/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.math.BigInteger;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BrowserSorter
extends ViewerSorter {
    private BrowserPreferences preferences;

    public BrowserSorter(BrowserPreferences preferences) {
        this.preferences = preferences;
    }

    public void connect(TreeViewer viewer) {
        viewer.setSorter((ViewerSorter)this);
    }

    public void sort(Viewer viewer, Object[] elements) {
        if (elements != null && (this.preferences.getSortLimit() <= 0 || elements.length < this.preferences.getSortLimit())) {
            BrowserSorter.super.sort(viewer, elements);
        }
    }

    public int category(Object element) {
        if (element instanceof IEntry) {
            IEntry entry = (IEntry)element;
            if ((entry instanceof DirectoryMetadataEntry || entry instanceof RootDSE || entry.isAlias() || entry.isReferral()) && this.preferences.isMetaEntriesLast()) {
                return 3;
            }
            if (entry.isSubentry()) {
                return 0;
            }
            if (!entry.hasChildren() && this.preferences.isLeafEntriesFirst()) {
                return 1;
            }
            if (entry.hasChildren() && this.preferences.isContainerEntriesFirst()) {
                return 1;
            }
            return 2;
        }
        return 4;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof StudioConnectionRunnableWithProgress) {
            StudioConnectionRunnableWithProgress runnable = (StudioConnectionRunnableWithProgress)o1;
            for (Object lockedObject : runnable.getLockedObjects()) {
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (o1 == search.getTopSearchRunnable()) {
                        return this.lessThanEntries();
                    }
                    if (o1 != search.getNextSearchRunnable()) continue;
                    return this.greaterThanEntries();
                }
                if (!(lockedObject instanceof IEntry)) continue;
                IEntry entry = (IEntry)lockedObject;
                if (o1 == entry.getTopPageChildrenRunnable()) {
                    return this.lessThanEntries();
                }
                if (o1 != entry.getNextPageChildrenRunnable()) continue;
                return this.greaterThanEntries();
            }
            return this.lessThanEntries();
        }
        if (o2 instanceof StudioConnectionRunnableWithProgress) {
            StudioConnectionRunnableWithProgress runnable = (StudioConnectionRunnableWithProgress)o2;
            for (Object lockedObject : runnable.getLockedObjects()) {
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (o2 == search.getTopSearchRunnable()) {
                        return this.greaterThanEntries();
                    }
                    if (o2 != search.getNextSearchRunnable()) continue;
                    return this.lessThanEntries();
                }
                if (!(lockedObject instanceof IEntry)) continue;
                IEntry entry = (IEntry)lockedObject;
                if (o2 == entry.getTopPageChildrenRunnable()) {
                    return this.greaterThanEntries();
                }
                if (o2 != entry.getNextPageChildrenRunnable()) continue;
                return this.lessThanEntries();
            }
            return this.greaterThanEntries();
        }
        if (o1 == null && o2 == null) {
            return this.equal();
        }
        if (o1 == null && o2 != null) {
            return this.lessThanEntries();
        }
        if (o1 != null && o2 == null) {
            return this.greaterThanEntries();
        }
        if (o1 instanceof IQuickSearch || o2 instanceof IQuickSearch) {
            if (!(o1 instanceof IQuickSearch) && o2 instanceof IQuickSearch) {
                return 1;
            }
            if (o1 instanceof IQuickSearch && !(o2 instanceof IQuickSearch)) {
                return -1;
            }
            return this.equal();
        }
        if (o1 instanceof IEntry || o2 instanceof IEntry) {
            int cat2;
            if (!(o1 instanceof IEntry) && !(o2 instanceof IEntry)) {
                return this.equal();
            }
            if (!(o1 instanceof IEntry) && o2 instanceof IEntry) {
                return this.lessThanEntries();
            }
            if (o1 instanceof IEntry && !(o2 instanceof IEntry)) {
                return this.greaterThanEntries();
            }
            IEntry entry1 = (IEntry)o1;
            IEntry entry2 = (IEntry)o2;
            int cat1 = this.category(entry1);
            if (cat1 != (cat2 = this.category(entry2))) {
                return cat1 - cat2;
            }
            if (this.preferences.getSortEntriesBy() == 0) {
                return this.equal();
            }
            if (this.preferences.getSortEntriesBy() == 1) {
                return this.compareRdns(entry1, entry2);
            }
            if (this.preferences.getSortEntriesBy() == 2) {
                return this.compareRdnValues(entry1, entry2);
            }
            return this.equal();
        }
        if (o1 instanceof ISearchResult || o2 instanceof ISearchResult) {
            int cat2;
            if (!(o1 instanceof ISearchResult) && !(o2 instanceof ISearchResult)) {
                return this.equal();
            }
            if (!(o1 instanceof ISearchResult) && o2 instanceof ISearchResult) {
                return this.lessThanEntries();
            }
            if (o1 instanceof ISearchResult && !(o2 instanceof ISearchResult)) {
                return this.greaterThanEntries();
            }
            ISearchResult sr1 = (ISearchResult)o1;
            ISearchResult sr2 = (ISearchResult)o2;
            int cat1 = this.category(sr1);
            if (cat1 != (cat2 = this.category(sr2))) {
                return cat1 - cat2;
            }
            if (this.preferences.getSortEntriesBy() == 0) {
                return this.equal();
            }
            if (this.preferences.getSortEntriesBy() == 1) {
                return this.compareRdns(sr1.getEntry(), sr2.getEntry());
            }
            if (this.preferences.getSortEntriesBy() == 2) {
                return this.compareRdnValues(sr1.getEntry(), sr2.getEntry());
            }
            return this.equal();
        }
        if (o1 instanceof ISearch || o2 instanceof ISearch) {
            if (!(o1 instanceof ISearch) && !(o2 instanceof ISearch)) {
                return this.equal();
            }
            if (!(o1 instanceof ISearch) && o2 instanceof ISearch) {
                return this.lessThanSearches();
            }
            if (o1 instanceof ISearch && !(o2 instanceof ISearch)) {
                return this.greaterThanSearches();
            }
            ISearch s1 = (ISearch)o1;
            ISearch s2 = (ISearch)o2;
            if (this.preferences.getSortSearchesOrder() == 0) {
                return this.equal();
            }
            return this.compareSearches(s1.getName(), s2.getName());
        }
        if (o1 instanceof IBookmark || o2 instanceof IBookmark) {
            if (!(o1 instanceof IBookmark) && !(o2 instanceof IBookmark)) {
                return this.equal();
            }
            if (!(o1 instanceof IBookmark) && o2 instanceof IBookmark) {
                return this.lessThanBookmarks();
            }
            if (o1 instanceof IBookmark && !(o2 instanceof IBookmark)) {
                return this.greaterThanBookmarks();
            }
            IBookmark b1 = (IBookmark)o1;
            IBookmark b2 = (IBookmark)o2;
            if (this.preferences.getSortBookmarksOrder() == 0) {
                return this.equal();
            }
            return this.compareBookmarks(b1.getName(), b2.getName());
        }
        return this.equal();
    }

    private int compareRdns(IEntry entry1, IEntry entry2) {
        Rdn rdn1 = entry1.getRdn();
        Rdn rdn2 = entry2.getRdn();
        if (rdn1 == null && rdn2 == null) {
            return this.equal();
        }
        if (rdn1 == null && rdn2 != null) {
            return this.greaterThanEntries();
        }
        if (rdn1 != null && rdn2 == null) {
            return this.lessThanEntries();
        }
        return this.compareEntries(rdn1.getName(), rdn2.getName());
    }

    private int compareRdnValues(IEntry entry1, IEntry entry2) {
        if (entry1 == null && entry2 == null) {
            return this.equal();
        }
        if (entry1 != null && entry2 == null) {
            return this.greaterThanEntries();
        }
        if (entry1 == null && entry2 != null) {
            return this.lessThanEntries();
        }
        Rdn rdn1 = entry1.getRdn();
        Rdn rdn2 = entry2.getRdn();
        if ((rdn1 == null || rdn1.getName() == null || "".equals(rdn1.getName())) && (rdn2 == null || rdn2.getName() == null || "".equals(rdn2.getName()))) {
            return this.equal();
        }
        if ((rdn1 == null || rdn1.getName() == null || "".equals(rdn1.getName())) && rdn2 != null && rdn2.getName() != null && !"".equals(rdn2.getName())) {
            return this.greaterThanEntries();
        }
        if (rdn1 != null && rdn1.getName() != null && !"".equals(rdn1.getName()) && (rdn2 == null || rdn2.getName() == null || "".equals(rdn2.getName()))) {
            return this.lessThanEntries();
        }
        String rdn1Value = rdn1.getName();
        String rdn2Value = rdn2.getName();
        if (rdn1Value.matches("\\d*") && !rdn2Value.matches("\\d*")) {
            return this.compareEntries(rdn1Value, rdn2Value);
        }
        if (!rdn1Value.matches("\\d*") && rdn2Value.matches("\\d*")) {
            return this.compareEntries(rdn1Value, rdn2Value);
        }
        if (rdn2Value.matches("\\d*") && rdn2Value.matches("\\d*")) {
            BigInteger bi1 = new BigInteger(rdn1Value);
            BigInteger bi2 = new BigInteger(rdn2Value);
            return this.compare(bi1, bi2);
        }
        return this.compareEntries(rdn1Value, rdn2Value);
    }

    private int lessThanEntries() {
        return this.preferences.getSortEntriesOrder() == 1 ? -1 : 1;
    }

    private int lessThanSearches() {
        return this.preferences.getSortSearchesOrder() == 1 ? -1 : 1;
    }

    private int lessThanBookmarks() {
        return this.preferences.getSortBookmarksOrder() == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThanEntries() {
        return this.preferences.getSortEntriesOrder() == 1 ? 1 : -1;
    }

    private int greaterThanSearches() {
        return this.preferences.getSortSearchesOrder() == 1 ? 1 : -1;
    }

    private int greaterThanBookmarks() {
        return this.preferences.getSortBookmarksOrder() == 1 ? 1 : -1;
    }

    private int compareEntries(String s1, String s2) {
        return this.preferences.getSortEntriesOrder() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    private int compareSearches(String s1, String s2) {
        return this.preferences.getSortSearchesOrder() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    private int compareBookmarks(String s1, String s2) {
        return this.preferences.getSortBookmarksOrder() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    private int compare(BigInteger bi1, BigInteger bi2) {
        return this.preferences.getSortEntriesOrder() == 1 ? bi1.compareTo(bi2) : bi2.compareTo(bi1);
    }
}

