/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class LdifRecordRule
implements IPredicateRule {
    private static char[] DN_SEQUENCE = new char[]{'d', 'n', ':'};
    private IToken recordToken;

    public LdifRecordRule(IToken recordToken) {
        this.recordToken = recordToken;
    }

    public IToken getSuccessToken() {
        return this.recordToken;
    }

    private int matchNewline(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == 13) {
            c = scanner.read();
            if (c == 10) {
                return 2;
            }
            scanner.unread();
            return 1;
        }
        if (c == 10) {
            c = scanner.read();
            if (c == 13) {
                return 2;
            }
            scanner.unread();
            return 1;
        }
        scanner.unread();
        return 0;
    }

    private int matchDnAndColon(ICharacterScanner scanner) {
        for (int i = 0; i < DN_SEQUENCE.length; ++i) {
            int c = scanner.read();
            if (c == DN_SEQUENCE[i]) continue;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
            return 0;
        }
        return DN_SEQUENCE.length;
    }

    private boolean matchEOF(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return true;
        }
        scanner.unread();
        return false;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (scanner.getColumn() != 0) {
            return Token.UNDEFINED;
        }
        block0: while (true) {
            int c;
            if ((c = scanner.read()) == 13 || c == 10) {
                scanner.unread();
                if (this.matchNewline(scanner) > 0) {
                    int nlCount = this.matchNewline(scanner);
                    if (nlCount > 0) {
                        int dnCount = this.matchDnAndColon(scanner);
                        if (dnCount > 0) {
                            while (dnCount > 0) {
                                scanner.unread();
                                --dnCount;
                            }
                            return this.recordToken;
                        }
                        if (this.matchEOF(scanner)) {
                            return this.recordToken;
                        }
                        while (true) {
                            if (nlCount <= 0) continue block0;
                            scanner.unread();
                            --nlCount;
                        }
                    }
                    if (!this.matchEOF(scanner)) continue;
                    return this.recordToken;
                }
                if (!this.matchEOF(scanner)) continue;
                return this.recordToken;
            }
            if (c == -1) break;
        }
        return this.recordToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

