#include "InfoDialogTransfersWidget.h"
#include "ui_InfoDialogTransfersWidget.h"
#include "MegaApplication.h"

using namespace mega;

InfoDialogTransfersWidget::InfoDialogTransfersWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::InfoDialogTransfersWidget)
{
    ui->setupUi(this);
    this->model = NULL;
    tDelegate = NULL;
    app = (MegaApplication *)qApp;
}

void InfoDialogTransfersWidget::setupTransfers(QCustomTransfersModel * mod)
{
    if (mod)
    {
        this->model = mod;
    }
    else
    {
        model = new QCustomTransfersModel(QTransfersModel::TYPE_CUSTOM_TRANSFERS);
    }

    // Subscribe to MegaApplication for changes on finished transfers generated by other finished model to keep consistency
    connect(app, SIGNAL(clearAllFinishedTransfers()),model, SLOT(removeAllTransfers()));
    connect(app, SIGNAL(clearFinishedTransfer(int)), model, SLOT(removeTransferByTag(int)));

    configureTransferView();
}

QCustomTransfersModel *InfoDialogTransfersWidget::getModel()
{
    return model;
}

InfoDialogTransfersWidget::~InfoDialogTransfersWidget()
{
    delete ui;
    delete model;
    delete tDelegate;
}

void InfoDialogTransfersWidget::configureTransferView()
{
    if (!model)
    {
        return;
    }

    tDelegate = new MegaTransferDelegate(model, this);
    ui->tView->setup(QTransfersModel::TYPE_CUSTOM_TRANSFERS);
    ui->tView->setItemDelegate((QAbstractItemDelegate *)tDelegate);
    ui->tView->header()->close();
    ui->tView->setSelectionMode(QAbstractItemView::NoSelection);
    ui->tView->setDragEnabled(false);
    ui->tView->viewport()->setAcceptDrops(false);
    ui->tView->setDropIndicatorShown(false);
    ui->tView->setDragDropMode(QAbstractItemView::InternalMove);
    ui->tView->setModel(model);
    ui->tView->setFocusPolicy(Qt::NoFocus);
    ui->tView->disableContextMenus(true);
}
