/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.utils;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import com.abdownloadmanager.shared.utils.FileIconProvider;
import com.abdownloadmanager.shared.utils.ui.IMyIcons;
import ir.amirab.util.compose.IconSource;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0017\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/abdownloadmanager/desktop/utils/OSFileIconProvider;", "Lcom/abdownloadmanager/shared/utils/FileIconProvider;", "icons", "Lcom/abdownloadmanager/shared/utils/ui/IMyIcons;", "<init>", "(Lcom/abdownloadmanager/shared/utils/ui/IMyIcons;)V", "registeredIcons", "", "", "Landroidx/compose/ui/graphics/ImageBitmap;", "lock", "", "getIconOfFileExtension", "extension", "iconToImage", "Ljava/awt/image/BufferedImage;", "icon", "Ljavax/swing/Icon;", "bufferedImageToImageBitmap", "bufferedImage", "getIcon", "Lir/amirab/util/compose/IconSource;", "fileName", "rememberIcon", "(Ljava/lang/String;Landroidx/compose/runtime/Composer;I)Lir/amirab/util/compose/IconSource;", "app"})
@StabilityInferred(parameters=0)
public final class OSFileIconProvider
implements FileIconProvider {
    @NotNull
    private final IMyIcons icons;
    @NotNull
    private final Map<String, ImageBitmap> registeredIcons;
    @NotNull
    private final Object lock;
    public static final int $stable = 8;

    public OSFileIconProvider(@NotNull IMyIcons icons) {
        Intrinsics.checkNotNullParameter((Object)icons, (String)"icons");
        this.icons = icons;
        this.registeredIcons = new LinkedHashMap();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImageBitmap getIconOfFileExtension(String extension) {
        ImageBitmap imageBitmap = this.registeredIcons.get(extension);
        if (imageBitmap != null) {
            return imageBitmap;
        }
        Object object = this.lock;
        synchronized (object) {
            Object $this$getIconOfFileExtension_u24lambda_u240_u240;
            block8: {
                boolean bl = false;
                ImageBitmap bitmapFoundInSync = this.registeredIcons.get(extension);
                if (bitmapFoundInSync == null) break block8;
                ImageBitmap imageBitmap2 = bitmapFoundInSync;
                return imageBitmap2;
            }
            int w = 24;
            int h = 24;
            Object object2 = this;
            try {
                $this$getIconOfFileExtension_u24lambda_u240_u240 = object2;
                boolean bl = false;
                FileSystemView fileSystemView = FileSystemView.getFileSystemView();
                File file = File.createTempFile("file", "file." + extension);
                Icon icon = fileSystemView.getSystemIcon(file, w, h);
                Intrinsics.checkNotNull((Object)icon);
                $this$getIconOfFileExtension_u24lambda_u240_u240 = Result.constructor-impl((Object)super.bufferedImageToImageBitmap(super.iconToImage(icon)));
            }
            catch (Throwable bl) {
                $this$getIconOfFileExtension_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$getIconOfFileExtension_u24lambda_u240_u240;
            if (Result.isSuccess-impl((Object)object2)) {
                ImageBitmap it = (ImageBitmap)object2;
                boolean bl = false;
                this.registeredIcons.put(extension, it);
            }
            ImageBitmap imageBitmap3 = (ImageBitmap)(Result.isFailure-impl((Object)object2) ? null : object2);
            return imageBitmap3;
        }
    }

    private final BufferedImage iconToImage(Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return image;
    }

    private final ImageBitmap bufferedImageToImageBitmap(BufferedImage bufferedImage) {
        return DesktopImageConverters_desktopKt.toComposeImageBitmap((BufferedImage)bufferedImage);
    }

    @NotNull
    public IconSource getIcon(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String extension = StringsKt.substringAfterLast((String)fileName, (char)'.', (String)"");
        ImageBitmap imageBitmap = this.getIconOfFileExtension(extension);
        if (imageBitmap == null) {
            return this.icons.getFile();
        }
        ImageBitmap imageBitmap2 = imageBitmap;
        return (IconSource)new IconSource.PainterIconSource((Painter)new BitmapPainter(imageBitmap2, 0L, 0L, 6, null), false);
    }

    @Composable
    @NotNull
    public IconSource rememberIcon(@NotNull String fileName, @Nullable Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        $composer.startReplaceGroup(-377741987);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(rememberIcon)N(fileName):OSFileIconProvider.kt#8vuru0");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-377741987, (int)$changed, (int)-1, (String)"com.abdownloadmanager.desktop.utils.OSFileIconProvider.rememberIcon (OSFileIconProvider.kt:69)");
        }
        IconSource iconSource = this.getIcon(fileName);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return iconSource;
    }
}

