/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.client.ExtKt;
import org.http4k.core.Body;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005j\u0002`\u000bH\u0087\u0002\u00a2\u0006\u0002\b\fJA\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005j\u0002`\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0087\u0002\u00a2\u0006\u0002\b\u0010J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/http4k/client/Java8HttpClient;", "", "<init>", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "create", "readTimeout", "Ljava/time/Duration;", "connectionTimeout", "createWithTimeouts", "body", "Lorg/http4k/core/Body;", "Ljava/net/HttpURLConnection;", "status", "Lorg/http4k/core/Status;", "resolveStream", "Ljava/io/InputStream;", "EMPTY_STREAM", "Ljava/io/ByteArrayInputStream;", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nJava8HttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Java8HttpClient.kt\norg/http4k/client/Java8HttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,91:1\n1#2:92\n1869#3,2:93\n1563#3:105\n1634#3,3:106\n1803#3,3:110\n488#4,7:95\n126#5:102\n153#5,2:103\n155#5:109\n*S KotlinDebug\n*F\n+ 1 Java8HttpClient.kt\norg/http4k/client/Java8HttpClient\n*L\n47#1:93,2\n63#1:105\n63#1:106,3\n65#1:110,3\n62#1:95,7\n63#1:102\n63#1:103,2\n63#1:109\n*E\n"})
public final class Java8HttpClient {
    @NotNull
    public static final Java8HttpClient INSTANCE = new Java8HttpClient();
    @NotNull
    private static final ByteArrayInputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);

    private Java8HttpClient() {
    }

    @JvmStatic
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        return Java8HttpClient.createWithTimeouts$default(duration2, null, 2, null);
    }

    @JvmStatic
    @JvmName(name="createWithTimeouts")
    @NotNull
    public static final Function1<Request, Response> createWithTimeouts(@NotNull Duration readTimeout, @NotNull Duration connectionTimeout) {
        Intrinsics.checkNotNullParameter((Object)readTimeout, (String)"readTimeout");
        Intrinsics.checkNotNullParameter((Object)connectionTimeout, (String)"connectionTimeout");
        return arg_0 -> Java8HttpClient.invoke$lambda$0(readTimeout, connectionTimeout, arg_0);
    }

    public static /* synthetic */ Function1 createWithTimeouts$default(Duration duration2, Duration duration3, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration4 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ZERO");
            duration2 = duration4;
        }
        if ((n & 2) != 0) {
            Duration duration5 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ZERO");
            duration3 = duration5;
        }
        return Java8HttpClient.createWithTimeouts(duration2, duration3);
    }

    /*
     * WARNING - void declaration
     */
    private final Body body(HttpURLConnection $this$body, Status status2) {
        void it;
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)this.resolveStream($this$body, status2));
        Body.Companion companion = Body.Companion;
        boolean bl = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])it);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"let(...)");
        return companion.create(byteBuffer);
    }

    private final InputStream resolveStream(HttpURLConnection $this$resolveStream, Status status2) {
        InputStream inputStream = status2.getServerError() || status2.getClientError() ? $this$resolveStream.getErrorStream() : $this$resolveStream.getInputStream();
        if (inputStream == null) {
            inputStream = EMPTY_STREAM;
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    private static final Response invoke$lambda$0(Duration $readTimeout, Duration $connectionTimeout, Request request) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Map $this$filterKeys$iv;
            Object it;
            Object element$iv;
            HttpURLConnection httpURLConnection;
            URLConnection uRLConnection = new URI(request.getUri().toString()).toURL().openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$invoke_u24lambda_u240_u240 = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean $i$a$-apply-Java8HttpClient$invoke$1$connection$22 = false;
            $this$invoke_u24lambda_u240_u240.setReadTimeout((int)$readTimeout.toMillis());
            $this$invoke_u24lambda_u240_u240.setConnectTimeout((int)$connectionTimeout.toMillis());
            $this$invoke_u24lambda_u240_u240.setInstanceFollowRedirects(false);
            $this$invoke_u24lambda_u240_u240.setRequestMethod(request.getMethod().name());
            $this$invoke_u24lambda_u240_u240.setDoOutput(true);
            $this$invoke_u24lambda_u240_u240.setDoInput(true);
            Object $this$forEach$iv = request.getHeaders();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (Pair)element$iv;
                boolean bl = false;
                $this$invoke_u24lambda_u240_u240.addRequestProperty((String)it.getFirst(), (String)it.getSecond());
            }
            Object object = request.header("content-length");
            if (object != null && (object = StringsKt.toLongOrNull((String)object)) != null) {
                long it2 = ((Number)object).longValue();
                boolean bl = false;
                $this$invoke_u24lambda_u240_u240.setFixedLengthStreamingMode(it2);
            }
            Object $this$invoke_u24lambda_u240_u240_u242 = $this$forEach$iv = request.getBody();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)$this$invoke_u24lambda_u240_u240_u242, (Object)Body.EMPTY)) {
                InputStream inputStream;
                if ($this$invoke_u24lambda_u240_u240_u242.getStream().available() == 0) {
                    byte[] byArray = $this$invoke_u24lambda_u240_u240_u242.getPayload().array();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                    element$iv = byArray;
                    inputStream = new ByteArrayInputStream((byte[])element$iv);
                } else {
                    inputStream = $this$invoke_u24lambda_u240_u240_u242.getStream();
                }
                InputStream content = inputStream;
                OutputStream outputStream = $this$invoke_u24lambda_u240_u240.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                ByteStreamsKt.copyTo$default((InputStream)content, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            HttpURLConnection connection = httpURLConnection;
            int n = connection.getResponseCode();
            String string = connection.getResponseMessage();
            if (string == null) {
                string = "";
            }
            Status status2 = new Status(n, string, false, 4, null);
            Response baseResponse = Response.Companion.create$default(Response.Companion, status2, null, 2, null).body(INSTANCE.body(connection, status2));
            Map<String, List<String>> map2 = connection.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getHeaderFields(...)");
            Map<String, List<String>> $i$a$-apply-Java8HttpClient$invoke$1$connection$22 = map2;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            it = $this$mapTo$iv$iv.entrySet().iterator();
            while (it.hasNext()) {
                void $this$mapTo$iv$iv2;
                void header;
                Map.Entry item$iv$iv;
                Map.Entry it2 = item$iv$iv = (Map.Entry)it.next();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Object v = header.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                Iterable $this$map$iv2 = (Iterable)v;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it3;
                    String string2 = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(TuplesKt.to(header.getKey(), (Object)it3));
                }
                collection.add((List)destination$iv$iv2);
            }
            $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Response initial$iv = baseResponse;
            boolean $i$f$fold = false;
            Response accumulator$iv = initial$iv;
            for (Object element$iv2 : $this$fold$iv) {
                void next;
                Pair item$iv$iv = (Pair)element$iv2;
                Response acc = accumulator$iv;
                boolean bl5 = false;
                Object object2 = next.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-first>(...)");
                accumulator$iv = acc.header((String)object2, (String)next.getSecond());
            }
            response = accumulator$iv;
        }
        catch (UnknownHostException e) {
            response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.UNKNOWN_HOST, e), null, 2, null);
        }
        catch (ConnectException e) {
            response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.CONNECTION_REFUSED, e), null, 2, null);
        }
        catch (SocketTimeoutException e) {
            response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.CLIENT_TIMEOUT, e), null, 2, null);
        }
        catch (SocketException e) {
            response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.SERVICE_UNAVAILABLE, e), null, 2, null);
        }
        catch (IOException e) {
            response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.SERVICE_UNAVAILABLE, e), null, 2, null);
        }
        return response;
    }
}

