/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.client.ExtKt;
import org.http4k.client.JavaHttpClientKt;
import org.http4k.client.PreCannedJavaHttpClients;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Ja\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005j\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0005H\u0087\u0002\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/http4k/client/JavaHttpClient;", "", "<init>", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "httpClient", "Ljava/net/http/HttpClient;", "requestBodyMode", "Lorg/http4k/core/BodyMode;", "responseBodyMode", "requestModifier", "Ljava/net/http/HttpRequest$Builder;", "create", "http4k-core"})
public final class JavaHttpClient {
    @NotNull
    public static final JavaHttpClient INSTANCE = new JavaHttpClient();

    private JavaHttpClient() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull HttpClient httpClient, @NotNull BodyMode requestBodyMode, @NotNull BodyMode responseBodyMode, @NotNull Function1<? super HttpRequest.Builder, ? extends HttpRequest.Builder> requestModifier) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        Intrinsics.checkNotNullParameter((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkNotNullParameter(requestModifier, (String)"requestModifier");
        return (Function1)new Function1<Request, Response>(requestBodyMode, requestModifier, responseBodyMode, httpClient){
            final /* synthetic */ BodyMode $requestBodyMode;
            final /* synthetic */ Function1<HttpRequest.Builder, HttpRequest.Builder> $requestModifier;
            final /* synthetic */ BodyMode $responseBodyMode;
            final /* synthetic */ HttpClient $httpClient;
            {
                this.$requestBodyMode = $requestBodyMode;
                this.$requestModifier = $requestModifier;
                this.$responseBodyMode = $responseBodyMode;
                this.$httpClient = $httpClient;
            }

            public Response invoke(Request request) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    Response response2;
                    HttpRequest javaRequest = JavaHttpClientKt.fromHttp4k(request, this.$requestBodyMode, this.$requestModifier);
                    BodyMode bodyMode = this.$responseBodyMode;
                    if (bodyMode instanceof BodyMode.Memory) {
                        HttpResponse<byte[]> $this$invoke_u24lambda_u240 = this.$httpClient.send(javaRequest, HttpResponse.BodyHandlers.ofByteArray());
                        boolean bl = false;
                        Intrinsics.checkNotNull($this$invoke_u24lambda_u240);
                        Response response3 = JavaHttpClientKt.asHttp4k($this$invoke_u24lambda_u240);
                        ByteBuffer byteBuffer = ByteBuffer.wrap($this$invoke_u24lambda_u240.body());
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                        response2 = response3.body(Body.Companion.create(byteBuffer));
                    } else if (bodyMode instanceof BodyMode.Stream) {
                        HttpResponse<InputStream> $this$invoke_u24lambda_u241 = this.$httpClient.send(javaRequest, HttpResponse.BodyHandlers.ofInputStream());
                        boolean bl = false;
                        Intrinsics.checkNotNull($this$invoke_u24lambda_u241);
                        HttpMessage httpMessage = JavaHttpClientKt.asHttp4k($this$invoke_u24lambda_u241);
                        InputStream inputStream = $this$invoke_u24lambda_u241.body();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"body(...)");
                        response2 = (Response)HttpMessage.body$default(httpMessage, inputStream, null, 2, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    response = response2;
                }
                catch (UnknownHostException e) {
                    response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.UNKNOWN_HOST, e), null, 2, null);
                }
                catch (ConnectException e) {
                    response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.CONNECTION_REFUSED, e), null, 2, null);
                }
                catch (HttpTimeoutException e) {
                    response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.CLIENT_TIMEOUT, e), null, 2, null);
                }
                catch (IOException e) {
                    response = Response.Companion.create$default(Response.Companion, ExtKt.toClientStatus(Status.SERVICE_UNAVAILABLE, e), null, 2, null);
                }
                return response;
            }
        };
    }

    public static /* synthetic */ Function1 create$default(HttpClient httpClient, BodyMode bodyMode, BodyMode bodyMode2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            httpClient = PreCannedJavaHttpClients.INSTANCE.defaultJavaHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = BodyMode.Memory.INSTANCE;
        }
        if ((n & 8) != 0) {
            function1 = JavaHttpClient::invoke$lambda$0;
        }
        return JavaHttpClient.create(httpClient, bodyMode, bodyMode2, (Function1<? super HttpRequest.Builder, ? extends HttpRequest.Builder>)function1);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull HttpClient httpClient, @NotNull BodyMode requestBodyMode, @NotNull BodyMode responseBodyMode) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        Intrinsics.checkNotNullParameter((Object)responseBodyMode, (String)"responseBodyMode");
        return JavaHttpClient.create$default(httpClient, requestBodyMode, responseBodyMode, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull HttpClient httpClient, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        return JavaHttpClient.create$default(httpClient, requestBodyMode, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        return JavaHttpClient.create$default(httpClient, null, null, null, 14, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        return JavaHttpClient.create$default(null, null, null, null, 15, null);
    }

    private static final HttpRequest.Builder invoke$lambda$0(HttpRequest.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

