/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ProtocolTransaction;
import org.http4k.core.ProtocolTransactionKt;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010 \u001a\u00020\fH\u00c6\u0003JG\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\nH\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lorg/http4k/core/HttpTransaction;", "Lorg/http4k/core/ProtocolTransaction;", "Lorg/http4k/core/Response;", "request", "Lorg/http4k/core/Request;", "response", "duration", "Ljava/time/Duration;", "labels", "", "", "start", "Ljava/time/Instant;", "<init>", "(Lorg/http4k/core/Request;Lorg/http4k/core/Response;Ljava/time/Duration;Ljava/util/Map;Ljava/time/Instant;)V", "getRequest", "()Lorg/http4k/core/Request;", "getResponse", "()Lorg/http4k/core/Response;", "getDuration", "()Ljava/time/Duration;", "getLabels", "()Ljava/util/Map;", "getStart", "()Ljava/time/Instant;", "label", "name", "value", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "http4k-core"})
public final class HttpTransaction
implements ProtocolTransaction<Response> {
    @NotNull
    private final Request request;
    @NotNull
    private final Response response;
    @NotNull
    private final Duration duration;
    @NotNull
    private final Map<String, String> labels;
    @NotNull
    private final Instant start;

    public HttpTransaction(@NotNull Request request, @NotNull Response response, @NotNull Duration duration2, @NotNull Map<String, String> labels, @NotNull Instant start) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        this.request = request;
        this.response = response;
        this.duration = duration2;
        this.labels = labels;
        this.start = start;
    }

    public /* synthetic */ HttpTransaction(Request request, Response response, Duration duration2, Map map2, Instant instant2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = ProtocolTransactionKt.defaultLabels(request, response);
        }
        this(request, response, duration2, map2, instant2);
    }

    @Override
    @NotNull
    public Request getRequest() {
        return this.request;
    }

    @Override
    @NotNull
    public Response getResponse() {
        return this.response;
    }

    @Override
    @NotNull
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    @NotNull
    public Instant getStart() {
        return this.start;
    }

    @NotNull
    public final HttpTransaction label(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return HttpTransaction.copy$default(this, null, null, null, MapsKt.plus(this.getLabels(), (Pair)TuplesKt.to((Object)name, (Object)value2)), null, 23, null);
    }

    @NotNull
    public final Request component1() {
        return this.request;
    }

    @NotNull
    public final Response component2() {
        return this.response;
    }

    @NotNull
    public final Duration component3() {
        return this.duration;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.labels;
    }

    @NotNull
    public final Instant component5() {
        return this.start;
    }

    @NotNull
    public final HttpTransaction copy(@NotNull Request request, @NotNull Response response, @NotNull Duration duration2, @NotNull Map<String, String> labels, @NotNull Instant start) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)duration2, (String)"duration");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        return new HttpTransaction(request, response, duration2, labels, start);
    }

    public static /* synthetic */ HttpTransaction copy$default(HttpTransaction httpTransaction, Request request, Response response, Duration duration2, Map map2, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            request = httpTransaction.request;
        }
        if ((n & 2) != 0) {
            response = httpTransaction.response;
        }
        if ((n & 4) != 0) {
            duration2 = httpTransaction.duration;
        }
        if ((n & 8) != 0) {
            map2 = httpTransaction.labels;
        }
        if ((n & 0x10) != 0) {
            instant2 = httpTransaction.start;
        }
        return httpTransaction.copy(request, response, duration2, map2, instant2);
    }

    @NotNull
    public String toString() {
        return "HttpTransaction(request=" + this.request + ", response=" + this.response + ", duration=" + this.duration + ", labels=" + this.labels + ", start=" + this.start + ")";
    }

    public int hashCode() {
        int result = this.request.hashCode();
        result = result * 31 + this.response.hashCode();
        result = result * 31 + this.duration.hashCode();
        result = result * 31 + ((Object)this.labels).hashCode();
        result = result * 31 + this.start.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpTransaction)) {
            return false;
        }
        HttpTransaction httpTransaction = (HttpTransaction)other;
        if (!Intrinsics.areEqual((Object)this.request, (Object)httpTransaction.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)httpTransaction.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.duration, (Object)httpTransaction.duration)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.labels, httpTransaction.labels)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.start, (Object)httpTransaction.start);
    }
}

