/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.events;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.core.HttpTransaction;
import org.http4k.core.Method;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.events.ProtocolEvent;
import org.http4k.routing.RoutedMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0014"}, d2={"Lorg/http4k/events/HttpEvent;", "", "<init>", "()V", "Incoming", "Lorg/http4k/events/ProtocolEvent$Incoming;", "uri", "Lorg/http4k/core/Uri;", "method", "Lorg/http4k/core/Method;", "status", "Lorg/http4k/core/Status;", "latency", "", "xUriTemplate", "", "tx", "Lorg/http4k/core/HttpTransaction;", "Outgoing", "Lorg/http4k/events/ProtocolEvent$Outgoing;", "http4k-core"})
public final class HttpEvent {
    @NotNull
    public static final HttpEvent INSTANCE = new HttpEvent();

    private HttpEvent() {
    }

    @NotNull
    public final ProtocolEvent.Incoming Incoming(@NotNull Uri uri2, @NotNull Method method, @NotNull Status status2, long latency, @NotNull String xUriTemplate) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)xUriTemplate, (String)"xUriTemplate");
        return new ProtocolEvent.Incoming(uri2, method, status2, latency, xUriTemplate, "http");
    }

    @NotNull
    public final ProtocolEvent.Incoming Incoming(@NotNull HttpTransaction tx) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Uri uri2 = tx.getRequest().getUri();
        Method method = tx.getRequest().getMethod();
        Status status2 = tx.getResponse().getStatus();
        long l = tx.getDuration().toMillis();
        if (tx.getRequest() instanceof RoutedMessage && ((RoutedMessage)((Object)tx.getRequest())).getXUriTemplate() != null) {
            string = String.valueOf(((RoutedMessage)((Object)tx.getRequest())).getXUriTemplate());
        } else {
            char[] cArray = new char[]{'/'};
            string = StringsKt.trimStart((String)tx.getRequest().getUri().getPath(), (char[])cArray);
        }
        return this.Incoming(uri2, method, status2, l, string);
    }

    @NotNull
    public final ProtocolEvent.Outgoing Outgoing(@NotNull Uri uri2, @NotNull Method method, @NotNull Status status2, long latency, @NotNull String xUriTemplate) {
        Intrinsics.checkNotNullParameter((Object)uri2, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)xUriTemplate, (String)"xUriTemplate");
        return new ProtocolEvent.Outgoing(uri2, method, status2, latency, xUriTemplate, "http");
    }

    @NotNull
    public final ProtocolEvent.Outgoing Outgoing(@NotNull HttpTransaction tx) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Uri uri2 = tx.getRequest().getUri();
        Method method = tx.getRequest().getMethod();
        Status status2 = tx.getResponse().getStatus();
        long l = tx.getDuration().toMillis();
        if (tx.getResponse() instanceof RoutedMessage && ((RoutedMessage)((Object)tx.getResponse())).getXUriTemplate() != null) {
            string = String.valueOf(((RoutedMessage)((Object)tx.getResponse())).getXUriTemplate());
        } else {
            char[] cArray = new char[]{'/'};
            string = StringsKt.trimStart((String)tx.getRequest().getUri().getPath(), (char[])cArray);
        }
        return this.Outgoing(uri2, method, status2, l, string);
    }
}

