/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0004H\u0016J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/http4k/filter/GZippingInputStream;", "Ljava/io/InputStream;", "source", "compressionLevel", "", "<init>", "(Ljava/io/InputStream;I)V", "deflater", "Ljava/util/zip/Deflater;", "crc", "Ljava/util/zip/CRC32;", "trailer", "Ljava/io/ByteArrayInputStream;", "header", "deflationBuffer", "", "stage", "Lorg/http4k/filter/GZippingInputStream$State;", "read", "readBuffer", "readOffset", "readLength", "deflatePendingInput", "createTrailer", "crcValue", "totalIn", "available", "close", "", "Companion", "State", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nGzip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gzip.kt\norg/http4k/filter/GZippingInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
public final class GZippingInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InputStream source;
    private final int compressionLevel;
    @NotNull
    private final Deflater deflater;
    @NotNull
    private final CRC32 crc;
    @Nullable
    private ByteArrayInputStream trailer;
    @NotNull
    private final ByteArrayInputStream header;
    @NotNull
    private byte[] deflationBuffer;
    @NotNull
    private State stage;
    private static final int GZIP_MAGIC = 35615;
    @NotNull
    private static final byte[] HEADER_DATA;
    private static final int INITIAL_BUFFER_SIZE = 8192;

    /*
     * WARNING - void declaration
     */
    public GZippingInputStream(@NotNull InputStream source, int compressionLevel) {
        void $this$deflater_u24lambda_u240;
        Deflater deflater;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.compressionLevel = compressionLevel;
        Deflater deflater2 = deflater = new Deflater(8, true);
        GZippingInputStream gZippingInputStream = this;
        boolean bl = false;
        $this$deflater_u24lambda_u240.setLevel(this.compressionLevel);
        gZippingInputStream.deflater = deflater;
        this.crc = new CRC32();
        this.header = new ByteArrayInputStream(HEADER_DATA);
        this.deflationBuffer = new byte[8192];
        this.stage = State.HEADER;
        this.crc.reset();
    }

    @Override
    public int read() {
        byte[] readBytes = new byte[1];
        int bytesRead = 0;
        while (bytesRead == 0) {
            bytesRead = this.read(readBytes, 0, 1);
        }
        return bytesRead != -1 ? readBytes[0] & 0xFF : -1;
    }

    @Override
    public int read(@NotNull byte[] readBuffer, int readOffset, int readLength) throws IOException {
        Intrinsics.checkNotNullParameter((Object)readBuffer, (String)"readBuffer");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.stage.ordinal()]) {
            case 1 -> {
                int bytesRead = this.header.read(readBuffer, readOffset, readLength);
                if (this.header.available() == 0) {
                    this.stage = State.DATA;
                }
                yield bytesRead;
            }
            case 2 -> {
                int bytesRead;
                if (!this.deflater.needsInput()) {
                    yield this.deflatePendingInput(readBuffer, readOffset, readLength);
                }
                if (this.deflationBuffer.length < readLength) {
                    this.deflationBuffer = new byte[readLength];
                }
                if ((bytesRead = this.source.read(this.deflationBuffer, 0, readLength)) <= 0) {
                    this.stage = State.FINALISE;
                    this.deflater.finish();
                    yield 0;
                }
                this.crc.update(this.deflationBuffer, 0, bytesRead);
                this.deflater.setInput(this.deflationBuffer, 0, bytesRead);
                yield this.deflatePendingInput(readBuffer, readOffset, readLength);
            }
            case 3 -> {
                if (this.deflater.finished()) {
                    this.stage = State.TRAILER;
                    int crcValue = (int)this.crc.getValue();
                    int totalIn = this.deflater.getTotalIn();
                    this.trailer = this.createTrailer(crcValue, totalIn);
                    yield 0;
                }
                yield this.deflater.deflate(readBuffer, readOffset, readLength, 3);
            }
            case 4 -> {
                ByteArrayInputStream v1 = this.trailer;
                if (v1 == null) {
                    throw new IllegalStateException("Trailer stream is null in trailer stage".toString());
                }
                ByteArrayInputStream trailerStream = v1;
                int bytesRead = trailerStream.read(readBuffer, readOffset, readLength);
                if (trailerStream.available() == 0) {
                    this.stage = State.DONE;
                }
                yield bytesRead;
            }
            case 5 -> -1;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final int deflatePendingInput(byte[] readBuffer, int readOffset, int readLength) {
        int bytesCompressed = 0;
        while (!this.deflater.needsInput() && readLength - bytesCompressed > 0) {
            bytesCompressed += this.deflater.deflate(readBuffer, readOffset + bytesCompressed, readLength - bytesCompressed, 3);
        }
        return bytesCompressed;
    }

    private final ByteArrayInputStream createTrailer(int crcValue, int totalIn) {
        byte[] byArray = new byte[]{(byte)(crcValue >> 0), (byte)(crcValue >> 8), (byte)(crcValue >> 16), (byte)(crcValue >> 24), (byte)(totalIn >> 0), (byte)(totalIn >> 8), (byte)(totalIn >> 16), (byte)(totalIn >> 24)};
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public int available() {
        if (this.stage == State.DONE) {
            return 0;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.deflater.end();
        ByteArrayInputStream byteArrayInputStream = this.trailer;
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        this.header.close();
    }

    static {
        byte[] byArray = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        HEADER_DATA = byArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/http4k/filter/GZippingInputStream$Companion;", "", "<init>", "()V", "GZIP_MAGIC", "", "HEADER_DATA", "", "INITIAL_BUFFER_SIZE", "http4k-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/http4k/filter/GZippingInputStream$State;", "", "<init>", "(Ljava/lang/String;I)V", "HEADER", "DATA", "FINALISE", "TRAILER", "DONE", "http4k-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER = new State();
        public static final /* enum */ State DATA = new State();
        public static final /* enum */ State FINALISE = new State();
        public static final /* enum */ State TRAILER = new State();
        public static final /* enum */ State DONE = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.HEADER, State.DATA, State.FINALISE, State.TRAILER, State.DONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.HEADER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.FINALISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.TRAILER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DONE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

