/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.osfileutil;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import ir.amirab.util.ExecKt;
import ir.amirab.util.osfileutil.FileUtilsBase;
import ir.amirab.util.osfileutil.Shell32Ex;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lir/amirab/util/osfileutil/WindowsFileUtils;", "Lir/amirab/util/osfileutil/FileUtilsBase;", "<init>", "()V", "openFileInternal", "", "file", "Ljava/io/File;", "openFolderOfFileInternal", "openFolderInternal", "folder", "isRemovableStorage", "path", "", "isRemovableStorageViaNative", "showFileInFolderViaNative", "openFolderViaNative", "quoted", "utils"})
@SourceDebugExtension(value={"SMAP\nWindowsFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsFileUtils.kt\nir/amirab/util/osfileutil/WindowsFileUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n13805#2,2:113\n*S KotlinDebug\n*F\n+ 1 WindowsFileUtils.kt\nir/amirab/util/osfileutil/WindowsFileUtils\n*L\n69#1:113,2\n*E\n"})
public final class WindowsFileUtils
extends FileUtilsBase {
    @Override
    protected boolean openFileInternal(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String[] stringArray = new String[6];
        stringArray[0] = "cmd";
        stringArray[1] = "/c";
        stringArray[2] = "start";
        stringArray[3] = "/B";
        stringArray[4] = "";
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        stringArray[5] = this.quoted(string);
        return ExecKt.execAndWait$default(stringArray, 0L, 2, null);
    }

    @Override
    protected boolean openFolderOfFileInternal(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        boolean nativeSuccess = this.showFileInFolderViaNative(string);
        if (nativeSuccess) {
            return true;
        }
        String[] stringArray = new String[5];
        stringArray[0] = "cmd";
        stringArray[1] = "/c";
        stringArray[2] = "explorer.exe";
        stringArray[3] = "/select,";
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        stringArray[4] = this.quoted(string2);
        return ExecKt.execAndWait$default(stringArray, 0L, 2, null);
    }

    @Override
    protected boolean openFolderInternal(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        String string = folder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        boolean nativeSuccess = this.openFolderViaNative(string);
        if (nativeSuccess) {
            return true;
        }
        String[] stringArray = new String[4];
        stringArray[0] = "cmd";
        stringArray[1] = "/c";
        stringArray[2] = "explorer.exe";
        String string2 = folder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        stringArray[3] = this.quoted(string2);
        return ExecKt.execAndWait$default(stringArray, 0L, 2, null);
    }

    @Override
    public boolean isRemovableStorage(@NotNull String path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            bl = this.isRemovableStorageViaNative(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = super.isRemovableStorage(path);
        }
        return bl;
    }

    private final boolean isRemovableStorageViaNative(String path) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        String rootPath = ((Object)path3.getRoot()).toString();
        int driveType = Kernel32.INSTANCE.GetDriveType(rootPath);
        return driveType == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean showFileInFolderViaNative(String file) {
        try {
            Pointer[] $this$forEach$iv;
            boolean bl;
            Ole32.INSTANCE.CoInitializeEx(null, 2);
            Pointer path = Shell32Ex.Companion.getINSTANCE().ILCreateFromPath(new File(file).getParent());
            Pointer[] pointerArray = new Pointer[]{Shell32Ex.Companion.getINSTANCE().ILCreateFromPath(file)};
            Pointer[] selectedFiles = pointerArray;
            WinDef.UINT cidl = new WinDef.UINT((long)selectedFiles.length);
            try {
                WinNT.HRESULT res = Shell32Ex.Companion.getINSTANCE().SHOpenFolderAndSelectItems(path, cidl, selectedFiles, new WinDef.DWORD(0L));
                bl = Intrinsics.areEqual((Object)WinError.S_OK, (Object)res);
                Shell32Ex.Companion.getINSTANCE().ILFree(path);
                $this$forEach$iv = selectedFiles;
                boolean $i$f$forEach = false;
            }
            catch (Throwable throwable) {
                try {
                    Shell32Ex.Companion.getINSTANCE().ILFree(path);
                    Pointer[] $this$forEach$iv2 = selectedFiles;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv2.length;
                    for (int i = 0; i < n; ++i) {
                        Pointer element$iv;
                        Pointer it = element$iv = $this$forEach$iv2[i];
                        boolean bl2 = false;
                        Shell32Ex.Companion.getINSTANCE().ILFree(it);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl3 = false;
                    return bl3;
                }
            }
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Pointer element$iv;
                Pointer it = element$iv = $this$forEach$iv[i];
                boolean bl4 = false;
                Shell32Ex.Companion.getINSTANCE().ILFree(it);
            }
            return bl;
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
    }

    private final boolean openFolderViaNative(String folder) {
        try {
            int result = Shell32.INSTANCE.ShellExecute(null, "explore", folder, null, null, 1).intValue();
            return result > 32;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final String quoted(String $this$quoted) {
        return "\"" + $this$quoted + "\"";
    }
}

