/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.ScreenUtil;
import dorkbox.util.Sys;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"J\u0014\u0010%\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'J\u0010\u0010(\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Ldorkbox/util/SwingUtil;", "", "()V", "BLANK_ICON", "Ljava/awt/Image;", "getBLANK_ICON", "()Ljava/awt/Image;", "isDefaultLookAndFeel", "", "()Z", "version", "", "getVersion", "()Ljava/lang/String;", "addWindowListener", "", "source", "Ljava/awt/Component;", "listener", "Ljava/awt/event/WindowListener;", "centerInWindow", "window", "Ljava/awt/Window;", "component", "getFromVirtualKey", "", "key", "", "getLargestIconHeightForButton", "button", "Ljavax/swing/AbstractButton;", "getVirtualKey", "invokeAndWait", "runnable", "Ljava/lang/Runnable;", "invokeAndWaitQuietly", "invokeLater", "setLookAndFeel", "lookAndFeel", "Ljava/lang/Class;", "setLookAndFeelByName", "showMessageDialog", "title", "message", "messageType", "Utilities"})
@SourceDebugExtension(value={"SMAP\nSwingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingUtil.kt\ndorkbox/util/SwingUtil\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,497:1\n107#2:498\n79#2,22:499\n*S KotlinDebug\n*F\n+ 1 SwingUtil.kt\ndorkbox/util/SwingUtil\n*L\n79#1:498\n79#1:499,22\n*E\n"})
public final class SwingUtil {
    @NotNull
    public static final SwingUtil INSTANCE = new SwingUtil();
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();
    @NotNull
    private static final Image BLANK_ICON;

    private SwingUtil() {
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    public final void setLookAndFeel(@Nullable Class<?> lookAndFeel) {
        if (lookAndFeel == null) {
            this.setLookAndFeelByName(null);
        } else {
            this.setLookAndFeelByName(lookAndFeel.getName());
        }
    }

    public final void setLookAndFeelByName(@Nullable String lookAndFeel) {
        if (lookAndFeel == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        String string = lookAndFeel.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String specified = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String string2 = UIManager.getLookAndFeel().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookAndFeel().name");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String current = string3;
        if (!Intrinsics.areEqual((Object)specified, (Object)current)) {
            try {
                UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                Intrinsics.checkNotNullExpressionValue((Object)lookAndFeelInfoArray, (String)"getInstalledLookAndFeels()");
                for (UIManager.LookAndFeelInfo info : lookAndFeelInfoArray) {
                    String className;
                    String name;
                    String string4 = info.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"info.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string4.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    String string5 = info.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"info.className");
                    Intrinsics.checkNotNullExpressionValue((Object)string5.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!Intrinsics.areEqual((Object)specified, (Object)name) && !Intrinsics.areEqual((Object)specified, (Object)className)) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        new Exception("Could not load " + lookAndFeel + ", it was not available.").printStackTrace();
    }

    public final boolean isDefaultLookAndFeel() {
        return Intrinsics.areEqual((Object)UIManager.getLookAndFeel().getClass().getName(), (Object)UIManager.getSystemLookAndFeelClassName());
    }

    @NotNull
    public final Image getBLANK_ICON() {
        return BLANK_ICON;
    }

    public final void addWindowListener(@NotNull Component source, @NotNull WindowListener listener) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (source instanceof Window) {
            ((Window)source).addWindowListener(listener);
        } else {
            source.addHierarchyListener(arg_0 -> SwingUtil.addWindowListener$lambda$1(source, listener, arg_0));
        }
    }

    public final int getLargestIconHeightForButton(@NotNull AbstractButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Icon icon = button.getIcon();
        String text = button.getText();
        button.setText("`Tj|\u2503");
        int minHeight = 0;
        int iconSize = 0;
        for (int i = 1; i < 128; ++i) {
            ImageIcon imageIcon = new ImageIcon(new BufferedImage(1, i, 12));
            button.setIcon(imageIcon);
            button.invalidate();
            int height = (int)button.getPreferredSize().getHeight();
            if (minHeight == 0) {
                minHeight = height;
            } else if (minHeight != height) break;
            iconSize = imageIcon.getIconHeight();
        }
        button.setIcon(icon);
        button.setText(text);
        return iconSize;
    }

    public final void centerInWindow(@NotNull Window window, @NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Dimension size = window.getSize();
        Point loc = window.getLocationOnScreen();
        Dimension cmpSize = component.getSize();
        loc.x += (size.width - cmpSize.width) / 2;
        loc.y += (size.height - cmpSize.height) / 2;
        component.setBounds(loc.x, loc.y, cmpSize.width, cmpSize.height);
    }

    public final void invokeLater(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public final void invokeAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeAndWait(runnable);
        }
    }

    public final void invokeAndWaitQuietly(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final int getVirtualKey(char key) {
        switch (key) {
            case '\b': {
                return 8;
            }
            case '\t': {
                return 9;
            }
            case '\n': {
                return 10;
            }
            case '\u001b': {
                return 27;
            }
            case '\u20ac': {
                return 516;
            }
            case ' ': {
                return 32;
            }
            case '!': {
                return 517;
            }
            case '\"': {
                return 152;
            }
            case '#': {
                return 520;
            }
            case '$': {
                return 515;
            }
            case '&': {
                return 150;
            }
            case '\'': {
                return 222;
            }
            case '(': {
                return 519;
            }
            case ')': {
                return 522;
            }
            case '*': {
                return 151;
            }
            case '+': {
                return 521;
            }
            case ',': {
                return 44;
            }
            case '-': {
                return 45;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case ':': {
                return 513;
            }
            case ';': {
                return 59;
            }
            case '<': {
                return 153;
            }
            case '=': {
                return 61;
            }
            case '>': {
                return 160;
            }
            case '@': {
                return 512;
            }
            case 'A': {
                return 65;
            }
            case 'B': {
                return 66;
            }
            case 'C': {
                return 67;
            }
            case 'D': {
                return 68;
            }
            case 'E': {
                return 69;
            }
            case 'F': {
                return 70;
            }
            case 'G': {
                return 71;
            }
            case 'H': {
                return 72;
            }
            case 'I': {
                return 73;
            }
            case 'J': {
                return 74;
            }
            case 'K': {
                return 75;
            }
            case 'L': {
                return 76;
            }
            case 'M': {
                return 77;
            }
            case 'N': {
                return 78;
            }
            case 'O': {
                return 79;
            }
            case 'P': {
                return 80;
            }
            case 'Q': {
                return 81;
            }
            case 'R': {
                return 82;
            }
            case 'S': {
                return 83;
            }
            case 'T': {
                return 84;
            }
            case 'U': {
                return 85;
            }
            case 'V': {
                return 86;
            }
            case 'W': {
                return 87;
            }
            case 'X': {
                return 88;
            }
            case 'Y': {
                return 89;
            }
            case 'Z': {
                return 90;
            }
            case '[': {
                return 91;
            }
            case '\\': {
                return 92;
            }
            case ']': {
                return 93;
            }
            case '^': {
                return 514;
            }
            case '_': {
                return 523;
            }
            case '`': {
                return 192;
            }
            case 'a': {
                return 65;
            }
            case 'b': {
                return 66;
            }
            case 'c': {
                return 67;
            }
            case 'd': {
                return 68;
            }
            case 'e': {
                return 69;
            }
            case 'f': {
                return 70;
            }
            case 'g': {
                return 71;
            }
            case 'h': {
                return 72;
            }
            case 'i': {
                return 73;
            }
            case 'j': {
                return 74;
            }
            case 'k': {
                return 75;
            }
            case 'l': {
                return 76;
            }
            case 'm': {
                return 77;
            }
            case 'n': {
                return 78;
            }
            case 'o': {
                return 79;
            }
            case 'p': {
                return 80;
            }
            case 'q': {
                return 81;
            }
            case 'r': {
                return 82;
            }
            case 's': {
                return 83;
            }
            case 't': {
                return 84;
            }
            case 'u': {
                return 85;
            }
            case 'v': {
                return 86;
            }
            case 'w': {
                return 87;
            }
            case 'x': {
                return 88;
            }
            case 'y': {
                return 89;
            }
            case 'z': {
                return 90;
            }
            case '{': {
                return 161;
            }
            case '}': {
                return 162;
            }
            case '\u007f': {
                return 127;
            }
            case '\u00a1': {
                return 518;
            }
        }
        return 0;
    }

    public final char getFromVirtualKey(int key) {
        int n;
        switch (key) {
            case 8: {
                n = 8;
                break;
            }
            case 9: {
                n = 9;
                break;
            }
            case 10: {
                n = 10;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 516: {
                n = 8364;
                break;
            }
            case 32: {
                n = 32;
                break;
            }
            case 517: {
                n = 33;
                break;
            }
            case 152: {
                n = 34;
                break;
            }
            case 520: {
                n = 35;
                break;
            }
            case 515: {
                n = 36;
                break;
            }
            case 150: {
                n = 38;
                break;
            }
            case 222: {
                n = 39;
                break;
            }
            case 519: {
                n = 40;
                break;
            }
            case 522: {
                n = 41;
                break;
            }
            case 151: {
                n = 42;
                break;
            }
            case 521: {
                n = 43;
                break;
            }
            case 44: {
                n = 44;
                break;
            }
            case 45: {
                n = 45;
                break;
            }
            case 46: {
                n = 46;
                break;
            }
            case 47: {
                n = 47;
                break;
            }
            case 48: {
                n = 48;
                break;
            }
            case 49: {
                n = 49;
                break;
            }
            case 50: {
                n = 50;
                break;
            }
            case 51: {
                n = 51;
                break;
            }
            case 52: {
                n = 52;
                break;
            }
            case 53: {
                n = 53;
                break;
            }
            case 54: {
                n = 54;
                break;
            }
            case 55: {
                n = 55;
                break;
            }
            case 56: {
                n = 56;
                break;
            }
            case 57: {
                n = 57;
                break;
            }
            case 513: {
                n = 58;
                break;
            }
            case 59: {
                n = 59;
                break;
            }
            case 153: {
                n = 60;
                break;
            }
            case 61: {
                n = 61;
                break;
            }
            case 160: {
                n = 62;
                break;
            }
            case 512: {
                n = 64;
                break;
            }
            case 65: {
                n = 65;
                break;
            }
            case 66: {
                n = 66;
                break;
            }
            case 67: {
                n = 67;
                break;
            }
            case 68: {
                n = 68;
                break;
            }
            case 69: {
                n = 69;
                break;
            }
            case 70: {
                n = 70;
                break;
            }
            case 71: {
                n = 71;
                break;
            }
            case 72: {
                n = 72;
                break;
            }
            case 73: {
                n = 73;
                break;
            }
            case 74: {
                n = 74;
                break;
            }
            case 75: {
                n = 75;
                break;
            }
            case 76: {
                n = 76;
                break;
            }
            case 77: {
                n = 77;
                break;
            }
            case 78: {
                n = 78;
                break;
            }
            case 79: {
                n = 79;
                break;
            }
            case 80: {
                n = 80;
                break;
            }
            case 81: {
                n = 81;
                break;
            }
            case 82: {
                n = 82;
                break;
            }
            case 83: {
                n = 83;
                break;
            }
            case 84: {
                n = 84;
                break;
            }
            case 85: {
                n = 85;
                break;
            }
            case 86: {
                n = 86;
                break;
            }
            case 87: {
                n = 87;
                break;
            }
            case 88: {
                n = 88;
                break;
            }
            case 89: {
                n = 89;
                break;
            }
            case 90: {
                n = 90;
                break;
            }
            case 91: {
                n = 91;
                break;
            }
            case 92: {
                n = 92;
                break;
            }
            case 93: {
                n = 93;
                break;
            }
            case 514: {
                n = 94;
                break;
            }
            case 523: {
                n = 95;
                break;
            }
            case 192: {
                n = 96;
                break;
            }
            case 161: {
                n = 123;
                break;
            }
            case 162: {
                n = 125;
                break;
            }
            case 127: {
                n = 127;
                break;
            }
            case 518: {
                n = 161;
                break;
            }
            default: {
                n = 0;
            }
        }
        int code = n;
        return (char)code;
    }

    public final int showMessageDialog(@NotNull String title, @NotNull String message, int messageType) throws HeadlessException {
        boolean supportsWindowDecorations;
        int n;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JOptionPane pane = new JOptionPane(message, messageType, -1, null, null, null);
        pane.setInitialValue(null);
        Frame rootFrame = JOptionPane.getRootFrame();
        pane.setComponentOrientation(rootFrame.getComponentOrientation());
        int style = 0;
        switch (messageType) {
            case 0: {
                n = 4;
                break;
            }
            case 3: {
                n = 7;
                break;
            }
            case 2: {
                n = 8;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case -1: {
                n = 2;
                break;
            }
            default: {
                n = 2;
            }
        }
        style = n;
        JDialog dialog = pane.createDialog(title);
        dialog.setModal(true);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            dialog.getRootPane().setWindowDecorationStyle(style);
        }
        pane.selectInitialValue();
        Intrinsics.checkNotNullExpressionValue((Object)dialog, (String)"dialog");
        ScreenUtil.INSTANCE.showOnSameScreenAsMouse_Center(dialog);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        return selectedValue instanceof Integer ? ((Number)selectedValue).intValue() : -1;
    }

    private static final void addWindowListener$lambda$1(Component $source, WindowListener $listener, HierarchyEvent e) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        if ((e.getChangeFlags() & 4L) == 4L) {
            SwingUtilities.getWindowAncestor($source).addWindowListener($listener);
        }
    }

    static {
        Toolkit.getDefaultToolkit();
        BLANK_ICON = new BufferedImage(1, 1, 3);
    }
}

