/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class Menu
extends MenuItem {
    final List<Entry> menuEntries = new ArrayList<Entry>();

    public Menu() {
    }

    public Menu(String text) {
        super(text);
    }

    public Menu(String text, ActionListener callback) {
        super(text, callback);
    }

    public Menu(String text, String imagePath) {
        super(text, imagePath);
    }

    public Menu(String text, File imageFile) {
        super(text, imageFile);
    }

    public Menu(String text, URL imageUrl) {
        super(text, imageUrl);
    }

    public Menu(String text, InputStream imageStream) {
        super(text, imageStream);
    }

    public Menu(String text, Image image) {
        super(text, image);
    }

    public Menu(String text, String imagePath, ActionListener callback) {
        super(text, imagePath, callback);
    }

    public Menu(String text, File imageFile, ActionListener callback) {
        super(text, imageFile, callback);
    }

    public Menu(String text, URL imageUrl, ActionListener callback) {
        super(text, imageUrl, callback);
    }

    public Menu(String text, InputStream imageStream, ActionListener callback) {
        super(text, imageStream, callback);
    }

    public Menu(String text, Image image, ActionListener callback) {
        super(text, image, callback);
    }

    public Menu(JMenu jMenu) {
        this.setEnabled(jMenu.isEnabled());
        Icon icon = jMenu.getIcon();
        if (icon != null) {
            BufferedImage bimage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            this.setImage(bimage);
        }
        this.setText(jMenu.getText());
        this.setShortcut(jMenu.getMnemonic());
        for (Component c : jMenu.getMenuComponents()) {
            if (c instanceof JMenu) {
                this.add((JMenu)c);
                continue;
            }
            if (c instanceof JCheckBoxMenuItem) {
                this.add((JCheckBoxMenuItem)c);
                continue;
            }
            if (c instanceof JMenuItem) {
                this.add((JMenuItem)c);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            this.add((JSeparator)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(MenuPeer peer, Menu parent, ImageResizeUtil imageResizeUtil) {
        ArrayList<Entry> copy;
        super.bind(peer, parent, imageResizeUtil);
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            copy = new ArrayList<Entry>(this.menuEntries);
        }
        int menuEntriesSize = copy.size();
        for (int i = 0; i < menuEntriesSize; ++i) {
            Entry menuEntry = (Entry)copy.get(i);
            peer.add(this, menuEntry, i);
        }
    }

    public final <T extends Entry> T add(T entry) {
        return this.add(entry, -1);
    }

    public final Menu add(JMenu entry) {
        this.add(new Menu(entry));
        return this;
    }

    public final Menu add(JCheckBoxMenuItem entry) {
        this.add(new Checkbox(entry));
        return this;
    }

    public final Menu add(JMenuItem entry) {
        this.add(new MenuItem(entry));
        return this;
    }

    public final Menu add(JSeparator entry) {
        this.add(new Separator());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T add(T entry, int index) {
        int insertIndex;
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (index == -1) {
                insertIndex = this.menuEntries.size();
                this.menuEntries.add(entry);
            } else {
                insertIndex = !this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Status ? index + 1 : index;
                this.menuEntries.add(index, entry);
            }
        }
        if (this.peer != null) {
            EventDispatch.runLater(() -> ((MenuPeer)this.peer).add(this, entry, insertIndex));
        }
        return entry;
    }

    public final Entry getFirst() {
        return this.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getLast() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                for (int i = this.menuEntries.size() - 1; i >= 0; --i) {
                    Entry entry = this.menuEntries.get(i);
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(int menuIndex) {
        if (menuIndex < 0) {
            return null;
        }
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                int count = 0;
                for (Entry entry : this.menuEntries) {
                    if (entry instanceof Separator || entry instanceof Status) continue;
                    if (count == menuIndex) {
                        return entry;
                    }
                    ++count;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getEntries() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Entry>(this.menuEntries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMenu asSwingComponent() {
        JMenu jMenu = new JMenu();
        if (this.getImage() != null) {
            jMenu.setIcon(new ImageIcon(this.getImage().getAbsolutePath()));
        }
        jMenu.setText(this.getText());
        jMenu.setToolTipText(this.getTooltip());
        jMenu.setEnabled(this.getEnabled());
        jMenu.setMnemonic(SwingUtil.INSTANCE.getVirtualKey(this.getShortcut()));
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            for (Entry menuEntry : this.menuEntries) {
                Entry entry;
                if (menuEntry instanceof Menu) {
                    entry = (Menu)menuEntry;
                    jMenu.add(((Menu)entry).asSwingComponent());
                    continue;
                }
                if (menuEntry instanceof Checkbox) {
                    entry = (Checkbox)menuEntry;
                    jMenu.add(((Checkbox)entry).asSwingComponent());
                    continue;
                }
                if (menuEntry instanceof MenuItem) {
                    entry = (MenuItem)menuEntry;
                    jMenu.add(((MenuItem)entry).asSwingComponent());
                    continue;
                }
                if (menuEntry instanceof Separator) {
                    entry = (Separator)menuEntry;
                    jMenu.add(((Separator)entry).asSwingComponent());
                    continue;
                }
                if (!(menuEntry instanceof Status)) continue;
                entry = (Status)menuEntry;
                jMenu.add(((Status)entry).asSwingComponent());
            }
        }
        return jMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entry entry) {
        if (entry != null) {
            Entry toRemove = null;
            List<Entry> list = this.menuEntries;
            synchronized (list) {
                Iterator<Entry> iterator = this.menuEntries.iterator();
                while (iterator.hasNext()) {
                    Entry entry__ = iterator.next();
                    if (entry__ != entry) continue;
                    iterator.remove();
                    toRemove = entry__;
                    break;
                }
            }
            if (toRemove != null) {
                Entry reference = toRemove;
                EventDispatch.runLater(() -> reference.remove());
                toRemove = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(0) instanceof Separator) {
                    toRemove = this.menuEntries.get(0);
                }
            }
            if (toRemove != null) {
                this.remove(toRemove);
                toRemove = null;
            }
            list = this.menuEntries;
            synchronized (list) {
                if (!this.menuEntries.isEmpty() && this.menuEntries.get(this.menuEntries.size() - 1) instanceof Separator) {
                    toRemove = this.menuEntries.get(this.menuEntries.size() - 1);
                }
            }
            if (toRemove != null) {
                this.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        List<Entry> list = this.menuEntries;
        synchronized (list) {
            this.menuEntries.clear();
        }
        EventDispatch.runLater(() -> this.remove_());
    }

    private void remove_() {
        super.remove();
    }
}

