/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItem;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemCheckbox;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemSeparator;
import dorkbox.systemTray.ui.osx.AwtOsxMenuItemStatus;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.io.File;
import javax.swing.ImageIcon;

class AwtOsxMenu
implements MenuPeer {
    volatile java.awt.Menu _native;
    private final AwtOsxMenu parent;
    private final Object peerObj;

    AwtOsxMenu(AwtOsxMenu parent) {
        this.parent = parent;
        if (parent == null) {
            this._native = new PopupMenu();
        } else {
            this._native = new java.awt.Menu();
            parent._native.add(this._native);
        }
        this._native.addNotify();
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void add(Menu parentMenu, Entry entry, int index) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry instanceof Menu) {
                AwtOsxMenu menu = new AwtOsxMenu(this);
                ((Menu)entry).bind(menu, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                AwtOsxMenuItemSeparator item = new AwtOsxMenuItemSeparator(this);
                entry.bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                AwtOsxMenuItemCheckbox item = new AwtOsxMenuItemCheckbox(this);
                ((Checkbox)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Status) {
                AwtOsxMenuItemStatus item = new AwtOsxMenuItemStatus(this);
                ((Status)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                AwtOsxMenuItem item = new AwtOsxMenuItem(this);
                ((MenuItem)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
        File imageFile = menuItem.getImage();
        if (this.peerObj != null && imageFile != null) {
            Image image = new ImageIcon(imageFile.getAbsolutePath()).getImage();
            SwingUtil.INSTANCE.invokeLater(() -> {
                try {
                    AwtAccessor.setImage(this.peerObj, image);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Unable to setImage for awt-osx menus.", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(vKey)));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        String tooltipText = menuItem.getTooltip();
        if (this.peerObj != null && tooltipText != null) {
            SwingUtil.INSTANCE.invokeLater(() -> {
                try {
                    AwtAccessor.setToolTipText(this.peerObj, tooltipText);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.removeAll();
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            }
            this._native.removeNotify();
        });
    }
}

