/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.SwingMenuItemSeparator;
import dorkbox.systemTray.ui.swing.SwingMenuItemStatus;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class SwingMenu
implements MenuPeer {
    private final SwingMenu parent;
    final JComponent _native;

    SwingMenu(String trayName) {
        this.parent = null;
        TrayPopup trayPopup = new TrayPopup(trayName);
        if (SystemTray.SWING_UI != null) {
            trayPopup.setUI(SystemTray.SWING_UI.getMenuUI(trayPopup, null));
        }
        this._native = trayPopup;
    }

    public SwingMenu(SwingMenu parent, Menu entry, int index) {
        this.parent = parent;
        JMenu jMenu = new JMenu();
        JPopupMenu popupMenu = jMenu.getPopupMenu();
        if (SystemTray.SWING_UI != null) {
            jMenu.setUI(SystemTray.SWING_UI.getItemUI(jMenu, entry));
            popupMenu.setUI(SystemTray.SWING_UI.getMenuUI(popupMenu, entry));
        }
        this._native = jMenu;
        parent._native.add((Component)jMenu, index);
    }

    @Override
    public void add(Menu parentMenu, Entry entry, int index) {
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            if (entry.hasPeer()) {
                return;
            }
            if (entry instanceof Menu) {
                SwingMenu swingMenu = new SwingMenu(this, (Menu)entry, index);
                ((Menu)entry).bind(swingMenu, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                SwingMenuItemSeparator item = new SwingMenuItemSeparator(this, index);
                entry.bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                SwingMenuItemCheckbox item = new SwingMenuItemCheckbox(this, entry, index);
                ((Checkbox)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Status) {
                SwingMenuItemStatus item = new SwingMenuItemStatus(this, entry);
                ((Status)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                SwingMenuItem item = new SwingMenuItem(this, entry, index);
                ((MenuItem)entry).bind(item, parentMenu, parentMenu.getImageResizeUtil());
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> {
            File imageFile = menuItem.getImage();
            if (imageFile != null) {
                ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                ((JMenu)this._native).setIcon(origIcon);
            } else {
                ((JMenu)this._native).setIcon(null);
            }
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> ((JMenu)this._native).setText(menuItem.getText()));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> ((JMenu)this._native).setMnemonic(vKey));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
    }

    @Override
    public synchronized void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.setVisible(false);
            this._native.removeAll();
            if (this.parent != null) {
                this.parent._native.remove(this._native);
            } else {
                ((TrayPopup)this._native).close();
            }
        });
    }
}

