/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItem
implements MenuItemPeer {
    static ImageIcon transparentIcon = null;
    protected final SwingMenu parent;
    protected final JMenuItem _native = new JMenuItem();
    protected volatile ActionListener callback;

    static void createTransparentIcon(int menuImageSize, ImageResizeUtil imageResizeUtil) {
        if (transparentIcon == null) {
            try {
                JMenuItem jMenuItem = new JMenuItem();
                if (SystemTray.SWING_UI != null) {
                    jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                }
                transparentIcon = new ImageIcon(imageResizeUtil.getTransparentImage(menuImageSize).getAbsolutePath());
            }
            catch (Exception e) {
                SystemTray.logger.error("Error creating transparent image.", (Throwable)e);
            }
        }
    }

    SwingMenuItem(SwingMenu parent, Entry entry, int index) {
        this.parent = parent;
        if (SystemTray.SWING_UI != null) {
            this._native.setUI(SystemTray.SWING_UI.getItemUI(this._native, entry));
        }
        this._native.setHorizontalAlignment(2);
        parent._native.add((Component)this._native, index);
        this._native.setIcon(transparentIcon);
    }

    @Override
    public void setImage(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> {
            File imageFile = menuItem.getImage();
            if (imageFile != null) {
                ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                this._native.setIcon(origIcon);
            } else {
                this._native.setIcon(transparentIcon);
            }
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setText(menuItem.getText()));
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setMnemonic(vKey));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setToolTipText(menuItem.getTooltip()));
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            if (this.callback != null) {
                this._native.removeActionListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeAll();
        });
    }
}

