/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import dorkbox.collections.ArrayMap;
import dorkbox.jna.windows.HBITMAPWrap;
import dorkbox.jna.windows.HICONWrap;
import dorkbox.jna.windows.Listener;
import dorkbox.jna.windows.Shell32;
import dorkbox.jna.windows.User32;
import dorkbox.jna.windows.WindowsEventDispatch;
import dorkbox.jna.windows.structs.NOTIFYICONDATA;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.ui.swing.SwingMenuItemCheckbox;
import dorkbox.systemTray.ui.swing.TrayPopup;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.systemTray.util.SizeAndScalingWindows;
import dorkbox.util.ImageUtil;
import dorkbox.util.SwingUtil;
import java.awt.Point;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class _WindowsNativeTray
extends Tray {
    private final Listener quitListener;
    private final Listener menuListener;
    private final Listener showListener;
    private volatile TrayPopup popupMenu;
    private volatile boolean visible = false;
    private volatile File imageFile;
    private volatile String tooltipText = "";
    private final WindowsEventDispatch edt;
    private final ArrayMap<File, HICONWrap> imageCache = new ArrayMap(false, 10);

    public _WindowsNativeTray(String trayName, ImageResizeUtil imageResizeUtil, Runnable onRemoveEvent) {
        super(onRemoveEvent);
        SwingMenuItem.createTransparentIcon(SizeAndScaling.TRAY_MENU_SIZE, imageResizeUtil);
        SwingMenuItemCheckbox.createCheckedIcon(SizeAndScaling.TRAY_MENU_SIZE);
        this.edt = WindowsEventDispatch.start();
        SwingMenu swingMenu = new SwingMenu(trayName){

            @Override
            public void setImage(MenuItem menuItem) {
                _WindowsNativeTray.this.imageFile = menuItem.getImage();
                NOTIFYICONDATA nid = new NOTIFYICONDATA();
                nid.hWnd = _WindowsNativeTray.this.edt.get();
                if (_WindowsNativeTray.this.imageFile != null) {
                    HICONWrap imageIcon = _WindowsNativeTray.this.convertImage(_WindowsNativeTray.this.imageFile);
                    nid.setIcon((WinDef.HICON)imageIcon);
                }
                if (!Shell32.Shell_NotifyIcon((int)1, (NOTIFYICONDATA)nid)) {
                    SystemTray.logger.error("Error setting the image for the tray. {}", (Object)Kernel32Util.getLastErrorMessage());
                }
                _WindowsNativeTray.this.setTooltip_(_WindowsNativeTray.this.tooltipText);
                SwingUtil.INSTANCE.invokeLater(() -> {
                    if (_WindowsNativeTray.this.popupMenu == null) {
                        TrayPopup popupMenu = (TrayPopup)this._native;
                        popupMenu.pack();
                        popupMenu.setFocusable(true);
                        _WindowsNativeTray.this.popupMenu = popupMenu;
                    }
                    _WindowsNativeTray.this.popupMenu.setTitleBarImage(_WindowsNativeTray.this.imageFile);
                });
            }

            @Override
            public void setEnabled(MenuItem menuItem) {
                boolean enabled = menuItem.getEnabled();
                if (_WindowsNativeTray.this.visible && !enabled) {
                    _WindowsNativeTray.this.hide();
                } else if (!_WindowsNativeTray.this.visible && enabled) {
                    _WindowsNativeTray.this.show();
                }
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void setTooltip(MenuItem menuItem) {
                String text = menuItem.getTooltip();
                _WindowsNativeTray.this.setTooltip_(text);
            }

            @Override
            public void remove() {
                _WindowsNativeTray.this.hide();
                super.remove();
                _WindowsNativeTray.this.edt.stop();
            }
        };
        WinDef.HWND hWnd = this.edt.get();
        if (hWnd == null) {
            throw new RuntimeException("The Windows System Tray is not supported! Please write an issue and include your OS type and configuration");
        }
        this.showListener = new Listener(){

            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                _WindowsNativeTray.this.show();
            }
        };
        this.quitListener = new Listener(){

            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.showListener);
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.quitListener);
                _WindowsNativeTray.this.edt.removeListener(_WindowsNativeTray.this.menuListener);
                _WindowsNativeTray.this.edt.stop();
            }
        };
        this.menuListener = new Listener(){
            final WinDef.POINT mousePosition = new WinDef.POINT();

            public void run(WinDef.HWND hWnd, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
                int lp = lParam.intValue();
                switch (lp) {
                    case 514: 
                    case 517: {
                        if (_WindowsNativeTray.this.popupMenu == null || !User32.User32.GetCursorPos(this.mousePosition)) break;
                        double scale = SizeAndScalingWindows.getDpiScaleForMouseClick(this.mousePosition.x, this.mousePosition.y);
                        Point point = new Point((int)((double)this.mousePosition.x * scale), (int)((double)this.mousePosition.y * scale));
                        _WindowsNativeTray.this.popupMenu.doShow(point, 0);
                        break;
                    }
                }
            }
        };
        this.edt.addListener(WindowsEventDispatch.WM_TASKBARCREATED, this.showListener);
        this.edt.addListener(18, this.quitListener);
        this.edt.addListener(1025, this.menuListener);
        this.show();
        this.bind(swingMenu, null, imageResizeUtil);
    }

    private void setTooltip_(String text) {
        if (this.tooltipText != null && this.tooltipText.equals(text)) {
            return;
        }
        this.tooltipText = text;
        NOTIFYICONDATA nid = new NOTIFYICONDATA();
        nid.hWnd = this.edt.get();
        if (text != null) {
            nid.setTooltip(text);
        }
        Shell32.Shell_NotifyIcon((int)1, (NOTIFYICONDATA)nid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hide() {
        ArrayMap<File, HICONWrap> arrayMap = this.imageCache;
        synchronized (arrayMap) {
            for (HICONWrap value : this.imageCache.getValues()) {
                value.close();
            }
            this.imageCache.clear();
        }
        if (this.visible) {
            NOTIFYICONDATA nid = new NOTIFYICONDATA();
            nid.hWnd = this.edt.get();
            if (nid.hWnd != null && !Shell32.Shell_NotifyIcon((int)2, (NOTIFYICONDATA)nid)) {
                SystemTray.logger.error("Error hiding tray. {}", (Object)Kernel32Util.getLastErrorMessage());
            }
            this.visible = false;
        }
    }

    private void show() {
        HICONWrap imageIcon;
        if (this.visible) {
            this.hide();
        }
        NOTIFYICONDATA nid = new NOTIFYICONDATA();
        nid.hWnd = this.edt.get();
        nid.setTooltip(this.tooltipText);
        if (this.imageFile != null && (imageIcon = this.convertImage(this.imageFile)) != null) {
            nid.setIcon((WinDef.HICON)imageIcon);
        }
        nid.setCallback(1025);
        if (!Shell32.Shell_NotifyIcon((int)0, (NOTIFYICONDATA)nid)) {
            SystemTray.logger.error("Error showing tray. {}, {}", (Object)Kernel32Util.getLastErrorMessage(), (Object)Thread.currentThread().getStackTrace());
        }
        this.visible = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HICONWrap convertImage(File imageFile) {
        ArrayMap<File, HICONWrap> arrayMap = this.imageCache;
        synchronized (arrayMap) {
            HICONWrap hiconWrap = (HICONWrap)this.imageCache.get((Object)imageFile);
            if (hiconWrap == null) {
                ImageIcon imageIcon = new ImageIcon(imageFile.getAbsolutePath());
                if ((imageIcon = new ImageIcon(imageIcon.getImage())).getIconHeight() <= 0 || imageIcon.getIconWidth() <= 0) {
                    SystemTray.logger.error("Error loading image for the system tray. {}", (Object)imageFile);
                    return null;
                }
                HBITMAPWrap hbitmapTrayIcon = new HBITMAPWrap(ImageUtil.getBufferedImage((Icon)imageIcon));
                hiconWrap = new HICONWrap(hbitmapTrayIcon);
                this.imageCache.put((Object)imageFile, (Object)hiconWrap);
                if (this.imageCache.getSize() > 120) {
                    SystemTray.logger.error("More than 120 different images used for the SystemTray icon. This will lead to performance issues.");
                }
            }
            return hiconWrap;
        }
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

