/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.updateapplier;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"extractTo", "", "archiveFile", "Ljava/io/File;", "destinationFolder", "extractZip", "zipFile", "outputDirPath", "extractTarGzUsingTar", "tarGzFilePath", "updater"})
@SourceDebugExtension(value={"SMAP\nUpdateInstallerFromArchiveFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateInstallerFromArchiveFile.kt\ncom/abdownloadmanager/updateapplier/UpdateInstallerFromArchiveFileKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,185:1\n72#2:186\n58#2,4:187\n72#2:191\n58#2,22:192\n66#2,10:214\n62#2,3:224\n77#2,3:227\n*S KotlinDebug\n*F\n+ 1 UpdateInstallerFromArchiveFile.kt\ncom/abdownloadmanager/updateapplier/UpdateInstallerFromArchiveFileKt\n*L\n151#1:186\n151#1:187,4\n161#1:191\n161#1:192,22\n151#1:214,10\n151#1:224,3\n151#1:227,3\n*E\n"})
public final class UpdateInstallerFromArchiveFileKt {
    private static final void extractTo(File archiveFile, File destinationFolder) {
        String name = archiveFile.getName();
        if (!(!destinationFolder.isFile())) {
            boolean $i$a$-require-UpdateInstallerFromArchiveFileKt$extractTo$32 = false;
            String $i$a$-require-UpdateInstallerFromArchiveFileKt$extractTo$32 = "destination folder is a file!";
            throw new IllegalArgumentException($i$a$-require-UpdateInstallerFromArchiveFileKt$extractTo$32.toString());
        }
        destinationFolder.mkdirs();
        if (!destinationFolder.isDirectory()) {
            boolean bl = false;
            String string = "destination folder is not created!";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null)) {
            UpdateInstallerFromArchiveFileKt.extractZip(archiveFile, destinationFolder);
        } else if (StringsKt.endsWith$default((String)name, (String)"tar.gz", (boolean)false, (int)2, null)) {
            UpdateInstallerFromArchiveFileKt.extractTarGzUsingTar(archiveFile, destinationFolder);
        } else {
            throw new IllegalStateException(("archive file not detected for this file name: " + name).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void extractZip(File zipFile, File outputDirPath) {
        Unit unit;
        Throwable thrown$iv;
        block28: {
            Closeable $this$use$iv = new ZipInputStream(new FileInputStream(zipFile));
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                ZipInputStream zis = (ZipInputStream)$this$use$iv;
                boolean bl = false;
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    Long l;
                    Throwable thrown$iv2;
                    block26: {
                        void $this$use$iv2;
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        File outputFile = FilesKt.resolve((File)outputDirPath, (String)string);
                        if (entry.isDirectory()) {
                            outputFile.mkdirs();
                            continue;
                        }
                        outputFile.getParentFile().mkdirs();
                        Closeable closeable = new FileOutputStream(outputFile);
                        boolean $i$f$use2 = false;
                        thrown$iv2 = null;
                        try {
                            FileOutputStream fileOutputStream = (FileOutputStream)$this$use$iv2;
                            boolean bl2 = false;
                            l = ByteStreamsKt.copyTo$default((InputStream)zis, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable t$iv) {
                            try {
                                thrown$iv2 = t$iv;
                                l = null;
                                break block26;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                block27: {
                                    try {
                                        $this$use$iv2.close();
                                    }
                                    catch (Throwable t$iv2) {
                                        if (thrown$iv2 == null) {
                                            thrown$iv2 = t$iv2;
                                            break block27;
                                        }
                                        ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv2);
                                    }
                                }
                            }
                        }
                        try {
                            $this$use$iv2.close();
                        }
                        catch (Throwable t$iv) {
                            thrown$iv2 = t$iv;
                        }
                    }
                    Long result$iv = l;
                    Throwable throwable = thrown$iv2;
                    if (throwable == null) continue;
                    throw throwable;
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    unit = null;
                    break block28;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block29: {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv3) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv3;
                                break block29;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                        }
                    }
                }
            }
            try {
                $this$use$iv.close();
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Unit result$iv = unit;
        Throwable throwable = thrown$iv;
        if (throwable == null) return;
        throw throwable;
    }

    private static final void extractTarGzUsingTar(File tarGzFilePath, File outputDirPath) {
        Object[] objectArray = new String[]{"tar", "-xzvf", tarGzFilePath.getPath(), "-C", outputDirPath.getPath()};
        List tarCommand = CollectionsKt.listOf((Object[])objectArray);
        try {
            Process process = new ProcessBuilder(tarCommand).start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                System.out.println((Object)"Extraction completed successfully.");
            } else {
                System.out.println((Object)("Error during extraction. Exit code: " + exitCode));
            }
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to execute tar command: " + e.getMessage()));
        }
    }

    public static final /* synthetic */ void access$extractTo(File archiveFile, File destinationFolder) {
        UpdateInstallerFromArchiveFileKt.extractTo(archiveFile, destinationFolder);
    }
}

