const Big5DecodeOffset* = 942
type UCS16x16* = tuple[ucs, p: uint16]
type UCS16x8* = tuple[ucs: uint16, p: uint8]

const IBM866Decode*: array[128, uint16] = [
uint16 1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,
1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,
1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,
1086,1087,9617,9618,9619,9474,9508,9569,9570,9558,9557,9571,9553,9559,9565,9564,
9563,9488,9492,9524,9516,9500,9472,9532,9566,9567,9562,9556,9577,9574,9568,9552,
9580,9575,9576,9572,9573,9561,9560,9554,9555,9579,9578,9496,9484,9608,9604,9612,
9616,9600,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,
1102,1103,1025,1105,1028,1108,1031,1111,1038,1118,176,8729,183,8730,8470,164,
9632,160,
]
const IBM866Encode*: array[128, UCS16x8] = [
(160u16,255u8),(164u16,253u8),(176u16,248u8),(183u16,250u8),(1025u16,240u8),
(1028u16,242u8),(1031u16,244u8),(1038u16,246u8),(1040u16,128u8),(1041u16,129u8),
(1042u16,130u8),(1043u16,131u8),(1044u16,132u8),(1045u16,133u8),(1046u16,134u8),
(1047u16,135u8),(1048u16,136u8),(1049u16,137u8),(1050u16,138u8),(1051u16,139u8),
(1052u16,140u8),(1053u16,141u8),(1054u16,142u8),(1055u16,143u8),(1056u16,144u8),
(1057u16,145u8),(1058u16,146u8),(1059u16,147u8),(1060u16,148u8),(1061u16,149u8),
(1062u16,150u8),(1063u16,151u8),(1064u16,152u8),(1065u16,153u8),(1066u16,154u8),
(1067u16,155u8),(1068u16,156u8),(1069u16,157u8),(1070u16,158u8),(1071u16,159u8),
(1072u16,160u8),(1073u16,161u8),(1074u16,162u8),(1075u16,163u8),(1076u16,164u8),
(1077u16,165u8),(1078u16,166u8),(1079u16,167u8),(1080u16,168u8),(1081u16,169u8),
(1082u16,170u8),(1083u16,171u8),(1084u16,172u8),(1085u16,173u8),(1086u16,174u8),
(1087u16,175u8),(1088u16,224u8),(1089u16,225u8),(1090u16,226u8),(1091u16,227u8),
(1092u16,228u8),(1093u16,229u8),(1094u16,230u8),(1095u16,231u8),(1096u16,232u8),
(1097u16,233u8),(1098u16,234u8),(1099u16,235u8),(1100u16,236u8),(1101u16,237u8),
(1102u16,238u8),(1103u16,239u8),(1105u16,241u8),(1108u16,243u8),(1111u16,245u8),
(1118u16,247u8),(8470u16,252u8),(8729u16,249u8),(8730u16,251u8),(9472u16,196u8),
(9474u16,179u8),(9484u16,218u8),(9488u16,191u8),(9492u16,192u8),(9496u16,217u8),
(9500u16,195u8),(9508u16,180u8),(9516u16,194u8),(9524u16,193u8),(9532u16,197u8),
(9552u16,205u8),(9553u16,186u8),(9554u16,213u8),(9555u16,214u8),(9556u16,201u8),
(9557u16,184u8),(9558u16,183u8),(9559u16,187u8),(9560u16,212u8),(9561u16,211u8),
(9562u16,200u8),(9563u16,190u8),(9564u16,189u8),(9565u16,188u8),(9566u16,198u8),
(9567u16,199u8),(9568u16,204u8),(9569u16,181u8),(9570u16,182u8),(9571u16,185u8),
(9572u16,209u8),(9573u16,210u8),(9574u16,203u8),(9575u16,207u8),(9576u16,208u8),
(9577u16,202u8),(9578u16,216u8),(9579u16,215u8),(9580u16,206u8),(9600u16,223u8),
(9604u16,220u8),(9608u16,219u8),(9612u16,221u8),(9616u16,222u8),(9617u16,176u8),
(9618u16,177u8),(9619u16,178u8),(9632u16,254u8),
]

const ISO88592Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,728,321,164,317,
346,167,168,352,350,356,377,173,381,379,176,261,731,322,180,318,347,711,184,353,
351,357,378,733,382,380,340,193,194,258,196,313,262,199,268,201,280,203,282,205,
206,270,272,323,327,211,212,336,214,215,344,366,218,368,220,221,354,223,341,225,
226,259,228,314,263,231,269,233,281,235,283,237,238,271,273,324,328,243,244,337,
246,247,345,367,250,369,252,253,355,729,
]
const ISO88592Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(164u16,164u8),(167u16,167u8),
(168u16,168u8),(173u16,173u8),(176u16,176u8),(180u16,180u8),(184u16,184u8),
(193u16,193u8),(194u16,194u8),(196u16,196u8),(199u16,199u8),(201u16,201u8),
(203u16,203u8),(205u16,205u8),(206u16,206u8),(211u16,211u8),(212u16,212u8),
(214u16,214u8),(215u16,215u8),(218u16,218u8),(220u16,220u8),(221u16,221u8),
(223u16,223u8),(225u16,225u8),(226u16,226u8),(228u16,228u8),(231u16,231u8),
(233u16,233u8),(235u16,235u8),(237u16,237u8),(238u16,238u8),(243u16,243u8),
(244u16,244u8),(246u16,246u8),(247u16,247u8),(250u16,250u8),(252u16,252u8),
(253u16,253u8),(258u16,195u8),(259u16,227u8),(260u16,161u8),(261u16,177u8),
(262u16,198u8),(263u16,230u8),(268u16,200u8),(269u16,232u8),(270u16,207u8),
(271u16,239u8),(272u16,208u8),(273u16,240u8),(280u16,202u8),(281u16,234u8),
(282u16,204u8),(283u16,236u8),(313u16,197u8),(314u16,229u8),(317u16,165u8),
(318u16,181u8),(321u16,163u8),(322u16,179u8),(323u16,209u8),(324u16,241u8),
(327u16,210u8),(328u16,242u8),(336u16,213u8),(337u16,245u8),(340u16,192u8),
(341u16,224u8),(344u16,216u8),(345u16,248u8),(346u16,166u8),(347u16,182u8),
(350u16,170u8),(351u16,186u8),(352u16,169u8),(353u16,185u8),(354u16,222u8),
(355u16,254u8),(356u16,171u8),(357u16,187u8),(366u16,217u8),(367u16,249u8),
(368u16,219u8),(369u16,251u8),(377u16,172u8),(378u16,188u8),(379u16,175u8),
(380u16,191u8),(381u16,174u8),(382u16,190u8),(711u16,183u8),(728u16,162u8),
(729u16,255u8),(731u16,178u8),(733u16,189u8),
]

const ISO88593Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,294,728,163,164,0,
292,167,168,304,350,286,308,173,0,379,176,295,178,179,180,181,293,183,184,305,
351,287,309,189,0,380,192,193,194,0,196,266,264,199,200,201,202,203,204,205,206,
207,0,209,210,211,212,288,214,215,284,217,218,219,220,364,348,223,224,225,226,0,
228,267,265,231,232,233,234,235,236,237,238,239,0,241,242,243,244,289,246,247,
285,249,250,251,252,365,349,729,
]
const ISO88593Encode*: array[121, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(163u16,163u8),(164u16,164u8),
(167u16,167u8),(168u16,168u8),(173u16,173u8),(176u16,176u8),(178u16,178u8),
(179u16,179u8),(180u16,180u8),(181u16,181u8),(183u16,183u8),(184u16,184u8),
(189u16,189u8),(192u16,192u8),(193u16,193u8),(194u16,194u8),(196u16,196u8),
(199u16,199u8),(200u16,200u8),(201u16,201u8),(202u16,202u8),(203u16,203u8),
(204u16,204u8),(205u16,205u8),(206u16,206u8),(207u16,207u8),(209u16,209u8),
(210u16,210u8),(211u16,211u8),(212u16,212u8),(214u16,214u8),(215u16,215u8),
(217u16,217u8),(218u16,218u8),(219u16,219u8),(220u16,220u8),(223u16,223u8),
(224u16,224u8),(225u16,225u8),(226u16,226u8),(228u16,228u8),(231u16,231u8),
(232u16,232u8),(233u16,233u8),(234u16,234u8),(235u16,235u8),(236u16,236u8),
(237u16,237u8),(238u16,238u8),(239u16,239u8),(241u16,241u8),(242u16,242u8),
(243u16,243u8),(244u16,244u8),(246u16,246u8),(247u16,247u8),(249u16,249u8),
(250u16,250u8),(251u16,251u8),(252u16,252u8),(264u16,198u8),(265u16,230u8),
(266u16,197u8),(267u16,229u8),(284u16,216u8),(285u16,248u8),(286u16,171u8),
(287u16,187u8),(288u16,213u8),(289u16,245u8),(292u16,166u8),(293u16,182u8),
(294u16,161u8),(295u16,177u8),(304u16,169u8),(305u16,185u8),(308u16,172u8),
(309u16,188u8),(348u16,222u8),(349u16,254u8),(350u16,170u8),(351u16,186u8),
(364u16,221u8),(365u16,253u8),(379u16,175u8),(380u16,191u8),(728u16,162u8),
(729u16,255u8),
]

const ISO88594Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,312,342,164,296,
315,167,168,352,274,290,358,173,381,175,176,261,731,343,180,297,316,711,184,353,
275,291,359,330,382,331,256,193,194,195,196,197,198,302,268,201,280,203,278,205,
206,298,272,325,332,310,212,213,214,215,216,370,218,219,220,360,362,223,257,225,
226,227,228,229,230,303,269,233,281,235,279,237,238,299,273,326,333,311,244,245,
246,247,248,371,250,251,252,361,363,729,
]
const ISO88594Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(164u16,164u8),(167u16,167u8),
(168u16,168u8),(173u16,173u8),(175u16,175u8),(176u16,176u8),(180u16,180u8),
(184u16,184u8),(193u16,193u8),(194u16,194u8),(195u16,195u8),(196u16,196u8),
(197u16,197u8),(198u16,198u8),(201u16,201u8),(203u16,203u8),(205u16,205u8),
(206u16,206u8),(212u16,212u8),(213u16,213u8),(214u16,214u8),(215u16,215u8),
(216u16,216u8),(218u16,218u8),(219u16,219u8),(220u16,220u8),(223u16,223u8),
(225u16,225u8),(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),
(230u16,230u8),(233u16,233u8),(235u16,235u8),(237u16,237u8),(238u16,238u8),
(244u16,244u8),(245u16,245u8),(246u16,246u8),(247u16,247u8),(248u16,248u8),
(250u16,250u8),(251u16,251u8),(252u16,252u8),(256u16,192u8),(257u16,224u8),
(260u16,161u8),(261u16,177u8),(268u16,200u8),(269u16,232u8),(272u16,208u8),
(273u16,240u8),(274u16,170u8),(275u16,186u8),(278u16,204u8),(279u16,236u8),
(280u16,202u8),(281u16,234u8),(290u16,171u8),(291u16,187u8),(296u16,165u8),
(297u16,181u8),(298u16,207u8),(299u16,239u8),(302u16,199u8),(303u16,231u8),
(310u16,211u8),(311u16,243u8),(312u16,162u8),(315u16,166u8),(316u16,182u8),
(325u16,209u8),(326u16,241u8),(330u16,189u8),(331u16,191u8),(332u16,210u8),
(333u16,242u8),(342u16,163u8),(343u16,179u8),(352u16,169u8),(353u16,185u8),
(358u16,172u8),(359u16,188u8),(360u16,221u8),(361u16,253u8),(362u16,222u8),
(363u16,254u8),(370u16,217u8),(371u16,249u8),(381u16,174u8),(382u16,190u8),
(711u16,183u8),(729u16,255u8),(731u16,178u8),
]

const ISO88595Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,1025,1026,1027,1028,
1029,1030,1031,1032,1033,1034,1035,1036,173,1038,1039,1040,1041,1042,1043,1044,
1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,
1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,
1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,
1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,8470,1105,1106,1107,1108,
1109,1110,1111,1112,1113,1114,1115,1116,167,1118,1119,
]
const ISO88595Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(167u16,253u8),(173u16,173u8),
(1025u16,161u8),(1026u16,162u8),(1027u16,163u8),(1028u16,164u8),(1029u16,165u8),
(1030u16,166u8),(1031u16,167u8),(1032u16,168u8),(1033u16,169u8),(1034u16,170u8),
(1035u16,171u8),(1036u16,172u8),(1038u16,174u8),(1039u16,175u8),(1040u16,176u8),
(1041u16,177u8),(1042u16,178u8),(1043u16,179u8),(1044u16,180u8),(1045u16,181u8),
(1046u16,182u8),(1047u16,183u8),(1048u16,184u8),(1049u16,185u8),(1050u16,186u8),
(1051u16,187u8),(1052u16,188u8),(1053u16,189u8),(1054u16,190u8),(1055u16,191u8),
(1056u16,192u8),(1057u16,193u8),(1058u16,194u8),(1059u16,195u8),(1060u16,196u8),
(1061u16,197u8),(1062u16,198u8),(1063u16,199u8),(1064u16,200u8),(1065u16,201u8),
(1066u16,202u8),(1067u16,203u8),(1068u16,204u8),(1069u16,205u8),(1070u16,206u8),
(1071u16,207u8),(1072u16,208u8),(1073u16,209u8),(1074u16,210u8),(1075u16,211u8),
(1076u16,212u8),(1077u16,213u8),(1078u16,214u8),(1079u16,215u8),(1080u16,216u8),
(1081u16,217u8),(1082u16,218u8),(1083u16,219u8),(1084u16,220u8),(1085u16,221u8),
(1086u16,222u8),(1087u16,223u8),(1088u16,224u8),(1089u16,225u8),(1090u16,226u8),
(1091u16,227u8),(1092u16,228u8),(1093u16,229u8),(1094u16,230u8),(1095u16,231u8),
(1096u16,232u8),(1097u16,233u8),(1098u16,234u8),(1099u16,235u8),(1100u16,236u8),
(1101u16,237u8),(1102u16,238u8),(1103u16,239u8),(1105u16,241u8),(1106u16,242u8),
(1107u16,243u8),(1108u16,244u8),(1109u16,245u8),(1110u16,246u8),(1111u16,247u8),
(1112u16,248u8),(1113u16,249u8),(1114u16,250u8),(1115u16,251u8),(1116u16,252u8),
(1118u16,254u8),(1119u16,255u8),(8470u16,240u8),
]

const ISO88596Decode*: array[115, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,0,0,0,164,0,0,0,0,0,
0,0,1548,173,0,0,0,0,0,0,0,0,0,0,0,0,0,1563,0,0,0,1567,0,1569,1570,1571,1572,
1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,1588,
1589,1590,1591,1592,1593,1594,0,0,0,0,0,1600,1601,1602,1603,1604,1605,1606,1607,
1608,1609,1610,1611,1612,1613,1614,1615,1616,1617,1618,
]
const ISO88596Encode*: array[83, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(164u16,164u8),(173u16,173u8),
(1548u16,172u8),(1563u16,187u8),(1567u16,191u8),(1569u16,193u8),(1570u16,194u8),
(1571u16,195u8),(1572u16,196u8),(1573u16,197u8),(1574u16,198u8),(1575u16,199u8),
(1576u16,200u8),(1577u16,201u8),(1578u16,202u8),(1579u16,203u8),(1580u16,204u8),
(1581u16,205u8),(1582u16,206u8),(1583u16,207u8),(1584u16,208u8),(1585u16,209u8),
(1586u16,210u8),(1587u16,211u8),(1588u16,212u8),(1589u16,213u8),(1590u16,214u8),
(1591u16,215u8),(1592u16,216u8),(1593u16,217u8),(1594u16,218u8),(1600u16,224u8),
(1601u16,225u8),(1602u16,226u8),(1603u16,227u8),(1604u16,228u8),(1605u16,229u8),
(1606u16,230u8),(1607u16,231u8),(1608u16,232u8),(1609u16,233u8),(1610u16,234u8),
(1611u16,235u8),(1612u16,236u8),(1613u16,237u8),(1614u16,238u8),(1615u16,239u8),
(1616u16,240u8),(1617u16,241u8),(1618u16,242u8),
]

const ISO88597Decode*: array[127, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8216,8217,163,8364,
8367,166,167,168,169,890,171,172,173,0,8213,176,177,178,179,900,901,902,183,904,
905,906,187,908,189,910,911,912,913,914,915,916,917,918,919,920,921,922,923,924,
925,926,927,928,929,0,931,932,933,934,935,936,937,938,939,940,941,942,943,944,
945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,
965,966,967,968,969,970,971,972,973,974,
]
const ISO88597Encode*: array[125, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(163u16,163u8),(166u16,166u8),
(167u16,167u8),(168u16,168u8),(169u16,169u8),(171u16,171u8),(172u16,172u8),
(173u16,173u8),(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),
(183u16,183u8),(187u16,187u8),(189u16,189u8),(890u16,170u8),(900u16,180u8),
(901u16,181u8),(902u16,182u8),(904u16,184u8),(905u16,185u8),(906u16,186u8),
(908u16,188u8),(910u16,190u8),(911u16,191u8),(912u16,192u8),(913u16,193u8),
(914u16,194u8),(915u16,195u8),(916u16,196u8),(917u16,197u8),(918u16,198u8),
(919u16,199u8),(920u16,200u8),(921u16,201u8),(922u16,202u8),(923u16,203u8),
(924u16,204u8),(925u16,205u8),(926u16,206u8),(927u16,207u8),(928u16,208u8),
(929u16,209u8),(931u16,211u8),(932u16,212u8),(933u16,213u8),(934u16,214u8),
(935u16,215u8),(936u16,216u8),(937u16,217u8),(938u16,218u8),(939u16,219u8),
(940u16,220u8),(941u16,221u8),(942u16,222u8),(943u16,223u8),(944u16,224u8),
(945u16,225u8),(946u16,226u8),(947u16,227u8),(948u16,228u8),(949u16,229u8),
(950u16,230u8),(951u16,231u8),(952u16,232u8),(953u16,233u8),(954u16,234u8),
(955u16,235u8),(956u16,236u8),(957u16,237u8),(958u16,238u8),(959u16,239u8),
(960u16,240u8),(961u16,241u8),(962u16,242u8),(963u16,243u8),(964u16,244u8),
(965u16,245u8),(966u16,246u8),(967u16,247u8),(968u16,248u8),(969u16,249u8),
(970u16,250u8),(971u16,251u8),(972u16,252u8),(973u16,253u8),(974u16,254u8),
(8213u16,175u8),(8216u16,161u8),(8217u16,162u8),(8364u16,164u8),(8367u16,165u8),
]

const ISO88598Decode*: array[127, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,0,162,163,164,165,
166,167,168,169,215,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,
247,187,188,189,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,8215,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,
1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,0,0,8206,8207,
]
const ISO88598Encode*: array[92, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(162u16,162u8),(163u16,163u8),
(164u16,164u8),(165u16,165u8),(166u16,166u8),(167u16,167u8),(168u16,168u8),
(169u16,169u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),
(175u16,175u8),(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),
(180u16,180u8),(181u16,181u8),(182u16,182u8),(183u16,183u8),(184u16,184u8),
(185u16,185u8),(187u16,187u8),(188u16,188u8),(189u16,189u8),(190u16,190u8),
(215u16,170u8),(247u16,186u8),(1488u16,224u8),(1489u16,225u8),(1490u16,226u8),
(1491u16,227u8),(1492u16,228u8),(1493u16,229u8),(1494u16,230u8),(1495u16,231u8),
(1496u16,232u8),(1497u16,233u8),(1498u16,234u8),(1499u16,235u8),(1500u16,236u8),
(1501u16,237u8),(1502u16,238u8),(1503u16,239u8),(1504u16,240u8),(1505u16,241u8),
(1506u16,242u8),(1507u16,243u8),(1508u16,244u8),(1509u16,245u8),(1510u16,246u8),
(1511u16,247u8),(1512u16,248u8),(1513u16,249u8),(1514u16,250u8),(8206u16,253u8),
(8207u16,254u8),(8215u16,223u8),
]

const ISO885910Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,274,290,298,296,
310,167,315,272,352,358,381,173,362,330,176,261,275,291,299,297,311,183,316,273,
353,359,382,8213,363,331,256,193,194,195,196,197,198,302,268,201,280,203,278,
205,206,207,208,325,332,211,212,213,214,360,216,370,218,219,220,221,222,223,257,
225,226,227,228,229,230,303,269,233,281,235,279,237,238,239,240,326,333,243,244,
245,246,361,248,371,250,251,252,253,254,312,
]
const ISO885910Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(167u16,167u8),(173u16,173u8),
(176u16,176u8),(183u16,183u8),(193u16,193u8),(194u16,194u8),(195u16,195u8),
(196u16,196u8),(197u16,197u8),(198u16,198u8),(201u16,201u8),(203u16,203u8),
(205u16,205u8),(206u16,206u8),(207u16,207u8),(208u16,208u8),(211u16,211u8),
(212u16,212u8),(213u16,213u8),(214u16,214u8),(216u16,216u8),(218u16,218u8),
(219u16,219u8),(220u16,220u8),(221u16,221u8),(222u16,222u8),(223u16,223u8),
(225u16,225u8),(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),
(230u16,230u8),(233u16,233u8),(235u16,235u8),(237u16,237u8),(238u16,238u8),
(239u16,239u8),(240u16,240u8),(243u16,243u8),(244u16,244u8),(245u16,245u8),
(246u16,246u8),(248u16,248u8),(250u16,250u8),(251u16,251u8),(252u16,252u8),
(253u16,253u8),(254u16,254u8),(256u16,192u8),(257u16,224u8),(260u16,161u8),
(261u16,177u8),(268u16,200u8),(269u16,232u8),(272u16,169u8),(273u16,185u8),
(274u16,162u8),(275u16,178u8),(278u16,204u8),(279u16,236u8),(280u16,202u8),
(281u16,234u8),(290u16,163u8),(291u16,179u8),(296u16,165u8),(297u16,181u8),
(298u16,164u8),(299u16,180u8),(302u16,199u8),(303u16,231u8),(310u16,166u8),
(311u16,182u8),(312u16,255u8),(315u16,168u8),(316u16,184u8),(325u16,209u8),
(326u16,241u8),(330u16,175u8),(331u16,191u8),(332u16,210u8),(333u16,242u8),
(352u16,170u8),(353u16,186u8),(358u16,171u8),(359u16,187u8),(360u16,215u8),
(361u16,247u8),(362u16,174u8),(363u16,190u8),(370u16,217u8),(371u16,249u8),
(381u16,172u8),(382u16,188u8),(8213u16,189u8),
]

const ISO885913Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,8221,162,163,164,
8222,166,167,216,169,342,171,172,173,174,198,176,177,178,179,8220,181,182,183,
248,185,343,187,188,189,190,230,260,302,256,262,196,197,280,274,268,201,377,278,
290,310,298,315,352,323,325,211,332,213,214,215,370,321,346,362,220,379,381,223,
261,303,257,263,228,229,281,275,269,233,378,279,291,311,299,316,353,324,326,243,
333,245,246,247,371,322,347,363,252,380,382,8217,
]
const ISO885913Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(162u16,162u8),(163u16,163u8),
(164u16,164u8),(166u16,166u8),(167u16,167u8),(169u16,169u8),(171u16,171u8),
(172u16,172u8),(173u16,173u8),(174u16,174u8),(176u16,176u8),(177u16,177u8),
(178u16,178u8),(179u16,179u8),(181u16,181u8),(182u16,182u8),(183u16,183u8),
(185u16,185u8),(187u16,187u8),(188u16,188u8),(189u16,189u8),(190u16,190u8),
(196u16,196u8),(197u16,197u8),(198u16,175u8),(201u16,201u8),(211u16,211u8),
(213u16,213u8),(214u16,214u8),(215u16,215u8),(216u16,168u8),(220u16,220u8),
(223u16,223u8),(228u16,228u8),(229u16,229u8),(230u16,191u8),(233u16,233u8),
(243u16,243u8),(245u16,245u8),(246u16,246u8),(247u16,247u8),(248u16,184u8),
(252u16,252u8),(256u16,194u8),(257u16,226u8),(260u16,192u8),(261u16,224u8),
(262u16,195u8),(263u16,227u8),(268u16,200u8),(269u16,232u8),(274u16,199u8),
(275u16,231u8),(278u16,203u8),(279u16,235u8),(280u16,198u8),(281u16,230u8),
(290u16,204u8),(291u16,236u8),(298u16,206u8),(299u16,238u8),(302u16,193u8),
(303u16,225u8),(310u16,205u8),(311u16,237u8),(315u16,207u8),(316u16,239u8),
(321u16,217u8),(322u16,249u8),(323u16,209u8),(324u16,241u8),(325u16,210u8),
(326u16,242u8),(332u16,212u8),(333u16,244u8),(342u16,170u8),(343u16,186u8),
(346u16,218u8),(347u16,250u8),(352u16,208u8),(353u16,240u8),(362u16,219u8),
(363u16,251u8),(370u16,216u8),(371u16,248u8),(377u16,202u8),(378u16,234u8),
(379u16,221u8),(380u16,253u8),(381u16,222u8),(382u16,254u8),(8217u16,255u8),
(8220u16,180u8),(8221u16,161u8),(8222u16,165u8),
]

const ISO885914Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,7682,7683,163,266,
267,7690,167,7808,169,7810,7691,7922,173,174,376,7710,7711,288,289,7744,7745,
182,7766,7809,7767,7811,7776,7923,7812,7813,7777,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,372,209,210,211,212,213,214,7786,216,217,
218,219,220,221,374,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,
238,239,373,241,242,243,244,245,246,7787,248,249,250,251,252,253,375,255,
]
const ISO885914Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(163u16,163u8),(167u16,167u8),
(169u16,169u8),(173u16,173u8),(174u16,174u8),(182u16,182u8),(192u16,192u8),
(193u16,193u8),(194u16,194u8),(195u16,195u8),(196u16,196u8),(197u16,197u8),
(198u16,198u8),(199u16,199u8),(200u16,200u8),(201u16,201u8),(202u16,202u8),
(203u16,203u8),(204u16,204u8),(205u16,205u8),(206u16,206u8),(207u16,207u8),
(209u16,209u8),(210u16,210u8),(211u16,211u8),(212u16,212u8),(213u16,213u8),
(214u16,214u8),(216u16,216u8),(217u16,217u8),(218u16,218u8),(219u16,219u8),
(220u16,220u8),(221u16,221u8),(223u16,223u8),(224u16,224u8),(225u16,225u8),
(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),(230u16,230u8),
(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),(235u16,235u8),
(236u16,236u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),(241u16,241u8),
(242u16,242u8),(243u16,243u8),(244u16,244u8),(245u16,245u8),(246u16,246u8),
(248u16,248u8),(249u16,249u8),(250u16,250u8),(251u16,251u8),(252u16,252u8),
(253u16,253u8),(255u16,255u8),(266u16,164u8),(267u16,165u8),(288u16,178u8),
(289u16,179u8),(372u16,208u8),(373u16,240u8),(374u16,222u8),(375u16,254u8),
(376u16,175u8),(7682u16,161u8),(7683u16,162u8),(7690u16,166u8),(7691u16,171u8),
(7710u16,176u8),(7711u16,177u8),(7744u16,180u8),(7745u16,181u8),(7766u16,183u8),
(7767u16,185u8),(7776u16,187u8),(7777u16,191u8),(7786u16,215u8),(7787u16,247u8),
(7808u16,168u8),(7809u16,184u8),(7810u16,170u8),(7811u16,186u8),(7812u16,189u8),
(7813u16,190u8),(7922u16,172u8),(7923u16,188u8),
]

const ISO885915Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,8364,
165,352,167,353,169,170,171,172,173,174,175,176,177,178,179,381,181,182,183,382,
185,186,187,338,339,376,191,192,193,194,195,196,197,198,199,200,201,202,203,204,
205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,
225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,
245,246,247,248,249,250,251,252,253,254,255,
]
const ISO885915Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(161u16,161u8),(162u16,162u8),
(163u16,163u8),(165u16,165u8),(167u16,167u8),(169u16,169u8),(170u16,170u8),
(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),(175u16,175u8),
(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),(181u16,181u8),
(182u16,182u8),(183u16,183u8),(185u16,185u8),(186u16,186u8),(187u16,187u8),
(191u16,191u8),(192u16,192u8),(193u16,193u8),(194u16,194u8),(195u16,195u8),
(196u16,196u8),(197u16,197u8),(198u16,198u8),(199u16,199u8),(200u16,200u8),
(201u16,201u8),(202u16,202u8),(203u16,203u8),(204u16,204u8),(205u16,205u8),
(206u16,206u8),(207u16,207u8),(208u16,208u8),(209u16,209u8),(210u16,210u8),
(211u16,211u8),(212u16,212u8),(213u16,213u8),(214u16,214u8),(215u16,215u8),
(216u16,216u8),(217u16,217u8),(218u16,218u8),(219u16,219u8),(220u16,220u8),
(221u16,221u8),(222u16,222u8),(223u16,223u8),(224u16,224u8),(225u16,225u8),
(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),(230u16,230u8),
(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),(235u16,235u8),
(236u16,236u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),(240u16,240u8),
(241u16,241u8),(242u16,242u8),(243u16,243u8),(244u16,244u8),(245u16,245u8),
(246u16,246u8),(247u16,247u8),(248u16,248u8),(249u16,249u8),(250u16,250u8),
(251u16,251u8),(252u16,252u8),(253u16,253u8),(254u16,254u8),(255u16,255u8),
(338u16,188u8),(339u16,189u8),(352u16,166u8),(353u16,168u8),(376u16,190u8),
(381u16,180u8),(382u16,184u8),(8364u16,164u8),
]

const ISO885916Decode*: array[128, uint16] = [
uint16 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,
146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,260,261,321,8364,
8222,352,167,353,169,536,171,377,173,378,379,176,177,268,322,381,8221,182,183,
382,269,537,187,338,339,376,380,192,193,194,258,196,262,198,199,200,201,202,203,
204,205,206,207,272,323,210,211,212,336,214,346,368,217,218,219,220,280,538,223,
224,225,226,259,228,263,230,231,232,233,234,235,236,237,238,239,273,324,242,243,
244,337,246,347,369,249,250,251,252,281,539,255,
]
const ISO885916Encode*: array[128, UCS16x8] = [
(128u16,128u8),(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),
(133u16,133u8),(134u16,134u8),(135u16,135u8),(136u16,136u8),(137u16,137u8),
(138u16,138u8),(139u16,139u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(145u16,145u8),(146u16,146u8),(147u16,147u8),
(148u16,148u8),(149u16,149u8),(150u16,150u8),(151u16,151u8),(152u16,152u8),
(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(167u16,167u8),(169u16,169u8),
(171u16,171u8),(173u16,173u8),(176u16,176u8),(177u16,177u8),(182u16,182u8),
(183u16,183u8),(187u16,187u8),(192u16,192u8),(193u16,193u8),(194u16,194u8),
(196u16,196u8),(198u16,198u8),(199u16,199u8),(200u16,200u8),(201u16,201u8),
(202u16,202u8),(203u16,203u8),(204u16,204u8),(205u16,205u8),(206u16,206u8),
(207u16,207u8),(210u16,210u8),(211u16,211u8),(212u16,212u8),(214u16,214u8),
(217u16,217u8),(218u16,218u8),(219u16,219u8),(220u16,220u8),(223u16,223u8),
(224u16,224u8),(225u16,225u8),(226u16,226u8),(228u16,228u8),(230u16,230u8),
(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),(235u16,235u8),
(236u16,236u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),(242u16,242u8),
(243u16,243u8),(244u16,244u8),(246u16,246u8),(249u16,249u8),(250u16,250u8),
(251u16,251u8),(252u16,252u8),(255u16,255u8),(258u16,195u8),(259u16,227u8),
(260u16,161u8),(261u16,162u8),(262u16,197u8),(263u16,229u8),(268u16,178u8),
(269u16,185u8),(272u16,208u8),(273u16,240u8),(280u16,221u8),(281u16,253u8),
(321u16,163u8),(322u16,179u8),(323u16,209u8),(324u16,241u8),(336u16,213u8),
(337u16,245u8),(338u16,188u8),(339u16,189u8),(346u16,215u8),(347u16,247u8),
(352u16,166u8),(353u16,168u8),(368u16,216u8),(369u16,248u8),(376u16,190u8),
(377u16,172u8),(378u16,174u8),(379u16,175u8),(380u16,191u8),(381u16,180u8),
(382u16,184u8),(536u16,170u8),(537u16,186u8),(538u16,222u8),(539u16,254u8),
(8221u16,181u8),(8222u16,165u8),(8364u16,164u8),
]

const KOI8RDecode*: array[128, uint16] = [
uint16 9472,9474,9484,9488,9492,9496,9500,9508,9516,9524,9532,9600,9604,9608,
9612,9616,9617,9618,9619,8992,9632,8729,8730,8776,8804,8805,160,8993,176,178,
183,247,9552,9553,9554,1105,9555,9556,9557,9558,9559,9560,9561,9562,9563,9564,
9565,9566,9567,9568,9569,1025,9570,9571,9572,9573,9574,9575,9576,9577,9578,9579,
9580,169,1102,1072,1073,1094,1076,1077,1092,1075,1093,1080,1081,1082,1083,1084,
1085,1086,1087,1103,1088,1089,1090,1091,1078,1074,1100,1099,1079,1096,1101,1097,
1095,1098,1070,1040,1041,1062,1044,1045,1060,1043,1061,1048,1049,1050,1051,1052,
1053,1054,1055,1071,1056,1057,1058,1059,1046,1042,1068,1067,1047,1064,1069,1065,
1063,1066,
]
const KOI8REncode*: array[128, UCS16x8] = [
(160u16,154u8),(169u16,191u8),(176u16,156u8),(178u16,157u8),(183u16,158u8),
(247u16,159u8),(1025u16,179u8),(1040u16,225u8),(1041u16,226u8),(1042u16,247u8),
(1043u16,231u8),(1044u16,228u8),(1045u16,229u8),(1046u16,246u8),(1047u16,250u8),
(1048u16,233u8),(1049u16,234u8),(1050u16,235u8),(1051u16,236u8),(1052u16,237u8),
(1053u16,238u8),(1054u16,239u8),(1055u16,240u8),(1056u16,242u8),(1057u16,243u8),
(1058u16,244u8),(1059u16,245u8),(1060u16,230u8),(1061u16,232u8),(1062u16,227u8),
(1063u16,254u8),(1064u16,251u8),(1065u16,253u8),(1066u16,255u8),(1067u16,249u8),
(1068u16,248u8),(1069u16,252u8),(1070u16,224u8),(1071u16,241u8),(1072u16,193u8),
(1073u16,194u8),(1074u16,215u8),(1075u16,199u8),(1076u16,196u8),(1077u16,197u8),
(1078u16,214u8),(1079u16,218u8),(1080u16,201u8),(1081u16,202u8),(1082u16,203u8),
(1083u16,204u8),(1084u16,205u8),(1085u16,206u8),(1086u16,207u8),(1087u16,208u8),
(1088u16,210u8),(1089u16,211u8),(1090u16,212u8),(1091u16,213u8),(1092u16,198u8),
(1093u16,200u8),(1094u16,195u8),(1095u16,222u8),(1096u16,219u8),(1097u16,221u8),
(1098u16,223u8),(1099u16,217u8),(1100u16,216u8),(1101u16,220u8),(1102u16,192u8),
(1103u16,209u8),(1105u16,163u8),(8729u16,149u8),(8730u16,150u8),(8776u16,151u8),
(8804u16,152u8),(8805u16,153u8),(8992u16,147u8),(8993u16,155u8),(9472u16,128u8),
(9474u16,129u8),(9484u16,130u8),(9488u16,131u8),(9492u16,132u8),(9496u16,133u8),
(9500u16,134u8),(9508u16,135u8),(9516u16,136u8),(9524u16,137u8),(9532u16,138u8),
(9552u16,160u8),(9553u16,161u8),(9554u16,162u8),(9555u16,164u8),(9556u16,165u8),
(9557u16,166u8),(9558u16,167u8),(9559u16,168u8),(9560u16,169u8),(9561u16,170u8),
(9562u16,171u8),(9563u16,172u8),(9564u16,173u8),(9565u16,174u8),(9566u16,175u8),
(9567u16,176u8),(9568u16,177u8),(9569u16,178u8),(9570u16,180u8),(9571u16,181u8),
(9572u16,182u8),(9573u16,183u8),(9574u16,184u8),(9575u16,185u8),(9576u16,186u8),
(9577u16,187u8),(9578u16,188u8),(9579u16,189u8),(9580u16,190u8),(9600u16,139u8),
(9604u16,140u8),(9608u16,141u8),(9612u16,142u8),(9616u16,143u8),(9617u16,144u8),
(9618u16,145u8),(9619u16,146u8),(9632u16,148u8),
]

const KOI8UDecode*: array[128, uint16] = [
uint16 9472,9474,9484,9488,9492,9496,9500,9508,9516,9524,9532,9600,9604,9608,
9612,9616,9617,9618,9619,8992,9632,8729,8730,8776,8804,8805,160,8993,176,178,
183,247,9552,9553,9554,1105,1108,9556,1110,1111,9559,9560,9561,9562,9563,1169,
1118,9566,9567,9568,9569,1025,1028,9571,1030,1031,9574,9575,9576,9577,9578,1168,
1038,169,1102,1072,1073,1094,1076,1077,1092,1075,1093,1080,1081,1082,1083,1084,
1085,1086,1087,1103,1088,1089,1090,1091,1078,1074,1100,1099,1079,1096,1101,1097,
1095,1098,1070,1040,1041,1062,1044,1045,1060,1043,1061,1048,1049,1050,1051,1052,
1053,1054,1055,1071,1056,1057,1058,1059,1046,1042,1068,1067,1047,1064,1069,1065,
1063,1066,
]
const KOI8UEncode*: array[128, UCS16x8] = [
(160u16,154u8),(169u16,191u8),(176u16,156u8),(178u16,157u8),(183u16,158u8),
(247u16,159u8),(1025u16,179u8),(1028u16,180u8),(1030u16,182u8),(1031u16,183u8),
(1038u16,190u8),(1040u16,225u8),(1041u16,226u8),(1042u16,247u8),(1043u16,231u8),
(1044u16,228u8),(1045u16,229u8),(1046u16,246u8),(1047u16,250u8),(1048u16,233u8),
(1049u16,234u8),(1050u16,235u8),(1051u16,236u8),(1052u16,237u8),(1053u16,238u8),
(1054u16,239u8),(1055u16,240u8),(1056u16,242u8),(1057u16,243u8),(1058u16,244u8),
(1059u16,245u8),(1060u16,230u8),(1061u16,232u8),(1062u16,227u8),(1063u16,254u8),
(1064u16,251u8),(1065u16,253u8),(1066u16,255u8),(1067u16,249u8),(1068u16,248u8),
(1069u16,252u8),(1070u16,224u8),(1071u16,241u8),(1072u16,193u8),(1073u16,194u8),
(1074u16,215u8),(1075u16,199u8),(1076u16,196u8),(1077u16,197u8),(1078u16,214u8),
(1079u16,218u8),(1080u16,201u8),(1081u16,202u8),(1082u16,203u8),(1083u16,204u8),
(1084u16,205u8),(1085u16,206u8),(1086u16,207u8),(1087u16,208u8),(1088u16,210u8),
(1089u16,211u8),(1090u16,212u8),(1091u16,213u8),(1092u16,198u8),(1093u16,200u8),
(1094u16,195u8),(1095u16,222u8),(1096u16,219u8),(1097u16,221u8),(1098u16,223u8),
(1099u16,217u8),(1100u16,216u8),(1101u16,220u8),(1102u16,192u8),(1103u16,209u8),
(1105u16,163u8),(1108u16,164u8),(1110u16,166u8),(1111u16,167u8),(1118u16,174u8),
(1168u16,189u8),(1169u16,173u8),(8729u16,149u8),(8730u16,150u8),(8776u16,151u8),
(8804u16,152u8),(8805u16,153u8),(8992u16,147u8),(8993u16,155u8),(9472u16,128u8),
(9474u16,129u8),(9484u16,130u8),(9488u16,131u8),(9492u16,132u8),(9496u16,133u8),
(9500u16,134u8),(9508u16,135u8),(9516u16,136u8),(9524u16,137u8),(9532u16,138u8),
(9552u16,160u8),(9553u16,161u8),(9554u16,162u8),(9556u16,165u8),(9559u16,168u8),
(9560u16,169u8),(9561u16,170u8),(9562u16,171u8),(9563u16,172u8),(9566u16,175u8),
(9567u16,176u8),(9568u16,177u8),(9569u16,178u8),(9571u16,181u8),(9574u16,184u8),
(9575u16,185u8),(9576u16,186u8),(9577u16,187u8),(9578u16,188u8),(9600u16,139u8),
(9604u16,140u8),(9608u16,141u8),(9612u16,142u8),(9616u16,143u8),(9617u16,144u8),
(9618u16,145u8),(9619u16,146u8),(9632u16,148u8),
]

const MacintoshDecode*: array[128, uint16] = [
uint16 196,197,199,201,209,214,220,225,224,226,228,227,229,231,233,232,234,235,
237,236,238,239,241,243,242,244,246,245,250,249,251,252,8224,176,162,163,167,
8226,182,223,174,169,8482,180,168,8800,198,216,8734,177,8804,8805,165,181,8706,
8721,8719,960,8747,170,186,937,230,248,191,161,172,8730,402,8776,8710,171,187,
8230,160,192,195,213,338,339,8211,8212,8220,8221,8216,8217,247,9674,255,376,
8260,8364,8249,8250,64257,64258,8225,183,8218,8222,8240,194,202,193,203,200,205,
206,207,204,211,212,63743,210,218,219,217,305,710,732,175,728,729,730,184,733,
731,711,
]
const MacintoshEncode*: array[128, UCS16x8] = [
(160u16,202u8),(161u16,193u8),(162u16,162u8),(163u16,163u8),(165u16,180u8),
(167u16,164u8),(168u16,172u8),(169u16,169u8),(170u16,187u8),(171u16,199u8),
(172u16,194u8),(174u16,168u8),(175u16,248u8),(176u16,161u8),(177u16,177u8),
(180u16,171u8),(181u16,181u8),(182u16,166u8),(183u16,225u8),(184u16,252u8),
(186u16,188u8),(187u16,200u8),(191u16,192u8),(192u16,203u8),(193u16,231u8),
(194u16,229u8),(195u16,204u8),(196u16,128u8),(197u16,129u8),(198u16,174u8),
(199u16,130u8),(200u16,233u8),(201u16,131u8),(202u16,230u8),(203u16,232u8),
(204u16,237u8),(205u16,234u8),(206u16,235u8),(207u16,236u8),(209u16,132u8),
(210u16,241u8),(211u16,238u8),(212u16,239u8),(213u16,205u8),(214u16,133u8),
(216u16,175u8),(217u16,244u8),(218u16,242u8),(219u16,243u8),(220u16,134u8),
(223u16,167u8),(224u16,136u8),(225u16,135u8),(226u16,137u8),(227u16,139u8),
(228u16,138u8),(229u16,140u8),(230u16,190u8),(231u16,141u8),(232u16,143u8),
(233u16,142u8),(234u16,144u8),(235u16,145u8),(236u16,147u8),(237u16,146u8),
(238u16,148u8),(239u16,149u8),(241u16,150u8),(242u16,152u8),(243u16,151u8),
(244u16,153u8),(245u16,155u8),(246u16,154u8),(247u16,214u8),(248u16,191u8),
(249u16,157u8),(250u16,156u8),(251u16,158u8),(252u16,159u8),(255u16,216u8),
(305u16,245u8),(338u16,206u8),(339u16,207u8),(376u16,217u8),(402u16,196u8),
(710u16,246u8),(711u16,255u8),(728u16,249u8),(729u16,250u8),(730u16,251u8),
(731u16,254u8),(732u16,247u8),(733u16,253u8),(937u16,189u8),(960u16,185u8),
(8211u16,208u8),(8212u16,209u8),(8216u16,212u8),(8217u16,213u8),(8218u16,226u8),
(8220u16,210u8),(8221u16,211u8),(8222u16,227u8),(8224u16,160u8),(8225u16,224u8),
(8226u16,165u8),(8230u16,201u8),(8240u16,228u8),(8249u16,220u8),(8250u16,221u8),
(8260u16,218u8),(8364u16,219u8),(8482u16,170u8),(8706u16,182u8),(8710u16,198u8),
(8719u16,184u8),(8721u16,183u8),(8730u16,195u8),(8734u16,176u8),(8747u16,186u8),
(8776u16,197u8),(8800u16,173u8),(8804u16,178u8),(8805u16,179u8),(9674u16,215u8),
(63743u16,240u8),(64257u16,222u8),(64258u16,223u8),
]

const Windows874Decode*: array[124, uint16] = [
uint16 8364,129,130,131,132,8230,134,135,136,137,138,139,140,141,142,143,144,
8216,8217,8220,8221,8226,8211,8212,152,153,154,155,156,157,158,159,160,3585,
3586,3587,3588,3589,3590,3591,3592,3593,3594,3595,3596,3597,3598,3599,3600,3601,
3602,3603,3604,3605,3606,3607,3608,3609,3610,3611,3612,3613,3614,3615,3616,3617,
3618,3619,3620,3621,3622,3623,3624,3625,3626,3627,3628,3629,3630,3631,3632,3633,
3634,3635,3636,3637,3638,3639,3640,3641,3642,0,0,0,0,3647,3648,3649,3650,3651,
3652,3653,3654,3655,3656,3657,3658,3659,3660,3661,3662,3663,3664,3665,3666,3667,
3668,3669,3670,3671,3672,3673,3674,3675,
]
const Windows874Encode*: array[120, UCS16x8] = [
(129u16,129u8),(130u16,130u8),(131u16,131u8),(132u16,132u8),(134u16,134u8),
(135u16,135u8),(136u16,136u8),(137u16,137u8),(138u16,138u8),(139u16,139u8),
(140u16,140u8),(141u16,141u8),(142u16,142u8),(143u16,143u8),(144u16,144u8),
(152u16,152u8),(153u16,153u8),(154u16,154u8),(155u16,155u8),(156u16,156u8),
(157u16,157u8),(158u16,158u8),(159u16,159u8),(160u16,160u8),(3585u16,161u8),
(3586u16,162u8),(3587u16,163u8),(3588u16,164u8),(3589u16,165u8),(3590u16,166u8),
(3591u16,167u8),(3592u16,168u8),(3593u16,169u8),(3594u16,170u8),(3595u16,171u8),
(3596u16,172u8),(3597u16,173u8),(3598u16,174u8),(3599u16,175u8),(3600u16,176u8),
(3601u16,177u8),(3602u16,178u8),(3603u16,179u8),(3604u16,180u8),(3605u16,181u8),
(3606u16,182u8),(3607u16,183u8),(3608u16,184u8),(3609u16,185u8),(3610u16,186u8),
(3611u16,187u8),(3612u16,188u8),(3613u16,189u8),(3614u16,190u8),(3615u16,191u8),
(3616u16,192u8),(3617u16,193u8),(3618u16,194u8),(3619u16,195u8),(3620u16,196u8),
(3621u16,197u8),(3622u16,198u8),(3623u16,199u8),(3624u16,200u8),(3625u16,201u8),
(3626u16,202u8),(3627u16,203u8),(3628u16,204u8),(3629u16,205u8),(3630u16,206u8),
(3631u16,207u8),(3632u16,208u8),(3633u16,209u8),(3634u16,210u8),(3635u16,211u8),
(3636u16,212u8),(3637u16,213u8),(3638u16,214u8),(3639u16,215u8),(3640u16,216u8),
(3641u16,217u8),(3642u16,218u8),(3647u16,223u8),(3648u16,224u8),(3649u16,225u8),
(3650u16,226u8),(3651u16,227u8),(3652u16,228u8),(3653u16,229u8),(3654u16,230u8),
(3655u16,231u8),(3656u16,232u8),(3657u16,233u8),(3658u16,234u8),(3659u16,235u8),
(3660u16,236u8),(3661u16,237u8),(3662u16,238u8),(3663u16,239u8),(3664u16,240u8),
(3665u16,241u8),(3666u16,242u8),(3667u16,243u8),(3668u16,244u8),(3669u16,245u8),
(3670u16,246u8),(3671u16,247u8),(3672u16,248u8),(3673u16,249u8),(3674u16,250u8),
(3675u16,251u8),(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),
(8220u16,147u8),(8221u16,148u8),(8226u16,149u8),(8230u16,133u8),(8364u16,128u8),
]

const Windows1250Decode*: array[128, uint16] = [
uint16 8364,129,8218,131,8222,8230,8224,8225,136,8240,352,8249,346,356,381,377,
144,8216,8217,8220,8221,8226,8211,8212,152,8482,353,8250,347,357,382,378,160,
711,728,321,164,260,166,167,168,169,350,171,172,173,174,379,176,177,731,322,180,
181,182,183,184,261,351,187,317,733,318,380,340,193,194,258,196,313,262,199,268,
201,280,203,282,205,206,270,272,323,327,211,212,336,214,215,344,366,218,368,220,
221,354,223,341,225,226,259,228,314,263,231,269,233,281,235,283,237,238,271,273,
324,328,243,244,337,246,247,345,367,250,369,252,253,355,729,
]
const Windows1250Encode*: array[128, UCS16x8] = [
(129u16,129u8),(131u16,131u8),(136u16,136u8),(144u16,144u8),(152u16,152u8),
(160u16,160u8),(164u16,164u8),(166u16,166u8),(167u16,167u8),(168u16,168u8),
(169u16,169u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),
(176u16,176u8),(177u16,177u8),(180u16,180u8),(181u16,181u8),(182u16,182u8),
(183u16,183u8),(184u16,184u8),(187u16,187u8),(193u16,193u8),(194u16,194u8),
(196u16,196u8),(199u16,199u8),(201u16,201u8),(203u16,203u8),(205u16,205u8),
(206u16,206u8),(211u16,211u8),(212u16,212u8),(214u16,214u8),(215u16,215u8),
(218u16,218u8),(220u16,220u8),(221u16,221u8),(223u16,223u8),(225u16,225u8),
(226u16,226u8),(228u16,228u8),(231u16,231u8),(233u16,233u8),(235u16,235u8),
(237u16,237u8),(238u16,238u8),(243u16,243u8),(244u16,244u8),(246u16,246u8),
(247u16,247u8),(250u16,250u8),(252u16,252u8),(253u16,253u8),(258u16,195u8),
(259u16,227u8),(260u16,165u8),(261u16,185u8),(262u16,198u8),(263u16,230u8),
(268u16,200u8),(269u16,232u8),(270u16,207u8),(271u16,239u8),(272u16,208u8),
(273u16,240u8),(280u16,202u8),(281u16,234u8),(282u16,204u8),(283u16,236u8),
(313u16,197u8),(314u16,229u8),(317u16,188u8),(318u16,190u8),(321u16,163u8),
(322u16,179u8),(323u16,209u8),(324u16,241u8),(327u16,210u8),(328u16,242u8),
(336u16,213u8),(337u16,245u8),(340u16,192u8),(341u16,224u8),(344u16,216u8),
(345u16,248u8),(346u16,140u8),(347u16,156u8),(350u16,170u8),(351u16,186u8),
(352u16,138u8),(353u16,154u8),(354u16,222u8),(355u16,254u8),(356u16,141u8),
(357u16,157u8),(366u16,217u8),(367u16,249u8),(368u16,219u8),(369u16,251u8),
(377u16,143u8),(378u16,159u8),(379u16,175u8),(380u16,191u8),(381u16,142u8),
(382u16,158u8),(711u16,161u8),(728u16,162u8),(729u16,255u8),(731u16,178u8),
(733u16,189u8),(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),
(8218u16,130u8),(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),
(8225u16,135u8),(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),
(8250u16,155u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1251Decode*: array[128, uint16] = [
uint16 1026,1027,8218,1107,8222,8230,8224,8225,8364,8240,1033,8249,1034,1036,
1035,1039,1106,8216,8217,8220,8221,8226,8211,8212,152,8482,1113,8250,1114,1116,
1115,1119,160,1038,1118,1032,164,1168,166,167,1025,169,1028,171,172,173,174,
1031,176,177,1030,1110,1169,181,182,183,1105,8470,1108,187,1112,1029,1109,1111,
1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,
1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,
1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,
1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,
]
const Windows1251Encode*: array[128, UCS16x8] = [
(152u16,152u8),(160u16,160u8),(164u16,164u8),(166u16,166u8),(167u16,167u8),
(169u16,169u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),
(176u16,176u8),(177u16,177u8),(181u16,181u8),(182u16,182u8),(183u16,183u8),
(187u16,187u8),(1025u16,168u8),(1026u16,128u8),(1027u16,129u8),(1028u16,170u8),
(1029u16,189u8),(1030u16,178u8),(1031u16,175u8),(1032u16,163u8),(1033u16,138u8),
(1034u16,140u8),(1035u16,142u8),(1036u16,141u8),(1038u16,161u8),(1039u16,143u8),
(1040u16,192u8),(1041u16,193u8),(1042u16,194u8),(1043u16,195u8),(1044u16,196u8),
(1045u16,197u8),(1046u16,198u8),(1047u16,199u8),(1048u16,200u8),(1049u16,201u8),
(1050u16,202u8),(1051u16,203u8),(1052u16,204u8),(1053u16,205u8),(1054u16,206u8),
(1055u16,207u8),(1056u16,208u8),(1057u16,209u8),(1058u16,210u8),(1059u16,211u8),
(1060u16,212u8),(1061u16,213u8),(1062u16,214u8),(1063u16,215u8),(1064u16,216u8),
(1065u16,217u8),(1066u16,218u8),(1067u16,219u8),(1068u16,220u8),(1069u16,221u8),
(1070u16,222u8),(1071u16,223u8),(1072u16,224u8),(1073u16,225u8),(1074u16,226u8),
(1075u16,227u8),(1076u16,228u8),(1077u16,229u8),(1078u16,230u8),(1079u16,231u8),
(1080u16,232u8),(1081u16,233u8),(1082u16,234u8),(1083u16,235u8),(1084u16,236u8),
(1085u16,237u8),(1086u16,238u8),(1087u16,239u8),(1088u16,240u8),(1089u16,241u8),
(1090u16,242u8),(1091u16,243u8),(1092u16,244u8),(1093u16,245u8),(1094u16,246u8),
(1095u16,247u8),(1096u16,248u8),(1097u16,249u8),(1098u16,250u8),(1099u16,251u8),
(1100u16,252u8),(1101u16,253u8),(1102u16,254u8),(1103u16,255u8),(1105u16,184u8),
(1106u16,144u8),(1107u16,131u8),(1108u16,186u8),(1109u16,190u8),(1110u16,179u8),
(1111u16,191u8),(1112u16,188u8),(1113u16,154u8),(1114u16,156u8),(1115u16,158u8),
(1116u16,157u8),(1118u16,162u8),(1119u16,159u8),(1168u16,165u8),(1169u16,180u8),
(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),(8218u16,130u8),
(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),(8225u16,135u8),
(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),(8250u16,155u8),
(8364u16,136u8),(8470u16,185u8),(8482u16,153u8),
]

const Windows1252Decode*: array[128, uint16] = [
uint16 8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,381,143,
144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,382,376,160,
161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,
181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,
221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,
241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
]
const Windows1252Encode*: array[128, UCS16x8] = [
(129u16,129u8),(141u16,141u8),(143u16,143u8),(144u16,144u8),(157u16,157u8),
(160u16,160u8),(161u16,161u8),(162u16,162u8),(163u16,163u8),(164u16,164u8),
(165u16,165u8),(166u16,166u8),(167u16,167u8),(168u16,168u8),(169u16,169u8),
(170u16,170u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),
(175u16,175u8),(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),
(180u16,180u8),(181u16,181u8),(182u16,182u8),(183u16,183u8),(184u16,184u8),
(185u16,185u8),(186u16,186u8),(187u16,187u8),(188u16,188u8),(189u16,189u8),
(190u16,190u8),(191u16,191u8),(192u16,192u8),(193u16,193u8),(194u16,194u8),
(195u16,195u8),(196u16,196u8),(197u16,197u8),(198u16,198u8),(199u16,199u8),
(200u16,200u8),(201u16,201u8),(202u16,202u8),(203u16,203u8),(204u16,204u8),
(205u16,205u8),(206u16,206u8),(207u16,207u8),(208u16,208u8),(209u16,209u8),
(210u16,210u8),(211u16,211u8),(212u16,212u8),(213u16,213u8),(214u16,214u8),
(215u16,215u8),(216u16,216u8),(217u16,217u8),(218u16,218u8),(219u16,219u8),
(220u16,220u8),(221u16,221u8),(222u16,222u8),(223u16,223u8),(224u16,224u8),
(225u16,225u8),(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),
(230u16,230u8),(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),
(235u16,235u8),(236u16,236u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),
(240u16,240u8),(241u16,241u8),(242u16,242u8),(243u16,243u8),(244u16,244u8),
(245u16,245u8),(246u16,246u8),(247u16,247u8),(248u16,248u8),(249u16,249u8),
(250u16,250u8),(251u16,251u8),(252u16,252u8),(253u16,253u8),(254u16,254u8),
(255u16,255u8),(338u16,140u8),(339u16,156u8),(352u16,138u8),(353u16,154u8),
(376u16,159u8),(381u16,142u8),(382u16,158u8),(402u16,131u8),(710u16,136u8),
(732u16,152u8),(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),
(8218u16,130u8),(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),
(8225u16,135u8),(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),
(8250u16,155u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1253Decode*: array[127, uint16] = [
uint16 8364,129,8218,402,8222,8230,8224,8225,136,8240,138,8249,140,141,142,143,
144,8216,8217,8220,8221,8226,8211,8212,152,8482,154,8250,156,157,158,159,160,
901,902,163,164,165,166,167,168,169,0,171,172,173,174,8213,176,177,178,179,900,
181,182,183,904,905,906,187,908,189,910,911,912,913,914,915,916,917,918,919,920,
921,922,923,924,925,926,927,928,929,0,931,932,933,934,935,936,937,938,939,940,
941,942,943,944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,
961,962,963,964,965,966,967,968,969,970,971,972,973,974,
]
const Windows1253Encode*: array[125, UCS16x8] = [
(129u16,129u8),(136u16,136u8),(138u16,138u8),(140u16,140u8),(141u16,141u8),
(142u16,142u8),(143u16,143u8),(144u16,144u8),(152u16,152u8),(154u16,154u8),
(156u16,156u8),(157u16,157u8),(158u16,158u8),(159u16,159u8),(160u16,160u8),
(163u16,163u8),(164u16,164u8),(165u16,165u8),(166u16,166u8),(167u16,167u8),
(168u16,168u8),(169u16,169u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),
(174u16,174u8),(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),
(181u16,181u8),(182u16,182u8),(183u16,183u8),(187u16,187u8),(189u16,189u8),
(402u16,131u8),(900u16,180u8),(901u16,161u8),(902u16,162u8),(904u16,184u8),
(905u16,185u8),(906u16,186u8),(908u16,188u8),(910u16,190u8),(911u16,191u8),
(912u16,192u8),(913u16,193u8),(914u16,194u8),(915u16,195u8),(916u16,196u8),
(917u16,197u8),(918u16,198u8),(919u16,199u8),(920u16,200u8),(921u16,201u8),
(922u16,202u8),(923u16,203u8),(924u16,204u8),(925u16,205u8),(926u16,206u8),
(927u16,207u8),(928u16,208u8),(929u16,209u8),(931u16,211u8),(932u16,212u8),
(933u16,213u8),(934u16,214u8),(935u16,215u8),(936u16,216u8),(937u16,217u8),
(938u16,218u8),(939u16,219u8),(940u16,220u8),(941u16,221u8),(942u16,222u8),
(943u16,223u8),(944u16,224u8),(945u16,225u8),(946u16,226u8),(947u16,227u8),
(948u16,228u8),(949u16,229u8),(950u16,230u8),(951u16,231u8),(952u16,232u8),
(953u16,233u8),(954u16,234u8),(955u16,235u8),(956u16,236u8),(957u16,237u8),
(958u16,238u8),(959u16,239u8),(960u16,240u8),(961u16,241u8),(962u16,242u8),
(963u16,243u8),(964u16,244u8),(965u16,245u8),(966u16,246u8),(967u16,247u8),
(968u16,248u8),(969u16,249u8),(970u16,250u8),(971u16,251u8),(972u16,252u8),
(973u16,253u8),(974u16,254u8),(8211u16,150u8),(8212u16,151u8),(8213u16,175u8),
(8216u16,145u8),(8217u16,146u8),(8218u16,130u8),(8220u16,147u8),(8221u16,148u8),
(8222u16,132u8),(8224u16,134u8),(8225u16,135u8),(8226u16,149u8),(8230u16,133u8),
(8240u16,137u8),(8249u16,139u8),(8250u16,155u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1254Decode*: array[128, uint16] = [
uint16 8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,142,143,
144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,158,376,160,
161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,
181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,286,209,210,211,212,213,214,215,216,217,218,219,220,
304,350,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,287,
241,242,243,244,245,246,247,248,249,250,251,252,305,351,255,
]
const Windows1254Encode*: array[128, UCS16x8] = [
(129u16,129u8),(141u16,141u8),(142u16,142u8),(143u16,143u8),(144u16,144u8),
(157u16,157u8),(158u16,158u8),(160u16,160u8),(161u16,161u8),(162u16,162u8),
(163u16,163u8),(164u16,164u8),(165u16,165u8),(166u16,166u8),(167u16,167u8),
(168u16,168u8),(169u16,169u8),(170u16,170u8),(171u16,171u8),(172u16,172u8),
(173u16,173u8),(174u16,174u8),(175u16,175u8),(176u16,176u8),(177u16,177u8),
(178u16,178u8),(179u16,179u8),(180u16,180u8),(181u16,181u8),(182u16,182u8),
(183u16,183u8),(184u16,184u8),(185u16,185u8),(186u16,186u8),(187u16,187u8),
(188u16,188u8),(189u16,189u8),(190u16,190u8),(191u16,191u8),(192u16,192u8),
(193u16,193u8),(194u16,194u8),(195u16,195u8),(196u16,196u8),(197u16,197u8),
(198u16,198u8),(199u16,199u8),(200u16,200u8),(201u16,201u8),(202u16,202u8),
(203u16,203u8),(204u16,204u8),(205u16,205u8),(206u16,206u8),(207u16,207u8),
(209u16,209u8),(210u16,210u8),(211u16,211u8),(212u16,212u8),(213u16,213u8),
(214u16,214u8),(215u16,215u8),(216u16,216u8),(217u16,217u8),(218u16,218u8),
(219u16,219u8),(220u16,220u8),(223u16,223u8),(224u16,224u8),(225u16,225u8),
(226u16,226u8),(227u16,227u8),(228u16,228u8),(229u16,229u8),(230u16,230u8),
(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),(235u16,235u8),
(236u16,236u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),(241u16,241u8),
(242u16,242u8),(243u16,243u8),(244u16,244u8),(245u16,245u8),(246u16,246u8),
(247u16,247u8),(248u16,248u8),(249u16,249u8),(250u16,250u8),(251u16,251u8),
(252u16,252u8),(255u16,255u8),(286u16,208u8),(287u16,240u8),(304u16,221u8),
(305u16,253u8),(338u16,140u8),(339u16,156u8),(350u16,222u8),(351u16,254u8),
(352u16,138u8),(353u16,154u8),(376u16,159u8),(402u16,131u8),(710u16,136u8),
(732u16,152u8),(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),
(8218u16,130u8),(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),
(8225u16,135u8),(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),
(8250u16,155u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1255Decode*: array[127, uint16] = [
uint16 8364,129,8218,402,8222,8230,8224,8225,710,8240,138,8249,140,141,142,143,
144,8216,8217,8220,8221,8226,8211,8212,732,8482,154,8250,156,157,158,159,160,
161,162,163,8362,165,166,167,168,169,215,171,172,173,174,175,176,177,178,179,
180,181,182,183,184,185,247,187,188,189,190,191,1456,1457,1458,1459,1460,1461,
1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,1472,1473,1474,1475,1520,1521,
1522,1523,1524,0,0,0,0,0,0,0,1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,
1498,1499,1500,1501,1502,1503,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,
1514,0,0,8206,8207,
]
const Windows1255Encode*: array[118, UCS16x8] = [
(129u16,129u8),(138u16,138u8),(140u16,140u8),(141u16,141u8),(142u16,142u8),
(143u16,143u8),(144u16,144u8),(154u16,154u8),(156u16,156u8),(157u16,157u8),
(158u16,158u8),(159u16,159u8),(160u16,160u8),(161u16,161u8),(162u16,162u8),
(163u16,163u8),(165u16,165u8),(166u16,166u8),(167u16,167u8),(168u16,168u8),
(169u16,169u8),(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),
(175u16,175u8),(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),
(180u16,180u8),(181u16,181u8),(182u16,182u8),(183u16,183u8),(184u16,184u8),
(185u16,185u8),(187u16,187u8),(188u16,188u8),(189u16,189u8),(190u16,190u8),
(191u16,191u8),(215u16,170u8),(247u16,186u8),(402u16,131u8),(710u16,136u8),
(732u16,152u8),(1456u16,192u8),(1457u16,193u8),(1458u16,194u8),(1459u16,195u8),
(1460u16,196u8),(1461u16,197u8),(1462u16,198u8),(1463u16,199u8),(1464u16,200u8),
(1465u16,201u8),(1466u16,202u8),(1467u16,203u8),(1468u16,204u8),(1469u16,205u8),
(1470u16,206u8),(1471u16,207u8),(1472u16,208u8),(1473u16,209u8),(1474u16,210u8),
(1475u16,211u8),(1488u16,224u8),(1489u16,225u8),(1490u16,226u8),(1491u16,227u8),
(1492u16,228u8),(1493u16,229u8),(1494u16,230u8),(1495u16,231u8),(1496u16,232u8),
(1497u16,233u8),(1498u16,234u8),(1499u16,235u8),(1500u16,236u8),(1501u16,237u8),
(1502u16,238u8),(1503u16,239u8),(1504u16,240u8),(1505u16,241u8),(1506u16,242u8),
(1507u16,243u8),(1508u16,244u8),(1509u16,245u8),(1510u16,246u8),(1511u16,247u8),
(1512u16,248u8),(1513u16,249u8),(1514u16,250u8),(1520u16,212u8),(1521u16,213u8),
(1522u16,214u8),(1523u16,215u8),(1524u16,216u8),(8206u16,253u8),(8207u16,254u8),
(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),(8218u16,130u8),
(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),(8225u16,135u8),
(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),(8250u16,155u8),
(8362u16,164u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1256Decode*: array[128, uint16] = [
uint16 8364,1662,8218,402,8222,8230,8224,8225,710,8240,1657,8249,338,1670,1688,
1672,1711,8216,8217,8220,8221,8226,8211,8212,1705,8482,1681,8250,339,8204,8205,
1722,160,1548,162,163,164,165,166,167,168,169,1726,171,172,173,174,175,176,177,
178,179,180,181,182,183,184,185,1563,187,188,189,190,1567,1729,1569,1570,1571,
1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,1584,1585,1586,1587,
1588,1589,1590,215,1591,1592,1593,1594,1600,1601,1602,1603,224,1604,226,1605,
1606,1607,1608,231,232,233,234,235,1609,1610,238,239,1611,1612,1613,1614,244,
1615,1616,247,1617,249,1618,251,252,8206,8207,1746,
]
const Windows1256Encode*: array[128, UCS16x8] = [
(160u16,160u8),(162u16,162u8),(163u16,163u8),(164u16,164u8),(165u16,165u8),
(166u16,166u8),(167u16,167u8),(168u16,168u8),(169u16,169u8),(171u16,171u8),
(172u16,172u8),(173u16,173u8),(174u16,174u8),(175u16,175u8),(176u16,176u8),
(177u16,177u8),(178u16,178u8),(179u16,179u8),(180u16,180u8),(181u16,181u8),
(182u16,182u8),(183u16,183u8),(184u16,184u8),(185u16,185u8),(187u16,187u8),
(188u16,188u8),(189u16,189u8),(190u16,190u8),(215u16,215u8),(224u16,224u8),
(226u16,226u8),(231u16,231u8),(232u16,232u8),(233u16,233u8),(234u16,234u8),
(235u16,235u8),(238u16,238u8),(239u16,239u8),(244u16,244u8),(247u16,247u8),
(249u16,249u8),(251u16,251u8),(252u16,252u8),(338u16,140u8),(339u16,156u8),
(402u16,131u8),(710u16,136u8),(1548u16,161u8),(1563u16,186u8),(1567u16,191u8),
(1569u16,193u8),(1570u16,194u8),(1571u16,195u8),(1572u16,196u8),(1573u16,197u8),
(1574u16,198u8),(1575u16,199u8),(1576u16,200u8),(1577u16,201u8),(1578u16,202u8),
(1579u16,203u8),(1580u16,204u8),(1581u16,205u8),(1582u16,206u8),(1583u16,207u8),
(1584u16,208u8),(1585u16,209u8),(1586u16,210u8),(1587u16,211u8),(1588u16,212u8),
(1589u16,213u8),(1590u16,214u8),(1591u16,216u8),(1592u16,217u8),(1593u16,218u8),
(1594u16,219u8),(1600u16,220u8),(1601u16,221u8),(1602u16,222u8),(1603u16,223u8),
(1604u16,225u8),(1605u16,227u8),(1606u16,228u8),(1607u16,229u8),(1608u16,230u8),
(1609u16,236u8),(1610u16,237u8),(1611u16,240u8),(1612u16,241u8),(1613u16,242u8),
(1614u16,243u8),(1615u16,245u8),(1616u16,246u8),(1617u16,248u8),(1618u16,250u8),
(1657u16,138u8),(1662u16,129u8),(1670u16,141u8),(1672u16,143u8),(1681u16,154u8),
(1688u16,142u8),(1705u16,152u8),(1711u16,144u8),(1722u16,159u8),(1726u16,170u8),
(1729u16,192u8),(1746u16,255u8),(8204u16,157u8),(8205u16,158u8),(8206u16,253u8),
(8207u16,254u8),(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),
(8218u16,130u8),(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),
(8225u16,135u8),(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),
(8250u16,155u8),(8364u16,128u8),(8482u16,153u8),
]

const Windows1257Decode*: array[128, uint16] = [
uint16 8364,129,8218,131,8222,8230,8224,8225,136,8240,138,8249,140,168,711,184,
144,8216,8217,8220,8221,8226,8211,8212,152,8482,154,8250,156,175,731,159,160,0,
162,163,164,0,166,167,216,169,342,171,172,173,174,198,176,177,178,179,180,181,
182,183,248,185,343,187,188,189,190,230,260,302,256,262,196,197,280,274,268,201,
377,278,290,310,298,315,352,323,325,211,332,213,214,215,370,321,346,362,220,379,
381,223,261,303,257,263,228,229,281,275,269,233,378,279,291,311,299,316,353,324,
326,243,333,245,246,247,371,322,347,363,252,380,382,729,
]
const Windows1257Encode*: array[126, UCS16x8] = [
(129u16,129u8),(131u16,131u8),(136u16,136u8),(138u16,138u8),(140u16,140u8),
(144u16,144u8),(152u16,152u8),(154u16,154u8),(156u16,156u8),(159u16,159u8),
(160u16,160u8),(162u16,162u8),(163u16,163u8),(164u16,164u8),(166u16,166u8),
(167u16,167u8),(168u16,141u8),(169u16,169u8),(171u16,171u8),(172u16,172u8),
(173u16,173u8),(174u16,174u8),(175u16,157u8),(176u16,176u8),(177u16,177u8),
(178u16,178u8),(179u16,179u8),(180u16,180u8),(181u16,181u8),(182u16,182u8),
(183u16,183u8),(184u16,143u8),(185u16,185u8),(187u16,187u8),(188u16,188u8),
(189u16,189u8),(190u16,190u8),(196u16,196u8),(197u16,197u8),(198u16,175u8),
(201u16,201u8),(211u16,211u8),(213u16,213u8),(214u16,214u8),(215u16,215u8),
(216u16,168u8),(220u16,220u8),(223u16,223u8),(228u16,228u8),(229u16,229u8),
(230u16,191u8),(233u16,233u8),(243u16,243u8),(245u16,245u8),(246u16,246u8),
(247u16,247u8),(248u16,184u8),(252u16,252u8),(256u16,194u8),(257u16,226u8),
(260u16,192u8),(261u16,224u8),(262u16,195u8),(263u16,227u8),(268u16,200u8),
(269u16,232u8),(274u16,199u8),(275u16,231u8),(278u16,203u8),(279u16,235u8),
(280u16,198u8),(281u16,230u8),(290u16,204u8),(291u16,236u8),(298u16,206u8),
(299u16,238u8),(302u16,193u8),(303u16,225u8),(310u16,205u8),(311u16,237u8),
(315u16,207u8),(316u16,239u8),(321u16,217u8),(322u16,249u8),(323u16,209u8),
(324u16,241u8),(325u16,210u8),(326u16,242u8),(332u16,212u8),(333u16,244u8),
(342u16,170u8),(343u16,186u8),(346u16,218u8),(347u16,250u8),(352u16,208u8),
(353u16,240u8),(362u16,219u8),(363u16,251u8),(370u16,216u8),(371u16,248u8),
(377u16,202u8),(378u16,234u8),(379u16,221u8),(380u16,253u8),(381u16,222u8),
(382u16,254u8),(711u16,142u8),(729u16,255u8),(731u16,158u8),(8211u16,150u8),
(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),(8218u16,130u8),(8220u16,147u8),
(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),(8225u16,135u8),(8226u16,149u8),
(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),(8250u16,155u8),(8364u16,128u8),
(8482u16,153u8),
]

const Windows1258Decode*: array[128, uint16] = [
uint16 8364,129,8218,402,8222,8230,8224,8225,710,8240,138,8249,338,141,142,143,
144,8216,8217,8220,8221,8226,8211,8212,732,8482,154,8250,339,157,158,376,160,
161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,
181,182,183,184,185,186,187,188,189,190,191,192,193,194,258,196,197,198,199,200,
201,202,203,768,205,206,207,272,209,777,211,212,416,214,215,216,217,218,219,220,
431,771,223,224,225,226,259,228,229,230,231,232,233,234,235,769,237,238,239,273,
241,803,243,244,417,246,247,248,249,250,251,252,432,8363,255,
]
const Windows1258Encode*: array[128, UCS16x8] = [
(129u16,129u8),(138u16,138u8),(141u16,141u8),(142u16,142u8),(143u16,143u8),
(144u16,144u8),(154u16,154u8),(157u16,157u8),(158u16,158u8),(160u16,160u8),
(161u16,161u8),(162u16,162u8),(163u16,163u8),(164u16,164u8),(165u16,165u8),
(166u16,166u8),(167u16,167u8),(168u16,168u8),(169u16,169u8),(170u16,170u8),
(171u16,171u8),(172u16,172u8),(173u16,173u8),(174u16,174u8),(175u16,175u8),
(176u16,176u8),(177u16,177u8),(178u16,178u8),(179u16,179u8),(180u16,180u8),
(181u16,181u8),(182u16,182u8),(183u16,183u8),(184u16,184u8),(185u16,185u8),
(186u16,186u8),(187u16,187u8),(188u16,188u8),(189u16,189u8),(190u16,190u8),
(191u16,191u8),(192u16,192u8),(193u16,193u8),(194u16,194u8),(196u16,196u8),
(197u16,197u8),(198u16,198u8),(199u16,199u8),(200u16,200u8),(201u16,201u8),
(202u16,202u8),(203u16,203u8),(205u16,205u8),(206u16,206u8),(207u16,207u8),
(209u16,209u8),(211u16,211u8),(212u16,212u8),(214u16,214u8),(215u16,215u8),
(216u16,216u8),(217u16,217u8),(218u16,218u8),(219u16,219u8),(220u16,220u8),
(223u16,223u8),(224u16,224u8),(225u16,225u8),(226u16,226u8),(228u16,228u8),
(229u16,229u8),(230u16,230u8),(231u16,231u8),(232u16,232u8),(233u16,233u8),
(234u16,234u8),(235u16,235u8),(237u16,237u8),(238u16,238u8),(239u16,239u8),
(241u16,241u8),(243u16,243u8),(244u16,244u8),(246u16,246u8),(247u16,247u8),
(248u16,248u8),(249u16,249u8),(250u16,250u8),(251u16,251u8),(252u16,252u8),
(255u16,255u8),(258u16,195u8),(259u16,227u8),(272u16,208u8),(273u16,240u8),
(338u16,140u8),(339u16,156u8),(376u16,159u8),(402u16,131u8),(416u16,213u8),
(417u16,245u8),(431u16,221u8),(432u16,253u8),(710u16,136u8),(732u16,152u8),
(768u16,204u8),(769u16,236u8),(771u16,222u8),(777u16,210u8),(803u16,242u8),
(8211u16,150u8),(8212u16,151u8),(8216u16,145u8),(8217u16,146u8),(8218u16,130u8),
(8220u16,147u8),(8221u16,148u8),(8222u16,132u8),(8224u16,134u8),(8225u16,135u8),
(8226u16,149u8),(8230u16,133u8),(8240u16,137u8),(8249u16,139u8),(8250u16,155u8),
(8363u16,254u8),(8364u16,128u8),(8482u16,153u8),
]

const XMacCyrillicDecode*: array[128, uint16] = [
uint16 1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1051,1052,1053,
1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,
1070,1071,8224,176,1168,163,167,8226,182,1030,174,169,8482,1026,1106,8800,1027,
1107,8734,177,8804,8805,1110,181,1169,1032,1028,1108,1031,1111,1033,1113,1034,
1114,1112,1029,172,8730,402,8776,8710,171,187,8230,160,1035,1115,1036,1116,1109,
8211,8212,8220,8221,8216,8217,247,8222,1038,1118,1039,1119,8470,1025,1105,1103,
1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,
1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,8364,
]
const XMacCyrillicEncode*: array[128, UCS16x8] = [
(160u16,202u8),(163u16,163u8),(167u16,164u8),(169u16,169u8),(171u16,199u8),
(172u16,194u8),(174u16,168u8),(176u16,161u8),(177u16,177u8),(181u16,181u8),
(182u16,166u8),(187u16,200u8),(247u16,214u8),(402u16,196u8),(1025u16,221u8),
(1026u16,171u8),(1027u16,174u8),(1028u16,184u8),(1029u16,193u8),(1030u16,167u8),
(1031u16,186u8),(1032u16,183u8),(1033u16,188u8),(1034u16,190u8),(1035u16,203u8),
(1036u16,205u8),(1038u16,216u8),(1039u16,218u8),(1040u16,128u8),(1041u16,129u8),
(1042u16,130u8),(1043u16,131u8),(1044u16,132u8),(1045u16,133u8),(1046u16,134u8),
(1047u16,135u8),(1048u16,136u8),(1049u16,137u8),(1050u16,138u8),(1051u16,139u8),
(1052u16,140u8),(1053u16,141u8),(1054u16,142u8),(1055u16,143u8),(1056u16,144u8),
(1057u16,145u8),(1058u16,146u8),(1059u16,147u8),(1060u16,148u8),(1061u16,149u8),
(1062u16,150u8),(1063u16,151u8),(1064u16,152u8),(1065u16,153u8),(1066u16,154u8),
(1067u16,155u8),(1068u16,156u8),(1069u16,157u8),(1070u16,158u8),(1071u16,159u8),
(1072u16,224u8),(1073u16,225u8),(1074u16,226u8),(1075u16,227u8),(1076u16,228u8),
(1077u16,229u8),(1078u16,230u8),(1079u16,231u8),(1080u16,232u8),(1081u16,233u8),
(1082u16,234u8),(1083u16,235u8),(1084u16,236u8),(1085u16,237u8),(1086u16,238u8),
(1087u16,239u8),(1088u16,240u8),(1089u16,241u8),(1090u16,242u8),(1091u16,243u8),
(1092u16,244u8),(1093u16,245u8),(1094u16,246u8),(1095u16,247u8),(1096u16,248u8),
(1097u16,249u8),(1098u16,250u8),(1099u16,251u8),(1100u16,252u8),(1101u16,253u8),
(1102u16,254u8),(1103u16,223u8),(1105u16,222u8),(1106u16,172u8),(1107u16,175u8),
(1108u16,185u8),(1109u16,207u8),(1110u16,180u8),(1111u16,187u8),(1112u16,192u8),
(1113u16,189u8),(1114u16,191u8),(1115u16,204u8),(1116u16,206u8),(1118u16,217u8),
(1119u16,219u8),(1168u16,162u8),(1169u16,182u8),(8211u16,208u8),(8212u16,209u8),
(8216u16,212u8),(8217u16,213u8),(8220u16,210u8),(8221u16,211u8),(8222u16,215u8),
(8224u16,160u8),(8226u16,165u8),(8230u16,201u8),(8364u16,255u8),(8470u16,220u8),
(8482u16,170u8),(8710u16,198u8),(8730u16,195u8),(8734u16,176u8),(8776u16,197u8),
(8800u16,173u8),(8804u16,178u8),(8805u16,179u8),
]

const GB18030Runs*: array[1916, uint32] = [
33554432u32,100671489u32,33628164u32,33644549u32,33677318u32,100843527u32,
33742858u32,33759243u32,33775628u32,67362829u32,33816591u32,33824784u32,
33832977u32,33841170u32,33873939u32,101007380u32,33906711u32,33914904u32,
33939481u32,33988634u32,34013211u32,34021404u32,67592221u32,134750239u32,
67649571u32,201875493u32,34119723u32,336117804u32,235462710u32,34144317u32,
34160702u32,34201663u32,67797056u32,34250818u32,101376067u32,34299974u32,
34349127u32,101490760u32,34398283u32,135069772u32,101531728u32,34496595u32,
34521172u32,68091989u32,34545751u32,101711960u32,34627675u32,34635868u32,
68214877u32,34668639u32,101802080u32,34701411u32,34717796u32,101851237u32,
34750568u32,34758761u32,34766954u32,236101739u32,68345970u32,169050228u32,
68427897u32,34898043u32,34906236u32,68493437u32,102064255u32,34971778u32,
34979971u32,34988164u32,34996357u32,35004550u32,35012743u32,169246856u32,
68591757u32,202817679u32,35086485u32,35094678u32,35102871u32,68739224u32,
35209370u32,35217563u32,68780188u32,68788382u32,68804768u32,35266722u32,
135938211u32,35291303u32,102416552u32,102432939u32,35340462u32,35348655u32,
35356848u32,35365041u32,68927666u32,68935860u32,102498486u32,35397817u32,
68960442u32,68968636u32,35422398u32,35471551u32,35479744u32,169713857u32,
303939782u32,102621391u32,136200402u32,102654166u32,169795801u32,35594462u32,
35602655u32,35635424u32,35643617u32,69206242u32,35660004u32,69239013u32,
35709159u32,35717352u32,136388841u32,35733741u32,102850798u32,438403313u32,
35766526u32,69329151u32,35782913u32,102899970u32,35815685u32,69378310u32,
35832072u32,102949129u32,35856652u32,35881229u32,371450126u32,35914009u32,
35922202u32,136593691u32,103047455u32,103063842u32,35963173u32,170197286u32,
136651051u32,35995951u32,270885168u32,203784504u32,304455998u32,103145799u32,
69599562u32,136733004u32,69632336u32,136749394u32,707182934u32,36102507u32,
36110700u32,69689709u32,170361199u32,237478260u32,640147835u32,203948430u32,
103293332u32,371736983u32,136872354u32,136896934u32,36241834u32,170467755u32,
338248112u32,103383482u32,204054973u32,472498627u32,975823313u32,36323822u32,
36356591u32,36372976u32,36381169u32,103498226u32,69951989u32,103530999u32,
36430330u32,170656251u32,70001152u32,70009346u32,70017540u32,36495878u32,
36512263u32,36569608u32,70148617u32,70173195u32,70181389u32,70197775u32,
137323025u32,70222357u32,36692503u32,36700696u32,103825945u32,36725276u32,
36733469u32,170967582u32,70320675u32,36807205u32,103940646u32,70410793u32,
103973419u32,36872750u32,36889135u32,36897328u32,70468145u32,36921907u32,
305365556u32,36938301u32,70500926u32,70517312u32,204743234u32,36979272u32,
36987465u32,70558282u32,37012044u32,37028429u32,37077582u32,70672975u32,
37143121u32,70705746u32,70722132u32,104292950u32,37233241u32,70795866u32,
104358492u32,104366687u32,37274210u32,37282403u32,37298788u32,70861413u32,
70869607u32,37364329u32,37372522u32,205185643u32,37421681u32,70992498u32,
71008884u32,37462646u32,171688567u32,37479036u32,71041661u32,104604287u32,
37503618u32,37511811u32,138191492u32,71090824u32,339534474u32,37552788u32,
37560981u32,171795094u32,238912155u32,71148194u32,238928548u32,37610155u32,
138330796u32,104825520u32,339731123u32,104866493u32,104874688u32,37774019u32,
37782212u32,138453701u32,37798601u32,104915658u32,37814989u32,205595342u32,
138494676u32,373383896u32,272728803u32,104973035u32,138552046u32,37905138u32,
138576627u32,37921527u32,138601208u32,37962492u32,71533309u32,71541503u32,
38003457u32,71566082u32,105128708u32,105136903u32,340026122u32,71615252u32,
38077206u32,38085399u32,38093592u32,38101785u32,105243418u32,38150941u32,
38175518u32,71754527u32,38208289u32,38216482u32,38273827u32,38290212u32,
38298405u32,71861030u32,38339368u32,38363945u32,38380330u32,139051819u32,
71951151u32,38404913u32,71983922u32,38437684u32,239788853u32,72024892u32,
38478654u32,72041279u32,38495041u32,72057666u32,38519620u32,38536005u32,
139215686u32,239887178u32,139232081u32,105685845u32,38585176u32,172819289u32,
105759582u32,72213345u32,38667107u32,38699876u32,105816933u32,72278888u32,
38757226u32,38855531u32,38896492u32,106029933u32,38929264u32,38945649u32,
38953842u32,38978419u32,39043956u32,106177397u32,39076728u32,39117689u32,
72680314u32,39158652u32,39199613u32,39215998u32,72786815u32,39248769u32,
39265154u32,39273347u32,72835972u32,72844166u32,39297928u32,39306121u32,
139985802u32,39330702u32,39396239u32,173630352u32,39420821u32,39429014u32,
39437207u32,274326424u32,39469984u32,73057185u32,73081763u32,39535525u32,
39543718u32,39551911u32,140223400u32,39576492u32,39601069u32,39609262u32,
73188271u32,39658417u32,173884338u32,39682999u32,39748536u32,39756729u32,
39764922u32,106890171u32,73343934u32,39797696u32,39805889u32,39838658u32,
39846851u32,73434052u32,39961542u32,39969735u32,39986120u32,174236617u32,
73622478u32,107193296u32,207872979u32,40109017u32,40125402u32,40133595u32,
140805084u32,40158176u32,174384097u32,73745382u32,207971304u32,140870638u32,
40215538u32,73794547u32,73802741u32,40256503u32,40264696u32,40297465u32,
107414522u32,140977149u32,40322049u32,40338434u32,40346627u32,40363012u32,
73925637u32,174605319u32,141059084u32,174629904u32,141083669u32,73983001u32,
74015771u32,40469533u32,208266270u32,74081316u32,40543270u32,40551463u32,
74146856u32,107742250u32,40641581u32,74204206u32,107766832u32,74228787u32,
40690741u32,242025526u32,309142589u32,40715334u32,40723527u32,40731720u32,
40739913u32,40748106u32,40756299u32,174990412u32,107897937u32,74351700u32,
107922518u32,40846425u32,175072346u32,40871007u32,40879200u32,40887393u32,
40920162u32,40928355u32,74507364u32,74515558u32,40977512u32,40985705u32,
175211626u32,41010287u32,208798832u32,74597494u32,41051256u32,275948665u32,
74630273u32,74638467u32,108209285u32,74671240u32,141788298u32,108250254u32,
41157777u32,41165970u32,74728595u32,41182357u32,108299414u32,410297497u32,
175441061u32,74785962u32,74810540u32,175482030u32,41272499u32,108389556u32,
141984951u32,141993147u32,142001343u32,276235459u32,242697419u32,108496082u32,
511157461u32,376947940u32,242738415u32,142083318u32,444081402u32,309871879u32,
74999056u32,75007250u32,41469204u32,41518357u32,209298710u32,41534748u32,
75097373u32,75113759u32,108684577u32,75146532u32,108725542u32,41633065u32,
41641258u32,578536747u32,75228476u32,108791102u32,142353729u32,41715013u32,
75310406u32,175981896u32,75343181u32,41796943u32,41805136u32,142476625u32,
75375957u32,41829719u32,176096600u32,75441501u32,75507039u32,41960801u32,
41968994u32,42001763u32,42009956u32,109127013u32,75580776u32,109151594u32,
176276845u32,142763378u32,176334198u32,243459451u32,142804354u32,42182022u32,
42198407u32,42206600u32,42214793u32,109340042u32,42239373u32,109356430u32,
310691217u32,243598746u32,75834785u32,75851171u32,42304933u32,75875750u32,
75900328u32,42354090u32,109479339u32,277259694u32,42386870u32,143058359u32,
109512123u32,75982270u32,75990464u32,42444226u32,109561283u32,109577670u32,
42477001u32,109594058u32,109602253u32,109610448u32,143173075u32,42517975u32,
76088792u32,176760282u32,176768479u32,143222244u32,478774760u32,243901942u32,
109700605u32,76154368u32,109716994u32,176834053u32,210396682u32,176850448u32,
579520021u32,42657318u32,42673703u32,42681896u32,109798953u32,277579308u32,
176932404u32,109839929u32,277628476u32,613189188u32,143435350u32,109889114u32,
378332765u32,109905512u32,479012459u32,210585209u32,42829439u32,42837632u32,
76400257u32,76408451u32,76416645u32,277751431u32,42878607u32,76441232u32,
177112722u32,42903191u32,143574680u32,76490396u32,42952350u32,76514975u32,
143632033u32,42985125u32,42993318u32,43017895u32,43042472u32,76605097u32,
76613291u32,43091629u32,143763118u32,43116210u32,76678835u32,43148981u32,
76711606u32,43173560u32,76736185u32,43222715u32,177448636u32,43239105u32,
76801730u32,445908676u32,43271889u32,43280082u32,110405331u32,110413526u32,
43337433u32,43362010u32,76924635u32,144041693u32,76949217u32,43411171u32,
144082660u32,144090856u32,77006572u32,77039342u32,77055728u32,211281650u32,
43517688u32,77080313u32,244860667u32,110651138u32,144221957u32,77154057u32,
43616011u32,43624204u32,177858317u32,43648786u32,77211411u32,110774037u32,
412772120u32,43681572u32,110798629u32,43697960u32,43706153u32,77317930u32,
144434988u32,43779888u32,144451377u32,110905141u32,77358904u32,77375290u32,
43829052u32,110946109u32,245172032u32,43861831u32,43870024u32,178095945u32,
110995278u32,178112337u32,77457238u32,345909080u32,144590690u32,245262182u32,
144607085u32,77506417u32,312395635u32,77547388u32,144664446u32,614434690u32,
245344148u32,480241563u32,245368745u32,44058544u32,77621169u32,178292659u32,
77637560u32,211871674u32,77662144u32,178333634u32,44124103u32,44132296u32,
44140489u32,111257546u32,111265741u32,44173264u32,77735889u32,77744083u32,
44197845u32,178423766u32,782411739u32,413321202u32,883099646u32,44247064u32,
77809689u32,279144475u32,514033699u32,44288050u32,44312627u32,44369972u32,
77932597u32,77973559u32,44435513u32,111552570u32,44460093u32,44468286u32,
145139775u32,78039107u32,78047301u32,44509255u32,44533832u32,44558409u32,
78129226u32,111691852u32,44591183u32,44599376u32,44664913u32,111831122u32,
145401941u32,78301273u32,44779611u32,111904860u32,78375007u32,44828769u32,
145524834u32,111978598u32,44877929u32,313329770u32,44918899u32,78481524u32,
78497910u32,179169400u32,44959869u32,246294654u32,78563461u32,45017223u32,
78579848u32,45033610u32,78596235u32,145721485u32,45066385u32,78629010u32,
45099156u32,45107349u32,45115542u32,145795223u32,45140123u32,45156508u32,
145827997u32,145836193u32,78735525u32,112298151u32,78833834u32,78842028u32,
78874798u32,112462000u32,112470195u32,146032822u32,45377722u32,45394107u32,
45402300u32,246745277u32,45435076u32,246769861u32,146122956u32,45467856u32,
179701969u32,112601302u32,79063257u32,79079643u32,45533405u32,179808478u32,
179824867u32,45615336u32,112748777u32,45648108u32,45656301u32,45664494u32,
146344175u32,45689075u32,45697268u32,79259893u32,213485815u32,213494013u32,
213502211u32,247064841u32,79300880u32,45771026u32,45779219u32,79341844u32,
79350038u32,347793688u32,213584162u32,79382824u32,213616938u32,180070704u32,
45861173u32,146532662u32,79431994u32,180103484u32,45893953u32,45910338u32,
113027395u32,180152646u32,280824139u32,280840531u32,79522139u32,381536605u32,
79554920u32,46008682u32,381561195u32,46025078u32,79595895u32,146712953u32,
448711037u32,750709130u32,113183136u32,851388835u32,448743868u32,247425481u32,
448760272u32,46115293u32,79686110u32,79702496u32,46189026u32,79751651u32,
46213605u32,79800806u32,180472296u32,79825389u32,46295535u32,46311920u32,
113428977u32,79882740u32,79907318u32,46377464u32,281307641u32,180660737u32,
80013830u32,180685320u32,80038413u32,147171855u32,46516755u32,214305300u32,
247867930u32,180775457u32,80120358u32,80128552u32,516352554u32,46615097u32,
46623290u32,46631483u32,46664252u32,113789501u32,46688832u32,80259649u32,
113830467u32,46746182u32,46787143u32,46803528u32,46811721u32,147499594u32,
181078606u32,181086803u32,46877272u32,147581529u32,348916317u32,214714983u32,
80521837u32,147638895u32,416082547u32,46991999u32,315435648u32,47008393u32,
80579210u32,114141836u32,114199183u32,47098514u32,114223763u32,47123094u32,
47131287u32,47139480u32,47147673u32,80718490u32,114281116u32,147851935u32,
47213219u32,80784036u32,47237798u32,47245991u32,248580776u32,47270575u32,
114387632u32,517049011u32,47295170u32,47311555u32,148007620u32,114461384u32,
47368907u32,47377100u32,80939725u32,47401679u32,80972496u32,47434450u32,
114551507u32,47450838u32,47459031u32,114584280u32,47499995u32,47516380u32,
114674397u32,47573728u32,81136353u32,47590115u32,81169124u32,148286182u32,
215403242u32,47639280u32,81201905u32,215436019u32,47672057u32,148343546u32,
181914366u32,81283843u32,81292037u32,47753991u32,114895624u32,114928395u32,
81382158u32,81398544u32,81406738u32,81414932u32,47876886u32,81447703u32,
115010329u32,81464092u32,81472286u32,47926048u32,115116833u32,81570596u32,
81595174u32,48048936u32,81627945u32,48081707u32,81660716u32,115231534u32,
115288881u32,182405940u32,182414137u32,81767230u32,48220992u32,249572161u32,
48253768u32,81816393u32,48270155u32,81832780u32,115395406u32,81857361u32,
148974419u32,81890135u32,48393049u32,81963866u32,81972060u32,48425822u32,
48474975u32,115592032u32,149162851u32,82062183u32,149187433u32,48532333u32,
48540526u32,115657583u32,48565106u32,48573299u32,82144116u32,82152310u32,
48606072u32,82168697u32,48638843u32,48647036u32,48663421u32,115780478u32,
82234241u32,283577219u32,115821451u32,182946702u32,115846035u32,82299798u32,
48753560u32,48761753u32,48778138u32,183012251u32,48827296u32,82430881u32,
48892835u32,82455460u32,183135142u32,149597099u32,48941999u32,116067248u32,
183200691u32,149654456u32,149662652u32,82570176u32,49032130u32,116157379u32,
653036486u32,283945945u32,49073121u32,49081314u32,49089507u32,82652132u32,
116214758u32,250440681u32,149785584u32,149793780u32,250473464u32,149818367u32,
49163267u32,653151236u32,82734103u32,183405593u32,284077086u32,317639718u32,
82783279u32,351226929u32,217017403u32,116362305u32,183479364u32,49269833u32,
183503946u32,49302607u32,586181712u32,485526625u32,317762671u32,217107576u32,
49343614u32,49351807u32,82979968u32,49458306u32,116583555u32,49482886u32,
49499271u32,150178952u32,49523852u32,49532045u32,150203534u32,83111058u32,
183782548u32,49605785u32,116722842u32,49638557u32,83225758u32,116812960u32,
83266723u32,251047077u32,83283116u32,49745070u32,83365039u32,83373233u32,
83381427u32,83389621u32,49843383u32,116976824u32,150539451u32,217664703u32,
49917125u32,49949894u32,117075143u32,49999050u32,83569867u32,83578061u32,
150703311u32,117157075u32,117165270u32,50064601u32,50089178u32,83651803u32,
50105565u32,50162910u32,50187487u32,50195680u32,50220257u32,83832034u32,
83840228u32,50302182u32,83897575u32,50375913u32,50384106u32,50400491u32,
151080172u32,50449648u32,151129329u32,151153909u32,84053241u32,151170299u32,
117624063u32,50531586u32,84159747u32,50613509u32,117738758u32,84192521u32,
218418443u32,84217105u32,151334163u32,50687255u32,84258072u32,50711834u32,
151424283u32,285650207u32,50785575u32,117919016u32,50818347u32,117935404u32,
84397359u32,151514417u32,84421941u32,151547191u32,50892091u32,151563580u32,
50933056u32,50941249u32,50965826u32,118082883u32,50982214u32,252316999u32,
50998606u32,51014991u32,51023184u32,51055953u32,51080530u32,84643155u32,
84659541u32,51121495u32,51129688u32,51137881u32,185363802u32,51154271u32,
84716896u32,118279522u32,51203429u32,118320486u32,252546409u32,51228016u32,
51244401u32,185470322u32,84823415u32,151940473u32,51285373u32,51293566u32,
51301759u32,151973248u32,51318148u32,84905349u32,185576839u32,84929932u32,
84946318u32,219180432u32,51424662u32,51432855u32,152112536u32,118566300u32,
51465631u32,219254176u32,185707942u32,85052843u32,51506605u32,51514798u32,
85077423u32,51563953u32,252898738u32,51580345u32,118697402u32,185814461u32,
286485954u32,51613130u32,118730187u32,353619406u32,252980696u32,51662303u32,
51678688u32,320122337u32,85257706u32,85274092u32,152391150u32,185953778u32,
152407543u32,85306875u32,51777021u32,152448510u32,51793410u32,51809795u32,
51817988u32,118935045u32,51834376u32,85397001u32,253177355u32,51867154u32,
51875347u32,152546836u32,186117656u32,119016989u32,51916320u32,51924513u32,
857239074u32,286821947u32,286830147u32,186175051u32,421064272u32,186191452u32,
85536353u32,152661603u32,52022887u32,52039272u32,85601897u32,186281579u32,
85626480u32,85642866u32,85651060u32,52104822u32,119221879u32,85683834u32,
52137596u32,52145789u32,119271038u32,85732993u32,152850051u32,119312007u32,
52211338u32,52219531u32,85782156u32,521997966u32,119352989u32,119369376u32,
52276899u32,119393956u32,52293287u32,52301480u32,85872297u32,52326059u32,
85888684u32,52350638u32,52358831u32,52367024u32,52375217u32,52383410u32,
287280819u32,85962427u32,119533245u32,52432576u32,153128641u32,52481733u32,
86052550u32,119615176u32,287403723u32,52530899u32,86093524u32,86134486u32,
153292504u32,86200028u32,186871518u32,52661987u32,86232804u32,119795430u32,
52694761u32,52702954u32,119828203u32,119852782u32,119860977u32,52760308u32,
153439989u32,52784889u32,153464570u32,52809470u32,52817663u32,86380288u32,
187068162u32,52858631u32,86421256u32,52875018u32,254209803u32,86454034u32,
86462228u32,86511382u32,153628440u32,52973340u32,86535965u32,52989727u32,
52997920u32,187223841u32,120139558u32,53038889u32,86609706u32,120172332u32,
120180527u32,53079858u32,86642483u32,153759541u32,153767737u32,153775933u32,
187346753u32,321572678u32,187371343u32,187379540u32,153833305u32,153841501u32,
892047201u32,53194619u32,288100220u32,86781828u32,221007750u32,53243788u32,
86822797u32,53276559u32,86839184u32,53292946u32,254644115u32,53350298u32,
86912923u32,120475549u32,53383072u32,120500129u32,53399460u32,53407653u32,
221188006u32,53424044u32,53432237u32,53465006u32,53473199u32,87035824u32,
154161074u32,87060406u32,87068600u32,53522362u32,87093179u32,53546941u32,
87117758u32,53571520u32,53604289u32,87166914u32,187838404u32,53628873u32,
120770506u32,87224269u32,87248847u32,53702609u32,53718994u32,53735379u32,
53743572u32,154415061u32,53759961u32,53776346u32,87338971u32,87347165u32,
53800927u32,53809120u32,154480609u32,154488805u32,53833705u32,53850090u32,
53858283u32,120991724u32,53899247u32,53907440u32,53923825u32,53940210u32,
53948403u32,87519220u32,53972982u32,288886775u32,54013951u32,356020224u32,
121188362u32,54104077u32,54128654u32,54136847u32,87699472u32,121262098u32,
87715861u32,87724055u32,54194201u32,289091610u32,54218786u32,154898467u32,
54243367u32,54292520u32,54308905u32,54317098u32,87879723u32,188559405u32,
121458738u32,255684661u32,255701052u32,121499715u32,87969862u32,54440008u32,
54497353u32,54521930u32,54530123u32,54538316u32,54554701u32,356569166u32,
54661208u32,289550425u32,54677601u32,323129442u32,54702187u32,54710380u32,
289607789u32,121843829u32,121852024u32,356741243u32,121868421u32,155447432u32,
54792332u32,88363149u32,54816911u32,356814992u32,54833306u32,222613659u32,
54849697u32,54857890u32,155529379u32,88428711u32,88436905u32,54890667u32,
189116588u32,88461489u32,356905139u32,54923453u32,122048702u32,122056897u32,
54964420u32,155635909u32,122089673u32,189206732u32,54997201u32,55013586u32,
55021779u32,424128724u32,122155232u32,289935587u32,88617195u32,122179821u32,
155742448u32,122196212u32,55095543u32,88658168u32,591982842u32,88674571u32,
88682765u32,88690959u32,55152913u32,88715538u32,88723732u32,155840790u32,
88740122u32,88748316u32,189419806u32,88781091u32,122343717u32,55243048u32,
55251241u32,55259434u32,122401067u32,223072558u32,88871220u32,88879414u32,
357331256u32,88912194u32,55365956u32,122483013u32,88936776u32,88944970u32,
122507596u32,189624655u32,290296148u32,55423324u32,55431517u32,55439710u32,
122556767u32,223228258u32,122573160u32,424579435u32,156152183u32,357486971u32,
55505285u32,357503366u32,424620432u32,223310236u32,55546274u32,223326627u32,
55562665u32,156234154u32,55579054u32,122696111u32,256922034u32,189829561u32,
89174462u32,290509248u32,256963016u32,55652815u32,189878736u32,122778069u32,
391221720u32,257012195u32,89248234u32,122810860u32,122819055u32,324153842u32,
55726587u32,189960700u32,290632193u32,290640393u32,55767569u32,3880989202u32,
89379461u32,357823111u32,156504721u32,55849621u32,122974870u32,156537497u32,
89436829u32,55898783u32,89461408u32,425013922u32,290804398u32,89526966u32,
492188344u32,55988934u32,156668615u32,56038091u32,56054476u32,56079053u32,
156750542u32,89658066u32,123220692u32,190345943u32,291017436u32,291025636u32,
56169196u32,257503981u32,56185588u32,89756405u32,190427895u32,56218364u32,
56226557u32,89789182u32,56283904u32,56292097u32,190518018u32,291189511u32,
123433743u32,123441938u32,56341269u32,123458326u32,123466521u32,257692444u32,
190608163u32,56398632u32,56423209u32,56455978u32,123597611u32,56496942u32,
56513327u32,56521520u32,123671345u32,56587060u32,56595253u32,90166070u32,
157283128u32,90182460u32,123761470u32,56668993u32,190903106u32,123802439u32,
56709962u32,123827019u32,90329934u32,123892560u32,191026003u32,56816472u32,
56824665u32,56832858u32,90395483u32,123958109u32,90420064u32,56890210u32,
56906595u32,90477412u32,90485606u32,90501992u32,157627242u32,56972142u32,
124089199u32,56988530u32,56996723u32,57037684u32,57062261u32,90633078u32,
157766520u32,57119612u32,157823869u32,124285825u32,57193348u32,124310405u32,
90764168u32,124359562u32,90813325u32,57267087u32,57299856u32,90862481u32,
57316243u32,90887060u32,57365398u32,57373591u32,57406360u32,91001753u32,
91009947u32,91018141u32,124580767u32,57488290u32,124605347u32,158167974u32,
57512874u32,91091883u32,225317805u32,57553843u32,91116468u32,91132854u32,
91141048u32,57611194u32,124728251u32,57627582u32,91214783u32,57668545u32,
57676738u32,57709507u32,57725892u32,57750469u32,158446534u32,57799626u32,
57807819u32,57816012u32,91378637u32,91386831u32,91395025u32,124965843u32,
158536662u32,91435994u32,125006812u32,192123871u32,91468772u32,91476966u32,
91493352u32,57947114u32,91509739u32,57963501u32,192205806u32,57996275u32,
58037236u32,58053621u32,91657206u32,91673592u32,91681786u32,91689980u32,
225915902u32,125268996u32,125301767u32,158872586u32,158880782u32,58225682u32,
125350931u32,58258454u32,91829271u32,58283033u32,158954522u32,58307614u32,
91870239u32,58324001u32,125441058u32,58340389u32,58348582u32,293245991u32,
159036463u32,58381363u32,58405940u32,91976757u32,58430519u32,92001336u32,
92009530u32,92017724u32,58479678u32,125613119u32,58512450u32,58520643u32,
58528836u32,92091461u32,58545223u32,125662280u32,58561611u32,293450828u32,
293467220u32,159265884u32,58618976u32,58627169u32,92189794u32,125752420u32,
394196071u32,92214386u32,528430196u32,125793411u32,58692742u32,92263559u32,
192935049u32,260060302u32,125850773u32,92304536u32,92312730u32,92320924u32,
58774686u32,92337311u32,159454369u32,58799269u32,58815654u32,58823847u32,
92394664u32,58856618u32,125973675u32,159544494u32,125998258u32,126006453u32,
58905784u32,58913977u32,58938554u32,92501179u32,126063805u32,58995904u32,
59020481u32,361026754u32,159708364u32,293934288u32,126170328u32,92624091u32,
193295581u32,126194914u32,361100517u32,126227695u32,159790322u32,59151606u32,
59159799u32,59167992u32,59176185u32,92738810u32,260519164u32,260527363u32,
126326026u32,59225357u32,361223438u32,126350616u32,59249947u32,126367004u32,
126375199u32,227046690u32,126399784u32,59299115u32,126416172u32,59315503u32,
59323696u32,260658481u32,126448952u32,92910907u32,462034237u32,160052554u32,
193615182u32,394949971u32,92968286u32,92976480u32,227202402u32,59438440u32,
227218793u32,260781423u32,395015542u32,59479425u32,428594562u32,1133254030u32,
294401455u32,260863415u32,596415934u32,126662095u32,629986770u32,93124068u32,
495785446u32,428684788u32,59610624u32,160290305u32,59643397u32,126760454u32,
59659785u32,160347658u32,126801422u32,126817809u32,126826004u32,59725335u32,
93304344u32,93312538u32,462427676u32,59815465u32,59823658u32,126940715u32,
59856430u32,93435439u32,160577073u32,59921973u32,462583350u32,59946563u32,
127063620u32,160626247u32,59971147u32,60003916u32,60028493u32,261363278u32,
60044885u32,127161942u32,395605593u32,194295396u32,93640297u32,60094059u32,
60110444u32,395679341u32,295024248u32,160831104u32,496383620u32,160847506u32,
60192406u32,60200599u32,462861976u32,60216997u32,194442918u32,60233387u32,
194475692u32,127375025u32,160945844u32,60290744u32,93853369u32,228079291u32,
194533057u32,160986822u32,160995018u32,127448782u32,194574033u32,261699286u32,
127489757u32,228161248u32,60397286u32,127514343u32,328849130u32,362411763u32,
194647805u32,362436354u32,161117964u32,60462864u32,228243217u32,362469143u32,
429586209u32,765138733u32,362493763u32,60512077u32,60520270u32,127637327u32,
127653714u32,60585813u32,60594006u32,60602199u32,261936984u32,127735647u32,
161306466u32,127760230u32,94213993u32,60667755u32,60675948u32,60684141u32,
60692334u32,127817583u32,60725106u32,161396595u32,94304119u32,94312313u32,
127874939u32,127891326u32,94369665u32,195041155u32,60839816u32,60848009u32,
94410634u32,429963148u32,429971352u32,60888996u32,128014245u32,60913576u32,
262272937u32,128087984u32,161650611u32,61003703u32,61011896u32,161683385u32,
61028285u32,94590910u32,
]
const GB18030RunsOffset* = 19970u16
const GB18030Runs2*: array[1626, uint32] = [
67108864u32,33562626u32,201351171u32,67149833u32,67223563u32,33685517u32,
134373390u32,33718290u32,201498643u32,100843545u32,134406172u32,33751072u32,
100884513u32,67362852u32,67379238u32,100941864u32,33865771u32,67428396u32,
67436590u32,67444784u32,134578226u32,436584502u32,67493955u32,33947717u32,
134619206u32,268845130u32,369516626u32,33988701u32,470204510u32,168222828u32,
67567729u32,34021491u32,34029684u32,67592309u32,67600503u32,134717561u32,
134725757u32,101179521u32,67633284u32,201859206u32,34095244u32,67657869u32,
34128015u32,101253264u32,67707027u32,134832277u32,34177177u32,168403098u32,
67764383u32,34218145u32,235569314u32,134914217u32,34259117u32,134930606u32,
34275506u32,34283699u32,101400756u32,134963383u32,537624763u32,34316491u32,
67887308u32,135012558u32,302801106u32,202154203u32,67944673u32,34406627u32,
34414820u32,34423013u32,34431206u32,34439399u32,68002024u32,168698090u32,
135151855u32,638476531u32,34504966u32,34513159u32,34545928u32,437215497u32,
68124950u32,168796440u32,202367261u32,34603299u32,34619684u32,101736741u32,
101744936u32,68198699u32,34652461u32,370204974u32,34668857u32,269558074u32,
538018114u32,772907346u32,303153513u32,34726258u32,34734451u32,34742644u32,
34767221u32,236102006u32,135455101u32,34800001u32,236142978u32,135487881u32,
269713805u32,34840981u32,34849174u32,34857367u32,135528856u32,34890140u32,
68452765u32,169124255u32,68469156u32,34931110u32,34955687u32,34996648u32,
35004841u32,35021226u32,68592043u32,35045805u32,135717294u32,68616626u32,
68624820u32,35086774u32,135766455u32,135774651u32,270025151u32,102269383u32,
236495306u32,35176913u32,102293970u32,169419221u32,102318554u32,68772317u32,
135889375u32,102343139u32,35242470u32,35258855u32,35267048u32,35283433u32,
68854250u32,35308012u32,35332589u32,169574894u32,35373555u32,68993524u32,
69009910u32,102588920u32,35512827u32,69100028u32,136217086u32,35561986u32,
35586563u32,69149188u32,69157382u32,102720008u32,35635723u32,35660300u32,
136339981u32,69247505u32,136364563u32,69263895u32,69272089u32,35742235u32,
35750428u32,136421917u32,35766817u32,102883874u32,136446501u32,35791401u32,
35815978u32,102933035u32,35840558u32,35848751u32,69427760u32,35897906u32,
69460531u32,69468725u32,69493303u32,103055929u32,35955260u32,69534269u32,
270869055u32,203776583u32,36012621u32,170238542u32,36029011u32,136700500u32,
237371992u32,103162463u32,270942818u32,69624426u32,36078188u32,103203437u32,
36102768u32,36110961u32,69689970u32,69698164u32,69706358u32,36160120u32,
69722745u32,69730939u32,338174589u32,304628359u32,69755536u32,36217490u32,
338215571u32,69788317u32,69796511u32,36258465u32,36266658u32,69829283u32,
36324005u32,36332198u32,69911207u32,103473833u32,170590892u32,271262385u32,
36397753u32,36414138u32,103531195u32,69993150u32,36446912u32,70009537u32,
70017731u32,70025925u32,36496071u32,36504264u32,372056777u32,137192148u32,
36545240u32,103662297u32,36561628u32,103686877u32,36586208u32,170812129u32,
36627174u32,36635367u32,103752424u32,36659947u32,103777004u32,271557359u32,
271573751u32,170926847u32,36733700u32,36750085u32,70312710u32,405873416u32,
103891732u32,103924503u32,204604186u32,70411040u32,405971746u32,36889390u32,
70452015u32,36905777u32,36913970u32,36930355u32,104047412u32,70501175u32,
36954937u32,171180858u32,36971327u32,36979520u32,439640897u32,305431374u32,
104112983u32,171238234u32,37036895u32,37045088u32,37053281u32,37061474u32,
137757539u32,70656871u32,37110633u32,137782122u32,204940142u32,70730612u32,
104301430u32,37208953u32,37217146u32,37241723u32,37249916u32,37266301u32,
104383358u32,37282689u32,37307266u32,70869891u32,70886277u32,104448903u32,
70902666u32,37397388u32,37405581u32,138077070u32,37421970u32,138093459u32,
37438359u32,37446552u32,37454745u32,71017370u32,171705244u32,406594465u32,
272417709u32,138208181u32,339542969u32,37561283u32,71123908u32,71148486u32,
37602248u32,104719305u32,37626828u32,71205837u32,37659599u32,37667792u32,
37675985u32,37684178u32,272573395u32,138396635u32,138404831u32,71304163u32,
104866789u32,104874984u32,138453995u32,104907759u32,104924146u32,474031093u32,
104940547u32,172057606u32,37848075u32,71410700u32,71418894u32,205644816u32,
104989718u32,440542233u32,339887142u32,172123184u32,507675701u32,172139588u32,
37946441u32,37954634u32,138634315u32,37979215u32,306431056u32,71558233u32,
71574619u32,38077533u32,71640158u32,38093920u32,138773601u32,38118501u32,
239453286u32,38143085u32,172369006u32,71722099u32,138847349u32,138855545u32,
340190333u32,407307399u32,373761171u32,172442782u32,38249635u32,38266020u32,
38282405u32,71845030u32,71853224u32,38306986u32,38315179u32,105432236u32,
71894191u32,71902385u32,206128307u32,105473209u32,38380732u32,38397117u32,
38405310u32,38413503u32,38421696u32,239764673u32,72000712u32,38454474u32,
72017099u32,38470861u32,72041678u32,139158736u32,38503636u32,172737749u32,
72082650u32,72090844u32,105653470u32,38552801u32,72115426u32,508331236u32,
105686259u32,38585590u32,38593783u32,38618360u32,206398713u32,340624639u32,
172860681u32,810403086u32,105768230u32,38667561u32,139371818u32,38733102u32,
38749487u32,38757680u32,139429169u32,105882933u32,72344888u32,105932090u32,
38839613u32,139519294u32,38872386u32,105989443u32,173114694u32,374449483u32,
374457686u32,340911457u32,72484203u32,139601261u32,72516977u32,38970739u32,
206759284u32,38995322u32,307438971u32,72574340u32,39028102u32,106145159u32,
39052682u32,39060875u32,39069068u32,106194317u32,39093648u32,72656273u32,
106227091u32,39126422u32,72689047u32,39142809u32,106259866u32,39175581u32,
39183774u32,39208351u32,72770976u32,39224738u32,139896227u32,39241127u32,
39249320u32,39257513u32,207037866u32,39273904u32,39282097u32,39290290u32,
72861107u32,39339445u32,39347638u32,39355831u32,39364024u32,39380409u32,
72943034u32,39396796u32,374949309u32,72967624u32,72984010u32,39437772u32,
39445965u32,39454158u32,73016783u32,39470545u32,140142034u32,240813526u32,
73049565u32,106612191u32,39519714u32,140191203u32,106653159u32,106669546u32,
106735085u32,73188848u32,106751474u32,274531829u32,140322301u32,140338689u32,
140346885u32,39691785u32,173917706u32,73270799u32,106833425u32,106841620u32,
106858007u32,106866202u32,73319965u32,173991455u32,140445220u32,39790120u32,
274679337u32,106915377u32,73377332u32,207603254u32,274720316u32,207619652u32,
73418314u32,442525260u32,207652441u32,375449183u32,1247872618u32,207701647u32,
375498389u32,241288864u32,73533095u32,39986857u32,107112106u32,73590445u32,
40044207u32,140723888u32,107177652u32,73631415u32,174319289u32,73664190u32,
73688768u32,107251394u32,40150725u32,40167110u32,40175303u32,241518280u32,
40216271u32,73778896u32,73787090u32,241575636u32,208029403u32,275146465u32,
73828073u32,476489451u32,711378681u32,40298254u32,140969743u32,107423507u32,
107431702u32,2087151385u32,275220311u32,1550296927u32,241682317u32,
4268222356u32,443017235u32,174589984u32,174598181u32,1952991274u32,812148836u32,
107513980u32,40527999u32,40568960u32,74172545u32,40822915u32,40929412u32,
40986757u32,41085062u32,41216135u32,41257096u32,41363593u32,41560202u32,
41568395u32,242903180u32,41584787u32,343591060u32,75171998u32,41633952u32,
41650337u32,142321826u32,41666726u32,175900839u32,108816556u32,75270319u32,
41732273u32,142403762u32,142411958u32,75311290u32,276646076u32,41773252u32,
41781445u32,176007366u32,176015563u32,75360464u32,41830610u32,75393235u32,
75401429u32,243181783u32,41871582u32,176097503u32,75450596u32,41912550u32,
41920743u32,109037800u32,142600427u32,41945327u32,41953520u32,176179441u32,
75532534u32,209758456u32,109119742u32,75581697u32,142698755u32,42043655u32,
42060040u32,243394825u32,109193488u32,42101011u32,142797076u32,75712792u32,
42166554u32,42174747u32,75778332u32,109340958u32,42240289u32,75802914u32,
210069796u32,42305834u32,42314027u32,75901228u32,42354990u32,42363183u32,
75925808u32,75942194u32,109504820u32,143092023u32,42436923u32,109553980u32,
42453311u32,478669120u32,210250062u32,445139284u32,76056929u32,42518883u32,
42535268u32,42543461u32,210332006u32,76122476u32,42576238u32,42584431u32,
42617200u32,42649969u32,109775218u32,42690933u32,42715510u32,42731895u32,
76294520u32,76302714u32,42756476u32,42830205u32,177056126u32,244189571u32,
42879370u32,76482955u32,76491149u32,42953103u32,43010448u32,43059601u32,
43067794u32,43075987u32,43084180u32,143763861u32,110217625u32,76671388u32,
76687774u32,43198880u32,43207073u32,43215266u32,110332323u32,445884838u32,
76794291u32,43248053u32,110373302u32,43272633u32,177498554u32,244615615u32,
43297222u32,43305415u32,110438856u32,43346379u32,110479820u32,177605071u32,
144058836u32,43403736u32,43411929u32,110528986u32,43436509u32,77007326u32,
144124384u32,43526628u32,177752549u32,43543018u32,144214507u32,43559407u32,
211339760u32,77130230u32,177818104u32,77163005u32,43616767u32,43624960u32,
278514177u32,211413513u32,144321039u32,77244947u32,110807573u32,43706904u32,
748358169u32,110832175u32,77285938u32,43739700u32,177973813u32,211544634u32,
43788864u32,43797057u32,43821634u32,178063939u32,77417032u32,43870794u32,
43878987u32,211659340u32,43903570u32,43919955u32,144607828u32,43952728u32,
43985497u32,44010074u32,44067419u32,77630044u32,178301534u32,77646435u32,
44100197u32,44108390u32,111225447u32,279005802u32,44132978u32,144804467u32,
279030391u32,178375295u32,44182148u32,144870021u32,77777545u32,77802123u32,
44255885u32,111372942u32,44272273u32,44288658u32,44313235u32,144992916u32,
77908632u32,44370586u32,44378779u32,77941404u32,44411550u32,44493471u32,
78064288u32,111643298u32,78105253u32,78113447u32,78121641u32,44583595u32,
44632748u32,44673709u32,78244526u32,44706480u32,44739249u32,145435314u32,
111889078u32,44788409u32,78351034u32,78359228u32,44812990u32,44821183u32,
179047104u32,78457541u32,44911303u32,44927688u32,78490313u32,44952267u32,
78514892u32,346974926u32,78555864u32,45026010u32,45034203u32,45042396u32,
45075165u32,45099742u32,112216799u32,78670562u32,78678756u32,45140710u32,
179366631u32,45181676u32,179407597u32,45214450u32,45247219u32,246680308u32,
78924539u32,246721277u32,78965508u32,146082566u32,112536330u32,146107149u32,
79006481u32,45468435u32,45476628u32,246811413u32,146180892u32,45558560u32,
45599521u32,79170338u32,112741156u32,45640487u32,79203112u32,45656874u32,
79219499u32,146336557u32,45681457u32,45689650u32,112806707u32,45714230u32,
112847671u32,112855866u32,179981117u32,180005698u32,112913223u32,112921418u32,
45820749u32,45837134u32,146508623u32,45886291u32,213666644u32,113011546u32,
213691229u32,280841059u32,213740395u32,113085297u32,280873844u32,347990908u32,
180226950u32,46017419u32,146713484u32,46058384u32,180284305u32,46074774u32,
113208215u32,46107546u32,46115739u32,46132124u32,46140317u32,247475102u32,
146820005u32,46181289u32,46197674u32,281086891u32,46214067u32,79776692u32,
146893750u32,448891834u32,79801287u32,46255049u32,113372106u32,79842253u32,
46296015u32,46304208u32,79866833u32,146983891u32,79891415u32,79899609u32,
46361563u32,79924188u32,214150110u32,46386148u32,79956965u32,46410727u32,
180644840u32,113544173u32,381987824u32,80006139u32,415558653u32,147131401u32,
46476301u32,113593358u32,80047121u32,147164179u32,46509079u32,314952728u32,
348523553u32,180808747u32,147262512u32,382168116u32,80186431u32,147303489u32,
180866117u32,113765450u32,315100237u32,46672982u32,147344471u32,80260187u32,
180931677u32,46730338u32,248065123u32,382291050u32,248089717u32,113880188u32,
46779519u32,113896576u32,214584451u32,46820489u32,248155274u32,248163473u32,
181062808u32,80415901u32,46869663u32,214650016u32,248212646u32,147557549u32,
583773361u32,114019522u32,181136581u32,382471370u32,147598549u32,550259929u32,
46951657u32,483167466u32,114076920u32,550292731u32,80571659u32,181243149u32,
114142482u32,114150677u32,281931032u32,47066400u32,80629025u32,248409379u32,
248491306u32,181415217u32,47205686u32,214986039u32,181447997u32,80801090u32,
47279428u32,80842053u32,80866631u32,114445641u32,181562700u32,114462033u32,
47361364u32,47377749u32,80956758u32,80989528u32,114552154u32,47459677u32,
81022302u32,148147552u32,148155748u32,114609512u32,47517035u32,114666860u32,
148237679u32,47582579u32,47590772u32,114716021u32,81194360u32,148311418u32,
47664510u32,47672703u32,47689088u32,47697281u32,47705474u32,81268099u32,
47738245u32,114855302u32,148417929u32,81317261u32,81325455u32,81333649u32,
114896275u32,81350038u32,249138584u32,81391007u32,47844769u32,148516258u32,
114970022u32,47869353u32,215649706u32,81440176u32,282791346u32,47918522u32,
115035579u32,47934910u32,148606399u32,115084739u32,47992262u32,81554887u32,
81563081u32,48016843u32,182242764u32,115142097u32,249368020u32,282930651u32,
81612259u32,48082405u32,115199462u32,48098793u32,148770282u32,81669614u32,
81677808u32,182349298u32,115248631u32,182373882u32,249507327u32,148852230u32,
148860426u32,148868622u32,115322386u32,350211605u32,148893215u32,148901411u32,
216018471u32,283135533u32,48262709u32,148942390u32,182505018u32,518065727u32,
216084046u32,81874516u32,115437142u32,115445337u32,216125020u32,216141410u32,
81931880u32,48385642u32,249720427u32,81989234u32,48451188u32,48467573u32,
48475766u32,48483959u32,149155448u32,182718076u32,48524929u32,48541314u32,
82112131u32,82120325u32,48574087u32,149245576u32,115699340u32,182816399u32,
182824596u32,48615065u32,216395418u32,48631456u32,115748513u32,182865572u32,
149319337u32,149327533u32,82235057u32,82251443u32,149368501u32,115822265u32,
48721596u32,82292413u32,182972095u32,82316996u32,82349766u32,250130120u32,
48819919u32,115945168u32,82407123u32,48860885u32,115977942u32,250203865u32,
183103200u32,48893669u32,183127782u32,183152363u32,116051696u32,149614323u32,
149630711u32,116084475u32,48983806u32,350981887u32,82554633u32,854314763u32,
216796964u32,686567210u32,116150078u32,49049409u32,49057602u32,82620227u32,
1961676613u32,49090431u32,49164160u32,116313985u32,116322180u32,49221511u32,
49229704u32,149901193u32,49246093u32,149925774u32,116379538u32,116387733u32,
418385816u32,217067428u32,1827688362u32,317747168u32,1626378217u32,519090201u32,
284225576u32,3874558000u32,1022439587u32,2129744065u32,183595264u32,
1727107333u32,49484088u32,49516857u32,49590586u32,49680699u32,49746236u32,
49951037u32,50196798u32,50360639u32,319000896u32,151236937u32,50590029u32,
84152654u32,285487440u32,151277912u32,218394972u32,251965794u32,251982185u32,
151327088u32,252014964u32,84251003u32,117813629u32,50721152u32,252055937u32,
117846408u32,4278604171u32,184963594u32,50770447u32,84718096u32,51196434u32,
51253779u32,51294740u32,118419989u32,51319320u32,84881945u32,84890139u32,
319812125u32,84939302u32,152064552u32,185635372u32,84980273u32,353423923u32,
118551101u32,454103616u32,51458637u32,85037646u32,51491408u32,51499601u32,
51507794u32,118633043u32,51540566u32,152212055u32,51565147u32,51581532u32,
152253021u32,85160545u32,51622499u32,118755940u32,118772327u32,51671658u32,
85250667u32,118813293u32,51712624u32,51720817u32,51761778u32,253096563u32,
118887034u32,51794557u32,85357182u32,152474240u32,286700164u32,85398156u32,
186077838u32,51876499u32,51884692u32,51901077u32,119018134u32,119026329u32,
85488284u32,85496478u32,51966624u32,85529249u32,186233507u32,219804328u32,
421139118u32,85603002u32,85611196u32,52073150u32,52089535u32,52097728u32,
52105921u32,186331842u32,85676743u32,52130505u32,119247562u32,52146893u32,
253481678u32,119280341u32,253506264u32,52187871u32,421294816u32,85766892u32,
85775086u32,253555440u32,656216823u32,4280103690u32,823997321u32,52278177u32,
52450210u32,52540323u32,52581284u32,52663205u32,119788454u32,153351081u32,
52704173u32,153375662u32,153392050u32,86291382u32,119854008u32,86315963u32,
52777917u32,52794302u32,187028415u32,52818884u32,52835269u32,86414278u32,
52876232u32,86471625u32,52925387u32,52949964u32,52982733u32,52999118u32,
86561743u32,120124369u32,120148948u32,86602711u32,86660057u32,53130203u32,
53138396u32,53171165u32,53179358u32,86750175u32,53212129u32,120370146u32,
221041637u32,187511787u32,53310448u32,86873073u32,53335027u32,86897652u32,
53359606u32,86922231u32,187593721u32,53384190u32,120534015u32,86995970u32,
221221892u32,53466122u32,87028747u32,154145805u32,187716625u32,254841878u32,
53523485u32,53539870u32,154219551u32,87118883u32,187790373u32,53580842u32,
53589035u32,53597228u32,53605421u32,53613614u32,53621807u32,120738864u32,
87209011u32,120771637u32,53670968u32,53679161u32,53711930u32,53744699u32,
87331900u32,87340094u32,87348288u32,53810242u32,87372867u32,120935493u32,
53859400u32,120976457u32,120984652u32,121009231u32,121025618u32,87495765u32,
53949527u32,53957720u32,154629209u32,121082973u32,154645600u32,121107556u32,
54006887u32,691549288u32,154686588u32,121140352u32,389592195u32,54056078u32,
255390863u32,322507926u32,87635103u32,87643297u32,54154403u32,154825892u32,
87725224u32,87733418u32,87749804u32,121345198u32,54252721u32,54260914u32,
54301875u32,121459892u32,188593335u32,54383804u32,54391997u32,54400190u32,
87979199u32,255775937u32,222237896u32,222254286u32,88044756u32,155178198u32,
155194586u32,423638238u32,54547690u32,54564075u32,54596844u32,356594925u32,
4282471671u32,826365302u32,859927950u32,1061262759u32,859944390u32,
3946960351u32,1463940692u32,1229067903u32,1967273635u32,390223581u32,
3477239528u32,1497536335u32,860010363u32,54802324u32,54835093u32,54843286u32,
55220119u32,55277464u32,88856473u32,55343003u32,55433116u32,55596957u32,
55859102u32,55883679u32,55932832u32,56022945u32,56096674u32,56137635u32,
56170404u32,56186789u32,56260518u32,56293287u32,56334248u32,56440745u32,
90036138u32,291370924u32,3512604596u32,56530972u32,56678429u32,56735774u32,
56825887u32,56858656u32,56875041u32,56891426u32,56899619u32,258242596u32,
124033067u32,90486830u32,157644848u32,57006132u32,57022517u32,57030710u32,
57079863u32,90658872u32,124221498u32,191346749u32,124246082u32,57145413u32,
57161798u32,90724423u32,57202761u32,191428682u32,57219151u32,459905104u32,
57268317u32,90830942u32,57284704u32,57292897u32,124418146u32,90871909u32,
90896487u32,359340137u32,292239475u32,90921083u32,90929277u32,90937471u32,
90945665u32,57415811u32,90986628u32,57464966u32,91027591u32,91060361u32,
91068555u32,359512205u32,258857111u32,158218398u32,124672162u32,91125925u32,
57587879u32,158259368u32,57604268u32,91175085u32,57628847u32,124770480u32,
124795059u32,91248822u32,191920312u32,57710781u32,393263294u32,91281609u32,
91289803u32,57743565u32,191969486u32,158431443u32,661756119u32,91347178u32,
91355372u32,57809134u32,91371759u32,57825521u32,91404530u32,124967156u32,
326301943u32,57882880u32,192108801u32,292780294u32,192125198u32,57915667u32,
125032724u32,57940247u32,125057304u32,259283227u32,91519266u32,259299620u32,
57981227u32,57989420u32,91552045u32,58005807u32,1668626736u32,58030433u32,
192289122u32,58079591u32,4252399976u32,58276326u32,58292711u32,58317288u32,
58333673u32,58358250u32,58431979u32,1299978732u32,92027410u32,58497556u32,
92060181u32,125639191u32,259873306u32,1232968225u32,92125765u32,998103623u32,
1266547300u32,461257353u32,58612374u32,58620567u32,58718872u32,92306073u32,
58759835u32,58776220u32,92355229u32,58841759u32,58858144u32,58866337u32,
394500770u32,92519085u32,4286831279u32,2307119918u32,59022194u32,59153267u32,
59194228u32,92773237u32,92814199u32,59284345u32,59382650u32,260725627u32,
160078722u32,59440006u32,59448199u32,126565256u32,93035403u32,193706893u32,
160168850u32,59513750u32,160185239u32,227302299u32,59538337u32,160209826u32,
160218022u32,59562922u32,59571115u32,328014764u32,59587509u32,260922294u32,
160267197u32,227384257u32,126729159u32,395172810u32,126745557u32,395189208u32,
93207523u32,294542309u32,160340973u32,59718641u32,126852082u32,59751413u32,
59759606u32,93322231u32,4287634425u32,4287634552u32,1401953527u32,93338912u32,
59792674u32,93363491u32,93396261u32,59850023u32,59866408u32,59890985u32,
160570666u32,59931950u32,60030255u32,60038448u32,60054833u32,60128562u32,
194379059u32,93756728u32,93814074u32,93871420u32,93904190u32,4288216384u32,
4288216511u32,2107178558u32,60399228u32,60415613u32,60464766u32,60472959u32,
60497536u32,94101121u32,60571267u32,60669572u32,60685957u32,127803014u32,
60702345u32,60718730u32,60743307u32,161414796u32,60767888u32,94387857u32,
60849811u32,362847892u32,94428830u32,161545888u32,94453412u32,228679334u32,
329359020u32,60931765u32,228712118u32,463601340u32,128065225u32,94518988u32,
60972750u32,195206863u32,161660628u32,128114392u32,61030107u32,94592732u32,
128155358u32,94609121u32,61079267u32,61095652u32,94658277u32,61112039u32,
61120232u32,161799913u32,329580269u32,61153014u32,61169399u32,430276344u32,
61185796u32,61202181u32,94764806u32,128327432u32,61226763u32,229007116u32,
61243154u32,329686803u32,94813980u32,94822174u32,
]
const GB18030RunsOffset2* = 29404u16
const GB18030Decode*: array[9220, uint16] = [
uint16 12288,12289,12290,183,713,711,168,12291,12293,8212,65374,8214,8230,8216,8217,
8220,8221,12308,12309,12296,12297,12298,12299,12300,12301,12302,12303,12310,
12311,12304,12305,177,215,247,8758,8743,8744,8721,8719,8746,8745,8712,8759,8730,
8869,8741,8736,8978,8857,8747,8750,8801,8780,8776,8765,8733,8800,8814,8815,8804,
8805,8734,8757,8756,9794,9792,176,8242,8243,8451,65284,164,65504,65505,8240,167,
8470,9734,9733,9675,9679,9678,9671,9670,9633,9632,9651,9650,8251,8594,8592,8593,
8595,12307,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,59238,59239,59240,
59241,59242,59243,9352,9353,9354,9355,9356,9357,9358,9359,9360,9361,9362,9363,
9364,9365,9366,9367,9368,9369,9370,9371,9332,9333,9334,9335,9336,9337,9338,9339,
9340,9341,9342,9343,9344,9345,9346,9347,9348,9349,9350,9351,9312,9313,9314,9315,
9316,9317,9318,9319,9320,9321,8364,59245,12832,12833,12834,12835,12836,12837,
12838,12839,12840,12841,59246,59247,8544,8545,8546,8547,8548,8549,8550,8551,
8552,8553,8554,8555,59248,59249,65281,65282,65283,65509,65285,65286,65287,65288,
65289,65290,65291,65292,65293,65294,65295,65296,65297,65298,65299,65300,65301,
65302,65303,65304,65305,65306,65307,65308,65309,65310,65311,65312,65313,65314,
65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,
65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,65339,65340,
65341,65342,65343,65344,65345,65346,65347,65348,65349,65350,65351,65352,65353,
65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,
65367,65368,65369,65370,65371,65372,65373,65507,12353,12354,12355,12356,12357,
12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,
12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,
12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,
12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,
12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,
12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,
59250,59251,59252,59253,59254,59255,59256,59257,59258,59259,59260,12449,12450,
12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,12461,12462,12463,
12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,12474,12475,12476,
12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,12487,12488,12489,
12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,12500,12501,12502,
12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,12513,12514,12515,
12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,12526,12527,12528,
12529,12530,12531,12532,12533,12534,59261,59262,59263,59264,59265,59266,59267,
59268,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,
932,933,934,935,936,937,59269,59270,59271,59272,59273,59274,59275,59276,945,946,
947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,
968,969,65040,65042,65041,65043,65044,65045,65046,65077,65078,65081,65082,65087,
65088,65085,65086,65089,65090,65091,65092,65047,65048,65083,65084,65079,65080,
65073,65049,65075,65076,59287,59288,59289,59290,59291,59292,59293,59294,59295,
1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,
1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,
1071,59296,59297,59298,59299,59300,59301,59302,59303,59304,59305,59306,59307,
59308,59309,59310,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,
1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,
1099,1100,1101,1102,1103,59311,59312,59313,59314,59315,59316,59317,59318,59319,
59320,59321,59322,59323,714,715,729,8211,8213,8229,8245,8453,8457,8598,8599,
8600,8601,8725,8735,8739,8786,8806,8807,8895,9552,9553,9554,9555,9556,9557,9558,
9559,9560,9561,9562,9563,9564,9565,9566,9567,9568,9569,9570,9571,9572,9573,9574,
9575,9576,9577,9578,9579,9580,9581,9582,9583,9584,9585,9586,9587,9601,9602,9603,
9604,9605,9606,9607,9608,9609,9610,9611,9612,9613,9614,9615,9619,9620,9621,9660,
9661,9698,9699,9700,9701,9737,8853,12306,12317,12318,59324,59325,59326,59327,
59328,59329,59330,59331,59332,59333,59334,257,225,462,224,275,233,283,232,299,
237,464,236,333,243,466,242,363,250,468,249,470,472,474,476,252,234,593,7743,
324,328,505,609,59337,59338,59339,59340,12549,12550,12551,12552,12553,12554,
12555,12556,12557,12558,12559,12560,12561,12562,12563,12564,12565,12566,12567,
12568,12569,12570,12571,12572,12573,12574,12575,12576,12577,12578,12579,12580,
12581,12582,12583,12584,12585,59341,59342,59343,59344,59345,59346,59347,59348,
59349,59350,59351,59352,59353,59354,59355,59356,59357,59358,59359,59360,59361,
12321,12322,12323,12324,12325,12326,12327,12328,12329,12963,13198,13199,13212,
13213,13214,13217,13252,13262,13265,13266,13269,65072,65506,65508,59362,8481,
12849,59363,8208,59364,59365,59366,12540,12443,12444,12541,12542,12294,12445,
12446,65097,65098,65099,65100,65101,65102,65103,65104,65105,65106,65108,65109,
65110,65111,65113,65114,65115,65116,65117,65118,65119,65120,65121,65122,65123,
65124,65125,65126,65128,65129,65130,65131,12350,12272,12273,12274,12275,12276,
12277,12278,12279,12280,12281,12282,12283,12295,59380,59381,59382,59383,59384,
59385,59386,59387,59388,59389,59390,59391,59392,9472,9473,9474,9475,9476,9477,
9478,9479,9480,9481,9482,9483,9484,9485,9486,9487,9488,9489,9490,9491,9492,9493,
9494,9495,9496,9497,9498,9499,9500,9501,9502,9503,9504,9505,9506,9507,9508,9509,
9510,9511,9512,9513,9514,9515,9516,9517,9518,9519,9520,9521,9522,9523,9524,9525,
9526,9527,9528,9529,9530,9531,9532,9533,9534,9535,9536,9537,9538,9539,9540,9541,
9542,9543,9544,9545,9546,9547,59393,59394,59395,59396,59397,59398,59399,59400,
59401,59402,59403,59404,59405,59406,59407,57344,57345,57346,57347,57348,57349,
57350,57351,57352,57353,57354,57355,57356,57357,57358,57359,57360,57361,57362,
57363,57364,57365,57366,57367,57368,57369,57370,57371,57372,57373,57374,57375,
57376,57377,57378,57379,57380,57381,57382,57383,57384,57385,57386,57387,57388,
57389,57390,57391,57392,57393,57394,57395,57396,57397,57398,57399,57400,57401,
57402,57403,57404,57405,57406,57407,57408,57409,57410,57411,57412,57413,57414,
57415,57416,57417,57418,57419,57420,57421,57422,57423,57424,57425,57426,57427,
57428,57429,57430,57431,57432,57433,57434,57435,57436,57437,57438,57439,57440,
57441,57442,57443,57444,57445,57446,57447,57448,57449,57450,57451,57452,57453,
57454,57455,57456,57457,57458,57459,57460,57461,57462,57463,57464,57465,57466,
57467,57468,57469,57470,57471,57472,57473,57474,57475,57476,57477,57478,57479,
57480,57481,57482,57483,57484,57485,57486,57487,57488,57489,57490,57491,57492,
57493,57494,57495,57496,57497,57498,57499,57500,57501,57502,57503,57504,57505,
57506,57507,57508,57509,57510,57511,57512,57513,57514,57515,57516,57517,57518,
57519,57520,57521,57522,57523,57524,57525,57526,57527,57528,57529,57530,57531,
57532,57533,57534,57535,57536,57537,57538,57539,57540,57541,57542,57543,57544,
57545,57546,57547,57548,57549,57550,57551,57552,57553,57554,57555,57556,57557,
57558,57559,57560,57561,57562,57563,57564,57565,57566,57567,57568,57569,57570,
57571,57572,57573,57574,57575,57576,57577,57578,57579,57580,57581,57582,57583,
57584,57585,57586,57587,57588,57589,57590,57591,57592,57593,57594,57595,57596,
57597,57598,57599,57600,57601,57602,57603,57604,57605,57606,57607,57608,57609,
57610,57611,57612,57613,57614,57615,57616,57617,57618,57619,57620,57621,57622,
57623,57624,57625,57626,57627,57628,57629,57630,57631,57632,57633,57634,57635,
57636,57637,57638,57639,57640,57641,57642,57643,57644,57645,57646,57647,57648,
57649,57650,57651,57652,57653,57654,57655,57656,57657,57658,57659,57660,57661,
57662,57663,57664,57665,57666,57667,57668,57669,57670,57671,57672,57673,57674,
57675,57676,57677,57678,57679,57680,57681,57682,57683,57684,57685,57686,57687,
57688,57689,57690,57691,57692,57693,57694,57695,57696,57697,57698,57699,57700,
57701,57702,57703,57704,57705,57706,57707,57708,57709,57710,57711,57712,57713,
57714,57715,57716,57717,57718,57719,57720,57721,57722,57723,57724,57725,57726,
57727,57728,57729,57730,57731,57732,57733,57734,57735,57736,57737,57738,57739,
57740,57741,57742,57743,57744,57745,57746,57747,57748,57749,57750,57751,57752,
57753,57754,57755,57756,57757,57758,57759,57760,57761,57762,57763,57764,57765,
57766,57767,57768,57769,57770,57771,57772,57773,57774,57775,57776,57777,57778,
57779,57780,57781,57782,57783,57784,57785,57786,57787,57788,57789,57790,57791,
57792,57793,57794,57795,57796,57797,57798,57799,57800,57801,57802,57803,57804,
57805,57806,57807,57808,57809,57810,57811,57812,57813,57814,57815,57816,57817,
57818,57819,57820,57821,57822,57823,57824,57825,57826,57827,57828,57829,57830,
57831,57832,57833,57834,57835,57836,57837,57838,57839,57840,57841,57842,57843,
57844,57845,57846,57847,57848,57849,57850,57851,57852,57853,57854,57855,57856,
57857,57858,57859,57860,57861,57862,57863,57864,57865,57866,57867,57868,57869,
57870,57871,57872,57873,57874,57875,57876,57877,57878,57879,57880,57881,57882,
57883,57884,57885,57886,57887,57888,57889,57890,57891,57892,57893,57894,57895,
57896,57897,57898,57899,57900,57901,57902,57903,57904,57905,57906,57907,21834,
38463,22467,25384,21710,21769,21696,30353,30284,34108,30702,33406,30861,29233,
38552,38797,27688,23433,20474,25353,26263,23736,33018,26696,32942,26114,30414,
20985,25942,29100,32753,34948,20658,22885,25034,28595,33453,25420,25170,21485,
21543,31494,20843,30116,24052,25300,36299,38774,25226,32793,22365,38712,32610,
29240,30333,26575,30334,25670,20336,36133,25308,31255,26001,29677,25644,25203,
33324,39041,26495,29256,25198,25292,20276,29923,21322,21150,32458,37030,24110,
26758,27036,33152,32465,26834,30917,34444,38225,20621,35876,33502,32990,21253,
35090,21093,34180,38649,20445,22561,39281,23453,25265,25253,26292,35961,40077,
29190,26479,30865,24754,21329,21271,36744,32972,36125,38049,20493,29384,22791,
24811,28953,34987,22868,33519,26412,31528,23849,32503,29997,27893,36454,36856,
36924,40763,27604,37145,31508,24444,30887,34006,34109,27605,27609,27606,24065,
24199,30201,38381,25949,24330,24517,36767,22721,33218,36991,38491,38829,36793,
32534,36140,25153,20415,21464,21342,36776,36777,36779,36941,26631,24426,33176,
34920,40150,24971,21035,30250,24428,25996,28626,28392,23486,25672,20853,20912,
26564,19993,31177,39292,28851,30149,24182,29627,33760,25773,25320,38069,27874,
21338,21187,25615,38082,31636,20271,24091,33334,33046,33162,28196,27850,39539,
25429,21340,21754,34917,22496,19981,24067,27493,31807,37096,24598,25830,29468,
35009,26448,25165,36130,30572,36393,37319,24425,33756,34081,39184,21442,34453,
27531,24813,24808,28799,33485,33329,20179,27815,34255,25805,31961,27133,26361,
33609,21397,31574,20391,20876,27979,23618,36461,25554,21449,33580,33590,26597,
30900,25661,23519,23700,24046,35815,25286,26612,35962,25600,25530,34633,39307,
35863,32544,38130,20135,38416,39076,26124,29462,22330,23581,24120,38271,20607,
32928,21378,25950,30021,21809,20513,36229,25220,38046,26397,22066,28526,24034,
21557,28818,36710,25199,25764,25507,24443,28552,37108,33251,36784,23576,26216,
24561,27785,38472,36225,34924,25745,31216,22478,27225,25104,21576,20056,31243,
24809,28548,35802,25215,36894,39563,31204,21507,30196,25345,21273,27744,36831,
24347,39536,32827,40831,20360,23610,36196,32709,26021,28861,20805,20914,34411,
23815,23456,25277,37228,30068,36364,31264,24833,31609,20167,32504,30597,19985,
33261,21021,20986,27249,21416,36487,38148,38607,28353,38500,26970,30784,20648,
30679,25616,35302,22788,25571,24029,31359,26941,20256,33337,21912,20018,30126,
31383,24162,24202,38383,21019,21561,28810,25462,38180,22402,26149,26943,37255,
21767,28147,32431,34850,25139,32496,30133,33576,30913,38604,36766,24904,29943,
35789,27492,21050,36176,27425,32874,33905,22257,21254,20174,19995,20945,31895,
37259,31751,20419,36479,31713,31388,25703,23828,20652,33030,30209,31929,28140,
32736,26449,23384,23544,30923,25774,25619,25514,25387,38169,25645,36798,31572,
30249,25171,22823,21574,27513,20643,25140,24102,27526,20195,36151,34955,24453,
36910,24608,32829,25285,20025,21333,37112,25528,32966,26086,27694,20294,24814,
28129,35806,24377,34507,24403,25377,20826,33633,26723,20992,25443,36424,20498,
23707,31095,23548,21040,31291,24764,36947,30423,24503,24471,30340,36460,28783,
30331,31561,30634,20979,37011,22564,20302,28404,36842,25932,31515,29380,28068,
32735,23265,25269,24213,22320,33922,31532,24093,24351,36882,32532,39072,25474,
28359,30872,28857,20856,38747,22443,30005,20291,30008,24215,24806,22880,28096,
27583,30857,21500,38613,20939,20993,25481,21514,38035,35843,36300,29241,30879,
34678,36845,35853,21472,19969,30447,21486,38025,39030,40718,38189,23450,35746,
20002,19996,20908,33891,25026,21160,26635,20375,24683,20923,27934,20828,25238,
26007,38497,35910,36887,30168,37117,30563,27602,29322,29420,35835,22581,30585,
36172,26460,38208,32922,24230,28193,22930,31471,30701,38203,27573,26029,32526,
22534,20817,38431,23545,22697,21544,36466,25958,39039,22244,38045,30462,36929,
25479,21702,22810,22842,22427,36530,26421,36346,33333,21057,24816,22549,34558,
23784,40517,20420,39069,35769,23077,24694,21380,25212,36943,37122,39295,24681,
32780,20799,32819,23572,39285,27953,20108,36144,21457,32602,31567,20240,20047,
38400,27861,29648,34281,24070,30058,32763,27146,30718,38034,32321,20961,28902,
21453,36820,33539,36137,29359,39277,27867,22346,33459,26041,32938,25151,38450,
22952,20223,35775,32442,25918,33778,38750,21857,39134,32933,21290,35837,21536,
32954,24223,27832,36153,33452,37210,21545,27675,20998,32439,22367,28954,27774,
31881,22859,20221,24575,24868,31914,20016,23553,26539,34562,23792,38155,39118,
30127,28925,36898,20911,32541,35773,22857,20964,20315,21542,22827,25975,32932,
23413,25206,25282,36752,24133,27679,31526,20239,20440,26381,28014,28074,31119,
34993,24343,29995,25242,36741,20463,37340,26023,33071,33105,24220,33104,36212,
21103,35206,36171,22797,20613,20184,38428,29238,33145,36127,23500,35747,38468,
22919,32538,21648,22134,22030,35813,25913,27010,38041,30422,28297,24178,29976,
26438,26577,31487,32925,36214,24863,31174,25954,36195,20872,21018,38050,32568,
32923,32434,23703,28207,26464,31705,30347,39640,33167,32660,31957,25630,38224,
31295,21578,21733,27468,25601,25096,40509,33011,30105,21106,38761,33883,26684,
34532,38401,38548,38124,20010,21508,32473,26681,36319,32789,26356,24218,32697,
22466,32831,26775,24037,25915,21151,24685,40858,20379,36524,20844,23467,24339,
24041,27742,25329,36129,20849,38057,21246,27807,33503,29399,22434,26500,36141,
22815,36764,33735,21653,31629,20272,27837,23396,22993,40723,21476,34506,39592,
35895,32929,25925,39038,22266,38599,21038,29916,21072,23521,25346,35074,20054,
25296,24618,26874,20851,23448,20896,35266,31649,39302,32592,24815,28748,36143,
20809,24191,36891,29808,35268,22317,30789,24402,40863,38394,36712,39740,35809,
30328,26690,26588,36330,36149,21053,36746,28378,26829,38149,37101,22269,26524,
35065,36807,21704,39608,23401,28023,27686,20133,23475,39559,37219,25000,37039,
38889,21547,28085,23506,20989,21898,32597,32752,25788,25421,26097,25022,24717,
28938,27735,27721,22831,26477,33322,22741,22158,35946,27627,37085,22909,32791,
21495,28009,21621,21917,33655,33743,26680,31166,21644,20309,21512,30418,35977,
38402,27827,28088,36203,35088,40548,36154,22079,40657,30165,24456,29408,24680,
21756,20136,27178,34913,24658,36720,21700,28888,34425,40511,27946,23439,24344,
32418,21897,20399,29492,21564,21402,20505,21518,21628,20046,24573,29786,22774,
33899,32993,34676,29392,31946,28246,24359,34382,21804,25252,20114,27818,25143,
33457,21719,21326,29502,28369,30011,21010,21270,35805,27088,24458,24576,28142,
22351,27426,29615,26707,36824,32531,25442,24739,21796,30186,35938,28949,28067,
23462,24187,33618,24908,40644,30970,34647,31783,30343,20976,24822,29004,26179,
24140,24653,35854,28784,25381,36745,24509,24674,34516,22238,27585,24724,24935,
21321,24800,26214,36159,31229,20250,28905,27719,35763,35826,32472,33636,26127,
23130,39746,27985,28151,35905,27963,20249,28779,33719,25110,24785,38669,36135,
31096,20987,22334,22522,26426,30072,31293,31215,31637,32908,39269,36857,28608,
35749,40481,23020,32489,32521,21513,26497,26840,36753,31821,38598,21450,24613,
30142,27762,21363,23241,32423,25380,20960,33034,24049,34015,25216,20864,23395,
20238,31085,21058,24760,27982,23492,23490,35745,35760,26082,24524,38469,22931,
32487,32426,22025,26551,22841,20339,23478,21152,33626,39050,36158,30002,38078,
20551,31292,20215,26550,39550,23233,27516,30417,22362,23574,31546,38388,29006,
20860,32937,33392,22904,32516,33575,26816,26604,30897,30839,25315,25441,31616,
20461,21098,20943,33616,27099,37492,36341,36145,35265,38190,31661,20214,20581,
33328,21073,39279,28176,28293,28071,24314,20725,23004,23558,27974,27743,30086,
33931,26728,22870,35762,21280,37233,38477,34121,26898,30977,28966,33014,20132,
37066,27975,39556,23047,22204,25605,38128,30699,20389,33050,29409,35282,39290,
32564,32478,21119,25945,37237,36735,36739,21483,31382,25581,25509,30342,31224,
34903,38454,25130,21163,33410,26708,26480,25463,30571,31469,27905,32467,35299,
22992,25106,34249,33445,30028,20511,20171,30117,35819,23626,24062,31563,26020,
37329,20170,27941,35167,32039,38182,20165,35880,36827,38771,26187,31105,36817,
28908,28024,23613,21170,33606,20834,33550,30555,26230,40120,20140,24778,31934,
31923,32463,20117,35686,26223,39048,38745,22659,25964,38236,24452,30153,38742,
31455,31454,20928,28847,31384,25578,31350,32416,29590,38893,20037,28792,20061,
37202,21417,25937,26087,33276,33285,21646,23601,30106,38816,25304,29401,30141,
23621,39545,33738,23616,21632,30697,20030,27822,32858,25298,25454,24040,20855,
36317,36382,38191,20465,21477,24807,28844,21095,25424,40515,23071,20518,30519,
21367,32482,25733,25899,25225,25496,20500,29237,35273,20915,35776,32477,22343,
33740,38055,20891,21531,23803,20426,31459,27994,37089,39567,21888,21654,21345,
21679,24320,25577,26999,20975,24936,21002,22570,21208,22350,30733,30475,24247,
24951,31968,25179,25239,20130,28821,32771,25335,28900,38752,22391,33499,26607,
26869,30933,39063,31185,22771,21683,21487,28212,20811,21051,23458,35838,32943,
21827,22438,24691,22353,21549,31354,24656,23380,25511,25248,21475,25187,23495,
26543,21741,31391,33510,37239,24211,35044,22840,22446,25358,36328,33007,22359,
31607,20393,24555,23485,27454,21281,31568,29378,26694,30719,30518,26103,20917,
20111,30420,23743,31397,33909,22862,39745,20608,39304,24871,28291,22372,26118,
25414,22256,25324,25193,24275,38420,22403,25289,21895,34593,33098,36771,21862,
33713,26469,36182,34013,23146,26639,25318,31726,38417,20848,28572,35888,25597,
35272,25042,32518,28866,28389,29701,27028,29436,24266,37070,26391,28010,25438,
21171,29282,32769,20332,23013,37226,28889,28061,21202,20048,38647,38253,34174,
30922,32047,20769,22418,25794,32907,31867,27882,26865,26974,20919,21400,26792,
29313,40654,31729,29432,31163,28435,29702,26446,37324,40100,31036,33673,33620,
21519,26647,20029,21385,21169,30782,21382,21033,20616,20363,20432,30178,31435,
31890,27813,38582,21147,29827,21737,20457,32852,33714,36830,38256,24265,24604,
28063,24088,25947,33080,38142,24651,28860,32451,31918,20937,26753,31921,33391,
20004,36742,37327,26238,20142,35845,25769,32842,20698,30103,29134,23525,36797,
28518,20102,25730,38243,24278,26009,21015,35010,28872,21155,29454,29747,26519,
30967,38678,20020,37051,40158,28107,20955,36161,21533,25294,29618,33777,38646,
40836,38083,20278,32666,20940,28789,38517,23725,39046,21478,20196,28316,29705,
27060,30827,39311,30041,21016,30244,27969,26611,20845,40857,32843,21657,31548,
31423,38534,22404,25314,38471,27004,23044,25602,31699,28431,38475,33446,21346,
39045,24208,28809,25523,21348,34383,40065,40595,30860,38706,36335,36162,40575,
28510,31108,24405,38470,25134,39540,21525,38109,20387,26053,23653,23649,32533,
34385,27695,24459,29575,28388,32511,23782,25371,23402,28390,21365,20081,25504,
30053,25249,36718,20262,20177,27814,32438,35770,33821,34746,32599,36923,38179,
31657,39585,35064,33853,27931,39558,32476,22920,40635,29595,30721,34434,39532,
39554,22043,21527,22475,20080,40614,21334,36808,33033,30610,39314,34542,28385,
34067,26364,24930,28459,35881,33426,33579,30450,27667,24537,33725,29483,33541,
38170,27611,30683,38086,21359,33538,20882,24125,35980,36152,20040,29611,26522,
26757,37238,38665,29028,27809,30473,23186,38209,27599,32654,26151,23504,22969,
23194,38376,38391,20204,33804,33945,27308,30431,38192,29467,26790,23391,30511,
37274,38753,31964,36855,35868,24357,31859,31192,35269,27852,34588,23494,24130,
26825,30496,32501,20885,20813,21193,23081,32517,38754,33495,25551,30596,34256,
31186,28218,24217,22937,34065,28781,27665,25279,30399,25935,24751,38397,26126,
34719,40483,38125,21517,21629,35884,25720,25721,34321,27169,33180,30952,25705,
39764,25273,26411,33707,22696,40664,27819,28448,23518,38476,35851,29279,26576,
25287,29281,20137,22982,27597,22675,26286,24149,21215,24917,26408,30446,30566,
29287,31302,25343,21738,21584,38048,37027,23068,32435,27670,20035,22902,32784,
22856,21335,30007,38590,22218,25376,33041,24700,38393,28118,21602,39297,20869,
23273,33021,22958,38675,20522,27877,23612,25311,20320,21311,33147,36870,28346,
34091,25288,24180,30910,25781,25467,24565,23064,37247,40479,23615,25423,32834,
23421,21870,38218,38221,28037,24744,26592,29406,20957,23425,25319,27870,29275,
25197,38062,32445,33043,27987,20892,24324,22900,21162,24594,22899,26262,34384,
30111,25386,25062,31983,35834,21734,27431,40485,27572,34261,21589,20598,27812,
21866,36276,29228,24085,24597,29750,25293,25490,29260,24472,28227,27966,25856,
28504,30424,30928,30460,30036,21028,21467,20051,24222,26049,32810,32982,25243,
21638,21032,28846,34957,36305,27873,21624,32986,22521,35060,36180,38506,37197,
20329,27803,21943,30406,30768,25256,28921,28558,24429,34028,26842,30844,31735,
33192,26379,40527,25447,30896,22383,30738,38713,25209,25259,21128,29749,27607,
21860,33086,30130,30382,21305,30174,20731,23617,35692,31687,20559,29255,39575,
39128,28418,29922,31080,25735,30629,25340,39057,36139,21697,32856,20050,22378,
33529,33805,24179,20973,29942,35780,23631,22369,27900,39047,23110,30772,39748,
36843,31893,21078,25169,38138,20166,33670,33889,33769,33970,22484,26420,22275,
26222,28006,35889,26333,28689,26399,27450,26646,25114,22971,19971,20932,28422,
26578,27791,20854,26827,22855,27495,30054,23822,33040,40784,26071,31048,31041,
39569,36215,23682,20062,20225,21551,22865,30732,22120,27668,36804,24323,27773,
27875,35755,25488,24688,27965,29301,25190,38030,38085,21315,36801,31614,20191,
35878,20094,40660,38065,38067,21069,28508,36963,27973,35892,22545,23884,27424,
27465,26538,21595,33108,32652,22681,34103,24378,25250,27207,38201,25970,24708,
26725,30631,20052,20392,24039,38808,25772,32728,23789,20431,31373,20999,33540,
19988,24623,31363,38054,20405,20146,31206,29748,21220,33465,25810,31165,23517,
27777,38738,36731,27682,20542,21375,28165,25806,26228,27696,24773,39031,35831,
24198,29756,31351,31179,19992,37041,29699,27714,22234,37195,27845,36235,21306,
34502,26354,36527,23624,39537,28192,21462,23094,40843,36259,21435,22280,39079,
26435,37275,27849,20840,30154,25331,29356,21048,21149,32570,28820,30264,21364,
40522,27063,30830,38592,35033,32676,28982,29123,20873,26579,29924,22756,25880,
22199,35753,39286,25200,32469,24825,28909,22764,20161,20154,24525,38887,20219,
35748,20995,22922,32427,25172,20173,26085,25102,33592,33993,33635,34701,29076,
28342,23481,32466,20887,25545,26580,32905,33593,34837,20754,23418,22914,36785,
20083,27741,20837,35109,36719,38446,34122,29790,38160,38384,28070,33509,24369,
25746,27922,33832,33134,40131,22622,36187,19977,21441,20254,25955,26705,21971,
20007,25620,39578,25195,23234,29791,33394,28073,26862,20711,33678,30722,26432,
21049,27801,32433,20667,21861,29022,31579,26194,29642,33515,26441,23665,21024,
29053,34923,38378,38485,25797,36193,33203,21892,27733,25159,32558,22674,20260,
21830,36175,26188,19978,23578,35059,26786,25422,31245,28903,33421,21242,38902,
23569,21736,37045,32461,22882,36170,34503,33292,33293,36198,25668,23556,24913,
28041,31038,35774,30775,30003,21627,20280,36523,28145,23072,32453,31070,27784,
23457,23158,29978,32958,24910,28183,22768,29983,29989,29298,21319,32499,30465,
30427,21097,32988,22307,24072,22833,29422,26045,28287,35799,23608,34417,21313,
30707,25342,26102,20160,39135,34432,23454,35782,21490,30690,20351,23630,39542,
22987,24335,31034,22763,19990,26623,20107,25325,35475,36893,21183,26159,21980,
22124,36866,20181,20365,37322,39280,27663,24066,24643,23460,35270,35797,25910,
25163,39318,23432,23551,25480,21806,21463,30246,20861,34092,26530,26803,27530,
25234,36755,21460,33298,28113,30095,20070,36174,23408,29087,34223,26257,26329,
32626,34560,40653,40736,23646,26415,36848,26641,26463,25101,31446,22661,24246,
25968,28465,24661,21047,32781,25684,34928,29993,24069,26643,25332,38684,21452,
29245,35841,27700,30561,31246,21550,30636,39034,33308,35828,30805,26388,28865,
26031,25749,22070,24605,31169,21496,19997,27515,32902,23546,21987,22235,20282,
20284,39282,24051,26494,32824,24578,39042,36865,23435,35772,35829,25628,33368,
25822,22013,33487,37221,20439,32032,36895,31903,20723,22609,28335,23487,35785,
32899,37240,33948,31639,34429,38539,38543,32485,39635,30862,23681,31319,36930,
38567,31071,23385,25439,31499,34001,26797,21766,32553,29712,32034,38145,25152,
22604,20182,23427,22905,22612,29549,25374,36427,36367,32974,33492,25260,21488,
27888,37214,22826,24577,27760,22349,25674,36138,30251,28393,22363,27264,30192,
28525,35885,35848,22374,27631,34962,30899,25506,21497,28845,27748,22616,25642,
22530,26848,33179,21776,31958,20504,36538,28108,36255,28907,25487,28059,28372,
32486,33796,26691,36867,28120,38518,35752,22871,29305,34276,33150,30140,35466,
26799,21076,36386,38161,25552,39064,36420,21884,20307,26367,22159,24789,28053,
21059,23625,22825,28155,22635,30000,29980,24684,33300,33094,25361,26465,36834,
30522,36339,36148,38081,24086,21381,21548,28867,27712,24311,20572,20141,24237,
25402,33351,36890,26704,37230,30643,21516,38108,24420,31461,26742,25413,31570,
32479,30171,20599,25237,22836,36879,20984,31171,31361,22270,24466,36884,28034,
23648,22303,21520,20820,28237,22242,25512,39059,33151,34581,35114,36864,21534,
23663,33216,25302,25176,33073,40501,38464,39534,39548,26925,22949,25299,21822,
25366,21703,34521,27964,23043,29926,34972,27498,22806,35916,24367,28286,29609,
39037,20024,28919,23436,30871,25405,26202,30358,24779,23451,23113,19975,33109,
27754,29579,20129,26505,32593,24448,26106,26395,24536,22916,23041,24013,24494,
21361,38886,36829,26693,22260,21807,24799,20026,28493,32500,33479,33806,22996,
20255,20266,23614,32428,26410,34074,21619,30031,32963,21890,39759,20301,28205,
35859,23561,24944,21355,30239,28201,34442,25991,38395,32441,21563,31283,32010,
38382,21985,32705,29934,25373,34583,28065,31389,25105,26017,21351,25569,27779,
24043,21596,38056,20044,27745,35820,23627,26080,33436,26791,21566,21556,27595,
27494,20116,25410,21320,33310,20237,20398,22366,25098,38654,26212,29289,21247,
21153,24735,35823,26132,29081,26512,35199,30802,30717,26224,22075,21560,38177,
29306,31232,24687,24076,24713,33181,22805,24796,29060,28911,28330,27728,29312,
27268,34989,24109,20064,23219,21916,38115,27927,31995,38553,25103,32454,30606,
34430,21283,38686,36758,26247,23777,20384,29421,19979,21414,22799,21523,25472,
38184,20808,20185,40092,32420,21688,36132,34900,33335,38386,28046,24358,23244,
26174,38505,29616,29486,21439,33146,39301,32673,23466,38519,38480,32447,30456,
21410,38262,39321,31665,35140,28248,20065,32724,31077,35814,24819,21709,20139,
39033,24055,27233,20687,21521,35937,33831,30813,38660,21066,21742,22179,38144,
28040,23477,28102,26195,23567,23389,26657,32918,21880,31505,25928,26964,20123,
27463,34638,38795,21327,25375,25658,37034,26012,32961,35856,20889,26800,21368,
34809,25032,27844,27899,35874,23633,34218,33455,38156,27427,36763,26032,24571,
24515,20449,34885,26143,33125,29481,24826,20852,21009,22411,24418,37026,34892,
37266,24184,26447,24615,22995,20804,20982,33016,21256,27769,38596,29066,20241,
20462,32670,26429,21957,38152,31168,34966,32483,22687,25100,38656,34394,22040,
39035,24464,35768,33988,37207,21465,26093,24207,30044,24676,32110,23167,32490,
32493,36713,21927,23459,24748,26059,29572,36873,30307,30505,32474,38772,34203,
23398,31348,38634,34880,21195,29071,24490,26092,35810,23547,39535,24033,27529,
27739,35757,35759,36874,36805,21387,25276,40486,40493,21568,20011,33469,29273,
34460,23830,34905,28079,38597,21713,20122,35766,28937,21693,38409,28895,28153,
30416,20005,30740,34578,23721,24310,35328,39068,38414,28814,27839,22852,25513,
30524,34893,28436,33395,22576,29141,21388,30746,38593,21761,24422,28976,23476,
35866,39564,27523,22830,40495,31207,26472,25196,20335,30113,32650,27915,38451,
27687,20208,30162,20859,26679,28478,36992,33136,22934,29814,25671,23591,36965,
31377,35875,23002,21676,33280,33647,35201,32768,26928,22094,32822,29239,37326,
20918,20063,39029,25494,19994,21494,26355,33099,22812,28082,19968,22777,21307,
25558,38129,20381,20234,34915,39056,22839,36951,31227,20202,33008,30097,27778,
23452,23016,24413,26885,34433,20506,24050,20057,30691,20197,33402,25233,26131,
37009,23673,20159,24441,33222,36920,32900,30123,20134,35028,24847,27589,24518,
20041,30410,28322,35811,35758,35850,35793,24322,32764,32716,32462,33589,33643,
22240,27575,38899,38452,23035,21535,38134,28139,23493,39278,23609,24341,38544,
21360,33521,27185,23156,40560,24212,32552,33721,33828,33829,33639,34631,36814,
36194,30408,24433,39062,30828,26144,21727,25317,20323,33219,30152,24248,38605,
36362,34553,21647,27891,28044,27704,24703,21191,29992,24189,20248,24736,24551,
23588,30001,37038,38080,29369,27833,28216,37193,26377,21451,21491,20305,37321,
35825,21448,24188,36802,28132,20110,30402,27014,34398,24858,33286,20313,20446,
36926,40060,24841,28189,28180,38533,20104,23089,38632,19982,23679,31161,23431,
35821,32701,29577,22495,33419,37057,21505,36935,21947,23786,24481,24840,27442,
29425,32946,35465,28020,23507,35029,39044,35947,39533,40499,28170,20900,20803,
22435,34945,21407,25588,36757,22253,21592,22278,29503,28304,32536,36828,33489,
24895,24616,38498,26352,32422,36234,36291,38053,23731,31908,26376,24742,38405,
32792,20113,37095,21248,38504,20801,36816,34164,37213,26197,38901,23381,21277,
30776,26434,26685,21705,28798,23472,36733,20877,22312,21681,25874,26242,36190,
36163,33039,33900,36973,31967,20991,34299,26531,26089,28577,34468,36481,22122,
36896,30338,28790,29157,36131,25321,21017,27901,36156,24590,22686,24974,26366,
36192,25166,21939,28195,26413,36711,38113,38392,30504,26629,27048,21643,20045,
28856,35784,25688,25995,23429,31364,20538,23528,30651,27617,35449,31896,27838,
30415,26025,36759,23853,23637,34360,26632,21344,25112,31449,28251,32509,27167,
31456,24432,28467,24352,25484,28072,26454,19976,24080,36134,20183,32960,30260,
38556,25307,26157,25214,27836,36213,29031,32617,20806,32903,21484,36974,25240,
21746,34544,36761,32773,38167,34071,36825,27993,29645,26015,30495,29956,30759,
33275,36126,38024,20390,26517,30137,35786,38663,25391,38215,38453,33976,25379,
30529,24449,29424,20105,24596,25972,25327,27491,25919,24103,30151,37073,35777,
33437,26525,25903,21553,34584,30693,32930,33026,27713,20043,32455,32844,30452,
26893,27542,25191,20540,20356,22336,25351,27490,36286,21482,26088,32440,24535,
25370,25527,33267,33268,32622,24092,23769,21046,26234,31209,31258,36136,28825,
30164,28382,27835,31378,20013,30405,24544,38047,34935,32456,31181,32959,37325,
20210,20247,33311,21608,24030,27954,35788,31909,36724,32920,24090,21650,30385,
23449,26172,39588,29664,26666,34523,26417,29482,35832,35803,36880,31481,28891,
29038,25284,30633,22065,20027,33879,26609,21161,34496,36142,38136,31569,20303,
27880,31069,39547,25235,29226,25341,19987,30742,36716,25776,36186,31686,26729,
24196,35013,22918,25758,22766,29366,26894,38181,36861,36184,22368,32512,35846,
20934,25417,25305,21331,26700,29730,33537,37196,21828,30528,28796,27978,20857,
21672,36164,23039,28363,28100,23388,32043,20180,31869,28371,23376,33258,28173,
23383,39683,26837,36394,23447,32508,24635,32437,37049,36208,22863,25549,31199,
36275,21330,26063,31062,35781,38459,32452,38075,32386,22068,37257,26368,32618,
23562,36981,26152,24038,20304,26590,20570,20316,22352,24231,59408,59409,59410,
59411,59412,20109,19980,20800,19984,24319,21317,19989,20120,19998,39730,23404,
22121,20008,31162,20031,21269,20039,22829,29243,21358,27664,22239,32996,39319,
27603,30590,40727,20022,20127,40720,20060,20073,20115,33416,23387,21868,22031,
20164,21389,21405,21411,21413,21422,38757,36189,21274,21493,21286,21294,21310,
36188,21350,21347,20994,21000,21006,21037,21043,21055,21056,21068,21086,21089,
21084,33967,21117,21122,21121,21136,21139,20866,32596,20155,20163,20169,20162,
20200,20193,20203,20190,20251,20211,20258,20324,20213,20261,20263,20233,20267,
20318,20327,25912,20314,20317,20319,20311,20274,20285,20342,20340,20369,20361,
20355,20367,20350,20347,20394,20348,20396,20372,20454,20456,20458,20421,20442,
20451,20444,20433,20447,20472,20521,20556,20467,20524,20495,20526,20525,20478,
20508,20492,20517,20520,20606,20547,20565,20552,20558,20588,20603,20645,20647,
20649,20666,20694,20742,20717,20716,20710,20718,20743,20747,20189,27709,20312,
20325,20430,40864,27718,31860,20846,24061,40649,39320,20865,22804,21241,21261,
35335,21264,20971,22809,20821,20128,20822,20147,34926,34980,20149,33044,35026,
31104,23348,34819,32696,20907,20913,20925,20924,20935,20886,20898,20901,35744,
35750,35751,35754,35764,35765,35767,35778,35779,35787,35791,35790,35794,35795,
35796,35798,35800,35801,35804,35807,35808,35812,35816,35817,35822,35824,35827,
35830,35833,35836,35839,35840,35842,35844,35847,35852,35855,35857,35858,35860,
35861,35862,35865,35867,35864,35869,35871,35872,35873,35877,35879,35882,35883,
35886,35887,35890,35891,35893,35894,21353,21370,38429,38434,38433,38449,38442,
38461,38460,38466,38473,38484,38495,38503,38508,38514,38516,38536,38541,38551,
38576,37015,37019,37021,37017,37036,37025,37044,37043,37046,37050,37048,37040,
37071,37061,37054,37072,37060,37063,37075,37094,37090,37084,37079,37083,37099,
37103,37118,37124,37154,37150,37155,37169,37167,37177,37187,37190,21005,22850,
21154,21164,21165,21182,21759,21200,21206,21232,21471,29166,30669,24308,20981,
20988,39727,21430,24321,30042,24047,22348,22441,22433,22654,22716,22725,22737,
22313,22316,22314,22323,22329,22318,22319,22364,22331,22338,22377,22405,22379,
22406,22396,22395,22376,22381,22390,22387,22445,22436,22412,22450,22479,22439,
22452,22419,22432,22485,22488,22490,22489,22482,22456,22516,22511,22520,22500,
22493,22539,22541,22525,22509,22528,22558,22553,22596,22560,22629,22636,22657,
22665,22682,22656,39336,40729,25087,33401,33405,33407,33423,33418,33448,33412,
33422,33425,33431,33433,33451,33464,33470,33456,33480,33482,33507,33432,33463,
33454,33483,33484,33473,33449,33460,33441,33450,33439,33476,33486,33444,33505,
33545,33527,33508,33551,33543,33500,33524,33490,33496,33548,33531,33491,33553,
33562,33542,33556,33557,33504,33493,33564,33617,33627,33628,33544,33682,33596,
33588,33585,33691,33630,33583,33615,33607,33603,33631,33600,33559,33632,33581,
33594,33587,33638,33637,33640,33563,33641,33644,33642,33645,33646,33712,33656,
33715,33716,33696,33706,33683,33692,33669,33660,33718,33705,33661,33720,33659,
33688,33694,33704,33722,33724,33729,33793,33765,33752,22535,33816,33803,33757,
33789,33750,33820,33848,33809,33798,33748,33759,33807,33795,33784,33785,33770,
33733,33728,33830,33776,33761,33884,33873,33882,33881,33907,33927,33928,33914,
33929,33912,33852,33862,33897,33910,33932,33934,33841,33901,33985,33997,34000,
34022,33981,34003,33994,33983,33978,34016,33953,33977,33972,33943,34021,34019,
34060,29965,34104,34032,34105,34079,34106,34134,34107,34047,34044,34137,34120,
34152,34148,34142,34170,30626,34115,34162,34171,34212,34216,34183,34191,34169,
34222,34204,34181,34233,34231,34224,34259,34241,34268,34303,34343,34309,34345,
34326,34364,24318,24328,22844,22849,32823,22869,22874,22872,21263,23586,23589,
23596,23604,25164,25194,25247,25275,25290,25306,25303,25326,25378,25334,25401,
25419,25411,25517,25590,25457,25466,25486,25524,25453,25516,25482,25449,25518,
25532,25586,25592,25568,25599,25540,25566,25550,25682,25542,25534,25669,25665,
25611,25627,25632,25612,25638,25633,25694,25732,25709,25750,25722,25783,25784,
25753,25786,25792,25808,25815,25828,25826,25865,25893,25902,24331,24530,29977,
24337,21343,21489,21501,21481,21480,21499,21522,21526,21510,21579,21586,21587,
21588,21590,21571,21537,21591,21593,21539,21554,21634,21652,21623,21617,21604,
21658,21659,21636,21622,21606,21661,21712,21677,21698,21684,21714,21671,21670,
21715,21716,21618,21667,21717,21691,21695,21708,21721,21722,21724,21673,21674,
21668,21725,21711,21726,21787,21735,21792,21757,21780,21747,21794,21795,21775,
21777,21799,21802,21863,21903,21941,21833,21869,21825,21845,21823,21840,21820,
21815,21846,21877,21878,21879,21811,21808,21852,21899,21970,21891,21937,21945,
21896,21889,21919,21886,21974,21905,21883,21983,21949,21950,21908,21913,21994,
22007,21961,22047,21969,21995,21996,21972,21990,21981,21956,21999,21989,22002,
22003,21964,21965,21992,22005,21988,36756,22046,22024,22028,22017,22052,22051,
22014,22016,22055,22061,22104,22073,22103,22060,22093,22114,22105,22108,22092,
22100,22150,22116,22129,22123,22139,22140,22149,22163,22191,22228,22231,22237,
22241,22261,22251,22265,22271,22276,22282,22281,22300,24079,24089,24084,24081,
24113,24123,24124,24119,24132,24148,24155,24158,24161,23692,23674,23693,23696,
23702,23688,23704,23705,23697,23706,23708,23733,23714,23741,23724,23723,23729,
23715,23745,23735,23748,23762,23780,23755,23781,23810,23811,23847,23846,23854,
23844,23838,23814,23835,23896,23870,23860,23869,23916,23899,23919,23901,23915,
23883,23882,23913,23924,23938,23961,23965,35955,23991,24005,24435,24439,24450,
24455,24457,24460,24469,24473,24476,24488,24493,24501,24508,34914,24417,29357,
29360,29364,29367,29368,29379,29377,29390,29389,29394,29416,29423,29417,29426,
29428,29431,29441,29427,29443,29434,29435,29463,29459,29473,29450,29470,29469,
29461,29474,29497,29477,29484,29496,29489,29520,29517,29527,29536,29548,29551,
29566,33307,22821,39143,22820,22786,39267,39271,39272,39273,39274,39275,39276,
39284,39287,39293,39296,39300,39303,39306,39309,39312,39313,39315,39316,39317,
24192,24209,24203,24214,24229,24224,24249,24245,24254,24243,36179,24274,24273,
24283,24296,24298,33210,24516,24521,24534,24527,24579,24558,24580,24545,24548,
24574,24581,24582,24554,24557,24568,24601,24629,24614,24603,24591,24589,24617,
24619,24586,24639,24609,24696,24697,24699,24698,24642,24682,24701,24726,24730,
24749,24733,24707,24722,24716,24731,24812,24763,24753,24797,24792,24774,24794,
24756,24864,24870,24853,24867,24820,24832,24846,24875,24906,24949,25004,24980,
24999,25015,25044,25077,24541,38579,38377,38379,38385,38387,38389,38390,38396,
38398,38403,38404,38406,38408,38410,38411,38412,38413,38415,38418,38421,38422,
38423,38425,38426,20012,29247,25109,27701,27732,27740,27722,27811,27781,27792,
27796,27788,27752,27753,27764,27766,27782,27817,27856,27860,27821,27895,27896,
27889,27863,27826,27872,27862,27898,27883,27886,27825,27859,27887,27902,27961,
27943,27916,27971,27976,27911,27908,27929,27918,27947,27981,27950,27957,27930,
27983,27986,27988,27955,28049,28015,28062,28064,27998,28051,28052,27996,28000,
28028,28003,28186,28103,28101,28126,28174,28095,28128,28177,28134,28125,28121,
28182,28075,28172,28078,28203,28270,28238,28267,28338,28255,28294,28243,28244,
28210,28197,28228,28383,28337,28312,28384,28461,28386,28325,28327,28349,28347,
28343,28375,28340,28367,28303,28354,28319,28514,28486,28487,28452,28437,28409,
28463,28470,28491,28532,28458,28425,28457,28553,28557,28556,28536,28530,28540,
28538,28625,28617,28583,28601,28598,28610,28641,28654,28638,28640,28655,28698,
28707,28699,28729,28725,28751,28766,23424,23428,23445,23443,23461,23480,29999,
39582,25652,23524,23534,35120,23536,36423,35591,36790,36819,36821,36837,36846,
36836,36841,36838,36851,36840,36869,36868,36875,36902,36881,36877,36886,36897,
36917,36918,36909,36911,36932,36945,36946,36944,36968,36952,36962,36955,26297,
36980,36989,36994,37000,36995,37003,24400,24407,24406,24408,23611,21675,23632,
23641,23409,23651,23654,32700,24362,24361,24365,33396,24380,39739,23662,22913,
22915,22925,22953,22954,22947,22935,22986,22955,22942,22948,22994,22962,22959,
22999,22974,23045,23046,23005,23048,23011,23000,23033,23052,23049,23090,23092,
23057,23075,23059,23104,23143,23114,23125,23100,23138,23157,33004,23210,23195,
23159,23162,23230,23275,23218,23250,23252,23224,23264,23267,23281,23254,23270,
23256,23260,23305,23319,23318,23346,23351,23360,23573,23580,23386,23397,23411,
23377,23379,23394,39541,39543,39544,39546,39551,39549,39552,39553,39557,39560,
39562,39568,39570,39571,39574,39576,39579,39580,39581,39583,39584,39586,39587,
39589,39591,32415,32417,32419,32421,32424,32425,32429,32432,32446,32448,32449,
32450,32457,32459,32460,32464,32468,32471,32475,32480,32481,32488,32491,32494,
32495,32497,32498,32525,32502,32506,32507,32510,32513,32514,32515,32519,32520,
32523,32524,32527,32529,32530,32535,32537,32540,32539,32543,32545,32546,32547,
32548,32549,32550,32551,32554,32555,32556,32557,32559,32560,32561,32562,32563,
32565,24186,30079,24027,30014,37013,29582,29585,29614,29602,29599,29647,29634,
29649,29623,29619,29632,29641,29640,29669,29657,39036,29706,29673,29671,29662,
29626,29682,29711,29738,29787,29734,29733,29736,29744,29742,29740,29723,29722,
29761,29788,29783,29781,29785,29815,29805,29822,29852,29838,29824,29825,29831,
29835,29854,29864,29865,29840,29863,29906,29882,38890,38891,38892,26444,26451,
26462,26440,26473,26533,26503,26474,26483,26520,26535,26485,26536,26526,26541,
26507,26487,26492,26608,26633,26584,26634,26601,26544,26636,26585,26549,26586,
26547,26589,26624,26563,26552,26594,26638,26561,26621,26674,26675,26720,26721,
26702,26722,26692,26724,26755,26653,26709,26726,26689,26727,26688,26686,26698,
26697,26665,26805,26767,26740,26743,26771,26731,26818,26990,26876,26911,26912,
26873,26916,26864,26891,26881,26967,26851,26896,26993,26937,26976,26946,26973,
27012,26987,27008,27032,27000,26932,27084,27015,27016,27086,27017,26982,26979,
27001,27035,27047,27067,27051,27053,27092,27057,27073,27082,27103,27029,27104,
27021,27135,27183,27117,27159,27160,27237,27122,27204,27198,27296,27216,27227,
27189,27278,27257,27197,27176,27224,27260,27281,27280,27305,27287,27307,29495,
29522,27521,27522,27527,27524,27538,27539,27533,27546,27547,27553,27562,36715,
36717,36721,36722,36723,36725,36726,36728,36727,36729,36730,36732,36734,36737,
36738,36740,36743,36747,36749,36750,36751,36760,36762,36558,25099,25111,25115,
25119,25122,25121,25125,25124,25132,33255,29935,29940,29951,29967,29969,29971,
25908,26094,26095,26096,26122,26137,26482,26115,26133,26112,28805,26359,26141,
26164,26161,26166,26165,32774,26207,26196,26177,26191,26198,26209,26199,26231,
26244,26252,26279,26269,26302,26331,26332,26342,26345,36146,36147,36150,36155,
36157,36160,36165,36166,36168,36169,36167,36173,36181,36185,35271,35274,35275,
35276,35278,35279,35280,35281,29294,29343,29277,29286,29295,29310,29311,29316,
29323,29325,29327,29330,25352,25394,25520,25663,25816,32772,27626,27635,27645,
27637,27641,27653,27655,27654,27661,27669,27672,27673,27674,27681,27689,27684,
27690,27698,25909,25941,25963,29261,29266,29270,29232,34402,21014,32927,32924,
32915,32956,26378,32957,32945,32939,32941,32948,32951,32999,33000,33001,33002,
32987,32962,32964,32985,32973,32983,26384,32989,33003,33009,33012,33005,33037,
33038,33010,33020,26389,33042,35930,33078,33054,33068,33048,33074,33096,33100,
33107,33140,33113,33114,33137,33120,33129,33148,33149,33133,33127,22605,23221,
33160,33154,33169,28373,33187,33194,33228,26406,33226,33211,33217,33190,27428,
27447,27449,27459,27462,27481,39121,39122,39123,39125,39129,39130,27571,24384,
27586,35315,26000,40785,26003,26044,26054,26052,26051,26060,26062,26066,26070,
28800,28828,28822,28829,28859,28864,28855,28843,28849,28904,28874,28944,28947,
28950,28975,28977,29043,29020,29032,28997,29042,29002,29048,29050,29080,29107,
29109,29096,29088,29152,29140,29159,29177,29213,29224,28780,28952,29030,29113,
25150,25149,25155,25160,25161,31035,31040,31046,31049,31067,31068,31059,31066,
31074,31063,31072,31087,31079,31098,31109,31114,31130,31143,31155,24529,24528,
24636,24669,24666,24679,24641,24665,24675,24747,24838,24845,24925,25001,24989,
25035,25041,25094,32896,32895,27795,27894,28156,30710,30712,30720,30729,30743,
30744,30737,26027,30765,30748,30749,30777,30778,30779,30751,30780,30757,30764,
30755,30761,30798,30829,30806,30807,30758,30800,30791,30796,30826,30875,30867,
30874,30855,30876,30881,30883,30898,30905,30885,30932,30937,30921,30956,30962,
30981,30964,30995,31012,31006,31028,40859,40697,40699,40700,30449,30468,30477,
30457,30471,30472,30490,30498,30489,30509,30502,30517,30520,30544,30545,30535,
30531,30554,30568,30562,30565,30591,30605,30589,30592,30604,30609,30623,30624,
30640,30645,30653,30010,30016,30030,30027,30024,30043,30066,30073,30083,32600,
32609,32607,35400,32616,32628,32625,32633,32641,32638,30413,30437,34866,38021,
38022,38023,38027,38026,38028,38029,38031,38032,38036,38039,38037,38042,38043,
38044,38051,38052,38059,38058,38061,38060,38063,38064,38066,38068,38070,38071,
38072,38073,38074,38076,38077,38079,38084,38088,38089,38090,38091,38092,38093,
38094,38096,38097,38098,38101,38102,38103,38105,38104,38107,38110,38111,38112,
38114,38116,38117,38119,38120,38122,38121,38123,38126,38127,38131,38132,38133,
38135,38137,38140,38141,38143,38147,38146,38150,38151,38153,38154,38157,38158,
38159,38162,38163,38164,38165,38166,38168,38171,38173,38174,38175,38178,38186,
38187,38185,38188,38193,38194,38196,38198,38199,38200,38204,38206,38207,38210,
38197,38212,38213,38214,38217,38220,38222,38223,38226,38227,38228,38230,38231,
38232,38233,38235,38238,38239,38237,38241,38242,38244,38245,38246,38247,38248,
38249,38250,38251,38252,38255,38257,38258,38259,38202,30695,30700,38601,31189,
31213,31203,31211,31238,23879,31235,31234,31262,31252,31289,31287,31313,40655,
39333,31344,30344,30350,30355,30361,30372,29918,29920,29996,40480,40482,40488,
40489,40490,40491,40492,40498,40497,40502,40504,40503,40505,40506,40510,40513,
40514,40516,40518,40519,40520,40521,40523,40524,40526,40529,40533,40535,40538,
40539,40540,40542,40547,40550,40551,40552,40553,40554,40555,40556,40561,40557,
40563,30098,30100,30102,30112,30109,30124,30115,30131,30132,30136,30148,30129,
30128,30147,30146,30166,30157,30179,30184,30182,30180,30187,30183,30211,30193,
30204,30207,30224,30208,30213,30220,30231,30218,30245,30232,30229,30233,30235,
30268,30242,30240,30272,30253,30256,30271,30261,30275,30270,30259,30285,30302,
30292,30300,30294,30315,30319,32714,31462,31352,31353,31360,31366,31368,31381,
31398,31392,31404,31400,31405,31411,34916,34921,34930,34941,34943,34946,34978,
35014,34999,35004,35017,35042,35022,35043,35045,35057,35098,35068,35048,35070,
35056,35105,35097,35091,35099,35082,35124,35115,35126,35137,35174,35195,30091,
32997,30386,30388,30684,32786,32788,32790,32796,32800,32802,32805,32806,32807,
32809,32808,32817,32779,32821,32835,32838,32845,32850,32873,32881,35203,39032,
39040,39043,39049,39052,39053,39055,39060,39066,39067,39070,39071,39073,39074,
39077,39078,34381,34388,34412,34414,34431,34426,34428,34427,34472,34445,34443,
34476,34461,34471,34467,34474,34451,34473,34486,34500,34485,34510,34480,34490,
34481,34479,34505,34511,34484,34537,34545,34546,34541,34547,34512,34579,34526,
34548,34527,34520,34513,34563,34567,34552,34568,34570,34573,34569,34595,34619,
34590,34597,34606,34586,34622,34632,34612,34609,34601,34615,34623,34690,34594,
34685,34686,34683,34656,34672,34636,34670,34699,34643,34659,34684,34660,34649,
34661,34707,34735,34728,34770,34758,34696,34693,34733,34711,34691,34731,34789,
34732,34741,34739,34763,34771,34749,34769,34752,34762,34779,34794,34784,34798,
34838,34835,34814,34826,34843,34849,34873,34876,32566,32578,32580,32581,33296,
31482,31485,31496,31491,31492,31509,31498,31531,31503,31559,31544,31530,31513,
31534,31537,31520,31525,31524,31539,31550,31518,31576,31578,31557,31605,31564,
31581,31584,31598,31611,31586,31602,31601,31632,31654,31655,31672,31660,31645,
31656,31621,31658,31644,31650,31659,31668,31697,31681,31692,31709,31706,31717,
31718,31722,31756,31742,31740,31759,31766,31755,31775,31786,31782,31800,31809,
31808,33278,33281,33282,33284,33260,34884,33313,33314,33315,33325,33327,33320,
33323,33336,33339,33331,33332,33342,33348,33353,33355,33359,33370,33375,33384,
34942,34949,34952,35032,35039,35166,32669,32671,32679,32687,32688,32690,31868,
25929,31889,31901,31900,31902,31906,31922,31932,31933,31937,31943,31948,31949,
31944,31941,31959,31976,33390,26280,32703,32718,32725,32741,32737,32742,32745,
32750,32755,31992,32119,32166,32174,32327,32411,40632,40628,36211,36228,36244,
36241,36273,36199,36205,35911,35913,37194,37200,37198,37199,37220,37218,37217,
37232,37225,37231,37245,37246,37234,37236,37241,37260,37253,37264,37261,37265,
37282,37283,37290,37293,37294,37295,37301,37300,37306,35925,40574,36280,36331,
36357,36441,36457,36277,36287,36284,36282,36292,36310,36311,36314,36318,36302,
36303,36315,36294,36332,36343,36344,36323,36345,36347,36324,36361,36349,36372,
36381,36383,36396,36398,36387,36399,36410,36416,36409,36405,36413,36401,36425,
36417,36418,36433,36434,36426,36464,36470,36476,36463,36468,36485,36495,36500,
36496,36508,36510,35960,35970,35978,35973,35992,35988,26011,35286,35294,35290,
35292,35301,35307,35311,35390,35622,38739,38633,38643,38639,38662,38657,38664,
38671,38670,38698,38701,38704,38718,40832,40835,40837,40838,40839,40840,40841,
40842,40844,40702,40715,40717,38585,38588,38589,38606,38610,30655,38624,37518,
37550,37576,37694,37738,37834,37775,37950,37995,40063,40066,40069,40070,40071,
40072,31267,40075,40078,40080,40081,40082,40084,40085,40090,40091,40094,40095,
40096,40097,40098,40099,40101,40102,40103,40104,40105,40107,40109,40110,40112,
40113,40114,40115,40116,40117,40118,40119,40122,40123,40124,40125,40132,40133,
40134,40135,40138,40139,40140,40141,40142,40143,40144,40147,40148,40149,40151,
40152,40153,40156,40157,40159,40162,38780,38789,38801,38802,38804,38831,38827,
38819,38834,38836,39601,39600,39607,40536,39606,39610,39612,39617,39616,39621,
39618,39627,39628,39633,39749,39747,39751,39753,39752,39757,39761,39144,39181,
39214,39253,39252,39647,39649,39654,39663,39659,39675,39661,39673,39688,39695,
39699,39711,39715,40637,40638,32315,40578,40583,40584,40587,40594,37846,40605,
40607,40667,40668,40669,40672,40671,40674,40681,40679,40677,40682,40687,40738,
40748,40751,40761,40759,40765,40766,40772,57908,57909,57910,57911,57912,57913,
57914,57915,57916,57917,57918,57919,57920,57921,57922,57923,57924,57925,57926,
57927,57928,57929,57930,57931,57932,57933,57934,57935,57936,57937,57938,57939,
57940,57941,57942,57943,57944,57945,57946,57947,57948,57949,57950,57951,57952,
57953,57954,57955,57956,57957,57958,57959,57960,57961,57962,57963,57964,57965,
57966,57967,57968,57969,57970,57971,57972,57973,57974,57975,57976,57977,57978,
57979,57980,57981,57982,57983,57984,57985,57986,57987,57988,57989,57990,57991,
57992,57993,57994,57995,57996,57997,57998,57999,58000,58001,58002,58003,58004,
58005,58006,58007,58008,58009,58010,58011,58012,58013,58014,58015,58016,58017,
58018,58019,58020,58021,58022,58023,58024,58025,58026,58027,58028,58029,58030,
58031,58032,58033,58034,58035,58036,58037,58038,58039,58040,58041,58042,58043,
58044,58045,58046,58047,58048,58049,58050,58051,58052,58053,58054,58055,58056,
58057,58058,58059,58060,58061,58062,58063,58064,58065,58066,58067,58068,58069,
58070,58071,58072,58073,58074,58075,58076,58077,58078,58079,58080,58081,58082,
58083,58084,58085,58086,58087,58088,58089,58090,58091,58092,58093,58094,58095,
58096,58097,58098,58099,58100,58101,58102,58103,58104,58105,58106,58107,58108,
58109,58110,58111,58112,58113,58114,58115,58116,58117,58118,58119,58120,58121,
58122,58123,58124,58125,58126,58127,58128,58129,58130,58131,58132,58133,58134,
58135,58136,58137,58138,58139,58140,58141,58142,58143,58144,58145,58146,58147,
58148,58149,58150,58151,58152,58153,58154,58155,58156,58157,58158,58159,58160,
58161,58162,58163,58164,58165,58166,58167,58168,58169,58170,58171,58172,58173,
58174,58175,58176,58177,58178,58179,58180,58181,58182,58183,58184,58185,58186,
58187,58188,58189,58190,58191,58192,58193,58194,58195,58196,58197,58198,58199,
58200,58201,58202,58203,58204,58205,58206,58207,58208,58209,58210,58211,58212,
58213,58214,58215,58216,58217,58218,58219,58220,58221,58222,58223,58224,58225,
58226,58227,58228,58229,58230,58231,58232,58233,58234,58235,58236,58237,58238,
58239,58240,58241,58242,58243,58244,58245,58246,58247,58248,58249,58250,58251,
58252,58253,58254,58255,58256,58257,58258,58259,58260,58261,58262,58263,58264,
58265,58266,58267,58268,58269,58270,58271,58272,58273,58274,58275,58276,58277,
58278,58279,58280,58281,58282,58283,58284,58285,58286,58287,58288,58289,58290,
58291,58292,58293,58294,58295,58296,58297,58298,58299,58300,58301,58302,58303,
58304,58305,58306,58307,58308,58309,58310,58311,58312,58313,58314,58315,58316,
58317,58318,58319,58320,58321,58322,58323,58324,58325,58326,58327,58328,58329,
58330,58331,58332,58333,58334,58335,58336,58337,58338,58339,58340,58341,58342,
58343,58344,58345,58346,58347,58348,58349,58350,58351,58352,58353,58354,58355,
58356,58357,58358,58359,58360,58361,58362,58363,58364,58365,58366,58367,58368,
58369,58370,58371,58372,58373,58374,58375,58376,58377,40754,40755,40756,40757,
40758,40760,40762,40764,40767,40768,40769,40770,40771,40773,40774,40775,40776,
40777,40778,40779,40780,40781,40782,40783,40786,40787,40788,40789,40790,40791,
40792,40793,40794,40795,40796,40797,40798,40799,40800,40801,40802,40803,40804,
40805,40806,40807,40808,40809,40810,40811,40812,40813,40814,40815,40816,40817,
40818,40819,40820,40821,40822,40823,40824,40825,40826,40827,40828,40829,40830,
40833,40834,40845,40846,40847,40848,40849,40850,40851,40852,40853,40854,40855,
40856,40860,40861,40862,40865,40866,40867,40868,40869,63788,63865,63893,63975,
63985,58378,58379,58380,58381,58382,58383,58384,58385,58386,58387,58388,58389,
58390,58391,58392,58393,58394,58395,58396,58397,58398,58399,58400,58401,58402,
58403,58404,58405,58406,58407,58408,58409,58410,58411,58412,58413,58414,58415,
58416,58417,58418,58419,58420,58421,58422,58423,58424,58425,58426,58427,58428,
58429,58430,58431,58432,58433,58434,58435,58436,58437,58438,58439,58440,58441,
58442,58443,58444,58445,58446,58447,58448,58449,58450,58451,58452,58453,58454,
58455,58456,58457,58458,58459,58460,58461,58462,58463,58464,58465,58466,58467,
58468,58469,58470,58471,64012,64013,64014,64015,64017,64019,64020,64024,64031,
64032,64033,64035,64036,64039,64040,64041,11905,59414,59415,59416,11908,13427,
13383,11912,11915,40884,13726,13850,13838,11916,11927,14702,14616,40885,14799,
14815,14963,14800,40886,40887,15182,15470,15584,11943,59441,40888,11946,16470,
16735,11950,17207,11955,11958,11959,59451,17329,17324,11963,17373,17622,18017,
17996,40889,18211,18217,18300,18317,11978,18759,18810,18813,18818,18819,18821,
18822,18847,18843,18871,18870,40890,59477,19619,19615,19616,19617,19575,19618,
19731,19732,19733,19734,19735,19736,19737,19886,40891,58472,58473,58474,58475,
58476,58477,58478,58479,58480,58481,58482,58483,58484,58485,58486,58487,58488,
58489,58490,58491,58492,58493,58494,58495,58496,58497,58498,58499,58500,58501,
58502,58503,58504,58505,58506,58507,58508,58509,58510,58511,58512,58513,58514,
58515,58516,58517,58518,58519,58520,58521,58522,58523,58524,58525,58526,58527,
58528,58529,58530,58531,58532,58533,58534,58535,58536,58537,58538,58539,58540,
58541,58542,58543,58544,58545,58546,58547,58548,58549,58550,58551,58552,58553,
58554,58555,58556,58557,58558,58559,58560,58561,58562,58563,58564,58565,
]
const GB18030Encode*: array[9891, UCS16x16] = [
(164u16,6247u16),(167u16,6251u16),(168u16,6182u16),(176u16,6242u16),
(177u16,6207u16),(183u16,6179u16),(215u16,6208u16),(224u16,7509u16),
(225u16,7507u16),(232u16,7513u16),(233u16,7511u16),(234u16,7531u16),
(236u16,7517u16),(237u16,7515u16),(242u16,7521u16),(243u16,7519u16),
(247u16,6209u16),(249u16,7525u16),(250u16,7523u16),(252u16,7530u16),
(257u16,7506u16),(275u16,7510u16),(283u16,7512u16),(299u16,7514u16),
(324u16,7534u16),(328u16,7535u16),(333u16,7518u16),(363u16,7522u16),
(462u16,7508u16),(464u16,7516u16),(466u16,7520u16),(468u16,7524u16),
(470u16,7526u16),(472u16,7527u16),(474u16,7528u16),(476u16,7529u16),
(505u16,7536u16),(593u16,7532u16),(609u16,7537u16),(711u16,6181u16),
(713u16,6180u16),(714u16,7410u16),(715u16,7411u16),(729u16,7412u16),
(913u16,7126u16),(914u16,7127u16),(915u16,7128u16),(916u16,7129u16),
(917u16,7130u16),(918u16,7131u16),(919u16,7132u16),(920u16,7133u16),
(921u16,7134u16),(922u16,7135u16),(923u16,7136u16),(924u16,7137u16),
(925u16,7138u16),(926u16,7139u16),(927u16,7140u16),(928u16,7141u16),
(929u16,7142u16),(931u16,7143u16),(932u16,7144u16),(933u16,7145u16),
(934u16,7146u16),(935u16,7147u16),(936u16,7148u16),(937u16,7149u16),
(945u16,7158u16),(946u16,7159u16),(947u16,7160u16),(948u16,7161u16),
(949u16,7162u16),(950u16,7163u16),(951u16,7164u16),(952u16,7165u16),
(953u16,7166u16),(954u16,7167u16),(955u16,7168u16),(956u16,7169u16),
(957u16,7170u16),(958u16,7171u16),(959u16,7172u16),(960u16,7173u16),
(961u16,7174u16),(963u16,7175u16),(964u16,7176u16),(965u16,7177u16),
(966u16,7178u16),(967u16,7179u16),(968u16,7180u16),(969u16,7181u16),
(1025u16,7322u16),(1040u16,7316u16),(1041u16,7317u16),(1042u16,7318u16),
(1043u16,7319u16),(1044u16,7320u16),(1045u16,7321u16),(1046u16,7323u16),
(1047u16,7324u16),(1048u16,7325u16),(1049u16,7326u16),(1050u16,7327u16),
(1051u16,7328u16),(1052u16,7329u16),(1053u16,7330u16),(1054u16,7331u16),
(1055u16,7332u16),(1056u16,7333u16),(1057u16,7334u16),(1058u16,7335u16),
(1059u16,7336u16),(1060u16,7337u16),(1061u16,7338u16),(1062u16,7339u16),
(1063u16,7340u16),(1064u16,7341u16),(1065u16,7342u16),(1066u16,7343u16),
(1067u16,7344u16),(1068u16,7345u16),(1069u16,7346u16),(1070u16,7347u16),
(1071u16,7348u16),(1072u16,7364u16),(1073u16,7365u16),(1074u16,7366u16),
(1075u16,7367u16),(1076u16,7368u16),(1077u16,7369u16),(1078u16,7371u16),
(1079u16,7372u16),(1080u16,7373u16),(1081u16,7374u16),(1082u16,7375u16),
(1083u16,7376u16),(1084u16,7377u16),(1085u16,7378u16),(1086u16,7379u16),
(1087u16,7380u16),(1088u16,7381u16),(1089u16,7382u16),(1090u16,7383u16),
(1091u16,7384u16),(1092u16,7385u16),(1093u16,7386u16),(1094u16,7387u16),
(1095u16,7388u16),(1096u16,7389u16),(1097u16,7390u16),(1098u16,7391u16),
(1099u16,7392u16),(1100u16,7393u16),(1101u16,7394u16),(1102u16,7395u16),
(1103u16,7396u16),(1105u16,7370u16),(7743u16,7533u16),(8208u16,7628u16),
(8211u16,7413u16),(8212u16,6185u16),(8213u16,7414u16),(8214u16,6187u16),
(8216u16,6189u16),(8217u16,6190u16),(8220u16,6191u16),(8221u16,6192u16),
(8229u16,7415u16),(8230u16,6188u16),(8240u16,6250u16),(8242u16,6243u16),
(8243u16,6244u16),(8245u16,7416u16),(8251u16,6264u16),(8364u16,6432u16),
(8451u16,6245u16),(8453u16,7417u16),(8457u16,7418u16),(8470u16,6252u16),
(8481u16,7625u16),(8544u16,6446u16),(8545u16,6447u16),(8546u16,6448u16),
(8547u16,6449u16),(8548u16,6450u16),(8549u16,6451u16),(8550u16,6452u16),
(8551u16,6453u16),(8552u16,6454u16),(8553u16,6455u16),(8554u16,6456u16),
(8555u16,6457u16),(8560u16,6366u16),(8561u16,6367u16),(8562u16,6368u16),
(8563u16,6369u16),(8564u16,6370u16),(8565u16,6371u16),(8566u16,6372u16),
(8567u16,6373u16),(8568u16,6374u16),(8569u16,6375u16),(8592u16,6266u16),
(8593u16,6267u16),(8594u16,6265u16),(8595u16,6268u16),(8598u16,7419u16),
(8599u16,7420u16),(8600u16,7421u16),(8601u16,7422u16),(8712u16,6217u16),
(8719u16,6214u16),(8721u16,6213u16),(8725u16,7423u16),(8730u16,6219u16),
(8733u16,6231u16),(8734u16,6237u16),(8735u16,7424u16),(8736u16,6222u16),
(8739u16,7425u16),(8741u16,6221u16),(8743u16,6211u16),(8744u16,6212u16),
(8745u16,6216u16),(8746u16,6215u16),(8747u16,6225u16),(8750u16,6226u16),
(8756u16,6239u16),(8757u16,6238u16),(8758u16,6210u16),(8759u16,6218u16),
(8765u16,6230u16),(8776u16,6229u16),(8780u16,6228u16),(8786u16,7426u16),
(8800u16,6232u16),(8801u16,6227u16),(8804u16,6235u16),(8805u16,6236u16),
(8806u16,7427u16),(8807u16,7428u16),(8814u16,6233u16),(8815u16,6234u16),
(8853u16,7491u16),(8857u16,6224u16),(8869u16,6220u16),(8895u16,7429u16),
(8978u16,6223u16),(9312u16,6422u16),(9313u16,6423u16),(9314u16,6424u16),
(9315u16,6425u16),(9316u16,6426u16),(9317u16,6427u16),(9318u16,6428u16),
(9319u16,6429u16),(9320u16,6430u16),(9321u16,6431u16),(9332u16,6402u16),
(9333u16,6403u16),(9334u16,6404u16),(9335u16,6405u16),(9336u16,6406u16),
(9337u16,6407u16),(9338u16,6408u16),(9339u16,6409u16),(9340u16,6410u16),
(9341u16,6411u16),(9342u16,6412u16),(9343u16,6413u16),(9344u16,6414u16),
(9345u16,6415u16),(9346u16,6416u16),(9347u16,6417u16),(9348u16,6418u16),
(9349u16,6419u16),(9350u16,6420u16),(9351u16,6421u16),(9352u16,6382u16),
(9353u16,6383u16),(9354u16,6384u16),(9355u16,6385u16),(9356u16,6386u16),
(9357u16,6387u16),(9358u16,6388u16),(9359u16,6389u16),(9360u16,6390u16),
(9361u16,6391u16),(9362u16,6392u16),(9363u16,6393u16),(9364u16,6394u16),
(9365u16,6395u16),(9366u16,6396u16),(9367u16,6397u16),(9368u16,6398u16),
(9369u16,6399u16),(9370u16,6400u16),(9371u16,6401u16),(9472u16,7699u16),
(9473u16,7700u16),(9474u16,7701u16),(9475u16,7702u16),(9476u16,7703u16),
(9477u16,7704u16),(9478u16,7705u16),(9479u16,7706u16),(9480u16,7707u16),
(9481u16,7708u16),(9482u16,7709u16),(9483u16,7710u16),(9484u16,7711u16),
(9485u16,7712u16),(9486u16,7713u16),(9487u16,7714u16),(9488u16,7715u16),
(9489u16,7716u16),(9490u16,7717u16),(9491u16,7718u16),(9492u16,7719u16),
(9493u16,7720u16),(9494u16,7721u16),(9495u16,7722u16),(9496u16,7723u16),
(9497u16,7724u16),(9498u16,7725u16),(9499u16,7726u16),(9500u16,7727u16),
(9501u16,7728u16),(9502u16,7729u16),(9503u16,7730u16),(9504u16,7731u16),
(9505u16,7732u16),(9506u16,7733u16),(9507u16,7734u16),(9508u16,7735u16),
(9509u16,7736u16),(9510u16,7737u16),(9511u16,7738u16),(9512u16,7739u16),
(9513u16,7740u16),(9514u16,7741u16),(9515u16,7742u16),(9516u16,7743u16),
(9517u16,7744u16),(9518u16,7745u16),(9519u16,7746u16),(9520u16,7747u16),
(9521u16,7748u16),(9522u16,7749u16),(9523u16,7750u16),(9524u16,7751u16),
(9525u16,7752u16),(9526u16,7753u16),(9527u16,7754u16),(9528u16,7755u16),
(9529u16,7756u16),(9530u16,7757u16),(9531u16,7758u16),(9532u16,7759u16),
(9533u16,7760u16),(9534u16,7761u16),(9535u16,7762u16),(9536u16,7763u16),
(9537u16,7764u16),(9538u16,7765u16),(9539u16,7766u16),(9540u16,7767u16),
(9541u16,7768u16),(9542u16,7769u16),(9543u16,7770u16),(9544u16,7771u16),
(9545u16,7772u16),(9546u16,7773u16),(9547u16,7774u16),(9552u16,7430u16),
(9553u16,7431u16),(9554u16,7432u16),(9555u16,7433u16),(9556u16,7434u16),
(9557u16,7435u16),(9558u16,7436u16),(9559u16,7437u16),(9560u16,7438u16),
(9561u16,7439u16),(9562u16,7440u16),(9563u16,7441u16),(9564u16,7442u16),
(9565u16,7443u16),(9566u16,7444u16),(9567u16,7445u16),(9568u16,7446u16),
(9569u16,7447u16),(9570u16,7448u16),(9571u16,7449u16),(9572u16,7450u16),
(9573u16,7451u16),(9574u16,7452u16),(9575u16,7453u16),(9576u16,7454u16),
(9577u16,7455u16),(9578u16,7456u16),(9579u16,7457u16),(9580u16,7458u16),
(9581u16,7459u16),(9582u16,7460u16),(9583u16,7461u16),(9584u16,7462u16),
(9585u16,7463u16),(9586u16,7464u16),(9587u16,7465u16),(9601u16,7466u16),
(9602u16,7467u16),(9603u16,7468u16),(9604u16,7469u16),(9605u16,7470u16),
(9606u16,7471u16),(9607u16,7472u16),(9608u16,7473u16),(9609u16,7474u16),
(9610u16,7475u16),(9611u16,7476u16),(9612u16,7477u16),(9613u16,7478u16),
(9614u16,7479u16),(9615u16,7480u16),(9619u16,7481u16),(9620u16,7482u16),
(9621u16,7483u16),(9632u16,6261u16),(9633u16,6260u16),(9650u16,6263u16),
(9651u16,6262u16),(9660u16,7484u16),(9661u16,7485u16),(9670u16,6259u16),
(9671u16,6258u16),(9675u16,6255u16),(9678u16,6257u16),(9679u16,6256u16),
(9698u16,7486u16),(9699u16,7487u16),(9700u16,7488u16),(9701u16,7489u16),
(9733u16,6254u16),(9734u16,6253u16),(9737u16,7490u16),(9792u16,6241u16),
(9794u16,6240u16),(11905u16,23766u16),(11908u16,23770u16),(11912u16,23773u16),
(11915u16,23774u16),(11916u16,23779u16),(11927u16,23780u16),(11943u16,23793u16),
(11946u16,23796u16),(11950u16,23799u16),(11955u16,23801u16),(11958u16,23802u16),
(11959u16,23803u16),(11963u16,23807u16),(11978u16,23817u16),(12272u16,7673u16),
(12273u16,7674u16),(12274u16,7675u16),(12275u16,7676u16),(12276u16,7677u16),
(12277u16,7678u16),(12278u16,7679u16),(12279u16,7680u16),(12280u16,7681u16),
(12281u16,7682u16),(12282u16,7683u16),(12283u16,7684u16),(12288u16,6176u16),
(12289u16,6177u16),(12290u16,6178u16),(12291u16,6183u16),(12293u16,6184u16),
(12294u16,7637u16),(12295u16,7685u16),(12296u16,6195u16),(12297u16,6196u16),
(12298u16,6197u16),(12299u16,6198u16),(12300u16,6199u16),(12301u16,6200u16),
(12302u16,6201u16),(12303u16,6202u16),(12304u16,6205u16),(12305u16,6206u16),
(12306u16,7492u16),(12307u16,6269u16),(12308u16,6193u16),(12309u16,6194u16),
(12310u16,6203u16),(12311u16,6204u16),(12317u16,7493u16),(12318u16,7494u16),
(12321u16,7600u16),(12322u16,7601u16),(12323u16,7602u16),(12324u16,7603u16),
(12325u16,7604u16),(12326u16,7605u16),(12327u16,7606u16),(12328u16,7607u16),
(12329u16,7608u16),(12350u16,7672u16),(12353u16,6746u16),(12354u16,6747u16),
(12355u16,6748u16),(12356u16,6749u16),(12357u16,6750u16),(12358u16,6751u16),
(12359u16,6752u16),(12360u16,6753u16),(12361u16,6754u16),(12362u16,6755u16),
(12363u16,6756u16),(12364u16,6757u16),(12365u16,6758u16),(12366u16,6759u16),
(12367u16,6760u16),(12368u16,6761u16),(12369u16,6762u16),(12370u16,6763u16),
(12371u16,6764u16),(12372u16,6765u16),(12373u16,6766u16),(12374u16,6767u16),
(12375u16,6768u16),(12376u16,6769u16),(12377u16,6770u16),(12378u16,6771u16),
(12379u16,6772u16),(12380u16,6773u16),(12381u16,6774u16),(12382u16,6775u16),
(12383u16,6776u16),(12384u16,6777u16),(12385u16,6778u16),(12386u16,6779u16),
(12387u16,6780u16),(12388u16,6781u16),(12389u16,6782u16),(12390u16,6783u16),
(12391u16,6784u16),(12392u16,6785u16),(12393u16,6786u16),(12394u16,6787u16),
(12395u16,6788u16),(12396u16,6789u16),(12397u16,6790u16),(12398u16,6791u16),
(12399u16,6792u16),(12400u16,6793u16),(12401u16,6794u16),(12402u16,6795u16),
(12403u16,6796u16),(12404u16,6797u16),(12405u16,6798u16),(12406u16,6799u16),
(12407u16,6800u16),(12408u16,6801u16),(12409u16,6802u16),(12410u16,6803u16),
(12411u16,6804u16),(12412u16,6805u16),(12413u16,6806u16),(12414u16,6807u16),
(12415u16,6808u16),(12416u16,6809u16),(12417u16,6810u16),(12418u16,6811u16),
(12419u16,6812u16),(12420u16,6813u16),(12421u16,6814u16),(12422u16,6815u16),
(12423u16,6816u16),(12424u16,6817u16),(12425u16,6818u16),(12426u16,6819u16),
(12427u16,6820u16),(12428u16,6821u16),(12429u16,6822u16),(12430u16,6823u16),
(12431u16,6824u16),(12432u16,6825u16),(12433u16,6826u16),(12434u16,6827u16),
(12435u16,6828u16),(12443u16,7633u16),(12444u16,7634u16),(12445u16,7638u16),
(12446u16,7639u16),(12449u16,6936u16),(12450u16,6937u16),(12451u16,6938u16),
(12452u16,6939u16),(12453u16,6940u16),(12454u16,6941u16),(12455u16,6942u16),
(12456u16,6943u16),(12457u16,6944u16),(12458u16,6945u16),(12459u16,6946u16),
(12460u16,6947u16),(12461u16,6948u16),(12462u16,6949u16),(12463u16,6950u16),
(12464u16,6951u16),(12465u16,6952u16),(12466u16,6953u16),(12467u16,6954u16),
(12468u16,6955u16),(12469u16,6956u16),(12470u16,6957u16),(12471u16,6958u16),
(12472u16,6959u16),(12473u16,6960u16),(12474u16,6961u16),(12475u16,6962u16),
(12476u16,6963u16),(12477u16,6964u16),(12478u16,6965u16),(12479u16,6966u16),
(12480u16,6967u16),(12481u16,6968u16),(12482u16,6969u16),(12483u16,6970u16),
(12484u16,6971u16),(12485u16,6972u16),(12486u16,6973u16),(12487u16,6974u16),
(12488u16,6975u16),(12489u16,6976u16),(12490u16,6977u16),(12491u16,6978u16),
(12492u16,6979u16),(12493u16,6980u16),(12494u16,6981u16),(12495u16,6982u16),
(12496u16,6983u16),(12497u16,6984u16),(12498u16,6985u16),(12499u16,6986u16),
(12500u16,6987u16),(12501u16,6988u16),(12502u16,6989u16),(12503u16,6990u16),
(12504u16,6991u16),(12505u16,6992u16),(12506u16,6993u16),(12507u16,6994u16),
(12508u16,6995u16),(12509u16,6996u16),(12510u16,6997u16),(12511u16,6998u16),
(12512u16,6999u16),(12513u16,7000u16),(12514u16,7001u16),(12515u16,7002u16),
(12516u16,7003u16),(12517u16,7004u16),(12518u16,7005u16),(12519u16,7006u16),
(12520u16,7007u16),(12521u16,7008u16),(12522u16,7009u16),(12523u16,7010u16),
(12524u16,7011u16),(12525u16,7012u16),(12526u16,7013u16),(12527u16,7014u16),
(12528u16,7015u16),(12529u16,7016u16),(12530u16,7017u16),(12531u16,7018u16),
(12532u16,7019u16),(12533u16,7020u16),(12534u16,7021u16),(12540u16,7632u16),
(12541u16,7635u16),(12542u16,7636u16),(12549u16,7542u16),(12550u16,7543u16),
(12551u16,7544u16),(12552u16,7545u16),(12553u16,7546u16),(12554u16,7547u16),
(12555u16,7548u16),(12556u16,7549u16),(12557u16,7550u16),(12558u16,7551u16),
(12559u16,7552u16),(12560u16,7553u16),(12561u16,7554u16),(12562u16,7555u16),
(12563u16,7556u16),(12564u16,7557u16),(12565u16,7558u16),(12566u16,7559u16),
(12567u16,7560u16),(12568u16,7561u16),(12569u16,7562u16),(12570u16,7563u16),
(12571u16,7564u16),(12572u16,7565u16),(12573u16,7566u16),(12574u16,7567u16),
(12575u16,7568u16),(12576u16,7569u16),(12577u16,7570u16),(12578u16,7571u16),
(12579u16,7572u16),(12580u16,7573u16),(12581u16,7574u16),(12582u16,7575u16),
(12583u16,7576u16),(12584u16,7577u16),(12585u16,7578u16),(12832u16,6434u16),
(12833u16,6435u16),(12834u16,6436u16),(12835u16,6437u16),(12836u16,6438u16),
(12837u16,6439u16),(12838u16,6440u16),(12839u16,6441u16),(12840u16,6442u16),
(12841u16,6443u16),(12849u16,7626u16),(12963u16,7609u16),(13198u16,7610u16),
(13199u16,7611u16),(13212u16,7612u16),(13213u16,7613u16),(13214u16,7614u16),
(13217u16,7615u16),(13252u16,7616u16),(13262u16,7617u16),(13265u16,7618u16),
(13266u16,7619u16),(13269u16,7620u16),(13383u16,23772u16),(13427u16,23771u16),
(13726u16,23776u16),(13838u16,23778u16),(13850u16,23777u16),(14616u16,23782u16),
(14702u16,23781u16),(14799u16,23784u16),(14800u16,23787u16),(14815u16,23785u16),
(14963u16,23786u16),(15182u16,23790u16),(15470u16,23791u16),(15584u16,23792u16),
(16470u16,23797u16),(16735u16,23798u16),(17207u16,23800u16),(17324u16,23806u16),
(17329u16,23805u16),(17373u16,23808u16),(17622u16,23809u16),(17996u16,23811u16),
(18017u16,23810u16),(18211u16,23813u16),(18217u16,23814u16),(18300u16,23815u16),
(18317u16,23816u16),(18759u16,23818u16),(18810u16,23819u16),(18813u16,23820u16),
(18818u16,23821u16),(18819u16,23822u16),(18821u16,23823u16),(18822u16,23824u16),
(18843u16,23826u16),(18847u16,23825u16),(18870u16,23828u16),(18871u16,23827u16),
(19575u16,23835u16),(19615u16,23832u16),(19616u16,23833u16),(19617u16,23834u16),
(19618u16,23836u16),(19619u16,23831u16),(19731u16,23837u16),(19732u16,23838u16),
(19733u16,23839u16),(19734u16,23840u16),(19735u16,23841u16),(19736u16,23842u16),
(19737u16,23843u16),(19886u16,23844u16),(19968u16,15512u16),(19969u16,10166u16),
(19971u16,13268u16),(19975u16,14617u16),(19976u16,16096u16),(19977u16,13678u16),
(19978u16,13822u16),(19979u16,14949u16),(19980u16,16627u16),(19981u16,9432u16),
(19982u16,15750u16),(19984u16,16629u16),(19985u16,9678u16),(19987u16,16443u16),
(19988u16,13445u16),(19989u16,16632u16),(19990u16,13997u16),(19992u16,13475u16),
(19993u16,9306u16),(19994u16,15506u16),(19995u16,9837u16),(19996u16,10176u16),
(19997u16,14186u16),(19998u16,16634u16),(20002u16,10175u16),(20004u16,12284u16),
(20005u16,15342u16),(20007u16,13780u16),(20008u16,16638u16),(20010u16,10631u16),
(20011u16,15325u16),(20012u16,18775u16),(20013u16,16293u16),(20016u16,10420u16),
(20018u16,9799u16),(20020u16,12312u16),(20022u16,16653u16),(20024u16,14607u16),
(20025u16,9979u16),(20026u16,14735u16),(20027u16,16332u16),(20029u16,12151u16),
(20030u16,11742u16),(20031u16,16640u16),(20035u16,12868u16),(20037u16,11720u16),
(20039u16,16642u16),(20040u16,12655u16),(20041u16,15554u16),(20043u16,16259u16),
(20044u16,14783u16),(20045u16,16062u16),(20046u16,11010u16),(20047u16,10361u16),
(20048u16,12119u16),(20050u16,13230u16),(20051u16,13065u16),(20052u16,13434u16),
(20054u16,10787u16),(20056u16,9638u16),(20057u16,15535u16),(20060u16,16656u16),
(20061u16,11722u16),(20062u16,13287u16),(20063u16,15503u16),(20064u16,14931u16),
(20065u16,14986u16),(20070u16,14038u16),(20073u16,16657u16),(20080u16,12527u16),
(20081u16,12495u16),(20083u16,13658u16),(20094u16,13407u16),(20102u16,12298u16),
(20104u16,15747u16),(20105u16,16144u16),(20107u16,13999u16),(20108u16,10259u16),
(20109u16,16626u16),(20110u16,15733u16),(20111u16,11962u16),(20113u16,15903u16),
(20114u16,11120u16),(20115u16,16658u16),(20116u16,14794u16),(20117u16,11699u16),
(20120u16,16633u16),(20122u16,15334u16),(20123u16,15114u16),(20127u16,16654u16),
(20128u16,16894u16),(20129u16,14621u16),(20130u16,11901u16),(20132u16,11522u16),
(20133u16,10930u16),(20134u16,15549u16),(20135u16,9495u16),(20136u16,10989u16),
(20137u16,12847u16),(20139u16,14992u16),(20140u16,11694u16),(20141u16,14539u16),
(20142u16,12288u16),(20146u16,13450u16),(20147u16,16896u16),(20149u16,16899u16),
(20154u16,13628u16),(20155u16,16698u16),(20159u16,15543u16),(20160u16,13983u16),
(20161u16,13627u16),(20162u16,16701u16),(20163u16,16699u16),(20164u16,16663u16),
(20165u16,11581u16),(20166u16,13250u16),(20167u16,9675u16),(20169u16,16700u16),
(20170u16,11576u16),(20171u16,11568u16),(20173u16,13637u16),(20174u16,9836u16),
(20177u16,12501u16),(20179u16,9459u16),(20180u16,16483u16),(20181u16,14008u16),
(20182u16,14246u16),(20183u16,16099u16),(20184u16,10567u16),(20185u16,14956u16),
(20189u16,16873u16),(20190u16,16705u16),(20191u16,13405u16),(20193u16,16703u16),
(20195u16,9875u16),(20196u16,12333u16),(20197u16,15537u16),(20200u16,16702u16),
(20202u16,15524u16),(20203u16,16704u16),(20204u16,12674u16),(20208u16,15381u16),
(20210u16,16302u16),(20211u16,16707u16),(20213u16,16710u16),(20214u16,11399u16),
(20215u16,11364u16),(20219u16,13631u16),(20221u16,10416u16),(20223u16,10389u16),
(20225u16,13288u16),(20233u16,16713u16),(20234u16,15518u16),(20237u16,14798u16),
(20238u16,11336u16),(20239u16,10447u16),(20240u16,10360u16),(20241u16,15166u16),
(20247u16,16303u16),(20248u16,15712u16),(20249u16,11194u16),(20250u16,11180u16),
(20251u16,16706u16),(20254u16,13776u16),(20255u16,14741u16),(20256u16,9796u16),
(20258u16,16708u16),(20260u16,13818u16),(20261u16,16711u16),(20262u16,12500u16),
(20263u16,16712u16),(20266u16,14742u16),(20267u16,16714u16),(20271u16,9419u16),
(20272u16,10767u16),(20274u16,16818u16),(20276u16,9098u16),(20278u16,12325u16),
(20280u16,13851u16),(20282u16,14192u16),(20284u16,14193u16),(20285u16,16819u16),
(20291u16,10047u16),(20294u16,9986u16),(20301u16,14752u16),(20302u16,10020u16),
(20303u16,16436u16),(20304u16,16519u16),(20305u16,15726u16),(20307u16,14414u16),
(20309u16,10971u16),(20311u16,16817u16),(20312u16,16875u16),(20313u16,15739u16),
(20314u16,16718u16),(20315u16,10435u16),(20316u16,16522u16),(20317u16,16719u16),
(20318u16,16715u16),(20319u16,16816u16),(20320u16,12892u16),(20323u16,15697u16),
(20324u16,16709u16),(20325u16,16876u16),(20327u16,16716u16),(20329u16,13084u16),
(20332u16,12113u16),(20335u16,15375u16),(20336u16,9084u16),(20339u16,11354u16),
(20340u16,16821u16),(20342u16,16820u16),(20347u16,16827u16),(20348u16,16829u16),
(20350u16,16826u16),(20351u16,13990u16),(20355u16,16824u16),(20356u16,16267u16),
(20360u16,9657u16),(20361u16,16823u16),(20363u16,12158u16),(20365u16,14009u16),
(20367u16,16825u16),(20369u16,16822u16),(20372u16,16831u16),(20375u16,10182u16),
(20379u16,10744u16),(20381u16,15517u16),(20384u16,14947u16),(20387u16,12479u16),
(20389u16,11531u16),(20390u16,16131u16),(20391u16,9469u16),(20392u16,13435u16),
(20393u16,11950u16),(20394u16,16828u16),(20396u16,16830u16),(20398u16,14799u16),
(20399u16,11003u16),(20405u16,13449u16),(20415u16,9282u16),(20419u16,9842u16),
(20420u16,10242u16),(20421u16,16835u16),(20426u16,11876u16),(20430u16,16877u16),
(20431u16,13441u16),(20432u16,12159u16),(20433u16,16839u16),(20439u16,14210u16),
(20440u16,10448u16),(20442u16,16836u16),(20444u16,16838u16),(20445u16,9218u16),
(20446u16,15740u16),(20447u16,16840u16),(20449u16,15142u16),(20451u16,16837u16),
(20454u16,16832u16),(20456u16,16833u16),(20457u16,12264u16),(20458u16,16834u16),
(20461u16,11388u16),(20462u16,15167u16),(20463u16,10554u16),(20465u16,11752u16),
(20467u16,16844u16),(20472u16,16841u16),(20474u16,9044u16),(20478u16,16849u16),
(20492u16,16851u16),(20493u16,9237u16),(20495u16,16846u16),(20498u16,10000u16),
(20500u16,11768u16),(20504u16,14385u16),(20505u16,11007u16),(20506u16,15533u16),
(20508u16,16850u16),(20511u16,11567u16),(20513u16,9606u16),(20517u16,16852u16),
(20518u16,11760u16),(20520u16,16853u16),(20521u16,16842u16),(20522u16,12888u16),
(20524u16,16845u16),(20525u16,16848u16),(20526u16,16847u16),(20538u16,16069u16),
(20540u16,16266u16),(20542u16,13462u16),(20547u16,16855u16),(20551u16,11362u16),
(20552u16,16857u16),(20556u16,16843u16),(20558u16,16858u16),(20559u16,13216u16),
(20565u16,16856u16),(20570u16,16521u16),(20572u16,14538u16),(20581u16,11496u16),
(20588u16,16859u16),(20598u16,13043u16),(20599u16,14556u16),(20603u16,16860u16),
(20606u16,16854u16),(20607u16,9600u16),(20608u16,11969u16),(20613u16,10566u16),
(20616u16,12157u16),(20621u16,9113u16),(20643u16,9871u16),(20645u16,16861u16),
(20647u16,16862u16),(20648u16,9787u16),(20649u16,16863u16),(20652u16,9848u16),
(20658u16,9058u16),(20666u16,16864u16),(20667u16,13796u16),(20687u16,14996u16),
(20694u16,16865u16),(20698u16,12292u16),(20710u16,16869u16),(20711u16,13789u16),
(20716u16,16868u16),(20717u16,16867u16),(20718u16,16870u16),(20723u16,14214u16),
(20725u16,11504u16),(20731u16,13212u16),(20742u16,16866u16),(20743u16,16871u16),
(20747u16,16872u16),(20754u16,13654u16),(20769u16,12125u16),(20799u16,10254u16),
(20800u16,16628u16),(20801u16,15907u16),(20803u16,15875u16),(20804u16,15159u16),
(20805u16,9663u16),(20806u16,16110u16),(20808u16,14955u16),(20809u16,10801u16),
(20811u16,11918u16),(20813u16,12701u16),(20817u16,10215u16),(20820u16,14570u16),
(20821u16,16893u16),(20822u16,16895u16),(20826u16,9994u16),(20828u16,10186u16),
(20834u16,11689u16),(20837u16,13660u16),(20840u16,13596u16),(20843u16,9068u16),
(20844u16,10746u16),(20845u16,12344u16),(20846u16,16881u16),(20848u16,12093u16),
(20849u16,10753u16),(20851u16,10791u16),(20852u16,15148u16),(20853u16,9303u16),
(20854u16,13273u16),(20855u16,11748u16),(20856u16,10043u16),(20857u16,16475u16),
(20859u16,15383u16),(20860u16,11375u16),(20861u16,14027u16),(20864u16,11334u16),
(20865u16,16885u16),(20866u16,16696u16),(20869u16,12883u16),(20872u16,10597u16),
(20873u16,13614u16),(20876u16,9470u16),(20877u16,15922u16),(20882u16,12651u16),
(20885u16,12700u16),(20886u16,17007u16),(20887u16,13648u16),(20889u16,15125u16),
(20891u16,11777u16),(20892u16,13024u16),(20896u16,10793u16),(20898u16,17008u16),
(20900u16,15874u16),(20901u16,17009u16),(20907u16,16906u16),(20908u16,10177u16),
(20911u16,10430u16),(20912u16,9304u16),(20913u16,16907u16),(20914u16,9664u16),
(20915u16,11771u16),(20917u16,11961u16),(20918u16,15502u16),(20919u16,12133u16),
(20923u16,10184u16),(20924u16,16909u16),(20925u16,16908u16),(20928u16,11712u16),
(20932u16,13269u16),(20934u16,16463u16),(20935u16,17006u16),(20937u16,12280u16),
(20939u16,10057u16),(20940u16,12327u16),(20943u16,11390u16),(20945u16,9838u16),
(20955u16,12316u16),(20957u16,12918u16),(20960u16,11329u16),(20961u16,10373u16),
(20964u16,10434u16),(20971u16,16891u16),(20973u16,13235u16),(20975u16,11888u16),
(20976u16,11158u16),(20979u16,10017u16),(20981u16,17236u16),(20982u16,15160u16),
(20984u16,14560u16),(20985u16,9053u16),(20986u16,9681u16),(20987u16,11202u16),
(20988u16,17237u16),(20989u16,10940u16),(20991u16,15933u16),(20992u16,9997u16),
(20993u16,10058u16),(20994u16,16679u16),(20995u16,13633u16),(20998u16,10409u16),
(20999u16,13443u16),(21000u16,16680u16),(21002u16,11890u16),(21005u16,17222u16),
(21006u16,16681u16),(21009u16,15149u16),(21010u16,11129u16),(21014u16,20265u16),
(21015u16,12303u16),(21016u16,12340u16),(21017u16,15947u16),(21018u16,10598u16),
(21019u16,9805u16),(21021u16,9680u16),(21024u16,13805u16),(21028u16,13063u16),
(21032u16,13072u16),(21033u16,12156u16),(21035u16,9295u16),(21037u16,16682u16),
(21038u16,10781u16),(21040u16,10004u16),(21043u16,16683u16),(21046u16,16283u16),
(21047u16,14157u16),(21048u16,13600u16),(21049u16,13793u16),(21050u16,9829u16),
(21051u16,11919u16),(21053u16,10819u16),(21055u16,16684u16),(21056u16,16685u16),
(21057u16,10236u16),(21058u16,11338u16),(21059u16,14419u16),(21066u16,15002u16),
(21068u16,16686u16),(21069u16,13411u16),(21072u16,10783u16),(21073u16,11498u16),
(21076u16,14407u16),(21078u16,13247u16),(21084u16,16689u16),(21086u16,16687u16),
(21089u16,16688u16),(21093u16,9119u16),(21095u16,11756u16),(21097u16,13968u16),
(21098u16,11389u16),(21103u16,10562u16),(21106u16,10623u16),(21117u16,16691u16),
(21119u16,11538u16),(21121u16,16693u16),(21122u16,16692u16),(21128u16,13107u16),
(21136u16,16694u16),(21139u16,16695u16),(21147u16,12261u16),(21149u16,13601u16),
(21150u16,9101u16),(21151u16,10741u16),(21152u16,11356u16),(21153u16,14806u16),
(21154u16,17224u16),(21155u16,12306u16),(21160u16,10180u16),(21161u16,16335u16),
(21162u16,13027u16),(21163u16,11552u16),(21164u16,17225u16),(21165u16,17226u16),
(21169u16,12153u16),(21170u16,11687u16),(21171u16,12110u16),(21182u16,17227u16),
(21183u16,14003u16),(21187u16,9415u16),(21191u16,15709u16),(21193u16,12702u16),
(21195u16,15306u16),(21200u16,17229u16),(21202u16,12118u16),(21206u16,17230u16),
(21208u16,11892u16),(21215u16,12853u16),(21220u16,13453u16),(21232u16,17231u16),
(21241u16,16887u16),(21242u16,13830u16),(21246u16,10755u16),(21247u16,14805u16),
(21248u16,15905u16),(21253u16,9117u16),(21254u16,9835u16),(21256u16,15162u16),
(21261u16,16888u16),(21263u16,17808u16),(21264u16,16890u16),(21269u16,16641u16),
(21270u16,11130u16),(21271u16,9232u16),(21273u16,9650u16),(21274u16,16671u16),
(21277u16,15914u16),(21280u16,11514u16),(21281u16,11954u16),(21283u16,14942u16),
(21286u16,16673u16),(21290u16,10398u16),(21294u16,16674u16),(21305u16,13210u16),
(21306u16,13483u16),(21307u16,15514u16),(21310u16,16675u16),(21311u16,12893u16),
(21313u16,13979u16),(21315u16,13402u16),(21317u16,16631u16),(21319u16,13868u16),
(21320u16,14796u16),(21321u16,11175u16),(21322u16,9100u16),(21326u16,11125u16),
(21327u16,15118u16),(21329u16,9231u16),(21330u16,16503u16),(21331u16,16466u16),
(21333u16,9980u16),(21334u16,12529u16),(21335u16,12872u16),(21338u16,9414u16),
(21340u16,9428u16),(21342u16,9284u16),(21343u16,17973u16),(21344u16,16083u16),
(21345u16,11883u16),(21346u16,12457u16),(21347u16,16678u16),(21348u16,12462u16),
(21350u16,16677u16),(21351u16,14777u16),(21353u16,17069u16),(21355u16,14757u16),
(21358u16,16645u16),(21359u16,12649u16),(21360u16,15676u16),(21361u16,14728u16),
(21363u16,11325u16),(21364u16,13605u16),(21365u16,12494u16),(21367u16,11762u16),
(21368u16,15127u16),(21370u16,17070u16),(21375u16,13463u16),(21378u16,9602u16),
(21380u16,10247u16),(21381u16,14437u16),(21382u16,12155u16),(21385u16,12152u16),
(21387u16,15320u16),(21388u16,15360u16),(21389u16,16664u16),(21397u16,9467u16),
(21400u16,12134u16),(21402u16,11006u16),(21405u16,16665u16),(21407u16,15878u16),
(21410u16,14980u16),(21411u16,16666u16),(21413u16,16667u16),(21414u16,14950u16),
(21416u16,9683u16),(21417u16,11724u16),(21422u16,16668u16),(21430u16,17239u16),
(21435u16,13590u16),(21439u16,14971u16),(21441u16,13679u16),(21442u16,9451u16),
(21448u16,15729u16),(21449u16,9475u16),(21450u16,11321u16),(21451u16,15724u16),
(21452u16,14166u16),(21453u16,10375u16),(21457u16,10357u16),(21460u16,14034u16),
(21462u16,13586u16),(21463u16,14025u16),(21464u16,9283u16),(21465u16,15185u16),
(21467u16,13064u16),(21471u16,17232u16),(21472u16,10069u16),(21475u16,11933u16),
(21476u16,10772u16),(21477u16,11753u16),(21478u16,12332u16),(21480u16,17977u16),
(21481u16,17976u16),(21482u16,16272u16),(21483u16,11543u16),(21484u16,16112u16),
(21485u16,9065u16),(21486u16,10168u16),(21487u16,11916u16),(21488u16,14353u16),
(21489u16,17974u16),(21490u16,13988u16),(21491u16,15725u16),(21493u16,16672u16),
(21494u16,15507u16),(21495u16,10962u16),(21496u16,14185u16),(21497u16,14375u16),
(21499u16,17978u16),(21500u16,10055u16),(21501u16,17975u16),(21505u16,15760u16),
(21507u16,9647u16),(21508u16,10632u16),(21510u16,17981u16),(21512u16,10972u16),
(21513u16,11315u16),(21514u16,10060u16),(21516u16,14547u16),(21517u16,12726u16),
(21518u16,11008u16),(21519u16,12149u16),(21520u16,14569u16),(21521u16,14997u16),
(21522u16,17979u16),(21523u16,14952u16),(21525u16,12477u16),(21526u16,17980u16),
(21527u16,12525u16),(21531u16,11778u16),(21533u16,12318u16),(21534u16,14579u16),
(21535u16,15572u16),(21536u16,10400u16),(21537u16,17988u16),(21539u16,17991u16),
(21542u16,10436u16),(21543u16,9066u16),(21544u16,10219u16),(21545u16,10407u16),
(21547u16,10937u16),(21548u16,14438u16),(21549u16,11927u16),(21550u16,14172u16),
(21551u16,13289u16),(21553u16,16253u16),(21554u16,17992u16),(21556u16,14791u16),
(21557u16,9614u16),(21560u16,14817u16),(21561u16,9806u16),(21563u16,14764u16),
(21564u16,11005u16),(21566u16,14790u16),(21568u16,15324u16),(21571u16,17987u16),
(21574u16,9869u16),(21576u16,9637u16),(21578u16,10615u16),(21579u16,17982u16),
(21584u16,12862u16),(21586u16,17983u16),(21587u16,17984u16),(21588u16,17985u16),
(21589u16,13042u16),(21590u16,17986u16),(21591u16,17989u16),(21592u16,15882u16),
(21593u16,17990u16),(21595u16,13421u16),(21596u16,14781u16),(21602u16,12881u16),
(21604u16,17997u16),(21606u16,18002u16),(21608u16,16305u16),(21617u16,17996u16),
(21618u16,18013u16),(21619u16,14747u16),(21621u16,10964u16),(21622u16,18001u16),
(21623u16,17995u16),(21624u16,13077u16),(21627u16,13850u16),(21628u16,11009u16),
(21629u16,12727u16),(21632u16,11740u16),(21634u16,17993u16),(21636u16,18000u16),
(21638u16,13071u16),(21643u16,16061u16),(21644u16,10970u16),(21646u16,11729u16),
(21647u16,15704u16),(21648u16,10577u16),(21650u16,16313u16),(21652u16,17994u16),
(21653u16,10765u16),(21654u16,11882u16),(21657u16,12347u16),(21658u16,17998u16),
(21659u16,17999u16),(21661u16,18003u16),(21667u16,18014u16),(21668u16,18024u16),
(21670u16,18010u16),(21671u16,18009u16),(21672u16,16476u16),(21673u16,18022u16),
(21674u16,18023u16),(21675u16,19170u16),(21676u16,15492u16),(21677u16,18005u16),
(21679u16,11884u16),(21681u16,15924u16),(21683u16,11915u16),(21684u16,18007u16),
(21688u16,14959u16),(21691u16,18016u16),(21693u16,15337u16),(21695u16,18017u16),
(21696u16,9032u16),(21697u16,13228u16),(21698u16,18006u16),(21700u16,10994u16),
(21702u16,10228u16),(21703u16,14594u16),(21704u16,10829u16),(21705u16,15918u16),
(21708u16,18018u16),(21709u16,14991u16),(21710u16,9030u16),(21711u16,18026u16),
(21712u16,18004u16),(21713u16,15333u16),(21714u16,18008u16),(21715u16,18011u16),
(21716u16,18012u16),(21717u16,18015u16),(21719u16,11124u16),(21721u16,18019u16),
(21722u16,18020u16),(21724u16,18021u16),(21725u16,18025u16),(21726u16,18027u16),
(21727u16,15695u16),(21733u16,10616u16),(21734u16,13037u16),(21735u16,18029u16),
(21736u16,13833u16),(21737u16,12263u16),(21738u16,12861u16),(21741u16,11937u16),
(21742u16,15003u16),(21746u16,16115u16),(21747u16,18033u16),(21754u16,9429u16),
(21756u16,10988u16),(21757u16,18031u16),(21759u16,17228u16),(21761u16,15363u16),
(21766u16,14239u16),(21767u16,9814u16),(21769u16,9031u16),(21775u16,18036u16),
(21776u16,14383u16),(21777u16,18037u16),(21780u16,18032u16),(21787u16,18028u16),
(21792u16,18030u16),(21794u16,18034u16),(21795u16,18035u16),(21796u16,11144u16),
(21799u16,18038u16),(21802u16,18039u16),(21804u16,11118u16),(21806u16,14024u16),
(21807u16,14733u16),(21808u16,18152u16),(21809u16,9605u16),(21811u16,18151u16),
(21815u16,18146u16),(21820u16,18049u16),(21822u16,14592u16),(21823u16,18047u16),
(21825u16,18045u16),(21827u16,11923u16),(21828u16,16471u16),(21830u16,13819u16),
(21833u16,18043u16),(21834u16,9026u16),(21840u16,18048u16),(21845u16,18046u16),
(21846u16,18147u16),(21852u16,18153u16),(21857u16,10395u16),(21860u16,13206u16),
(21861u16,13797u16),(21862u16,12083u16),(21863u16,18040u16),(21866u16,13045u16),
(21868u16,16661u16),(21869u16,18044u16),(21870u16,12911u16),(21877u16,18148u16),
(21878u16,18149u16),(21879u16,18150u16),(21880u16,15110u16),(21883u16,18165u16),
(21884u16,14413u16),(21886u16,18162u16),(21888u16,11881u16),(21889u16,18160u16),
(21890u16,14750u16),(21891u16,18156u16),(21892u16,13813u16),(21895u16,12079u16),
(21896u16,18159u16),(21897u16,11002u16),(21898u16,10941u16),(21899u16,18154u16),
(21903u16,18041u16),(21905u16,18164u16),(21908u16,18169u16),(21912u16,9798u16),
(21913u16,18170u16),(21916u16,14933u16),(21917u16,10965u16),(21919u16,18161u16),
(21927u16,15195u16),(21937u16,18157u16),(21939u16,15956u16),(21941u16,18042u16),
(21943u16,13086u16),(21945u16,18158u16),(21947u16,15762u16),(21949u16,18167u16),
(21950u16,18168u16),(21956u16,18181u16),(21957u16,15170u16),(21961u16,18173u16),
(21964u16,18186u16),(21965u16,18187u16),(21969u16,18175u16),(21970u16,18155u16),
(21971u16,13779u16),(21972u16,18178u16),(21974u16,18163u16),(21980u16,14005u16),
(21981u16,18180u16),(21983u16,18166u16),(21985u16,14768u16),(21987u16,14190u16),
(21988u16,18190u16),(21989u16,18183u16),(21990u16,18179u16),(21992u16,18188u16),
(21994u16,18171u16),(21995u16,18176u16),(21996u16,18177u16),(21999u16,18182u16),
(22002u16,18184u16),(22003u16,18185u16),(22005u16,18189u16),(22007u16,18172u16),
(22013u16,14207u16),(22014u16,18198u16),(22016u16,18199u16),(22017u16,18195u16),
(22024u16,18193u16),(22025u16,11351u16),(22028u16,18194u16),(22030u16,10579u16),
(22031u16,16662u16),(22040u16,15179u16),(22043u16,12524u16),(22046u16,18192u16),
(22047u16,18174u16),(22051u16,18197u16),(22052u16,18196u16),(22055u16,18200u16),
(22060u16,18205u16),(22061u16,18201u16),(22065u16,16331u16),(22066u16,9611u16),
(22068u16,16511u16),(22070u16,14182u16),(22073u16,18203u16),(22075u16,14816u16),
(22079u16,10982u16),(22092u16,18210u16),(22093u16,18206u16),(22094u16,15498u16),
(22100u16,18211u16),(22103u16,18204u16),(22104u16,18202u16),(22105u16,18208u16),
(22108u16,18209u16),(22114u16,18207u16),(22116u16,18213u16),(22120u16,13292u16),
(22121u16,16637u16),(22122u16,15940u16),(22123u16,18215u16),(22124u16,14006u16),
(22129u16,18214u16),(22134u16,10578u16),(22139u16,18216u16),(22140u16,18217u16),
(22149u16,18218u16),(22150u16,18212u16),(22158u16,10956u16),(22159u16,14416u16),
(22163u16,18219u16),(22179u16,15004u16),(22191u16,18220u16),(22199u16,13619u16),
(22204u16,11527u16),(22218u16,12875u16),(22228u16,18221u16),(22231u16,18222u16),
(22234u16,13479u16),(22235u16,14191u16),(22237u16,18223u16),(22238u16,11171u16),
(22239u16,16647u16),(22240u16,15567u16),(22241u16,18224u16),(22242u16,14572u16),
(22244u16,10223u16),(22251u16,18226u16),(22253u16,15881u16),(22256u16,12072u16),
(22257u16,9834u16),(22260u16,14732u16),(22261u16,18225u16),(22265u16,18227u16),
(22266u16,10779u16),(22269u16,10825u16),(22270u16,14563u16),(22271u16,18228u16),
(22275u16,13257u16),(22276u16,18229u16),(22278u16,15883u16),(22280u16,13591u16),
(22281u16,18231u16),(22282u16,18230u16),(22300u16,18232u16),(22303u16,14568u16),
(22307u16,13970u16),(22312u16,15923u16),(22313u16,17250u16),(22314u16,17252u16),
(22316u16,17251u16),(22317u16,10806u16),(22318u16,17255u16),(22319u16,17256u16),
(22320u16,10031u16),(22323u16,17253u16),(22329u16,17254u16),(22330u16,9596u16),
(22331u16,17258u16),(22334u16,11203u16),(22336u16,16268u16),(22338u16,17259u16),
(22343u16,11774u16),(22346u16,10382u16),(22348u16,17243u16),(22349u16,14359u16),
(22350u16,11893u16),(22351u16,11136u16),(22352u16,16523u16),(22353u16,11926u16),
(22359u16,11948u16),(22362u16,11370u16),(22363u16,14364u16),(22364u16,17257u16),
(22365u16,9076u16),(22366u16,14800u16),(22367u16,10411u16),(22368u16,16460u16),
(22369u16,13239u16),(22372u16,12069u16),(22374u16,14370u16),(22376u16,17266u16),
(22377u16,17260u16),(22378u16,13231u16),(22379u16,17262u16),(22381u16,17267u16),
(22383u16,13102u16),(22387u16,17269u16),(22390u16,17268u16),(22391u16,11907u16),
(22395u16,17265u16),(22396u16,17264u16),(22402u16,9810u16),(22403u16,12077u16),
(22404u16,12447u16),(22405u16,17261u16),(22406u16,17263u16),(22411u16,15150u16),
(22412u16,17272u16),(22418u16,12126u16),(22419u16,17277u16),(22427u16,10231u16),
(22432u16,17278u16),(22433u16,17245u16),(22434u16,10759u16),(22435u16,15876u16),
(22436u16,17271u16),(22438u16,11924u16),(22439u16,17275u16),(22441u16,17244u16),
(22443u16,10045u16),(22445u16,17270u16),(22446u16,11944u16),(22450u16,17273u16),
(22452u16,17276u16),(22456u16,17284u16),(22466u16,10736u16),(22467u16,9028u16),
(22475u16,12526u16),(22478u16,9634u16),(22479u16,17274u16),(22482u16,17283u16),
(22484u16,13255u16),(22485u16,17279u16),(22488u16,17280u16),(22489u16,17282u16),
(22490u16,17281u16),(22493u16,17289u16),(22495u16,15757u16),(22496u16,9431u16),
(22500u16,17288u16),(22509u16,17389u16),(22511u16,17286u16),(22516u16,17285u16),
(22520u16,17287u16),(22521u16,13079u16),(22522u16,11204u16),(22525u16,17388u16),
(22528u16,17390u16),(22530u16,14380u16),(22534u16,10214u16),(22535u16,17607u16),
(22539u16,17386u16),(22541u16,17387u16),(22545u16,13416u16),(22549u16,10238u16),
(22553u16,17392u16),(22558u16,17391u16),(22560u16,17394u16),(22561u16,9219u16),
(22564u16,10019u16),(22570u16,11891u16),(22576u16,15358u16),(22581u16,10199u16),
(22596u16,17393u16),(22604u16,14245u16),(22605u16,20318u16),(22609u16,14215u16),
(22612u16,14249u16),(22616u16,14378u16),(22622u16,13676u16),(22629u16,17395u16),
(22635u16,14423u16),(22636u16,17396u16),(22654u16,17246u16),(22656u16,17400u16),
(22657u16,17397u16),(22659u16,11704u16),(22661u16,14056u16),(22665u16,17398u16),
(22674u16,13817u16),(22675u16,12850u16),(22681u16,13424u16),(22682u16,17399u16),
(22686u16,15951u16),(22687u16,15175u16),(22696u16,12836u16),(22697u16,10218u16),
(22716u16,17247u16),(22721u16,9273u16),(22725u16,17248u16),(22737u16,17249u16),
(22741u16,10955u16),(22756u16,13617u16),(22763u16,13996u16),(22764u16,13626u16),
(22766u16,16454u16),(22768u16,13864u16),(22771u16,11914u16),(22774u16,11013u16),
(22777u16,15513u16),(22786u16,18551u16),(22788u16,9791u16),(22791u16,9239u16),
(22797u16,10565u16),(22799u16,14951u16),(22804u16,16886u16),(22805u16,14921u16),
(22806u16,14601u16),(22809u16,16892u16),(22810u16,10229u16),(22812u16,15510u16),
(22815u16,10762u16),(22820u16,18550u16),(22821u16,18548u16),(22823u16,9868u16),
(22825u16,14421u16),(22826u16,14356u16),(22827u16,10437u16),(22829u16,16643u16),
(22830u16,15370u16),(22831u16,10952u16),(22833u16,13972u16),(22836u16,14558u16),
(22839u16,15521u16),(22840u16,11943u16),(22841u16,11353u16),(22842u16,10230u16),
(22844u16,17802u16),(22849u16,17803u16),(22850u16,17223u16),(22852u16,15352u16),
(22855u16,13275u16),(22856u16,12871u16),(22857u16,10433u16),(22859u16,10415u16),
(22862u16,11967u16),(22863u16,16499u16),(22865u16,13290u16),(22868u16,9243u16),
(22869u16,17805u16),(22870u16,11512u16),(22871u16,14400u16),(22872u16,17807u16),
(22874u16,17806u16),(22880u16,10051u16),(22882u16,13836u16),(22885u16,9059u16),
(22899u16,13029u16),(22900u16,13026u16),(22902u16,12869u16),(22904u16,11378u16),
(22905u16,14248u16),(22909u16,10960u16),(22913u16,19184u16),(22914u16,13656u16),
(22915u16,19185u16),(22916u16,14628u16),(22918u16,16452u16),(22919u16,10575u16),
(22920u16,12517u16),(22922u16,13634u16),(22925u16,19186u16),(22930u16,10207u16),
(22931u16,11348u16),(22934u16,15388u16),(22935u16,19286u16),(22937u16,12713u16),
(22942u16,19289u16),(22947u16,19189u16),(22948u16,19290u16),(22949u16,14590u16),
(22952u16,10388u16),(22953u16,19187u16),(22954u16,19188u16),(22955u16,19288u16),
(22958u16,12886u16),(22959u16,19293u16),(22962u16,19292u16),(22969u16,12670u16),
(22971u16,13267u16),(22974u16,19295u16),(22982u16,12848u16),(22986u16,19287u16),
(22987u16,13993u16),(22992u16,11562u16),(22993u16,10770u16),(22994u16,19291u16),
(22995u16,15158u16),(22996u16,14740u16),(22999u16,19294u16),(23000u16,19301u16),
(23002u16,15491u16),(23004u16,11505u16),(23005u16,19298u16),(23011u16,19300u16),
(23013u16,12114u16),(23016u16,15529u16),(23020u16,11312u16),(23033u16,19302u16),
(23035u16,15571u16),(23039u16,16478u16),(23041u16,14629u16),(23043u16,14597u16),
(23044u16,12451u16),(23045u16,19296u16),(23046u16,19297u16),(23047u16,11526u16),
(23048u16,19299u16),(23049u16,19304u16),(23052u16,19303u16),(23057u16,19307u16),
(23059u16,19309u16),(23064u16,12904u16),(23068u16,12865u16),(23071u16,11759u16),
(23072u16,13854u16),(23075u16,19308u16),(23077u16,10245u16),(23081u16,12703u16),
(23089u16,15748u16),(23090u16,19305u16),(23092u16,19306u16),(23094u16,13587u16),
(23100u16,19314u16),(23104u16,19310u16),(23110u16,13242u16),(23113u16,14616u16),
(23114u16,19312u16),(23125u16,19313u16),(23130u16,11188u16),(23138u16,19315u16),
(23143u16,19311u16),(23146u16,12088u16),(23156u16,15679u16),(23157u16,19316u16),
(23158u16,13859u16),(23159u16,19320u16),(23162u16,19321u16),(23167u16,15191u16),
(23186u16,12664u16),(23194u16,12671u16),(23195u16,19319u16),(23210u16,19318u16),
(23218u16,19324u16),(23219u16,14932u16),(23221u16,20319u16),(23224u16,19327u16),
(23230u16,19322u16),(23233u16,11367u16),(23234u16,13784u16),(23241u16,11326u16),
(23244u16,14966u16),(23250u16,19325u16),(23252u16,19326u16),(23254u16,19331u16),
(23256u16,19333u16),(23260u16,19334u16),(23264u16,19328u16),(23265u16,10028u16),
(23267u16,19329u16),(23270u16,19332u16),(23273u16,12884u16),(23275u16,19323u16),
(23281u16,19330u16),(23305u16,19335u16),(23318u16,19337u16),(23319u16,19336u16),
(23346u16,19338u16),(23348u16,16903u16),(23351u16,19339u16),(23360u16,19340u16),
(23376u16,16486u16),(23377u16,19346u16),(23379u16,19347u16),(23380u16,11930u16),
(23381u16,15913u16),(23383u16,16489u16),(23384u16,9855u16),(23385u16,14234u16),
(23386u16,19343u16),(23387u16,16660u16),(23388u16,16481u16),(23389u16,15107u16),
(23391u16,12682u16),(23394u16,19348u16),(23395u16,11335u16),(23396u16,10769u16),
(23397u16,19344u16),(23398u16,15302u16),(23401u16,10927u16),(23402u16,12492u16),
(23404u16,16636u16),(23408u16,14040u16),(23409u16,19173u16),(23411u16,19345u16),
(23413u16,10440u16),(23418u16,13655u16),(23421u16,12910u16),(23424u16,19113u16),
(23425u16,12919u16),(23427u16,14247u16),(23428u16,19114u16),(23429u16,16067u16),
(23431u16,15753u16),(23432u16,14021u16),(23433u16,9043u16),(23435u16,14201u16),
(23436u16,14609u16),(23439u16,10999u16),(23443u16,19116u16),(23445u16,19115u16),
(23447u16,16493u16),(23448u16,10792u16),(23449u16,16315u16),(23450u16,10173u16),
(23451u16,14615u16),(23452u16,15528u16),(23453u16,9221u16),(23454u16,13986u16),
(23456u16,9667u16),(23457u16,13858u16),(23458u16,11920u16),(23459u16,15196u16),
(23460u16,14015u16),(23461u16,19117u16),(23462u16,11149u16),(23466u16,14975u16),
(23467u16,10747u16),(23472u16,15920u16),(23475u16,10931u16),(23476u16,15366u16),
(23477u16,15007u16),(23478u16,11355u16),(23480u16,19118u16),(23481u16,13646u16),
(23485u16,11952u16),(23486u16,9301u16),(23487u16,14217u16),(23490u16,11342u16),
(23492u16,11341u16),(23493u16,15575u16),(23494u16,12695u16),(23495u16,11935u16),
(23500u16,10572u16),(23504u16,12669u16),(23506u16,10939u16),(23507u16,15867u16),
(23517u16,13457u16),(23518u16,12840u16),(23519u16,9481u16),(23521u16,10784u16),
(23524u16,19122u16),(23525u16,12295u16),(23528u16,16070u16),(23534u16,19123u16),
(23536u16,19125u16),(23544u16,9856u16),(23545u16,10217u16),(23546u16,14189u16),
(23547u16,15311u16),(23548u16,10003u16),(23551u16,14022u16),(23553u16,10421u16),
(23556u16,13843u16),(23558u16,11506u16),(23561u16,14755u16),(23562u16,16515u16),
(23567u16,15106u16),(23569u16,13832u16),(23572u16,10256u16),(23573u16,19341u16),
(23574u16,11371u16),(23576u16,9625u16),(23578u16,13823u16),(23580u16,19342u16),
(23581u16,9597u16),(23586u16,17809u16),(23588u16,15715u16),(23589u16,17810u16),
(23591u16,15487u16),(23596u16,17811u16),(23601u16,11730u16),(23604u16,17812u16),
(23608u16,13977u16),(23609u16,15577u16),(23610u16,9658u16),(23611u16,19169u16),
(23612u16,12890u16),(23613u16,11686u16),(23614u16,14743u16),(23615u16,12907u16),
(23616u16,11739u16),(23617u16,13213u16),(23618u16,9472u16),(23621u16,11736u16),
(23624u16,13487u16),(23625u16,14420u16),(23626u16,11571u16),(23627u16,14786u16),
(23630u16,13991u16),(23631u16,13238u16),(23632u16,19171u16),(23633u16,15133u16),
(23637u16,16080u16),(23641u16,19172u16),(23646u16,14049u16),(23648u16,14567u16),
(23649u16,12482u16),(23651u16,19174u16),(23653u16,12481u16),(23654u16,19175u16),
(23662u16,19183u16),(23663u16,14580u16),(23665u16,13804u16),(23673u16,15542u16),
(23674u16,18343u16),(23679u16,15751u16),(23681u16,14229u16),(23682u16,13286u16),
(23688u16,18347u16),(23692u16,18342u16),(23693u16,18344u16),(23696u16,18345u16),
(23697u16,18350u16),(23700u16,9482u16),(23702u16,18346u16),(23703u16,10603u16),
(23704u16,18348u16),(23705u16,18349u16),(23706u16,18351u16),(23707u16,10001u16),
(23708u16,18352u16),(23714u16,18354u16),(23715u16,18359u16),(23721u16,15345u16),
(23723u16,18357u16),(23724u16,18356u16),(23725u16,12330u16),(23729u16,18358u16),
(23731u16,15897u16),(23733u16,18353u16),(23735u16,18361u16),(23736u16,9047u16),
(23741u16,18355u16),(23743u16,11964u16),(23745u16,18360u16),(23748u16,18362u16),
(23755u16,18365u16),(23762u16,18363u16),(23769u16,16282u16),(23777u16,14946u16),
(23780u16,18364u16),(23781u16,18366u16),(23782u16,12490u16),(23784u16,10240u16),
(23786u16,15763u16),(23789u16,13440u16),(23792u16,10424u16),(23803u16,11779u16),
(23810u16,18367u16),(23811u16,18368u16),(23814u16,18374u16),(23815u16,9666u16),
(23822u16,13278u16),(23828u16,9847u16),(23830u16,15329u16),(23835u16,18375u16),
(23838u16,18373u16),(23844u16,18372u16),(23846u16,18370u16),(23847u16,18369u16),
(23849u16,9247u16),(23853u16,16079u16),(23854u16,18371u16),(23860u16,18378u16),
(23869u16,18379u16),(23870u16,18377u16),(23879u16,21085u16),(23882u16,18386u16),
(23883u16,18385u16),(23884u16,13417u16),(23896u16,18376u16),(23899u16,18381u16),
(23901u16,18383u16),(23913u16,18387u16),(23915u16,18384u16),(23916u16,18380u16),
(23919u16,18382u16),(23924u16,18388u16),(23938u16,18389u16),(23961u16,18390u16),
(23965u16,18391u16),(23991u16,18393u16),(24005u16,18394u16),(24013u16,14726u16),
(24027u16,19536u16),(24029u16,9793u16),(24030u16,16306u16),(24033u16,15313u16),
(24034u16,9613u16),(24037u16,10739u16),(24038u16,16518u16),(24039u16,13436u16),
(24040u16,11747u16),(24041u16,10749u16),(24043u16,14780u16),(24046u16,9483u16),
(24047u16,17242u16),(24049u16,11331u16),(24050u16,15534u16),(24051u16,14195u16),
(24052u16,9070u16),(24055u16,14994u16),(24061u16,16882u16),(24062u16,11572u16),
(24065u16,9265u16),(24066u16,14013u16),(24067u16,9433u16),(24069u16,14162u16),
(24070u16,10366u16),(24072u16,13971u16),(24076u16,14918u16),(24079u16,18233u16),
(24080u16,16097u16),(24081u16,18236u16),(24084u16,18235u16),(24085u16,13048u16),
(24086u16,14436u16),(24088u16,12272u16),(24089u16,18234u16),(24090u16,16312u16),
(24091u16,9420u16),(24092u16,16281u16),(24093u16,10034u16),(24102u16,9873u16),
(24103u16,16246u16),(24109u16,14930u16),(24110u16,9104u16),(24113u16,18237u16),
(24119u16,18336u16),(24120u16,9598u16),(24123u16,18238u16),(24124u16,18239u16),
(24125u16,12652u16),(24130u16,12696u16),(24132u16,18337u16),(24133u16,10444u16),
(24140u16,11162u16),(24148u16,18338u16),(24149u16,12852u16),(24155u16,18339u16),
(24158u16,18340u16),(24161u16,18341u16),(24162u16,9802u16),(24178u16,10586u16),
(24179u16,13234u16),(24180u16,12899u16),(24182u16,9407u16),(24184u16,15155u16),
(24186u16,19534u16),(24187u16,11150u16),(24188u16,15730u16),(24189u16,15711u16),
(24191u16,10802u16),(24192u16,18572u16),(24196u16,16450u16),(24198u16,13471u16),
(24199u16,9266u16),(24202u16,9803u16),(24203u16,18574u16),(24207u16,15187u16),
(24208u16,12459u16),(24209u16,18573u16),(24211u16,11941u16),(24212u16,15681u16),
(24213u16,10030u16),(24214u16,18575u16),(24215u16,10049u16),(24217u16,12712u16),
(24218u16,10638u16),(24220u16,10559u16),(24222u16,13066u16),(24223u16,10402u16),
(24224u16,18577u16),(24229u16,18576u16),(24230u16,10205u16),(24231u16,16524u16),
(24237u16,14540u16),(24243u16,18581u16),(24245u16,18579u16),(24246u16,14057u16),
(24247u16,11896u16),(24248u16,15700u16),(24249u16,18578u16),(24254u16,18580u16),
(24265u16,12269u16),(24266u16,12105u16),(24273u16,18584u16),(24274u16,18583u16),
(24275u16,12075u16),(24278u16,12301u16),(24283u16,18585u16),(24296u16,18586u16),
(24298u16,18587u16),(24308u16,17235u16),(24310u16,15346u16),(24311u16,14537u16),
(24314u16,11503u16),(24318u16,17800u16),(24319u16,16630u16),(24320u16,11885u16),
(24321u16,17240u16),(24322u16,15561u16),(24323u16,13295u16),(24324u16,13025u16),
(24328u16,17801u16),(24330u16,9270u16),(24331u16,17969u16),(24335u16,13994u16),
(24337u16,17972u16),(24339u16,10748u16),(24341u16,15578u16),(24343u16,10550u16),
(24344u16,11000u16),(24347u16,9653u16),(24351u16,10035u16),(24352u16,16092u16),
(24357u16,12689u16),(24358u16,14965u16),(24359u16,11116u16),(24361u16,19178u16),
(24362u16,19177u16),(24365u16,19179u16),(24367u16,14603u16),(24369u16,13670u16),
(24377u16,9990u16),(24378u16,13426u16),(24380u16,19181u16),(24384u16,20441u16),
(24400u16,19165u16),(24402u16,10808u16),(24403u16,9992u16),(24405u16,12473u16),
(24406u16,19167u16),(24407u16,19166u16),(24408u16,19168u16),(24413u16,15530u16),
(24417u16,18409u16),(24418u16,15151u16),(24420u16,14549u16),(24422u16,15364u16),
(24425u16,9447u16),(24426u16,9290u16),(24428u16,9297u16),(24429u16,13092u16),
(24432u16,16090u16),(24433u16,15691u16),(24435u16,18395u16),(24439u16,18396u16),
(24441u16,15544u16),(24443u16,9620u16),(24444u16,9258u16),(24448u16,14624u16),
(24449u16,16142u16),(24450u16,18397u16),(24452u16,11707u16),(24453u16,9878u16),
(24455u16,18398u16),(24456u16,10985u16),(24457u16,18399u16),(24458u16,11133u16),
(24459u16,12486u16),(24460u16,18400u16),(24464u16,15181u16),(24466u16,14564u16),
(24469u16,18401u16),(24471u16,10010u16),(24472u16,13054u16),(24473u16,18402u16),
(24476u16,18403u16),(24481u16,15764u16),(24488u16,18404u16),(24490u16,15308u16),
(24493u16,18405u16),(24494u16,14727u16),(24501u16,18406u16),(24503u16,10009u16),
(24508u16,18407u16),(24509u16,11168u16),(24515u16,15141u16),(24516u16,18589u16),
(24517u16,9271u16),(24518u16,15553u16),(24521u16,18590u16),(24524u16,11346u16),
(24525u16,13629u16),(24527u16,18592u16),(24528u16,20519u16),(24529u16,20518u16),
(24530u16,17970u16),(24534u16,18591u16),(24535u16,16275u16),(24536u16,14627u16),
(24537u16,12641u16),(24541u16,18750u16),(24544u16,16295u16),(24545u16,18596u16),
(24548u16,18597u16),(24551u16,15714u16),(24554u16,18601u16),(24555u16,11951u16),
(24557u16,18602u16),(24558u16,18594u16),(24561u16,9627u16),(24565u16,12903u16),
(24568u16,18603u16),(24571u16,15140u16),(24573u16,11011u16),(24574u16,18598u16),
(24575u16,10417u16),(24576u16,11134u16),(24577u16,14357u16),(24578u16,14198u16),
(24579u16,18593u16),(24580u16,18595u16),(24581u16,18599u16),(24582u16,18600u16),
(24586u16,18612u16),(24589u16,18609u16),(24590u16,15950u16),(24591u16,18608u16),
(24594u16,13028u16),(24596u16,16145u16),(24597u16,13049u16),(24598u16,9437u16),
(24601u16,18604u16),(24603u16,18607u16),(24604u16,12270u16),(24605u16,14183u16),
(24608u16,9976u16),(24609u16,18614u16),(24613u16,11322u16),(24614u16,18606u16),
(24615u16,15157u16),(24616u16,15890u16),(24617u16,18610u16),(24618u16,10789u16),
(24619u16,18611u16),(24623u16,13446u16),(24629u16,18605u16),(24635u16,16495u16),
(24636u16,20616u16),(24639u16,18613u16),(24641u16,20620u16),(24642u16,18619u16),
(24643u16,14014u16),(24651u16,12276u16),(24653u16,11163u16),(24656u16,11929u16),
(24658u16,10992u16),(24661u16,14156u16),(24665u16,20621u16),(24666u16,20618u16),
(24669u16,20617u16),(24674u16,11169u16),(24675u16,20622u16),(24676u16,15189u16),
(24679u16,20619u16),(24680u16,10987u16),(24681u16,10252u16),(24682u16,18716u16),
(24683u16,10183u16),(24684u16,14426u16),(24685u16,10742u16),(24687u16,14917u16),
(24688u16,13396u16),(24691u16,11925u16),(24694u16,10246u16),(24696u16,18615u16),
(24697u16,18616u16),(24698u16,18618u16),(24699u16,18617u16),(24700u16,12878u16),
(24701u16,18717u16),(24703u16,15708u16),(24707u16,18722u16),(24708u16,13431u16),
(24713u16,14919u16),(24716u16,18724u16),(24717u16,10948u16),(24722u16,18723u16),
(24724u16,11173u16),(24726u16,18718u16),(24730u16,18719u16),(24731u16,18725u16),
(24733u16,18721u16),(24735u16,14807u16),(24736u16,15713u16),(24739u16,11143u16),
(24742u16,15900u16),(24744u16,12915u16),(24747u16,20623u16),(24748u16,15197u16),
(24749u16,18720u16),(24751u16,12720u16),(24753u16,18728u16),(24754u16,9230u16),
(24756u16,18733u16),(24760u16,11339u16),(24763u16,18727u16),(24764u16,10006u16),
(24773u16,13468u16),(24774u16,18731u16),(24778u16,11695u16),(24779u16,14614u16),
(24785u16,11198u16),(24789u16,14417u16),(24792u16,18730u16),(24794u16,18732u16),
(24796u16,14922u16),(24797u16,18729u16),(24799u16,14734u16),(24800u16,11176u16),
(24806u16,10050u16),(24807u16,11754u16),(24808u16,9455u16),(24809u16,9640u16),
(24811u16,9240u16),(24812u16,18726u16),(24813u16,9454u16),(24814u16,9987u16),
(24815u16,10798u16),(24816u16,10237u16),(24819u16,14990u16),(24820u16,18738u16),
(24822u16,11159u16),(24825u16,13624u16),(24826u16,15147u16),(24832u16,18739u16),
(24833u16,9673u16),(24838u16,20624u16),(24840u16,15765u16),(24841u16,15743u16),
(24845u16,20625u16),(24846u16,18740u16),(24847u16,15551u16),(24853u16,18736u16),
(24858u16,15737u16),(24863u16,10593u16),(24864u16,18734u16),(24867u16,18737u16),
(24868u16,10418u16),(24870u16,18735u16),(24871u16,12067u16),(24875u16,18741u16),
(24895u16,15889u16),(24904u16,9825u16),(24906u16,18742u16),(24908u16,11152u16),
(24910u16,13862u16),(24913u16,13844u16),(24917u16,12854u16),(24925u16,20626u16),
(24930u16,12538u16),(24935u16,11174u16),(24936u16,11889u16),(24944u16,14756u16),
(24949u16,18743u16),(24951u16,11897u16),(24971u16,9294u16),(24974u16,15952u16),
(24980u16,18745u16),(24989u16,20628u16),(24999u16,18746u16),(25000u16,10934u16),
(25001u16,20627u16),(25004u16,18744u16),(25015u16,18747u16),(25022u16,10947u16),
(25026u16,10179u16),(25032u16,15129u16),(25034u16,9060u16),(25035u16,20629u16),
(25041u16,20630u16),(25042u16,12098u16),(25044u16,18748u16),(25062u16,13034u16),
(25077u16,18749u16),(25087u16,17403u16),(25094u16,20631u16),(25096u16,10619u16),
(25098u16,14801u16),(25099u16,20052u16),(25100u16,15176u16),(25101u16,14054u16),
(25102u16,13639u16),(25103u16,14938u16),(25104u16,9636u16),(25105u16,14775u16),
(25106u16,11563u16),(25109u16,18777u16),(25110u16,11197u16),(25111u16,20053u16),
(25112u16,16084u16),(25114u16,13266u16),(25115u16,20054u16),(25119u16,20055u16),
(25121u16,20057u16),(25122u16,20056u16),(25124u16,20059u16),(25125u16,20058u16),
(25130u16,11551u16),(25132u16,20060u16),(25134u16,12475u16),(25139u16,9818u16),
(25140u16,9872u16),(25143u16,11122u16),(25149u16,20495u16),(25150u16,20494u16),
(25151u16,10386u16),(25152u16,14244u16),(25153u16,9281u16),(25155u16,20496u16),
(25159u16,13815u16),(25160u16,20497u16),(25161u16,20498u16),(25163u16,14019u16),
(25164u16,17813u16),(25165u16,9442u16),(25166u16,15955u16),(25169u16,13248u16),
(25170u16,9064u16),(25171u16,9867u16),(25172u16,13636u16),(25176u16,14583u16),
(25179u16,11899u16),(25187u16,11934u16),(25190u16,13399u16),(25191u16,16265u16),
(25193u16,12074u16),(25194u16,17814u16),(25195u16,13783u16),(25196u16,15374u16),
(25197u16,13019u16),(25198u16,9096u16),(25199u16,9617u16),(25200u16,13622u16),
(25203u16,9091u16),(25206u16,10441u16),(25209u16,13105u16),(25212u16,10248u16),
(25214u16,16105u16),(25215u16,9643u16),(25216u16,11333u16),(25220u16,9608u16),
(25225u16,11766u16),(25226u16,9074u16),(25233u16,15539u16),(25234u16,14032u16),
(25235u16,16440u16),(25237u16,14557u16),(25238u16,10187u16),(25239u16,11900u16),
(25240u16,16114u16),(25242u16,10552u16),(25243u16,13070u16),(25247u16,17815u16),
(25248u16,11932u16),(25249u16,12498u16),(25250u16,13427u16),(25252u16,11119u16),
(25253u16,9223u16),(25256u16,13089u16),(25259u16,13106u16),(25260u16,14352u16),
(25265u16,9222u16),(25269u16,10029u16),(25273u16,12833u16),(25275u16,17816u16),
(25276u16,15321u16),(25277u16,9668u16),(25279u16,12717u16),(25282u16,10442u16),
(25284u16,16329u16),(25285u16,9978u16),(25286u16,9485u16),(25287u16,12845u16),
(25288u16,12898u16),(25289u16,12078u16),(25290u16,17817u16),(25292u16,9097u16),
(25293u16,13051u16),(25294u16,12319u16),(25296u16,10788u16),(25298u16,11745u16),
(25299u16,14591u16),(25300u16,9071u16),(25302u16,14582u16),(25303u16,17819u16),
(25304u16,11733u16),(25305u16,16465u16),(25306u16,17818u16),(25307u16,16103u16),
(25308u16,9086u16),(25311u16,12891u16),(25314u16,12448u16),(25315u16,11385u16),
(25317u16,15696u16),(25318u16,12090u16),(25319u16,13016u16),(25320u16,9411u16),
(25321u16,15946u16),(25324u16,12073u16),(25325u16,14000u16),(25326u16,17820u16),
(25327u16,16147u16),(25329u16,10751u16),(25331u16,13598u16),(25332u16,14164u16),
(25334u16,17822u16),(25335u16,11904u16),(25340u16,13225u16),(25341u16,16442u16),
(25342u16,13981u16),(25343u16,12860u16),(25345u16,9649u16),(25346u16,10785u16),
(25351u16,16269u16),(25352u16,20137u16),(25353u16,9045u16),(25358u16,11945u16),
(25361u16,14429u16),(25366u16,14593u16),(25370u16,16276u16),(25371u16,12491u16),
(25373u16,14771u16),(25374u16,14347u16),(25375u16,15119u16),(25376u16,12876u16),
(25377u16,9993u16),(25378u16,17821u16),(25379u16,16140u16),(25380u16,11328u16),
(25381u16,11166u16),(25384u16,9029u16),(25386u16,13033u16),(25387u16,9861u16),
(25391u16,16136u16),(25394u16,20138u16),(25401u16,17823u16),(25402u16,14541u16),
(25405u16,14611u16),(25410u16,14795u16),(25411u16,17825u16),(25413u16,14552u16),
(25414u16,12071u16),(25417u16,16464u16),(25419u16,17824u16),(25420u16,9063u16),
(25421u16,10945u16),(25422u16,13826u16),(25423u16,12908u16),(25424u16,11757u16),
(25429u16,9427u16),(25438u16,12109u16),(25439u16,14235u16),(25441u16,11386u16),
(25442u16,11142u16),(25443u16,9998u16),(25447u16,13100u16),(25449u16,17835u16),
(25453u16,17832u16),(25454u16,11746u16),(25457u16,17828u16),(25462u16,9808u16),
(25463u16,11556u16),(25466u16,17829u16),(25467u16,12902u16),(25472u16,14953u16),
(25474u16,10039u16),(25479u16,10227u16),(25480u16,14023u16),(25481u16,10059u16),
(25482u16,17834u16),(25484u16,16093u16),(25486u16,17830u16),(25487u16,14390u16),
(25488u16,13299u16),(25490u16,13052u16),(25494u16,15505u16),(25496u16,11767u16),
(25504u16,12496u16),(25506u16,14374u16),(25507u16,9619u16),(25509u16,11546u16),
(25511u16,11931u16),(25512u16,14573u16),(25513u16,15353u16),(25514u16,9860u16),
(25516u16,17833u16),(25517u16,17826u16),(25518u16,17836u16),(25520u16,20139u16),
(25523u16,12461u16),(25524u16,17831u16),(25527u16,16277u16),(25528u16,9982u16),
(25530u16,9489u16),(25532u16,17837u16),(25534u16,17847u16),(25540u16,17842u16),
(25542u16,17846u16),(25545u16,13649u16),(25549u16,16500u16),(25550u16,17844u16),
(25551u16,12707u16),(25552u16,14410u16),(25554u16,9474u16),(25558u16,15515u16),
(25566u16,17843u16),(25568u16,17840u16),(25569u16,14778u16),(25571u16,9792u16),
(25577u16,11886u16),(25578u16,11715u16),(25581u16,11545u16),(25586u16,17838u16),
(25588u16,15879u16),(25590u16,17827u16),(25592u16,17839u16),(25597u16,12096u16),
(25599u16,17841u16),(25600u16,9488u16),(25601u16,10618u16),(25602u16,12452u16),
(25605u16,11528u16),(25611u16,17850u16),(25612u16,17853u16),(25615u16,9416u16),
(25616u16,9789u16),(25619u16,9859u16),(25620u16,13781u16),(25627u16,17851u16),
(25628u16,14204u16),(25630u16,10612u16),(25632u16,17852u16),(25633u16,17855u16),
(25638u16,17854u16),(25642u16,14379u16),(25644u16,9090u16),(25645u16,9863u16),
(25652u16,19121u16),(25658u16,15120u16),(25661u16,9480u16),(25663u16,20236u16),
(25665u16,17849u16),(25668u16,13842u16),(25669u16,17848u16),(25670u16,9083u16),
(25671u16,15486u16),(25672u16,9302u16),(25674u16,14360u16),(25682u16,17845u16),
(25684u16,14159u16),(25688u16,16065u16),(25694u16,17856u16),(25703u16,9846u16),
(25705u16,12831u16),(25709u16,17858u16),(25720u16,12729u16),(25721u16,12826u16),
(25722u16,17956u16),(25730u16,12299u16),(25732u16,17857u16),(25733u16,11764u16),
(25735u16,13223u16),(25745u16,9632u16),(25746u16,13671u16),(25749u16,14181u16),
(25750u16,17859u16),(25753u16,17959u16),(25758u16,16453u16),(25764u16,9618u16),
(25769u16,12290u16),(25772u16,13438u16),(25773u16,9410u16),(25774u16,9858u16),
(25776u16,16446u16),(25781u16,12901u16),(25783u16,17957u16),(25784u16,17958u16),
(25786u16,17960u16),(25788u16,10944u16),(25792u16,17961u16),(25794u16,12127u16),
(25797u16,13810u16),(25805u16,9462u16),(25806u16,13465u16),(25808u16,17962u16),
(25810u16,13455u16),(25815u16,17963u16),(25816u16,20237u16),(25822u16,14206u16),
(25826u16,17965u16),(25828u16,17964u16),(25830u16,9438u16),(25856u16,13057u16),
(25865u16,17966u16),(25874u16,15925u16),(25880u16,13618u16),(25893u16,17967u16),
(25899u16,11765u16),(25902u16,17968u16),(25903u16,16252u16),(25908u16,20068u16),
(25909u16,20257u16),(25910u16,14018u16),(25912u16,16717u16),(25913u16,10581u16),
(25915u16,10740u16),(25918u16,10392u16),(25919u16,16149u16),(25925u16,10777u16),
(25928u16,15112u16),(25929u16,21990u16),(25932u16,10023u16),(25935u16,12719u16),
(25937u16,11725u16),(25941u16,20258u16),(25942u16,9054u16),(25945u16,11539u16),
(25947u16,12273u16),(25949u16,9269u16),(25950u16,9603u16),(25954u16,10595u16),
(25955u16,13777u16),(25958u16,10221u16),(25963u16,20259u16),(25964u16,11705u16),
(25968u16,14058u16),(25970u16,13430u16),(25972u16,16146u16),(25975u16,10438u16),
(25991u16,14761u16),(25995u16,16066u16),(25996u16,9298u16),(26000u16,20444u16),
(26001u16,9088u16),(26003u16,20446u16),(26007u16,10188u16),(26009u16,12302u16),
(26011u16,22225u16),(26012u16,15122u16),(26015u16,16124u16),(26017u16,14776u16),
(26020u16,11574u16),(26021u16,9661u16),(26023u16,10556u16),(26025u16,16077u16),
(26027u16,20644u16),(26029u16,10212u16),(26031u16,14180u16),(26032u16,15139u16),
(26041u16,10384u16),(26044u16,20447u16),(26045u16,13974u16),(26049u16,13067u16),
(26051u16,20450u16),(26052u16,20449u16),(26053u16,12480u16),(26054u16,20448u16),
(26059u16,15198u16),(26060u16,20451u16),(26062u16,20452u16),(26063u16,16504u16),
(26066u16,20453u16),(26070u16,20454u16),(26071u16,13281u16),(26080u16,14787u16),
(26082u16,11345u16),(26085u16,13638u16),(26086u16,9984u16),(26087u16,11726u16),
(26088u16,16273u16),(26089u16,15936u16),(26092u16,15309u16),(26093u16,15186u16),
(26094u16,20069u16),(26095u16,20070u16),(26096u16,20071u16),(26097u16,10946u16),
(26102u16,13982u16),(26103u16,11960u16),(26106u16,14625u16),(26112u16,20077u16),
(26114u16,9051u16),(26115u16,20075u16),(26118u16,12070u16),(26122u16,20072u16),
(26124u16,9498u16),(26126u16,12722u16),(26127u16,11187u16),(26131u16,15540u16),
(26132u16,14809u16),(26133u16,20076u16),(26137u16,20073u16),(26141u16,20080u16),
(26143u16,15144u16),(26144u16,15694u16),(26149u16,9811u16),(26151u16,12668u16),
(26152u16,16517u16),(26157u16,16104u16),(26159u16,14004u16),(26161u16,20082u16),
(26164u16,20081u16),(26165u16,20084u16),(26166u16,20083u16),(26172u16,16316u16),
(26174u16,14967u16),(26177u16,20088u16),(26179u16,11161u16),(26187u16,11585u16),
(26188u16,13821u16),(26191u16,20089u16),(26194u16,13800u16),(26195u16,15009u16),
(26196u16,20087u16),(26197u16,15911u16),(26198u16,20090u16),(26199u16,20092u16),
(26202u16,14612u16),(26207u16,20086u16),(26209u16,20091u16),(26212u16,14803u16),
(26214u16,11177u16),(26216u16,9626u16),(26222u16,13258u16),(26223u16,11701u16),
(26224u16,14815u16),(26228u16,13466u16),(26230u16,11692u16),(26231u16,20093u16),
(26234u16,16284u16),(26238u16,12287u16),(26242u16,15926u16),(26244u16,20094u16),
(26247u16,14945u16),(26252u16,20095u16),(26257u16,14043u16),(26262u16,13030u16),
(26263u16,9046u16),(26269u16,20097u16),(26279u16,20096u16),(26280u16,22008u16),
(26286u16,12851u16),(26292u16,9224u16),(26297u16,19158u16),(26302u16,20098u16),
(26329u16,14044u16),(26331u16,20099u16),(26332u16,20100u16),(26333u16,13261u16),
(26342u16,20101u16),(26345u16,20102u16),(26352u16,15892u16),(26354u16,13485u16),
(26355u16,15508u16),(26356u16,10637u16),(26359u16,20079u16),(26361u16,9465u16),
(26364u16,12537u16),(26366u16,15953u16),(26367u16,14415u16),(26368u16,16513u16),
(26376u16,15899u16),(26377u16,15723u16),(26378u16,20270u16),(26379u16,13098u16),
(26381u16,10449u16),(26384u16,20287u16),(26388u16,14178u16),(26389u16,20297u16),
(26391u16,12107u16),(26395u16,14626u16),(26397u16,9610u16),(26399u16,13263u16),
(26406u16,20327u16),(26408u16,12855u16),(26410u16,14745u16),(26411u16,12834u16),
(26412u16,9245u16),(26413u16,15958u16),(26415u16,14050u16),(26417u16,16321u16),
(26420u16,13256u16),(26421u16,10233u16),(26426u16,11205u16),(26429u16,15169u16),
(26432u16,13792u16),(26434u16,15916u16),(26435u16,13593u16),(26438u16,10588u16),
(26440u16,19695u16),(26441u16,13803u16),(26444u16,19692u16),(26446u16,12143u16),
(26447u16,15156u16),(26448u16,9441u16),(26449u16,9854u16),(26451u16,19693u16),
(26454u16,16095u16),(26460u16,10202u16),(26462u16,19694u16),(26463u16,14053u16),
(26464u16,10605u16),(26465u16,14430u16),(26469u16,12085u16),(26472u16,15373u16),
(26473u16,19696u16),(26474u16,19699u16),(26477u16,10953u16),(26479u16,9228u16),
(26480u16,11555u16),(26482u16,20074u16),(26483u16,19700u16),(26485u16,19703u16),
(26487u16,19708u16),(26492u16,19709u16),(26494u16,14196u16),(26495u16,9094u16),
(26497u16,11316u16),(26500u16,10760u16),(26503u16,19698u16),(26505u16,14622u16),
(26507u16,19707u16),(26512u16,14811u16),(26517u16,16132u16),(26519u16,12309u16),
(26520u16,19701u16),(26522u16,12657u16),(26524u16,10826u16),(26525u16,16251u16),
(26526u16,19705u16),(26530u16,14029u16),(26531u16,15935u16),(26533u16,19697u16),
(26535u16,19702u16),(26536u16,19704u16),(26538u16,13420u16),(26539u16,10422u16),
(26541u16,19706u16),(26543u16,11936u16),(26544u16,19715u16),(26547u16,19720u16),
(26549u16,19718u16),(26550u16,11365u16),(26551u16,11352u16),(26552u16,19724u16),
(26561u16,19727u16),(26563u16,19723u16),(26564u16,9305u16),(26575u16,9081u16),
(26576u16,12844u16),(26577u16,10589u16),(26578u16,13271u16),(26579u16,13615u16),
(26580u16,13650u16),(26584u16,19712u16),(26585u16,19717u16),(26586u16,19719u16),
(26588u16,10816u16),(26589u16,19721u16),(26590u16,16520u16),(26592u16,12916u16),
(26594u16,19725u16),(26597u16,9478u16),(26601u16,19714u16),(26604u16,11382u16),
(26607u16,11909u16),(26608u16,19710u16),(26609u16,16334u16),(26611u16,12343u16),
(26612u16,9486u16),(26621u16,19728u16),(26623u16,13998u16),(26624u16,19722u16),
(26629u16,16059u16),(26631u16,9289u16),(26632u16,16082u16),(26633u16,19711u16),
(26634u16,19713u16),(26635u16,10181u16),(26636u16,19716u16),(26638u16,19726u16),
(26639u16,12089u16),(26641u16,14052u16),(26643u16,14163u16),(26646u16,13265u16),
(26647u16,12150u16),(26653u16,19738u16),(26657u16,15108u16),(26665u16,19747u16),
(26666u16,16319u16),(26674u16,19729u16),(26675u16,19730u16),(26679u16,15384u16),
(26680u16,10968u16),(26681u16,10634u16),(26684u16,10626u16),(26685u16,15917u16),
(26686u16,19744u16),(26688u16,19743u16),(26689u16,19741u16),(26690u16,10815u16),
(26691u16,14395u16),(26692u16,19735u16),(26693u16,14731u16),(26694u16,11957u16),
(26696u16,9049u16),(26697u16,19746u16),(26698u16,19745u16),(26700u16,16467u16),
(26702u16,19733u16),(26704u16,14544u16),(26705u16,13778u16),(26707u16,11139u16),
(26708u16,11554u16),(26709u16,19739u16),(26720u16,19731u16),(26721u16,19732u16),
(26722u16,19734u16),(26723u16,9996u16),(26724u16,19736u16),(26725u16,13432u16),
(26726u16,19740u16),(26727u16,19742u16),(26728u16,11511u16),(26729u16,16449u16),
(26731u16,19753u16),(26740u16,19750u16),(26742u16,14551u16),(26743u16,19751u16),
(26753u16,12281u16),(26755u16,19737u16),(26757u16,12658u16),(26758u16,9105u16),
(26767u16,19749u16),(26771u16,19752u16),(26775u16,10738u16),(26786u16,13825u16),
(26790u16,12681u16),(26791u16,14789u16),(26792u16,12135u16),(26797u16,14238u16),
(26799u16,14406u16),(26800u16,15126u16),(26803u16,14030u16),(26805u16,19748u16),
(26816u16,11381u16),(26818u16,19754u16),(26825u16,12697u16),(26827u16,13274u16),
(26829u16,10822u16),(26834u16,9109u16),(26837u16,16491u16),(26840u16,11317u16),
(26842u16,13094u16),(26848u16,14381u16),(26851u16,19861u16),(26862u16,13788u16),
(26864u16,19857u16),(26865u16,12131u16),(26869u16,11910u16),(26873u16,19759u16),
(26874u16,10790u16),(26876u16,19756u16),(26881u16,19859u16),(26885u16,15531u16),
(26891u16,19858u16),(26893u16,16263u16),(26894u16,16456u16),(26896u16,19862u16),
(26898u16,11518u16),(26911u16,19757u16),(26912u16,19758u16),(26916u16,19856u16),
(26925u16,14589u16),(26928u16,15497u16),(26932u16,19873u16),(26937u16,19864u16),
(26941u16,9795u16),(26943u16,9812u16),(26946u16,19866u16),(26964u16,15113u16),
(26967u16,19860u16),(26970u16,9689u16),(26973u16,19867u16),(26974u16,12132u16),
(26976u16,19865u16),(26979u16,19880u16),(26982u16,19879u16),(26987u16,19869u16),
(26990u16,19755u16),(26993u16,19863u16),(26999u16,11887u16),(27000u16,19872u16),
(27001u16,19881u16),(27004u16,12450u16),(27008u16,19870u16),(27010u16,10582u16),
(27012u16,19868u16),(27014u16,15735u16),(27015u16,19875u16),(27016u16,19876u16),
(27017u16,19878u16),(27021u16,19894u16),(27028u16,12103u16),(27029u16,19892u16),
(27032u16,19871u16),(27035u16,19882u16),(27036u16,9106u16),(27047u16,19883u16),
(27048u16,16060u16),(27051u16,19885u16),(27053u16,19886u16),(27057u16,19888u16),
(27060u16,12336u16),(27063u16,13607u16),(27067u16,19884u16),(27073u16,19889u16),
(27082u16,19890u16),(27084u16,19874u16),(27086u16,19877u16),(27088u16,11132u16),
(27092u16,19887u16),(27099u16,11392u16),(27103u16,19891u16),(27104u16,19893u16),
(27117u16,19897u16),(27122u16,19901u16),(27133u16,9464u16),(27135u16,19895u16),
(27146u16,10369u16),(27159u16,19898u16),(27160u16,19899u16),(27167u16,16088u16),
(27169u16,12828u16),(27176u16,19911u16),(27178u16,10990u16),(27183u16,19896u16),
(27185u16,15678u16),(27189u16,19907u16),(27197u16,19910u16),(27198u16,19903u16),
(27204u16,19902u16),(27207u16,13428u16),(27216u16,19905u16),(27224u16,19912u16),
(27225u16,9635u16),(27227u16,19906u16),(27233u16,14995u16),(27237u16,19900u16),
(27249u16,9682u16),(27257u16,19909u16),(27260u16,19913u16),(27264u16,14365u16),
(27268u16,14928u16),(27278u16,19908u16),(27280u16,19915u16),(27281u16,19914u16),
(27287u16,19917u16),(27296u16,19904u16),(27305u16,19916u16),(27307u16,19918u16),
(27308u16,12677u16),(27424u16,13418u16),(27425u16,9831u16),(27426u16,11137u16),
(27427u16,15137u16),(27428u16,20428u16),(27431u16,13038u16),(27442u16,15766u16),
(27447u16,20429u16),(27449u16,20430u16),(27450u16,13264u16),(27454u16,11953u16),
(27459u16,20431u16),(27462u16,20432u16),(27463u16,15115u16),(27465u16,13419u16),
(27468u16,10617u16),(27481u16,20433u16),(27490u16,16270u16),(27491u16,16148u16),
(27492u16,9828u16),(27493u16,9434u16),(27494u16,14793u16),(27495u16,13276u16),
(27498u16,14600u16),(27513u16,9870u16),(27515u16,14187u16),(27516u16,11368u16),
(27521u16,19921u16),(27522u16,19922u16),(27523u16,15369u16),(27524u16,19924u16),
(27526u16,9874u16),(27527u16,19923u16),(27529u16,15314u16),(27530u16,14031u16),
(27531u16,9453u16),(27533u16,19927u16),(27538u16,19925u16),(27539u16,19926u16),
(27542u16,16264u16),(27546u16,19928u16),(27547u16,19929u16),(27553u16,19930u16),
(27562u16,19931u16),(27571u16,20440u16),(27572u16,13040u16),(27573u16,10211u16),
(27575u16,15568u16),(27583u16,10053u16),(27585u16,11172u16),(27586u16,20442u16),
(27589u16,15552u16),(27595u16,14792u16),(27597u16,12849u16),(27599u16,12666u16),
(27602u16,10195u16),(27603u16,16650u16),(27604u16,9255u16),(27605u16,9262u16),
(27606u16,9264u16),(27607u16,13109u16),(27609u16,9263u16),(27611u16,12646u16),
(27617u16,16072u16),(27626u16,20239u16),(27627u16,10958u16),(27631u16,14371u16),
(27635u16,20240u16),(27637u16,20242u16),(27641u16,20243u16),(27645u16,20241u16),
(27653u16,20244u16),(27654u16,20246u16),(27655u16,20245u16),(27661u16,20247u16),
(27663u16,14012u16),(27664u16,16646u16),(27665u16,12716u16),(27667u16,12640u16),
(27668u16,13293u16),(27669u16,20248u16),(27670u16,12867u16),(27672u16,20249u16),
(27673u16,20250u16),(27674u16,20251u16),(27675u16,10408u16),(27679u16,10445u16),
(27681u16,20252u16),(27682u16,13461u16),(27684u16,20254u16),(27686u16,10929u16),
(27687u16,15380u16),(27688u16,9042u16),(27689u16,20253u16),(27690u16,20255u16),
(27694u16,9985u16),(27695u16,12485u16),(27696u16,13467u16),(27698u16,20256u16),
(27700u16,14169u16),(27701u16,18778u16),(27704u16,15707u16),(27709u16,16874u16),
(27712u16,14536u16),(27713u16,16258u16),(27714u16,13478u16),(27718u16,16879u16),
(27719u16,11182u16),(27721u16,10951u16),(27722u16,18781u16),(27728u16,14926u16),
(27732u16,18779u16),(27733u16,13814u16),(27735u16,10950u16),(27739u16,15315u16),
(27740u16,18780u16),(27741u16,13659u16),(27742u16,10750u16),(27743u16,11508u16),
(27744u16,9651u16),(27745u16,14784u16),(27748u16,14377u16),(27752u16,18787u16),
(27753u16,18788u16),(27754u16,14619u16),(27760u16,14358u16),(27762u16,11324u16),
(27764u16,18789u16),(27766u16,18790u16),(27769u16,15163u16),(27773u16,13296u16),
(27774u16,10413u16),(27777u16,13458u16),(27778u16,15527u16),(27779u16,14779u16),
(27781u16,18783u16),(27782u16,18791u16),(27784u16,13857u16),(27785u16,9628u16),
(27788u16,18786u16),(27791u16,13272u16),(27792u16,18784u16),(27795u16,20634u16),
(27796u16,18785u16),(27801u16,13794u16),(27803u16,13085u16),(27807u16,10756u16),
(27809u16,12662u16),(27811u16,18782u16),(27812u16,13044u16),(27813u16,12259u16),
(27814u16,12502u16),(27815u16,9460u16),(27817u16,18792u16),(27818u16,11121u16),
(27819u16,12838u16),(27821u16,18795u16),(27822u16,11743u16),(27825u16,18806u16),
(27826u16,18800u16),(27827u16,10976u16),(27832u16,10403u16),(27833u16,15720u16),
(27835u16,16291u16),(27836u16,16106u16),(27837u16,10768u16),(27838u16,16075u16),
(27839u16,15351u16),(27844u16,15130u16),(27845u16,13481u16),(27849u16,13595u16),
(27850u16,9425u16),(27852u16,12693u16),(27856u16,18793u16),(27859u16,18807u16),
(27860u16,18794u16),(27861u16,10363u16),(27862u16,18802u16),(27863u16,18799u16),
(27867u16,10381u16),(27870u16,13017u16),(27872u16,18801u16),(27873u16,13076u16),
(27874u16,9413u16),(27875u16,13297u16),(27877u16,12889u16),(27880u16,16437u16),
(27882u16,12130u16),(27883u16,18804u16),(27886u16,18805u16),(27887u16,18808u16),
(27888u16,14354u16),(27889u16,18798u16),(27891u16,15705u16),(27893u16,9250u16),
(27894u16,20635u16),(27895u16,18796u16),(27896u16,18797u16),(27898u16,18803u16),
(27899u16,15131u16),(27900u16,13240u16),(27901u16,15948u16),(27902u16,18809u16),
(27905u16,11559u16),(27908u16,18912u16),(27911u16,18911u16),(27915u16,15378u16),
(27916u16,18908u16),(27918u16,18914u16),(27922u16,13672u16),(27927u16,14935u16),
(27929u16,18913u16),(27930u16,18919u16),(27931u16,12514u16),(27934u16,10185u16),
(27941u16,11577u16),(27943u16,18907u16),(27946u16,10998u16),(27947u16,18915u16),
(27950u16,18917u16),(27953u16,10258u16),(27954u16,16307u16),(27955u16,18923u16),
(27957u16,18918u16),(27961u16,18906u16),(27963u16,11193u16),(27964u16,14596u16),
(27965u16,13397u16),(27966u16,13056u16),(27969u16,12342u16),(27971u16,18909u16),
(27973u16,13414u16),(27974u16,11507u16),(27975u16,11524u16),(27976u16,18910u16),
(27978u16,16474u16),(27979u16,9471u16),(27981u16,18916u16),(27982u16,11340u16),
(27983u16,18920u16),(27985u16,11190u16),(27986u16,18921u16),(27987u16,13023u16),
(27988u16,18922u16),(27993u16,16122u16),(27994u16,11878u16),(27996u16,18931u16),
(27998u16,18928u16),(28000u16,18932u16),(28003u16,18934u16),(28006u16,13259u16),
(28009u16,10963u16),(28010u16,12108u16),(28014u16,10546u16),(28015u16,18925u16),
(28020u16,15866u16),(28023u16,10928u16),(28024u16,11589u16),(28028u16,18933u16),
(28034u16,14566u16),(28037u16,12914u16),(28040u16,15006u16),(28041u16,13845u16),
(28044u16,15706u16),(28046u16,14964u16),(28049u16,18924u16),(28051u16,18929u16),
(28052u16,18930u16),(28053u16,14418u16),(28059u16,14391u16),(28061u16,12117u16),
(28062u16,18926u16),(28063u16,12271u16),(28064u16,18927u16),(28065u16,14773u16),
(28067u16,11148u16),(28068u16,10026u16),(28070u16,13668u16),(28071u16,11502u16),
(28072u16,16094u16),(28073u16,13787u16),(28074u16,10547u16),(28075u16,18947u16),
(28078u16,18949u16),(28079u16,15331u16),(28082u16,15511u16),(28085u16,10938u16),
(28088u16,10977u16),(28095u16,18940u16),(28096u16,10052u16),(28100u16,16480u16),
(28101u16,18937u16),(28102u16,15008u16),(28103u16,18936u16),(28107u16,12315u16),
(28108u16,14387u16),(28113u16,14036u16),(28118u16,12880u16),(28120u16,14397u16),
(28121u16,18945u16),(28125u16,18944u16),(28126u16,18938u16),(28128u16,18941u16),
(28129u16,9988u16),(28132u16,15732u16),(28134u16,18943u16),(28139u16,15574u16),
(28140u16,9852u16),(28142u16,11135u16),(28145u16,13853u16),(28147u16,9815u16),
(28151u16,11191u16),(28153u16,15340u16),(28155u16,14422u16),(28156u16,20636u16),
(28165u16,13464u16),(28170u16,15873u16),(28172u16,18948u16),(28173u16,16488u16),
(28174u16,18939u16),(28176u16,11500u16),(28177u16,18942u16),(28180u16,15745u16),
(28182u16,18946u16),(28183u16,13863u16),(28186u16,18935u16),(28189u16,15744u16),
(28192u16,13489u16),(28193u16,10206u16),(28195u16,15957u16),(28196u16,9424u16),
(28197u16,18960u16),(28201u16,14759u16),(28203u16,18950u16),(28205u16,14753u16),
(28207u16,10604u16),(28210u16,18959u16),(28212u16,11917u16),(28216u16,15721u16),
(28218u16,12711u16),(28227u16,13055u16),(28228u16,18961u16),(28237u16,14571u16),
(28238u16,18952u16),(28243u16,18957u16),(28244u16,18958u16),(28246u16,11019u16),
(28248u16,14985u16),(28251u16,16086u16),(28255u16,18955u16),(28267u16,18953u16),
(28270u16,18951u16),(28286u16,14604u16),(28287u16,13975u16),(28291u16,12068u16),
(28293u16,11501u16),(28294u16,18956u16),(28297u16,10585u16),(28303u16,18976u16),
(28304u16,15885u16),(28312u16,18964u16),(28316u16,12334u16),(28319u16,18978u16),
(28322u16,15556u16),(28325u16,18968u16),(28327u16,18969u16),(28330u16,14925u16),
(28335u16,14216u16),(28337u16,18963u16),(28338u16,18954u16),(28340u16,18974u16),
(28342u16,13645u16),(28343u16,18972u16),(28346u16,12896u16),(28347u16,18971u16),
(28349u16,18970u16),(28353u16,9687u16),(28354u16,18977u16),(28359u16,10040u16),
(28363u16,16479u16),(28367u16,18975u16),(28369u16,11127u16),(28371u16,16485u16),
(28372u16,14392u16),(28373u16,20323u16),(28375u16,18973u16),(28378u16,10821u16),
(28382u16,16290u16),(28383u16,18962u16),(28384u16,18965u16),(28385u16,12535u16),
(28386u16,18967u16),(28388u16,12488u16),(28389u16,12101u16),(28390u16,12493u16),
(28392u16,9300u16),(28393u16,14363u16),(28404u16,10021u16),(28409u16,18984u16),
(28418u16,13220u16),(28422u16,13270u16),(28425u16,18990u16),(28431u16,12454u16),
(28435u16,12141u16),(28436u16,15356u16),(28437u16,18983u16),(28448u16,12839u16),
(28452u16,18982u16),(28457u16,18991u16),(28458u16,18989u16),(28459u16,12539u16),
(28461u16,18966u16),(28463u16,18985u16),(28465u16,14059u16),(28467u16,16091u16),
(28470u16,18986u16),(28478u16,15385u16),(28486u16,18980u16),(28487u16,18981u16),
(28491u16,18987u16),(28493u16,14736u16),(28504u16,13058u16),(28508u16,13412u16),
(28510u16,12471u16),(28514u16,18979u16),(28518u16,12297u16),(28525u16,14367u16),
(28526u16,9612u16),(28530u16,18996u16),(28532u16,18988u16),(28536u16,18995u16),
(28538u16,18998u16),(28540u16,18997u16),(28548u16,9641u16),(28552u16,9621u16),
(28553u16,18992u16),(28556u16,18994u16),(28557u16,18993u16),(28558u16,13091u16),
(28572u16,12094u16),(28577u16,15937u16),(28583u16,19097u16),(28595u16,9061u16),
(28598u16,19099u16),(28601u16,19098u16),(28608u16,11309u16),(28610u16,19100u16),
(28617u16,19096u16),(28625u16,18999u16),(28626u16,9299u16),(28638u16,19103u16),
(28640u16,19104u16),(28641u16,19101u16),(28654u16,19102u16),(28655u16,19105u16),
(28689u16,13262u16),(28698u16,19106u16),(28699u16,19108u16),(28707u16,19107u16),
(28725u16,19110u16),(28729u16,19109u16),(28748u16,10799u16),(28751u16,19111u16),
(28766u16,19112u16),(28779u16,11195u16),(28780u16,20490u16),(28781u16,12715u16),
(28783u16,10013u16),(28784u16,11165u16),(28789u16,12328u16),(28790u16,15943u16),
(28792u16,11721u16),(28796u16,16473u16),(28798u16,15919u16),(28799u16,9456u16),
(28800u16,20455u16),(28805u16,20078u16),(28809u16,12460u16),(28810u16,9807u16),
(28814u16,15350u16),(28818u16,9615u16),(28820u16,13603u16),(28821u16,11902u16),
(28822u16,20457u16),(28825u16,16288u16),(28828u16,20456u16),(28829u16,20458u16),
(28843u16,20462u16),(28844u16,11755u16),(28845u16,14376u16),(28846u16,13073u16),
(28847u16,11713u16),(28849u16,20463u16),(28851u16,9309u16),(28855u16,20461u16),
(28856u16,16063u16),(28857u16,10042u16),(28859u16,20459u16),(28860u16,12277u16),
(28861u16,9662u16),(28864u16,20460u16),(28865u16,14179u16),(28866u16,12100u16),
(28867u16,14439u16),(28872u16,12305u16),(28874u16,20465u16),(28888u16,10995u16),
(28889u16,12116u16),(28891u16,16327u16),(28895u16,15339u16),(28900u16,11905u16),
(28902u16,10374u16),(28903u16,13828u16),(28904u16,20464u16),(28905u16,11181u16),
(28907u16,14389u16),(28908u16,11588u16),(28909u16,13625u16),(28911u16,14924u16),
(28919u16,14608u16),(28921u16,13090u16),(28925u16,10428u16),(28937u16,15336u16),
(28938u16,10949u16),(28944u16,20466u16),(28947u16,20467u16),(28949u16,11147u16),
(28950u16,20468u16),(28952u16,20491u16),(28953u16,9241u16),(28954u16,10412u16),
(28966u16,11520u16),(28975u16,20469u16),(28976u16,15365u16),(28977u16,20470u16),
(28982u16,13612u16),(28997u16,20474u16),(29002u16,20476u16),(29004u16,11160u16),
(29006u16,11374u16),(29020u16,20472u16),(29022u16,13798u16),(29028u16,12661u16),
(29030u16,20492u16),(29031u16,16108u16),(29032u16,20473u16),(29038u16,16328u16),
(29042u16,20475u16),(29043u16,20471u16),(29048u16,20477u16),(29050u16,20478u16),
(29053u16,13806u16),(29060u16,14923u16),(29066u16,15165u16),(29071u16,15307u16),
(29076u16,13644u16),(29080u16,20479u16),(29081u16,14810u16),(29087u16,14041u16),
(29088u16,20483u16),(29096u16,20482u16),(29100u16,9055u16),(29107u16,20480u16),
(29109u16,20481u16),(29113u16,20493u16),(29123u16,13613u16),(29134u16,12294u16),
(29140u16,20485u16),(29141u16,15359u16),(29152u16,20484u16),(29157u16,15944u16),
(29159u16,20486u16),(29166u16,17233u16),(29177u16,20487u16),(29190u16,9227u16),
(29213u16,20488u16),(29224u16,20489u16),(29226u16,16441u16),(29228u16,13047u16),
(29232u16,20263u16),(29233u16,9039u16),(29237u16,11769u16),(29238u16,10569u16),
(29239u16,15500u16),(29240u16,9079u16),(29241u16,10064u16),(29243u16,16644u16),
(29245u16,14167u16),(29247u16,18776u16),(29255u16,13217u16),(29256u16,9095u16),
(29260u16,13053u16),(29261u16,20260u16),(29266u16,20261u16),(29270u16,20262u16),
(29273u16,15327u16),(29275u16,13018u16),(29277u16,20127u16),(29279u16,12843u16),
(29281u16,12846u16),(29282u16,12111u16),(29286u16,20128u16),(29287u16,12858u16),
(29289u16,14804u16),(29294u16,20125u16),(29295u16,20129u16),(29298u16,13867u16),
(29301u16,13398u16),(29305u16,14401u16),(29306u16,14819u16),(29310u16,20130u16),
(29311u16,20131u16),(29312u16,14927u16),(29313u16,12136u16),(29316u16,20132u16),
(29322u16,10196u16),(29323u16,20133u16),(29325u16,20134u16),(29327u16,20135u16),
(29330u16,20136u16),(29343u16,20126u16),(29356u16,13599u16),(29357u16,18410u16),
(29359u16,10379u16),(29360u16,18411u16),(29364u16,18412u16),(29366u16,16455u16),
(29367u16,18413u16),(29368u16,18414u16),(29369u16,15719u16),(29377u16,18416u16),
(29378u16,11956u16),(29379u16,18415u16),(29380u16,10025u16),(29384u16,9238u16),
(29389u16,18418u16),(29390u16,18417u16),(29392u16,11017u16),(29394u16,18419u16),
(29399u16,10758u16),(29401u16,11734u16),(29406u16,12917u16),(29408u16,10986u16),
(29409u16,11533u16),(29416u16,18420u16),(29417u16,18422u16),(29420u16,10197u16),
(29421u16,14948u16),(29422u16,13973u16),(29423u16,18421u16),(29424u16,16143u16),
(29425u16,15767u16),(29426u16,18423u16),(29427u16,18427u16),(29428u16,18424u16),
(29431u16,18425u16),(29432u16,12139u16),(29434u16,18429u16),(29435u16,18526u16),
(29436u16,12104u16),(29441u16,18426u16),(29443u16,18428u16),(29450u16,18530u16),
(29454u16,12307u16),(29459u16,18528u16),(29461u16,18533u16),(29462u16,9499u16),
(29463u16,18527u16),(29467u16,12680u16),(29468u16,9439u16),(29469u16,18532u16),
(29470u16,18531u16),(29473u16,18529u16),(29474u16,18534u16),(29477u16,18536u16),
(29481u16,15146u16),(29482u16,16322u16),(29483u16,12643u16),(29484u16,18537u16),
(29486u16,14970u16),(29489u16,18539u16),(29492u16,11004u16),(29495u16,19919u16),
(29496u16,18538u16),(29497u16,18535u16),(29502u16,11126u16),(29503u16,15884u16),
(29517u16,18541u16),(29520u16,18540u16),(29522u16,19920u16),(29527u16,18542u16),
(29536u16,18543u16),(29548u16,18544u16),(29549u16,14346u16),(29551u16,18545u16),
(29566u16,18546u16),(29572u16,15199u16),(29575u16,12487u16),(29577u16,15756u16),
(29579u16,14620u16),(29582u16,19539u16),(29585u16,19540u16),(29590u16,11718u16),
(29595u16,12519u16),(29599u16,19543u16),(29602u16,19542u16),(29609u16,14605u16),
(29611u16,12656u16),(29614u16,19541u16),(29615u16,11138u16),(29616u16,14969u16),
(29618u16,12320u16),(29619u16,19548u16),(29623u16,19547u16),(29626u16,19559u16),
(29627u16,9408u16),(29632u16,19549u16),(29634u16,19545u16),(29640u16,19551u16),
(29641u16,19550u16),(29642u16,13801u16),(29645u16,16123u16),(29647u16,19544u16),
(29648u16,10364u16),(29649u16,19546u16),(29657u16,19553u16),(29662u16,19558u16),
(29664u16,16318u16),(29669u16,19552u16),(29671u16,19557u16),(29673u16,19556u16),
(29677u16,9089u16),(29682u16,19560u16),(29699u16,13477u16),(29701u16,12102u16),
(29702u16,12142u16),(29705u16,12335u16),(29706u16,19555u16),(29711u16,19561u16),
(29712u16,14241u16),(29722u16,19667u16),(29723u16,19666u16),(29730u16,16468u16),
(29733u16,19565u16),(29734u16,19564u16),(29736u16,19566u16),(29738u16,19562u16),
(29740u16,19569u16),(29742u16,19568u16),(29744u16,19567u16),(29747u16,12308u16),
(29748u16,13452u16),(29749u16,13108u16),(29750u16,13050u16),(29756u16,13472u16),
(29761u16,19668u16),(29781u16,19671u16),(29783u16,19670u16),(29785u16,19672u16),
(29786u16,11012u16),(29787u16,19563u16),(29788u16,19669u16),(29790u16,13665u16),
(29791u16,13785u16),(29805u16,19674u16),(29808u16,10804u16),(29814u16,15389u16),
(29815u16,19673u16),(29822u16,19675u16),(29824u16,19678u16),(29825u16,19679u16),
(29827u16,12262u16),(29831u16,19680u16),(29835u16,19681u16),(29838u16,19677u16),
(29840u16,19685u16),(29852u16,19676u16),(29854u16,19682u16),(29863u16,19686u16),
(29864u16,19683u16),(29865u16,19684u16),(29882u16,19688u16),(29906u16,19687u16),
(29916u16,10782u16),(29918u16,21197u16),(29920u16,21198u16),(29922u16,13221u16),
(29923u16,9099u16),(29924u16,13616u16),(29926u16,14598u16),(29934u16,14770u16),
(29935u16,20062u16),(29940u16,20063u16),(29942u16,13236u16),(29943u16,9826u16),
(29951u16,20064u16),(29956u16,16126u16),(29965u16,17664u16),(29967u16,20065u16),
(29969u16,20066u16),(29971u16,20067u16),(29976u16,10587u16),(29977u16,17971u16),
(29978u16,13860u16),(29980u16,14425u16),(29983u16,13865u16),(29989u16,13866u16),
(29992u16,15710u16),(29993u16,14161u16),(29995u16,10551u16),(29996u16,21199u16),
(29997u16,9249u16),(29999u16,19119u16),(30000u16,14424u16),(30001u16,15716u16),
(30002u16,11360u16),(30003u16,13849u16),(30005u16,10046u16),(30007u16,12873u16),
(30008u16,10048u16),(30010u16,20819u16),(30011u16,11128u16),(30014u16,19537u16),
(30016u16,20820u16),(30021u16,9604u16),(30024u16,20823u16),(30027u16,20822u16),
(30028u16,11566u16),(30030u16,20821u16),(30031u16,14748u16),(30036u16,13062u16),
(30041u16,12339u16),(30042u16,17241u16),(30043u16,20824u16),(30044u16,15188u16),
(30053u16,12497u16),(30054u16,13277u16),(30058u16,10367u16),(30066u16,20825u16),
(30068u16,9670u16),(30072u16,11206u16),(30073u16,20826u16),(30079u16,19535u16),
(30083u16,20827u16),(30086u16,11509u16),(30091u16,21441u16),(30095u16,14037u16),
(30097u16,15526u16),(30098u16,21243u16),(30100u16,21244u16),(30102u16,21245u16),
(30103u16,12293u16),(30105u16,10622u16),(30106u16,11731u16),(30109u16,21247u16),
(30111u16,13032u16),(30112u16,21246u16),(30113u16,15376u16),(30115u16,21249u16),
(30116u16,9069u16),(30117u16,11569u16),(30123u16,15548u16),(30124u16,21248u16),
(30126u16,9800u16),(30127u16,10427u16),(30128u16,21255u16),(30129u16,21254u16),
(30130u16,13208u16),(30131u16,21250u16),(30132u16,21251u16),(30133u16,9820u16),
(30136u16,21252u16),(30137u16,16133u16),(30140u16,14404u16),(30141u16,11735u16),
(30142u16,11323u16),(30146u16,21257u16),(30147u16,21256u16),(30148u16,21253u16),
(30149u16,9406u16),(30151u16,16247u16),(30152u16,15699u16),(30153u16,11708u16),
(30154u16,13597u16),(30157u16,21259u16),(30162u16,15382u16),(30164u16,16289u16),
(30165u16,10984u16),(30166u16,21258u16),(30168u16,10192u16),(30171u16,14555u16),
(30174u16,13211u16),(30178u16,12256u16),(30179u16,21260u16),(30180u16,21263u16),
(30182u16,21262u16),(30183u16,21265u16),(30184u16,21261u16),(30186u16,11145u16),
(30187u16,21264u16),(30192u16,14366u16),(30193u16,21267u16),(30196u16,9648u16),
(30201u16,9267u16),(30204u16,21268u16),(30207u16,21269u16),(30208u16,21271u16),
(30209u16,9850u16),(30211u16,21266u16),(30213u16,21272u16),(30218u16,21275u16),
(30220u16,21273u16),(30224u16,21270u16),(30229u16,21278u16),(30231u16,21274u16),
(30232u16,21277u16),(30233u16,21279u16),(30235u16,21376u16),(30239u16,14758u16),
(30240u16,21379u16),(30242u16,21378u16),(30244u16,12341u16),(30245u16,21276u16),
(30246u16,14026u16),(30249u16,9866u16),(30250u16,9296u16),(30251u16,14362u16),
(30253u16,21381u16),(30256u16,21382u16),(30259u16,21387u16),(30260u16,16101u16),
(30261u16,21384u16),(30264u16,13604u16),(30268u16,21377u16),(30270u16,21386u16),
(30271u16,21383u16),(30272u16,21380u16),(30275u16,21385u16),(30284u16,9034u16),
(30285u16,21388u16),(30292u16,21390u16),(30294u16,21392u16),(30300u16,21391u16),
(30302u16,21389u16),(30307u16,15297u16),(30315u16,21393u16),(30319u16,21394u16),
(30328u16,10814u16),(30331u16,10014u16),(30333u16,9080u16),(30334u16,9082u16),
(30338u16,15942u16),(30340u16,10011u16),(30342u16,11547u16),(30343u16,11157u16),
(30344u16,21192u16),(30347u16,10607u16),(30350u16,21193u16),(30353u16,9033u16),
(30355u16,21194u16),(30358u16,14613u16),(30361u16,21195u16),(30372u16,21196u16),
(30382u16,13209u16),(30385u16,16314u16),(30386u16,21443u16),(30388u16,21444u16),
(30399u16,12718u16),(30402u16,15734u16),(30405u16,16294u16),(30406u16,13087u16),
(30408u16,15690u16),(30410u16,15555u16),(30413u16,20838u16),(30414u16,9052u16),
(30415u16,16076u16),(30416u16,15341u16),(30417u16,11369u16),(30418u16,10973u16),
(30420u16,11963u16),(30422u16,10584u16),(30423u16,10008u16),(30424u16,13059u16),
(30427u16,13967u16),(30431u16,12678u16),(30437u16,20839u16),(30446u16,12856u16),
(30447u16,10167u16),(30449u16,20691u16),(30450u16,12639u16),(30452u16,16262u16),
(30456u16,14979u16),(30457u16,20694u16),(30460u16,13061u16),(30462u16,10225u16),
(30465u16,13966u16),(30468u16,20692u16),(30471u16,20695u16),(30472u16,20696u16),
(30473u16,12663u16),(30475u16,11895u16),(30477u16,20693u16),(30489u16,20699u16),
(30490u16,20697u16),(30495u16,16125u16),(30496u16,12698u16),(30498u16,20698u16),
(30502u16,20701u16),(30504u16,16058u16),(30505u16,15298u16),(30509u16,20700u16),
(30511u16,12683u16),(30517u16,20702u16),(30518u16,11959u16),(30519u16,11761u16),
(30520u16,20703u16),(30522u16,14432u16),(30524u16,15354u16),(30528u16,16472u16),
(30529u16,16141u16),(30531u16,20707u16),(30535u16,20706u16),(30544u16,20704u16),
(30545u16,20705u16),(30554u16,20708u16),(30555u16,11691u16),(30561u16,14170u16),
(30562u16,20806u16),(30563u16,10194u16),(30565u16,20807u16),(30566u16,12857u16),
(30568u16,20709u16),(30571u16,11557u16),(30572u16,9444u16),(30585u16,10200u16),
(30589u16,20810u16),(30590u16,16651u16),(30591u16,20808u16),(30592u16,20811u16),
(30596u16,12708u16),(30597u16,9677u16),(30604u16,20812u16),(30605u16,20809u16),
(30606u16,14940u16),(30609u16,20813u16),(30610u16,12532u16),(30623u16,20814u16),
(30624u16,20815u16),(30626u16,17776u16),(30629u16,13224u16),(30631u16,13433u16),
(30633u16,16330u16),(30634u16,10016u16),(30636u16,14173u16),(30640u16,20816u16),
(30643u16,14546u16),(30645u16,20817u16),(30651u16,16071u16),(30653u16,20818u16),
(30655u16,22361u16),(30669u16,17234u16),(30679u16,9788u16),(30683u16,12647u16),
(30684u16,21445u16),(30690u16,13989u16),(30691u16,15536u16),(30693u16,16255u16),
(30695u16,21077u16),(30697u16,11741u16),(30699u16,11530u16),(30700u16,21078u16),
(30701u16,10209u16),(30702u16,9036u16),(30707u16,13980u16),(30710u16,20637u16),
(30712u16,20638u16),(30717u16,14814u16),(30718u16,10370u16),(30719u16,11958u16),
(30720u16,20639u16),(30721u16,12520u16),(30722u16,13791u16),(30729u16,20640u16),
(30732u16,13291u16),(30733u16,11894u16),(30737u16,20643u16),(30738u16,13103u16),
(30740u16,15343u16),(30742u16,16444u16),(30743u16,20641u16),(30744u16,20642u16),
(30746u16,15361u16),(30748u16,20646u16),(30749u16,20647u16),(30751u16,20651u16),
(30755u16,20655u16),(30757u16,20653u16),(30758u16,20661u16),(30759u16,16127u16),
(30761u16,20656u16),(30764u16,20654u16),(30765u16,20645u16),(30768u16,13088u16),
(30772u16,13243u16),(30775u16,13848u16),(30776u16,15915u16),(30777u16,20648u16),
(30778u16,20649u16),(30779u16,20650u16),(30780u16,20652u16),(30782u16,12154u16),
(30784u16,9786u16),(30789u16,10807u16),(30791u16,20663u16),(30796u16,20664u16),
(30798u16,20657u16),(30800u16,20662u16),(30802u16,14813u16),(30805u16,14177u16),
(30806u16,20659u16),(30807u16,20660u16),(30813u16,15000u16),(30826u16,20665u16),
(30827u16,12337u16),(30828u16,15693u16),(30829u16,20658u16),(30830u16,13608u16),
(30839u16,11384u16),(30844u16,13095u16),(30855u16,20669u16),(30857u16,10054u16),
(30860u16,12466u16),(30861u16,9038u16),(30862u16,14228u16),(30865u16,9229u16),
(30867u16,20667u16),(30871u16,14610u16),(30872u16,10041u16),(30874u16,20668u16),
(30875u16,20666u16),(30876u16,20670u16),(30879u16,10065u16),(30881u16,20671u16),
(30883u16,20672u16),(30885u16,20675u16),(30887u16,9259u16),(30896u16,13101u16),
(30897u16,11383u16),(30898u16,20673u16),(30899u16,14373u16),(30900u16,9479u16),
(30905u16,20674u16),(30910u16,12900u16),(30913u16,9822u16),(30917u16,9110u16),
(30921u16,20678u16),(30922u16,12123u16),(30923u16,9857u16),(30928u16,13060u16),
(30932u16,20676u16),(30933u16,11911u16),(30937u16,20677u16),(30952u16,12830u16),
(30956u16,20679u16),(30962u16,20680u16),(30964u16,20682u16),(30967u16,12310u16),
(30970u16,11154u16),(30977u16,11519u16),(30981u16,20681u16),(30995u16,20683u16),
(31006u16,20685u16),(31012u16,20684u16),(31028u16,20686u16),(31034u16,13995u16),
(31035u16,20499u16),(31036u16,12146u16),(31038u16,13846u16),(31040u16,20500u16),
(31041u16,13283u16),(31046u16,20501u16),(31048u16,13282u16),(31049u16,20502u16),
(31059u16,20505u16),(31062u16,16505u16),(31063u16,20508u16),(31066u16,20506u16),
(31067u16,20503u16),(31068u16,20504u16),(31069u16,16438u16),(31070u16,13856u16),
(31071u16,14233u16),(31072u16,20509u16),(31074u16,20507u16),(31077u16,14988u16),
(31079u16,20511u16),(31080u16,13222u16),(31085u16,11337u16),(31087u16,20510u16),
(31095u16,10002u16),(31096u16,11201u16),(31098u16,20512u16),(31104u16,16902u16),
(31105u16,11586u16),(31108u16,12472u16),(31109u16,20513u16),(31114u16,20514u16),
(31119u16,10548u16),(31130u16,20515u16),(31143u16,20516u16),(31155u16,20517u16),
(31161u16,15752u16),(31162u16,16639u16),(31163u16,12140u16),(31165u16,13456u16),
(31166u16,10969u16),(31168u16,15172u16),(31169u16,14184u16),(31171u16,14561u16),
(31174u16,10594u16),(31177u16,9307u16),(31179u16,13474u16),(31181u16,16299u16),
(31185u16,11913u16),(31186u16,12710u16),(31189u16,21080u16),(31192u16,12691u16),
(31199u16,16501u16),(31203u16,21082u16),(31204u16,9646u16),(31206u16,13451u16),
(31207u16,15372u16),(31209u16,16285u16),(31211u16,21083u16),(31213u16,21081u16),
(31215u16,11208u16),(31216u16,9633u16),(31224u16,11548u16),(31227u16,15523u16),
(31229u16,11179u16),(31232u16,14916u16),(31234u16,21087u16),(31235u16,21086u16),
(31238u16,21084u16),(31243u16,9639u16),(31245u16,13827u16),(31246u16,14171u16),
(31252u16,21089u16),(31255u16,9087u16),(31258u16,16286u16),(31262u16,21088u16),
(31264u16,9672u16),(31267u16,22378u16),(31283u16,14765u16),(31287u16,21187u16),
(31289u16,21186u16),(31291u16,10005u16),(31292u16,11363u16),(31293u16,11207u16),
(31295u16,10614u16),(31302u16,12859u16),(31313u16,21188u16),(31319u16,14230u16),
(31344u16,21191u16),(31348u16,15303u16),(31350u16,11716u16),(31351u16,13473u16),
(31352u16,21397u16),(31353u16,21398u16),(31354u16,11928u16),(31359u16,9794u16),
(31360u16,21399u16),(31361u16,14562u16),(31363u16,13447u16),(31364u16,16068u16),
(31366u16,21400u16),(31368u16,21401u16),(31373u16,13442u16),(31377u16,15489u16),
(31378u16,16292u16),(31381u16,21402u16),(31382u16,11544u16),(31383u16,9801u16),
(31384u16,11714u16),(31388u16,9845u16),(31389u16,14774u16),(31391u16,11938u16),
(31392u16,21404u16),(31397u16,11965u16),(31398u16,21403u16),(31400u16,21406u16),
(31404u16,21405u16),(31405u16,21407u16),(31411u16,21408u16),(31423u16,12349u16),
(31435u16,12257u16),(31446u16,14055u16),(31449u16,16085u16),(31454u16,11711u16),
(31455u16,11710u16),(31456u16,16089u16),(31459u16,11877u16),(31461u16,14550u16),
(31462u16,21396u16),(31469u16,11558u16),(31471u16,10208u16),(31481u16,16326u16),
(31482u16,21790u16),(31485u16,21791u16),(31487u16,10590u16),(31491u16,21793u16),
(31492u16,21794u16),(31494u16,9067u16),(31496u16,21792u16),(31498u16,21796u16),
(31499u16,14236u16),(31503u16,21798u16),(31505u16,15111u16),(31508u16,9257u16),
(31509u16,21795u16),(31513u16,21802u16),(31515u16,10024u16),(31518u16,21810u16),
(31520u16,21805u16),(31524u16,21807u16),(31525u16,21806u16),(31526u16,10446u16),
(31528u16,9246u16),(31530u16,21801u16),(31531u16,21797u16),(31532u16,10033u16),
(31534u16,21803u16),(31537u16,21804u16),(31539u16,21808u16),(31544u16,21800u16),
(31546u16,11372u16),(31548u16,12348u16),(31550u16,21809u16),(31557u16,21813u16),
(31559u16,21799u16),(31561u16,10015u16),(31563u16,11573u16),(31564u16,21815u16),
(31567u16,10359u16),(31568u16,11955u16),(31569u16,16339u16),(31570u16,14553u16),
(31572u16,9865u16),(31574u16,9468u16),(31576u16,21811u16),(31578u16,21812u16),
(31579u16,13799u16),(31581u16,21816u16),(31584u16,21817u16),(31586u16,21820u16),
(31598u16,21818u16),(31601u16,21822u16),(31602u16,21821u16),(31605u16,21814u16),
(31607u16,11949u16),(31609u16,9674u16),(31611u16,21819u16),(31614u16,13404u16),
(31616u16,11387u16),(31621u16,21830u16),(31629u16,10766u16),(31632u16,21823u16),
(31636u16,9418u16),(31637u16,11209u16),(31639u16,14222u16),(31644u16,21832u16),
(31645u16,21828u16),(31649u16,10795u16),(31650u16,21833u16),(31654u16,21824u16),
(31655u16,21825u16),(31656u16,21829u16),(31657u16,12510u16),(31658u16,21831u16),
(31659u16,21834u16),(31660u16,21827u16),(31661u16,11398u16),(31665u16,14983u16),
(31668u16,21835u16),(31672u16,21826u16),(31681u16,21837u16),(31686u16,16448u16),
(31687u16,13215u16),(31692u16,21838u16),(31697u16,21836u16),(31699u16,12453u16),
(31705u16,10606u16),(31706u16,21840u16),(31709u16,21839u16),(31713u16,9844u16),
(31717u16,21841u16),(31718u16,21842u16),(31722u16,21843u16),(31726u16,12091u16),
(31729u16,12138u16),(31735u16,13096u16),(31740u16,21846u16),(31742u16,21845u16),
(31751u16,9841u16),(31755u16,21849u16),(31756u16,21844u16),(31759u16,21847u16),
(31766u16,21848u16),(31775u16,21946u16),(31782u16,21948u16),(31783u16,11156u16),
(31786u16,21947u16),(31800u16,21949u16),(31807u16,9435u16),(31808u16,21951u16),
(31809u16,21950u16),(31821u16,11319u16),(31859u16,12690u16),(31860u16,16880u16),
(31867u16,12129u16),(31868u16,21989u16),(31869u16,16484u16),(31881u16,10414u16),
(31889u16,21991u16),(31890u16,12258u16),(31893u16,13246u16),(31895u16,9839u16),
(31896u16,16074u16),(31900u16,21993u16),(31901u16,21992u16),(31902u16,21994u16),
(31903u16,14213u16),(31906u16,21995u16),(31908u16,15898u16),(31909u16,16309u16),
(31914u16,10419u16),(31918u16,12279u16),(31921u16,12282u16),(31922u16,21996u16),
(31923u16,11697u16),(31929u16,9851u16),(31932u16,21997u16),(31933u16,21998u16),
(31934u16,11696u16),(31937u16,21999u16),(31941u16,22004u16),(31943u16,22000u16),
(31944u16,22003u16),(31946u16,11018u16),(31948u16,22001u16),(31949u16,22002u16),
(31957u16,10611u16),(31958u16,14384u16),(31959u16,22005u16),(31961u16,9463u16),
(31964u16,12686u16),(31967u16,15932u16),(31968u16,11898u16),(31976u16,22006u16),
(31983u16,13035u16),(31992u16,22018u16),(31995u16,14936u16),(32010u16,14766u16),
(32032u16,14211u16),(32034u16,14242u16),(32039u16,11579u16),(32043u16,16482u16),
(32047u16,12124u16),(32110u16,15190u16),(32119u16,22019u16),(32166u16,22020u16),
(32174u16,22021u16),(32315u16,22582u16),(32321u16,10372u16),(32327u16,22022u16),
(32386u16,16510u16),(32411u16,22023u16),(32415u16,19374u16),(32416u16,11717u16),
(32417u16,19375u16),(32418u16,11001u16),(32419u16,19376u16),(32420u16,14958u16),
(32421u16,19377u16),(32422u16,15893u16),(32423u16,11327u16),(32424u16,19378u16),
(32425u16,19379u16),(32426u16,11350u16),(32427u16,13635u16),(32428u16,14744u16),
(32429u16,19476u16),(32431u16,9816u16),(32432u16,19477u16),(32433u16,13795u16),
(32434u16,10602u16),(32435u16,12866u16),(32437u16,16496u16),(32438u16,12503u16),
(32439u16,10410u16),(32440u16,16274u16),(32441u16,14763u16),(32442u16,10391u16),
(32445u16,13021u16),(32446u16,19478u16),(32447u16,14978u16),(32448u16,19479u16),
(32449u16,19480u16),(32450u16,19481u16),(32451u16,12278u16),(32452u16,16508u16),
(32453u16,13855u16),(32454u16,14939u16),(32455u16,16260u16),(32456u16,16298u16),
(32457u16,19482u16),(32458u16,9102u16),(32459u16,19483u16),(32460u16,19484u16),
(32461u16,13835u16),(32462u16,15564u16),(32463u16,11698u16),(32464u16,19485u16),
(32465u16,9108u16),(32466u16,13647u16),(32467u16,11560u16),(32468u16,19486u16),
(32469u16,13623u16),(32471u16,19487u16),(32472u16,11185u16),(32473u16,10633u16),
(32474u16,15299u16),(32475u16,19488u16),(32476u16,12516u16),(32477u16,11773u16),
(32478u16,11537u16),(32479u16,14554u16),(32480u16,19489u16),(32481u16,19490u16),
(32482u16,11763u16),(32483u16,15174u16),(32485u16,14226u16),(32486u16,14393u16),
(32487u16,11349u16),(32488u16,19491u16),(32489u16,11313u16),(32490u16,15192u16),
(32491u16,19492u16),(32493u16,15193u16),(32494u16,19493u16),(32495u16,19494u16),
(32496u16,9819u16),(32497u16,19495u16),(32498u16,19496u16),(32499u16,13869u16),
(32500u16,14737u16),(32501u16,12699u16),(32502u16,19498u16),(32503u16,9248u16),
(32504u16,9676u16),(32506u16,19499u16),(32507u16,19500u16),(32508u16,16494u16),
(32509u16,16087u16),(32510u16,19501u16),(32511u16,12489u16),(32512u16,16461u16),
(32513u16,19502u16),(32514u16,19503u16),(32515u16,19504u16),(32516u16,11379u16),
(32517u16,12704u16),(32518u16,12099u16),(32519u16,19505u16),(32520u16,19506u16),
(32521u16,11314u16),(32523u16,19507u16),(32524u16,19508u16),(32525u16,19497u16),
(32526u16,10213u16),(32527u16,19509u16),(32529u16,19510u16),(32530u16,19511u16),
(32531u16,11141u16),(32532u16,10037u16),(32533u16,12483u16),(32534u16,9279u16),
(32535u16,19512u16),(32536u16,15886u16),(32537u16,19513u16),(32538u16,10576u16),
(32539u16,19515u16),(32540u16,19514u16),(32541u16,10431u16),(32543u16,19516u16),
(32544u16,9493u16),(32545u16,19517u16),(32546u16,19518u16),(32547u16,19519u16),
(32548u16,19520u16),(32549u16,19521u16),(32550u16,19522u16),(32551u16,19523u16),
(32552u16,15682u16),(32553u16,14240u16),(32554u16,19524u16),(32555u16,19525u16),
(32556u16,19526u16),(32557u16,19527u16),(32558u16,13816u16),(32559u16,19528u16),
(32560u16,19529u16),(32561u16,19530u16),(32562u16,19531u16),(32563u16,19532u16),
(32564u16,11536u16),(32565u16,19533u16),(32566u16,21785u16),(32568u16,10600u16),
(32570u16,13602u16),(32578u16,21786u16),(32580u16,21787u16),(32581u16,21788u16),
(32592u16,10797u16),(32593u16,14623u16),(32596u16,16697u16),(32597u16,10942u16),
(32599u16,12507u16),(32600u16,20828u16),(32602u16,10358u16),(32607u16,20830u16),
(32609u16,20829u16),(32610u16,9078u16),(32616u16,20832u16),(32617u16,16109u16),
(32618u16,16514u16),(32622u16,16280u16),(32625u16,20834u16),(32626u16,14045u16),
(32628u16,20833u16),(32633u16,20835u16),(32638u16,20837u16),(32641u16,20836u16),
(32650u16,15377u16),(32652u16,13423u16),(32654u16,12667u16),(32660u16,10610u16),
(32666u16,12326u16),(32669u16,21983u16),(32670u16,15168u16),(32671u16,21984u16),
(32673u16,14974u16),(32676u16,13611u16),(32679u16,21985u16),(32687u16,21986u16),
(32688u16,21987u16),(32690u16,21988u16),(32696u16,16905u16),(32697u16,10639u16),
(32700u16,19176u16),(32701u16,15755u16),(32703u16,22009u16),(32705u16,14769u16),
(32709u16,9660u16),(32714u16,21395u16),(32716u16,15563u16),(32718u16,22010u16),
(32724u16,14987u16),(32725u16,22011u16),(32728u16,13439u16),(32735u16,10027u16),
(32736u16,9853u16),(32737u16,22013u16),(32741u16,22012u16),(32742u16,22014u16),
(32745u16,22015u16),(32750u16,22016u16),(32752u16,10943u16),(32753u16,9056u16),
(32755u16,22017u16),(32763u16,10368u16),(32764u16,15562u16),(32768u16,15496u16),
(32769u16,12112u16),(32771u16,11903u16),(32772u16,20238u16),(32773u16,16118u16),
(32774u16,20085u16),(32779u16,21458u16),(32780u16,10253u16),(32781u16,14158u16),
(32784u16,12870u16),(32786u16,21446u16),(32788u16,21447u16),(32789u16,10636u16),
(32790u16,21448u16),(32791u16,10961u16),(32792u16,15902u16),(32793u16,9075u16),
(32796u16,21449u16),(32800u16,21450u16),(32802u16,21451u16),(32805u16,21452u16),
(32806u16,21453u16),(32807u16,21454u16),(32808u16,21456u16),(32809u16,21455u16),
(32810u16,13068u16),(32817u16,21457u16),(32819u16,10255u16),(32821u16,21459u16),
(32822u16,15499u16),(32823u16,17804u16),(32824u16,14197u16),(32827u16,9655u16),
(32829u16,9977u16),(32831u16,10737u16),(32834u16,12909u16),(32835u16,21460u16),
(32838u16,21461u16),(32842u16,12291u16),(32843u16,12346u16),(32844u16,16261u16),
(32845u16,21462u16),(32850u16,21463u16),(32852u16,12265u16),(32856u16,13229u16),
(32858u16,11744u16),(32873u16,21464u16),(32874u16,9832u16),(32881u16,21465u16),
(32895u16,20633u16),(32896u16,20632u16),(32899u16,14219u16),(32900u16,15547u16),
(32902u16,14188u16),(32903u16,16111u16),(32905u16,13651u16),(32907u16,12128u16),
(32908u16,11306u16),(32915u16,20268u16),(32918u16,15109u16),(32920u16,16311u16),
(32922u16,10204u16),(32923u16,10601u16),(32924u16,20267u16),(32925u16,10591u16),
(32927u16,20266u16),(32928u16,9601u16),(32929u16,10776u16),(32930u16,16256u16),
(32932u16,10439u16),(32933u16,10397u16),(32937u16,11376u16),(32938u16,10385u16),
(32939u16,20273u16),(32941u16,20274u16),(32942u16,9050u16),(32943u16,11922u16),
(32945u16,20272u16),(32946u16,15768u16),(32948u16,20275u16),(32951u16,20276u16),
(32954u16,10401u16),(32956u16,20269u16),(32957u16,20271u16),(32958u16,13861u16),
(32959u16,16300u16),(32960u16,16100u16),(32961u16,15123u16),(32962u16,20282u16),
(32963u16,14749u16),(32964u16,20283u16),(32966u16,9983u16),(32972u16,9234u16),
(32973u16,20285u16),(32974u16,14350u16),(32982u16,13069u16),(32983u16,20286u16),
(32985u16,20284u16),(32986u16,13078u16),(32987u16,20281u16),(32988u16,13969u16),
(32989u16,20288u16),(32990u16,9116u16),(32993u16,11015u16),(32996u16,16648u16),
(32997u16,21442u16),(32999u16,20277u16),(33000u16,20278u16),(33001u16,20279u16),
(33002u16,20280u16),(33003u16,20289u16),(33004u16,19317u16),(33005u16,20292u16),
(33007u16,11947u16),(33008u16,15525u16),(33009u16,20290u16),(33010u16,20295u16),
(33011u16,10621u16),(33012u16,20291u16),(33014u16,11521u16),(33016u16,15161u16),
(33018u16,9048u16),(33020u16,20296u16),(33021u16,12885u16),(33026u16,16257u16),
(33030u16,9849u16),(33033u16,12531u16),(33034u16,11330u16),(33037u16,20293u16),
(33038u16,20294u16),(33039u16,15929u16),(33040u16,13279u16),(33041u16,12877u16),
(33042u16,20298u16),(33043u16,13022u16),(33044u16,16900u16),(33046u16,9422u16),
(33048u16,20303u16),(33050u16,11532u16),(33054u16,20301u16),(33068u16,20302u16),
(33071u16,10557u16),(33073u16,14584u16),(33074u16,20304u16),(33078u16,20300u16),
(33080u16,12274u16),(33086u16,13207u16),(33094u16,14428u16),(33096u16,20305u16),
(33098u16,12081u16),(33099u16,15509u16),(33100u16,20306u16),(33104u16,10560u16),
(33105u16,10558u16),(33107u16,20307u16),(33108u16,13422u16),(33109u16,14618u16),
(33113u16,20309u16),(33114u16,20310u16),(33120u16,20312u16),(33125u16,15145u16),
(33127u16,20317u16),(33129u16,20313u16),(33133u16,20316u16),(33134u16,13674u16),
(33136u16,15387u16),(33137u16,20311u16),(33140u16,20308u16),(33145u16,10570u16),
(33146u16,14972u16),(33147u16,12894u16),(33148u16,20314u16),(33149u16,20315u16),
(33150u16,14403u16),(33151u16,14575u16),(33152u16,9107u16),(33154u16,20321u16),
(33160u16,20320u16),(33162u16,9423u16),(33167u16,10609u16),(33169u16,20322u16),
(33176u16,9291u16),(33179u16,14382u16),(33180u16,12829u16),(33181u16,14920u16),
(33187u16,20324u16),(33190u16,20427u16),(33192u16,13097u16),(33194u16,20325u16),
(33203u16,13812u16),(33210u16,18588u16),(33211u16,20329u16),(33216u16,14581u16),
(33217u16,20426u16),(33218u16,9274u16),(33219u16,15698u16),(33222u16,15545u16),
(33226u16,20328u16),(33228u16,20326u16),(33251u16,9623u16),(33255u16,20061u16),
(33258u16,16487u16),(33260u16,21956u16),(33261u16,9679u16),(33267u16,16278u16),
(33268u16,16279u16),(33275u16,16128u16),(33276u16,11727u16),(33278u16,21952u16),
(33280u16,15493u16),(33281u16,21953u16),(33282u16,21954u16),(33284u16,21955u16),
(33285u16,11728u16),(33286u16,15738u16),(33292u16,13839u16),(33293u16,13840u16),
(33296u16,21789u16),(33298u16,14035u16),(33300u16,14427u16),(33307u16,18547u16),
(33308u16,14175u16),(33310u16,14797u16),(33311u16,16304u16),(33313u16,21958u16),
(33314u16,21959u16),(33315u16,21960u16),(33320u16,21963u16),(33322u16,10954u16),
(33323u16,21964u16),(33324u16,9092u16),(33325u16,21961u16),(33327u16,21962u16),
(33328u16,11497u16),(33329u16,9458u16),(33331u16,21967u16),(33332u16,21968u16),
(33333u16,10235u16),(33334u16,9421u16),(33335u16,14962u16),(33336u16,21965u16),
(33337u16,9797u16),(33339u16,21966u16),(33342u16,21969u16),(33348u16,21970u16),
(33351u16,14542u16),(33353u16,21971u16),(33355u16,21972u16),(33359u16,21973u16),
(33368u16,14205u16),(33370u16,21974u16),(33375u16,21975u16),(33384u16,21976u16),
(33390u16,22007u16),(33391u16,12283u16),(33392u16,11377u16),(33394u16,13786u16),
(33395u16,15357u16),(33396u16,19180u16),(33401u16,17404u16),(33402u16,15538u16),
(33405u16,17405u16),(33406u16,9037u16),(33407u16,17406u16),(33410u16,11553u16),
(33412u16,17410u16),(33416u16,16659u16),(33418u16,17408u16),(33419u16,15758u16),
(33421u16,13829u16),(33422u16,17411u16),(33423u16,17407u16),(33425u16,17412u16),
(33426u16,12637u16),(33431u16,17413u16),(33432u16,17422u16),(33433u16,17414u16),
(33436u16,14788u16),(33437u16,16250u16),(33439u16,17432u16),(33441u16,17430u16),
(33444u16,17435u16),(33445u16,11565u16),(33446u16,12456u16),(33448u16,17409u16),
(33449u16,17428u16),(33450u16,17431u16),(33451u16,17415u16),(33452u16,10405u16),
(33453u16,9062u16),(33454u16,17424u16),(33455u16,15135u16),(33456u16,17418u16),
(33457u16,11123u16),(33459u16,10383u16),(33460u16,17429u16),(33463u16,17423u16),
(33464u16,17416u16),(33465u16,13454u16),(33469u16,15326u16),(33470u16,17417u16),
(33473u16,17427u16),(33476u16,17433u16),(33479u16,14738u16),(33480u16,17419u16),
(33482u16,17420u16),(33483u16,17425u16),(33484u16,17426u16),(33485u16,9457u16),
(33486u16,17434u16),(33487u16,14208u16),(33489u16,15888u16),(33490u16,17444u16),
(33491u16,17448u16),(33492u16,14351u16),(33493u16,17455u16),(33495u16,12706u16),
(33496u16,17445u16),(33499u16,11908u16),(33500u16,17442u16),(33502u16,9115u16),
(33503u16,10757u16),(33504u16,17454u16),(33505u16,17436u16),(33507u16,17421u16),
(33508u16,17439u16),(33509u16,13669u16),(33510u16,11939u16),(33515u16,13802u16),
(33519u16,9244u16),(33521u16,15677u16),(33524u16,17443u16),(33527u16,17438u16),
(33529u16,13232u16),(33531u16,17447u16),(33537u16,16469u16),(33538u16,12650u16),
(33539u16,10377u16),(33540u16,13444u16),(33541u16,12644u16),(33542u16,17451u16),
(33543u16,17441u16),(33544u16,17460u16),(33545u16,17437u16),(33548u16,17446u16),
(33550u16,11690u16),(33551u16,17440u16),(33553u16,17449u16),(33556u16,17452u16),
(33557u16,17453u16),(33559u16,17473u16),(33562u16,17450u16),(33563u16,17577u16),
(33564u16,17456u16),(33575u16,11380u16),(33576u16,9821u16),(33579u16,12638u16),
(33580u16,9476u16),(33581u16,17475u16),(33583u16,17467u16),(33585u16,17464u16),
(33587u16,17477u16),(33588u16,17463u16),(33589u16,15565u16),(33590u16,9477u16),
(33592u16,13640u16),(33593u16,13652u16),(33594u16,17476u16),(33596u16,17462u16),
(33600u16,17472u16),(33603u16,17470u16),(33606u16,11688u16),(33607u16,17469u16),
(33609u16,9466u16),(33615u16,17468u16),(33616u16,11391u16),(33617u16,17457u16),
(33618u16,11151u16),(33620u16,12148u16),(33626u16,11357u16),(33627u16,17458u16),
(33628u16,17459u16),(33630u16,17466u16),(33631u16,17471u16),(33632u16,17474u16),
(33633u16,9995u16),(33635u16,13642u16),(33636u16,11186u16),(33637u16,17479u16),
(33638u16,17478u16),(33639u16,15686u16),(33640u16,17576u16),(33641u16,17578u16),
(33642u16,17580u16),(33643u16,15566u16),(33644u16,17579u16),(33645u16,17581u16),
(33646u16,17582u16),(33647u16,15494u16),(33655u16,10966u16),(33656u16,17584u16),
(33659u16,17597u16),(33660u16,17592u16),(33661u16,17595u16),(33669u16,17591u16),
(33670u16,13251u16),(33673u16,12147u16),(33678u16,13790u16),(33682u16,17461u16),
(33683u16,17589u16),(33688u16,17598u16),(33691u16,17465u16),(33692u16,17590u16),
(33694u16,17599u16),(33696u16,17587u16),(33704u16,17600u16),(33705u16,17594u16),
(33706u16,17588u16),(33707u16,12835u16),(33712u16,17583u16),(33713u16,12084u16),
(33714u16,12266u16),(33715u16,17585u16),(33716u16,17586u16),(33718u16,17593u16),
(33719u16,11196u16),(33720u16,17596u16),(33721u16,15683u16),(33722u16,17601u16),
(33724u16,17602u16),(33725u16,12642u16),(33728u16,17625u16),(33729u16,17603u16),
(33733u16,17624u16),(33735u16,10764u16),(33738u16,11738u16),(33740u16,11775u16),
(33743u16,10967u16),(33748u16,17617u16),(33750u16,17612u16),(33752u16,17606u16),
(33756u16,9448u16),(33757u16,17610u16),(33759u16,17618u16),(33760u16,9409u16),
(33761u16,17628u16),(33765u16,17605u16),(33769u16,13253u16),(33770u16,17623u16),
(33776u16,17627u16),(33777u16,12321u16),(33778u16,10393u16),(33784u16,17621u16),
(33785u16,17622u16),(33789u16,17611u16),(33793u16,17604u16),(33795u16,17620u16),
(33796u16,14394u16),(33798u16,17616u16),(33803u16,17609u16),(33804u16,12675u16),
(33805u16,13233u16),(33806u16,14739u16),(33807u16,17619u16),(33809u16,17615u16),
(33816u16,17608u16),(33820u16,17613u16),(33821u16,12505u16),(33828u16,15684u16),
(33829u16,15685u16),(33830u16,17626u16),(33831u16,14999u16),(33832u16,13673u16),
(33841u16,17645u16),(33848u16,17614u16),(33852u16,17639u16),(33853u16,12513u16),
(33862u16,17640u16),(33873u16,17630u16),(33879u16,16333u16),(33881u16,17632u16),
(33882u16,17631u16),(33883u16,10625u16),(33884u16,17629u16),(33889u16,13252u16),
(33891u16,10178u16),(33897u16,17641u16),(33899u16,11014u16),(33900u16,15930u16),
(33901u16,17646u16),(33905u16,9833u16),(33907u16,17633u16),(33909u16,11966u16),
(33910u16,17642u16),(33912u16,17638u16),(33914u16,17636u16),(33922u16,10032u16),
(33927u16,17634u16),(33928u16,17635u16),(33929u16,17637u16),(33931u16,11510u16),
(33932u16,17643u16),(33934u16,17644u16),(33943u16,17660u16),(33945u16,12676u16),
(33948u16,14221u16),(33953u16,17657u16),(33967u16,16690u16),(33970u16,13254u16),
(33972u16,17659u16),(33976u16,16139u16),(33977u16,17658u16),(33978u16,17655u16),
(33981u16,17651u16),(33983u16,17654u16),(33985u16,17647u16),(33988u16,15183u16),
(33993u16,13641u16),(33994u16,17653u16),(33997u16,17648u16),(34000u16,17649u16),
(34001u16,14237u16),(34003u16,17652u16),(34006u16,9260u16),(34013u16,12087u16),
(34015u16,11332u16),(34016u16,17656u16),(34019u16,17662u16),(34021u16,17661u16),
(34022u16,17650u16),(34028u16,13093u16),(34032u16,17666u16),(34044u16,17769u16),
(34047u16,17768u16),(34060u16,17663u16),(34065u16,12714u16),(34067u16,12536u16),
(34071u16,16120u16),(34074u16,14746u16),(34079u16,17668u16),(34081u16,9449u16),
(34091u16,12897u16),(34092u16,14028u16),(34103u16,13425u16),(34104u16,17665u16),
(34105u16,17667u16),(34106u16,17669u16),(34107u16,17767u16),(34108u16,9035u16),
(34109u16,9261u16),(34115u16,17777u16),(34120u16,17771u16),(34121u16,11517u16),
(34122u16,13664u16),(34134u16,17766u16),(34137u16,17770u16),(34142u16,17774u16),
(34148u16,17773u16),(34152u16,17772u16),(34162u16,17778u16),(34164u16,15909u16),
(34169u16,17784u16),(34170u16,17775u16),(34171u16,17779u16),(34174u16,12122u16),
(34180u16,9216u16),(34181u16,17787u16),(34183u16,17782u16),(34191u16,17783u16),
(34203u16,15301u16),(34204u16,17786u16),(34212u16,17780u16),(34216u16,17781u16),
(34218u16,15134u16),(34222u16,17785u16),(34223u16,14042u16),(34224u16,17790u16),
(34231u16,17789u16),(34233u16,17788u16),(34241u16,17792u16),(34249u16,11564u16),
(34255u16,9461u16),(34256u16,12709u16),(34259u16,17791u16),(34261u16,13041u16),
(34268u16,17793u16),(34276u16,14402u16),(34281u16,10365u16),(34299u16,15934u16),
(34303u16,17794u16),(34309u16,17796u16),(34321u16,12827u16),(34326u16,17798u16),
(34343u16,17795u16),(34345u16,17797u16),(34360u16,16081u16),(34364u16,17799u16),
(34381u16,21579u16),(34382u16,11117u16),(34383u16,12463u16),(34384u16,13031u16),
(34385u16,12484u16),(34388u16,21580u16),(34394u16,15178u16),(34398u16,15736u16),
(34402u16,20264u16),(34411u16,9665u16),(34412u16,21581u16),(34414u16,21582u16),
(34417u16,13978u16),(34425u16,10996u16),(34426u16,21584u16),(34427u16,21586u16),
(34428u16,21585u16),(34429u16,14223u16),(34430u16,14941u16),(34431u16,21583u16),
(34432u16,13985u16),(34433u16,15532u16),(34434u16,12521u16),(34442u16,14760u16),
(34443u16,21589u16),(34444u16,9111u16),(34445u16,21588u16),(34451u16,21595u16),
(34453u16,9452u16),(34460u16,15328u16),(34461u16,21591u16),(34467u16,21593u16),
(34468u16,15938u16),(34471u16,21592u16),(34472u16,21587u16),(34473u16,21596u16),
(34474u16,21594u16),(34476u16,21590u16),(34479u16,21604u16),(34480u16,21601u16),
(34481u16,21603u16),(34484u16,21607u16),(34485u16,21599u16),(34486u16,21597u16),
(34490u16,21602u16),(34496u16,16336u16),(34500u16,21598u16),(34502u16,13484u16),
(34503u16,13838u16),(34505u16,21605u16),(34506u16,10773u16),(34507u16,9991u16),
(34510u16,21600u16),(34511u16,21606u16),(34512u16,21613u16),(34513u16,21619u16),
(34516u16,11170u16),(34520u16,21618u16),(34521u16,14595u16),(34523u16,16320u16),
(34526u16,21615u16),(34527u16,21617u16),(34532u16,10627u16),(34537u16,21608u16),
(34541u16,21611u16),(34542u16,12534u16),(34544u16,16116u16),(34545u16,21609u16),
(34546u16,21610u16),(34547u16,21612u16),(34548u16,21616u16),(34552u16,21622u16),
(34553u16,15703u16),(34558u16,10239u16),(34560u16,14046u16),(34562u16,10423u16),
(34563u16,21620u16),(34567u16,21621u16),(34568u16,21623u16),(34569u16,21626u16),
(34570u16,21624u16),(34573u16,21625u16),(34578u16,15344u16),(34579u16,21614u16),
(34581u16,14576u16),(34583u16,14772u16),(34584u16,16254u16),(34586u16,21632u16),
(34588u16,12694u16),(34590u16,21629u16),(34593u16,12080u16),(34594u16,21641u16),
(34595u16,21627u16),(34597u16,21630u16),(34601u16,21637u16),(34606u16,21631u16),
(34609u16,21636u16),(34612u16,21635u16),(34615u16,21638u16),(34619u16,21628u16),
(34622u16,21633u16),(34623u16,21639u16),(34631u16,15687u16),(34632u16,21634u16),
(34633u16,9490u16),(34636u16,21647u16),(34638u16,15116u16),(34643u16,21650u16),
(34647u16,11155u16),(34649u16,21654u16),(34656u16,21645u16),(34659u16,21651u16),
(34660u16,21653u16),(34661u16,21655u16),(34670u16,21648u16),(34672u16,21646u16),
(34676u16,11016u16),(34678u16,10066u16),(34683u16,21644u16),(34684u16,21652u16),
(34685u16,21642u16),(34686u16,21643u16),(34690u16,21640u16),(34691u16,21761u16),
(34693u16,21758u16),(34696u16,21757u16),(34699u16,21649u16),(34701u16,13643u16),
(34707u16,21656u16),(34711u16,21760u16),(34719u16,12723u16),(34728u16,21658u16),
(34731u16,21762u16),(34732u16,21764u16),(34733u16,21759u16),(34735u16,21657u16),
(34739u16,21766u16),(34741u16,21765u16),(34746u16,12506u16),(34749u16,21769u16),
(34752u16,21771u16),(34758u16,21756u16),(34762u16,21772u16),(34763u16,21767u16),
(34769u16,21770u16),(34770u16,21659u16),(34771u16,21768u16),(34779u16,21773u16),
(34784u16,21775u16),(34789u16,21763u16),(34794u16,21774u16),(34798u16,21776u16),
(34809u16,15128u16),(34814u16,21779u16),(34819u16,16904u16),(34826u16,21780u16),
(34835u16,21778u16),(34837u16,13653u16),(34838u16,21777u16),(34843u16,21781u16),
(34849u16,21782u16),(34850u16,9817u16),(34866u16,20840u16),(34873u16,21783u16),
(34876u16,21784u16),(34880u16,15305u16),(34884u16,21957u16),(34885u16,15143u16),
(34892u16,15153u16),(34893u16,15355u16),(34900u16,14961u16),(34903u16,11549u16),
(34905u16,15330u16),(34913u16,10991u16),(34914u16,18408u16),(34915u16,15519u16),
(34916u16,21409u16),(34917u16,9430u16),(34920u16,9292u16),(34921u16,21410u16),
(34923u16,13807u16),(34924u16,9631u16),(34926u16,16897u16),(34928u16,14160u16),
(34930u16,21411u16),(34935u16,16297u16),(34941u16,21412u16),(34942u16,21977u16),
(34943u16,21413u16),(34945u16,15877u16),(34946u16,21414u16),(34948u16,9057u16),
(34949u16,21978u16),(34952u16,21979u16),(34955u16,9877u16),(34957u16,13074u16),
(34962u16,14372u16),(34966u16,15173u16),(34972u16,14599u16),(34978u16,21415u16),
(34980u16,16898u16),(34987u16,9242u16),(34989u16,14929u16),(34993u16,10549u16),
(34999u16,21417u16),(35004u16,21418u16),(35009u16,9440u16),(35010u16,12304u16),
(35013u16,16451u16),(35014u16,21416u16),(35017u16,21419u16),(35022u16,21421u16),
(35026u16,16901u16),(35028u16,15550u16),(35029u16,15868u16),(35032u16,21980u16),
(35033u16,13610u16),(35039u16,21981u16),(35042u16,21420u16),(35043u16,21422u16),
(35044u16,11942u16),(35045u16,21423u16),(35048u16,21427u16),(35056u16,21429u16),
(35057u16,21424u16),(35059u16,13824u16),(35060u16,13080u16),(35064u16,12512u16),
(35065u16,10827u16),(35068u16,21426u16),(35070u16,21428u16),(35074u16,10786u16),
(35082u16,21434u16),(35088u16,10979u16),(35090u16,9118u16),(35091u16,21432u16),
(35097u16,21431u16),(35098u16,21425u16),(35099u16,21433u16),(35105u16,21430u16),
(35109u16,13661u16),(35114u16,14577u16),(35115u16,21436u16),(35120u16,19124u16),
(35124u16,21435u16),(35126u16,21437u16),(35137u16,21438u16),(35140u16,14984u16),
(35166u16,21982u16),(35167u16,11578u16),(35174u16,21439u16),(35195u16,21440u16),
(35199u16,14812u16),(35201u16,15495u16),(35203u16,21466u16),(35206u16,10563u16),
(35265u16,11396u16),(35266u16,10794u16),(35268u16,10805u16),(35269u16,12692u16),
(35270u16,14016u16),(35271u16,20117u16),(35272u16,12097u16),(35273u16,11770u16),
(35274u16,20118u16),(35275u16,20119u16),(35276u16,20120u16),(35278u16,20121u16),
(35279u16,20122u16),(35280u16,20123u16),(35281u16,20124u16),(35282u16,11534u16),
(35286u16,22226u16),(35290u16,22228u16),(35292u16,22229u16),(35294u16,22227u16),
(35299u16,11561u16),(35301u16,22326u16),(35302u16,9790u16),(35307u16,22327u16),
(35311u16,22328u16),(35315u16,20443u16),(35328u16,15347u16),(35335u16,16889u16),
(35390u16,22329u16),(35400u16,20831u16),(35449u16,16073u16),(35465u16,15769u16),
(35466u16,14405u16),(35475u16,14001u16),(35591u16,19127u16),(35622u16,22330u16),
(35686u16,11700u16),(35692u16,13214u16),(35744u16,17010u16),(35745u16,11343u16),
(35746u16,10174u16),(35747u16,10573u16),(35748u16,13632u16),(35749u16,11310u16),
(35750u16,17011u16),(35751u16,17012u16),(35752u16,14399u16),(35753u16,13620u16),
(35754u16,17013u16),(35755u16,13298u16),(35757u16,15316u16),(35758u16,15558u16),
(35759u16,15317u16),(35760u16,11344u16),(35762u16,11513u16),(35763u16,11183u16),
(35764u16,17014u16),(35765u16,17015u16),(35766u16,15335u16),(35767u16,17016u16),
(35768u16,15182u16),(35769u16,10244u16),(35770u16,12504u16),(35772u16,14202u16),
(35773u16,10432u16),(35774u16,13847u16),(35775u16,10390u16),(35776u16,11772u16),
(35777u16,16249u16),(35778u16,17017u16),(35779u16,17018u16),(35780u16,13237u16),
(35781u16,16506u16),(35782u16,13987u16),(35784u16,16064u16),(35785u16,14218u16),
(35786u16,16134u16),(35787u16,17019u16),(35788u16,16308u16),(35789u16,9827u16),
(35790u16,17021u16),(35791u16,17020u16),(35793u16,15560u16),(35794u16,17022u16),
(35795u16,17023u16),(35796u16,17024u16),(35797u16,14017u16),(35798u16,17025u16),
(35799u16,13976u16),(35800u16,17026u16),(35801u16,17027u16),(35802u16,9642u16),
(35803u16,16324u16),(35804u16,17028u16),(35805u16,11131u16),(35806u16,9989u16),
(35807u16,17029u16),(35808u16,17030u16),(35809u16,10813u16),(35810u16,15310u16),
(35811u16,15557u16),(35812u16,17031u16),(35813u16,10580u16),(35814u16,14989u16),
(35815u16,9484u16),(35816u16,17032u16),(35817u16,17033u16),(35819u16,11570u16),
(35820u16,14785u16),(35821u16,15754u16),(35822u16,17034u16),(35823u16,14808u16),
(35824u16,17035u16),(35825u16,15728u16),(35826u16,11184u16),(35827u16,17036u16),
(35828u16,14176u16),(35829u16,14203u16),(35830u16,17037u16),(35831u16,13470u16),
(35832u16,16323u16),(35833u16,17038u16),(35834u16,13036u16),(35835u16,10198u16),
(35836u16,17039u16),(35837u16,10399u16),(35838u16,11921u16),(35839u16,17040u16),
(35840u16,17041u16),(35841u16,14168u16),(35842u16,17042u16),(35843u16,10062u16),
(35844u16,17043u16),(35845u16,12289u16),(35846u16,16462u16),(35847u16,17044u16),
(35848u16,14369u16),(35850u16,15559u16),(35851u16,12842u16),(35852u16,17045u16),
(35853u16,10068u16),(35854u16,11164u16),(35855u16,17046u16),(35856u16,15124u16),
(35857u16,17047u16),(35858u16,17048u16),(35859u16,14754u16),(35860u16,17049u16),
(35861u16,17050u16),(35862u16,17051u16),(35863u16,9492u16),(35864u16,17054u16),
(35865u16,17052u16),(35866u16,15367u16),(35867u16,17053u16),(35868u16,12688u16),
(35869u16,17055u16),(35871u16,17056u16),(35872u16,17057u16),(35873u16,17058u16),
(35874u16,15132u16),(35875u16,15490u16),(35876u16,9114u16),(35877u16,17059u16),
(35878u16,13406u16),(35879u16,17060u16),(35880u16,11582u16),(35881u16,12636u16),
(35882u16,17061u16),(35883u16,17062u16),(35884u16,12728u16),(35885u16,14368u16),
(35886u16,17063u16),(35887u16,17064u16),(35888u16,12095u16),(35889u16,13260u16),
(35890u16,17065u16),(35891u16,17066u16),(35892u16,13415u16),(35893u16,17067u16),
(35894u16,17068u16),(35895u16,10775u16),(35905u16,11192u16),(35910u16,10190u16),
(35911u16,22033u16),(35913u16,22034u16),(35916u16,14602u16),(35925u16,22160u16),
(35930u16,20299u16),(35937u16,14998u16),(35938u16,11146u16),(35946u16,10957u16),
(35947u16,15870u16),(35955u16,18392u16),(35960u16,22219u16),(35961u16,9225u16),
(35962u16,9487u16),(35970u16,22220u16),(35973u16,22222u16),(35977u16,10974u16),
(35978u16,22221u16),(35980u16,12653u16),(35988u16,22224u16),(35992u16,22223u16),
(36125u16,9235u16),(36126u16,16129u16),(36127u16,10571u16),(36129u16,10752u16),
(36130u16,9443u16),(36131u16,15945u16),(36132u16,14960u16),(36133u16,9085u16),
(36134u16,16098u16),(36135u16,11200u16),(36136u16,16287u16),(36137u16,10378u16),
(36138u16,14361u16),(36139u16,13227u16),(36140u16,9280u16),(36141u16,10761u16),
(36142u16,16337u16),(36143u16,10800u16),(36144u16,10356u16),(36145u16,11395u16),
(36146u16,20103u16),(36147u16,20104u16),(36148u16,14434u16),(36149u16,10818u16),
(36150u16,20105u16),(36151u16,9876u16),(36152u16,12654u16),(36153u16,10404u16),
(36154u16,10981u16),(36155u16,20106u16),(36156u16,15949u16),(36157u16,20107u16),
(36158u16,11359u16),(36159u16,11178u16),(36160u16,20108u16),(36161u16,12317u16),
(36162u16,12469u16),(36163u16,15928u16),(36164u16,16477u16),(36165u16,20109u16),
(36166u16,20110u16),(36167u16,20113u16),(36168u16,20111u16),(36169u16,20112u16),
(36170u16,13837u16),(36171u16,10564u16),(36172u16,10201u16),(36173u16,20114u16),
(36174u16,14039u16),(36175u16,13820u16),(36176u16,9830u16),(36179u16,18582u16),
(36180u16,13081u16),(36181u16,20115u16),(36182u16,12086u16),(36184u16,16459u16),
(36185u16,20116u16),(36186u16,16447u16),(36187u16,13677u16),(36188u16,16676u16),
(36189u16,16670u16),(36190u16,15927u16),(36192u16,15954u16),(36193u16,13811u16),
(36194u16,15689u16),(36195u16,10596u16),(36196u16,9659u16),(36198u16,13841u16),
(36199u16,22031u16),(36203u16,10978u16),(36205u16,22032u16),(36208u16,16498u16),
(36211u16,22026u16),(36212u16,10561u16),(36213u16,16107u16),(36214u16,10592u16),
(36215u16,13285u16),(36225u16,9630u16),(36228u16,22027u16),(36229u16,9607u16),
(36234u16,15894u16),(36235u16,13482u16),(36241u16,22029u16),(36244u16,22028u16),
(36255u16,14388u16),(36259u16,13589u16),(36273u16,22030u16),(36275u16,16502u16),
(36276u16,13046u16),(36277u16,22167u16),(36280u16,22162u16),(36282u16,22170u16),
(36284u16,22169u16),(36286u16,16271u16),(36287u16,22168u16),(36291u16,15895u16),
(36292u16,22171u16),(36294u16,22179u16),(36299u16,9072u16),(36300u16,10063u16),
(36302u16,22176u16),(36303u16,22177u16),(36305u16,13075u16),(36310u16,22172u16),
(36311u16,22173u16),(36314u16,22174u16),(36315u16,22178u16),(36317u16,11749u16),
(36318u16,22175u16),(36319u16,10635u16),(36323u16,22183u16),(36324u16,22186u16),
(36328u16,11946u16),(36330u16,10817u16),(36331u16,22163u16),(36332u16,22180u16),
(36335u16,12468u16),(36339u16,14433u16),(36341u16,11394u16),(36343u16,22181u16),
(36344u16,22182u16),(36345u16,22184u16),(36346u16,10234u16),(36347u16,22185u16),
(36349u16,22188u16),(36357u16,22164u16),(36361u16,22187u16),(36362u16,15702u16),
(36364u16,9671u16),(36367u16,14349u16),(36372u16,22189u16),(36381u16,22190u16),
(36382u16,11750u16),(36383u16,22191u16),(36386u16,14408u16),(36387u16,22194u16),
(36393u16,9445u16),(36394u16,16492u16),(36396u16,22192u16),(36398u16,22193u16),
(36399u16,22195u16),(36401u16,22201u16),(36405u16,22199u16),(36409u16,22198u16),
(36410u16,22196u16),(36413u16,22200u16),(36416u16,22197u16),(36417u16,22203u16),
(36418u16,22204u16),(36420u16,14412u16),(36423u16,19126u16),(36424u16,9999u16),
(36425u16,22202u16),(36426u16,22207u16),(36427u16,14348u16),(36433u16,22205u16),
(36434u16,22206u16),(36441u16,22165u16),(36454u16,9251u16),(36457u16,22166u16),
(36460u16,10012u16),(36461u16,9473u16),(36463u16,22211u16),(36464u16,22208u16),
(36466u16,10220u16),(36468u16,22212u16),(36470u16,22209u16),(36476u16,22210u16),
(36479u16,9843u16),(36481u16,15939u16),(36485u16,22213u16),(36487u16,9684u16),
(36495u16,22214u16),(36496u16,22216u16),(36500u16,22215u16),(36508u16,22217u16),
(36510u16,22218u16),(36523u16,13852u16),(36524u16,10745u16),(36527u16,13486u16),
(36530u16,10232u16),(36538u16,14386u16),(36558u16,20051u16),(36710u16,9616u16),
(36711u16,15959u16),(36712u16,10811u16),(36713u16,15194u16),(36715u16,19932u16),
(36716u16,16445u16),(36717u16,19933u16),(36718u16,12499u16),(36719u16,13662u16),
(36720u16,10993u16),(36721u16,19934u16),(36722u16,19935u16),(36723u16,19936u16),
(36724u16,16310u16),(36725u16,19937u16),(36726u16,19938u16),(36727u16,19940u16),
(36728u16,19939u16),(36729u16,19941u16),(36730u16,19942u16),(36731u16,13460u16),
(36732u16,19943u16),(36733u16,15921u16),(36734u16,19944u16),(36735u16,11541u16),
(36737u16,19945u16),(36738u16,19946u16),(36739u16,11542u16),(36740u16,19947u16),
(36741u16,10553u16),(36742u16,12285u16),(36743u16,19948u16),(36744u16,9233u16),
(36745u16,11167u16),(36746u16,10820u16),(36747u16,19949u16),(36749u16,20046u16),
(36750u16,20047u16),(36751u16,20048u16),(36752u16,10443u16),(36753u16,11318u16),
(36755u16,14033u16),(36756u16,18191u16),(36757u16,15880u16),(36758u16,14944u16),
(36759u16,16078u16),(36760u16,20049u16),(36761u16,16117u16),(36762u16,20050u16),
(36763u16,15138u16),(36764u16,10763u16),(36766u16,9824u16),(36767u16,9272u16),
(36771u16,12082u16),(36776u16,9285u16),(36777u16,9286u16),(36779u16,9287u16),
(36784u16,9624u16),(36785u16,13657u16),(36790u16,19128u16),(36793u16,9278u16),
(36797u16,12296u16),(36798u16,9864u16),(36801u16,13403u16),(36802u16,15731u16),
(36804u16,13294u16),(36805u16,15319u16),(36807u16,10828u16),(36808u16,12530u16),
(36814u16,15688u16),(36816u16,15908u16),(36817u16,11587u16),(36819u16,19129u16),
(36820u16,10376u16),(36821u16,19130u16),(36824u16,11140u16),(36825u16,16121u16),
(36827u16,11583u16),(36828u16,15887u16),(36829u16,14730u16),(36830u16,12267u16),
(36831u16,9652u16),(36834u16,14431u16),(36836u16,19133u16),(36837u16,19131u16),
(36838u16,19135u16),(36840u16,19137u16),(36841u16,19134u16),(36842u16,10022u16),
(36843u16,13245u16),(36845u16,10067u16),(36846u16,19132u16),(36848u16,14051u16),
(36851u16,19136u16),(36855u16,12687u16),(36856u16,9252u16),(36857u16,11308u16),
(36861u16,16458u16),(36864u16,14578u16),(36865u16,14200u16),(36866u16,14007u16),
(36867u16,14396u16),(36868u16,19139u16),(36869u16,19138u16),(36870u16,12895u16),
(36873u16,15296u16),(36874u16,15318u16),(36875u16,19140u16),(36877u16,19143u16),
(36879u16,14559u16),(36880u16,16325u16),(36881u16,19142u16),(36882u16,10036u16),
(36884u16,14565u16),(36886u16,19144u16),(36887u16,10191u16),(36890u16,14543u16),
(36891u16,10803u16),(36893u16,14002u16),(36894u16,9644u16),(36895u16,14212u16),
(36896u16,15941u16),(36897u16,19145u16),(36898u16,10429u16),(36902u16,19141u16),
(36909u16,19148u16),(36910u16,9879u16),(36911u16,19149u16),(36917u16,19146u16),
(36918u16,19147u16),(36920u16,15546u16),(36923u16,12508u16),(36924u16,9253u16),
(36926u16,15741u16),(36929u16,10226u16),(36930u16,14231u16),(36932u16,19150u16),
(36935u16,15761u16),(36941u16,9288u16),(36943u16,10249u16),(36944u16,19153u16),
(36945u16,19151u16),(36946u16,19152u16),(36947u16,10007u16),(36951u16,15522u16),
(36952u16,19155u16),(36955u16,19157u16),(36962u16,19156u16),(36963u16,13413u16),
(36965u16,15488u16),(36968u16,19154u16),(36973u16,15931u16),(36974u16,16113u16),
(36980u16,19159u16),(36981u16,16516u16),(36989u16,19160u16),(36991u16,9275u16),
(36992u16,15386u16),(36994u16,19161u16),(36995u16,19163u16),(37000u16,19162u16),
(37003u16,19164u16),(37009u16,15541u16),(37011u16,10018u16),(37013u16,19538u16),
(37015u16,17090u16),(37017u16,17093u16),(37019u16,17091u16),(37021u16,17092u16),
(37025u16,17095u16),(37026u16,15152u16),(37027u16,12864u16),(37030u16,9103u16),
(37034u16,15121u16),(37036u16,17094u16),(37038u16,15717u16),(37039u16,10935u16),
(37040u16,17197u16),(37041u16,13476u16),(37043u16,17097u16),(37044u16,17096u16),
(37045u16,13834u16),(37046u16,17098u16),(37048u16,17196u16),(37049u16,16497u16),
(37050u16,17099u16),(37051u16,12313u16),(37054u16,17200u16),(37057u16,15759u16),
(37060u16,17202u16),(37061u16,17199u16),(37063u16,17203u16),(37066u16,11523u16),
(37070u16,12106u16),(37071u16,17198u16),(37072u16,17201u16),(37073u16,16248u16),
(37075u16,17204u16),(37079u16,17208u16),(37083u16,17209u16),(37084u16,17207u16),
(37085u16,10959u16),(37089u16,11879u16),(37090u16,17206u16),(37094u16,17205u16),
(37095u16,15904u16),(37096u16,9436u16),(37099u16,17210u16),(37101u16,10824u16),
(37103u16,17211u16),(37108u16,9622u16),(37112u16,9981u16),(37117u16,10193u16),
(37118u16,17212u16),(37122u16,10250u16),(37124u16,17213u16),(37145u16,9256u16),
(37150u16,17215u16),(37154u16,17214u16),(37155u16,17216u16),(37167u16,17218u16),
(37169u16,17217u16),(37177u16,17219u16),(37187u16,17220u16),(37190u16,17221u16),
(37193u16,15722u16),(37194u16,22035u16),(37195u16,13480u16),(37196u16,16470u16),
(37197u16,13083u16),(37198u16,22037u16),(37199u16,22038u16),(37200u16,22036u16),
(37202u16,11723u16),(37207u16,15184u16),(37210u16,10406u16),(37213u16,15910u16),
(37214u16,14355u16),(37217u16,22137u16),(37218u16,22136u16),(37219u16,10933u16),
(37220u16,22039u16),(37221u16,14209u16),(37225u16,22139u16),(37226u16,12115u16),
(37228u16,9669u16),(37230u16,14545u16),(37231u16,22140u16),(37232u16,22138u16),
(37233u16,11515u16),(37234u16,22143u16),(37236u16,22144u16),(37237u16,11540u16),
(37238u16,12659u16),(37239u16,11940u16),(37240u16,14220u16),(37241u16,22145u16),
(37245u16,22141u16),(37246u16,22142u16),(37247u16,12905u16),(37253u16,22147u16),
(37255u16,9813u16),(37257u16,16512u16),(37259u16,9840u16),(37260u16,22146u16),
(37261u16,22149u16),(37264u16,22148u16),(37265u16,22150u16),(37266u16,15154u16),
(37274u16,12684u16),(37275u16,13594u16),(37282u16,22151u16),(37283u16,22152u16),
(37290u16,22153u16),(37293u16,22154u16),(37294u16,22155u16),(37295u16,22156u16),
(37300u16,22158u16),(37301u16,22157u16),(37306u16,22159u16),(37319u16,9446u16),
(37321u16,15727u16),(37322u16,14010u16),(37324u16,12144u16),(37325u16,16301u16),
(37326u16,15501u16),(37327u16,12286u16),(37329u16,11575u16),(37340u16,10555u16),
(37492u16,11393u16),(37518u16,22363u16),(37550u16,22364u16),(37576u16,22365u16),
(37694u16,22366u16),(37738u16,22367u16),(37775u16,22369u16),(37834u16,22368u16),
(37846u16,22588u16),(37950u16,22370u16),(37995u16,22371u16),(38021u16,20841u16),
(38022u16,20842u16),(38023u16,20843u16),(38024u16,16130u16),(38025u16,10169u16),
(38026u16,20845u16),(38027u16,20844u16),(38028u16,20846u16),(38029u16,20847u16),
(38030u16,13400u16),(38031u16,20848u16),(38032u16,20849u16),(38034u16,10371u16),
(38035u16,10061u16),(38036u16,20850u16),(38037u16,20852u16),(38039u16,20851u16),
(38041u16,10583u16),(38042u16,20853u16),(38043u16,20854u16),(38044u16,20855u16),
(38045u16,10224u16),(38046u16,9609u16),(38047u16,16296u16),(38048u16,12863u16),
(38049u16,9236u16),(38050u16,10599u16),(38051u16,20856u16),(38052u16,20857u16),
(38053u16,15896u16),(38054u16,13448u16),(38055u16,11776u16),(38056u16,14782u16),
(38057u16,10754u16),(38058u16,20859u16),(38059u16,20858u16),(38060u16,20861u16),
(38061u16,20860u16),(38062u16,13020u16),(38063u16,20862u16),(38064u16,20863u16),
(38065u16,13409u16),(38066u16,20864u16),(38067u16,13410u16),(38068u16,20865u16),
(38069u16,9412u16),(38070u16,20866u16),(38071u16,20867u16),(38072u16,20868u16),
(38073u16,20869u16),(38074u16,20870u16),(38075u16,16509u16),(38076u16,20871u16),
(38077u16,20872u16),(38078u16,11361u16),(38079u16,20873u16),(38080u16,15718u16),
(38081u16,14435u16),(38082u16,9417u16),(38083u16,12324u16),(38084u16,20874u16),
(38085u16,13401u16),(38086u16,12648u16),(38088u16,20875u16),(38089u16,20876u16),
(38090u16,20877u16),(38091u16,20878u16),(38092u16,20879u16),(38093u16,20880u16),
(38094u16,20881u16),(38096u16,20882u16),(38097u16,20883u16),(38098u16,20884u16),
(38101u16,20885u16),(38102u16,20886u16),(38103u16,20887u16),(38104u16,20889u16),
(38105u16,20888u16),(38107u16,20890u16),(38108u16,14548u16),(38109u16,12478u16),
(38110u16,20891u16),(38111u16,20892u16),(38112u16,20893u16),(38113u16,16056u16),
(38114u16,20894u16),(38115u16,14934u16),(38116u16,20895u16),(38117u16,20896u16),
(38119u16,20897u16),(38120u16,20898u16),(38121u16,20996u16),(38122u16,20899u16),
(38123u16,20997u16),(38124u16,10630u16),(38125u16,12725u16),(38126u16,20998u16),
(38127u16,20999u16),(38128u16,11529u16),(38129u16,15516u16),(38130u16,9494u16),
(38131u16,21000u16),(38132u16,21001u16),(38133u16,21002u16),(38134u16,15573u16),
(38135u16,21003u16),(38136u16,16338u16),(38137u16,21004u16),(38138u16,13249u16),
(38140u16,21005u16),(38141u16,21006u16),(38142u16,12275u16),(38143u16,21007u16),
(38144u16,15005u16),(38145u16,14243u16),(38146u16,21009u16),(38147u16,21008u16),
(38148u16,9685u16),(38149u16,10823u16),(38150u16,21010u16),(38151u16,21011u16),
(38152u16,15171u16),(38153u16,21012u16),(38154u16,21013u16),(38155u16,10425u16),
(38156u16,15136u16),(38157u16,21014u16),(38158u16,21015u16),(38159u16,21016u16),
(38160u16,13666u16),(38161u16,14409u16),(38162u16,21017u16),(38163u16,21018u16),
(38164u16,21019u16),(38165u16,21020u16),(38166u16,21021u16),(38167u16,16119u16),
(38168u16,21022u16),(38169u16,9862u16),(38170u16,12645u16),(38171u16,21023u16),
(38173u16,21024u16),(38174u16,21025u16),(38175u16,21026u16),(38177u16,14818u16),
(38178u16,21027u16),(38179u16,12509u16),(38180u16,9809u16),(38181u16,16457u16),
(38182u16,11580u16),(38184u16,14954u16),(38185u16,21030u16),(38186u16,21028u16),
(38187u16,21029u16),(38188u16,21031u16),(38189u16,10172u16),(38190u16,11397u16),
(38191u16,11751u16),(38192u16,12679u16),(38193u16,21032u16),(38194u16,21033u16),
(38196u16,21034u16),(38197u16,21042u16),(38198u16,21035u16),(38199u16,21036u16),
(38200u16,21037u16),(38201u16,13429u16),(38202u16,21076u16),(38203u16,10210u16),
(38204u16,21038u16),(38206u16,21039u16),(38207u16,21040u16),(38208u16,10203u16),
(38209u16,12665u16),(38210u16,21041u16),(38212u16,21043u16),(38213u16,21044u16),
(38214u16,21045u16),(38215u16,16137u16),(38217u16,21046u16),(38218u16,12912u16),
(38220u16,21047u16),(38221u16,12913u16),(38222u16,21048u16),(38223u16,21049u16),
(38224u16,10613u16),(38225u16,9112u16),(38226u16,21050u16),(38227u16,21051u16),
(38228u16,21052u16),(38230u16,21053u16),(38231u16,21054u16),(38232u16,21055u16),
(38233u16,21056u16),(38235u16,21057u16),(38236u16,11706u16),(38237u16,21060u16),
(38238u16,21058u16),(38239u16,21059u16),(38241u16,21061u16),(38242u16,21062u16),
(38243u16,12300u16),(38244u16,21063u16),(38245u16,21064u16),(38246u16,21065u16),
(38247u16,21066u16),(38248u16,21067u16),(38249u16,21068u16),(38250u16,21069u16),
(38251u16,21070u16),(38252u16,21071u16),(38253u16,12121u16),(38255u16,21072u16),
(38256u16,12268u16),(38257u16,21073u16),(38258u16,21074u16),(38259u16,21075u16),
(38262u16,14981u16),(38271u16,9599u16),(38376u16,12672u16),(38377u16,18752u16),
(38378u16,13808u16),(38379u16,18753u16),(38381u16,9268u16),(38382u16,14767u16),
(38383u16,9804u16),(38384u16,13667u16),(38385u16,18754u16),(38386u16,14963u16),
(38387u16,18755u16),(38388u16,11373u16),(38389u16,18756u16),(38390u16,18757u16),
(38391u16,12673u16),(38392u16,16057u16),(38393u16,12879u16),(38394u16,10810u16),
(38395u16,14762u16),(38396u16,18758u16),(38397u16,12721u16),(38398u16,18759u16),
(38400u16,10362u16),(38401u16,10628u16),(38402u16,10975u16),(38403u16,18760u16),
(38404u16,18761u16),(38405u16,15901u16),(38406u16,18762u16),(38408u16,18763u16),
(38409u16,15338u16),(38410u16,18764u16),(38411u16,18765u16),(38412u16,18766u16),
(38413u16,18767u16),(38414u16,15349u16),(38415u16,18768u16),(38416u16,9496u16),
(38417u16,12092u16),(38418u16,18769u16),(38420u16,12076u16),(38421u16,18770u16),
(38422u16,18771u16),(38423u16,18772u16),(38425u16,18773u16),(38426u16,18774u16),
(38428u16,10568u16),(38429u16,17071u16),(38431u16,10216u16),(38433u16,17073u16),
(38434u16,17072u16),(38442u16,17075u16),(38446u16,13663u16),(38449u16,17074u16),
(38450u16,10387u16),(38451u16,15379u16),(38452u16,15570u16),(38453u16,16138u16),
(38454u16,11550u16),(38459u16,16507u16),(38460u16,17077u16),(38461u16,17076u16),
(38463u16,9027u16),(38464u16,14586u16),(38466u16,17078u16),(38468u16,10574u16),
(38469u16,11347u16),(38470u16,12474u16),(38471u16,12449u16),(38472u16,9629u16),
(38473u16,17079u16),(38475u16,12455u16),(38476u16,12841u16),(38477u16,11516u16),
(38480u16,14977u16),(38484u16,17080u16),(38485u16,13809u16),(38491u16,9276u16),
(38495u16,17081u16),(38497u16,10189u16),(38498u16,15891u16),(38500u16,9688u16),
(38503u16,17082u16),(38504u16,15906u16),(38505u16,14968u16),(38506u16,13082u16),
(38508u16,17083u16),(38514u16,17084u16),(38516u16,17085u16),(38517u16,12329u16),
(38518u16,14398u16),(38519u16,14976u16),(38533u16,15746u16),(38534u16,12446u16),
(38536u16,17086u16),(38539u16,14224u16),(38541u16,17087u16),(38543u16,14225u16),
(38544u16,15579u16),(38548u16,10629u16),(38551u16,17088u16),(38552u16,9040u16),
(38553u16,14937u16),(38556u16,16102u16),(38567u16,14232u16),(38576u16,17089u16),
(38579u16,18751u16),(38582u16,12260u16),(38585u16,22356u16),(38588u16,22357u16),
(38589u16,22358u16),(38590u16,12874u16),(38592u16,13609u16),(38593u16,15362u16),
(38596u16,15164u16),(38597u16,15332u16),(38598u16,11320u16),(38599u16,10780u16),
(38601u16,21079u16),(38604u16,9823u16),(38605u16,15701u16),(38606u16,22359u16),
(38607u16,9686u16),(38610u16,22360u16),(38613u16,10056u16),(38624u16,22362u16),
(38632u16,15749u16),(38633u16,22332u16),(38634u16,15304u16),(38639u16,22334u16),
(38643u16,22333u16),(38646u16,12322u16),(38647u16,12120u16),(38649u16,9217u16),
(38654u16,14802u16),(38656u16,15177u16),(38657u16,22336u16),(38660u16,15001u16),
(38662u16,22335u16),(38663u16,16135u16),(38664u16,22337u16),(38665u16,12660u16),
(38669u16,11199u16),(38670u16,22339u16),(38671u16,22338u16),(38675u16,12887u16),
(38678u16,12311u16),(38684u16,14165u16),(38686u16,14943u16),(38698u16,22340u16),
(38701u16,22341u16),(38704u16,22342u16),(38706u16,12467u16),(38712u16,9077u16),
(38713u16,13104u16),(38718u16,22343u16),(38738u16,13459u16),(38739u16,22331u16),
(38742u16,11709u16),(38745u16,11703u16),(38747u16,10044u16),(38750u16,10394u16),
(38752u16,11906u16),(38753u16,12685u16),(38754u16,12705u16),(38757u16,16669u16),
(38761u16,10624u16),(38771u16,11584u16),(38772u16,15300u16),(38774u16,9073u16),
(38780u16,22531u16),(38789u16,22532u16),(38795u16,15117u16),(38797u16,9041u16),
(38801u16,22533u16),(38802u16,22534u16),(38804u16,22535u16),(38808u16,13437u16),
(38816u16,11732u16),(38819u16,22538u16),(38827u16,22537u16),(38829u16,9277u16),
(38831u16,22536u16),(38834u16,22539u16),(38836u16,22540u16),(38886u16,14729u16),
(38887u16,13630u16),(38889u16,10936u16),(38890u16,19689u16),(38891u16,19690u16),
(38892u16,19691u16),(38893u16,11719u16),(38899u16,15569u16),(38901u16,15912u16),
(38902u16,13831u16),(39029u16,15504u16),(39030u16,10170u16),(39031u16,13469u16),
(39032u16,21467u16),(39033u16,14993u16),(39034u16,14174u16),(39035u16,15180u16),
(39036u16,19554u16),(39037u16,14606u16),(39038u16,10778u16),(39039u16,10222u16),
(39040u16,21468u16),(39041u16,9093u16),(39042u16,14199u16),(39043u16,21469u16),
(39044u16,15869u16),(39045u16,12458u16),(39046u16,12331u16),(39047u16,13241u16),
(39048u16,11702u16),(39049u16,21566u16),(39050u16,11358u16),(39052u16,21567u16),
(39053u16,21568u16),(39055u16,21569u16),(39056u16,15520u16),(39057u16,13226u16),
(39059u16,14574u16),(39060u16,21570u16),(39062u16,15692u16),(39063u16,11912u16),
(39064u16,14411u16),(39066u16,21571u16),(39067u16,21572u16),(39068u16,15348u16),
(39069u16,10243u16),(39070u16,21573u16),(39071u16,21574u16),(39072u16,10038u16),
(39073u16,21575u16),(39074u16,21576u16),(39076u16,9497u16),(39077u16,21577u16),
(39078u16,21578u16),(39079u16,13592u16),(39118u16,10426u16),(39121u16,20434u16),
(39122u16,20435u16),(39123u16,20436u16),(39125u16,20437u16),(39128u16,13219u16),
(39129u16,20438u16),(39130u16,20439u16),(39134u16,10396u16),(39135u16,13984u16),
(39143u16,18549u16),(39144u16,22562u16),(39181u16,22563u16),(39184u16,9450u16),
(39214u16,22564u16),(39252u16,22566u16),(39253u16,22565u16),(39267u16,18552u16),
(39269u16,11307u16),(39271u16,18553u16),(39272u16,18554u16),(39273u16,18555u16),
(39274u16,18556u16),(39275u16,18557u16),(39276u16,18558u16),(39277u16,10380u16),
(39278u16,15576u16),(39279u16,11499u16),(39280u16,14011u16),(39281u16,9220u16),
(39282u16,14194u16),(39284u16,18559u16),(39285u16,10257u16),(39286u16,13621u16),
(39287u16,18560u16),(39290u16,11535u16),(39292u16,9308u16),(39293u16,18561u16),
(39295u16,10251u16),(39296u16,18562u16),(39297u16,12882u16),(39300u16,18563u16),
(39301u16,14973u16),(39302u16,10796u16),(39303u16,18564u16),(39304u16,12066u16),
(39306u16,18565u16),(39307u16,9491u16),(39309u16,18566u16),(39311u16,12338u16),
(39312u16,18567u16),(39313u16,18568u16),(39314u16,12533u16),(39315u16,18569u16),
(39316u16,18570u16),(39317u16,18571u16),(39318u16,14020u16),(39319u16,16649u16),
(39320u16,16884u16),(39321u16,14982u16),(39333u16,21190u16),(39336u16,17401u16),
(39532u16,12522u16),(39533u16,15871u16),(39534u16,14587u16),(39535u16,15312u16),
(39536u16,9654u16),(39537u16,13488u16),(39539u16,9426u16),(39540u16,12476u16),
(39541u16,19349u16),(39542u16,13992u16),(39543u16,19350u16),(39544u16,19351u16),
(39545u16,11737u16),(39546u16,19352u16),(39547u16,16439u16),(39548u16,14588u16),
(39549u16,19354u16),(39550u16,11366u16),(39551u16,19353u16),(39552u16,19355u16),
(39553u16,19356u16),(39554u16,12523u16),(39556u16,11525u16),(39557u16,19357u16),
(39558u16,12515u16),(39559u16,10932u16),(39560u16,19358u16),(39562u16,19359u16),
(39563u16,9645u16),(39564u16,15368u16),(39567u16,11880u16),(39568u16,19360u16),
(39569u16,13284u16),(39570u16,19361u16),(39571u16,19362u16),(39574u16,19363u16),
(39575u16,13218u16),(39576u16,19364u16),(39578u16,13782u16),(39579u16,19365u16),
(39580u16,19366u16),(39581u16,19367u16),(39582u16,19120u16),(39583u16,19368u16),
(39584u16,19369u16),(39585u16,12511u16),(39586u16,19370u16),(39587u16,19371u16),
(39588u16,16317u16),(39589u16,19372u16),(39591u16,19373u16),(39592u16,10774u16),
(39600u16,22542u16),(39601u16,22541u16),(39606u16,22545u16),(39607u16,22543u16),
(39608u16,10926u16),(39610u16,22546u16),(39612u16,22547u16),(39616u16,22549u16),
(39617u16,22548u16),(39618u16,22551u16),(39621u16,22550u16),(39627u16,22552u16),
(39628u16,22553u16),(39633u16,22554u16),(39635u16,14227u16),(39640u16,10608u16),
(39647u16,22567u16),(39649u16,22568u16),(39654u16,22569u16),(39659u16,22571u16),
(39661u16,22573u16),(39663u16,22570u16),(39673u16,22574u16),(39675u16,22572u16),
(39683u16,16490u16),(39688u16,22575u16),(39695u16,22576u16),(39699u16,22577u16),
(39711u16,22578u16),(39715u16,22579u16),(39727u16,17238u16),(39730u16,16635u16),
(39739u16,19182u16),(39740u16,10812u16),(39745u16,11968u16),(39746u16,11189u16),
(39747u16,22556u16),(39748u16,13244u16),(39749u16,22555u16),(39751u16,22557u16),
(39752u16,22559u16),(39753u16,22558u16),(39757u16,22560u16),(39759u16,14751u16),
(39761u16,22561u16),(39764u16,12832u16),(40060u16,15742u16),(40063u16,22372u16),
(40065u16,12464u16),(40066u16,22373u16),(40069u16,22374u16),(40070u16,22375u16),
(40071u16,22376u16),(40072u16,22377u16),(40075u16,22379u16),(40077u16,9226u16),
(40078u16,22380u16),(40080u16,22381u16),(40081u16,22382u16),(40082u16,22383u16),
(40084u16,22384u16),(40085u16,22385u16),(40090u16,22386u16),(40091u16,22387u16),
(40092u16,14957u16),(40094u16,22388u16),(40095u16,22389u16),(40096u16,22390u16),
(40097u16,22391u16),(40098u16,22392u16),(40099u16,22393u16),(40100u16,12145u16),
(40101u16,22394u16),(40102u16,22395u16),(40103u16,22396u16),(40104u16,22397u16),
(40105u16,22398u16),(40107u16,22399u16),(40109u16,22400u16),(40110u16,22401u16),
(40112u16,22402u16),(40113u16,22403u16),(40114u16,22404u16),(40115u16,22405u16),
(40116u16,22406u16),(40117u16,22407u16),(40118u16,22408u16),(40119u16,22409u16),
(40120u16,11693u16),(40122u16,22410u16),(40123u16,22411u16),(40124u16,22412u16),
(40125u16,22413u16),(40131u16,13675u16),(40132u16,22414u16),(40133u16,22415u16),
(40134u16,22416u16),(40135u16,22417u16),(40138u16,22418u16),(40139u16,22419u16),
(40140u16,22516u16),(40141u16,22517u16),(40142u16,22518u16),(40143u16,22519u16),
(40144u16,22520u16),(40147u16,22521u16),(40148u16,22522u16),(40149u16,22523u16),
(40150u16,9293u16),(40151u16,22524u16),(40152u16,22525u16),(40153u16,22526u16),
(40156u16,22527u16),(40157u16,22528u16),(40158u16,12314u16),(40159u16,22529u16),
(40162u16,22530u16),(40479u16,12906u16),(40480u16,21200u16),(40481u16,11311u16),
(40482u16,21201u16),(40483u16,12724u16),(40485u16,13039u16),(40486u16,15322u16),
(40488u16,21202u16),(40489u16,21203u16),(40490u16,21204u16),(40491u16,21205u16),
(40492u16,21206u16),(40493u16,15323u16),(40495u16,15371u16),(40497u16,21208u16),
(40498u16,21207u16),(40499u16,15872u16),(40501u16,14585u16),(40502u16,21209u16),
(40503u16,21211u16),(40504u16,21210u16),(40505u16,21212u16),(40506u16,21213u16),
(40509u16,10620u16),(40510u16,21214u16),(40511u16,10997u16),(40513u16,21215u16),
(40514u16,21216u16),(40515u16,11758u16),(40516u16,21217u16),(40517u16,10241u16),
(40518u16,21218u16),(40519u16,21219u16),(40520u16,21220u16),(40521u16,21221u16),
(40522u16,13606u16),(40523u16,21222u16),(40524u16,21223u16),(40526u16,21224u16),
(40527u16,13099u16),(40529u16,21225u16),(40533u16,21226u16),(40535u16,21227u16),
(40536u16,22544u16),(40538u16,21228u16),(40539u16,21229u16),(40540u16,21230u16),
(40542u16,21231u16),(40547u16,21232u16),(40548u16,10980u16),(40550u16,21233u16),
(40551u16,21234u16),(40552u16,21235u16),(40553u16,21236u16),(40554u16,21237u16),
(40555u16,21238u16),(40556u16,21239u16),(40557u16,21241u16),(40560u16,15680u16),
(40561u16,21240u16),(40563u16,21242u16),(40574u16,22161u16),(40575u16,12470u16),
(40578u16,22583u16),(40583u16,22584u16),(40584u16,22585u16),(40587u16,22586u16),
(40594u16,22587u16),(40595u16,12465u16),(40605u16,22589u16),(40607u16,22590u16),
(40614u16,12528u16),(40628u16,22025u16),(40632u16,22024u16),(40635u16,12518u16),
(40637u16,22580u16),(40638u16,22581u16),(40644u16,11153u16),(40649u16,16883u16),
(40653u16,14047u16),(40654u16,12137u16),(40655u16,21189u16),(40657u16,10983u16),
(40660u16,13408u16),(40664u16,12837u16),(40667u16,22591u16),(40668u16,22592u16),
(40669u16,22593u16),(40671u16,22595u16),(40672u16,22594u16),(40674u16,22596u16),
(40677u16,22599u16),(40679u16,22598u16),(40681u16,22597u16),(40682u16,22600u16),
(40687u16,22601u16),(40697u16,20688u16),(40699u16,20689u16),(40700u16,20690u16),
(40702u16,22353u16),(40715u16,22354u16),(40717u16,22355u16),(40718u16,10171u16),
(40720u16,16655u16),(40723u16,10771u16),(40727u16,16652u16),(40729u16,17402u16),
(40736u16,14048u16),(40738u16,22602u16),(40748u16,22603u16),(40751u16,22604u16),
(40754u16,23560u16),(40755u16,23561u16),(40756u16,23562u16),(40757u16,23563u16),
(40758u16,23564u16),(40759u16,22606u16),(40760u16,23565u16),(40761u16,22605u16),
(40762u16,23566u16),(40763u16,9254u16),(40764u16,23567u16),(40765u16,22607u16),
(40766u16,22608u16),(40767u16,23568u16),(40768u16,23569u16),(40769u16,23570u16),
(40770u16,23571u16),(40771u16,23572u16),(40772u16,22609u16),(40773u16,23573u16),
(40774u16,23574u16),(40775u16,23575u16),(40776u16,23576u16),(40777u16,23577u16),
(40778u16,23578u16),(40779u16,23579u16),(40780u16,23580u16),(40781u16,23581u16),
(40782u16,23582u16),(40783u16,23583u16),(40784u16,13280u16),(40785u16,20445u16),
(40786u16,23584u16),(40787u16,23585u16),(40788u16,23586u16),(40789u16,23587u16),
(40790u16,23588u16),(40791u16,23589u16),(40792u16,23590u16),(40793u16,23591u16),
(40794u16,23592u16),(40795u16,23593u16),(40796u16,23594u16),(40797u16,23595u16),
(40798u16,23596u16),(40799u16,23597u16),(40800u16,23598u16),(40801u16,23599u16),
(40802u16,23600u16),(40803u16,23601u16),(40804u16,23602u16),(40805u16,23603u16),
(40806u16,23604u16),(40807u16,23605u16),(40808u16,23606u16),(40809u16,23607u16),
(40810u16,23608u16),(40811u16,23609u16),(40812u16,23610u16),(40813u16,23611u16),
(40814u16,23612u16),(40815u16,23613u16),(40816u16,23614u16),(40817u16,23615u16),
(40818u16,23616u16),(40819u16,23617u16),(40820u16,23618u16),(40821u16,23619u16),
(40822u16,23620u16),(40823u16,23621u16),(40824u16,23622u16),(40825u16,23623u16),
(40826u16,23624u16),(40827u16,23625u16),(40828u16,23626u16),(40829u16,23627u16),
(40830u16,23628u16),(40831u16,9656u16),(40832u16,22344u16),(40833u16,23629u16),
(40834u16,23630u16),(40835u16,22345u16),(40836u16,12323u16),(40837u16,22346u16),
(40838u16,22347u16),(40839u16,22348u16),(40840u16,22349u16),(40841u16,22350u16),
(40842u16,22351u16),(40843u16,13588u16),(40844u16,22352u16),(40845u16,23631u16),
(40846u16,23632u16),(40847u16,23633u16),(40848u16,23634u16),(40849u16,23635u16),
(40850u16,23636u16),(40851u16,23637u16),(40852u16,23638u16),(40853u16,23639u16),
(40854u16,23640u16),(40855u16,23641u16),(40856u16,23642u16),(40857u16,12345u16),
(40858u16,10743u16),(40859u16,20687u16),(40860u16,23643u16),(40861u16,23644u16),
(40862u16,23645u16),(40863u16,10809u16),(40864u16,16878u16),(40865u16,23646u16),
(40866u16,23647u16),(40867u16,23648u16),(40868u16,23649u16),(40869u16,23650u16),
(40884u16,23775u16),(40885u16,23783u16),(40886u16,23788u16),(40887u16,23789u16),
(40888u16,23795u16),(40889u16,23812u16),(40890u16,23829u16),(40891u16,23845u16),
(57344u16,7886u16),(57345u16,7887u16),(57346u16,7888u16),(57347u16,7889u16),
(57348u16,7890u16),(57349u16,7891u16),(57350u16,7892u16),(57351u16,7893u16),
(57352u16,7894u16),(57353u16,7895u16),(57354u16,7896u16),(57355u16,7897u16),
(57356u16,7898u16),(57357u16,7899u16),(57358u16,7900u16),(57359u16,7901u16),
(57360u16,7902u16),(57361u16,7903u16),(57362u16,7904u16),(57363u16,7905u16),
(57364u16,7906u16),(57365u16,7907u16),(57366u16,7908u16),(57367u16,7909u16),
(57368u16,7910u16),(57369u16,7911u16),(57370u16,7912u16),(57371u16,7913u16),
(57372u16,7914u16),(57373u16,7915u16),(57374u16,7916u16),(57375u16,7917u16),
(57376u16,7918u16),(57377u16,7919u16),(57378u16,7920u16),(57379u16,7921u16),
(57380u16,7922u16),(57381u16,7923u16),(57382u16,7924u16),(57383u16,7925u16),
(57384u16,7926u16),(57385u16,7927u16),(57386u16,7928u16),(57387u16,7929u16),
(57388u16,7930u16),(57389u16,7931u16),(57390u16,7932u16),(57391u16,7933u16),
(57392u16,7934u16),(57393u16,7935u16),(57394u16,7936u16),(57395u16,7937u16),
(57396u16,7938u16),(57397u16,7939u16),(57398u16,7940u16),(57399u16,7941u16),
(57400u16,7942u16),(57401u16,7943u16),(57402u16,7944u16),(57403u16,7945u16),
(57404u16,7946u16),(57405u16,7947u16),(57406u16,7948u16),(57407u16,7949u16),
(57408u16,7950u16),(57409u16,7951u16),(57410u16,7952u16),(57411u16,7953u16),
(57412u16,7954u16),(57413u16,7955u16),(57414u16,7956u16),(57415u16,7957u16),
(57416u16,7958u16),(57417u16,7959u16),(57418u16,7960u16),(57419u16,7961u16),
(57420u16,7962u16),(57421u16,7963u16),(57422u16,7964u16),(57423u16,7965u16),
(57424u16,7966u16),(57425u16,7967u16),(57426u16,7968u16),(57427u16,7969u16),
(57428u16,7970u16),(57429u16,7971u16),(57430u16,7972u16),(57431u16,7973u16),
(57432u16,7974u16),(57433u16,7975u16),(57434u16,7976u16),(57435u16,7977u16),
(57436u16,7978u16),(57437u16,7979u16),(57438u16,8076u16),(57439u16,8077u16),
(57440u16,8078u16),(57441u16,8079u16),(57442u16,8080u16),(57443u16,8081u16),
(57444u16,8082u16),(57445u16,8083u16),(57446u16,8084u16),(57447u16,8085u16),
(57448u16,8086u16),(57449u16,8087u16),(57450u16,8088u16),(57451u16,8089u16),
(57452u16,8090u16),(57453u16,8091u16),(57454u16,8092u16),(57455u16,8093u16),
(57456u16,8094u16),(57457u16,8095u16),(57458u16,8096u16),(57459u16,8097u16),
(57460u16,8098u16),(57461u16,8099u16),(57462u16,8100u16),(57463u16,8101u16),
(57464u16,8102u16),(57465u16,8103u16),(57466u16,8104u16),(57467u16,8105u16),
(57468u16,8106u16),(57469u16,8107u16),(57470u16,8108u16),(57471u16,8109u16),
(57472u16,8110u16),(57473u16,8111u16),(57474u16,8112u16),(57475u16,8113u16),
(57476u16,8114u16),(57477u16,8115u16),(57478u16,8116u16),(57479u16,8117u16),
(57480u16,8118u16),(57481u16,8119u16),(57482u16,8120u16),(57483u16,8121u16),
(57484u16,8122u16),(57485u16,8123u16),(57486u16,8124u16),(57487u16,8125u16),
(57488u16,8126u16),(57489u16,8127u16),(57490u16,8128u16),(57491u16,8129u16),
(57492u16,8130u16),(57493u16,8131u16),(57494u16,8132u16),(57495u16,8133u16),
(57496u16,8134u16),(57497u16,8135u16),(57498u16,8136u16),(57499u16,8137u16),
(57500u16,8138u16),(57501u16,8139u16),(57502u16,8140u16),(57503u16,8141u16),
(57504u16,8142u16),(57505u16,8143u16),(57506u16,8144u16),(57507u16,8145u16),
(57508u16,8146u16),(57509u16,8147u16),(57510u16,8148u16),(57511u16,8149u16),
(57512u16,8150u16),(57513u16,8151u16),(57514u16,8152u16),(57515u16,8153u16),
(57516u16,8154u16),(57517u16,8155u16),(57518u16,8156u16),(57519u16,8157u16),
(57520u16,8158u16),(57521u16,8159u16),(57522u16,8160u16),(57523u16,8161u16),
(57524u16,8162u16),(57525u16,8163u16),(57526u16,8164u16),(57527u16,8165u16),
(57528u16,8166u16),(57529u16,8167u16),(57530u16,8168u16),(57531u16,8169u16),
(57532u16,8266u16),(57533u16,8267u16),(57534u16,8268u16),(57535u16,8269u16),
(57536u16,8270u16),(57537u16,8271u16),(57538u16,8272u16),(57539u16,8273u16),
(57540u16,8274u16),(57541u16,8275u16),(57542u16,8276u16),(57543u16,8277u16),
(57544u16,8278u16),(57545u16,8279u16),(57546u16,8280u16),(57547u16,8281u16),
(57548u16,8282u16),(57549u16,8283u16),(57550u16,8284u16),(57551u16,8285u16),
(57552u16,8286u16),(57553u16,8287u16),(57554u16,8288u16),(57555u16,8289u16),
(57556u16,8290u16),(57557u16,8291u16),(57558u16,8292u16),(57559u16,8293u16),
(57560u16,8294u16),(57561u16,8295u16),(57562u16,8296u16),(57563u16,8297u16),
(57564u16,8298u16),(57565u16,8299u16),(57566u16,8300u16),(57567u16,8301u16),
(57568u16,8302u16),(57569u16,8303u16),(57570u16,8304u16),(57571u16,8305u16),
(57572u16,8306u16),(57573u16,8307u16),(57574u16,8308u16),(57575u16,8309u16),
(57576u16,8310u16),(57577u16,8311u16),(57578u16,8312u16),(57579u16,8313u16),
(57580u16,8314u16),(57581u16,8315u16),(57582u16,8316u16),(57583u16,8317u16),
(57584u16,8318u16),(57585u16,8319u16),(57586u16,8320u16),(57587u16,8321u16),
(57588u16,8322u16),(57589u16,8323u16),(57590u16,8324u16),(57591u16,8325u16),
(57592u16,8326u16),(57593u16,8327u16),(57594u16,8328u16),(57595u16,8329u16),
(57596u16,8330u16),(57597u16,8331u16),(57598u16,8332u16),(57599u16,8333u16),
(57600u16,8334u16),(57601u16,8335u16),(57602u16,8336u16),(57603u16,8337u16),
(57604u16,8338u16),(57605u16,8339u16),(57606u16,8340u16),(57607u16,8341u16),
(57608u16,8342u16),(57609u16,8343u16),(57610u16,8344u16),(57611u16,8345u16),
(57612u16,8346u16),(57613u16,8347u16),(57614u16,8348u16),(57615u16,8349u16),
(57616u16,8350u16),(57617u16,8351u16),(57618u16,8352u16),(57619u16,8353u16),
(57620u16,8354u16),(57621u16,8355u16),(57622u16,8356u16),(57623u16,8357u16),
(57624u16,8358u16),(57625u16,8359u16),(57626u16,8456u16),(57627u16,8457u16),
(57628u16,8458u16),(57629u16,8459u16),(57630u16,8460u16),(57631u16,8461u16),
(57632u16,8462u16),(57633u16,8463u16),(57634u16,8464u16),(57635u16,8465u16),
(57636u16,8466u16),(57637u16,8467u16),(57638u16,8468u16),(57639u16,8469u16),
(57640u16,8470u16),(57641u16,8471u16),(57642u16,8472u16),(57643u16,8473u16),
(57644u16,8474u16),(57645u16,8475u16),(57646u16,8476u16),(57647u16,8477u16),
(57648u16,8478u16),(57649u16,8479u16),(57650u16,8480u16),(57651u16,8481u16),
(57652u16,8482u16),(57653u16,8483u16),(57654u16,8484u16),(57655u16,8485u16),
(57656u16,8486u16),(57657u16,8487u16),(57658u16,8488u16),(57659u16,8489u16),
(57660u16,8490u16),(57661u16,8491u16),(57662u16,8492u16),(57663u16,8493u16),
(57664u16,8494u16),(57665u16,8495u16),(57666u16,8496u16),(57667u16,8497u16),
(57668u16,8498u16),(57669u16,8499u16),(57670u16,8500u16),(57671u16,8501u16),
(57672u16,8502u16),(57673u16,8503u16),(57674u16,8504u16),(57675u16,8505u16),
(57676u16,8506u16),(57677u16,8507u16),(57678u16,8508u16),(57679u16,8509u16),
(57680u16,8510u16),(57681u16,8511u16),(57682u16,8512u16),(57683u16,8513u16),
(57684u16,8514u16),(57685u16,8515u16),(57686u16,8516u16),(57687u16,8517u16),
(57688u16,8518u16),(57689u16,8519u16),(57690u16,8520u16),(57691u16,8521u16),
(57692u16,8522u16),(57693u16,8523u16),(57694u16,8524u16),(57695u16,8525u16),
(57696u16,8526u16),(57697u16,8527u16),(57698u16,8528u16),(57699u16,8529u16),
(57700u16,8530u16),(57701u16,8531u16),(57702u16,8532u16),(57703u16,8533u16),
(57704u16,8534u16),(57705u16,8535u16),(57706u16,8536u16),(57707u16,8537u16),
(57708u16,8538u16),(57709u16,8539u16),(57710u16,8540u16),(57711u16,8541u16),
(57712u16,8542u16),(57713u16,8543u16),(57714u16,8544u16),(57715u16,8545u16),
(57716u16,8546u16),(57717u16,8547u16),(57718u16,8548u16),(57719u16,8549u16),
(57720u16,8646u16),(57721u16,8647u16),(57722u16,8648u16),(57723u16,8649u16),
(57724u16,8650u16),(57725u16,8651u16),(57726u16,8652u16),(57727u16,8653u16),
(57728u16,8654u16),(57729u16,8655u16),(57730u16,8656u16),(57731u16,8657u16),
(57732u16,8658u16),(57733u16,8659u16),(57734u16,8660u16),(57735u16,8661u16),
(57736u16,8662u16),(57737u16,8663u16),(57738u16,8664u16),(57739u16,8665u16),
(57740u16,8666u16),(57741u16,8667u16),(57742u16,8668u16),(57743u16,8669u16),
(57744u16,8670u16),(57745u16,8671u16),(57746u16,8672u16),(57747u16,8673u16),
(57748u16,8674u16),(57749u16,8675u16),(57750u16,8676u16),(57751u16,8677u16),
(57752u16,8678u16),(57753u16,8679u16),(57754u16,8680u16),(57755u16,8681u16),
(57756u16,8682u16),(57757u16,8683u16),(57758u16,8684u16),(57759u16,8685u16),
(57760u16,8686u16),(57761u16,8687u16),(57762u16,8688u16),(57763u16,8689u16),
(57764u16,8690u16),(57765u16,8691u16),(57766u16,8692u16),(57767u16,8693u16),
(57768u16,8694u16),(57769u16,8695u16),(57770u16,8696u16),(57771u16,8697u16),
(57772u16,8698u16),(57773u16,8699u16),(57774u16,8700u16),(57775u16,8701u16),
(57776u16,8702u16),(57777u16,8703u16),(57778u16,8704u16),(57779u16,8705u16),
(57780u16,8706u16),(57781u16,8707u16),(57782u16,8708u16),(57783u16,8709u16),
(57784u16,8710u16),(57785u16,8711u16),(57786u16,8712u16),(57787u16,8713u16),
(57788u16,8714u16),(57789u16,8715u16),(57790u16,8716u16),(57791u16,8717u16),
(57792u16,8718u16),(57793u16,8719u16),(57794u16,8720u16),(57795u16,8721u16),
(57796u16,8722u16),(57797u16,8723u16),(57798u16,8724u16),(57799u16,8725u16),
(57800u16,8726u16),(57801u16,8727u16),(57802u16,8728u16),(57803u16,8729u16),
(57804u16,8730u16),(57805u16,8731u16),(57806u16,8732u16),(57807u16,8733u16),
(57808u16,8734u16),(57809u16,8735u16),(57810u16,8736u16),(57811u16,8737u16),
(57812u16,8738u16),(57813u16,8739u16),(57814u16,8836u16),(57815u16,8837u16),
(57816u16,8838u16),(57817u16,8839u16),(57818u16,8840u16),(57819u16,8841u16),
(57820u16,8842u16),(57821u16,8843u16),(57822u16,8844u16),(57823u16,8845u16),
(57824u16,8846u16),(57825u16,8847u16),(57826u16,8848u16),(57827u16,8849u16),
(57828u16,8850u16),(57829u16,8851u16),(57830u16,8852u16),(57831u16,8853u16),
(57832u16,8854u16),(57833u16,8855u16),(57834u16,8856u16),(57835u16,8857u16),
(57836u16,8858u16),(57837u16,8859u16),(57838u16,8860u16),(57839u16,8861u16),
(57840u16,8862u16),(57841u16,8863u16),(57842u16,8864u16),(57843u16,8865u16),
(57844u16,8866u16),(57845u16,8867u16),(57846u16,8868u16),(57847u16,8869u16),
(57848u16,8870u16),(57849u16,8871u16),(57850u16,8872u16),(57851u16,8873u16),
(57852u16,8874u16),(57853u16,8875u16),(57854u16,8876u16),(57855u16,8877u16),
(57856u16,8878u16),(57857u16,8879u16),(57858u16,8880u16),(57859u16,8881u16),
(57860u16,8882u16),(57861u16,8883u16),(57862u16,8884u16),(57863u16,8885u16),
(57864u16,8886u16),(57865u16,8887u16),(57866u16,8888u16),(57867u16,8889u16),
(57868u16,8890u16),(57869u16,8891u16),(57870u16,8892u16),(57871u16,8893u16),
(57872u16,8894u16),(57873u16,8895u16),(57874u16,8896u16),(57875u16,8897u16),
(57876u16,8898u16),(57877u16,8899u16),(57878u16,8900u16),(57879u16,8901u16),
(57880u16,8902u16),(57881u16,8903u16),(57882u16,8904u16),(57883u16,8905u16),
(57884u16,8906u16),(57885u16,8907u16),(57886u16,8908u16),(57887u16,8909u16),
(57888u16,8910u16),(57889u16,8911u16),(57890u16,8912u16),(57891u16,8913u16),
(57892u16,8914u16),(57893u16,8915u16),(57894u16,8916u16),(57895u16,8917u16),
(57896u16,8918u16),(57897u16,8919u16),(57898u16,8920u16),(57899u16,8921u16),
(57900u16,8922u16),(57901u16,8923u16),(57902u16,8924u16),(57903u16,8925u16),
(57904u16,8926u16),(57905u16,8927u16),(57906u16,8928u16),(57907u16,8929u16),
(57908u16,22706u16),(57909u16,22707u16),(57910u16,22708u16),(57911u16,22709u16),
(57912u16,22710u16),(57913u16,22711u16),(57914u16,22712u16),(57915u16,22713u16),
(57916u16,22714u16),(57917u16,22715u16),(57918u16,22716u16),(57919u16,22717u16),
(57920u16,22718u16),(57921u16,22719u16),(57922u16,22720u16),(57923u16,22721u16),
(57924u16,22722u16),(57925u16,22723u16),(57926u16,22724u16),(57927u16,22725u16),
(57928u16,22726u16),(57929u16,22727u16),(57930u16,22728u16),(57931u16,22729u16),
(57932u16,22730u16),(57933u16,22731u16),(57934u16,22732u16),(57935u16,22733u16),
(57936u16,22734u16),(57937u16,22735u16),(57938u16,22736u16),(57939u16,22737u16),
(57940u16,22738u16),(57941u16,22739u16),(57942u16,22740u16),(57943u16,22741u16),
(57944u16,22742u16),(57945u16,22743u16),(57946u16,22744u16),(57947u16,22745u16),
(57948u16,22746u16),(57949u16,22747u16),(57950u16,22748u16),(57951u16,22749u16),
(57952u16,22750u16),(57953u16,22751u16),(57954u16,22752u16),(57955u16,22753u16),
(57956u16,22754u16),(57957u16,22755u16),(57958u16,22756u16),(57959u16,22757u16),
(57960u16,22758u16),(57961u16,22759u16),(57962u16,22760u16),(57963u16,22761u16),
(57964u16,22762u16),(57965u16,22763u16),(57966u16,22764u16),(57967u16,22765u16),
(57968u16,22766u16),(57969u16,22767u16),(57970u16,22768u16),(57971u16,22769u16),
(57972u16,22770u16),(57973u16,22771u16),(57974u16,22772u16),(57975u16,22773u16),
(57976u16,22774u16),(57977u16,22775u16),(57978u16,22776u16),(57979u16,22777u16),
(57980u16,22778u16),(57981u16,22779u16),(57982u16,22780u16),(57983u16,22781u16),
(57984u16,22782u16),(57985u16,22783u16),(57986u16,22784u16),(57987u16,22785u16),
(57988u16,22786u16),(57989u16,22787u16),(57990u16,22788u16),(57991u16,22789u16),
(57992u16,22790u16),(57993u16,22791u16),(57994u16,22792u16),(57995u16,22793u16),
(57996u16,22794u16),(57997u16,22795u16),(57998u16,22796u16),(57999u16,22797u16),
(58000u16,22798u16),(58001u16,22799u16),(58002u16,22896u16),(58003u16,22897u16),
(58004u16,22898u16),(58005u16,22899u16),(58006u16,22900u16),(58007u16,22901u16),
(58008u16,22902u16),(58009u16,22903u16),(58010u16,22904u16),(58011u16,22905u16),
(58012u16,22906u16),(58013u16,22907u16),(58014u16,22908u16),(58015u16,22909u16),
(58016u16,22910u16),(58017u16,22911u16),(58018u16,22912u16),(58019u16,22913u16),
(58020u16,22914u16),(58021u16,22915u16),(58022u16,22916u16),(58023u16,22917u16),
(58024u16,22918u16),(58025u16,22919u16),(58026u16,22920u16),(58027u16,22921u16),
(58028u16,22922u16),(58029u16,22923u16),(58030u16,22924u16),(58031u16,22925u16),
(58032u16,22926u16),(58033u16,22927u16),(58034u16,22928u16),(58035u16,22929u16),
(58036u16,22930u16),(58037u16,22931u16),(58038u16,22932u16),(58039u16,22933u16),
(58040u16,22934u16),(58041u16,22935u16),(58042u16,22936u16),(58043u16,22937u16),
(58044u16,22938u16),(58045u16,22939u16),(58046u16,22940u16),(58047u16,22941u16),
(58048u16,22942u16),(58049u16,22943u16),(58050u16,22944u16),(58051u16,22945u16),
(58052u16,22946u16),(58053u16,22947u16),(58054u16,22948u16),(58055u16,22949u16),
(58056u16,22950u16),(58057u16,22951u16),(58058u16,22952u16),(58059u16,22953u16),
(58060u16,22954u16),(58061u16,22955u16),(58062u16,22956u16),(58063u16,22957u16),
(58064u16,22958u16),(58065u16,22959u16),(58066u16,22960u16),(58067u16,22961u16),
(58068u16,22962u16),(58069u16,22963u16),(58070u16,22964u16),(58071u16,22965u16),
(58072u16,22966u16),(58073u16,22967u16),(58074u16,22968u16),(58075u16,22969u16),
(58076u16,22970u16),(58077u16,22971u16),(58078u16,22972u16),(58079u16,22973u16),
(58080u16,22974u16),(58081u16,22975u16),(58082u16,22976u16),(58083u16,22977u16),
(58084u16,22978u16),(58085u16,22979u16),(58086u16,22980u16),(58087u16,22981u16),
(58088u16,22982u16),(58089u16,22983u16),(58090u16,22984u16),(58091u16,22985u16),
(58092u16,22986u16),(58093u16,22987u16),(58094u16,22988u16),(58095u16,22989u16),
(58096u16,23086u16),(58097u16,23087u16),(58098u16,23088u16),(58099u16,23089u16),
(58100u16,23090u16),(58101u16,23091u16),(58102u16,23092u16),(58103u16,23093u16),
(58104u16,23094u16),(58105u16,23095u16),(58106u16,23096u16),(58107u16,23097u16),
(58108u16,23098u16),(58109u16,23099u16),(58110u16,23100u16),(58111u16,23101u16),
(58112u16,23102u16),(58113u16,23103u16),(58114u16,23104u16),(58115u16,23105u16),
(58116u16,23106u16),(58117u16,23107u16),(58118u16,23108u16),(58119u16,23109u16),
(58120u16,23110u16),(58121u16,23111u16),(58122u16,23112u16),(58123u16,23113u16),
(58124u16,23114u16),(58125u16,23115u16),(58126u16,23116u16),(58127u16,23117u16),
(58128u16,23118u16),(58129u16,23119u16),(58130u16,23120u16),(58131u16,23121u16),
(58132u16,23122u16),(58133u16,23123u16),(58134u16,23124u16),(58135u16,23125u16),
(58136u16,23126u16),(58137u16,23127u16),(58138u16,23128u16),(58139u16,23129u16),
(58140u16,23130u16),(58141u16,23131u16),(58142u16,23132u16),(58143u16,23133u16),
(58144u16,23134u16),(58145u16,23135u16),(58146u16,23136u16),(58147u16,23137u16),
(58148u16,23138u16),(58149u16,23139u16),(58150u16,23140u16),(58151u16,23141u16),
(58152u16,23142u16),(58153u16,23143u16),(58154u16,23144u16),(58155u16,23145u16),
(58156u16,23146u16),(58157u16,23147u16),(58158u16,23148u16),(58159u16,23149u16),
(58160u16,23150u16),(58161u16,23151u16),(58162u16,23152u16),(58163u16,23153u16),
(58164u16,23154u16),(58165u16,23155u16),(58166u16,23156u16),(58167u16,23157u16),
(58168u16,23158u16),(58169u16,23159u16),(58170u16,23160u16),(58171u16,23161u16),
(58172u16,23162u16),(58173u16,23163u16),(58174u16,23164u16),(58175u16,23165u16),
(58176u16,23166u16),(58177u16,23167u16),(58178u16,23168u16),(58179u16,23169u16),
(58180u16,23170u16),(58181u16,23171u16),(58182u16,23172u16),(58183u16,23173u16),
(58184u16,23174u16),(58185u16,23175u16),(58186u16,23176u16),(58187u16,23177u16),
(58188u16,23178u16),(58189u16,23179u16),(58190u16,23276u16),(58191u16,23277u16),
(58192u16,23278u16),(58193u16,23279u16),(58194u16,23280u16),(58195u16,23281u16),
(58196u16,23282u16),(58197u16,23283u16),(58198u16,23284u16),(58199u16,23285u16),
(58200u16,23286u16),(58201u16,23287u16),(58202u16,23288u16),(58203u16,23289u16),
(58204u16,23290u16),(58205u16,23291u16),(58206u16,23292u16),(58207u16,23293u16),
(58208u16,23294u16),(58209u16,23295u16),(58210u16,23296u16),(58211u16,23297u16),
(58212u16,23298u16),(58213u16,23299u16),(58214u16,23300u16),(58215u16,23301u16),
(58216u16,23302u16),(58217u16,23303u16),(58218u16,23304u16),(58219u16,23305u16),
(58220u16,23306u16),(58221u16,23307u16),(58222u16,23308u16),(58223u16,23309u16),
(58224u16,23310u16),(58225u16,23311u16),(58226u16,23312u16),(58227u16,23313u16),
(58228u16,23314u16),(58229u16,23315u16),(58230u16,23316u16),(58231u16,23317u16),
(58232u16,23318u16),(58233u16,23319u16),(58234u16,23320u16),(58235u16,23321u16),
(58236u16,23322u16),(58237u16,23323u16),(58238u16,23324u16),(58239u16,23325u16),
(58240u16,23326u16),(58241u16,23327u16),(58242u16,23328u16),(58243u16,23329u16),
(58244u16,23330u16),(58245u16,23331u16),(58246u16,23332u16),(58247u16,23333u16),
(58248u16,23334u16),(58249u16,23335u16),(58250u16,23336u16),(58251u16,23337u16),
(58252u16,23338u16),(58253u16,23339u16),(58254u16,23340u16),(58255u16,23341u16),
(58256u16,23342u16),(58257u16,23343u16),(58258u16,23344u16),(58259u16,23345u16),
(58260u16,23346u16),(58261u16,23347u16),(58262u16,23348u16),(58263u16,23349u16),
(58264u16,23350u16),(58265u16,23351u16),(58266u16,23352u16),(58267u16,23353u16),
(58268u16,23354u16),(58269u16,23355u16),(58270u16,23356u16),(58271u16,23357u16),
(58272u16,23358u16),(58273u16,23359u16),(58274u16,23360u16),(58275u16,23361u16),
(58276u16,23362u16),(58277u16,23363u16),(58278u16,23364u16),(58279u16,23365u16),
(58280u16,23366u16),(58281u16,23367u16),(58282u16,23368u16),(58283u16,23369u16),
(58284u16,23466u16),(58285u16,23467u16),(58286u16,23468u16),(58287u16,23469u16),
(58288u16,23470u16),(58289u16,23471u16),(58290u16,23472u16),(58291u16,23473u16),
(58292u16,23474u16),(58293u16,23475u16),(58294u16,23476u16),(58295u16,23477u16),
(58296u16,23478u16),(58297u16,23479u16),(58298u16,23480u16),(58299u16,23481u16),
(58300u16,23482u16),(58301u16,23483u16),(58302u16,23484u16),(58303u16,23485u16),
(58304u16,23486u16),(58305u16,23487u16),(58306u16,23488u16),(58307u16,23489u16),
(58308u16,23490u16),(58309u16,23491u16),(58310u16,23492u16),(58311u16,23493u16),
(58312u16,23494u16),(58313u16,23495u16),(58314u16,23496u16),(58315u16,23497u16),
(58316u16,23498u16),(58317u16,23499u16),(58318u16,23500u16),(58319u16,23501u16),
(58320u16,23502u16),(58321u16,23503u16),(58322u16,23504u16),(58323u16,23505u16),
(58324u16,23506u16),(58325u16,23507u16),(58326u16,23508u16),(58327u16,23509u16),
(58328u16,23510u16),(58329u16,23511u16),(58330u16,23512u16),(58331u16,23513u16),
(58332u16,23514u16),(58333u16,23515u16),(58334u16,23516u16),(58335u16,23517u16),
(58336u16,23518u16),(58337u16,23519u16),(58338u16,23520u16),(58339u16,23521u16),
(58340u16,23522u16),(58341u16,23523u16),(58342u16,23524u16),(58343u16,23525u16),
(58344u16,23526u16),(58345u16,23527u16),(58346u16,23528u16),(58347u16,23529u16),
(58348u16,23530u16),(58349u16,23531u16),(58350u16,23532u16),(58351u16,23533u16),
(58352u16,23534u16),(58353u16,23535u16),(58354u16,23536u16),(58355u16,23537u16),
(58356u16,23538u16),(58357u16,23539u16),(58358u16,23540u16),(58359u16,23541u16),
(58360u16,23542u16),(58361u16,23543u16),(58362u16,23544u16),(58363u16,23545u16),
(58364u16,23546u16),(58365u16,23547u16),(58366u16,23548u16),(58367u16,23549u16),
(58368u16,23550u16),(58369u16,23551u16),(58370u16,23552u16),(58371u16,23553u16),
(58372u16,23554u16),(58373u16,23555u16),(58374u16,23556u16),(58375u16,23557u16),
(58376u16,23558u16),(58377u16,23559u16),(58378u16,23656u16),(58379u16,23657u16),
(58380u16,23658u16),(58381u16,23659u16),(58382u16,23660u16),(58383u16,23661u16),
(58384u16,23662u16),(58385u16,23663u16),(58386u16,23664u16),(58387u16,23665u16),
(58388u16,23666u16),(58389u16,23667u16),(58390u16,23668u16),(58391u16,23669u16),
(58392u16,23670u16),(58393u16,23671u16),(58394u16,23672u16),(58395u16,23673u16),
(58396u16,23674u16),(58397u16,23675u16),(58398u16,23676u16),(58399u16,23677u16),
(58400u16,23678u16),(58401u16,23679u16),(58402u16,23680u16),(58403u16,23681u16),
(58404u16,23682u16),(58405u16,23683u16),(58406u16,23684u16),(58407u16,23685u16),
(58408u16,23686u16),(58409u16,23687u16),(58410u16,23688u16),(58411u16,23689u16),
(58412u16,23690u16),(58413u16,23691u16),(58414u16,23692u16),(58415u16,23693u16),
(58416u16,23694u16),(58417u16,23695u16),(58418u16,23696u16),(58419u16,23697u16),
(58420u16,23698u16),(58421u16,23699u16),(58422u16,23700u16),(58423u16,23701u16),
(58424u16,23702u16),(58425u16,23703u16),(58426u16,23704u16),(58427u16,23705u16),
(58428u16,23706u16),(58429u16,23707u16),(58430u16,23708u16),(58431u16,23709u16),
(58432u16,23710u16),(58433u16,23711u16),(58434u16,23712u16),(58435u16,23713u16),
(58436u16,23714u16),(58437u16,23715u16),(58438u16,23716u16),(58439u16,23717u16),
(58440u16,23718u16),(58441u16,23719u16),(58442u16,23720u16),(58443u16,23721u16),
(58444u16,23722u16),(58445u16,23723u16),(58446u16,23724u16),(58447u16,23725u16),
(58448u16,23726u16),(58449u16,23727u16),(58450u16,23728u16),(58451u16,23729u16),
(58452u16,23730u16),(58453u16,23731u16),(58454u16,23732u16),(58455u16,23733u16),
(58456u16,23734u16),(58457u16,23735u16),(58458u16,23736u16),(58459u16,23737u16),
(58460u16,23738u16),(58461u16,23739u16),(58462u16,23740u16),(58463u16,23741u16),
(58464u16,23742u16),(58465u16,23743u16),(58466u16,23744u16),(58467u16,23745u16),
(58468u16,23746u16),(58469u16,23747u16),(58470u16,23748u16),(58471u16,23749u16),
(58472u16,23846u16),(58473u16,23847u16),(58474u16,23848u16),(58475u16,23849u16),
(58476u16,23850u16),(58477u16,23851u16),(58478u16,23852u16),(58479u16,23853u16),
(58480u16,23854u16),(58481u16,23855u16),(58482u16,23856u16),(58483u16,23857u16),
(58484u16,23858u16),(58485u16,23859u16),(58486u16,23860u16),(58487u16,23861u16),
(58488u16,23862u16),(58489u16,23863u16),(58490u16,23864u16),(58491u16,23865u16),
(58492u16,23866u16),(58493u16,23867u16),(58494u16,23868u16),(58495u16,23869u16),
(58496u16,23870u16),(58497u16,23871u16),(58498u16,23872u16),(58499u16,23873u16),
(58500u16,23874u16),(58501u16,23875u16),(58502u16,23876u16),(58503u16,23877u16),
(58504u16,23878u16),(58505u16,23879u16),(58506u16,23880u16),(58507u16,23881u16),
(58508u16,23882u16),(58509u16,23883u16),(58510u16,23884u16),(58511u16,23885u16),
(58512u16,23886u16),(58513u16,23887u16),(58514u16,23888u16),(58515u16,23889u16),
(58516u16,23890u16),(58517u16,23891u16),(58518u16,23892u16),(58519u16,23893u16),
(58520u16,23894u16),(58521u16,23895u16),(58522u16,23896u16),(58523u16,23897u16),
(58524u16,23898u16),(58525u16,23899u16),(58526u16,23900u16),(58527u16,23901u16),
(58528u16,23902u16),(58529u16,23903u16),(58530u16,23904u16),(58531u16,23905u16),
(58532u16,23906u16),(58533u16,23907u16),(58534u16,23908u16),(58535u16,23909u16),
(58536u16,23910u16),(58537u16,23911u16),(58538u16,23912u16),(58539u16,23913u16),
(58540u16,23914u16),(58541u16,23915u16),(58542u16,23916u16),(58543u16,23917u16),
(58544u16,23918u16),(58545u16,23919u16),(58546u16,23920u16),(58547u16,23921u16),
(58548u16,23922u16),(58549u16,23923u16),(58550u16,23924u16),(58551u16,23925u16),
(58552u16,23926u16),(58553u16,23927u16),(58554u16,23928u16),(58555u16,23929u16),
(58556u16,23930u16),(58557u16,23931u16),(58558u16,23932u16),(58559u16,23933u16),
(58560u16,23934u16),(58561u16,23935u16),(58562u16,23936u16),(58563u16,23937u16),
(58564u16,23938u16),(58565u16,23939u16),(58566u16,6080u16),(58567u16,6081u16),
(58568u16,6082u16),(58569u16,6083u16),(58570u16,6084u16),(58571u16,6085u16),
(58572u16,6086u16),(58573u16,6087u16),(58574u16,6088u16),(58575u16,6089u16),
(58576u16,6090u16),(58577u16,6091u16),(58578u16,6092u16),(58579u16,6093u16),
(58580u16,6094u16),(58581u16,6095u16),(58582u16,6096u16),(58583u16,6097u16),
(58584u16,6098u16),(58585u16,6099u16),(58586u16,6100u16),(58587u16,6101u16),
(58588u16,6102u16),(58589u16,6103u16),(58590u16,6104u16),(58591u16,6105u16),
(58592u16,6106u16),(58593u16,6107u16),(58594u16,6108u16),(58595u16,6109u16),
(58596u16,6110u16),(58597u16,6111u16),(58598u16,6112u16),(58599u16,6113u16),
(58600u16,6114u16),(58601u16,6115u16),(58602u16,6116u16),(58603u16,6117u16),
(58604u16,6118u16),(58605u16,6119u16),(58606u16,6120u16),(58607u16,6121u16),
(58608u16,6122u16),(58609u16,6123u16),(58610u16,6124u16),(58611u16,6125u16),
(58612u16,6126u16),(58613u16,6127u16),(58614u16,6128u16),(58615u16,6129u16),
(58616u16,6130u16),(58617u16,6131u16),(58618u16,6132u16),(58619u16,6133u16),
(58620u16,6134u16),(58621u16,6135u16),(58622u16,6136u16),(58623u16,6137u16),
(58624u16,6138u16),(58625u16,6139u16),(58626u16,6140u16),(58627u16,6141u16),
(58628u16,6142u16),(58629u16,6143u16),(58630u16,6144u16),(58631u16,6145u16),
(58632u16,6146u16),(58633u16,6147u16),(58634u16,6148u16),(58635u16,6149u16),
(58636u16,6150u16),(58637u16,6151u16),(58638u16,6152u16),(58639u16,6153u16),
(58640u16,6154u16),(58641u16,6155u16),(58642u16,6156u16),(58643u16,6157u16),
(58644u16,6158u16),(58645u16,6159u16),(58646u16,6160u16),(58647u16,6161u16),
(58648u16,6162u16),(58649u16,6163u16),(58650u16,6164u16),(58651u16,6165u16),
(58652u16,6166u16),(58653u16,6167u16),(58654u16,6168u16),(58655u16,6169u16),
(58656u16,6170u16),(58657u16,6171u16),(58658u16,6172u16),(58659u16,6173u16),
(58660u16,6174u16),(58661u16,6175u16),(58662u16,6270u16),(58663u16,6271u16),
(58664u16,6272u16),(58665u16,6273u16),(58666u16,6274u16),(58667u16,6275u16),
(58668u16,6276u16),(58669u16,6277u16),(58670u16,6278u16),(58671u16,6279u16),
(58672u16,6280u16),(58673u16,6281u16),(58674u16,6282u16),(58675u16,6283u16),
(58676u16,6284u16),(58677u16,6285u16),(58678u16,6286u16),(58679u16,6287u16),
(58680u16,6288u16),(58681u16,6289u16),(58682u16,6290u16),(58683u16,6291u16),
(58684u16,6292u16),(58685u16,6293u16),(58686u16,6294u16),(58687u16,6295u16),
(58688u16,6296u16),(58689u16,6297u16),(58690u16,6298u16),(58691u16,6299u16),
(58692u16,6300u16),(58693u16,6301u16),(58694u16,6302u16),(58695u16,6303u16),
(58696u16,6304u16),(58697u16,6305u16),(58698u16,6306u16),(58699u16,6307u16),
(58700u16,6308u16),(58701u16,6309u16),(58702u16,6310u16),(58703u16,6311u16),
(58704u16,6312u16),(58705u16,6313u16),(58706u16,6314u16),(58707u16,6315u16),
(58708u16,6316u16),(58709u16,6317u16),(58710u16,6318u16),(58711u16,6319u16),
(58712u16,6320u16),(58713u16,6321u16),(58714u16,6322u16),(58715u16,6323u16),
(58716u16,6324u16),(58717u16,6325u16),(58718u16,6326u16),(58719u16,6327u16),
(58720u16,6328u16),(58721u16,6329u16),(58722u16,6330u16),(58723u16,6331u16),
(58724u16,6332u16),(58725u16,6333u16),(58726u16,6334u16),(58727u16,6335u16),
(58728u16,6336u16),(58729u16,6337u16),(58730u16,6338u16),(58731u16,6339u16),
(58732u16,6340u16),(58733u16,6341u16),(58734u16,6342u16),(58735u16,6343u16),
(58736u16,6344u16),(58737u16,6345u16),(58738u16,6346u16),(58739u16,6347u16),
(58740u16,6348u16),(58741u16,6349u16),(58742u16,6350u16),(58743u16,6351u16),
(58744u16,6352u16),(58745u16,6353u16),(58746u16,6354u16),(58747u16,6355u16),
(58748u16,6356u16),(58749u16,6357u16),(58750u16,6358u16),(58751u16,6359u16),
(58752u16,6360u16),(58753u16,6361u16),(58754u16,6362u16),(58755u16,6363u16),
(58756u16,6364u16),(58757u16,6365u16),(58758u16,6460u16),(58759u16,6461u16),
(58760u16,6462u16),(58761u16,6463u16),(58762u16,6464u16),(58763u16,6465u16),
(58764u16,6466u16),(58765u16,6467u16),(58766u16,6468u16),(58767u16,6469u16),
(58768u16,6470u16),(58769u16,6471u16),(58770u16,6472u16),(58771u16,6473u16),
(58772u16,6474u16),(58773u16,6475u16),(58774u16,6476u16),(58775u16,6477u16),
(58776u16,6478u16),(58777u16,6479u16),(58778u16,6480u16),(58779u16,6481u16),
(58780u16,6482u16),(58781u16,6483u16),(58782u16,6484u16),(58783u16,6485u16),
(58784u16,6486u16),(58785u16,6487u16),(58786u16,6488u16),(58787u16,6489u16),
(58788u16,6490u16),(58789u16,6491u16),(58790u16,6492u16),(58791u16,6493u16),
(58792u16,6494u16),(58793u16,6495u16),(58794u16,6496u16),(58795u16,6497u16),
(58796u16,6498u16),(58797u16,6499u16),(58798u16,6500u16),(58799u16,6501u16),
(58800u16,6502u16),(58801u16,6503u16),(58802u16,6504u16),(58803u16,6505u16),
(58804u16,6506u16),(58805u16,6507u16),(58806u16,6508u16),(58807u16,6509u16),
(58808u16,6510u16),(58809u16,6511u16),(58810u16,6512u16),(58811u16,6513u16),
(58812u16,6514u16),(58813u16,6515u16),(58814u16,6516u16),(58815u16,6517u16),
(58816u16,6518u16),(58817u16,6519u16),(58818u16,6520u16),(58819u16,6521u16),
(58820u16,6522u16),(58821u16,6523u16),(58822u16,6524u16),(58823u16,6525u16),
(58824u16,6526u16),(58825u16,6527u16),(58826u16,6528u16),(58827u16,6529u16),
(58828u16,6530u16),(58829u16,6531u16),(58830u16,6532u16),(58831u16,6533u16),
(58832u16,6534u16),(58833u16,6535u16),(58834u16,6536u16),(58835u16,6537u16),
(58836u16,6538u16),(58837u16,6539u16),(58838u16,6540u16),(58839u16,6541u16),
(58840u16,6542u16),(58841u16,6543u16),(58842u16,6544u16),(58843u16,6545u16),
(58844u16,6546u16),(58845u16,6547u16),(58846u16,6548u16),(58847u16,6549u16),
(58848u16,6550u16),(58849u16,6551u16),(58850u16,6552u16),(58851u16,6553u16),
(58852u16,6554u16),(58854u16,6650u16),(58855u16,6651u16),(58856u16,6652u16),
(58857u16,6653u16),(58858u16,6654u16),(58859u16,6655u16),(58860u16,6656u16),
(58861u16,6657u16),(58862u16,6658u16),(58863u16,6659u16),(58864u16,6660u16),
(58865u16,6661u16),(58866u16,6662u16),(58867u16,6663u16),(58868u16,6664u16),
(58869u16,6665u16),(58870u16,6666u16),(58871u16,6667u16),(58872u16,6668u16),
(58873u16,6669u16),(58874u16,6670u16),(58875u16,6671u16),(58876u16,6672u16),
(58877u16,6673u16),(58878u16,6674u16),(58879u16,6675u16),(58880u16,6676u16),
(58881u16,6677u16),(58882u16,6678u16),(58883u16,6679u16),(58884u16,6680u16),
(58885u16,6681u16),(58886u16,6682u16),(58887u16,6683u16),(58888u16,6684u16),
(58889u16,6685u16),(58890u16,6686u16),(58891u16,6687u16),(58892u16,6688u16),
(58893u16,6689u16),(58894u16,6690u16),(58895u16,6691u16),(58896u16,6692u16),
(58897u16,6693u16),(58898u16,6694u16),(58899u16,6695u16),(58900u16,6696u16),
(58901u16,6697u16),(58902u16,6698u16),(58903u16,6699u16),(58904u16,6700u16),
(58905u16,6701u16),(58906u16,6702u16),(58907u16,6703u16),(58908u16,6704u16),
(58909u16,6705u16),(58910u16,6706u16),(58911u16,6707u16),(58912u16,6708u16),
(58913u16,6709u16),(58914u16,6710u16),(58915u16,6711u16),(58916u16,6712u16),
(58917u16,6713u16),(58918u16,6714u16),(58919u16,6715u16),(58920u16,6716u16),
(58921u16,6717u16),(58922u16,6718u16),(58923u16,6719u16),(58924u16,6720u16),
(58925u16,6721u16),(58926u16,6722u16),(58927u16,6723u16),(58928u16,6724u16),
(58929u16,6725u16),(58930u16,6726u16),(58931u16,6727u16),(58932u16,6728u16),
(58933u16,6729u16),(58934u16,6730u16),(58935u16,6731u16),(58936u16,6732u16),
(58937u16,6733u16),(58938u16,6734u16),(58939u16,6735u16),(58940u16,6736u16),
(58941u16,6737u16),(58942u16,6738u16),(58943u16,6739u16),(58944u16,6740u16),
(58945u16,6741u16),(58946u16,6742u16),(58947u16,6743u16),(58948u16,6744u16),
(58949u16,6745u16),(58950u16,6840u16),(58951u16,6841u16),(58952u16,6842u16),
(58953u16,6843u16),(58954u16,6844u16),(58955u16,6845u16),(58956u16,6846u16),
(58957u16,6847u16),(58958u16,6848u16),(58959u16,6849u16),(58960u16,6850u16),
(58961u16,6851u16),(58962u16,6852u16),(58963u16,6853u16),(58964u16,6854u16),
(58965u16,6855u16),(58966u16,6856u16),(58967u16,6857u16),(58968u16,6858u16),
(58969u16,6859u16),(58970u16,6860u16),(58971u16,6861u16),(58972u16,6862u16),
(58973u16,6863u16),(58974u16,6864u16),(58975u16,6865u16),(58976u16,6866u16),
(58977u16,6867u16),(58978u16,6868u16),(58979u16,6869u16),(58980u16,6870u16),
(58981u16,6871u16),(58982u16,6872u16),(58983u16,6873u16),(58984u16,6874u16),
(58985u16,6875u16),(58986u16,6876u16),(58987u16,6877u16),(58988u16,6878u16),
(58989u16,6879u16),(58990u16,6880u16),(58991u16,6881u16),(58992u16,6882u16),
(58993u16,6883u16),(58994u16,6884u16),(58995u16,6885u16),(58996u16,6886u16),
(58997u16,6887u16),(58998u16,6888u16),(58999u16,6889u16),(59000u16,6890u16),
(59001u16,6891u16),(59002u16,6892u16),(59003u16,6893u16),(59004u16,6894u16),
(59005u16,6895u16),(59006u16,6896u16),(59007u16,6897u16),(59008u16,6898u16),
(59009u16,6899u16),(59010u16,6900u16),(59011u16,6901u16),(59012u16,6902u16),
(59013u16,6903u16),(59014u16,6904u16),(59015u16,6905u16),(59016u16,6906u16),
(59017u16,6907u16),(59018u16,6908u16),(59019u16,6909u16),(59020u16,6910u16),
(59021u16,6911u16),(59022u16,6912u16),(59023u16,6913u16),(59024u16,6914u16),
(59025u16,6915u16),(59026u16,6916u16),(59027u16,6917u16),(59028u16,6918u16),
(59029u16,6919u16),(59030u16,6920u16),(59031u16,6921u16),(59032u16,6922u16),
(59033u16,6923u16),(59034u16,6924u16),(59035u16,6925u16),(59036u16,6926u16),
(59037u16,6927u16),(59038u16,6928u16),(59039u16,6929u16),(59040u16,6930u16),
(59041u16,6931u16),(59042u16,6932u16),(59043u16,6933u16),(59044u16,6934u16),
(59045u16,6935u16),(59046u16,7030u16),(59047u16,7031u16),(59048u16,7032u16),
(59049u16,7033u16),(59050u16,7034u16),(59051u16,7035u16),(59052u16,7036u16),
(59053u16,7037u16),(59054u16,7038u16),(59055u16,7039u16),(59056u16,7040u16),
(59057u16,7041u16),(59058u16,7042u16),(59059u16,7043u16),(59060u16,7044u16),
(59061u16,7045u16),(59062u16,7046u16),(59063u16,7047u16),(59064u16,7048u16),
(59065u16,7049u16),(59066u16,7050u16),(59067u16,7051u16),(59068u16,7052u16),
(59069u16,7053u16),(59070u16,7054u16),(59071u16,7055u16),(59072u16,7056u16),
(59073u16,7057u16),(59074u16,7058u16),(59075u16,7059u16),(59076u16,7060u16),
(59077u16,7061u16),(59078u16,7062u16),(59079u16,7063u16),(59080u16,7064u16),
(59081u16,7065u16),(59082u16,7066u16),(59083u16,7067u16),(59084u16,7068u16),
(59085u16,7069u16),(59086u16,7070u16),(59087u16,7071u16),(59088u16,7072u16),
(59089u16,7073u16),(59090u16,7074u16),(59091u16,7075u16),(59092u16,7076u16),
(59093u16,7077u16),(59094u16,7078u16),(59095u16,7079u16),(59096u16,7080u16),
(59097u16,7081u16),(59098u16,7082u16),(59099u16,7083u16),(59100u16,7084u16),
(59101u16,7085u16),(59102u16,7086u16),(59103u16,7087u16),(59104u16,7088u16),
(59105u16,7089u16),(59106u16,7090u16),(59107u16,7091u16),(59108u16,7092u16),
(59109u16,7093u16),(59110u16,7094u16),(59111u16,7095u16),(59112u16,7096u16),
(59113u16,7097u16),(59114u16,7098u16),(59115u16,7099u16),(59116u16,7100u16),
(59117u16,7101u16),(59118u16,7102u16),(59119u16,7103u16),(59120u16,7104u16),
(59121u16,7105u16),(59122u16,7106u16),(59123u16,7107u16),(59124u16,7108u16),
(59125u16,7109u16),(59126u16,7110u16),(59127u16,7111u16),(59128u16,7112u16),
(59129u16,7113u16),(59130u16,7114u16),(59131u16,7115u16),(59132u16,7116u16),
(59133u16,7117u16),(59134u16,7118u16),(59135u16,7119u16),(59136u16,7120u16),
(59137u16,7121u16),(59138u16,7122u16),(59139u16,7123u16),(59140u16,7124u16),
(59141u16,7125u16),(59142u16,7220u16),(59143u16,7221u16),(59144u16,7222u16),
(59145u16,7223u16),(59146u16,7224u16),(59147u16,7225u16),(59148u16,7226u16),
(59149u16,7227u16),(59150u16,7228u16),(59151u16,7229u16),(59152u16,7230u16),
(59153u16,7231u16),(59154u16,7232u16),(59155u16,7233u16),(59156u16,7234u16),
(59157u16,7235u16),(59158u16,7236u16),(59159u16,7237u16),(59160u16,7238u16),
(59161u16,7239u16),(59162u16,7240u16),(59163u16,7241u16),(59164u16,7242u16),
(59165u16,7243u16),(59166u16,7244u16),(59167u16,7245u16),(59168u16,7246u16),
(59169u16,7247u16),(59170u16,7248u16),(59171u16,7249u16),(59172u16,7250u16),
(59173u16,7251u16),(59174u16,7252u16),(59175u16,7253u16),(59176u16,7254u16),
(59177u16,7255u16),(59178u16,7256u16),(59179u16,7257u16),(59180u16,7258u16),
(59181u16,7259u16),(59182u16,7260u16),(59183u16,7261u16),(59184u16,7262u16),
(59185u16,7263u16),(59186u16,7264u16),(59187u16,7265u16),(59188u16,7266u16),
(59189u16,7267u16),(59190u16,7268u16),(59191u16,7269u16),(59192u16,7270u16),
(59193u16,7271u16),(59194u16,7272u16),(59195u16,7273u16),(59196u16,7274u16),
(59197u16,7275u16),(59198u16,7276u16),(59199u16,7277u16),(59200u16,7278u16),
(59201u16,7279u16),(59202u16,7280u16),(59203u16,7281u16),(59204u16,7282u16),
(59205u16,7283u16),(59206u16,7284u16),(59207u16,7285u16),(59208u16,7286u16),
(59209u16,7287u16),(59210u16,7288u16),(59211u16,7289u16),(59212u16,7290u16),
(59213u16,7291u16),(59214u16,7292u16),(59215u16,7293u16),(59216u16,7294u16),
(59217u16,7295u16),(59218u16,7296u16),(59219u16,7297u16),(59220u16,7298u16),
(59221u16,7299u16),(59222u16,7300u16),(59223u16,7301u16),(59224u16,7302u16),
(59225u16,7303u16),(59226u16,7304u16),(59227u16,7305u16),(59228u16,7306u16),
(59229u16,7307u16),(59230u16,7308u16),(59231u16,7309u16),(59232u16,7310u16),
(59233u16,7311u16),(59234u16,7312u16),(59235u16,7313u16),(59236u16,7314u16),
(59237u16,7315u16),(59238u16,6376u16),(59239u16,6377u16),(59240u16,6378u16),
(59241u16,6379u16),(59242u16,6380u16),(59243u16,6381u16),(59245u16,6433u16),
(59246u16,6444u16),(59247u16,6445u16),(59248u16,6458u16),(59249u16,6459u16),
(59250u16,6829u16),(59251u16,6830u16),(59252u16,6831u16),(59253u16,6832u16),
(59254u16,6833u16),(59255u16,6834u16),(59256u16,6835u16),(59257u16,6836u16),
(59258u16,6837u16),(59259u16,6838u16),(59260u16,6839u16),(59261u16,7022u16),
(59262u16,7023u16),(59263u16,7024u16),(59264u16,7025u16),(59265u16,7026u16),
(59266u16,7027u16),(59267u16,7028u16),(59268u16,7029u16),(59269u16,7150u16),
(59270u16,7151u16),(59271u16,7152u16),(59272u16,7153u16),(59273u16,7154u16),
(59274u16,7155u16),(59275u16,7156u16),(59276u16,7157u16),(59287u16,7211u16),
(59288u16,7212u16),(59289u16,7213u16),(59290u16,7214u16),(59291u16,7215u16),
(59292u16,7216u16),(59293u16,7217u16),(59294u16,7218u16),(59295u16,7219u16),
(59296u16,7349u16),(59297u16,7350u16),(59298u16,7351u16),(59299u16,7352u16),
(59300u16,7353u16),(59301u16,7354u16),(59302u16,7355u16),(59303u16,7356u16),
(59304u16,7357u16),(59305u16,7358u16),(59306u16,7359u16),(59307u16,7360u16),
(59308u16,7361u16),(59309u16,7362u16),(59310u16,7363u16),(59311u16,7397u16),
(59312u16,7398u16),(59313u16,7399u16),(59314u16,7400u16),(59315u16,7401u16),
(59316u16,7402u16),(59317u16,7403u16),(59318u16,7404u16),(59319u16,7405u16),
(59320u16,7406u16),(59321u16,7407u16),(59322u16,7408u16),(59323u16,7409u16),
(59324u16,7495u16),(59325u16,7496u16),(59326u16,7497u16),(59327u16,7498u16),
(59328u16,7499u16),(59329u16,7500u16),(59330u16,7501u16),(59331u16,7502u16),
(59332u16,7503u16),(59333u16,7504u16),(59334u16,7505u16),(59337u16,7538u16),
(59338u16,7539u16),(59339u16,7540u16),(59340u16,7541u16),(59341u16,7579u16),
(59342u16,7580u16),(59343u16,7581u16),(59344u16,7582u16),(59345u16,7583u16),
(59346u16,7584u16),(59347u16,7585u16),(59348u16,7586u16),(59349u16,7587u16),
(59350u16,7588u16),(59351u16,7589u16),(59352u16,7590u16),(59353u16,7591u16),
(59354u16,7592u16),(59355u16,7593u16),(59356u16,7594u16),(59357u16,7595u16),
(59358u16,7596u16),(59359u16,7597u16),(59360u16,7598u16),(59361u16,7599u16),
(59362u16,7624u16),(59363u16,7627u16),(59364u16,7629u16),(59365u16,7630u16),
(59366u16,7631u16),(59380u16,7686u16),(59381u16,7687u16),(59382u16,7688u16),
(59383u16,7689u16),(59384u16,7690u16),(59385u16,7691u16),(59386u16,7692u16),
(59387u16,7693u16),(59388u16,7694u16),(59389u16,7695u16),(59390u16,7696u16),
(59391u16,7697u16),(59392u16,7698u16),(59393u16,7775u16),(59394u16,7776u16),
(59395u16,7777u16),(59396u16,7778u16),(59397u16,7779u16),(59398u16,7780u16),
(59399u16,7781u16),(59400u16,7782u16),(59401u16,7783u16),(59402u16,7784u16),
(59403u16,7785u16),(59404u16,7786u16),(59405u16,7787u16),(59406u16,7788u16),
(59407u16,7789u16),(59408u16,16525u16),(59409u16,16526u16),(59410u16,16527u16),
(59411u16,16528u16),(59412u16,16529u16),(59414u16,23767u16),(59415u16,23768u16),
(59416u16,23769u16),(59441u16,23794u16),(59451u16,23804u16),(59477u16,23830u16),
(63788u16,23651u16),(63865u16,23652u16),(63893u16,23653u16),(63975u16,23654u16),
(63985u16,23655u16),(64012u16,23750u16),(64013u16,23751u16),(64014u16,23752u16),
(64015u16,23753u16),(64017u16,23754u16),(64019u16,23755u16),(64020u16,23756u16),
(64024u16,23757u16),(64031u16,23758u16),(64032u16,23759u16),(64033u16,23760u16),
(64035u16,23761u16),(64036u16,23762u16),(64039u16,23763u16),(64040u16,23764u16),
(64041u16,23765u16),(65040u16,7182u16),(65041u16,7184u16),(65042u16,7183u16),
(65043u16,7185u16),(65044u16,7186u16),(65045u16,7187u16),(65046u16,7188u16),
(65047u16,7201u16),(65048u16,7202u16),(65049u16,7208u16),(65072u16,7621u16),
(65073u16,7207u16),(65075u16,7209u16),(65076u16,7210u16),(65077u16,7189u16),
(65078u16,7190u16),(65079u16,7205u16),(65080u16,7206u16),(65081u16,7191u16),
(65082u16,7192u16),(65083u16,7203u16),(65084u16,7204u16),(65085u16,7195u16),
(65086u16,7196u16),(65087u16,7193u16),(65088u16,7194u16),(65089u16,7197u16),
(65090u16,7198u16),(65091u16,7199u16),(65092u16,7200u16),(65097u16,7640u16),
(65098u16,7641u16),(65099u16,7642u16),(65100u16,7643u16),(65101u16,7644u16),
(65102u16,7645u16),(65103u16,7646u16),(65104u16,7647u16),(65105u16,7648u16),
(65106u16,7649u16),(65108u16,7650u16),(65109u16,7651u16),(65110u16,7652u16),
(65111u16,7653u16),(65113u16,7654u16),(65114u16,7655u16),(65115u16,7656u16),
(65116u16,7657u16),(65117u16,7658u16),(65118u16,7659u16),(65119u16,7660u16),
(65120u16,7661u16),(65121u16,7662u16),(65122u16,7663u16),(65123u16,7664u16),
(65124u16,7665u16),(65125u16,7666u16),(65126u16,7667u16),(65128u16,7668u16),
(65129u16,7669u16),(65130u16,7670u16),(65131u16,7671u16),(65281u16,6556u16),
(65282u16,6557u16),(65283u16,6558u16),(65284u16,6246u16),(65285u16,6560u16),
(65286u16,6561u16),(65287u16,6562u16),(65288u16,6563u16),(65289u16,6564u16),
(65290u16,6565u16),(65291u16,6566u16),(65292u16,6567u16),(65293u16,6568u16),
(65294u16,6569u16),(65295u16,6570u16),(65296u16,6571u16),(65297u16,6572u16),
(65298u16,6573u16),(65299u16,6574u16),(65300u16,6575u16),(65301u16,6576u16),
(65302u16,6577u16),(65303u16,6578u16),(65304u16,6579u16),(65305u16,6580u16),
(65306u16,6581u16),(65307u16,6582u16),(65308u16,6583u16),(65309u16,6584u16),
(65310u16,6585u16),(65311u16,6586u16),(65312u16,6587u16),(65313u16,6588u16),
(65314u16,6589u16),(65315u16,6590u16),(65316u16,6591u16),(65317u16,6592u16),
(65318u16,6593u16),(65319u16,6594u16),(65320u16,6595u16),(65321u16,6596u16),
(65322u16,6597u16),(65323u16,6598u16),(65324u16,6599u16),(65325u16,6600u16),
(65326u16,6601u16),(65327u16,6602u16),(65328u16,6603u16),(65329u16,6604u16),
(65330u16,6605u16),(65331u16,6606u16),(65332u16,6607u16),(65333u16,6608u16),
(65334u16,6609u16),(65335u16,6610u16),(65336u16,6611u16),(65337u16,6612u16),
(65338u16,6613u16),(65339u16,6614u16),(65340u16,6615u16),(65341u16,6616u16),
(65342u16,6617u16),(65343u16,6618u16),(65344u16,6619u16),(65345u16,6620u16),
(65346u16,6621u16),(65347u16,6622u16),(65348u16,6623u16),(65349u16,6624u16),
(65350u16,6625u16),(65351u16,6626u16),(65352u16,6627u16),(65353u16,6628u16),
(65354u16,6629u16),(65355u16,6630u16),(65356u16,6631u16),(65357u16,6632u16),
(65358u16,6633u16),(65359u16,6634u16),(65360u16,6635u16),(65361u16,6636u16),
(65362u16,6637u16),(65363u16,6638u16),(65364u16,6639u16),(65365u16,6640u16),
(65366u16,6641u16),(65367u16,6642u16),(65368u16,6643u16),(65369u16,6644u16),
(65370u16,6645u16),(65371u16,6646u16),(65372u16,6647u16),(65373u16,6648u16),
(65374u16,6186u16),(65504u16,6248u16),(65505u16,6249u16),(65506u16,7622u16),
(65507u16,6649u16),(65508u16,7623u16),(65509u16,6559u16),
]

const Jis0208Decode*: array[8096, uint16] = [
uint16 12288,12289,12290,65292,65294,12539,65306,65307,65311,65281,12443,12444,
180,65344,168,65342,65507,65343,12541,12542,12445,12446,12291,20189,12293,12294,
12295,12540,8213,8208,65295,65340,65374,8741,65372,8230,8229,8216,8217,8220,
8221,65288,65289,12308,12309,65339,65341,65371,65373,12296,12297,12298,12299,
12300,12301,12302,12303,12304,12305,65291,65293,177,215,247,65309,8800,65308,
65310,8806,8807,8734,8756,9794,9792,176,8242,8243,8451,65509,65284,65504,65505,
65285,65283,65286,65290,65312,167,9734,9733,9675,9679,9678,9671,9670,9633,9632,
9651,9650,9661,9660,8251,12306,8594,8592,8593,8595,12307,0,0,0,0,0,0,0,0,0,0,0,
8712,8715,8838,8839,8834,8835,8746,8745,0,0,0,0,0,0,0,0,8743,8744,65506,8658,
8660,8704,8707,0,0,0,0,0,0,0,0,0,0,0,8736,8869,8978,8706,8711,8801,8786,8810,
8811,8730,8765,8733,8757,8747,8748,0,0,0,0,0,0,0,8491,8240,9839,9837,9834,8224,
8225,182,0,0,0,0,9711,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65296,65297,65298,65299,
65300,65301,65302,65303,65304,65305,0,0,0,0,0,0,0,65313,65314,65315,65316,65317,
65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,
65331,65332,65333,65334,65335,65336,65337,65338,0,0,0,0,0,0,65345,65346,65347,
65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,65358,65359,65360,
65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,0,0,0,0,12353,12354,
12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,
12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,
12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,
12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,
12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,
12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,
12433,12434,12435,0,0,0,0,0,0,0,0,0,0,0,12449,12450,12451,12452,12453,12454,
12455,12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,
12468,12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,
12481,12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,
12494,12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,
12507,12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,
12520,12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,
12533,12534,0,0,0,0,0,0,0,0,913,914,915,916,917,918,919,920,921,922,923,924,925,
926,927,928,929,931,932,933,934,935,936,937,0,0,0,0,0,0,0,0,945,946,947,948,949,
950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1040,
1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,
1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,
1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,
1097,1098,1099,1100,1101,1102,1103,0,0,0,0,0,0,0,0,0,0,0,0,0,9472,9474,9484,
9488,9496,9492,9500,9516,9508,9524,9532,9473,9475,9487,9491,9499,9495,9507,9523,
9515,9531,9547,9504,9519,9512,9527,9535,9501,9520,9509,9528,9538,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,
9322,9323,9324,9325,9326,9327,9328,9329,9330,9331,8544,8545,8546,8547,8548,8549,
8550,8551,8552,8553,0,13129,13076,13090,13133,13080,13095,13059,13110,13137,
13143,13069,13094,13091,13099,13130,13115,13212,13213,13214,13198,13199,13252,
13217,0,0,0,0,0,0,0,0,13179,12317,12319,8470,13261,8481,12964,12965,12966,12967,
12968,12849,12850,12857,13182,13181,13180,8786,8801,8747,8750,8721,8730,8869,
8736,8735,8895,8757,8745,8746,0,0,20124,21782,23043,38463,21696,24859,25384,
23030,36898,33909,33564,31312,24746,25569,28197,26093,33894,33446,39925,26771,
22311,26017,25201,23451,22992,34427,39156,32098,32190,39822,25110,31903,34999,
23433,24245,25353,26263,26696,38343,38797,26447,20197,20234,20301,20381,20553,
22258,22839,22996,23041,23561,24799,24847,24944,26131,26885,28858,30031,30064,
31227,32173,32239,32963,33806,34915,35586,36949,36986,21307,20117,20133,22495,
32946,37057,30959,19968,22769,28322,36920,31282,33576,33419,39983,20801,21360,
21693,21729,22240,23035,24341,39154,28139,32996,34093,38498,38512,38560,38907,
21515,21491,23431,28879,32701,36802,38632,21359,40284,31418,19985,30867,33276,
28198,22040,21764,27421,34074,39995,23013,21417,28006,29916,38287,22082,20113,
36939,38642,33615,39180,21473,21942,23344,24433,26144,26355,26628,27704,27891,
27945,29787,30408,31310,38964,33521,34907,35424,37613,28082,30123,30410,39365,
24742,35585,36234,38322,27022,21421,20870,22290,22576,22852,23476,24310,24616,
25513,25588,27839,28436,28814,28948,29017,29141,29503,32257,33398,33489,34199,
36960,37467,40219,22633,26044,27738,29989,20985,22830,22885,24448,24540,25276,
26106,27178,27431,27572,29579,32705,35158,40236,40206,40644,23713,27798,33659,
20740,23627,25014,33222,26742,29281,20057,20474,21368,24681,28201,31311,38899,
19979,21270,20206,20309,20285,20385,20339,21152,21487,22025,22799,23233,23478,
23521,31185,26247,26524,26550,27468,27827,28779,29634,31117,31166,31292,31623,
33457,33499,33540,33655,33775,33747,34662,35506,22057,36008,36838,36942,38686,
34442,20420,23784,25105,29273,30011,33253,33469,34558,36032,38597,39187,39381,
20171,20250,35299,22238,22602,22730,24315,24555,24618,24724,24674,25040,25106,
25296,25913,39745,26214,26800,28023,28784,30028,30342,32117,33445,34809,38283,
38542,35997,20977,21182,22806,21683,23475,23830,24936,27010,28079,30861,33995,
34903,35442,37799,39608,28012,39336,34521,22435,26623,34510,37390,21123,22151,
21508,24275,25313,25785,26684,26680,27579,29554,30906,31339,35226,35282,36203,
36611,37101,38307,38548,38761,23398,23731,27005,38989,38990,25499,31520,27179,
27263,26806,39949,28511,21106,21917,24688,25324,27963,28167,28369,33883,35088,
36676,19988,39993,21494,26907,27194,38788,26666,20828,31427,33970,37340,37772,
22107,40232,26658,33541,33841,31909,21000,33477,29926,20094,20355,20896,23506,
21002,21208,21223,24059,21914,22570,23014,23436,23448,23515,24178,24185,24739,
24863,24931,25022,25563,25954,26577,26707,26874,27454,27475,27735,28450,28567,
28485,29872,29976,30435,30475,31487,31649,31777,32233,32566,32752,32925,33382,
33694,35251,35532,36011,36996,37969,38291,38289,38306,38501,38867,39208,33304,
20024,21547,23736,24012,29609,30284,30524,23721,32747,36107,38593,38929,38996,
39000,20225,20238,21361,21916,22120,22522,22855,23305,23492,23696,24076,24190,
24524,25582,26426,26071,26082,26399,26827,26820,27231,24112,27589,27671,27773,
30079,31048,23395,31232,32000,24509,35215,35352,36020,36215,36556,36637,39138,
39438,39740,20096,20605,20736,22931,23452,25135,25216,25836,27450,29344,30097,
31047,32681,34811,35516,35696,25516,33738,38816,21513,21507,21931,26708,27224,
35440,30759,26485,40653,21364,23458,33050,34384,36870,19992,20037,20167,20241,
21450,21560,23470,24339,24613,25937,26429,27714,27762,27875,28792,29699,31350,
31406,31496,32026,31998,32102,26087,29275,21435,23621,24040,25298,25312,25369,
28192,34394,35377,36317,37624,28417,31142,39770,20136,20139,20140,20379,20384,
20689,20807,31478,20849,20982,21332,21281,21375,21483,21932,22659,23777,24375,
24394,24623,24656,24685,25375,25945,27211,27841,29378,29421,30703,33016,33029,
33288,34126,37111,37857,38911,39255,39514,20208,20957,23597,26241,26989,23616,
26354,26997,29577,26704,31873,20677,21220,22343,24062,37670,26020,27427,27453,
29748,31105,31165,31563,32202,33465,33740,34943,35167,35641,36817,37329,21535,
37504,20061,20534,21477,21306,29399,29590,30697,33510,36527,39366,39368,39378,
20855,24858,34398,21936,31354,20598,23507,36935,38533,20018,27355,37351,23633,
23624,25496,31391,27795,38772,36705,31402,29066,38536,31874,26647,32368,26705,
37740,21234,21531,34219,35347,32676,36557,37089,21350,34952,31041,20418,20670,
21009,20804,21843,22317,29674,22411,22865,24418,24452,24693,24950,24935,25001,
25522,25658,25964,26223,26690,28179,30054,31293,31995,32076,32153,32331,32619,
33550,33610,34509,35336,35427,35686,36605,38938,40335,33464,36814,39912,21127,
25119,25731,28608,38553,26689,20625,27424,27770,28500,31348,32080,34880,35363,
26376,20214,20537,20518,20581,20860,21048,21091,21927,22287,22533,23244,24314,
25010,25080,25331,25458,26908,27177,29309,29356,29486,30740,30831,32121,30476,
32937,35211,35609,36066,36562,36963,37749,38522,38997,39443,40568,20803,21407,
21427,24187,24358,28187,28304,29572,29694,32067,33335,35328,35578,38480,20046,
20491,21476,21628,22266,22993,23396,24049,24235,24359,25144,25925,26543,28246,
29392,31946,34996,32929,32993,33776,34382,35463,36328,37431,38599,39015,40723,
20116,20114,20237,21320,21577,21566,23087,24460,24481,24735,26791,27278,29786,
30849,35486,35492,35703,37264,20062,39881,20132,20348,20399,20505,20502,20809,
20844,21151,21177,21246,21402,21475,21521,21518,21897,22353,22434,22909,23380,
23389,23439,24037,24039,24055,24184,24195,24218,24247,24344,24658,24908,25239,
25304,25511,25915,26114,26179,26356,26477,26657,26775,27083,27743,27946,28009,
28207,28317,30002,30343,30828,31295,31968,32005,32024,32094,32177,32789,32771,
32943,32945,33108,33167,33322,33618,34892,34913,35611,36002,36092,37066,37237,
37489,30783,37628,38308,38477,38917,39321,39640,40251,21083,21163,21495,21512,
22741,25335,28640,35946,36703,40633,20811,21051,21578,22269,31296,37239,40288,
40658,29508,28425,33136,29969,24573,24794,39592,29403,36796,27492,38915,20170,
22256,22372,22718,23130,24680,25031,26127,26118,26681,26801,28151,30165,32058,
33390,39746,20123,20304,21449,21766,23919,24038,24046,26619,27801,29811,30722,
35408,37782,35039,22352,24231,25387,20661,20652,20877,26368,21705,22622,22971,
23472,24425,25165,25505,26685,27507,28168,28797,37319,29312,30741,30758,31085,
25998,32048,33756,35009,36617,38555,21092,22312,26448,32618,36001,20916,22338,
38442,22586,27018,32948,21682,23822,22524,30869,40442,20316,21066,21643,25662,
26152,26388,26613,31364,31574,32034,37679,26716,39853,31545,21273,20874,21047,
23519,25334,25774,25830,26413,27578,34217,38609,30352,39894,25420,37638,39851,
30399,26194,19977,20632,21442,23665,24808,25746,25955,26719,29158,29642,29987,
31639,32386,34453,35715,36059,37240,39184,26028,26283,27531,20181,20180,20282,
20351,21050,21496,21490,21987,22235,22763,22987,22985,23039,23376,23629,24066,
24107,24535,24605,25351,25903,23388,26031,26045,26088,26525,27490,27515,27663,
29509,31049,31169,31992,32025,32043,32930,33026,33267,35222,35422,35433,35430,
35468,35566,36039,36060,38604,39164,27503,20107,20284,20365,20816,23383,23546,
24904,25345,26178,27425,28363,27835,29246,29885,30164,30913,31034,32780,32819,
33258,33940,36766,27728,40575,24335,35672,40235,31482,36600,23437,38635,19971,
21489,22519,22833,23241,23460,24713,28287,28422,30142,36074,23455,34048,31712,
20594,26612,33437,23649,34122,32286,33294,20889,23556,25448,36198,26012,29038,
31038,32023,32773,35613,36554,36974,34503,37034,20511,21242,23610,26451,28796,
29237,37196,37320,37675,33509,23490,24369,24825,20027,21462,23432,25163,26417,
27530,29417,29664,31278,33131,36259,37202,39318,20754,21463,21610,23551,25480,
27193,32172,38656,22234,21454,21608,23447,23601,24030,20462,24833,25342,27954,
31168,31179,32066,32333,32722,33261,33311,33936,34886,35186,35728,36468,36655,
36913,37195,37228,38598,37276,20160,20303,20805,21313,24467,25102,26580,27713,
28171,29539,32294,37325,37507,21460,22809,23487,28113,31069,32302,31899,22654,
29087,20986,34899,36848,20426,23803,26149,30636,31459,33308,39423,20934,24490,
26092,26991,27529,28147,28310,28516,30462,32020,24033,36981,37255,38918,20966,
21021,25152,26257,26329,28186,24246,32210,32626,26360,34223,34295,35576,21161,
21465,22899,24207,24464,24661,37604,38500,20663,20767,21213,21280,21319,21484,
21736,21830,21809,22039,22888,22974,23100,23477,23558,23567,23569,23578,24196,
24202,24288,24432,25215,25220,25307,25484,25463,26119,26124,26157,26230,26494,
26786,27167,27189,27836,28040,28169,28248,28988,28966,29031,30151,30465,30813,
30977,31077,31216,31456,31505,31911,32057,32918,33750,33931,34121,34909,35059,
35359,35388,35412,35443,35937,36062,37284,37478,37758,37912,38556,38808,19978,
19976,19998,20055,20887,21104,22478,22580,22732,23330,24120,24773,25854,26465,
26454,27972,29366,30067,31331,33976,35698,37304,37664,22065,22516,39166,25325,
26893,27542,29165,32340,32887,33394,35302,39135,34645,36785,23611,20280,20449,
20405,21767,23072,23517,23529,24515,24910,25391,26032,26187,26862,27035,28024,
28145,30003,30137,30495,31070,31206,32051,33251,33455,34218,35242,35386,36523,
36763,36914,37341,38663,20154,20161,20995,22645,22764,23563,29978,23613,33102,
35338,36805,38499,38765,31525,35535,38920,37218,22259,21416,36887,21561,22402,
24101,25512,27700,28810,30561,31883,32736,34928,36930,37204,37648,37656,38543,
29790,39620,23815,23913,25968,26530,36264,38619,25454,26441,26905,33733,38935,
38592,35070,28548,25722,23544,19990,28716,30045,26159,20932,21046,21218,22995,
24449,24615,25104,25919,25972,26143,26228,26866,26646,27491,28165,29298,29983,
30427,31934,32854,22768,35069,35199,35488,35475,35531,36893,37266,38738,38745,
25993,31246,33030,38587,24109,24796,25114,26021,26132,26512,30707,31309,31821,
32318,33034,36012,36196,36321,36447,30889,20999,25305,25509,25666,25240,35373,
31363,31680,35500,38634,32118,33292,34633,20185,20808,21315,21344,23459,23554,
23574,24029,25126,25159,25776,26643,26676,27849,27973,27927,26579,28508,29006,
29053,26059,31359,31661,32218,32330,32680,33146,33307,33337,34214,35438,36046,
36341,36984,36983,37549,37521,38275,39854,21069,21892,28472,28982,20840,31109,
32341,33203,31950,22092,22609,23720,25514,26366,26365,26970,29401,30095,30094,
30990,31062,31199,31895,32032,32068,34311,35380,38459,36961,40736,20711,21109,
21452,21474,20489,21930,22766,22863,29245,23435,23652,21277,24803,24819,25436,
25475,25407,25531,25805,26089,26361,24035,27085,27133,28437,29157,20105,30185,
30456,31379,31967,32207,32156,32865,33609,33624,33900,33980,34299,35013,36208,
36865,36973,37783,38684,39442,20687,22679,24974,33235,34101,36104,36896,20419,
20596,21063,21363,24687,25417,26463,28204,36275,36895,20439,23646,36042,26063,
32154,21330,34966,20854,25539,23384,23403,23562,25613,26449,36956,20182,22810,
22826,27760,35409,21822,22549,22949,24816,25171,26561,33333,26965,38464,39364,
39464,20307,22534,23550,32784,23729,24111,24453,24608,24907,25140,26367,27888,
28382,32974,33151,33492,34955,36024,36864,36910,38538,40667,39899,20195,21488,
22823,31532,37261,38988,40441,28381,28711,21331,21828,23429,25176,25246,25299,
27810,28655,29730,35351,37944,28609,35582,33592,20967,34552,21482,21481,20294,
36948,36784,22890,33073,24061,31466,36799,26842,35895,29432,40008,27197,35504,
20025,21336,22022,22374,25285,25506,26086,27470,28129,28251,28845,30701,31471,
31658,32187,32829,32966,34507,35477,37723,22243,22727,24382,26029,26262,27264,
27573,30007,35527,20516,30693,22320,24347,24677,26234,27744,30196,31258,32622,
33268,34584,36933,39347,31689,30044,31481,31569,33988,36880,31209,31378,33590,
23265,30528,20013,20210,23449,24544,25277,26172,26609,27880,34411,34935,35387,
37198,37619,39376,27159,28710,29482,33511,33879,36015,19969,20806,20939,21899,
23541,24086,24115,24193,24340,24373,24427,24500,25074,25361,26274,26397,28526,
29266,30010,30522,32884,33081,33144,34678,35519,35548,36229,36339,37530,38263,
38914,40165,21189,25431,30452,26389,27784,29645,36035,37806,38515,27941,22684,
26894,27084,36861,37786,30171,36890,22618,26626,25524,27131,20291,28460,26584,
36795,34086,32180,37716,26943,28528,22378,22775,23340,32044,29226,21514,37347,
40372,20141,20302,20572,20597,21059,35998,21576,22564,23450,24093,24213,24237,
24311,24351,24716,25269,25402,25552,26799,27712,30855,31118,31243,32224,33351,
35330,35558,36420,36883,37048,37165,37336,40718,27877,25688,25826,25973,28404,
30340,31515,36969,37841,28346,21746,24505,25764,36685,36845,37444,20856,22635,
22825,23637,24215,28155,32399,29980,36028,36578,39003,28857,20253,27583,28593,
30000,38651,20814,21520,22581,22615,22956,23648,24466,26007,26460,28193,30331,
33759,36077,36884,37117,37709,30757,30778,21162,24230,22303,22900,24594,20498,
20826,20908,20941,20992,21776,22612,22616,22871,23445,23798,23947,24764,25237,
25645,26481,26691,26812,26847,30423,28120,28271,28059,28783,29128,24403,30168,
31095,31561,31572,31570,31958,32113,21040,33891,34153,34276,35342,35588,35910,
36367,36867,36879,37913,38518,38957,39472,38360,20685,21205,21516,22530,23566,
24999,25758,27934,30643,31461,33012,33796,36947,37509,23776,40199,21311,24471,
24499,28060,29305,30563,31167,31716,27602,29420,35501,26627,27233,20984,31361,
26932,23626,40182,33515,23493,37193,28702,22136,23663,24775,25958,27788,35930,
36929,38931,21585,26311,37389,22856,37027,20869,20045,20970,34201,35598,28760,
25466,37707,26978,39348,32260,30071,21335,26976,36575,38627,27741,20108,23612,
24336,36841,21250,36049,32905,34425,24319,26085,20083,20837,22914,23615,38894,
20219,22922,24525,35469,28641,31152,31074,23527,33905,29483,29105,24180,24565,
25467,25754,29123,31896,20035,24316,20043,22492,22178,24745,28611,32013,33021,
33075,33215,36786,35223,34468,24052,25226,25773,35207,26487,27874,27966,29750,
30772,23110,32629,33453,39340,20467,24259,25309,25490,25943,26479,30403,29260,
32972,32954,36649,37197,20493,22521,23186,26757,26995,29028,29437,36023,22770,
36064,38506,36889,34687,31204,30695,33833,20271,21093,21338,25293,26575,27850,
30333,31636,31893,33334,34180,36843,26333,28448,29190,32283,33707,39361,40614,
20989,31665,30834,31672,32903,31560,27368,24161,32908,30033,30048,20843,37474,
28300,30330,37271,39658,20240,32624,25244,31567,38309,40169,22138,22617,34532,
38588,20276,21028,21322,21453,21467,24070,25644,26001,26495,27710,27726,29256,
29359,29677,30036,32321,33324,34281,36009,31684,37318,29033,38930,39151,25405,
26217,30058,30436,30928,34115,34542,21290,21329,21542,22915,24199,24444,24754,
25161,25209,25259,26000,27604,27852,30130,30382,30865,31192,32203,32631,32933,
34987,35513,36027,36991,38750,39131,27147,31800,20633,23614,24494,26503,27608,
29749,30473,32654,40763,26570,31255,21305,30091,39661,24422,33181,33777,32920,
24380,24517,30050,31558,36924,26727,23019,23195,32016,30334,35628,20469,24426,
27161,27703,28418,29922,31080,34920,35413,35961,24287,25551,30149,31186,33495,
37672,37618,33948,34541,39981,21697,24428,25996,27996,28693,36007,36051,38971,
25935,29942,19981,20184,22496,22827,23142,23500,20904,24067,24220,24598,25206,
25975,26023,26222,28014,29238,31526,33104,33178,33433,35676,36000,36070,36212,
38428,38468,20398,25771,27494,33310,33889,34154,37096,23553,26963,39080,33914,
34135,20239,21103,24489,24133,26381,31119,33145,35079,35206,28149,24343,25173,
27832,20175,29289,39826,20998,21563,22132,22707,24996,25198,28954,22894,31881,
31966,32027,38640,25991,32862,19993,20341,20853,22592,24163,24179,24330,26564,
20006,34109,38281,38491,31859,38913,20731,22721,30294,30887,21029,30629,34065,
31622,20559,22793,29255,31687,32232,36794,36820,36941,20415,21193,23081,24321,
38829,20445,33303,37610,22275,25429,27497,29995,35036,36628,31298,21215,22675,
24917,25098,26286,27597,31807,33769,20515,20472,21253,21574,22577,22857,23453,
23792,23791,23849,24214,25265,25447,25918,26041,26379,27861,27873,28921,30770,
32299,32990,33459,33804,34028,34562,35090,35370,35914,37030,37586,39165,40179,
40300,20047,20129,20621,21078,22346,22952,24125,24536,24537,25151,26292,26395,
26576,26834,20882,32033,32938,33192,35584,35980,36031,37502,38450,21536,38956,
21271,20693,21340,22696,25778,26420,29287,30566,31302,37350,21187,27809,27526,
22528,24140,22868,26412,32763,20961,30406,25705,30952,39764,40635,22475,22969,
26151,26522,27598,21737,27097,24149,33180,26517,39850,26622,40018,26717,20134,
20451,21448,25273,26411,27819,36804,20397,32365,40639,19975,24930,28288,28459,
34067,21619,26410,39749,24051,31637,23724,23494,34588,28234,34001,31252,33032,
22937,31885,27665,30496,21209,22818,28961,29279,30683,38695,40289,26891,23167,
23064,20901,21517,21629,26126,30431,36855,37528,40180,23018,29277,28357,20813,
26825,32191,32236,38754,40634,25720,27169,33538,22916,23391,27611,29467,30450,
32178,32791,33945,20786,26408,40665,30446,26466,21247,39173,23588,25147,31870,
36016,21839,24758,32011,38272,21249,20063,20918,22812,29242,32822,37326,24357,
30690,21380,24441,32004,34220,35379,36493,38742,26611,34222,37971,24841,24840,
27833,30290,35565,36664,21807,20305,20778,21191,21451,23461,24189,24736,24962,
25558,26377,26586,28263,28044,29494,29495,30001,31056,35029,35480,36938,37009,
37109,38596,34701,22805,20104,20313,19982,35465,36671,38928,20653,24188,22934,
23481,24248,25562,25594,25793,26332,26954,27096,27915,28342,29076,29992,31407,
32650,32768,33865,33993,35201,35617,36362,36965,38525,39178,24958,25233,27442,
27779,28020,32716,32764,28096,32645,34746,35064,26469,33713,38972,38647,27931,
32097,33853,37226,20081,21365,23888,27396,28651,34253,34349,35239,21033,21519,
23653,26446,26792,29702,29827,30178,35023,35041,37324,38626,38520,24459,29575,
31435,33870,25504,30053,21129,27969,28316,29705,30041,30827,31890,38534,31452,
40845,20406,24942,26053,34396,20102,20142,20698,20001,20940,23534,26009,26753,
28092,29471,30274,30637,31260,31975,33391,35538,36988,37327,38517,38936,21147,
32209,20523,21400,26519,28107,29136,29747,33256,36650,38563,40023,40607,29792,
22593,28057,32047,39006,20196,20278,20363,20919,21169,23994,24604,29618,31036,
33491,37428,38583,38646,38666,40599,40802,26278,27508,21015,21155,28872,35010,
24265,24651,24976,28451,29001,31806,32244,32879,34030,36899,37676,21570,39791,
27347,28809,36034,36335,38706,21172,23105,24266,24324,26391,27004,27028,28010,
28431,29282,29436,31725,32769,32894,34635,37070,20845,40595,31108,32907,37682,
35542,20525,21644,35441,27498,36036,33031,24785,26528,40434,20121,20120,39952,
35435,34241,34152,26880,28286,30871,33109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24332,19984,19989,20010,20017,
20022,20028,20031,20034,20054,20056,20098,20101,35947,20106,33298,24333,20110,
20126,20127,20128,20130,20144,20147,20150,20174,20173,20164,20166,20162,20183,
20190,20205,20191,20215,20233,20314,20272,20315,20317,20311,20295,20342,20360,
20367,20376,20347,20329,20336,20369,20335,20358,20374,20760,20436,20447,20430,
20440,20443,20433,20442,20432,20452,20453,20506,20520,20500,20522,20517,20485,
20252,20470,20513,20521,20524,20478,20463,20497,20486,20547,20551,26371,20565,
20560,20552,20570,20566,20588,20600,20608,20634,20613,20660,20658,20681,20682,
20659,20674,20694,20702,20709,20717,20707,20718,20729,20725,20745,20737,20738,
20758,20757,20756,20762,20769,20794,20791,20796,20795,20799,20800,20818,20812,
20820,20834,31480,20841,20842,20846,20864,20866,22232,20876,20873,20879,20881,
20883,20885,20886,20900,20902,20898,20905,20906,20907,20915,20913,20914,20912,
20917,20925,20933,20937,20955,20960,34389,20969,20973,20976,20981,20990,20996,
21003,21012,21006,21031,21034,21038,21043,21049,21071,21060,21067,21068,21086,
21076,21098,21108,21097,21107,21119,21117,21133,21140,21138,21105,21128,21137,
36776,36775,21164,21165,21180,21173,21185,21197,21207,21214,21219,21222,39149,
21216,21235,21237,21240,21241,21254,21256,30008,21261,21264,21263,21269,21274,
21283,21295,21297,21299,21304,21312,21318,21317,19991,21321,21325,20950,21342,
21353,21358,22808,21371,21367,21378,21398,21408,21414,21413,21422,21424,21430,
21443,31762,38617,21471,26364,29166,21486,21480,21485,21498,21505,21565,21568,
21548,21549,21564,21550,21558,21545,21533,21582,21647,21621,21646,21599,21617,
21623,21616,21650,21627,21632,21622,21636,21648,21638,21703,21666,21688,21669,
21676,21700,21704,21672,21675,21698,21668,21694,21692,21720,21733,21734,21775,
21780,21757,21742,21741,21754,21730,21817,21824,21859,21836,21806,21852,21829,
21846,21847,21816,21811,21853,21913,21888,21679,21898,21919,21883,21886,21912,
21918,21934,21884,21891,21929,21895,21928,21978,21957,21983,21956,21980,21988,
21972,22036,22007,22038,22014,22013,22043,22009,22094,22096,29151,22068,22070,
22066,22072,22123,22116,22063,22124,22122,22150,22144,22154,22176,22164,22159,
22181,22190,22198,22196,22210,22204,22209,22211,22208,22216,22222,22225,22227,
22231,22254,22265,22272,22271,22276,22281,22280,22283,22285,22291,22296,22294,
21959,22300,22310,22327,22328,22350,22331,22336,22351,22377,22464,22408,22369,
22399,22409,22419,22432,22451,22436,22442,22448,22467,22470,22484,22482,22483,
22538,22486,22499,22539,22553,22557,22642,22561,22626,22603,22640,27584,22610,
22589,22649,22661,22713,22687,22699,22714,22750,22715,22712,22702,22725,22739,
22737,22743,22745,22744,22757,22748,22756,22751,22767,22778,22777,22779,22780,
22781,22786,22794,22800,22811,26790,22821,22828,22829,22834,22840,22846,31442,
22869,22864,22862,22874,22872,22882,22880,22887,22892,22889,22904,22913,22941,
20318,20395,22947,22962,22982,23016,23004,22925,23001,23002,23077,23071,23057,
23068,23049,23066,23104,23148,23113,23093,23094,23138,23146,23194,23228,23230,
23243,23234,23229,23267,23255,23270,23273,23254,23290,23291,23308,23307,23318,
23346,23248,23338,23350,23358,23363,23365,23360,23377,23381,23386,23387,23397,
23401,23408,23411,23413,23416,25992,23418,23424,23427,23462,23480,23491,23495,
23497,23508,23504,23524,23526,23522,23518,23525,23531,23536,23542,23539,23557,
23559,23560,23565,23571,23584,23586,23592,23608,23609,23617,23622,23630,23635,
23632,23631,23409,23660,23662,20066,23670,23673,23692,23697,23700,22939,23723,
23739,23734,23740,23735,23749,23742,23751,23769,23785,23805,23802,23789,23948,
23786,23819,23829,23831,23900,23839,23835,23825,23828,23842,23834,23833,23832,
23884,23890,23886,23883,23916,23923,23926,23943,23940,23938,23970,23965,23980,
23982,23997,23952,23991,23996,24009,24013,24019,24018,24022,24027,24043,24050,
24053,24075,24090,24089,24081,24091,24118,24119,24132,24131,24128,24142,24151,
24148,24159,24162,24164,24135,24181,24182,24186,40636,24191,24224,24257,24258,
24264,24272,24271,24278,24291,24285,24282,24283,24290,24289,24296,24297,24300,
24305,24307,24304,24308,24312,24318,24323,24329,24413,24412,24331,24337,24342,
24361,24365,24376,24385,24392,24396,24398,24367,24401,24406,24407,24409,24417,
24429,24435,24439,24451,24450,24447,24458,24456,24465,24455,24478,24473,24472,
24480,24488,24493,24508,24534,24571,24548,24568,24561,24541,24755,24575,24609,
24672,24601,24592,24617,24590,24625,24603,24597,24619,24614,24591,24634,24666,
24641,24682,24695,24671,24650,24646,24653,24675,24643,24676,24642,24684,24683,
24665,24705,24717,24807,24707,24730,24708,24731,24726,24727,24722,24743,24715,
24801,24760,24800,24787,24756,24560,24765,24774,24757,24792,24909,24853,24838,
24822,24823,24832,24820,24826,24835,24865,24827,24817,24845,24846,24903,24894,
24872,24871,24906,24895,24892,24876,24884,24893,24898,24900,24947,24951,24920,
24921,24922,24939,24948,24943,24933,24945,24927,24925,24915,24949,24985,24982,
24967,25004,24980,24986,24970,24977,25003,25006,25036,25034,25033,25079,25032,
25027,25030,25018,25035,32633,25037,25062,25059,25078,25082,25076,25087,25085,
25084,25086,25088,25096,25097,25101,25100,25108,25115,25118,25121,25130,25134,
25136,25138,25139,25153,25166,25182,25187,25179,25184,25192,25212,25218,25225,
25214,25234,25235,25238,25300,25219,25236,25303,25297,25275,25295,25343,25286,
25812,25288,25308,25292,25290,25282,25287,25243,25289,25356,25326,25329,25383,
25346,25352,25327,25333,25424,25406,25421,25628,25423,25494,25486,25472,25515,
25462,25507,25487,25481,25503,25525,25451,25449,25534,25577,25536,25542,25571,
25545,25554,25590,25540,25622,25652,25606,25619,25638,25654,25885,25623,25640,
25615,25703,25711,25718,25678,25898,25749,25747,25765,25769,25736,25788,25818,
25810,25797,25799,25787,25816,25794,25841,25831,33289,25824,25825,25260,25827,
25839,25900,25846,25844,25842,25850,25856,25853,25880,25884,25861,25892,25891,
25899,25908,25909,25911,25910,25912,30027,25928,25942,25941,25933,25944,25950,
25949,25970,25976,25986,25987,35722,26011,26015,26027,26039,26051,26054,26049,
26052,26060,26066,26075,26073,26080,26081,26097,26482,26122,26115,26107,26483,
26165,26166,26164,26140,26191,26180,26185,26177,26206,26205,26212,26215,26216,
26207,26210,26224,26243,26248,26254,26249,26244,26264,26269,26305,26297,26313,
26302,26300,26308,26296,26326,26330,26336,26175,26342,26345,26352,26357,26359,
26383,26390,26398,26406,26407,38712,26414,26431,26422,26433,26424,26423,26438,
26462,26464,26457,26467,26468,26505,26480,26537,26492,26474,26508,26507,26534,
26529,26501,26551,26607,26548,26604,26547,26601,26552,26596,26590,26589,26594,
26606,26553,26574,26566,26599,27292,26654,26694,26665,26688,26701,26674,26702,
26803,26667,26713,26723,26743,26751,26783,26767,26797,26772,26781,26779,26755,
27310,26809,26740,26805,26784,26810,26895,26765,26750,26881,26826,26888,26840,
26914,26918,26849,26892,26829,26836,26855,26837,26934,26898,26884,26839,26851,
26917,26873,26848,26863,26920,26922,26906,26915,26913,26822,27001,26999,26972,
27000,26987,26964,27006,26990,26937,26996,26941,26969,26928,26977,26974,26973,
27009,26986,27058,27054,27088,27071,27073,27091,27070,27086,23528,27082,27101,
27067,27075,27047,27182,27025,27040,27036,27029,27060,27102,27112,27138,27163,
27135,27402,27129,27122,27111,27141,27057,27166,27117,27156,27115,27146,27154,
27329,27171,27155,27204,27148,27250,27190,27256,27207,27234,27225,27238,27208,
27192,27170,27280,27277,27296,27268,27298,27299,27287,34327,27323,27331,27330,
27320,27315,27308,27358,27345,27359,27306,27354,27370,27387,27397,34326,27386,
27410,27414,39729,27423,27448,27447,30428,27449,39150,27463,27459,27465,27472,
27481,27476,27483,27487,27489,27512,27513,27519,27520,27524,27523,27533,27544,
27541,27550,27556,27562,27563,27567,27570,27569,27571,27575,27580,27590,27595,
27603,27615,27628,27627,27635,27631,40638,27656,27667,27668,27675,27684,27683,
27742,27733,27746,27754,27778,27789,27802,27777,27803,27774,27752,27763,27794,
27792,27844,27889,27859,27837,27863,27845,27869,27822,27825,27838,27834,27867,
27887,27865,27882,27935,34893,27958,27947,27965,27960,27929,27957,27955,27922,
27916,28003,28051,28004,27994,28025,27993,28046,28053,28644,28037,28153,28181,
28170,28085,28103,28134,28088,28102,28140,28126,28108,28136,28114,28101,28154,
28121,28132,28117,28138,28142,28205,28270,28206,28185,28274,28255,28222,28195,
28267,28203,28278,28237,28191,28227,28218,28238,28196,28415,28189,28216,28290,
28330,28312,28361,28343,28371,28349,28335,28356,28338,28372,28373,28303,28325,
28354,28319,28481,28433,28748,28396,28408,28414,28479,28402,28465,28399,28466,
28364,28478,28435,28407,28550,28538,28536,28545,28544,28527,28507,28659,28525,
28546,28540,28504,28558,28561,28610,28518,28595,28579,28577,28580,28601,28614,
28586,28639,28629,28652,28628,28632,28657,28654,28635,28681,28683,28666,28689,
28673,28687,28670,28699,28698,28532,28701,28696,28703,28720,28734,28722,28753,
28771,28825,28818,28847,28913,28844,28856,28851,28846,28895,28875,28893,28889,
28937,28925,28956,28953,29029,29013,29064,29030,29026,29004,29014,29036,29071,
29179,29060,29077,29096,29100,29143,29113,29118,29138,29129,29140,29134,29152,
29164,29159,29173,29180,29177,29183,29197,29200,29211,29224,29229,29228,29232,
29234,29243,29244,29247,29248,29254,29259,29272,29300,29310,29314,29313,29319,
29330,29334,29346,29351,29369,29362,29379,29382,29380,29390,29394,29410,29408,
29409,29433,29431,20495,29463,29450,29468,29462,29469,29492,29487,29481,29477,
29502,29518,29519,40664,29527,29546,29544,29552,29560,29557,29563,29562,29640,
29619,29646,29627,29632,29669,29678,29662,29858,29701,29807,29733,29688,29746,
29754,29781,29759,29791,29785,29761,29788,29801,29808,29795,29802,29814,29822,
29835,29854,29863,29898,29903,29908,29681,29920,29923,29927,29929,29934,29938,
29936,29937,29944,29943,29956,29955,29957,29964,29966,29965,29973,29971,29982,
29990,29996,30012,30020,30029,30026,30025,30043,30022,30042,30057,30052,30055,
30059,30061,30072,30070,30086,30087,30068,30090,30089,30082,30100,30106,30109,
30117,30115,30146,30131,30147,30133,30141,30136,30140,30129,30157,30154,30162,
30169,30179,30174,30206,30207,30204,30209,30192,30202,30194,30195,30219,30221,
30217,30239,30247,30240,30241,30242,30244,30260,30256,30267,30279,30280,30278,
30300,30296,30305,30306,30312,30313,30314,30311,30316,30320,30322,30326,30328,
30332,30336,30339,30344,30347,30350,30358,30355,30361,30362,30384,30388,30392,
30393,30394,30402,30413,30422,30418,30430,30433,30437,30439,30442,34351,30459,
30472,30471,30468,30505,30500,30494,30501,30502,30491,30519,30520,30535,30554,
30568,30571,30555,30565,30591,30590,30585,30606,30603,30609,30624,30622,30640,
30646,30649,30655,30652,30653,30651,30663,30669,30679,30682,30684,30691,30702,
30716,30732,30738,31014,30752,31018,30789,30862,30836,30854,30844,30874,30860,
30883,30901,30890,30895,30929,30918,30923,30932,30910,30908,30917,30922,30956,
30951,30938,30973,30964,30983,30994,30993,31001,31020,31019,31040,31072,31063,
31071,31066,31061,31059,31098,31103,31114,31133,31143,40779,31146,31150,31155,
31161,31162,31177,31189,31207,31212,31201,31203,31240,31245,31256,31257,31264,
31263,31104,31281,31291,31294,31287,31299,31319,31305,31329,31330,31337,40861,
31344,31353,31357,31368,31383,31381,31384,31382,31401,31432,31408,31414,31429,
31428,31423,36995,31431,31434,31437,31439,31445,31443,31449,31450,31453,31457,
31458,31462,31469,31472,31490,31503,31498,31494,31539,31512,31513,31518,31541,
31528,31542,31568,31610,31492,31565,31499,31564,31557,31605,31589,31604,31591,
31600,31601,31596,31598,31645,31640,31647,31629,31644,31642,31627,31634,31631,
31581,31641,31691,31681,31692,31695,31668,31686,31709,31721,31761,31764,31718,
31717,31840,31744,31751,31763,31731,31735,31767,31757,31734,31779,31783,31786,
31775,31799,31787,31805,31820,31811,31828,31823,31808,31824,31832,31839,31844,
31830,31845,31852,31861,31875,31888,31908,31917,31906,31915,31905,31912,31923,
31922,31921,31918,31929,31933,31936,31941,31938,31960,31954,31964,31970,39739,
31983,31986,31988,31990,31994,32006,32002,32028,32021,32010,32069,32075,32046,
32050,32063,32053,32070,32115,32086,32078,32114,32104,32110,32079,32099,32147,
32137,32091,32143,32125,32155,32186,32174,32163,32181,32199,32189,32171,32317,
32162,32175,32220,32184,32159,32176,32216,32221,32228,32222,32251,32242,32225,
32261,32266,32291,32289,32274,32305,32287,32265,32267,32290,32326,32358,32315,
32309,32313,32323,32311,32306,32314,32359,32349,32342,32350,32345,32346,32377,
32362,32361,32380,32379,32387,32213,32381,36782,32383,32392,32393,32396,32402,
32400,32403,32404,32406,32398,32411,32412,32568,32570,32581,32588,32589,32590,
32592,32593,32597,32596,32600,32607,32608,32616,32617,32615,32632,32642,32646,
32643,32648,32647,32652,32660,32670,32669,32666,32675,32687,32690,32697,32686,
32694,32696,35697,32709,32710,32714,32725,32724,32737,32742,32745,32755,32761,
39132,32774,32772,32779,32786,32792,32793,32796,32801,32808,32831,32827,32842,
32838,32850,32856,32858,32863,32866,32872,32883,32882,32880,32886,32889,32893,
32895,32900,32902,32901,32923,32915,32922,32941,20880,32940,32987,32997,32985,
32989,32964,32986,32982,33033,33007,33009,33051,33065,33059,33071,33099,38539,
33094,33086,33107,33105,33020,33137,33134,33125,33126,33140,33155,33160,33162,
33152,33154,33184,33173,33188,33187,33119,33171,33193,33200,33205,33214,33208,
33213,33216,33218,33210,33225,33229,33233,33241,33240,33224,33242,33247,33248,
33255,33274,33275,33278,33281,33282,33285,33287,33290,33293,33296,33302,33321,
33323,33336,33331,33344,33369,33368,33373,33370,33375,33380,33378,33384,33386,
33387,33326,33393,33399,33400,33406,33421,33426,33451,33439,33467,33452,33505,
33507,33503,33490,33524,33523,33530,33683,33539,33531,33529,33502,33542,33500,
33545,33497,33589,33588,33558,33586,33585,33600,33593,33616,33605,33583,33579,
33559,33560,33669,33690,33706,33695,33698,33686,33571,33678,33671,33674,33660,
33717,33651,33653,33696,33673,33704,33780,33811,33771,33742,33789,33795,33752,
33803,33729,33783,33799,33760,33778,33805,33826,33824,33725,33848,34054,33787,
33901,33834,33852,34138,33924,33911,33899,33965,33902,33922,33897,33862,33836,
33903,33913,33845,33994,33890,33977,33983,33951,34009,33997,33979,34010,34000,
33985,33990,34006,33953,34081,34047,34036,34071,34072,34092,34079,34069,34068,
34044,34112,34147,34136,34120,34113,34306,34123,34133,34176,34212,34184,34193,
34186,34216,34157,34196,34203,34282,34183,34204,34167,34174,34192,34249,34234,
34255,34233,34256,34261,34269,34277,34268,34297,34314,34323,34315,34302,34298,
34310,34338,34330,34352,34367,34381,20053,34388,34399,34407,34417,34451,34467,
34473,34474,34443,34444,34486,34479,34500,34502,34480,34505,34851,34475,34516,
34526,34537,34540,34527,34523,34543,34578,34566,34568,34560,34563,34555,34577,
34569,34573,34553,34570,34612,34623,34615,34619,34597,34601,34586,34656,34655,
34680,34636,34638,34676,34647,34664,34670,34649,34643,34659,34666,34821,34722,
34719,34690,34735,34763,34749,34752,34768,38614,34731,34756,34739,34759,34758,
34747,34799,34802,34784,34831,34829,34814,34806,34807,34830,34770,34833,34838,
34837,34850,34849,34865,34870,34873,34855,34875,34884,34882,34898,34905,34910,
34914,34923,34945,34942,34974,34933,34941,34997,34930,34946,34967,34962,34990,
34969,34978,34957,34980,34992,35007,34993,35011,35012,35028,35032,35033,35037,
35065,35074,35068,35060,35048,35058,35076,35084,35082,35091,35139,35102,35109,
35114,35115,35137,35140,35131,35126,35128,35148,35101,35168,35166,35174,35172,
35181,35178,35183,35188,35191,35198,35203,35208,35210,35219,35224,35233,35241,
35238,35244,35247,35250,35258,35261,35263,35264,35290,35292,35293,35303,35316,
35320,35331,35350,35344,35340,35355,35357,35365,35382,35393,35419,35410,35398,
35400,35452,35437,35436,35426,35461,35458,35460,35496,35489,35473,35493,35494,
35482,35491,35524,35533,35522,35546,35563,35571,35559,35556,35569,35604,35552,
35554,35575,35550,35547,35596,35591,35610,35553,35606,35600,35607,35616,35635,
38827,35622,35627,35646,35624,35649,35660,35663,35662,35657,35670,35675,35674,
35691,35679,35692,35695,35700,35709,35712,35724,35726,35730,35731,35734,35737,
35738,35898,35905,35903,35912,35916,35918,35920,35925,35938,35948,35960,35962,
35970,35977,35973,35978,35981,35982,35988,35964,35992,25117,36013,36010,36029,
36018,36019,36014,36022,36040,36033,36068,36067,36058,36093,36090,36091,36100,
36101,36106,36103,36111,36109,36112,40782,36115,36045,36116,36118,36199,36205,
36209,36211,36225,36249,36290,36286,36282,36303,36314,36310,36300,36315,36299,
36330,36331,36319,36323,36348,36360,36361,36351,36381,36382,36368,36383,36418,
36405,36400,36404,36426,36423,36425,36428,36432,36424,36441,36452,36448,36394,
36451,36437,36470,36466,36476,36481,36487,36485,36484,36491,36490,36499,36497,
36500,36505,36522,36513,36524,36528,36550,36529,36542,36549,36552,36555,36571,
36579,36604,36603,36587,36606,36618,36613,36629,36626,36633,36627,36636,36639,
36635,36620,36646,36659,36667,36665,36677,36674,36670,36684,36681,36678,36686,
36695,36700,36706,36707,36708,36764,36767,36771,36781,36783,36791,36826,36837,
36834,36842,36847,36999,36852,36869,36857,36858,36881,36885,36897,36877,36894,
36886,36875,36903,36918,36917,36921,36856,36943,36944,36945,36946,36878,36937,
36926,36950,36952,36958,36968,36975,36982,38568,36978,36994,36989,36993,36992,
37002,37001,37007,37032,37039,37041,37045,37090,37092,25160,37083,37122,37138,
37145,37170,37168,37194,37206,37208,37219,37221,37225,37235,37234,37259,37257,
37250,37282,37291,37295,37290,37301,37300,37306,37312,37313,37321,37323,37328,
37334,37343,37345,37339,37372,37365,37366,37406,37375,37396,37420,37397,37393,
37470,37463,37445,37449,37476,37448,37525,37439,37451,37456,37532,37526,37523,
37531,37466,37583,37561,37559,37609,37647,37626,37700,37678,37657,37666,37658,
37667,37690,37685,37691,37724,37728,37756,37742,37718,37808,37804,37805,37780,
37817,37846,37847,37864,37861,37848,37827,37853,37840,37832,37860,37914,37908,
37907,37891,37895,37904,37942,37931,37941,37921,37946,37953,37970,37956,37979,
37984,37986,37982,37994,37417,38000,38005,38007,38013,37978,38012,38014,38017,
38015,38274,38279,38282,38292,38294,38296,38297,38304,38312,38311,38317,38332,
38331,38329,38334,38346,28662,38339,38349,38348,38357,38356,38358,38364,38369,
38373,38370,38433,38440,38446,38447,38466,38476,38479,38475,38519,38492,38494,
38493,38495,38502,38514,38508,38541,38552,38549,38551,38570,38567,38577,38578,
38576,38580,38582,38584,38585,38606,38603,38601,38605,35149,38620,38669,38613,
38649,38660,38662,38664,38675,38670,38673,38671,38678,38681,38692,38698,38704,
38713,38717,38718,38724,38726,38728,38722,38729,38748,38752,38756,38758,38760,
21202,38763,38769,38777,38789,38780,38785,38778,38790,38795,38799,38800,38812,
38824,38822,38819,38835,38836,38851,38854,38856,38859,38876,38893,40783,38898,
31455,38902,38901,38927,38924,38968,38948,38945,38967,38973,38982,38991,38987,
39019,39023,39024,39025,39028,39027,39082,39087,39089,39094,39108,39107,39110,
39145,39147,39171,39177,39186,39188,39192,39201,39197,39198,39204,39200,39212,
39214,39229,39230,39234,39241,39237,39248,39243,39249,39250,39244,39253,39319,
39320,39333,39341,39342,39356,39391,39387,39389,39384,39377,39405,39406,39409,
39410,39419,39416,39425,39439,39429,39394,39449,39467,39479,39493,39490,39488,
39491,39486,39509,39501,39515,39511,39519,39522,39525,39524,39529,39531,39530,
39597,39600,39612,39616,39631,39633,39635,39636,39646,39647,39650,39651,39654,
39663,39659,39662,39668,39665,39671,39675,39686,39704,39706,39711,39714,39715,
39717,39719,39720,39721,39722,39726,39727,39730,39748,39747,39759,39757,39758,
39761,39768,39796,39827,39811,39825,39830,39831,39839,39840,39848,39860,39872,
39882,39865,39878,39887,39889,39890,39907,39906,39908,39892,39905,39994,39922,
39921,39920,39957,39956,39945,39955,39948,39942,39944,39954,39946,39940,39982,
39963,39973,39972,39969,39984,40007,39986,40006,39998,40026,40032,40039,40054,
40056,40167,40172,40176,40201,40200,40171,40195,40198,40234,40230,40367,40227,
40223,40260,40213,40210,40257,40255,40254,40262,40264,40285,40286,40292,40273,
40272,40281,40306,40329,40327,40363,40303,40314,40346,40356,40361,40370,40388,
40385,40379,40376,40378,40390,40399,40386,40409,40403,40440,40422,40429,40431,
40445,40474,40475,40478,40565,40569,40573,40577,40584,40587,40588,40594,40597,
40593,40605,40613,40617,40632,40618,40621,38753,40652,40654,40655,40656,40660,
40668,40670,40669,40672,40677,40680,40687,40692,40694,40695,40697,40699,40700,
40701,40711,40712,30391,40725,40737,40748,40766,40778,40786,40788,40803,40799,
40800,40801,40806,40807,40812,40810,40823,40818,40822,40853,40860,40864,22575,
27079,36953,29796,20956,29081,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32394,35100,37704,37512,34012,
20425,28859,26161,26824,37625,26363,24389,20008,20193,20220,20224,20227,20281,
20310,20370,20362,20378,20372,20429,20544,20514,20479,20510,20550,20592,20546,
20628,20724,20696,20810,20836,20893,20926,20972,21013,21148,21158,21184,21211,
21248,21255,21284,21362,21395,21426,21469,64014,21660,21642,21673,21759,21894,
22361,22373,22444,22472,22471,64015,64016,22686,22706,22795,22867,22875,22877,
22883,22948,22970,23382,23488,29999,23512,23532,23582,23718,23738,23797,23847,
23891,64017,23874,23917,23992,23993,24016,24353,24372,24423,24503,24542,24669,
24709,24714,24798,24789,24864,24818,24849,24887,24880,24984,25107,25254,25589,
25696,25757,25806,25934,26112,26133,26171,26121,26158,26142,26148,26213,26199,
26201,64018,26227,26265,26272,26290,26303,26362,26382,63785,26470,26555,26706,
26560,26625,26692,26831,64019,26984,64020,27032,27106,27184,27243,27206,27251,
27262,27362,27364,27606,27711,27740,27782,27759,27866,27908,28039,28015,28054,
28076,28111,28152,28146,28156,28217,28252,28199,28220,28351,28552,28597,28661,
28677,28679,28712,28805,28843,28943,28932,29020,28998,28999,64021,29121,29182,
29361,29374,29476,64022,29559,29629,29641,29654,29667,29650,29703,29685,29734,
29738,29737,29742,29794,29833,29855,29953,30063,30338,30364,30366,30363,30374,
64023,30534,21167,30753,30798,30820,30842,31024,64024,64025,64026,31124,64027,
31131,31441,31463,64028,31467,31646,64029,32072,32092,32183,32160,32214,32338,
32583,32673,64030,33537,33634,33663,33735,33782,33864,33972,34131,34137,34155,
64031,34224,64032,64033,34823,35061,35346,35383,35449,35495,35518,35551,64034,
35574,35667,35711,36080,36084,36114,36214,64035,36559,64036,64037,36967,37086,
64038,37141,37159,37338,37335,37342,37357,37358,37348,37349,37382,37392,37386,
37434,37440,37436,37454,37465,37457,37433,37479,37543,37495,37496,37607,37591,
37593,37584,64039,37589,37600,37587,37669,37665,37627,64040,37662,37631,37661,
37634,37744,37719,37796,37830,37854,37880,37937,37957,37960,38290,63964,64041,
38557,38575,38707,38715,38723,38733,38735,38737,38741,38999,39013,64042,64043,
39207,64044,39326,39502,39641,39644,39797,39794,39823,39857,39867,39936,40304,
40299,64045,40473,40657,0,0,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,
65506,65508,65287,65282,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,8544,
8545,8546,8547,8548,8549,8550,8551,8552,8553,65506,65508,65287,65282,12849,8470,
8481,8757,32394,35100,37704,37512,34012,20425,28859,26161,26824,37625,26363,
24389,20008,20193,20220,20224,20227,20281,20310,20370,20362,20378,20372,20429,
20544,20514,20479,20510,20550,20592,20546,20628,20724,20696,20810,20836,20893,
20926,20972,21013,21148,21158,21184,21211,21248,21255,21284,21362,21395,21426,
21469,64014,21660,21642,21673,21759,21894,22361,22373,22444,22472,22471,64015,
64016,22686,22706,22795,22867,22875,22877,22883,22948,22970,23382,23488,29999,
23512,23532,23582,23718,23738,23797,23847,23891,64017,23874,23917,23992,23993,
24016,24353,24372,24423,24503,24542,24669,24709,24714,24798,24789,24864,24818,
24849,24887,24880,24984,25107,25254,25589,25696,25757,25806,25934,26112,26133,
26171,26121,26158,26142,26148,26213,26199,26201,64018,26227,26265,26272,26290,
26303,26362,26382,63785,26470,26555,26706,26560,26625,26692,26831,64019,26984,
64020,27032,27106,27184,27243,27206,27251,27262,27362,27364,27606,27711,27740,
27782,27759,27866,27908,28039,28015,28054,28076,28111,28152,28146,28156,28217,
28252,28199,28220,28351,28552,28597,28661,28677,28679,28712,28805,28843,28943,
28932,29020,28998,28999,64021,29121,29182,29361,29374,29476,64022,29559,29629,
29641,29654,29667,29650,29703,29685,29734,29738,29737,29742,29794,29833,29855,
29953,30063,30338,30364,30366,30363,30374,64023,30534,21167,30753,30798,30820,
30842,31024,64024,64025,64026,31124,64027,31131,31441,31463,64028,31467,31646,
64029,32072,32092,32183,32160,32214,32338,32583,32673,64030,33537,33634,33663,
33735,33782,33864,33972,34131,34137,34155,64031,34224,64032,64033,34823,35061,
35346,35383,35449,35495,35518,35551,64034,35574,35667,35711,36080,36084,36114,
36214,64035,36559,64036,64037,36967,37086,64038,37141,37159,37338,37335,37342,
37357,37358,37348,37349,37382,37392,37386,37434,37440,37436,37454,37465,37457,
37433,37479,37543,37495,37496,37607,37591,37593,37584,64039,37589,37600,37587,
37669,37665,37627,64040,37662,37631,37661,37634,37744,37719,37796,37830,37854,
37880,37937,37957,37960,38290,63964,64041,38557,38575,38707,38715,38723,38733,
38735,38737,38741,38999,39013,64042,64043,39207,64044,39326,39502,39641,39644,
39797,39794,39823,39857,39867,39936,40304,40299,64045,40473,40657,
]
const Jis0208Encode*: array[7327, UCS16x16] = [
(167u16,87u16),(168u16,14u16),(176u16,74u16),(177u16,61u16),(180u16,12u16),
(182u16,182u16),(215u16,62u16),(247u16,63u16),(913u16,470u16),(914u16,471u16),
(915u16,472u16),(916u16,473u16),(917u16,474u16),(918u16,475u16),(919u16,476u16),
(920u16,477u16),(921u16,478u16),(922u16,479u16),(923u16,480u16),(924u16,481u16),
(925u16,482u16),(926u16,483u16),(927u16,484u16),(928u16,485u16),(929u16,486u16),
(931u16,487u16),(932u16,488u16),(933u16,489u16),(934u16,490u16),(935u16,491u16),
(936u16,492u16),(937u16,493u16),(945u16,502u16),(946u16,503u16),(947u16,504u16),
(948u16,505u16),(949u16,506u16),(950u16,507u16),(951u16,508u16),(952u16,509u16),
(953u16,510u16),(954u16,511u16),(955u16,512u16),(956u16,513u16),(957u16,514u16),
(958u16,515u16),(959u16,516u16),(960u16,517u16),(961u16,518u16),(963u16,519u16),
(964u16,520u16),(965u16,521u16),(966u16,522u16),(967u16,523u16),(968u16,524u16),
(969u16,525u16),(1025u16,570u16),(1040u16,564u16),(1041u16,565u16),
(1042u16,566u16),(1043u16,567u16),(1044u16,568u16),(1045u16,569u16),
(1046u16,571u16),(1047u16,572u16),(1048u16,573u16),(1049u16,574u16),
(1050u16,575u16),(1051u16,576u16),(1052u16,577u16),(1053u16,578u16),
(1054u16,579u16),(1055u16,580u16),(1056u16,581u16),(1057u16,582u16),
(1058u16,583u16),(1059u16,584u16),(1060u16,585u16),(1061u16,586u16),
(1062u16,587u16),(1063u16,588u16),(1064u16,589u16),(1065u16,590u16),
(1066u16,591u16),(1067u16,592u16),(1068u16,593u16),(1069u16,594u16),
(1070u16,595u16),(1071u16,596u16),(1072u16,612u16),(1073u16,613u16),
(1074u16,614u16),(1075u16,615u16),(1076u16,616u16),(1077u16,617u16),
(1078u16,619u16),(1079u16,620u16),(1080u16,621u16),(1081u16,622u16),
(1082u16,623u16),(1083u16,624u16),(1084u16,625u16),(1085u16,626u16),
(1086u16,627u16),(1087u16,628u16),(1088u16,629u16),(1089u16,630u16),
(1090u16,631u16),(1091u16,632u16),(1092u16,633u16),(1093u16,634u16),
(1094u16,635u16),(1095u16,636u16),(1096u16,637u16),(1097u16,638u16),
(1098u16,639u16),(1099u16,640u16),(1100u16,641u16),(1101u16,642u16),
(1102u16,643u16),(1103u16,644u16),(1105u16,618u16),(8208u16,29u16),
(8213u16,28u16),(8216u16,37u16),(8217u16,38u16),(8220u16,39u16),(8221u16,40u16),
(8224u16,180u16),(8225u16,181u16),(8229u16,36u16),(8230u16,35u16),
(8240u16,176u16),(8242u16,75u16),(8243u16,76u16),(8251u16,101u16),
(8451u16,77u16),(8470u16,1193u16),(8481u16,1195u16),(8491u16,175u16),
(8544u16,1148u16),(8545u16,1149u16),(8546u16,1150u16),(8547u16,1151u16),
(8548u16,1152u16),(8549u16,1153u16),(8550u16,1154u16),(8551u16,1155u16),
(8552u16,1156u16),(8553u16,1157u16),(8560u16,8634u16),(8561u16,8635u16),
(8562u16,8636u16),(8563u16,8637u16),(8564u16,8638u16),(8565u16,8639u16),
(8566u16,8640u16),(8567u16,8641u16),(8568u16,8642u16),(8569u16,8643u16),
(8592u16,104u16),(8593u16,105u16),(8594u16,103u16),(8595u16,106u16),
(8658u16,138u16),(8660u16,139u16),(8704u16,140u16),(8706u16,156u16),
(8707u16,141u16),(8711u16,157u16),(8712u16,119u16),(8715u16,120u16),
(8721u16,1211u16),(8722u16,60u16),(8730u16,162u16),(8733u16,164u16),
(8734u16,70u16),(8735u16,1215u16),(8736u16,153u16),(8741u16,33u16),
(8743u16,135u16),(8744u16,136u16),(8745u16,126u16),(8746u16,125u16),
(8747u16,166u16),(8748u16,167u16),(8750u16,1210u16),(8756u16,71u16),
(8757u16,165u16),(8765u16,163u16),(8786u16,159u16),(8800u16,65u16),
(8801u16,158u16),(8806u16,68u16),(8807u16,69u16),(8810u16,160u16),
(8811u16,161u16),(8834u16,123u16),(8835u16,124u16),(8838u16,121u16),
(8839u16,122u16),(8869u16,154u16),(8895u16,1216u16),(8978u16,155u16),
(9312u16,1128u16),(9313u16,1129u16),(9314u16,1130u16),(9315u16,1131u16),
(9316u16,1132u16),(9317u16,1133u16),(9318u16,1134u16),(9319u16,1135u16),
(9320u16,1136u16),(9321u16,1137u16),(9322u16,1138u16),(9323u16,1139u16),
(9324u16,1140u16),(9325u16,1141u16),(9326u16,1142u16),(9327u16,1143u16),
(9328u16,1144u16),(9329u16,1145u16),(9330u16,1146u16),(9331u16,1147u16),
(9472u16,658u16),(9473u16,669u16),(9474u16,659u16),(9475u16,670u16),
(9484u16,660u16),(9487u16,671u16),(9488u16,661u16),(9491u16,672u16),
(9492u16,663u16),(9495u16,674u16),(9496u16,662u16),(9499u16,673u16),
(9500u16,664u16),(9501u16,685u16),(9504u16,680u16),(9507u16,675u16),
(9508u16,666u16),(9509u16,687u16),(9512u16,682u16),(9515u16,677u16),
(9516u16,665u16),(9519u16,681u16),(9520u16,686u16),(9523u16,676u16),
(9524u16,667u16),(9527u16,683u16),(9528u16,688u16),(9531u16,678u16),
(9532u16,668u16),(9535u16,684u16),(9538u16,689u16),(9547u16,679u16),
(9632u16,96u16),(9633u16,95u16),(9650u16,98u16),(9651u16,97u16),
(9660u16,100u16),(9661u16,99u16),(9670u16,94u16),(9671u16,93u16),
(9675u16,90u16),(9678u16,92u16),(9679u16,91u16),(9711u16,187u16),
(9733u16,89u16),(9734u16,88u16),(9792u16,73u16),(9794u16,72u16),
(9834u16,179u16),(9837u16,178u16),(9839u16,177u16),(12288u16,0u16),
(12289u16,1u16),(12290u16,2u16),(12291u16,22u16),(12293u16,24u16),
(12294u16,25u16),(12295u16,26u16),(12296u16,49u16),(12297u16,50u16),
(12298u16,51u16),(12299u16,52u16),(12300u16,53u16),(12301u16,54u16),
(12302u16,55u16),(12303u16,56u16),(12304u16,57u16),(12305u16,58u16),
(12306u16,102u16),(12307u16,107u16),(12308u16,43u16),(12309u16,44u16),
(12317u16,1191u16),(12319u16,1192u16),(12353u16,282u16),(12354u16,283u16),
(12355u16,284u16),(12356u16,285u16),(12357u16,286u16),(12358u16,287u16),
(12359u16,288u16),(12360u16,289u16),(12361u16,290u16),(12362u16,291u16),
(12363u16,292u16),(12364u16,293u16),(12365u16,294u16),(12366u16,295u16),
(12367u16,296u16),(12368u16,297u16),(12369u16,298u16),(12370u16,299u16),
(12371u16,300u16),(12372u16,301u16),(12373u16,302u16),(12374u16,303u16),
(12375u16,304u16),(12376u16,305u16),(12377u16,306u16),(12378u16,307u16),
(12379u16,308u16),(12380u16,309u16),(12381u16,310u16),(12382u16,311u16),
(12383u16,312u16),(12384u16,313u16),(12385u16,314u16),(12386u16,315u16),
(12387u16,316u16),(12388u16,317u16),(12389u16,318u16),(12390u16,319u16),
(12391u16,320u16),(12392u16,321u16),(12393u16,322u16),(12394u16,323u16),
(12395u16,324u16),(12396u16,325u16),(12397u16,326u16),(12398u16,327u16),
(12399u16,328u16),(12400u16,329u16),(12401u16,330u16),(12402u16,331u16),
(12403u16,332u16),(12404u16,333u16),(12405u16,334u16),(12406u16,335u16),
(12407u16,336u16),(12408u16,337u16),(12409u16,338u16),(12410u16,339u16),
(12411u16,340u16),(12412u16,341u16),(12413u16,342u16),(12414u16,343u16),
(12415u16,344u16),(12416u16,345u16),(12417u16,346u16),(12418u16,347u16),
(12419u16,348u16),(12420u16,349u16),(12421u16,350u16),(12422u16,351u16),
(12423u16,352u16),(12424u16,353u16),(12425u16,354u16),(12426u16,355u16),
(12427u16,356u16),(12428u16,357u16),(12429u16,358u16),(12430u16,359u16),
(12431u16,360u16),(12432u16,361u16),(12433u16,362u16),(12434u16,363u16),
(12435u16,364u16),(12443u16,10u16),(12444u16,11u16),(12445u16,20u16),
(12446u16,21u16),(12449u16,376u16),(12450u16,377u16),(12451u16,378u16),
(12452u16,379u16),(12453u16,380u16),(12454u16,381u16),(12455u16,382u16),
(12456u16,383u16),(12457u16,384u16),(12458u16,385u16),(12459u16,386u16),
(12460u16,387u16),(12461u16,388u16),(12462u16,389u16),(12463u16,390u16),
(12464u16,391u16),(12465u16,392u16),(12466u16,393u16),(12467u16,394u16),
(12468u16,395u16),(12469u16,396u16),(12470u16,397u16),(12471u16,398u16),
(12472u16,399u16),(12473u16,400u16),(12474u16,401u16),(12475u16,402u16),
(12476u16,403u16),(12477u16,404u16),(12478u16,405u16),(12479u16,406u16),
(12480u16,407u16),(12481u16,408u16),(12482u16,409u16),(12483u16,410u16),
(12484u16,411u16),(12485u16,412u16),(12486u16,413u16),(12487u16,414u16),
(12488u16,415u16),(12489u16,416u16),(12490u16,417u16),(12491u16,418u16),
(12492u16,419u16),(12493u16,420u16),(12494u16,421u16),(12495u16,422u16),
(12496u16,423u16),(12497u16,424u16),(12498u16,425u16),(12499u16,426u16),
(12500u16,427u16),(12501u16,428u16),(12502u16,429u16),(12503u16,430u16),
(12504u16,431u16),(12505u16,432u16),(12506u16,433u16),(12507u16,434u16),
(12508u16,435u16),(12509u16,436u16),(12510u16,437u16),(12511u16,438u16),
(12512u16,439u16),(12513u16,440u16),(12514u16,441u16),(12515u16,442u16),
(12516u16,443u16),(12517u16,444u16),(12518u16,445u16),(12519u16,446u16),
(12520u16,447u16),(12521u16,448u16),(12522u16,449u16),(12523u16,450u16),
(12524u16,451u16),(12525u16,452u16),(12526u16,453u16),(12527u16,454u16),
(12528u16,455u16),(12529u16,456u16),(12530u16,457u16),(12531u16,458u16),
(12532u16,459u16),(12533u16,460u16),(12534u16,461u16),(12539u16,5u16),
(12540u16,27u16),(12541u16,18u16),(12542u16,19u16),(12849u16,1201u16),
(12850u16,1202u16),(12857u16,1203u16),(12964u16,1196u16),(12965u16,1197u16),
(12966u16,1198u16),(12967u16,1199u16),(12968u16,1200u16),(13059u16,1165u16),
(13069u16,1169u16),(13076u16,1160u16),(13080u16,1163u16),(13090u16,1161u16),
(13091u16,1171u16),(13094u16,1170u16),(13095u16,1164u16),(13099u16,1172u16),
(13110u16,1166u16),(13115u16,1174u16),(13129u16,1159u16),(13130u16,1173u16),
(13133u16,1162u16),(13137u16,1167u16),(13143u16,1168u16),(13179u16,1190u16),
(13180u16,1206u16),(13181u16,1205u16),(13182u16,1204u16),(13198u16,1178u16),
(13199u16,1179u16),(13212u16,1175u16),(13213u16,1176u16),(13214u16,1177u16),
(13217u16,1181u16),(13252u16,1180u16),(13261u16,1194u16),(19968u16,1485u16),
(19969u16,3285u16),(19971u16,2560u16),(19975u16,4039u16),(19976u16,2795u16),
(19977u16,2459u16),(19978u16,2794u16),(19979u16,1625u16),(19981u16,3811u16),
(19982u16,4166u16),(19984u16,4419u16),(19985u16,1518u16),(19988u16,1769u16),
(19989u16,4420u16),(19990u16,2917u16),(19991u16,4639u16),(19992u16,1933u16),
(19993u16,3879u16),(19998u16,2796u16),(20001u16,4259u16),(20006u16,3887u16),
(20008u16,8284u16),(20010u16,4421u16),(20013u16,3265u16),(20017u16,4422u16),
(20018u16,2063u16),(20022u16,4423u16),(20024u16,1846u16),(20025u16,3211u16),
(20027u16,2608u16),(20028u16,4424u16),(20031u16,4425u16),(20034u16,4426u16),
(20035u16,3592u16),(20037u16,1934u16),(20043u16,3594u16),(20045u16,3544u16),
(20046u16,2196u16),(20047u16,3966u16),(20053u16,6808u16),(20054u16,4427u16),
(20055u16,2797u16),(20056u16,4428u16),(20057u16,1618u16),(20061u16,2042u16),
(20062u16,2241u16),(20063u16,4114u16),(20066u16,4987u16),(20081u16,4215u16),
(20083u16,3570u16),(20094u16,1790u16),(20096u16,1900u16),(20098u16,4429u16),
(20101u16,4430u16),(20102u16,4256u16),(20104u16,4164u16),(20105u16,3079u16),
(20106u16,4432u16),(20107u16,2529u16),(20108u16,3560u16),(20110u16,4435u16),
(20113u16,1533u16),(20114u16,2224u16),(20116u16,2223u16),(20117u16,1479u16),
(20120u16,4366u16),(20121u16,4365u16),(20123u16,2368u16),(20124u16,1410u16),
(20126u16,4436u16),(20127u16,4437u16),(20128u16,4438u16),(20129u16,3967u16),
(20130u16,4439u16),(20132u16,2243u16),(20133u16,1480u16),(20134u16,4029u16),
(20136u16,1971u16),(20139u16,1972u16),(20140u16,1973u16),(20141u16,3355u16),
(20142u16,4257u16),(20144u16,4440u16),(20147u16,4441u16),(20150u16,4442u16),
(20154u16,2864u16),(20160u16,2657u16),(20161u16,2865u16),(20162u16,4447u16),
(20164u16,4445u16),(20166u16,4446u16),(20167u16,1935u16),(20170u16,2352u16),
(20171u16,1677u16),(20173u16,4444u16),(20174u16,4443u16),(20175u16,3862u16),
(20180u16,2481u16),(20181u16,2480u16),(20182u16,3131u16),(20183u16,4448u16),
(20184u16,3812u16),(20185u16,2984u16),(20189u16,23u16),(20190u16,4449u16),
(20191u16,4451u16),(20193u16,8285u16),(20195u16,3170u16),(20196u16,4294u16),
(20197u16,1451u16),(20205u16,4450u16),(20206u16,1627u16),(20208u16,2009u16),
(20210u16,3266u16),(20214u16,2146u16),(20215u16,4452u16),(20219u16,3575u16),
(20220u16,8286u16),(20224u16,8287u16),(20225u16,1860u16),(20227u16,8288u16),
(20233u16,4453u16),(20234u16,1452u16),(20237u16,2225u16),(20238u16,1861u16),
(20239u16,3849u16),(20240u16,3683u16),(20241u16,1936u16),(20250u16,1678u16),
(20252u16,4488u16),(20253u16,3416u16),(20271u16,3647u16),(20272u16,4455u16),
(20276u16,3693u16),(20278u16,4295u16),(20280u16,2832u16),(20281u16,8289u16),
(20282u16,2482u16),(20284u16,2530u16),(20285u16,1629u16),(20291u16,3338u16),
(20294u16,3197u16),(20295u16,4459u16),(20301u16,1453u16),(20302u16,3356u16),
(20303u16,2658u16),(20304u16,2369u16),(20305u16,4139u16),(20307u16,3147u16),
(20309u16,1628u16),(20310u16,8290u16),(20311u16,4458u16),(20313u16,4165u16),
(20314u16,4454u16),(20315u16,4456u16),(20316u16,2427u16),(20317u16,4457u16),
(20318u16,4891u16),(20329u16,4465u16),(20335u16,4468u16),(20336u16,4466u16),
(20339u16,1631u16),(20341u16,3880u16),(20342u16,4460u16),(20347u16,4464u16),
(20348u16,2244u16),(20351u16,2483u16),(20355u16,1791u16),(20358u16,4469u16),
(20360u16,4461u16),(20362u16,8292u16),(20363u16,4296u16),(20365u16,2531u16),
(20367u16,4462u16),(20369u16,4467u16),(20370u16,8291u16),(20372u16,8294u16),
(20374u16,4470u16),(20376u16,4463u16),(20378u16,8293u16),(20379u16,1974u16),
(20381u16,1454u16),(20384u16,1975u16),(20385u16,1630u16),(20395u16,4892u16),
(20397u16,4036u16),(20398u16,3837u16),(20399u16,2245u16),(20405u16,2834u16),
(20406u16,4252u16),(20415u16,3909u16),(20418u16,2091u16),(20419u16,3106u16),
(20420u16,1665u16),(20425u16,8277u16),(20426u16,2682u16),(20429u16,8295u16),
(20430u16,4474u16),(20432u16,4479u16),(20433u16,4477u16),(20436u16,4472u16),
(20439u16,3116u16),(20440u16,4475u16),(20442u16,4478u16),(20443u16,4476u16),
(20445u16,3914u16),(20447u16,4473u16),(20449u16,2833u16),(20451u16,4030u16),
(20452u16,4480u16),(20453u16,4481u16),(20462u16,2635u16),(20463u16,4494u16),
(20467u16,3619u16),(20469u16,3781u16),(20470u16,4489u16),(20472u16,3933u16),
(20474u16,1619u16),(20478u16,4493u16),(20479u16,8298u16),(20485u16,4487u16),
(20486u16,4496u16),(20489u16,3057u16),(20491u16,2197u16),(20493u16,3631u16),
(20495u16,5960u16),(20497u16,4495u16),(20498u16,3444u16),(20500u16,4484u16),
(20502u16,2247u16),(20505u16,2246u16),(20506u16,4482u16),(20510u16,8299u16),
(20511u16,2595u16),(20513u16,4490u16),(20514u16,8297u16),(20515u16,3932u16),
(20516u16,3240u16),(20517u16,4486u16),(20518u16,2148u16),(20520u16,4483u16),
(20521u16,4491u16),(20522u16,4485u16),(20523u16,4278u16),(20524u16,4492u16),
(20525u16,4356u16),(20534u16,2043u16),(20537u16,2147u16),(20544u16,8296u16),
(20546u16,8302u16),(20547u16,4497u16),(20550u16,8300u16),(20551u16,4498u16),
(20552u16,4502u16),(20553u16,1455u16),(20559u16,3901u16),(20560u16,4501u16),
(20565u16,4500u16),(20566u16,4504u16),(20570u16,4503u16),(20572u16,3357u16),
(20581u16,2149u16),(20588u16,4505u16),(20592u16,8301u16),(20594u16,2574u16),
(20596u16,3107u16),(20597u16,3358u16),(20598u16,2059u16),(20600u16,4506u16),
(20605u16,1901u16),(20608u16,4507u16),(20613u16,4509u16),(20621u16,3968u16),
(20625u16,2137u16),(20628u16,8303u16),(20632u16,2460u16),(20633u16,3752u16),
(20634u16,4508u16),(20652u16,2386u16),(20653u16,4170u16),(20658u16,4511u16),
(20659u16,4514u16),(20660u16,4510u16),(20661u16,2385u16),(20663u16,2724u16),
(20670u16,2092u16),(20674u16,4515u16),(20677u16,2020u16),(20681u16,4512u16),
(20682u16,4513u16),(20685u16,3492u16),(20687u16,3099u16),(20689u16,1976u16),
(20693u16,3992u16),(20694u16,4516u16),(20696u16,8305u16),(20698u16,4258u16),
(20702u16,4517u16),(20707u16,4520u16),(20709u16,4518u16),(20711u16,3053u16),
(20717u16,4519u16),(20718u16,4521u16),(20724u16,8304u16),(20725u16,4523u16),
(20729u16,4522u16),(20731u16,3893u16),(20736u16,1902u16),(20737u16,4525u16),
(20738u16,4526u16),(20740u16,1612u16),(20745u16,4524u16),(20754u16,2621u16),
(20756u16,4529u16),(20757u16,4528u16),(20758u16,4527u16),(20760u16,4471u16),
(20762u16,4530u16),(20767u16,2725u16),(20769u16,4531u16),(20778u16,4140u16),
(20786u16,4098u16),(20791u16,4533u16),(20794u16,4532u16),(20795u16,4535u16),
(20796u16,4534u16),(20799u16,4536u16),(20800u16,4537u16),(20801u16,1493u16),
(20803u16,2182u16),(20804u16,2094u16),(20805u16,2659u16),(20806u16,3286u16),
(20807u16,1977u16),(20808u16,2985u16),(20809u16,2248u16),(20810u16,8306u16),
(20811u16,2333u16),(20812u16,4539u16),(20813u16,4081u16),(20814u16,3421u16),
(20816u16,2532u16),(20818u16,4538u16),(20820u16,4540u16),(20826u16,3445u16),
(20828u16,1776u16),(20834u16,4541u16),(20836u16,8307u16),(20837u16,3571u16),
(20840u16,3027u16),(20841u16,4543u16),(20842u16,4544u16),(20843u16,3677u16),
(20844u16,2249u16),(20845u16,4350u16),(20846u16,4545u16),(20849u16,1979u16),
(20853u16,3881u16),(20854u16,3123u16),(20855u16,2054u16),(20856u16,3404u16),
(20860u16,2150u16),(20864u16,4546u16),(20866u16,4547u16),(20869u16,3543u16),
(20870u16,1566u16),(20873u16,4550u16),(20874u16,2442u16),(20876u16,4549u16),
(20877u16,2387u16),(20879u16,4551u16),(20880u16,6563u16),(20881u16,4552u16),
(20882u16,3980u16),(20883u16,4553u16),(20885u16,4554u16),(20886u16,4555u16),
(20887u16,2798u16),(20889u16,2581u16),(20893u16,8308u16),(20896u16,1792u16),
(20898u16,4558u16),(20900u16,4556u16),(20901u16,4070u16),(20902u16,4557u16),
(20904u16,3817u16),(20905u16,4559u16),(20906u16,4560u16),(20907u16,4561u16),
(20908u16,3446u16),(20912u16,4565u16),(20913u16,4563u16),(20914u16,4564u16),
(20915u16,4562u16),(20916u16,2416u16),(20917u16,4566u16),(20918u16,4115u16),
(20919u16,4297u16),(20925u16,4567u16),(20926u16,8309u16),(20932u16,2921u16),
(20933u16,4568u16),(20934u16,2689u16),(20937u16,4569u16),(20939u16,3287u16),
(20940u16,4260u16),(20941u16,3447u16),(20950u16,4642u16),(20955u16,4570u16),
(20956u16,7806u16),(20957u16,2010u16),(20960u16,4571u16),(20961u16,4009u16),
(20966u16,2703u16),(20967u16,3193u16),(20969u16,4573u16),(20970u16,3545u16),
(20972u16,8310u16),(20973u16,4574u16),(20976u16,4575u16),(20977u16,1705u16),
(20981u16,4576u16),(20982u16,1980u16),(20984u16,3521u16),(20985u16,1593u16),
(20986u16,2679u16),(20989u16,3666u16),(20990u16,4577u16),(20992u16,3448u16),
(20995u16,2866u16),(20996u16,4578u16),(20998u16,3865u16),(20999u16,2971u16),
(21000u16,1787u16),(21002u16,1794u16),(21003u16,4579u16),(21006u16,4581u16),
(21009u16,2093u16),(21012u16,4580u16),(21013u16,8311u16),(21015u16,4312u16),
(21021u16,2704u16),(21028u16,3694u16),(21029u16,3897u16),(21031u16,4582u16),
(21033u16,4223u16),(21034u16,4583u16),(21038u16,4584u16),(21040u16,3477u16),
(21043u16,4585u16),(21046u16,2922u16),(21047u16,2443u16),(21048u16,2151u16),
(21049u16,4586u16),(21050u16,2484u16),(21051u16,2334u16),(21059u16,3359u16),
(21060u16,4588u16),(21063u16,3108u16),(21066u16,2428u16),(21067u16,4589u16),
(21068u16,4590u16),(21069u16,3023u16),(21071u16,4587u16),(21076u16,4592u16),
(21078u16,3969u16),(21083u16,2323u16),(21086u16,4591u16),(21091u16,2152u16),
(21092u16,2411u16),(21093u16,3648u16),(21097u16,4595u16),(21098u16,4593u16),
(21103u16,3850u16),(21104u16,2799u16),(21105u16,4602u16),(21106u16,1759u16),
(21107u16,4596u16),(21108u16,4594u16),(21109u16,3054u16),(21117u16,4598u16),
(21119u16,4597u16),(21123u16,1727u16),(21127u16,2131u16),(21128u16,4603u16),
(21129u16,4242u16),(21133u16,4599u16),(21137u16,4604u16),(21138u16,4601u16),
(21140u16,4600u16),(21147u16,4276u16),(21148u16,8312u16),(21151u16,2250u16),
(21152u16,1632u16),(21155u16,4313u16),(21158u16,8313u16),(21161u16,2716u16),
(21162u16,3439u16),(21163u16,2324u16),(21164u16,4607u16),(21165u16,4608u16),
(21167u16,8487u16),(21169u16,4298u16),(21172u16,4334u16),(21173u16,4610u16),
(21177u16,2251u16),(21180u16,4609u16),(21182u16,1706u16),(21184u16,8314u16),
(21185u16,4611u16),(21187u16,4001u16),(21189u16,3317u16),(21191u16,4141u16),
(21193u16,3910u16),(21197u16,4612u16),(21202u16,7478u16),(21205u16,3493u16),
(21207u16,4613u16),(21208u16,1795u16),(21209u16,4060u16),(21211u16,8315u16),
(21213u16,2726u16),(21214u16,4614u16),(21215u16,3924u16),(21216u16,4618u16),
(21218u16,2923u16),(21219u16,4615u16),(21220u16,2021u16),(21222u16,4616u16),
(21223u16,1796u16),(21234u16,2081u16),(21235u16,4619u16),(21237u16,4620u16),
(21240u16,4621u16),(21241u16,4622u16),(21242u16,2596u16),(21246u16,2252u16),
(21247u16,4103u16),(21248u16,8316u16),(21249u16,4113u16),(21250u16,3564u16),
(21253u16,3934u16),(21254u16,4623u16),(21255u16,8317u16),(21256u16,4624u16),
(21261u16,4626u16),(21263u16,4628u16),(21264u16,4627u16),(21269u16,4629u16),
(21270u16,1626u16),(21271u16,3991u16),(21273u16,2441u16),(21274u16,4630u16),
(21277u16,3064u16),(21280u16,2727u16),(21281u16,1982u16),(21283u16,4631u16),
(21284u16,8318u16),(21290u16,3724u16),(21295u16,4632u16),(21297u16,4633u16),
(21299u16,4634u16),(21304u16,4635u16),(21305u16,3763u16),(21306u16,2045u16),
(21307u16,1478u16),(21311u16,3508u16),(21312u16,4636u16),(21313u16,2660u16),
(21315u16,2986u16),(21317u16,4638u16),(21318u16,4637u16),(21319u16,2728u16),
(21320u16,2226u16),(21321u16,4640u16),(21322u16,3695u16),(21325u16,4641u16),
(21329u16,3725u16),(21330u16,3121u16),(21331u16,3179u16),(21332u16,1981u16),
(21335u16,3555u16),(21336u16,3212u16),(21338u16,3649u16),(21340u16,3993u16),
(21342u16,4643u16),(21344u16,2987u16),(21350u16,2088u16),(21353u16,4644u16),
(21358u16,4645u16),(21359u16,1515u16),(21360u16,1494u16),(21361u16,1862u16),
(21362u16,8319u16),(21363u16,3109u16),(21364u16,1928u16),(21365u16,4216u16),
(21367u16,4648u16),(21368u16,1620u16),(21371u16,4647u16),(21375u16,1983u16),
(21378u16,4649u16),(21380u16,4122u16),(21395u16,8320u16),(21398u16,4650u16),
(21400u16,4279u16),(21402u16,2253u16),(21407u16,2183u16),(21408u16,4651u16),
(21413u16,4653u16),(21414u16,4652u16),(21416u16,2882u16),(21417u16,1528u16),
(21421u16,1565u16),(21422u16,4654u16),(21424u16,4655u16),(21426u16,8321u16),
(21427u16,2184u16),(21430u16,4656u16),(21435u16,1957u16),(21442u16,2461u16),
(21443u16,4657u16),(21448u16,4031u16),(21449u16,2370u16),(21450u16,1937u16),
(21451u16,4142u16),(21452u16,3055u16),(21453u16,3696u16),(21454u16,2630u16),
(21460u16,2670u16),(21462u16,2609u16),(21463u16,2622u16),(21465u16,2717u16),
(21467u16,3697u16),(21469u16,8322u16),(21471u16,4660u16),(21473u16,1538u16),
(21474u16,3056u16),(21475u16,2254u16),(21476u16,2198u16),(21477u16,2044u16),
(21480u16,4664u16),(21481u16,3196u16),(21482u16,3195u16),(21483u16,1984u16),
(21484u16,2729u16),(21485u16,4665u16),(21486u16,4663u16),(21487u16,1633u16),
(21488u16,3171u16),(21489u16,2561u16),(21490u16,2486u16),(21491u16,1509u16),
(21494u16,1771u16),(21495u16,2325u16),(21496u16,2485u16),(21498u16,4666u16),
(21505u16,4667u16),(21507u16,1920u16),(21508u16,1729u16),(21512u16,2326u16),
(21513u16,1919u16),(21514u16,3352u16),(21515u16,1508u16),(21516u16,3494u16),
(21517u16,4071u16),(21518u16,2256u16),(21519u16,4224u16),(21520u16,3422u16),
(21521u16,2255u16),(21531u16,2082u16),(21533u16,4676u16),(21535u16,2040u16),
(21536u16,3989u16),(21542u16,3726u16),(21545u16,4675u16),(21547u16,1847u16),
(21548u16,4670u16),(21549u16,4671u16),(21550u16,4673u16),(21558u16,4674u16),
(21560u16,1938u16),(21561u16,2884u16),(21563u16,3866u16),(21564u16,4672u16),
(21565u16,4668u16),(21566u16,2228u16),(21568u16,4669u16),(21570u16,4327u16),
(21574u16,3935u16),(21576u16,3361u16),(21577u16,2227u16),(21578u16,2335u16),
(21582u16,4677u16),(21585u16,3538u16),(21599u16,4681u16),(21608u16,2631u16),
(21610u16,2623u16),(21616u16,4684u16),(21617u16,4682u16),(21619u16,4044u16),
(21621u16,4679u16),(21622u16,4688u16),(21623u16,4683u16),(21627u16,4686u16),
(21628u16,2199u16),(21629u16,4072u16),(21632u16,4687u16),(21636u16,4689u16),
(21638u16,4691u16),(21642u16,8325u16),(21643u16,2429u16),(21644u16,4357u16),
(21646u16,4680u16),(21647u16,4678u16),(21648u16,4690u16),(21650u16,4685u16),
(21660u16,8324u16),(21666u16,4693u16),(21668u16,4702u16),(21669u16,4695u16),
(21672u16,4699u16),(21673u16,8326u16),(21675u16,4700u16),(21676u16,4696u16),
(21679u16,4729u16),(21682u16,2422u16),(21683u16,1708u16),(21688u16,4694u16),
(21692u16,4704u16),(21693u16,1495u16),(21694u16,4703u16),(21696u16,1414u16),
(21697u16,3801u16),(21698u16,4701u16),(21700u16,4697u16),(21703u16,4692u16),
(21704u16,4698u16),(21705u16,2389u16),(21720u16,4705u16),(21729u16,1496u16),
(21730u16,4714u16),(21733u16,4706u16),(21734u16,4707u16),(21736u16,2730u16),
(21737u16,4020u16),(21741u16,4712u16),(21742u16,4711u16),(21746u16,3398u16),
(21754u16,4713u16),(21757u16,4710u16),(21759u16,8327u16),(21764u16,1523u16),
(21766u16,2371u16),(21767u16,2835u16),(21775u16,4708u16),(21776u16,3449u16),
(21780u16,4709u16),(21782u16,1411u16),(21806u16,4719u16),(21807u16,4138u16),
(21809u16,2732u16),(21811u16,4725u16),(21816u16,4724u16),(21817u16,4715u16),
(21822u16,3136u16),(21824u16,4716u16),(21828u16,3180u16),(21829u16,4721u16),
(21830u16,2731u16),(21836u16,4718u16),(21839u16,4109u16),(21843u16,2095u16),
(21846u16,4722u16),(21847u16,4723u16),(21852u16,4720u16),(21853u16,4726u16),
(21859u16,4717u16),(21883u16,4732u16),(21884u16,4737u16),(21886u16,4733u16),
(21888u16,4728u16),(21891u16,4738u16),(21892u16,3024u16),(21894u16,8328u16),
(21895u16,4740u16),(21897u16,2257u16),(21898u16,4730u16),(21899u16,3288u16),
(21912u16,4734u16),(21913u16,4727u16),(21914u16,1798u16),(21916u16,1863u16),
(21917u16,1760u16),(21918u16,4735u16),(21919u16,4731u16),(21927u16,2153u16),
(21928u16,4741u16),(21929u16,4739u16),(21930u16,3058u16),(21931u16,1921u16),
(21932u16,1985u16),(21934u16,4736u16),(21936u16,2057u16),(21942u16,1539u16),
(21956u16,4745u16),(21957u16,4743u16),(21959u16,4800u16),(21972u16,4748u16),
(21978u16,4742u16),(21980u16,4746u16),(21983u16,4744u16),(21987u16,2487u16),
(21988u16,4747u16),(22007u16,4750u16),(22009u16,4755u16),(22013u16,4753u16),
(22014u16,4752u16),(22022u16,3213u16),(22025u16,1634u16),(22036u16,4749u16),
(22038u16,4751u16),(22039u16,2733u16),(22040u16,1522u16),(22043u16,4754u16),
(22057u16,1659u16),(22063u16,4765u16),(22065u16,2817u16),(22066u16,4761u16),
(22068u16,4759u16),(22070u16,4760u16),(22072u16,4762u16),(22082u16,1532u16),
(22092u16,3032u16),(22094u16,4756u16),(22096u16,4757u16),(22107u16,1781u16),
(22116u16,4764u16),(22120u16,1864u16),(22122u16,4767u16),(22123u16,4763u16),
(22124u16,4766u16),(22132u16,3867u16),(22136u16,3530u16),(22138u16,3689u16),
(22144u16,4769u16),(22150u16,4768u16),(22151u16,1728u16),(22154u16,4770u16),
(22159u16,4773u16),(22164u16,4772u16),(22176u16,4771u16),(22178u16,3596u16),
(22181u16,4774u16),(22190u16,4775u16),(22196u16,4777u16),(22198u16,4776u16),
(22204u16,4779u16),(22208u16,4782u16),(22209u16,4780u16),(22210u16,4778u16),
(22211u16,4781u16),(22216u16,4783u16),(22222u16,4784u16),(22225u16,4785u16),
(22227u16,4786u16),(22231u16,4787u16),(22232u16,4548u16),(22234u16,2629u16),
(22235u16,2488u16),(22238u16,1680u16),(22240u16,1497u16),(22243u16,3231u16),
(22254u16,4788u16),(22256u16,2353u16),(22258u16,1456u16),(22259u16,2881u16),
(22265u16,4789u16),(22266u16,2200u16),(22269u16,2336u16),(22271u16,4791u16),
(22272u16,4790u16),(22275u16,3917u16),(22276u16,4792u16),(22280u16,4794u16),
(22281u16,4793u16),(22283u16,4795u16),(22285u16,4796u16),(22287u16,2154u16),
(22290u16,1567u16),(22291u16,4797u16),(22294u16,4799u16),(22296u16,4798u16),
(22300u16,4801u16),(22303u16,3441u16),(22310u16,4802u16),(22311u16,1430u16),
(22312u16,2412u16),(22317u16,2096u16),(22320u16,3242u16),(22327u16,4803u16),
(22328u16,4804u16),(22331u16,4806u16),(22336u16,4807u16),(22338u16,2417u16),
(22343u16,2022u16),(22346u16,3970u16),(22350u16,4805u16),(22351u16,4808u16),
(22352u16,2382u16),(22353u16,2258u16),(22361u16,8329u16),(22369u16,4812u16),
(22372u16,2354u16),(22373u16,8330u16),(22374u16,3214u16),(22377u16,4809u16),
(22378u16,3347u16),(22399u16,4813u16),(22402u16,2885u16),(22408u16,4811u16),
(22409u16,4814u16),(22411u16,2098u16),(22419u16,4815u16),(22432u16,4816u16),
(22434u16,2259u16),(22435u16,1723u16),(22436u16,4818u16),(22442u16,4819u16),
(22444u16,8331u16),(22448u16,4820u16),(22451u16,4817u16),(22464u16,4810u16),
(22467u16,4821u16),(22470u16,4822u16),(22471u16,8333u16),(22472u16,8332u16),
(22475u16,4015u16),(22478u16,2800u16),(22482u16,4824u16),(22483u16,4825u16),
(22484u16,4823u16),(22486u16,4827u16),(22492u16,3595u16),(22495u16,1481u16),
(22496u16,3813u16),(22499u16,4828u16),(22516u16,2818u16),(22519u16,2562u16),
(22521u16,3632u16),(22522u16,1865u16),(22524u16,2424u16),(22528u16,4004u16),
(22530u16,3495u16),(22533u16,2155u16),(22534u16,3148u16),(22538u16,4826u16),
(22539u16,4829u16),(22549u16,3137u16),(22553u16,4830u16),(22557u16,4831u16),
(22561u16,4833u16),(22564u16,3362u16),(22570u16,1799u16),(22575u16,7802u16),
(22576u16,1568u16),(22577u16,3936u16),(22580u16,2801u16),(22581u16,3423u16),
(22586u16,2419u16),(22589u16,4839u16),(22592u16,3882u16),(22593u16,4290u16),
(22602u16,1681u16),(22603u16,4835u16),(22609u16,3033u16),(22610u16,4838u16),
(22612u16,3450u16),(22615u16,3424u16),(22616u16,3451u16),(22617u16,3690u16),
(22618u16,3334u16),(22622u16,2390u16),(22626u16,4834u16),(22633u16,1589u16),
(22635u16,3405u16),(22640u16,4836u16),(22642u16,4832u16),(22645u16,2867u16),
(22649u16,4840u16),(22654u16,2677u16),(22659u16,1986u16),(22661u16,4841u16),
(22675u16,3925u16),(22679u16,3100u16),(22684u16,3327u16),(22686u16,8336u16),
(22687u16,4843u16),(22696u16,3994u16),(22699u16,4844u16),(22702u16,4849u16),
(22706u16,8337u16),(22707u16,3868u16),(22712u16,4848u16),(22713u16,4842u16),
(22714u16,4845u16),(22715u16,4847u16),(22718u16,2355u16),(22721u16,3894u16),
(22725u16,4850u16),(22727u16,3232u16),(22730u16,1682u16),(22732u16,2802u16),
(22737u16,4852u16),(22739u16,4851u16),(22741u16,2327u16),(22743u16,4853u16),
(22744u16,4855u16),(22745u16,4854u16),(22748u16,4857u16),(22750u16,4846u16),
(22751u16,4859u16),(22756u16,4858u16),(22757u16,4856u16),(22763u16,2489u16),
(22764u16,2868u16),(22766u16,3059u16),(22767u16,4860u16),(22768u16,2941u16),
(22769u16,1486u16),(22770u16,3639u16),(22775u16,3348u16),(22777u16,4862u16),
(22778u16,4861u16),(22779u16,4863u16),(22780u16,4864u16),(22781u16,4865u16),
(22786u16,4866u16),(22793u16,3902u16),(22794u16,4867u16),(22795u16,8338u16),
(22799u16,1635u16),(22800u16,4868u16),(22805u16,4163u16),(22806u16,1707u16),
(22808u16,4646u16),(22809u16,2671u16),(22810u16,3132u16),(22811u16,4869u16),
(22812u16,4116u16),(22818u16,4061u16),(22821u16,4871u16),(22823u16,3172u16),
(22825u16,3406u16),(22826u16,3133u16),(22827u16,3814u16),(22828u16,4872u16),
(22829u16,4873u16),(22830u16,1594u16),(22833u16,2563u16),(22834u16,4874u16),
(22839u16,1457u16),(22840u16,4875u16),(22846u16,4876u16),(22852u16,1569u16),
(22855u16,1866u16),(22856u16,3541u16),(22857u16,3937u16),(22862u16,4880u16),
(22863u16,3060u16),(22864u16,4879u16),(22865u16,2099u16),(22867u16,8339u16),
(22868u16,4006u16),(22869u16,4878u16),(22871u16,3452u16),(22872u16,4882u16),
(22874u16,4881u16),(22875u16,8340u16),(22877u16,8341u16),(22880u16,4884u16),
(22882u16,4883u16),(22883u16,8342u16),(22885u16,1595u16),(22887u16,4885u16),
(22888u16,2734u16),(22889u16,4887u16),(22890u16,3200u16),(22892u16,4886u16),
(22894u16,3872u16),(22899u16,2718u16),(22900u16,3442u16),(22904u16,4888u16),
(22909u16,2260u16),(22913u16,4889u16),(22914u16,3572u16),(22915u16,3727u16),
(22916u16,4090u16),(22922u16,3576u16),(22925u16,4898u16),(22931u16,1903u16),
(22934u16,4172u16),(22937u16,4056u16),(22939u16,4993u16),(22941u16,4890u16),
(22947u16,4893u16),(22948u16,8343u16),(22949u16,3138u16),(22952u16,3971u16),
(22956u16,3425u16),(22962u16,4894u16),(22969u16,4016u16),(22970u16,8344u16),
(22971u16,2391u16),(22974u16,2735u16),(22982u16,4895u16),(22985u16,2491u16),
(22987u16,2490u16),(22992u16,1434u16),(22993u16,2201u16),(22995u16,2924u16),
(22996u16,1458u16),(23001u16,4899u16),(23002u16,4900u16),(23004u16,4897u16),
(23013u16,1527u16),(23014u16,1800u16),(23016u16,4896u16),(23018u16,4078u16),
(23019u16,3776u16),(23030u16,1417u16),(23035u16,1498u16),(23039u16,2492u16),
(23041u16,1459u16),(23043u16,1412u16),(23049u16,4905u16),(23057u16,4903u16),
(23064u16,4069u16),(23066u16,4906u16),(23068u16,4904u16),(23071u16,4902u16),
(23072u16,2836u16),(23077u16,4901u16),(23081u16,3911u16),(23087u16,2229u16),
(23093u16,4910u16),(23094u16,4911u16),(23100u16,2736u16),(23104u16,4907u16),
(23105u16,4335u16),(23110u16,3615u16),(23113u16,4909u16),(23130u16,2356u16),
(23138u16,4912u16),(23142u16,3815u16),(23146u16,4913u16),(23148u16,4908u16),
(23167u16,4068u16),(23186u16,3633u16),(23194u16,4914u16),(23195u16,3777u16),
(23228u16,4915u16),(23229u16,4919u16),(23230u16,4916u16),(23233u16,1636u16),
(23234u16,4918u16),(23241u16,2564u16),(23243u16,4917u16),(23244u16,2156u16),
(23248u16,4931u16),(23254u16,4924u16),(23255u16,4921u16),(23265u16,3263u16),
(23267u16,4920u16),(23270u16,4922u16),(23273u16,4923u16),(23290u16,4925u16),
(23291u16,4926u16),(23305u16,1867u16),(23307u16,4928u16),(23308u16,4927u16),
(23318u16,4929u16),(23330u16,2803u16),(23338u16,4932u16),(23340u16,3349u16),
(23344u16,1540u16),(23346u16,4930u16),(23350u16,4933u16),(23358u16,4934u16),
(23360u16,4937u16),(23363u16,4935u16),(23365u16,4936u16),(23376u16,2493u16),
(23377u16,4938u16),(23380u16,2261u16),(23381u16,4939u16),(23382u16,8345u16),
(23383u16,2533u16),(23384u16,3125u16),(23386u16,4940u16),(23387u16,4941u16),
(23388u16,2501u16),(23389u16,2262u16),(23391u16,4091u16),(23395u16,1887u16),
(23396u16,2202u16),(23397u16,4942u16),(23398u16,1747u16),(23401u16,4943u16),
(23403u16,3126u16),(23408u16,4944u16),(23409u16,4984u16),(23411u16,4945u16),
(23413u16,4946u16),(23416u16,4947u16),(23418u16,4949u16),(23424u16,4950u16),
(23427u16,4951u16),(23429u16,3181u16),(23431u16,1510u16),(23432u16,2610u16),
(23433u16,1443u16),(23435u16,3062u16),(23436u16,1801u16),(23437u16,2558u16),
(23439u16,2263u16),(23445u16,3453u16),(23447u16,2632u16),(23448u16,1802u16),
(23449u16,3267u16),(23450u16,3363u16),(23451u16,1433u16),(23452u16,1904u16),
(23453u16,3938u16),(23455u16,2571u16),(23458u16,1929u16),(23459u16,2988u16),
(23460u16,2565u16),(23461u16,4143u16),(23462u16,4952u16),(23470u16,1939u16),
(23472u16,2392u16),(23475u16,1709u16),(23476u16,1570u16),(23477u16,2737u16),
(23478u16,1637u16),(23480u16,4953u16),(23481u16,4173u16),(23487u16,2672u16),
(23488u16,8346u16),(23490u16,2605u16),(23491u16,4954u16),(23492u16,1868u16),
(23493u16,3527u16),(23494u16,4050u16),(23495u16,4955u16),(23497u16,4956u16),
(23500u16,3816u16),(23504u16,4958u16),(23506u16,1793u16),(23507u16,2060u16),
(23508u16,4957u16),(23512u16,8348u16),(23515u16,1803u16),(23517u16,2837u16),
(23518u16,4962u16),(23519u16,2444u16),(23521u16,1638u16),(23522u16,4961u16),
(23524u16,4959u16),(23525u16,4963u16),(23526u16,4960u16),(23527u16,3582u16),
(23528u16,5590u16),(23529u16,2838u16),(23531u16,4964u16),(23532u16,8349u16),
(23534u16,4261u16),(23536u16,4965u16),(23539u16,4967u16),(23541u16,3289u16),
(23542u16,4966u16),(23544u16,2916u16),(23546u16,2534u16),(23550u16,3149u16),
(23551u16,2624u16),(23553u16,3844u16),(23554u16,2989u16),(23556u16,2582u16),
(23557u16,4968u16),(23558u16,2738u16),(23559u16,4969u16),(23560u16,4970u16),
(23561u16,1460u16),(23562u16,3127u16),(23563u16,2869u16),(23565u16,4971u16),
(23566u16,3496u16),(23567u16,2739u16),(23569u16,2740u16),(23571u16,4972u16),
(23574u16,2990u16),(23578u16,2741u16),(23582u16,8350u16),(23584u16,4973u16),
(23586u16,4974u16),(23588u16,4105u16),(23592u16,4975u16),(23597u16,2011u16),
(23601u16,2633u16),(23608u16,4976u16),(23609u16,4977u16),(23610u16,2597u16),
(23611u16,2831u16),(23612u16,3561u16),(23613u16,2871u16),(23614u16,3753u16),
(23615u16,3573u16),(23616u16,2014u16),(23617u16,4978u16),(23621u16,1958u16),
(23622u16,4979u16),(23624u16,2067u16),(23626u16,3524u16),(23627u16,1613u16),
(23629u16,2494u16),(23630u16,4980u16),(23631u16,4983u16),(23632u16,4982u16),
(23633u16,2066u16),(23635u16,4981u16),(23637u16,3407u16),(23646u16,3117u16),
(23648u16,3426u16),(23649u16,2577u16),(23652u16,3063u16),(23653u16,4225u16),
(23660u16,4985u16),(23662u16,4986u16),(23663u16,3531u16),(23665u16,2462u16),
(23670u16,4988u16),(23673u16,4989u16),(23692u16,4990u16),(23696u16,1869u16),
(23697u16,4991u16),(23700u16,4992u16),(23713u16,1609u16),(23718u16,8351u16),
(23720u16,3034u16),(23721u16,1853u16),(23723u16,4994u16),(23724u16,4049u16),
(23729u16,3151u16),(23731u16,1748u16),(23734u16,4996u16),(23735u16,4998u16),
(23736u16,1848u16),(23738u16,8352u16),(23739u16,4995u16),(23740u16,4997u16),
(23742u16,5000u16),(23749u16,4999u16),(23751u16,5001u16),(23769u16,5002u16),
(23776u16,3506u16),(23777u16,1987u16),(23784u16,1666u16),(23785u16,5003u16),
(23786u16,5008u16),(23789u16,5006u16),(23791u16,3940u16),(23792u16,3939u16),
(23797u16,8353u16),(23798u16,3454u16),(23802u16,5005u16),(23803u16,2683u16),
(23805u16,5004u16),(23815u16,2901u16),(23819u16,5009u16),(23822u16,2423u16),
(23825u16,5015u16),(23828u16,5016u16),(23829u16,5010u16),(23830u16,1710u16),
(23831u16,5011u16),(23832u16,5020u16),(23833u16,5019u16),(23834u16,5018u16),
(23835u16,5014u16),(23839u16,5013u16),(23842u16,5017u16),(23847u16,8354u16),
(23849u16,3941u16),(23874u16,8357u16),(23883u16,5024u16),(23884u16,5021u16),
(23886u16,5023u16),(23888u16,4217u16),(23890u16,5022u16),(23891u16,8355u16),
(23900u16,5012u16),(23913u16,2902u16),(23916u16,5025u16),(23917u16,8358u16),
(23919u16,2372u16),(23923u16,5026u16),(23926u16,5027u16),(23938u16,5030u16),
(23940u16,5029u16),(23943u16,5028u16),(23947u16,3455u16),(23948u16,5007u16),
(23952u16,5036u16),(23965u16,5032u16),(23970u16,5031u16),(23980u16,5033u16),
(23982u16,5034u16),(23991u16,5037u16),(23992u16,8359u16),(23993u16,8360u16),
(23994u16,4299u16),(23996u16,5038u16),(23997u16,5035u16),(24009u16,5039u16),
(24012u16,1849u16),(24013u16,5040u16),(24016u16,8361u16),(24018u16,5042u16),
(24019u16,5041u16),(24022u16,5043u16),(24027u16,5044u16),(24029u16,2991u16),
(24030u16,2634u16),(24033u16,2699u16),(24035u16,3074u16),(24037u16,2264u16),
(24038u16,2373u16),(24039u16,2265u16),(24040u16,1959u16),(24043u16,5045u16),
(24046u16,2374u16),(24049u16,2203u16),(24050u16,5046u16),(24051u16,4047u16),
(24052u16,3606u16),(24053u16,5047u16),(24055u16,2266u16),(24059u16,1797u16),
(24061u16,3202u16),(24062u16,2023u16),(24066u16,2495u16),(24067u16,3818u16),
(24070u16,3698u16),(24075u16,5048u16),(24076u16,1870u16),(24081u16,5051u16),
(24086u16,3290u16),(24089u16,5050u16),(24090u16,5049u16),(24091u16,5052u16),
(24093u16,3364u16),(24101u16,2886u16),(24107u16,2496u16),(24109u16,2955u16),
(24111u16,3152u16),(24112u16,1881u16),(24115u16,3291u16),(24118u16,5053u16),
(24119u16,5054u16),(24120u16,2804u16),(24125u16,3972u16),(24128u16,5057u16),
(24131u16,5056u16),(24132u16,5055u16),(24133u16,3852u16),(24135u16,5064u16),
(24140u16,4005u16),(24142u16,5058u16),(24148u16,5060u16),(24149u16,4022u16),
(24151u16,5059u16),(24159u16,5061u16),(24161u16,3673u16),(24162u16,5062u16),
(24163u16,3883u16),(24164u16,5063u16),(24178u16,1804u16),(24179u16,3884u16),
(24180u16,3586u16),(24181u16,5065u16),(24182u16,5066u16),(24184u16,2267u16),
(24185u16,1805u16),(24186u16,5067u16),(24187u16,2185u16),(24188u16,4171u16),
(24189u16,4144u16),(24190u16,1871u16),(24191u16,5069u16),(24193u16,3292u16),
(24195u16,2268u16),(24196u16,2742u16),(24199u16,3728u16),(24202u16,2743u16),
(24207u16,2719u16),(24213u16,3365u16),(24214u16,3942u16),(24215u16,3408u16),
(24218u16,2269u16),(24220u16,3819u16),(24224u16,5070u16),(24230u16,3440u16),
(24231u16,2383u16),(24235u16,2204u16),(24237u16,3366u16),(24245u16,1444u16),
(24246u16,2709u16),(24247u16,2270u16),(24248u16,4174u16),(24257u16,5071u16),
(24258u16,5072u16),(24259u16,3620u16),(24264u16,5073u16),(24265u16,4316u16),
(24266u16,4336u16),(24271u16,5075u16),(24272u16,5074u16),(24275u16,1730u16),
(24278u16,5076u16),(24282u16,5079u16),(24283u16,5080u16),(24285u16,5078u16),
(24287u16,3791u16),(24288u16,2744u16),(24289u16,5082u16),(24290u16,5081u16),
(24291u16,5077u16),(24296u16,5083u16),(24297u16,5084u16),(24300u16,5085u16),
(24304u16,5088u16),(24305u16,5086u16),(24307u16,5087u16),(24308u16,5089u16),
(24310u16,1571u16),(24311u16,3367u16),(24312u16,5090u16),(24314u16,2157u16),
(24315u16,1683u16),(24316u16,3593u16),(24318u16,5091u16),(24319u16,3568u16),
(24321u16,3912u16),(24323u16,5092u16),(24324u16,4337u16),(24329u16,5093u16),
(24330u16,3885u16),(24331u16,5096u16),(24332u16,4418u16),(24333u16,4434u16),
(24335u16,2553u16),(24336u16,3562u16),(24337u16,5097u16),(24339u16,1940u16),
(24340u16,3293u16),(24341u16,1499u16),(24342u16,5098u16),(24343u16,3859u16),
(24344u16,2271u16),(24347u16,3243u16),(24351u16,3368u16),(24353u16,8362u16),
(24357u16,4120u16),(24358u16,2186u16),(24359u16,2205u16),(24361u16,5099u16),
(24365u16,5100u16),(24367u16,5106u16),(24369u16,2606u16),(24372u16,8363u16),
(24373u16,3294u16),(24375u16,1988u16),(24376u16,5101u16),(24380u16,3770u16),
(24382u16,3233u16),(24385u16,5102u16),(24389u16,8283u16),(24392u16,5103u16),
(24394u16,1989u16),(24396u16,5104u16),(24398u16,5105u16),(24401u16,5107u16),
(24403u16,3469u16),(24406u16,5108u16),(24407u16,5109u16),(24409u16,5110u16),
(24412u16,5095u16),(24413u16,5094u16),(24417u16,5111u16),(24418u16,2100u16),
(24422u16,3766u16),(24423u16,8364u16),(24425u16,2393u16),(24426u16,3782u16),
(24427u16,3295u16),(24428u16,3802u16),(24429u16,5112u16),(24432u16,2745u16),
(24433u16,1541u16),(24435u16,5113u16),(24439u16,5114u16),(24441u16,4123u16),
(24444u16,3729u16),(24447u16,5117u16),(24448u16,1596u16),(24449u16,2925u16),
(24450u16,5116u16),(24451u16,5115u16),(24452u16,2101u16),(24453u16,3153u16),
(24455u16,5121u16),(24456u16,5119u16),(24458u16,5118u16),(24459u16,4236u16),
(24460u16,2230u16),(24464u16,2720u16),(24465u16,5120u16),(24466u16,3427u16),
(24467u16,2661u16),(24471u16,3509u16),(24472u16,5124u16),(24473u16,5123u16),
(24478u16,5122u16),(24480u16,5125u16),(24481u16,2231u16),(24488u16,5126u16),
(24489u16,3851u16),(24490u16,2690u16),(24493u16,5127u16),(24494u16,3754u16),
(24499u16,3510u16),(24500u16,3296u16),(24503u16,8365u16),(24505u16,3399u16),
(24508u16,5128u16),(24509u16,1890u16),(24515u16,2839u16),(24517u16,3771u16),
(24524u16,1872u16),(24525u16,3577u16),(24534u16,5129u16),(24535u16,2497u16),
(24536u16,3973u16),(24537u16,3974u16),(24540u16,1597u16),(24541u16,5134u16),
(24542u16,8366u16),(24544u16,3268u16),(24548u16,5131u16),(24555u16,1684u16),
(24560u16,5182u16),(24561u16,5133u16),(24565u16,3587u16),(24568u16,5132u16),
(24571u16,5130u16),(24573u16,2345u16),(24575u16,5136u16),(24590u16,5142u16),
(24591u16,5148u16),(24592u16,5140u16),(24594u16,3443u16),(24597u16,5145u16),
(24598u16,3820u16),(24601u16,5139u16),(24603u16,5144u16),(24604u16,4300u16),
(24605u16,2498u16),(24608u16,3154u16),(24609u16,5137u16),(24613u16,1941u16),
(24614u16,5147u16),(24615u16,2926u16),(24616u16,1572u16),(24617u16,5141u16),
(24618u16,1685u16),(24619u16,5146u16),(24623u16,1990u16),(24625u16,5143u16),
(24634u16,5149u16),(24641u16,5151u16),(24642u16,5161u16),(24643u16,5159u16),
(24646u16,5156u16),(24650u16,5155u16),(24651u16,4317u16),(24653u16,5157u16),
(24656u16,1991u16),(24658u16,2272u16),(24661u16,2721u16),(24665u16,5164u16),
(24666u16,5150u16),(24669u16,8367u16),(24671u16,5154u16),(24672u16,5138u16),
(24674u16,1687u16),(24675u16,5158u16),(24676u16,5160u16),(24677u16,3244u16),
(24680u16,2357u16),(24681u16,1621u16),(24682u16,5152u16),(24683u16,5163u16),
(24684u16,5162u16),(24685u16,1992u16),(24687u16,3110u16),(24688u16,1761u16),
(24693u16,2102u16),(24695u16,5153u16),(24705u16,5165u16),(24707u16,5168u16),
(24708u16,5170u16),(24709u16,8368u16),(24713u16,2566u16),(24714u16,8369u16),
(24715u16,5176u16),(24716u16,3369u16),(24717u16,5166u16),(24722u16,5174u16),
(24724u16,1686u16),(24726u16,5172u16),(24727u16,5173u16),(24730u16,5169u16),
(24731u16,5171u16),(24735u16,2232u16),(24736u16,4145u16),(24739u16,1806u16),
(24742u16,1560u16),(24743u16,5175u16),(24745u16,3597u16),(24746u16,1422u16),
(24754u16,3730u16),(24755u16,5135u16),(24756u16,5181u16),(24757u16,5185u16),
(24758u16,4110u16),(24760u16,5178u16),(24764u16,3456u16),(24765u16,5183u16),
(24773u16,2805u16),(24774u16,5184u16),(24775u16,3532u16),(24785u16,4362u16),
(24787u16,5180u16),(24789u16,8371u16),(24792u16,5186u16),(24794u16,2346u16),
(24796u16,2956u16),(24798u16,8370u16),(24799u16,1461u16),(24800u16,5179u16),
(24801u16,5177u16),(24803u16,3065u16),(24807u16,5167u16),(24808u16,2463u16),
(24816u16,3139u16),(24817u16,5198u16),(24818u16,8373u16),(24819u16,3066u16),
(24820u16,5193u16),(24822u16,5190u16),(24823u16,5191u16),(24825u16,2607u16),
(24826u16,5194u16),(24827u16,5197u16),(24832u16,5192u16),(24833u16,2636u16),
(24835u16,5195u16),(24838u16,5189u16),(24840u16,4133u16),(24841u16,4132u16),
(24845u16,5199u16),(24846u16,5200u16),(24847u16,1462u16),(24849u16,8374u16),
(24853u16,5188u16),(24858u16,2055u16),(24859u16,1415u16),(24863u16,1807u16),
(24864u16,8372u16),(24865u16,5196u16),(24871u16,5204u16),(24872u16,5203u16),
(24876u16,5208u16),(24880u16,8376u16),(24884u16,5209u16),(24887u16,8375u16),
(24892u16,5207u16),(24893u16,5210u16),(24894u16,5202u16),(24895u16,5206u16),
(24898u16,5211u16),(24900u16,5212u16),(24903u16,5201u16),(24904u16,2535u16),
(24906u16,5205u16),(24907u16,3155u16),(24908u16,2273u16),(24909u16,5187u16),
(24910u16,2840u16),(24915u16,5225u16),(24917u16,3926u16),(24920u16,5215u16),
(24921u16,5216u16),(24922u16,5217u16),(24925u16,5224u16),(24927u16,5223u16),
(24930u16,4040u16),(24931u16,1808u16),(24933u16,5221u16),(24935u16,2104u16),
(24936u16,1711u16),(24939u16,5218u16),(24942u16,4253u16),(24943u16,5220u16),
(24944u16,1463u16),(24945u16,5222u16),(24947u16,5213u16),(24948u16,5219u16),
(24949u16,5226u16),(24950u16,2103u16),(24951u16,5214u16),(24958u16,4196u16),
(24962u16,4146u16),(24967u16,5229u16),(24970u16,5233u16),(24974u16,3101u16),
(24976u16,4318u16),(24977u16,5234u16),(24980u16,5231u16),(24982u16,5228u16),
(24984u16,8377u16),(24985u16,5227u16),(24986u16,5232u16),(24996u16,3869u16),
(24999u16,3497u16),(25001u16,2105u16),(25003u16,5235u16),(25004u16,5230u16),
(25006u16,5236u16),(25010u16,2158u16),(25014u16,1614u16),(25018u16,5244u16),
(25022u16,1809u16),(25027u16,5242u16),(25030u16,5243u16),(25031u16,2358u16),
(25032u16,5241u16),(25033u16,5239u16),(25034u16,5238u16),(25035u16,5245u16),
(25036u16,5237u16),(25037u16,5247u16),(25040u16,1688u16),(25059u16,5249u16),
(25062u16,5248u16),(25074u16,3297u16),(25076u16,5252u16),(25078u16,5250u16),
(25079u16,5240u16),(25080u16,2159u16),(25082u16,5251u16),(25084u16,5255u16),
(25085u16,5254u16),(25086u16,5256u16),(25087u16,5253u16),(25088u16,5257u16),
(25096u16,5258u16),(25097u16,5259u16),(25098u16,3927u16),(25100u16,5261u16),
(25101u16,5260u16),(25102u16,2662u16),(25104u16,2927u16),(25105u16,1667u16),
(25106u16,1689u16),(25107u16,8378u16),(25108u16,5262u16),(25110u16,1440u16),
(25114u16,2957u16),(25115u16,5263u16),(25117u16,7084u16),(25118u16,5264u16),
(25119u16,2132u16),(25121u16,5265u16),(25126u16,2992u16),(25130u16,5266u16),
(25134u16,5267u16),(25135u16,1905u16),(25136u16,5268u16),(25138u16,5269u16),
(25139u16,5270u16),(25140u16,3156u16),(25144u16,2206u16),(25147u16,4106u16),
(25151u16,3975u16),(25152u16,2705u16),(25153u16,5271u16),(25159u16,2993u16),
(25160u16,7266u16),(25161u16,3731u16),(25163u16,2611u16),(25165u16,2394u16),
(25166u16,5272u16),(25171u16,3140u16),(25173u16,3860u16),(25176u16,3182u16),
(25179u16,5275u16),(25182u16,5273u16),(25184u16,5276u16),(25187u16,5274u16),
(25192u16,5277u16),(25198u16,3870u16),(25201u16,1432u16),(25206u16,3821u16),
(25209u16,3732u16),(25212u16,5278u16),(25214u16,5281u16),(25215u16,2746u16),
(25216u16,1906u16),(25218u16,5279u16),(25219u16,5286u16),(25220u16,2747u16),
(25225u16,5280u16),(25226u16,3607u16),(25233u16,4197u16),(25234u16,5282u16),
(25235u16,5283u16),(25236u16,5287u16),(25237u16,3457u16),(25238u16,5284u16),
(25239u16,2274u16),(25240u16,2975u16),(25243u16,5301u16),(25244u16,3685u16),
(25246u16,3183u16),(25254u16,8379u16),(25259u16,3733u16),(25260u16,5370u16),
(25265u16,3943u16),(25269u16,3370u16),(25273u16,4032u16),(25275u16,5290u16),
(25276u16,1598u16),(25277u16,3269u16),(25282u16,5299u16),(25285u16,3215u16),
(25286u16,5293u16),(25287u16,5300u16),(25288u16,5295u16),(25289u16,5302u16),
(25290u16,5298u16),(25292u16,5297u16),(25293u16,3650u16),(25295u16,5291u16),
(25296u16,1690u16),(25297u16,5289u16),(25298u16,1960u16),(25299u16,3184u16),
(25300u16,5285u16),(25303u16,5288u16),(25304u16,2275u16),(25305u16,2972u16),
(25307u16,2748u16),(25308u16,5296u16),(25309u16,3621u16),(25312u16,1961u16),
(25313u16,1731u16),(25324u16,1762u16),(25325u16,2820u16),(25326u16,5304u16),
(25327u16,5309u16),(25329u16,5305u16),(25331u16,2160u16),(25333u16,5310u16),
(25334u16,2445u16),(25335u16,2328u16),(25342u16,2637u16),(25343u16,5292u16),
(25345u16,2536u16),(25346u16,5307u16),(25351u16,2499u16),(25352u16,5308u16),
(25353u16,1445u16),(25356u16,5303u16),(25361u16,3298u16),(25369u16,1962u16),
(25375u16,1993u16),(25383u16,5306u16),(25384u16,1416u16),(25387u16,2384u16),
(25391u16,2841u16),(25402u16,3371u16),(25405u16,3717u16),(25406u16,5312u16),
(25407u16,3069u16),(25417u16,3111u16),(25420u16,2454u16),(25421u16,5313u16),
(25423u16,5315u16),(25424u16,5311u16),(25429u16,3918u16),(25431u16,3318u16),
(25436u16,3067u16),(25447u16,3944u16),(25448u16,2583u16),(25449u16,5327u16),
(25451u16,5326u16),(25454u16,2907u16),(25458u16,2161u16),(25462u16,5320u16),
(25463u16,2750u16),(25466u16,3549u16),(25467u16,3588u16),(25472u16,5318u16),
(25475u16,3068u16),(25480u16,2625u16),(25481u16,5323u16),(25484u16,2749u16),
(25486u16,5317u16),(25487u16,5322u16),(25490u16,3622u16),(25494u16,5316u16),
(25496u16,2068u16),(25499u16,1752u16),(25503u16,5324u16),(25504u16,4240u16),
(25505u16,2395u16),(25506u16,3216u16),(25507u16,5321u16),(25509u16,2973u16),
(25511u16,2276u16),(25512u16,2887u16),(25513u16,1573u16),(25514u16,3035u16),
(25515u16,5319u16),(25516u16,1916u16),(25522u16,2106u16),(25524u16,3336u16),
(25525u16,5325u16),(25531u16,3070u16),(25534u16,5328u16),(25536u16,5330u16),
(25539u16,3124u16),(25540u16,5336u16),(25542u16,5331u16),(25545u16,5333u16),
(25551u16,3792u16),(25552u16,3372u16),(25554u16,5334u16),(25558u16,4147u16),
(25562u16,4175u16),(25563u16,1810u16),(25569u16,1423u16),(25571u16,5332u16),
(25577u16,5329u16),(25582u16,1873u16),(25588u16,1574u16),(25589u16,8380u16),
(25590u16,5335u16),(25594u16,4176u16),(25606u16,5339u16),(25613u16,3128u16),
(25615u16,5346u16),(25619u16,5340u16),(25622u16,5337u16),(25623u16,5344u16),
(25628u16,5314u16),(25638u16,5341u16),(25640u16,5345u16),(25644u16,3699u16),
(25645u16,3458u16),(25652u16,5338u16),(25654u16,5342u16),(25658u16,2107u16),
(25662u16,2430u16),(25666u16,2974u16),(25678u16,5350u16),(25688u16,3389u16),
(25696u16,8381u16),(25703u16,5347u16),(25705u16,4011u16),(25711u16,5348u16),
(25718u16,5349u16),(25720u16,4087u16),(25722u16,2915u16),(25731u16,2133u16),
(25736u16,5356u16),(25746u16,2464u16),(25747u16,5353u16),(25749u16,5352u16),
(25754u16,3589u16),(25757u16,8382u16),(25758u16,3498u16),(25764u16,3400u16),
(25765u16,5354u16),(25769u16,5355u16),(25771u16,3838u16),(25773u16,3608u16),
(25774u16,2446u16),(25776u16,2994u16),(25778u16,3995u16),(25785u16,1732u16),
(25787u16,5362u16),(25788u16,5357u16),(25793u16,4177u16),(25794u16,5364u16),
(25797u16,5360u16),(25799u16,5361u16),(25805u16,3071u16),(25806u16,8383u16),
(25810u16,5359u16),(25812u16,5294u16),(25816u16,5363u16),(25818u16,5358u16),
(25824u16,5368u16),(25825u16,5369u16),(25826u16,3390u16),(25827u16,5371u16),
(25830u16,2447u16),(25831u16,5366u16),(25836u16,1907u16),(25839u16,5372u16),
(25841u16,5365u16),(25842u16,5376u16),(25844u16,5375u16),(25846u16,5374u16),
(25850u16,5377u16),(25853u16,5379u16),(25854u16,2806u16),(25856u16,5378u16),
(25861u16,5382u16),(25880u16,5380u16),(25884u16,5381u16),(25885u16,5343u16),
(25891u16,5384u16),(25892u16,5383u16),(25898u16,5351u16),(25899u16,5385u16),
(25900u16,5373u16),(25903u16,2500u16),(25908u16,5386u16),(25909u16,5387u16),
(25910u16,5389u16),(25911u16,5388u16),(25912u16,5390u16),(25913u16,1691u16),
(25915u16,2277u16),(25918u16,3945u16),(25919u16,2928u16),(25925u16,2207u16),
(25928u16,5392u16),(25933u16,5395u16),(25934u16,8384u16),(25935u16,3809u16),
(25937u16,1942u16),(25941u16,5394u16),(25942u16,5393u16),(25943u16,3623u16),
(25944u16,5396u16),(25945u16,1994u16),(25949u16,5398u16),(25950u16,5397u16),
(25954u16,1811u16),(25955u16,2465u16),(25958u16,3533u16),(25964u16,2108u16),
(25968u16,2903u16),(25970u16,5399u16),(25972u16,2929u16),(25973u16,3391u16),
(25975u16,3822u16),(25976u16,5400u16),(25986u16,5401u16),(25987u16,5402u16),
(25991u16,3877u16),(25992u16,4948u16),(25993u16,2951u16),(25996u16,3803u16),
(25998u16,2405u16),(26000u16,3734u16),(26001u16,3700u16),(26007u16,3428u16),
(26009u16,4262u16),(26011u16,5404u16),(26012u16,2585u16),(26015u16,5405u16),
(26017u16,1431u16),(26020u16,2025u16),(26021u16,2958u16),(26023u16,3823u16),
(26027u16,5406u16),(26028u16,2477u16),(26029u16,3234u16),(26031u16,2502u16),
(26032u16,2842u16),(26039u16,5407u16),(26041u16,3946u16),(26044u16,1590u16),
(26045u16,2503u16),(26049u16,5410u16),(26051u16,5408u16),(26052u16,5411u16),
(26053u16,4254u16),(26054u16,5409u16),(26059u16,3004u16),(26060u16,5412u16),
(26063u16,3119u16),(26066u16,5413u16),(26071u16,1875u16),(26073u16,5415u16),
(26075u16,5414u16),(26080u16,5416u16),(26081u16,5417u16),(26082u16,1876u16),
(26085u16,3569u16),(26086u16,3217u16),(26087u16,1955u16),(26088u16,2504u16),
(26089u16,3072u16),(26092u16,2691u16),(26093u16,1425u16),(26097u16,5418u16),
(26106u16,1599u16),(26107u16,5422u16),(26112u16,8385u16),(26114u16,2278u16),
(26115u16,5421u16),(26118u16,2360u16),(26119u16,2751u16),(26121u16,8388u16),
(26122u16,5420u16),(26124u16,2752u16),(26126u16,4073u16),(26127u16,2359u16),
(26131u16,1464u16),(26132u16,2959u16),(26133u16,8386u16),(26140u16,5427u16),
(26142u16,8390u16),(26143u16,2930u16),(26144u16,1542u16),(26148u16,8391u16),
(26149u16,2684u16),(26151u16,4017u16),(26152u16,2431u16),(26157u16,2753u16),
(26158u16,8389u16),(26159u16,2920u16),(26161u16,8279u16),(26164u16,5426u16),
(26165u16,5424u16),(26166u16,5425u16),(26171u16,8387u16),(26172u16,3270u16),
(26175u16,5457u16),(26177u16,5431u16),(26178u16,2537u16),(26179u16,2279u16),
(26180u16,5429u16),(26185u16,5430u16),(26187u16,2843u16),(26191u16,5428u16),
(26194u16,2458u16),(26199u16,8393u16),(26201u16,8394u16),(26205u16,5433u16),
(26206u16,5432u16),(26207u16,5437u16),(26210u16,5438u16),(26212u16,5434u16),
(26213u16,8392u16),(26214u16,1693u16),(26215u16,5435u16),(26216u16,5436u16),
(26217u16,3718u16),(26222u16,3824u16),(26223u16,2109u16),(26224u16,5439u16),
(26227u16,8396u16),(26228u16,2931u16),(26230u16,2754u16),(26234u16,3245u16),
(26241u16,2012u16),(26243u16,5440u16),(26244u16,5444u16),(26247u16,1640u16),
(26248u16,5441u16),(26249u16,5443u16),(26254u16,5442u16),(26257u16,2706u16),
(26262u16,3235u16),(26263u16,1446u16),(26264u16,5445u16),(26265u16,8397u16),
(26269u16,5446u16),(26272u16,8398u16),(26274u16,3299u16),(26278u16,4310u16),
(26283u16,2478u16),(26286u16,3928u16),(26290u16,8399u16),(26292u16,3976u16),
(26296u16,5453u16),(26297u16,5448u16),(26300u16,5451u16),(26302u16,5450u16),
(26303u16,8400u16),(26305u16,5447u16),(26308u16,5452u16),(26311u16,3539u16),
(26313u16,5449u16),(26326u16,5454u16),(26329u16,2707u16),(26330u16,5455u16),
(26332u16,4178u16),(26333u16,3659u16),(26336u16,5456u16),(26342u16,5458u16),
(26345u16,5459u16),(26352u16,5460u16),(26354u16,2015u16),(26355u16,1543u16),
(26356u16,2280u16),(26357u16,5461u16),(26359u16,5462u16),(26360u16,2712u16),
(26361u16,3073u16),(26362u16,8401u16),(26363u16,8282u16),(26364u16,4661u16),
(26365u16,3037u16),(26366u16,3036u16),(26367u16,3157u16),(26368u16,2388u16),
(26371u16,4499u16),(26376u16,2145u16),(26377u16,4148u16),(26379u16,3947u16),
(26381u16,3853u16),(26382u16,8402u16),(26383u16,5463u16),(26388u16,2432u16),
(26389u16,3320u16),(26390u16,5464u16),(26391u16,4338u16),(26395u16,3977u16),
(26397u16,3300u16),(26398u16,5465u16),(26399u16,1877u16),(26406u16,5466u16),
(26407u16,5467u16),(26408u16,4099u16),(26410u16,4045u16),(26411u16,4033u16),
(26412u16,4007u16),(26413u16,2448u16),(26414u16,5469u16),(26417u16,2612u16),
(26420u16,3996u16),(26422u16,5471u16),(26423u16,5474u16),(26424u16,5473u16),
(26426u16,1874u16),(26429u16,1943u16),(26431u16,5470u16),(26433u16,5472u16),
(26438u16,5475u16),(26441u16,2908u16),(26446u16,4226u16),(26447u16,1450u16),
(26448u16,2413u16),(26449u16,3129u16),(26451u16,2598u16),(26454u16,2808u16),
(26457u16,5478u16),(26460u16,3429u16),(26462u16,5476u16),(26463u16,3112u16),
(26464u16,5477u16),(26465u16,2807u16),(26466u16,4102u16),(26467u16,5479u16),
(26468u16,5480u16),(26469u16,4207u16),(26470u16,8404u16),(26474u16,5485u16),
(26477u16,2281u16),(26479u16,3624u16),(26480u16,5482u16),(26481u16,3459u16),
(26482u16,5419u16),(26483u16,5423u16),(26485u16,1926u16),(26487u16,3610u16),
(26492u16,5484u16),(26494u16,2755u16),(26495u16,3701u16),(26501u16,5490u16),
(26503u16,3755u16),(26505u16,5481u16),(26507u16,5487u16),(26508u16,5486u16),
(26512u16,2960u16),(26517u16,4024u16),(26519u16,4280u16),(26522u16,4018u16),
(26524u16,1641u16),(26525u16,2505u16),(26528u16,4363u16),(26529u16,5489u16),
(26530u16,2904u16),(26534u16,5488u16),(26537u16,5483u16),(26543u16,2208u16),
(26547u16,5495u16),(26548u16,5493u16),(26550u16,1642u16),(26551u16,5491u16),
(26552u16,5497u16),(26553u16,5503u16),(26555u16,8405u16),(26560u16,8407u16),
(26561u16,3141u16),(26564u16,3886u16),(26566u16,5505u16),(26570u16,3761u16),
(26574u16,5504u16),(26575u16,3651u16),(26576u16,3978u16),(26577u16,1812u16),
(26579u16,3000u16),(26580u16,2663u16),(26584u16,3340u16),(26586u16,4149u16),
(26589u16,5500u16),(26590u16,5499u16),(26594u16,5501u16),(26596u16,5498u16),
(26599u16,5506u16),(26601u16,5496u16),(26604u16,5494u16),(26606u16,5502u16),
(26607u16,5492u16),(26609u16,3271u16),(26611u16,4129u16),(26612u16,2575u16),
(26613u16,2433u16),(26619u16,2375u16),(26622u16,4026u16),(26623u16,1724u16),
(26625u16,8408u16),(26626u16,3335u16),(26627u16,3519u16),(26628u16,1544u16),
(26643u16,2995u16),(26646u16,2933u16),(26647u16,2077u16),(26654u16,5508u16),
(26657u16,2282u16),(26658u16,1783u16),(26665u16,5510u16),(26666u16,1775u16),
(26667u16,5516u16),(26674u16,5513u16),(26676u16,2996u16),(26680u16,1734u16),
(26681u16,2361u16),(26684u16,1733u16),(26685u16,2396u16),(26688u16,5511u16),
(26689u16,2136u16),(26690u16,2110u16),(26691u16,3460u16),(26692u16,8409u16),
(26694u16,5509u16),(26696u16,1447u16),(26701u16,5512u16),(26702u16,5514u16),
(26704u16,2018u16),(26705u16,2079u16),(26706u16,8406u16),(26707u16,1813u16),
(26708u16,1922u16),(26713u16,5517u16),(26716u16,2438u16),(26717u16,4028u16),
(26719u16,2466u16),(26723u16,5518u16),(26727u16,3775u16),(26740u16,5530u16),
(26742u16,1616u16),(26743u16,5519u16),(26750u16,5536u16),(26751u16,5520u16),
(26753u16,4263u16),(26755u16,5527u16),(26757u16,3634u16),(26765u16,5535u16),
(26767u16,5522u16),(26771u16,1429u16),(26772u16,5524u16),(26775u16,2283u16),
(26779u16,5526u16),(26781u16,5525u16),(26783u16,5521u16),(26784u16,5532u16),
(26786u16,2756u16),(26790u16,4870u16),(26791u16,2233u16),(26792u16,4227u16),
(26797u16,5523u16),(26799u16,3373u16),(26800u16,1694u16),(26801u16,2362u16),
(26803u16,5515u16),(26805u16,5531u16),(26806u16,1756u16),(26809u16,5529u16),
(26810u16,5533u16),(26812u16,3461u16),(26820u16,1879u16),(26822u16,5563u16),
(26824u16,8280u16),(26825u16,4082u16),(26826u16,5538u16),(26827u16,1878u16),
(26829u16,5545u16),(26831u16,8410u16),(26834u16,3979u16),(26836u16,5546u16),
(26837u16,5548u16),(26839u16,5552u16),(26840u16,5540u16),(26842u16,3205u16),
(26847u16,3462u16),(26848u16,5556u16),(26849u16,5543u16),(26851u16,5553u16),
(26855u16,5547u16),(26862u16,2844u16),(26863u16,5557u16),(26866u16,2932u16),
(26873u16,5555u16),(26874u16,1814u16),(26880u16,4371u16),(26881u16,5537u16),
(26884u16,5551u16),(26885u16,1465u16),(26888u16,5539u16),(26891u16,4067u16),
(26892u16,5544u16),(26893u16,2821u16),(26894u16,3328u16),(26895u16,5534u16),
(26898u16,5550u16),(26905u16,2909u16),(26906u16,5560u16),(26907u16,1772u16),
(26908u16,2162u16),(26913u16,5562u16),(26914u16,5541u16),(26915u16,5561u16),
(26917u16,5554u16),(26918u16,5542u16),(26920u16,5558u16),(26922u16,5559u16),
(26928u16,5576u16),(26932u16,3523u16),(26934u16,5549u16),(26937u16,5572u16),
(26941u16,5574u16),(26943u16,3345u16),(26954u16,4179u16),(26963u16,3845u16),
(26964u16,5569u16),(26965u16,3143u16),(26969u16,5575u16),(26970u16,3038u16),
(26972u16,5566u16),(26973u16,5579u16),(26974u16,5578u16),(26976u16,3556u16),
(26977u16,5577u16),(26978u16,3551u16),(26984u16,8412u16),(26986u16,5581u16),
(26987u16,5568u16),(26989u16,2013u16),(26990u16,5571u16),(26991u16,2692u16),
(26995u16,3635u16),(26996u16,5573u16),(26997u16,2016u16),(26999u16,5565u16),
(27000u16,5567u16),(27001u16,5564u16),(27004u16,4339u16),(27005u16,1749u16),
(27006u16,5570u16),(27009u16,5580u16),(27010u16,1712u16),(27018u16,2420u16),
(27022u16,1564u16),(27025u16,5597u16),(27028u16,4340u16),(27029u16,5600u16),
(27032u16,8414u16),(27035u16,2845u16),(27036u16,5599u16),(27040u16,5598u16),
(27047u16,5595u16),(27054u16,5583u16),(27057u16,5612u16),(27058u16,5582u16),
(27060u16,5601u16),(27067u16,5593u16),(27070u16,5588u16),(27071u16,5585u16),
(27073u16,5586u16),(27075u16,5594u16),(27079u16,7803u16),(27082u16,5591u16),
(27083u16,2284u16),(27084u16,3329u16),(27085u16,3075u16),(27086u16,5589u16),
(27088u16,5584u16),(27091u16,5587u16),(27096u16,4180u16),(27097u16,4021u16),
(27101u16,5592u16),(27102u16,5602u16),(27106u16,8415u16),(27111u16,5610u16),
(27112u16,5603u16),(27115u16,5616u16),(27117u16,5614u16),(27122u16,5609u16),
(27129u16,5608u16),(27131u16,3337u16),(27133u16,3076u16),(27135u16,5606u16),
(27138u16,5604u16),(27141u16,5611u16),(27146u16,5617u16),(27147u16,3750u16),
(27148u16,5623u16),(27154u16,5618u16),(27155u16,5621u16),(27156u16,5615u16),
(27159u16,3279u16),(27161u16,3783u16),(27163u16,5605u16),(27166u16,5613u16),
(27167u16,2757u16),(27169u16,4088u16),(27170u16,5633u16),(27171u16,5620u16),
(27177u16,2163u16),(27178u16,1600u16),(27179u16,1754u16),(27182u16,5596u16),
(27184u16,8416u16),(27189u16,2758u16),(27190u16,5625u16),(27192u16,5632u16),
(27193u16,2626u16),(27194u16,1773u16),(27197u16,3209u16),(27204u16,5622u16),
(27206u16,8418u16),(27207u16,5627u16),(27208u16,5631u16),(27211u16,1995u16),
(27224u16,1923u16),(27225u16,5629u16),(27231u16,1880u16),(27233u16,3520u16),
(27234u16,5628u16),(27238u16,5630u16),(27243u16,8417u16),(27250u16,5624u16),
(27251u16,8419u16),(27256u16,5626u16),(27262u16,8420u16),(27263u16,1755u16),
(27264u16,3236u16),(27268u16,5637u16),(27277u16,5635u16),(27278u16,2234u16),
(27280u16,5634u16),(27287u16,5640u16),(27292u16,5507u16),(27296u16,5636u16),
(27298u16,5638u16),(27299u16,5639u16),(27306u16,5651u16),(27308u16,5647u16),
(27310u16,5528u16),(27315u16,5646u16),(27320u16,5645u16),(27323u16,5642u16),
(27329u16,5619u16),(27330u16,5644u16),(27331u16,5643u16),(27345u16,5649u16),
(27347u16,4329u16),(27354u16,5652u16),(27355u16,2064u16),(27358u16,5648u16),
(27359u16,5650u16),(27362u16,8421u16),(27364u16,8422u16),(27368u16,3672u16),
(27370u16,5653u16),(27386u16,5657u16),(27387u16,5654u16),(27396u16,4218u16),
(27397u16,5655u16),(27402u16,5607u16),(27410u16,5658u16),(27414u16,5659u16),
(27421u16,1524u16),(27423u16,5661u16),(27424u16,2138u16),(27425u16,2538u16),
(27427u16,2026u16),(27431u16,1601u16),(27442u16,4198u16),(27447u16,5663u16),
(27448u16,5662u16),(27449u16,5665u16),(27450u16,1908u16),(27453u16,2027u16),
(27454u16,1815u16),(27459u16,5668u16),(27463u16,5667u16),(27465u16,5669u16),
(27468u16,1643u16),(27470u16,3218u16),(27472u16,5670u16),(27475u16,1816u16),
(27476u16,5672u16),(27481u16,5671u16),(27483u16,5673u16),(27487u16,5674u16),
(27489u16,5675u16),(27490u16,2506u16),(27491u16,2934u16),(27492u16,2350u16),
(27494u16,3839u16),(27497u16,3919u16),(27498u16,4359u16),(27503u16,2528u16),
(27507u16,2397u16),(27508u16,4311u16),(27512u16,5676u16),(27513u16,5677u16),
(27515u16,2507u16),(27519u16,5678u16),(27520u16,5679u16),(27523u16,5681u16),
(27524u16,5680u16),(27526u16,4003u16),(27529u16,2693u16),(27530u16,2613u16),
(27531u16,2479u16),(27533u16,5682u16),(27541u16,5684u16),(27542u16,2822u16),
(27544u16,5683u16),(27550u16,5685u16),(27556u16,5686u16),(27562u16,5687u16),
(27563u16,5688u16),(27567u16,5689u16),(27569u16,5691u16),(27570u16,5690u16),
(27571u16,5692u16),(27572u16,1602u16),(27573u16,3237u16),(27575u16,5693u16),
(27578u16,2449u16),(27579u16,1735u16),(27580u16,5694u16),(27583u16,3417u16),
(27584u16,4837u16),(27589u16,1882u16),(27590u16,5695u16),(27595u16,5696u16),
(27597u16,3929u16),(27598u16,4019u16),(27602u16,3516u16),(27603u16,5697u16),
(27604u16,3735u16),(27606u16,8423u16),(27608u16,3756u16),(27611u16,4092u16),
(27615u16,5698u16),(27627u16,5700u16),(27628u16,5699u16),(27631u16,5702u16),
(27635u16,5701u16),(27656u16,5704u16),(27663u16,2508u16),(27665u16,4058u16),
(27667u16,5705u16),(27668u16,5706u16),(27671u16,1883u16),(27675u16,5707u16),
(27683u16,5709u16),(27684u16,5708u16),(27700u16,2888u16),(27703u16,3784u16),
(27704u16,1545u16),(27710u16,3702u16),(27711u16,8424u16),(27712u16,3374u16),
(27713u16,2664u16),(27714u16,1944u16),(27726u16,3703u16),(27728u16,2551u16),
(27733u16,5711u16),(27735u16,1817u16),(27738u16,1591u16),(27740u16,8425u16),
(27741u16,3559u16),(27742u16,5710u16),(27743u16,2285u16),(27744u16,3246u16),
(27746u16,5712u16),(27752u16,5720u16),(27754u16,5713u16),(27759u16,8427u16),
(27760u16,3134u16),(27762u16,1945u16),(27763u16,5721u16),(27770u16,2139u16),
(27773u16,1884u16),(27774u16,5719u16),(27777u16,5717u16),(27778u16,5714u16),
(27779u16,4199u16),(27782u16,8426u16),(27784u16,3321u16),(27788u16,3534u16),
(27789u16,5715u16),(27792u16,5723u16),(27794u16,5722u16),(27795u16,2070u16),
(27798u16,1610u16),(27801u16,2376u16),(27802u16,5716u16),(27803u16,5718u16),
(27809u16,4002u16),(27810u16,3185u16),(27819u16,4034u16),(27822u16,5731u16),
(27825u16,5732u16),(27827u16,1644u16),(27832u16,3861u16),(27833u16,4134u16),
(27834u16,5734u16),(27835u16,2540u16),(27836u16,2759u16),(27837u16,5727u16),
(27838u16,5733u16),(27839u16,1575u16),(27841u16,1996u16),(27844u16,5724u16),
(27845u16,5729u16),(27849u16,2997u16),(27850u16,3652u16),(27852u16,3736u16),
(27859u16,5726u16),(27861u16,3948u16),(27863u16,5728u16),(27865u16,5737u16),
(27866u16,8428u16),(27867u16,5735u16),(27869u16,5730u16),(27873u16,3949u16),
(27874u16,3611u16),(27875u16,1946u16),(27877u16,3388u16),(27880u16,3272u16),
(27882u16,5738u16),(27887u16,5736u16),(27888u16,3158u16),(27889u16,5725u16),
(27891u16,1546u16),(27908u16,8429u16),(27915u16,4181u16),(27916u16,5749u16),
(27922u16,5748u16),(27927u16,2999u16),(27929u16,5745u16),(27931u16,4211u16),
(27934u16,3499u16),(27935u16,5739u16),(27941u16,3326u16),(27945u16,1547u16),
(27946u16,2286u16),(27947u16,5742u16),(27954u16,2638u16),(27955u16,5747u16),
(27957u16,5746u16),(27958u16,5741u16),(27960u16,5744u16),(27963u16,1763u16),
(27965u16,5743u16),(27966u16,3612u16),(27969u16,4243u16),(27972u16,2809u16),
(27973u16,2998u16),(27993u16,5755u16),(27994u16,5753u16),(27996u16,3804u16),
(28003u16,5750u16),(28004u16,5752u16),(28006u16,1529u16),(28009u16,2287u16),
(28010u16,4341u16),(28012u16,1720u16),(28014u16,3825u16),(28015u16,8431u16),
(28020u16,4200u16),(28023u16,1695u16),(28024u16,2846u16),(28025u16,5754u16),
(28037u16,5759u16),(28039u16,8430u16),(28040u16,2760u16),(28044u16,4151u16),
(28046u16,5756u16),(28051u16,5751u16),(28053u16,5757u16),(28054u16,8432u16),
(28057u16,4291u16),(28059u16,3466u16),(28060u16,3511u16),(28076u16,8433u16),
(28079u16,1713u16),(28082u16,1556u16),(28085u16,5763u16),(28088u16,5766u16),
(28092u16,4264u16),(28096u16,4203u16),(28101u16,5773u16),(28102u16,5767u16),
(28103u16,5764u16),(28107u16,4281u16),(28108u16,5770u16),(28111u16,8434u16),
(28113u16,2673u16),(28114u16,5772u16),(28117u16,5777u16),(28120u16,3464u16),
(28121u16,5775u16),(28126u16,5769u16),(28129u16,3219u16),(28132u16,5776u16),
(28134u16,5765u16),(28136u16,5771u16),(28138u16,5778u16),(28139u16,1501u16),
(28140u16,5768u16),(28142u16,5779u16),(28145u16,2847u16),(28146u16,8436u16),
(28147u16,2694u16),(28149u16,3858u16),(28151u16,2363u16),(28152u16,8435u16),
(28153u16,5760u16),(28154u16,5774u16),(28155u16,3409u16),(28156u16,8437u16),
(28165u16,2935u16),(28167u16,1764u16),(28168u16,2398u16),(28169u16,2761u16),
(28170u16,5762u16),(28171u16,2665u16),(28179u16,2111u16),(28181u16,5761u16),
(28185u16,5783u16),(28186u16,2708u16),(28187u16,2187u16),(28189u16,5798u16),
(28191u16,5792u16),(28192u16,1963u16),(28193u16,3430u16),(28195u16,5787u16),
(28196u16,5796u16),(28197u16,1424u16),(28198u16,1521u16),(28199u16,8440u16),
(28201u16,1622u16),(28203u16,5789u16),(28204u16,3113u16),(28205u16,5780u16),
(28206u16,5782u16),(28207u16,2288u16),(28216u16,5799u16),(28217u16,8438u16),
(28218u16,5794u16),(28220u16,8441u16),(28222u16,5786u16),(28227u16,5793u16),
(28234u16,4052u16),(28237u16,5791u16),(28238u16,5795u16),(28246u16,2209u16),
(28248u16,2762u16),(28251u16,3220u16),(28252u16,8439u16),(28255u16,5785u16),
(28263u16,4150u16),(28267u16,5788u16),(28270u16,5781u16),(28271u16,3465u16),
(28274u16,5784u16),(28278u16,5790u16),(28286u16,4372u16),(28287u16,2567u16),
(28288u16,4041u16),(28290u16,5800u16),(28300u16,3679u16),(28303u16,5812u16),
(28304u16,2188u16),(28310u16,2695u16),(28312u16,5802u16),(28316u16,4244u16),
(28317u16,2289u16),(28319u16,5815u16),(28322u16,1487u16),(28325u16,5813u16),
(28330u16,5801u16),(28335u16,5807u16),(28338u16,5809u16),(28342u16,4182u16),
(28343u16,5804u16),(28346u16,3397u16),(28349u16,5806u16),(28351u16,8442u16),
(28354u16,5814u16),(28356u16,5808u16),(28357u16,4080u16),(28361u16,5803u16),
(28363u16,2539u16),(28364u16,5827u16),(28369u16,1765u16),(28371u16,5805u16),
(28372u16,5810u16),(28373u16,5811u16),(28381u16,3177u16),(28382u16,3159u16),
(28396u16,5819u16),(28399u16,5825u16),(28402u16,5823u16),(28404u16,3392u16),
(28407u16,5830u16),(28408u16,5820u16),(28414u16,5821u16),(28415u16,5797u16),
(28417u16,1968u16),(28418u16,3785u16),(28422u16,2568u16),(28425u16,2342u16),
(28431u16,4342u16),(28433u16,5817u16),(28435u16,5829u16),(28436u16,1576u16),
(28437u16,3077u16),(28448u16,3660u16),(28450u16,1818u16),(28451u16,4319u16),
(28459u16,4042u16),(28460u16,3339u16),(28465u16,5824u16),(28466u16,5826u16),
(28472u16,3025u16),(28478u16,5828u16),(28479u16,5822u16),(28481u16,5816u16),
(28485u16,1820u16),(28500u16,2140u16),(28504u16,5842u16),(28507u16,5837u16),
(28508u16,3001u16),(28511u16,1758u16),(28516u16,2696u16),(28518u16,5846u16),
(28525u16,5839u16),(28526u16,3301u16),(28527u16,5836u16),(28528u16,3346u16),
(28532u16,5871u16),(28536u16,5833u16),(28538u16,5832u16),(28540u16,5841u16),
(28544u16,5835u16),(28545u16,5834u16),(28546u16,5840u16),(28548u16,2914u16),
(28550u16,5831u16),(28552u16,8443u16),(28558u16,5843u16),(28561u16,5844u16),
(28567u16,1819u16),(28577u16,5849u16),(28579u16,5848u16),(28580u16,5850u16),
(28586u16,5853u16),(28593u16,3418u16),(28595u16,5847u16),(28597u16,8444u16),
(28601u16,5851u16),(28608u16,2134u16),(28609u16,3190u16),(28610u16,5845u16),
(28611u16,3598u16),(28614u16,5852u16),(28628u16,5857u16),(28629u16,5855u16),
(28632u16,5858u16),(28635u16,5861u16),(28639u16,5854u16),(28640u16,2329u16),
(28641u16,3579u16),(28644u16,5758u16),(28651u16,4219u16),(28652u16,5856u16),
(28654u16,5860u16),(28655u16,3186u16),(28657u16,5859u16),(28659u16,5838u16),
(28661u16,8445u16),(28662u16,7404u16),(28666u16,5864u16),(28670u16,5868u16),
(28673u16,5866u16),(28677u16,8446u16),(28679u16,8447u16),(28681u16,5862u16),
(28683u16,5863u16),(28687u16,5867u16),(28689u16,5865u16),(28693u16,3805u16),
(28696u16,5873u16),(28698u16,5870u16),(28699u16,5869u16),(28701u16,5872u16),
(28702u16,3529u16),(28703u16,5874u16),(28710u16,3280u16),(28711u16,3178u16),
(28712u16,8448u16),(28716u16,2918u16),(28720u16,5875u16),(28722u16,5877u16),
(28734u16,5876u16),(28748u16,5818u16),(28753u16,5878u16),(28760u16,3548u16),
(28771u16,5879u16),(28779u16,1645u16),(28783u16,3467u16),(28784u16,1696u16),
(28792u16,1947u16),(28796u16,2599u16),(28797u16,2399u16),(28805u16,8449u16),
(28809u16,4330u16),(28810u16,2889u16),(28814u16,1577u16),(28818u16,5881u16),
(28825u16,5880u16),(28843u16,8450u16),(28844u16,5884u16),(28845u16,3221u16),
(28846u16,5887u16),(28847u16,5882u16),(28851u16,5886u16),(28856u16,5885u16),
(28857u16,3415u16),(28858u16,1466u16),(28859u16,8278u16),(28872u16,4314u16),
(28875u16,5889u16),(28879u16,1511u16),(28889u16,5891u16),(28893u16,5890u16),
(28895u16,5888u16),(28913u16,5883u16),(28921u16,3950u16),(28925u16,5893u16),
(28932u16,8452u16),(28937u16,5892u16),(28943u16,8451u16),(28948u16,1578u16),
(28953u16,5895u16),(28954u16,3871u16),(28956u16,5894u16),(28961u16,4062u16),
(28966u16,2764u16),(28982u16,3026u16),(28988u16,2763u16),(28998u16,8454u16),
(28999u16,8455u16),(29001u16,4320u16),(29004u16,5901u16),(29006u16,3002u16),
(29013u16,5897u16),(29014u16,5902u16),(29017u16,1579u16),(29020u16,8453u16),
(29026u16,5900u16),(29028u16,3636u16),(29029u16,5896u16),(29030u16,5899u16),
(29031u16,2765u16),(29033u16,3714u16),(29036u16,5903u16),(29038u16,2586u16),
(29053u16,3003u16),(29060u16,5906u16),(29064u16,5898u16),(29066u16,2074u16),
(29071u16,5904u16),(29076u16,4183u16),(29077u16,5907u16),(29081u16,7807u16),
(29087u16,2678u16),(29096u16,5908u16),(29100u16,5909u16),(29105u16,3585u16),
(29113u16,5911u16),(29118u16,5912u16),(29121u16,8457u16),(29123u16,3590u16),
(29128u16,3468u16),(29129u16,5914u16),(29134u16,5916u16),(29136u16,4282u16),
(29138u16,5913u16),(29140u16,5915u16),(29141u16,1580u16),(29143u16,5910u16),
(29151u16,4758u16),(29152u16,5917u16),(29157u16,3078u16),(29158u16,2467u16),
(29159u16,5919u16),(29164u16,5918u16),(29165u16,2823u16),(29166u16,4662u16),
(29173u16,5920u16),(29177u16,5922u16),(29179u16,5905u16),(29180u16,5921u16),
(29182u16,8458u16),(29183u16,5923u16),(29190u16,3661u16),(29197u16,5924u16),
(29200u16,5925u16),(29211u16,5926u16),(29224u16,5927u16),(29226u16,3351u16),
(29228u16,5929u16),(29229u16,5928u16),(29232u16,5930u16),(29234u16,5931u16),
(29237u16,2600u16),(29238u16,3826u16),(29242u16,4117u16),(29243u16,5932u16),
(29244u16,5933u16),(29245u16,3061u16),(29246u16,2541u16),(29247u16,5934u16),
(29248u16,5935u16),(29254u16,5936u16),(29255u16,3903u16),(29256u16,3704u16),
(29259u16,5937u16),(29260u16,3626u16),(29266u16,3302u16),(29272u16,5938u16),
(29273u16,1668u16),(29275u16,1956u16),(29277u16,4079u16),(29279u16,4063u16),
(29281u16,1617u16),(29282u16,4343u16),(29287u16,3997u16),(29289u16,3863u16),
(29298u16,2936u16),(29300u16,5939u16),(29305u16,3512u16),(29309u16,2164u16),
(29310u16,5940u16),(29312u16,2401u16),(29313u16,5942u16),(29314u16,5941u16),
(29319u16,5943u16),(29330u16,5944u16),(29334u16,5945u16),(29344u16,1909u16),
(29346u16,5946u16),(29351u16,5947u16),(29356u16,2165u16),(29359u16,3705u16),
(29361u16,8459u16),(29362u16,5949u16),(29366u16,2810u16),(29369u16,5948u16),
(29374u16,8460u16),(29378u16,1997u16),(29379u16,5950u16),(29380u16,5952u16),
(29382u16,5951u16),(29390u16,5953u16),(29392u16,2210u16),(29394u16,5954u16),
(29399u16,2046u16),(29401u16,3039u16),(29403u16,2348u16),(29408u16,5956u16),
(29409u16,5957u16),(29410u16,5955u16),(29417u16,2614u16),(29420u16,3517u16),
(29421u16,1998u16),(29431u16,5959u16),(29432u16,3207u16),(29433u16,5958u16),
(29436u16,4344u16),(29437u16,3637u16),(29450u16,5962u16),(29462u16,5964u16),
(29463u16,5961u16),(29467u16,4093u16),(29468u16,5963u16),(29469u16,5965u16),
(29471u16,4265u16),(29476u16,8461u16),(29477u16,5969u16),(29481u16,5968u16),
(29482u16,3281u16),(29483u16,3584u16),(29486u16,2166u16),(29487u16,5967u16),
(29492u16,5966u16),(29494u16,4152u16),(29495u16,4153u16),(29502u16,5970u16),
(29503u16,1581u16),(29508u16,2341u16),(29509u16,2509u16),(29518u16,5971u16),
(29519u16,5972u16),(29527u16,5974u16),(29539u16,2666u16),(29544u16,5976u16),
(29546u16,5975u16),(29552u16,5977u16),(29554u16,1736u16),(29557u16,5979u16),
(29559u16,8463u16),(29560u16,5978u16),(29562u16,5981u16),(29563u16,5980u16),
(29572u16,2189u16),(29575u16,4237u16),(29577u16,2017u16),(29579u16,1603u16),
(29590u16,2047u16),(29609u16,1850u16),(29618u16,4301u16),(29619u16,5983u16),
(29627u16,5985u16),(29629u16,8464u16),(29632u16,5986u16),(29634u16,1646u16),
(29640u16,5982u16),(29641u16,8465u16),(29642u16,2468u16),(29645u16,3322u16),
(29646u16,5984u16),(29650u16,8468u16),(29654u16,8466u16),(29662u16,5989u16),
(29664u16,2615u16),(29667u16,8467u16),(29669u16,5987u16),(29674u16,2097u16),
(29677u16,3706u16),(29678u16,5988u16),(29681u16,6015u16),(29685u16,8470u16),
(29688u16,5994u16),(29694u16,2190u16),(29699u16,1948u16),(29701u16,5991u16),
(29702u16,4228u16),(29703u16,8469u16),(29705u16,4245u16),(29730u16,3187u16),
(29733u16,5993u16),(29734u16,8471u16),(29737u16,8473u16),(29738u16,8472u16),
(29742u16,8474u16),(29746u16,5995u16),(29747u16,4283u16),(29748u16,2028u16),
(29749u16,3757u16),(29750u16,3613u16),(29754u16,5996u16),(29759u16,5998u16),
(29761u16,6001u16),(29781u16,5997u16),(29785u16,6000u16),(29786u16,2235u16),
(29787u16,1548u16),(29788u16,6002u16),(29790u16,2899u16),(29791u16,5999u16),
(29792u16,4289u16),(29794u16,8475u16),(29795u16,6005u16),(29796u16,7805u16),
(29801u16,6003u16),(29802u16,6006u16),(29807u16,5992u16),(29808u16,6004u16),
(29811u16,2377u16),(29814u16,6007u16),(29822u16,6008u16),(29827u16,4229u16),
(29833u16,8476u16),(29835u16,6009u16),(29854u16,6010u16),(29855u16,8477u16),
(29858u16,5990u16),(29863u16,6011u16),(29872u16,1821u16),(29885u16,2542u16),
(29898u16,6012u16),(29903u16,6013u16),(29908u16,6014u16),(29916u16,1530u16),
(29920u16,6016u16),(29922u16,3786u16),(29923u16,6017u16),(29926u16,1789u16),
(29927u16,6018u16),(29929u16,6019u16),(29934u16,6020u16),(29936u16,6022u16),
(29937u16,6023u16),(29938u16,6021u16),(29942u16,3810u16),(29943u16,6025u16),
(29944u16,6024u16),(29953u16,8478u16),(29955u16,6027u16),(29956u16,6026u16),
(29957u16,6028u16),(29964u16,6029u16),(29965u16,6031u16),(29966u16,6030u16),
(29969u16,2344u16),(29971u16,6033u16),(29973u16,6032u16),(29976u16,1822u16),
(29978u16,2870u16),(29980u16,3411u16),(29982u16,6034u16),(29983u16,2937u16),
(29987u16,2469u16),(29989u16,1592u16),(29990u16,6035u16),(29992u16,4184u16),
(29995u16,3920u16),(29996u16,6036u16),(29999u16,8347u16),(30000u16,3419u16),
(30001u16,4154u16),(30002u16,2290u16),(30003u16,2848u16),(30007u16,3238u16),
(30008u16,4625u16),(30010u16,3303u16),(30011u16,1669u16),(30012u16,6037u16),
(30020u16,6038u16),(30022u16,6043u16),(30025u16,6041u16),(30026u16,6040u16),
(30027u16,5391u16),(30028u16,1697u16),(30029u16,6039u16),(30031u16,1467u16),
(30033u16,3675u16),(30036u16,3707u16),(30041u16,4246u16),(30042u16,6044u16),
(30043u16,6042u16),(30044u16,3255u16),(30045u16,2919u16),(30048u16,3676u16),
(30050u16,3772u16),(30052u16,6046u16),(30053u16,4241u16),(30054u16,2112u16),
(30055u16,6047u16),(30057u16,6045u16),(30058u16,3719u16),(30059u16,6048u16),
(30061u16,6049u16),(30063u16,8479u16),(30064u16,1468u16),(30067u16,2811u16),
(30068u16,6054u16),(30070u16,6051u16),(30071u16,3554u16),(30072u16,6050u16),
(30079u16,1885u16),(30082u16,6057u16),(30086u16,6052u16),(30087u16,6053u16),
(30089u16,6056u16),(30090u16,6055u16),(30091u16,3764u16),(30094u16,3041u16),
(30095u16,3040u16),(30097u16,1910u16),(30100u16,6058u16),(30106u16,6059u16),
(30109u16,6060u16),(30115u16,6062u16),(30117u16,6061u16),(30123u16,1557u16),
(30129u16,6070u16),(30130u16,3737u16),(30131u16,6064u16),(30133u16,6066u16),
(30136u16,6068u16),(30137u16,2849u16),(30140u16,6069u16),(30141u16,6067u16),
(30142u16,2569u16),(30146u16,6063u16),(30147u16,6065u16),(30149u16,3793u16),
(30151u16,2766u16),(30154u16,6072u16),(30157u16,6071u16),(30162u16,6073u16),
(30164u16,2543u16),(30165u16,2364u16),(30168u16,3470u16),(30169u16,6074u16),
(30171u16,3332u16),(30174u16,6076u16),(30178u16,4230u16),(30179u16,6075u16),
(30185u16,3080u16),(30192u16,6081u16),(30194u16,6083u16),(30195u16,6084u16),
(30196u16,3247u16),(30202u16,6082u16),(30204u16,6079u16),(30206u16,6077u16),
(30207u16,6078u16),(30209u16,6080u16),(30217u16,6087u16),(30219u16,6085u16),
(30221u16,6086u16),(30239u16,6088u16),(30240u16,6090u16),(30241u16,6091u16),
(30242u16,6092u16),(30244u16,6093u16),(30247u16,6089u16),(30256u16,6095u16),
(30260u16,6094u16),(30267u16,6096u16),(30274u16,4266u16),(30278u16,6099u16),
(30279u16,6097u16),(30280u16,6098u16),(30284u16,1851u16),(30290u16,4135u16),
(30294u16,3895u16),(30296u16,6101u16),(30300u16,6100u16),(30305u16,6102u16),
(30306u16,6103u16),(30311u16,6107u16),(30312u16,6104u16),(30313u16,6105u16),
(30314u16,6106u16),(30316u16,6108u16),(30320u16,6109u16),(30322u16,6110u16),
(30326u16,6111u16),(30328u16,6112u16),(30330u16,3680u16),(30331u16,3431u16),
(30332u16,6113u16),(30333u16,3653u16),(30334u16,3779u16),(30336u16,6114u16),
(30338u16,8480u16),(30339u16,6115u16),(30340u16,3393u16),(30342u16,1698u16),
(30343u16,2291u16),(30344u16,6116u16),(30347u16,6117u16),(30350u16,6118u16),
(30352u16,2452u16),(30355u16,6120u16),(30358u16,6119u16),(30361u16,6121u16),
(30362u16,6122u16),(30363u16,8483u16),(30364u16,8481u16),(30366u16,8482u16),
(30374u16,8484u16),(30382u16,3738u16),(30384u16,6123u16),(30388u16,6124u16),
(30391u16,7780u16),(30392u16,6125u16),(30393u16,6126u16),(30394u16,6127u16),
(30399u16,2457u16),(30402u16,6128u16),(30403u16,3625u16),(30406u16,4010u16),
(30408u16,1549u16),(30410u16,1558u16),(30413u16,6129u16),(30418u16,6131u16),
(30422u16,6130u16),(30423u16,3463u16),(30427u16,2938u16),(30428u16,5664u16),
(30430u16,6132u16),(30431u16,4074u16),(30433u16,6133u16),(30435u16,1823u16),
(30436u16,3720u16),(30437u16,6134u16),(30439u16,6135u16),(30442u16,6136u16),
(30446u16,4101u16),(30450u16,4094u16),(30452u16,3319u16),(30456u16,3081u16),
(30459u16,6138u16),(30462u16,2697u16),(30465u16,2767u16),(30468u16,6141u16),
(30471u16,6140u16),(30472u16,6139u16),(30473u16,3758u16),(30475u16,1824u16),
(30476u16,2170u16),(30491u16,6147u16),(30494u16,6144u16),(30495u16,2850u16),
(30496u16,4059u16),(30500u16,6143u16),(30501u16,6145u16),(30502u16,6146u16),
(30505u16,6142u16),(30519u16,6148u16),(30520u16,6149u16),(30522u16,3304u16),
(30524u16,1852u16),(30528u16,3264u16),(30534u16,8486u16),(30535u16,6150u16),
(30554u16,6151u16),(30555u16,6154u16),(30561u16,2890u16),(30563u16,3513u16),
(30565u16,6155u16),(30566u16,3998u16),(30568u16,6152u16),(30571u16,6153u16),
(30585u16,6158u16),(30590u16,6157u16),(30591u16,6156u16),(30603u16,6160u16),
(30606u16,6159u16),(30609u16,6161u16),(30622u16,6163u16),(30624u16,6162u16),
(30629u16,3898u16),(30636u16,2685u16),(30637u16,4267u16),(30640u16,6164u16),
(30643u16,3500u16),(30646u16,6165u16),(30649u16,6166u16),(30651u16,6170u16),
(30652u16,6168u16),(30653u16,6169u16),(30655u16,6167u16),(30663u16,6171u16),
(30669u16,6172u16),(30679u16,6173u16),(30682u16,6174u16),(30683u16,4064u16),
(30684u16,6175u16),(30690u16,4121u16),(30691u16,6176u16),(30693u16,3241u16),
(30695u16,3645u16),(30697u16,2048u16),(30701u16,3222u16),(30702u16,6177u16),
(30703u16,1999u16),(30707u16,2961u16),(30716u16,6178u16),(30722u16,2378u16),
(30732u16,6179u16),(30738u16,6180u16),(30740u16,2167u16),(30741u16,2402u16),
(30752u16,6182u16),(30753u16,8488u16),(30757u16,3437u16),(30758u16,2403u16),
(30759u16,1925u16),(30770u16,3951u16),(30772u16,3614u16),(30778u16,3438u16),
(30783u16,2315u16),(30789u16,6184u16),(30798u16,8489u16),(30813u16,2768u16),
(30820u16,8490u16),(30827u16,4247u16),(30828u16,2292u16),(30831u16,2168u16),
(30834u16,3668u16),(30836u16,6186u16),(30842u16,8491u16),(30844u16,6188u16),
(30849u16,2236u16),(30854u16,6187u16),(30855u16,3375u16),(30860u16,6190u16),
(30861u16,1714u16),(30862u16,6185u16),(30865u16,3739u16),(30867u16,1519u16),
(30869u16,2425u16),(30871u16,4373u16),(30874u16,6189u16),(30883u16,6191u16),
(30887u16,3896u16),(30889u16,2970u16),(30890u16,6193u16),(30895u16,6194u16),
(30901u16,6192u16),(30906u16,1737u16),(30908u16,6200u16),(30910u16,6199u16),
(30913u16,2544u16),(30917u16,6201u16),(30918u16,6196u16),(30922u16,6202u16),
(30923u16,6197u16),(30928u16,3721u16),(30929u16,6195u16),(30932u16,6198u16),
(30938u16,6205u16),(30951u16,6204u16),(30952u16,4012u16),(30956u16,6203u16),
(30959u16,1484u16),(30964u16,6207u16),(30973u16,6206u16),(30977u16,2769u16),
(30983u16,6208u16),(30990u16,3042u16),(30993u16,6210u16),(30994u16,6209u16),
(31001u16,6211u16),(31014u16,6181u16),(31018u16,6183u16),(31019u16,6213u16),
(31020u16,6212u16),(31024u16,8492u16),(31034u16,2545u16),(31036u16,4302u16),
(31038u16,2587u16),(31040u16,6214u16),(31041u16,2090u16),(31047u16,1911u16),
(31048u16,1886u16),(31049u16,2510u16),(31056u16,4155u16),(31059u16,6220u16),
(31061u16,6219u16),(31062u16,3043u16),(31063u16,6216u16),(31066u16,6218u16),
(31069u16,2674u16),(31070u16,2851u16),(31071u16,6217u16),(31072u16,6215u16),
(31074u16,3581u16),(31077u16,2770u16),(31080u16,3787u16),(31085u16,2404u16),
(31095u16,3471u16),(31098u16,6221u16),(31103u16,6222u16),(31104u16,6244u16),
(31105u16,2029u16),(31108u16,4352u16),(31109u16,3028u16),(31114u16,6223u16),
(31117u16,1647u16),(31118u16,3376u16),(31119u16,3854u16),(31124u16,8496u16),
(31131u16,8498u16),(31133u16,6224u16),(31142u16,1969u16),(31143u16,6225u16),
(31146u16,6227u16),(31150u16,6228u16),(31152u16,3580u16),(31155u16,6229u16),
(31161u16,6230u16),(31162u16,6231u16),(31165u16,2030u16),(31166u16,1648u16),
(31167u16,3514u16),(31168u16,2639u16),(31169u16,2511u16),(31177u16,6232u16),
(31179u16,2640u16),(31185u16,1639u16),(31186u16,3794u16),(31189u16,6233u16),
(31192u16,3740u16),(31199u16,3044u16),(31201u16,6236u16),(31203u16,6237u16),
(31204u16,3644u16),(31206u16,2852u16),(31207u16,6234u16),(31209u16,3260u16),
(31212u16,6235u16),(31216u16,2771u16),(31227u16,1469u16),(31232u16,1888u16),
(31240u16,6238u16),(31243u16,3377u16),(31245u16,6239u16),(31246u16,2952u16),
(31252u16,4054u16),(31255u16,3762u16),(31256u16,6240u16),(31257u16,6241u16),
(31258u16,3248u16),(31260u16,4268u16),(31263u16,6243u16),(31264u16,6242u16),
(31278u16,2616u16),(31281u16,6245u16),(31282u16,1489u16),(31287u16,6248u16),
(31291u16,6246u16),(31292u16,1649u16),(31293u16,2113u16),(31294u16,6247u16),
(31295u16,2293u16),(31296u16,2337u16),(31298u16,3923u16),(31299u16,6249u16),
(31302u16,3999u16),(31305u16,6251u16),(31309u16,2962u16),(31310u16,1550u16),
(31311u16,1623u16),(31312u16,1421u16),(31319u16,6250u16),(31329u16,6252u16),
(31330u16,6253u16),(31331u16,2812u16),(31337u16,6254u16),(31339u16,1738u16),
(31344u16,6256u16),(31348u16,2141u16),(31350u16,1949u16),(31353u16,6257u16),
(31354u16,2058u16),(31357u16,6258u16),(31359u16,3005u16),(31361u16,3522u16),
(31363u16,2977u16),(31364u16,2434u16),(31368u16,6259u16),(31378u16,3261u16),
(31379u16,3082u16),(31381u16,6261u16),(31382u16,6263u16),(31383u16,6260u16),
(31384u16,6262u16),(31391u16,2069u16),(31401u16,6264u16),(31402u16,2073u16),
(31406u16,1950u16),(31407u16,4185u16),(31408u16,6266u16),(31414u16,6267u16),
(31418u16,1517u16),(31423u16,6270u16),(31427u16,1777u16),(31428u16,6269u16),
(31429u16,6268u16),(31431u16,6272u16),(31432u16,6265u16),(31434u16,6273u16),
(31435u16,4238u16),(31437u16,6274u16),(31439u16,6275u16),(31441u16,8499u16),
(31442u16,4877u16),(31443u16,6277u16),(31445u16,6276u16),(31449u16,6278u16),
(31450u16,6279u16),(31452u16,4250u16),(31453u16,6280u16),(31455u16,7504u16),
(31456u16,2772u16),(31457u16,6281u16),(31458u16,6282u16),(31459u16,2686u16),
(31461u16,3501u16),(31462u16,6283u16),(31463u16,8500u16),(31466u16,3203u16),
(31467u16,8502u16),(31469u16,6284u16),(31471u16,3223u16),(31472u16,6285u16),
(31478u16,1978u16),(31480u16,4542u16),(31481u16,3256u16),(31482u16,2556u16),
(31487u16,1825u16),(31490u16,6286u16),(31492u16,6299u16),(31494u16,6289u16),
(31496u16,1951u16),(31498u16,6288u16),(31499u16,6301u16),(31503u16,6287u16),
(31505u16,2773u16),(31512u16,6291u16),(31513u16,6292u16),(31515u16,3394u16),
(31518u16,6293u16),(31520u16,1753u16),(31525u16,2877u16),(31526u16,3827u16),
(31528u16,6295u16),(31532u16,3173u16),(31539u16,6290u16),(31541u16,6294u16),
(31542u16,6296u16),(31545u16,2440u16),(31557u16,6303u16),(31558u16,3773u16),
(31560u16,3671u16),(31561u16,3472u16),(31563u16,2031u16),(31564u16,6302u16),
(31565u16,6300u16),(31567u16,3686u16),(31568u16,6297u16),(31569u16,3257u16),
(31570u16,3474u16),(31572u16,3473u16),(31574u16,2435u16),(31581u16,6321u16),
(31589u16,6305u16),(31591u16,6307u16),(31596u16,6310u16),(31598u16,6311u16),
(31600u16,6308u16),(31601u16,6309u16),(31604u16,6306u16),(31605u16,6304u16),
(31610u16,6298u16),(31622u16,3900u16),(31623u16,1650u16),(31627u16,6318u16),
(31629u16,6315u16),(31631u16,6320u16),(31634u16,6319u16),(31636u16,3654u16),
(31637u16,4048u16),(31639u16,2470u16),(31640u16,6313u16),(31641u16,6322u16),
(31642u16,6317u16),(31644u16,6316u16),(31645u16,6312u16),(31646u16,8503u16),
(31647u16,6314u16),(31649u16,1826u16),(31658u16,3224u16),(31661u16,3006u16),
(31665u16,3667u16),(31668u16,6327u16),(31672u16,3669u16),(31680u16,2978u16),
(31681u16,6324u16),(31684u16,3712u16),(31686u16,6328u16),(31687u16,3904u16),
(31689u16,3254u16),(31691u16,6323u16),(31692u16,6325u16),(31695u16,6326u16),
(31709u16,6329u16),(31712u16,2573u16),(31716u16,3515u16),(31717u16,6334u16),
(31718u16,6333u16),(31721u16,6330u16),(31725u16,4345u16),(31731u16,6339u16),
(31734u16,6343u16),(31735u16,6340u16),(31744u16,6336u16),(31751u16,6337u16),
(31757u16,6342u16),(31761u16,6331u16),(31762u16,4658u16),(31763u16,6338u16),
(31764u16,6332u16),(31767u16,6341u16),(31775u16,6347u16),(31777u16,1827u16),
(31779u16,6344u16),(31783u16,6345u16),(31786u16,6346u16),(31787u16,6349u16),
(31799u16,6348u16),(31800u16,3751u16),(31805u16,6350u16),(31806u16,4321u16),
(31807u16,3930u16),(31808u16,6355u16),(31811u16,6352u16),(31820u16,6351u16),
(31821u16,2963u16),(31823u16,6354u16),(31824u16,6356u16),(31828u16,6353u16),
(31830u16,6360u16),(31832u16,6357u16),(31839u16,6358u16),(31840u16,6335u16),
(31844u16,6359u16),(31845u16,6361u16),(31852u16,6362u16),(31859u16,3891u16),
(31861u16,6363u16),(31870u16,4107u16),(31873u16,2019u16),(31874u16,2076u16),
(31875u16,6364u16),(31881u16,3873u16),(31883u16,2891u16),(31885u16,4057u16),
(31888u16,6365u16),(31890u16,4248u16),(31893u16,3655u16),(31895u16,3045u16),
(31896u16,3591u16),(31899u16,2676u16),(31903u16,1441u16),(31905u16,6370u16),
(31906u16,6368u16),(31908u16,6366u16),(31909u16,1786u16),(31911u16,2774u16),
(31912u16,6371u16),(31915u16,6369u16),(31917u16,6367u16),(31918u16,6375u16),
(31921u16,6374u16),(31922u16,6373u16),(31923u16,6372u16),(31929u16,6376u16),
(31933u16,6377u16),(31934u16,2939u16),(31936u16,6378u16),(31938u16,6380u16),
(31941u16,6379u16),(31946u16,2211u16),(31950u16,3031u16),(31954u16,6382u16),
(31958u16,3475u16),(31960u16,6381u16),(31964u16,6383u16),(31966u16,3874u16),
(31967u16,3083u16),(31968u16,2294u16),(31970u16,6384u16),(31975u16,4269u16),
(31983u16,6386u16),(31986u16,6387u16),(31988u16,6388u16),(31990u16,6389u16),
(31992u16,2512u16),(31994u16,6390u16),(31995u16,2114u16),(31998u16,1953u16),
(32000u16,1889u16),(32002u16,6392u16),(32004u16,4124u16),(32005u16,2295u16),
(32006u16,6391u16),(32010u16,6395u16),(32011u16,4111u16),(32013u16,3599u16),
(32016u16,3778u16),(32020u16,2698u16),(32021u16,6394u16),(32023u16,2588u16),
(32024u16,2296u16),(32025u16,2513u16),(32026u16,1952u16),(32027u16,3875u16),
(32028u16,6393u16),(32032u16,3046u16),(32033u16,3981u16),(32034u16,2436u16),
(32043u16,2514u16),(32044u16,3350u16),(32046u16,6398u16),(32047u16,4292u16),
(32048u16,2406u16),(32050u16,6399u16),(32051u16,2853u16),(32053u16,6401u16),
(32057u16,2775u16),(32058u16,2365u16),(32063u16,6400u16),(32066u16,2641u16),
(32067u16,2191u16),(32068u16,3047u16),(32069u16,6396u16),(32070u16,6402u16),
(32072u16,8505u16),(32075u16,6397u16),(32076u16,2115u16),(32078u16,6405u16),
(32079u16,6409u16),(32080u16,2142u16),(32086u16,6404u16),(32091u16,6413u16),
(32092u16,8506u16),(32094u16,2297u16),(32097u16,4212u16),(32098u16,1437u16),
(32099u16,6410u16),(32102u16,1954u16),(32104u16,6407u16),(32110u16,6408u16),
(32113u16,3476u16),(32114u16,6406u16),(32115u16,6403u16),(32117u16,1699u16),
(32118u16,2981u16),(32121u16,2169u16),(32125u16,6415u16),(32137u16,6412u16),
(32143u16,6414u16),(32147u16,6411u16),(32153u16,2116u16),(32154u16,3120u16),
(32155u16,6416u16),(32156u16,3085u16),(32159u16,6429u16),(32160u16,8508u16),
(32162u16,6425u16),(32163u16,6419u16),(32171u16,6423u16),(32172u16,2627u16),
(32173u16,1470u16),(32174u16,6418u16),(32175u16,6426u16),(32176u16,6430u16),
(32177u16,2298u16),(32178u16,4095u16),(32180u16,3343u16),(32181u16,6420u16),
(32183u16,8507u16),(32184u16,6428u16),(32186u16,6417u16),(32187u16,3225u16),
(32189u16,6422u16),(32190u16,1438u16),(32191u16,4083u16),(32199u16,6421u16),
(32202u16,2032u16),(32203u16,3741u16),(32207u16,3084u16),(32209u16,4277u16),
(32210u16,2710u16),(32213u16,6469u16),(32214u16,8509u16),(32216u16,6431u16),
(32218u16,3007u16),(32220u16,6427u16),(32221u16,6432u16),(32222u16,6434u16),
(32224u16,3378u16),(32225u16,6437u16),(32228u16,6433u16),(32232u16,3905u16),
(32233u16,1828u16),(32236u16,4084u16),(32239u16,1471u16),(32242u16,6436u16),
(32244u16,4322u16),(32251u16,6435u16),(32257u16,1582u16),(32260u16,3553u16),
(32261u16,6438u16),(32265u16,6445u16),(32266u16,6439u16),(32267u16,6446u16),
(32274u16,6442u16),(32283u16,3662u16),(32286u16,2579u16),(32287u16,6444u16),
(32289u16,6441u16),(32290u16,6447u16),(32291u16,6440u16),(32294u16,2667u16),
(32299u16,3952u16),(32302u16,2675u16),(32305u16,6443u16),(32306u16,6455u16),
(32309u16,6451u16),(32311u16,6454u16),(32313u16,6452u16),(32314u16,6456u16),
(32315u16,6450u16),(32317u16,6424u16),(32318u16,2964u16),(32321u16,3708u16),
(32323u16,6453u16),(32326u16,6448u16),(32330u16,3008u16),(32331u16,2117u16),
(32333u16,2642u16),(32338u16,8510u16),(32340u16,2824u16),(32341u16,3029u16),
(32342u16,6459u16),(32345u16,6461u16),(32346u16,6462u16),(32349u16,6458u16),
(32350u16,6460u16),(32358u16,6449u16),(32359u16,6457u16),(32361u16,6465u16),
(32362u16,6464u16),(32365u16,4037u16),(32368u16,2078u16),(32377u16,6463u16),
(32379u16,6467u16),(32380u16,6466u16),(32381u16,6470u16),(32383u16,6472u16),
(32386u16,2471u16),(32387u16,6468u16),(32392u16,6473u16),(32393u16,6474u16),
(32394u16,8272u16),(32396u16,6475u16),(32398u16,6481u16),(32399u16,3410u16),
(32400u16,6477u16),(32402u16,6476u16),(32403u16,6478u16),(32404u16,6479u16),
(32406u16,6480u16),(32411u16,6482u16),(32412u16,6483u16),(32566u16,1829u16),
(32568u16,6484u16),(32570u16,6485u16),(32581u16,6486u16),(32583u16,8511u16),
(32588u16,6487u16),(32589u16,6488u16),(32590u16,6489u16),(32592u16,6490u16),
(32593u16,6491u16),(32596u16,6493u16),(32597u16,6492u16),(32600u16,6494u16),
(32607u16,6495u16),(32608u16,6496u16),(32615u16,6499u16),(32616u16,6497u16),
(32617u16,6498u16),(32618u16,2414u16),(32619u16,2118u16),(32622u16,3249u16),
(32624u16,3684u16),(32626u16,2711u16),(32629u16,3616u16),(32631u16,3742u16),
(32632u16,6500u16),(32633u16,5246u16),(32642u16,6501u16),(32643u16,6503u16),
(32645u16,4204u16),(32646u16,6502u16),(32647u16,6505u16),(32648u16,6504u16),
(32650u16,4186u16),(32652u16,6506u16),(32654u16,3759u16),(32660u16,6507u16),
(32666u16,6510u16),(32669u16,6509u16),(32670u16,6508u16),(32673u16,8512u16),
(32675u16,6511u16),(32676u16,2085u16),(32680u16,3009u16),(32681u16,1912u16),
(32686u16,6515u16),(32687u16,6512u16),(32690u16,6513u16),(32694u16,6516u16),
(32696u16,6517u16),(32697u16,6514u16),(32701u16,1512u16),(32705u16,1604u16),
(32709u16,6519u16),(32710u16,6520u16),(32714u16,6521u16),(32716u16,4201u16),
(32722u16,2643u16),(32724u16,6523u16),(32725u16,6522u16),(32736u16,2892u16),
(32737u16,6524u16),(32742u16,6525u16),(32745u16,6526u16),(32747u16,1854u16),
(32752u16,1830u16),(32755u16,6527u16),(32761u16,6528u16),(32763u16,4008u16),
(32764u16,4202u16),(32768u16,4187u16),(32769u16,4346u16),(32771u16,2300u16),
(32772u16,6531u16),(32773u16,2589u16),(32774u16,6530u16),(32779u16,6532u16),
(32780u16,2546u16),(32784u16,3150u16),(32786u16,6533u16),(32789u16,2299u16),
(32791u16,4096u16),(32792u16,6534u16),(32793u16,6535u16),(32796u16,6536u16),
(32801u16,6537u16),(32808u16,6538u16),(32819u16,2547u16),(32822u16,4118u16),
(32827u16,6540u16),(32829u16,3226u16),(32831u16,6539u16),(32838u16,6542u16),
(32842u16,6541u16),(32850u16,6543u16),(32854u16,2940u16),(32856u16,6544u16),
(32858u16,6545u16),(32862u16,3878u16),(32863u16,6546u16),(32865u16,3086u16),
(32866u16,6547u16),(32872u16,6548u16),(32879u16,4323u16),(32880u16,6551u16),
(32882u16,6550u16),(32883u16,6549u16),(32884u16,3305u16),(32886u16,6552u16),
(32887u16,2825u16),(32889u16,6553u16),(32893u16,6554u16),(32894u16,4347u16),
(32895u16,6555u16),(32900u16,6556u16),(32901u16,6558u16),(32902u16,6557u16),
(32903u16,3670u16),(32905u16,3566u16),(32907u16,4353u16),(32908u16,3674u16),
(32915u16,6560u16),(32918u16,2776u16),(32920u16,3769u16),(32922u16,6561u16),
(32923u16,6559u16),(32925u16,1831u16),(32929u16,2213u16),(32930u16,2515u16),
(32933u16,3743u16),(32937u16,2171u16),(32938u16,3982u16),(32940u16,6564u16),
(32941u16,6562u16),(32943u16,2301u16),(32945u16,2302u16),(32946u16,1482u16),
(32948u16,2421u16),(32954u16,3628u16),(32963u16,1472u16),(32964u16,6569u16),
(32966u16,3227u16),(32972u16,3627u16),(32974u16,3160u16),(32982u16,6571u16),
(32985u16,6567u16),(32986u16,6570u16),(32987u16,6565u16),(32989u16,6568u16),
(32990u16,3953u16),(32993u16,2214u16),(32996u16,1502u16),(32997u16,6566u16),
(33007u16,6573u16),(33009u16,6574u16),(33012u16,3502u16),(33016u16,2000u16),
(33020u16,6585u16),(33021u16,3600u16),(33026u16,2516u16),(33029u16,2001u16),
(33030u16,2953u16),(33031u16,4361u16),(33032u16,4055u16),(33033u16,6572u16),
(33034u16,2965u16),(33050u16,1930u16),(33051u16,6575u16),(33059u16,6577u16),
(33065u16,6576u16),(33071u16,6578u16),(33073u16,3201u16),(33075u16,3601u16),
(33081u16,3306u16),(33086u16,6582u16),(33094u16,6581u16),(33099u16,6579u16),
(33102u16,2872u16),(33104u16,3828u16),(33105u16,6584u16),(33107u16,6583u16),
(33108u16,2303u16),(33109u16,4374u16),(33119u16,6600u16),(33125u16,6588u16),
(33126u16,6589u16),(33131u16,2617u16),(33134u16,6587u16),(33136u16,2343u16),
(33137u16,6586u16),(33140u16,6590u16),(33144u16,3307u16),(33145u16,3855u16),
(33146u16,3010u16),(33151u16,3161u16),(33152u16,6594u16),(33154u16,6595u16),
(33155u16,6591u16),(33160u16,6592u16),(33162u16,6593u16),(33167u16,2304u16),
(33171u16,6601u16),(33173u16,6597u16),(33178u16,3829u16),(33180u16,4023u16),
(33181u16,3767u16),(33184u16,6596u16),(33187u16,6599u16),(33188u16,6598u16),
(33192u16,3983u16),(33193u16,6602u16),(33200u16,6603u16),(33203u16,3030u16),
(33205u16,6604u16),(33208u16,6606u16),(33210u16,6610u16),(33213u16,6607u16),
(33214u16,6605u16),(33215u16,3602u16),(33216u16,6608u16),(33218u16,6609u16),
(33222u16,1615u16),(33224u16,6616u16),(33225u16,6611u16),(33229u16,6612u16),
(33233u16,6613u16),(33235u16,3102u16),(33240u16,6615u16),(33241u16,6614u16),
(33242u16,6617u16),(33247u16,6618u16),(33248u16,6619u16),(33251u16,2854u16),
(33253u16,1670u16),(33255u16,6620u16),(33256u16,4284u16),(33258u16,2548u16),
(33261u16,2644u16),(33267u16,2517u16),(33268u16,3250u16),(33274u16,6621u16),
(33275u16,6622u16),(33276u16,1520u16),(33278u16,6623u16),(33281u16,6624u16),
(33282u16,6625u16),(33285u16,6626u16),(33287u16,6627u16),(33288u16,2002u16),
(33289u16,5367u16),(33290u16,6628u16),(33292u16,2982u16),(33293u16,6629u16),
(33294u16,2580u16),(33296u16,6630u16),(33298u16,4433u16),(33302u16,6631u16),
(33303u16,3915u16),(33304u16,1845u16),(33307u16,3011u16),(33308u16,2687u16),
(33310u16,3840u16),(33311u16,2645u16),(33321u16,6632u16),(33322u16,2305u16),
(33323u16,6633u16),(33324u16,3709u16),(33326u16,6647u16),(33331u16,6635u16),
(33333u16,3142u16),(33334u16,3656u16),(33335u16,2192u16),(33336u16,6634u16),
(33337u16,3012u16),(33344u16,6636u16),(33351u16,3379u16),(33368u16,6638u16),
(33369u16,6637u16),(33370u16,6640u16),(33373u16,6639u16),(33375u16,6641u16),
(33378u16,6643u16),(33380u16,6642u16),(33382u16,1832u16),(33384u16,6644u16),
(33386u16,6645u16),(33387u16,6646u16),(33390u16,2366u16),(33391u16,4270u16),
(33393u16,6648u16),(33394u16,2826u16),(33398u16,1583u16),(33399u16,6649u16),
(33400u16,6650u16),(33406u16,6651u16),(33419u16,1491u16),(33421u16,6652u16),
(33426u16,6653u16),(33433u16,3830u16),(33437u16,2576u16),(33439u16,6655u16),
(33445u16,1700u16),(33446u16,1427u16),(33451u16,6654u16),(33452u16,6657u16),
(33453u16,3617u16),(33455u16,2855u16),(33457u16,1651u16),(33459u16,3954u16),
(33464u16,2128u16),(33465u16,2033u16),(33467u16,6656u16),(33469u16,1671u16),
(33477u16,1788u16),(33489u16,1584u16),(33490u16,6661u16),(33491u16,4303u16),
(33492u16,3162u16),(33495u16,3795u16),(33497u16,6673u16),(33499u16,1652u16),
(33500u16,6671u16),(33502u16,6669u16),(33503u16,6660u16),(33505u16,6658u16),
(33507u16,6659u16),(33509u16,2604u16),(33510u16,2049u16),(33511u16,3282u16),
(33515u16,3526u16),(33521u16,1552u16),(33523u16,6663u16),(33524u16,6662u16),
(33529u16,6668u16),(33530u16,6664u16),(33531u16,6667u16),(33537u16,8514u16),
(33538u16,4089u16),(33539u16,6666u16),(33540u16,1653u16),(33541u16,1784u16),
(33542u16,6670u16),(33545u16,6672u16),(33550u16,2119u16),(33558u16,6676u16),
(33559u16,6685u16),(33560u16,6686u16),(33564u16,1420u16),(33571u16,6693u16),
(33576u16,1490u16),(33579u16,6684u16),(33583u16,6683u16),(33585u16,6678u16),
(33586u16,6677u16),(33588u16,6675u16),(33589u16,6674u16),(33590u16,3262u16),
(33592u16,3192u16),(33593u16,6680u16),(33600u16,6679u16),(33605u16,6682u16),
(33609u16,3087u16),(33610u16,2120u16),(33615u16,1536u16),(33616u16,6681u16),
(33618u16,2306u16),(33624u16,3088u16),(33634u16,8515u16),(33651u16,6699u16),
(33653u16,6700u16),(33655u16,1654u16),(33659u16,1611u16),(33660u16,6697u16),
(33663u16,8516u16),(33669u16,6687u16),(33671u16,6695u16),(33673u16,6702u16),
(33674u16,6696u16),(33678u16,6694u16),(33683u16,6665u16),(33686u16,6692u16),
(33690u16,6688u16),(33694u16,1833u16),(33695u16,6690u16),(33696u16,6701u16),
(33698u16,6691u16),(33704u16,6703u16),(33706u16,6689u16),(33707u16,3663u16),
(33713u16,4208u16),(33717u16,6698u16),(33725u16,6720u16),(33729u16,6712u16),
(33733u16,2910u16),(33735u16,8517u16),(33738u16,1917u16),(33740u16,2034u16),
(33742u16,6707u16),(33747u16,1656u16),(33750u16,2777u16),(33752u16,6710u16),
(33756u16,2407u16),(33759u16,3432u16),(33760u16,6715u16),(33769u16,3931u16),
(33771u16,6706u16),(33775u16,1655u16),(33776u16,2215u16),(33777u16,3768u16),
(33778u16,6716u16),(33780u16,6704u16),(33782u16,8518u16),(33783u16,6713u16),
(33787u16,6723u16),(33789u16,6708u16),(33795u16,6709u16),(33796u16,3503u16),
(33799u16,6714u16),(33803u16,6711u16),(33804u16,3955u16),(33805u16,6717u16),
(33806u16,1473u16),(33811u16,6705u16),(33824u16,6719u16),(33826u16,6718u16),
(33833u16,3646u16),(33834u16,6725u16),(33836u16,6736u16),(33841u16,1785u16),
(33845u16,6739u16),(33848u16,6721u16),(33852u16,6726u16),(33853u16,4213u16),
(33862u16,6735u16),(33864u16,8519u16),(33865u16,4188u16),(33870u16,4239u16),
(33879u16,3283u16),(33883u16,1766u16),(33889u16,3841u16),(33890u16,6741u16),
(33891u16,3478u16),(33894u16,1426u16),(33897u16,6734u16),(33899u16,6730u16),
(33900u16,3089u16),(33901u16,6724u16),(33902u16,6732u16),(33903u16,6737u16),
(33905u16,3583u16),(33909u16,1419u16),(33911u16,6729u16),(33913u16,6738u16),
(33914u16,3847u16),(33922u16,6733u16),(33924u16,6728u16),(33931u16,2778u16),
(33936u16,2646u16),(33940u16,2549u16),(33945u16,4097u16),(33948u16,3798u16),
(33951u16,6744u16),(33953u16,6753u16),(33965u16,6731u16),(33970u16,1778u16),
(33972u16,8520u16),(33976u16,2813u16),(33977u16,6742u16),(33979u16,6747u16),
(33980u16,3090u16),(33983u16,6743u16),(33985u16,6750u16),(33988u16,3258u16),
(33990u16,6751u16),(33993u16,4189u16),(33994u16,6740u16),(33995u16,1715u16),
(33997u16,6746u16),(34000u16,6749u16),(34001u16,4053u16),(34006u16,6752u16),
(34009u16,6745u16),(34010u16,6748u16),(34012u16,8276u16),(34028u16,3956u16),
(34030u16,4324u16),(34036u16,6756u16),(34044u16,6763u16),(34047u16,6755u16),
(34048u16,2572u16),(34054u16,6722u16),(34065u16,3899u16),(34067u16,4043u16),
(34068u16,6762u16),(34069u16,6761u16),(34071u16,6757u16),(34072u16,6758u16),
(34074u16,1525u16),(34079u16,6760u16),(34081u16,6754u16),(34086u16,3342u16),
(34092u16,6759u16),(34093u16,1503u16),(34101u16,3103u16),(34109u16,3888u16),
(34112u16,6764u16),(34113u16,6768u16),(34115u16,3722u16),(34120u16,6767u16),
(34121u16,2779u16),(34122u16,2578u16),(34123u16,6770u16),(34126u16,2003u16),
(34131u16,8521u16),(34133u16,6771u16),(34135u16,3848u16),(34136u16,6766u16),
(34137u16,8522u16),(34138u16,6727u16),(34147u16,6765u16),(34152u16,4370u16),
(34153u16,3479u16),(34154u16,3842u16),(34155u16,8523u16),(34157u16,6778u16),
(34167u16,6784u16),(34174u16,6785u16),(34176u16,6772u16),(34180u16,3657u16),
(34183u16,6782u16),(34184u16,6774u16),(34186u16,6776u16),(34192u16,6786u16),
(34193u16,6775u16),(34196u16,6779u16),(34199u16,1585u16),(34201u16,3546u16),
(34203u16,6780u16),(34204u16,6783u16),(34212u16,6773u16),(34214u16,3013u16),
(34216u16,6777u16),(34217u16,2450u16),(34218u16,2856u16),(34219u16,2083u16),
(34220u16,4125u16),(34222u16,4130u16),(34223u16,2713u16),(34224u16,8525u16),
(34233u16,6790u16),(34234u16,6788u16),(34241u16,4369u16),(34249u16,6787u16),
(34253u16,4220u16),(34255u16,6789u16),(34256u16,6791u16),(34261u16,6792u16),
(34268u16,6795u16),(34269u16,6793u16),(34276u16,3480u16),(34277u16,6794u16),
(34281u16,3710u16),(34282u16,6781u16),(34295u16,2714u16),(34297u16,6796u16),
(34298u16,6801u16),(34299u16,3091u16),(34302u16,6800u16),(34306u16,6769u16),
(34310u16,6802u16),(34311u16,3048u16),(34314u16,6797u16),(34315u16,6799u16),
(34323u16,6798u16),(34326u16,5656u16),(34327u16,5641u16),(34330u16,6804u16),
(34338u16,6803u16),(34349u16,4221u16),(34351u16,6137u16),(34352u16,6805u16),
(34367u16,6806u16),(34381u16,6807u16),(34382u16,2216u16),(34384u16,1931u16),
(34388u16,6809u16),(34389u16,4572u16),(34394u16,1964u16),(34396u16,4255u16),
(34398u16,2056u16),(34399u16,6810u16),(34407u16,6811u16),(34411u16,3273u16),
(34417u16,6812u16),(34425u16,3567u16),(34427u16,1435u16),(34442u16,1664u16),
(34443u16,6817u16),(34444u16,6818u16),(34451u16,6813u16),(34453u16,2472u16),
(34467u16,6814u16),(34468u16,3605u16),(34473u16,6815u16),(34474u16,6816u16),
(34475u16,6826u16),(34479u16,6820u16),(34480u16,6823u16),(34486u16,6819u16),
(34500u16,6821u16),(34502u16,6822u16),(34503u16,2593u16),(34505u16,6824u16),
(34507u16,3228u16),(34509u16,2121u16),(34510u16,1725u16),(34516u16,6827u16),
(34521u16,1722u16),(34523u16,6832u16),(34526u16,6828u16),(34527u16,6831u16),
(34532u16,3691u16),(34537u16,6829u16),(34540u16,6830u16),(34541u16,3799u16),
(34542u16,3723u16),(34543u16,6833u16),(34552u16,3194u16),(34553u16,6843u16),
(34555u16,6839u16),(34558u16,1672u16),(34560u16,6837u16),(34562u16,3957u16),
(34563u16,6838u16),(34566u16,6835u16),(34568u16,6836u16),(34569u16,6841u16),
(34570u16,6844u16),(34573u16,6842u16),(34577u16,6840u16),(34578u16,6834u16),
(34584u16,3251u16),(34586u16,6851u16),(34588u16,4051u16),(34597u16,6849u16),
(34601u16,6850u16),(34612u16,6845u16),(34615u16,6847u16),(34619u16,6848u16),
(34623u16,6846u16),(34633u16,2983u16),(34635u16,4348u16),(34636u16,6855u16),
(34638u16,6856u16),(34643u16,6862u16),(34645u16,2829u16),(34647u16,6858u16),
(34649u16,6861u16),(34655u16,6853u16),(34656u16,6852u16),(34659u16,6863u16),
(34662u16,1657u16),(34664u16,6859u16),(34666u16,6864u16),(34670u16,6860u16),
(34676u16,6857u16),(34678u16,3308u16),(34680u16,6854u16),(34687u16,3643u16),
(34690u16,6868u16),(34701u16,4162u16),(34719u16,6867u16),(34722u16,6866u16),
(34731u16,6875u16),(34735u16,6869u16),(34739u16,6877u16),(34746u16,4205u16),
(34747u16,6880u16),(34749u16,6871u16),(34752u16,6872u16),(34756u16,6876u16),
(34758u16,6879u16),(34759u16,6878u16),(34763u16,6870u16),(34768u16,6873u16),
(34770u16,6890u16),(34784u16,6883u16),(34799u16,6881u16),(34802u16,6882u16),
(34806u16,6887u16),(34807u16,6888u16),(34809u16,1701u16),(34811u16,1913u16),
(34814u16,6886u16),(34821u16,6865u16),(34823u16,8528u16),(34829u16,6885u16),
(34830u16,6889u16),(34831u16,6884u16),(34833u16,6891u16),(34837u16,6893u16),
(34838u16,6892u16),(34849u16,6895u16),(34850u16,6894u16),(34851u16,6825u16),
(34855u16,6899u16),(34865u16,6896u16),(34870u16,6897u16),(34873u16,6898u16),
(34875u16,6900u16),(34880u16,2143u16),(34882u16,6902u16),(34884u16,6901u16),
(34886u16,2647u16),(34892u16,2307u16),(34893u16,5740u16),(34898u16,6903u16),
(34899u16,2680u16),(34903u16,1716u16),(34905u16,6904u16),(34907u16,1553u16),
(34909u16,2780u16),(34910u16,6905u16),(34913u16,2308u16),(34914u16,6906u16),
(34915u16,1474u16),(34920u16,3788u16),(34923u16,6907u16),(34928u16,2893u16),
(34930u16,6914u16),(34933u16,6911u16),(34935u16,3274u16),(34941u16,6912u16),
(34942u16,6909u16),(34943u16,2035u16),(34945u16,6908u16),(34946u16,6915u16),
(34952u16,2089u16),(34955u16,3163u16),(34957u16,6921u16),(34962u16,6917u16),
(34966u16,3122u16),(34967u16,6916u16),(34969u16,6919u16),(34974u16,6910u16),
(34978u16,6920u16),(34980u16,6922u16),(34987u16,3744u16),(34990u16,6918u16),
(34992u16,6923u16),(34993u16,6925u16),(34996u16,2212u16),(34997u16,6913u16),
(34999u16,1442u16),(35007u16,6924u16),(35009u16,2408u16),(35010u16,4315u16),
(35011u16,6926u16),(35012u16,6927u16),(35013u16,3092u16),(35023u16,4231u16),
(35028u16,6928u16),(35029u16,4156u16),(35032u16,6929u16),(35033u16,6930u16),
(35036u16,3921u16),(35037u16,6931u16),(35039u16,2381u16),(35041u16,4232u16),
(35048u16,6936u16),(35058u16,6937u16),(35059u16,2781u16),(35060u16,6935u16),
(35061u16,8529u16),(35064u16,4206u16),(35065u16,6932u16),(35068u16,6934u16),
(35069u16,2942u16),(35070u16,2913u16),(35074u16,6933u16),(35076u16,6938u16),
(35079u16,3856u16),(35082u16,6940u16),(35084u16,6939u16),(35088u16,1767u16),
(35090u16,3958u16),(35091u16,6941u16),(35100u16,8273u16),(35101u16,6953u16),
(35102u16,6943u16),(35109u16,6944u16),(35114u16,6945u16),(35115u16,6946u16),
(35126u16,6950u16),(35128u16,6951u16),(35131u16,6949u16),(35137u16,6947u16),
(35139u16,6942u16),(35140u16,6948u16),(35148u16,6952u16),(35149u16,7448u16),
(35158u16,1605u16),(35166u16,6955u16),(35167u16,2036u16),(35168u16,6954u16),
(35172u16,6957u16),(35174u16,6956u16),(35178u16,6959u16),(35181u16,6958u16),
(35183u16,6960u16),(35186u16,2648u16),(35188u16,6961u16),(35191u16,6962u16),
(35198u16,6963u16),(35199u16,2943u16),(35201u16,4190u16),(35203u16,6964u16),
(35206u16,3857u16),(35207u16,3609u16),(35208u16,6965u16),(35210u16,6966u16),
(35211u16,2172u16),(35215u16,1891u16),(35219u16,6967u16),(35222u16,2518u16),
(35223u16,3604u16),(35224u16,6968u16),(35226u16,1739u16),(35233u16,6969u16),
(35238u16,6971u16),(35239u16,4222u16),(35241u16,6970u16),(35242u16,2857u16),
(35244u16,6972u16),(35247u16,6973u16),(35250u16,6974u16),(35251u16,1834u16),
(35258u16,6975u16),(35261u16,6976u16),(35263u16,6977u16),(35264u16,6978u16),
(35282u16,1740u16),(35290u16,6979u16),(35292u16,6980u16),(35293u16,6981u16),
(35299u16,1679u16),(35302u16,2827u16),(35303u16,6982u16),(35316u16,6983u16),
(35320u16,6984u16),(35328u16,2193u16),(35330u16,3380u16),(35331u16,6985u16),
(35336u16,2122u16),(35338u16,2873u16),(35340u16,6988u16),(35342u16,3481u16),
(35344u16,6987u16),(35346u16,8530u16),(35347u16,2084u16),(35350u16,6986u16),
(35351u16,3188u16),(35352u16,1892u16),(35355u16,6989u16),(35357u16,6990u16),
(35359u16,2782u16),(35363u16,2144u16),(35365u16,6991u16),(35370u16,3959u16),
(35373u16,2976u16),(35377u16,1965u16),(35379u16,4126u16),(35380u16,3049u16),
(35382u16,6992u16),(35383u16,8531u16),(35386u16,2858u16),(35387u16,3275u16),
(35388u16,2783u16),(35393u16,6993u16),(35398u16,6996u16),(35400u16,6997u16),
(35408u16,2379u16),(35409u16,3135u16),(35410u16,6995u16),(35412u16,2784u16),
(35413u16,3789u16),(35419u16,6994u16),(35422u16,2519u16),(35424u16,1554u16),
(35426u16,7001u16),(35427u16,2123u16),(35430u16,2521u16),(35433u16,2520u16),
(35435u16,4368u16),(35436u16,7000u16),(35437u16,6999u16),(35438u16,3014u16),
(35440u16,1924u16),(35441u16,4358u16),(35442u16,1717u16),(35443u16,2785u16),
(35449u16,8532u16),(35452u16,6998u16),(35458u16,7003u16),(35460u16,7004u16),
(35461u16,7002u16),(35463u16,2217u16),(35465u16,4167u16),(35468u16,2522u16),
(35469u16,3578u16),(35473u16,7007u16),(35475u16,2945u16),(35477u16,3229u16),
(35480u16,4157u16),(35482u16,7010u16),(35486u16,2237u16),(35488u16,2944u16),
(35489u16,7006u16),(35491u16,7011u16),(35492u16,2238u16),(35493u16,7008u16),
(35494u16,7009u16),(35495u16,8533u16),(35496u16,7005u16),(35500u16,2979u16),
(35501u16,3518u16),(35504u16,3210u16),(35506u16,1658u16),(35513u16,3745u16),
(35516u16,1914u16),(35518u16,8534u16),(35519u16,3309u16),(35522u16,7014u16),
(35524u16,7012u16),(35527u16,3239u16),(35531u16,2946u16),(35532u16,1835u16),
(35533u16,7013u16),(35535u16,2878u16),(35538u16,4271u16),(35542u16,4355u16),
(35546u16,7015u16),(35547u16,7026u16),(35548u16,3310u16),(35550u16,7025u16),
(35551u16,8535u16),(35552u16,7022u16),(35553u16,7030u16),(35554u16,7023u16),
(35556u16,7019u16),(35558u16,3381u16),(35559u16,7018u16),(35563u16,7016u16),
(35565u16,4136u16),(35566u16,2523u16),(35569u16,7020u16),(35571u16,7017u16),
(35574u16,8537u16),(35575u16,7024u16),(35576u16,2715u16),(35578u16,2194u16),
(35582u16,3191u16),(35584u16,3984u16),(35585u16,1561u16),(35586u16,1475u16),
(35588u16,3482u16),(35591u16,7028u16),(35596u16,7027u16),(35598u16,3547u16),
(35600u16,7032u16),(35604u16,7021u16),(35606u16,7031u16),(35607u16,7033u16),
(35609u16,2173u16),(35610u16,7029u16),(35611u16,2309u16),(35613u16,2590u16),
(35616u16,7034u16),(35617u16,4191u16),(35622u16,7037u16),(35624u16,7040u16),
(35627u16,7038u16),(35628u16,3780u16),(35635u16,7035u16),(35641u16,2037u16),
(35646u16,7039u16),(35649u16,7041u16),(35657u16,7045u16),(35660u16,7042u16),
(35662u16,7044u16),(35663u16,7043u16),(35667u16,8538u16),(35670u16,7046u16),
(35672u16,2554u16),(35674u16,7048u16),(35675u16,7047u16),(35676u16,3831u16),
(35679u16,7050u16),(35686u16,2124u16),(35691u16,7049u16),(35692u16,7051u16),
(35695u16,7052u16),(35696u16,1915u16),(35697u16,6518u16),(35698u16,2814u16),
(35700u16,7053u16),(35703u16,2239u16),(35709u16,7054u16),(35711u16,8539u16),
(35712u16,7055u16),(35715u16,2473u16),(35722u16,5403u16),(35724u16,7056u16),
(35726u16,7057u16),(35728u16,2649u16),(35730u16,7058u16),(35731u16,7059u16),
(35734u16,7060u16),(35737u16,7061u16),(35738u16,7062u16),(35895u16,3206u16),
(35898u16,7063u16),(35903u16,7065u16),(35905u16,7064u16),(35910u16,3483u16),
(35912u16,7066u16),(35914u16,3960u16),(35916u16,7067u16),(35918u16,7068u16),
(35920u16,7069u16),(35925u16,7070u16),(35930u16,3535u16),(35937u16,2786u16),
(35938u16,7071u16),(35946u16,2330u16),(35947u16,4431u16),(35948u16,7072u16),
(35960u16,7073u16),(35961u16,3790u16),(35962u16,7074u16),(35964u16,7082u16),
(35970u16,7075u16),(35973u16,7077u16),(35977u16,7076u16),(35978u16,7078u16),
(35980u16,3985u16),(35981u16,7079u16),(35982u16,7080u16),(35988u16,7081u16),
(35992u16,7083u16),(35997u16,1704u16),(35998u16,3360u16),(36000u16,3832u16),
(36001u16,2415u16),(36002u16,2310u16),(36007u16,3806u16),(36008u16,1660u16),
(36009u16,3711u16),(36010u16,7086u16),(36011u16,1836u16),(36012u16,2966u16),
(36013u16,7085u16),(36014u16,7090u16),(36015u16,3284u16),(36016u16,4108u16),
(36018u16,7088u16),(36019u16,7089u16),(36020u16,1893u16),(36022u16,7091u16),
(36023u16,3638u16),(36024u16,3164u16),(36027u16,3746u16),(36028u16,3412u16),
(36029u16,7087u16),(36031u16,3986u16),(36032u16,1673u16),(36033u16,7093u16),
(36034u16,4331u16),(36035u16,3323u16),(36036u16,4360u16),(36039u16,2524u16),
(36040u16,7092u16),(36042u16,3118u16),(36045u16,7109u16),(36046u16,3015u16),
(36049u16,3565u16),(36051u16,3807u16),(36058u16,7096u16),(36059u16,2474u16),
(36060u16,2525u16),(36062u16,2787u16),(36064u16,3640u16),(36066u16,2174u16),
(36067u16,7095u16),(36068u16,7094u16),(36070u16,3833u16),(36074u16,2570u16),
(36077u16,3433u16),(36080u16,8540u16),(36084u16,8541u16),(36090u16,7098u16),
(36091u16,7099u16),(36092u16,2311u16),(36093u16,7097u16),(36100u16,7100u16),
(36101u16,7101u16),(36103u16,7103u16),(36104u16,3104u16),(36106u16,7102u16),
(36107u16,1855u16),(36109u16,7105u16),(36111u16,7104u16),(36112u16,7106u16),
(36114u16,8542u16),(36115u16,7108u16),(36116u16,7110u16),(36118u16,7111u16),
(36196u16,2967u16),(36198u16,2584u16),(36199u16,7112u16),(36203u16,1741u16),
(36205u16,7113u16),(36208u16,3093u16),(36209u16,7114u16),(36211u16,7115u16),
(36212u16,3834u16),(36214u16,8543u16),(36215u16,1894u16),(36225u16,7116u16),
(36229u16,3311u16),(36234u16,1562u16),(36249u16,7117u16),(36259u16,2618u16),
(36264u16,2905u16),(36275u16,3114u16),(36282u16,7120u16),(36286u16,7119u16),
(36290u16,7118u16),(36299u16,7126u16),(36300u16,7124u16),(36303u16,7121u16),
(36310u16,7123u16),(36314u16,7122u16),(36315u16,7125u16),(36317u16,1966u16),
(36319u16,7129u16),(36321u16,2968u16),(36323u16,7130u16),(36328u16,2218u16),
(36330u16,7127u16),(36331u16,7128u16),(36335u16,4332u16),(36339u16,3312u16),
(36341u16,3016u16),(36348u16,7131u16),(36351u16,7134u16),(36360u16,7132u16),
(36361u16,7133u16),(36362u16,4192u16),(36367u16,3484u16),(36368u16,7137u16),
(36381u16,7135u16),(36382u16,7136u16),(36383u16,7138u16),(36394u16,7152u16),
(36400u16,7141u16),(36404u16,7142u16),(36405u16,7140u16),(36418u16,7139u16),
(36420u16,3382u16),(36423u16,7144u16),(36424u16,7148u16),(36425u16,7145u16),
(36426u16,7143u16),(36428u16,7146u16),(36432u16,7147u16),(36437u16,7154u16),
(36441u16,7149u16),(36447u16,2969u16),(36448u16,7151u16),(36451u16,7153u16),
(36452u16,7150u16),(36466u16,7156u16),(36468u16,2650u16),(36470u16,7155u16),
(36476u16,7157u16),(36481u16,7158u16),(36484u16,7161u16),(36485u16,7160u16),
(36487u16,7159u16),(36490u16,7163u16),(36491u16,7162u16),(36493u16,4127u16),
(36497u16,7165u16),(36499u16,7164u16),(36500u16,7166u16),(36505u16,7167u16),
(36513u16,7169u16),(36522u16,7168u16),(36523u16,2859u16),(36524u16,7170u16),
(36527u16,2050u16),(36528u16,7171u16),(36529u16,7173u16),(36542u16,7174u16),
(36549u16,7175u16),(36550u16,7172u16),(36552u16,7176u16),(36554u16,2591u16),
(36555u16,7177u16),(36556u16,1895u16),(36557u16,2086u16),(36559u16,8545u16),
(36562u16,2175u16),(36571u16,7178u16),(36575u16,3557u16),(36578u16,3413u16),
(36579u16,7179u16),(36587u16,7182u16),(36600u16,2557u16),(36603u16,7181u16),
(36604u16,7180u16),(36605u16,2125u16),(36606u16,7183u16),(36611u16,1742u16),
(36613u16,7185u16),(36617u16,2409u16),(36618u16,7184u16),(36620u16,7193u16),
(36626u16,7187u16),(36627u16,7189u16),(36628u16,3922u16),(36629u16,7186u16),
(36633u16,7188u16),(36635u16,7192u16),(36636u16,7190u16),(36637u16,1896u16),
(36639u16,7191u16),(36646u16,7194u16),(36649u16,3629u16),(36650u16,4285u16),
(36655u16,2651u16),(36659u16,7195u16),(36664u16,4137u16),(36665u16,7197u16),
(36667u16,7196u16),(36670u16,7200u16),(36671u16,4168u16),(36674u16,7199u16),
(36676u16,1768u16),(36677u16,7198u16),(36678u16,7203u16),(36681u16,7202u16),
(36684u16,7201u16),(36685u16,3401u16),(36686u16,7204u16),(36695u16,7205u16),
(36700u16,7206u16),(36703u16,2331u16),(36705u16,2072u16),(36706u16,7207u16),
(36707u16,7208u16),(36708u16,7209u16),(36763u16,2860u16),(36764u16,7210u16),
(36766u16,2550u16),(36767u16,7211u16),(36771u16,7212u16),(36775u16,4606u16),
(36776u16,4605u16),(36781u16,7213u16),(36782u16,6471u16),(36783u16,7214u16),
(36784u16,3199u16),(36785u16,2830u16),(36786u16,3603u16),(36791u16,7215u16),
(36794u16,3906u16),(36795u16,3341u16),(36796u16,2349u16),(36799u16,3204u16),
(36802u16,1513u16),(36804u16,4035u16),(36805u16,2874u16),(36814u16,2129u16),
(36817u16,2038u16),(36820u16,3907u16),(36826u16,7216u16),(36834u16,7218u16),
(36837u16,7217u16),(36838u16,1661u16),(36841u16,3563u16),(36842u16,7219u16),
(36843u16,3658u16),(36845u16,3402u16),(36847u16,7220u16),(36848u16,2681u16),
(36852u16,7222u16),(36855u16,4075u16),(36856u16,7237u16),(36857u16,7224u16),
(36858u16,7225u16),(36861u16,3330u16),(36864u16,3165u16),(36865u16,3094u16),
(36867u16,3485u16),(36869u16,7223u16),(36870u16,1932u16),(36875u16,7232u16),
(36877u16,7229u16),(36878u16,7242u16),(36879u16,3486u16),(36880u16,3259u16),
(36881u16,7226u16),(36883u16,3383u16),(36884u16,3434u16),(36885u16,7227u16),
(36886u16,7231u16),(36887u16,2883u16),(36889u16,3642u16),(36890u16,3333u16),
(36893u16,2947u16),(36894u16,7230u16),(36895u16,3115u16),(36896u16,3105u16),
(36897u16,7228u16),(36898u16,1418u16),(36899u16,4325u16),(36903u16,7233u16),
(36910u16,3166u16),(36913u16,2652u16),(36914u16,2861u16),(36917u16,7235u16),
(36918u16,7234u16),(36920u16,1488u16),(36921u16,7236u16),(36924u16,3774u16),
(36926u16,7244u16),(36929u16,3536u16),(36930u16,2894u16),(36933u16,3252u16),
(36935u16,2061u16),(36937u16,7243u16),(36938u16,4158u16),(36939u16,1534u16),
(36941u16,3908u16),(36942u16,1662u16),(36943u16,7238u16),(36944u16,7239u16),
(36945u16,7240u16),(36946u16,7241u16),(36947u16,3504u16),(36948u16,3198u16),
(36949u16,1476u16),(36950u16,7245u16),(36952u16,7246u16),(36953u16,7804u16),
(36956u16,3130u16),(36958u16,7247u16),(36960u16,1586u16),(36961u16,3051u16),
(36963u16,2176u16),(36965u16,4193u16),(36967u16,8548u16),(36968u16,7248u16),
(36969u16,3395u16),(36973u16,3095u16),(36974u16,2592u16),(36975u16,7249u16),
(36978u16,7252u16),(36981u16,2700u16),(36982u16,7250u16),(36983u16,3018u16),
(36984u16,3017u16),(36986u16,1477u16),(36988u16,4272u16),(36989u16,7254u16),
(36991u16,3747u16),(36992u16,7256u16),(36993u16,7255u16),(36994u16,7253u16),
(36995u16,6271u16),(36996u16,1837u16),(36999u16,7221u16),(37001u16,7258u16),
(37002u16,7257u16),(37007u16,7259u16),(37009u16,4159u16),(37027u16,3542u16),
(37030u16,3961u16),(37032u16,7260u16),(37034u16,2594u16),(37039u16,7261u16),
(37041u16,7262u16),(37045u16,7263u16),(37048u16,3384u16),(37057u16,1483u16),
(37066u16,2312u16),(37070u16,4349u16),(37083u16,7267u16),(37086u16,8549u16),
(37089u16,2087u16),(37090u16,7264u16),(37092u16,7265u16),(37096u16,3843u16),
(37101u16,1743u16),(37109u16,4160u16),(37111u16,2004u16),(37117u16,3435u16),
(37122u16,7268u16),(37138u16,7269u16),(37141u16,8551u16),(37145u16,7270u16),
(37159u16,8552u16),(37165u16,3385u16),(37168u16,7272u16),(37170u16,7271u16),
(37193u16,3528u16),(37194u16,7273u16),(37195u16,2653u16),(37196u16,2601u16),
(37197u16,3630u16),(37198u16,3276u16),(37202u16,2619u16),(37204u16,2895u16),
(37206u16,7274u16),(37208u16,7275u16),(37218u16,2880u16),(37219u16,7276u16),
(37221u16,7277u16),(37225u16,7278u16),(37226u16,4214u16),(37228u16,2654u16),
(37234u16,7280u16),(37235u16,7279u16),(37237u16,2313u16),(37239u16,2338u16),
(37240u16,2475u16),(37250u16,7283u16),(37255u16,2701u16),(37257u16,7282u16),
(37259u16,7281u16),(37261u16,3174u16),(37264u16,2240u16),(37266u16,2948u16),
(37271u16,3681u16),(37276u16,2656u16),(37282u16,7284u16),(37284u16,2788u16),
(37290u16,7287u16),(37291u16,7285u16),(37295u16,7286u16),(37300u16,7289u16),
(37301u16,7288u16),(37304u16,2815u16),(37306u16,7290u16),(37312u16,7291u16),
(37313u16,7292u16),(37318u16,3713u16),(37319u16,2400u16),(37320u16,2602u16),
(37321u16,7293u16),(37323u16,7294u16),(37324u16,4233u16),(37325u16,2668u16),
(37326u16,4119u16),(37327u16,4273u16),(37328u16,7295u16),(37329u16,2039u16),
(37334u16,7296u16),(37335u16,8554u16),(37336u16,3386u16),(37338u16,8553u16),
(37339u16,7299u16),(37340u16,1779u16),(37341u16,2862u16),(37342u16,8555u16),
(37343u16,7297u16),(37345u16,7298u16),(37347u16,3353u16),(37348u16,8558u16),
(37349u16,8559u16),(37350u16,4000u16),(37351u16,2065u16),(37357u16,8556u16),
(37358u16,8557u16),(37365u16,7301u16),(37366u16,7302u16),(37372u16,7300u16),
(37375u16,7304u16),(37382u16,8560u16),(37386u16,8562u16),(37389u16,3540u16),
(37390u16,1726u16),(37392u16,8561u16),(37393u16,7308u16),(37396u16,7305u16),
(37397u16,7307u16),(37406u16,7303u16),(37417u16,7378u16),(37420u16,7306u16),
(37428u16,4304u16),(37431u16,2219u16),(37433u16,8569u16),(37434u16,8563u16),
(37436u16,8565u16),(37439u16,7316u16),(37440u16,8564u16),(37444u16,3403u16),
(37445u16,7311u16),(37448u16,7314u16),(37449u16,7312u16),(37451u16,7317u16),
(37454u16,8566u16),(37456u16,7318u16),(37457u16,8568u16),(37463u16,7310u16),
(37465u16,8567u16),(37466u16,7323u16),(37467u16,1587u16),(37470u16,7309u16),
(37474u16,3678u16),(37476u16,7313u16),(37478u16,2789u16),(37479u16,8570u16),
(37489u16,2314u16),(37495u16,8572u16),(37496u16,8573u16),(37502u16,3987u16),
(37504u16,2041u16),(37507u16,2669u16),(37509u16,3505u16),(37512u16,8275u16),
(37521u16,3020u16),(37523u16,7321u16),(37525u16,7315u16),(37526u16,7320u16),
(37528u16,4076u16),(37530u16,3313u16),(37531u16,7322u16),(37532u16,7319u16),
(37543u16,8571u16),(37549u16,3019u16),(37559u16,7326u16),(37561u16,7325u16),
(37583u16,7324u16),(37584u16,8577u16),(37586u16,3962u16),(37587u16,8581u16),
(37589u16,8579u16),(37591u16,8575u16),(37593u16,8576u16),(37600u16,8580u16),
(37604u16,2722u16),(37607u16,8574u16),(37609u16,7327u16),(37610u16,3916u16),
(37613u16,1555u16),(37618u16,3797u16),(37619u16,3277u16),(37624u16,1967u16),
(37625u16,8281u16),(37626u16,7329u16),(37627u16,8584u16),(37628u16,2316u16),
(37631u16,8587u16),(37634u16,8589u16),(37638u16,2455u16),(37647u16,7328u16),
(37648u16,2896u16),(37656u16,2897u16),(37657u16,7332u16),(37658u16,7334u16),
(37661u16,8588u16),(37662u16,8586u16),(37664u16,2816u16),(37665u16,8583u16),
(37666u16,7333u16),(37667u16,7335u16),(37669u16,8582u16),(37670u16,2024u16),
(37672u16,3796u16),(37675u16,2603u16),(37676u16,4326u16),(37678u16,7331u16),
(37679u16,2437u16),(37682u16,4354u16),(37685u16,7337u16),(37690u16,7336u16),
(37691u16,7338u16),(37700u16,7330u16),(37704u16,8274u16),(37707u16,3550u16),
(37709u16,3436u16),(37716u16,3344u16),(37718u16,7343u16),(37719u16,8591u16),
(37723u16,3230u16),(37724u16,7339u16),(37728u16,7340u16),(37740u16,2080u16),
(37742u16,7342u16),(37744u16,8590u16),(37749u16,2177u16),(37756u16,7341u16),
(37758u16,2790u16),(37772u16,1780u16),(37780u16,7347u16),(37782u16,2380u16),
(37783u16,3096u16),(37786u16,3331u16),(37796u16,8592u16),(37799u16,1718u16),
(37804u16,7345u16),(37805u16,7346u16),(37806u16,3324u16),(37808u16,7344u16),
(37817u16,7348u16),(37827u16,7354u16),(37830u16,8593u16),(37832u16,7357u16),
(37840u16,7356u16),(37841u16,3396u16),(37846u16,7349u16),(37847u16,7350u16),
(37848u16,7353u16),(37853u16,7355u16),(37854u16,8594u16),(37857u16,2005u16),
(37860u16,7358u16),(37861u16,7352u16),(37864u16,7351u16),(37880u16,8595u16),
(37891u16,7362u16),(37895u16,7363u16),(37904u16,7364u16),(37907u16,7361u16),
(37908u16,7360u16),(37912u16,2791u16),(37913u16,3487u16),(37914u16,7359u16),
(37921u16,7368u16),(37931u16,7366u16),(37937u16,8596u16),(37941u16,7367u16),
(37942u16,7365u16),(37944u16,3189u16),(37946u16,7369u16),(37953u16,7370u16),
(37956u16,7372u16),(37957u16,8597u16),(37960u16,8598u16),(37969u16,1838u16),
(37970u16,7371u16),(37971u16,4131u16),(37978u16,7383u16),(37979u16,7373u16),
(37982u16,7376u16),(37984u16,7374u16),(37986u16,7375u16),(37994u16,7377u16),
(38000u16,7379u16),(38005u16,7380u16),(38007u16,7381u16),(38012u16,7384u16),
(38013u16,7382u16),(38014u16,7385u16),(38015u16,7387u16),(38017u16,7386u16),
(38263u16,3314u16),(38272u16,4112u16),(38274u16,7388u16),(38275u16,3021u16),
(38279u16,7389u16),(38281u16,3889u16),(38282u16,7390u16),(38283u16,1702u16),
(38287u16,1531u16),(38289u16,1840u16),(38290u16,8599u16),(38291u16,1839u16),
(38292u16,7391u16),(38294u16,7392u16),(38296u16,7393u16),(38297u16,7394u16),
(38304u16,7395u16),(38306u16,1841u16),(38307u16,1744u16),(38308u16,2317u16),
(38309u16,3687u16),(38311u16,7397u16),(38312u16,7396u16),(38317u16,7398u16),
(38322u16,1563u16),(38329u16,7401u16),(38331u16,7400u16),(38332u16,7399u16),
(38334u16,7402u16),(38339u16,7405u16),(38343u16,1448u16),(38346u16,7403u16),
(38348u16,7407u16),(38349u16,7406u16),(38356u16,7409u16),(38357u16,7408u16),
(38358u16,7410u16),(38360u16,3491u16),(38364u16,7411u16),(38369u16,7412u16),
(38370u16,7414u16),(38373u16,7413u16),(38428u16,3835u16),(38433u16,7415u16),
(38440u16,7416u16),(38442u16,2418u16),(38446u16,7417u16),(38447u16,7418u16),
(38450u16,3988u16),(38459u16,3050u16),(38463u16,1413u16),(38464u16,3144u16),
(38466u16,7419u16),(38468u16,3836u16),(38475u16,7422u16),(38476u16,7420u16),
(38477u16,2318u16),(38479u16,7421u16),(38480u16,2195u16),(38491u16,3890u16),
(38492u16,7424u16),(38493u16,7426u16),(38494u16,7425u16),(38495u16,7427u16),
(38498u16,1504u16),(38499u16,2875u16),(38500u16,2723u16),(38501u16,1842u16),
(38502u16,7428u16),(38506u16,3641u16),(38508u16,7430u16),(38512u16,1505u16),
(38514u16,7429u16),(38515u16,3325u16),(38517u16,4274u16),(38518u16,3488u16),
(38519u16,7423u16),(38520u16,4235u16),(38522u16,2178u16),(38525u16,4194u16),
(38533u16,2062u16),(38534u16,4249u16),(38536u16,2075u16),(38538u16,3167u16),
(38539u16,6580u16),(38541u16,7431u16),(38542u16,1703u16),(38543u16,2898u16),
(38548u16,1745u16),(38549u16,7433u16),(38551u16,7434u16),(38552u16,7432u16),
(38553u16,2135u16),(38555u16,2410u16),(38556u16,2792u16),(38557u16,8602u16),
(38560u16,1506u16),(38563u16,4286u16),(38567u16,7436u16),(38568u16,7251u16),
(38570u16,7435u16),(38575u16,8603u16),(38576u16,7439u16),(38577u16,7437u16),
(38578u16,7438u16),(38580u16,7440u16),(38582u16,7441u16),(38583u16,4305u16),
(38584u16,7442u16),(38585u16,7443u16),(38587u16,2954u16),(38588u16,3692u16),
(38592u16,2912u16),(38593u16,1856u16),(38596u16,4161u16),(38597u16,1674u16),
(38598u16,2655u16),(38599u16,2220u16),(38601u16,7446u16),(38603u16,7445u16),
(38604u16,2526u16),(38605u16,7447u16),(38606u16,7444u16),(38609u16,2451u16),
(38613u16,7451u16),(38614u16,6874u16),(38617u16,4659u16),(38619u16,2906u16),
(38620u16,7449u16),(38626u16,4234u16),(38627u16,3558u16),(38632u16,1514u16),
(38634u16,2980u16),(38635u16,2559u16),(38640u16,3876u16),(38642u16,1535u16),
(38646u16,4306u16),(38647u16,4210u16),(38649u16,7452u16),(38651u16,3420u16),
(38656u16,2628u16),(38660u16,7453u16),(38662u16,7454u16),(38663u16,2863u16),
(38664u16,7455u16),(38666u16,4307u16),(38669u16,7450u16),(38670u16,7457u16),
(38671u16,7459u16),(38673u16,7458u16),(38675u16,7456u16),(38678u16,7460u16),
(38681u16,7461u16),(38684u16,3097u16),(38686u16,1663u16),(38692u16,7462u16),
(38695u16,4065u16),(38698u16,7463u16),(38704u16,7464u16),(38706u16,4333u16),
(38707u16,8604u16),(38712u16,5468u16),(38713u16,7465u16),(38715u16,8605u16),
(38717u16,7466u16),(38718u16,7467u16),(38722u16,7471u16),(38723u16,8606u16),
(38724u16,7468u16),(38726u16,7469u16),(38728u16,7470u16),(38729u16,7472u16),
(38733u16,8607u16),(38735u16,8608u16),(38737u16,8609u16),(38738u16,2949u16),
(38741u16,8610u16),(38742u16,4128u16),(38745u16,2950u16),(38748u16,7473u16),
(38750u16,3748u16),(38752u16,7474u16),(38753u16,7758u16),(38754u16,4085u16),
(38756u16,7475u16),(38758u16,7476u16),(38760u16,7477u16),(38761u16,1746u16),
(38763u16,7479u16),(38765u16,2876u16),(38769u16,7480u16),(38772u16,2071u16),
(38777u16,7481u16),(38778u16,7485u16),(38780u16,7483u16),(38785u16,7484u16),
(38788u16,1774u16),(38789u16,7482u16),(38790u16,7486u16),(38795u16,7487u16),
(38797u16,1449u16),(38799u16,7488u16),(38800u16,7489u16),(38808u16,2793u16),
(38812u16,7490u16),(38816u16,1918u16),(38819u16,7493u16),(38822u16,7492u16),
(38824u16,7491u16),(38827u16,7036u16),(38829u16,3913u16),(38835u16,7494u16),
(38836u16,7495u16),(38851u16,7496u16),(38854u16,7497u16),(38856u16,7498u16),
(38859u16,7499u16),(38867u16,1843u16),(38876u16,7500u16),(38893u16,7501u16),
(38894u16,3574u16),(38898u16,7503u16),(38899u16,1624u16),(38901u16,7506u16),
(38902u16,7505u16),(38907u16,1507u16),(38911u16,2006u16),(38913u16,3892u16),
(38914u16,3315u16),(38915u16,2351u16),(38917u16,2319u16),(38918u16,2702u16),
(38920u16,2879u16),(38924u16,7508u16),(38927u16,7507u16),(38928u16,4169u16),
(38929u16,1857u16),(38930u16,3715u16),(38931u16,3537u16),(38935u16,2911u16),
(38936u16,4275u16),(38938u16,2126u16),(38945u16,7511u16),(38948u16,7510u16),
(38956u16,3990u16),(38957u16,3489u16),(38964u16,1551u16),(38967u16,7512u16),
(38968u16,7509u16),(38971u16,3808u16),(38972u16,4209u16),(38973u16,7513u16),
(38982u16,7514u16),(38987u16,7516u16),(38988u16,3175u16),(38989u16,1750u16),
(38990u16,1751u16),(38991u16,7515u16),(38996u16,1858u16),(38997u16,2179u16),
(38999u16,8611u16),(39000u16,1859u16),(39003u16,3414u16),(39006u16,4293u16),
(39013u16,8612u16),(39015u16,2221u16),(39019u16,7517u16),(39023u16,7518u16),
(39024u16,7519u16),(39025u16,7520u16),(39027u16,7522u16),(39028u16,7521u16),
(39080u16,3846u16),(39082u16,7523u16),(39087u16,7524u16),(39089u16,7525u16),
(39094u16,7526u16),(39107u16,7528u16),(39108u16,7527u16),(39110u16,7529u16),
(39131u16,3749u16),(39132u16,6529u16),(39135u16,2828u16),(39138u16,1897u16),
(39145u16,7530u16),(39147u16,7531u16),(39149u16,4617u16),(39150u16,5666u16),
(39151u16,3716u16),(39154u16,1500u16),(39156u16,1436u16),(39164u16,2527u16),
(39165u16,3963u16),(39166u16,2819u16),(39171u16,7532u16),(39173u16,4104u16),
(39177u16,7533u16),(39178u16,4195u16),(39180u16,1537u16),(39184u16,2476u16),
(39186u16,7534u16),(39187u16,1675u16),(39188u16,7535u16),(39192u16,7536u16),
(39197u16,7538u16),(39198u16,7539u16),(39200u16,7541u16),(39201u16,7537u16),
(39204u16,7540u16),(39207u16,8615u16),(39208u16,1844u16),(39212u16,7542u16),
(39214u16,7543u16),(39229u16,7544u16),(39230u16,7545u16),(39234u16,7546u16),
(39237u16,7548u16),(39241u16,7547u16),(39243u16,7550u16),(39244u16,7553u16),
(39248u16,7549u16),(39249u16,7551u16),(39250u16,7552u16),(39253u16,7554u16),
(39255u16,2007u16),(39318u16,2620u16),(39319u16,7555u16),(39320u16,7556u16),
(39321u16,2320u16),(39326u16,8617u16),(39333u16,7557u16),(39336u16,1721u16),
(39340u16,3618u16),(39341u16,7558u16),(39342u16,7559u16),(39347u16,3253u16),
(39348u16,3552u16),(39356u16,7560u16),(39361u16,3664u16),(39364u16,3145u16),
(39365u16,1559u16),(39366u16,2051u16),(39368u16,2052u16),(39376u16,3278u16),
(39377u16,7565u16),(39378u16,2053u16),(39381u16,1676u16),(39384u16,7564u16),
(39387u16,7562u16),(39389u16,7563u16),(39391u16,7561u16),(39394u16,7575u16),
(39405u16,7566u16),(39406u16,7567u16),(39409u16,7568u16),(39410u16,7569u16),
(39416u16,7571u16),(39419u16,7570u16),(39423u16,2688u16),(39425u16,7572u16),
(39429u16,7574u16),(39438u16,1898u16),(39439u16,7573u16),(39442u16,3098u16),
(39443u16,2180u16),(39449u16,7576u16),(39464u16,3146u16),(39467u16,7577u16),
(39472u16,3490u16),(39479u16,7578u16),(39486u16,7583u16),(39488u16,7581u16),
(39490u16,7580u16),(39491u16,7582u16),(39493u16,7579u16),(39501u16,7585u16),
(39502u16,8618u16),(39509u16,7584u16),(39511u16,7587u16),(39514u16,2008u16),
(39515u16,7586u16),(39519u16,7588u16),(39522u16,7589u16),(39524u16,7591u16),
(39525u16,7590u16),(39529u16,7592u16),(39530u16,7594u16),(39531u16,7593u16),
(39592u16,2347u16),(39597u16,7595u16),(39600u16,7596u16),(39608u16,1719u16),
(39612u16,7597u16),(39616u16,7598u16),(39620u16,2900u16),(39631u16,7599u16),
(39633u16,7600u16),(39635u16,7601u16),(39636u16,7602u16),(39640u16,2321u16),
(39641u16,8619u16),(39644u16,8620u16),(39646u16,7603u16),(39647u16,7604u16),
(39650u16,7605u16),(39651u16,7606u16),(39654u16,7607u16),(39658u16,3682u16),
(39659u16,7609u16),(39661u16,3765u16),(39662u16,7610u16),(39663u16,7608u16),
(39665u16,7612u16),(39668u16,7611u16),(39671u16,7613u16),(39675u16,7614u16),
(39686u16,7615u16),(39704u16,7616u16),(39706u16,7617u16),(39711u16,7618u16),
(39714u16,7619u16),(39715u16,7620u16),(39717u16,7621u16),(39719u16,7622u16),
(39720u16,7623u16),(39721u16,7624u16),(39722u16,7625u16),(39726u16,7626u16),
(39727u16,7627u16),(39729u16,5660u16),(39730u16,7628u16),(39739u16,6385u16),
(39740u16,1899u16),(39745u16,1692u16),(39746u16,2367u16),(39747u16,7630u16),
(39748u16,7629u16),(39749u16,4046u16),(39757u16,7632u16),(39758u16,7633u16),
(39759u16,7631u16),(39761u16,7634u16),(39764u16,4013u16),(39768u16,7635u16),
(39770u16,1970u16),(39791u16,4328u16),(39794u16,8622u16),(39796u16,7636u16),
(39797u16,8621u16),(39811u16,7638u16),(39822u16,1439u16),(39823u16,8623u16),
(39825u16,7639u16),(39826u16,3864u16),(39827u16,7637u16),(39830u16,7640u16),
(39831u16,7641u16),(39839u16,7642u16),(39840u16,7643u16),(39848u16,7644u16),
(39850u16,4025u16),(39851u16,2456u16),(39853u16,2439u16),(39854u16,3022u16),
(39857u16,8624u16),(39860u16,7645u16),(39865u16,7648u16),(39867u16,8625u16),
(39872u16,7646u16),(39878u16,7649u16),(39881u16,2242u16),(39882u16,7647u16),
(39887u16,7650u16),(39889u16,7651u16),(39890u16,7652u16),(39892u16,7656u16),
(39894u16,2453u16),(39899u16,3169u16),(39905u16,7657u16),(39906u16,7654u16),
(39907u16,7653u16),(39908u16,7655u16),(39912u16,2130u16),(39920u16,7661u16),
(39921u16,7660u16),(39922u16,7659u16),(39925u16,1428u16),(39936u16,8626u16),
(39940u16,7671u16),(39942u16,7667u16),(39944u16,7668u16),(39945u16,7664u16),
(39946u16,7670u16),(39948u16,7666u16),(39949u16,1757u16),(39952u16,4367u16),
(39954u16,7669u16),(39955u16,7665u16),(39956u16,7663u16),(39957u16,7662u16),
(39963u16,7673u16),(39969u16,7676u16),(39972u16,7675u16),(39973u16,7674u16),
(39981u16,3800u16),(39982u16,7672u16),(39983u16,1492u16),(39984u16,7677u16),
(39986u16,7679u16),(39993u16,1770u16),(39994u16,7658u16),(39995u16,1526u16),
(39998u16,7681u16),(40006u16,7680u16),(40007u16,7678u16),(40008u16,3208u16),
(40018u16,4027u16),(40023u16,4287u16),(40026u16,7682u16),(40032u16,7683u16),
(40039u16,7684u16),(40054u16,7685u16),(40056u16,7686u16),(40165u16,3316u16),
(40167u16,7687u16),(40169u16,3688u16),(40171u16,7692u16),(40172u16,7688u16),
(40176u16,7689u16),(40179u16,3964u16),(40180u16,4077u16),(40182u16,3525u16),
(40195u16,7693u16),(40198u16,7694u16),(40199u16,3507u16),(40200u16,7691u16),
(40201u16,7690u16),(40206u16,1607u16),(40210u16,7702u16),(40213u16,7701u16),
(40219u16,1588u16),(40223u16,7699u16),(40227u16,7698u16),(40230u16,7696u16),
(40232u16,1782u16),(40234u16,7695u16),(40235u16,2555u16),(40236u16,1606u16),
(40251u16,2322u16),(40254u16,7705u16),(40255u16,7704u16),(40257u16,7703u16),
(40260u16,7700u16),(40262u16,7706u16),(40264u16,7707u16),(40272u16,7712u16),
(40273u16,7711u16),(40281u16,7713u16),(40284u16,1516u16),(40285u16,7708u16),
(40286u16,7709u16),(40288u16,2339u16),(40289u16,4066u16),(40292u16,7710u16),
(40299u16,8628u16),(40300u16,3965u16),(40303u16,7718u16),(40304u16,8627u16),
(40306u16,7714u16),(40314u16,7719u16),(40327u16,7716u16),(40329u16,7715u16),
(40335u16,2127u16),(40346u16,7720u16),(40356u16,7721u16),(40361u16,7722u16),
(40363u16,7717u16),(40367u16,7697u16),(40370u16,7723u16),(40372u16,3354u16),
(40376u16,7727u16),(40378u16,7728u16),(40379u16,7726u16),(40385u16,7725u16),
(40386u16,7731u16),(40388u16,7724u16),(40390u16,7729u16),(40399u16,7730u16),
(40403u16,7733u16),(40409u16,7732u16),(40422u16,7735u16),(40429u16,7736u16),
(40431u16,7737u16),(40434u16,4364u16),(40440u16,7734u16),(40441u16,3176u16),
(40442u16,2426u16),(40445u16,7738u16),(40473u16,8630u16),(40474u16,7739u16),
(40475u16,7740u16),(40478u16,7741u16),(40565u16,7742u16),(40568u16,2181u16),
(40569u16,7743u16),(40573u16,7744u16),(40575u16,2552u16),(40577u16,7745u16),
(40584u16,7746u16),(40587u16,7747u16),(40588u16,7748u16),(40593u16,7751u16),
(40594u16,7749u16),(40595u16,4351u16),(40597u16,7750u16),(40599u16,4308u16),
(40605u16,7752u16),(40607u16,4288u16),(40613u16,7753u16),(40614u16,3665u16),
(40617u16,7754u16),(40618u16,7756u16),(40621u16,7757u16),(40632u16,7755u16),
(40633u16,2332u16),(40634u16,4086u16),(40635u16,4014u16),(40636u16,5068u16),
(40638u16,5703u16),(40639u16,4038u16),(40644u16,1608u16),(40652u16,7759u16),
(40653u16,1927u16),(40654u16,7760u16),(40655u16,7761u16),(40656u16,7762u16),
(40657u16,8631u16),(40658u16,2340u16),(40660u16,7763u16),(40664u16,5973u16),
(40665u16,4100u16),(40667u16,3168u16),(40668u16,7764u16),(40669u16,7766u16),
(40670u16,7765u16),(40672u16,7767u16),(40677u16,7768u16),(40680u16,7769u16),
(40687u16,7770u16),(40692u16,7771u16),(40694u16,7772u16),(40695u16,7773u16),
(40697u16,7774u16),(40699u16,7775u16),(40700u16,7776u16),(40701u16,7777u16),
(40711u16,7778u16),(40712u16,7779u16),(40718u16,3387u16),(40723u16,2222u16),
(40725u16,7781u16),(40736u16,3052u16),(40737u16,7782u16),(40748u16,7783u16),
(40763u16,3760u16),(40766u16,7784u16),(40778u16,7785u16),(40779u16,6226u16),
(40782u16,7107u16),(40783u16,7502u16),(40786u16,7786u16),(40788u16,7787u16),
(40799u16,7789u16),(40800u16,7790u16),(40801u16,7791u16),(40802u16,4309u16),
(40803u16,7788u16),(40806u16,7792u16),(40807u16,7793u16),(40810u16,7795u16),
(40812u16,7794u16),(40818u16,7797u16),(40822u16,7798u16),(40823u16,7796u16),
(40845u16,4251u16),(40853u16,7799u16),(40860u16,7800u16),(40861u16,6255u16),
(40864u16,7801u16),(63785u16,8403u16),(63964u16,8600u16),(64014u16,8323u16),
(64015u16,8334u16),(64016u16,8335u16),(64017u16,8356u16),(64018u16,8395u16),
(64019u16,8411u16),(64020u16,8413u16),(64021u16,8456u16),(64022u16,8462u16),
(64023u16,8485u16),(64024u16,8493u16),(64025u16,8494u16),(64026u16,8495u16),
(64027u16,8497u16),(64028u16,8501u16),(64029u16,8504u16),(64030u16,8513u16),
(64031u16,8524u16),(64032u16,8526u16),(64033u16,8527u16),(64034u16,8536u16),
(64035u16,8544u16),(64036u16,8546u16),(64037u16,8547u16),(64038u16,8550u16),
(64039u16,8578u16),(64040u16,8585u16),(64041u16,8601u16),(64042u16,8613u16),
(64043u16,8614u16),(64044u16,8616u16),(64045u16,8629u16),(65281u16,9u16),
(65282u16,8647u16),(65283u16,83u16),(65284u16,79u16),(65285u16,82u16),
(65286u16,84u16),(65287u16,8646u16),(65288u16,41u16),(65289u16,42u16),
(65290u16,85u16),(65291u16,59u16),(65292u16,3u16),(65293u16,60u16),
(65294u16,4u16),(65295u16,30u16),(65296u16,203u16),(65297u16,204u16),
(65298u16,205u16),(65299u16,206u16),(65300u16,207u16),(65301u16,208u16),
(65302u16,209u16),(65303u16,210u16),(65304u16,211u16),(65305u16,212u16),
(65306u16,6u16),(65307u16,7u16),(65308u16,66u16),(65309u16,64u16),
(65310u16,67u16),(65311u16,8u16),(65312u16,86u16),(65313u16,220u16),
(65314u16,221u16),(65315u16,222u16),(65316u16,223u16),(65317u16,224u16),
(65318u16,225u16),(65319u16,226u16),(65320u16,227u16),(65321u16,228u16),
(65322u16,229u16),(65323u16,230u16),(65324u16,231u16),(65325u16,232u16),
(65326u16,233u16),(65327u16,234u16),(65328u16,235u16),(65329u16,236u16),
(65330u16,237u16),(65331u16,238u16),(65332u16,239u16),(65333u16,240u16),
(65334u16,241u16),(65335u16,242u16),(65336u16,243u16),(65337u16,244u16),
(65338u16,245u16),(65339u16,45u16),(65340u16,31u16),(65341u16,46u16),
(65342u16,15u16),(65343u16,17u16),(65344u16,13u16),(65345u16,252u16),
(65346u16,253u16),(65347u16,254u16),(65348u16,255u16),(65349u16,256u16),
(65350u16,257u16),(65351u16,258u16),(65352u16,259u16),(65353u16,260u16),
(65354u16,261u16),(65355u16,262u16),(65356u16,263u16),(65357u16,264u16),
(65358u16,265u16),(65359u16,266u16),(65360u16,267u16),(65361u16,268u16),
(65362u16,269u16),(65363u16,270u16),(65364u16,271u16),(65365u16,272u16),
(65366u16,273u16),(65367u16,274u16),(65368u16,275u16),(65369u16,276u16),
(65370u16,277u16),(65371u16,47u16),(65372u16,34u16),(65373u16,48u16),
(65374u16,32u16),(65504u16,80u16),(65505u16,81u16),(65506u16,137u16),
(65507u16,16u16),(65508u16,8645u16),(65509u16,78u16),
]

const Jis0212Decode*: array[7211, uint16] = [
uint16 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,184,729,733,175,
731,730,65374,900,901,0,0,0,0,0,0,0,0,161,166,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,186,170,169,174,8482,164,8470,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,902,
904,905,906,938,0,908,0,910,939,0,911,0,0,0,0,940,941,942,943,970,912,972,962,
973,971,944,974,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,1036,1038,1039,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1106,1107,1108,
1109,1110,1111,1112,1113,1114,1115,1116,1118,1119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
198,272,0,294,0,306,0,321,319,0,330,216,338,0,358,222,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,230,273,240,295,305,307,312,322,320,329,331,248,339,223,359,254,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,193,192,196,194,258,461,256,260,197,195,262,264,268,199,266,270,201,200,203,
202,282,278,274,280,0,284,286,290,288,292,205,204,207,206,463,304,298,302,296,
308,310,313,317,315,323,327,325,209,211,210,214,212,465,336,332,213,340,344,342,
346,348,352,350,356,354,218,217,220,219,364,467,368,362,370,366,360,471,475,473,
469,372,221,376,374,377,381,379,0,0,0,0,0,0,0,225,224,228,226,259,462,257,261,
229,227,263,265,269,231,267,271,233,232,235,234,283,279,275,281,501,285,287,0,
289,293,237,236,239,238,464,0,299,303,297,309,311,314,318,316,324,328,326,241,
243,242,246,244,466,337,333,245,341,345,343,347,349,353,351,357,355,250,249,252,
251,365,468,369,363,371,367,361,472,476,474,470,373,253,255,375,378,382,380,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19970,19972,19973,19980,19986,19999,
20003,20004,20008,20011,20014,20015,20016,20021,20032,20033,20036,20039,20049,
20058,20060,20067,20072,20073,20084,20085,20089,20095,20109,20118,20119,20125,
20143,20153,20163,20176,20186,20187,20192,20193,20194,20200,20207,20209,20211,
20213,20221,20222,20223,20224,20226,20227,20232,20235,20236,20242,20245,20246,
20247,20249,20270,20273,20320,20275,20277,20279,20281,20283,20286,20288,20290,
20296,20297,20299,20300,20306,20308,20310,20312,20319,20323,20330,20332,20334,
20337,20343,20344,20345,20346,20349,20350,20353,20354,20356,20357,20361,20362,
20364,20366,20368,20370,20371,20372,20375,20377,20378,20382,20383,20402,20407,
20409,20411,20412,20413,20414,20416,20417,20421,20422,20424,20425,20427,20428,
20429,20431,20434,20444,20448,20450,20464,20466,20476,20477,20479,20480,20481,
20484,20487,20490,20492,20494,20496,20499,20503,20504,20507,20508,20509,20510,
20514,20519,20526,20528,20530,20531,20533,20544,20545,20546,20549,20550,20554,
20556,20558,20561,20562,20563,20567,20569,20575,20576,20578,20579,20582,20583,
20586,20589,20592,20593,20539,20609,20611,20612,20614,20618,20622,20623,20624,
20626,20627,20628,20630,20635,20636,20638,20639,20640,20641,20642,20650,20655,
20656,20665,20666,20669,20672,20675,20676,20679,20684,20686,20688,20691,20692,
20696,20700,20701,20703,20706,20708,20710,20712,20713,20719,20721,20726,20730,
20734,20739,20742,20743,20744,20747,20748,20749,20750,20722,20752,20759,20761,
20763,20764,20765,20766,20771,20775,20776,20780,20781,20783,20785,20787,20788,
20789,20792,20793,20802,20810,20815,20819,20821,20823,20824,20831,20836,20838,
20862,20867,20868,20875,20878,20888,20893,20897,20899,20909,20920,20922,20924,
20926,20927,20930,20936,20943,20945,20946,20947,20949,20952,20958,20962,20965,
20974,20978,20979,20980,20983,20993,20994,20997,21010,21011,21013,21014,21016,
21026,21032,21041,21042,21045,21052,21061,21065,21077,21079,21080,21082,21084,
21087,21088,21089,21094,21102,21111,21112,21113,21120,21122,21125,21130,21132,
21139,21141,21142,21143,21144,21146,21148,21156,21157,21158,21159,21167,21168,
21174,21175,21176,21178,21179,21181,21184,21188,21190,21192,21196,21199,21201,
21204,21206,21211,21212,21217,21221,21224,21225,21226,21228,21232,21233,21236,
21238,21239,21248,21251,21258,21259,21260,21265,21267,21272,21275,21276,21278,
21279,21285,21287,21288,21289,21291,21292,21293,21296,21298,21301,21308,21309,
21310,21314,21324,21323,21337,21339,21345,21347,21349,21356,21357,21362,21369,
21374,21379,21383,21384,21390,21395,21396,21401,21405,21409,21412,21418,21419,
21423,21426,21428,21429,21431,21432,21434,21437,21440,21445,21455,21458,21459,
21461,21466,21469,21470,21472,21478,21479,21493,21506,21523,21530,21537,21543,
21544,21546,21551,21553,21556,21557,21571,21572,21575,21581,21583,21598,21602,
21604,21606,21607,21609,21611,21613,21614,21620,21631,21633,21635,21637,21640,
21641,21645,21649,21653,21654,21660,21663,21665,21670,21671,21673,21674,21677,
21678,21681,21687,21689,21690,21691,21695,21702,21706,21709,21710,21728,21738,
21740,21743,21750,21756,21758,21759,21760,21761,21765,21768,21769,21772,21773,
21774,21781,21802,21803,21810,21813,21814,21819,21820,21821,21825,21831,21833,
21834,21837,21840,21841,21848,21850,21851,21854,21856,21857,21860,21862,21887,
21889,21890,21894,21896,21902,21903,21905,21906,21907,21908,21911,21923,21924,
21933,21938,21951,21953,21955,21958,21961,21963,21964,21966,21969,21970,21971,
21975,21976,21979,21982,21986,21993,22006,22015,22021,22024,22026,22029,22030,
22031,22032,22033,22034,22041,22060,22064,22067,22069,22071,22073,22075,22076,
22077,22079,22080,22081,22083,22084,22086,22089,22091,22093,22095,22100,22110,
22112,22113,22114,22115,22118,22121,22125,22127,22129,22130,22133,22148,22149,
22152,22155,22156,22165,22169,22170,22173,22174,22175,22182,22183,22184,22185,
22187,22188,22189,22193,22195,22199,22206,22213,22217,22218,22219,22223,22224,
22220,22221,22233,22236,22237,22239,22241,22244,22245,22246,22247,22248,22257,
22251,22253,22262,22263,22273,22274,22279,22282,22284,22289,22293,22298,22299,
22301,22304,22306,22307,22308,22309,22313,22314,22316,22318,22319,22323,22324,
22333,22334,22335,22341,22342,22348,22349,22354,22370,22373,22375,22376,22379,
22381,22382,22383,22384,22385,22387,22388,22389,22391,22393,22394,22395,22396,
22398,22401,22403,22412,22420,22423,22425,22426,22428,22429,22430,22431,22433,
22421,22439,22440,22441,22444,22456,22461,22471,22472,22476,22479,22485,22493,
22494,22500,22502,22503,22505,22509,22512,22517,22518,22520,22525,22526,22527,
22531,22532,22536,22537,22497,22540,22541,22555,22558,22559,22560,22566,22567,
22573,22578,22585,22591,22601,22604,22605,22607,22608,22613,22623,22625,22628,
22631,22632,22648,22652,22655,22656,22657,22663,22664,22665,22666,22668,22669,
22671,22672,22676,22678,22685,22688,22689,22690,22694,22697,22705,22706,22724,
22716,22722,22728,22733,22734,22736,22738,22740,22742,22746,22749,22753,22754,
22761,22771,22789,22790,22795,22796,22802,22803,22804,34369,22813,22817,22819,
22820,22824,22831,22832,22835,22837,22838,22847,22851,22854,22866,22867,22873,
22875,22877,22878,22879,22881,22883,22891,22893,22895,22898,22901,22902,22905,
22907,22908,22923,22924,22926,22930,22933,22935,22943,22948,22951,22957,22958,
22959,22960,22963,22967,22970,22972,22977,22979,22980,22984,22986,22989,22994,
23005,23006,23007,23011,23012,23015,23022,23023,23025,23026,23028,23031,23040,
23044,23052,23053,23054,23058,23059,23070,23075,23076,23079,23080,23082,23085,
23088,23108,23109,23111,23112,23116,23120,23125,23134,23139,23141,23143,23149,
23159,23162,23163,23166,23179,23184,23187,23190,23193,23196,23198,23199,23200,
23202,23207,23212,23217,23218,23219,23221,23224,23226,23227,23231,23236,23238,
23240,23247,23258,23260,23264,23269,23274,23278,23285,23286,23293,23296,23297,
23304,23319,23348,23321,23323,23325,23329,23333,23341,23352,23361,23371,23372,
23378,23382,23390,23400,23406,23407,23420,23421,23422,23423,23425,23428,23430,
23434,23438,23440,23441,23443,23444,23446,23464,23465,23468,23469,23471,23473,
23474,23479,23482,23484,23488,23489,23501,23503,23510,23511,23512,23513,23514,
23520,23535,23537,23540,23549,23564,23575,23582,23583,23587,23590,23593,23595,
23596,23598,23600,23602,23605,23606,23641,23642,23644,23650,23651,23655,23656,
23657,23661,23664,23668,23669,23674,23675,23676,23677,23687,23688,23690,23695,
23698,23709,23711,23712,23714,23715,23718,23722,23730,23732,23733,23738,23753,
23755,23762,23773,23767,23790,23793,23794,23796,23809,23814,23821,23826,23851,
23843,23844,23846,23847,23857,23860,23865,23869,23871,23874,23875,23878,23880,
23893,23889,23897,23882,23903,23904,23905,23906,23908,23914,23917,23920,23929,
23930,23934,23935,23937,23939,23944,23946,23954,23955,23956,23957,23961,23963,
23967,23968,23975,23979,23984,23988,23992,23993,24003,24007,24011,24016,24014,
24024,24025,24032,24036,24041,24056,24057,24064,24071,24077,24082,24084,24085,
24088,24095,24096,24110,24104,24114,24117,24126,24139,24144,24137,24145,24150,
24152,24155,24156,24158,24168,24170,24171,24172,24173,24174,24176,24192,24203,
24206,24226,24228,24229,24232,24234,24236,24241,24243,24253,24254,24255,24262,
24268,24267,24270,24273,24274,24276,24277,24284,24286,24293,24299,24322,24326,
24327,24328,24334,24345,24348,24349,24353,24354,24355,24356,24360,24363,24364,
24366,24368,24372,24374,24379,24381,24383,24384,24388,24389,24391,24397,24400,
24404,24408,24411,24416,24419,24420,24423,24431,24434,24436,24437,24440,24442,
24445,24446,24457,24461,24463,24470,24476,24477,24482,24487,24491,24484,24492,
24495,24496,24497,24504,24516,24519,24520,24521,24523,24528,24529,24530,24531,
24532,24542,24545,24546,24552,24553,24554,24556,24557,24558,24559,24562,24563,
24566,24570,24572,24583,24586,24589,24595,24596,24599,24600,24602,24607,24612,
24621,24627,24629,24640,24647,24648,24649,24652,24657,24660,24662,24663,24669,
24673,24679,24689,24702,24703,24706,24710,24712,24714,24718,24721,24723,24725,
24728,24733,24734,24738,24740,24741,24744,24752,24753,24759,24763,24766,24770,
24772,24776,24777,24778,24779,24782,24783,24788,24789,24793,24795,24797,24798,
24802,24805,24818,24821,24824,24828,24829,24834,24839,24842,24844,24848,24849,
24850,24851,24852,24854,24855,24857,24860,24862,24866,24874,24875,24880,24881,
24885,24886,24887,24889,24897,24901,24902,24905,24926,24928,24940,24946,24952,
24955,24956,24959,24960,24961,24963,24964,24971,24973,24978,24979,24983,24984,
24988,24989,24991,24992,24997,25000,25002,25005,25016,25017,25020,25024,25025,
25026,25038,25039,25045,25052,25053,25054,25055,25057,25058,25063,25065,25061,
25068,25069,25071,25089,25091,25092,25095,25107,25109,25116,25120,25122,25123,
25127,25129,25131,25145,25149,25154,25155,25156,25158,25164,25168,25169,25170,
25172,25174,25178,25180,25188,25197,25199,25203,25210,25213,25229,25230,25231,
25232,25254,25256,25267,25270,25271,25274,25278,25279,25284,25294,25301,25302,
25306,25322,25330,25332,25340,25341,25347,25348,25354,25355,25357,25360,25363,
25366,25368,25385,25386,25389,25397,25398,25401,25404,25409,25410,25411,25412,
25414,25418,25419,25422,25426,25427,25428,25432,25435,25445,25446,25452,25453,
25457,25460,25461,25464,25468,25469,25471,25474,25476,25479,25482,25488,25492,
25493,25497,25498,25502,25508,25510,25517,25518,25519,25533,25537,25541,25544,
25550,25553,25555,25556,25557,25564,25568,25573,25578,25580,25586,25587,25589,
25592,25593,25609,25610,25616,25618,25620,25624,25630,25632,25634,25636,25637,
25641,25642,25647,25648,25653,25661,25663,25675,25679,25681,25682,25683,25684,
25690,25691,25692,25693,25695,25696,25697,25699,25709,25715,25716,25723,25725,
25733,25735,25743,25744,25745,25752,25753,25755,25757,25759,25761,25763,25766,
25768,25772,25779,25789,25790,25791,25796,25801,25802,25803,25804,25806,25808,
25809,25813,25815,25828,25829,25833,25834,25837,25840,25845,25847,25851,25855,
25857,25860,25864,25865,25866,25871,25875,25876,25878,25881,25883,25886,25887,
25890,25894,25897,25902,25905,25914,25916,25917,25923,25927,25929,25936,25938,
25940,25951,25952,25959,25963,25978,25981,25985,25989,25994,26002,26005,26008,
26013,26016,26019,26022,26030,26034,26035,26036,26047,26050,26056,26057,26062,
26064,26068,26070,26072,26079,26096,26098,26100,26101,26105,26110,26111,26112,
26116,26120,26121,26125,26129,26130,26133,26134,26141,26142,26145,26146,26147,
26148,26150,26153,26154,26155,26156,26158,26160,26161,26163,26169,26167,26176,
26181,26182,26186,26188,26193,26190,26199,26200,26201,26203,26204,26208,26209,
26363,26218,26219,26220,26238,26227,26229,26239,26231,26232,26233,26235,26240,
26236,26251,26252,26253,26256,26258,26265,26266,26267,26268,26271,26272,26276,
26285,26289,26290,26293,26299,26303,26304,26306,26307,26312,26316,26318,26319,
26324,26331,26335,26344,26347,26348,26350,26362,26373,26375,26382,26387,26393,
26396,26400,26402,26419,26430,26437,26439,26440,26444,26452,26453,26461,26470,
26476,26478,26484,26486,26491,26497,26500,26510,26511,26513,26515,26518,26520,
26521,26523,26544,26545,26546,26549,26555,26556,26557,26617,26560,26562,26563,
26565,26568,26569,26578,26583,26585,26588,26593,26598,26608,26610,26614,26615,
26706,26644,26649,26653,26655,26664,26663,26668,26669,26671,26672,26673,26675,
26683,26687,26692,26693,26698,26700,26709,26711,26712,26715,26731,26734,26735,
26736,26737,26738,26741,26745,26746,26747,26748,26754,26756,26758,26760,26774,
26776,26778,26780,26785,26787,26789,26793,26794,26798,26802,26811,26821,26824,
26828,26831,26832,26833,26835,26838,26841,26844,26845,26853,26856,26858,26859,
26860,26861,26864,26865,26869,26870,26875,26876,26877,26886,26889,26890,26896,
26897,26899,26902,26903,26929,26931,26933,26936,26939,26946,26949,26953,26958,
26967,26971,26979,26980,26981,26982,26984,26985,26988,26992,26993,26994,27002,
27003,27007,27008,27021,27026,27030,27032,27041,27045,27046,27048,27051,27053,
27055,27063,27064,27066,27068,27077,27080,27089,27094,27095,27106,27109,27118,
27119,27121,27123,27125,27134,27136,27137,27139,27151,27153,27157,27162,27165,
27168,27172,27176,27184,27186,27188,27191,27195,27198,27199,27205,27206,27209,
27210,27214,27216,27217,27218,27221,27222,27227,27236,27239,27242,27249,27251,
27262,27265,27267,27270,27271,27273,27275,27281,27291,27293,27294,27295,27301,
27307,27311,27312,27313,27316,27325,27326,27327,27334,27337,27336,27340,27344,
27348,27349,27350,27356,27357,27364,27367,27372,27376,27377,27378,27388,27389,
27394,27395,27398,27399,27401,27407,27408,27409,27415,27419,27422,27428,27432,
27435,27436,27439,27445,27446,27451,27455,27462,27466,27469,27474,27478,27480,
27485,27488,27495,27499,27502,27504,27509,27517,27518,27522,27525,27543,27547,
27551,27552,27554,27555,27560,27561,27564,27565,27566,27568,27576,27577,27581,
27582,27587,27588,27593,27596,27606,27610,27617,27619,27622,27623,27630,27633,
27639,27641,27647,27650,27652,27653,27657,27661,27662,27664,27666,27673,27679,
27686,27687,27688,27692,27694,27699,27701,27702,27706,27707,27711,27722,27723,
27725,27727,27730,27732,27737,27739,27740,27755,27757,27759,27764,27766,27768,
27769,27771,27781,27782,27783,27785,27796,27797,27799,27800,27804,27807,27824,
27826,27828,27842,27846,27853,27855,27856,27857,27858,27860,27862,27866,27868,
27872,27879,27881,27883,27884,27886,27890,27892,27908,27911,27914,27918,27919,
27921,27923,27930,27942,27943,27944,27751,27950,27951,27953,27961,27964,27967,
27991,27998,27999,28001,28005,28007,28015,28016,28028,28034,28039,28049,28050,
28052,28054,28055,28056,28074,28076,28084,28087,28089,28093,28095,28100,28104,
28106,28110,28111,28118,28123,28125,28127,28128,28130,28133,28137,28143,28144,
28148,28150,28156,28160,28164,28190,28194,28199,28210,28214,28217,28219,28220,
28228,28229,28232,28233,28235,28239,28241,28242,28243,28244,28247,28252,28253,
28254,28258,28259,28264,28275,28283,28285,28301,28307,28313,28320,28327,28333,
28334,28337,28339,28347,28351,28352,28353,28355,28359,28360,28362,28365,28366,
28367,28395,28397,28398,28409,28411,28413,28420,28424,28426,28428,28429,28438,
28440,28442,28443,28454,28457,28458,28463,28464,28467,28470,28475,28476,28461,
28495,28497,28498,28499,28503,28505,28506,28509,28510,28513,28514,28520,28524,
28541,28542,28547,28551,28552,28555,28556,28557,28560,28562,28563,28564,28566,
28570,28575,28576,28581,28582,28583,28584,28590,28591,28592,28597,28598,28604,
28613,28615,28616,28618,28634,28638,28648,28649,28656,28661,28665,28668,28669,
28672,28677,28678,28679,28685,28695,28704,28707,28719,28724,28727,28729,28732,
28739,28740,28744,28745,28746,28747,28756,28757,28765,28766,28750,28772,28773,
28780,28782,28789,28790,28798,28801,28805,28806,28820,28821,28822,28823,28824,
28827,28836,28843,28848,28849,28852,28855,28874,28881,28883,28884,28885,28886,
28888,28892,28900,28922,28931,28932,28933,28934,28935,28939,28940,28943,28958,
28960,28971,28973,28975,28976,28977,28984,28993,28997,28998,28999,29002,29003,
29008,29010,29015,29018,29020,29022,29024,29032,29049,29056,29061,29063,29068,
29074,29082,29083,29088,29090,29103,29104,29106,29107,29114,29119,29120,29121,
29124,29131,29132,29139,29142,29145,29146,29148,29176,29182,29184,29191,29192,
29193,29203,29207,29210,29213,29215,29220,29227,29231,29236,29240,29241,29249,
29250,29251,29253,29262,29263,29264,29267,29269,29270,29274,29276,29278,29280,
29283,29288,29291,29294,29295,29297,29303,29304,29307,29308,29311,29316,29321,
29325,29326,29331,29339,29352,29357,29358,29361,29364,29374,29377,29383,29385,
29388,29397,29398,29400,29407,29413,29427,29428,29434,29435,29438,29442,29444,
29445,29447,29451,29453,29458,29459,29464,29465,29470,29474,29476,29479,29480,
29484,29489,29490,29493,29498,29499,29501,29507,29517,29520,29522,29526,29528,
29533,29534,29535,29536,29542,29543,29545,29547,29548,29550,29551,29553,29559,
29561,29564,29568,29569,29571,29573,29574,29582,29584,29587,29589,29591,29592,
29596,29598,29599,29600,29602,29605,29606,29610,29611,29613,29621,29623,29625,
29628,29629,29631,29637,29638,29641,29643,29644,29647,29650,29651,29654,29657,
29661,29665,29667,29670,29671,29673,29684,29685,29687,29689,29690,29691,29693,
29695,29696,29697,29700,29703,29706,29713,29722,29723,29732,29734,29736,29737,
29738,29739,29740,29741,29742,29743,29744,29745,29753,29760,29763,29764,29766,
29767,29771,29773,29777,29778,29783,29789,29794,29798,29799,29800,29803,29805,
29806,29809,29810,29824,29825,29829,29830,29831,29833,29839,29840,29841,29842,
29848,29849,29850,29852,29855,29856,29857,29859,29862,29864,29865,29866,29867,
29870,29871,29873,29874,29877,29881,29883,29887,29896,29897,29900,29904,29907,
29912,29914,29915,29918,29919,29924,29928,29930,29931,29935,29940,29946,29947,
29948,29951,29958,29970,29974,29975,29984,29985,29988,29991,29993,29994,29999,
30006,30009,30013,30014,30015,30016,30019,30023,30024,30030,30032,30034,30039,
30046,30047,30049,30063,30065,30073,30074,30075,30076,30077,30078,30081,30085,
30096,30098,30099,30101,30105,30108,30114,30116,30132,30138,30143,30144,30145,
30148,30150,30156,30158,30159,30167,30172,30175,30176,30177,30180,30183,30188,
30190,30191,30193,30201,30208,30210,30211,30212,30215,30216,30218,30220,30223,
30226,30227,30229,30230,30233,30235,30236,30237,30238,30243,30245,30246,30249,
30253,30258,30259,30261,30264,30265,30266,30268,30282,30272,30273,30275,30276,
30277,30281,30283,30293,30297,30303,30308,30309,30317,30318,30319,30321,30324,
30337,30341,30348,30349,30357,30363,30364,30365,30367,30368,30370,30371,30372,
30373,30374,30375,30376,30378,30381,30397,30401,30405,30409,30411,30412,30414,
30420,30425,30432,30438,30440,30444,30448,30449,30454,30457,30460,30464,30470,
30474,30478,30482,30484,30485,30487,30489,30490,30492,30498,30504,30509,30510,
30511,30516,30517,30518,30521,30525,30526,30530,30533,30534,30538,30541,30542,
30543,30546,30550,30551,30556,30558,30559,30560,30562,30564,30567,30570,30572,
30576,30578,30579,30580,30586,30589,30592,30596,30604,30605,30612,30613,30614,
30618,30623,30626,30631,30634,30638,30639,30641,30645,30654,30659,30665,30673,
30674,30677,30681,30686,30687,30688,30692,30694,30698,30700,30704,30705,30708,
30712,30715,30725,30726,30729,30733,30734,30737,30749,30753,30754,30755,30765,
30766,30768,30773,30775,30787,30788,30791,30792,30796,30798,30802,30812,30814,
30816,30817,30819,30820,30824,30826,30830,30842,30846,30858,30863,30868,30872,
30881,30877,30878,30879,30884,30888,30892,30893,30896,30897,30898,30899,30907,
30909,30911,30919,30920,30921,30924,30926,30930,30931,30933,30934,30948,30939,
30943,30944,30945,30950,30954,30962,30963,30976,30966,30967,30970,30971,30975,
30982,30988,30992,31002,31004,31006,31007,31008,31013,31015,31017,31021,31025,
31028,31029,31035,31037,31039,31044,31045,31046,31050,31051,31055,31057,31060,
31064,31067,31068,31079,31081,31083,31090,31097,31099,31100,31102,31115,31116,
31121,31123,31124,31125,31126,31128,31131,31132,31137,31144,31145,31147,31151,
31153,31156,31160,31163,31170,31172,31175,31176,31178,31183,31188,31190,31194,
31197,31198,31200,31202,31205,31210,31211,31213,31217,31224,31228,31234,31235,
31239,31241,31242,31244,31249,31253,31259,31262,31265,31271,31275,31277,31279,
31280,31284,31285,31288,31289,31290,31300,31301,31303,31304,31308,31317,31318,
31321,31324,31325,31327,31328,31333,31335,31338,31341,31349,31352,31358,31360,
31362,31365,31366,31370,31371,31376,31377,31380,31390,31392,31395,31404,31411,
31413,31417,31419,31420,31430,31433,31436,31438,31441,31451,31464,31465,31467,
31468,31473,31476,31483,31485,31486,31495,31508,31519,31523,31527,31529,31530,
31531,31533,31534,31535,31536,31537,31540,31549,31551,31552,31553,31559,31566,
31573,31584,31588,31590,31593,31594,31597,31599,31602,31603,31607,31620,31625,
31630,31632,31633,31638,31643,31646,31648,31653,31660,31663,31664,31666,31669,
31670,31674,31675,31676,31677,31682,31685,31688,31690,31700,31702,31703,31705,
31706,31707,31720,31722,31730,31732,31733,31736,31737,31738,31740,31742,31745,
31746,31747,31748,31750,31753,31755,31756,31758,31759,31769,31771,31776,31781,
31782,31784,31788,31793,31795,31796,31798,31801,31802,31814,31818,31829,31825,
31826,31827,31833,31834,31835,31836,31837,31838,31841,31843,31847,31849,31853,
31854,31856,31858,31865,31868,31869,31878,31879,31887,31892,31902,31904,31910,
31920,31926,31927,31930,31931,31932,31935,31940,31943,31944,31945,31949,31951,
31955,31956,31957,31959,31961,31962,31965,31974,31977,31979,31989,32003,32007,
32008,32009,32015,32017,32018,32019,32022,32029,32030,32035,32038,32042,32045,
32049,32060,32061,32062,32064,32065,32071,32072,32077,32081,32083,32087,32089,
32090,32092,32093,32101,32103,32106,32112,32120,32122,32123,32127,32129,32130,
32131,32133,32134,32136,32139,32140,32141,32145,32150,32151,32157,32158,32166,
32167,32170,32179,32182,32183,32185,32194,32195,32196,32197,32198,32204,32205,
32206,32215,32217,32256,32226,32229,32230,32234,32235,32237,32241,32245,32246,
32249,32250,32264,32272,32273,32277,32279,32284,32285,32288,32295,32296,32300,
32301,32303,32307,32310,32319,32324,32325,32327,32334,32336,32338,32344,32351,
32353,32354,32357,32363,32366,32367,32371,32376,32382,32385,32390,32391,32394,
32397,32401,32405,32408,32410,32413,32414,32572,32571,32573,32574,32575,32579,
32580,32583,32591,32594,32595,32603,32604,32605,32609,32611,32612,32613,32614,
32621,32625,32637,32638,32639,32640,32651,32653,32655,32656,32657,32662,32663,
32668,32673,32674,32678,32682,32685,32692,32700,32703,32704,32707,32712,32718,
32719,32731,32735,32739,32741,32744,32748,32750,32751,32754,32762,32765,32766,
32767,32775,32776,32778,32781,32782,32783,32785,32787,32788,32790,32797,32798,
32799,32800,32804,32806,32812,32814,32816,32820,32821,32823,32825,32826,32828,
32830,32832,32836,32864,32868,32870,32877,32881,32885,32897,32904,32910,32924,
32926,32934,32935,32939,32952,32953,32968,32973,32975,32978,32980,32981,32983,
32984,32992,33005,33006,33008,33010,33011,33014,33017,33018,33022,33027,33035,
33046,33047,33048,33052,33054,33056,33060,33063,33068,33072,33077,33082,33084,
33093,33095,33098,33100,33106,33111,33120,33121,33127,33128,33129,33133,33135,
33143,33153,33168,33156,33157,33158,33163,33166,33174,33176,33179,33182,33186,
33198,33202,33204,33211,33227,33219,33221,33226,33230,33231,33237,33239,33243,
33245,33246,33249,33252,33259,33260,33264,33265,33266,33269,33270,33272,33273,
33277,33279,33280,33283,33295,33299,33300,33305,33306,33309,33313,33314,33320,
33330,33332,33338,33347,33348,33349,33350,33355,33358,33359,33361,33366,33372,
33376,33379,33383,33389,33396,33403,33405,33407,33408,33409,33411,33412,33415,
33417,33418,33422,33425,33428,33430,33432,33434,33435,33440,33441,33443,33444,
33447,33448,33449,33450,33454,33456,33458,33460,33463,33466,33468,33470,33471,
33478,33488,33493,33498,33504,33506,33508,33512,33514,33517,33519,33526,33527,
33533,33534,33536,33537,33543,33544,33546,33547,33620,33563,33565,33566,33567,
33569,33570,33580,33581,33582,33584,33587,33591,33594,33596,33597,33602,33603,
33604,33607,33613,33614,33617,33621,33622,33623,33648,33656,33661,33663,33664,
33666,33668,33670,33677,33682,33684,33685,33688,33689,33691,33692,33693,33702,
33703,33705,33708,33726,33727,33728,33735,33737,33743,33744,33745,33748,33757,
33619,33768,33770,33782,33784,33785,33788,33793,33798,33802,33807,33809,33813,
33817,33709,33839,33849,33861,33863,33864,33866,33869,33871,33873,33874,33878,
33880,33881,33882,33884,33888,33892,33893,33895,33898,33904,33907,33908,33910,
33912,33916,33917,33921,33925,33938,33939,33941,33950,33958,33960,33961,33962,
33967,33969,33972,33978,33981,33982,33984,33986,33991,33992,33996,33999,34003,
34012,34023,34026,34031,34032,34033,34034,34039,34098,34042,34043,34045,34050,
34051,34055,34060,34062,34064,34076,34078,34082,34083,34084,34085,34087,34090,
34091,34095,34099,34100,34102,34111,34118,34127,34128,34129,34130,34131,34134,
34137,34140,34141,34142,34143,34144,34145,34146,34148,34155,34159,34169,34170,
34171,34173,34175,34177,34181,34182,34185,34187,34188,34191,34195,34200,34205,
34207,34208,34210,34213,34215,34228,34230,34231,34232,34236,34237,34238,34239,
34242,34247,34250,34251,34254,34221,34264,34266,34271,34272,34278,34280,34285,
34291,34294,34300,34303,34304,34308,34309,34317,34318,34320,34321,34322,34328,
34329,34331,34334,34337,34343,34345,34358,34360,34362,34364,34365,34368,34370,
34374,34386,34387,34390,34391,34392,34393,34397,34400,34401,34402,34403,34404,
34409,34412,34415,34421,34422,34423,34426,34445,34449,34454,34456,34458,34460,
34465,34470,34471,34472,34477,34481,34483,34484,34485,34487,34488,34489,34495,
34496,34497,34499,34501,34513,34514,34517,34519,34522,34524,34528,34531,34533,
34535,34440,34554,34556,34557,34564,34565,34567,34571,34574,34575,34576,34579,
34580,34585,34590,34591,34593,34595,34600,34606,34607,34609,34610,34617,34618,
34620,34621,34622,34624,34627,34629,34637,34648,34653,34657,34660,34661,34671,
34673,34674,34683,34691,34692,34693,34694,34695,34696,34697,34699,34700,34704,
34707,34709,34711,34712,34713,34718,34720,34723,34727,34732,34733,34734,34737,
34741,34750,34751,34753,34760,34761,34762,34766,34773,34774,34777,34778,34780,
34783,34786,34787,34788,34794,34795,34797,34801,34803,34808,34810,34815,34817,
34819,34822,34825,34826,34827,34832,34841,34834,34835,34836,34840,34842,34843,
34844,34846,34847,34856,34861,34862,34864,34866,34869,34874,34876,34881,34883,
34885,34888,34889,34890,34891,34894,34897,34901,34902,34904,34906,34908,34911,
34912,34916,34921,34929,34937,34939,34944,34968,34970,34971,34972,34975,34976,
34984,34986,35002,35005,35006,35008,35018,35019,35020,35021,35022,35025,35026,
35027,35035,35038,35047,35055,35056,35057,35061,35063,35073,35078,35085,35086,
35087,35093,35094,35096,35097,35098,35100,35104,35110,35111,35112,35120,35121,
35122,35125,35129,35130,35134,35136,35138,35141,35142,35145,35151,35154,35159,
35162,35163,35164,35169,35170,35171,35179,35182,35184,35187,35189,35194,35195,
35196,35197,35209,35213,35216,35220,35221,35227,35228,35231,35232,35237,35248,
35252,35253,35254,35255,35260,35284,35285,35286,35287,35288,35301,35305,35307,
35309,35313,35315,35318,35321,35325,35327,35332,35333,35335,35343,35345,35346,
35348,35349,35358,35360,35362,35364,35366,35371,35372,35375,35381,35383,35389,
35390,35392,35395,35397,35399,35401,35405,35406,35411,35414,35415,35416,35420,
35421,35425,35429,35431,35445,35446,35447,35449,35450,35451,35454,35455,35456,
35459,35462,35467,35471,35472,35474,35478,35479,35481,35487,35495,35497,35502,
35503,35507,35510,35511,35515,35518,35523,35526,35528,35529,35530,35537,35539,
35540,35541,35543,35549,35551,35564,35568,35572,35573,35574,35580,35583,35589,
35590,35595,35601,35612,35614,35615,35594,35629,35632,35639,35644,35650,35651,
35652,35653,35654,35656,35666,35667,35668,35673,35661,35678,35683,35693,35702,
35704,35705,35708,35710,35713,35716,35717,35723,35725,35727,35732,35733,35740,
35742,35743,35896,35897,35901,35902,35909,35911,35913,35915,35919,35921,35923,
35924,35927,35928,35931,35933,35929,35939,35940,35942,35944,35945,35949,35955,
35957,35958,35963,35966,35974,35975,35979,35984,35986,35987,35993,35995,35996,
36004,36025,36026,36037,36038,36041,36043,36047,36054,36053,36057,36061,36065,
36072,36076,36079,36080,36082,36085,36087,36088,36094,36095,36097,36099,36105,
36114,36119,36123,36197,36201,36204,36206,36223,36226,36228,36232,36237,36240,
36241,36245,36254,36255,36256,36262,36267,36268,36271,36274,36277,36279,36281,
36283,36288,36293,36294,36295,36296,36298,36302,36305,36308,36309,36311,36313,
36324,36325,36327,36332,36336,36284,36337,36338,36340,36349,36353,36356,36357,
36358,36363,36369,36372,36374,36384,36385,36386,36387,36390,36391,36401,36403,
36406,36407,36408,36409,36413,36416,36417,36427,36429,36430,36431,36436,36443,
36444,36445,36446,36449,36450,36457,36460,36461,36463,36464,36465,36473,36474,
36475,36482,36483,36489,36496,36498,36501,36506,36507,36509,36510,36514,36519,
36521,36525,36526,36531,36533,36538,36539,36544,36545,36547,36548,36551,36559,
36561,36564,36572,36584,36590,36592,36593,36599,36601,36602,36589,36608,36610,
36615,36616,36623,36624,36630,36631,36632,36638,36640,36641,36643,36645,36647,
36648,36652,36653,36654,36660,36661,36662,36663,36666,36672,36673,36675,36679,
36687,36689,36690,36691,36692,36693,36696,36701,36702,36709,36765,36768,36769,
36772,36773,36774,36789,36790,36792,36798,36800,36801,36806,36810,36811,36813,
36816,36818,36819,36821,36832,36835,36836,36840,36846,36849,36853,36854,36859,
36862,36866,36868,36872,36876,36888,36891,36904,36905,36911,36906,36908,36909,
36915,36916,36919,36927,36931,36932,36940,36955,36957,36962,36966,36967,36972,
36976,36980,36985,36997,37000,37003,37004,37006,37008,37013,37015,37016,37017,
37019,37024,37025,37026,37029,37040,37042,37043,37044,37046,37053,37068,37054,
37059,37060,37061,37063,37064,37077,37079,37080,37081,37084,37085,37087,37093,
37074,37110,37099,37103,37104,37108,37118,37119,37120,37124,37125,37126,37128,
37133,37136,37140,37142,37143,37144,37146,37148,37150,37152,37157,37154,37155,
37159,37161,37166,37167,37169,37172,37174,37175,37177,37178,37180,37181,37187,
37191,37192,37199,37203,37207,37209,37210,37211,37217,37220,37223,37229,37236,
37241,37242,37243,37249,37251,37253,37254,37258,37262,37265,37267,37268,37269,
37272,37278,37281,37286,37288,37292,37293,37294,37296,37297,37298,37299,37302,
37307,37308,37309,37311,37314,37315,37317,37331,37332,37335,37337,37338,37342,
37348,37349,37353,37354,37356,37357,37358,37359,37360,37361,37367,37369,37371,
37373,37376,37377,37380,37381,37382,37383,37385,37386,37388,37392,37394,37395,
37398,37400,37404,37405,37411,37412,37413,37414,37416,37422,37423,37424,37427,
37429,37430,37432,37433,37434,37436,37438,37440,37442,37443,37446,37447,37450,
37453,37454,37455,37457,37464,37465,37468,37469,37472,37473,37477,37479,37480,
37481,37486,37487,37488,37493,37494,37495,37496,37497,37499,37500,37501,37503,
37512,37513,37514,37517,37518,37522,37527,37529,37535,37536,37540,37541,37543,
37544,37547,37551,37554,37558,37560,37562,37563,37564,37565,37567,37568,37569,
37570,37571,37573,37574,37575,37576,37579,37580,37581,37582,37584,37587,37589,
37591,37592,37593,37596,37597,37599,37600,37601,37603,37605,37607,37608,37612,
37614,37616,37625,37627,37631,37632,37634,37640,37645,37649,37652,37653,37660,
37661,37662,37663,37665,37668,37669,37671,37673,37674,37683,37684,37686,37687,
37703,37704,37705,37712,37713,37714,37717,37719,37720,37722,37726,37732,37733,
37735,37737,37738,37741,37743,37744,37745,37747,37748,37750,37754,37757,37759,
37760,37761,37762,37768,37770,37771,37773,37775,37778,37781,37784,37787,37790,
37793,37795,37796,37798,37800,37803,37812,37813,37814,37818,37801,37825,37828,
37829,37830,37831,37833,37834,37835,37836,37837,37843,37849,37852,37854,37855,
37858,37862,37863,37881,37879,37880,37882,37883,37885,37889,37890,37892,37896,
37897,37901,37902,37903,37909,37910,37911,37919,37934,37935,37937,37938,37939,
37940,37947,37951,37949,37955,37957,37960,37962,37964,37973,37977,37980,37983,
37985,37987,37992,37995,37997,37998,37999,38001,38002,38020,38019,38264,38265,
38270,38276,38280,38284,38285,38286,38301,38302,38303,38305,38310,38313,38315,
38316,38324,38326,38330,38333,38335,38342,38344,38345,38347,38352,38353,38354,
38355,38361,38362,38365,38366,38367,38368,38372,38374,38429,38430,38434,38436,
38437,38438,38444,38449,38451,38455,38456,38457,38458,38460,38461,38465,38482,
38484,38486,38487,38488,38497,38510,38516,38523,38524,38526,38527,38529,38530,
38531,38532,38537,38545,38550,38554,38557,38559,38564,38565,38566,38569,38574,
38575,38579,38586,38602,38610,23986,38616,38618,38621,38622,38623,38633,38639,
38641,38650,38658,38659,38661,38665,38682,38683,38685,38689,38690,38691,38696,
38705,38707,38721,38723,38730,38734,38735,38741,38743,38744,38746,38747,38755,
38759,38762,38766,38771,38774,38775,38776,38779,38781,38783,38784,38793,38805,
38806,38807,38809,38810,38814,38815,38818,38828,38830,38833,38834,38837,38838,
38840,38841,38842,38844,38846,38847,38849,38852,38853,38855,38857,38858,38860,
38861,38862,38864,38865,38868,38871,38872,38873,38877,38878,38880,38875,38881,
38884,38895,38897,38900,38903,38904,38906,38919,38922,38937,38925,38926,38932,
38934,38940,38942,38944,38947,38950,38955,38958,38959,38960,38962,38963,38965,
38949,38974,38980,38983,38986,38993,38994,38995,38998,38999,39001,39002,39010,
39011,39013,39014,39018,39020,39083,39085,39086,39088,39092,39095,39096,39098,
39099,39103,39106,39109,39112,39116,39137,39139,39141,39142,39143,39146,39155,
39158,39170,39175,39176,39185,39189,39190,39191,39194,39195,39196,39199,39202,
39206,39207,39211,39217,39218,39219,39220,39221,39225,39226,39227,39228,39232,
39233,39238,39239,39240,39245,39246,39252,39256,39257,39259,39260,39262,39263,
39264,39323,39325,39327,39334,39344,39345,39346,39349,39353,39354,39357,39359,
39363,39369,39379,39380,39385,39386,39388,39390,39399,39402,39403,39404,39408,
39412,39413,39417,39421,39422,39426,39427,39428,39435,39436,39440,39441,39446,
39454,39456,39458,39459,39460,39463,39469,39470,39475,39477,39478,39480,39495,
39489,39492,39498,39499,39500,39502,39505,39508,39510,39517,39594,39596,39598,
39599,39602,39604,39605,39606,39609,39611,39614,39615,39617,39619,39622,39624,
39630,39632,39634,39637,39638,39639,39643,39644,39648,39652,39653,39655,39657,
39660,39666,39667,39669,39673,39674,39677,39679,39680,39681,39682,39683,39684,
39685,39688,39689,39691,39692,39693,39694,39696,39698,39702,39705,39707,39708,
39712,39718,39723,39725,39731,39732,39733,39735,39737,39738,39741,39752,39755,
39756,39765,39766,39767,39771,39774,39777,39779,39781,39782,39784,39786,39787,
39788,39789,39790,39795,39797,39799,39800,39801,39807,39808,39812,39813,39814,
39815,39817,39818,39819,39821,39823,39824,39828,39834,39837,39838,39846,39847,
39849,39852,39856,39857,39858,39863,39864,39867,39868,39870,39871,39873,39879,
39880,39886,39888,39895,39896,39901,39903,39909,39911,39914,39915,39919,39923,
39927,39928,39929,39930,39933,39935,39936,39938,39947,39951,39953,39958,39960,
39961,39962,39964,39966,39970,39971,39974,39975,39976,39977,39978,39985,39989,
39990,39991,39997,40001,40003,40004,40005,40009,40010,40014,40015,40016,40019,
40020,40022,40024,40027,40029,40030,40031,40035,40041,40042,40028,40043,40040,
40046,40048,40050,40053,40055,40059,40166,40178,40183,40185,40203,40194,40209,
40215,40216,40220,40221,40222,40239,40240,40242,40243,40244,40250,40252,40261,
40253,40258,40259,40263,40266,40275,40276,40287,40291,40290,40293,40297,40298,
40299,40304,40310,40311,40315,40316,40318,40323,40324,40326,40330,40333,40334,
40338,40339,40341,40342,40343,40344,40353,40362,40364,40366,40369,40373,40377,
40380,40383,40387,40391,40393,40394,40404,40405,40406,40407,40410,40414,40415,
40416,40421,40423,40425,40427,40430,40432,40435,40436,40446,40458,40450,40455,
40462,40464,40465,40466,40469,40470,40473,40476,40477,40570,40571,40572,40576,
40578,40579,40580,40581,40583,40590,40591,40598,40600,40603,40606,40612,40616,
40620,40622,40623,40624,40627,40628,40629,40646,40648,40651,40661,40671,40676,
40679,40684,40685,40686,40688,40689,40690,40693,40696,40703,40706,40707,40713,
40719,40720,40721,40722,40724,40726,40727,40729,40730,40731,40735,40738,40742,
40746,40747,40751,40753,40754,40756,40759,40761,40762,40764,40765,40767,40769,
40771,40772,40773,40774,40775,40787,40789,40790,40791,40792,40794,40797,40798,
40808,40809,40813,40814,40815,40816,40817,40819,40821,40826,40829,40847,40848,
40849,40850,40852,40854,40855,40862,40865,40866,40867,40869,
]
const EUCKRRuns*: array[1079, uint32] = [
67108864u32,67117058u32,167813124u32,33660937u32,67256330u32,100818956u32,
235044879u32,33734678u32,201531415u32,67330077u32,100892703u32,335781922u32,
33800236u32,201580589u32,100925491u32,100933686u32,637812793u32,67403852u32,
67412046u32,33874000u32,168099921u32,33898582u32,67485783u32,101072985u32,
101081180u32,235307103u32,33996902u32,201793639u32,34046061u32,67608686u32,
235397232u32,34087031u32,101220472u32,67674235u32,101236861u32,101245056u32,
269025411u32,34152587u32,269041804u32,67731604u32,67739798u32,34201752u32,
34209945u32,67772570u32,34242716u32,34250909u32,168485022u32,67838115u32,
101400741u32,34300072u32,168525993u32,34324654u32,34332847u32,202113200u32,
101458102u32,101466297u32,269246652u32,67928260u32,202162374u32,67961036u32,
101523662u32,235749585u32,34439384u32,34447577u32,202227930u32,101572832u32,
101581027u32,269361382u32,34488558u32,269377775u32,68067575u32,68075769u32,
135217403u32,34578687u32,34586880u32,168820993u32,68174086u32,101736712u32,
370180363u32,202424598u32,605085980u32,269549870u32,68239670u32,101802296u32,
236028219u32,34718018u32,269607235u32,101843275u32,101851470u32,638730577u32,
68321636u32,68329830u32,202572136u32,34816366u32,34824559u32,202604912u32,
907256182u32,68411793u32,68419987u32,34881941u32,169107862u32,34906523u32,
34914716u32,102039965u32,34939296u32,34963873u32,102080930u32,34980261u32,
169206182u32,35004843u32,102138284u32,68592047u32,68608433u32,102171059u32,
236396982u32,35086781u32,202883518u32,202899908u32,1578639818u32,35160569u32,
102277626u32,236503549u32,35193348u32,202990085u32,68788747u32,370786829u32,
68805144u32,35258906u32,203039259u32,102384161u32,102392356u32,337281575u32,
135971377u32,68870709u32,907739703u32,68895314u32,35349076u32,35357269u32,
236692054u32,35381853u32,35390046u32,136077919u32,203203171u32,370983529u32,
203227764u32,639451770u32,203252365u32,102597267u32,102605462u32,236831385u32,
102630048u32,203301539u32,907952809u32,69108420u32,102671046u32,203342537u32,
35594959u32,35603152u32,169837265u32,236954326u32,371180253u32,203424488u32,
69223150u32,102785776u32,237011699u32,69255930u32,237036284u32,102826755u32,
102834950u32,237060873u32,337740560u32,908174106u32,69329717u32,35783479u32,
35791672u32,35799865u32,136471354u32,35832638u32,35840831u32,102957888u32,
1008935747u32,69428065u32,102990691u32,237216614u32,35906413u32,35914606u32,
203694959u32,35947381u32,69510006u32,170206072u32,36004733u32,36045694u32,
36053887u32,69632896u32,103195522u32,237421445u32,36111244u32,203907981u32,
69706643u32,103269269u32,237495192u32,136840095u32,1143481251u32,36201413u32,
103326662u32,36225993u32,136905674u32,36258766u32,170501071u32,69862356u32,
103424982u32,237650905u32,36340704u32,204137441u32,69936103u32,103498729u32,
237724652u32,69968883u32,69985269u32,103547895u32,103556090u32,774652925u32,
70026260u32,103588886u32,36488217u32,170714138u32,36512799u32,36520992u32,
137192481u32,103662629u32,103670824u32,372114475u32,1177429046u32,103695449u32,
103703644u32,237929567u32,36619366u32,271508583u32,70198383u32,103761009u32,
271541364u32,36668540u32,36676733u32,204457086u32,70255748u32,70263942u32,
238052488u32,36742287u32,36750480u32,204530833u32,640746647u32,238101674u32,
909198513u32,103900364u32,103908559u32,238134482u32,338814169u32,204612835u32,
238175465u32,103974128u32,204645619u32,70444281u32,104006907u32,171140350u32,
36939011u32,36947204u32,104072453u32,36971784u32,104088841u32,104097036u32,
640976143u32,70567202u32,104129828u32,37029159u32,171255080u32,37053741u32,
37061934u32,137733423u32,37078323u32,37102900u32,70665525u32,104260919u32,
37176634u32,104326459u32,70796606u32,104359232u32,238585155u32,37274954u32,
205071691u32,1849247057u32,37332360u32,70894985u32,37356939u32,138036620u32,
37389712u32,37397905u32,37406098u32,70968723u32,37422485u32,70993302u32,
104555928u32,238781851u32,37471650u32,205268387u32,104613289u32,104621484u32,
373065135u32,205309370u32,104654272u32,775751107u32,71124442u32,71132636u32,
37594590u32,37602783u32,104719840u32,37627363u32,37635556u32,37643749u32,
37651942u32,71214567u32,104777193u32,104785388u32,641664495u32,641672706u32,
239027733u32,104818204u32,104826399u32,239052322u32,37742121u32,272631338u32,
910173746u32,71329357u32,104891983u32,239117906u32,37807705u32,37815898u32,
205596251u32,641812065u32,239167092u32,675382907u32,205629071u32,104973973u32,
104982168u32,272762523u32,37889699u32,37897892u32,205678245u32,105023147u32,
105031342u32,239257265u32,138602168u32,205719228u32,71517890u32,71526084u32,
37988038u32,172213959u32,38012620u32,38020813u32,205801166u32,910452436u32,
71608047u32,71616241u32,239404787u32,38094586u32,172345083u32,71698176u32,
105260802u32,239486725u32,38176524u32,172418829u32,71780114u32,105342740u32,
239568663u32,38258462u32,2085103391u32,71853917u32,105416543u32,38315874u32,
138995555u32,38348647u32,172590952u32,71952237u32,105514863u32,239740786u32,
38430585u32,206227322u32,642443136u32,1179322259u32,72042422u32,105605048u32,
407603131u32,206284743u32,239847373u32,642508756u32,910952423u32,105654274u32,
1716275205u32,72124472u32,105687098u32,206358589u32,139266115u32,1145907271u32,
911034473u32,105736324u32,105744519u32,239970442u32,105769105u32,1145964692u32,
72239286u32,72247480u32,240036026u32,38725825u32,273615042u32,105851082u32,
105859277u32,240085200u32,340764887u32,105892065u32,105900260u32,240126183u32,
38815982u32,38824175u32,206604528u32,72403190u32,105965816u32,240191739u32,
38881538u32,106023171u32,72501510u32,106064136u32,240290059u32,38979858u32,
206776595u32,72575257u32,475236635u32,39037225u32,1146341674u32,72616268u32,
106178894u32,240404817u32,39094616u32,173336921u32,72698206u32,106260832u32,
240486755u32,39176554u32,39184747u32,206965100u32,72763762u32,106326388u32,
240552311u32,39242110u32,207038847u32,106383749u32,408381832u32,39291284u32,
274180501u32,72870301u32,106432927u32,240658850u32,39348649u32,39356842u32,
207137195u32,106482097u32,542697908u32,878250436u32,240724446u32,106514917u32,
106523112u32,240749035u32,39438834u32,39447027u32,207227380u32,106572282u32,
106580477u32,274360832u32,39488008u32,39496201u32,207276554u32,73075216u32,
106637842u32,240863765u32,39553564u32,39561757u32,207342110u32,643557924u32,
240912951u32,912009790u32,73165401u32,106728027u32,240953950u32,73189989u32,
39643751u32,207424104u32,73222766u32,106785392u32,241011315u32,39701114u32,
39709307u32,207489660u32,73288322u32,106850948u32,241076871u32,39766670u32,
39774863u32,73345680u32,979331730u32,73378479u32,106941105u32,241167028u32,
39856827u32,39865020u32,207645373u32,73444035u32,39897797u32,174156486u32,
39955147u32,39963340u32,73534157u32,39987919u32,73566928u32,107129554u32,
241355477u32,40045276u32,174295773u32,207866594u32,409201384u32,1147407092u32,
73681686u32,107244312u32,40143643u32,174369564u32,40168225u32,40176418u32,
140856099u32,73771815u32,107334441u32,241560364u32,40250163u32,208046900u32,
73845562u32,107408188u32,342297407u32,40332105u32,141003594u32,912763726u32,
40364905u32,107490154u32,40389485u32,174615406u32,40414067u32,40422260u32,
208202613u32,107547515u32,510208894u32,1147759501u32,107580335u32,107588530u32,
275368885u32,40496061u32,40504254u32,208284607u32,107629509u32,107637704u32,
275418059u32,40545235u32,275434452u32,40578012u32,74140637u32,174836703u32,
40635364u32,40643557u32,107760614u32,40659945u32,107785194u32,107793389u32,
275573744u32,40700920u32,275590137u32,913132545u32,107834396u32,107842591u32,
644721698u32,107858997u32,107867192u32,242093115u32,74329154u32,275663940u32,
107899980u32,107908175u32,242134098u32,74370137u32,1215229019u32,74394751u32,
74402945u32,40864899u32,175090820u32,40889481u32,40914058u32,40922251u32,
74484876u32,74525838u32,141675664u32,41028756u32,41036949u32,108154006u32,
74607769u32,74624155u32,108186781u32,242412704u32,41102503u32,108235944u32,
74689707u32,74706093u32,410258607u32,1282682043u32,74738913u32,74747107u32,
41209061u32,175434982u32,41233643u32,41241836u32,175475949u32,74829042u32,
74837236u32,242625782u32,41315581u32,209112318u32,74910980u32,108473606u32,
276253961u32,41381137u32,108514578u32,74968341u32,108530967u32,779627802u32,
41454897u32,108571954u32,242797877u32,41487676u32,41495869u32,209276222u32,
108621124u32,511282503u32,242855254u32,645516637u32,242871664u32,75115895u32,
108678521u32,242904444u32,343584131u32,108711309u32,779808144u32,75181479u32,
75189673u32,175885739u32,41684400u32,41692593u32,108809650u32,41717173u32,
243051958u32,377277885u32,243068360u32,914165199u32,75320810u32,108883436u32,
410881519u32,209563131u32,108908033u32,108916228u32,243142151u32,75378190u32,
41831952u32,209612305u32,75410967u32,108973593u32,243199516u32,41889315u32,
1216302628u32,75468360u32,109030986u32,41930317u32,176156238u32,41954899u32,
41963092u32,142650965u32,75558489u32,109121115u32,42020446u32,176246367u32,
42045028u32,176287333u32,75648618u32,109211244u32,243437167u32,42126966u32,
209923703u32,478375549u32,1317244555u32,75746994u32,75755188u32,243543734u32,
75779773u32,210022079u32,679792325u32,210038489u32,478490335u32,42299117u32,
1149619950u32,75894544u32,109457170u32,243683093u32,109481756u32,2089201439u32,
914804573u32,679931768u32,210177932u32,75976594u32,109539220u32,243765143u32,
76001182u32,42454944u32,3028807585u32,680005627u32,210251791u32,109596693u32,
109604888u32,243830811u32,1284034594u32,76091464u32,109654090u32,243880013u32,
42569812u32,42578005u32,210358358u32,42602588u32,76173405u32,176869471u32,
42668132u32,109801573u32,76255336u32,76271722u32,109834348u32,244060271u32,
42750070u32,210546807u32,76345469u32,109908095u32,244134018u32,42823817u32,
42832010u32,210612363u32,109957265u32,109965460u32,244191383u32,143536286u32,
210653346u32,76476584u32,42938538u32,143618219u32,42971311u32,143659184u32,
43004084u32,76574901u32,110137527u32,244363450u32,43053249u32,210849986u32,
76648648u32,110211274u32,244437197u32,43126996u32,210923733u32,110268635u32,
110276830u32,412274913u32,210956525u32,43208947u32,110326004u32,43225335u32,
177451256u32,43249917u32,43258110u32,110375167u32,76828930u32,76845316u32,
110407942u32,412406025u32,211087637u32,110432539u32,110440734u32,244666657u32,
76902696u32,244691242u32,110481713u32,110489908u32,244715831u32,43405630u32,
278294847u32,76984647u32,110547273u32,244773196u32,43462995u32,43471188u32,
211251541u32,77050203u32,77058397u32,244846943u32,43536742u32,43544935u32,
43553128u32,43561321u32,43577706u32,647565675u32,244920702u32,77164933u32,
110727559u32,244953482u32,144298385u32,211415445u32,77214107u32,110776733u32,
245002656u32,43692455u32,43700648u32,211481001u32,211497391u32,245060021u32,
77296060u32,43749822u32,211530175u32,77328837u32,110891463u32,211571146u32,
43815376u32,43823569u32,1151128018u32,77402612u32,77410806u32,211644920u32,
43897342u32,43905535u32,144577024u32,43921924u32,43938309u32,111063558u32,
245289481u32,77533712u32,178213394u32,77574679u32,111137305u32,245363228u32,
77607459u32,916484645u32,1151373888u32,77648482u32,111211108u32,44110439u32,
178336360u32,77689453u32,211923567u32,111268469u32,111276664u32,1721897595u32,
782381742u32,77755077u32,77763271u32,44225225u32,178451146u32,111358671u32,
212030162u32,77828824u32,514044634u32,245617385u32,648278768u32,245633795u32,
111424266u32,111432461u32,245658384u32,346338071u32,916771617u32,77927228u32,
111489854u32,245715777u32,111514440u32,212185931u32,648401745u32,245756772u32,
916853611u32,111555462u32,1487295369u32,212235189u32,78033851u32,111596477u32,
44495808u32,145167297u32,346518469u32,111645647u32,111653842u32,245879765u32,
380105692u32,78132199u32,111694825u32,245920748u32,44610547u32,44618740u32,
212399093u32,78197755u32,44667901u32,145355774u32,44717058u32,111850499u32,
44758022u32,78328839u32,111891465u32,246117388u32,44807187u32,212603924u32,
78402586u32,111965212u32,78418975u32,145536033u32,44889125u32,44897318u32,
112014375u32,44913706u32,112038955u32,112047150u32,279827505u32,346944569u32,
78525507u32,44987461u32,179237958u32,45077579u32,45085772u32,45093965u32,
78664782u32,112227408u32,246453331u32,45143130u32,45151323u32,212931676u32,
45184098u32,112301155u32,45200486u32,145880167u32,112374891u32,112407662u32,
112415857u32,246641780u32,45331579u32,246674556u32,78918787u32,112481413u32,
45397128u32,78959753u32,45429899u32,45438092u32,45446285u32,146117774u32,
79025298u32,112587924u32,246813847u32,45503646u32,213300383u32,79099045u32,
381097127u32,79115442u32,45569204u32,213349557u32,79148219u32,112710845u32,
246936768u32,45626567u32,45634760u32,213415113u32,79213775u32,112776401u32,
247002324u32,45692123u32,45700316u32,213480669u32,79279331u32,112841957u32,
179975400u32,45774061u32,45782254u32,213562607u32,79361269u32,112923895u32,
247149818u32,79394049u32,213628163u32,79426825u32,112989451u32,247215374u32,
113014037u32,213685528u32,79484190u32,113046816u32,247272739u32,45962538u32,
45970731u32,213751084u32,79549746u32,113112372u32,247338295u32,46028094u32,
46036287u32,46044480u32,146715969u32,79623493u32,113186119u32,180303178u32,
46093647u32,46110032u32,46118225u32,113292626u32,113300821u32,247526744u32,
79762783u32,281097569u32,79787369u32,113349995u32,146929006u32,46290290u32,
113431923u32,46331254u32,79902071u32,46355833u32,46380410u32,180606331u32,
46404992u32,180655489u32,80008582u32,113571208u32,247797131u32,46486930u32,
214283667u32,80082329u32,46536091u32,46544284u32,247879069u32,147223972u32,
214341032u32,113685934u32,113694129u32,650573236u32,80164295u32,113726921u32,
46626252u32,180852173u32,46650834u32,46659027u32,180893140u32,80246233u32,
113808859u32,248034782u32,46724581u32,46732774u32,214513127u32,113858029u32,
113866224u32,248092147u32,80336378u32,214570492u32,919221762u32,80377373u32,
113939999u32,46839330u32,181065251u32,46863912u32,46872105u32,114005546u32,
214693421u32,281810483u32,46937659u32,46945852u32,114062909u32,
]
const EUCKRRunsOffset* = 44034u16
const EUCKRRuns2*: array[535, uint32] = [
100663296u32,637542403u32,201351190u32,100696092u32,100704287u32,234930210u32,
33620009u32,33628202u32,201408555u32,67207217u32,536977459u32,201441347u32,
67240009u32,100802635u32,167936078u32,33734739u32,33742932u32,201523285u32,
637739099u32,235094126u32,906190965u32,67346576u32,100909202u32,235135125u32,
33824924u32,268714141u32,100950181u32,100958376u32,235184299u32,369410226u32,
67436733u32,100999359u32,235225282u32,33915081u32,33923274u32,1141227723u32,
67502317u32,67510511u32,33972465u32,168198386u32,33997047u32,34005240u32,
67576057u32,34038011u32,67608828u32,34062590u32,34070783u32,67633408u32,
134750466u32,34103558u32,201900295u32,67698957u32,101261583u32,235487506u32,
34177305u32,201974042u32,101318944u32,537534755u32,1141522739u32,67797333u32,
101359959u32,235585882u32,34275681u32,202072418u32,671842664u32,202088828u32,
638304642u32,1175183765u32,67903928u32,101466554u32,235692477u32,34382276u32,
34390469u32,34398662u32,135070151u32,202195403u32,369975761u32,235766236u32,
638427619u32,235782646u32,101573117u32,101581312u32,235807235u32,1041129994u32,
202277417u32,68076079u32,101638705u32,235864628u32,101663291u32,202334782u32,
638550596u32,1141883479u32,907010681u32,907018900u32,504373935u32,68174526u32,
34628288u32,1141932737u32,68207331u32,101769957u32,235995880u32,101794543u32,
135365362u32,68281078u32,34734840u32,34743033u32,236077818u32,34767617u32,
169018114u32,68371207u32,101933833u32,236159756u32,34849555u32,202646292u32,
101991194u32,34890525u32,34898718u32,236233503u32,135578406u32,1142219562u32,
68494156u32,102056782u32,236282705u32,34972504u32,202769241u32,68567903u32,
102130529u32,236356452u32,35046251u32,35054444u32,202834797u32,102179699u32,
504841078u32,236413829u32,102204300u32,538420111u32,202883999u32,68682661u32,
102245287u32,236471210u32,35161009u32,35169202u32,202949555u32,102294457u32,
102302652u32,404300735u32,1142506443u32,102327277u32,102335472u32,236561395u32,
35251194u32,35259387u32,203039740u32,505037826u32,370828305u32,68854812u32,
102417438u32,236643361u32,35333160u32,35341353u32,203121706u32,639337520u32,
236692547u32,102483018u32,773579853u32,102499428u32,102507623u32,236733546u32,
35423345u32,35431538u32,203211891u32,102556793u32,102564988u32,236790911u32,
136135814u32,203252874u32,69051536u32,102614162u32,236840085u32,35529884u32,
35538077u32,1142842526u32,69117120u32,69125314u32,203367620u32,35611850u32,
35620043u32,203400396u32,69199058u32,102761684u32,236987607u32,35677406u32,
35685599u32,203465952u32,69264614u32,102827240u32,237053163u32,35742962u32,
203539699u32,639763705u32,1143088396u32,69362990u32,69371184u32,237159730u32,
35849529u32,203646266u32,69444928u32,103007554u32,237233477u32,35923276u32,
35931469u32,203711822u32,103056724u32,103064919u32,237290842u32,35980641u32,
203777378u32,908428648u32,69584259u32,103146885u32,237372808u32,36062607u32,
36070800u32,203851153u32,69649815u32,103212441u32,237438364u32,136783267u32,
203900327u32,673670573u32,203916737u32,237479367u32,640140750u32,908584417u32,
69740028u32,103302654u32,237528577u32,36218376u32,36226569u32,204006922u32,
103351824u32,103360019u32,405358102u32,204039714u32,673809960u32,204056124u32,
69854786u32,103417412u32,237643335u32,36333134u32,36341327u32,204121680u32,
103466582u32,103474777u32,237700700u32,371926627u32,69953134u32,103515760u32,
237741683u32,103540346u32,1143735933u32,70010527u32,103573153u32,237799076u32,
36488875u32,36497068u32,204277421u32,70076083u32,103638709u32,204318392u32,
36562622u32,204359359u32,70158021u32,103720647u32,237946570u32,36636369u32,
204433106u32,674203352u32,1143973612u32,70248206u32,103810832u32,36710163u32,
170936084u32,36734745u32,204531482u32,70330144u32,103892770u32,238118693u32,
36808492u32,36816685u32,204597038u32,103941940u32,506603319u32,238176070u32,
103966541u32,775063376u32,70436711u32,103999337u32,238225260u32,36915059u32,
36923252u32,137594741u32,36939641u32,104056698u32,775153533u32,909379476u32,
104081327u32,473188274u32,36988864u32,204769217u32,909420487u32,70576098u32,
104138724u32,238364647u32,37054446u32,37062639u32,204842992u32,641058806u32,
238413833u32,909510672u32,70666283u32,104228909u32,238454832u32,104253495u32,
204924986u32,104269888u32,104278083u32,238504006u32,137848909u32,204965969u32,
70764631u32,70772825u32,37234779u32,171460700u32,37259361u32,272148578u32,
104384618u32,104392813u32,238618736u32,339298423u32,70879361u32,104441987u32,
238667910u32,37357709u32,37365902u32,205146255u32,37398677u32,104515734u32,
37415065u32,171640986u32,37439647u32,104573088u32,71026851u32,71043237u32,
104605863u32,238831786u32,37521585u32,205318322u32,1815947448u32,71133422u32,
104696048u32,238921971u32,37611770u32,205408507u32,71207169u32,104769795u32,
238995718u32,37685517u32,37693710u32,205474063u32,104818965u32,104827160u32,
239053083u32,71297314u32,205531428u32,239094058u32,272656689u32,37783865u32,
272673082u32,71362882u32,104925508u32,239151431u32,37841230u32,37849423u32,
205629776u32,675400022u32,1145170282u32,104991116u32,776087951u32,105007526u32,
105015721u32,272796076u32,37923252u32,272812469u32,71502269u32,71510463u32,
37972417u32,172198338u32,37996999u32,38005192u32,205785545u32,675555791u32,
1145326051u32,105146885u32,105155080u32,239381003u32,71617042u32,272951828u32,
105187868u32,105196063u32,239421986u32,71658025u32,38111787u32,205892140u32,
105237042u32,105245237u32,239471160u32,38160959u32,1212574272u32,71740004u32,
105302630u32,239528553u32,38218352u32,38226545u32,206006898u32,71805560u32,
105368186u32,138930813u32,71830145u32,38292099u32,38300292u32,206080645u32,
71879307u32,105441933u32,239667856u32,38357655u32,206154392u32,675924638u32,
1145694898u32,71969492u32,105532118u32,38431449u32,172657370u32,38456031u32,
38464224u32,206244577u32,72043239u32,105605865u32,239831788u32,38521587u32,
38529780u32,206310133u32,72108795u32,105671421u32,239897344u32,38587143u32,
206383880u32,105728782u32,105736977u32,273517332u32,340634396u32,72215334u32,
105777960u32,139340587u32,72239919u32,38701873u32,38710066u32,105827123u32,
72280886u32,72297272u32,105859898u32,340749117u32,38767431u32,206547784u32,
72346446u32,475007824u32,38808414u32,206588767u32,72387429u32,105950055u32,
273730410u32,38857586u32,38865779u32,206646132u32,105991034u32,105999229u32,
273779584u32,38906760u32,273795977u32,72485777u32,106048403u32,139611030u32,
72510362u32,72518556u32,38972318u32,206752671u32,106097573u32,106105768u32,
240331691u32,139676594u32,206793654u32,72592316u32,106154942u32,408153025u32,
206834637u32,72633299u32,106195925u32,240421848u32,39111647u32,39119840u32,
206900193u32,72698855u32,106261481u32,240487404u32,72723443u32,39177205u32,
206957558u32,72756220u32,39209982u32,207014911u32,39259141u32,39267334u32,
106384391u32,72838154u32,106400780u32,106408975u32,240634898u32,106433561u32,
207105052u32,72903714u32,106466340u32,240692263u32,39382062u32,39390255u32,
207170608u32,
]
const EUCKRRunsOffset2* = 51365u16
const EUCKRDecode*: array[8742, uint16] = [
uint16 12288,12289,12290,183,8229,8230,168,12291,173,8213,8741,65340,8764,8216,8217,
8220,8221,12308,12309,12296,12297,12298,12299,12300,12301,12302,12303,12304,
12305,177,215,247,8800,8804,8805,8734,8756,176,8242,8243,8451,8491,65504,65505,
65509,9794,9792,8736,8869,8978,8706,8711,8801,8786,167,8251,9734,9733,9675,9679,
9678,9671,9670,9633,9632,9651,9650,9661,9660,8594,8592,8593,8595,8596,12307,
8810,8811,8730,8765,8733,8757,8747,8748,8712,8715,8838,8839,8834,8835,8746,8745,
8743,8744,65506,8658,8660,8704,8707,180,65374,711,728,733,730,729,184,731,161,
191,720,8750,8721,8719,164,8457,8240,9665,9664,9655,9654,9828,9824,9825,9829,
9831,9827,8857,9672,9635,9680,9681,9618,9636,9637,9640,9639,9638,9641,9832,9743,
9742,9756,9758,182,8224,8225,8597,8599,8601,8598,8600,9837,9833,9834,9836,12927,
12828,8470,13255,8482,13250,13272,8481,8364,174,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,65281,65282,65283,65284,65285,65286,65287,65288,65289,65290,65291,
65292,65293,65294,65295,65296,65297,65298,65299,65300,65301,65302,65303,65304,
65305,65306,65307,65308,65309,65310,65311,65312,65313,65314,65315,65316,65317,
65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,
65331,65332,65333,65334,65335,65336,65337,65338,65339,65510,65341,65342,65343,
65344,65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,
65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,
65370,65371,65372,65373,65507,12593,12594,12595,12596,12597,12598,12599,12600,
12601,12602,12603,12604,12605,12606,12607,12608,12609,12610,12611,12612,12613,
12614,12615,12616,12617,12618,12619,12620,12621,12622,12623,12624,12625,12626,
12627,12628,12629,12630,12631,12632,12633,12634,12635,12636,12637,12638,12639,
12640,12641,12642,12643,12644,12645,12646,12647,12648,12649,12650,12651,12652,
12653,12654,12655,12656,12657,12658,12659,12660,12661,12662,12663,12664,12665,
12666,12667,12668,12669,12670,12671,12672,12673,12674,12675,12676,12677,12678,
12679,12680,12681,12682,12683,12684,12685,12686,8560,8561,8562,8563,8564,8565,
8566,8567,8568,8569,0,0,0,0,0,8544,8545,8546,8547,8548,8549,8550,8551,8552,8553,
0,0,0,0,0,0,0,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,
929,931,932,933,934,935,936,937,0,0,0,0,0,0,0,0,945,946,947,948,949,950,951,952,
953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,0,0,0,0,0,0,
9472,9474,9484,9488,9496,9492,9500,9516,9508,9524,9532,9473,9475,9487,9491,9499,
9495,9507,9523,9515,9531,9547,9504,9519,9512,9527,9535,9501,9520,9509,9528,9538,
9490,9489,9498,9497,9494,9493,9486,9485,9502,9503,9505,9506,9510,9511,9513,9514,
9517,9518,9521,9522,9525,9526,9529,9530,9533,9534,9536,9537,9539,9540,9541,9542,
9543,9544,9545,9546,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13205,
13206,13207,8467,13208,13252,13219,13220,13221,13222,13209,13210,13211,13212,
13213,13214,13215,13216,13217,13218,13258,13197,13198,13199,13263,13192,13193,
13256,13223,13224,13232,13233,13234,13235,13236,13237,13238,13239,13240,13241,
13184,13185,13186,13187,13188,13242,13243,13244,13245,13246,13247,13200,13201,
13202,13203,13204,8486,13248,13249,13194,13195,13196,13270,13253,13229,13230,
13231,13275,13225,13226,13227,13228,13277,13264,13267,13251,13257,13276,13254,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,208,170,294,0,306,0,319,321,216,338,186,222,358,
330,0,12896,12897,12898,12899,12900,12901,12902,12903,12904,12905,12906,12907,
12908,12909,12910,12911,12912,12913,12914,12915,12916,12917,12918,12919,12920,
12921,12922,12923,9424,9425,9426,9427,9428,9429,9430,9431,9432,9433,9434,9435,
9436,9437,9438,9439,9440,9441,9442,9443,9444,9445,9446,9447,9448,9449,9312,9313,
9314,9315,9316,9317,9318,9319,9320,9321,9322,9323,9324,9325,9326,189,8531,8532,
188,190,8539,8540,8541,8542,230,273,240,295,305,307,312,320,322,248,339,223,254,
359,331,329,12800,12801,12802,12803,12804,12805,12806,12807,12808,12809,12810,
12811,12812,12813,12814,12815,12816,12817,12818,12819,12820,12821,12822,12823,
12824,12825,12826,12827,9372,9373,9374,9375,9376,9377,9378,9379,9380,9381,9382,
9383,9384,9385,9386,9387,9388,9389,9390,9391,9392,9393,9394,9395,9396,9397,9332,
9333,9334,9335,9336,9337,9338,9339,9340,9341,9342,9343,9344,9345,9346,185,178,
179,8308,8319,8321,8322,8323,8324,12353,12354,12355,12356,12357,12358,12359,
12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,12371,12372,
12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,12384,12385,
12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,12397,12398,
12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,12410,12411,
12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,12423,12424,
12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,0,0,0,0,0,0,0,
0,0,0,0,12449,12450,12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,
12461,12462,12463,12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,
12474,12475,12476,12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,
12487,12488,12489,12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,
12500,12501,12502,12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,
12513,12514,12515,12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,
12526,12527,12528,12529,12530,12531,12532,12533,12534,0,0,0,0,0,0,0,0,1040,1041,
1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,
1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,
1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,
1097,1098,1099,1100,1101,1102,1103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44032,44033,
44036,44039,44040,44041,44042,44048,44049,44050,44051,44052,44053,44054,44055,
44057,44058,44059,44060,44061,44064,44068,44076,44077,44079,44080,44081,44088,
44089,44092,44096,44107,44109,44116,44120,44124,44144,44145,44148,44151,44152,
44154,44160,44161,44163,44164,44165,44166,44169,44170,44171,44172,44176,44180,
44188,44189,44191,44192,44193,44200,44201,44202,44204,44207,44208,44216,44217,
44219,44220,44221,44225,44228,44232,44236,44245,44247,44256,44257,44260,44263,
44264,44266,44268,44271,44272,44273,44275,44277,44278,44284,44285,44288,44292,
44294,44300,44301,44303,44305,44312,44316,44320,44329,44332,44333,44340,44341,
44344,44348,44356,44357,44359,44361,44368,44372,44376,44385,44387,44396,44397,
44400,44403,44404,44405,44406,44411,44412,44413,44415,44417,44418,44424,44425,
44428,44432,44444,44445,44452,44471,44480,44481,44484,44488,44496,44497,44499,
44508,44512,44516,44536,44537,44540,44543,44544,44545,44552,44553,44555,44557,
44564,44592,44593,44596,44599,44600,44602,44608,44609,44611,44613,44614,44618,
44620,44621,44622,44624,44628,44630,44636,44637,44639,44640,44641,44645,44648,
44649,44652,44656,44664,44665,44667,44668,44669,44676,44677,44684,44732,44733,
44734,44736,44740,44748,44749,44751,44752,44753,44760,44761,44764,44776,44779,
44781,44788,44792,44796,44807,44808,44813,44816,44844,44845,44848,44850,44852,
44860,44861,44863,44865,44866,44867,44872,44873,44880,44892,44893,44900,44901,
44921,44928,44932,44936,44944,44945,44949,44956,44984,44985,44988,44992,44999,
45000,45001,45003,45005,45006,45012,45020,45032,45033,45040,45041,45044,45048,
45056,45057,45060,45068,45072,45076,45084,45085,45096,45124,45125,45128,45130,
45132,45134,45139,45140,45141,45143,45145,45149,45180,45181,45184,45188,45196,
45197,45199,45201,45208,45209,45210,45212,45215,45216,45217,45218,45224,45225,
45227,45228,45229,45230,45231,45233,45235,45236,45237,45240,45244,45252,45253,
45255,45256,45257,45264,45265,45268,45272,45280,45285,45320,45321,45323,45324,
45328,45330,45331,45336,45337,45339,45340,45341,45347,45348,45349,45352,45356,
45364,45365,45367,45368,45369,45376,45377,45380,45384,45392,45393,45396,45397,
45400,45404,45408,45432,45433,45436,45440,45442,45448,45449,45451,45453,45458,
45459,45460,45464,45468,45480,45516,45520,45524,45532,45533,45535,45544,45545,
45548,45552,45561,45563,45565,45572,45573,45576,45579,45580,45588,45589,45591,
45593,45600,45620,45628,45656,45660,45664,45672,45673,45684,45685,45692,45700,
45701,45705,45712,45713,45716,45720,45721,45722,45728,45729,45731,45733,45734,
45738,45740,45744,45748,45768,45769,45772,45776,45778,45784,45785,45787,45789,
45794,45796,45797,45798,45800,45803,45804,45805,45806,45807,45811,45812,45813,
45815,45816,45817,45818,45819,45823,45824,45825,45828,45832,45840,45841,45843,
45844,45845,45852,45908,45909,45910,45912,45915,45916,45918,45919,45924,45925,
45927,45929,45931,45934,45936,45937,45940,45944,45952,45953,45955,45956,45957,
45964,45968,45972,45984,45985,45992,45996,46020,46021,46024,46027,46028,46030,
46032,46036,46037,46039,46041,46043,46045,46048,46052,46056,46076,46096,46104,
46108,46112,46120,46121,46123,46132,46160,46161,46164,46168,46176,46177,46179,
46181,46188,46208,46216,46237,46244,46248,46252,46261,46263,46265,46272,46276,
46280,46288,46293,46300,46301,46304,46307,46308,46310,46316,46317,46319,46321,
46328,46356,46357,46360,46363,46364,46372,46373,46375,46376,46377,46378,46384,
46385,46388,46392,46400,46401,46403,46404,46405,46411,46412,46413,46416,46420,
46428,46429,46431,46432,46433,46496,46497,46500,46504,46506,46507,46512,46513,
46515,46516,46517,46523,46524,46525,46528,46532,46540,46541,46543,46544,46545,
46552,46572,46608,46609,46612,46616,46629,46636,46644,46664,46692,46696,46748,
46749,46752,46756,46763,46764,46769,46804,46832,46836,46840,46848,46849,46853,
46888,46889,46892,46895,46896,46904,46905,46907,46916,46920,46924,46932,46933,
46944,46948,46952,46960,46961,46963,46965,46972,46973,46976,46980,46988,46989,
46991,46992,46993,46994,46998,46999,47000,47001,47004,47008,47016,47017,47019,
47020,47021,47028,47029,47032,47047,47049,47084,47085,47088,47092,47100,47101,
47103,47104,47105,47111,47112,47113,47116,47120,47128,47129,47131,47133,47140,
47141,47144,47148,47156,47157,47159,47160,47161,47168,47172,47185,47187,47196,
47197,47200,47204,47212,47213,47215,47217,47224,47228,47245,47272,47280,47284,
47288,47296,47297,47299,47301,47308,47312,47316,47325,47327,47329,47336,47337,
47340,47344,47352,47353,47355,47357,47364,47384,47392,47420,47421,47424,47428,
47436,47439,47441,47448,47449,47452,47456,47464,47465,47467,47469,47476,47477,
47480,47484,47492,47493,47495,47497,47498,47501,47502,47532,47533,47536,47540,
47548,47549,47551,47553,47560,47561,47564,47566,47567,47568,47569,47570,47576,
47577,47579,47581,47582,47585,47587,47588,47589,47592,47596,47604,47605,47607,
47608,47609,47610,47616,47617,47624,47637,47672,47673,47676,47680,47682,47688,
47689,47691,47693,47694,47699,47700,47701,47704,47708,47716,47717,47719,47720,
47721,47728,47729,47732,47736,47747,47748,47749,47751,47756,47784,47785,47787,
47788,47792,47794,47800,47801,47803,47805,47812,47816,47832,47833,47868,47872,
47876,47885,47887,47889,47896,47900,47904,47913,47915,47924,47925,47926,47928,
47931,47932,47933,47934,47940,47941,47943,47945,47949,47951,47952,47956,47960,
47969,47971,47980,48008,48012,48016,48036,48040,48044,48052,48055,48064,48068,
48072,48080,48083,48120,48121,48124,48127,48128,48130,48136,48137,48139,48140,
48141,48143,48145,48148,48149,48150,48151,48152,48155,48156,48157,48158,48159,
48164,48165,48167,48169,48173,48176,48177,48180,48184,48192,48193,48195,48196,
48197,48201,48204,48205,48208,48221,48260,48261,48264,48267,48268,48270,48276,
48277,48279,48281,48282,48288,48289,48292,48295,48296,48304,48305,48307,48308,
48309,48316,48317,48320,48324,48333,48335,48336,48337,48341,48344,48348,48372,
48373,48374,48376,48380,48388,48389,48391,48393,48400,48404,48420,48428,48448,
48456,48457,48460,48464,48472,48473,48484,48488,48512,48513,48516,48519,48520,
48521,48522,48528,48529,48531,48533,48537,48538,48540,48548,48560,48568,48596,
48597,48600,48604,48617,48624,48628,48632,48640,48643,48645,48652,48653,48656,
48660,48668,48669,48671,48708,48709,48712,48716,48718,48724,48725,48727,48729,
48730,48731,48736,48737,48740,48744,48746,48752,48753,48755,48756,48757,48763,
48764,48765,48768,48772,48780,48781,48783,48784,48785,48792,48793,48808,48848,
48849,48852,48855,48856,48864,48867,48868,48869,48876,48897,48904,48905,48920,
48921,48923,48924,48925,48960,48961,48964,48968,48976,48977,48981,49044,49072,
49093,49100,49101,49104,49108,49116,49119,49121,49212,49233,49240,49244,49248,
49256,49257,49296,49297,49300,49304,49312,49313,49315,49317,49324,49325,49327,
49328,49331,49332,49333,49334,49340,49341,49343,49344,49345,49349,49352,49353,
49356,49360,49368,49369,49371,49372,49373,49380,49381,49384,49388,49396,49397,
49399,49401,49408,49412,49416,49424,49429,49436,49437,49438,49439,49440,49443,
49444,49446,49447,49452,49453,49455,49456,49457,49462,49464,49465,49468,49472,
49480,49481,49483,49484,49485,49492,49493,49496,49500,49508,49509,49511,49512,
49513,49520,49524,49528,49541,49548,49549,49550,49552,49556,49558,49564,49565,
49567,49569,49573,49576,49577,49580,49584,49597,49604,49608,49612,49620,49623,
49624,49632,49636,49640,49648,49649,49651,49660,49661,49664,49668,49676,49677,
49679,49681,49688,49689,49692,49695,49696,49704,49705,49707,49709,49711,49713,
49714,49716,49736,49744,49745,49748,49752,49760,49765,49772,49773,49776,49780,
49788,49789,49791,49793,49800,49801,49808,49816,49819,49821,49828,49829,49832,
49836,49837,49844,49845,49847,49849,49884,49885,49888,49891,49892,49899,49900,
49901,49903,49905,49910,49912,49913,49915,49916,49920,49928,49929,49932,49933,
49939,49940,49941,49944,49948,49956,49957,49960,49961,49989,50024,50025,50028,
50032,50034,50040,50041,50044,50045,50052,50056,50060,50112,50136,50137,50140,
50143,50144,50146,50152,50153,50157,50164,50165,50168,50184,50192,50212,50220,
50224,50228,50236,50237,50248,50276,50277,50280,50284,50292,50293,50297,50304,
50324,50332,50360,50364,50409,50416,50417,50420,50424,50426,50431,50432,50433,
50444,50448,50452,50460,50472,50473,50476,50480,50488,50489,50491,50493,50500,
50501,50504,50505,50506,50508,50509,50510,50515,50516,50517,50519,50520,50521,
50525,50526,50528,50529,50532,50536,50544,50545,50547,50548,50549,50556,50557,
50560,50564,50567,50572,50573,50575,50577,50581,50583,50584,50588,50592,50601,
50612,50613,50616,50617,50619,50620,50621,50622,50628,50629,50630,50631,50632,
50633,50634,50636,50638,50640,50641,50644,50648,50656,50657,50659,50661,50668,
50669,50670,50672,50676,50678,50679,50684,50685,50686,50687,50688,50689,50693,
50694,50695,50696,50700,50704,50712,50713,50715,50716,50724,50725,50728,50732,
50733,50734,50736,50739,50740,50741,50743,50745,50747,50752,50753,50756,50760,
50768,50769,50771,50772,50773,50780,50781,50784,50796,50799,50801,50808,50809,
50812,50816,50824,50825,50827,50829,50836,50837,50840,50844,50852,50853,50855,
50857,50864,50865,50868,50872,50873,50874,50880,50881,50883,50885,50892,50893,
50896,50900,50908,50909,50912,50913,50920,50921,50924,50928,50936,50937,50941,
50948,50949,50952,50956,50964,50965,50967,50969,50976,50977,50980,50984,50992,
50993,50995,50997,50999,51004,51005,51008,51012,51018,51020,51021,51023,51025,
51026,51027,51028,51029,51030,51031,51032,51036,51040,51048,51051,51060,51061,
51064,51068,51069,51070,51075,51076,51077,51079,51080,51081,51082,51086,51088,
51089,51092,51094,51095,51096,51098,51104,51105,51107,51108,51109,51110,51116,
51117,51120,51124,51132,51133,51135,51136,51137,51144,51145,51148,51150,51152,
51160,51165,51172,51176,51180,51200,51201,51204,51208,51210,51216,51217,51219,
51221,51222,51228,51229,51232,51236,51244,51245,51247,51249,51256,51260,51264,
51272,51273,51276,51277,51284,51312,51313,51316,51320,51322,51328,51329,51331,
51333,51334,51335,51339,51340,51341,51348,51357,51359,51361,51368,51388,51389,
51396,51400,51404,51412,51413,51415,51417,51424,51425,51428,51445,51452,51453,
51456,51460,51461,51462,51468,51469,51471,51473,51480,51500,51508,51536,51537,
51540,51544,51552,51553,51555,51564,51568,51572,51580,51592,51593,51596,51600,
51608,51609,51611,51613,51648,51649,51652,51655,51656,51658,51664,51665,51667,
51669,51670,51673,51674,51676,51677,51680,51682,51684,51687,51692,51693,51695,
51696,51697,51704,51705,51708,51712,51720,51721,51723,51724,51725,51732,51736,
51753,51788,51789,51792,51796,51804,51805,51807,51808,51809,51816,51837,51844,
51864,51900,51901,51904,51908,51916,51917,51919,51921,51923,51928,51929,51936,
51948,51956,51976,51984,51988,51992,52000,52001,52033,52040,52041,52044,52048,
52056,52057,52061,52068,52088,52089,52124,52152,52180,52196,52199,52201,52236,
52237,52240,52244,52252,52253,52257,52258,52263,52264,52265,52268,52270,52272,
52280,52281,52283,52284,52285,52286,52292,52293,52296,52300,52308,52309,52311,
52312,52313,52320,52324,52326,52328,52336,52341,52376,52377,52380,52384,52392,
52393,52395,52396,52397,52404,52405,52408,52412,52420,52421,52423,52425,52432,
52436,52452,52460,52464,52481,52488,52489,52492,52496,52504,52505,52507,52509,
52516,52520,52524,52537,52572,52576,52580,52588,52589,52591,52593,52600,52616,
52628,52629,52632,52636,52644,52645,52647,52649,52656,52676,52684,52688,52712,
52716,52720,52728,52729,52731,52733,52740,52744,52748,52756,52761,52768,52769,
52772,52776,52784,52785,52787,52789,52824,52825,52828,52831,52832,52833,52840,
52841,52843,52845,52852,52853,52856,52860,52868,52869,52871,52873,52880,52881,
52884,52888,52896,52897,52899,52900,52901,52908,52909,52929,52964,52965,52968,
52971,52972,52980,52981,52983,52984,52985,52992,52993,52996,53000,53008,53009,
53011,53013,53020,53024,53028,53036,53037,53039,53040,53041,53048,53076,53077,
53080,53084,53092,53093,53095,53097,53104,53105,53108,53112,53120,53125,53132,
53153,53160,53168,53188,53216,53217,53220,53224,53232,53233,53235,53237,53244,
53248,53252,53265,53272,53293,53300,53301,53304,53308,53316,53317,53319,53321,
53328,53332,53336,53344,53356,53357,53360,53364,53372,53373,53377,53412,53413,
53416,53420,53428,53429,53431,53433,53440,53441,53444,53448,53449,53456,53457,
53459,53460,53461,53468,53469,53472,53476,53484,53485,53487,53488,53489,53496,
53517,53552,53553,53556,53560,53562,53568,53569,53571,53572,53573,53580,53581,
53584,53588,53596,53597,53599,53601,53608,53612,53628,53636,53640,53664,53665,
53668,53672,53680,53681,53683,53685,53690,53692,53696,53720,53748,53752,53767,
53769,53776,53804,53805,53808,53812,53820,53821,53823,53825,53832,53852,53860,
53888,53889,53892,53896,53904,53905,53909,53916,53920,53924,53932,53937,53944,
53945,53948,53951,53952,53954,53960,53961,53963,53972,53976,53980,53988,53989,
54000,54001,54004,54008,54016,54017,54019,54021,54028,54029,54030,54032,54036,
54038,54044,54045,54047,54048,54049,54053,54056,54057,54060,54064,54072,54073,
54075,54076,54077,54084,54085,54140,54141,54144,54148,54156,54157,54159,54160,
54161,54168,54169,54172,54176,54184,54185,54187,54189,54196,54200,54204,54212,
54213,54216,54217,54224,54232,54241,54243,54252,54253,54256,54260,54268,54269,
54271,54273,54280,54301,54336,54340,54364,54368,54372,54381,54383,54392,54393,
54396,54399,54400,54402,54408,54409,54411,54413,54420,54441,54476,54480,54484,
54492,54495,54504,54508,54512,54520,54523,54525,54532,54536,54540,54548,54549,
54551,54588,54589,54592,54596,54604,54605,54607,54609,54616,54617,54620,54624,
54629,54632,54633,54635,54637,54644,54645,54648,54652,54660,54661,54663,54664,
54665,54672,54693,54728,54729,54732,54736,54738,54744,54745,54747,54749,54756,
54757,54760,54764,54772,54773,54775,54777,54784,54785,54788,54792,54800,54801,
54803,54804,54805,54812,54816,54820,54829,54840,54841,54844,54848,54853,54856,
54857,54859,54861,54865,54868,54869,54872,54876,54887,54889,54896,54897,54900,
54915,54917,54924,54925,54928,54932,54941,54943,54945,54952,54956,54960,54969,
54971,54980,54981,54984,54988,54993,54996,54999,55001,55008,55012,55016,55024,
55029,55036,55037,55040,55044,55057,55064,55065,55068,55072,55080,55081,55083,
55085,55092,55093,55096,55100,55108,55111,55113,55120,55121,55124,55126,55127,
55128,55129,55136,55137,55139,55141,55145,55148,55152,55156,55164,55165,55169,
55176,55177,55180,55184,55192,55193,55195,55197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
20285,20339,20551,20729,21152,21487,21621,21733,22025,23233,23478,26247,26550,
26551,26607,27468,29634,30146,31292,33499,33540,34903,34952,35382,36040,36303,
36603,36838,39381,21051,21364,21508,24682,24932,27580,29647,33050,35258,35282,
38307,20355,21002,22718,22904,23014,24178,24185,25031,25536,26438,26604,26751,
28567,30286,30475,30965,31240,31487,31777,32925,33390,33393,35563,38291,20075,
21917,26359,28212,30883,31469,33883,35088,34638,38824,21208,22350,22570,23884,
24863,25022,25121,25954,26577,27204,28187,29976,30131,30435,30640,32058,37039,
37969,37970,40853,21283,23724,30002,32987,37440,38296,21083,22536,23004,23713,
23831,24247,24378,24394,24951,27743,30074,30086,31968,32115,32177,32652,33108,
33313,34193,35137,35611,37628,38477,40007,20171,20215,20491,20977,22607,24887,
24894,24936,25913,27114,28433,30117,30342,30422,31623,33445,33995,63744,37799,
38283,21888,23458,22353,63745,31923,32697,37301,20520,21435,23621,24040,25298,
25454,25818,25831,28192,28844,31067,36317,36382,63746,36989,37445,37624,20094,
20214,20581,24062,24314,24838,26967,33137,34388,36423,37749,39467,20062,20625,
26480,26688,20745,21133,21138,27298,30652,37392,40660,21163,24623,36850,20552,
25001,25581,25802,26684,27268,28608,33160,35233,38548,22533,29309,29356,29956,
32121,32365,32937,35211,35700,36963,40273,25225,27770,28500,32080,32570,35363,
20860,24906,31645,35609,37463,37772,20140,20435,20510,20670,20742,21185,21197,
21375,22384,22659,24218,24465,24950,25004,25806,25964,26223,26299,26356,26775,
28039,28805,28913,29855,29861,29898,30169,30828,30956,31455,31478,32069,32147,
32789,32831,33051,33686,35686,36629,36885,37857,38915,38968,39514,39912,20418,
21843,22586,22865,23395,23622,24760,25106,26690,26800,26856,28330,30028,30328,
30926,31293,31995,32363,32380,35336,35489,35903,38542,40388,21476,21481,21578,
21617,22266,22993,23396,23611,24235,25335,25911,25925,25970,26272,26543,27073,
27837,30204,30352,30590,31295,32660,32771,32929,33167,33510,33533,33776,34241,
34865,34996,35493,63747,36764,37678,38599,39015,39640,40723,21741,26011,26354,
26767,31296,35895,40288,22256,22372,23825,26118,26801,26829,28414,29736,34974,
39908,27752,63748,39592,20379,20844,20849,21151,23380,24037,24656,24685,25329,
25511,25915,29657,31354,34467,36002,38799,20018,23521,25096,26524,29916,31185,
33747,35463,35506,36328,36942,37707,38982,24275,27112,34303,37101,63749,20896,
23448,23532,24931,26874,27454,28748,29743,29912,31649,32592,33733,35264,36011,
38364,39208,21038,24669,25324,36866,20362,20809,21281,22745,24291,26336,27960,
28826,29378,29654,31568,33009,37979,21350,25499,32619,20054,20608,22602,22750,
24618,24871,25296,27088,39745,23439,32024,32945,36703,20132,20689,21676,21932,
23308,23968,24039,25898,25934,26657,27211,29409,30350,30703,32094,32761,33184,
34126,34527,36611,36686,37066,39171,39509,39851,19992,20037,20061,20167,20465,
20855,21246,21312,21475,21477,21646,22036,22389,22434,23495,23943,24272,25084,
25304,25937,26552,26601,27083,27472,27590,27628,27714,28317,28792,29399,29590,
29699,30655,30697,31350,32127,32777,33276,33285,33290,33503,34914,35635,36092,
36544,36881,37041,37476,37558,39378,39493,40169,40407,40860,22283,23616,33738,
38816,38827,40628,21531,31384,32676,35033,36557,37089,22528,23624,25496,31391,
23470,24339,31353,31406,33422,36524,20518,21048,21240,21367,22280,25331,25458,
27402,28099,30519,21413,29527,34152,36470,38357,26426,27331,28528,35437,36556,
39243,63750,26231,27512,36020,39740,63751,21483,22317,22862,25542,27131,29674,
30789,31418,31429,31998,33909,35215,36211,36917,38312,21243,22343,30023,31584,
33740,37406,63752,27224,20811,21067,21127,25119,26840,26997,38553,20677,21156,
21220,25027,26020,26681,27135,29822,31563,33465,33771,35250,35641,36817,39241,
63753,20170,22935,25810,26129,27278,29748,31105,31165,33449,34942,34943,35167,
63754,37670,20235,21450,24613,25201,27762,32026,32102,20120,20834,30684,32943,
20225,20238,20854,20864,21980,22120,22331,22522,22524,22804,22855,22931,23492,
23696,23822,24049,24190,24524,25216,26071,26083,26398,26399,26462,26827,26820,
27231,27450,27683,27773,27778,28103,29592,29734,29738,29826,29859,30072,30079,
30849,30959,31041,31047,31048,31098,31637,32000,32186,32648,32774,32813,32908,
35352,35663,35912,36215,37665,37668,39138,39249,39438,39439,39525,40594,32202,
20342,21513,25326,26708,37329,21931,20794,63755,63756,23068,25062,63757,25295,
25343,63758,63759,63760,63761,63762,63763,37027,63764,63765,63766,63767,63768,
35582,63769,63770,63771,63772,26262,63773,29014,63774,63775,38627,63776,25423,
25466,21335,63777,26511,26976,28275,63778,30007,63779,63780,63781,32013,63782,
63783,34930,22218,23064,63784,63785,63786,63787,63788,20035,63789,20839,22856,
26608,32784,63790,22899,24180,25754,31178,24565,24684,25288,25467,23527,23511,
21162,63791,22900,24361,24594,63792,63793,63794,29785,63795,63796,63797,63798,
63799,63800,39377,63801,63802,63803,63804,63805,63806,63807,63808,63809,63810,
63811,28611,63812,63813,33215,36786,24817,63814,63815,33126,63816,63817,23615,
63818,63819,63820,63821,63822,63823,63824,63825,23273,35365,26491,32016,63826,
63827,63828,63829,63830,63831,33021,63832,63833,23612,27877,21311,28346,22810,
33590,20025,20150,20294,21934,22296,22727,24406,26039,26086,27264,27573,28237,
30701,31471,31774,32222,34507,34962,37170,37723,25787,28606,29562,30136,36948,
21846,22349,25018,25812,26311,28129,28251,28525,28601,30192,32835,33213,34113,
35203,35527,35674,37663,27795,30035,31572,36367,36957,21776,22530,22616,24162,
25095,25758,26848,30070,31958,34739,40680,20195,22408,22382,22823,23565,23729,
24118,24453,25140,25825,29619,33274,34955,36024,38538,40667,23429,24503,24755,
20498,20992,21040,22294,22581,22615,23566,23648,23798,23947,24230,24466,24764,
25361,25481,25623,26691,26873,27330,28120,28193,28372,28644,29182,30428,30585,
31153,31291,33796,35241,36077,36339,36424,36867,36884,36947,37117,37709,38518,
38876,27602,28678,29272,29346,29544,30563,31167,31716,32411,35712,22697,24775,
25958,26109,26302,27788,28958,29129,35930,38931,20077,31361,20189,20908,20941,
21205,21516,24999,26481,26704,26847,27934,28540,30140,30643,31461,33012,33891,
37509,20828,26007,26460,26515,30168,31431,33651,63834,35910,36887,38957,23663,
33216,33434,36929,36975,37389,24471,23965,27225,29128,30331,31561,34276,35588,
37159,39472,21895,25078,63835,30313,32645,34367,34746,35064,37007,63836,27931,
28889,29662,32097,33853,63837,37226,39409,63838,20098,21365,27396,27410,28734,
29211,34349,40478,21068,36771,23888,25829,25900,27414,28651,31811,32412,34253,
35172,35261,25289,33240,34847,24266,26391,28010,29436,29701,29807,34690,37086,
20358,23821,24480,33802,20919,25504,30053,20142,20486,20841,20937,26753,27153,
31918,31921,31975,33391,35538,36635,37327,20406,20791,21237,21570,24300,24942,
25150,26053,27354,28670,31018,34268,34851,38317,39522,39530,40599,40654,21147,
26310,27511,28701,31019,36706,38722,24976,25088,25891,28451,29001,29833,32244,
32879,34030,36646,36899,37706,20925,21015,21155,27916,28872,35010,24265,25986,
27566,28610,31806,29557,20196,20278,22265,63839,23738,23994,24604,29618,31533,
32666,32718,32838,36894,37428,38646,38728,38936,40801,20363,28583,31150,37300,
38583,21214,63840,25736,25796,27347,28510,28696,29200,30439,32769,34310,34396,
36335,36613,38706,39791,40442,40565,30860,31103,32160,33737,37636,40575,40595,
35542,22751,24324,26407,28711,29903,31840,32894,20769,28712,29282,30922,36034,
36058,36084,38647,20102,20698,23534,24278,26009,29134,30274,30637,32842,34044,
36988,39719,40845,22744,23105,23650,27155,28122,28431,30267,32047,32311,34078,
35128,37860,38475,21129,26066,26611,27060,27969,28316,28687,29705,29792,30041,
30244,30827,35628,39006,20845,25134,38520,20374,20523,23833,28138,32184,36650,
24459,24900,26647,63841,38534,21202,32907,20956,20940,26974,31260,32190,33777,
38517,20442,21033,21400,21519,21774,23653,24743,26446,26792,28012,29313,29432,
29702,29827,63842,30178,31852,32633,32696,33673,35023,35041,37324,37328,38626,
39881,21533,28542,29136,29848,34298,36522,38563,40023,40607,26519,28107,29747,
33256,38678,30764,31435,31520,31890,25705,29802,30194,30908,30952,39340,39764,
40635,23518,24149,28448,33180,33707,37000,19975,21325,23081,24018,24398,24930,
25405,26217,26364,28415,28459,28771,30622,33836,34067,34875,36627,39237,39995,
21788,25273,26411,27819,33545,35178,38778,20129,22916,24536,24537,26395,32178,
32596,33426,33579,33725,36638,37017,22475,22969,23186,23504,26151,26522,26757,
27599,29028,32629,36023,36067,36993,39749,33032,35978,38476,39488,40613,23391,
27667,29467,30450,30431,33804,20906,35219,20813,20885,21193,26825,27796,30468,
30496,32191,32236,38754,40629,28357,34065,20901,21517,21629,26126,26269,26919,
28319,30399,30609,33559,33986,34719,37225,37528,40180,34946,20398,20882,21215,
22982,24125,24917,25720,25721,26286,26576,27169,27597,27611,29279,29281,29761,
30520,30683,32791,33468,33541,35584,35624,35980,26408,27792,29287,30446,30566,
31302,40361,27519,27794,22818,26406,33945,21359,22675,22937,24287,25551,26164,
26483,28218,29483,31447,33495,37672,21209,24043,25006,25035,25098,25287,25771,
26080,26969,27494,27595,28961,29687,30045,32326,33310,33538,34154,35491,36031,
38695,40289,22696,40664,20497,21006,21563,21839,25991,27766,32010,32011,32862,
34442,38272,38639,21247,27797,29289,21619,23194,23614,23883,24396,24494,26410,
26806,26979,28220,28228,30473,31859,32654,34183,35598,36855,38753,40692,23735,
24758,24845,25003,25935,26107,26108,27665,27887,29599,29641,32225,38292,23494,
34588,35600,21085,21338,25293,25615,25778,26420,27192,27850,29632,29854,31636,
31893,32283,33162,33334,34180,36843,38649,39361,20276,21322,21453,21467,25292,
25644,25856,26001,27075,27886,28504,29677,30036,30242,30436,30460,30928,30971,
31020,32070,33324,34784,36820,38930,39151,21187,25300,25765,28196,28497,30332,
36299,37297,37474,39662,39747,20515,20621,22346,22952,23592,24135,24439,25151,
25918,26041,26049,26121,26507,27036,28354,30917,32033,32938,33152,33323,33459,
33953,34444,35370,35607,37030,38450,40848,20493,20467,63843,22521,24472,25308,
25490,26479,28227,28953,30403,32972,32986,35060,35061,35097,36064,36649,37197,
38506,20271,20336,24091,26575,26658,30333,30334,39748,24161,27146,29033,29140,
30058,63844,32321,34115,34281,39132,20240,31567,32624,38309,20961,24070,26805,
27710,27726,27867,29359,31684,33539,27861,29754,20731,21128,22721,25816,27287,
29863,30294,30887,34327,38370,38713,63845,21342,24321,35722,36776,36783,37002,
21029,30629,40009,40712,19993,20482,20853,23643,24183,26142,26170,26564,26821,
28851,29953,30149,31177,31453,36647,39200,39432,20445,22561,22577,23542,26222,
27493,27921,28282,28541,29668,29995,33769,35036,35091,35676,36628,20239,20693,
21264,21340,23443,24489,26381,31119,33145,33583,34068,35079,35206,36665,36667,
39333,39954,26412,20086,20472,22857,23553,23791,23792,25447,26834,28925,29090,
29739,32299,34028,34562,36898,37586,40179,19981,20184,20463,20613,21078,21103,
21542,21648,22496,22827,23142,23386,23413,23500,24220,63846,25206,25975,26023,
28014,28325,29238,31526,31807,32566,33104,33105,33178,33344,33433,33705,35331,
36000,36070,36091,36212,36282,37096,37340,38428,38468,39385,40167,21271,20998,
21545,22132,22707,22868,22894,24575,24996,25198,26128,27774,28954,30406,31881,
31966,32027,33452,36033,38640,63847,20315,24343,24447,25282,23849,26379,26842,
30844,32323,40300,19989,20633,21269,21290,21329,22915,23138,24199,24754,24970,
25161,25209,26000,26503,27047,27604,27606,27607,27608,27832,63848,29749,30202,
30738,30865,31189,31192,31875,32203,32737,32933,33086,33218,33778,34586,35048,
35513,35692,36027,37145,38750,39131,40763,22188,23338,24428,25996,27315,27567,
27996,28657,28693,29277,29613,36007,36051,38971,24977,27703,32856,39425,20045,
20107,20123,20181,20282,20284,20351,20447,20735,21490,21496,21766,21987,22235,
22763,22882,23057,23531,23546,23556,24051,24107,24473,24605,25448,26012,26031,
26614,26619,26797,27515,27801,27863,28195,28681,29509,30722,31038,31040,31072,
31169,31721,32023,32114,32902,33293,33678,34001,34503,35039,35408,35422,35613,
36060,36198,36781,37034,39164,39391,40605,21066,63849,26388,63850,20632,21034,
23665,25955,27733,29642,29987,30109,31639,33948,37240,38704,20087,25746,27578,
29022,34217,19977,63851,26441,26862,28183,33439,34072,34923,25591,28545,37394,
39087,19978,20663,20687,20767,21830,21930,22039,23360,23577,23776,24120,24202,
24224,24258,24819,26705,27233,28248,29245,29248,29376,30456,31077,31665,32724,
35059,35316,35443,35937,36062,38684,22622,29885,36093,21959,63852,31329,32034,
33394,29298,29983,29989,63853,31513,22661,22779,23996,24207,24246,24464,24661,
25234,25471,25933,26257,26329,26360,26646,26866,29312,29790,31598,32110,32214,
32626,32997,33298,34223,35199,35475,36893,37604,40653,40736,22805,22893,24109,
24796,26132,26227,26512,27728,28101,28511,30707,30889,33990,37323,37675,20185,
20682,20808,21892,23307,23459,25159,25982,26059,28210,29053,29697,29764,29831,
29887,30316,31146,32218,32341,32680,33146,33203,33337,34330,34796,35445,36323,
36984,37521,37925,39245,39854,21352,23633,26964,27844,27945,28203,33292,34203,
35131,35373,35498,38634,40807,21089,26297,27570,32406,34814,36109,38275,38493,
25885,28041,29166,63854,22478,22995,23468,24615,24826,25104,26143,26207,29481,
29689,30427,30465,31596,32854,32882,33125,35488,37266,19990,21218,27506,27927,
31237,31545,32048,63855,36016,21484,22063,22609,23477,23567,23569,24034,25152,
25475,25620,26157,26803,27836,28040,28335,28703,28836,29138,29990,30095,30094,
30233,31505,31712,31787,32032,32057,34092,34157,34311,35380,36877,36961,37045,
37559,38902,39479,20439,23660,26463,28049,31903,32396,35606,36118,36895,23403,
24061,25613,33984,36956,39137,29575,23435,24730,26494,28126,35359,35494,36865,
38924,21047,63856,28753,30862,37782,34928,37335,20462,21463,22013,22234,22402,
22781,23234,23432,23723,23744,24101,24833,25101,25163,25480,25628,25910,25976,
27193,27530,27700,27929,28465,29159,29417,29560,29703,29874,30246,30561,31168,
31319,31466,31929,32143,32172,32353,32670,33065,33585,33936,34010,34282,34966,
35504,35728,36664,36930,36995,37228,37526,37561,38539,38567,38568,38614,38656,
38920,39318,39635,39706,21460,22654,22809,23408,23487,28113,28506,29087,29729,
29881,32901,33789,24033,24455,24490,24642,26092,26642,26991,27219,27529,27957,
28147,29667,30462,30636,31565,32020,33059,33308,33600,34036,34147,35426,35524,
37255,37662,38918,39348,25100,34899,36848,37477,23815,23847,23913,29791,33181,
34664,28629,25342,32722,35126,35186,19998,20056,20711,21213,21319,25215,26119,
32361,34821,38494,20365,21273,22070,22987,23204,23608,23630,23629,24066,24337,
24643,26045,26159,26178,26558,26612,29468,30690,31034,32709,33940,33997,35222,
35430,35433,35553,35925,35962,22516,23508,24335,24687,25325,26893,27542,28252,
29060,31698,34645,35672,36606,39135,39166,20280,20353,20449,21627,23072,23480,
24892,26032,26216,29180,30003,31070,32051,33102,33251,33688,34218,34254,34563,
35338,36523,36763,63857,36805,22833,23460,23526,24713,23529,23563,24515,27777,
63858,28145,28683,29978,33455,35574,20160,21313,63859,38617,27663,20126,20420,
20818,21854,23077,23784,25105,29273,33469,33706,34558,34905,35357,38463,38597,
39187,40201,40285,22538,23731,23997,24132,24801,24853,25569,27138,28197,37122,
37716,38990,39952,40823,23433,23736,25353,26191,26696,30524,38593,38797,38996,
39839,26017,35585,36555,38332,21813,23721,24022,24245,26263,30284,33780,38343,
22739,25276,29390,40232,20208,22830,24591,26171,27523,31207,40230,21395,21696,
22467,23830,24859,26326,28079,30861,33406,38552,38724,21380,25212,25494,28082,
32266,33099,38989,27387,32588,40367,40474,20063,20539,20918,22812,24825,25590,
26928,29242,32822,63860,37326,24369,63861,63862,32004,33509,33903,33979,34277,
36493,63863,20335,63864,63865,22756,23363,24665,25562,25880,25965,26264,63866,
26954,27171,27915,28673,29036,30162,30221,31155,31344,63867,32650,63868,35140,
63869,35731,37312,38525,63870,39178,22276,24481,26044,28417,30208,31142,35486,
39341,39770,40812,20740,25014,25233,27277,33222,20547,22576,24422,28937,35328,
35578,23420,34326,20474,20796,22196,22852,25513,28153,23978,26989,20870,20104,
20313,63871,63872,63873,22914,63874,63875,27487,27741,63876,29877,30998,63877,
33287,33349,33593,36671,36701,63878,39192,63879,63880,63881,20134,63882,22495,
24441,26131,63883,63884,30123,32377,35695,63885,36870,39515,22181,22567,23032,
23071,23476,63886,24310,63887,63888,25424,25403,63889,26941,27783,27839,28046,
28051,28149,28436,63890,28895,28982,29017,63891,29123,29141,63892,30799,30831,
63893,31605,32227,63894,32303,63895,34893,36575,63896,63897,63898,37467,63899,
40182,63900,63901,63902,24709,28037,63903,29105,63904,63905,38321,21421,63906,
63907,63908,26579,63909,28814,28976,29744,33398,33490,63910,38331,39653,40573,
26308,63911,29121,33865,63912,63913,22603,63914,63915,23992,24433,63916,26144,
26254,27001,27054,27704,27891,28214,28481,28634,28699,28719,29008,29151,29552,
63917,29787,63918,29908,30408,31310,32403,63919,63920,33521,35424,36814,63921,
37704,63922,38681,63923,63924,20034,20522,63925,21000,21473,26355,27757,28618,
29450,30591,31330,33454,34269,34306,63926,35028,35427,35709,35947,63927,37555,
63928,38675,38928,20116,20237,20425,20658,21320,21566,21555,21978,22626,22714,
22887,23067,23524,24735,63929,25034,25942,26111,26212,26791,27738,28595,28879,
29100,29522,31613,34568,35492,39986,40711,23627,27779,29508,29577,37434,28331,
29797,30239,31337,32277,34314,20800,22725,25793,29934,29973,30320,32705,37013,
38605,39252,28198,29926,31401,31402,33253,34521,34680,35355,23113,23436,23451,
26785,26880,28003,29609,29715,29740,30871,32233,32747,33048,33109,33694,35916,
38446,38929,26352,24448,26106,26505,27754,29579,20525,23043,27498,30702,22806,
23916,24013,29477,30031,63930,63931,20709,20985,22575,22829,22934,23002,23525,
63932,63933,23970,25303,25622,25747,25854,63934,26332,63935,27208,63936,29183,
29796,63937,31368,31407,32327,32350,32768,33136,63938,34799,35201,35616,36953,
63939,36992,39250,24958,27442,28020,32287,35109,36785,20433,20653,20887,21191,
22471,22665,23481,24248,24898,27029,28044,28263,28342,29076,29794,29992,29996,
32883,33592,33993,36362,37780,37854,63940,20110,20305,20598,20778,21448,21451,
21491,23431,23507,23588,24858,24962,26100,29275,29591,29760,30402,31056,31121,
31161,32006,32701,33419,34261,34398,36802,36935,37109,37354,38533,38632,38633,
21206,24423,26093,26161,26671,29020,31286,37057,38922,20113,63941,27218,27550,
28560,29065,32792,33464,34131,36939,38549,38642,38907,34074,39729,20112,29066,
38596,20803,21407,21729,22291,22290,22435,23195,23236,23491,24616,24895,25588,
27781,27961,28274,28304,29232,29503,29783,33489,34945,36677,36960,63942,38498,
39000,40219,26376,36234,37470,20301,20553,20702,21361,22285,22996,23041,23561,
24944,26256,28205,29234,29771,32239,32963,33806,33894,34111,34655,34907,35096,
35586,36949,38859,39759,20083,20369,20754,20842,63943,21807,21929,23418,23461,
24188,24189,24254,24736,24799,24840,24841,25540,25912,26377,63944,26580,26586,
63945,26977,26978,27833,27943,63946,28216,63947,28641,29494,29495,63948,29788,
30001,63949,30290,63950,63951,32173,33278,33848,35029,35480,35547,35565,36400,
36418,36938,36926,36986,37193,37321,37742,63952,63953,22537,63954,27603,32905,
32946,63955,63956,20801,22891,23609,63957,63958,28516,29607,32996,36103,63959,
37399,38287,63960,63961,63962,63963,32895,25102,28700,32104,34701,63964,22432,
24681,24903,27575,35518,37504,38577,20057,21535,28139,34093,38512,38899,39150,
25558,27875,37009,20957,25033,33210,40441,20381,20506,20736,23452,24847,25087,
25836,26885,27589,30097,30691,32681,33380,34191,34811,34915,35516,35696,37291,
20108,20197,20234,63965,63966,22839,23016,63967,24050,24347,24411,24609,63968,
63969,63970,63971,29246,29669,63972,30064,30157,63973,31227,63974,32780,32819,
32900,33505,33617,63975,63976,36029,36019,36999,63977,63978,39156,39180,63979,
63980,28727,30410,32714,32716,32764,35610,20154,20161,20995,21360,63981,21693,
22240,23035,23493,24341,24525,28270,63982,63983,32106,33589,63984,34451,35469,
63985,38765,38775,63986,63987,19968,20314,20350,22777,26085,28322,36920,37808,
39353,20219,22764,22922,23001,24641,63988,63989,31252,63990,33615,36035,20837,
21316,63991,63992,63993,20173,21097,23381,33471,20180,21050,21672,22985,23039,
23376,23383,23388,24675,24904,28363,28825,29038,29574,29943,30133,30913,32043,
32773,33258,33576,34071,34249,35566,36039,38604,20316,21242,22204,26027,26152,
28796,28856,29237,32189,33421,37196,38592,40306,23409,26855,27544,28538,30430,
23697,26283,28507,31668,31786,34870,38620,19976,20183,21280,22580,22715,22767,
22892,23559,24115,24196,24373,25484,26290,26454,27167,27299,27404,28479,29254,
63994,29520,29835,31456,31911,33144,33247,33255,33674,33900,34083,34196,34255,
35037,36115,37292,38263,38556,20877,21705,22312,23472,25165,26448,26685,26771,
28221,28371,28797,32289,35009,36001,36617,40779,40782,29229,31631,35533,37658,
20295,20302,20786,21632,22992,24213,25269,26485,26990,27159,27822,28186,29401,
29482,30141,31672,32053,33511,33785,33879,34295,35419,36015,36487,36889,37048,
38606,40799,21219,21514,23265,23490,25688,25973,28404,29380,63995,30340,31309,
31515,31821,32318,32735,33659,35627,36042,36196,36321,36447,36842,36857,36969,
37841,20291,20346,20659,20840,20856,21069,21098,22625,22652,22880,23560,23637,
24283,24731,25136,26643,27583,27656,28593,29006,29728,30000,30008,30033,30322,
31564,31627,31661,31686,32399,35438,36670,36681,37439,37523,37666,37931,38651,
39002,39019,39198,20999,25130,25240,27993,30308,31434,31680,32118,21344,23742,
24215,28472,28857,31896,38673,39822,40670,25509,25722,34678,19969,20117,20141,
20572,20597,21576,22979,23450,24128,24237,24311,24449,24773,25402,25919,25972,
26060,26230,26232,26622,26984,27273,27491,27712,28096,28136,28191,28254,28702,
28833,29582,29693,30010,30555,30855,31118,31243,31357,31934,32142,33351,35330,
35562,35998,37165,37194,37336,37478,37580,37664,38662,38742,38748,38914,40718,
21046,21137,21884,22564,24093,24351,24716,25552,26799,28639,31085,31532,33229,
34234,35069,35576,36420,37261,38500,38555,38717,38988,40778,20430,20806,20939,
21161,22066,24340,24427,25514,25805,26089,26177,26362,26361,26397,26781,26839,
27133,28437,28526,29031,29157,29226,29866,30522,31062,31066,31199,31264,31381,
31895,31967,32068,32368,32903,34299,34468,35412,35519,36249,36481,36896,36973,
37347,38459,38613,40165,26063,31751,36275,37827,23384,23562,21330,25305,29469,
20519,23447,24478,24752,24939,26837,28121,29742,31278,32066,32156,32305,33131,
36394,36405,37758,37912,20304,22352,24038,24231,25387,32618,20027,20303,20367,
20570,23005,32964,21610,21608,22014,22863,23449,24030,24282,26205,26417,26609,
26666,27880,27954,28234,28557,28855,29664,30087,31820,32002,32044,32162,33311,
34523,35387,35461,36208,36490,36659,36913,37198,37202,37956,39376,31481,31909,
20426,20737,20934,22472,23535,23803,26201,27197,27994,28310,28652,28940,30063,
31459,34850,36897,36981,38603,39423,33537,20013,20210,34886,37325,21373,27355,
26987,27713,33914,22686,24974,26366,25327,28893,29969,30151,32338,33976,35657,
36104,20043,21482,21675,22320,22336,24535,25345,25351,25711,25903,26088,26234,
26525,26547,27490,27744,27802,28460,30693,30757,31049,31063,32025,32930,33026,
33267,33437,33463,34584,35468,63996,36100,36286,36978,30452,31257,31287,32340,
32887,21767,21972,22645,25391,25634,26185,26187,26733,27035,27524,27941,28337,
29645,29800,29857,30043,30137,30433,30494,30603,31206,32265,32285,33275,34095,
34967,35386,36049,36587,36784,36914,37805,38499,38515,38663,20356,21489,23018,
23241,24089,26702,29894,30142,31209,31378,33187,34541,36074,36300,36845,26015,
26389,63997,22519,28503,32221,36655,37878,38598,24501,25074,28548,19988,20376,
20511,21449,21983,23919,24046,27425,27492,30923,31642,63998,36425,36554,36974,
25417,25662,30528,31364,37679,38015,40810,25776,28591,29158,29864,29914,31428,
31762,32386,31922,32408,35738,36106,38013,39184,39244,21049,23519,25830,26413,
32046,20717,21443,22649,24920,24921,25082,26028,31449,35730,35734,20489,20513,
21109,21809,23100,24288,24432,24884,25950,26124,26166,26274,27085,28356,28466,
29462,30241,31379,33081,33369,33750,33980,20661,22512,23488,23528,24425,25505,
30758,32181,33756,34081,37319,37365,20874,26613,31574,36012,20932,22971,24765,
34389,20508,63999,21076,23610,24957,25114,25299,25842,26021,28364,30240,33034,
36448,38495,38587,20191,21315,21912,22825,24029,25797,27849,28154,29588,31359,
33307,34214,36068,36368,36983,37351,38369,38433,38854,20984,21746,21894,24505,
25764,28552,32180,36639,36685,37941,20681,23574,27838,28155,29979,30651,31805,
31844,35449,35522,22558,22974,24086,25463,29266,30090,30571,35548,36028,36626,
24307,26228,28152,32893,33729,35531,38737,39894,64000,21059,26367,28053,28399,
32224,35558,36910,36958,39636,21021,21119,21736,24980,25220,25307,26786,26898,
26970,27189,28818,28966,30813,30977,30990,31186,31245,32918,33400,33493,33609,
34121,35970,36229,37218,37259,37294,20419,22225,29165,30679,34560,35320,23544,
24534,26449,37032,21474,22618,23541,24740,24961,25696,32317,32880,34085,37507,
25774,20652,23828,26368,22684,25277,25512,26894,27000,27166,28267,30394,31179,
33467,33833,35535,36264,36861,37138,37195,37276,37648,37656,37786,38619,39478,
39949,19985,30044,31069,31482,31569,31689,32302,33988,36441,36468,36600,36880,
26149,26943,29763,20986,26414,40668,20805,24544,27798,34802,34909,34935,24756,
33205,33795,36101,21462,21561,22068,23094,23601,28810,32736,32858,33030,33261,
36259,37257,39519,40434,20596,20164,21408,24827,28204,23652,20360,20516,21988,
23769,24159,24677,26772,27835,28100,29118,30164,30196,30305,31258,31305,32199,
32251,32622,33268,34473,36636,38601,39347,40786,21063,21189,39149,35242,19971,
26578,28422,20405,23522,26517,27784,28024,29723,30759,37341,37756,34756,31204,
31281,24555,20182,21668,21822,22702,22949,24816,25171,25302,26422,26965,33333,
38464,39345,39389,20524,21331,21828,22396,64001,25176,64002,25826,26219,26589,
28609,28655,29730,29752,35351,37944,21585,22022,22374,24392,24986,27470,28760,
28845,32187,35477,22890,33067,25506,30472,32829,36010,22612,25645,27067,23445,
24081,28271,64003,34153,20812,21488,22826,24608,24907,27526,27760,27888,31518,
32974,33492,36294,37040,39089,64004,25799,28580,25745,25860,20814,21520,22303,
35342,24927,26742,64005,30171,31570,32113,36890,22534,27084,33151,35114,36864,
38969,20600,22871,22956,25237,36879,39722,24925,29305,38358,22369,23110,24052,
25226,25773,25850,26487,27874,27966,29228,29750,30772,32631,33453,36315,38935,
21028,22338,26495,29256,29923,36009,36774,37393,38442,20843,21485,25420,20329,
21764,24726,25943,27803,28031,29260,29437,31255,35207,35997,24429,28558,28921,
33192,24846,20415,20559,25153,29255,31687,32232,32745,36941,38829,39449,36022,
22378,24179,26544,33805,35413,21536,23318,24163,24290,24330,25987,32954,34109,
38281,38491,20296,21253,21261,21263,21638,21754,22275,24067,24598,25243,25265,
25429,64006,27873,28006,30129,30770,32990,33071,33502,33889,33970,34957,35090,
36875,37610,39165,39825,24133,26292,26333,28689,29190,64007,20469,21117,24426,
24915,26451,27161,28418,29922,31080,34920,35961,39111,39108,39491,21697,31263,
26963,35575,35914,39080,39342,24444,25259,30130,30382,34987,36991,38466,21305,
24380,24517,27852,29644,30050,30091,31558,33534,39325,20047,36924,19979,20309,
21414,22799,24264,26160,27827,29781,33655,34662,36032,36944,38686,39957,22737,
23416,34384,35604,40372,23506,24680,24717,26097,27735,28450,28579,28698,32597,
32752,38289,38290,38480,38867,21106,36676,20989,21547,21688,21859,21898,27323,
28085,32216,33382,37532,38519,40569,21512,21704,30418,34532,38308,38356,38492,
20130,20233,23022,23270,24055,24658,25239,26477,26689,27782,28207,32568,32923,
33322,64008,64009,38917,20133,20565,21683,22419,22874,23401,23475,25032,26999,
28023,28707,34809,35299,35442,35559,36994,39405,39608,21182,26680,20502,24184,
26447,33607,34892,20139,21521,22190,29670,37141,38911,39177,39255,39321,22099,
22687,34395,35377,25010,27382,29563,36562,27463,38570,39511,22869,29184,36203,
38761,20436,23796,24358,25080,26203,27883,28843,29572,29625,29694,30505,30541,
32067,32098,32291,33335,34898,64010,36066,37449,39023,23377,31348,34880,38913,
23244,20448,21332,22846,23805,25406,28025,29433,33029,33031,33698,37583,38960,
20136,20804,21009,22411,24418,27842,28366,28677,28752,28847,29074,29673,29801,
33610,34722,34913,36872,37026,37795,39336,20846,24407,24800,24935,26291,34137,
36426,37295,38795,20046,20114,21628,22741,22778,22909,23733,24359,25142,25160,
26122,26215,27627,28009,28111,28246,28408,28564,28640,28649,28765,29392,29733,
29786,29920,30355,31068,31946,32286,32993,33446,33899,33983,34382,34399,34676,
35703,35946,37804,38912,39013,24785,25110,37239,23130,26127,28151,28222,29759,
39746,24573,24794,31503,21700,24344,27742,27859,27946,28888,32005,34425,35340,
40251,21270,21644,23301,27194,28779,30069,31117,31166,33457,33775,35441,35649,
36008,38772,64011,25844,25899,30906,30907,31339,20024,21914,22864,23462,24187,
24739,25563,27489,26213,26707,28185,29029,29872,32008,36996,39529,39973,27963,
28369,29502,35905,38346,20976,24140,24488,24653,24822,24880,24908,26179,26180,
27045,27841,28255,28361,28514,29004,29852,30343,31681,31783,33618,34647,36945,
38541,40643,21295,22238,24315,24458,24674,24724,25079,26214,26371,27292,28142,
28590,28784,29546,32362,33214,33588,34516,35496,36036,21123,29554,23446,27243,
37892,21742,22150,23389,25928,25989,26313,26783,28045,28102,29243,32948,37237,
39501,20399,20505,21402,21518,21564,21897,21957,24127,24460,26429,29030,29661,
36869,21211,21235,22628,22734,28932,29071,29179,34224,35347,26248,34216,21927,
26244,29002,33841,21321,21913,27585,24409,24509,25582,26249,28999,35569,36637,
40638,20241,25658,28875,30054,34407,24676,35662,40440,20807,20982,21256,27958,
33016,40657,26133,27427,28824,30165,21507,23673,32007,35350,27424,27453,27462,
21560,24688,27965,32725,33288,20694,20958,21916,22123,22221,23020,23305,24076,
24985,24984,25137,26206,26342,29081,29113,29114,29351,31143,31232,32690,35440,
]
const EUCKREncode*: array[8226, UCS16x16] = [
(161u16,6379u16),(164u16,6385u16),(167u16,6230u16),(168u16,6182u16),
(170u16,7508u16),(173u16,6184u16),(174u16,6436u16),(176u16,6213u16),
(177u16,6205u16),(178u16,7782u16),(179u16,7783u16),(180u16,6370u16),
(182u16,6415u16),(183u16,6179u16),(184u16,6377u16),(185u16,7781u16),
(186u16,7517u16),(188u16,7594u16),(189u16,7591u16),(190u16,7595u16),
(191u16,6380u16),(198u16,7506u16),(208u16,7507u16),(215u16,6206u16),
(216u16,7515u16),(222u16,7518u16),(223u16,7707u16),(230u16,7696u16),
(240u16,7698u16),(247u16,6207u16),(248u16,7705u16),(254u16,7708u16),
(273u16,7697u16),(294u16,7509u16),(295u16,7699u16),(305u16,7700u16),
(306u16,7511u16),(307u16,7701u16),(312u16,7702u16),(319u16,7513u16),
(320u16,7703u16),(321u16,7514u16),(322u16,7704u16),(329u16,7711u16),
(330u16,7520u16),(331u16,7710u16),(338u16,7516u16),(339u16,7706u16),
(358u16,7519u16),(359u16,7709u16),(711u16,6372u16),(720u16,6381u16),
(728u16,6373u16),(729u16,6376u16),(730u16,6375u16),(731u16,6378u16),
(733u16,6374u16),(913u16,6968u16),(914u16,6969u16),(915u16,6970u16),
(916u16,6971u16),(917u16,6972u16),(918u16,6973u16),(919u16,6974u16),
(920u16,6975u16),(921u16,6976u16),(922u16,6977u16),(923u16,6978u16),
(924u16,6979u16),(925u16,6980u16),(926u16,6981u16),(927u16,6982u16),
(928u16,6983u16),(929u16,6984u16),(931u16,6985u16),(932u16,6986u16),
(933u16,6987u16),(934u16,6988u16),(935u16,6989u16),(936u16,6990u16),
(937u16,6991u16),(945u16,7000u16),(946u16,7001u16),(947u16,7002u16),
(948u16,7003u16),(949u16,7004u16),(950u16,7005u16),(951u16,7006u16),
(952u16,7007u16),(953u16,7008u16),(954u16,7009u16),(955u16,7010u16),
(956u16,7011u16),(957u16,7012u16),(958u16,7013u16),(959u16,7014u16),
(960u16,7015u16),(961u16,7016u16),(963u16,7017u16),(964u16,7018u16),
(965u16,7019u16),(966u16,7020u16),(967u16,7021u16),(968u16,7022u16),
(969u16,7023u16),(1025u16,8272u16),(1040u16,8266u16),(1041u16,8267u16),
(1042u16,8268u16),(1043u16,8269u16),(1044u16,8270u16),(1045u16,8271u16),
(1046u16,8273u16),(1047u16,8274u16),(1048u16,8275u16),(1049u16,8276u16),
(1050u16,8277u16),(1051u16,8278u16),(1052u16,8279u16),(1053u16,8280u16),
(1054u16,8281u16),(1055u16,8282u16),(1056u16,8283u16),(1057u16,8284u16),
(1058u16,8285u16),(1059u16,8286u16),(1060u16,8287u16),(1061u16,8288u16),
(1062u16,8289u16),(1063u16,8290u16),(1064u16,8291u16),(1065u16,8292u16),
(1066u16,8293u16),(1067u16,8294u16),(1068u16,8295u16),(1069u16,8296u16),
(1070u16,8297u16),(1071u16,8298u16),(1072u16,8314u16),(1073u16,8315u16),
(1074u16,8316u16),(1075u16,8317u16),(1076u16,8318u16),(1077u16,8319u16),
(1078u16,8321u16),(1079u16,8322u16),(1080u16,8323u16),(1081u16,8324u16),
(1082u16,8325u16),(1083u16,8326u16),(1084u16,8327u16),(1085u16,8328u16),
(1086u16,8329u16),(1087u16,8330u16),(1088u16,8331u16),(1089u16,8332u16),
(1090u16,8333u16),(1091u16,8334u16),(1092u16,8335u16),(1093u16,8336u16),
(1094u16,8337u16),(1095u16,8338u16),(1096u16,8339u16),(1097u16,8340u16),
(1098u16,8341u16),(1099u16,8342u16),(1100u16,8343u16),(1101u16,8344u16),
(1102u16,8345u16),(1103u16,8346u16),(1105u16,8320u16),(8213u16,6185u16),
(8216u16,6189u16),(8217u16,6190u16),(8220u16,6191u16),(8221u16,6192u16),
(8224u16,6416u16),(8225u16,6417u16),(8229u16,6180u16),(8230u16,6181u16),
(8240u16,6387u16),(8242u16,6214u16),(8243u16,6215u16),(8251u16,6231u16),
(8308u16,7784u16),(8319u16,7785u16),(8321u16,7786u16),(8322u16,7787u16),
(8323u16,7788u16),(8324u16,7789u16),(8364u16,6435u16),(8451u16,6216u16),
(8457u16,6386u16),(8467u16,7319u16),(8470u16,6429u16),(8481u16,6434u16),
(8482u16,6431u16),(8486u16,7372u16),(8491u16,6217u16),(8531u16,7592u16),
(8532u16,7593u16),(8539u16,7596u16),(8540u16,7597u16),(8541u16,7598u16),
(8542u16,7599u16),(8544u16,6951u16),(8545u16,6952u16),(8546u16,6953u16),
(8547u16,6954u16),(8548u16,6955u16),(8549u16,6956u16),(8550u16,6957u16),
(8551u16,6958u16),(8552u16,6959u16),(8553u16,6960u16),(8560u16,6936u16),
(8561u16,6937u16),(8562u16,6938u16),(8563u16,6939u16),(8564u16,6940u16),
(8565u16,6941u16),(8566u16,6942u16),(8567u16,6943u16),(8568u16,6944u16),
(8569u16,6945u16),(8592u16,6246u16),(8593u16,6247u16),(8594u16,6245u16),
(8595u16,6248u16),(8596u16,6249u16),(8597u16,6418u16),(8598u16,6421u16),
(8599u16,6419u16),(8600u16,6422u16),(8601u16,6420u16),(8658u16,6366u16),
(8660u16,6367u16),(8704u16,6368u16),(8706u16,6226u16),(8707u16,6369u16),
(8711u16,6227u16),(8712u16,6259u16),(8715u16,6260u16),(8719u16,6384u16),
(8721u16,6383u16),(8730u16,6253u16),(8733u16,6255u16),(8734u16,6211u16),
(8736u16,6223u16),(8741u16,6186u16),(8743u16,6267u16),(8744u16,6268u16),
(8745u16,6266u16),(8746u16,6265u16),(8747u16,6257u16),(8748u16,6258u16),
(8750u16,6382u16),(8756u16,6212u16),(8757u16,6256u16),(8764u16,6188u16),
(8765u16,6254u16),(8786u16,6229u16),(8800u16,6208u16),(8801u16,6228u16),
(8804u16,6209u16),(8805u16,6210u16),(8810u16,6251u16),(8811u16,6252u16),
(8834u16,6263u16),(8835u16,6264u16),(8838u16,6261u16),(8839u16,6262u16),
(8857u16,6398u16),(8869u16,6224u16),(8978u16,6225u16),(9312u16,7576u16),
(9313u16,7577u16),(9314u16,7578u16),(9315u16,7579u16),(9316u16,7580u16),
(9317u16,7581u16),(9318u16,7582u16),(9319u16,7583u16),(9320u16,7584u16),
(9321u16,7585u16),(9322u16,7586u16),(9323u16,7587u16),(9324u16,7588u16),
(9325u16,7589u16),(9326u16,7590u16),(9332u16,7766u16),(9333u16,7767u16),
(9334u16,7768u16),(9335u16,7769u16),(9336u16,7770u16),(9337u16,7771u16),
(9338u16,7772u16),(9339u16,7773u16),(9340u16,7774u16),(9341u16,7775u16),
(9342u16,7776u16),(9343u16,7777u16),(9344u16,7778u16),(9345u16,7779u16),
(9346u16,7780u16),(9372u16,7740u16),(9373u16,7741u16),(9374u16,7742u16),
(9375u16,7743u16),(9376u16,7744u16),(9377u16,7745u16),(9378u16,7746u16),
(9379u16,7747u16),(9380u16,7748u16),(9381u16,7749u16),(9382u16,7750u16),
(9383u16,7751u16),(9384u16,7752u16),(9385u16,7753u16),(9386u16,7754u16),
(9387u16,7755u16),(9388u16,7756u16),(9389u16,7757u16),(9390u16,7758u16),
(9391u16,7759u16),(9392u16,7760u16),(9393u16,7761u16),(9394u16,7762u16),
(9395u16,7763u16),(9396u16,7764u16),(9397u16,7765u16),(9424u16,7550u16),
(9425u16,7551u16),(9426u16,7552u16),(9427u16,7553u16),(9428u16,7554u16),
(9429u16,7555u16),(9430u16,7556u16),(9431u16,7557u16),(9432u16,7558u16),
(9433u16,7559u16),(9434u16,7560u16),(9435u16,7561u16),(9436u16,7562u16),
(9437u16,7563u16),(9438u16,7564u16),(9439u16,7565u16),(9440u16,7566u16),
(9441u16,7567u16),(9442u16,7568u16),(9443u16,7569u16),(9444u16,7570u16),
(9445u16,7571u16),(9446u16,7572u16),(9447u16,7573u16),(9448u16,7574u16),
(9449u16,7575u16),(9472u16,7126u16),(9473u16,7137u16),(9474u16,7127u16),
(9475u16,7138u16),(9484u16,7128u16),(9485u16,7165u16),(9486u16,7164u16),
(9487u16,7139u16),(9488u16,7129u16),(9489u16,7159u16),(9490u16,7158u16),
(9491u16,7140u16),(9492u16,7131u16),(9493u16,7163u16),(9494u16,7162u16),
(9495u16,7142u16),(9496u16,7130u16),(9497u16,7161u16),(9498u16,7160u16),
(9499u16,7141u16),(9500u16,7132u16),(9501u16,7153u16),(9502u16,7166u16),
(9503u16,7167u16),(9504u16,7148u16),(9505u16,7168u16),(9506u16,7169u16),
(9507u16,7143u16),(9508u16,7134u16),(9509u16,7155u16),(9510u16,7170u16),
(9511u16,7171u16),(9512u16,7150u16),(9513u16,7172u16),(9514u16,7173u16),
(9515u16,7145u16),(9516u16,7133u16),(9517u16,7174u16),(9518u16,7175u16),
(9519u16,7149u16),(9520u16,7154u16),(9521u16,7176u16),(9522u16,7177u16),
(9523u16,7144u16),(9524u16,7135u16),(9525u16,7178u16),(9526u16,7179u16),
(9527u16,7151u16),(9528u16,7156u16),(9529u16,7180u16),(9530u16,7181u16),
(9531u16,7146u16),(9532u16,7136u16),(9533u16,7182u16),(9534u16,7183u16),
(9535u16,7152u16),(9536u16,7184u16),(9537u16,7185u16),(9538u16,7157u16),
(9539u16,7186u16),(9540u16,7187u16),(9541u16,7188u16),(9542u16,7189u16),
(9543u16,7190u16),(9544u16,7191u16),(9545u16,7192u16),(9546u16,7193u16),
(9547u16,7147u16),(9618u16,6403u16),(9632u16,6240u16),(9633u16,6239u16),
(9635u16,6400u16),(9636u16,6404u16),(9637u16,6405u16),(9638u16,6408u16),
(9639u16,6407u16),(9640u16,6406u16),(9641u16,6409u16),(9650u16,6242u16),
(9651u16,6241u16),(9654u16,6391u16),(9655u16,6390u16),(9660u16,6244u16),
(9661u16,6243u16),(9664u16,6389u16),(9665u16,6388u16),(9670u16,6238u16),
(9671u16,6237u16),(9672u16,6399u16),(9675u16,6234u16),(9678u16,6236u16),
(9679u16,6235u16),(9680u16,6401u16),(9681u16,6402u16),(9733u16,6233u16),
(9734u16,6232u16),(9742u16,6412u16),(9743u16,6411u16),(9756u16,6413u16),
(9758u16,6414u16),(9792u16,6222u16),(9794u16,6221u16),(9824u16,6393u16),
(9825u16,6394u16),(9827u16,6397u16),(9828u16,6392u16),(9829u16,6395u16),
(9831u16,6396u16),(9832u16,6410u16),(9833u16,6424u16),(9834u16,6425u16),
(9836u16,6426u16),(9837u16,6423u16),(12288u16,6176u16),(12289u16,6177u16),
(12290u16,6178u16),(12291u16,6183u16),(12296u16,6195u16),(12297u16,6196u16),
(12298u16,6197u16),(12299u16,6198u16),(12300u16,6199u16),(12301u16,6200u16),
(12302u16,6201u16),(12303u16,6202u16),(12304u16,6203u16),(12305u16,6204u16),
(12307u16,6250u16),(12308u16,6193u16),(12309u16,6194u16),(12353u16,7886u16),
(12354u16,7887u16),(12355u16,7888u16),(12356u16,7889u16),(12357u16,7890u16),
(12358u16,7891u16),(12359u16,7892u16),(12360u16,7893u16),(12361u16,7894u16),
(12362u16,7895u16),(12363u16,7896u16),(12364u16,7897u16),(12365u16,7898u16),
(12366u16,7899u16),(12367u16,7900u16),(12368u16,7901u16),(12369u16,7902u16),
(12370u16,7903u16),(12371u16,7904u16),(12372u16,7905u16),(12373u16,7906u16),
(12374u16,7907u16),(12375u16,7908u16),(12376u16,7909u16),(12377u16,7910u16),
(12378u16,7911u16),(12379u16,7912u16),(12380u16,7913u16),(12381u16,7914u16),
(12382u16,7915u16),(12383u16,7916u16),(12384u16,7917u16),(12385u16,7918u16),
(12386u16,7919u16),(12387u16,7920u16),(12388u16,7921u16),(12389u16,7922u16),
(12390u16,7923u16),(12391u16,7924u16),(12392u16,7925u16),(12393u16,7926u16),
(12394u16,7927u16),(12395u16,7928u16),(12396u16,7929u16),(12397u16,7930u16),
(12398u16,7931u16),(12399u16,7932u16),(12400u16,7933u16),(12401u16,7934u16),
(12402u16,7935u16),(12403u16,7936u16),(12404u16,7937u16),(12405u16,7938u16),
(12406u16,7939u16),(12407u16,7940u16),(12408u16,7941u16),(12409u16,7942u16),
(12410u16,7943u16),(12411u16,7944u16),(12412u16,7945u16),(12413u16,7946u16),
(12414u16,7947u16),(12415u16,7948u16),(12416u16,7949u16),(12417u16,7950u16),
(12418u16,7951u16),(12419u16,7952u16),(12420u16,7953u16),(12421u16,7954u16),
(12422u16,7955u16),(12423u16,7956u16),(12424u16,7957u16),(12425u16,7958u16),
(12426u16,7959u16),(12427u16,7960u16),(12428u16,7961u16),(12429u16,7962u16),
(12430u16,7963u16),(12431u16,7964u16),(12432u16,7965u16),(12433u16,7966u16),
(12434u16,7967u16),(12435u16,7968u16),(12449u16,8076u16),(12450u16,8077u16),
(12451u16,8078u16),(12452u16,8079u16),(12453u16,8080u16),(12454u16,8081u16),
(12455u16,8082u16),(12456u16,8083u16),(12457u16,8084u16),(12458u16,8085u16),
(12459u16,8086u16),(12460u16,8087u16),(12461u16,8088u16),(12462u16,8089u16),
(12463u16,8090u16),(12464u16,8091u16),(12465u16,8092u16),(12466u16,8093u16),
(12467u16,8094u16),(12468u16,8095u16),(12469u16,8096u16),(12470u16,8097u16),
(12471u16,8098u16),(12472u16,8099u16),(12473u16,8100u16),(12474u16,8101u16),
(12475u16,8102u16),(12476u16,8103u16),(12477u16,8104u16),(12478u16,8105u16),
(12479u16,8106u16),(12480u16,8107u16),(12481u16,8108u16),(12482u16,8109u16),
(12483u16,8110u16),(12484u16,8111u16),(12485u16,8112u16),(12486u16,8113u16),
(12487u16,8114u16),(12488u16,8115u16),(12489u16,8116u16),(12490u16,8117u16),
(12491u16,8118u16),(12492u16,8119u16),(12493u16,8120u16),(12494u16,8121u16),
(12495u16,8122u16),(12496u16,8123u16),(12497u16,8124u16),(12498u16,8125u16),
(12499u16,8126u16),(12500u16,8127u16),(12501u16,8128u16),(12502u16,8129u16),
(12503u16,8130u16),(12504u16,8131u16),(12505u16,8132u16),(12506u16,8133u16),
(12507u16,8134u16),(12508u16,8135u16),(12509u16,8136u16),(12510u16,8137u16),
(12511u16,8138u16),(12512u16,8139u16),(12513u16,8140u16),(12514u16,8141u16),
(12515u16,8142u16),(12516u16,8143u16),(12517u16,8144u16),(12518u16,8145u16),
(12519u16,8146u16),(12520u16,8147u16),(12521u16,8148u16),(12522u16,8149u16),
(12523u16,8150u16),(12524u16,8151u16),(12525u16,8152u16),(12526u16,8153u16),
(12527u16,8154u16),(12528u16,8155u16),(12529u16,8156u16),(12530u16,8157u16),
(12531u16,8158u16),(12532u16,8159u16),(12533u16,8160u16),(12534u16,8161u16),
(12593u16,6746u16),(12594u16,6747u16),(12595u16,6748u16),(12596u16,6749u16),
(12597u16,6750u16),(12598u16,6751u16),(12599u16,6752u16),(12600u16,6753u16),
(12601u16,6754u16),(12602u16,6755u16),(12603u16,6756u16),(12604u16,6757u16),
(12605u16,6758u16),(12606u16,6759u16),(12607u16,6760u16),(12608u16,6761u16),
(12609u16,6762u16),(12610u16,6763u16),(12611u16,6764u16),(12612u16,6765u16),
(12613u16,6766u16),(12614u16,6767u16),(12615u16,6768u16),(12616u16,6769u16),
(12617u16,6770u16),(12618u16,6771u16),(12619u16,6772u16),(12620u16,6773u16),
(12621u16,6774u16),(12622u16,6775u16),(12623u16,6776u16),(12624u16,6777u16),
(12625u16,6778u16),(12626u16,6779u16),(12627u16,6780u16),(12628u16,6781u16),
(12629u16,6782u16),(12630u16,6783u16),(12631u16,6784u16),(12632u16,6785u16),
(12633u16,6786u16),(12634u16,6787u16),(12635u16,6788u16),(12636u16,6789u16),
(12637u16,6790u16),(12638u16,6791u16),(12639u16,6792u16),(12640u16,6793u16),
(12641u16,6794u16),(12642u16,6795u16),(12643u16,6796u16),(12644u16,6797u16),
(12645u16,6798u16),(12646u16,6799u16),(12647u16,6800u16),(12648u16,6801u16),
(12649u16,6802u16),(12650u16,6803u16),(12651u16,6804u16),(12652u16,6805u16),
(12653u16,6806u16),(12654u16,6807u16),(12655u16,6808u16),(12656u16,6809u16),
(12657u16,6810u16),(12658u16,6811u16),(12659u16,6812u16),(12660u16,6813u16),
(12661u16,6814u16),(12662u16,6815u16),(12663u16,6816u16),(12664u16,6817u16),
(12665u16,6818u16),(12666u16,6819u16),(12667u16,6820u16),(12668u16,6821u16),
(12669u16,6822u16),(12670u16,6823u16),(12671u16,6824u16),(12672u16,6825u16),
(12673u16,6826u16),(12674u16,6827u16),(12675u16,6828u16),(12676u16,6829u16),
(12677u16,6830u16),(12678u16,6831u16),(12679u16,6832u16),(12680u16,6833u16),
(12681u16,6834u16),(12682u16,6835u16),(12683u16,6836u16),(12684u16,6837u16),
(12685u16,6838u16),(12686u16,6839u16),(12800u16,7712u16),(12801u16,7713u16),
(12802u16,7714u16),(12803u16,7715u16),(12804u16,7716u16),(12805u16,7717u16),
(12806u16,7718u16),(12807u16,7719u16),(12808u16,7720u16),(12809u16,7721u16),
(12810u16,7722u16),(12811u16,7723u16),(12812u16,7724u16),(12813u16,7725u16),
(12814u16,7726u16),(12815u16,7727u16),(12816u16,7728u16),(12817u16,7729u16),
(12818u16,7730u16),(12819u16,7731u16),(12820u16,7732u16),(12821u16,7733u16),
(12822u16,7734u16),(12823u16,7735u16),(12824u16,7736u16),(12825u16,7737u16),
(12826u16,7738u16),(12827u16,7739u16),(12828u16,6428u16),(12896u16,7522u16),
(12897u16,7523u16),(12898u16,7524u16),(12899u16,7525u16),(12900u16,7526u16),
(12901u16,7527u16),(12902u16,7528u16),(12903u16,7529u16),(12904u16,7530u16),
(12905u16,7531u16),(12906u16,7532u16),(12907u16,7533u16),(12908u16,7534u16),
(12909u16,7535u16),(12910u16,7536u16),(12911u16,7537u16),(12912u16,7538u16),
(12913u16,7539u16),(12914u16,7540u16),(12915u16,7541u16),(12916u16,7542u16),
(12917u16,7543u16),(12918u16,7544u16),(12919u16,7545u16),(12920u16,7546u16),
(12921u16,7547u16),(12922u16,7548u16),(12923u16,7549u16),(12927u16,6427u16),
(13184u16,7356u16),(13185u16,7357u16),(13186u16,7358u16),(13187u16,7359u16),
(13188u16,7360u16),(13192u16,7341u16),(13193u16,7342u16),(13194u16,7375u16),
(13195u16,7376u16),(13196u16,7377u16),(13197u16,7337u16),(13198u16,7338u16),
(13199u16,7339u16),(13200u16,7367u16),(13201u16,7368u16),(13202u16,7369u16),
(13203u16,7370u16),(13204u16,7371u16),(13205u16,7316u16),(13206u16,7317u16),
(13207u16,7318u16),(13208u16,7320u16),(13209u16,7326u16),(13210u16,7327u16),
(13211u16,7328u16),(13212u16,7329u16),(13213u16,7330u16),(13214u16,7331u16),
(13215u16,7332u16),(13216u16,7333u16),(13217u16,7334u16),(13218u16,7335u16),
(13219u16,7322u16),(13220u16,7323u16),(13221u16,7324u16),(13222u16,7325u16),
(13223u16,7344u16),(13224u16,7345u16),(13225u16,7384u16),(13226u16,7385u16),
(13227u16,7386u16),(13228u16,7387u16),(13229u16,7380u16),(13230u16,7381u16),
(13231u16,7382u16),(13232u16,7346u16),(13233u16,7347u16),(13234u16,7348u16),
(13235u16,7349u16),(13236u16,7350u16),(13237u16,7351u16),(13238u16,7352u16),
(13239u16,7353u16),(13240u16,7354u16),(13241u16,7355u16),(13242u16,7361u16),
(13243u16,7362u16),(13244u16,7363u16),(13245u16,7364u16),(13246u16,7365u16),
(13247u16,7366u16),(13248u16,7373u16),(13249u16,7374u16),(13250u16,6432u16),
(13251u16,7391u16),(13252u16,7321u16),(13253u16,7379u16),(13254u16,7394u16),
(13255u16,6430u16),(13256u16,7343u16),(13257u16,7392u16),(13258u16,7336u16),
(13263u16,7340u16),(13264u16,7389u16),(13267u16,7390u16),(13270u16,7378u16),
(13272u16,6433u16),(13275u16,7383u16),(13276u16,7393u16),(13277u16,7388u16),
(19968u16,20498u16),(19969u16,21038u16),(19971u16,22375u16),(19975u16,16643u16),
(19976u16,20674u16),(19977u16,17973u16),(19978u16,17985u16),(19979u16,22922u16),
(19981u16,17469u16),(19985u16,22203u16),(19988u16,21761u16),(19989u16,17639u16),
(19990u16,18341u16),(19992u16,14813u16),(19993u16,17401u16),(19998u16,18725u16),
(20013u16,21448u16),(20018u16,14625u16),(20024u16,23480u16),(20025u16,15676u16),
(20027u16,21386u16),(20034u16,19524u16),(20035u16,15497u16),(20037u16,14814u16),
(20043u16,21468u16),(20045u16,17796u16),(20046u16,23301u16),(20047u16,22920u16),
(20054u16,14775u16),(20056u16,18726u16),(20057u16,20299u16),(20061u16,14815u16),
(20062u16,14242u16),(20063u16,19100u16),(20075u16,14030u16),(20077u16,15909u16),
(20083u16,20110u16),(20086u16,17452u16),(20087u16,17968u16),(20094u16,14230u16),
(20098u16,16070u16),(20102u16,16330u16),(20104u16,19183u16),(20107u16,17797u16),
(20108u16,20428u16),(20110u16,19900u16),(20112u16,20052u16),(20113u16,19941u16),
(20114u16,23302u16),(20116u16,19548u16),(20117u16,21039u16),(20120u16,15175u16),
(20123u16,17798u16),(20126u16,18917u16),(20129u16,16669u16),(20130u16,22976u16),
(20132u16,14788u16),(20133u16,23089u16),(20134u16,19303u16),(20136u16,23176u16),
(20139u16,23114u16),(20140u16,14385u16),(20141u16,21040u16),(20142u16,16108u16),
(20150u16,15677u16),(20154u16,20474u16),(20160u16,18912u16),(20161u16,20475u16),
(20164u16,22342u16),(20167u16,14816u16),(20170u16,15154u16),(20171u16,14186u16),
(20173u16,20619u16),(20180u16,20623u16),(20181u16,17799u16),(20182u16,22391u16),
(20183u16,20675u16),(20184u16,17470u16),(20185u16,18170u16),(20189u16,15911u16),
(20191u16,21966u16),(20195u16,15734u16),(20196u16,16266u16),(20197u16,20429u16),
(20208u16,18975u16),(20210u16,21449u16),(20214u16,14231u16),(20215u16,14187u16),
(20219u16,20507u16),(20225u16,15179u16),(20233u16,22977u16),(20234u16,20430u16),
(20235u16,15168u16),(20237u16,19549u16),(20238u16,15180u16),(20239u16,17434u16),
(20240u16,17268u16),(20241u16,23699u16),(20271u16,17250u16),(20276u16,17070u16),
(20278u16,16267u16),(20280u16,18778u16),(20282u16,17800u16),(20284u16,17801u16),
(20285u16,13966u16),(20291u16,20881u16),(20294u16,15678u16),(20295u16,20828u16),
(20296u16,22752u16),(20301u16,20085u16),(20302u16,20829u16),(20303u16,21387u16),
(20304u16,21380u16),(20305u16,19901u16),(20309u16,22923u16),(20313u16,19184u16),
(20314u16,20499u16),(20315u16,17629u16),(20316u16,20649u16),(20329u16,22710u16),
(20335u16,19121u16),(20336u16,17251u16),(20339u16,13967u16),(20342u16,15340u16),
(20346u16,20882u16),(20350u16,20500u16),(20351u16,17802u16),(20353u16,18779u16),
(20355u16,14006u16),(20356u16,21638u16),(20358u16,16101u16),(20360u16,22347u16),
(20362u16,14759u16),(20363u16,16284u16),(20365u16,18735u16),(20367u16,21388u16),
(20369u16,20111u16),(20374u16,16469u16),(20376u16,21762u16),(20379u16,14609u16),
(20381u16,20313u16),(20398u16,16833u16),(20399u16,23660u16),(20405u16,22378u16),
(20406u16,16121u16),(20415u16,22726u16),(20418u16,14430u16),(20419u16,22156u16),
(20420u16,18918u16),(20425u16,19550u16),(20426u16,21428u16),(20430u16,21212u16),
(20433u16,19876u16),(20435u16,14386u16),(20436u16,23138u16),(20439u16,18387u16),
(20442u16,16489u16),(20445u16,17418u16),(20447u16,17803u16),(20448u16,23164u16),
(20449u16,18780u16),(20462u16,18418u16),(20463u16,17471u16),(20465u16,14817u16),
(20467u16,17231u16),(20469u16,22786u16),(20472u16,17453u16),(20474u16,19174u16),
(20482u16,17402u16),(20486u16,16109u16),(20489u16,21813u16),(20491u16,14188u16),
(20493u16,17230u16),(20497u16,16905u16),(20498u16,15753u16),(20502u16,23109u16),
(20505u16,23661u16),(20506u16,20314u16),(20508u16,21951u16),(20510u16,14387u16),
(20511u16,21763u16),(20513u16,21814u16),(20515u16,17202u16),(20516u16,22348u16),
(20518u16,14985u16),(20519u16,21267u16),(20520u16,14213u16),(20522u16,19525u16),
(20523u16,16470u16),(20524u16,22405u16),(20525u16,19727u16),(20539u16,19101u16),
(20547u16,19166u16),(20551u16,13968u16),(20552u16,14352u16),(20553u16,20086u16),
(20559u16,22727u16),(20565u16,23090u16),(20570u16,21389u16),(20572u16,21041u16),
(20581u16,14232u16),(20596u16,22341u16),(20597u16,21042u16),(20598u16,19902u16),
(20600u16,22577u16),(20608u16,14776u16),(20613u16,17472u16),(20621u16,17203u16),
(20625u16,14243u16),(20632u16,17956u16),(20633u16,17640u16),(20652u16,22177u16),
(20653u16,19877u16),(20658u16,19551u16),(20659u16,20883u16),(20661u16,21835u16),
(20663u16,17986u16),(20670u16,14388u16),(20677u16,15138u16),(20681u16,21995u16),
(20682u16,18171u16),(20687u16,17987u16),(20689u16,14789u16),(20693u16,17435u16),
(20694u16,23729u16),(20698u16,16331u16),(20702u16,20087u16),(20709u16,19738u16),
(20711u16,18727u16),(20717u16,21803u16),(20729u16,13969u16),(20731u16,17283u16),
(20735u16,17804u16),(20736u16,20315u16),(20737u16,21429u16),(20740u16,19161u16),
(20742u16,14389u16),(20745u16,14246u16),(20754u16,20112u16),(20767u16,17988u16),
(20769u16,16322u16),(20778u16,19903u16),(20786u16,20830u16),(20791u16,16122u16),
(20794u16,15346u16),(20796u16,19175u16),(20800u16,19685u16),(20801u16,20270u16),
(20803u16,20055u16),(20804u16,23177u16),(20805u16,22221u16),(20806u16,21213u16),
(20807u16,23707u16),(20808u16,18172u16),(20809u16,14760u16),(20811u16,15131u16),
(20812u16,22541u16),(20813u16,16708u16),(20814u16,22560u16),(20818u16,18919u16),
(20828u16,15928u16),(20834u16,15176u16),(20837u16,20518u16),(20839u16,15499u16),
(20840u16,20884u16),(20841u16,16110u16),(20842u16,20113u16),(20843u16,22707u16),
(20844u16,14610u16),(20845u16,16466u16),(20846u16,23292u16),(20849u16,14611u16),
(20853u16,17403u16),(20854u16,15181u16),(20855u16,14818u16),(20856u16,20885u16),
(20860u16,14379u16),(20864u16,15182u16),(20870u16,19182u16),(20874u16,21847u16),
(20877u16,20807u16),(20882u16,16834u16),(20885u16,16709u16),(20887u16,19878u16),
(20896u16,14739u16),(20901u16,16817u16),(20906u16,16706u16),(20908u16,15912u16),
(20918u16,19102u16),(20919u16,16105u16),(20925u16,16254u16),(20932u16,21947u16),
(20934u16,21430u16),(20937u16,16111u16),(20939u16,21214u16),(20940u16,16483u16),
(20941u16,15913u16),(20956u16,16482u16),(20957u16,20309u16),(20958u16,23730u16),
(20961u16,17272u16),(20976u16,23502u16),(20977u16,14189u16),(20982u16,23708u16),
(20984u16,21985u16),(20985u16,19739u16),(20986u16,22218u16),(20989u16,22957u16),
(20992u16,15754u16),(20995u16,20476u16),(20998u16,17609u16),(20999u16,21018u16),
(21000u16,19527u16),(21002u16,14007u16),(21006u16,16906u16),(21009u16,23178u16),
(21015u16,16255u16),(21021u16,22033u16),(21028u16,22602u16),(21029u16,17397u16),
(21033u16,16490u16),(21034u16,17957u16),(21038u16,14755u16),(21040u16,15755u16),
(21046u16,21189u16),(21047u16,18411u16),(21048u16,14986u16),(21049u16,21798u16),
(21050u16,20624u16),(21051u16,13995u16),(21059u16,22024u16),(21063u16,22371u16),
(21066u16,17856u16),(21067u16,15132u16),(21068u16,16078u16),(21069u16,20886u16),
(21076u16,21953u16),(21078u16,17473u16),(21083u16,14162u16),(21085u16,17051u16),
(21089u16,18215u16),(21097u16,20620u16),(21098u16,20887u16),(21103u16,17474u16),
(21106u16,22955u16),(21109u16,21815u16),(21117u16,22787u16),(21119u16,22034u16),
(21123u16,23546u16),(21127u16,15133u16),(21128u16,17284u16),(21129u16,16452u16),
(21133u16,14247u16),(21137u16,21190u16),(21138u16,14248u16),(21147u16,16139u16),
(21151u16,14612u16),(21152u16,13970u16),(21155u16,16256u16),(21156u16,15139u16),
(21161u16,21215u16),(21162u16,15514u16),(21163u16,14349u16),(21182u16,23107u16),
(21185u16,14390u16),(21187u16,17095u16),(21189u16,22372u16),(21191u16,19879u16),
(21193u16,16710u16),(21197u16,14391u16),(21202u16,16480u16),(21205u16,15914u16),
(21206u16,19932u16),(21208u16,14040u16),(21209u16,16881u16),(21211u16,23673u16),
(21213u16,18728u16),(21214u16,16289u16),(21215u16,16835u16),(21218u16,18342u16),
(21219u16,20856u16),(21220u16,15140u16),(21235u16,23674u16),(21237u16,16123u16),
(21240u16,14987u16),(21242u16,20650u16),(21243u16,15123u16),(21246u16,14819u16),
(21247u16,17013u16),(21253u16,22753u16),(21256u16,23709u16),(21261u16,22754u16),
(21263u16,22755u16),(21264u16,17436u16),(21269u16,17641u16),(21270u16,23364u16),
(21271u16,17608u16),(21273u16,18736u16),(21280u16,20676u16),(21281u16,14761u16),
(21283u16,14156u16),(21290u16,17642u16),(21295u16,23526u16),(21305u16,22910u16),
(21311u16,15576u16),(21312u16,14916u16),(21313u16,18913u16),(21315u16,21967u16),
(21316u16,20519u16),(21319u16,18729u16),(21320u16,19552u16),(21321u16,23688u16),
(21322u16,17071u16),(21325u16,16644u16),(21329u16,17643u16),(21330u16,21264u16),
(21331u16,22406u16),(21332u16,23165u16),(21335u16,15380u16),(21338u16,17052u16),
(21340u16,17437u16),(21342u16,17391u16),(21344u16,21026u16),(21350u16,14772u16),
(21352u16,18202u16),(21359u16,16869u16),(21360u16,20477u16),(21361u16,20088u16),
(21364u16,13996u16),(21365u16,16071u16),(21367u16,14988u16),(21373u16,21452u16),
(21375u16,14392u16),(21380u16,18993u16),(21395u16,18982u16),(21400u16,16491u16),
(21402u16,23662u16),(21407u16,20056u16),(21408u16,22343u16),(21413u16,14995u16),
(21414u16,22924u16),(21421u16,19369u16),(21435u16,14214u16),(21443u16,21804u16),
(21448u16,19904u16),(21449u16,21764u16),(21450u16,15169u16),(21451u16,19905u16),
(21453u16,17072u16),(21460u16,18575u16),(21462u16,22327u16),(21463u16,18419u16),
(21467u16,17073u16),(21473u16,19528u16),(21474u16,22166u16),(21475u16,14917u16),
(21476u16,14550u16),(21477u16,14918u16),(21481u16,14551u16),(21482u16,21469u16),
(21483u16,15108u16),(21484u16,18350u16),(21485u16,22708u16),(21487u16,13971u16),
(21488u16,22542u16),(21489u16,21639u16),(21490u16,17805u16),(21491u16,19906u16),
(21496u16,17806u16),(21507u16,23717u16),(21508u16,13997u16),(21512u16,22969u16),
(21513u16,15341u16),(21514u16,20857u16),(21516u16,15915u16),(21517u16,16818u16),
(21518u16,23663u16),(21519u16,16492u16),(21520u16,22561u16),(21521u16,23115u16),
(21531u16,14969u16),(21533u16,16515u16),(21535u16,20300u16),(21536u16,22742u16),
(21542u16,17475u16),(21545u16,17610u16),(21547u16,22958u16),(21555u16,19554u16),
(21560u16,23724u16),(21561u16,22328u16),(21563u16,16907u16),(21564u16,23664u16),
(21566u16,19553u16),(21570u16,16124u16),(21576u16,21043u16),(21578u16,14552u16),
(21585u16,22517u16),(21608u16,21393u16),(21610u16,21392u16),(21617u16,14553u16),
(21619u16,17016u16),(21621u16,13972u16),(21627u16,18781u16),(21628u16,23303u16),
(21629u16,16819u16),(21632u16,20831u16),(21638u16,22756u16),(21644u16,23365u16),
(21646u16,14919u16),(21648u16,17476u16),(21668u16,22392u16),(21672u16,20625u16),
(21675u16,21566u16),(21676u16,14790u16),(21683u16,23091u16),(21688u16,22959u16),
(21693u16,20479u16),(21696u16,18983u16),(21697u16,22896u16),(21700u16,23354u16),
(21704u16,22970u16),(21705u16,20808u16),(21729u16,20057u16),(21733u16,13973u16),
(21736u16,22035u16),(21741u16,14589u16),(21742u16,23551u16),(21746u16,21986u16),
(21754u16,22757u16),(21764u16,22711u16),(21766u16,17807u16),(21767u16,21603u16),
(21774u16,16493u16),(21776u16,15723u16),(21788u16,16662u16),(21807u16,20115u16),
(21809u16,21816u16),(21813u16,18963u16),(21822u16,22393u16),(21828u16,22407u16),
(21830u16,17989u16),(21839u16,16908u16),(21843u16,14431u16),(21846u16,15701u16),
(21854u16,18920u16),(21859u16,22960u16),(21884u16,21191u16),(21888u16,14206u16),
(21892u16,18173u16),(21894u16,21987u16),(21895u16,15955u16),(21897u16,23665u16),
(21898u16,22961u16),(21912u16,21968u16),(21913u16,23689u16),(21914u16,23481u16),
(21916u16,23731u16),(21917u16,14031u16),(21927u16,23684u16),(21929u16,20116u16),
(21930u16,17990u16),(21931u16,15345u16),(21932u16,14791u16),(21934u16,15679u16),
(21957u16,23666u16),(21959u16,18019u16),(21972u16,21604u16),(21978u16,19555u16),
(21980u16,15183u16),(21983u16,21765u16),(21987u16,17808u16),(21988u16,22349u16),
(22013u16,18420u16),(22014u16,21394u16),(22022u16,22518u16),(22025u16,13974u16),
(22036u16,14920u16),(22039u16,17991u16),(22063u16,18351u16),(22066u16,21216u16),
(22068u16,22329u16),(22070u16,18737u16),(22099u16,23123u16),(22120u16,15184u16),
(22123u16,23732u16),(22132u16,17611u16),(22150u16,23552u16),(22181u16,19316u16),
(22188u16,17778u16),(22190u16,23116u16),(22196u16,19176u16),(22204u16,20651u16),
(22218u16,15490u16),(22221u16,23733u16),(22225u16,22157u16),(22234u16,18421u16),
(22235u16,17809u16),(22238u16,23527u16),(22240u16,20480u16),(22256u16,14596u16),
(22265u16,16268u16),(22266u16,14554u16),(22275u16,22758u16),(22276u16,19151u16),
(22280u16,14989u16),(22283u16,14963u16),(22285u16,20089u16),(22290u16,20059u16),
(22291u16,20058u16),(22294u16,15756u16),(22296u16,15680u16),(22303u16,22562u16),
(22312u16,20809u16),(22317u16,15109u16),(22320u16,21567u16),(22331u16,15185u16),
(22336u16,21568u16),(22338u16,22603u16),(22343u16,15124u16),(22346u16,17204u16),
(22349u16,15702u16),(22350u16,14041u16),(22352u16,21381u16),(22353u16,14208u16),
(22369u16,22586u16),(22372u16,14597u16),(22374u16,22519u16),(22378u16,22737u16),
(22382u16,15736u16),(22384u16,14393u16),(22389u16,14921u16),(22396u16,22408u16),
(22402u16,18422u16),(22408u16,15735u16),(22411u16,23179u16),(22419u16,23092u16),
(22432u16,20292u16),(22434u16,14922u16),(22435u16,20060u16),(22467u16,18984u16),
(22471u16,19880u16),(22472u16,21431u16),(22475u16,16681u16),(22478u16,18227u16),
(22495u16,19305u16),(22496u16,17477u16),(22512u16,21836u16),(22516u16,18763u16),
(22519u16,21656u16),(22521u16,17233u16),(22522u16,15186u16),(22524u16,15187u16),
(22528u16,14975u16),(22530u16,15724u16),(22533u16,14362u16),(22534u16,22571u16),
(22536u16,14163u16),(22537u16,20263u16),(22538u16,18935u16),(22558u16,22005u16),
(22561u16,17419u16),(22564u16,21192u16),(22567u16,19317u16),(22570u16,14042u16),
(22575u16,19740u16),(22576u16,19167u16),(22577u16,17420u16),(22580u16,20677u16),
(22581u16,15757u16),(22586u16,14432u16),(22602u16,14777u16),(22603u16,19486u16),
(22607u16,14190u16),(22609u16,18352u16),(22612u16,22533u16),(22615u16,15758u16),
(22616u16,15725u16),(22618u16,22167u16),(22622u16,18016u16),(22625u16,20888u16),
(22626u16,19556u16),(22628u16,23675u16),(22645u16,21605u16),(22649u16,21805u16),
(22652u16,20889u16),(22654u16,18576u16),(22659u16,14394u16),(22661u16,18029u16),
(22665u16,19881u16),(22675u16,16870u16),(22684u16,22180u16),(22686u16,21457u16),
(22687u16,23124u16),(22696u16,16903u16),(22697u16,15899u16),(22702u16,22394u16),
(22707u16,17612u16),(22714u16,19557u16),(22715u16,20678u16),(22718u16,14008u16),
(22721u16,17285u16),(22725u16,19686u16),(22727u16,15681u16),(22734u16,23676u16),
(22737u16,22936u16),(22739u16,18971u16),(22741u16,23304u16),(22744u16,16439u16),
(22745u16,14762u16),(22750u16,14778u16),(22751u16,16315u16),(22756u16,19124u16),
(22763u16,17810u16),(22764u16,20508u16),(22767u16,20679u16),(22777u16,20501u16),
(22778u16,23305u16),(22779u16,18030u16),(22781u16,18423u16),(22799u16,22925u16),
(22804u16,15188u16),(22805u16,18155u16),(22806u16,19731u16),(22809u16,18577u16),
(22810u16,15578u16),(22812u16,19103u16),(22818u16,16866u16),(22823u16,15737u16),
(22825u16,21969u16),(22826u16,22543u16),(22827u16,17478u16),(22829u16,19741u16),
(22830u16,18976u16),(22833u16,18802u16),(22839u16,20433u16),(22846u16,23166u16),
(22852u16,19177u16),(22855u16,15189u16),(22856u16,15500u16),(22857u16,17454u16),
(22862u16,15110u16),(22863u16,21395u16),(22864u16,23482u16),(22865u16,14433u16),
(22868u16,17613u16),(22869u16,23134u16),(22871u16,22578u16),(22874u16,23093u16),
(22880u16,20890u16),(22882u16,17811u16),(22887u16,19558u16),(22890u16,22527u16),
(22891u16,20271u16),(22892u16,20680u16),(22893u16,18156u16),(22894u16,17614u16),
(22899u16,15504u16),(22900u16,15516u16),(22904u16,14009u16),(22909u16,23306u16),
(22914u16,19188u16),(22915u16,17644u16),(22916u16,16670u16),(22922u16,20509u16),
(22931u16,15190u16),(22934u16,19742u16),(22935u16,15155u16),(22937u16,16871u16),
(22949u16,22395u16),(22952u16,17205u16),(22956u16,22579u16),(22969u16,16682u16),
(22971u16,21948u16),(22974u16,22006u16),(22979u16,21044u16),(22982u16,16836u16),
(22985u16,20626u16),(22987u16,18738u16),(22992u16,20832u16),(22993u16,14555u16),
(22995u16,18228u16),(22996u16,20090u16),(23001u16,20510u16),(23002u16,19743u16),
(23004u16,14164u16),(23005u16,21390u16),(23014u16,14010u16),(23016u16,20434u16),
(23018u16,21640u16),(23020u16,23734u16),(23022u16,22978u16),(23032u16,19318u16),
(23035u16,20481u16),(23039u16,20627u16),(23041u16,20091u16),(23043u16,19728u16),
(23057u16,17812u16),(23064u16,15491u16),(23067u16,19559u16),(23068u16,15349u16),
(23071u16,19319u16),(23072u16,18782u16),(23077u16,18921u16),(23081u16,16645u16),
(23094u16,22330u16),(23100u16,21817u16),(23105u16,16440u16),(23110u16,22587u16),
(23113u16,19703u16),(23130u16,23345u16),(23138u16,17645u16),(23142u16,17479u16),
(23186u16,16683u16),(23194u16,17017u16),(23195u16,20061u16),(23204u16,18739u16),
(23233u16,13975u16),(23234u16,18424u16),(23236u16,20062u16),(23241u16,21641u16),
(23244u16,23163u16),(23265u16,20858u16),(23270u16,22979u16),(23273u16,15561u16),
(23301u16,23366u16),(23305u16,23735u16),(23307u16,18174u16),(23308u16,14792u16),
(23318u16,22743u16),(23338u16,17779u16),(23360u16,17992u16),(23363u16,19125u16),
(23376u16,20628u16),(23377u16,23159u16),(23380u16,14613u16),(23381u16,20621u16),
(23383u16,20629u16),(23384u16,21262u16),(23386u16,17576u16),(23388u16,20630u16),
(23389u16,23553u16),(23391u16,16700u16),(23395u16,14434u16),(23396u16,14556u16),
(23401u16,23094u16),(23403u16,18396u16),(23408u16,18578u16),(23409u16,20662u16),
(23413u16,17577u16),(23416u16,22937u16),(23418u16,20117u16),(23420u16,19172u16),
(23429u16,15750u16),(23431u16,19907u16),(23432u16,18425u16),(23433u16,18949u16),
(23435u16,18403u16),(23436u16,19704u16),(23439u16,14784u16),(23443u16,17438u16),
(23445u16,22536u16),(23446u16,23548u16),(23447u16,21268u16),(23448u16,14740u16),
(23449u16,21396u16),(23450u16,21045u16),(23451u16,19705u16),(23452u16,20316u16),
(23458u16,14207u16),(23459u16,18175u16),(23460u16,18803u16),(23461u16,20118u16),
(23462u16,23483u16),(23468u16,18229u16),(23470u16,14979u16),(23472u16,20810u16),
(23475u16,23095u16),(23476u16,19320u16),(23477u16,18353u16),(23478u16,13976u16),
(23480u16,18783u16),(23481u16,19882u16),(23487u16,18579u16),(23488u16,21837u16),
(23490u16,20859u16),(23491u16,20063u16),(23492u16,15191u16),(23493u16,20482u16),
(23494u16,17048u16),(23495u16,14923u16),(23500u16,17578u16),(23504u16,16684u16),
(23506u16,22941u16),(23507u16,19908u16),(23508u16,18764u16),(23511u16,15513u16),
(23518u16,16637u16),(23519u16,21799u16),(23521u16,14626u16),(23522u16,22379u16),
(23524u16,19560u16),(23525u16,19744u16),(23526u16,18804u16),(23527u16,15512u16),
(23528u16,21838u16),(23529u16,18806u16),(23531u16,17813u16),(23532u16,14741u16),
(23534u16,16332u16),(23535u16,21432u16),(23541u16,22168u16),(23542u16,17421u16),
(23544u16,22162u16),(23546u16,17814u16),(23553u16,17455u16),(23556u16,17815u16),
(23559u16,20681u16),(23560u16,20891u16),(23561u16,20092u16),(23562u16,21263u16),
(23563u16,18807u16),(23565u16,15738u16),(23566u16,15759u16),(23567u16,18354u16),
(23569u16,18355u16),(23574u16,21996u16),(23577u16,17993u16),(23588u16,19909u16),
(23592u16,17206u16),(23601u16,22331u16),(23608u16,18740u16),(23609u16,20272u16),
(23610u16,21954u16),(23611u16,14557u16),(23612u16,15574u16),(23614u16,17018u16),
(23615u16,15552u16),(23616u16,14964u16),(23621u16,14215u16),(23622u16,14435u16),
(23624u16,14976u16),(23627u16,19674u16),(23629u16,18742u16),(23630u16,18741u16),
(23633u16,18203u16),(23637u16,20892u16),(23643u16,17404u16),(23648u16,15760u16),
(23650u16,16441u16),(23652u16,22346u16),(23653u16,16494u16),(23660u16,18388u16),
(23663u16,15939u16),(23665u16,17958u16),(23673u16,23718u16),(23696u16,15192u16),
(23697u16,20667u16),(23713u16,14165u16),(23721u16,18964u16),(23723u16,18426u16),
(23724u16,14157u16),(23729u16,15739u16),(23731u16,18936u16),(23733u16,23307u16),
(23735u16,17035u16),(23736u16,18950u16),(23738u16,16270u16),(23742u16,21027u16),
(23744u16,18427u16),(23769u16,22350u16),(23776u16,17994u16),(23784u16,18922u16),
(23791u16,17456u16),(23792u16,17457u16),(23796u16,23139u16),(23798u16,15761u16),
(23803u16,21433u16),(23805u16,23167u16),(23815u16,18618u16),(23821u16,16102u16),
(23822u16,15193u16),(23825u16,14598u16),(23828u16,22178u16),(23830u16,18985u16),
(23831u16,14166u16),(23833u16,16471u16),(23847u16,18619u16),(23849u16,17633u16),
(23883u16,17019u16),(23884u16,14043u16),(23888u16,16080u16),(23913u16,18716u16),
(23916u16,19732u16),(23919u16,21766u16),(23943u16,14924u16),(23947u16,15762u16),
(23965u16,15946u16),(23968u16,14793u16),(23970u16,19747u16),(23978u16,19180u16),
(23992u16,19489u16),(23994u16,16271u16),(23996u16,18031u16),(23997u16,18937u16),
(24013u16,19733u16),(24018u16,16646u16),(24022u16,18965u16),(24029u16,21970u16),
(24030u16,21397u16),(24033u16,18587u16),(24034u16,18356u16),(24037u16,14614u16),
(24038u16,21382u16),(24039u16,14794u16),(24040u16,14216u16),(24043u16,16882u16),
(24046u16,21767u16),(24049u16,15194u16),(24050u16,20436u16),(24051u16,17816u16),
(24052u16,22588u16),(24055u16,22980u16),(24061u16,18397u16),(24062u16,14233u16),
(24066u16,18743u16),(24067u16,22759u16),(24070u16,17273u16),(24076u16,23736u16),
(24081u16,22537u16),(24086u16,22007u16),(24089u16,21642u16),(24091u16,17252u16),
(24093u16,21193u16),(24101u16,18428u16),(24107u16,17817u16),(24109u16,18157u16),
(24115u16,20682u16),(24118u16,15740u16),(24120u16,17995u16),(24125u16,16837u16),
(24127u16,23667u16),(24128u16,21046u16),(24132u16,18938u16),(24133u16,22780u16),
(24135u16,17207u16),(24140u16,23503u16),(24149u16,16638u16),(24159u16,22351u16),
(24161u16,17258u16),(24162u16,15726u16),(24163u16,22744u16),(24178u16,14011u16),
(24179u16,22738u16),(24180u16,15505u16),(24183u16,17405u16),(24184u16,23110u16),
(24185u16,14012u16),(24187u16,23484u16),(24188u16,20119u16),(24189u16,20120u16),
(24190u16,15195u16),(24196u16,20683u16),(24199u16,17646u16),(24202u16,17996u16),
(24207u16,18032u16),(24213u16,20833u16),(24215u16,21028u16),(24218u16,14395u16),
(24220u16,17579u16),(24224u16,17997u16),(24230u16,15763u16),(24231u16,21383u16),
(24235u16,14558u16),(24237u16,21047u16),(24245u16,18966u16),(24246u16,18033u16),
(24247u16,14167u16),(24248u16,19883u16),(24254u16,20121u16),(24258u16,17998u16),
(24264u16,22926u16),(24265u16,16260u16),(24266u16,16093u16),(24272u16,14925u16),
(24275u16,14734u16),(24278u16,16333u16),(24282u16,21398u16),(24283u16,20893u16),
(24287u16,16872u16),(24288u16,21818u16),(24290u16,22745u16),(24291u16,14763u16),
(24300u16,16125u16),(24307u16,22015u16),(24310u16,19322u16),(24311u16,21048u16),
(24314u16,14234u16),(24315u16,23528u16),(24321u16,17392u16),(24324u16,16316u16),
(24330u16,22746u16),(24335u16,18765u16),(24337u16,18744u16),(24339u16,14980u16),
(24340u16,21217u16),(24341u16,20483u16),(24343u16,17630u16),(24344u16,23355u16),
(24347u16,20437u16),(24351u16,21194u16),(24358u16,23140u16),(24359u16,23308u16),
(24361u16,15517u16),(24369u16,19111u16),(24373u16,20684u16),(24378u16,14168u16),
(24380u16,22911u16),(24392u16,22520u16),(24394u16,14169u16),(24396u16,17020u16),
(24398u16,16647u16),(24406u16,15682u16),(24407u16,23293u16),(24409u16,23691u16),
(24411u16,20438u16),(24418u16,23276u16),(24422u16,19168u16),(24423u16,19933u16),
(24425u16,21839u16),(24426u16,22788u16),(24427u16,21218u16),(24428u16,17780u16),
(24429u16,22721u16),(24432u16,21819u16),(24433u16,19490u16),(24439u16,17208u16),
(24441u16,19306u16),(24444u16,22903u16),(24447u16,17631u16),(24448u16,19722u16),
(24449u16,21049u16),(24453u16,15741u16),(24455u16,18588u16),(24458u16,23529u16),
(24459u16,16475u16),(24460u16,23668u16),(24464u16,18034u16),(24465u16,14396u16),
(24466u16,15764u16),(24471u16,15945u16),(24472u16,17234u16),(24473u16,17818u16),
(24478u16,21269u16),(24480u16,16103u16),(24481u16,19152u16),(24488u16,23504u16),
(24489u16,17439u16),(24490u16,18589u16),(24494u16,17021u16),(24501u16,21758u16),
(24503u16,15751u16),(24505u16,21988u16),(24509u16,23692u16),(24515u16,18808u16),
(24517u16,22912u16),(24524u16,15196u16),(24525u16,20484u16),(24534u16,22163u16),
(24535u16,21569u16),(24536u16,16671u16),(24537u16,16672u16),(24544u16,22222u16),
(24555u16,22390u16),(24565u16,15508u16),(24573u16,23351u16),(24575u16,17615u16),
(24591u16,18977u16),(24594u16,15518u16),(24598u16,22760u16),(24604u16,16272u16),
(24605u16,17819u16),(24608u16,22544u16),(24609u16,20439u16),(24613u16,15170u16),
(24615u16,18230u16),(24616u16,20064u16),(24618u16,14779u16),(24623u16,14350u16),
(24641u16,20511u16),(24642u16,18590u16),(24643u16,18745u16),(24653u16,23505u16),
(24656u16,14615u16),(24658u16,22981u16),(24661u16,18035u16),(24665u16,19126u16),
(24669u16,14756u16),(24674u16,23530u16),(24675u16,20631u16),(24676u16,23704u16),
(24677u16,22352u16),(24680u16,22942u16),(24681u16,20293u16),(24682u16,13998u16),
(24684u16,15509u16),(24685u16,14616u16),(24687u16,18766u16),(24688u16,23725u16),
(24709u16,19362u16),(24713u16,18805u16),(24716u16,21195u16),(24717u16,22943u16),
(24724u16,23531u16),(24726u16,22712u16),(24730u16,18404u16),(24731u16,20894u16),
(24735u16,19561u16),(24736u16,20122u16),(24739u16,23485u16),(24740u16,22169u16),
(24743u16,16495u16),(24752u16,21270u16),(24754u16,17647u16),(24755u16,15752u16),
(24756u16,22227u16),(24758u16,17036u16),(24760u16,14436u16),(24764u16,15765u16),
(24765u16,21949u16),(24773u16,21050u16),(24775u16,15900u16),(24785u16,23342u16),
(24794u16,23352u16),(24796u16,18158u16),(24799u16,20123u16),(24800u16,23294u16),
(24801u16,18939u16),(24816u16,22396u16),(24817u16,15546u16),(24819u16,17999u16),
(24822u16,23506u16),(24825u16,19104u16),(24826u16,18231u16),(24827u16,22344u16),
(24833u16,18429u16),(24838u16,14235u16),(24840u16,20124u16),(24841u16,20125u16),
(24845u16,17037u16),(24846u16,22725u16),(24847u16,20317u16),(24853u16,18940u16),
(24858u16,19910u16),(24859u16,18986u16),(24863u16,14044u16),(24871u16,14780u16),
(24880u16,23507u16),(24884u16,21820u16),(24887u16,14191u16),(24892u16,18784u16),
(24894u16,14192u16),(24895u16,20065u16),(24898u16,19884u16),(24900u16,16476u16),
(24903u16,20294u16),(24904u16,20632u16),(24906u16,14380u16),(24907u16,22545u16),
(24908u16,23508u16),(24915u16,22789u16),(24917u16,16838u16),(24920u16,21806u16),
(24921u16,21807u16),(24925u16,22583u16),(24927u16,22564u16),(24930u16,16648u16),
(24931u16,14742u16),(24932u16,13999u16),(24935u16,23295u16),(24936u16,14193u16),
(24939u16,21271u16),(24942u16,16126u16),(24944u16,20093u16),(24950u16,14397u16),
(24951u16,14170u16),(24957u16,21955u16),(24958u16,19870u16),(24961u16,22170u16),
(24962u16,19911u16),(24970u16,17648u16),(24974u16,21458u16),(24976u16,16146u16),
(24977u16,17792u16),(24980u16,22036u16),(24984u16,23738u16),(24985u16,23737u16),
(24986u16,22521u16),(24996u16,17616u16),(24999u16,15916u16),(25001u16,14353u16),
(25003u16,17038u16),(25004u16,14398u16),(25006u16,16883u16),(25010u16,23127u16),
(25014u16,19162u16),(25018u16,15703u16),(25022u16,14045u16),(25027u16,15141u16),
(25031u16,14013u16),(25032u16,23096u16),(25033u16,20310u16),(25034u16,19563u16),
(25035u16,16884u16),(25062u16,15350u16),(25074u16,21759u16),(25078u16,15956u16),
(25079u16,23532u16),(25080u16,23141u16),(25082u16,21808u16),(25084u16,14926u16),
(25087u16,20318u16),(25088u16,16147u16),(25095u16,15727u16),(25096u16,14627u16),
(25098u16,16885u16),(25100u16,18614u16),(25101u16,18526u16),(25102u16,20287u16),
(25104u16,18232u16),(25105u16,18923u16),(25106u16,14437u16),(25110u16,23343u16),
(25114u16,21956u16),(25119u16,15134u16),(25121u16,14046u16),(25130u16,21019u16),
(25134u16,16467u16),(25136u16,20895u16),(25137u16,23739u16),(25140u16,15742u16),
(25142u16,23309u16),(25150u16,16127u16),(25151u16,17209u16),(25152u16,18357u16),
(25153u16,22728u16),(25159u16,18176u16),(25160u16,23310u16),(25161u16,17649u16),
(25163u16,18527u16),(25165u16,20811u16),(25171u16,22397u16),(25176u16,22410u16),
(25198u16,17617u16),(25201u16,15171u16),(25206u16,17581u16),(25209u16,17650u16),
(25212u16,18994u16),(25215u16,18730u16),(25216u16,15197u16),(25220u16,22037u16),
(25225u16,14373u16),(25226u16,22589u16),(25233u16,19163u16),(25234u16,18036u16),
(25237u16,22580u16),(25239u16,22982u16),(25240u16,21020u16),(25243u16,22761u16),
(25259u16,22904u16),(25265u16,22762u16),(25269u16,20834u16),(25273u16,16663u16),
(25276u16,18972u16),(25277u16,22181u16),(25282u16,17632u16),(25287u16,16886u16),
(25288u16,15510u16),(25289u16,16090u16),(25292u16,17074u16),(25293u16,17053u16),
(25295u16,15352u16),(25296u16,14781u16),(25298u16,14217u16),(25299u16,21957u16),
(25300u16,17096u16),(25302u16,22398u16),(25303u16,19748u16),(25304u16,14927u16),
(25305u16,21265u16),(25307u16,22038u16),(25308u16,17235u16),(25324u16,14757u16),
(25325u16,18767u16),(25326u16,15342u16),(25327u16,21460u16),(25329u16,14617u16),
(25331u16,14990u16),(25335u16,14559u16),(25342u16,18721u16),(25343u16,15353u16),
(25345u16,21570u16),(25351u16,21571u16),(25353u16,18951u16),(25361u16,15766u16),
(25387u16,21384u16),(25391u16,21606u16),(25402u16,21051u16),(25403u16,19326u16),
(25405u16,16649u16),(25406u16,23168u16),(25417u16,21776u16),(25420u16,22709u16),
(25423u16,15378u16),(25424u16,19325u16),(25429u16,22763u16),(25447u16,17458u16),
(25448u16,17820u16),(25454u16,14218u16),(25458u16,14991u16),(25463u16,22008u16),
(25466u16,15379u16),(25467u16,15511u16),(25471u16,18037u16),(25475u16,18358u16),
(25480u16,18528u16),(25481u16,15767u16),(25484u16,20685u16),(25490u16,17236u16),
(25494u16,18995u16),(25496u16,14977u16),(25499u16,14773u16),(25504u16,16106u16),
(25505u16,21840u16),(25506u16,22529u16),(25509u16,21035u16),(25511u16,14618u16),
(25512u16,22182u16),(25513u16,19178u16),(25514u16,21219u16),(25536u16,14014u16),
(25540u16,20126u16),(25542u16,15111u16),(25551u16,16873u16),(25552u16,21196u16),
(25558u16,20306u16),(25562u16,19127u16),(25563u16,23486u16),(25569u16,18941u16),
(25581u16,14354u16),(25582u16,23693u16),(25588u16,20066u16),(25590u16,19105u16),
(25591u16,17981u16),(25613u16,18398u16),(25615u16,17054u16),(25620u16,18359u16),
(25622u16,19749u16),(25623u16,15768u16),(25628u16,18529u16),(25634u16,21607u16),
(25644u16,17075u16),(25645u16,22534u16),(25658u16,23700u16),(25662u16,21777u16),
(25688u16,20860u16),(25696u16,22171u16),(25705u16,16629u16),(25711u16,21572u16),
(25720u16,16839u16),(25721u16,16840u16),(25722u16,21036u16),(25736u16,16291u16),
(25745u16,22558u16),(25746u16,17969u16),(25747u16,19750u16),(25754u16,15506u16),
(25758u16,15728u16),(25764u16,21989u16),(25765u16,17097u16),(25771u16,16887u16),
(25773u16,22590u16),(25774u16,22176u16),(25776u16,21783u16),(25778u16,17055u16),
(25787u16,15696u16),(25793u16,19687u16),(25796u16,16292u16),(25797u16,21971u16),
(25799u16,22556u16),(25802u16,14355u16),(25805u16,21220u16),(25806u16,14399u16),
(25810u16,15156u16),(25812u16,15704u16),(25816u16,17286u16),(25818u16,14219u16),
(25825u16,15743u16),(25826u16,22412u16),(25829u16,16081u16),(25830u16,21800u16),
(25831u16,14220u16),(25836u16,20319u16),(25842u16,21958u16),(25844u16,23475u16),
(25850u16,22591u16),(25854u16,19751u16),(25856u16,17076u16),(25860u16,22559u16),
(25880u16,19128u16),(25885u16,18223u16),(25891u16,16148u16),(25898u16,14795u16),
(25899u16,23476u16),(25900u16,16082u16),(25903u16,21573u16),(25910u16,18530u16),
(25911u16,14560u16),(25912u16,20127u16),(25913u16,14194u16),(25915u16,14619u16),
(25918u16,17210u16),(25919u16,21052u16),(25925u16,14561u16),(25928u16,23554u16),
(25933u16,18038u16),(25934u16,14796u16),(25935u16,17039u16),(25937u16,14928u16),
(25942u16,19564u16),(25943u16,22713u16),(25950u16,21821u16),(25954u16,14047u16),
(25955u16,17959u16),(25958u16,15901u16),(25964u16,14400u16),(25965u16,19129u16),
(25970u16,14562u16),(25972u16,21053u16),(25973u16,20861u16),(25975u16,17582u16),
(25976u16,18531u16),(25982u16,18177u16),(25986u16,16261u16),(25987u16,22747u16),
(25989u16,23555u16),(25991u16,16909u16),(25996u16,17781u16),(26000u16,17651u16),
(26001u16,17077u16),(26007u16,15929u16),(26009u16,16334u16),(26011u16,14590u16),
(26012u16,17821u16),(26015u16,21653u16),(26017u16,18959u16),(26020u16,15142u16),
(26021u16,21959u16),(26023u16,17583u16),(26027u16,20652u16),(26028u16,21809u16),
(26031u16,17822u16),(26032u16,18785u16),(26039u16,15683u16),(26041u16,17211u16),
(26044u16,19153u16),(26045u16,18746u16),(26049u16,17212u16),(26053u16,16128u16),
(26059u16,18178u16),(26060u16,21054u16),(26063u16,21258u16),(26066u16,16453u16),
(26071u16,15198u16),(26080u16,16888u16),(26083u16,15199u16),(26085u16,20502u16),
(26086u16,15684u16),(26088u16,21574u16),(26089u16,21221u16),(26092u16,18591u16),
(26093u16,19934u16),(26097u16,22944u16),(26100u16,19912u16),(26106u16,19723u16),
(26107u16,17040u16),(26108u16,17041u16),(26109u16,15902u16),(26111u16,19565u16),
(26118u16,14599u16),(26119u16,18731u16),(26121u16,17213u16),(26122u16,23311u16),
(26124u16,21822u16),(26126u16,16820u16),(26127u16,23346u16),(26128u16,17618u16),
(26129u16,15157u16),(26131u16,19307u16),(26132u16,18159u16),(26133u16,23713u16),
(26142u16,17406u16),(26143u16,18233u16),(26144u16,19492u16),(26149u16,22215u16),
(26151u16,16685u16),(26152u16,20653u16),(26157u16,18360u16),(26159u16,18747u16),
(26160u16,22927u16),(26161u16,19935u16),(26164u16,16874u16),(26166u16,21823u16),
(26170u16,17407u16),(26171u16,18978u16),(26177u16,21222u16),(26178u16,18748u16),
(26179u16,23509u16),(26180u16,23510u16),(26185u16,21608u16),(26187u16,21609u16),
(26191u16,18952u16),(26201u16,21434u16),(26203u16,23142u16),(26205u16,21399u16),
(26206u16,23740u16),(26207u16,18234u16),(26212u16,19566u16),(26213u16,23488u16),
(26214u16,23533u16),(26215u16,23312u16),(26216u16,18786u16),(26217u16,16650u16),
(26219u16,22413u16),(26222u16,17422u16),(26223u16,14401u16),(26227u16,18160u16),
(26228u16,22016u16),(26230u16,21055u16),(26231u16,15007u16),(26232u16,21056u16),
(26234u16,21575u16),(26244u16,23685u16),(26247u16,13977u16),(26248u16,23682u16),
(26249u16,23694u16),(26254u16,19493u16),(26256u16,20094u16),(26257u16,18039u16),
(26262u16,15371u16),(26263u16,18967u16),(26264u16,19130u16),(26269u16,16821u16),
(26272u16,14563u16),(26274u16,21824u16),(26283u16,20668u16),(26286u16,16841u16),
(26290u16,20686u16),(26291u16,23296u16),(26292u16,22781u16),(26297u16,18216u16),
(26299u16,14402u16),(26302u16,15903u16),(26308u16,19480u16),(26310u16,16140u16),
(26311u16,15705u16),(26313u16,23556u16),(26326u16,18987u16),(26329u16,18040u16),
(26332u16,19753u16),(26333u16,22782u16),(26336u16,14764u16),(26342u16,23741u16),
(26352u16,19721u16),(26354u16,14591u16),(26355u16,19529u16),(26356u16,14403u16),
(26359u16,14032u16),(26360u16,18041u16),(26361u16,21224u16),(26362u16,21223u16),
(26364u16,16651u16),(26366u16,21459u16),(26367u16,22025u16),(26368u16,22179u16),
(26371u16,23534u16),(26376u16,20082u16),(26377u16,20128u16),(26379u16,17634u16),
(26381u16,17440u16),(26388u16,17858u16),(26389u16,21654u16),(26391u16,16094u16),
(26395u16,16673u16),(26397u16,21225u16),(26398u16,15296u16),(26399u16,15297u16),
(26406u16,16867u16),(26407u16,16317u16),(26408u16,16857u16),(26410u16,17022u16),
(26411u16,16664u16),(26412u16,17451u16),(26413u16,21801u16),(26414u16,22219u16),
(26417u16,21400u16),(26420u16,17056u16),(26422u16,22399u16),(26426u16,15000u16),
(26429u16,23669u16),(26438u16,14015u16),(26441u16,17975u16),(26446u16,16496u16),
(26447u16,23111u16),(26448u16,20812u16),(26449u16,22164u16),(26451u16,22790u16),
(26454u16,20687u16),(26460u16,15930u16),(26462u16,15298u16),(26463u16,18389u16),
(26477u16,22983u16),(26479u16,17237u16),(26480u16,14244u16),(26481u16,15917u16),
(26483u16,16875u16),(26485u16,20835u16),(26487u16,22592u16),(26491u16,15563u16),
(26494u16,18405u16),(26495u16,22604u16),(26503u16,17652u16),(26505u16,19724u16),
(26507u16,17214u16),(26511u16,15382u16),(26512u16,18161u16),(26515u16,15931u16),
(26517u16,22380u16),(26519u16,16524u16),(26522u16,16686u16),(26524u16,14628u16),
(26525u16,21576u16),(26543u16,14564u16),(26544u16,22739u16),(26547u16,21577u16),
(26550u16,13978u16),(26551u16,13979u16),(26552u16,14929u16),(26558u16,18749u16),
(26564u16,17408u16),(26575u16,17253u16),(26576u16,16842u16),(26577u16,14048u16),
(26578u16,22376u16),(26579u16,19373u16),(26580u16,20130u16),(26586u16,20131u16),
(26589u16,22414u16),(26601u16,14930u16),(26604u16,14016u16),(26607u16,13980u16),
(26608u16,15501u16),(26609u16,21401u16),(26611u16,16454u16),(26612u16,18750u16),
(26613u16,21848u16),(26614u16,17823u16),(26619u16,17824u16),(26622u16,21057u16),
(26642u16,18592u16),(26643u16,20896u16),(26646u16,18042u16),(26647u16,16477u16),
(26657u16,14797u16),(26658u16,17254u16),(26666u16,21402u16),(26671u16,19936u16),
(26680u16,23108u16),(26681u16,15143u16),(26684u16,14356u16),(26685u16,20813u16),
(26688u16,14245u16),(26689u16,22984u16),(26690u16,14438u16),(26691u16,15769u16),
(26696u16,18953u16),(26702u16,21643u16),(26704u16,15918u16),(26705u16,18000u16),
(26707u16,23489u16),(26708u16,15343u16),(26733u16,21610u16),(26742u16,22565u16),
(26751u16,14017u16),(26753u16,16112u16),(26757u16,16687u16),(26767u16,14592u16),
(26771u16,20814u16),(26772u16,22353u16),(26775u16,14404u16),(26781u16,21226u16),
(26783u16,23557u16),(26785u16,19706u16),(26786u16,22039u16),(26791u16,19567u16),
(26792u16,16497u16),(26797u16,17825u16),(26799u16,21197u16),(26800u16,14439u16),
(26801u16,14600u16),(26803u16,18361u16),(26805u16,17274u16),(26806u16,17023u16),
(26820u16,15300u16),(26821u16,17409u16),(26825u16,16711u16),(26827u16,15299u16),
(26829u16,14601u16),(26834u16,17459u16),(26837u16,21272u16),(26839u16,21227u16),
(26840u16,15135u16),(26842u16,17635u16),(26847u16,15919u16),(26848u16,15729u16),
(26855u16,20663u16),(26856u16,14536u16),(26862u16,17976u16),(26866u16,18043u16),
(26873u16,15866u16),(26874u16,14743u16),(26880u16,19707u16),(26885u16,20320u16),
(26893u16,18768u16),(26894u16,22183u16),(26898u16,22136u16),(26919u16,16822u16),
(26928u16,19106u16),(26941u16,19328u16),(26943u16,22216u16),(26954u16,19132u16),
(26963u16,22898u16),(26964u16,18204u16),(26965u16,22400u16),(26967u16,14236u16),
(26969u16,16889u16),(26970u16,22137u16),(26974u16,16484u16),(26976u16,15383u16),
(26977u16,20133u16),(26978u16,20134u16),(26979u16,17024u16),(26984u16,21058u16),
(26987u16,21454u16),(26989u16,19181u16),(26990u16,20836u16),(26991u16,18593u16),
(26997u16,15136u16),(26999u16,23097u16),(27000u16,22184u16),(27001u16,19494u16),
(27029u16,19885u16),(27035u16,21611u16),(27036u16,17215u16),(27045u16,23511u16),
(27047u16,17653u16),(27054u16,19495u16),(27060u16,16455u16),(27067u16,22535u16),
(27073u16,14565u16),(27075u16,17078u16),(27083u16,14931u16),(27084u16,22572u16),
(27085u16,21825u16),(27088u16,14782u16),(27112u16,14735u16),(27114u16,14195u16),
(27131u16,15112u16),(27133u16,21228u16),(27135u16,15144u16),(27138u16,18942u16),
(27146u16,17259u16),(27153u16,16113u16),(27155u16,16442u16),(27159u16,20837u16),
(27161u16,22791u16),(27166u16,22185u16),(27167u16,20688u16),(27169u16,16843u16),
(27171u16,19133u16),(27189u16,22138u16),(27192u16,17057u16),(27193u16,18532u16),
(27194u16,23367u16),(27197u16,21435u16),(27204u16,14049u16),(27208u16,19755u16),
(27211u16,14798u16),(27218u16,19943u16),(27219u16,18594u16),(27224u16,15130u16),
(27225u16,15947u16),(27231u16,15301u16),(27233u16,18001u16),(27243u16,23549u16),
(27264u16,15685u16),(27268u16,14357u16),(27273u16,21059u16),(27277u16,19164u16),
(27278u16,15158u16),(27287u16,17287u16),(27292u16,23535u16),(27298u16,14249u16),
(27299u16,20689u16),(27315u16,17782u16),(27323u16,22962u16),(27330u16,15867u16),
(27331u16,15001u16),(27347u16,16293u16),(27354u16,16129u16),(27355u16,21453u16),
(27382u16,23128u16),(27387u16,19096u16),(27396u16,16072u16),(27402u16,14992u16),
(27404u16,20690u16),(27410u16,16073u16),(27414u16,16083u16),(27424u16,23721u16),
(27425u16,21768u16),(27427u16,23714u16),(27442u16,19871u16),(27450u16,15302u16),
(27453u16,23722u16),(27454u16,14744u16),(27462u16,23723u16),(27463u16,23131u16),
(27468u16,13981u16),(27470u16,22522u16),(27472u16,14932u16),(27487u16,19287u16),
(27489u16,23487u16),(27490u16,21578u16),(27491u16,21060u16),(27492u16,21769u16),
(27493u16,17423u16),(27494u16,16890u16),(27498u16,19729u16),(27506u16,18343u16),
(27511u16,16141u16),(27512u16,15008u16),(27515u16,17826u16),(27519u16,16864u16),
(27523u16,18979u16),(27524u16,21612u16),(27526u16,22546u16),(27529u16,18595u16),
(27530u16,18533u16),(27542u16,18769u16),(27544u16,20664u16),(27550u16,19944u16),
(27566u16,16262u16),(27567u16,17783u16),(27570u16,18217u16),(27573u16,15686u16),
(27575u16,20295u16),(27578u16,17970u16),(27580u16,14000u16),(27583u16,20897u16),
(27585u16,23690u16),(27589u16,20321u16),(27590u16,14933u16),(27595u16,16891u16),
(27597u16,16844u16),(27599u16,16688u16),(27602u16,15889u16),(27603u16,20265u16),
(27604u16,17654u16),(27606u16,17655u16),(27607u16,17656u16),(27608u16,17657u16),
(27611u16,16845u16),(27627u16,23313u16),(27628u16,14934u16),(27656u16,20898u16),
(27663u16,18916u16),(27665u16,17042u16),(27667u16,16701u16),(27683u16,15303u16),
(27700u16,18534u16),(27703u16,17793u16),(27704u16,19496u16),(27710u16,17275u16),
(27712u16,21061u16),(27713u16,21455u16),(27714u16,14935u16),(27726u16,17276u16),
(27728u16,18162u16),(27733u16,17960u16),(27735u16,22945u16),(27738u16,19568u16),
(27741u16,19288u16),(27742u16,23356u16),(27743u16,14171u16),(27744u16,21579u16),
(27752u16,14606u16),(27754u16,19725u16),(27757u16,19530u16),(27760u16,22547u16),
(27762u16,15172u16),(27766u16,17006u16),(27770u16,14374u16),(27773u16,15304u16),
(27774u16,17619u16),(27777u16,18809u16),(27778u16,15305u16),(27779u16,19675u16),
(27781u16,20067u16),(27782u16,22985u16),(27783u16,19329u16),(27784u16,22381u16),
(27788u16,15904u16),(27792u16,16858u16),(27794u16,16865u16),(27795u16,15718u16),
(27796u16,16712u16),(27797u16,17014u16),(27798u16,22223u16),(27801u16,17827u16),
(27802u16,21580u16),(27803u16,22714u16),(27819u16,16665u16),(27822u16,20838u16),
(27827u16,22928u16),(27832u16,17658u16),(27833u16,20135u16),(27835u16,22354u16),
(27836u16,18362u16),(27837u16,14566u16),(27838u16,21997u16),(27839u16,19330u16),
(27841u16,23512u16),(27842u16,23277u16),(27844u16,18205u16),(27849u16,21972u16),
(27850u16,17058u16),(27852u16,22913u16),(27859u16,23357u16),(27861u16,17281u16),
(27863u16,17828u16),(27867u16,17277u16),(27873u16,22765u16),(27874u16,22593u16),
(27875u16,20307u16),(27877u16,15575u16),(27880u16,21403u16),(27883u16,23143u16),
(27886u16,17079u16),(27887u16,17043u16),(27888u16,22548u16),(27891u16,19497u16),
(27915u16,19134u16),(27916u16,16257u16),(27921u16,17424u16),(27927u16,18344u16),
(27929u16,18535u16),(27931u16,16061u16),(27934u16,15920u16),(27941u16,21613u16),
(27943u16,20136u16),(27945u16,18206u16),(27946u16,23358u16),(27954u16,21404u16),
(27957u16,18596u16),(27958u16,23710u16),(27960u16,14765u16),(27961u16,20068u16),
(27963u16,23497u16),(27965u16,23726u16),(27966u16,22594u16),(27969u16,16456u16),
(27993u16,21021u16),(27994u16,21436u16),(27996u16,17784u16),(28003u16,19708u16),
(28006u16,22766u16),(28009u16,23314u16),(28010u16,16095u16),(28012u16,16498u16),
(28014u16,17584u16),(28020u16,19872u16),(28023u16,23098u16),(28024u16,22382u16),
(28025u16,23169u16),(28031u16,22715u16),(28037u16,19363u16),(28039u16,14405u16),
(28040u16,18363u16),(28041u16,18224u16),(28044u16,19886u16),(28045u16,23558u16),
(28046u16,19331u16),(28049u16,18390u16),(28051u16,19332u16),(28053u16,22026u16),
(28079u16,18988u16),(28082u16,18996u16),(28085u16,22963u16),(28096u16,21062u16),
(28099u16,14993u16),(28100u16,22355u16),(28101u16,18163u16),(28102u16,23559u16),
(28103u16,15306u16),(28107u16,16525u16),(28111u16,23315u16),(28113u16,18580u16),
(28120u16,15868u16),(28121u16,21273u16),(28122u16,16443u16),(28126u16,18406u16),
(28129u16,15706u16),(28136u16,21063u16),(28138u16,16472u16),(28139u16,20301u16),
(28142u16,23536u16),(28145u16,18907u16),(28147u16,18597u16),(28149u16,19333u16),
(28151u16,23347u16),(28152u16,22017u16),(28153u16,19179u16),(28154u16,21973u16),
(28155u16,21998u16),(28183u16,17977u16),(28185u16,23490u16),(28186u16,20839u16),
(28187u16,14050u16),(28191u16,21064u16),(28192u16,14221u16),(28193u16,15869u16),
(28195u16,17829u16),(28196u16,17098u16),(28197u16,18943u16),(28198u16,19695u16),
(28203u16,18207u16),(28204u16,22345u16),(28205u16,20095u16),(28207u16,22986u16),
(28210u16,18179u16),(28212u16,14033u16),(28214u16,19498u16),(28216u16,20138u16),
(28218u16,16876u16),(28220u16,17025u16),(28221u16,20815u16),(28222u16,23348u16),
(28227u16,17238u16),(28228u16,17026u16),(28234u16,21405u16),(28237u16,15687u16),
(28246u16,23316u16),(28248u16,18002u16),(28251u16,15707u16),(28252u16,18770u16),
(28254u16,21065u16),(28255u16,23513u16),(28263u16,19887u16),(28267u16,22186u16),
(28270u16,20485u16),(28271u16,22538u16),(28274u16,20069u16),(28275u16,15384u16),
(28282u16,17425u16),(28304u16,20070u16),(28310u16,21437u16),(28316u16,16457u16),
(28317u16,14936u16),(28319u16,16823u16),(28322u16,20503u16),(28325u16,17585u16),
(28330u16,14537u16),(28331u16,19679u16),(28335u16,18364u16),(28337u16,21614u16),
(28342u16,19888u16),(28346u16,15577u16),(28354u16,17216u16),(28356u16,21826u16),
(28357u16,16719u16),(28361u16,23514u16),(28363u16,20633u16),(28364u16,21960u16),
(28366u16,23278u16),(28369u16,23498u16),(28371u16,20816u16),(28372u16,15870u16),
(28399u16,22027u16),(28404u16,20862u16),(28408u16,23317u16),(28414u16,14602u16),
(28415u16,16652u16),(28417u16,19154u16),(28418u16,22792u16),(28422u16,22377u16),
(28431u16,16444u16),(28433u16,14196u16),(28436u16,19334u16),(28437u16,21229u16),
(28448u16,16639u16),(28450u16,22946u16),(28451u16,16149u16),(28459u16,16653u16),
(28460u16,21581u16),(28465u16,18536u16),(28466u16,21827u16),(28472u16,21029u16),
(28479u16,20691u16),(28481u16,19499u16),(28497u16,17099u16),(28500u16,14375u16),
(28503u16,21657u16),(28504u16,17080u16),(28506u16,18581u16),(28507u16,20669u16),
(28510u16,16294u16),(28511u16,18164u16),(28514u16,23515u16),(28516u16,20275u16),
(28525u16,15708u16),(28526u16,21230u16),(28528u16,15002u16),(28538u16,20665u16),
(28540u16,15921u16),(28541u16,17426u16),(28542u16,16516u16),(28545u16,17982u16),
(28548u16,21760u16),(28552u16,21990u16),(28557u16,21406u16),(28558u16,22722u16),
(28560u16,19945u16),(28564u16,23318u16),(28567u16,14018u16),(28579u16,22947u16),
(28580u16,22557u16),(28583u16,16285u16),(28590u16,23537u16),(28591u16,21784u16),
(28593u16,20899u16),(28595u16,19569u16),(28601u16,15709u16),(28606u16,15697u16),
(28608u16,14358u16),(28609u16,22415u16),(28610u16,16263u16),(28611u16,15541u16),
(28618u16,19531u16),(28629u16,18720u16),(28634u16,19500u16),(28639u16,21198u16),
(28640u16,23319u16),(28641u16,20236u16),(28644u16,15871u16),(28649u16,23320u16),
(28651u16,16084u16),(28652u16,21438u16),(28655u16,22416u16),(28657u16,17785u16),
(28670u16,16130u16),(28673u16,19135u16),(28677u16,23279u16),(28678u16,15890u16),
(28681u16,17830u16),(28683u16,18908u16),(28687u16,16458u16),(28689u16,22783u16),
(28693u16,17786u16),(28696u16,16295u16),(28698u16,22948u16),(28699u16,19501u16),
(28700u16,20288u16),(28701u16,16142u16),(28702u16,21066u16),(28703u16,18365u16),
(28707u16,23099u16),(28711u16,16318u16),(28712u16,16323u16),(28719u16,19502u16),
(28727u16,20468u16),(28734u16,16074u16),(28748u16,14745u16),(28752u16,23280u16),
(28753u16,18413u16),(28760u16,22523u16),(28765u16,23321u16),(28771u16,16654u16),
(28779u16,23368u16),(28784u16,23538u16),(28792u16,14937u16),(28796u16,20654u16),
(28797u16,20817u16),(28805u16,14406u16),(28810u16,22332u16),(28814u16,19375u16),
(28818u16,22139u16),(28824u16,23715u16),(28825u16,20634u16),(28826u16,14766u16),
(28833u16,21067u16),(28836u16,18366u16),(28843u16,23144u16),(28844u16,14222u16),
(28845u16,22524u16),(28847u16,23281u16),(28851u16,17410u16),(28855u16,21407u16),
(28856u16,20655u16),(28857u16,21030u16),(28872u16,16258u16),(28875u16,23701u16),
(28879u16,19666u16),(28888u16,23359u16),(28889u16,16062u16),(28893u16,21461u16),
(28895u16,19336u16),(28913u16,14407u16),(28921u16,22723u16),(28925u16,17460u16),
(28932u16,23677u16),(28937u16,19169u16),(28940u16,21439u16),(28953u16,17239u16),
(28954u16,17620u16),(28958u16,15905u16),(28961u16,16892u16),(28966u16,22140u16),
(28976u16,19376u16),(28982u16,19337u16),(28999u16,23695u16),(29001u16,16246u16),
(29002u16,23686u16),(29004u16,23516u16),(29006u16,20996u16),(29008u16,19503u16),
(29014u16,15373u16),(29017u16,19338u16),(29020u16,19937u16),(29022u16,17971u16),
(29028u16,16689u16),(29029u16,23491u16),(29030u16,23670u16),(29031u16,21231u16),
(29033u16,17260u16),(29036u16,19136u16),(29038u16,20635u16),(29053u16,18180u16),
(29060u16,18771u16),(29065u16,19946u16),(29066u16,20053u16),(29071u16,23678u16),
(29074u16,23282u16),(29076u16,19889u16),(29081u16,23742u16),(29087u16,18582u16),
(29090u16,17461u16),(29100u16,19667u16),(29105u16,19365u16),(29113u16,23743u16),
(29114u16,23744u16),(29118u16,22356u16),(29121u16,19482u16),(29123u16,19340u16),
(29128u16,15948u16),(29129u16,15906u16),(29134u16,16335u16),(29136u16,16517u16),
(29138u16,18367u16),(29140u16,17261u16),(29141u16,19341u16),(29151u16,19504u16),
(29157u16,21232u16),(29158u16,21785u16),(29159u16,18537u16),(29165u16,22158u16),
(29166u16,18225u16),(29179u16,23679u16),(29180u16,18787u16),(29182u16,15872u16),
(29183u16,19757u16),(29184u16,23135u16),(29190u16,22784u16),(29200u16,16296u16),
(29211u16,16075u16),(29226u16,21233u16),(29228u16,22595u16),(29229u16,20824u16),
(29232u16,20071u16),(29234u16,20096u16),(29237u16,20656u16),(29238u16,17586u16),
(29242u16,19107u16),(29243u16,23656u16),(29245u16,18003u16),(29246u16,20444u16),
(29248u16,18004u16),(29254u16,20692u16),(29255u16,22729u16),(29256u16,22605u16),
(29260u16,22716u16),(29266u16,22009u16),(29272u16,15891u16),(29273u16,18924u16),
(29275u16,19913u16),(29277u16,17787u16),(29279u16,16846u16),(29281u16,16847u16),
(29282u16,16324u16),(29287u16,16859u16),(29289u16,17015u16),(29298u16,18024u16),
(29305u16,22584u16),(29309u16,14363u16),(29312u16,18044u16),(29313u16,16499u16),
(29346u16,15892u16),(29351u16,23745u16),(29356u16,14364u16),(29359u16,17278u16),
(29376u16,18005u16),(29378u16,14767u16),(29380u16,20863u16),(29390u16,18973u16),
(29392u16,23322u16),(29399u16,14938u16),(29401u16,20840u16),(29409u16,14799u16),
(29417u16,18538u16),(29432u16,16500u16),(29433u16,23170u16),(29436u16,16096u16),
(29437u16,22717u16),(29450u16,19532u16),(29462u16,21828u16),(29467u16,16702u16),
(29468u16,18751u16),(29469u16,21266u16),(29477u16,19734u16),(29481u16,18235u16),
(29482u16,20841u16),(29483u16,16877u16),(29494u16,20237u16),(29495u16,20238u16),
(29502u16,23499u16),(29503u16,20072u16),(29508u16,19676u16),(29509u16,17831u16),
(29520u16,20694u16),(29522u16,19668u16),(29527u16,14996u16),(29544u16,15893u16),
(29546u16,23539u16),(29552u16,19505u16),(29554u16,23547u16),(29557u16,16265u16),
(29560u16,18539u16),(29562u16,15698u16),(29563u16,23129u16),(29572u16,23145u16),
(29574u16,20636u16),(29575u16,18402u16),(29577u16,19677u16),(29579u16,19726u16),
(29582u16,21068u16),(29588u16,21974u16),(29590u16,14939u16),(29591u16,19914u16),
(29592u16,15307u16),(29599u16,17044u16),(29607u16,20276u16),(29609u16,19709u16),
(29613u16,17788u16),(29618u16,16273u16),(29619u16,15744u16),(29625u16,23146u16),
(29632u16,17059u16),(29634u16,13982u16),(29641u16,17045u16),(29642u16,17961u16),
(29644u16,22914u16),(29645u16,21615u16),(29647u16,14001u16),(29654u16,14768u16),
(29657u16,14620u16),(29661u16,23671u16),(29662u16,16063u16),(29664u16,21408u16),
(29667u16,18598u16),(29668u16,17427u16),(29669u16,20445u16),(29670u16,23117u16),
(29673u16,23283u16),(29674u16,15113u16),(29677u16,17081u16),(29687u16,16893u16),
(29689u16,18236u16),(29693u16,21069u16),(29694u16,23147u16),(29697u16,18181u16),
(29699u16,14940u16),(29701u16,16097u16),(29702u16,16501u16),(29703u16,18540u16),
(29705u16,16459u16),(29715u16,19710u16),(29723u16,22383u16),(29728u16,20997u16),
(29729u16,18583u16),(29730u16,22417u16),(29733u16,23323u16),(29734u16,15308u16),
(29736u16,14603u16),(29738u16,15309u16),(29739u16,17462u16),(29740u16,19711u16),
(29742u16,21274u16),(29743u16,14746u16),(29744u16,19377u16),(29747u16,16526u16),
(29748u16,15159u16),(29749u16,17660u16),(29750u16,22596u16),(29752u16,22418u16),
(29754u16,17282u16),(29759u16,23349u16),(29760u16,19915u16),(29761u16,16848u16),
(29763u16,22217u16),(29764u16,18182u16),(29771u16,20097u16),(29781u16,22929u16),
(29783u16,20073u16),(29785u16,15522u16),(29786u16,23324u16),(29787u16,19507u16),
(29788u16,20240u16),(29790u16,18045u16),(29791u16,18717u16),(29792u16,16460u16),
(29794u16,19890u16),(29796u16,19758u16),(29797u16,19680u16),(29800u16,21616u16),
(29801u16,23284u16),(29802u16,16630u16),(29807u16,16098u16),(29822u16,15145u16),
(29826u16,15310u16),(29827u16,16502u16),(29831u16,18183u16),(29833u16,16247u16),
(29835u16,20695u16),(29848u16,16518u16),(29852u16,23517u16),(29854u16,17060u16),
(29855u16,14408u16),(29857u16,21617u16),(29859u16,15311u16),(29861u16,14409u16),
(29863u16,17288u16),(29864u16,21786u16),(29866u16,21234u16),(29872u16,23492u16),
(29874u16,18541u16),(29877u16,19290u16),(29881u16,18584u16),(29885u16,18017u16),
(29887u16,18184u16),(29894u16,21644u16),(29898u16,14410u16),(29903u16,16319u16),
(29908u16,19509u16),(29912u16,14747u16),(29914u16,21787u16),(29916u16,14629u16),
(29920u16,23325u16),(29922u16,22793u16),(29923u16,22606u16),(29926u16,19696u16),
(29934u16,19688u16),(29943u16,20637u16),(29953u16,17411u16),(29956u16,14365u16),
(29969u16,21462u16),(29973u16,19689u16),(29976u16,14051u16),(29978u16,18909u16),
(29979u16,21999u16),(29983u16,18025u16),(29987u16,17962u16),(29989u16,18026u16),
(29990u16,18368u16),(29992u16,19891u16),(29995u16,17428u16),(29996u16,19892u16),
(30000u16,20998u16),(30001u16,20241u16),(30002u16,14158u16),(30003u16,18788u16),
(30007u16,15386u16),(30008u16,20999u16),(30010u16,21070u16),(30023u16,15125u16),
(30028u16,14538u16),(30031u16,19735u16),(30033u16,21000u16),(30035u16,15719u16),
(30036u16,17082u16),(30041u16,16461u16),(30043u16,21618u16),(30044u16,22204u16),
(30045u16,16894u16),(30050u16,22915u16),(30053u16,16107u16),(30054u16,23702u16),
(30058u16,17262u16),(30063u16,21440u16),(30064u16,20447u16),(30069u16,23369u16),
(30070u16,15730u16),(30072u16,15312u16),(30074u16,14172u16),(30079u16,15313u16),
(30086u16,14173u16),(30087u16,21409u16),(30090u16,22010u16),(30091u16,22916u16),
(30094u16,18370u16),(30095u16,18369u16),(30097u16,20322u16),(30109u16,17963u16),
(30117u16,14197u16),(30123u16,19310u16),(30129u16,22767u16),(30130u16,22905u16),
(30131u16,14052u16),(30133u16,20638u16),(30136u16,15699u16),(30137u16,21619u16),
(30140u16,15922u16),(30141u16,20842u16),(30142u16,21645u16),(30146u16,13983u16),
(30149u16,17412u16),(30151u16,21463u16),(30157u16,20448u16),(30162u16,19137u16),
(30164u16,22357u16),(30165u16,23716u16),(30168u16,15932u16),(30169u16,14411u16),
(30171u16,22567u16),(30178u16,16504u16),(30192u16,15710u16),(30194u16,16631u16),
(30196u16,22358u16),(30202u16,17661u16),(30204u16,14567u16),(30208u16,19155u16),
(30221u16,19138u16),(30233u16,18371u16),(30239u16,19681u16),(30240u16,21961u16),
(30241u16,21829u16),(30242u16,17083u16),(30244u16,16462u16),(30246u16,18542u16),
(30267u16,16445u16),(30274u16,16336u16),(30284u16,18968u16),(30286u16,14019u16),
(30290u16,20243u16),(30294u16,17289u16),(30305u16,22359u16),(30308u16,21022u16),
(30313u16,15958u16),(30316u16,18185u16),(30320u16,19690u16),(30322u16,21001u16),
(30328u16,14539u16),(30331u16,15949u16),(30332u16,17196u16),(30333u16,17255u16),
(30334u16,17256u16),(30340u16,20865u16),(30342u16,14198u16),(30343u16,23518u16),
(30350u16,14800u16),(30352u16,14568u16),(30355u16,23326u16),(30382u16,22906u16),
(30394u16,22187u16),(30399u16,16824u16),(30402u16,19916u16),(30403u16,17240u16),
(30406u16,17621u16),(30408u16,19510u16),(30410u16,20469u16),(30418u16,22971u16),
(30422u16,14199u16),(30427u16,18237u16),(30428u16,15873u16),(30430u16,20666u16),
(30431u16,16704u16),(30433u16,21620u16),(30435u16,14053u16),(30436u16,17084u16),
(30439u16,16297u16),(30446u16,16860u16),(30450u16,16703u16),(30452u16,21598u16),
(30456u16,18006u16),(30460u16,17085u16),(30462u16,18599u16),(30465u16,18238u16),
(30468u16,16713u16),(30472u16,22530u16),(30473u16,17027u16),(30475u16,14020u16),
(30494u16,21621u16),(30496u16,16714u16),(30505u16,23148u16),(30519u16,14994u16),
(30520u16,16849u16),(30522u16,21235u16),(30524u16,18954u16),(30528u16,21778u16),
(30541u16,23149u16),(30555u16,21071u16),(30561u16,18543u16),(30563u16,15894u16),
(30566u16,16861u16),(30571u16,22011u16),(30585u16,15874u16),(30590u16,14569u16),
(30591u16,19533u16),(30603u16,21622u16),(30609u16,16825u16),(30622u16,16655u16),
(30629u16,17398u16),(30636u16,18600u16),(30637u16,16337u16),(30640u16,14054u16),
(30643u16,15923u16),(30651u16,22000u16),(30652u16,14346u16),(30655u16,14941u16),
(30679u16,22159u16),(30683u16,16850u16),(30684u16,15177u16),(30690u16,18752u16),
(30691u16,20323u16),(30693u16,21582u16),(30697u16,14942u16),(30701u16,15688u16),
(30702u16,19730u16),(30703u16,14801u16),(30707u16,18165u16),(30722u16,17832u16),
(30738u16,17662u16),(30757u16,21583u16),(30758u16,21841u16),(30759u16,22384u16),
(30764u16,16529u16),(30770u16,22768u16),(30772u16,22597u16),(30789u16,15114u16),
(30799u16,19343u16),(30813u16,22141u16),(30827u16,16463u16),(30828u16,14412u16),
(30831u16,19344u16),(30844u16,17636u16),(30849u16,15314u16),(30855u16,21072u16),
(30860u16,16307u16),(30861u16,18989u16),(30862u16,18414u16),(30865u16,17663u16),
(30871u16,19712u16),(30883u16,14034u16),(30887u16,17386u16),(30889u16,18166u16),
(30906u16,23477u16),(30907u16,23478u16),(30908u16,16632u16),(30913u16,20639u16),
(30917u16,17217u16),(30922u16,16325u16),(30923u16,21770u16),(30926u16,14540u16),
(30928u16,17086u16),(30952u16,16633u16),(30956u16,14413u16),(30959u16,15315u16),
(30965u16,14021u16),(30971u16,17087u16),(30977u16,22142u16),(30990u16,22143u16),
(30998u16,19291u16),(31018u16,16131u16),(31019u16,16143u16),(31020u16,17088u16),
(31034u16,18753u16),(31038u16,17833u16),(31040u16,17834u16),(31041u16,15316u16),
(31047u16,15317u16),(31048u16,15318u16),(31049u16,21584u16),(31056u16,19917u16),
(31062u16,21236u16),(31063u16,21585u16),(31066u16,21237u16),(31067u16,14223u16),
(31068u16,23327u16),(31069u16,22205u16),(31070u16,18789u16),(31072u16,17835u16),
(31077u16,18007u16),(31080u16,22794u16),(31085u16,21199u16),(31098u16,15319u16),
(31103u16,16308u16),(31105u16,15160u16),(31117u16,23466u16),(31118u16,21073u16),
(31119u16,17441u16),(31121u16,19918u16),(31142u16,19156u16),(31143u16,23746u16),
(31146u16,18186u16),(31150u16,16286u16),(31153u16,15875u16),(31155u16,19139u16),
(31161u16,19919u16),(31165u16,15161u16),(31166u16,23467u16),(31167u16,15895u16),
(31168u16,18544u16),(31169u16,17836u16),(31177u16,17413u16),(31178u16,15507u16),
(31179u16,22188u16),(31185u16,14726u16),(31186u16,22144u16),(31189u16,17664u16),
(31192u16,17665u16),(31199u16,21238u16),(31204u16,22388u16),(31206u16,21623u16),
(31207u16,18980u16),(31209u16,21646u16),(31227u16,20450u16),(31232u16,23747u16),
(31237u16,18345u16),(31240u16,14022u16),(31243u16,21074u16),(31245u16,22145u16),
(31252u16,20514u16),(31255u16,22718u16),(31257u16,21599u16),(31258u16,22360u16),
(31260u16,16485u16),(31263u16,22897u16),(31264u16,21239u16),(31278u16,21275u16),
(31281u16,22389u16),(31286u16,19938u16),(31287u16,21600u16),(31291u16,15876u16),
(31292u16,13984u16),(31293u16,14541u16),(31295u16,14570u16),(31296u16,14593u16),
(31302u16,16862u16),(31305u16,22361u16),(31309u16,20866u16),(31310u16,19511u16),
(31319u16,18545u16),(31329u16,18021u16),(31330u16,19534u16),(31337u16,19682u16),
(31339u16,23479u16),(31344u16,19140u16),(31348u16,23160u16),(31350u16,14943u16),
(31353u16,14981u16),(31354u16,14621u16),(31357u16,21075u16),(31359u16,21975u16),
(31361u16,15910u16),(31364u16,21779u16),(31368u16,19856u16),(31378u16,21647u16),
(31379u16,21830u16),(31381u16,21240u16),(31384u16,14970u16),(31391u16,14978u16),
(31401u16,19697u16),(31402u16,19698u16),(31406u16,14982u16),(31407u16,19857u16),
(31418u16,15115u16),(31428u16,21788u16),(31429u16,15116u16),(31431u16,15933u16),
(31434u16,21023u16),(31435u16,16626u16),(31447u16,16878u16),(31449u16,21810u16),
(31453u16,17414u16),(31455u16,14414u16),(31456u16,20696u16),(31459u16,21441u16),
(31461u16,15924u16),(31466u16,18546u16),(31469u16,14035u16),(31471u16,15689u16),
(31478u16,14415u16),(31481u16,21426u16),(31482u16,22206u16),(31487u16,14023u16),
(31503u16,23353u16),(31505u16,18372u16),(31513u16,18028u16),(31515u16,20867u16),
(31518u16,22549u16),(31520u16,16627u16),(31526u16,17587u16),(31532u16,21200u16),
(31533u16,16274u16),(31545u16,18346u16),(31558u16,22917u16),(31561u16,15950u16),
(31563u16,15146u16),(31564u16,21002u16),(31565u16,18601u16),(31567u16,17269u16),
(31568u16,14769u16),(31569u16,22207u16),(31570u16,22568u16),(31572u16,15720u16),
(31574u16,21849u16),(31584u16,15126u16),(31596u16,18239u16),(31598u16,18046u16),
(31605u16,19346u16),(31613u16,19669u16),(31623u16,14200u16),(31627u16,21003u16),
(31631u16,20825u16),(31636u16,17061u16),(31637u16,15320u16),(31639u16,17964u16),
(31642u16,21771u16),(31645u16,14381u16),(31649u16,14748u16),(31661u16,21004u16),
(31665u16,18008u16),(31668u16,20670u16),(31672u16,20843u16),(31680u16,21024u16),
(31681u16,23519u16),(31684u16,17279u16),(31686u16,21005u16),(31687u16,22730u16),
(31689u16,22208u16),(31698u16,18772u16),(31712u16,18373u16),(31716u16,15896u16),
(31721u16,17837u16),(31751u16,21259u16),(31762u16,21789u16),(31774u16,15690u16),
(31777u16,14024u16),(31783u16,23520u16),(31786u16,20671u16),(31787u16,18374u16),
(31805u16,22001u16),(31806u16,16264u16),(31807u16,17588u16),(31811u16,16085u16),
(31820u16,21410u16),(31821u16,20868u16),(31840u16,16320u16),(31844u16,22002u16),
(31852u16,16505u16),(31859u16,17028u16),(31875u16,17666u16),(31881u16,17622u16),
(31890u16,16628u16),(31893u16,17062u16),(31895u16,21241u16),(31896u16,21031u16),
(31903u16,18391u16),(31909u16,21427u16),(31911u16,20697u16),(31918u16,16114u16),
(31921u16,16115u16),(31922u16,21791u16),(31923u16,14210u16),(31929u16,18547u16),
(31934u16,21076u16),(31946u16,23328u16),(31958u16,15731u16),(31966u16,17623u16),
(31967u16,21242u16),(31968u16,14174u16),(31975u16,16116u16),(31995u16,14542u16),
(31998u16,15117u16),(32000u16,15321u16),(32002u16,21411u16),(32004u16,19114u16),
(32005u16,23360u16),(32006u16,19920u16),(32007u16,23719u16),(32008u16,23493u16),
(32010u16,17007u16),(32011u16,17008u16),(32013u16,15486u16),(32016u16,15564u16),
(32020u16,18602u16),(32023u16,17838u16),(32024u16,14785u16),(32025u16,21586u16),
(32026u16,15173u16),(32027u16,17624u16),(32032u16,18375u16),(32033u16,17218u16),
(32034u16,18022u16),(32043u16,20640u16),(32044u16,21412u16),(32046u16,21802u16),
(32047u16,16446u16),(32048u16,18347u16),(32051u16,18790u16),(32053u16,20844u16),
(32057u16,18376u16),(32058u16,14055u16),(32066u16,21276u16),(32067u16,23150u16),
(32068u16,21243u16),(32069u16,14416u16),(32070u16,17089u16),(32080u16,14376u16),
(32094u16,14802u16),(32097u16,16064u16),(32098u16,23151u16),(32102u16,15174u16),
(32104u16,20289u16),(32106u16,20488u16),(32110u16,18047u16),(32113u16,22569u16),
(32114u16,17839u16),(32115u16,14175u16),(32118u16,21025u16),(32121u16,14366u16),
(32127u16,14944u16),(32142u16,21077u16),(32143u16,18548u16),(32147u16,14417u16),
(32156u16,21277u16),(32160u16,16309u16),(32162u16,21413u16),(32172u16,18549u16),
(32173u16,20246u16),(32177u16,14176u16),(32178u16,16674u16),(32180u16,21991u16),
(32181u16,21842u16),(32184u16,16473u16),(32186u16,15322u16),(32187u16,22525u16),
(32189u16,20657u16),(32190u16,16486u16),(32191u16,16715u16),(32199u16,22362u16),
(32202u16,15339u16),(32203u16,17667u16),(32214u16,18048u16),(32216u16,22964u16),
(32218u16,18187u16),(32221u16,21658u16),(32222u16,15691u16),(32224u16,22028u16),
(32225u16,17046u16),(32227u16,19347u16),(32232u16,22731u16),(32233u16,19713u16),
(32236u16,16716u16),(32239u16,20098u16),(32244u16,16248u16),(32251u16,22363u16),
(32265u16,21624u16),(32266u16,18997u16),(32277u16,19683u16),(32283u16,17063u16),
(32285u16,21625u16),(32286u16,23329u16),(32287u16,19873u16),(32289u16,20818u16),
(32291u16,23152u16),(32299u16,17463u16),(32302u16,22209u16),(32303u16,19349u16),
(32305u16,21278u16),(32311u16,16447u16),(32317u16,22172u16),(32318u16,20869u16),
(32321u16,17264u16),(32323u16,17637u16),(32326u16,16895u16),(32327u16,19858u16),
(32338u16,21464u16),(32340u16,21601u16),(32341u16,18188u16),(32350u16,19859u16),
(32353u16,18550u16),(32361u16,18732u16),(32362u16,23540u16),(32363u16,14543u16),
(32365u16,14367u16),(32368u16,21244u16),(32377u16,19311u16),(32380u16,14544u16),
(32386u16,21790u16),(32396u16,18392u16),(32399u16,21006u16),(32403u16,19512u16),
(32406u16,18218u16),(32408u16,21792u16),(32411u16,15897u16),(32412u16,16086u16),
(32566u16,17589u16),(32568u16,22987u16),(32570u16,14377u16),(32588u16,19097u16),
(32592u16,14749u16),(32596u16,16675u16),(32597u16,22949u16),(32618u16,21385u16),
(32619u16,14774u16),(32622u16,22364u16),(32624u16,17270u16),(32626u16,18049u16),
(32629u16,16690u16),(32631u16,22598u16),(32633u16,16506u16),(32645u16,15959u16),
(32648u16,15323u16),(32650u16,19142u16),(32652u16,14177u16),(32654u16,17029u16),
(32660u16,14571u16),(32666u16,16275u16),(32670u16,18551u16),(32676u16,14971u16),
(32680u16,18189u16),(32681u16,20324u16),(32690u16,23748u16),(32696u16,16507u16),
(32697u16,14211u16),(32701u16,19921u16),(32705u16,19691u16),(32709u16,18754u16),
(32714u16,20470u16),(32716u16,20471u16),(32718u16,16276u16),(32722u16,18722u16),
(32724u16,18009u16),(32725u16,23727u16),(32735u16,20870u16),(32736u16,22333u16),
(32737u16,17668u16),(32745u16,22732u16),(32747u16,19714u16),(32752u16,22950u16),
(32761u16,14803u16),(32764u16,20472u16),(32768u16,19860u16),(32769u16,16298u16),
(32771u16,14572u16),(32773u16,20641u16),(32774u16,15324u16),(32777u16,14945u16),
(32780u16,20452u16),(32784u16,15502u16),(32789u16,14418u16),(32791u16,16851u16),
(32792u16,19947u16),(32813u16,15325u16),(32819u16,20453u16),(32822u16,19108u16),
(32829u16,22531u16),(32831u16,14419u16),(32835u16,15711u16),(32838u16,16277u16),
(32842u16,16338u16),(32854u16,18336u16),(32856u16,17794u16),(32858u16,22334u16),
(32862u16,17009u16),(32879u16,16249u16),(32880u16,22173u16),(32882u16,18337u16),
(32883u16,19893u16),(32887u16,21602u16),(32893u16,22018u16),(32894u16,16321u16),
(32895u16,20286u16),(32900u16,20454u16),(32901u16,18585u16),(32902u16,17840u16),
(32903u16,21245u16),(32905u16,20266u16),(32907u16,16481u16),(32908u16,15326u16),
(32918u16,22146u16),(32923u16,22988u16),(32925u16,14025u16),(32929u16,14573u16),
(32930u16,21587u16),(32933u16,17669u16),(32937u16,14368u16),(32938u16,17219u16),
(32943u16,15178u16),(32945u16,14786u16),(32946u16,20267u16),(32948u16,23657u16),
(32954u16,22748u16),(32963u16,20099u16),(32964u16,21391u16),(32972u16,17241u16),
(32974u16,22550u16),(32986u16,17242u16),(32987u16,14159u16),(32990u16,22769u16),
(32993u16,23330u16),(32996u16,20277u16),(32997u16,18146u16),(33009u16,14770u16),
(33012u16,15925u16),(33016u16,23711u16),(33021u16,15571u16),(33026u16,21588u16),
(33029u16,23171u16),(33030u16,22335u16),(33031u16,23172u16),(33032u16,16695u16),
(33034u16,21962u16),(33048u16,19715u16),(33050u16,14002u16),(33051u16,14420u16),
(33059u16,18603u16),(33065u16,18552u16),(33067u16,22528u16),(33071u16,22770u16),
(33081u16,21831u16),(33086u16,17766u16),(33099u16,18998u16),(33102u16,18791u16),
(33104u16,17590u16),(33105u16,17591u16),(33108u16,14178u16),(33109u16,19716u16),
(33125u16,18338u16),(33126u16,15549u16),(33131u16,21279u16),(33136u16,19861u16),
(33137u16,14237u16),(33144u16,20698u16),(33145u16,17442u16),(33146u16,18190u16),
(33151u16,22573u16),(33152u16,17220u16),(33160u16,14359u16),(33162u16,17064u16),
(33167u16,14574u16),(33178u16,17592u16),(33180u16,16640u16),(33181u16,18718u16),
(33184u16,14804u16),(33187u16,21648u16),(33192u16,22724u16),(33203u16,18191u16),
(33205u16,22228u16),(33210u16,20311u16),(33213u16,15712u16),(33214u16,23541u16),
(33215u16,15544u16),(33216u16,15940u16),(33218u16,17767u16),(33222u16,19165u16),
(33229u16,21201u16),(33240u16,16091u16),(33247u16,20699u16),(33251u16,18792u16),
(33253u16,19699u16),(33255u16,20700u16),(33256u16,16527u16),(33258u16,20642u16),
(33261u16,22336u16),(33267u16,21589u16),(33268u16,22365u16),(33274u16,15745u16),
(33275u16,21626u16),(33276u16,14946u16),(33278u16,20247u16),(33285u16,14947u16),
(33287u16,19293u16),(33288u16,23728u16),(33290u16,14948u16),(33292u16,18208u16),
(33293u16,17841u16),(33298u16,18147u16),(33307u16,21976u16),(33308u16,18604u16),
(33310u16,16896u16),(33311u16,21414u16),(33313u16,14179u16),(33322u16,22989u16),
(33323u16,17221u16),(33324u16,17090u16),(33333u16,22401u16),(33334u16,17065u16),
(33335u16,23153u16),(33337u16,18192u16),(33344u16,17593u16),(33349u16,19294u16),
(33351u16,21078u16),(33369u16,21832u16),(33380u16,20325u16),(33382u16,22965u16),
(33390u16,14026u16),(33391u16,16117u16),(33393u16,14027u16),(33394u16,18023u16),
(33398u16,19378u16),(33400u16,22147u16),(33406u16,18990u16),(33419u16,19922u16),
(33421u16,20658u16),(33422u16,14983u16),(33426u16,16676u16),(33433u16,17594u16),
(33434u16,15941u16),(33437u16,21590u16),(33439u16,17978u16),(33445u16,14201u16),
(33446u16,23331u16),(33449u16,15162u16),(33452u16,17625u16),(33453u16,22599u16),
(33454u16,19535u16),(33455u16,18910u16),(33457u16,23468u16),(33459u16,17222u16),
(33463u16,21591u16),(33464u16,19948u16),(33465u16,15147u16),(33467u16,22189u16),
(33468u16,16852u16),(33469u16,18925u16),(33471u16,20622u16),(33489u16,20074u16),
(33490u16,19379u16),(33492u16,22551u16),(33493u16,22148u16),(33495u16,16879u16),
(33499u16,13985u16),(33502u16,22771u16),(33503u16,14949u16),(33505u16,20455u16),
(33509u16,19115u16),(33510u16,14575u16),(33511u16,20845u16),(33521u16,19515u16),
(33533u16,14576u16),(33534u16,22918u16),(33537u16,21447u16),(33538u16,16897u16),
(33539u16,17280u16),(33540u16,13986u16),(33541u16,16853u16),(33545u16,16666u16),
(33559u16,16826u16),(33576u16,20643u16),(33579u16,16677u16),(33583u16,17443u16),
(33585u16,18553u16),(33588u16,23542u16),(33589u16,20489u16),(33590u16,15579u16),
(33592u16,19894u16),(33593u16,19295u16),(33600u16,18605u16),(33607u16,23112u16),
(33609u16,22149u16),(33610u16,23285u16),(33615u16,20516u16),(33617u16,20456u16),
(33618u16,23521u16),(33651u16,15934u16),(33655u16,22930u16),(33659u16,20871u16),
(33673u16,16508u16),(33674u16,20701u16),(33678u16,17842u16),(33686u16,14421u16),
(33688u16,18793u16),(33694u16,19717u16),(33698u16,23173u16),(33705u16,17595u16),
(33706u16,18926u16),(33707u16,16641u16),(33725u16,16678u16),(33729u16,22019u16),
(33733u16,14750u16),(33737u16,16310u16),(33738u16,14965u16),(33740u16,15127u16),
(33747u16,14727u16),(33750u16,21833u16),(33756u16,21843u16),(33769u16,17429u16),
(33771u16,15148u16),(33775u16,23469u16),(33776u16,14577u16),(33777u16,16487u16),
(33778u16,17768u16),(33780u16,18969u16),(33785u16,20846u16),(33789u16,18586u16),
(33795u16,22229u16),(33796u16,15877u16),(33802u16,16104u16),(33804u16,16705u16),
(33805u16,22740u16),(33806u16,20100u16),(33833u16,22190u16),(33836u16,16656u16),
(33841u16,23687u16),(33848u16,20248u16),(33853u16,16065u16),(33865u16,19483u16),
(33879u16,20847u16),(33883u16,14036u16),(33889u16,22772u16),(33891u16,15926u16),
(33894u16,20101u16),(33899u16,23332u16),(33900u16,20702u16),(33903u16,19116u16),
(33909u16,15118u16),(33914u16,21456u16),(33936u16,18554u16),(33940u16,18755u16),
(33945u16,16868u16),(33948u16,17965u16),(33953u16,17223u16),(33970u16,22773u16),
(33976u16,21465u16),(33979u16,19117u16),(33980u16,21834u16),(33983u16,23333u16),
(33984u16,18399u16),(33986u16,16827u16),(33988u16,22210u16),(33990u16,18167u16),
(33993u16,19895u16),(33995u16,14202u16),(33997u16,18756u16),(34001u16,17843u16),
(34010u16,18555u16),(34028u16,17464u16),(34030u16,16250u16),(34036u16,18606u16),
(34044u16,16339u16),(34065u16,16816u16),(34067u16,16657u16),(34068u16,17444u16),
(34071u16,20644u16),(34072u16,17979u16),(34074u16,20050u16),(34078u16,16448u16),
(34081u16,21844u16),(34083u16,20703u16),(34085u16,22174u16),(34092u16,18377u16),
(34093u16,20302u16),(34095u16,21627u16),(34109u16,22749u16),(34111u16,20102u16),
(34113u16,15713u16),(34115u16,17265u16),(34121u16,22150u16),(34126u16,14805u16),
(34131u16,19949u16),(34137u16,23297u16),(34147u16,18607u16),(34152u16,14997u16),
(34153u16,22540u16),(34154u16,16898u16),(34157u16,18378u16),(34180u16,17066u16),
(34183u16,17030u16),(34191u16,20326u16),(34193u16,14180u16),(34196u16,20704u16),
(34203u16,18209u16),(34214u16,21977u16),(34216u16,23683u16),(34217u16,17972u16),
(34218u16,18794u16),(34223u16,18148u16),(34224u16,23680u16),(34234u16,21202u16),
(34241u16,14578u16),(34249u16,20645u16),(34253u16,16087u16),(34254u16,18795u16),
(34255u16,20705u16),(34261u16,19923u16),(34268u16,16132u16),(34269u16,19536u16),
(34276u16,15951u16),(34277u16,19118u16),(34281u16,17266u16),(34282u16,18556u16),
(34295u16,20848u16),(34298u16,16519u16),(34299u16,21246u16),(34303u16,14736u16),
(34306u16,19537u16),(34310u16,16299u16),(34311u16,18379u16),(34314u16,19684u16),
(34326u16,19173u16),(34327u16,17387u16),(34330u16,18193u16),(34349u16,16076u16),
(34367u16,16056u16),(34382u16,23334u16),(34384u16,22938u16),(34388u16,14238u16),
(34389u16,21950u16),(34395u16,23125u16),(34396u16,16300u16),(34398u16,19924u16),
(34399u16,23335u16),(34407u16,23703u16),(34425u16,23361u16),(34442u16,17010u16),
(34444u16,17224u16),(34451u16,20491u16),(34467u16,14622u16),(34468u16,21247u16),
(34473u16,22366u16),(34503u16,17844u16),(34507u16,15692u16),(34516u16,23543u16),
(34521u16,19700u16),(34523u16,21415u16),(34527u16,14806u16),(34532u16,22972u16),
(34541u16,21649u16),(34558u16,18927u16),(34560u16,22160u16),(34562u16,17465u16),
(34563u16,18796u16),(34568u16,19670u16),(34584u16,21592u16),(34586u16,17769u16),
(34588u16,17049u16),(34638u16,14038u16),(34645u16,18773u16),(34647u16,23522u16),
(34655u16,20103u16),(34662u16,22931u16),(34664u16,18719u16),(34676u16,23336u16),
(34678u16,21037u16),(34680u16,19701u16),(34690u16,16099u16),(34701u16,20290u16),
(34719u16,16828u16),(34722u16,23286u16),(34739u16,15732u16),(34746u16,16057u16),
(34756u16,22387u16),(34784u16,17091u16),(34796u16,18194u16),(34799u16,19863u16),
(34802u16,22224u16),(34809u16,23100u16),(34811u16,20327u16),(34814u16,18219u16),
(34821u16,18733u16),(34847u16,16092u16),(34850u16,21442u16),(34851u16,16133u16),
(34865u16,14579u16),(34870u16,20672u16),(34875u16,16658u16),(34880u16,23161u16),
(34886u16,21450u16),(34892u16,23113u16),(34893u16,19351u16),(34898u16,23154u16),
(34899u16,18615u16),(34903u16,13987u16),(34905u16,18928u16),(34907u16,20104u16),
(34909u16,22225u16),(34913u16,23287u16),(34914u16,14950u16),(34915u16,20328u16),
(34920u16,22795u16),(34923u16,17980u16),(34928u16,18416u16),(34930u16,15489u16),
(34935u16,22226u16),(34942u16,15163u16),(34943u16,15164u16),(34945u16,20075u16),
(34946u16,16832u16),(34952u16,13988u16),(34955u16,15746u16),(34957u16,22774u16),
(34962u16,15693u16),(34966u16,18557u16),(34967u16,21628u16),(34974u16,14604u16),
(34987u16,22907u16),(34996u16,14580u16),(35009u16,20819u16),(35010u16,16259u16),
(35023u16,16509u16),(35028u16,19539u16),(35029u16,20249u16),(35033u16,14972u16),
(35036u16,17430u16),(35037u16,20706u16),(35039u16,17845u16),(35041u16,16510u16),
(35048u16,17770u16),(35059u16,18010u16),(35060u16,17243u16),(35061u16,17244u16),
(35064u16,16058u16),(35069u16,21203u16),(35079u16,17445u16),(35088u16,14037u16),
(35090u16,22775u16),(35091u16,17431u16),(35096u16,20105u16),(35097u16,17245u16),
(35109u16,19874u16),(35114u16,22574u16),(35126u16,18723u16),(35128u16,16449u16),
(35131u16,18210u16),(35137u16,14181u16),(35140u16,19144u16),(35167u16,15165u16),
(35172u16,16088u16),(35178u16,16667u16),(35186u16,18724u16),(35199u16,18149u16),
(35201u16,19864u16),(35203u16,15714u16),(35206u16,17446u16),(35207u16,22719u16),
(35211u16,14369u16),(35215u16,15119u16),(35219u16,16707u16),(35222u16,18757u16),
(35233u16,14360u16),(35241u16,15878u16),(35242u16,22374u16),(35250u16,15149u16),
(35258u16,14003u16),(35261u16,16089u16),(35264u16,14751u16),(35282u16,14004u16),
(35299u16,23101u16),(35316u16,18011u16),(35320u16,22161u16),(35328u16,19170u16),
(35330u16,21079u16),(35331u16,17596u16),(35336u16,14545u16),(35338u16,18797u16),
(35340u16,23362u16),(35342u16,22563u16),(35347u16,23681u16),(35350u16,23720u16),
(35351u16,22419u16),(35352u16,15327u16),(35355u16,19702u16),(35357u16,18929u16),
(35359u16,18407u16),(35363u16,14378u16),(35365u16,15562u16),(35370u16,17225u16),
(35373u16,18211u16),(35377u16,23126u16),(35380u16,18380u16),(35382u16,13989u16),
(35386u16,21629u16),(35387u16,21416u16),(35408u16,17846u16),(35412u16,21248u16),
(35413u16,22741u16),(35419u16,20849u16),(35422u16,17847u16),(35424u16,19516u16),
(35426u16,18608u16),(35427u16,19540u16),(35430u16,18758u16),(35433u16,18759u16),
(35437u16,15003u16),(35438u16,21007u16),(35440u16,23749u16),(35441u16,23470u16),
(35442u16,23102u16),(35443u16,18012u16),(35445u16,18195u16),(35449u16,22003u16),
(35461u16,21417u16),(35463u16,14728u16),(35468u16,21593u16),(35469u16,20492u16),
(35475u16,18150u16),(35477u16,22526u16),(35480u16,20250u16),(35486u16,19157u16),
(35488u16,18339u16),(35489u16,14546u16),(35491u16,16899u16),(35492u16,19671u16),
(35493u16,14581u16),(35494u16,18408u16),(35496u16,23544u16),(35498u16,18212u16),
(35504u16,18558u16),(35506u16,14729u16),(35513u16,17771u16),(35516u16,20329u16),
(35518u16,20296u16),(35519u16,21249u16),(35522u16,22004u16),(35524u16,18609u16),
(35527u16,15715u16),(35531u16,22020u16),(35533u16,20826u16),(35535u16,22191u16),
(35538u16,16118u16),(35542u16,16314u16),(35547u16,20251u16),(35548u16,22012u16),
(35553u16,18760u16),(35558u16,22029u16),(35559u16,23103u16),(35562u16,21080u16),
(35563u16,14028u16),(35565u16,20252u16),(35566u16,20646u16),(35569u16,23696u16),
(35574u16,18911u16),(35575u16,22899u16),(35576u16,21204u16),(35578u16,19171u16),
(35582u16,15366u16),(35584u16,16854u16),(35585u16,18960u16),(35586u16,20106u16),
(35588u16,15952u16),(35598u16,17031u16),(35600u16,17050u16),(35604u16,22939u16),
(35606u16,18393u16),(35607u16,17226u16),(35609u16,14382u16),(35610u16,20473u16),
(35611u16,14182u16),(35613u16,17848u16),(35616u16,19865u16),(35624u16,16855u16),
(35627u16,20872u16),(35628u16,16464u16),(35635u16,14951u16),(35641u16,15150u16),
(35649u16,23471u16),(35657u16,21466u16),(35662u16,23705u16),(35663u16,15328u16),
(35672u16,18774u16),(35674u16,15716u16),(35676u16,17432u16),(35686u16,14422u16),
(35692u16,17772u16),(35695u16,19312u16),(35696u16,20426u16),(35700u16,14370u16),
(35703u16,23337u16),(35709u16,19541u16),(35712u16,15898u16),(35722u16,17393u16),
(35728u16,18559u16),(35730u16,21811u16),(35731u16,19146u16),(35734u16,21812u16),
(35738u16,21793u16),(35895u16,14594u16),(35903u16,14547u16),(35905u16,23500u16),
(35910u16,15936u16),(35912u16,15329u16),(35914u16,22900u16),(35916u16,19718u16),
(35925u16,18761u16),(35930u16,15907u16),(35937u16,18013u16),(35946u16,23338u16),
(35947u16,19542u16),(35961u16,22796u16),(35962u16,18762u16),(35970u16,22151u16),
(35978u16,16696u16),(35980u16,16856u16),(35997u16,22720u16),(35998u16,21081u16),
(36000u16,17597u16),(36001u16,20820u16),(36002u16,14623u16),(36007u16,17789u16),
(36008u16,23472u16),(36009u16,22607u16),(36010u16,22532u16),(36011u16,14752u16),
(36012u16,21946u16),(36015u16,20850u16),(36016u16,18349u16),(36019u16,20460u16),
(36020u16,15009u16),(36022u16,22736u16),(36023u16,16691u16),(36024u16,15747u16),
(36027u16,17773u16),(36028u16,22013u16),(36029u16,20459u16),(36031u16,16900u16),
(36032u16,22932u16),(36033u16,17626u16),(36034u16,16326u16),(36035u16,20517u16),
(36036u16,23545u16),(36039u16,20647u16),(36040u16,13990u16),(36042u16,20873u16),
(36049u16,21630u16),(36051u16,17790u16),(36058u16,16327u16),(36060u16,17849u16),
(36062u16,18014u16),(36064u16,17246u16),(36066u16,23156u16),(36067u16,16692u16),
(36068u16,21978u16),(36070u16,17598u16),(36074u16,21650u16),(36077u16,15879u16),
(36084u16,16328u16),(36091u16,17599u16),(36092u16,14952u16),(36093u16,18018u16),
(36100u16,21595u16),(36101u16,22326u16),(36103u16,20278u16),(36104u16,21467u16),
(36106u16,21794u16),(36109u16,18220u16),(36115u16,20707u16),(36118u16,18394u16),
(36196u16,20874u16),(36198u16,17850u16),(36203u16,23136u16),(36208u16,21418u16),
(36211u16,15120u16),(36212u16,17600u16),(36215u16,15330u16),(36229u16,22152u16),
(36234u16,20083u16),(36249u16,21250u16),(36259u16,22337u16),(36264u16,22192u16),
(36275u16,21260u16),(36282u16,17601u16),(36286u16,21596u16),(36294u16,22552u16),
(36299u16,17197u16),(36300u16,21651u16),(36303u16,13991u16),(36315u16,22600u16),
(36317u16,14224u16),(36321u16,20875u16),(36323u16,18196u16),(36328u16,14730u16),
(36335u16,16301u16),(36339u16,15880u16),(36362u16,19896u16),(36367u16,15721u16),
(36368u16,21979u16),(36382u16,14225u16),(36394u16,21376u16),(36400u16,20253u16),
(36405u16,21377u16),(36418u16,20254u16),(36420u16,21205u16),(36423u16,14239u16),
(36424u16,15881u16),(36425u16,21773u16),(36426u16,23298u16),(36441u16,22211u16),
(36447u16,20876u16),(36448u16,21963u16),(36468u16,22212u16),(36470u16,14998u16),
(36481u16,21251u16),(36487u16,20851u16),(36490u16,21419u16),(36493u16,19119u16),
(36522u16,16520u16),(36523u16,18798u16),(36524u16,14984u16),(36544u16,14953u16),
(36554u16,21774u16),(36555u16,18961u16),(36556u16,15004u16),(36557u16,14973u16),
(36562u16,23130u16),(36575u16,19352u16),(36587u16,21631u16),(36600u16,22213u16),
(36603u16,13992u16),(36606u16,18775u16),(36611u16,14807u16),(36613u16,16302u16),
(36617u16,20821u16),(36626u16,22014u16),(36627u16,16659u16),(36628u16,17433u16),
(36629u16,14423u16),(36635u16,16119u16),(36636u16,22367u16),(36637u16,23697u16),
(36638u16,16679u16),(36639u16,21992u16),(36646u16,16251u16),(36647u16,17415u16),
(36649u16,17247u16),(36650u16,16474u16),(36655u16,21659u16),(36659u16,21420u16),
(36664u16,18560u16),(36665u16,17447u16),(36667u16,17448u16),(36670u16,21008u16),
(36671u16,19296u16),(36676u16,22956u16),(36677u16,20076u16),(36681u16,21009u16),
(36685u16,21993u16),(36686u16,14808u16),(36701u16,19297u16),(36703u16,14787u16),
(36706u16,16144u16),(36763u16,18799u16),(36764u16,14583u16),(36771u16,16079u16),
(36774u16,22608u16),(36776u16,17394u16),(36781u16,17851u16),(36783u16,17395u16),
(36784u16,21632u16),(36785u16,19875u16),(36786u16,15545u16),(36802u16,19925u16),
(36805u16,18801u16),(36814u16,19517u16),(36817u16,15151u16),(36820u16,17092u16),
(36838u16,13993u16),(36842u16,20877u16),(36843u16,17067u16),(36845u16,21652u16),
(36848u16,18616u16),(36850u16,14351u16),(36855u16,17032u16),(36857u16,20878u16),
(36861u16,22193u16),(36864u16,22575u16),(36865u16,18409u16),(36866u16,14758u16),
(36867u16,15882u16),(36869u16,23672u16),(36870u16,19314u16),(36872u16,23288u16),
(36875u16,22776u16),(36877u16,18381u16),(36879u16,22581u16),(36880u16,22214u16),
(36881u16,14954u16),(36884u16,15883u16),(36885u16,14424u16),(36887u16,15937u16),
(36889u16,20852u16),(36890u16,22570u16),(36893u16,18151u16),(36894u16,16278u16),
(36895u16,18395u16),(36896u16,21252u16),(36897u16,21443u16),(36898u16,17466u16),
(36899u16,16252u16),(36910u16,22030u16),(36913u16,21421u16),(36914u16,21633u16),
(36917u16,15121u16),(36920u16,20504u16),(36924u16,22921u16),(36926u16,20256u16),
(36929u16,15942u16),(36930u16,18561u16),(36935u16,19926u16),(36938u16,20255u16),
(36939u16,20046u16),(36941u16,22733u16),(36942u16,14731u16),(36944u16,22933u16),
(36945u16,23523u16),(36947u16,15884u16),(36948u16,15700u16),(36949u16,20107u16),
(36953u16,19866u16),(36956u16,18400u16),(36957u16,15722u16),(36958u16,22031u16),
(36960u16,20077u16),(36961u16,18382u16),(36963u16,14371u16),(36969u16,20879u16),
(36973u16,21253u16),(36974u16,21775u16),(36975u16,15943u16),(36978u16,21597u16),
(36981u16,21444u16),(36983u16,21980u16),(36984u16,18197u16),(36986u16,20257u16),
(36988u16,16436u16),(36989u16,14227u16),(36991u16,22908u16),(36992u16,19868u16),
(36993u16,16693u16),(36994u16,23104u16),(36995u16,18562u16),(36996u16,23494u16),
(36999u16,20461u16),(37000u16,16642u16),(37002u16,17396u16),(37007u16,16059u16),
(37009u16,20308u16),(37013u16,19692u16),(37017u16,16680u16),(37026u16,23289u16),
(37027u16,15360u16),(37030u16,17227u16),(37032u16,22165u16),(37034u16,17852u16),
(37039u16,14056u16),(37040u16,22553u16),(37041u16,14955u16),(37045u16,18383u16),
(37048u16,20853u16),(37057u16,19939u16),(37066u16,14809u16),(37086u16,16100u16),
(37089u16,14974u16),(37096u16,17602u16),(37101u16,14737u16),(37109u16,19927u16),
(37117u16,15885u16),(37122u16,18944u16),(37138u16,22194u16),(37141u16,23118u16),
(37145u16,17774u16),(37159u16,15953u16),(37165u16,21082u16),(37170u16,15694u16),
(37193u16,20258u16),(37194u16,21083u16),(37195u16,22195u16),(37196u16,20659u16),
(37197u16,17248u16),(37198u16,21422u16),(37202u16,21423u16),(37218u16,22153u16),
(37225u16,16829u16),(37226u16,16067u16),(37228u16,18563u16),(37237u16,23658u16),
(37239u16,23344u16),(37240u16,17966u16),(37255u16,18610u16),(37257u16,22338u16),
(37259u16,22154u16),(37261u16,21206u16),(37266u16,18340u16),(37276u16,22196u16),
(37291u16,20427u16),(37292u16,20708u16),(37294u16,22155u16),(37295u16,23299u16),
(37297u16,17198u16),(37300u16,16287u16),(37301u16,14212u16),(37312u16,19147u16),
(37319u16,21845u16),(37321u16,20259u16),(37323u16,18168u16),(37324u16,16511u16),
(37325u16,21451u16),(37326u16,19110u16),(37327u16,16120u16),(37328u16,16512u16),
(37329u16,15344u16),(37335u16,18417u16),(37336u16,21084u16),(37340u16,17603u16),
(37341u16,22385u16),(37347u16,21254u16),(37351u16,21981u16),(37354u16,19928u16),
(37365u16,21846u16),(37389u16,15944u16),(37392u16,14347u16),(37393u16,22609u16),
(37394u16,17983u16),(37399u16,20280u16),(37406u16,15128u16),(37428u16,16279u16),
(37434u16,19678u16),(37439u16,21010u16),(37440u16,14160u16),(37445u16,14228u16),
(37449u16,23157u16),(37463u16,14383u16),(37467u16,19356u16),(37470u16,20084u16),
(37474u16,17199u16),(37476u16,14956u16),(37477u16,18617u16),(37478u16,21085u16),
(37504u16,20297u16),(37507u16,22175u16),(37509u16,15927u16),(37521u16,18198u16),
(37523u16,21011u16),(37526u16,18564u16),(37528u16,16830u16),(37532u16,22966u16),
(37555u16,19544u16),(37558u16,14957u16),(37559u16,18384u16),(37561u16,18565u16),
(37580u16,21086u16),(37583u16,23174u16),(37586u16,17467u16),(37604u16,18152u16),
(37610u16,22777u16),(37624u16,14229u16),(37628u16,14183u16),(37636u16,16311u16),
(37648u16,22197u16),(37656u16,22198u16),(37658u16,20827u16),(37662u16,18611u16),
(37663u16,15717u16),(37664u16,21087u16),(37665u16,15331u16),(37666u16,21012u16),
(37668u16,15332u16),(37670u16,15167u16),(37672u16,16880u16),(37675u16,18169u16),
(37678u16,14584u16),(37679u16,21780u16),(37704u16,19519u16),(37706u16,16253u16),
(37707u16,14732u16),(37709u16,15886u16),(37716u16,18945u16),(37723u16,15695u16),
(37742u16,20260u16),(37749u16,14240u16),(37756u16,22386u16),(37758u16,21378u16),
(37772u16,14384u16),(37780u16,19897u16),(37782u16,18415u16),(37786u16,22199u16),
(37795u16,23290u16),(37799u16,14204u16),(37804u16,23339u16),(37805u16,21634u16),
(37808u16,20505u16),(37827u16,21261u16),(37841u16,20880u16),(37854u16,19898u16),
(37857u16,14425u16),(37860u16,16450u16),(37878u16,21756u16),(37892u16,23550u16),
(37912u16,21379u16),(37925u16,18199u16),(37931u16,21013u16),(37941u16,21994u16),
(37944u16,22516u16),(37956u16,21424u16),(37969u16,14057u16),(37970u16,14058u16),
(37979u16,14771u16),(38013u16,21795u16),(38015u16,21781u16),(38263u16,20709u16),
(38272u16,17011u16),(38275u16,18221u16),(38281u16,22750u16),(38283u16,14205u16),
(38287u16,20281u16),(38289u16,22951u16),(38290u16,22952u16),(38291u16,14029u16),
(38292u16,17047u16),(38296u16,14161u16),(38307u16,14005u16),(38308u16,22973u16),
(38309u16,17271u16),(38312u16,15122u16),(38317u16,16134u16),(38321u16,19368u16),
(38331u16,19477u16),(38332u16,18962u16),(38343u16,18970u16),(38346u16,23501u16),
(38356u16,22974u16),(38357u16,14999u16),(38358u16,22585u16),(38364u16,14753u16),
(38369u16,21982u16),(38370u16,17388u16),(38428u16,17604u16),(38433u16,21983u16),
(38442u16,22706u16),(38446u16,19719u16),(38450u16,17228u16),(38459u16,21255u16),
(38463u16,18930u16),(38464u16,22402u16),(38466u16,22909u16),(38468u16,17605u16),
(38475u16,16451u16),(38476u16,16697u16),(38477u16,14184u16),(38480u16,22953u16),
(38491u16,22751u16),(38492u16,22975u16),(38493u16,18222u16),(38494u16,18734u16),
(38495u16,21964u16),(38498u16,20079u16),(38499u16,21635u16),(38500u16,21207u16),
(38506u16,17249u16),(38512u16,20303u16),(38515u16,21636u16),(38517u16,16488u16),
(38518u16,15887u16),(38519u16,22967u16),(38520u16,16468u16),(38525u16,19148u16),
(38533u16,19929u16),(38534u16,16479u16),(38538u16,15748u16),(38539u16,18566u16),
(38541u16,23524u16),(38542u16,14548u16),(38548u16,14361u16),(38549u16,20047u16),
(38552u16,18991u16),(38553u16,15137u16),(38555u16,21208u16),(38556u16,20806u16),
(38563u16,16521u16),(38567u16,18567u16),(38568u16,18568u16),(38570u16,23132u16),
(38577u16,20298u16),(38583u16,16288u16),(38587u16,21965u16),(38592u16,20660u16),
(38593u16,18955u16),(38596u16,20054u16),(38597u16,18931u16),(38598u16,21757u16),
(38599u16,14585u16),(38601u16,22368u16),(38603u16,21445u16),(38604u16,20648u16),
(38605u16,19693u16),(38606u16,20854u16),(38613u16,21256u16),(38614u16,18569u16),
(38617u16,18915u16),(38619u16,22200u16),(38620u16,20673u16),(38626u16,16513u16),
(38627u16,15376u16),(38632u16,19930u16),(38633u16,19931u16),(38634u16,18213u16),
(38639u16,17012u16),(38640u16,17627u16),(38642u16,20048u16),(38646u16,16280u16),
(38647u16,16329u16),(38649u16,17068u16),(38651u16,21014u16),(38656u16,18570u16),
(38662u16,21088u16),(38663u16,21637u16),(38673u16,21032u16),(38675u16,19546u16),
(38678u16,16528u16),(38681u16,19521u16),(38684u16,18015u16),(38686u16,22934u16),
(38695u16,16901u16),(38704u16,17967u16),(38706u16,16303u16),(38713u16,17389u16),
(38717u16,21209u16),(38722u16,16145u16),(38724u16,18992u16),(38728u16,16281u16),
(38737u16,22021u16),(38742u16,21089u16),(38748u16,21186u16),(38750u16,17775u16),
(38753u16,17033u16),(38754u16,16717u16),(38761u16,23137u16),(38765u16,20494u16),
(38772u16,23473u16),(38775u16,20495u16),(38778u16,16668u16),(38795u16,23300u16),
(38797u16,18956u16),(38799u16,14624u16),(38816u16,14966u16),(38824u16,14039u16),
(38827u16,14967u16),(38829u16,22734u16),(38854u16,21984u16),(38859u16,20108u16),
(38867u16,22954u16),(38876u16,15888u16),(38899u16,20304u16),(38902u16,18385u16),
(38907u16,20049u16),(38911u16,23119u16),(38912u16,23340u16),(38913u16,23162u16),
(38914u16,21187u16),(38915u16,14426u16),(38917u16,23088u16),(38918u16,18612u16),
(38920u16,18571u16),(38922u16,19940u16),(38924u16,18410u16),(38928u16,19547u16),
(38929u16,19720u16),(38930u16,17093u16),(38931u16,15908u16),(38935u16,22601u16),
(38936u16,16282u16),(38957u16,15938u16),(38960u16,23175u16),(38968u16,14427u16),
(38969u16,22576u16),(38971u16,17791u16),(38982u16,14733u16),(38988u16,21210u16),
(38989u16,18999u16),(38990u16,18946u16),(38996u16,18957u16),(39000u16,20080u16),
(39002u16,21015u16),(39006u16,16465u16),(39013u16,23341u16),(39015u16,14586u16),
(39019u16,21016u16),(39023u16,23158u16),(39080u16,22901u16),(39087u16,17984u16),
(39089u16,22554u16),(39108u16,22798u16),(39111u16,22797u16),(39131u16,17776u16),
(39132u16,17267u16),(39135u16,18776u16),(39137u16,18401u16),(39138u16,15333u16),
(39149u16,22373u16),(39150u16,20305u16),(39151u16,17094u16),(39156u16,20464u16),
(39164u16,17853u16),(39165u16,22778u16),(39166u16,18777u16),(39171u16,14810u16),
(39177u16,23120u16),(39178u16,19150u16),(39180u16,20465u16),(39184u16,21796u16),
(39187u16,18932u16),(39192u16,19299u16),(39198u16,21017u16),(39200u16,17416u16),
(39208u16,14754u16),(39237u16,16660u16),(39241u16,15152u16),(39243u16,15005u16),
(39244u16,21797u16),(39245u16,18200u16),(39249u16,15334u16),(39250u16,19869u16),
(39252u16,19694u16),(39255u16,23121u16),(39318u16,18572u16),(39321u16,23122u16),
(39325u16,22919u16),(39333u16,17449u16),(39336u16,23291u16),(39340u16,16634u16),
(39341u16,19158u16),(39342u16,22902u16),(39345u16,22403u16),(39347u16,22369u16),
(39348u16,18613u16),(39353u16,20506u16),(39361u16,17069u16),(39376u16,21425u16),
(39377u16,15529u16),(39378u16,14958u16),(39381u16,13994u16),(39385u16,17606u16),
(39389u16,22404u16),(39391u16,17854u16),(39405u16,23105u16),(39409u16,16068u16),
(39423u16,21446u16),(39425u16,17795u16),(39432u16,17417u16),(39438u16,15335u16),
(39439u16,15336u16),(39449u16,22735u16),(39467u16,14241u16),(39472u16,15954u16),
(39478u16,22201u16),(39479u16,18386u16),(39488u16,16698u16),(39491u16,22799u16),
(39493u16,14959u16),(39501u16,23659u16),(39509u16,14811u16),(39511u16,23133u16),
(39514u16,14428u16),(39515u16,19315u16),(39519u16,22339u16),(39522u16,16135u16),
(39525u16,15337u16),(39529u16,23495u16),(39530u16,16136u16),(39592u16,14608u16),
(39608u16,23106u16),(39635u16,18573u16),(39636u16,22032u16),(39640u16,14587u16),
(39653u16,19478u16),(39662u16,17200u16),(39706u16,18574u16),(39719u16,16437u16),
(39722u16,22582u16),(39729u16,20051u16),(39740u16,15106u16),(39745u16,14783u16),
(39746u16,23350u16),(39747u16,17201u16),(39748u16,17257u16),(39749u16,16694u16),
(39759u16,20109u16),(39764u16,16635u16),(39770u16,19159u16),(39791u16,16304u16),
(39822u16,21033u16),(39825u16,22779u16),(39839u16,18958u16),(39851u16,14812u16),
(39854u16,18201u16),(39881u16,16514u16),(39894u16,22022u16),(39908u16,14605u16),
(39912u16,14429u16),(39949u16,22202u16),(39952u16,18947u16),(39954u16,17450u16),
(39957u16,22935u16),(39973u16,23496u16),(39986u16,19672u16),(39995u16,16661u16),
(40007u16,14185u16),(40009u16,17399u16),(40023u16,16522u16),(40165u16,21257u16),
(40167u16,17607u16),(40169u16,14960u16),(40179u16,17468u16),(40180u16,16831u16),
(40182u16,19358u16),(40201u16,18933u16),(40219u16,20081u16),(40230u16,18981u16),
(40232u16,18974u16),(40251u16,23363u16),(40273u16,14372u16),(40285u16,18934u16),
(40288u16,14595u16),(40289u16,16902u16),(40300u16,17638u16),(40306u16,20661u16),
(40361u16,16863u16),(40367u16,19098u16),(40372u16,22940u16),(40388u16,14549u16),
(40407u16,14961u16),(40434u16,22340u16),(40440u16,23706u16),(40441u16,20312u16),
(40442u16,16305u16),(40474u16,19099u16),(40478u16,16077u16),(40565u16,16306u16),
(40569u16,22968u16),(40573u16,19479u16),(40575u16,16312u16),(40594u16,15338u16),
(40595u16,16313u16),(40599u16,16137u16),(40605u16,17855u16),(40607u16,16523u16),
(40613u16,16699u16),(40628u16,14968u16),(40629u16,16718u16),(40635u16,16636u16),
(40638u16,23698u16),(40643u16,23525u16),(40653u16,18153u16),(40654u16,16138u16),
(40657u16,23712u16),(40660u16,14348u16),(40664u16,16904u16),(40667u16,15749u16),
(40668u16,22220u16),(40670u16,21034u16),(40680u16,15733u16),(40692u16,17034u16),
(40711u16,19673u16),(40712u16,17400u16),(40718u16,21188u16),(40723u16,14588u16),
(40736u16,18154u16),(40763u16,17777u16),(40778u16,21211u16),(40779u16,20822u16),
(40782u16,20823u16),(40786u16,22370u16),(40799u16,20855u16),(40801u16,16283u16),
(40807u16,18214u16),(40810u16,21782u16),(40812u16,19160u16),(40823u16,18948u16),
(40845u16,16438u16),(40848u16,17229u16),(40853u16,14059u16),(40860u16,14962u16),
(44032u16,9026u16),(44033u16,9027u16),(44036u16,9028u16),(44039u16,9029u16),
(44040u16,9030u16),(44041u16,9031u16),(44042u16,9032u16),(44048u16,9033u16),
(44049u16,9034u16),(44050u16,9035u16),(44051u16,9036u16),(44052u16,9037u16),
(44053u16,9038u16),(44054u16,9039u16),(44055u16,9040u16),(44057u16,9041u16),
(44058u16,9042u16),(44059u16,9043u16),(44060u16,9044u16),(44061u16,9045u16),
(44064u16,9046u16),(44068u16,9047u16),(44076u16,9048u16),(44077u16,9049u16),
(44079u16,9050u16),(44080u16,9051u16),(44081u16,9052u16),(44088u16,9053u16),
(44089u16,9054u16),(44092u16,9055u16),(44096u16,9056u16),(44107u16,9057u16),
(44109u16,9058u16),(44116u16,9059u16),(44120u16,9060u16),(44124u16,9061u16),
(44144u16,9062u16),(44145u16,9063u16),(44148u16,9064u16),(44151u16,9065u16),
(44152u16,9066u16),(44154u16,9067u16),(44160u16,9068u16),(44161u16,9069u16),
(44163u16,9070u16),(44164u16,9071u16),(44165u16,9072u16),(44166u16,9073u16),
(44169u16,9074u16),(44170u16,9075u16),(44171u16,9076u16),(44172u16,9077u16),
(44176u16,9078u16),(44180u16,9079u16),(44188u16,9080u16),(44189u16,9081u16),
(44191u16,9082u16),(44192u16,9083u16),(44193u16,9084u16),(44200u16,9085u16),
(44201u16,9086u16),(44202u16,9087u16),(44204u16,9088u16),(44207u16,9089u16),
(44208u16,9090u16),(44216u16,9091u16),(44217u16,9092u16),(44219u16,9093u16),
(44220u16,9094u16),(44221u16,9095u16),(44225u16,9096u16),(44228u16,9097u16),
(44232u16,9098u16),(44236u16,9099u16),(44245u16,9100u16),(44247u16,9101u16),
(44256u16,9102u16),(44257u16,9103u16),(44260u16,9104u16),(44263u16,9105u16),
(44264u16,9106u16),(44266u16,9107u16),(44268u16,9108u16),(44271u16,9109u16),
(44272u16,9110u16),(44273u16,9111u16),(44275u16,9112u16),(44277u16,9113u16),
(44278u16,9114u16),(44284u16,9115u16),(44285u16,9116u16),(44288u16,9117u16),
(44292u16,9118u16),(44294u16,9119u16),(44300u16,9216u16),(44301u16,9217u16),
(44303u16,9218u16),(44305u16,9219u16),(44312u16,9220u16),(44316u16,9221u16),
(44320u16,9222u16),(44329u16,9223u16),(44332u16,9224u16),(44333u16,9225u16),
(44340u16,9226u16),(44341u16,9227u16),(44344u16,9228u16),(44348u16,9229u16),
(44356u16,9230u16),(44357u16,9231u16),(44359u16,9232u16),(44361u16,9233u16),
(44368u16,9234u16),(44372u16,9235u16),(44376u16,9236u16),(44385u16,9237u16),
(44387u16,9238u16),(44396u16,9239u16),(44397u16,9240u16),(44400u16,9241u16),
(44403u16,9242u16),(44404u16,9243u16),(44405u16,9244u16),(44406u16,9245u16),
(44411u16,9246u16),(44412u16,9247u16),(44413u16,9248u16),(44415u16,9249u16),
(44417u16,9250u16),(44418u16,9251u16),(44424u16,9252u16),(44425u16,9253u16),
(44428u16,9254u16),(44432u16,9255u16),(44444u16,9256u16),(44445u16,9257u16),
(44452u16,9258u16),(44471u16,9259u16),(44480u16,9260u16),(44481u16,9261u16),
(44484u16,9262u16),(44488u16,9263u16),(44496u16,9264u16),(44497u16,9265u16),
(44499u16,9266u16),(44508u16,9267u16),(44512u16,9268u16),(44516u16,9269u16),
(44536u16,9270u16),(44537u16,9271u16),(44540u16,9272u16),(44543u16,9273u16),
(44544u16,9274u16),(44545u16,9275u16),(44552u16,9276u16),(44553u16,9277u16),
(44555u16,9278u16),(44557u16,9279u16),(44564u16,9280u16),(44592u16,9281u16),
(44593u16,9282u16),(44596u16,9283u16),(44599u16,9284u16),(44600u16,9285u16),
(44602u16,9286u16),(44608u16,9287u16),(44609u16,9288u16),(44611u16,9289u16),
(44613u16,9290u16),(44614u16,9291u16),(44618u16,9292u16),(44620u16,9293u16),
(44621u16,9294u16),(44622u16,9295u16),(44624u16,9296u16),(44628u16,9297u16),
(44630u16,9298u16),(44636u16,9299u16),(44637u16,9300u16),(44639u16,9301u16),
(44640u16,9302u16),(44641u16,9303u16),(44645u16,9304u16),(44648u16,9305u16),
(44649u16,9306u16),(44652u16,9307u16),(44656u16,9308u16),(44664u16,9309u16),
(44665u16,9406u16),(44667u16,9407u16),(44668u16,9408u16),(44669u16,9409u16),
(44676u16,9410u16),(44677u16,9411u16),(44684u16,9412u16),(44732u16,9413u16),
(44733u16,9414u16),(44734u16,9415u16),(44736u16,9416u16),(44740u16,9417u16),
(44748u16,9418u16),(44749u16,9419u16),(44751u16,9420u16),(44752u16,9421u16),
(44753u16,9422u16),(44760u16,9423u16),(44761u16,9424u16),(44764u16,9425u16),
(44776u16,9426u16),(44779u16,9427u16),(44781u16,9428u16),(44788u16,9429u16),
(44792u16,9430u16),(44796u16,9431u16),(44807u16,9432u16),(44808u16,9433u16),
(44813u16,9434u16),(44816u16,9435u16),(44844u16,9436u16),(44845u16,9437u16),
(44848u16,9438u16),(44850u16,9439u16),(44852u16,9440u16),(44860u16,9441u16),
(44861u16,9442u16),(44863u16,9443u16),(44865u16,9444u16),(44866u16,9445u16),
(44867u16,9446u16),(44872u16,9447u16),(44873u16,9448u16),(44880u16,9449u16),
(44892u16,9450u16),(44893u16,9451u16),(44900u16,9452u16),(44901u16,9453u16),
(44921u16,9454u16),(44928u16,9455u16),(44932u16,9456u16),(44936u16,9457u16),
(44944u16,9458u16),(44945u16,9459u16),(44949u16,9460u16),(44956u16,9461u16),
(44984u16,9462u16),(44985u16,9463u16),(44988u16,9464u16),(44992u16,9465u16),
(44999u16,9466u16),(45000u16,9467u16),(45001u16,9468u16),(45003u16,9469u16),
(45005u16,9470u16),(45006u16,9471u16),(45012u16,9472u16),(45020u16,9473u16),
(45032u16,9474u16),(45033u16,9475u16),(45040u16,9476u16),(45041u16,9477u16),
(45044u16,9478u16),(45048u16,9479u16),(45056u16,9480u16),(45057u16,9481u16),
(45060u16,9482u16),(45068u16,9483u16),(45072u16,9484u16),(45076u16,9485u16),
(45084u16,9486u16),(45085u16,9487u16),(45096u16,9488u16),(45124u16,9489u16),
(45125u16,9490u16),(45128u16,9491u16),(45130u16,9492u16),(45132u16,9493u16),
(45134u16,9494u16),(45139u16,9495u16),(45140u16,9496u16),(45141u16,9497u16),
(45143u16,9498u16),(45145u16,9499u16),(45149u16,9596u16),(45180u16,9597u16),
(45181u16,9598u16),(45184u16,9599u16),(45188u16,9600u16),(45196u16,9601u16),
(45197u16,9602u16),(45199u16,9603u16),(45201u16,9604u16),(45208u16,9605u16),
(45209u16,9606u16),(45210u16,9607u16),(45212u16,9608u16),(45215u16,9609u16),
(45216u16,9610u16),(45217u16,9611u16),(45218u16,9612u16),(45224u16,9613u16),
(45225u16,9614u16),(45227u16,9615u16),(45228u16,9616u16),(45229u16,9617u16),
(45230u16,9618u16),(45231u16,9619u16),(45233u16,9620u16),(45235u16,9621u16),
(45236u16,9622u16),(45237u16,9623u16),(45240u16,9624u16),(45244u16,9625u16),
(45252u16,9626u16),(45253u16,9627u16),(45255u16,9628u16),(45256u16,9629u16),
(45257u16,9630u16),(45264u16,9631u16),(45265u16,9632u16),(45268u16,9633u16),
(45272u16,9634u16),(45280u16,9635u16),(45285u16,9636u16),(45320u16,9637u16),
(45321u16,9638u16),(45323u16,9639u16),(45324u16,9640u16),(45328u16,9641u16),
(45330u16,9642u16),(45331u16,9643u16),(45336u16,9644u16),(45337u16,9645u16),
(45339u16,9646u16),(45340u16,9647u16),(45341u16,9648u16),(45347u16,9649u16),
(45348u16,9650u16),(45349u16,9651u16),(45352u16,9652u16),(45356u16,9653u16),
(45364u16,9654u16),(45365u16,9655u16),(45367u16,9656u16),(45368u16,9657u16),
(45369u16,9658u16),(45376u16,9659u16),(45377u16,9660u16),(45380u16,9661u16),
(45384u16,9662u16),(45392u16,9663u16),(45393u16,9664u16),(45396u16,9665u16),
(45397u16,9666u16),(45400u16,9667u16),(45404u16,9668u16),(45408u16,9669u16),
(45432u16,9670u16),(45433u16,9671u16),(45436u16,9672u16),(45440u16,9673u16),
(45442u16,9674u16),(45448u16,9675u16),(45449u16,9676u16),(45451u16,9677u16),
(45453u16,9678u16),(45458u16,9679u16),(45459u16,9680u16),(45460u16,9681u16),
(45464u16,9682u16),(45468u16,9683u16),(45480u16,9684u16),(45516u16,9685u16),
(45520u16,9686u16),(45524u16,9687u16),(45532u16,9688u16),(45533u16,9689u16),
(45535u16,9786u16),(45544u16,9787u16),(45545u16,9788u16),(45548u16,9789u16),
(45552u16,9790u16),(45561u16,9791u16),(45563u16,9792u16),(45565u16,9793u16),
(45572u16,9794u16),(45573u16,9795u16),(45576u16,9796u16),(45579u16,9797u16),
(45580u16,9798u16),(45588u16,9799u16),(45589u16,9800u16),(45591u16,9801u16),
(45593u16,9802u16),(45600u16,9803u16),(45620u16,9804u16),(45628u16,9805u16),
(45656u16,9806u16),(45660u16,9807u16),(45664u16,9808u16),(45672u16,9809u16),
(45673u16,9810u16),(45684u16,9811u16),(45685u16,9812u16),(45692u16,9813u16),
(45700u16,9814u16),(45701u16,9815u16),(45705u16,9816u16),(45712u16,9817u16),
(45713u16,9818u16),(45716u16,9819u16),(45720u16,9820u16),(45721u16,9821u16),
(45722u16,9822u16),(45728u16,9823u16),(45729u16,9824u16),(45731u16,9825u16),
(45733u16,9826u16),(45734u16,9827u16),(45738u16,9828u16),(45740u16,9829u16),
(45744u16,9830u16),(45748u16,9831u16),(45768u16,9832u16),(45769u16,9833u16),
(45772u16,9834u16),(45776u16,9835u16),(45778u16,9836u16),(45784u16,9837u16),
(45785u16,9838u16),(45787u16,9839u16),(45789u16,9840u16),(45794u16,9841u16),
(45796u16,9842u16),(45797u16,9843u16),(45798u16,9844u16),(45800u16,9845u16),
(45803u16,9846u16),(45804u16,9847u16),(45805u16,9848u16),(45806u16,9849u16),
(45807u16,9850u16),(45811u16,9851u16),(45812u16,9852u16),(45813u16,9853u16),
(45815u16,9854u16),(45816u16,9855u16),(45817u16,9856u16),(45818u16,9857u16),
(45819u16,9858u16),(45823u16,9859u16),(45824u16,9860u16),(45825u16,9861u16),
(45828u16,9862u16),(45832u16,9863u16),(45840u16,9864u16),(45841u16,9865u16),
(45843u16,9866u16),(45844u16,9867u16),(45845u16,9868u16),(45852u16,9869u16),
(45908u16,9870u16),(45909u16,9871u16),(45910u16,9872u16),(45912u16,9873u16),
(45915u16,9874u16),(45916u16,9875u16),(45918u16,9876u16),(45919u16,9877u16),
(45924u16,9878u16),(45925u16,9879u16),(45927u16,9976u16),(45929u16,9977u16),
(45931u16,9978u16),(45934u16,9979u16),(45936u16,9980u16),(45937u16,9981u16),
(45940u16,9982u16),(45944u16,9983u16),(45952u16,9984u16),(45953u16,9985u16),
(45955u16,9986u16),(45956u16,9987u16),(45957u16,9988u16),(45964u16,9989u16),
(45968u16,9990u16),(45972u16,9991u16),(45984u16,9992u16),(45985u16,9993u16),
(45992u16,9994u16),(45996u16,9995u16),(46020u16,9996u16),(46021u16,9997u16),
(46024u16,9998u16),(46027u16,9999u16),(46028u16,10000u16),(46030u16,10001u16),
(46032u16,10002u16),(46036u16,10003u16),(46037u16,10004u16),(46039u16,10005u16),
(46041u16,10006u16),(46043u16,10007u16),(46045u16,10008u16),(46048u16,10009u16),
(46052u16,10010u16),(46056u16,10011u16),(46076u16,10012u16),(46096u16,10013u16),
(46104u16,10014u16),(46108u16,10015u16),(46112u16,10016u16),(46120u16,10017u16),
(46121u16,10018u16),(46123u16,10019u16),(46132u16,10020u16),(46160u16,10021u16),
(46161u16,10022u16),(46164u16,10023u16),(46168u16,10024u16),(46176u16,10025u16),
(46177u16,10026u16),(46179u16,10027u16),(46181u16,10028u16),(46188u16,10029u16),
(46208u16,10030u16),(46216u16,10031u16),(46237u16,10032u16),(46244u16,10033u16),
(46248u16,10034u16),(46252u16,10035u16),(46261u16,10036u16),(46263u16,10037u16),
(46265u16,10038u16),(46272u16,10039u16),(46276u16,10040u16),(46280u16,10041u16),
(46288u16,10042u16),(46293u16,10043u16),(46300u16,10044u16),(46301u16,10045u16),
(46304u16,10046u16),(46307u16,10047u16),(46308u16,10048u16),(46310u16,10049u16),
(46316u16,10050u16),(46317u16,10051u16),(46319u16,10052u16),(46321u16,10053u16),
(46328u16,10054u16),(46356u16,10055u16),(46357u16,10056u16),(46360u16,10057u16),
(46363u16,10058u16),(46364u16,10059u16),(46372u16,10060u16),(46373u16,10061u16),
(46375u16,10062u16),(46376u16,10063u16),(46377u16,10064u16),(46378u16,10065u16),
(46384u16,10066u16),(46385u16,10067u16),(46388u16,10068u16),(46392u16,10069u16),
(46400u16,10166u16),(46401u16,10167u16),(46403u16,10168u16),(46404u16,10169u16),
(46405u16,10170u16),(46411u16,10171u16),(46412u16,10172u16),(46413u16,10173u16),
(46416u16,10174u16),(46420u16,10175u16),(46428u16,10176u16),(46429u16,10177u16),
(46431u16,10178u16),(46432u16,10179u16),(46433u16,10180u16),(46496u16,10181u16),
(46497u16,10182u16),(46500u16,10183u16),(46504u16,10184u16),(46506u16,10185u16),
(46507u16,10186u16),(46512u16,10187u16),(46513u16,10188u16),(46515u16,10189u16),
(46516u16,10190u16),(46517u16,10191u16),(46523u16,10192u16),(46524u16,10193u16),
(46525u16,10194u16),(46528u16,10195u16),(46532u16,10196u16),(46540u16,10197u16),
(46541u16,10198u16),(46543u16,10199u16),(46544u16,10200u16),(46545u16,10201u16),
(46552u16,10202u16),(46572u16,10203u16),(46608u16,10204u16),(46609u16,10205u16),
(46612u16,10206u16),(46616u16,10207u16),(46629u16,10208u16),(46636u16,10209u16),
(46644u16,10210u16),(46664u16,10211u16),(46692u16,10212u16),(46696u16,10213u16),
(46748u16,10214u16),(46749u16,10215u16),(46752u16,10216u16),(46756u16,10217u16),
(46763u16,10218u16),(46764u16,10219u16),(46769u16,10220u16),(46804u16,10221u16),
(46832u16,10222u16),(46836u16,10223u16),(46840u16,10224u16),(46848u16,10225u16),
(46849u16,10226u16),(46853u16,10227u16),(46888u16,10228u16),(46889u16,10229u16),
(46892u16,10230u16),(46895u16,10231u16),(46896u16,10232u16),(46904u16,10233u16),
(46905u16,10234u16),(46907u16,10235u16),(46916u16,10236u16),(46920u16,10237u16),
(46924u16,10238u16),(46932u16,10239u16),(46933u16,10240u16),(46944u16,10241u16),
(46948u16,10242u16),(46952u16,10243u16),(46960u16,10244u16),(46961u16,10245u16),
(46963u16,10246u16),(46965u16,10247u16),(46972u16,10248u16),(46973u16,10249u16),
(46976u16,10250u16),(46980u16,10251u16),(46988u16,10252u16),(46989u16,10253u16),
(46991u16,10254u16),(46992u16,10255u16),(46993u16,10256u16),(46994u16,10257u16),
(46998u16,10258u16),(46999u16,10259u16),(47000u16,10356u16),(47001u16,10357u16),
(47004u16,10358u16),(47008u16,10359u16),(47016u16,10360u16),(47017u16,10361u16),
(47019u16,10362u16),(47020u16,10363u16),(47021u16,10364u16),(47028u16,10365u16),
(47029u16,10366u16),(47032u16,10367u16),(47047u16,10368u16),(47049u16,10369u16),
(47084u16,10370u16),(47085u16,10371u16),(47088u16,10372u16),(47092u16,10373u16),
(47100u16,10374u16),(47101u16,10375u16),(47103u16,10376u16),(47104u16,10377u16),
(47105u16,10378u16),(47111u16,10379u16),(47112u16,10380u16),(47113u16,10381u16),
(47116u16,10382u16),(47120u16,10383u16),(47128u16,10384u16),(47129u16,10385u16),
(47131u16,10386u16),(47133u16,10387u16),(47140u16,10388u16),(47141u16,10389u16),
(47144u16,10390u16),(47148u16,10391u16),(47156u16,10392u16),(47157u16,10393u16),
(47159u16,10394u16),(47160u16,10395u16),(47161u16,10396u16),(47168u16,10397u16),
(47172u16,10398u16),(47185u16,10399u16),(47187u16,10400u16),(47196u16,10401u16),
(47197u16,10402u16),(47200u16,10403u16),(47204u16,10404u16),(47212u16,10405u16),
(47213u16,10406u16),(47215u16,10407u16),(47217u16,10408u16),(47224u16,10409u16),
(47228u16,10410u16),(47245u16,10411u16),(47272u16,10412u16),(47280u16,10413u16),
(47284u16,10414u16),(47288u16,10415u16),(47296u16,10416u16),(47297u16,10417u16),
(47299u16,10418u16),(47301u16,10419u16),(47308u16,10420u16),(47312u16,10421u16),
(47316u16,10422u16),(47325u16,10423u16),(47327u16,10424u16),(47329u16,10425u16),
(47336u16,10426u16),(47337u16,10427u16),(47340u16,10428u16),(47344u16,10429u16),
(47352u16,10430u16),(47353u16,10431u16),(47355u16,10432u16),(47357u16,10433u16),
(47364u16,10434u16),(47384u16,10435u16),(47392u16,10436u16),(47420u16,10437u16),
(47421u16,10438u16),(47424u16,10439u16),(47428u16,10440u16),(47436u16,10441u16),
(47439u16,10442u16),(47441u16,10443u16),(47448u16,10444u16),(47449u16,10445u16),
(47452u16,10446u16),(47456u16,10447u16),(47464u16,10448u16),(47465u16,10449u16),
(47467u16,10546u16),(47469u16,10547u16),(47476u16,10548u16),(47477u16,10549u16),
(47480u16,10550u16),(47484u16,10551u16),(47492u16,10552u16),(47493u16,10553u16),
(47495u16,10554u16),(47497u16,10555u16),(47498u16,10556u16),(47501u16,10557u16),
(47502u16,10558u16),(47532u16,10559u16),(47533u16,10560u16),(47536u16,10561u16),
(47540u16,10562u16),(47548u16,10563u16),(47549u16,10564u16),(47551u16,10565u16),
(47553u16,10566u16),(47560u16,10567u16),(47561u16,10568u16),(47564u16,10569u16),
(47566u16,10570u16),(47567u16,10571u16),(47568u16,10572u16),(47569u16,10573u16),
(47570u16,10574u16),(47576u16,10575u16),(47577u16,10576u16),(47579u16,10577u16),
(47581u16,10578u16),(47582u16,10579u16),(47585u16,10580u16),(47587u16,10581u16),
(47588u16,10582u16),(47589u16,10583u16),(47592u16,10584u16),(47596u16,10585u16),
(47604u16,10586u16),(47605u16,10587u16),(47607u16,10588u16),(47608u16,10589u16),
(47609u16,10590u16),(47610u16,10591u16),(47616u16,10592u16),(47617u16,10593u16),
(47624u16,10594u16),(47637u16,10595u16),(47672u16,10596u16),(47673u16,10597u16),
(47676u16,10598u16),(47680u16,10599u16),(47682u16,10600u16),(47688u16,10601u16),
(47689u16,10602u16),(47691u16,10603u16),(47693u16,10604u16),(47694u16,10605u16),
(47699u16,10606u16),(47700u16,10607u16),(47701u16,10608u16),(47704u16,10609u16),
(47708u16,10610u16),(47716u16,10611u16),(47717u16,10612u16),(47719u16,10613u16),
(47720u16,10614u16),(47721u16,10615u16),(47728u16,10616u16),(47729u16,10617u16),
(47732u16,10618u16),(47736u16,10619u16),(47747u16,10620u16),(47748u16,10621u16),
(47749u16,10622u16),(47751u16,10623u16),(47756u16,10624u16),(47784u16,10625u16),
(47785u16,10626u16),(47787u16,10627u16),(47788u16,10628u16),(47792u16,10629u16),
(47794u16,10630u16),(47800u16,10631u16),(47801u16,10632u16),(47803u16,10633u16),
(47805u16,10634u16),(47812u16,10635u16),(47816u16,10636u16),(47832u16,10637u16),
(47833u16,10638u16),(47868u16,10639u16),(47872u16,10736u16),(47876u16,10737u16),
(47885u16,10738u16),(47887u16,10739u16),(47889u16,10740u16),(47896u16,10741u16),
(47900u16,10742u16),(47904u16,10743u16),(47913u16,10744u16),(47915u16,10745u16),
(47924u16,10746u16),(47925u16,10747u16),(47926u16,10748u16),(47928u16,10749u16),
(47931u16,10750u16),(47932u16,10751u16),(47933u16,10752u16),(47934u16,10753u16),
(47940u16,10754u16),(47941u16,10755u16),(47943u16,10756u16),(47945u16,10757u16),
(47949u16,10758u16),(47951u16,10759u16),(47952u16,10760u16),(47956u16,10761u16),
(47960u16,10762u16),(47969u16,10763u16),(47971u16,10764u16),(47980u16,10765u16),
(48008u16,10766u16),(48012u16,10767u16),(48016u16,10768u16),(48036u16,10769u16),
(48040u16,10770u16),(48044u16,10771u16),(48052u16,10772u16),(48055u16,10773u16),
(48064u16,10774u16),(48068u16,10775u16),(48072u16,10776u16),(48080u16,10777u16),
(48083u16,10778u16),(48120u16,10779u16),(48121u16,10780u16),(48124u16,10781u16),
(48127u16,10782u16),(48128u16,10783u16),(48130u16,10784u16),(48136u16,10785u16),
(48137u16,10786u16),(48139u16,10787u16),(48140u16,10788u16),(48141u16,10789u16),
(48143u16,10790u16),(48145u16,10791u16),(48148u16,10792u16),(48149u16,10793u16),
(48150u16,10794u16),(48151u16,10795u16),(48152u16,10796u16),(48155u16,10797u16),
(48156u16,10798u16),(48157u16,10799u16),(48158u16,10800u16),(48159u16,10801u16),
(48164u16,10802u16),(48165u16,10803u16),(48167u16,10804u16),(48169u16,10805u16),
(48173u16,10806u16),(48176u16,10807u16),(48177u16,10808u16),(48180u16,10809u16),
(48184u16,10810u16),(48192u16,10811u16),(48193u16,10812u16),(48195u16,10813u16),
(48196u16,10814u16),(48197u16,10815u16),(48201u16,10816u16),(48204u16,10817u16),
(48205u16,10818u16),(48208u16,10819u16),(48221u16,10820u16),(48260u16,10821u16),
(48261u16,10822u16),(48264u16,10823u16),(48267u16,10824u16),(48268u16,10825u16),
(48270u16,10826u16),(48276u16,10827u16),(48277u16,10828u16),(48279u16,10829u16),
(48281u16,10926u16),(48282u16,10927u16),(48288u16,10928u16),(48289u16,10929u16),
(48292u16,10930u16),(48295u16,10931u16),(48296u16,10932u16),(48304u16,10933u16),
(48305u16,10934u16),(48307u16,10935u16),(48308u16,10936u16),(48309u16,10937u16),
(48316u16,10938u16),(48317u16,10939u16),(48320u16,10940u16),(48324u16,10941u16),
(48333u16,10942u16),(48335u16,10943u16),(48336u16,10944u16),(48337u16,10945u16),
(48341u16,10946u16),(48344u16,10947u16),(48348u16,10948u16),(48372u16,10949u16),
(48373u16,10950u16),(48374u16,10951u16),(48376u16,10952u16),(48380u16,10953u16),
(48388u16,10954u16),(48389u16,10955u16),(48391u16,10956u16),(48393u16,10957u16),
(48400u16,10958u16),(48404u16,10959u16),(48420u16,10960u16),(48428u16,10961u16),
(48448u16,10962u16),(48456u16,10963u16),(48457u16,10964u16),(48460u16,10965u16),
(48464u16,10966u16),(48472u16,10967u16),(48473u16,10968u16),(48484u16,10969u16),
(48488u16,10970u16),(48512u16,10971u16),(48513u16,10972u16),(48516u16,10973u16),
(48519u16,10974u16),(48520u16,10975u16),(48521u16,10976u16),(48522u16,10977u16),
(48528u16,10978u16),(48529u16,10979u16),(48531u16,10980u16),(48533u16,10981u16),
(48537u16,10982u16),(48538u16,10983u16),(48540u16,10984u16),(48548u16,10985u16),
(48560u16,10986u16),(48568u16,10987u16),(48596u16,10988u16),(48597u16,10989u16),
(48600u16,10990u16),(48604u16,10991u16),(48617u16,10992u16),(48624u16,10993u16),
(48628u16,10994u16),(48632u16,10995u16),(48640u16,10996u16),(48643u16,10997u16),
(48645u16,10998u16),(48652u16,10999u16),(48653u16,11000u16),(48656u16,11001u16),
(48660u16,11002u16),(48668u16,11003u16),(48669u16,11004u16),(48671u16,11005u16),
(48708u16,11006u16),(48709u16,11007u16),(48712u16,11008u16),(48716u16,11009u16),
(48718u16,11010u16),(48724u16,11011u16),(48725u16,11012u16),(48727u16,11013u16),
(48729u16,11014u16),(48730u16,11015u16),(48731u16,11016u16),(48736u16,11017u16),
(48737u16,11018u16),(48740u16,11019u16),(48744u16,11116u16),(48746u16,11117u16),
(48752u16,11118u16),(48753u16,11119u16),(48755u16,11120u16),(48756u16,11121u16),
(48757u16,11122u16),(48763u16,11123u16),(48764u16,11124u16),(48765u16,11125u16),
(48768u16,11126u16),(48772u16,11127u16),(48780u16,11128u16),(48781u16,11129u16),
(48783u16,11130u16),(48784u16,11131u16),(48785u16,11132u16),(48792u16,11133u16),
(48793u16,11134u16),(48808u16,11135u16),(48848u16,11136u16),(48849u16,11137u16),
(48852u16,11138u16),(48855u16,11139u16),(48856u16,11140u16),(48864u16,11141u16),
(48867u16,11142u16),(48868u16,11143u16),(48869u16,11144u16),(48876u16,11145u16),
(48897u16,11146u16),(48904u16,11147u16),(48905u16,11148u16),(48920u16,11149u16),
(48921u16,11150u16),(48923u16,11151u16),(48924u16,11152u16),(48925u16,11153u16),
(48960u16,11154u16),(48961u16,11155u16),(48964u16,11156u16),(48968u16,11157u16),
(48976u16,11158u16),(48977u16,11159u16),(48981u16,11160u16),(49044u16,11161u16),
(49072u16,11162u16),(49093u16,11163u16),(49100u16,11164u16),(49101u16,11165u16),
(49104u16,11166u16),(49108u16,11167u16),(49116u16,11168u16),(49119u16,11169u16),
(49121u16,11170u16),(49212u16,11171u16),(49233u16,11172u16),(49240u16,11173u16),
(49244u16,11174u16),(49248u16,11175u16),(49256u16,11176u16),(49257u16,11177u16),
(49296u16,11178u16),(49297u16,11179u16),(49300u16,11180u16),(49304u16,11181u16),
(49312u16,11182u16),(49313u16,11183u16),(49315u16,11184u16),(49317u16,11185u16),
(49324u16,11186u16),(49325u16,11187u16),(49327u16,11188u16),(49328u16,11189u16),
(49331u16,11190u16),(49332u16,11191u16),(49333u16,11192u16),(49334u16,11193u16),
(49340u16,11194u16),(49341u16,11195u16),(49343u16,11196u16),(49344u16,11197u16),
(49345u16,11198u16),(49349u16,11199u16),(49352u16,11200u16),(49353u16,11201u16),
(49356u16,11202u16),(49360u16,11203u16),(49368u16,11204u16),(49369u16,11205u16),
(49371u16,11206u16),(49372u16,11207u16),(49373u16,11208u16),(49380u16,11209u16),
(49381u16,11306u16),(49384u16,11307u16),(49388u16,11308u16),(49396u16,11309u16),
(49397u16,11310u16),(49399u16,11311u16),(49401u16,11312u16),(49408u16,11313u16),
(49412u16,11314u16),(49416u16,11315u16),(49424u16,11316u16),(49429u16,11317u16),
(49436u16,11318u16),(49437u16,11319u16),(49438u16,11320u16),(49439u16,11321u16),
(49440u16,11322u16),(49443u16,11323u16),(49444u16,11324u16),(49446u16,11325u16),
(49447u16,11326u16),(49452u16,11327u16),(49453u16,11328u16),(49455u16,11329u16),
(49456u16,11330u16),(49457u16,11331u16),(49462u16,11332u16),(49464u16,11333u16),
(49465u16,11334u16),(49468u16,11335u16),(49472u16,11336u16),(49480u16,11337u16),
(49481u16,11338u16),(49483u16,11339u16),(49484u16,11340u16),(49485u16,11341u16),
(49492u16,11342u16),(49493u16,11343u16),(49496u16,11344u16),(49500u16,11345u16),
(49508u16,11346u16),(49509u16,11347u16),(49511u16,11348u16),(49512u16,11349u16),
(49513u16,11350u16),(49520u16,11351u16),(49524u16,11352u16),(49528u16,11353u16),
(49541u16,11354u16),(49548u16,11355u16),(49549u16,11356u16),(49550u16,11357u16),
(49552u16,11358u16),(49556u16,11359u16),(49558u16,11360u16),(49564u16,11361u16),
(49565u16,11362u16),(49567u16,11363u16),(49569u16,11364u16),(49573u16,11365u16),
(49576u16,11366u16),(49577u16,11367u16),(49580u16,11368u16),(49584u16,11369u16),
(49597u16,11370u16),(49604u16,11371u16),(49608u16,11372u16),(49612u16,11373u16),
(49620u16,11374u16),(49623u16,11375u16),(49624u16,11376u16),(49632u16,11377u16),
(49636u16,11378u16),(49640u16,11379u16),(49648u16,11380u16),(49649u16,11381u16),
(49651u16,11382u16),(49660u16,11383u16),(49661u16,11384u16),(49664u16,11385u16),
(49668u16,11386u16),(49676u16,11387u16),(49677u16,11388u16),(49679u16,11389u16),
(49681u16,11390u16),(49688u16,11391u16),(49689u16,11392u16),(49692u16,11393u16),
(49695u16,11394u16),(49696u16,11395u16),(49704u16,11396u16),(49705u16,11397u16),
(49707u16,11398u16),(49709u16,11399u16),(49711u16,11496u16),(49713u16,11497u16),
(49714u16,11498u16),(49716u16,11499u16),(49736u16,11500u16),(49744u16,11501u16),
(49745u16,11502u16),(49748u16,11503u16),(49752u16,11504u16),(49760u16,11505u16),
(49765u16,11506u16),(49772u16,11507u16),(49773u16,11508u16),(49776u16,11509u16),
(49780u16,11510u16),(49788u16,11511u16),(49789u16,11512u16),(49791u16,11513u16),
(49793u16,11514u16),(49800u16,11515u16),(49801u16,11516u16),(49808u16,11517u16),
(49816u16,11518u16),(49819u16,11519u16),(49821u16,11520u16),(49828u16,11521u16),
(49829u16,11522u16),(49832u16,11523u16),(49836u16,11524u16),(49837u16,11525u16),
(49844u16,11526u16),(49845u16,11527u16),(49847u16,11528u16),(49849u16,11529u16),
(49884u16,11530u16),(49885u16,11531u16),(49888u16,11532u16),(49891u16,11533u16),
(49892u16,11534u16),(49899u16,11535u16),(49900u16,11536u16),(49901u16,11537u16),
(49903u16,11538u16),(49905u16,11539u16),(49910u16,11540u16),(49912u16,11541u16),
(49913u16,11542u16),(49915u16,11543u16),(49916u16,11544u16),(49920u16,11545u16),
(49928u16,11546u16),(49929u16,11547u16),(49932u16,11548u16),(49933u16,11549u16),
(49939u16,11550u16),(49940u16,11551u16),(49941u16,11552u16),(49944u16,11553u16),
(49948u16,11554u16),(49956u16,11555u16),(49957u16,11556u16),(49960u16,11557u16),
(49961u16,11558u16),(49989u16,11559u16),(50024u16,11560u16),(50025u16,11561u16),
(50028u16,11562u16),(50032u16,11563u16),(50034u16,11564u16),(50040u16,11565u16),
(50041u16,11566u16),(50044u16,11567u16),(50045u16,11568u16),(50052u16,11569u16),
(50056u16,11570u16),(50060u16,11571u16),(50112u16,11572u16),(50136u16,11573u16),
(50137u16,11574u16),(50140u16,11575u16),(50143u16,11576u16),(50144u16,11577u16),
(50146u16,11578u16),(50152u16,11579u16),(50153u16,11580u16),(50157u16,11581u16),
(50164u16,11582u16),(50165u16,11583u16),(50168u16,11584u16),(50184u16,11585u16),
(50192u16,11586u16),(50212u16,11587u16),(50220u16,11588u16),(50224u16,11589u16),
(50228u16,11686u16),(50236u16,11687u16),(50237u16,11688u16),(50248u16,11689u16),
(50276u16,11690u16),(50277u16,11691u16),(50280u16,11692u16),(50284u16,11693u16),
(50292u16,11694u16),(50293u16,11695u16),(50297u16,11696u16),(50304u16,11697u16),
(50324u16,11698u16),(50332u16,11699u16),(50360u16,11700u16),(50364u16,11701u16),
(50409u16,11702u16),(50416u16,11703u16),(50417u16,11704u16),(50420u16,11705u16),
(50424u16,11706u16),(50426u16,11707u16),(50431u16,11708u16),(50432u16,11709u16),
(50433u16,11710u16),(50444u16,11711u16),(50448u16,11712u16),(50452u16,11713u16),
(50460u16,11714u16),(50472u16,11715u16),(50473u16,11716u16),(50476u16,11717u16),
(50480u16,11718u16),(50488u16,11719u16),(50489u16,11720u16),(50491u16,11721u16),
(50493u16,11722u16),(50500u16,11723u16),(50501u16,11724u16),(50504u16,11725u16),
(50505u16,11726u16),(50506u16,11727u16),(50508u16,11728u16),(50509u16,11729u16),
(50510u16,11730u16),(50515u16,11731u16),(50516u16,11732u16),(50517u16,11733u16),
(50519u16,11734u16),(50520u16,11735u16),(50521u16,11736u16),(50525u16,11737u16),
(50526u16,11738u16),(50528u16,11739u16),(50529u16,11740u16),(50532u16,11741u16),
(50536u16,11742u16),(50544u16,11743u16),(50545u16,11744u16),(50547u16,11745u16),
(50548u16,11746u16),(50549u16,11747u16),(50556u16,11748u16),(50557u16,11749u16),
(50560u16,11750u16),(50564u16,11751u16),(50567u16,11752u16),(50572u16,11753u16),
(50573u16,11754u16),(50575u16,11755u16),(50577u16,11756u16),(50581u16,11757u16),
(50583u16,11758u16),(50584u16,11759u16),(50588u16,11760u16),(50592u16,11761u16),
(50601u16,11762u16),(50612u16,11763u16),(50613u16,11764u16),(50616u16,11765u16),
(50617u16,11766u16),(50619u16,11767u16),(50620u16,11768u16),(50621u16,11769u16),
(50622u16,11770u16),(50628u16,11771u16),(50629u16,11772u16),(50630u16,11773u16),
(50631u16,11774u16),(50632u16,11775u16),(50633u16,11776u16),(50634u16,11777u16),
(50636u16,11778u16),(50638u16,11779u16),(50640u16,11876u16),(50641u16,11877u16),
(50644u16,11878u16),(50648u16,11879u16),(50656u16,11880u16),(50657u16,11881u16),
(50659u16,11882u16),(50661u16,11883u16),(50668u16,11884u16),(50669u16,11885u16),
(50670u16,11886u16),(50672u16,11887u16),(50676u16,11888u16),(50678u16,11889u16),
(50679u16,11890u16),(50684u16,11891u16),(50685u16,11892u16),(50686u16,11893u16),
(50687u16,11894u16),(50688u16,11895u16),(50689u16,11896u16),(50693u16,11897u16),
(50694u16,11898u16),(50695u16,11899u16),(50696u16,11900u16),(50700u16,11901u16),
(50704u16,11902u16),(50712u16,11903u16),(50713u16,11904u16),(50715u16,11905u16),
(50716u16,11906u16),(50724u16,11907u16),(50725u16,11908u16),(50728u16,11909u16),
(50732u16,11910u16),(50733u16,11911u16),(50734u16,11912u16),(50736u16,11913u16),
(50739u16,11914u16),(50740u16,11915u16),(50741u16,11916u16),(50743u16,11917u16),
(50745u16,11918u16),(50747u16,11919u16),(50752u16,11920u16),(50753u16,11921u16),
(50756u16,11922u16),(50760u16,11923u16),(50768u16,11924u16),(50769u16,11925u16),
(50771u16,11926u16),(50772u16,11927u16),(50773u16,11928u16),(50780u16,11929u16),
(50781u16,11930u16),(50784u16,11931u16),(50796u16,11932u16),(50799u16,11933u16),
(50801u16,11934u16),(50808u16,11935u16),(50809u16,11936u16),(50812u16,11937u16),
(50816u16,11938u16),(50824u16,11939u16),(50825u16,11940u16),(50827u16,11941u16),
(50829u16,11942u16),(50836u16,11943u16),(50837u16,11944u16),(50840u16,11945u16),
(50844u16,11946u16),(50852u16,11947u16),(50853u16,11948u16),(50855u16,11949u16),
(50857u16,11950u16),(50864u16,11951u16),(50865u16,11952u16),(50868u16,11953u16),
(50872u16,11954u16),(50873u16,11955u16),(50874u16,11956u16),(50880u16,11957u16),
(50881u16,11958u16),(50883u16,11959u16),(50885u16,11960u16),(50892u16,11961u16),
(50893u16,11962u16),(50896u16,11963u16),(50900u16,11964u16),(50908u16,11965u16),
(50909u16,11966u16),(50912u16,11967u16),(50913u16,11968u16),(50920u16,11969u16),
(50921u16,12066u16),(50924u16,12067u16),(50928u16,12068u16),(50936u16,12069u16),
(50937u16,12070u16),(50941u16,12071u16),(50948u16,12072u16),(50949u16,12073u16),
(50952u16,12074u16),(50956u16,12075u16),(50964u16,12076u16),(50965u16,12077u16),
(50967u16,12078u16),(50969u16,12079u16),(50976u16,12080u16),(50977u16,12081u16),
(50980u16,12082u16),(50984u16,12083u16),(50992u16,12084u16),(50993u16,12085u16),
(50995u16,12086u16),(50997u16,12087u16),(50999u16,12088u16),(51004u16,12089u16),
(51005u16,12090u16),(51008u16,12091u16),(51012u16,12092u16),(51018u16,12093u16),
(51020u16,12094u16),(51021u16,12095u16),(51023u16,12096u16),(51025u16,12097u16),
(51026u16,12098u16),(51027u16,12099u16),(51028u16,12100u16),(51029u16,12101u16),
(51030u16,12102u16),(51031u16,12103u16),(51032u16,12104u16),(51036u16,12105u16),
(51040u16,12106u16),(51048u16,12107u16),(51051u16,12108u16),(51060u16,12109u16),
(51061u16,12110u16),(51064u16,12111u16),(51068u16,12112u16),(51069u16,12113u16),
(51070u16,12114u16),(51075u16,12115u16),(51076u16,12116u16),(51077u16,12117u16),
(51079u16,12118u16),(51080u16,12119u16),(51081u16,12120u16),(51082u16,12121u16),
(51086u16,12122u16),(51088u16,12123u16),(51089u16,12124u16),(51092u16,12125u16),
(51094u16,12126u16),(51095u16,12127u16),(51096u16,12128u16),(51098u16,12129u16),
(51104u16,12130u16),(51105u16,12131u16),(51107u16,12132u16),(51108u16,12133u16),
(51109u16,12134u16),(51110u16,12135u16),(51116u16,12136u16),(51117u16,12137u16),
(51120u16,12138u16),(51124u16,12139u16),(51132u16,12140u16),(51133u16,12141u16),
(51135u16,12142u16),(51136u16,12143u16),(51137u16,12144u16),(51144u16,12145u16),
(51145u16,12146u16),(51148u16,12147u16),(51150u16,12148u16),(51152u16,12149u16),
(51160u16,12150u16),(51165u16,12151u16),(51172u16,12152u16),(51176u16,12153u16),
(51180u16,12154u16),(51200u16,12155u16),(51201u16,12156u16),(51204u16,12157u16),
(51208u16,12158u16),(51210u16,12159u16),(51216u16,12256u16),(51217u16,12257u16),
(51219u16,12258u16),(51221u16,12259u16),(51222u16,12260u16),(51228u16,12261u16),
(51229u16,12262u16),(51232u16,12263u16),(51236u16,12264u16),(51244u16,12265u16),
(51245u16,12266u16),(51247u16,12267u16),(51249u16,12268u16),(51256u16,12269u16),
(51260u16,12270u16),(51264u16,12271u16),(51272u16,12272u16),(51273u16,12273u16),
(51276u16,12274u16),(51277u16,12275u16),(51284u16,12276u16),(51312u16,12277u16),
(51313u16,12278u16),(51316u16,12279u16),(51320u16,12280u16),(51322u16,12281u16),
(51328u16,12282u16),(51329u16,12283u16),(51331u16,12284u16),(51333u16,12285u16),
(51334u16,12286u16),(51335u16,12287u16),(51339u16,12288u16),(51340u16,12289u16),
(51341u16,12290u16),(51348u16,12291u16),(51357u16,12292u16),(51359u16,12293u16),
(51361u16,12294u16),(51368u16,12295u16),(51388u16,12296u16),(51389u16,12297u16),
(51396u16,12298u16),(51400u16,12299u16),(51404u16,12300u16),(51412u16,12301u16),
(51413u16,12302u16),(51415u16,12303u16),(51417u16,12304u16),(51424u16,12305u16),
(51425u16,12306u16),(51428u16,12307u16),(51445u16,12308u16),(51452u16,12309u16),
(51453u16,12310u16),(51456u16,12311u16),(51460u16,12312u16),(51461u16,12313u16),
(51462u16,12314u16),(51468u16,12315u16),(51469u16,12316u16),(51471u16,12317u16),
(51473u16,12318u16),(51480u16,12319u16),(51500u16,12320u16),(51508u16,12321u16),
(51536u16,12322u16),(51537u16,12323u16),(51540u16,12324u16),(51544u16,12325u16),
(51552u16,12326u16),(51553u16,12327u16),(51555u16,12328u16),(51564u16,12329u16),
(51568u16,12330u16),(51572u16,12331u16),(51580u16,12332u16),(51592u16,12333u16),
(51593u16,12334u16),(51596u16,12335u16),(51600u16,12336u16),(51608u16,12337u16),
(51609u16,12338u16),(51611u16,12339u16),(51613u16,12340u16),(51648u16,12341u16),
(51649u16,12342u16),(51652u16,12343u16),(51655u16,12344u16),(51656u16,12345u16),
(51658u16,12346u16),(51664u16,12347u16),(51665u16,12348u16),(51667u16,12349u16),
(51669u16,12446u16),(51670u16,12447u16),(51673u16,12448u16),(51674u16,12449u16),
(51676u16,12450u16),(51677u16,12451u16),(51680u16,12452u16),(51682u16,12453u16),
(51684u16,12454u16),(51687u16,12455u16),(51692u16,12456u16),(51693u16,12457u16),
(51695u16,12458u16),(51696u16,12459u16),(51697u16,12460u16),(51704u16,12461u16),
(51705u16,12462u16),(51708u16,12463u16),(51712u16,12464u16),(51720u16,12465u16),
(51721u16,12466u16),(51723u16,12467u16),(51724u16,12468u16),(51725u16,12469u16),
(51732u16,12470u16),(51736u16,12471u16),(51753u16,12472u16),(51788u16,12473u16),
(51789u16,12474u16),(51792u16,12475u16),(51796u16,12476u16),(51804u16,12477u16),
(51805u16,12478u16),(51807u16,12479u16),(51808u16,12480u16),(51809u16,12481u16),
(51816u16,12482u16),(51837u16,12483u16),(51844u16,12484u16),(51864u16,12485u16),
(51900u16,12486u16),(51901u16,12487u16),(51904u16,12488u16),(51908u16,12489u16),
(51916u16,12490u16),(51917u16,12491u16),(51919u16,12492u16),(51921u16,12493u16),
(51923u16,12494u16),(51928u16,12495u16),(51929u16,12496u16),(51936u16,12497u16),
(51948u16,12498u16),(51956u16,12499u16),(51976u16,12500u16),(51984u16,12501u16),
(51988u16,12502u16),(51992u16,12503u16),(52000u16,12504u16),(52001u16,12505u16),
(52033u16,12506u16),(52040u16,12507u16),(52041u16,12508u16),(52044u16,12509u16),
(52048u16,12510u16),(52056u16,12511u16),(52057u16,12512u16),(52061u16,12513u16),
(52068u16,12514u16),(52088u16,12515u16),(52089u16,12516u16),(52124u16,12517u16),
(52152u16,12518u16),(52180u16,12519u16),(52196u16,12520u16),(52199u16,12521u16),
(52201u16,12522u16),(52236u16,12523u16),(52237u16,12524u16),(52240u16,12525u16),
(52244u16,12526u16),(52252u16,12527u16),(52253u16,12528u16),(52257u16,12529u16),
(52258u16,12530u16),(52263u16,12531u16),(52264u16,12532u16),(52265u16,12533u16),
(52268u16,12534u16),(52270u16,12535u16),(52272u16,12536u16),(52280u16,12537u16),
(52281u16,12538u16),(52283u16,12539u16),(52284u16,12636u16),(52285u16,12637u16),
(52286u16,12638u16),(52292u16,12639u16),(52293u16,12640u16),(52296u16,12641u16),
(52300u16,12642u16),(52308u16,12643u16),(52309u16,12644u16),(52311u16,12645u16),
(52312u16,12646u16),(52313u16,12647u16),(52320u16,12648u16),(52324u16,12649u16),
(52326u16,12650u16),(52328u16,12651u16),(52336u16,12652u16),(52341u16,12653u16),
(52376u16,12654u16),(52377u16,12655u16),(52380u16,12656u16),(52384u16,12657u16),
(52392u16,12658u16),(52393u16,12659u16),(52395u16,12660u16),(52396u16,12661u16),
(52397u16,12662u16),(52404u16,12663u16),(52405u16,12664u16),(52408u16,12665u16),
(52412u16,12666u16),(52420u16,12667u16),(52421u16,12668u16),(52423u16,12669u16),
(52425u16,12670u16),(52432u16,12671u16),(52436u16,12672u16),(52452u16,12673u16),
(52460u16,12674u16),(52464u16,12675u16),(52481u16,12676u16),(52488u16,12677u16),
(52489u16,12678u16),(52492u16,12679u16),(52496u16,12680u16),(52504u16,12681u16),
(52505u16,12682u16),(52507u16,12683u16),(52509u16,12684u16),(52516u16,12685u16),
(52520u16,12686u16),(52524u16,12687u16),(52537u16,12688u16),(52572u16,12689u16),
(52576u16,12690u16),(52580u16,12691u16),(52588u16,12692u16),(52589u16,12693u16),
(52591u16,12694u16),(52593u16,12695u16),(52600u16,12696u16),(52616u16,12697u16),
(52628u16,12698u16),(52629u16,12699u16),(52632u16,12700u16),(52636u16,12701u16),
(52644u16,12702u16),(52645u16,12703u16),(52647u16,12704u16),(52649u16,12705u16),
(52656u16,12706u16),(52676u16,12707u16),(52684u16,12708u16),(52688u16,12709u16),
(52712u16,12710u16),(52716u16,12711u16),(52720u16,12712u16),(52728u16,12713u16),
(52729u16,12714u16),(52731u16,12715u16),(52733u16,12716u16),(52740u16,12717u16),
(52744u16,12718u16),(52748u16,12719u16),(52756u16,12720u16),(52761u16,12721u16),
(52768u16,12722u16),(52769u16,12723u16),(52772u16,12724u16),(52776u16,12725u16),
(52784u16,12726u16),(52785u16,12727u16),(52787u16,12728u16),(52789u16,12729u16),
(52824u16,12826u16),(52825u16,12827u16),(52828u16,12828u16),(52831u16,12829u16),
(52832u16,12830u16),(52833u16,12831u16),(52840u16,12832u16),(52841u16,12833u16),
(52843u16,12834u16),(52845u16,12835u16),(52852u16,12836u16),(52853u16,12837u16),
(52856u16,12838u16),(52860u16,12839u16),(52868u16,12840u16),(52869u16,12841u16),
(52871u16,12842u16),(52873u16,12843u16),(52880u16,12844u16),(52881u16,12845u16),
(52884u16,12846u16),(52888u16,12847u16),(52896u16,12848u16),(52897u16,12849u16),
(52899u16,12850u16),(52900u16,12851u16),(52901u16,12852u16),(52908u16,12853u16),
(52909u16,12854u16),(52929u16,12855u16),(52964u16,12856u16),(52965u16,12857u16),
(52968u16,12858u16),(52971u16,12859u16),(52972u16,12860u16),(52980u16,12861u16),
(52981u16,12862u16),(52983u16,12863u16),(52984u16,12864u16),(52985u16,12865u16),
(52992u16,12866u16),(52993u16,12867u16),(52996u16,12868u16),(53000u16,12869u16),
(53008u16,12870u16),(53009u16,12871u16),(53011u16,12872u16),(53013u16,12873u16),
(53020u16,12874u16),(53024u16,12875u16),(53028u16,12876u16),(53036u16,12877u16),
(53037u16,12878u16),(53039u16,12879u16),(53040u16,12880u16),(53041u16,12881u16),
(53048u16,12882u16),(53076u16,12883u16),(53077u16,12884u16),(53080u16,12885u16),
(53084u16,12886u16),(53092u16,12887u16),(53093u16,12888u16),(53095u16,12889u16),
(53097u16,12890u16),(53104u16,12891u16),(53105u16,12892u16),(53108u16,12893u16),
(53112u16,12894u16),(53120u16,12895u16),(53125u16,12896u16),(53132u16,12897u16),
(53153u16,12898u16),(53160u16,12899u16),(53168u16,12900u16),(53188u16,12901u16),
(53216u16,12902u16),(53217u16,12903u16),(53220u16,12904u16),(53224u16,12905u16),
(53232u16,12906u16),(53233u16,12907u16),(53235u16,12908u16),(53237u16,12909u16),
(53244u16,12910u16),(53248u16,12911u16),(53252u16,12912u16),(53265u16,12913u16),
(53272u16,12914u16),(53293u16,12915u16),(53300u16,12916u16),(53301u16,12917u16),
(53304u16,12918u16),(53308u16,12919u16),(53316u16,13016u16),(53317u16,13017u16),
(53319u16,13018u16),(53321u16,13019u16),(53328u16,13020u16),(53332u16,13021u16),
(53336u16,13022u16),(53344u16,13023u16),(53356u16,13024u16),(53357u16,13025u16),
(53360u16,13026u16),(53364u16,13027u16),(53372u16,13028u16),(53373u16,13029u16),
(53377u16,13030u16),(53412u16,13031u16),(53413u16,13032u16),(53416u16,13033u16),
(53420u16,13034u16),(53428u16,13035u16),(53429u16,13036u16),(53431u16,13037u16),
(53433u16,13038u16),(53440u16,13039u16),(53441u16,13040u16),(53444u16,13041u16),
(53448u16,13042u16),(53449u16,13043u16),(53456u16,13044u16),(53457u16,13045u16),
(53459u16,13046u16),(53460u16,13047u16),(53461u16,13048u16),(53468u16,13049u16),
(53469u16,13050u16),(53472u16,13051u16),(53476u16,13052u16),(53484u16,13053u16),
(53485u16,13054u16),(53487u16,13055u16),(53488u16,13056u16),(53489u16,13057u16),
(53496u16,13058u16),(53517u16,13059u16),(53552u16,13060u16),(53553u16,13061u16),
(53556u16,13062u16),(53560u16,13063u16),(53562u16,13064u16),(53568u16,13065u16),
(53569u16,13066u16),(53571u16,13067u16),(53572u16,13068u16),(53573u16,13069u16),
(53580u16,13070u16),(53581u16,13071u16),(53584u16,13072u16),(53588u16,13073u16),
(53596u16,13074u16),(53597u16,13075u16),(53599u16,13076u16),(53601u16,13077u16),
(53608u16,13078u16),(53612u16,13079u16),(53628u16,13080u16),(53636u16,13081u16),
(53640u16,13082u16),(53664u16,13083u16),(53665u16,13084u16),(53668u16,13085u16),
(53672u16,13086u16),(53680u16,13087u16),(53681u16,13088u16),(53683u16,13089u16),
(53685u16,13090u16),(53690u16,13091u16),(53692u16,13092u16),(53696u16,13093u16),
(53720u16,13094u16),(53748u16,13095u16),(53752u16,13096u16),(53767u16,13097u16),
(53769u16,13098u16),(53776u16,13099u16),(53804u16,13100u16),(53805u16,13101u16),
(53808u16,13102u16),(53812u16,13103u16),(53820u16,13104u16),(53821u16,13105u16),
(53823u16,13106u16),(53825u16,13107u16),(53832u16,13108u16),(53852u16,13109u16),
(53860u16,13206u16),(53888u16,13207u16),(53889u16,13208u16),(53892u16,13209u16),
(53896u16,13210u16),(53904u16,13211u16),(53905u16,13212u16),(53909u16,13213u16),
(53916u16,13214u16),(53920u16,13215u16),(53924u16,13216u16),(53932u16,13217u16),
(53937u16,13218u16),(53944u16,13219u16),(53945u16,13220u16),(53948u16,13221u16),
(53951u16,13222u16),(53952u16,13223u16),(53954u16,13224u16),(53960u16,13225u16),
(53961u16,13226u16),(53963u16,13227u16),(53972u16,13228u16),(53976u16,13229u16),
(53980u16,13230u16),(53988u16,13231u16),(53989u16,13232u16),(54000u16,13233u16),
(54001u16,13234u16),(54004u16,13235u16),(54008u16,13236u16),(54016u16,13237u16),
(54017u16,13238u16),(54019u16,13239u16),(54021u16,13240u16),(54028u16,13241u16),
(54029u16,13242u16),(54030u16,13243u16),(54032u16,13244u16),(54036u16,13245u16),
(54038u16,13246u16),(54044u16,13247u16),(54045u16,13248u16),(54047u16,13249u16),
(54048u16,13250u16),(54049u16,13251u16),(54053u16,13252u16),(54056u16,13253u16),
(54057u16,13254u16),(54060u16,13255u16),(54064u16,13256u16),(54072u16,13257u16),
(54073u16,13258u16),(54075u16,13259u16),(54076u16,13260u16),(54077u16,13261u16),
(54084u16,13262u16),(54085u16,13263u16),(54140u16,13264u16),(54141u16,13265u16),
(54144u16,13266u16),(54148u16,13267u16),(54156u16,13268u16),(54157u16,13269u16),
(54159u16,13270u16),(54160u16,13271u16),(54161u16,13272u16),(54168u16,13273u16),
(54169u16,13274u16),(54172u16,13275u16),(54176u16,13276u16),(54184u16,13277u16),
(54185u16,13278u16),(54187u16,13279u16),(54189u16,13280u16),(54196u16,13281u16),
(54200u16,13282u16),(54204u16,13283u16),(54212u16,13284u16),(54213u16,13285u16),
(54216u16,13286u16),(54217u16,13287u16),(54224u16,13288u16),(54232u16,13289u16),
(54241u16,13290u16),(54243u16,13291u16),(54252u16,13292u16),(54253u16,13293u16),
(54256u16,13294u16),(54260u16,13295u16),(54268u16,13296u16),(54269u16,13297u16),
(54271u16,13298u16),(54273u16,13299u16),(54280u16,13396u16),(54301u16,13397u16),
(54336u16,13398u16),(54340u16,13399u16),(54364u16,13400u16),(54368u16,13401u16),
(54372u16,13402u16),(54381u16,13403u16),(54383u16,13404u16),(54392u16,13405u16),
(54393u16,13406u16),(54396u16,13407u16),(54399u16,13408u16),(54400u16,13409u16),
(54402u16,13410u16),(54408u16,13411u16),(54409u16,13412u16),(54411u16,13413u16),
(54413u16,13414u16),(54420u16,13415u16),(54441u16,13416u16),(54476u16,13417u16),
(54480u16,13418u16),(54484u16,13419u16),(54492u16,13420u16),(54495u16,13421u16),
(54504u16,13422u16),(54508u16,13423u16),(54512u16,13424u16),(54520u16,13425u16),
(54523u16,13426u16),(54525u16,13427u16),(54532u16,13428u16),(54536u16,13429u16),
(54540u16,13430u16),(54548u16,13431u16),(54549u16,13432u16),(54551u16,13433u16),
(54588u16,13434u16),(54589u16,13435u16),(54592u16,13436u16),(54596u16,13437u16),
(54604u16,13438u16),(54605u16,13439u16),(54607u16,13440u16),(54609u16,13441u16),
(54616u16,13442u16),(54617u16,13443u16),(54620u16,13444u16),(54624u16,13445u16),
(54629u16,13446u16),(54632u16,13447u16),(54633u16,13448u16),(54635u16,13449u16),
(54637u16,13450u16),(54644u16,13451u16),(54645u16,13452u16),(54648u16,13453u16),
(54652u16,13454u16),(54660u16,13455u16),(54661u16,13456u16),(54663u16,13457u16),
(54664u16,13458u16),(54665u16,13459u16),(54672u16,13460u16),(54693u16,13461u16),
(54728u16,13462u16),(54729u16,13463u16),(54732u16,13464u16),(54736u16,13465u16),
(54738u16,13466u16),(54744u16,13467u16),(54745u16,13468u16),(54747u16,13469u16),
(54749u16,13470u16),(54756u16,13471u16),(54757u16,13472u16),(54760u16,13473u16),
(54764u16,13474u16),(54772u16,13475u16),(54773u16,13476u16),(54775u16,13477u16),
(54777u16,13478u16),(54784u16,13479u16),(54785u16,13480u16),(54788u16,13481u16),
(54792u16,13482u16),(54800u16,13483u16),(54801u16,13484u16),(54803u16,13485u16),
(54804u16,13486u16),(54805u16,13487u16),(54812u16,13488u16),(54816u16,13489u16),
(54820u16,13586u16),(54829u16,13587u16),(54840u16,13588u16),(54841u16,13589u16),
(54844u16,13590u16),(54848u16,13591u16),(54853u16,13592u16),(54856u16,13593u16),
(54857u16,13594u16),(54859u16,13595u16),(54861u16,13596u16),(54865u16,13597u16),
(54868u16,13598u16),(54869u16,13599u16),(54872u16,13600u16),(54876u16,13601u16),
(54887u16,13602u16),(54889u16,13603u16),(54896u16,13604u16),(54897u16,13605u16),
(54900u16,13606u16),(54915u16,13607u16),(54917u16,13608u16),(54924u16,13609u16),
(54925u16,13610u16),(54928u16,13611u16),(54932u16,13612u16),(54941u16,13613u16),
(54943u16,13614u16),(54945u16,13615u16),(54952u16,13616u16),(54956u16,13617u16),
(54960u16,13618u16),(54969u16,13619u16),(54971u16,13620u16),(54980u16,13621u16),
(54981u16,13622u16),(54984u16,13623u16),(54988u16,13624u16),(54993u16,13625u16),
(54996u16,13626u16),(54999u16,13627u16),(55001u16,13628u16),(55008u16,13629u16),
(55012u16,13630u16),(55016u16,13631u16),(55024u16,13632u16),(55029u16,13633u16),
(55036u16,13634u16),(55037u16,13635u16),(55040u16,13636u16),(55044u16,13637u16),
(55057u16,13638u16),(55064u16,13639u16),(55065u16,13640u16),(55068u16,13641u16),
(55072u16,13642u16),(55080u16,13643u16),(55081u16,13644u16),(55083u16,13645u16),
(55085u16,13646u16),(55092u16,13647u16),(55093u16,13648u16),(55096u16,13649u16),
(55100u16,13650u16),(55108u16,13651u16),(55111u16,13652u16),(55113u16,13653u16),
(55120u16,13654u16),(55121u16,13655u16),(55124u16,13656u16),(55126u16,13657u16),
(55127u16,13658u16),(55128u16,13659u16),(55129u16,13660u16),(55136u16,13661u16),
(55137u16,13662u16),(55139u16,13663u16),(55141u16,13664u16),(55145u16,13665u16),
(55148u16,13666u16),(55152u16,13667u16),(55156u16,13668u16),(55164u16,13669u16),
(55165u16,13670u16),(55169u16,13671u16),(55176u16,13672u16),(55177u16,13673u16),
(55180u16,13674u16),(55184u16,13675u16),(55192u16,13676u16),(55193u16,13677u16),
(55195u16,13678u16),(55197u16,13679u16),(63744u16,14203u16),(63745u16,14209u16),
(63746u16,14226u16),(63747u16,14582u16),(63748u16,14607u16),(63749u16,14738u16),
(63750u16,15006u16),(63751u16,15107u16),(63752u16,15129u16),(63753u16,15153u16),
(63754u16,15166u16),(63755u16,15347u16),(63756u16,15348u16),(63757u16,15351u16),
(63758u16,15354u16),(63759u16,15355u16),(63760u16,15356u16),(63761u16,15357u16),
(63762u16,15358u16),(63763u16,15359u16),(63764u16,15361u16),(63765u16,15362u16),
(63766u16,15363u16),(63767u16,15364u16),(63768u16,15365u16),(63769u16,15367u16),
(63770u16,15368u16),(63771u16,15369u16),(63772u16,15370u16),(63773u16,15372u16),
(63774u16,15374u16),(63775u16,15375u16),(63776u16,15377u16),(63777u16,15381u16),
(63778u16,15385u16),(63779u16,15387u16),(63780u16,15388u16),(63781u16,15389u16),
(63782u16,15487u16),(63783u16,15488u16),(63784u16,15492u16),(63785u16,15493u16),
(63786u16,15494u16),(63787u16,15495u16),(63788u16,15496u16),(63789u16,15498u16),
(63790u16,15503u16),(63791u16,15515u16),(63792u16,15519u16),(63793u16,15520u16),
(63794u16,15521u16),(63795u16,15523u16),(63796u16,15524u16),(63797u16,15525u16),
(63798u16,15526u16),(63799u16,15527u16),(63800u16,15528u16),(63801u16,15530u16),
(63802u16,15531u16),(63803u16,15532u16),(63804u16,15533u16),(63805u16,15534u16),
(63806u16,15535u16),(63807u16,15536u16),(63808u16,15537u16),(63809u16,15538u16),
(63810u16,15539u16),(63811u16,15540u16),(63812u16,15542u16),(63813u16,15543u16),
(63814u16,15547u16),(63815u16,15548u16),(63816u16,15550u16),(63817u16,15551u16),
(63818u16,15553u16),(63819u16,15554u16),(63820u16,15555u16),(63821u16,15556u16),
(63822u16,15557u16),(63823u16,15558u16),(63824u16,15559u16),(63825u16,15560u16),
(63826u16,15565u16),(63827u16,15566u16),(63828u16,15567u16),(63829u16,15568u16),
(63830u16,15569u16),(63831u16,15570u16),(63832u16,15572u16),(63833u16,15573u16),
(63834u16,15935u16),(63835u16,15957u16),(63836u16,16060u16),(63837u16,16066u16),
(63838u16,16069u16),(63839u16,16269u16),(63840u16,16290u16),(63841u16,16478u16),
(63842u16,16503u16),(63843u16,17232u16),(63844u16,17263u16),(63845u16,17390u16),
(63846u16,17580u16),(63847u16,17628u16),(63848u16,17659u16),(63849u16,17857u16),
(63850u16,17859u16),(63851u16,17974u16),(63852u16,18020u16),(63853u16,18027u16),
(63854u16,18226u16),(63855u16,18348u16),(63856u16,18412u16),(63857u16,18800u16),
(63858u16,18906u16),(63859u16,18914u16),(63860u16,19109u16),(63861u16,19112u16),
(63862u16,19113u16),(63863u16,19120u16),(63864u16,19122u16),(63865u16,19123u16),
(63866u16,19131u16),(63867u16,19141u16),(63868u16,19143u16),(63869u16,19145u16),
(63870u16,19149u16),(63871u16,19185u16),(63872u16,19186u16),(63873u16,19187u16),
(63874u16,19189u16),(63875u16,19286u16),(63876u16,19289u16),(63877u16,19292u16),
(63878u16,19298u16),(63879u16,19300u16),(63880u16,19301u16),(63881u16,19302u16),
(63882u16,19304u16),(63883u16,19308u16),(63884u16,19309u16),(63885u16,19313u16),
(63886u16,19321u16),(63887u16,19323u16),(63888u16,19324u16),(63889u16,19327u16),
(63890u16,19335u16),(63891u16,19339u16),(63892u16,19342u16),(63893u16,19345u16),
(63894u16,19348u16),(63895u16,19350u16),(63896u16,19353u16),(63897u16,19354u16),
(63898u16,19355u16),(63899u16,19357u16),(63900u16,19359u16),(63901u16,19360u16),
(63902u16,19361u16),(63903u16,19364u16),(63904u16,19366u16),(63905u16,19367u16),
(63906u16,19370u16),(63907u16,19371u16),(63908u16,19372u16),(63909u16,19374u16),
(63910u16,19476u16),(63911u16,19481u16),(63912u16,19484u16),(63913u16,19485u16),
(63914u16,19487u16),(63915u16,19488u16),(63916u16,19491u16),(63917u16,19506u16),
(63918u16,19508u16),(63919u16,19513u16),(63920u16,19514u16),(63921u16,19518u16),
(63922u16,19520u16),(63923u16,19522u16),(63924u16,19523u16),(63925u16,19526u16),
(63926u16,19538u16),(63927u16,19543u16),(63928u16,19545u16),(63929u16,19562u16),
(63930u16,19736u16),(63931u16,19737u16),(63932u16,19745u16),(63933u16,19746u16),
(63934u16,19752u16),(63935u16,19754u16),(63936u16,19756u16),(63937u16,19759u16),
(63938u16,19862u16),(63939u16,19867u16),(63940u16,19899u16),(63941u16,19942u16),
(63942u16,20078u16),(63943u16,20114u16),(63944u16,20129u16),(63945u16,20132u16),
(63946u16,20137u16),(63947u16,20139u16),(63948u16,20239u16),(63949u16,20242u16),
(63950u16,20244u16),(63951u16,20245u16),(63952u16,20261u16),(63953u16,20262u16),
(63954u16,20264u16),(63955u16,20268u16),(63956u16,20269u16),(63957u16,20273u16),
(63958u16,20274u16),(63959u16,20279u16),(63960u16,20282u16),(63961u16,20283u16),
(63962u16,20284u16),(63963u16,20285u16),(63964u16,20291u16),(63965u16,20431u16),
(63966u16,20432u16),(63967u16,20435u16),(63968u16,20440u16),(63969u16,20441u16),
(63970u16,20442u16),(63971u16,20443u16),(63972u16,20446u16),(63973u16,20449u16),
(63974u16,20451u16),(63975u16,20457u16),(63976u16,20458u16),(63977u16,20462u16),
(63978u16,20463u16),(63979u16,20466u16),(63980u16,20467u16),(63981u16,20478u16),
(63982u16,20486u16),(63983u16,20487u16),(63984u16,20490u16),(63985u16,20493u16),
(63986u16,20496u16),(63987u16,20497u16),(63988u16,20512u16),(63989u16,20513u16),
(63990u16,20515u16),(63991u16,20616u16),(63992u16,20617u16),(63993u16,20618u16),
(63994u16,20693u16),(63995u16,20864u16),(63996u16,21594u16),(63997u16,21655u16),
(63998u16,21772u16),(63999u16,21952u16),(64000u16,22023u16),(64001u16,22409u16),
(64002u16,22411u16),(64003u16,22539u16),(64004u16,22555u16),(64005u16,22566u16),
(64006u16,22764u16),(64007u16,22785u16),(64008u16,23086u16),(64009u16,23087u16),
(64010u16,23155u16),(64011u16,23474u16),(65281u16,6556u16),(65282u16,6557u16),
(65283u16,6558u16),(65284u16,6559u16),(65285u16,6560u16),(65286u16,6561u16),
(65287u16,6562u16),(65288u16,6563u16),(65289u16,6564u16),(65290u16,6565u16),
(65291u16,6566u16),(65292u16,6567u16),(65293u16,6568u16),(65294u16,6569u16),
(65295u16,6570u16),(65296u16,6571u16),(65297u16,6572u16),(65298u16,6573u16),
(65299u16,6574u16),(65300u16,6575u16),(65301u16,6576u16),(65302u16,6577u16),
(65303u16,6578u16),(65304u16,6579u16),(65305u16,6580u16),(65306u16,6581u16),
(65307u16,6582u16),(65308u16,6583u16),(65309u16,6584u16),(65310u16,6585u16),
(65311u16,6586u16),(65312u16,6587u16),(65313u16,6588u16),(65314u16,6589u16),
(65315u16,6590u16),(65316u16,6591u16),(65317u16,6592u16),(65318u16,6593u16),
(65319u16,6594u16),(65320u16,6595u16),(65321u16,6596u16),(65322u16,6597u16),
(65323u16,6598u16),(65324u16,6599u16),(65325u16,6600u16),(65326u16,6601u16),
(65327u16,6602u16),(65328u16,6603u16),(65329u16,6604u16),(65330u16,6605u16),
(65331u16,6606u16),(65332u16,6607u16),(65333u16,6608u16),(65334u16,6609u16),
(65335u16,6610u16),(65336u16,6611u16),(65337u16,6612u16),(65338u16,6613u16),
(65339u16,6614u16),(65340u16,6187u16),(65341u16,6616u16),(65342u16,6617u16),
(65343u16,6618u16),(65344u16,6619u16),(65345u16,6620u16),(65346u16,6621u16),
(65347u16,6622u16),(65348u16,6623u16),(65349u16,6624u16),(65350u16,6625u16),
(65351u16,6626u16),(65352u16,6627u16),(65353u16,6628u16),(65354u16,6629u16),
(65355u16,6630u16),(65356u16,6631u16),(65357u16,6632u16),(65358u16,6633u16),
(65359u16,6634u16),(65360u16,6635u16),(65361u16,6636u16),(65362u16,6637u16),
(65363u16,6638u16),(65364u16,6639u16),(65365u16,6640u16),(65366u16,6641u16),
(65367u16,6642u16),(65368u16,6643u16),(65369u16,6644u16),(65370u16,6645u16),
(65371u16,6646u16),(65372u16,6647u16),(65373u16,6648u16),(65374u16,6371u16),
(65504u16,6218u16),(65505u16,6219u16),(65506u16,6269u16),(65507u16,6649u16),
(65509u16,6220u16),(65510u16,6615u16),
]

const GB18030Ranges*: array[206, UCS16x16] = [
(128u16,0u16),(165u16,36u16),(169u16,38u16),(178u16,45u16),(184u16,50u16),
(216u16,81u16),(226u16,89u16),(235u16,95u16),(238u16,96u16),(244u16,100u16),
(248u16,103u16),(251u16,104u16),(253u16,105u16),(258u16,109u16),(276u16,126u16),
(284u16,133u16),(300u16,148u16),(325u16,172u16),(329u16,175u16),(334u16,179u16),
(364u16,208u16),(463u16,306u16),(465u16,307u16),(467u16,308u16),(469u16,309u16),
(471u16,310u16),(473u16,311u16),(475u16,312u16),(477u16,313u16),(506u16,341u16),
(594u16,428u16),(610u16,443u16),(712u16,544u16),(716u16,545u16),(730u16,558u16),
(930u16,741u16),(938u16,742u16),(962u16,749u16),(970u16,750u16),
(1026u16,805u16),(1104u16,819u16),(1106u16,820u16),(8209u16,7922u16),
(8215u16,7924u16),(8218u16,7925u16),(8222u16,7927u16),(8231u16,7934u16),
(8241u16,7943u16),(8244u16,7944u16),(8246u16,7945u16),(8252u16,7950u16),
(8365u16,8062u16),(8452u16,8148u16),(8454u16,8149u16),(8458u16,8152u16),
(8471u16,8164u16),(8482u16,8174u16),(8556u16,8236u16),(8570u16,8240u16),
(8596u16,8262u16),(8602u16,8264u16),(8713u16,8374u16),(8720u16,8380u16),
(8722u16,8381u16),(8726u16,8384u16),(8731u16,8388u16),(8737u16,8390u16),
(8740u16,8392u16),(8742u16,8393u16),(8748u16,8394u16),(8751u16,8396u16),
(8760u16,8401u16),(8766u16,8406u16),(8777u16,8416u16),(8781u16,8419u16),
(8787u16,8424u16),(8802u16,8437u16),(8808u16,8439u16),(8816u16,8445u16),
(8854u16,8482u16),(8858u16,8485u16),(8870u16,8496u16),(8896u16,8521u16),
(8979u16,8603u16),(9322u16,8936u16),(9372u16,8946u16),(9548u16,9046u16),
(9588u16,9050u16),(9616u16,9063u16),(9622u16,9066u16),(9634u16,9076u16),
(9652u16,9092u16),(9662u16,9100u16),(9672u16,9108u16),(9676u16,9111u16),
(9680u16,9113u16),(9702u16,9131u16),(9735u16,9162u16),(9738u16,9164u16),
(9793u16,9218u16),(9795u16,9219u16),(11906u16,11329u16),(11909u16,11331u16),
(11913u16,11334u16),(11917u16,11336u16),(11928u16,11346u16),(11944u16,11361u16),
(11947u16,11363u16),(11951u16,11366u16),(11956u16,11370u16),(11960u16,11372u16),
(11964u16,11375u16),(11979u16,11389u16),(12284u16,11682u16),(12292u16,11686u16),
(12312u16,11687u16),(12319u16,11692u16),(12330u16,11694u16),(12351u16,11714u16),
(12436u16,11716u16),(12447u16,11723u16),(12535u16,11725u16),(12543u16,11730u16),
(12586u16,11736u16),(12842u16,11982u16),(12850u16,11989u16),(12964u16,12102u16),
(13200u16,12336u16),(13215u16,12348u16),(13218u16,12350u16),(13253u16,12384u16),
(13263u16,12393u16),(13267u16,12395u16),(13270u16,12397u16),(13384u16,12510u16),
(13428u16,12553u16),(13727u16,12851u16),(13839u16,12962u16),(13851u16,12973u16),
(14617u16,13738u16),(14703u16,13823u16),(14801u16,13919u16),(14816u16,13933u16),
(14964u16,14080u16),(15183u16,14298u16),(15471u16,14585u16),(15585u16,14698u16),
(16471u16,15583u16),(16736u16,15847u16),(17208u16,16318u16),(17325u16,16434u16),
(17330u16,16438u16),(17374u16,16481u16),(17623u16,16729u16),(17997u16,17102u16),
(18018u16,17122u16),(18212u16,17315u16),(18218u16,17320u16),(18301u16,17402u16),
(18318u16,17418u16),(18760u16,17859u16),(18811u16,17909u16),(18814u16,17911u16),
(18820u16,17915u16),(18823u16,17916u16),(18844u16,17936u16),(18848u16,17939u16),
(18872u16,17961u16),(19576u16,18664u16),(19620u16,18703u16),(19738u16,18814u16),
(19887u16,18962u16),(40870u16,19043u16),(59244u16,33469u16),(59336u16,33470u16),
(59367u16,33471u16),(59413u16,33484u16),(59417u16,33485u16),(59423u16,33490u16),
(59431u16,33497u16),(59437u16,33501u16),(59443u16,33505u16),(59452u16,33513u16),
(59460u16,33520u16),(59478u16,33536u16),(59493u16,33550u16),(63789u16,37845u16),
(63866u16,37921u16),(63894u16,37948u16),(63976u16,38029u16),(63986u16,38038u16),
(64016u16,38064u16),(64018u16,38065u16),(64021u16,38066u16),(64025u16,38069u16),
(64034u16,38075u16),(64037u16,38076u16),(64042u16,38078u16),(65074u16,39108u16),
(65093u16,39109u16),(65107u16,39113u16),(65112u16,39114u16),(65127u16,39115u16),
(65132u16,39116u16),(65375u16,39265u16),(65510u16,39394u16),
]

const Big5Decode*: array[18840, uint16] = [
uint16 17392,19506,17923,17830,17784,1,19831,17843,1,19682,1,15253,18230,18244,
19527,19520,1,1,1,1,1,19543,1,18255,17882,19589,1,19719,19108,18081,1,29221,1,1,
1,1,26189,22267,0,32149,22813,1,15860,38708,1,23515,1,23204,13861,1,23249,23479,
23804,26478,34195,1,29793,29853,14453,1,1,1,16108,1,15093,31484,40855,1,1,1,1,1,
17162,33924,40854,37935,18736,34323,22678,38730,37400,31184,31282,26208,27177,
34973,29772,31685,26498,31276,21071,36934,13542,29636,1,29894,40903,22451,18735,
21580,16689,1,22552,31346,1,35727,18094,1,16769,1,31662,1,40904,1,1,1,40905,
34052,1,16564,40906,17633,1,25281,28782,40907,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,12736,12737,12738,12739,12740,1,12741,1,1,12742,
12743,1,1,12744,1,12745,12746,12747,12748,1,12749,12750,256,193,461,192,274,201,
282,200,332,211,465,210,0,7870,0,7872,202,257,225,462,224,593,275,233,283,232,
299,237,464,236,333,243,466,242,363,250,468,249,470,472,474,476,252,0,7871,0,
7873,234,609,9178,9179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,25866,0,0,20029,28381,40270,37343,0,0,1,
25745,20250,20264,20392,20822,20852,20892,20964,21153,21160,21307,21326,21457,
21464,22242,22768,22788,22791,22834,22836,23398,23454,23455,23706,24198,24635,
25993,26622,26628,26725,27982,28860,30005,32420,32428,32442,32455,32463,32479,
32518,32567,33402,33487,33647,35270,35774,35810,36710,36711,36718,29713,31996,
32205,26950,31433,21031,0,0,0,0,37260,30904,37214,32956,0,36107,33014,1,0,0,
32927,40647,19661,40393,40460,19518,1,1,40458,1,13761,0,28314,33342,29977,0,
18705,39532,39567,40857,31111,1,1,1,1,20004,20097,20096,20103,20159,20203,20279,
13388,20413,15944,20483,20616,13437,13459,13477,20870,22789,20955,20988,20997,
20105,21113,21136,21287,13767,21417,13649,21424,13651,21442,21539,13677,13682,
13953,21651,21667,21684,21689,21712,21743,21784,21795,21800,13720,21823,13733,
13759,21975,13765,1,21797,0,1,1,1,21904,1,14828,1,36422,1,1,16467,1,30586,1,
14900,18389,1,1,1,25821,1,1,1,1,25741,36478,1,1,1,1,1,1,0,1,1,1,18420,1,1,39602,
14951,1,16365,13574,1,1,1,1,40302,38933,0,17369,1,25780,21731,1,1,1,14843,1,1,1,
1,25834,1,1,36456,1,1,1,0,18443,1,16378,22643,1,0,1,1,1,1,1,21881,16571,17338,0,
19124,1,1,33194,39157,1,25465,14846,1,36288,22177,25724,15939,0,1,1,1,1,0,1,1,
14738,14854,1,13688,1,1,22098,1,1,1,13500,27709,1,0,0,1,1,1,1,1,1,1,1,32659,1,1,
1,13819,1,1,1,1,16275,1,1,1,1,0,1,1,1,1,1,16377,1,25650,1,1,1,1,1,1,1,1,14872,1,
1,1,1,1,1,1,1,38314,21708,33476,21945,0,1,39974,39606,1,1,28992,33133,33004,
23580,1,33076,14231,21343,1,37302,1,1,1,1,13789,1,13833,1,22191,1,1,1,1,1,1,1,1,
1,1,1,23124,1,1,1,1,22428,1,1,1,1,1,1,14083,1,1,1,1,1,1,1,1,22681,21096,13850,1,
31666,23400,18432,19244,40743,18919,39967,39821,1,1,22011,13810,22153,20008,
22786,1,1,38737,1,20059,20155,13630,23587,24401,24516,14586,25164,25909,27514,
27701,27706,28780,29227,20012,29357,1,32594,31035,31993,32595,1,13505,0,1,32770,
32896,1,1,21341,34916,35265,1,35744,36125,38021,38264,38271,38376,1,38886,39029,
39118,39134,39267,1,40060,40479,40644,27503,63751,20023,1,38429,25143,38050,0,
20539,28158,1,40870,15817,34959,1,28791,23797,19232,1,13657,1,24866,1,36775,
37366,29073,26393,29626,1,1,15499,1,19216,30948,29698,20910,1,16393,27235,1,
16931,34319,1,31274,1,1,38741,28749,21284,1,37876,30425,1,40871,30685,20131,
20464,20668,20015,20247,40872,21556,32139,22674,22736,1,24210,24217,24514,1,
25995,1,26905,27203,1,27903,0,29184,1,29580,16091,1,23317,29881,35715,1,1,31379,
31724,31939,32364,33528,34199,40873,34960,40874,36537,40875,36815,34143,39392,
37409,40876,1,1,16497,17058,23066,0,0,0,39016,26475,17014,22333,0,34262,1,33471,
1,19585,1,23931,1,1,40877,40878,23446,40879,26343,32347,28247,31178,15752,17603,
1,1,17306,17718,0,23765,1,35577,23672,15634,1,23928,40882,29015,17752,1,1,19575,
14712,13386,1,1,35532,20404,1,22975,33132,38998,1,24379,1,0,1,1,16642,18107,1,
16135,40883,1,16632,14294,18167,1,16764,1,1,17773,14548,1,17761,17691,19849,
19579,19830,17898,16328,1,13921,17630,17597,16877,23870,23880,23894,15868,14351,
23972,23993,14368,14392,24130,24253,24357,24451,14600,14612,14655,14669,24791,
24893,23781,14729,25015,25017,25039,14776,25132,25232,25317,25368,14840,22193,
14851,25570,25595,25607,25690,14923,25792,23829,22049,40863,14999,25990,15037,
26111,26195,15090,26258,15138,26390,15170,26532,26624,15192,26698,26756,15218,
15217,15227,26889,26947,29276,26980,27039,27013,15292,27094,15325,27237,27252,
27249,27266,15340,27289,15346,27307,27317,27348,27382,27521,27585,27626,27765,
27818,15563,27906,27910,27942,28033,15599,28068,28081,28181,28184,28201,28294,1,
28347,28386,28378,40831,28392,28393,28452,28468,15686,1,28545,28606,15722,15733,
29111,23705,15754,28716,15761,28752,28756,28783,28799,28809,1,17345,13809,1,1,
22462,1,28990,1,13902,27042,1,23412,31305,1,1,31333,31357,1,31419,31408,31426,
31427,29137,1,16842,31450,31453,31466,16879,21682,1,31499,31573,31529,1,1,31650,
31599,33692,1,1,31696,33825,31634,31672,1,15789,1,33938,31738,31750,31797,1,
31812,31875,1,31910,26237,1,31945,31943,31974,31860,31987,31989,31950,32359,
17693,1,32093,1,29837,32137,32171,28981,32179,32210,1,1,32228,15635,32245,1,
32229,1,32285,1,1,32366,32402,17195,37996,32295,32576,32577,32583,31030,1,39393,
32663,1,32675,1,1,17756,1,17667,1,32762,1,32773,32776,32797,32808,32815,1,1,
32827,32828,32865,1,18825,1,1,1,26405,32935,1,33031,33050,22704,1,27775,1,1,
25831,1,33304,1,27219,1,1,17530,33321,1,1,1,20473,1,34018,33634,1,1,1,1,1,33450,
26907,1,16859,34123,33488,33562,1,1,14017,1,1,33403,33506,33560,1,1,1,1,1,15807,
33565,21996,33669,17675,1,33708,33729,33747,13438,1,27223,34138,13462,1,1,33880,
1,33905,15827,17636,27303,33866,1,31064,33960,1,1,1,34014,33807,33681,17568,
33939,34020,1,16960,1,17731,34100,23282,1,17703,34163,17686,26559,34326,1,1,
34241,1,34306,1,1,1,17770,34344,13896,1,21495,1,34430,34673,1,34798,1,34737,
34778,34831,22113,34412,26710,17935,34885,34886,1,1,1,34910,34972,18011,34996,
34997,25537,35013,30583,1,35207,35210,35238,35241,35239,35260,1,35303,1,1,35484,
30611,37374,35472,1,31465,1,1,18195,1,29052,35596,35615,1,1,35647,35660,35661,
35497,1,35728,35739,35503,1,17941,34895,35995,1,1,1,14117,1,36054,1,1,36114,
36099,1,36059,28764,36113,1,16080,36215,36265,1,1,1,15228,1,1,31463,36525,36534,
36547,37588,36633,36653,1,1,36773,37635,1,1,36787,18730,1,1,1,24312,1,36857,1,1,
1,1,14720,1,36919,1,1,36961,1,1,37032,1,37060,1,37038,37117,37223,15088,37289,
37316,31916,1,1,37390,27807,37441,37474,1,37561,1,1,1,1,1,37676,37739,1,1,28815,
23235,1,1,18789,37444,1,1,1,37747,37979,36540,38277,38310,37926,38304,28662,
17081,1,1,1,1,18911,27676,38523,38550,16748,38563,1,25050,38582,30965,1,38589,
21452,18849,1,1,1,1,1,1,1,1,38705,34370,38710,18959,17725,17797,1,28789,23361,
38683,38748,1,38743,23370,1,38751,37925,20688,1,1,38793,38815,38833,38846,38848,
38866,38880,1,38894,29724,1,38911,38901,1,1,19153,38964,38963,38987,39014,15118,
1,15697,1,1,1,39114,39095,39112,39111,19199,1,1,21936,39137,39142,39148,37752,
39225,1,19314,1,1,39413,39436,39483,39440,39512,1,14020,1,1,39648,39650,1,39668,
19470,39700,39725,1,20532,39732,1,14531,1,39760,39744,1,23109,1,39822,1,39938,
39935,39948,1,40404,1,1,1,1,1,1,40318,40323,1,40462,26760,40388,1,1,1,1,1,40249,
1,1,40592,40597,40606,40610,19764,40618,40623,1,40641,15200,14821,15645,20274,
14270,1,40706,40712,19350,37924,1,40727,40726,40761,22175,22154,40773,39352,1,
38898,33919,40802,40809,31452,40846,29206,19390,1,1,29047,1,1,1,29598,1,1,31135,
1,1,37737,37875,1,37612,37761,37835,1,1,29207,16107,30578,31299,28880,1,1,29054,
1,28835,1,1,16071,1,1,1,14114,1,1,14049,1,1,1,14115,1,22363,1,1,1,1,1,34051,1,
34051,33877,1,1,1,1,1,1,17652,1,1,1,26617,14131,15381,15847,22636,1,26640,16471,
1,1,1,1,1,21707,22174,1,22162,1,1,1,37830,1,37788,20216,20779,14361,1,20156,1,1,
20299,20362,1,23144,1,1,14745,1,1,13365,20265,1,1,1,35546,1,20120,20685,20749,
20386,20227,1,1,20290,20526,20588,20609,20428,20453,20568,20732,20825,20827,
20829,20830,28278,1,1,1,28018,1,1,20904,20931,1,17629,1,1,1,36218,1,1,21081,
21156,1,21217,37742,18042,29068,1,1,1,1,27089,1,29817,16094,29849,29716,29782,
29592,19342,1,1,21456,13700,29199,1,21940,1,21709,1,22301,37469,38644,37734,
22493,22413,22399,13886,22731,23193,1,1,1,1,23084,22968,37519,23166,23247,23058,
1,1,1,1,14069,27909,29763,23073,1,23169,1,1,37856,29836,1,28933,18802,37896,1,
37821,14240,23582,23710,24158,24136,1,1,1,24269,23375,1,1,14081,1,14045,1,14035,
33066,1,1,1,1,24332,24334,1,1,23147,1,23364,34324,1,34912,24702,1,1,24539,16056,
1,1,1,1,25024,1,1,1,24985,24984,24693,1,1,1,1,25713,1,1,14889,1,1,1,1,25399,1,
25782,25393,25553,1,1,25252,1,25659,25963,26994,15348,1,1,1,1,21773,1,1,1,26318,
1,1,15072,16784,1,1,1,1,1,1,30958,1,1,1,13412,1,1,1,26254,1,26219,19347,26160,1,
1,26211,1,1,26142,1,14545,1,1,15257,1,1,29904,15254,26511,1,26806,26654,15300,
27326,14435,1,1,27187,27218,27337,27397,1,25873,26776,27212,15319,27258,27479,1,
1,37792,37618,1,1,37513,1,1,37991,28069,28427,1,28007,1,15759,28164,1,23101,
28170,22599,27940,30786,28987,1,1,28913,29264,29319,29332,1,1,20857,1,1,29818,1,
1,1,1,1,16134,16049,1,1,1,24743,16115,29900,29756,37767,29751,17567,1,17745,
30083,16227,1,1,16216,30037,30323,1,15129,29800,1,1,1,15099,15821,1,16127,1,1,
37370,22322,37698,1,1,20703,1,1,30584,1,30478,30479,30587,1,1,14942,1,29752,
29851,16063,1,1,16584,1,1,37639,1,30750,30861,30856,30930,29648,31065,1,1,16654,
31131,33942,31141,27181,1,31290,31220,16750,1,16690,37429,31217,1,1,1,1,1,13719,
21867,13680,13994,1,1,31458,23129,1,1,1,23053,1,30960,23082,1,31486,16889,31837,
31853,16913,1,1,1,31949,1,1,31886,31868,31918,27314,32220,32263,32211,32590,1,1,
1,32151,1,17002,1,1,26582,1,1,22468,1,1,1,32733,31527,1,1,1,31500,1,39398,34373,
39523,27164,1,14818,1,1,39455,1,33920,1,1,17642,33079,17410,32966,33033,33090,1,
39107,1,33378,33381,1,33875,1,34320,1,23174,16767,1,23339,1,23268,1,34464,1,1,
34861,1,23042,34926,20293,34951,35007,35046,35173,35149,1,35156,1,1,1,1,1,1,
16045,33955,18165,18127,14322,35389,35356,1,24397,37419,1,26068,28969,28868,1,
40301,35999,36073,1,22938,30659,23024,17262,14036,36394,36519,1,36656,36682,
17140,27736,28603,1,18587,28537,28299,1,39913,14005,1,37051,37015,21873,18694,
37307,37892,1,16482,1,37927,1,1,34021,35371,38297,38311,38295,38294,1,29765,
16066,1,1,1,16103,1,38543,1,1,1,16076,1,1,1,29714,29803,16124,38721,1,26695,
18973,1,1,38749,37736,1,1,1,1,37562,23313,35689,18748,29689,1,38811,38769,39224,
1,24001,1,1,38943,1,37622,1,37349,17600,1,1,1,39132,1,16128,37418,18725,33812,
39227,39245,1,15869,39323,19311,39338,39516,1,1,27279,39457,23294,39471,1,19344,
1,39356,19389,19351,37757,22642,1,22562,1,1,30788,1,1,26821,15741,37976,14631,
24912,1,1,24839,40015,40019,40059,39989,39952,39807,39887,1,39839,1,1,40225,
19630,1,40472,19632,40204,1,1,1,1,40357,33981,1,1,1,34300,17715,1,1,1,33824,
34286,1,1,1,31202,1,1,18733,1,15714,37851,37566,37704,1,30905,37495,37965,20452,
13376,36964,1,30781,30804,30902,30795,1,1,1,13978,20338,28634,28633,28702,28702,
21524,1,22459,22771,22410,40214,22487,28980,13487,1,29163,1,1,23336,1,1,24844,
23246,23051,17084,1,14124,19323,1,37819,37816,1,1,33906,1,1,1,1,1,22932,1,1,
32168,1,1,1,1,1,37605,29666,16105,29876,1,1,16097,1,27352,29683,29691,16086,1,1,
1,1,1,1,1,29768,1,28837,1,37508,29670,37727,1,37681,1,1,37766,1,1,18741,1,29035,
1,1,22180,1,1,1,21762,31172,1,32254,1,1,1,17710,37889,14090,1,1,22960,1,1,1,
23201,14050,1,14000,37471,23161,1,1,37748,15565,1,19094,14730,20724,15721,15692,
1,29045,17147,1,28175,1,17643,27991,1,28775,27823,15574,1,1,28162,28428,15727,1,
30033,14012,13512,18048,16090,18545,22980,37486,18750,36673,1,1,22546,22472,
14038,1,28926,1,1,1,1,1,26809,26983,1,1,1,1,1,1,1,1,27162,1,1,33854,17631,17614,
1,1,1,1,28439,1,33597,1,33773,1,1,1,22921,23170,1,23137,23153,1,1,14125,23023,1,
14023,29070,37776,26266,1,23150,23083,1,27179,1,1,1,1,28957,1,1,20400,1,23746,1,
1,1,27148,1,1,28838,28979,1,15781,27871,1,1,32357,23019,23855,15859,24412,1,1,
32164,33830,21637,1,1,1,22398,1,1,16357,1,1,28675,1,23920,29583,31955,1,1,20424,
32743,29389,29456,1,29496,29497,1,29505,29512,16041,1,36972,29173,1,29665,33270,
16074,30476,16081,27810,22269,29721,29726,29727,16098,16112,16116,16122,29907,
16142,16211,30018,30061,30066,30093,16252,30152,30172,16320,30285,16343,30324,
16348,30330,1,29064,22051,35200,22633,16413,30531,16441,26465,16453,13787,30616,
16490,16495,23646,30654,30667,22770,30744,28857,30748,16552,30777,30791,30801,
30822,33864,1,31027,26627,31026,16643,16649,31121,31129,36795,31238,36796,16743,
31377,16818,31420,33401,16836,31439,31451,16847,20001,31586,31596,31611,31762,
31771,16992,17018,31867,31900,17036,31928,17044,31981,36755,28864,1,32207,32212,
32208,32253,32686,32692,29343,17303,32800,32805,31545,32814,32817,32852,15820,
22452,28832,32951,33001,17389,33036,29482,33038,33042,30048,33044,17409,15161,
33110,33113,33114,17427,22586,33148,33156,17445,33171,17453,33189,22511,33217,
33252,33364,17551,33446,33398,33482,33496,33535,17584,33623,38505,27018,33797,
28917,33892,24803,33928,17668,33982,34017,34040,34064,34104,34130,17723,34159,
34160,34272,17783,34418,34450,34482,34543,38469,34699,17926,17943,34990,35071,
35108,35143,35217,1,35369,35384,35476,35508,35921,36052,36082,36124,18328,22623,
36291,18413,20206,36410,21976,22356,36465,22005,36528,18487,36558,36578,36580,
36589,36594,36791,36801,36810,36812,36915,39364,18605,39136,37395,18718,37416,
37464,37483,37553,37550,37567,37603,37611,37619,37620,37629,37699,37764,37805,
18757,18769,40639,37911,21249,37917,37933,37950,18794,37972,38009,38189,38306,
18855,38388,38451,18917,26528,18980,38720,18997,38834,38850,22100,19172,24808,
39097,19225,39153,22596,39182,39193,20916,39196,39223,39234,39261,39266,19312,
39365,19357,39484,39695,31363,39785,39809,39901,39921,39924,19565,39968,14191,1,
40265,39994,40702,22096,40339,40381,40384,40444,38134,36790,40571,40620,40625,
40637,40646,38108,40674,40689,40696,31432,40772,1,1,1,26906,38083,22956,1,22592,
38081,14265,1,1,1,1,22359,29043,1,1,1,21610,1,1,21662,1,1,1,1,1,24807,1,22138,1,
1,1,1,1,1,26965,39983,34725,1,1,1,1,1,1,23584,1,24075,1,1,1,26398,1,1,1,13895,1,
1,1,1,21348,33965,1,1,1,35713,1,1,1,1,20088,28859,1,1,1,1,1,1,1,1,25283,1,1,
29080,26709,1,27113,14024,1,1,1,1,1,1,33533,1,1,1,35237,1,36768,1,38840,1,38983,
39613,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24497,26184,26303,1,1,1,29185,1,30679,1,1,
32391,1,22709,26382,26904,1,1,1,1,1,1,1,18640,19128,1,1,1,1,1,1,1,1,1,20946,1,
22943,1,15294,1,1,1,22408,1,14747,1,1,1,14178,1,35678,1,39382,1,1,1,29193,1,1,
22885,1,1,1,36570,1,21135,22335,29041,1,1,1,1,21948,1,1,1,37332,13427,1,1,1,
18200,1,1,1,1,1,20582,13563,1,24798,1,18300,1,1,1,1,1,22433,29009,28598,1,1,
36950,1,1,35682,1,1,23899,1,36662,1,1,35562,1,1,1,1,19392,1,1,1,37989,1,24981,
23079,1,20411,22201,1,1,20074,1,38486,28047,1,13848,35191,1,1,1,1,29151,1,31554,
1,1,1,37124,1,31301,40432,1,39462,1,13919,1,1,31107,1,1,23852,1,33743,1,18128,1,
30011,34917,1,22710,14108,1,1,1,15444,1,1,37505,1,1,37680,1,1,27705,38047,1,1,
34855,35061,1,1,1,28344,1,1,14756,14009,23568,31203,17727,26294,1,1,35139,1,1,
22230,16607,1,14753,1,1,1,29101,33638,1,1,23143,19639,1,1,1,1,1,1,1,31555,31102,
1,28597,1,27139,1,21410,1,37823,26678,38749,1,1,1,1,1,1,23941,1,1,22293,38947,1,
23979,1,26046,27093,21458,1,1,15377,26422,1,1,1,1,1,1,1,1,1,1,1,13770,1,1,18682,
25574,1,30728,37461,1,17394,1,17375,1,1,1,23032,1,36619,1,1,31569,1,1,15863,1,1,
36816,29327,22155,1,1,1,1,1,1,1,1,1,1,1,1,1,32415,1,1,19620,38215,1,29090,1,
19857,36882,1,19868,1,36798,21953,36794,1,36793,1,17673,32383,28502,27313,20202,
13540,1,1,14138,36480,1,1,1,1,1,1,15851,1,1,1,1,20122,1,1,22207,1,36366,23405,1,
1,25566,25296,1,1,25904,22061,1,21530,1,15814,1,19581,22050,22046,32585,1,22901,
1,34672,19996,1,1,1,33047,40286,36120,30267,40005,30286,30649,37701,21554,33096,
33527,22053,33074,33816,32957,21994,31074,22083,21526,1,13774,22021,22001,26353,
1,13869,30004,22000,21946,21655,21874,1,1,24272,1,1,1,1,40619,32090,21982,1,
25245,38765,21652,36045,29174,37238,25596,25529,25598,21865,1,40050,1,20890,
13535,1,20903,21581,21790,21779,30310,36397,1,30129,32950,34820,34694,35015,
33206,33820,1,17644,29444,1,23440,33547,1,22139,1,1,1,1,1,1,37232,1,37384,1,1,1,
1,29286,1,18254,1,1,1,16634,40029,25887,1,18675,1,1,1,1,24674,1,1,0,1,1,29091,
32398,40272,19994,19972,13687,23309,27826,21351,13996,14812,21373,13989,1,22682,
1,33325,21579,22442,1,1,0,14930,1,29556,1,19721,39917,1,1,19547,1,1,1,33884,1,1,
1,1,25390,32037,1,1,14890,36872,21196,15988,13946,17897,1,30272,23280,1,30842,1,
22695,16575,22140,39819,23924,30292,1,40581,19681,30201,14331,24857,1,1,0,22109,
1,22439,1,1,21044,1,13741,27722,40316,31830,39737,22494,1,23635,25811,1,1,1,
34477,1,1,1,1,0,20990,1,23950,38659,1,40577,36940,31519,39682,23761,31651,25192,
25397,39679,31695,39722,31870,39726,31810,31878,39957,31740,39689,40727,39963,1,
40794,21875,23491,20477,40600,20466,21088,15878,21201,22375,20566,22967,24082,
38856,40363,36700,21609,38836,39232,38842,21292,24880,26924,21466,39946,40194,
19515,38465,27008,20646,30022,1,39386,21107,0,37209,38529,37212,0,37201,1,25471,
1,27338,22033,37262,30074,25221,1,29519,31856,1,1,0,1,30422,39837,20010,1,33726,
34882,0,23626,27072,20717,22394,21023,24053,20174,27697,1,20281,21660,21722,
21146,36226,13822,24332,13811,0,27474,37244,40869,39831,38958,39092,39610,40616,
40580,29050,31508,0,27642,34840,32632,0,22048,1,36471,40787,0,36308,36431,40476,
36353,25218,1,36392,36469,31443,1,31294,30936,27882,35431,30215,1,40742,27854,
34774,30147,1,30803,1,36108,29410,29553,35629,29442,29937,36075,1,34351,24506,
34976,17591,0,1,1,0,35454,1,0,24829,30311,39639,40260,37742,39823,34805,0,34831,
36087,29484,38689,39856,13782,29362,19463,31825,39242,1,24921,19460,40598,24957,
0,22367,24943,25254,25145,25294,14940,25058,21418,1,25444,26626,13778,23895,1,
36826,1,0,20697,1,30982,21298,38456,1,16485,0,30718,0,31938,1,31962,31277,32870,
32867,32077,29957,29938,35220,33306,26380,32866,1,32859,29936,33027,30500,35209,
1,30035,1,34729,34766,33224,34700,35401,36013,35651,30507,29944,34010,13877,
27058,36262,0,35241,29800,28089,34753,1,29927,15835,29046,24740,24988,15569,
29026,24695,0,32625,1,29264,24809,19326,21024,15384,1,1,1,1,1,1,1,1,1,23745,1,1,
1,1,1,1,17762,23327,1,40784,40614,1,12288,65292,12289,12290,65294,8231,65307,
65306,65311,65281,65072,8230,8229,65104,65105,65106,183,65108,65109,65110,65111,
65372,8211,65073,8212,65075,9588,65076,65103,65288,65289,65077,65078,65371,
65373,65079,65080,12308,12309,65081,65082,12304,12305,65083,65084,12298,12299,
65085,65086,12296,12297,65087,65088,12300,12301,65089,65090,12302,12303,65091,
65092,65113,65114,65115,65116,65117,65118,8216,8217,8220,8221,12317,12318,8245,
8242,65283,65286,65290,8251,167,12291,9675,9679,9651,9650,9678,9734,9733,9671,
9670,9633,9632,9661,9660,12963,8453,175,65507,65343,717,65097,65098,65101,65102,
65099,65100,65119,65120,65121,65291,65293,215,247,177,8730,65308,65310,65309,
8806,8807,8800,8734,8786,8801,65122,65123,65124,65125,65126,65374,8745,8746,
8869,8736,8735,8895,13266,13265,8747,8750,8757,8756,9792,9794,8853,8857,8593,
8595,8592,8594,8598,8599,8601,8600,8741,8739,65295,65340,8725,65128,65284,65509,
12306,65504,65505,65285,65312,8451,8457,65129,65130,65131,13269,13212,13213,
13214,13262,13217,13198,13199,13252,176,20825,20827,20830,20829,20833,20835,
21991,29929,31950,9601,9602,9603,9604,9605,9606,9607,9608,9615,9614,9613,9612,
9611,9610,9609,9532,9524,9516,9508,9500,9620,9472,9474,9621,9484,9488,9492,9496,
9581,9582,9584,9583,9552,9566,9578,9569,9698,9699,9701,9700,9585,9586,9587,
65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,8544,8545,8546,8547,
8548,8549,8550,8551,8552,8553,12321,12322,12323,12324,12325,12326,12327,12328,
12329,21313,21316,21317,65313,65314,65315,65316,65317,65318,65319,65320,65321,
65322,65323,65324,65325,65326,65327,65328,65329,65330,65331,65332,65333,65334,
65335,65336,65337,65338,65345,65346,65347,65348,65349,65350,65351,65352,65353,
65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,
65367,65368,65369,65370,913,914,915,916,917,918,919,920,921,922,923,924,925,926,
927,928,929,931,932,933,934,935,936,937,945,946,947,948,949,950,951,952,953,954,
955,956,957,958,959,960,961,963,964,965,966,967,968,969,12549,12550,12551,12552,
12553,12554,12555,12556,12557,12558,12559,12560,12561,12562,12563,12564,12565,
12566,12567,12568,12569,12570,12571,12572,12573,12574,12575,12576,12577,12578,
12579,12580,12581,12582,12583,12584,12585,729,713,714,711,715,9216,9217,9218,
9219,9220,9221,9222,9223,9224,9225,9226,9227,9228,9229,9230,9231,9232,9233,9234,
9235,9236,9237,9238,9239,9240,9241,9242,9243,9244,9245,9246,9247,9249,8364,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19968,20057,19969,19971,
20035,20061,20102,20108,20154,20799,20837,20843,20960,20992,20993,21147,21269,
21313,21340,21448,19977,19979,19976,19978,20011,20024,20961,20037,20040,20063,
20062,20110,20129,20800,20995,21242,21315,21449,21475,22303,22763,22805,22823,
22899,23376,23377,23379,23544,23567,23586,23608,23665,24029,24037,24049,24050,
24051,24062,24178,24318,24331,24339,25165,19985,19984,19981,20013,20016,20025,
20043,23609,20104,20113,20117,20114,20116,20130,20161,20160,20163,20166,20167,
20173,20170,20171,20164,20803,20801,20839,20845,20846,20844,20887,20982,20998,
20999,21000,21243,21246,21247,21270,21305,21320,21319,21317,21342,21380,21451,
21450,21453,22764,22825,22827,22826,22829,23380,23569,23588,23610,23663,24052,
24187,24319,24340,24341,24515,25096,25142,25163,25166,25903,25991,26007,26020,
26041,26085,26352,26376,26408,27424,27490,27513,27595,27604,27611,27663,27700,
28779,29226,29238,29243,29255,29273,29275,29356,29579,19993,19990,19989,19988,
19992,20027,20045,20047,20046,20197,20184,20180,20181,20182,20183,20195,20196,
20185,20190,20805,20804,20873,20874,20908,20985,20986,20984,21002,21152,21151,
21253,21254,21271,21277,20191,21322,21321,21345,21344,21359,21358,21435,21487,
21476,21491,21484,21486,21481,21480,21500,21496,21493,21483,21478,21482,21490,
21489,21488,21477,21485,21499,22235,22234,22806,22830,22833,22900,22902,23381,
23427,23612,24040,24039,24038,24066,24067,24179,24188,24321,24344,24343,24517,
25098,25171,25172,25170,25169,26021,26086,26414,26412,26410,26411,26413,27491,
27597,27665,27664,27704,27713,27712,27710,29359,29572,29577,29916,29926,29976,
29983,29992,29993,30000,30001,30002,30003,30091,30333,30382,30399,30446,30683,
30690,30707,31034,31166,31348,31435,19998,19999,20050,20051,20073,20121,20132,
20134,20133,20223,20233,20249,20234,20245,20237,20240,20241,20239,20210,20214,
20219,20208,20211,20221,20225,20235,20809,20807,20806,20808,20840,20849,20877,
20912,21015,21009,21010,21006,21014,21155,21256,21281,21280,21360,21361,21513,
21519,21516,21514,21520,21505,21515,21508,21521,21517,21512,21507,21518,21510,
21522,22240,22238,22237,22323,22320,22312,22317,22316,22319,22313,22809,22810,
22839,22840,22916,22904,22915,22909,22905,22914,22913,23383,23384,23431,23432,
23429,23433,23546,23574,23673,24030,24070,24182,24180,24335,24347,24537,24534,
25102,25100,25101,25104,25187,25179,25176,25910,26089,26088,26092,26093,26354,
26355,26377,26429,26420,26417,26421,27425,27492,27515,27670,27741,27735,27737,
27743,27744,27728,27733,27745,27739,27725,27726,28784,29279,29277,30334,31481,
31859,31992,32566,32650,32701,32769,32771,32780,32786,32819,32895,32905,32907,
32908,33251,33258,33267,33276,33292,33307,33311,33390,33394,33406,34411,34880,
34892,34915,35199,38433,20018,20136,20301,20303,20295,20311,20318,20276,20315,
20309,20272,20304,20305,20285,20282,20280,20291,20308,20284,20294,20323,20316,
20320,20271,20302,20278,20313,20317,20296,20314,20812,20811,20813,20853,20918,
20919,21029,21028,21033,21034,21032,21163,21161,21162,21164,21283,21363,21365,
21533,21549,21534,21566,21542,21582,21543,21574,21571,21555,21576,21570,21531,
21545,21578,21561,21563,21560,21550,21557,21558,21536,21564,21568,21553,21547,
21535,21548,22250,22256,22244,22251,22346,22353,22336,22349,22343,22350,22334,
22352,22351,22331,22767,22846,22941,22930,22952,22942,22947,22937,22934,22925,
22948,22931,22922,22949,23389,23388,23386,23387,23436,23435,23439,23596,23616,
23617,23615,23614,23696,23697,23700,23692,24043,24076,24207,24199,24202,24311,
24324,24351,24420,24418,24439,24441,24536,24524,24535,24525,24561,24555,24568,
24554,25106,25105,25220,25239,25238,25216,25206,25225,25197,25226,25212,25214,
25209,25203,25234,25199,25240,25198,25237,25235,25233,25222,25913,25915,25912,
26097,26356,26463,26446,26447,26448,26449,26460,26454,26462,26441,26438,26464,
26451,26455,27493,27599,27714,27742,27801,27777,27784,27785,27781,27803,27754,
27770,27792,27760,27788,27752,27798,27794,27773,27779,27762,27774,27764,27782,
27766,27789,27796,27800,27778,28790,28796,28797,28792,29282,29281,29280,29380,
29378,29590,29996,29995,30007,30008,30338,30447,30691,31169,31168,31167,31350,
31995,32597,32918,32915,32925,32920,32923,32922,32946,33391,33426,33419,33421,
35211,35282,35328,35895,35910,35925,35997,36196,36208,36275,36523,36554,36763,
36784,36802,36806,36805,36804,24033,37009,37026,37034,37030,37027,37193,37318,
37324,38450,38446,38449,38442,38444,20006,20054,20083,20107,20123,20126,20139,
20140,20335,20381,20365,20339,20351,20332,20379,20363,20358,20355,20336,20341,
20360,20329,20347,20374,20350,20367,20369,20346,20820,20818,20821,20841,20855,
20854,20856,20925,20989,21051,21048,21047,21050,21040,21038,21046,21057,21182,
21179,21330,21332,21331,21329,21350,21367,21368,21369,21462,21460,21463,21619,
21621,21654,21624,21653,21632,21627,21623,21636,21650,21638,21628,21648,21617,
21622,21644,21658,21602,21608,21643,21629,21646,22266,22403,22391,22378,22377,
22369,22374,22372,22396,22812,22857,22855,22856,22852,22868,22974,22971,22996,
22969,22958,22993,22982,22992,22989,22987,22995,22986,22959,22963,22994,22981,
23391,23396,23395,23447,23450,23448,23452,23449,23451,23578,23624,23621,23622,
23735,23713,23736,23721,23723,23729,23731,24088,24090,24086,24085,24091,24081,
24184,24218,24215,24220,24213,24214,24310,24358,24359,24361,24448,24449,24447,
24444,24541,24544,24573,24565,24575,24591,24596,24623,24629,24598,24618,24597,
24609,24615,24617,24619,24603,25110,25109,25151,25150,25152,25215,25289,25292,
25284,25279,25282,25273,25298,25307,25259,25299,25300,25291,25288,25256,25277,
25276,25296,25305,25287,25293,25269,25306,25265,25304,25302,25303,25286,25260,
25294,25918,26023,26044,26106,26132,26131,26124,26118,26114,26126,26112,26127,
26133,26122,26119,26381,26379,26477,26507,26517,26481,26524,26483,26487,26503,
26525,26519,26479,26480,26495,26505,26494,26512,26485,26522,26515,26492,26474,
26482,27427,27494,27495,27519,27667,27675,27875,27880,27891,27825,27852,27877,
27827,27837,27838,27836,27874,27819,27861,27859,27832,27844,27833,27841,27822,
27863,27845,27889,27839,27835,27873,27867,27850,27820,27887,27868,27862,27872,
28821,28814,28818,28810,28825,29228,29229,29240,29256,29287,29289,29376,29390,
29401,29399,29392,29609,29608,29599,29611,29605,30013,30109,30105,30106,30340,
30402,30450,30452,30693,30717,31038,31040,31041,31177,31176,31354,31353,31482,
31998,32596,32652,32651,32773,32954,32933,32930,32945,32929,32939,32937,32948,
32938,32943,33253,33278,33293,33459,33437,33433,33453,33469,33439,33465,33457,
33452,33445,33455,33464,33443,33456,33470,33463,34382,34417,21021,34920,36555,
36814,36820,36817,37045,37048,37041,37046,37319,37329,38263,38272,38428,38464,
38463,38459,38468,38466,38585,38632,38738,38750,20127,20141,20142,20449,20405,
20399,20415,20448,20433,20431,20445,20419,20406,20440,20447,20426,20439,20398,
20432,20420,20418,20442,20430,20446,20407,20823,20882,20881,20896,21070,21059,
21066,21069,21068,21067,21063,21191,21193,21187,21185,21261,21335,21371,21402,
21467,21676,21696,21672,21710,21705,21688,21670,21683,21703,21698,21693,21674,
21697,21700,21704,21679,21675,21681,21691,21673,21671,21695,22271,22402,22411,
22432,22435,22434,22478,22446,22419,22869,22865,22863,22862,22864,23004,23000,
23039,23011,23016,23043,23013,23018,23002,23014,23041,23035,23401,23459,23462,
23460,23458,23461,23553,23630,23631,23629,23627,23769,23762,24055,24093,24101,
24095,24189,24224,24230,24314,24328,24365,24421,24456,24453,24458,24459,24455,
24460,24457,24594,24605,24608,24613,24590,24616,24653,24688,24680,24674,24646,
24643,24684,24683,24682,24676,25153,25308,25366,25353,25340,25325,25345,25326,
25341,25351,25329,25335,25327,25324,25342,25332,25361,25346,25919,25925,26027,
26045,26082,26149,26157,26144,26151,26159,26143,26152,26161,26148,26359,26623,
26579,26609,26580,26576,26604,26550,26543,26613,26601,26607,26564,26577,26548,
26586,26597,26552,26575,26590,26611,26544,26585,26594,26589,26578,27498,27523,
27526,27573,27602,27607,27679,27849,27915,27954,27946,27969,27941,27916,27953,
27934,27927,27963,27965,27966,27958,27931,27893,27961,27943,27960,27945,27950,
27957,27918,27947,28843,28858,28851,28844,28847,28845,28856,28846,28836,29232,
29298,29295,29300,29417,29408,29409,29623,29642,29627,29618,29645,29632,29619,
29978,29997,30031,30028,30030,30027,30123,30116,30117,30114,30115,30328,30342,
30343,30344,30408,30406,30403,30405,30465,30457,30456,30473,30475,30462,30460,
30471,30684,30722,30740,30732,30733,31046,31049,31048,31047,31161,31162,31185,
31186,31179,31359,31361,31487,31485,31869,32002,32005,32000,32009,32007,32004,
32006,32568,32654,32703,32772,32784,32781,32785,32822,32982,32997,32986,32963,
32964,32972,32993,32987,32974,32990,32996,32989,33268,33314,33511,33539,33541,
33507,33499,33510,33540,33509,33538,33545,33490,33495,33521,33537,33500,33492,
33489,33502,33491,33503,33519,33542,34384,34425,34427,34426,34893,34923,35201,
35284,35336,35330,35331,35998,36000,36212,36211,36276,36557,36556,36848,36838,
36834,36842,36837,36845,36843,36836,36840,37066,37070,37057,37059,37195,37194,
37325,38274,38480,38475,38476,38477,38754,38761,38859,38893,38899,38913,39080,
39131,39135,39318,39321,20056,20147,20492,20493,20515,20463,20518,20517,20472,
20521,20502,20486,20540,20511,20506,20498,20497,20474,20480,20500,20520,20465,
20513,20491,20505,20504,20467,20462,20525,20522,20478,20523,20489,20860,20900,
20901,20898,20941,20940,20934,20939,21078,21084,21076,21083,21085,21290,21375,
21407,21405,21471,21736,21776,21761,21815,21756,21733,21746,21766,21754,21780,
21737,21741,21729,21769,21742,21738,21734,21799,21767,21757,21775,22275,22276,
22466,22484,22475,22467,22537,22799,22871,22872,22874,23057,23064,23068,23071,
23067,23059,23020,23072,23075,23081,23077,23052,23049,23403,23640,23472,23475,
23478,23476,23470,23477,23481,23480,23556,23633,23637,23632,23789,23805,23803,
23786,23784,23792,23798,23809,23796,24046,24109,24107,24235,24237,24231,24369,
24466,24465,24464,24665,24675,24677,24656,24661,24685,24681,24687,24708,24735,
24730,24717,24724,24716,24709,24726,25159,25331,25352,25343,25422,25406,25391,
25429,25410,25414,25423,25417,25402,25424,25405,25386,25387,25384,25421,25420,
25928,25929,26009,26049,26053,26178,26185,26191,26179,26194,26188,26181,26177,
26360,26388,26389,26391,26657,26680,26696,26694,26707,26681,26690,26708,26665,
26803,26647,26700,26705,26685,26612,26704,26688,26684,26691,26666,26693,26643,
26648,26689,27530,27529,27575,27683,27687,27688,27686,27684,27888,28010,28053,
28040,28039,28006,28024,28023,27993,28051,28012,28041,28014,27994,28020,28009,
28044,28042,28025,28037,28005,28052,28874,28888,28900,28889,28872,28879,29241,
29305,29436,29433,29437,29432,29431,29574,29677,29705,29678,29664,29674,29662,
30036,30045,30044,30042,30041,30142,30149,30151,30130,30131,30141,30140,30137,
30146,30136,30347,30384,30410,30413,30414,30505,30495,30496,30504,30697,30768,
30759,30776,30749,30772,30775,30757,30765,30752,30751,30770,31061,31056,31072,
31071,31062,31070,31069,31063,31066,31204,31203,31207,31199,31206,31209,31192,
31364,31368,31449,31494,31505,31881,32033,32023,32011,32010,32032,32034,32020,
32016,32021,32026,32028,32013,32025,32027,32570,32607,32660,32709,32705,32774,
32792,32789,32793,32791,32829,32831,33009,33026,33008,33029,33005,33012,33030,
33016,33011,33032,33021,33034,33020,33007,33261,33260,33280,33296,33322,33323,
33320,33324,33467,33579,33618,33620,33610,33592,33616,33609,33589,33588,33615,
33586,33593,33590,33559,33600,33585,33576,33603,34388,34442,34474,34451,34468,
34473,34444,34467,34460,34928,34935,34945,34946,34941,34937,35352,35344,35342,
35340,35349,35338,35351,35347,35350,35343,35345,35912,35962,35961,36001,36002,
36215,36524,36562,36564,36559,36785,36865,36870,36855,36864,36858,36852,36867,
36861,36869,36856,37013,37089,37085,37090,37202,37197,37196,37336,37341,37335,
37340,37337,38275,38498,38499,38497,38491,38493,38500,38488,38494,38587,39138,
39340,39592,39640,39717,39730,39740,20094,20602,20605,20572,20551,20547,20556,
20570,20553,20581,20598,20558,20565,20597,20596,20599,20559,20495,20591,20589,
20828,20885,20976,21098,21103,21202,21209,21208,21205,21264,21263,21273,21311,
21312,21310,21443,26364,21830,21866,21862,21828,21854,21857,21827,21834,21809,
21846,21839,21845,21807,21860,21816,21806,21852,21804,21859,21811,21825,21847,
22280,22283,22281,22495,22533,22538,22534,22496,22500,22522,22530,22581,22519,
22521,22816,22882,23094,23105,23113,23142,23146,23104,23100,23138,23130,23110,
23114,23408,23495,23493,23492,23490,23487,23494,23561,23560,23559,23648,23644,
23645,23815,23814,23822,23835,23830,23842,23825,23849,23828,23833,23844,23847,
23831,24034,24120,24118,24115,24119,24247,24248,24246,24245,24254,24373,24375,
24407,24428,24425,24427,24471,24473,24478,24472,24481,24480,24476,24703,24739,
24713,24736,24744,24779,24756,24806,24765,24773,24763,24757,24796,24764,24792,
24789,24774,24799,24760,24794,24775,25114,25115,25160,25504,25511,25458,25494,
25506,25509,25463,25447,25496,25514,25457,25513,25481,25475,25499,25451,25512,
25476,25480,25497,25505,25516,25490,25487,25472,25467,25449,25448,25466,25949,
25942,25937,25945,25943,21855,25935,25944,25941,25940,26012,26011,26028,26063,
26059,26060,26062,26205,26202,26212,26216,26214,26206,26361,21207,26395,26753,
26799,26786,26771,26805,26751,26742,26801,26791,26775,26800,26755,26820,26797,
26758,26757,26772,26781,26792,26783,26785,26754,27442,27578,27627,27628,27691,
28046,28092,28147,28121,28082,28129,28108,28132,28155,28154,28165,28103,28107,
28079,28113,28078,28126,28153,28088,28151,28149,28101,28114,28186,28085,28122,
28139,28120,28138,28145,28142,28136,28102,28100,28074,28140,28095,28134,28921,
28937,28938,28925,28911,29245,29309,29313,29468,29467,29462,29459,29465,29575,
29701,29706,29699,29702,29694,29709,29920,29942,29943,29980,29986,30053,30054,
30050,30064,30095,30164,30165,30133,30154,30157,30350,30420,30418,30427,30519,
30526,30524,30518,30520,30522,30827,30787,30798,31077,31080,31085,31227,31378,
31381,31520,31528,31515,31532,31526,31513,31518,31534,31890,31895,31893,32070,
32067,32113,32046,32057,32060,32064,32048,32051,32068,32047,32066,32050,32049,
32573,32670,32666,32716,32718,32722,32796,32842,32838,33071,33046,33059,33067,
33065,33072,33060,33282,33333,33335,33334,33337,33678,33694,33688,33656,33698,
33686,33725,33707,33682,33674,33683,33673,33696,33655,33659,33660,33670,33703,
34389,24426,34503,34496,34486,34500,34485,34502,34507,34481,34479,34505,34899,
34974,34952,34987,34962,34966,34957,34955,35219,35215,35370,35357,35363,35365,
35377,35373,35359,35355,35362,35913,35930,36009,36012,36011,36008,36010,36007,
36199,36198,36286,36282,36571,36575,36889,36877,36890,36887,36899,36895,36893,
36880,36885,36894,36896,36879,36898,36886,36891,36884,37096,37101,37117,37207,
37326,37365,37350,37347,37351,37357,37353,38281,38506,38517,38515,38520,38512,
38516,38518,38519,38508,38592,38634,38633,31456,31455,38914,38915,39770,40165,
40565,40575,40613,40635,20642,20621,20613,20633,20625,20608,20630,20632,20634,
26368,20977,21106,21108,21109,21097,21214,21213,21211,21338,21413,21883,21888,
21927,21884,21898,21917,21912,21890,21916,21930,21908,21895,21899,21891,21939,
21934,21919,21822,21938,21914,21947,21932,21937,21886,21897,21931,21913,22285,
22575,22570,22580,22564,22576,22577,22561,22557,22560,22777,22778,22880,23159,
23194,23167,23186,23195,23207,23411,23409,23506,23500,23507,23504,23562,23563,
23601,23884,23888,23860,23879,24061,24133,24125,24128,24131,24190,24266,24257,
24258,24260,24380,24429,24489,24490,24488,24785,24801,24754,24758,24800,24860,
24867,24826,24853,24816,24827,24820,24936,24817,24846,24822,24841,24832,24850,
25119,25161,25507,25484,25551,25536,25577,25545,25542,25549,25554,25571,25552,
25569,25558,25581,25582,25462,25588,25578,25563,25682,25562,25593,25950,25958,
25954,25955,26001,26000,26031,26222,26224,26228,26230,26223,26257,26234,26238,
26231,26366,26367,26399,26397,26874,26837,26848,26840,26839,26885,26847,26869,
26862,26855,26873,26834,26866,26851,26827,26829,26893,26898,26894,26825,26842,
26990,26875,27454,27450,27453,27544,27542,27580,27631,27694,27695,27692,28207,
28216,28244,28193,28210,28263,28234,28192,28197,28195,28187,28251,28248,28196,
28246,28270,28205,28198,28271,28212,28237,28218,28204,28227,28189,28222,28363,
28297,28185,28238,28259,28228,28274,28265,28255,28953,28954,28966,28976,28961,
28982,29038,28956,29260,29316,29312,29494,29477,29492,29481,29754,29738,29747,
29730,29733,29749,29750,29748,29743,29723,29734,29736,29989,29990,30059,30058,
30178,30171,30179,30169,30168,30174,30176,30331,30332,30358,30355,30388,30428,
30543,30701,30813,30828,30831,31245,31240,31243,31237,31232,31384,31383,31382,
31461,31459,31561,31574,31558,31568,31570,31572,31565,31563,31567,31569,31903,
31909,32094,32080,32104,32085,32043,32110,32114,32097,32102,32098,32112,32115,
21892,32724,32725,32779,32850,32901,33109,33108,33099,33105,33102,33081,33094,
33086,33100,33107,33140,33298,33308,33769,33795,33784,33805,33760,33733,33803,
33729,33775,33777,33780,33879,33802,33776,33804,33740,33789,33778,33738,33848,
33806,33796,33756,33799,33748,33759,34395,34527,34521,34541,34516,34523,34532,
34512,34526,34903,35009,35010,34993,35203,35222,35387,35424,35413,35422,35388,
35393,35412,35419,35408,35398,35380,35386,35382,35414,35937,35970,36015,36028,
36019,36029,36033,36027,36032,36020,36023,36022,36031,36024,36234,36229,36225,
36302,36317,36299,36314,36305,36300,36315,36294,36603,36600,36604,36764,36910,
36917,36913,36920,36914,36918,37122,37109,37129,37118,37219,37221,37327,37396,
37397,37411,37385,37406,37389,37392,37383,37393,38292,38287,38283,38289,38291,
38290,38286,38538,38542,38539,38525,38533,38534,38541,38514,38532,38593,38597,
38596,38598,38599,38639,38642,38860,38917,38918,38920,39143,39146,39151,39145,
39154,39149,39342,39341,40643,40653,40657,20098,20653,20661,20658,20659,20677,
20670,20652,20663,20667,20655,20679,21119,21111,21117,21215,21222,21220,21218,
21219,21295,21983,21992,21971,21990,21966,21980,21959,21969,21987,21988,21999,
21978,21985,21957,21958,21989,21961,22290,22291,22622,22609,22616,22615,22618,
22612,22635,22604,22637,22602,22626,22610,22603,22887,23233,23241,23244,23230,
23229,23228,23219,23234,23218,23913,23919,24140,24185,24265,24264,24338,24409,
24492,24494,24858,24847,24904,24863,24819,24859,24825,24833,24840,24910,24908,
24900,24909,24894,24884,24871,24845,24838,24887,25121,25122,25619,25662,25630,
25642,25645,25661,25644,25615,25628,25620,25613,25654,25622,25623,25606,25964,
26015,26032,26263,26249,26247,26248,26262,26244,26264,26253,26371,27028,26989,
26970,26999,26976,26964,26997,26928,27010,26954,26984,26987,26974,26963,27001,
27014,26973,26979,26971,27463,27506,27584,27583,27603,27645,28322,28335,28371,
28342,28354,28304,28317,28359,28357,28325,28312,28348,28346,28331,28369,28310,
28316,28356,28372,28330,28327,28340,29006,29017,29033,29028,29001,29031,29020,
29036,29030,29004,29029,29022,28998,29032,29014,29242,29266,29495,29509,29503,
29502,29807,29786,29781,29791,29790,29761,29759,29785,29787,29788,30070,30072,
30208,30192,30209,30194,30193,30202,30207,30196,30195,30430,30431,30555,30571,
30566,30558,30563,30585,30570,30572,30556,30565,30568,30562,30702,30862,30896,
30871,30872,30860,30857,30844,30865,30867,30847,31098,31103,31105,33836,31165,
31260,31258,31264,31252,31263,31262,31391,31392,31607,31680,31584,31598,31591,
31921,31923,31925,32147,32121,32145,32129,32143,32091,32622,32617,32618,32626,
32681,32680,32676,32854,32856,32902,32900,33137,33136,33144,33125,33134,33139,
33131,33145,33146,33126,33285,33351,33922,33911,33853,33841,33909,33894,33899,
33865,33900,33883,33852,33845,33889,33891,33897,33901,33862,34398,34396,34399,
34553,34579,34568,34567,34560,34558,34555,34562,34563,34566,34570,34905,35039,
35028,35033,35036,35032,35037,35041,35018,35029,35026,35228,35299,35435,35442,
35443,35430,35433,35440,35463,35452,35427,35488,35441,35461,35437,35426,35438,
35436,35449,35451,35390,35432,35938,35978,35977,36042,36039,36040,36036,36018,
36035,36034,36037,36321,36319,36328,36335,36339,36346,36330,36324,36326,36530,
36611,36617,36606,36618,36767,36786,36939,36938,36947,36930,36948,36924,36949,
36944,36935,36943,36942,36941,36945,36926,36929,37138,37143,37228,37226,37225,
37321,37431,37463,37432,37437,37440,37438,37467,37451,37476,37457,37428,37449,
37453,37445,37433,37439,37466,38296,38552,38548,38549,38605,38603,38601,38602,
38647,38651,38649,38646,38742,38772,38774,38928,38929,38931,38922,38930,38924,
39164,39156,39165,39166,39347,39345,39348,39649,40169,40578,40718,40723,40736,
20711,20718,20709,20694,20717,20698,20693,20687,20689,20721,20686,20713,20834,
20979,21123,21122,21297,21421,22014,22016,22043,22039,22013,22036,22022,22025,
22029,22030,22007,22038,22047,22024,22032,22006,22296,22294,22645,22654,22659,
22675,22666,22649,22661,22653,22781,22821,22818,22820,22890,22889,23265,23270,
23273,23255,23254,23256,23267,23413,23518,23527,23521,23525,23526,23528,23522,
23524,23519,23565,23650,23940,23943,24155,24163,24149,24151,24148,24275,24278,
24330,24390,24432,24505,24903,24895,24907,24951,24930,24931,24927,24922,24920,
24949,25130,25735,25688,25684,25764,25720,25695,25722,25681,25703,25652,25709,
25723,25970,26017,26071,26070,26274,26280,26269,27036,27048,27029,27073,27054,
27091,27083,27035,27063,27067,27051,27060,27088,27085,27053,27084,27046,27075,
27043,27465,27468,27699,28467,28436,28414,28435,28404,28457,28478,28448,28460,
28431,28418,28450,28415,28399,28422,28465,28472,28466,28451,28437,28459,28463,
28552,28458,28396,28417,28402,28364,28407,29076,29081,29053,29066,29060,29074,
29246,29330,29334,29508,29520,29796,29795,29802,29808,29805,29956,30097,30247,
30221,30219,30217,30227,30433,30435,30596,30589,30591,30561,30913,30879,30887,
30899,30889,30883,31118,31119,31117,31278,31281,31402,31401,31469,31471,31649,
31637,31627,31605,31639,31645,31636,31631,31672,31623,31620,31929,31933,31934,
32187,32176,32156,32189,32190,32160,32202,32180,32178,32177,32186,32162,32191,
32181,32184,32173,32210,32199,32172,32624,32736,32737,32735,32862,32858,32903,
33104,33152,33167,33160,33162,33151,33154,33255,33274,33287,33300,33310,33355,
33993,33983,33990,33988,33945,33950,33970,33948,33995,33976,33984,34003,33936,
33980,34001,33994,34623,34588,34619,34594,34597,34612,34584,34645,34615,34601,
35059,35074,35060,35065,35064,35069,35048,35098,35055,35494,35468,35486,35491,
35469,35489,35475,35492,35498,35493,35496,35480,35473,35482,35495,35946,35981,
35980,36051,36049,36050,36203,36249,36245,36348,36628,36626,36629,36627,36771,
36960,36952,36956,36963,36953,36958,36962,36957,36955,37145,37144,37150,37237,
37240,37239,37236,37496,37504,37509,37528,37526,37499,37523,37532,37544,37500,
37521,38305,38312,38313,38307,38309,38308,38553,38556,38555,38604,38610,38656,
38780,38789,38902,38935,38936,39087,39089,39171,39173,39180,39177,39361,39599,
39600,39654,39745,39746,40180,40182,40179,40636,40763,40778,20740,20736,20731,
20725,20729,20738,20744,20745,20741,20956,21127,21128,21129,21133,21130,21232,
21426,22062,22075,22073,22066,22079,22068,22057,22099,22094,22103,22132,22070,
22063,22064,22656,22687,22686,22707,22684,22702,22697,22694,22893,23305,23291,
23307,23285,23308,23304,23534,23532,23529,23531,23652,23653,23965,23956,24162,
24159,24161,24290,24282,24287,24285,24291,24288,24392,24433,24503,24501,24950,
24935,24942,24925,24917,24962,24956,24944,24939,24958,24999,24976,25003,24974,
25004,24986,24996,24980,25006,25134,25705,25711,25721,25758,25778,25736,25744,
25776,25765,25747,25749,25769,25746,25774,25773,25771,25754,25772,25753,25762,
25779,25973,25975,25976,26286,26283,26292,26289,27171,27167,27112,27137,27166,
27161,27133,27169,27155,27146,27123,27138,27141,27117,27153,27472,27470,27556,
27589,27590,28479,28540,28548,28497,28518,28500,28550,28525,28507,28536,28526,
28558,28538,28528,28516,28567,28504,28373,28527,28512,28511,29087,29100,29105,
29096,29270,29339,29518,29527,29801,29835,29827,29822,29824,30079,30240,30249,
30239,30244,30246,30241,30242,30362,30394,30436,30606,30599,30604,30609,30603,
30923,30917,30906,30922,30910,30933,30908,30928,31295,31292,31296,31293,31287,
31291,31407,31406,31661,31665,31684,31668,31686,31687,31681,31648,31692,31946,
32224,32244,32239,32251,32216,32236,32221,32232,32227,32218,32222,32233,32158,
32217,32242,32249,32629,32631,32687,32745,32806,33179,33180,33181,33184,33178,
33176,34071,34109,34074,34030,34092,34093,34067,34065,34083,34081,34068,34028,
34085,34047,34054,34690,34676,34678,34656,34662,34680,34664,34649,34647,34636,
34643,34907,34909,35088,35079,35090,35091,35093,35082,35516,35538,35527,35524,
35477,35531,35576,35506,35529,35522,35519,35504,35542,35533,35510,35513,35547,
35916,35918,35948,36064,36062,36070,36068,36076,36077,36066,36067,36060,36074,
36065,36205,36255,36259,36395,36368,36381,36386,36367,36393,36383,36385,36382,
36538,36637,36635,36639,36649,36646,36650,36636,36638,36645,36969,36974,36968,
36973,36983,37168,37165,37159,37169,37255,37257,37259,37251,37573,37563,37559,
37610,37548,37604,37569,37555,37564,37586,37575,37616,37554,38317,38321,38660,
38662,38663,38665,38752,38797,38795,38799,38945,38955,38940,39091,39178,39187,
39186,39192,39389,39376,39391,39387,39377,39381,39378,39385,39607,39662,39663,
39719,39749,39748,39799,39791,40198,40201,40195,40617,40638,40654,22696,40786,
20754,20760,20756,20752,20757,20864,20906,20957,21137,21139,21235,22105,22123,
22137,22121,22116,22136,22122,22120,22117,22129,22127,22124,22114,22134,22721,
22718,22727,22725,22894,23325,23348,23416,23536,23566,24394,25010,24977,25001,
24970,25037,25014,25022,25034,25032,25136,25797,25793,25803,25787,25788,25818,
25796,25799,25794,25805,25791,25810,25812,25790,25972,26310,26313,26297,26308,
26311,26296,27197,27192,27194,27225,27243,27224,27193,27204,27234,27233,27211,
27207,27189,27231,27208,27481,27511,27653,28610,28593,28577,28611,28580,28609,
28583,28595,28608,28601,28598,28582,28576,28596,29118,29129,29136,29138,29128,
29141,29113,29134,29145,29148,29123,29124,29544,29852,29859,29848,29855,29854,
29922,29964,29965,30260,30264,30266,30439,30437,30624,30622,30623,30629,30952,
30938,30956,30951,31142,31309,31310,31302,31308,31307,31418,31705,31761,31689,
31716,31707,31713,31721,31718,31957,31958,32266,32273,32264,32283,32291,32286,
32285,32265,32272,32633,32690,32752,32753,32750,32808,33203,33193,33192,33275,
33288,33368,33369,34122,34137,34120,34152,34153,34115,34121,34157,34154,34142,
34691,34719,34718,34722,34701,34913,35114,35122,35109,35115,35105,35242,35238,
35558,35578,35563,35569,35584,35548,35559,35566,35582,35585,35586,35575,35565,
35571,35574,35580,35947,35949,35987,36084,36420,36401,36404,36418,36409,36405,
36667,36655,36664,36659,36776,36774,36981,36980,36984,36978,36988,36986,37172,
37266,37664,37686,37624,37683,37679,37666,37628,37675,37636,37658,37648,37670,
37665,37653,37678,37657,38331,38567,38568,38570,38613,38670,38673,38678,38669,
38675,38671,38747,38748,38758,38808,38960,38968,38971,38967,38957,38969,38948,
39184,39208,39198,39195,39201,39194,39405,39394,39409,39608,39612,39675,39661,
39720,39825,40213,40227,40230,40232,40210,40219,40664,40660,40845,40860,20778,
20767,20769,20786,21237,22158,22144,22160,22149,22151,22159,22741,22739,22737,
22734,23344,23338,23332,23418,23607,23656,23996,23994,23997,23992,24171,24396,
24509,25033,25026,25031,25062,25035,25138,25140,25806,25802,25816,25824,25840,
25830,25836,25841,25826,25837,25986,25987,26329,26326,27264,27284,27268,27298,
27292,27355,27299,27262,27287,27280,27296,27484,27566,27610,27656,28632,28657,
28639,28640,28635,28644,28651,28655,28544,28652,28641,28649,28629,28654,28656,
29159,29151,29166,29158,29157,29165,29164,29172,29152,29237,29254,29552,29554,
29865,29872,29862,29864,30278,30274,30284,30442,30643,30634,30640,30636,30631,
30637,30703,30967,30970,30964,30959,30977,31143,31146,31319,31423,31751,31757,
31742,31735,31756,31712,31968,31964,31966,31970,31967,31961,31965,32302,32318,
32326,32311,32306,32323,32299,32317,32305,32325,32321,32308,32313,32328,32309,
32319,32303,32580,32755,32764,32881,32882,32880,32879,32883,33222,33219,33210,
33218,33216,33215,33213,33225,33214,33256,33289,33393,34218,34180,34174,34204,
34193,34196,34223,34203,34183,34216,34186,34407,34752,34769,34739,34770,34758,
34731,34747,34746,34760,34763,35131,35126,35140,35128,35133,35244,35598,35607,
35609,35611,35594,35616,35613,35588,35600,35905,35903,35955,36090,36093,36092,
36088,36091,36264,36425,36427,36424,36426,36676,36670,36674,36677,36671,36991,
36989,36996,36993,36994,36992,37177,37283,37278,37276,37709,37762,37672,37749,
37706,37733,37707,37656,37758,37740,37723,37744,37722,37716,38346,38347,38348,
38344,38342,38577,38584,38614,38684,38686,38816,38867,38982,39094,39221,39425,
39423,39854,39851,39850,39853,40251,40255,40587,40655,40670,40668,40669,40667,
40766,40779,21474,22165,22190,22745,22744,23352,24413,25059,25139,25844,25842,
25854,25862,25850,25851,25847,26039,26332,26406,27315,27308,27331,27323,27320,
27330,27310,27311,27487,27512,27567,28681,28683,28670,28678,28666,28689,28687,
29179,29180,29182,29176,29559,29557,29863,29887,29973,30294,30296,30290,30653,
30655,30651,30652,30990,31150,31329,31330,31328,31428,31429,31787,31783,31786,
31774,31779,31777,31975,32340,32341,32350,32346,32353,32338,32345,32584,32761,
32763,32887,32886,33229,33231,33290,34255,34217,34253,34256,34249,34224,34234,
34233,34214,34799,34796,34802,34784,35206,35250,35316,35624,35641,35628,35627,
35920,36101,36441,36451,36454,36452,36447,36437,36544,36681,36685,36999,36995,
37000,37291,37292,37328,37780,37770,37782,37794,37811,37806,37804,37808,37784,
37786,37783,38356,38358,38352,38357,38626,38620,38617,38619,38622,38692,38819,
38822,38829,38905,38989,38991,38988,38990,38995,39098,39230,39231,39229,39214,
39333,39438,39617,39683,39686,39759,39758,39757,39882,39881,39933,39880,39872,
40273,40285,40288,40672,40725,40748,20787,22181,22750,22751,22754,23541,40848,
24300,25074,25079,25078,25077,25856,25871,26336,26333,27365,27357,27354,27347,
28699,28703,28712,28698,28701,28693,28696,29190,29197,29272,29346,29560,29562,
29885,29898,29923,30087,30086,30303,30305,30663,31001,31153,31339,31337,31806,
31807,31800,31805,31799,31808,32363,32365,32377,32361,32362,32645,32371,32694,
32697,32696,33240,34281,34269,34282,34261,34276,34277,34295,34811,34821,34829,
34809,34814,35168,35167,35158,35166,35649,35676,35672,35657,35674,35662,35663,
35654,35673,36104,36106,36476,36466,36487,36470,36460,36474,36468,36692,36686,
36781,37002,37003,37297,37294,37857,37841,37855,37827,37832,37852,37853,37846,
37858,37837,37848,37860,37847,37864,38364,38580,38627,38698,38695,38753,38876,
38907,39006,39000,39003,39100,39237,39241,39446,39449,39693,39912,39911,39894,
39899,40329,40289,40306,40298,40300,40594,40599,40595,40628,21240,22184,22199,
22198,22196,22204,22756,23360,23363,23421,23542,24009,25080,25082,25880,25876,
25881,26342,26407,27372,28734,28720,28722,29200,29563,29903,30306,30309,31014,
31018,31020,31019,31431,31478,31820,31811,31821,31983,31984,36782,32381,32380,
32386,32588,32768,33242,33382,34299,34297,34321,34298,34310,34315,34311,34314,
34836,34837,35172,35258,35320,35696,35692,35686,35695,35679,35691,36111,36109,
36489,36481,36485,36482,37300,37323,37912,37891,37885,38369,38704,39108,39250,
39249,39336,39467,39472,39479,39477,39955,39949,40569,40629,40680,40751,40799,
40803,40801,20791,20792,22209,22208,22210,22804,23660,24013,25084,25086,25885,
25884,26005,26345,27387,27396,27386,27570,28748,29211,29351,29910,29908,30313,
30675,31824,32399,32396,32700,34327,34349,34330,34851,34850,34849,34847,35178,
35180,35261,35700,35703,35709,36115,36490,36493,36491,36703,36783,37306,37934,
37939,37941,37946,37944,37938,37931,38370,38712,38713,38706,38911,39015,39013,
39255,39493,39491,39488,39486,39631,39764,39761,39981,39973,40367,40372,40386,
40376,40605,40687,40729,40796,40806,40807,20796,20795,22216,22218,22217,23423,
24020,24018,24398,25087,25892,27402,27489,28753,28760,29568,29924,30090,30318,
30316,31155,31840,31839,32894,32893,33247,35186,35183,35324,35712,36118,36119,
36497,36499,36705,37192,37956,37969,37970,38717,38718,38851,38849,39019,39253,
39509,39501,39634,39706,40009,39985,39998,39995,40403,40407,40756,40812,40810,
40852,22220,24022,25088,25891,25899,25898,26348,27408,29914,31434,31844,31843,
31845,32403,32406,32404,33250,34360,34367,34865,35722,37008,37007,37987,37984,
37988,38760,39023,39260,39514,39515,39511,39635,39636,39633,40020,40023,40022,
40421,40607,40692,22225,22761,25900,28766,30321,30322,30679,32592,32648,34870,
34873,34914,35731,35730,35734,33399,36123,37312,37994,38722,38728,38724,38854,
39024,39519,39714,39768,40031,40441,40442,40572,40573,40711,40823,40818,24307,
27414,28771,31852,31854,34875,35264,36513,37313,38002,38000,39025,39262,39638,
39715,40652,28772,30682,35738,38007,38857,39522,39525,32412,35740,36522,37317,
38013,38014,38012,40055,40056,40695,35924,38015,40474,29224,39530,39729,40475,
40478,31858,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,9332,9333,9334,
9335,9336,9337,9338,9339,9340,9341,8560,8561,8562,8563,8564,8565,8566,8567,8568,
8569,20022,20031,20101,20128,20866,20886,20907,21241,21304,21353,21430,22794,
23424,24027,12083,24191,24308,24400,24417,25908,26080,30098,30326,36789,38582,
168,710,12541,12542,12445,12446,12291,20189,12293,12294,12295,12540,65339,65341,
10045,12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,
12365,12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,
12378,12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,
12391,12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,
12404,12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,
12417,12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,
12430,12431,12432,12433,12434,12435,12449,12450,12451,12452,12453,12454,12455,
12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,
12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,
12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,
12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,
12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,
12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,
12534,1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,
1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,
1069,1070,1071,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,1083,
1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,
1100,1101,1102,1103,8679,8632,8633,12751,1,20058,1,20994,17553,40880,20872,
40881,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,65506,65508,65287,65282,12849,8470,8481,12443,12444,11904,11908,11910,
11911,11912,11914,11916,11917,11925,11932,11933,11941,11943,11946,11948,11950,
11958,11964,11966,11974,11978,11980,11981,11983,11990,11991,11998,12003,0,0,0,
643,592,603,596,629,339,248,331,650,618,20034,20060,20981,21274,21378,19975,
19980,20039,20109,22231,64012,23662,24435,19983,20871,19982,20014,20115,20162,
20169,20168,20888,21244,21356,21433,22304,22787,22828,23568,24063,26081,27571,
27596,27668,29247,20017,20028,20200,20188,20201,20193,20189,20186,21004,21276,
21324,22306,22307,22807,22831,23425,23428,23570,23611,23668,23667,24068,24192,
24194,24521,25097,25168,27669,27702,27715,27711,27707,29358,29360,29578,31160,
32906,38430,20238,20248,20268,20213,20244,20209,20224,20215,20232,20253,20226,
20229,20258,20243,20228,20212,20242,20913,21011,21001,21008,21158,21282,21279,
21325,21386,21511,22241,22239,22318,22314,22324,22844,22912,22908,22917,22907,
22910,22903,22911,23382,23573,23589,23676,23674,23675,23678,24031,24181,24196,
24322,24346,24436,24533,24532,24527,25180,25182,25188,25185,25190,25186,25177,
25184,25178,25189,26095,26094,26430,26425,26424,26427,26426,26431,26428,26419,
27672,27718,27730,27740,27727,27722,27732,27723,27724,28785,29278,29364,29365,
29582,29994,30335,31349,32593,33400,33404,33408,33405,33407,34381,35198,37017,
37015,37016,37019,37012,38434,38436,38432,38435,20310,20283,20322,20297,20307,
20324,20286,20327,20306,20319,20289,20312,20269,20275,20287,20321,20879,20921,
21020,21022,21025,21165,21166,21257,21347,21362,21390,21391,21552,21559,21546,
21588,21573,21529,21532,21541,21528,21565,21583,21569,21544,21540,21575,22254,
22247,22245,22337,22341,22348,22345,22347,22354,22790,22848,22950,22936,22944,
22935,22926,22946,22928,22927,22951,22945,23438,23442,23592,23594,23693,23695,
23688,23691,23689,23698,23690,23686,23699,23701,24032,24074,24078,24203,24201,
24204,24200,24205,24325,24349,24440,24438,24530,24529,24528,24557,24552,24558,
24563,24545,24548,24547,24570,24559,24567,24571,24576,24564,25146,25219,25228,
25230,25231,25236,25223,25201,25211,25210,25200,25217,25224,25207,25213,25202,
25204,25911,26096,26100,26099,26098,26101,26437,26439,26457,26453,26444,26440,
26461,26445,26458,26443,27600,27673,27674,27768,27751,27755,27780,27787,27791,
27761,27759,27753,27802,27757,27783,27797,27804,27750,27763,27749,27771,27790,
28788,28794,29283,29375,29373,29379,29382,29377,29370,29381,29589,29591,29587,
29588,29586,30010,30009,30100,30101,30337,31037,32820,32917,32921,32912,32914,
32924,33424,33423,33413,33422,33425,33427,33418,33411,33412,35960,36809,36799,
37023,37025,37029,37022,37031,37024,38448,38440,38447,38445,20019,20376,20348,
20357,20349,20352,20359,20342,20340,20361,20356,20343,20300,20375,20330,20378,
20345,20353,20344,20368,20380,20372,20382,20370,20354,20373,20331,20334,20894,
20924,20926,21045,21042,21043,21062,21041,21180,21258,21259,21308,21394,21396,
21639,21631,21633,21649,21634,21640,21611,21626,21630,21605,21612,21620,21606,
21645,21615,21601,21600,21656,21603,21607,21604,22263,22265,22383,22386,22381,
22379,22385,22384,22390,22400,22389,22395,22387,22388,22370,22376,22397,22796,
22853,22965,22970,22991,22990,22962,22988,22977,22966,22972,22979,22998,22961,
22973,22976,22984,22964,22983,23394,23397,23443,23445,23620,23623,23726,23716,
23712,23733,23727,23720,23724,23711,23715,23725,23714,23722,23719,23709,23717,
23734,23728,23718,24087,24084,24089,24360,24354,24355,24356,24404,24450,24446,
24445,24542,24549,24621,24614,24601,24626,24587,24628,24586,24599,24627,24602,
24606,24620,24610,24589,24592,24622,24595,24593,24588,24585,24604,25108,25149,
25261,25268,25297,25278,25258,25270,25290,25262,25267,25263,25275,25257,25264,
25272,25917,26024,26043,26121,26108,26116,26130,26120,26107,26115,26123,26125,
26117,26109,26129,26128,26358,26378,26501,26476,26510,26514,26486,26491,26520,
26502,26500,26484,26509,26508,26490,26527,26513,26521,26499,26493,26497,26488,
26489,26516,27429,27520,27518,27614,27677,27795,27884,27883,27886,27865,27830,
27860,27821,27879,27831,27856,27842,27834,27843,27846,27885,27890,27858,27869,
27828,27786,27805,27776,27870,27840,27952,27853,27847,27824,27897,27855,27881,
27857,28820,28824,28805,28819,28806,28804,28817,28822,28802,28826,28803,29290,
29398,29387,29400,29385,29404,29394,29396,29402,29388,29393,29604,29601,29613,
29606,29602,29600,29612,29597,29917,29928,30015,30016,30014,30092,30104,30383,
30451,30449,30448,30453,30712,30716,30713,30715,30714,30711,31042,31039,31173,
31352,31355,31483,31861,31997,32821,32911,32942,32931,32952,32949,32941,33312,
33440,33472,33451,33434,33432,33435,33461,33447,33454,33468,33438,33466,33460,
33448,33441,33449,33474,33444,33475,33462,33442,34416,34415,34413,34414,35926,
36818,36811,36819,36813,36822,36821,36823,37042,37044,37039,37043,37040,38457,
38461,38460,38458,38467,20429,20421,20435,20402,20425,20427,20417,20436,20444,
20441,20411,20403,20443,20423,20438,20410,20416,20409,20460,21060,21065,21184,
21186,21309,21372,21399,21398,21401,21400,21690,21665,21677,21669,21711,21699,
33549,21687,21678,21718,21686,21701,21702,21664,21616,21692,21666,21694,21618,
21726,21680,22453,22430,22431,22436,22412,22423,22429,22427,22420,22424,22415,
22425,22437,22426,22421,22772,22797,22867,23009,23006,23022,23040,23025,23005,
23034,23037,23036,23030,23012,23026,23031,23003,23017,23027,23029,23008,23038,
23028,23021,23464,23628,23760,23768,23756,23767,23755,23771,23774,23770,23753,
23751,23754,23766,23763,23764,23759,23752,23750,23758,23775,23800,24057,24097,
24098,24099,24096,24100,24240,24228,24226,24219,24227,24229,24327,24366,24406,
24454,24631,24633,24660,24690,24670,24645,24659,24647,24649,24667,24652,24640,
24642,24671,24612,24644,24664,24678,24686,25154,25155,25295,25357,25355,25333,
25358,25347,25323,25337,25359,25356,25336,25334,25344,25363,25364,25338,25365,
25339,25328,25921,25923,26026,26047,26166,26145,26162,26165,26140,26150,26146,
26163,26155,26170,26141,26164,26169,26158,26383,26384,26561,26610,26568,26554,
26588,26555,26616,26584,26560,26551,26565,26603,26596,26591,26549,26573,26547,
26615,26614,26606,26595,26562,26553,26574,26599,26608,26546,26620,26566,26605,
26572,26542,26598,26587,26618,26569,26570,26563,26602,26571,27432,27522,27524,
27574,27606,27608,27616,27680,27681,27944,27956,27949,27935,27964,27967,27922,
27914,27866,27955,27908,27929,27962,27930,27921,27904,27933,27970,27905,27928,
27959,27907,27919,27968,27911,27936,27948,27912,27938,27913,27920,28855,28831,
28862,28849,28848,28833,28852,28853,28841,29249,29257,29258,29292,29296,29299,
29294,29386,29412,29416,29419,29407,29418,29414,29411,29573,29644,29634,29640,
29637,29625,29622,29621,29620,29675,29631,29639,29630,29635,29638,29624,29643,
29932,29934,29998,30023,30024,30119,30122,30329,30404,30472,30467,30468,30469,
30474,30455,30459,30458,30695,30696,30726,30737,30738,30725,30736,30735,30734,
30729,30723,30739,31050,31052,31051,31045,31044,31189,31181,31183,31190,31182,
31360,31358,31441,31488,31489,31866,31864,31865,31871,31872,31873,32003,32008,
32001,32600,32657,32653,32702,32775,32782,32783,32788,32823,32984,32967,32992,
32977,32968,32962,32976,32965,32995,32985,32988,32970,32981,32969,32975,32983,
32998,32973,33279,33313,33428,33497,33534,33529,33543,33512,33536,33493,33594,
33515,33494,33524,33516,33505,33522,33525,33548,33531,33526,33520,33514,33508,
33504,33530,33523,33517,34423,34420,34428,34419,34881,34894,34919,34922,34921,
35283,35332,35335,36210,36835,36833,36846,36832,37105,37053,37055,37077,37061,
37054,37063,37067,37064,37332,37331,38484,38479,38481,38483,38474,38478,20510,
20485,20487,20499,20514,20528,20507,20469,20468,20531,20535,20524,20470,20471,
20503,20508,20512,20519,20533,20527,20529,20494,20826,20884,20883,20938,20932,
20933,20936,20942,21089,21082,21074,21086,21087,21077,21090,21197,21262,21406,
21798,21730,21783,21778,21735,21747,21732,21786,21759,21764,21768,21739,21777,
21765,21745,21770,21755,21751,21752,21728,21774,21763,21771,22273,22274,22476,
22578,22485,22482,22458,22470,22461,22460,22456,22454,22463,22471,22480,22457,
22465,22798,22858,23065,23062,23085,23086,23061,23055,23063,23050,23070,23091,
23404,23463,23469,23468,23555,23638,23636,23788,23807,23790,23793,23799,23808,
23801,24105,24104,24232,24238,24234,24236,24371,24368,24423,24669,24666,24679,
24641,24738,24712,24704,24722,24705,24733,24707,24725,24731,24727,24711,24732,
24718,25113,25158,25330,25360,25430,25388,25412,25413,25398,25411,25572,25401,
25419,25418,25404,25385,25409,25396,25432,25428,25433,25389,25415,25395,25434,
25425,25400,25431,25408,25416,25930,25926,26054,26051,26052,26050,26186,26207,
26183,26193,26386,26387,26655,26650,26697,26674,26675,26683,26699,26703,26646,
26673,26652,26677,26667,26669,26671,26702,26692,26676,26653,26642,26644,26662,
26664,26670,26701,26682,26661,26656,27436,27439,27437,27441,27444,27501,32898,
27528,27622,27620,27624,27619,27618,27623,27685,28026,28003,28004,28022,27917,
28001,28050,27992,28002,28013,28015,28049,28045,28143,28031,28038,27998,28007,
28000,28055,28016,28028,27999,28034,28056,27951,28008,28043,28030,28032,28036,
27926,28035,28027,28029,28021,28048,28892,28883,28881,28893,28875,32569,28898,
28887,28882,28894,28896,28884,28877,28869,28870,28871,28890,28878,28897,29250,
29304,29303,29302,29440,29434,29428,29438,29430,29427,29435,29441,29651,29657,
29669,29654,29628,29671,29667,29673,29660,29650,29659,29652,29661,29658,29655,
29656,29672,29918,29919,29940,29941,29985,30043,30047,30128,30145,30139,30148,
30144,30143,30134,30138,30346,30409,30493,30491,30480,30483,30482,30499,30481,
30485,30489,30490,30498,30503,30755,30764,30754,30773,30767,30760,30766,30763,
30753,30761,30771,30762,30769,31060,31067,31055,31068,31059,31058,31057,31211,
31212,31200,31214,31213,31210,31196,31198,31197,31366,31369,31365,31371,31372,
31370,31367,31448,31504,31492,31507,31493,31503,31496,31498,31502,31497,31506,
31876,31889,31882,31884,31880,31885,31877,32030,32029,32017,32014,32024,32022,
32019,32031,32018,32015,32012,32604,32609,32606,32608,32605,32603,32662,32658,
32707,32706,32704,32790,32830,32825,33018,33010,33017,33013,33025,33019,33024,
33281,33327,33317,33587,33581,33604,33561,33617,33573,33622,33599,33601,33574,
33564,33570,33602,33614,33563,33578,33544,33596,33613,33558,33572,33568,33591,
33583,33577,33607,33605,33612,33619,33566,33580,33611,33575,33608,34387,34386,
34466,34472,34454,34445,34449,34462,34439,34455,34438,34443,34458,34437,34469,
34457,34465,34471,34453,34456,34446,34461,34448,34452,34883,34884,34925,34933,
34934,34930,34944,34929,34943,34927,34947,34942,34932,34940,35346,35911,35927,
35963,36004,36003,36214,36216,36277,36279,36278,36561,36563,36862,36853,36866,
36863,36859,36868,36860,36854,37078,37088,37081,37082,37091,37087,37093,37080,
37083,37079,37084,37092,37200,37198,37199,37333,37346,37338,38492,38495,38588,
39139,39647,39727,20095,20592,20586,20577,20574,20576,20563,20555,20573,20594,
20552,20557,20545,20571,20554,20578,20501,20549,20575,20585,20587,20579,20580,
20550,20544,20590,20595,20567,20561,20944,21099,21101,21100,21102,21206,21203,
21293,21404,21877,21878,21820,21837,21840,21812,21802,21841,21858,21814,21813,
21808,21842,21829,21772,21810,21861,21838,21817,21832,21805,21819,21824,21835,
22282,22279,22523,22548,22498,22518,22492,22516,22528,22509,22525,22536,22520,
22539,22515,22479,22535,22510,22499,22514,22501,22508,22497,22542,22524,22544,
22503,22529,22540,22513,22505,22512,22541,22532,22876,23136,23128,23125,23143,
23134,23096,23093,23149,23120,23135,23141,23148,23123,23140,23127,23107,23133,
23122,23108,23131,23112,23182,23102,23117,23097,23116,23152,23145,23111,23121,
23126,23106,23132,23410,23406,23489,23488,23641,23838,23819,23837,23834,23840,
23820,23848,23821,23846,23845,23823,23856,23826,23843,23839,23854,24126,24116,
24241,24244,24249,24242,24243,24374,24376,24475,24470,24479,24714,24720,24710,
24766,24752,24762,24787,24788,24783,24804,24793,24797,24776,24753,24795,24759,
24778,24767,24771,24781,24768,25394,25445,25482,25474,25469,25533,25502,25517,
25501,25495,25515,25486,25455,25479,25488,25454,25519,25461,25500,25453,25518,
25468,25508,25403,25503,25464,25477,25473,25489,25485,25456,25939,26061,26213,
26209,26203,26201,26204,26210,26392,26745,26759,26768,26780,26733,26734,26798,
26795,26966,26735,26787,26796,26793,26741,26740,26802,26767,26743,26770,26748,
26731,26738,26794,26752,26737,26750,26779,26774,26763,26784,26761,26788,26744,
26747,26769,26764,26762,26749,27446,27443,27447,27448,27537,27535,27533,27534,
27532,27690,28096,28075,28084,28083,28276,28076,28137,28130,28087,28150,28116,
28160,28104,28128,28127,28118,28094,28133,28124,28125,28123,28148,28106,28093,
28141,28144,28090,28117,28098,28111,28105,28112,28146,28115,28157,28119,28109,
28131,28091,28922,28941,28919,28951,28916,28940,28912,28932,28915,28944,28924,
28927,28934,28947,28928,28920,28918,28939,28930,28942,29310,29307,29308,29311,
29469,29463,29447,29457,29464,29450,29448,29439,29455,29470,29576,29686,29688,
29685,29700,29697,29693,29703,29696,29690,29692,29695,29708,29707,29684,29704,
30052,30051,30158,30162,30159,30155,30156,30161,30160,30351,30345,30419,30521,
30511,30509,30513,30514,30516,30515,30525,30501,30523,30517,30792,30802,30793,
30797,30794,30796,30758,30789,30800,31076,31079,31081,31082,31075,31083,31073,
31163,31226,31224,31222,31223,31375,31380,31376,31541,31559,31540,31525,31536,
31522,31524,31539,31512,31530,31517,31537,31531,31533,31535,31538,31544,31514,
31523,31892,31896,31894,31907,32053,32061,32056,32054,32058,32069,32044,32041,
32065,32071,32062,32063,32074,32059,32040,32611,32661,32668,32669,32667,32714,
32715,32717,32720,32721,32711,32719,32713,32799,32798,32795,32839,32835,32840,
33048,33061,33049,33051,33069,33055,33068,33054,33057,33045,33063,33053,33058,
33297,33336,33331,33338,33332,33330,33396,33680,33699,33704,33677,33658,33651,
33700,33652,33679,33665,33685,33689,33653,33684,33705,33661,33667,33676,33693,
33691,33706,33675,33662,33701,33711,33672,33687,33712,33663,33702,33671,33710,
33654,33690,34393,34390,34495,34487,34498,34497,34501,34490,34480,34504,34489,
34483,34488,34508,34484,34491,34492,34499,34493,34494,34898,34953,34965,34984,
34978,34986,34970,34961,34977,34975,34968,34983,34969,34971,34967,34980,34988,
34956,34963,34958,35202,35286,35289,35285,35376,35367,35372,35358,35897,35899,
35932,35933,35965,36005,36221,36219,36217,36284,36290,36281,36287,36289,36568,
36574,36573,36572,36567,36576,36577,36900,36875,36881,36892,36876,36897,37103,
37098,37104,37108,37106,37107,37076,37099,37100,37097,37206,37208,37210,37203,
37205,37356,37364,37361,37363,37368,37348,37369,37354,37355,37367,37352,37358,
38266,38278,38280,38524,38509,38507,38513,38511,38591,38762,38916,39141,39319,
20635,20629,20628,20638,20619,20643,20611,20620,20622,20637,20584,20636,20626,
20610,20615,20831,20948,21266,21265,21412,21415,21905,21928,21925,21933,21879,
22085,21922,21907,21896,21903,21941,21889,21923,21906,21924,21885,21900,21926,
21887,21909,21921,21902,22284,22569,22583,22553,22558,22567,22563,22568,22517,
22600,22565,22556,22555,22579,22591,22582,22574,22585,22584,22573,22572,22587,
22881,23215,23188,23199,23162,23202,23198,23160,23206,23164,23205,23212,23189,
23214,23095,23172,23178,23191,23171,23179,23209,23163,23165,23180,23196,23183,
23187,23197,23530,23501,23499,23508,23505,23498,23502,23564,23600,23863,23875,
23915,23873,23883,23871,23861,23889,23886,23893,23859,23866,23890,23869,23857,
23897,23874,23865,23881,23864,23868,23858,23862,23872,23877,24132,24129,24408,
24486,24485,24491,24777,24761,24780,24802,24782,24772,24852,24818,24842,24854,
24837,24821,24851,24824,24828,24830,24769,24835,24856,24861,24848,24831,24836,
24843,25162,25492,25521,25520,25550,25573,25576,25583,25539,25757,25587,25546,
25568,25590,25557,25586,25589,25697,25567,25534,25565,25564,25540,25560,25555,
25538,25543,25548,25547,25544,25584,25559,25561,25906,25959,25962,25956,25948,
25960,25957,25996,26013,26014,26030,26064,26066,26236,26220,26235,26240,26225,
26233,26218,26226,26369,26892,26835,26884,26844,26922,26860,26858,26865,26895,
26838,26871,26859,26852,26870,26899,26896,26867,26849,26887,26828,26888,26992,
26804,26897,26863,26822,26900,26872,26832,26877,26876,26856,26891,26890,26903,
26830,26824,26845,26846,26854,26868,26833,26886,26836,26857,26901,26917,26823,
27449,27451,27455,27452,27540,27543,27545,27541,27581,27632,27634,27635,27696,
28156,28230,28231,28191,28233,28296,28220,28221,28229,28258,28203,28223,28225,
28253,28275,28188,28211,28235,28224,28241,28219,28163,28206,28254,28264,28252,
28257,28209,28200,28256,28273,28267,28217,28194,28208,28243,28261,28199,28280,
28260,28279,28245,28281,28242,28262,28213,28214,28250,28960,28958,28975,28923,
28974,28977,28963,28965,28962,28978,28959,28968,28986,28955,29259,29274,29320,
29321,29318,29317,29323,29458,29451,29488,29474,29489,29491,29479,29490,29485,
29478,29475,29493,29452,29742,29740,29744,29739,29718,29722,29729,29741,29745,
29732,29731,29725,29737,29728,29746,29947,29999,30063,30060,30183,30170,30177,
30182,30173,30175,30180,30167,30357,30354,30426,30534,30535,30532,30541,30533,
30538,30542,30539,30540,30686,30700,30816,30820,30821,30812,30829,30833,30826,
30830,30832,30825,30824,30814,30818,31092,31091,31090,31088,31234,31242,31235,
31244,31236,31385,31462,31460,31562,31547,31556,31560,31564,31566,31552,31576,
31557,31906,31902,31912,31905,32088,32111,32099,32083,32086,32103,32106,32079,
32109,32092,32107,32082,32084,32105,32081,32095,32078,32574,32575,32613,32614,
32674,32672,32673,32727,32849,32847,32848,33022,32980,33091,33098,33106,33103,
33095,33085,33101,33082,33254,33262,33271,33272,33273,33284,33340,33341,33343,
33397,33595,33743,33785,33827,33728,33768,33810,33767,33764,33788,33782,33808,
33734,33736,33771,33763,33727,33793,33757,33765,33752,33791,33761,33739,33742,
33750,33781,33737,33801,33807,33758,33809,33798,33730,33779,33749,33786,33735,
33745,33770,33811,33731,33772,33774,33732,33787,33751,33762,33819,33755,33790,
34520,34530,34534,34515,34531,34522,34538,34525,34539,34524,34540,34537,34519,
34536,34513,34888,34902,34901,35002,35031,35001,35000,35008,35006,34998,35004,
34999,35005,34994,35073,35017,35221,35224,35223,35293,35290,35291,35406,35405,
35385,35417,35392,35415,35416,35396,35397,35410,35400,35409,35402,35404,35407,
35935,35969,35968,36026,36030,36016,36025,36021,36228,36224,36233,36312,36307,
36301,36295,36310,36316,36303,36309,36313,36296,36311,36293,36591,36599,36602,
36601,36582,36590,36581,36597,36583,36584,36598,36587,36593,36588,36596,36585,
36909,36916,36911,37126,37164,37124,37119,37116,37128,37113,37115,37121,37120,
37127,37125,37123,37217,37220,37215,37218,37216,37377,37386,37413,37379,37402,
37414,37391,37388,37376,37394,37375,37373,37382,37380,37415,37378,37404,37412,
37401,37399,37381,37398,38267,38285,38284,38288,38535,38526,38536,38537,38531,
38528,38594,38600,38595,38641,38640,38764,38768,38766,38919,39081,39147,40166,
40697,20099,20100,20150,20669,20671,20678,20654,20676,20682,20660,20680,20674,
20656,20673,20666,20657,20683,20681,20662,20664,20951,21114,21112,21115,21116,
21955,21979,21964,21968,21963,21962,21981,21952,21972,21956,21993,21951,21970,
21901,21967,21973,21986,21974,21960,22002,21965,21977,21954,22292,22611,22632,
22628,22607,22605,22601,22639,22613,22606,22621,22617,22629,22619,22589,22627,
22641,22780,23239,23236,23243,23226,23224,23217,23221,23216,23231,23240,23227,
23238,23223,23232,23242,23220,23222,23245,23225,23184,23510,23512,23513,23583,
23603,23921,23907,23882,23909,23922,23916,23902,23912,23911,23906,24048,24143,
24142,24138,24141,24139,24261,24268,24262,24267,24263,24384,24495,24493,24823,
24905,24906,24875,24901,24886,24882,24878,24902,24879,24911,24873,24896,25120,
37224,25123,25125,25124,25541,25585,25579,25616,25618,25609,25632,25636,25651,
25667,25631,25621,25624,25657,25655,25634,25635,25612,25638,25648,25640,25665,
25653,25647,25610,25626,25664,25637,25639,25611,25575,25627,25646,25633,25614,
25967,26002,26067,26246,26252,26261,26256,26251,26250,26265,26260,26232,26400,
26982,26975,26936,26958,26978,26993,26943,26949,26986,26937,26946,26967,26969,
27002,26952,26953,26933,26988,26931,26941,26981,26864,27000,26932,26985,26944,
26991,26948,26998,26968,26945,26996,26956,26939,26955,26935,26972,26959,26961,
26930,26962,26927,27003,26940,27462,27461,27459,27458,27464,27457,27547,64013,
27643,27644,27641,27639,27640,28315,28374,28360,28303,28352,28319,28307,28308,
28320,28337,28345,28358,28370,28349,28353,28318,28361,28343,28336,28365,28326,
28367,28338,28350,28355,28380,28376,28313,28306,28302,28301,28324,28321,28351,
28339,28368,28362,28311,28334,28323,28999,29012,29010,29027,29024,28993,29021,
29026,29042,29048,29034,29025,28994,29016,28995,29003,29040,29023,29008,29011,
28996,29005,29018,29263,29325,29324,29329,29328,29326,29500,29506,29499,29498,
29504,29514,29513,29764,29770,29771,29778,29777,29783,29760,29775,29776,29774,
29762,29766,29773,29780,29921,29951,29950,29949,29981,30073,30071,27011,30191,
30223,30211,30199,30206,30204,30201,30200,30224,30203,30198,30189,30197,30205,
30361,30389,30429,30549,30559,30560,30546,30550,30554,30569,30567,30548,30553,
30573,30688,30855,30874,30868,30863,30852,30869,30853,30854,30881,30851,30841,
30873,30848,30870,30843,31100,31106,31101,31097,31249,31256,31257,31250,31255,
31253,31266,31251,31259,31248,31395,31394,31390,31467,31590,31588,31597,31604,
31593,31602,31589,31603,31601,31600,31585,31608,31606,31587,31922,31924,31919,
32136,32134,32128,32141,32127,32133,32122,32142,32123,32131,32124,32140,32148,
32132,32125,32146,32621,32619,32615,32616,32620,32678,32677,32679,32731,32732,
32801,33124,33120,33143,33116,33129,33115,33122,33138,26401,33118,33142,33127,
33135,33092,33121,33309,33353,33348,33344,33346,33349,34033,33855,33878,33910,
33913,33935,33933,33893,33873,33856,33926,33895,33840,33869,33917,33882,33881,
33908,33907,33885,34055,33886,33847,33850,33844,33914,33859,33912,33842,33861,
33833,33753,33867,33839,33858,33837,33887,33904,33849,33870,33868,33874,33903,
33989,33934,33851,33863,33846,33843,33896,33918,33860,33835,33888,33876,33902,
33872,34571,34564,34551,34572,34554,34518,34549,34637,34552,34574,34569,34561,
34550,34573,34565,35030,35019,35021,35022,35038,35035,35034,35020,35024,35205,
35227,35295,35301,35300,35297,35296,35298,35292,35302,35446,35462,35455,35425,
35391,35447,35458,35460,35445,35459,35457,35444,35450,35900,35915,35914,35941,
35940,35942,35974,35972,35973,36044,36200,36201,36241,36236,36238,36239,36237,
36243,36244,36240,36242,36336,36320,36332,36337,36334,36304,36329,36323,36322,
36327,36338,36331,36340,36614,36607,36609,36608,36613,36615,36616,36610,36619,
36946,36927,36932,36937,36925,37136,37133,37135,37137,37142,37140,37131,37134,
37230,37231,37448,37458,37424,37434,37478,37427,37477,37470,37507,37422,37450,
37446,37485,37484,37455,37472,37479,37487,37430,37473,37488,37425,37460,37475,
37456,37490,37454,37459,37452,37462,37426,38303,38300,38302,38299,38546,38547,
38545,38551,38606,38650,38653,38648,38645,38771,38775,38776,38770,38927,38925,
38926,39084,39158,39161,39343,39346,39344,39349,39597,39595,39771,40170,40173,
40167,40576,40701,20710,20692,20695,20712,20723,20699,20714,20701,20708,20691,
20716,20720,20719,20707,20704,20952,21120,21121,21225,21227,21296,21420,22055,
22037,22028,22034,22012,22031,22044,22017,22035,22018,22010,22045,22020,22015,
22009,22665,22652,22672,22680,22662,22657,22655,22644,22667,22650,22663,22673,
22670,22646,22658,22664,22651,22676,22671,22782,22891,23260,23278,23269,23253,
23274,23258,23277,23275,23283,23266,23264,23259,23276,23262,23261,23257,23272,
23263,23415,23520,23523,23651,23938,23936,23933,23942,23930,23937,23927,23946,
23945,23944,23934,23932,23949,23929,23935,24152,24153,24147,24280,24273,24279,
24270,24284,24277,24281,24274,24276,24388,24387,24431,24502,24876,24872,24897,
24926,24945,24947,24914,24915,24946,24940,24960,24948,24916,24954,24923,24933,
24891,24938,24929,24918,25129,25127,25131,25643,25677,25691,25693,25716,25718,
25714,25715,25725,25717,25702,25766,25678,25730,25694,25692,25675,25683,25696,
25680,25727,25663,25708,25707,25689,25701,25719,25971,26016,26273,26272,26271,
26373,26372,26402,27057,27062,27081,27040,27086,27030,27056,27052,27068,27025,
27033,27022,27047,27021,27049,27070,27055,27071,27076,27069,27044,27092,27065,
27082,27034,27087,27059,27027,27050,27041,27038,27097,27031,27024,27074,27061,
27045,27078,27466,27469,27467,27550,27551,27552,27587,27588,27646,28366,28405,
28401,28419,28453,28408,28471,28411,28462,28425,28494,28441,28442,28455,28440,
28475,28434,28397,28426,28470,28531,28409,28398,28461,28480,28464,28476,28469,
28395,28423,28430,28483,28421,28413,28406,28473,28444,28412,28474,28447,28429,
28446,28424,28449,29063,29072,29065,29056,29061,29058,29071,29051,29062,29057,
29079,29252,29267,29335,29333,29331,29507,29517,29521,29516,29794,29811,29809,
29813,29810,29799,29806,29952,29954,29955,30077,30096,30230,30216,30220,30229,
30225,30218,30228,30392,30593,30588,30597,30594,30574,30592,30575,30590,30595,
30898,30890,30900,30893,30888,30846,30891,30878,30885,30880,30892,30882,30884,
31128,31114,31115,31126,31125,31124,31123,31127,31112,31122,31120,31275,31306,
31280,31279,31272,31270,31400,31403,31404,31470,31624,31644,31626,31633,31632,
31638,31629,31628,31643,31630,31621,31640,21124,31641,31652,31618,31931,31935,
31932,31930,32167,32183,32194,32163,32170,32193,32192,32197,32157,32206,32196,
32198,32203,32204,32175,32185,32150,32188,32159,32166,32174,32169,32161,32201,
32627,32738,32739,32741,32734,32804,32861,32860,33161,33158,33155,33159,33165,
33164,33163,33301,33943,33956,33953,33951,33978,33998,33986,33964,33966,33963,
33977,33972,33985,33997,33962,33946,33969,34000,33949,33959,33979,33954,33940,
33991,33996,33947,33961,33967,33960,34006,33944,33974,33999,33952,34007,34004,
34002,34011,33968,33937,34401,34611,34595,34600,34667,34624,34606,34590,34593,
34585,34587,34627,34604,34625,34622,34630,34592,34610,34602,34605,34620,34578,
34618,34609,34613,34626,34598,34599,34616,34596,34586,34608,34577,35063,35047,
35057,35058,35066,35070,35054,35068,35062,35067,35056,35052,35051,35229,35233,
35231,35230,35305,35307,35304,35499,35481,35467,35474,35471,35478,35901,35944,
35945,36053,36047,36055,36246,36361,36354,36351,36365,36349,36362,36355,36359,
36358,36357,36350,36352,36356,36624,36625,36622,36621,37155,37148,37152,37154,
37151,37149,37146,37156,37153,37147,37242,37234,37241,37235,37541,37540,37494,
37531,37498,37536,37524,37546,37517,37542,37530,37547,37497,37527,37503,37539,
37614,37518,37506,37525,37538,37501,37512,37537,37514,37510,37516,37529,37543,
37502,37511,37545,37533,37515,37421,38558,38561,38655,38744,38781,38778,38782,
38787,38784,38786,38779,38788,38785,38783,38862,38861,38934,39085,39086,39170,
39168,39175,39325,39324,39363,39353,39355,39354,39362,39357,39367,39601,39651,
39655,39742,39743,39776,39777,39775,40177,40178,40181,40615,20735,20739,20784,
20728,20742,20743,20726,20734,20747,20748,20733,20746,21131,21132,21233,21231,
22088,22082,22092,22069,22081,22090,22089,22086,22104,22106,22080,22067,22077,
22060,22078,22072,22058,22074,22298,22699,22685,22705,22688,22691,22703,22700,
22693,22689,22783,23295,23284,23293,23287,23286,23299,23288,23298,23289,23297,
23303,23301,23311,23655,23961,23959,23967,23954,23970,23955,23957,23968,23964,
23969,23962,23966,24169,24157,24160,24156,32243,24283,24286,24289,24393,24498,
24971,24963,24953,25009,25008,24994,24969,24987,24979,25007,25005,24991,24978,
25002,24993,24973,24934,25011,25133,25710,25712,25750,25760,25733,25751,25756,
25743,25739,25738,25740,25763,25759,25704,25777,25752,25974,25978,25977,25979,
26034,26035,26293,26288,26281,26290,26295,26282,26287,27136,27142,27159,27109,
27128,27157,27121,27108,27168,27135,27116,27106,27163,27165,27134,27175,27122,
27118,27156,27127,27111,27200,27144,27110,27131,27149,27132,27115,27145,27140,
27160,27173,27151,27126,27174,27143,27124,27158,27473,27557,27555,27554,27558,
27649,27648,27647,27650,28481,28454,28542,28551,28614,28562,28557,28553,28556,
28514,28495,28549,28506,28566,28534,28524,28546,28501,28530,28498,28496,28503,
28564,28563,28509,28416,28513,28523,28541,28519,28560,28499,28555,28521,28543,
28565,28515,28535,28522,28539,29106,29103,29083,29104,29088,29082,29097,29109,
29085,29093,29086,29092,29089,29098,29084,29095,29107,29336,29338,29528,29522,
29534,29535,29536,29533,29531,29537,29530,29529,29538,29831,29833,29834,29830,
29825,29821,29829,29832,29820,29817,29960,29959,30078,30245,30238,30233,30237,
30236,30243,30234,30248,30235,30364,30365,30366,30363,30605,30607,30601,30600,
30925,30907,30927,30924,30929,30926,30932,30920,30915,30916,30921,31130,31137,
31136,31132,31138,31131,27510,31289,31410,31412,31411,31671,31691,31678,31660,
31694,31663,31673,31690,31669,31941,31944,31948,31947,32247,32219,32234,32231,
32215,32225,32259,32250,32230,32246,32241,32240,32238,32223,32630,32684,32688,
32685,32749,32747,32746,32748,32742,32744,32868,32871,33187,33183,33182,33173,
33186,33177,33175,33302,33359,33363,33362,33360,33358,33361,34084,34107,34063,
34048,34089,34062,34057,34061,34079,34058,34087,34076,34043,34091,34042,34056,
34060,34036,34090,34034,34069,34039,34027,34035,34044,34066,34026,34025,34070,
34046,34088,34077,34094,34050,34045,34078,34038,34097,34086,34023,34024,34032,
34031,34041,34072,34080,34096,34059,34073,34095,34402,34646,34659,34660,34679,
34785,34675,34648,34644,34651,34642,34657,34650,34641,34654,34669,34666,34640,
34638,34655,34653,34671,34668,34682,34670,34652,34661,34639,34683,34677,34658,
34663,34665,34906,35077,35084,35092,35083,35095,35096,35097,35078,35094,35089,
35086,35081,35234,35236,35235,35309,35312,35308,35535,35526,35512,35539,35537,
35540,35541,35515,35543,35518,35520,35525,35544,35523,35514,35517,35545,35902,
35917,35983,36069,36063,36057,36072,36058,36061,36071,36256,36252,36257,36251,
36384,36387,36389,36388,36398,36373,36379,36374,36369,36377,36390,36391,36372,
36370,36376,36371,36380,36375,36378,36652,36644,36632,36634,36640,36643,36630,
36631,36979,36976,36975,36967,36971,37167,37163,37161,37162,37170,37158,37166,
37253,37254,37258,37249,37250,37252,37248,37584,37571,37572,37568,37593,37558,
37583,37617,37599,37592,37609,37591,37597,37580,37615,37570,37608,37578,37576,
37582,37606,37581,37589,37577,37600,37598,37607,37585,37587,37557,37601,37574,
37556,38268,38316,38315,38318,38320,38564,38562,38611,38661,38664,38658,38746,
38794,38798,38792,38864,38863,38942,38941,38950,38953,38952,38944,38939,38951,
39090,39176,39162,39185,39188,39190,39191,39189,39388,39373,39375,39379,39380,
39374,39369,39382,39384,39371,39383,39372,39603,39660,39659,39667,39666,39665,
39750,39747,39783,39796,39793,39782,39798,39797,39792,39784,39780,39788,40188,
40186,40189,40191,40183,40199,40192,40185,40187,40200,40197,40196,40579,40659,
40719,40720,20764,20755,20759,20762,20753,20958,21300,21473,22128,22112,22126,
22131,22118,22115,22125,22130,22110,22135,22300,22299,22728,22717,22729,22719,
22714,22722,22716,22726,23319,23321,23323,23329,23316,23315,23312,23318,23336,
23322,23328,23326,23535,23980,23985,23977,23975,23989,23984,23982,23978,23976,
23986,23981,23983,23988,24167,24168,24166,24175,24297,24295,24294,24296,24293,
24395,24508,24989,25000,24982,25029,25012,25030,25025,25036,25018,25023,25016,
24972,25815,25814,25808,25807,25801,25789,25737,25795,25819,25843,25817,25907,
25983,25980,26018,26312,26302,26304,26314,26315,26319,26301,26299,26298,26316,
26403,27188,27238,27209,27239,27186,27240,27198,27229,27245,27254,27227,27217,
27176,27226,27195,27199,27201,27242,27236,27216,27215,27220,27247,27241,27232,
27196,27230,27222,27221,27213,27214,27206,27477,27476,27478,27559,27562,27563,
27592,27591,27652,27651,27654,28589,28619,28579,28615,28604,28622,28616,28510,
28612,28605,28574,28618,28584,28676,28581,28590,28602,28588,28586,28623,28607,
28600,28578,28617,28587,28621,28591,28594,28592,29125,29122,29119,29112,29142,
29120,29121,29131,29140,29130,29127,29135,29117,29144,29116,29126,29146,29147,
29341,29342,29545,29542,29543,29548,29541,29547,29546,29823,29850,29856,29844,
29842,29845,29857,29963,30080,30255,30253,30257,30269,30259,30268,30261,30258,
30256,30395,30438,30618,30621,30625,30620,30619,30626,30627,30613,30617,30615,
30941,30953,30949,30954,30942,30947,30939,30945,30946,30957,30943,30944,31140,
31300,31304,31303,31414,31416,31413,31409,31415,31710,31715,31719,31709,31701,
31717,31706,31720,31737,31700,31722,31714,31708,31723,31704,31711,31954,31956,
31959,31952,31953,32274,32289,32279,32268,32287,32288,32275,32270,32284,32277,
32282,32290,32267,32271,32278,32269,32276,32293,32292,32579,32635,32636,32634,
32689,32751,32810,32809,32876,33201,33190,33198,33209,33205,33195,33200,33196,
33204,33202,33207,33191,33266,33365,33366,33367,34134,34117,34155,34125,34131,
34145,34136,34112,34118,34148,34113,34146,34116,34129,34119,34147,34110,34139,
34161,34126,34158,34165,34133,34151,34144,34188,34150,34141,34132,34149,34156,
34403,34405,34404,34715,34703,34711,34707,34706,34696,34689,34710,34712,34681,
34695,34723,34693,34704,34705,34717,34692,34708,34716,34714,34697,35102,35110,
35120,35117,35118,35111,35121,35106,35113,35107,35119,35116,35103,35313,35552,
35554,35570,35572,35573,35549,35604,35556,35551,35568,35528,35550,35553,35560,
35583,35567,35579,35985,35986,35984,36085,36078,36081,36080,36083,36204,36206,
36261,36263,36403,36414,36408,36416,36421,36406,36412,36413,36417,36400,36415,
36541,36662,36654,36661,36658,36665,36663,36660,36982,36985,36987,36998,37114,
37171,37173,37174,37267,37264,37265,37261,37263,37671,37662,37640,37663,37638,
37647,37754,37688,37692,37659,37667,37650,37633,37702,37677,37646,37645,37579,
37661,37626,37669,37651,37625,37623,37684,37634,37668,37631,37673,37689,37685,
37674,37652,37644,37643,37630,37641,37632,37627,37654,38332,38349,38334,38329,
38330,38326,38335,38325,38333,38569,38612,38667,38674,38672,38809,38807,38804,
38896,38904,38965,38959,38962,39204,39199,39207,39209,39326,39406,39404,39397,
39396,39408,39395,39402,39401,39399,39609,39615,39604,39611,39670,39674,39673,
39671,39731,39808,39813,39815,39804,39806,39803,39810,39827,39826,39824,39802,
39829,39805,39816,40229,40215,40224,40222,40212,40233,40221,40216,40226,40208,
40217,40223,40584,40582,40583,40622,40621,40661,40662,40698,40722,40765,20774,
20773,20770,20772,20768,20777,21236,22163,22156,22157,22150,22148,22147,22142,
22146,22143,22145,22742,22740,22735,22738,23341,23333,23346,23331,23340,23335,
23334,23343,23342,23419,23537,23538,23991,24172,24170,24510,24507,25027,25013,
25020,25063,25056,25061,25060,25064,25054,25839,25833,25827,25835,25828,25832,
25985,25984,26038,26074,26322,27277,27286,27265,27301,27273,27295,27291,27297,
27294,27271,27283,27278,27285,27267,27304,27300,27281,27263,27302,27290,27269,
27276,27282,27483,27565,27657,28620,28585,28660,28628,28643,28636,28653,28647,
28646,28638,28658,28637,28642,28648,29153,29169,29160,29170,29156,29168,29154,
29555,29550,29551,29847,29874,29867,29840,29866,29869,29873,29861,29871,29968,
29969,29970,29967,30084,30275,30280,30281,30279,30372,30441,30645,30635,30642,
30647,30646,30644,30641,30632,30704,30963,30973,30978,30971,30972,30962,30981,
30969,30974,30980,31147,31144,31324,31323,31318,31320,31316,31322,31422,31424,
31425,31749,31759,31730,31744,31743,31739,31758,31732,31755,31731,31746,31753,
31747,31745,31736,31741,31750,31728,31729,31760,31754,31976,32301,32316,32322,
32307,38984,32312,32298,32329,32320,32327,32297,32332,32304,32315,32310,32324,
32314,32581,32639,32638,32637,32756,32754,32812,33211,33220,33228,33226,33221,
33223,33212,33257,33371,33370,33372,34179,34176,34191,34215,34197,34208,34187,
34211,34171,34212,34202,34206,34167,34172,34185,34209,34170,34168,34135,34190,
34198,34182,34189,34201,34205,34177,34210,34178,34184,34181,34169,34166,34200,
34192,34207,34408,34750,34730,34733,34757,34736,34732,34745,34741,34748,34734,
34761,34755,34754,34764,34743,34735,34756,34762,34740,34742,34751,34744,34749,
34782,34738,35125,35123,35132,35134,35137,35154,35127,35138,35245,35247,35246,
35314,35315,35614,35608,35606,35601,35589,35595,35618,35599,35602,35605,35591,
35597,35592,35590,35612,35603,35610,35919,35952,35954,35953,35951,35989,35988,
36089,36207,36430,36429,36435,36432,36428,36423,36675,36672,36997,36990,37176,
37274,37282,37275,37273,37279,37281,37277,37280,37793,37763,37807,37732,37718,
37703,37756,37720,37724,37750,37705,37712,37713,37728,37741,37775,37708,37738,
37753,37719,37717,37714,37711,37745,37751,37755,37729,37726,37731,37735,37760,
37710,37721,38343,38336,38345,38339,38341,38327,38574,38576,38572,38688,38687,
38680,38685,38681,38810,38817,38812,38814,38813,38869,38868,38897,38977,38980,
38986,38985,38981,38979,39205,39211,39212,39210,39219,39218,39215,39213,39217,
39216,39320,39331,39329,39426,39418,39412,39415,39417,39416,39414,39419,39421,
39422,39420,39427,39614,39678,39677,39681,39676,39752,39834,39848,39838,39835,
39846,39841,39845,39844,39814,39842,39840,39855,40243,40257,40295,40246,40238,
40239,40241,40248,40240,40261,40258,40259,40254,40247,40256,40253,32757,40237,
40586,40585,40589,40624,40648,40666,40699,40703,40740,40739,40738,40788,40864,
20785,20781,20782,22168,22172,22167,22170,22173,22169,22896,23356,23657,23658,
24000,24173,24174,25048,25055,25069,25070,25073,25066,25072,25067,25046,25065,
25855,25860,25853,25848,25857,25859,25852,26004,26075,26330,26331,26328,27333,
27321,27325,27361,27334,27322,27318,27319,27335,27316,27309,27486,27593,27659,
28679,28684,28685,28673,28677,28692,28686,28671,28672,28667,28710,28668,28663,
28682,29185,29183,29177,29187,29181,29558,29880,29888,29877,29889,29886,29878,
29883,29890,29972,29971,30300,30308,30297,30288,30291,30295,30298,30374,30397,
30444,30658,30650,30975,30988,30995,30996,30985,30992,30994,30993,31149,31148,
31327,31772,31785,31769,31776,31775,31789,31773,31782,31784,31778,31781,31792,
32348,32336,32342,32355,32344,32354,32351,32337,32352,32343,32339,32693,32691,
32759,32760,32885,33233,33234,33232,33375,33374,34228,34246,34240,34243,34242,
34227,34229,34237,34247,34244,34239,34251,34254,34248,34245,34225,34230,34258,
34340,34232,34231,34238,34409,34791,34790,34786,34779,34795,34794,34789,34783,
34803,34788,34772,34780,34771,34797,34776,34787,34724,34775,34777,34817,34804,
34792,34781,35155,35147,35151,35148,35142,35152,35153,35145,35626,35623,35619,
35635,35632,35637,35655,35631,35644,35646,35633,35621,35639,35622,35638,35630,
35620,35643,35645,35642,35906,35957,35993,35992,35991,36094,36100,36098,36096,
36444,36450,36448,36439,36438,36446,36453,36455,36443,36442,36449,36445,36457,
36436,36678,36679,36680,36683,37160,37178,37179,37182,37288,37285,37287,37295,
37290,37813,37772,37778,37815,37787,37789,37769,37799,37774,37802,37790,37798,
37781,37768,37785,37791,37773,37809,37777,37810,37796,37800,37812,37795,37797,
38354,38355,38353,38579,38615,38618,24002,38623,38616,38621,38691,38690,38693,
38828,38830,38824,38827,38820,38826,38818,38821,38871,38873,38870,38872,38906,
38992,38993,38994,39096,39233,39228,39226,39439,39435,39433,39437,39428,39441,
39434,39429,39431,39430,39616,39644,39688,39684,39685,39721,39733,39754,39756,
39755,39879,39878,39875,39871,39873,39861,39864,39891,39862,39876,39865,39869,
40284,40275,40271,40266,40283,40267,40281,40278,40268,40279,40274,40276,40287,
40280,40282,40590,40588,40671,40705,40704,40726,40741,40747,40746,40745,40744,
40780,40789,20788,20789,21142,21239,21428,22187,22189,22182,22183,22186,22188,
22746,22749,22747,22802,23357,23358,23359,24003,24176,24511,25083,25863,25872,
25869,25865,25868,25870,25988,26078,26077,26334,27367,27360,27340,27345,27353,
27339,27359,27356,27344,27371,27343,27341,27358,27488,27568,27660,28697,28711,
28704,28694,28715,28705,28706,28707,28713,28695,28708,28700,28714,29196,29194,
29191,29186,29189,29349,29350,29348,29347,29345,29899,29893,29879,29891,29974,
30304,30665,30666,30660,30705,31005,31003,31009,31004,30999,31006,31152,31335,
31336,31795,31804,31801,31788,31803,31980,31978,32374,32373,32376,32368,32375,
32367,32378,32370,32372,32360,32587,32586,32643,32646,32695,32765,32766,32888,
33239,33237,33380,33377,33379,34283,34289,34285,34265,34273,34280,34266,34263,
34284,34290,34296,34264,34271,34275,34268,34257,34288,34278,34287,34270,34274,
34816,34810,34819,34806,34807,34825,34828,34827,34822,34812,34824,34815,34826,
34818,35170,35162,35163,35159,35169,35164,35160,35165,35161,35208,35255,35254,
35318,35664,35656,35658,35648,35667,35670,35668,35659,35669,35665,35650,35666,
35671,35907,35959,35958,35994,36102,36103,36105,36268,36266,36269,36267,36461,
36472,36467,36458,36463,36475,36546,36690,36689,36687,36688,36691,36788,37184,
37183,37296,37293,37854,37831,37839,37826,37850,37840,37881,37868,37836,37849,
37801,37862,37834,37844,37870,37859,37845,37828,37838,37824,37842,37863,38269,
38362,38363,38625,38697,38699,38700,38696,38694,38835,38839,38838,38877,38878,
38879,39004,39001,39005,38999,39103,39101,39099,39102,39240,39239,39235,39334,
39335,39450,39445,39461,39453,39460,39451,39458,39456,39463,39459,39454,39452,
39444,39618,39691,39690,39694,39692,39735,39914,39915,39904,39902,39908,39910,
39906,39920,39892,39895,39916,39900,39897,39909,39893,39905,39898,40311,40321,
40330,40324,40328,40305,40320,40312,40326,40331,40332,40317,40299,40308,40309,
40304,40297,40325,40307,40315,40322,40303,40313,40319,40327,40296,40596,40593,
40640,40700,40749,40768,40769,40781,40790,40791,40792,21303,22194,22197,22195,
22755,23365,24006,24007,24302,24303,24512,24513,25081,25879,25878,25877,25875,
26079,26344,26339,26340,27379,27376,27370,27368,27385,27377,27374,27375,28732,
28725,28719,28727,28724,28721,28738,28728,28735,28730,28729,28736,28731,28723,
28737,29203,29204,29352,29565,29564,29882,30379,30378,30398,30445,30668,30670,
30671,30669,30706,31013,31011,31015,31016,31012,31017,31154,31342,31340,31341,
31479,31817,31816,31818,31815,31813,31982,32379,32382,32385,32384,32698,32767,
32889,33243,33241,33291,33384,33385,34338,34303,34305,34302,34331,34304,34294,
34308,34313,34309,34316,34301,34841,34832,34833,34839,34835,34838,35171,35174,
35257,35319,35680,35690,35677,35688,35683,35685,35687,35693,36270,36486,36488,
36484,36697,36694,36695,36693,36696,36698,37005,37187,37185,37303,37301,37298,
37299,37899,37907,37883,37920,37903,37908,37886,37909,37904,37928,37913,37901,
37877,37888,37879,37895,37902,37910,37906,37882,37897,37880,37898,37887,37884,
37900,37878,37905,37894,38366,38368,38367,38702,38703,38841,38843,38909,38910,
39008,39010,39011,39007,39105,39106,39248,39246,39257,39244,39243,39251,39474,
39476,39473,39468,39466,39478,39465,39470,39480,39469,39623,39626,39622,39696,
39698,39697,39947,39944,39927,39941,39954,39928,40000,39943,39950,39942,39959,
39956,39945,40351,40345,40356,40349,40338,40344,40336,40347,40352,40340,40348,
40362,40343,40353,40346,40354,40360,40350,40355,40383,40361,40342,40358,40359,
40601,40603,40602,40677,40676,40679,40678,40752,40750,40795,40800,40798,40797,
40793,40849,20794,20793,21144,21143,22211,22205,22206,23368,23367,24011,24015,
24305,25085,25883,27394,27388,27395,27384,27392,28739,28740,28746,28744,28745,
28741,28742,29213,29210,29209,29566,29975,30314,30672,31021,31025,31023,31828,
31827,31986,32394,32391,32392,32395,32390,32397,32589,32699,32816,33245,34328,
34346,34342,34335,34339,34332,34329,34343,34350,34337,34336,34345,34334,34341,
34857,34845,34843,34848,34852,34844,34859,34890,35181,35177,35182,35179,35322,
35705,35704,35653,35706,35707,36112,36116,36271,36494,36492,36702,36699,36701,
37190,37188,37189,37305,37951,37947,37942,37929,37949,37948,37936,37945,37930,
37943,37932,37952,37937,38373,38372,38371,38709,38714,38847,38881,39012,39113,
39110,39104,39256,39254,39481,39485,39494,39492,39490,39489,39482,39487,39629,
39701,39703,39704,39702,39738,39762,39979,39965,39964,39980,39971,39976,39977,
39972,39969,40375,40374,40380,40385,40391,40394,40399,40382,40389,40387,40379,
40373,40398,40377,40378,40364,40392,40369,40365,40396,40371,40397,40370,40570,
40604,40683,40686,40685,40731,40728,40730,40753,40782,40805,40804,40850,20153,
22214,22213,22219,22897,23371,23372,24021,24017,24306,25889,25888,25894,25890,
27403,27400,27401,27661,28757,28758,28759,28754,29214,29215,29353,29567,29912,
29909,29913,29911,30317,30381,31029,31156,31344,31345,31831,31836,31833,31835,
31834,31988,31985,32401,32591,32647,33246,33387,34356,34357,34355,34348,34354,
34358,34860,34856,34854,34858,34853,35185,35263,35262,35323,35710,35716,35714,
35718,35717,35711,36117,36501,36500,36506,36498,36496,36502,36503,36704,36706,
37191,37964,37968,37962,37963,37967,37959,37957,37960,37961,37958,38719,38883,
39018,39017,39115,39252,39259,39502,39507,39508,39500,39503,39496,39498,39497,
39506,39504,39632,39705,39723,39739,39766,39765,40006,40008,39999,40004,39993,
39987,40001,39996,39991,39988,39986,39997,39990,40411,40402,40414,40410,40395,
40400,40412,40401,40415,40425,40409,40408,40406,40437,40405,40413,40630,40688,
40757,40755,40754,40770,40811,40853,40866,20797,21145,22760,22759,22898,23373,
24024,34863,24399,25089,25091,25092,25897,25893,26006,26347,27409,27410,27407,
27594,28763,28762,29218,29570,29569,29571,30320,30676,31847,31846,32405,33388,
34362,34368,34361,34364,34353,34363,34366,34864,34866,34862,34867,35190,35188,
35187,35326,35724,35726,35723,35720,35909,36121,36504,36708,36707,37308,37986,
37973,37981,37975,37982,38852,38853,38912,39510,39513,39710,39711,39712,40018,
40024,40016,40010,40013,40011,40021,40025,40012,40014,40443,40439,40431,40419,
40427,40440,40420,40438,40417,40430,40422,40434,40432,40418,40428,40436,40435,
40424,40429,40642,40656,40690,40691,40710,40732,40760,40759,40758,40771,40783,
40817,40816,40814,40815,22227,22221,23374,23661,25901,26349,26350,27411,28767,
28769,28765,28768,29219,29915,29925,30677,31032,31159,31158,31850,32407,32649,
33389,34371,34872,34871,34869,34891,35732,35733,36510,36511,36512,36509,37310,
37309,37314,37995,37992,37993,38629,38726,38723,38727,38855,38885,39518,39637,
39769,40035,40039,40038,40034,40030,40032,40450,40446,40455,40451,40454,40453,
40448,40449,40457,40447,40445,40452,40608,40734,40774,40820,40821,40822,22228,
25902,26040,27416,27417,27415,27418,28770,29222,29354,30680,30681,31033,31849,
31851,31990,32410,32408,32411,32409,33248,33249,34374,34375,34376,35193,35194,
35196,35195,35327,35736,35737,36517,36516,36515,37998,37997,37999,38001,38003,
38729,39026,39263,40040,40046,40045,40459,40461,40464,40463,40466,40465,40609,
40693,40713,40775,40824,40827,40826,40825,22302,28774,31855,34876,36274,36518,
37315,38004,38008,38006,38005,39520,40052,40051,40049,40053,40468,40467,40694,
40714,40868,28776,28773,31991,34410,34878,34877,34879,35742,35996,36521,36553,
38731,39027,39028,39116,39265,39339,39524,39526,39527,39716,40469,40471,40776,
25095,27422,29223,34380,36520,38018,38016,38017,39529,39528,39726,40473,29225,
34379,35743,38019,40057,40631,30325,39531,40058,40477,28777,28778,40612,40830,
40777,40856,30849,37561,35023,22715,24658,31911,23290,9556,9574,9559,9568,9580,
9571,9562,9577,9565,9554,9572,9557,9566,9578,9569,9560,9575,9563,9555,9573,9558,
9567,9579,9570,9561,9576,9564,9553,9552,9581,9582,9584,9583,65517,1,37595,1,1,
34124,17077,29679,20917,13897,1,1,37700,1,33518,1,30780,26436,25311,1,1,1,1,1,
20395,1,20488,1,1,1,1,1,20521,1,24484,1,1,28379,1,20605,20737,13434,20750,39020,
14147,33814,1,1,20832,1,20842,1,1,1,1,1,1,1,23426,34685,1,1,20914,20920,40244,
20937,20943,20945,15580,20947,1,20915,20962,21314,20973,33741,26942,1,24443,
21003,21030,21052,21173,21079,21140,21177,21189,31765,34114,21216,34317,1,21253,
1,21833,28377,1,1,1,21299,21316,1,27851,1,26651,29653,24650,16042,14540,1,29149,
17570,21357,21364,1,21374,21375,1,1,30694,21395,1,21408,21419,21422,29607,1,
16217,29596,21441,21445,27721,20041,22526,21465,15019,1,21472,1,1,21494,1,21523,
28793,21803,26199,27995,21613,1,1,21853,21647,21668,18342,1,1,15796,1,1,1,21831,
19693,21551,29719,21894,21929,22021,1,1,17746,1,26291,1,22071,26317,1,26276,
26285,22093,22095,30961,22257,38791,21502,22272,22255,22253,1,13859,1,22342,1,
27758,28811,22338,14001,1,22502,1,22531,1,1,22566,1,22620,22698,13665,22752,
22748,1,22779,23551,22339,1,1,37843,13729,22815,26790,14019,28249,1,23076,21843,
1,34053,22985,1,1,1,1,23001,1,1,1,28017,1,1,23033,1,23211,23139,14054,1,23159,
14088,23190,29797,23251,1,1,15749,1,14130,1,24195,21200,23414,25992,23420,1,
16388,18525,1,23509,24928,1,1,1,23539,23453,19728,23557,1,23571,29646,23572,1,1,
23625,18653,23685,23785,23791,23947,1,1,23824,23832,23878,1,23738,24023,33532,
14381,1,1,1,33415,14390,15298,24110,27274,24181,24186,1,1,21414,20151,24272,
21416,1,24073,24308,1,24313,24315,14496,24316,26686,37915,24333,1,1,15070,18606,
1,24378,1,1,24408,1,24419,38845,1,24434,37696,1,24487,23990,15711,1,1,1,1,37334,
1,1,24625,26245,1,14691,15815,13881,22416,1,31089,15936,24734,24740,24755,1,1,1,
29860,20705,23200,24932,33828,24898,1,1,24961,20980,1,24967,23466,1,1,25043,1,1,
25040,14642,1,1,24611,24924,25886,25483,1,25285,1,25301,1,25452,1,14871,25656,
25592,1,1,25744,28554,1,38932,1,1,25825,25829,38011,14950,25658,14935,25933,
28438,1,1,25989,25965,25951,1,26037,1,19255,26065,16600,1,26080,26083,24543,1,
26136,1,1,26180,1,1,26187,1,26215,1,26227,26228,1,1,1,1,1,30661,1,39332,26370,1,
1,15147,27130,1,26462,26471,26466,1,1,26583,17641,26658,28240,37436,26625,1,1,
26717,1,27105,27147,1,26995,26819,1,26881,26880,15666,14849,1,15232,26540,26977,
1,17148,26934,27032,15265,1,33635,20624,27129,1,1,27205,1,27293,15347,26545,
27336,1,15373,27421,1,24798,27445,27508,1,28341,1,1,1,14144,21537,1,27617,1,
27612,27703,1,1,1,27738,33318,27769,1,17605,1,1,1,1,1,14053,15595,1,39811,1,1,
32655,26679,1,1,1,28054,27996,28284,28420,1,1,1,34099,1,20935,27804,28189,33838,
1,28207,1,29779,1,31180,28239,23185,1,28664,14093,28573,1,28410,1,1,17749,37872,
28484,28508,15694,28532,1,15675,28575,1,28627,1,1,1,1,1,1,20959,1,1,1,1,28747,
28798,28839,28801,28876,28885,28886,28895,16644,15848,29108,29078,1,28971,28997,
23176,29002,29038,23708,1,29007,37730,1,28972,1,1,1,29114,1,28861,29198,37954,
29205,22801,37955,29220,37697,1,29230,29248,1,26813,29269,29271,15957,1,26637,
28477,29314,29482,29483,1,1,18669,1,29480,29486,29647,29610,1,1,29641,29769,1,1,
1,26147,14021,1,1,1,29687,29717,26883,1,29753,1,16087,29788,1,29792,1,29767,
29668,29814,33721,29804,14128,29812,37873,27180,29826,18771,1,1,1,1,23366,1,1,
29896,1,29966,29929,29982,1,1,23511,1,37765,30029,30026,30055,30062,1,16132,1,
30094,29789,30110,30132,30210,30252,30289,30287,30319,30326,1,30352,33263,14328,
1,1,30369,30373,30391,30412,1,33890,1,1,1,30494,30502,30528,25775,1,30552,1,
30639,1,1,1,30708,30729,1,1,26826,30895,30919,30931,38565,31022,1,30935,31028,
30897,1,36792,34948,1,1,1,31110,35072,26882,31104,1,31133,1,31036,31145,28202,1,
16040,31174,1,31188,
]
const Big5EncodeLow*: array[16777, UCS16x16] = [
(167u16,5103u16),(168u16,10951u16),(175u16,5120u16),(176u16,5205u16),
(177u16,5137u16),(183u16,5040u16),(192u16,1124u16),(193u16,1122u16),
(200u16,1128u16),(201u16,1126u16),(202u16,1137u16),(210u16,1132u16),
(211u16,1130u16),(215u16,5135u16),(224u16,1141u16),(225u16,1139u16),
(232u16,1146u16),(233u16,1144u16),(234u16,1168u16),(236u16,1150u16),
(237u16,1148u16),(242u16,1154u16),(243u16,1152u16),(247u16,5136u16),
(248u16,11300u16),(249u16,1158u16),(250u16,1156u16),(252u16,1163u16),
(256u16,1121u16),(257u16,1138u16),(274u16,1125u16),(275u16,1143u16),
(282u16,1127u16),(283u16,1145u16),(299u16,1147u16),(331u16,11301u16),
(332u16,1129u16),(333u16,1151u16),(339u16,11299u16),(363u16,1155u16),
(461u16,1123u16),(462u16,1140u16),(464u16,1149u16),(465u16,1131u16),
(466u16,1153u16),(468u16,1157u16),(470u16,1159u16),(472u16,1160u16),
(474u16,1161u16),(476u16,1162u16),(592u16,11295u16),(593u16,1142u16),
(596u16,11297u16),(603u16,11296u16),(609u16,1169u16),(618u16,11303u16),
(629u16,11298u16),(643u16,11294u16),(650u16,11302u16),(710u16,10952u16),
(711u16,5430u16),(713u16,5428u16),(714u16,5429u16),(715u16,5431u16),
(717u16,5123u16),(729u16,5427u16),(913u16,5342u16),(914u16,5343u16),
(915u16,5344u16),(916u16,5345u16),(917u16,5346u16),(918u16,5347u16),
(919u16,5348u16),(920u16,5349u16),(921u16,5350u16),(922u16,5351u16),
(923u16,5352u16),(924u16,5353u16),(925u16,5354u16),(926u16,5355u16),
(927u16,5356u16),(928u16,5357u16),(929u16,5358u16),(931u16,5359u16),
(932u16,5360u16),(933u16,5361u16),(934u16,5362u16),(935u16,5363u16),
(936u16,5364u16),(937u16,5365u16),(945u16,5366u16),(946u16,5367u16),
(947u16,5368u16),(948u16,5369u16),(949u16,5370u16),(950u16,5371u16),
(951u16,5372u16),(952u16,5373u16),(953u16,5374u16),(954u16,5375u16),
(955u16,5376u16),(956u16,5377u16),(957u16,5378u16),(958u16,5379u16),
(959u16,5380u16),(960u16,5381u16),(961u16,5382u16),(963u16,5383u16),
(964u16,5384u16),(965u16,5385u16),(966u16,5386u16),(967u16,5387u16),
(968u16,5388u16),(969u16,5389u16),(1025u16,11141u16),(1040u16,11135u16),
(1041u16,11136u16),(1042u16,11137u16),(1043u16,11138u16),(1044u16,11139u16),
(1045u16,11140u16),(1046u16,11142u16),(1047u16,11143u16),(1048u16,11144u16),
(1049u16,11145u16),(1050u16,11146u16),(1051u16,11147u16),(1052u16,11148u16),
(1053u16,11149u16),(1054u16,11150u16),(1055u16,11151u16),(1056u16,11152u16),
(1057u16,11153u16),(1058u16,11154u16),(1059u16,11155u16),(1060u16,11156u16),
(1061u16,11157u16),(1062u16,11158u16),(1063u16,11159u16),(1064u16,11160u16),
(1065u16,11161u16),(1066u16,11162u16),(1067u16,11163u16),(1068u16,11164u16),
(1069u16,11165u16),(1070u16,11166u16),(1071u16,11167u16),(1072u16,11168u16),
(1073u16,11169u16),(1074u16,11170u16),(1075u16,11171u16),(1076u16,11172u16),
(1077u16,11173u16),(1078u16,11175u16),(1079u16,11176u16),(1080u16,11177u16),
(1081u16,11178u16),(1082u16,11179u16),(1083u16,11180u16),(1084u16,11181u16),
(1085u16,11182u16),(1086u16,11183u16),(1087u16,11184u16),(1088u16,11185u16),
(1089u16,11186u16),(1090u16,11187u16),(1091u16,11188u16),(1092u16,11189u16),
(1093u16,11190u16),(1094u16,11191u16),(1095u16,11192u16),(1096u16,11193u16),
(1097u16,11194u16),(1098u16,11195u16),(1099u16,11196u16),(1100u16,11197u16),
(1101u16,11198u16),(1102u16,11199u16),(1103u16,11200u16),(1105u16,11174u16),
(7870u16,1134u16),(7871u16,1165u16),(7872u16,1136u16),(7873u16,1167u16),
(8211u16,5046u16),(8212u16,5048u16),(8216u16,5091u16),(8217u16,5092u16),
(8220u16,5093u16),(8221u16,5094u16),(8229u16,5036u16),(8230u16,5035u16),
(8231u16,5029u16),(8242u16,5098u16),(8245u16,5097u16),(8251u16,5102u16),
(8364u16,5465u16),(8451u16,5191u16),(8453u16,5119u16),(8457u16,5192u16),
(8470u16,11259u16),(8481u16,11260u16),(8544u16,5268u16),(8545u16,5269u16),
(8546u16,5270u16),(8547u16,5271u16),(8548u16,5272u16),(8549u16,5273u16),
(8550u16,5274u16),(8551u16,5275u16),(8552u16,5276u16),(8553u16,5277u16),
(8560u16,10916u16),(8561u16,10917u16),(8562u16,10918u16),(8563u16,10919u16),
(8564u16,10920u16),(8565u16,10921u16),(8566u16,10922u16),(8567u16,10923u16),
(8568u16,10924u16),(8569u16,10925u16),(8592u16,5172u16),(8593u16,5170u16),
(8594u16,5173u16),(8595u16,5171u16),(8598u16,5174u16),(8599u16,5175u16),
(8600u16,5177u16),(8601u16,5176u16),(8632u16,11202u16),(8633u16,11203u16),
(8679u16,11201u16),(8725u16,5182u16),(8730u16,5138u16),(8734u16,5145u16),
(8735u16,5158u16),(8736u16,5157u16),(8739u16,5179u16),(8741u16,5178u16),
(8745u16,5154u16),(8746u16,5155u16),(8747u16,5162u16),(8750u16,5163u16),
(8756u16,5165u16),(8757u16,5164u16),(8786u16,5146u16),(8800u16,5144u16),
(8801u16,5147u16),(8806u16,5142u16),(8807u16,5143u16),(8853u16,5168u16),
(8857u16,5169u16),(8869u16,5156u16),(8895u16,5159u16),(9178u16,1170u16),
(9179u16,1171u16),(9216u16,5432u16),(9217u16,5433u16),(9218u16,5434u16),
(9219u16,5435u16),(9220u16,5436u16),(9221u16,5437u16),(9222u16,5438u16),
(9223u16,5439u16),(9224u16,5440u16),(9225u16,5441u16),(9226u16,5442u16),
(9227u16,5443u16),(9228u16,5444u16),(9229u16,5445u16),(9230u16,5446u16),
(9231u16,5447u16),(9232u16,5448u16),(9233u16,5449u16),(9234u16,5450u16),
(9235u16,5451u16),(9236u16,5452u16),(9237u16,5453u16),(9238u16,5454u16),
(9239u16,5455u16),(9240u16,5456u16),(9241u16,5457u16),(9242u16,5458u16),
(9243u16,5459u16),(9244u16,5460u16),(9245u16,5461u16),(9246u16,5462u16),
(9247u16,5463u16),(9249u16,5464u16),(9312u16,10896u16),(9313u16,10897u16),
(9314u16,10898u16),(9315u16,10899u16),(9316u16,10900u16),(9317u16,10901u16),
(9318u16,10902u16),(9319u16,10903u16),(9320u16,10904u16),(9321u16,10905u16),
(9332u16,10906u16),(9333u16,10907u16),(9334u16,10908u16),(9335u16,10909u16),
(9336u16,10910u16),(9337u16,10911u16),(9338u16,10912u16),(9339u16,10913u16),
(9340u16,10914u16),(9341u16,10915u16),(9472u16,5236u16),(9474u16,5237u16),
(9484u16,5239u16),(9488u16,5240u16),(9492u16,5241u16),(9496u16,5242u16),
(9500u16,5234u16),(9508u16,5233u16),(9516u16,5232u16),(9524u16,5231u16),
(9532u16,5230u16),(9552u16,18991u16),(9553u16,18990u16),(9554u16,18972u16),
(9555u16,18981u16),(9556u16,18963u16),(9557u16,18974u16),(9558u16,18983u16),
(9559u16,18965u16),(9560u16,18978u16),(9561u16,18987u16),(9562u16,18969u16),
(9563u16,18980u16),(9564u16,18989u16),(9565u16,18971u16),(9566u16,18975u16),
(9567u16,18984u16),(9568u16,18966u16),(9569u16,18977u16),(9570u16,18986u16),
(9571u16,18968u16),(9572u16,18973u16),(9573u16,18982u16),(9574u16,18964u16),
(9575u16,18979u16),(9576u16,18988u16),(9577u16,18970u16),(9578u16,18976u16),
(9579u16,18985u16),(9580u16,18967u16),(9581u16,5243u16),(9582u16,5244u16),
(9583u16,5246u16),(9584u16,5245u16),(9585u16,5255u16),(9586u16,5256u16),
(9587u16,5257u16),(9588u16,5050u16),(9601u16,5215u16),(9602u16,5216u16),
(9603u16,5217u16),(9604u16,5218u16),(9605u16,5219u16),(9606u16,5220u16),
(9607u16,5221u16),(9608u16,5222u16),(9609u16,5229u16),(9610u16,5228u16),
(9611u16,5227u16),(9612u16,5226u16),(9613u16,5225u16),(9614u16,5224u16),
(9615u16,5223u16),(9620u16,5235u16),(9621u16,5238u16),(9632u16,5115u16),
(9633u16,5114u16),(9650u16,5108u16),(9651u16,5107u16),(9660u16,5117u16),
(9661u16,5116u16),(9670u16,5113u16),(9671u16,5112u16),(9675u16,5105u16),
(9678u16,5109u16),(9679u16,5106u16),(9698u16,5251u16),(9699u16,5252u16),
(9700u16,5254u16),(9701u16,5253u16),(9733u16,5111u16),(9734u16,5110u16),
(9792u16,5166u16),(9794u16,5167u16),(10045u16,10965u16),(11904u16,11263u16),
(11908u16,11264u16),(11910u16,11265u16),(11911u16,11266u16),(11912u16,11267u16),
(11914u16,11268u16),(11916u16,11269u16),(11917u16,11270u16),(11925u16,11271u16),
(11932u16,11272u16),(11933u16,11273u16),(11941u16,11274u16),(11943u16,11275u16),
(11946u16,11276u16),(11948u16,11277u16),(11950u16,11278u16),(11958u16,11279u16),
(11964u16,11280u16),(11966u16,11281u16),(11974u16,11282u16),(11978u16,11283u16),
(11980u16,11284u16),(11981u16,11285u16),(11983u16,11286u16),(11990u16,11287u16),
(11991u16,11288u16),(11998u16,11289u16),(12003u16,11290u16),(12083u16,10940u16),
(12288u16,5024u16),(12289u16,5026u16),(12290u16,5027u16),(12291u16,5104u16),
(12293u16,10959u16),(12294u16,10960u16),(12295u16,10961u16),(12296u16,5073u16),
(12297u16,5074u16),(12298u16,5069u16),(12299u16,5070u16),(12300u16,5077u16),
(12301u16,5078u16),(12302u16,5081u16),(12303u16,5082u16),(12304u16,5065u16),
(12305u16,5066u16),(12306u16,5186u16),(12308u16,5061u16),(12309u16,5062u16),
(12317u16,5095u16),(12318u16,5096u16),(12321u16,5278u16),(12322u16,5279u16),
(12323u16,5280u16),(12324u16,5281u16),(12325u16,5282u16),(12326u16,5283u16),
(12327u16,5284u16),(12328u16,5285u16),(12329u16,5286u16),(12353u16,10966u16),
(12354u16,10967u16),(12355u16,10968u16),(12356u16,10969u16),(12357u16,10970u16),
(12358u16,10971u16),(12359u16,10972u16),(12360u16,10973u16),(12361u16,10974u16),
(12362u16,10975u16),(12363u16,10976u16),(12364u16,10977u16),(12365u16,10978u16),
(12366u16,10979u16),(12367u16,10980u16),(12368u16,10981u16),(12369u16,10982u16),
(12370u16,10983u16),(12371u16,10984u16),(12372u16,10985u16),(12373u16,10986u16),
(12374u16,10987u16),(12375u16,10988u16),(12376u16,10989u16),(12377u16,10990u16),
(12378u16,10991u16),(12379u16,10992u16),(12380u16,10993u16),(12381u16,10994u16),
(12382u16,10995u16),(12383u16,10996u16),(12384u16,10997u16),(12385u16,10998u16),
(12386u16,10999u16),(12387u16,11000u16),(12388u16,11001u16),(12389u16,11002u16),
(12390u16,11003u16),(12391u16,11004u16),(12392u16,11005u16),(12393u16,11006u16),
(12394u16,11007u16),(12395u16,11008u16),(12396u16,11009u16),(12397u16,11010u16),
(12398u16,11011u16),(12399u16,11012u16),(12400u16,11013u16),(12401u16,11014u16),
(12402u16,11015u16),(12403u16,11016u16),(12404u16,11017u16),(12405u16,11018u16),
(12406u16,11019u16),(12407u16,11020u16),(12408u16,11021u16),(12409u16,11022u16),
(12410u16,11023u16),(12411u16,11024u16),(12412u16,11025u16),(12413u16,11026u16),
(12414u16,11027u16),(12415u16,11028u16),(12416u16,11029u16),(12417u16,11030u16),
(12418u16,11031u16),(12419u16,11032u16),(12420u16,11033u16),(12421u16,11034u16),
(12422u16,11035u16),(12423u16,11036u16),(12424u16,11037u16),(12425u16,11038u16),
(12426u16,11039u16),(12427u16,11040u16),(12428u16,11041u16),(12429u16,11042u16),
(12430u16,11043u16),(12431u16,11044u16),(12432u16,11045u16),(12433u16,11046u16),
(12434u16,11047u16),(12435u16,11048u16),(12443u16,11261u16),(12444u16,11262u16),
(12445u16,10955u16),(12446u16,10956u16),(12449u16,11049u16),(12450u16,11050u16),
(12451u16,11051u16),(12452u16,11052u16),(12453u16,11053u16),(12454u16,11054u16),
(12455u16,11055u16),(12456u16,11056u16),(12457u16,11057u16),(12458u16,11058u16),
(12459u16,11059u16),(12460u16,11060u16),(12461u16,11061u16),(12462u16,11062u16),
(12463u16,11063u16),(12464u16,11064u16),(12465u16,11065u16),(12466u16,11066u16),
(12467u16,11067u16),(12468u16,11068u16),(12469u16,11069u16),(12470u16,11070u16),
(12471u16,11071u16),(12472u16,11072u16),(12473u16,11073u16),(12474u16,11074u16),
(12475u16,11075u16),(12476u16,11076u16),(12477u16,11077u16),(12478u16,11078u16),
(12479u16,11079u16),(12480u16,11080u16),(12481u16,11081u16),(12482u16,11082u16),
(12483u16,11083u16),(12484u16,11084u16),(12485u16,11085u16),(12486u16,11086u16),
(12487u16,11087u16),(12488u16,11088u16),(12489u16,11089u16),(12490u16,11090u16),
(12491u16,11091u16),(12492u16,11092u16),(12493u16,11093u16),(12494u16,11094u16),
(12495u16,11095u16),(12496u16,11096u16),(12497u16,11097u16),(12498u16,11098u16),
(12499u16,11099u16),(12500u16,11100u16),(12501u16,11101u16),(12502u16,11102u16),
(12503u16,11103u16),(12504u16,11104u16),(12505u16,11105u16),(12506u16,11106u16),
(12507u16,11107u16),(12508u16,11108u16),(12509u16,11109u16),(12510u16,11110u16),
(12511u16,11111u16),(12512u16,11112u16),(12513u16,11113u16),(12514u16,11114u16),
(12515u16,11115u16),(12516u16,11116u16),(12517u16,11117u16),(12518u16,11118u16),
(12519u16,11119u16),(12520u16,11120u16),(12521u16,11121u16),(12522u16,11122u16),
(12523u16,11123u16),(12524u16,11124u16),(12525u16,11125u16),(12526u16,11126u16),
(12527u16,11127u16),(12528u16,11128u16),(12529u16,11129u16),(12530u16,11130u16),
(12531u16,11131u16),(12532u16,11132u16),(12533u16,11133u16),(12534u16,11134u16),
(12540u16,10962u16),(12541u16,10953u16),(12542u16,10954u16),(12549u16,5390u16),
(12550u16,5391u16),(12551u16,5392u16),(12552u16,5393u16),(12553u16,5394u16),
(12554u16,5395u16),(12555u16,5396u16),(12556u16,5397u16),(12557u16,5398u16),
(12558u16,5399u16),(12559u16,5400u16),(12560u16,5401u16),(12561u16,5402u16),
(12562u16,5403u16),(12563u16,5404u16),(12564u16,5405u16),(12565u16,5406u16),
(12566u16,5407u16),(12567u16,5408u16),(12568u16,5409u16),(12569u16,5410u16),
(12570u16,5411u16),(12571u16,5412u16),(12572u16,5413u16),(12573u16,5414u16),
(12574u16,5415u16),(12575u16,5416u16),(12576u16,5417u16),(12577u16,5418u16),
(12578u16,5419u16),(12579u16,5420u16),(12580u16,5421u16),(12581u16,5422u16),
(12582u16,5423u16),(12583u16,5424u16),(12584u16,5425u16),(12585u16,5426u16),
(12736u16,1099u16),(12737u16,1100u16),(12738u16,1101u16),(12739u16,1102u16),
(12740u16,1103u16),(12741u16,1105u16),(12742u16,1108u16),(12743u16,1109u16),
(12744u16,1112u16),(12745u16,1114u16),(12746u16,1115u16),(12747u16,1116u16),
(12748u16,1117u16),(12749u16,1119u16),(12750u16,1120u16),(12751u16,11204u16),
(12849u16,11258u16),(12963u16,5118u16),(13198u16,5202u16),(13199u16,5203u16),
(13212u16,5197u16),(13213u16,5198u16),(13214u16,5199u16),(13217u16,5201u16),
(13252u16,5204u16),(13262u16,5200u16),(13265u16,5161u16),(13266u16,5160u16),
(13269u16,5196u16),(13365u16,2724u16),(13376u16,3422u16),(13386u16,1873u16),
(13388u16,1371u16),(13412u16,2933u16),(13427u16,4207u16),(13434u16,19037u16),
(13437u16,1376u16),(13438u16,2223u16),(13459u16,1377u16),(13462u16,2227u16),
(13477u16,1378u16),(13487u16,3446u16),(13500u16,1533u16),(13505u16,1692u16),
(13512u16,3575u16),(13535u16,4572u16),(13540u16,4468u16),(13542u16,1034u16),
(13563u16,4218u16),(13574u16,1459u16),(13630u16,1672u16),(13649u16,1390u16),
(13651u16,1392u16),(13657u16,1738u16),(13665u16,19202u16),(13677u16,1395u16),
(13680u16,3106u16),(13682u16,1396u16),(13687u16,4635u16),(13688u16,1526u16),
(13700u16,2790u16),(13719u16,3104u16),(13720u16,1407u16),(13729u16,19212u16),
(13733u16,1409u16),(13741u16,4707u16),(13759u16,1410u16),(13761u16,1349u16),
(13765u16,1412u16),(13767u16,1388u16),(13770u16,4402u16),(13774u16,4536u16),
(13778u16,4929u16),(13782u16,4907u16),(13787u16,3746u16),(13789u16,1610u16),
(13809u16,2039u16),(13810u16,1662u16),(13811u16,4829u16),(13819u16,1550u16),
(13822u16,4827u16),(13833u16,1612u16),(13848u16,4267u16),(13850u16,1649u16),
(13859u16,19184u16),(13861u16,990u16),(13869u16,4541u16),(13877u16,4977u16),
(13881u16,19349u16),(13886u16,2804u16),(13895u16,4063u16),(13896u16,2271u16),
(13897u16,19005u16),(13902u16,2046u16),(13919u16,4286u16),(13921u16,1912u16),
(13946u16,4677u16),(13953u16,1397u16),(13978u16,3432u16),(13989u16,4642u16),
(13994u16,3107u16),(13996u16,4639u16),(14000u16,3542u16),(14001u16,19191u16),
(14005u16,3256u16),(14009u16,4328u16),(14012u16,3574u16),(14017u16,2203u16),
(14019u16,19215u16),(14020u16,2536u16),(14021u16,19661u16),(14023u16,3633u16),
(14024u16,4095u16),(14035u16,2853u16),(14036u16,3241u16),(14038u16,3587u16),
(14045u16,2851u16),(14049u16,2659u16),(14050u16,3540u16),(14053u16,19532u16),
(14054u16,19238u16),(14069u16,2821u16),(14081u16,2849u16),(14083u16,1638u16),
(14088u16,19241u16),(14090u16,3532u16),(14093u16,19566u16),(14108u16,4302u16),
(14114u16,2656u16),(14115u16,2663u16),(14117u16,2341u16),(14124u16,3459u16),
(14125u16,3630u16),(14128u16,19681u16),(14130u16,19249u16),(14131u16,2686u16),
(14138u16,4471u16),(14144u16,19512u16),(14147u16,19040u16),(14178u16,4178u16),
(14191u16,3984u16),(14231u16,1602u16),(14240u16,2837u16),(14265u16,4016u16),
(14270u16,2597u16),(14294u16,1895u16),(14322u16,3222u16),(14328u16,19724u16),
(14331u16,4695u16),(14351u16,1920u16),(14361u16,2710u16),(14368u16,1923u16),
(14381u16,19290u16),(14390u16,19295u16),(14392u16,1924u16),(14435u16,2963u16),
(14453u16,1000u16),(14496u16,19313u16),(14531u16,2550u16),(14540u16,19104u16),
(14545u16,2949u16),(14548u16,1902u16),(14586u16,1676u16),(14600u16,1929u16),
(14612u16,1930u16),(14631u16,3367u16),(14642u16,19379u16),(14655u16,1931u16),
(14669u16,1932u16),(14691u16,19347u16),(14712u16,1872u16),(14720u16,2387u16),
(14729u16,1936u16),(14730u16,3551u16),(14738u16,1523u16),(14745u16,2721u16),
(14747u16,4174u16),(14753u16,4341u16),(14756u16,4327u16),(14776u16,1940u16),
(14812u16,4640u16),(14818u16,3166u16),(14821u16,2594u16),(14828u16,1421u16),
(14840u16,1945u16),(14843u16,1474u16),(14846u16,1509u16),(14849u16,19478u16),
(14851u16,1947u16),(14854u16,1524u16),(14871u16,19393u16),(14872u16,1577u16),
(14889u16,2892u16),(14890u16,4673u16),(14900u16,1430u16),(14923u16,1952u16),
(14930u16,4652u16),(14935u16,19409u16),(14940u16,4923u16),(14942u16,3066u16),
(14950u16,19407u16),(14951u16,1456u16),(14999u16,1957u16),(15019u16,19131u16),
(15037u16,1959u16),(15070u16,19320u16),(15072u16,2921u16),(15088u16,2402u16),
(15090u16,1962u16),(15093u16,1006u16),(15099u16,3045u16),(15118u16,2507u16),
(15129u16,3040u16),(15138u16,1964u16),(15147u16,19451u16),(15161u16,3827u16),
(15170u16,1966u16),(15192u16,1969u16),(15200u16,2593u16),(15217u16,1973u16),
(15218u16,1972u16),(15227u16,1974u16),(15228u16,2359u16),(15232u16,19480u16),
(15253u16,953u16),(15254u16,2956u16),(15257u16,2952u16),(15265u16,19487u16),
(15292u16,1981u16),(15294u16,4168u16),(15298u16,19296u16),(15300u16,2961u16),
(15319u16,2974u16),(15325u16,1983u16),(15340u16,1988u16),(15346u16,1990u16),
(15347u16,19497u16),(15348u16,2909u16),(15373u16,19501u16),(15377u16,4389u16),
(15381u16,2687u16),(15384u16,5001u16),(15444u16,4306u16),(15499u16,1749u16),
(15563u16,2000u16),(15565u16,3548u16),(15569u16,4991u16),(15574u16,3566u16),
(15580u16,19064u16),(15595u16,19533u16),(15599u16,2005u16),(15634u16,1863u16),
(15635u16,2118u16),(15645u16,2595u16),(15666u16,19477u16),(15675u16,19579u16),
(15686u16,2021u16),(15692u16,3554u16),(15694u16,19576u16),(15697u16,2509u16),
(15711u16,19336u16),(15714u16,3413u16),(15721u16,3553u16),(15722u16,2025u16),
(15727u16,3571u16),(15733u16,2026u16),(15741u16,3365u16),(15749u16,19247u16),
(15752u16,1852u16),(15754u16,2029u16),(15759u16,2992u16),(15761u16,2031u16),
(15781u16,3661u16),(15789u16,2084u16),(15796u16,19152u16),(15807u16,2214u16),
(15814u16,4502u16),(15815u16,19348u16),(15817u16,1731u16),(15820u16,3814u16),
(15821u16,3046u16),(15827u16,2233u16),(15835u16,4987u16),(15847u16,2688u16),
(15848u16,19603u16),(15851u16,4479u16),(15859u16,3668u16),(15860u16,984u16),
(15863u16,4425u16),(15868u16,1919u16),(15869u16,3338u16),(15878u16,4758u16),
(15936u16,19353u16),(15939u16,1514u16),(15944u16,1373u16),(15957u16,19638u16),
(15988u16,4676u16),(16040u16,19778u16),(16041u16,3701u16),(16042u16,19103u16),
(16045u16,3218u16),(16049u16,3019u16),(16056u16,2873u16),(16063u16,3070u16),
(16066u16,3278u16),(16071u16,2652u16),(16074u16,3708u16),(16076u16,3288u16),
(16080u16,2353u16),(16081u16,3710u16),(16086u16,3492u16),(16087u16,19671u16),
(16090u16,3577u16),(16091u16,1799u16),(16094u16,2781u16),(16097u16,3487u16),
(16098u16,3716u16),(16103u16,3282u16),(16105u16,3483u16),(16107u16,2641u16),
(16108u16,1004u16),(16112u16,3717u16),(16115u16,3024u16),(16116u16,3718u16),
(16122u16,3719u16),(16124u16,3294u16),(16127u16,3048u16),(16128u16,3331u16),
(16132u16,19709u16),(16134u16,3018u16),(16135u16,1891u16),(16142u16,3721u16),
(16211u16,3722u16),(16216u16,3036u16),(16217u16,19123u16),(16227u16,3033u16),
(16252u16,3727u16),(16275u16,1555u16),(16320u16,3730u16),(16328u16,1910u16),
(16343u16,3732u16),(16348u16,3734u16),(16357u16,3681u16),(16365u16,1458u16),
(16377u16,1566u16),(16378u16,1489u16),(16388u16,19257u16),(16393u16,1756u16),
(16413u16,3741u16),(16441u16,3743u16),(16453u16,3745u16),(16467u16,1426u16),
(16471u16,2692u16),(16482u16,3265u16),(16485u16,4941u16),(16490u16,3748u16),
(16495u16,3749u16),(16497u16,1824u16),(16552u16,3757u16),(16564u16,1061u16),
(16571u16,1499u16),(16575u16,4686u16),(16584u16,3073u16),(16600u16,19422u16),
(16607u16,4339u16),(16632u16,1894u16),(16634u16,4615u16),(16642u16,1888u16),
(16643u16,3767u16),(16644u16,19602u16),(16649u16,3768u16),(16654u16,3086u16),
(16689u16,1042u16),(16690u16,3096u16),(16743u16,3774u16),(16748u16,2449u16),
(16750u16,3094u16),(16764u16,1898u16),(16767u16,3191u16),(16769u16,1050u16),
(16784u16,2922u16),(16818u16,3776u16),(16836u16,3779u16),(16842u16,2062u16),
(16847u16,3782u16),(16859u16,2197u16),(16877u16,1915u16),(16879u16,2066u16),
(16889u16,3121u16),(16913u16,3124u16),(16931u16,1759u16),(16960u16,2250u16),
(16992u16,3789u16),(17002u16,3144u16),(17014u16,1832u16),(17018u16,3790u16),
(17036u16,3793u16),(17044u16,3795u16),(17058u16,1825u16),(17077u16,19002u16),
(17081u16,2440u16),(17084u16,3457u16),(17140u16,3247u16),(17147u16,3557u16),
(17148u16,19484u16),(17162u16,1014u16),(17195u16,2128u16),(17262u16,3240u16),
(17303u16,3807u16),(17306u16,1856u16),(17338u16,1500u16),(17345u16,2038u16),
(17369u16,1467u16),(17375u16,4413u16),(17389u16,3819u16),(17392u16,942u16),
(17394u16,4411u16),(17409u16,3826u16),(17410u16,3176u16),(17427u16,3831u16),
(17445u16,3835u16),(17453u16,3837u16),(17530u16,2180u16),(17551u16,3843u16),
(17553u16,11209u16),(17567u16,3029u16),(17568u16,2246u16),(17570u16,19107u16),
(17584u16,3849u16),(17591u16,4886u16),(17597u16,1914u16),(17600u16,3325u16),
(17603u16,1853u16),(17605u16,19526u16),(17614u16,3610u16),(17629u16,2760u16),
(17630u16,1913u16),(17631u16,3609u16),(17633u16,1063u16),(17636u16,2234u16),
(17641u16,19460u16),(17642u16,3174u16),(17643u16,3561u16),(17644u16,4589u16),
(17652u16,2681u16),(17667u16,2144u16),(17668u16,3858u16),(17673u16,4463u16),
(17675u16,2218u16),(17686u16,2258u16),(17691u16,1905u16),(17693u16,2105u16),
(17703u16,2256u16),(17710u16,3530u16),(17715u16,3399u16),(17718u16,1857u16),
(17723u16,3865u16),(17725u16,2471u16),(17727u16,4331u16),(17731u16,2252u16),
(17745u16,3031u16),(17746u16,19165u16),(17749u16,19572u16),(17752u16,1868u16),
(17756u16,2142u16),(17761u16,1904u16),(17762u16,5018u16),(17770u16,2269u16),
(17773u16,1901u16),(17783u16,3869u16),(17784u16,946u16),(17797u16,2472u16),
(17830u16,945u16),(17843u16,949u16),(17882u16,966u16),(17897u16,4678u16),
(17898u16,1909u16),(17923u16,944u16),(17926u16,3876u16),(17935u16,2286u16),
(17941u16,2335u16),(17943u16,3877u16),(18011u16,2294u16),(18042u16,2772u16),
(18048u16,3576u16),(18081u16,971u16),(18094u16,1048u16),(18107u16,1889u16),
(18127u16,3221u16),(18128u16,4296u16),(18165u16,3220u16),(18167u16,1896u16),
(18195u16,2319u16),(18200u16,4211u16),(18230u16,954u16),(18244u16,955u16),
(18254u16,4611u16),(18255u16,965u16),(18300u16,4222u16),(18328u16,3892u16),
(18342u16,19149u16),(18389u16,1431u16),(18413u16,3895u16),(18420u16,1452u16),
(18432u16,1653u16),(18443u16,1487u16),(18487u16,3903u16),(18525u16,19258u16),
(18545u16,3578u16),(18587u16,3251u16),(18605u16,3915u16),(18606u16,19321u16),
(18640u16,4153u16),(18653u16,19276u16),(18669u16,19647u16),(18675u16,4619u16),
(18682u16,4405u16),(18694u16,3261u16),(18705u16,1355u16),(18718u16,3918u16),
(18725u16,3333u16),(18730u16,2376u16),(18733u16,3411u16),(18735u16,1040u16),
(18736u16,1018u16),(18741u16,3514u16),(18748u16,3310u16),(18750u16,3581u16),
(18757u16,3933u16),(18769u16,3934u16),(18771u16,19686u16),(18789u16,2427u16),
(18794u16,3941u16),(18802u16,2833u16),(18825u16,2159u16),(18849u16,2458u16),
(18855u16,3946u16),(18911u16,2445u16),(18917u16,3949u16),(18919u16,1656u16),
(18959u16,2470u16),(18973u16,3298u16),(18980u16,3951u16),(18997u16,3953u16),
(19094u16,3550u16),(19108u16,970u16),(19124u16,1502u16),(19128u16,4154u16),
(19153u16,2502u16),(19172u16,3957u16),(19199u16,2517u16),(19216u16,1751u16),
(19225u16,3960u16),(19232u16,1736u16),(19244u16,1654u16),(19255u16,19420u16),
(19311u16,3340u16),(19312u16,3971u16),(19314u16,2527u16),(19323u16,3460u16),
(19326u16,4999u16),(19342u16,2786u16),(19344u16,3350u16),(19347u16,2940u16),
(19350u16,2601u16),(19351u16,3354u16),(19357u16,3973u16),(19389u16,3353u16),
(19390u16,2619u16),(19392u16,4249u16),(19460u16,4914u16),(19463u16,4909u16),
(19470u16,2543u16),(19506u16,943u16),(19515u16,4777u16),(19518u16,1344u16),
(19520u16,957u16),(19527u16,956u16),(19543u16,963u16),(19547u16,4660u16),
(19565u16,3982u16),(19575u16,1871u16),(19579u16,1907u16),(19581u16,4504u16),
(19585u16,1839u16),(19589u16,967u16),(19620u16,4447u16),(19630u16,3384u16),
(19632u16,3387u16),(19639u16,4350u16),(19661u16,1341u16),(19681u16,4693u16),
(19682u16,951u16),(19693u16,19157u16),(19719u16,969u16),(19721u16,4656u16),
(19728u16,19267u16),(19764u16,2588u16),(19830u16,1908u16),(19831u16,948u16),
(19849u16,1906u16),(19857u16,4452u16),(19868u16,4455u16),(19968u16,5495u16),
(19969u16,5497u16),(19971u16,5498u16),(19972u16,4634u16),(19975u16,11309u16),
(19976u16,5517u16),(19977u16,5515u16),(19978u16,5518u16),(19979u16,5516u16),
(19980u16,11310u16),(19981u16,5560u16),(19982u16,11319u16),(19983u16,11317u16),
(19984u16,5559u16),(19985u16,5558u16),(19988u16,5654u16),(19989u16,5653u16),
(19990u16,5652u16),(19992u16,5655u16),(19993u16,5651u16),(19994u16,4633u16),
(19996u16,4512u16),(19998u16,5778u16),(19999u16,5779u16),(20001u16,3783u16),
(20004u16,1364u16),(20006u16,6220u16),(20008u16,1664u16),(20010u16,4808u16),
(20011u16,5519u16),(20012u16,1684u16),(20013u16,5561u16),(20014u16,11320u16),
(20015u16,1777u16),(20016u16,5562u16),(20017u16,11339u16),(20018u16,5945u16),
(20019u16,11697u16),(20022u16,10926u16),(20023u16,1721u16),(20024u16,5520u16),
(20025u16,5563u16),(20027u16,5656u16),(20028u16,11340u16),(20029u16,1262u16),
(20031u16,10927u16),(20034u16,11304u16),(20035u16,5499u16),(20037u16,5522u16),
(20039u16,11311u16),(20040u16,5523u16),(20041u16,19128u16),(20043u16,5564u16),
(20045u16,5657u16),(20046u16,5659u16),(20047u16,5658u16),(20050u16,5780u16),
(20051u16,5781u16),(20054u16,6221u16),(20056u16,6998u16),(20057u16,5496u16),
(20058u16,11206u16),(20059u16,1670u16),(20060u16,11305u16),(20061u16,5500u16),
(20062u16,5525u16),(20063u16,5524u16),(20073u16,5782u16),(20074u16,4262u16),
(20083u16,6222u16),(20088u16,4078u16),(20094u16,7455u16),(20095u16,13042u16),
(20096u16,1366u16),(20097u16,1365u16),(20098u16,8418u16),(20099u16,14366u16),
(20100u16,14367u16),(20101u16,10928u16),(20102u16,5501u16),(20103u16,1367u16),
(20104u16,5566u16),(20105u16,1384u16),(20107u16,6223u16),(20108u16,5502u16),
(20109u16,11312u16),(20110u16,5526u16),(20113u16,5567u16),(20114u16,5569u16),
(20115u16,11321u16),(20116u16,5570u16),(20117u16,5568u16),(20120u16,2731u16),
(20121u16,5783u16),(20122u16,4484u16),(20123u16,6224u16),(20126u16,6225u16),
(20127u16,6599u16),(20128u16,10929u16),(20129u16,5527u16),(20130u16,5571u16),
(20131u16,1774u16),(20132u16,5784u16),(20133u16,5786u16),(20134u16,5785u16),
(20136u16,5946u16),(20139u16,6226u16),(20140u16,6227u16),(20141u16,6600u16),
(20142u16,6601u16),(20147u16,6999u16),(20150u16,14368u16),(20151u16,19304u16),
(20153u16,18485u16),(20154u16,5503u16),(20155u16,1671u16),(20156u16,2712u16),
(20159u16,1368u16),(20160u16,5573u16),(20161u16,5572u16),(20162u16,11322u16),
(20163u16,5574u16),(20164u16,5580u16),(20166u16,5575u16),(20167u16,5576u16),
(20168u16,11324u16),(20169u16,11323u16),(20170u16,5578u16),(20171u16,5579u16),
(20173u16,5577u16),(20174u16,4819u16),(20180u16,5662u16),(20181u16,5663u16),
(20182u16,5664u16),(20183u16,5665u16),(20184u16,5661u16),(20185u16,5668u16),
(20186u16,11346u16),(20188u16,11342u16),(20189u16,10958u16),(20190u16,5669u16),
(20191u16,5685u16),(20193u16,11344u16),(20195u16,5666u16),(20196u16,5667u16),
(20197u16,5660u16),(20200u16,11341u16),(20201u16,11343u16),(20202u16,4467u16),
(20203u16,1369u16),(20206u16,3896u16),(20208u16,5799u16),(20209u16,11382u16),
(20210u16,5796u16),(20211u16,5800u16),(20212u16,11392u16),(20213u16,11380u16),
(20214u16,5797u16),(20215u16,11384u16),(20216u16,2708u16),(20219u16,5798u16),
(20221u16,5801u16),(20223u16,5787u16),(20224u16,11383u16),(20225u16,5802u16),
(20226u16,11387u16),(20227u16,2735u16),(20228u16,11391u16),(20229u16,11388u16),
(20232u16,11385u16),(20233u16,5788u16),(20234u16,5790u16),(20235u16,5803u16),
(20237u16,5792u16),(20238u16,11377u16),(20239u16,5795u16),(20240u16,5793u16),
(20241u16,5794u16),(20242u16,11393u16),(20243u16,11390u16),(20244u16,11381u16),
(20245u16,5791u16),(20247u16,1778u16),(20248u16,11378u16),(20249u16,5789u16),
(20250u16,1270u16),(20253u16,11386u16),(20258u16,11389u16),(20264u16,1271u16),
(20265u16,2725u16),(20268u16,11379u16),(20269u16,11499u16),(20271u16,5968u16),
(20272u16,5955u16),(20274u16,2596u16),(20275u16,11500u16),(20276u16,5952u16),
(20278u16,5970u16),(20279u16,1370u16),(20280u16,5960u16),(20281u16,4822u16),
(20282u16,5959u16),(20283u16,11488u16),(20284u16,5963u16),(20285u16,5958u16),
(20286u16,11493u16),(20287u16,11501u16),(20289u16,11497u16),(20290u16,2738u16),
(20291u16,5961u16),(20293u16,3204u16),(20294u16,5964u16),(20295u16,5949u16),
(20296u16,5973u16),(20297u16,11490u16),(20299u16,2715u16),(20300u16,11709u16),
(20301u16,5947u16),(20302u16,5969u16),(20303u16,5948u16),(20304u16,5956u16),
(20305u16,5957u16),(20306u16,11495u16),(20307u16,11491u16),(20308u16,5962u16),
(20309u16,5954u16),(20310u16,11487u16),(20311u16,5950u16),(20312u16,11498u16),
(20313u16,5971u16),(20314u16,5974u16),(20315u16,5953u16),(20316u16,5966u16),
(20317u16,5972u16),(20318u16,5951u16),(20319u16,11496u16),(20320u16,5967u16),
(20321u16,11502u16),(20322u16,11489u16),(20323u16,5965u16),(20324u16,11492u16),
(20327u16,11494u16),(20329u16,6241u16),(20330u16,11711u16),(20331u16,11723u16),
(20332u16,6233u16),(20334u16,11724u16),(20335u16,6228u16),(20336u16,6238u16),
(20338u16,3433u16),(20339u16,6231u16),(20340u16,11705u16),(20341u16,6239u16),
(20342u16,11704u16),(20343u16,11708u16),(20344u16,11715u16),(20345u16,11713u16),
(20346u16,6247u16),(20347u16,6242u16),(20348u16,11699u16),(20349u16,11701u16),
(20350u16,6244u16),(20351u16,6232u16),(20352u16,11702u16),(20353u16,11714u16),
(20354u16,11721u16),(20355u16,6237u16),(20356u16,11707u16),(20357u16,11700u16),
(20358u16,6236u16),(20359u16,11703u16),(20360u16,6240u16),(20361u16,11706u16),
(20362u16,2716u16),(20363u16,6235u16),(20365u16,6230u16),(20367u16,6245u16),
(20368u16,11716u16),(20369u16,6246u16),(20370u16,11720u16),(20372u16,11718u16),
(20373u16,11722u16),(20374u16,6243u16),(20375u16,11710u16),(20376u16,11698u16),
(20378u16,11712u16),(20379u16,6234u16),(20380u16,11717u16),(20381u16,6229u16),
(20382u16,11719u16),(20386u16,2734u16),(20392u16,1272u16),(20395u16,19020u16),
(20398u16,6616u16),(20399u16,6604u16),(20400u16,3649u16),(20402u16,12058u16),
(20403u16,12066u16),(20404u16,1877u16),(20405u16,6603u16),(20406u16,6611u16),
(20407u16,6623u16),(20409u16,12072u16),(20410u16,12070u16),(20411u16,4258u16),
(20413u16,1372u16),(20415u16,6605u16),(20416u16,12071u16),(20417u16,12061u16),
(20418u16,6619u16),(20419u16,6610u16),(20420u16,6618u16),(20421u16,12056u16),
(20423u16,12068u16),(20424u16,3691u16),(20425u16,12059u16),(20426u16,6614u16),
(20427u16,12060u16),(20428u16,2742u16),(20429u16,12055u16),(20430u16,6621u16),
(20431u16,6608u16),(20432u16,6617u16),(20433u16,6607u16),(20435u16,12057u16),
(20436u16,12062u16),(20438u16,12069u16),(20439u16,6615u16),(20440u16,6612u16),
(20441u16,12064u16),(20442u16,6620u16),(20443u16,12067u16),(20444u16,12063u16),
(20445u16,6609u16),(20446u16,6622u16),(20447u16,6613u16),(20448u16,6606u16),
(20449u16,6602u16),(20452u16,3421u16),(20453u16,2743u16),(20460u16,12073u16),
(20462u16,7025u16),(20463u16,7003u16),(20464u16,1775u16),(20465u16,7019u16),
(20466u16,4756u16),(20467u16,7024u16),(20468u16,12513u16),(20469u16,12512u16),
(20470u16,12517u16),(20471u16,12518u16),(20472u16,7006u16),(20473u16,2185u16),
(20474u16,7015u16),(20477u16,4754u16),(20478u16,7028u16),(20480u16,7016u16),
(20483u16,1374u16),(20485u16,12506u16),(20486u16,7009u16),(20487u16,12507u16),
(20488u16,19022u16),(20489u16,7030u16),(20491u16,7021u16),(20492u16,7000u16),
(20493u16,7001u16),(20494u16,12526u16),(20495u16,7472u16),(20497u16,7014u16),
(20498u16,7013u16),(20499u16,12508u16),(20500u16,7017u16),(20501u16,13058u16),
(20502u16,7008u16),(20503u16,12519u16),(20504u16,7023u16),(20505u16,7022u16),
(20506u16,7012u16),(20507u16,12511u16),(20508u16,12520u16),(20510u16,12505u16),
(20511u16,7011u16),(20512u16,12521u16),(20513u16,7020u16),(20514u16,12509u16),
(20515u16,7002u16),(20517u16,7005u16),(20518u16,7004u16),(20519u16,12522u16),
(20520u16,7018u16),(20521u16,7007u16),(20522u16,7027u16),(20523u16,7029u16),
(20524u16,12516u16),(20525u16,7026u16),(20526u16,2739u16),(20527u16,12524u16),
(20528u16,12510u16),(20529u16,12525u16),(20531u16,12514u16),(20532u16,2547u16),
(20533u16,12523u16),(20535u16,12515u16),(20539u16,1727u16),(20540u16,7010u16),
(20544u16,13066u16),(20545u16,13054u16),(20547u16,7460u16),(20549u16,13059u16),
(20550u16,13065u16),(20551u16,7459u16),(20552u16,13052u16),(20553u16,7463u16),
(20554u16,13056u16),(20555u16,13049u16),(20556u16,7461u16),(20557u16,13053u16),
(20558u16,7466u16),(20559u16,7471u16),(20561u16,13070u16),(20563u16,13048u16),
(20565u16,7467u16),(20566u16,4761u16),(20567u16,13069u16),(20568u16,2744u16),
(20570u16,7462u16),(20571u16,13055u16),(20572u16,7458u16),(20573u16,13050u16),
(20574u16,13046u16),(20575u16,13060u16),(20576u16,13047u16),(20577u16,13045u16),
(20578u16,13057u16),(20579u16,13063u16),(20580u16,13064u16),(20581u16,7464u16),
(20582u16,4217u16),(20584u16,13686u16),(20585u16,13061u16),(20586u16,13044u16),
(20587u16,13062u16),(20588u16,2740u16),(20589u16,7474u16),(20590u16,13067u16),
(20591u16,7473u16),(20592u16,13043u16),(20594u16,13051u16),(20595u16,13068u16),
(20596u16,7469u16),(20597u16,7468u16),(20598u16,7465u16),(20599u16,7470u16),
(20602u16,7456u16),(20605u16,7457u16),(20608u16,7952u16),(20609u16,2741u16),
(20610u16,13689u16),(20611u16,13682u16),(20613u16,7949u16),(20615u16,13690u16),
(20616u16,1375u16),(20619u16,13680u16),(20620u16,13683u16),(20621u16,7948u16),
(20622u16,13684u16),(20624u16,19490u16),(20625u16,7951u16),(20626u16,13688u16),
(20628u16,13678u16),(20629u16,13677u16),(20630u16,7953u16),(20632u16,7954u16),
(20633u16,7950u16),(20634u16,7955u16),(20635u16,13676u16),(20636u16,13687u16),
(20637u16,13685u16),(20638u16,13679u16),(20642u16,7947u16),(20643u16,13681u16),
(20646u16,4780u16),(20652u16,8425u16),(20653u16,8419u16),(20654u16,14372u16),
(20655u16,8428u16),(20656u16,14378u16),(20657u16,14381u16),(20658u16,8421u16),
(20659u16,8422u16),(20660u16,14375u16),(20661u16,8420u16),(20662u16,14384u16),
(20663u16,8426u16),(20664u16,14385u16),(20666u16,14380u16),(20667u16,8427u16),
(20668u16,1776u16),(20669u16,14369u16),(20670u16,8424u16),(20671u16,14370u16),
(20673u16,14379u16),(20674u16,14377u16),(20676u16,14373u16),(20677u16,8423u16),
(20678u16,14371u16),(20679u16,8429u16),(20680u16,14376u16),(20681u16,14383u16),
(20682u16,14374u16),(20683u16,14382u16),(20685u16,2732u16),(20686u16,8876u16),
(20687u16,8873u16),(20688u16,2484u16),(20689u16,8874u16),(20691u16,15066u16),
(20692u16,15058u16),(20693u16,8872u16),(20694u16,8869u16),(20695u16,15059u16),
(20697u16,4935u16),(20698u16,8871u16),(20699u16,15062u16),(20701u16,15064u16),
(20703u16,3056u16),(20704u16,15071u16),(20705u16,19361u16),(20707u16,15070u16),
(20708u16,15065u16),(20709u16,8868u16),(20710u16,15057u16),(20711u16,8866u16),
(20712u16,15060u16),(20713u16,8877u16),(20714u16,15063u16),(20716u16,15067u16),
(20717u16,4815u16),(20718u16,8867u16),(20719u16,15069u16),(20720u16,15068u16),
(20721u16,8875u16),(20723u16,15061u16),(20724u16,3552u16),(20725u16,9256u16),
(20726u16,15681u16),(20728u16,15678u16),(20729u16,9257u16),(20731u16,9255u16),
(20732u16,2745u16),(20733u16,15685u16),(20734u16,15682u16),(20735u16,15675u16),
(20736u16,9254u16),(20737u16,19036u16),(20738u16,9258u16),(20739u16,15676u16),
(20740u16,9253u16),(20741u16,9261u16),(20742u16,15679u16),(20743u16,15680u16),
(20744u16,9259u16),(20745u16,9260u16),(20746u16,15686u16),(20747u16,15683u16),
(20748u16,15684u16),(20749u16,2733u16),(20750u16,19038u16),(20752u16,9649u16),
(20753u16,16321u16),(20754u16,9646u16),(20755u16,16318u16),(20756u16,9648u16),
(20757u16,9650u16),(20759u16,16319u16),(20760u16,9647u16),(20762u16,16320u16),
(20764u16,16317u16),(20767u16,9945u16),(20768u16,16890u16),(20769u16,9946u16),
(20770u16,16888u16),(20772u16,16889u16),(20773u16,16887u16),(20774u16,16886u16),
(20777u16,16891u16),(20778u16,9944u16),(20779u16,2709u16),(20781u16,17356u16),
(20782u16,17357u16),(20784u16,15677u16),(20785u16,17355u16),(20786u16,9947u16),
(20787u16,10393u16),(20788u16,17721u16),(20789u16,17722u16),(20791u16,10636u16),
(20792u16,10637u16),(20793u16,18307u16),(20794u16,18306u16),(20795u16,10720u16),
(20796u16,10719u16),(20797u16,18636u16),(20799u16,5504u16),(20800u16,5528u16),
(20801u16,5582u16),(20803u16,5581u16),(20804u16,5671u16),(20805u16,5670u16),
(20806u16,5806u16),(20807u16,5805u16),(20808u16,5807u16),(20809u16,5804u16),
(20811u16,5976u16),(20812u16,5975u16),(20813u16,5977u16),(20818u16,6249u16),
(20820u16,6248u16),(20821u16,6250u16),(20822u16,1273u16),(20823u16,6624u16),
(20825u16,2746u16),(20826u16,12527u16),(20827u16,2747u16),(20828u16,7475u16),
(20829u16,2748u16),(20830u16,2749u16),(20831u16,13691u16),(20832u16,19044u16),
(20833u16,5210u16),(20834u16,8878u16),(20835u16,5211u16),(20837u16,5505u16),
(20839u16,5583u16),(20840u16,5808u16),(20841u16,6251u16),(20842u16,19046u16),
(20843u16,5506u16),(20844u16,5586u16),(20845u16,5584u16),(20846u16,5585u16),
(20849u16,5809u16),(20852u16,1274u16),(20853u16,5978u16),(20854u16,6253u16),
(20855u16,6252u16),(20856u16,6254u16),(20857u16,3009u16),(20860u16,7031u16),
(20864u16,9651u16),(20866u16,10930u16),(20870u16,1379u16),(20871u16,11318u16),
(20872u16,11211u16),(20873u16,5672u16),(20874u16,5673u16),(20877u16,5810u16),
(20879u16,11503u16),(20881u16,6626u16),(20882u16,6625u16),(20883u16,12529u16),
(20884u16,12528u16),(20885u16,7476u16),(20886u16,10931u16),(20887u16,5587u16),
(20888u16,11325u16),(20890u16,4571u16),(20892u16,1275u16),(20894u16,11725u16),
(20896u16,6627u16),(20898u16,7034u16),(20900u16,7032u16),(20901u16,7033u16),
(20903u16,4574u16),(20904u16,2757u16),(20906u16,9652u16),(20907u16,10932u16),
(20908u16,5674u16),(20910u16,1754u16),(20912u16,5811u16),(20913u16,11394u16),
(20914u16,19058u16),(20915u16,19067u16),(20916u16,3965u16),(20917u16,19004u16),
(20918u16,5979u16),(20919u16,5980u16),(20920u16,19059u16),(20921u16,11504u16),
(20924u16,11726u16),(20925u16,6255u16),(20926u16,11727u16),(20931u16,2758u16),
(20932u16,12531u16),(20933u16,12532u16),(20934u16,7037u16),(20935u16,19552u16),
(20936u16,12533u16),(20937u16,19061u16),(20938u16,12530u16),(20939u16,7038u16),
(20940u16,7036u16),(20941u16,7035u16),(20942u16,12534u16),(20943u16,19062u16),
(20944u16,13071u16),(20945u16,19063u16),(20946u16,4164u16),(20947u16,19065u16),
(20948u16,13692u16),(20951u16,14386u16),(20952u16,15072u16),(20955u16,1381u16),
(20956u16,9262u16),(20957u16,9653u16),(20958u16,16322u16),(20959u16,19589u16),
(20960u16,5507u16),(20961u16,5521u16),(20962u16,19068u16),(20964u16,1276u16),
(20973u16,19070u16),(20976u16,7477u16),(20977u16,7957u16),(20979u16,8879u16),
(20980u16,19369u16),(20981u16,11306u16),(20982u16,5588u16),(20984u16,5677u16),
(20985u16,5675u16),(20986u16,5676u16),(20988u16,1382u16),(20989u16,6256u16),
(20990u16,4725u16),(20992u16,5508u16),(20993u16,5509u16),(20994u16,11208u16),
(20995u16,5529u16),(20997u16,1383u16),(20998u16,5589u16),(20999u16,5590u16),
(21000u16,5591u16),(21001u16,11396u16),(21002u16,5678u16),(21003u16,19075u16),
(21004u16,11347u16),(21006u16,5815u16),(21008u16,11397u16),(21009u16,5813u16),
(21010u16,5814u16),(21011u16,11395u16),(21014u16,5816u16),(21015u16,5812u16),
(21020u16,11505u16),(21021u16,6575u16),(21022u16,11506u16),(21023u16,4817u16),
(21024u16,5000u16),(21025u16,11507u16),(21028u16,5982u16),(21029u16,5981u16),
(21030u16,19076u16),(21031u16,1324u16),(21032u16,5985u16),(21033u16,5983u16),
(21034u16,5984u16),(21038u16,6262u16),(21040u16,6261u16),(21041u16,11732u16),
(21042u16,11729u16),(21043u16,11730u16),(21044u16,4705u16),(21045u16,11728u16),
(21046u16,6263u16),(21047u16,6259u16),(21048u16,6258u16),(21050u16,6260u16),
(21051u16,6257u16),(21052u16,19077u16),(21057u16,6264u16),(21059u16,6629u16),
(21060u16,12074u16),(21062u16,11731u16),(21063u16,6634u16),(21065u16,12075u16),
(21066u16,6630u16),(21067u16,6633u16),(21068u16,6632u16),(21069u16,6631u16),
(21070u16,6628u16),(21071u16,1032u16),(21074u16,12537u16),(21076u16,7041u16),
(21077u16,12540u16),(21078u16,7039u16),(21079u16,19079u16),(21081u16,2767u16),
(21082u16,12536u16),(21083u16,7042u16),(21084u16,7040u16),(21085u16,7043u16),
(21086u16,12538u16),(21087u16,12539u16),(21088u16,4757u16),(21089u16,12535u16),
(21090u16,12541u16),(21096u16,1648u16),(21097u16,7961u16),(21098u16,7478u16),
(21099u16,13072u16),(21100u16,13074u16),(21101u16,13073u16),(21102u16,13075u16),
(21103u16,7479u16),(21106u16,7958u16),(21107u16,4784u16),(21108u16,7959u16),
(21109u16,7960u16),(21111u16,8431u16),(21112u16,14388u16),(21113u16,1385u16),
(21114u16,14387u16),(21115u16,14389u16),(21116u16,14390u16),(21117u16,8432u16),
(21119u16,8430u16),(21120u16,15073u16),(21121u16,15074u16),(21122u16,8881u16),
(21123u16,8880u16),(21124u16,15412u16),(21127u16,9263u16),(21128u16,9264u16),
(21129u16,9265u16),(21130u16,9267u16),(21131u16,15687u16),(21132u16,15688u16),
(21133u16,9266u16),(21135u16,4195u16),(21136u16,1386u16),(21137u16,9654u16),
(21139u16,9655u16),(21140u16,19080u16),(21142u16,17723u16),(21143u16,18309u16),
(21144u16,18308u16),(21145u16,18637u16),(21146u16,4825u16),(21147u16,5510u16),
(21151u16,5680u16),(21152u16,5679u16),(21153u16,1277u16),(21155u16,5817u16),
(21156u16,2768u16),(21158u16,11398u16),(21160u16,1278u16),(21161u16,5987u16),
(21162u16,5988u16),(21163u16,5986u16),(21164u16,5989u16),(21165u16,11508u16),
(21166u16,11509u16),(21173u16,19078u16),(21177u16,19081u16),(21179u16,6266u16),
(21180u16,11733u16),(21182u16,6265u16),(21184u16,12076u16),(21185u16,6638u16),
(21186u16,12077u16),(21187u16,6637u16),(21189u16,19082u16),(21191u16,6635u16),
(21193u16,6636u16),(21196u16,4675u16),(21197u16,12542u16),(21200u16,19252u16),
(21201u16,4759u16),(21202u16,7480u16),(21203u16,13077u16),(21205u16,7483u16),
(21206u16,13076u16),(21207u16,7667u16),(21208u16,7482u16),(21209u16,7481u16),
(21211u16,7964u16),(21213u16,7963u16),(21214u16,7962u16),(21215u16,8433u16),
(21216u16,19085u16),(21217u16,2770u16),(21218u16,8436u16),(21219u16,8437u16),
(21220u16,8435u16),(21222u16,8434u16),(21225u16,15075u16),(21227u16,15076u16),
(21231u16,15690u16),(21232u16,9268u16),(21233u16,15689u16),(21235u16,9656u16),
(21236u16,16892u16),(21237u16,9948u16),(21239u16,17724u16),(21240u16,10540u16),
(21241u16,10933u16),(21242u16,5530u16),(21243u16,5592u16),(21244u16,11326u16),
(21246u16,5593u16),(21247u16,5594u16),(21249u16,3937u16),(21253u16,5681u16),
(21254u16,5682u16),(21256u16,5818u16),(21257u16,11510u16),(21258u16,11734u16),
(21259u16,11735u16),(21261u16,6639u16),(21262u16,12543u16),(21263u16,7485u16),
(21264u16,7484u16),(21265u16,13694u16),(21266u16,13693u16),(21269u16,5511u16),
(21270u16,5595u16),(21271u16,5683u16),(21273u16,7486u16),(21274u16,11307u16),
(21276u16,11348u16),(21277u16,5684u16),(21279u16,11400u16),(21280u16,5820u16),
(21281u16,5819u16),(21282u16,11399u16),(21283u16,5990u16),(21284u16,1767u16),
(21287u16,1387u16),(21290u16,7044u16),(21292u16,4771u16),(21293u16,13078u16),
(21295u16,8438u16),(21296u16,15077u16),(21297u16,8882u16),(21298u16,4938u16),
(21299u16,19095u16),(21300u16,16323u16),(21303u16,18053u16),(21304u16,10934u16),
(21305u16,5596u16),(21307u16,1279u16),(21308u16,11736u16),(21309u16,12078u16),
(21310u16,7489u16),(21311u16,7487u16),(21312u16,7488u16),(21313u16,5512u16),
(21314u16,19069u16),(21315u16,5531u16),(21316u16,5288u16),(21317u16,5599u16),
(21319u16,5598u16),(21320u16,5597u16),(21321u16,5687u16),(21322u16,5686u16),
(21324u16,11349u16),(21325u16,11401u16),(21326u16,1280u16),(21329u16,6270u16),
(21330u16,6267u16),(21331u16,6269u16),(21332u16,6268u16),(21335u16,6640u16),
(21338u16,7965u16),(21340u16,5513u16),(21341u16,1699u16),(21342u16,5600u16),
(21343u16,1603u16),(21344u16,5689u16),(21345u16,5688u16),(21347u16,11511u16),
(21348u16,4068u16),(21350u16,6271u16),(21351u16,4638u16),(21353u16,10935u16),
(21356u16,11327u16),(21357u16,19108u16),(21358u16,5691u16),(21359u16,5690u16),
(21360u16,5821u16),(21361u16,5822u16),(21362u16,11512u16),(21363u16,5991u16),
(21364u16,19109u16),(21365u16,5992u16),(21367u16,6272u16),(21368u16,6273u16),
(21369u16,6274u16),(21371u16,6641u16),(21372u16,12079u16),(21373u16,4641u16),
(21374u16,19111u16),(21375u16,7045u16),(21378u16,11308u16),(21380u16,5601u16),
(21386u16,11402u16),(21390u16,11513u16),(21391u16,11514u16),(21394u16,11737u16),
(21395u16,19116u16),(21396u16,11738u16),(21398u16,12081u16),(21399u16,12080u16),
(21400u16,12083u16),(21401u16,12082u16),(21402u16,6642u16),(21404u16,13079u16),
(21405u16,7047u16),(21406u16,12544u16),(21407u16,7046u16),(21408u16,19118u16),
(21410u16,4365u16),(21412u16,13695u16),(21413u16,7966u16),(21414u16,19303u16),
(21415u16,13696u16),(21416u16,19306u16),(21417u16,1389u16),(21418u16,4925u16),
(21419u16,19119u16),(21420u16,15078u16),(21421u16,8883u16),(21422u16,19120u16),
(21424u16,1391u16),(21426u16,9269u16),(21428u16,17725u16),(21430u16,10936u16),
(21433u16,11328u16),(21435u16,5692u16),(21441u16,19125u16),(21442u16,1393u16),
(21443u16,7490u16),(21445u16,19126u16),(21448u16,5514u16),(21449u16,5532u16),
(21450u16,5603u16),(21451u16,5602u16),(21452u16,2457u16),(21453u16,5604u16),
(21456u16,2789u16),(21457u16,1281u16),(21458u16,4386u16),(21460u16,6276u16),
(21462u16,6275u16),(21463u16,6277u16),(21464u16,1282u16),(21465u16,19130u16),
(21466u16,4774u16),(21467u16,6643u16),(21471u16,7048u16),(21472u16,19133u16),
(21473u16,16324u16),(21474u16,10220u16),(21475u16,5533u16),(21476u16,5694u16),
(21477u16,5709u16),(21478u16,5704u16),(21480u16,5699u16),(21481u16,5698u16),
(21482u16,5705u16),(21483u16,5703u16),(21484u16,5696u16),(21485u16,5710u16),
(21486u16,5697u16),(21487u16,5693u16),(21488u16,5708u16),(21489u16,5707u16),
(21490u16,5706u16),(21491u16,5695u16),(21493u16,5702u16),(21494u16,19136u16),
(21495u16,2273u16),(21496u16,5701u16),(21499u16,5711u16),(21500u16,5700u16),
(21502u16,19179u16),(21505u16,5828u16),(21507u16,5834u16),(21508u16,5830u16),
(21510u16,5836u16),(21511u16,11403u16),(21512u16,5833u16),(21513u16,5823u16),
(21514u16,5826u16),(21515u16,5829u16),(21516u16,5825u16),(21517u16,5832u16),
(21518u16,5835u16),(21519u16,5824u16),(21520u16,5827u16),(21521u16,5831u16),
(21522u16,5837u16),(21523u16,19138u16),(21524u16,3438u16),(21526u16,4534u16),
(21528u16,11523u16),(21529u16,11520u16),(21530u16,4500u16),(21531u16,6005u16),
(21532u16,11521u16),(21533u16,5993u16),(21534u16,5995u16),(21535u16,6019u16),
(21536u16,6014u16),(21537u16,19513u16),(21539u16,1394u16),(21540u16,11528u16),
(21541u16,11522u16),(21542u16,5997u16),(21543u16,5999u16),(21544u16,11527u16),
(21545u16,6006u16),(21546u16,11517u16),(21547u16,6018u16),(21548u16,6020u16),
(21549u16,5994u16),(21550u16,6011u16),(21551u16,19158u16),(21552u16,11515u16),
(21553u16,6017u16),(21554u16,4524u16),(21555u16,6002u16),(21556u16,1780u16),
(21557u16,6012u16),(21558u16,6013u16),(21559u16,11516u16),(21560u16,6010u16),
(21561u16,6008u16),(21563u16,6009u16),(21564u16,6015u16),(21565u16,11524u16),
(21566u16,5996u16),(21568u16,6016u16),(21569u16,11526u16),(21570u16,6004u16),
(21571u16,6001u16),(21573u16,11519u16),(21574u16,6000u16),(21575u16,11529u16),
(21576u16,6003u16),(21578u16,6007u16),(21579u16,4647u16),(21580u16,1041u16),
(21581u16,4575u16),(21582u16,5998u16),(21583u16,11525u16),(21588u16,11518u16),
(21600u16,11755u16),(21601u16,11754u16),(21602u16,6295u16),(21603u16,11757u16),
(21604u16,11759u16),(21605u16,11748u16),(21606u16,11751u16),(21607u16,11758u16),
(21608u16,6296u16),(21609u16,4767u16),(21610u16,4026u16),(21611u16,11745u16),
(21612u16,11749u16),(21613u16,19143u16),(21615u16,11753u16),(21616u16,12098u16),
(21617u16,6291u16),(21618u16,12102u16),(21619u16,6278u16),(21620u16,11750u16),
(21621u16,6279u16),(21622u16,6292u16),(21623u16,6285u16),(21624u16,6281u16),
(21626u16,11746u16),(21627u16,6284u16),(21628u16,6289u16),(21629u16,6298u16),
(21630u16,11747u16),(21631u16,11740u16),(21632u16,6283u16),(21633u16,11741u16),
(21634u16,11743u16),(21636u16,6286u16),(21637u16,3674u16),(21638u16,6288u16),
(21639u16,11739u16),(21640u16,11744u16),(21643u16,6297u16),(21644u16,6293u16),
(21645u16,11752u16),(21646u16,6299u16),(21647u16,19147u16),(21648u16,6290u16),
(21649u16,11742u16),(21650u16,6287u16),(21651u16,1398u16),(21652u16,4560u16),
(21653u16,6282u16),(21654u16,6280u16),(21655u16,4545u16),(21656u16,11756u16),
(21658u16,6294u16),(21660u16,4823u16),(21662u16,4029u16),(21664u16,12097u16),
(21665u16,12085u16),(21666u16,12100u16),(21667u16,1399u16),(21668u16,19148u16),
(21669u16,12087u16),(21670u16,6650u16),(21671u16,6664u16),(21672u16,6646u16),
(21673u16,6663u16),(21674u16,6655u16),(21675u16,6660u16),(21676u16,6644u16),
(21677u16,12086u16),(21678u16,12092u16),(21679u16,6659u16),(21680u16,12104u16),
(21681u16,6661u16),(21682u16,2067u16),(21683u16,6651u16),(21684u16,1400u16),
(21686u16,12094u16),(21687u16,12091u16),(21688u16,6649u16),(21689u16,1401u16),
(21690u16,12084u16),(21691u16,6662u16),(21692u16,12099u16),(21693u16,6654u16),
(21694u16,12101u16),(21695u16,6665u16),(21696u16,6645u16),(21697u16,6656u16),
(21698u16,6653u16),(21699u16,12089u16),(21700u16,6657u16),(21701u16,12095u16),
(21702u16,12096u16),(21703u16,6652u16),(21704u16,6658u16),(21705u16,6648u16),
(21707u16,2698u16),(21708u16,1587u16),(21709u16,2795u16),(21710u16,6647u16),
(21711u16,12088u16),(21712u16,1402u16),(21718u16,12093u16),(21722u16,4824u16),
(21726u16,12103u16),(21728u16,12564u16),(21729u16,7061u16),(21730u16,12546u16),
(21731u16,1470u16),(21732u16,12551u16),(21733u16,7054u16),(21734u16,7065u16),
(21735u16,12549u16),(21736u16,7049u16),(21737u16,7059u16),(21738u16,7064u16),
(21739u16,12556u16),(21741u16,7060u16),(21742u16,7063u16),(21743u16,1403u16),
(21745u16,12559u16),(21746u16,7055u16),(21747u16,12550u16),(21751u16,12562u16),
(21752u16,12563u16),(21754u16,7057u16),(21755u16,12561u16),(21756u16,7053u16),
(21757u16,7068u16),(21759u16,12553u16),(21761u16,7051u16),(21762u16,3523u16),
(21763u16,12566u16),(21764u16,12554u16),(21765u16,12558u16),(21766u16,7056u16),
(21767u16,7067u16),(21768u16,12555u16),(21769u16,7062u16),(21770u16,12560u16),
(21771u16,12567u16),(21772u16,13094u16),(21773u16,2914u16),(21774u16,12565u16),
(21775u16,7069u16),(21776u16,7050u16),(21777u16,12557u16),(21778u16,12548u16),
(21779u16,4577u16),(21780u16,7058u16),(21783u16,12547u16),(21784u16,1404u16),
(21786u16,12552u16),(21790u16,4576u16),(21795u16,1405u16),(21797u16,1414u16),
(21798u16,12545u16),(21799u16,7066u16),(21800u16,1406u16),(21802u16,13086u16),
(21803u16,19140u16),(21804u16,7509u16),(21805u16,13100u16),(21806u16,7507u16),
(21807u16,7504u16),(21808u16,13091u16),(21809u16,7500u16),(21810u16,13095u16),
(21811u16,7511u16),(21812u16,13085u16),(21813u16,13090u16),(21814u16,13089u16),
(21815u16,7052u16),(21816u16,7506u16),(21817u16,13098u16),(21819u16,13101u16),
(21820u16,13082u16),(21822u16,7984u16),(21823u16,1408u16),(21824u16,13102u16),
(21825u16,7512u16),(21827u16,7498u16),(21828u16,7495u16),(21829u16,13093u16),
(21830u16,7492u16),(21831u16,19156u16),(21832u16,13099u16),(21833u16,19090u16),
(21834u16,7499u16),(21835u16,13103u16),(21837u16,13083u16),(21838u16,13097u16),
(21839u16,7502u16),(21840u16,13084u16),(21841u16,13087u16),(21842u16,13092u16),
(21843u16,19219u16),(21845u16,7503u16),(21846u16,7501u16),(21847u16,7513u16),
(21852u16,7508u16),(21853u16,19146u16),(21854u16,7496u16),(21855u16,7648u16),
(21857u16,7497u16),(21858u16,13088u16),(21859u16,7510u16),(21860u16,7505u16),
(21861u16,13096u16),(21862u16,7494u16),(21865u16,4567u16),(21866u16,7493u16),
(21867u16,3105u16),(21873u16,3260u16),(21874u16,4546u16),(21875u16,4752u16),
(21877u16,13080u16),(21878u16,13081u16),(21879u16,13701u16),(21881u16,1498u16),
(21883u16,7967u16),(21884u16,7970u16),(21885u16,13712u16),(21886u16,7990u16),
(21887u16,13715u16),(21888u16,7968u16),(21889u16,13708u16),(21890u16,7974u16),
(21891u16,7980u16),(21892u16,8255u16),(21894u16,19160u16),(21895u16,7978u16),
(21896u16,13705u16),(21897u16,7991u16),(21898u16,7971u16),(21899u16,7979u16),
(21900u16,13713u16),(21901u16,14404u16),(21902u16,13718u16),(21903u16,13706u16),
(21904u16,1419u16),(21905u16,13697u16),(21906u16,13710u16),(21907u16,13704u16),
(21908u16,7977u16),(21909u16,13716u16),(21912u16,7973u16),(21913u16,7993u16),
(21914u16,7986u16),(21916u16,7975u16),(21917u16,7972u16),(21919u16,7983u16),
(21921u16,13717u16),(21922u16,13703u16),(21923u16,13709u16),(21924u16,13711u16),
(21925u16,13699u16),(21926u16,13714u16),(21927u16,7969u16),(21928u16,13698u16),
(21929u16,19161u16),(21930u16,7976u16),(21931u16,7992u16),(21932u16,7988u16),
(21933u16,13700u16),(21934u16,7982u16),(21936u16,2520u16),(21937u16,7989u16),
(21938u16,7985u16),(21939u16,7981u16),(21940u16,2793u16),(21941u16,13707u16),
(21945u16,1589u16),(21946u16,4544u16),(21947u16,7987u16),(21948u16,4202u16),
(21951u16,14402u16),(21952u16,14398u16),(21953u16,4458u16),(21954u16,14413u16),
(21955u16,14391u16),(21956u16,14400u16),(21957u16,8452u16),(21958u16,8453u16),
(21959u16,8445u16),(21960u16,14409u16),(21961u16,8455u16),(21962u16,14396u16),
(21963u16,14395u16),(21964u16,14393u16),(21965u16,14411u16),(21966u16,8443u16),
(21967u16,14405u16),(21968u16,14394u16),(21969u16,8446u16),(21970u16,14403u16),
(21971u16,8441u16),(21972u16,14399u16),(21973u16,14406u16),(21974u16,14408u16),
(21975u16,1411u16),(21976u16,3898u16),(21977u16,14412u16),(21978u16,8450u16),
(21979u16,14392u16),(21980u16,8444u16),(21981u16,14397u16),(21982u16,4556u16),
(21983u16,8439u16),(21985u16,8451u16),(21986u16,14407u16),(21987u16,8447u16),
(21988u16,8448u16),(21989u16,8454u16),(21990u16,8442u16),(21991u16,5212u16),
(21992u16,8440u16),(21993u16,14401u16),(21994u16,4531u16),(21996u16,2216u16),
(21999u16,8449u16),(22000u16,4543u16),(22001u16,4538u16),(22002u16,14410u16),
(22005u16,3901u16),(22006u16,8899u16),(22007u16,8894u16),(22009u16,15093u16),
(22010u16,15089u16),(22011u16,1661u16),(22012u16,15083u16),(22013u16,8888u16),
(22014u16,8884u16),(22015u16,15092u16),(22016u16,8885u16),(22017u16,15086u16),
(22018u16,15088u16),(22020u16,15091u16),(22021u16,4537u16),(22022u16,8890u16),
(22024u16,8897u16),(22025u16,8891u16),(22028u16,15081u16),(22029u16,8892u16),
(22030u16,8893u16),(22031u16,15084u16),(22032u16,8898u16),(22033u16,4795u16),
(22034u16,15082u16),(22035u16,15087u16),(22036u16,8889u16),(22037u16,15080u16),
(22038u16,8895u16),(22039u16,8887u16),(22043u16,8886u16),(22044u16,15085u16),
(22045u16,15090u16),(22046u16,4506u16),(22047u16,8896u16),(22048u16,4847u16),
(22049u16,1955u16),(22050u16,4505u16),(22051u16,3738u16),(22053u16,4527u16),
(22055u16,15079u16),(22057u16,9276u16),(22058u16,15707u16),(22060u16,15704u16),
(22061u16,4498u16),(22062u16,9270u16),(22063u16,9282u16),(22064u16,9283u16),
(22066u16,9273u16),(22067u16,15702u16),(22068u16,9275u16),(22069u16,15694u16),
(22070u16,9281u16),(22071u16,19169u16),(22072u16,15706u16),(22073u16,9272u16),
(22074u16,15708u16),(22075u16,9271u16),(22077u16,15703u16),(22078u16,15705u16),
(22079u16,9274u16),(22080u16,15701u16),(22081u16,15695u16),(22082u16,15692u16),
(22083u16,4533u16),(22085u16,13702u16),(22086u16,15698u16),(22088u16,15691u16),
(22089u16,15697u16),(22090u16,15696u16),(22092u16,15693u16),(22093u16,19174u16),
(22094u16,9278u16),(22095u16,19175u16),(22096u16,3989u16),(22098u16,1529u16),
(22099u16,9277u16),(22100u16,3956u16),(22103u16,9279u16),(22104u16,15699u16),
(22105u16,9657u16),(22106u16,15700u16),(22109u16,4700u16),(22110u16,16333u16),
(22112u16,16326u16),(22113u16,2283u16),(22114u16,9669u16),(22115u16,16330u16),
(22116u16,9661u16),(22117u16,9665u16),(22118u16,16329u16),(22120u16,9664u16),
(22121u16,9660u16),(22122u16,9663u16),(22123u16,9658u16),(22124u16,9668u16),
(22125u16,16331u16),(22126u16,16327u16),(22127u16,9667u16),(22128u16,16325u16),
(22129u16,9666u16),(22130u16,16332u16),(22131u16,16328u16),(22132u16,9280u16),
(22134u16,9670u16),(22135u16,16334u16),(22136u16,9662u16),(22137u16,9659u16),
(22138u16,4037u16),(22139u16,4595u16),(22140u16,4687u16),(22142u16,16899u16),
(22143u16,16901u16),(22144u16,9950u16),(22145u16,16902u16),(22146u16,16900u16),
(22147u16,16898u16),(22148u16,16897u16),(22149u16,9952u16),(22150u16,16896u16),
(22151u16,9953u16),(22153u16,1663u16),(22154u16,2608u16),(22155u16,4430u16),
(22156u16,16894u16),(22157u16,16895u16),(22158u16,9949u16),(22159u16,9954u16),
(22160u16,9951u16),(22162u16,2701u16),(22163u16,16893u16),(22165u16,10221u16),
(22167u16,17360u16),(22168u16,17358u16),(22169u16,17363u16),(22170u16,17361u16),
(22172u16,17359u16),(22173u16,17362u16),(22174u16,2699u16),(22175u16,2607u16),
(22177u16,1512u16),(22180u16,3519u16),(22181u16,10394u16),(22182u16,17728u16),
(22183u16,17729u16),(22184u16,10541u16),(22186u16,17730u16),(22187u16,17726u16),
(22188u16,17731u16),(22189u16,17727u16),(22190u16,10222u16),(22191u16,1614u16),
(22193u16,1946u16),(22194u16,18054u16),(22195u16,18056u16),(22196u16,10544u16),
(22197u16,18055u16),(22198u16,10543u16),(22199u16,10542u16),(22201u16,4259u16),
(22204u16,10545u16),(22205u16,18311u16),(22206u16,18312u16),(22207u16,4487u16),
(22208u16,10639u16),(22209u16,10638u16),(22210u16,10640u16),(22211u16,18310u16),
(22213u16,18487u16),(22214u16,18486u16),(22216u16,10721u16),(22217u16,10723u16),
(22218u16,10722u16),(22219u16,18488u16),(22220u16,10778u16),(22221u16,18751u16),
(22225u16,10819u16),(22227u16,18750u16),(22228u16,18823u16),(22230u16,4338u16),
(22231u16,11313u16),(22234u16,5713u16),(22235u16,5712u16),(22237u16,5840u16),
(22238u16,5839u16),(22239u16,11405u16),(22240u16,5838u16),(22241u16,11404u16),
(22242u16,1283u16),(22244u16,6023u16),(22245u16,11532u16),(22247u16,11531u16),
(22250u16,6021u16),(22251u16,6024u16),(22253u16,19182u16),(22254u16,11530u16),
(22255u16,19181u16),(22256u16,6022u16),(22257u16,19177u16),(22263u16,11760u16),
(22265u16,11761u16),(22266u16,6300u16),(22267u16,979u16),(22269u16,3712u16),
(22271u16,6666u16),(22272u16,19180u16),(22273u16,12568u16),(22274u16,12569u16),
(22275u16,7070u16),(22276u16,7071u16),(22279u16,13105u16),(22280u16,7514u16),
(22281u16,7516u16),(22282u16,13104u16),(22283u16,7515u16),(22284u16,13719u16),
(22285u16,7994u16),(22290u16,8456u16),(22291u16,8457u16),(22292u16,14414u16),
(22293u16,4379u16),(22294u16,8901u16),(22296u16,8900u16),(22298u16,15709u16),
(22299u16,16336u16),(22300u16,16335u16),(22301u16,2797u16),(22302u16,18883u16),
(22303u16,5534u16),(22304u16,11329u16),(22306u16,11350u16),(22307u16,11351u16),
(22312u16,5843u16),(22313u16,5847u16),(22314u16,11407u16),(22316u16,5845u16),
(22317u16,5844u16),(22318u16,11406u16),(22319u16,5846u16),(22320u16,5842u16),
(22322u16,3052u16),(22323u16,5841u16),(22324u16,11408u16),(22331u16,6034u16),
(22333u16,1833u16),(22334u16,6031u16),(22335u16,4196u16),(22336u16,6027u16),
(22337u16,11533u16),(22338u16,19190u16),(22339u16,19208u16),(22341u16,11534u16),
(22342u16,19186u16),(22343u16,6029u16),(22345u16,11536u16),(22346u16,6025u16),
(22347u16,11537u16),(22348u16,11535u16),(22349u16,6028u16),(22350u16,6030u16),
(22351u16,6033u16),(22352u16,6032u16),(22353u16,6026u16),(22354u16,11538u16),
(22356u16,3899u16),(22359u16,4021u16),(22363u16,2665u16),(22367u16,4918u16),
(22369u16,6305u16),(22370u16,11774u16),(22372u16,6307u16),(22374u16,6306u16),
(22375u16,4760u16),(22376u16,11775u16),(22377u16,6304u16),(22378u16,6303u16),
(22379u16,11765u16),(22381u16,11764u16),(22383u16,11762u16),(22384u16,11767u16),
(22385u16,11766u16),(22386u16,11763u16),(22387u16,11772u16),(22388u16,11773u16),
(22389u16,11770u16),(22390u16,11768u16),(22391u16,6302u16),(22394u16,4816u16),
(22395u16,11771u16),(22396u16,6308u16),(22397u16,11776u16),(22398u16,3678u16),
(22399u16,2803u16),(22400u16,11769u16),(22402u16,6667u16),(22403u16,6301u16),
(22408u16,4172u16),(22410u16,3442u16),(22411u16,6668u16),(22412u16,12109u16),
(22413u16,2802u16),(22415u16,12115u16),(22416u16,19350u16),(22419u16,6674u16),
(22420u16,12113u16),(22421u16,12119u16),(22423u16,12110u16),(22424u16,12114u16),
(22425u16,12116u16),(22426u16,12118u16),(22427u16,12112u16),(22428u16,1631u16),
(22429u16,12111u16),(22430u16,12106u16),(22431u16,12107u16),(22432u16,6669u16),
(22433u16,4228u16),(22434u16,6671u16),(22435u16,6670u16),(22436u16,12108u16),
(22437u16,12117u16),(22439u16,4702u16),(22442u16,4648u16),(22446u16,6673u16),
(22451u16,1039u16),(22452u16,3815u16),(22453u16,12105u16),(22454u16,12579u16),
(22456u16,12578u16),(22457u16,12583u16),(22458u16,12574u16),(22459u16,3440u16),
(22460u16,12577u16),(22461u16,12576u16),(22462u16,2042u16),(22463u16,12580u16),
(22465u16,12584u16),(22466u16,7072u16),(22467u16,7075u16),(22468u16,3150u16),
(22470u16,12575u16),(22471u16,12581u16),(22472u16,3586u16),(22475u16,7074u16),
(22476u16,12570u16),(22478u16,6672u16),(22479u16,13119u16),(22480u16,12582u16),
(22482u16,12573u16),(22484u16,7073u16),(22485u16,12572u16),(22487u16,3444u16),
(22492u16,13110u16),(22493u16,2801u16),(22494u16,4712u16),(22495u16,7517u16),
(22496u16,7521u16),(22497u16,13126u16),(224