type
  TagType* = enum
    TAG_UNKNOWN = ""
    TAG_APPLET = "applet"
    TAG_BIG = "big"
    TAG_HTML = "html"
    TAG_BASE = "base"
    TAG_BASEFONT = "basefont"
    TAG_BGSOUND = "bgsound"
    TAG_HEAD = "head"
    TAG_LINK = "link"
    TAG_LISTING = "listing"
    TAG_META = "meta"
    TAG_STYLE = "style"
    TAG_TITLE = "title"
    TAG_BODY = "body"
    TAG_ADDRESS = "address"
    TAG_ARTICLE = "article"
    TAG_ASIDE = "aside"
    TAG_FOOTER = "footer"
    TAG_HEADER = "header"
    TAG_H1 = "h1"
    TAG_H2 = "h2"
    TAG_H3 = "h3"
    TAG_H4 = "h4"
    TAG_H5 = "h5"
    TAG_H6 = "h6"
    TAG_HGROUP = "hgroup"
    TAG_MAIN = "main"
    TAG_NAV = "nav"
    TAG_SEARCH = "search"
    TAG_SECTION = "section"
    TAG_BLOCKQUOTE = "blockquote"
    TAG_DD = "dd"
    TAG_DIV = "div"
    TAG_DL = "dl"
    TAG_DT = "dt"
    TAG_FIGCAPTION = "figcaption"
    TAG_FIGURE = "figure"
    TAG_HR = "hr"
    TAG_LI = "li"
    TAG_OL = "ol"
    TAG_P = "p"
    TAG_PRE = "pre"
    TAG_UL = "ul"
    TAG_A = "a"
    TAG_ABBR = "abbr"
    TAG_B = "b"
    TAG_BDI = "bdi"
    TAG_BDO = "bdo"
    TAG_BR = "br"
    TAG_NOBR = "nobr"
    TAG_CITE = "cite"
    TAG_CODE = "code"
    TAG_DATA = "data"
    TAG_DFN = "dfn"
    TAG_EM = "em"
    TAG_EMBED = "embed"
    TAG_I = "i"
    TAG_KBD = "kbd"
    TAG_MARK = "mark"
    TAG_MARQUEE = "marquee"
    TAG_Q = "q"
    TAG_RB = "rb"
    TAG_RP = "rp"
    TAG_RT = "rt"
    TAG_RTC = "rtc"
    TAG_RUBY = "ruby"
    TAG_S = "s"
    TAG_SAMP = "samp"
    TAG_SMALL = "small"
    TAG_SPAN = "span"
    TAG_STRONG = "strong"
    TAG_SUB = "sub"
    TAG_SUP = "sup"
    TAG_TIME = "time"
    TAG_U = "u"
    TAG_VAR = "var"
    TAG_WBR = "wbr"
    TAG_AREA = "area"
    TAG_AUDIO = "audio"
    TAG_IMG = "img"
    TAG_IMAGE = "image"
    TAG_MAP = "map"
    TAG_TRACK = "track"
    TAG_VIDEO = "video"
    TAG_IFRAME = "iframe"
    TAG_OBJECT = "object"
    TAG_PARAM = "param"
    TAG_PICTURE = "picture"
    TAG_PORTAL = "portal"
    TAG_SOURCE = "source"
    TAG_CANVAS = "canvas"
    TAG_NOSCRIPT = "noscript"
    TAG_NOEMBED = "noembed"
    TAG_PLAINTEXT = "plaintext"
    TAG_XMP = "xmp"
    TAG_SCRIPT = "script"
    TAG_DEL = "del"
    TAG_INS = "ins"
    TAG_CAPTION = "caption"
    TAG_COL = "col"
    TAG_COLGROUP = "colgroup"
    TAG_TABLE = "table"
    TAG_TBODY = "tbody"
    TAG_TD = "td"
    TAG_TFOOT = "tfoot"
    TAG_TH = "th"
    TAG_THEAD = "thead"
    TAG_TR = "tr"
    TAG_BUTTON = "button"
    TAG_DATALIST = "datalist"
    TAG_FIELDSET = "fieldset"
    TAG_FORM = "form"
    TAG_INPUT = "input"
    TAG_KEYGEN = "keygen"
    TAG_LABEL = "label"
    TAG_LEGEND = "legend"
    TAG_METER = "meter"
    TAG_OPTGROUP = "optgroup"
    TAG_OPTION = "option"
    TAG_OUTPUT = "output"
    TAG_PROGRESS = "progress"
    TAG_SELECT = "select"
    TAG_TEXTAREA = "textarea"
    TAG_DETAILS = "details"
    TAG_DIALOG = "dialog"
    TAG_MENU = "menu"
    TAG_SUMMARY = "summary"
    TAG_BLINK = "blink"
    TAG_CENTER = "center"
    TAG_CONTENT = "content"
    TAG_DIR = "dir"
    TAG_FONT = "font"
    TAG_FRAME = "frame"
    TAG_NOFRAMES = "noframes"
    TAG_FRAMESET = "frameset"
    TAG_STRIKE = "strike"
    TAG_TT = "tt"
    TAG_TEMPLATE = "template"
    TAG_SARCASM = "sarcasm"
    TAG_MATH = "math"
    TAG_SVG = "svg"
    TAG_CHARSET = "charset"
    TAG_HTTP_EQUIV = "http-equiv"
    TAG_TYP = "type"
    TAG_DEFINITION_URL = "definitionurl"
    TAG_ANNOTATION_XML = "annotation-xml"
    TAG_FOREIGN_OBJECT = "foreignObject"
    TAG_DESC = "desc"
    TAG_ENCODING = "encoding"
    TAG_MI = "mi"
    TAG_MO = "mo"
    TAG_MN = "mn"
    TAG_MS = "ms"
    TAG_MTEXT = "mtext"
    TAG_MGLYPH = "mglyph"
    TAG_MALIGNMARK = "malignmark"
    TAG_COLOR = "color"
    TAG_FACE = "face"
    TAG_SIZE = "size"

  QuirksMode* = enum
    NO_QUIRKS, QUIRKS, LIMITED_QUIRKS

  Namespace* = enum
    NO_NAMESPACE = "",
    HTML = "http://www.w3.org/1999/xhtml",
    MATHML = "http://www.w3.org/1998/Math/MathML",
    SVG = "http://www.w3.org/2000/svg",
    XLINK = "http://www.w3.org/1999/xlink",
    XML = "http://www.w3.org/XML/1998/namespace",
    XMLNS = "http://www.w3.org/2000/xmlns/"
    NAMESPACE_UNKNOWN = ""

  NamespacePrefix* = enum
    NO_PREFIX = ""
    PREFIX_XLINK = "xlink"
    PREFIX_XML = "xml"
    PREFIX_XMLNS = "xmlns"
    PREFIX_UNKNOWN = ""

const AllTagTypes* = {TagType.low..TagType.high}

const HTagTypes* = {
  TAG_H1, TAG_H2, TAG_H3, TAG_H4, TAG_H5, TAG_H6
}

# 4.10.2 Categories
const FormAssociatedElements* = {
  TAG_BUTTON, TAG_FIELDSET, TAG_INPUT, TAG_OBJECT, TAG_OUTPUT, TAG_SELECT,
  TAG_TEXTAREA, TAG_IMG
}

const ListedElements* = {
  TAG_FIELDSET, TAG_INPUT, TAG_OBJECT, TAG_OUTPUT, TAG_SELECT, TAG_TEXTAREA
}
