
// Regels die eindigen op //m zijn niet-geverifieerde machinale vertalingen

Ls.nld = {
	"tt": "Nederlands",

	"cols": {
		"c": "Action knoppen",
		"dur": "Duratie",
		"q": "Kwaliteit / bitrate",
		"Ac": "Audio codec",
		"Vc": "Video codec",
		"Fmt": "Formaat / container",
		"Ahash": "Audio checksum",
		"Vhash": "Video checksum",
		"Res": "Resolution",
		"T": "Bestandstype",
		"aq": "Audio kwaliteit / bitrate",
		"vq": "Video kwaliteit / bitrate",
		"pixfmt": "Subsampling / pixel structure",
		"resw": "Horizontale resolutie",
		"resh": "Verticale resolutie",
		"chs": "Audiokanalen",
		"hz": "Samplefrequentie",
	},

	"hks": [
		[
			"diversen",
			["ESC", "Sluit verschillende dingen"],

			"bestand beheer",
			["G", "Verwissel tussen list / grid weergave"],
			["T", "Verwissel tussen miniaturen / iconen"],
			["⇧ A/D", "Thumbnail formaat"],
			["ctrl-K", "Verwijder geselecteerde"],
			["ctrl-X", "Knip selectie naar klembord"],
			["ctrl-C", "Kopieer selectie naar klembord"],
			["ctrl-V", "Hier plakken (verplaatsen/kopieëren)"],
			["Y", "Download geselecteerde"],
			["F2", "Hernoem geselecteerde"],

			"bestand-lijst-selectie",
			["space", "wissel bestand selectie"],
			["↑/↓", "verplaats selectie cursor"],
			["ctrl ↑/↓", "verplaats cursor en scherm"],
			["⇧ ↑/↓", "select vorige/volgende bestand"],
			["ctrl-A", "selecteer alle bestanden / mappen"],
		], [
			"navigatie",
			["B", "verwissel breadcrumbs / navpane"],
			["I/K", "Vorige/volgende map"],
			["M", "Bovenliggende map (of huidige uitvouwen)"],
			["V", "Berwissel map / tekstbestand in navpane"],
			["A/D", "Navpane formaat"],
		], [
			"muziek-speler",
			["J/L", "Vorige/volgende song"],
			["U/O", "Skip 10sec terug/vooruit"],
			["0..9", "Spring naar 0%..90%"],
			["P", "Speel/pauzeer (start ook)"],
			["S", "Selecteer afspelende song"],
			["Y", "Download song"],
		], [
			"afbeelding viewer",
			["J/L, ←/→", "Vorige/volgende afbeelding"],
			["Home/End", "Eerste/laatste afbeelding"],
			["F", "Volledig scherm"],
			["R", "Draai rechtsom"],
			["⇧ R", "Draai linksom"],
			["S", "Selecteer afbeelding"],
			["Y", "Download afbeelding"],
		], [
			"video-speler",
			["U/O", "Skip 10sec terug/vooruit"],
			["P/K/Space", "Speel/pauze"],
			["C", "Verder met volgende"],
			["V", "herhaal"],
			["M", "stil"],
			["[ and ]", "zet herhaal interval"],
		], [
			"tekstbestand-viewer",
			["I/K", "vorige/volgende bestand"],
			["M", "sluit tekst bestand"],
			["E", "bewerk tekst bestand"],
			["S", "selecteer bestand (voor knip/kopie/hernoem)"],
			["Y", "tekst bestand downloaden"], //m
			["⇧ J", "json verfraaien"], //m
		]
	],

	"m_ok": "OK",
	"m_ng": "Annuleren",

	"enable": "Inschakelen",
	"danger": "GEVAARLIJK",
	"clipped": "Gekopieërd naar klembord",

	"ht_s1": "seconde",
	"ht_s2": "secondes",
	"ht_m1": "minuut",
	"ht_m2": "minuten",
	"ht_h1": "uur",
	"ht_h2": "uur",
	"ht_d1": "dag",
	"ht_d2": "dagen",
	"ht_and": " en ",

	"goh": "Beheer-paneel",
	"gop": 'Vorige map">Vorige',
	"gou": 'Bovenligende map">Omhoog',
	"gon": 'Volgende map">Volgende',
	"logout": "Uitloggen ",
	"login": "Inloggen", //m
	"access": " Toegang",
	"ot_close": "Sluit onder-menu",
	"ot_search": "Zoek voor bestanden bij attributes, pad / naam, muziek tags, of elk andere combinatie tussen$N$N&lt;code&gt;foo bar&lt;/code&gt; = moet beide «foo» en «bar» bevatten,$N&lt;code&gt;foo -bar&lt;/code&gt; = moet «foo» bevatten maar geen «bar»,$N&lt;code&gt;^yana .opus$&lt;/code&gt; = start met «yana» en moet een «opus» bestand zijn$N&lt;code&gt;&quot;try unite&quot;&lt;/code&gt; = moet precies «try unite» bevatten$N$Nde datum formaat is iso-8601, zoals$N&lt;code&gt;2009-12-31&lt;/code&gt; of &lt;code&gt;2020-09-12 23:30:00&lt;/code&gt;",
	"ot_unpost": "unpost: verwijder je recente uploads, of onvoltooide uploads afbreken",
	"ot_bup": "bup: Basisuploader, supports zelfs netscape 4.0",
	"ot_mkdir": "mkdir: Maak een nieuwe map",
	"ot_md": "new-file: Maak een nieuw tekstbestand", //m
	"ot_msg": "msg: Verstuur een bericht naar de server logs",
	"ot_mp": "Media speler opties",
	"ot_cfg": "Configuratie opties",
	"ot_u2i": 'up2k: upload bestanden (als je schrijf toegang hebt) of verwissel naar zoek-mode om te zien of ze ergens bestaan op de server$N$Nuploads zijn hervatbaar, multithreaded, en bestandstijdstempels blijven behouden, maar het gebruikt meer CPU dan [🎈]&nbsp; (de basic uploader)<br /><br />tijdens het uploaden, dit icoon word dan een progress indicatie!',
	"ot_u2w": 'up2k: upload bestanden met hervattings ondersteuning (sluit je webbrowser en selecteer dezelfde bestand later opnieuw)$N$Nmultithreaded, en bestandstijdstempels blijven behouden, maar het gebruikt meer CPU dan [🎈]&nbsp; (de basic uploader)<br /><br />tijdens het uploaden, dit icoon word dan een progress indicatie!',
	"ot_noie": 'Gebruik alstublieft Chrome / Firefox / Edge',

	"ab_mkdir": "maak map",
	"ab_mkdoc": "nieuw tekstbestand", //m
	"ab_msg": "verstuur msg naar srv log",

	"ay_path": "skip naar mappen",
	"ay_files": "skip naar bestanden",

	"wt_ren": "Hernoem geselecteerde items$NHotkey: F2",
	"wt_del": "Berwijder geselecteerde items$NHotkey: ctrl-K",
	"wt_cut": "Knip geselecteerde items &lt;small&gt;(en plak het ergens anders)&lt;/small&gt;$NHotkey: ctrl-X",
	"wt_cpy": "Kopieer geselecteerde items naar klembord$N(om te plakken ergens anders)$NHotkey: ctrl-C",
	"wt_pst": "Plak eeen laatst geknipte / gekopieërde selectie$NHotkey: ctrl-V",
	"wt_selall": "Selecteer alle bestanden$NHotkey: ctrl-A (wanneer bestand gefocused is)",
	"wt_selinv": "Selectie omkeren",
	"wt_zip1": "Download deze map als archief",
	"wt_selzip": "Download selectie als archief",
	"wt_seldl": "Download selectie als losse bestanden$NHotkey: Y",
	"wt_npirc": "Kopieer irc-geformarteerde track info",
	"wt_nptxt": "Kopieer platte tekst track info",
	"wt_m3ua": "Aan m3u afspeellijst toevoegen (klik <code>📻kopieer</code> later)",
	"wt_m3uc": "Kopieer m3u playlist naar klembord",
	"wt_grid": "Verwissel grid / lijst weergave$NHotkey: G",
	"wt_prev": "Vorig nummer$NHotkey: J",
	"wt_play": "Afspelen / pauzeer$NHotkey: P",
	"wt_next": "Volgend nummer$NHotkey: L",

	"ul_par": "Parallel uploads:",
	"ut_rand": "Willekeurige bestandsnaam",
	"ut_u2ts": "Kopieer de laatste-gewijzigde tijdstamp$Nvan je bestandsysteem naar de server\">📅",
	"ut_ow": "Overschrijf bestaande bestanden op de server?$N🛡️: nooit (zal in plaats daarvan een nieuwe bestandsnaam genereren)$N🕒: overschrijven als de server-bestand ouder is dan het geüploade bestand$N♻️: altijd overschrijven als de bestanden verschillend zijn",
	"ut_mt": "Ga door met hashen van andere bestanden tijdens het uploaden$N$Moet je misschien uitschakelen als je CPU of HDD het niet aan kan",
	"ut_ask": 'Vraag voor bevestiging voordat het uploaden start">💭',
	"ut_pot": "Verbeter de uploadsnelheid voor langzame apparaten$Ndoor de interface minder complex te maken",
	"ut_srch": "Niet uploaden, maar check of de bestanden als op de server bestaan$N (checkt alle mappen die waar jij toegang op hebt)",
	"ut_par": "Pauzeer bij zetten het op 0$N$Nverhoog als je verbinding traag is$N$Nhou het op 1 als je netwerk of server HDD het niet aankan",
	"ul_btn": "Drop bestanden / mappen<br>hier (of klik mij)",
	"ul_btnu": "U P L O A D",
	"ul_btns": "Z O E K E N",

	"ul_hash": "Hashing",
	"ul_send": "Versturen",
	"ul_done": "Klaar",
	"ul_idle1": "Geen uploads in wachtrij",
	"ut_etah": "Gemiddelde &lt;em&gt;hashing&lt;/em&gt; snelheid en geschatte tijd tot de voltooiing",
	"ut_etau": "Gemiddelde &lt;em&gt;verzend&lt;/em&gt; snelheid en geschatte tijd tot voltooiing",
	"ut_etat": "Gemiddelde &lt;em&gt;totale&lt;/em&gt; snelheid en geschatte tijd tot voltooiing",

	"uct_ok": "Succesvol afgerond",
	"uct_ng": "Niet goed: gefaald / geweigerd / niet gevonden",
	"uct_done": "ok en ng gecombineerd",
	"uct_bz": "Hashing van uploads",
	"uct_q": "Inactief, in afwachting",

	"utl_name": "Bestandsnaam",
	"utl_ulist": "Lijst",
	"utl_ucopy": "Kopieer",
	"utl_links": "Links",
	"utl_stat": "Status",
	"utl_prog": "Vooruitgang",

	// keep short:
	"utl_404": "404",
	"utl_err": "FOUT",
	"utl_oserr": "OS-FOUT",
	"utl_found": "gevonden",
	"utl_defer": "Uitgesteld",
	"utl_yolo": "YOLO",
	"utl_done": "klaar",

	"ul_flagblk": "De bestanden zijn toegevoegd aan de wachtrij</b><br>maar er is een drukke up2k bezig in een andere tabblad,<br>wachten totdat die eerst klaar is",
	"ul_btnlk": "De server configuratie heeft deze schakelaar versleuteld in deze staat",

	"udt_up": "Upload",
	"udt_srch": "Zoeken",
	"udt_drop": "Laat hier los",

	"u_nav_m": '<h6>Hey, wat heb jij daar?</h6><code>Enter</code> = Bestanden (een of meer)\n<code>ESC</code> = Een map (inclusief submappen)',
	"u_nav_b": '<a href="#" id="modal-ok">Bestanden</a><a href="#" id="modal-ng">Een map</a>',

	"cl_opts": "Switches",
	"cl_hfsz": "Bestandsgrootte", //m
	"cl_themes": "Thema",
	"cl_langs": "Taal",
	"cl_ziptype": "Download map als",
	"cl_uopts": "up2k switches",
	"cl_favico": "Favicon",
	"cl_bigdir": "Item limiet in map",
	"cl_hsort": "#sorteer",
	"cl_keytype": "Key notaties",
	"cl_hiddenc": "Verborgen kolomen",
	"cl_hidec": "Verborgen",
	"cl_reset": "Reset",
	"cl_hpick": "Tik op de kolomkoppen om ze in de onderstaande tabel te verbergen",
	"cl_hcancel": "Kolumn verbergen geannuleerd",

	"ct_grid": '田 grid',
	"ct_ttips": '◔ ◡ ◔">ℹ️ tooltips',
	"ct_thumb": 'In grid-overzicht, wissel tussen iconen of thumbnails$NHotkey: T">🖼️ thumbs',
	"ct_csel": 'Gebruik CTRL en SHIFT voor de bestand selectie in grid-overzicht>sel',
	"ct_dl": 'download afdwingen (niet inline weergeven) wanneer op een bestand wordt geklikt">dl', //m
	"ct_ihop": 'Als je afbeeldingviewer afsluit, scroll omlaag naar de laatst bekeken bestand">g⮯',
	"ct_dots": 'Laat verborgen bestanden zien (als de server dat toestaat)">dotfiles',
	"ct_qdel": 'Waneeer je een bestand verwijderd, vraag eenmalig om bevestiging">qdel',
	"ct_dir1st": 'Sorteer mappen eerst en dan de bestanden">📁 first',
	"ct_nsort": 'Natural sort (voor bestandsnamen dat beginnen met getallen)">nsort',
	"ct_readme": 'Laat README.md in mappen lijst zien">📜 readme',
	"ct_utc": 'Toon alle datums en tijden in UTC">UTC',
	"ct_idxh": 'Laat index.html zien in plaats van de map overzicht">htm',
	"ct_sbars": 'Laat scrollbars zien">⟊',

	"cut_umod": "Als een bestand al bestaat op de server, update de 'gewijzigd' waarde op het bestand wat op de server staat met het bestand wat je geupload hebt (vereist schrijf+verwijder rechten)\">re📅",

	"cut_turbo": "De yolo knop, die wil jij waarschijnlijk NIET actief wilt hebben:$N$Ngebruik dit als je heel veel bestanden gaat uploaden EN je moest het herstarten voor een reden en je wilt doorgaan met uploaden ASAP$N$Ndit vervangt de hash-check met een simpele <em>&quot;heeft dit dezelfde bestands groote op de server?&quot;</em>, zo als de bestands inhoud verschillend is, dan worden ze NIET geupload$N$NJe zou deze optie weer uit moeten zetten als de upload klaar is en dan &quot;upload&quot; de zelfde bestanden opnieuw uploaden zo de client het kan verifieren\">turbo",

	"cut_datechk": "Heeft geen effect tenzij de turbo knop actief is$N$Nverminder de yolo factor (een klein beetje); controlleert of de bestand tijdstamp op de server hetzelfde is met het geuploade bestand$N$Ndit zou <em>in theorie</em> de meest onvoltooide/onvoledige uploads, maar dit is geen vervaning voor de verificatie-check met de turbo knop uitgeschakeld daarna\">date-chk",

	"cut_u2sz": "Grote (in MiB) voor elk geuploade stuk; grote waardes vliegen beter over de Atlantische Oceaan. Probeer lage waardes op zeer onstabiele verbindingen",

	"cut_flag": "Alleen een tabblad kan bestanden uploaden $N -- andere tabbladen moeten deze optie ook actief hebben $N -- dit heeft alleen effect op de tabbladen die op hetzelfde domain zijn",

	"cut_az": "Bestanden uploaden in alfabetische volgorde, in plaats van kleinste bestanden eerst$N$Nalfabetische volgorde kan het makkelijker maken om te zien of er wat fout is gegaan op de server, dit maakt het uploaden ietsjes trager op fiber / LAN",

	"cut_nag": "Systeem notificatie weergeven als een upload voltooid is$N(alleen als de browser of tabblad niet actief is)",
	"cut_sfx": "Geluid waarschuwing afspelen als een upload voltooid is$N(alleen als de browser of tabblad niet actief is)",

	"cut_mt": "Gebruik multithreading om bestands-hashing te versnellen$N$Ndit gebruikt web-workers en vereist$Nmeer geheugen (tot wel 512 MiB extra)$N$Nmaakt https 30% sneller en http 4.5x sneller\">mt",

	"cut_wasm": "Gebruik wasm in plaats van de webbrowser ingebouwde hasher; verbetert de snelheid op chrome-gebaseerde webbrowsers maar verhoogd CPU gebruik, veel oude versie van chrome hebben een bug dat een geheugen lek heeft, dat kan alle geheugen in gebruik nemen en crashen als dit actief is\">wasm",

	"cft_text": "Favicon tekst (laat leeg en vernieuw om uit te schakelen)",
	"cft_fg": "Voorgrondkleur",
	"cft_bg": "Achtergrondkleur",

	"cdt_lim": "Max aantal bestanden laten zien in een map",
	"cdt_ask": "Als helemaal naar beneden gescrolld bent,$Nin plaats van meer inladen,$Nvraag wat het moet doen",
	"cdt_hsort": "Hoeveel sorteerregels (&lt;code&gt;,sorthref&lt;/code&gt;) moeten er in media-URL's worden opgenomen? Als je dit op 0 instelt, worden de sorteerregels in medialinks ook genegeerd wanneer erop geklikt word.",

	"tt_entree": "Laat navpane zien (directoryboom zijbalk)$NHotkey: B",
	"tt_detree": "Laat breadcrumbs zien$NHotkey: B",
	"tt_visdir": "Scroll naar geselecteerde map",
	"tt_ftree": "Verwissel tussen directoryboom / tekst bestanden$NHotkey: V",
	"tt_pdock": "Laat bovenliggende mappen zien in een vastgezet deelvenster bovenaan",
	"tt_dynt": "Automatisch groeien naarmate de directoryboom zich uitbreidt",
	"tt_wrap": "Automatische terugloop",
	"tt_hover": "Laat overlopenden lijnen zien bij zweven$N(stopt het scrollen tenzij de muis in de linker gedeelte van het scherm is)",

	"ml_pmode": "Aan het einde van de map...",
	"ml_btns": "Cmds",
	"ml_tcode": "Transcode",
	"ml_tcode2": "Transcode naar",
	"ml_tint": "Tint",
	"ml_eq": "Audio-equalizer",
	"ml_drc": "Dynamisch bereikcompressor",

	"mt_loop": "Loop/herhaal een nummer\">🔁",
	"mt_one": "Stop na een nummer\">1️⃣",
	"mt_shuf": "Shuffle alle muziek in alle mappen\">🔀",
	"mt_aplay": "Autoplay als er een song-ID staat in de link waarop je hebt geklikt om naar de server te gaan$N$NAls u dit uitschakelt, wordt de pagina-URL ook niet meer bijgewerkt met nummer-ID's tijdens het afspelen van muziek. Dit voorkomt automatisch afspelen als deze instellingen verloren gaan, maar de URL behouden blijft.\">a▶",
	"mt_preload": "Begin het laden van de volgende nummer vlak voordat de huidige nummer het einde bereikt voor gapless playback\">preload",
	"mt_prescan": "Ga naar de volgende map voordat de laatste nummer eindigd$NMaakt de webbrower blij$NZo het afspelen van muziek niet gestopt word\">nav",
	"mt_fullpre": "Probeer het hele nummer vooraf te laden;$N✅ activeer dit op <b>onstabiele</b> verbindingen,$N❌ <b>zet uit</b> als je waarschijnlijk een trage verbinding hebt\">full",
	"mt_fau": "Op telefoons, voorkom muziek van stoppen als de volgende nummer niet snel genoeg voorgeladen is (kan de weergave van tags glitchy maken)\">☕️",
	"mt_waves": "Waveform zoekbar:$NToon audio-amplitude in de zoekbar\">~s",
	"mt_npclip": "Knoppen tonen voor het clipboarden van het nummer dat op dat moment wordt afgespeeld\">/np",
	"mt_m3u_c": "Knoppen tonen om de geselecteerde nummers als m3u8-afspeellijstitems te clipboarden\">📻",
	"mt_octl": "OS-integratie (media hotkeys / osd)\">os-ctl",
	"mt_oseek": "Zoeken via os-integratie mogelijk maken$N$NNotitie: op sommige toestellen (iPhones) dit vervcangt de volgende-nummer knop\">seek",
	"mt_oscv": "Albumhoes weergeven in osd\">art",
	"mt_follow": "Het afgespeelde nummer in beeld houden\">🎯",
	"mt_compact": "Compacte bedieningselementen\">⟎",
	"mt_uncache": "Cache wissen &nbsp;(Probeer dit als uw browser een kapotte kopie van een nummer heeft gecached, waardoor het niet afgespeeld kan worden)\">uncache",
	"mt_mloop": "De open map herhalen\">🔁 loop",
	"mt_mnext": "Laad de volgende map en ga verder\">📂 next",
	"mt_mstop": "Stoppen met afspelen\">⏸ stop",
	"mt_cflac": "flac / wav omzetten naar {0}\">flac",
	"mt_caac": "aac / m4a omzetten naar {0}\">aac",
	"mt_coth": "Alle andere bestanden (geen mp3) converteren naar {0}\">oth",
	"mt_c2opus": "Beste keuze voor computers, laptops, android\">opus",
	"mt_c2owa": "opus-weba, voor iOS 17.5 en nieuwer\">owa",
	"mt_c2caf": "opus-caf, voor iOS 11 tot en met iOS 17\">caf",
	"mt_c2mp3": "Gebruik dit hele oude toestellen\">mp3",
	"mt_c2flac": "Beste geluidskwaliteit, maar grote downloads\">flac", //m
	"mt_c2wav": "Ongemprimeerde weergave (nog groter)\">wav", //m
	"mt_c2ok": "Mooi, goede keuze",
	"mt_c2nd": "Dat is niet het aanbevolen uitvoerformaat voor uw apparaat, maar dat is prima",
	"mt_c2ng": "Uw apparaat lijkt dit uitvoerformaat niet te ondersteunen, maar we gaan het toch proberen",
	"mt_xowa": "iOS bevat bugs waardoor dit formaat niet op de achtergrond kan worden afgespeeld; gebruik in plaats daarvan caf of mp3.",
	"mt_tint": "Achtergrond helderheid (0-100) op de zoekbalk om bufferen minder storend te maken",
	"mt_eq": "Schakelt de equalizer en gain-control in;$N$Nboost &lt;code&gt;0&lt;/code&gt; = standaard 100% volume (ongeweijzigd)$N$Nwidth &lt;code&gt;1 &nbsp;&lt;/code&gt; = standaard stereo (ongeweijzigd)$Nwidth &lt;code&gt;0.5&lt;/code&gt; = 50% links-rechts crossfeed$Nwidth &lt;code&gt;0 &nbsp;&lt;/code&gt; = mono$N$Nboost &lt;code&gt;-0.8&lt;/code&gt; &amp; width &lt;code&gt;10&lt;/code&gt; = stemverwijdering :^)$N$NDoor de equalizer in te schakelen, worden gapless albums volledig gapless. Laat hem dus aanstaan met alle waarden op nul (behalve width = 1) als je dat belangrijk vindt.",
	"mt_drc": "Schakelt de dynamic range compressor in (volume flattener / brickwaller); schakelt ook EQ in om de spaghetti te balanceren, dus zet alle EQ velden behalve ‘width’ op 0 als je dat niet wilt.$N$Nverlaagt het volume van audio boven THRESHOLD dB; voor elke RATIO dB voorbij THRESHOLD is er 1 dB output, dus standaardwaarden van tresh -24 en ratio 12 betekenen dat het nooit luider dan -22 dB zou moeten worden en het is veilig om de equalizer boost te verhogen tot 0.8, of zelfs 1.8 met ATK 0 en een enorme RLS zoals 90 (werkt alleen in firefox; RLS is max 1 in andere browsers)$N$N(zie wikipedia, die legt het veel beter uit)",

	"mb_play": "Afspelen",
	"mm_hashplay": "Deze audio bestand afspelen?",
	"mm_m3u": "Druk op <code>Enter/OK</code> om af te spelen\nDruk op <code>ESC/Annuleren</code> om te bewerken",
	"mp_breq": "Heeft firefox 82+ of chrome 73+ of iOS 15+",
	"mm_bload": "Aan het laden...",
	"mm_bconv": "Opmzetten naar {0}, even geduld...",
	"mm_opusen": "Uw browser kan geen aac / m4a-bestanden afspelen;\ntranscodering naar opus is nu ingeschakeld",
	"mm_playerr": "Afspelen mislukt: ",
	"mm_eabrt": "De afspeelpoging is geannuleerd",
	"mm_enet": "Je internetverbinding is onstabiel",
	"mm_edec": "Dit bestand is vermoedelijk beschadigd??",
	"mm_esupp": "Uw browser begrijpt deze audio-formaat niet",
	"mm_eunk": "Onbekende fout",
	"mm_e404": "Kan audio niet afspelen; fout 404: Bestand niet gevonden..",
	"mm_e403": "Kan audio niet afspelen; fout 403: Toegang geweigerd.\n\nProbeer op F5 te drukken om opnieuw te laden, misschien ben je uitgelogd",
	"mm_e500": "Kan geen audio afspelen; fout 500: Controleer serverlogs.",
	"mm_e5xx": "Kan geen audio afspelen; serverfout ",
	"mm_nof": "Geen audiobestanden meer vinden in de buurt",
	"mm_prescan": "Op zoek naar muziek om als volgende te spelen...",
	"mm_scank": "Het volgende nummer gevonden:",
	"mm_uncache": "Cache gewist; alle nummers worden opnieuw gedownload bij de volgende keer afspelen",
	"mm_hnf": "Dat liedje bestaat niet meer",

	"im_hnf": "Deze afbeelding bestaat niet meer",

	"f_empty": 'Deze map is leeg',
	"f_chide": 'Dit verbergt kolom «{0}»\n\nje kunt kolommen verbergen op de instellingen tabblad',
	"f_bigtxt": "Dit bestand is {0} MiB groot -- echt bekijken als tekst?",
	"f_bigtxt2": "Wilt u alleen het einde van het bestand bekijken? Dit maakt ook volgen/tailen mogelijk, waarbij nieuw toegevoegde tekstregels in realtime worden weergegeven.",
	"fbd_more": '<div id="blazy"><code>{0}</code> van de <code>{1}</code> bestanden weergegeven; <a href="#" id="bd_more">Toon {2}</a> of <a href="#" id="bd_all">Laat alles zien</a></div>',
	"fbd_all": '<div id="blazy"><code>{0}</code> van de <code>{1}</code> bestanden weergegeven; <a href="#" id="bd_all">Laat alles zien</a></div>',
	"f_anota": "Alleen {0} van de {1} items zijn geselecteerd;\nom de volledige map te selecteren, scrol je eerst naar beneden",

	"f_dls": 'de bestandslinks in de huidige map zijn veranderd in downloadlinks',

	"f_partial": "Om een bestand dat momenteel wordt geüpload veilig te downloaden, klikt u op het bestand met dezelfde bestandsnaam, maar zonder de bestandsextensie <code>.PARTIAL</code>. Druk op Annuleren of Escape om dit te doen.\n\nAls u op OK / Enter drukt, wordt deze waarschuwing genegeerd en gaat u verder met het downloaden van het gedeeltelijke <code>.PARTIAL</code> scratchbestand, waardoor u vrijwel zeker beschadigde gegevens krijgt.",

	"ft_paste": "plakken {0} items$NHotkey: ctrl-V",
	"fr_eperm": 'kan de naam niet wijzigen:\nje hebt geen “move” rechten in deze map',
	"fd_eperm": 'kan niet verwijderen:\nje hebt geen “delete” rechten in deze map',
	"fc_eperm": 'kan niet knippen:\nje hebt geen “move” rechten in deze map',
	"fp_eperm": 'kan niet plakken:\nje hebt geen “schrijf” rechten in deze map',
	"fr_emore": "selecteer ten minste één item om te hernoemen",
	"fd_emore": "selecteer minstens één item om te verwijderen",
	"fc_emore": "selecteer ten minste één item om te knippen",
	"fcp_emore": "selecteer ten minste één item om naar het klembord te kopiëren",

	"fs_sc": "Deel de map waarin je je bevindt",
	"fs_ss": "De geselecteerde bestand(en) delen",
	"fs_just1d": "U kunt niet meer dan één map selecteren\nof mix bestanden en mappen in één selectie",
	"fs_abrt": "❌ Afbreken",
	"fs_rand": "🎲 rand.naam",
	"fs_go": "✅ Maak share",
	"fs_name": "Naam",
	"fs_src": "Bron",
	"fs_pwd": "Wachtwoord",
	"fs_exp": "Verloopt",
	"fs_tmin": "min",
	"fs_thrs": "uur",
	"fs_tdays": "dag(en)",
	"fs_never": "eeuwig",
	"fs_pname": "Optionele linknaam; is willekeurig als deze leeg is",
	"fs_tsrc": "Het bestand of de map die u wilt delen",
	"fs_ppwd": "Optioneel wachtwoord",
	"fs_w8": "Delen...",
	"fs_ok": "Druk op <code>Enter/OK</code> naar klembord te zetten\Druk op <code>ESC/Annuleren</code> om te sluiten",

	"frt_dec": "Kan sommige gevallen van gebroken bestandsnamen oplossen\">url-decode",
	"frt_rst": "Gewijzigde bestandsnamen terugzetten naar de oorspronkelijke namen\">↺ reset",
	"frt_abrt": "Afbreken en dit venster sluiten\">❌ Annuleren",
	"frb_apply": "HERNOEMEN TOEPASSEN",
	"fr_adv": "Batch / metadata / patroon hernoemen\">Geavanceerd",
	"fr_case": "Hoofdlettergevoelige regex\">case",
	"fr_win": "Windows-veilige namen; vervangen <code>&lt;&gt;:&quot;\\|?*</code> met japanse tekens over de volledige breedte\">win",
	"fr_slash": "Vervang <code>/</code> met een teken waardoor er geen nieuwe mappen worden gemaakt\">geen /",
	"fr_re": "Regex zoekpatroon om toe te passen op originele bestandsnamen; naar capturing groups kan worden verwezen in het onderstaande opmaakveld zoals &lt;code&gt;(1)&lt;/code&gt; en &lt;code&gt;(2)&lt;/code&gt; enzovoort",
	"fr_fmt": "Geïnspireerd door foobar2000 :$N&lt;code&gt;(titel)&lt;/code&gt; wordt vervangen door de titel van het nummer,$N&lt;code&gt;[(artiest) - ](titel)&lt;/code&gt; sla [dit] gedeelte over als artiest leeg is$N&lt;code&gt;$lpad((tn),2,0)&lt;/code&gt; vult tracknummer op tot 2 cijfers (0X)",
	"fr_pdel": "Verwijderen",
	"fr_pnew": "Opslaan als",
	"fr_pname": "Geef een naam op voor je nieuwe preset",
	"fr_aborted": "Afgebroken",
	"fr_lold": "Oude naam",
	"fr_lnew": "Nieuwe naam",
	"fr_tags": "Tags voor de geselecteerde bestanden (alleen-lezen, alleen ter referentie):",
	"fr_busy": "Hernoemen van {0} items...\n\n{1}",
	"fr_efail": "Hernoemen mislukt:\n",
	"fr_nchg": "{0} van de nieuwe namen zijn gewijzigd als gevolg van <cod>win</code> en/of <code>geen /</code>\n\nOK om door te gaan met deze gewijzigde nieuwe namen?",

	"fd_ok": "Verwijderen OK",
	"fd_err": "Verwijderen mislukt:\n",
	"fd_none": "Er is niets verwijderd; misschien geblokkeerd door serverconfiguratie (xbd)?",
	"fd_busy": "{0} items verwijderen...\n\n{1}",
	"fd_warn1": "VERWIJDER deze {0} items?",
	"fd_warn2": "<b>LAATSTE KANS!</b> Geen manier om ongedaan te maken. Verwijderen?",

	"fc_ok": "Knip {0} items",
	"fc_warn": 'Knip {0} items\n\nmaar: alleen <b>deze</b> browser-tabblad kan weer plakken\n(omdat de selectie zo enorm is)',

	"fcc_ok": "{0} items naar klembord gekopieerd",
	"fcc_warn": '{0} items naar klembord gekopieerd\n\maar: alleen <b>deze</b> browser-tabblad kan weer plakken\n(omdat de selectie zo enorm is)',

	"fp_apply": "Gebruik deze namen",
	"fp_ecut": "Knip of kopieer eerst enkele bestanden/mappen om te verplaatsen/plakken\n\nnotitie: je kunt knippen/plakken in verschillende browsertabbladen",
	"fp_ename": "{0} items kunnen hier niet worden verplaatst omdat de namen al in gebruik zijn. Geef ze hieronder een nieuwe naam om verder te gaan, of verwijder de naam om ze over te slaan:",
	"fcp_ename": "{0} items kunnen hier niet worden gekopieerd omdat de namen al in gebruik zijn. Geef ze hieronder een nieuwe naam om verder te gaan, of verwijder de naam om ze over te slaan:",
	"fp_emore": "Er zijn nog enkele bestandsnaambotsingen die moeten worden opgelost",
	"fp_ok": "Verplaatsen OK",
	"fcp_ok": "Kopiëren OK",
	"fp_busy": "{0} items verplaatsen...\n\n{1}",
	"fcp_busy": "{0} items kopiëren...\n\n{1}",
	"fp_abrt": "afbreken...", //m
	"fp_err": "Verplaatsen mislukt:\n",
	"fcp_err": "Kopieëren mislukt:\n",
	"fp_confirm": "Verplaats deze {0} items hierheen?",
	"fcp_confirm": "Kopieer deze {0} items hier?",
	"fp_etab": 'Kan klembord van ander browsertabblad niet lezen',
	"fp_name": "Een bestand uploaden vanaf uw apparaat. Geef het een naam:",
	"fp_both_m": '<h6>Kies wat je wilt plakken</h6><code>Enter</code> = Verplaatsen {0} bestanden van «{1}»\n<code>ESC</code> = Upload {2} bestanden van je apparaat',
	"fcp_both_m": '<h6>Kies wat je wilt plakken</h6><code>Enter</code> = Kopieer {0} bestanden van «{1}»\n<code>ESC</code> = Upload {2} bestanden van je apparaat',
	"fp_both_b": '<a href="#" id="modal-ok">Verplaats</a><a href="#" id="modal-ng">Upload</a>',
	"fcp_both_b": '<a href="#" id="modal-ok">Kopieer</a><a href="#" id="modal-ng">Upload</a>',

	"mk_noname": "Voer een naam in het tekstveld aan de linkerkant voordat je verder gaat :p",
	"nmd_i1": "Voeg ook de gewenste extensie toe, bijvoorbeeld <code>.md</code>", //m
	"nmd_i2": "Je kunt alleen <code>.md</code>-bestanden maken omdat je geen verwijderrechten hebt", //m

	"tv_load": "Tekstdocument laden:\n\n{0}\n\n{1}% ({2} van de {3} MiB geladen)",
	"tv_xe1": "Kon tekstbestand niet laden:\n\nfout ",
	"tv_xe2": "404, bestand niet gevonden",
	"tv_lst": "Lijst met tekstbestanden in",
	"tvt_close": "Terugkeren naar mapweergave$NHotkey: M (of Esc)\">❌ Sluiten",
	"tvt_dl": "Download dit bestand$NHotkey: Y\">💾 download",
	"tvt_prev": "Vorig document tonen$NHotkey: i\">⬆ prev",
	"tvt_next": "Volgende document tonen$NHotkey: K\">⬇ next",
	"tvt_sel": "Selecteer bestand &nbsp; ( voor knip / verplaats / verwijder / ... )$NHotkey: S\">sel",
	"tvt_j": "json verfraaien$NHotkey: shift-J\">j", //m
	"tvt_edit": "Bestand openen in teksteditor$NHotkey: E\">✏️ bewerk",
	"tvt_tail": "Bestand controleren op wijzigingen; nieuwe regels in realtime weergeven\">📡 volgen",
	"tvt_wrap": "Automatische terugloop\">↵",
	"tvt_atail": "Vergrendelen scroll naar onderkant van pagina\">⚓",
	"tvt_ctail": "Kleuren van terminals decoderen (ansi escape codes)\">🌈",
	"tvt_ntail": "Terugrollimiet (hoeveel tekst geladen moeten blijven)",

	"m3u_add1": "Nummer toegevoegd aan m3u afspeellijst",
	"m3u_addn": "{0} nummers toegevoegd aan m3u-afspeellijst",
	"m3u_clip": "m3u-afspeellijst nu gekopieerd naar klembord\n\nje moet een nieuw tekstbestand maken met de naam iets.m3u en de afspeellijst in dat document plakken; dit maakt het afspeelbaar",

	"gt_vau": "Laat geen video's zien, speel alleen de audio af\">🎧",
	"gt_msel": "Schakel bestandsselectie in; ctrl-klik op een bestand om te openen$N$N&lt;em&gt;indien actief: dubbelklik op een bestand / map om het te openen&lt;/em&gt;$N$NHotkey: S\">multiselect",
	"gt_crop": "Gecentreerde miniaturen\">crop",
	"gt_3x": "Hi-res miniaturen\">3x",
	"gt_zoom": "Zoom",
	"gt_chop": "Verkorten",
	"gt_sort": "Sorteer bij",
	"gt_name": "naam",
	"gt_sz": "grootte",
	"gt_ts": "datum",
	"gt_ext": "type",
	"gt_c1": "Bestandsnamen meer inkorten (minder tonen)",
	"gt_c2": "Bestandsnamen minder inkorten (meer tonen)",

	"sm_w8": "Zoeken...",
	"sm_prev": "Onderstaande zoekresultaten zijn afkomstig van een eerdere zoekopdracht:\n  ",
	"sl_close": "Zoekresultaten sluiten",
	"sl_hits": "Toont {0} treffers",
	"sl_moar": "Laad meer",

	"s_sz": "grootte",
	"s_dt": "datum",
	"s_rd": "pad",
	"s_fn": "naam",
	"s_ta": "tags",
	"s_ua": "op@",
	"s_ad": "adv.",
	"s_s1": "Minimaal MiB",
	"s_s2": "Maximaal MiB",
	"s_d1": "Min. iso8601",
	"s_d2": "Max. iso8601",
	"s_u1": "Uploaded na",
	"s_u2": "en/of voor",
	"s_r1": "Pad bevad &nbsp; (spatie-gescheiden)",
	"s_f1": "Naam bevat &nbsp; (ontkennen met -nope)",
	"s_t1": "Tags bevat &nbsp; (^=start, einde=$)",
	"s_a1": "Specifieke metadata-eigenschappen",

	"md_eshow": "Kan niet weergeven ",
	"md_off": "[📜<em>readme</em>] uitgeschakeld in [⚙️] -- document verborgen",

	"badreply": "Mislukt om antwoord van server te parsen",

	"xhr403": "403: Toegang geweigerd\n\nprobeer F5 in te drukken, misschien ben je uitgelogd",
	"xhr0": "Onbekend (waarschijnlijk verbinding met server verloren of server is offline)",
	"cf_ok": "Sorry daarvoor -- DD" + wah + "OS-bescherming ingeschakeld\n\nalles zou binnen ongeveer 30 seconden moeten hervatten\n\nals er niets gebeurt, druk dan op F5 om de pagina opnieuw te laden",
	"tl_xe1": "Kon submappen niet weergeven:\n\nfout ",
	"tl_xe2": "404: Map niet gevonden",
	"fl_xe1": "Kon bestanden in map niet weergeven:\n\nfout ",
	"fl_xe2": "404: Map niet gevonden",
	"fd_xe1": "Kon submap niet aanmaken:\n\nfout ",
	"fd_xe2": "404: Bovenliggende map niet gevonden",
	"fsm_xe1": "Kon bericht niet verzenden:\n\nfout ",
	"fsm_xe2": "404: Bovenliggende map niet gevonden",
	"fu_xe1": "Mislukt om unpost lijst van server te laden:\n\nfout ",
	"fu_xe2": "404: Bestand niet gevonden??",

	"fz_tar": "gnu-tar bestand uitpakken (linux / mac)",
	"fz_pax": "pax-formaat tar uitpakken (trager)",
	"fz_targz": "gnu-tar met gzip niveau 3 compressie$N$Ndit is meestal erg langzaam, dus gebruik in plaats daarvan ongecomprimeerde tar",
	"fz_tarxz": "gnu-tar met xz-niveau 1 compressie$N$Ndit is meestal erg langzaam, dus gebruik in plaats daarvan ongecomprimeerde tar",
	"fz_zip8": "Zip met utf8 bestandsnamen (misschien onhandig op windows 7 en ouder)",
	"fz_zipd": "Zip met traditionele cp437-bestandsnamen, voor echt oude software",
	"fz_zipc": "cp437 met crc32 vroeg berekend$Nvoor MS-DOS PKZIP v2.04g (oktober 1993)$N(het duurt langer voordat het downloaden kan beginnen)",

	"un_m1": "Hieronder kunt u uw recente uploads verwijderen (of onvoltooide uploads afbreken)",
	"un_upd": "Vernieuwen",
	"un_m4": "of deel de bestanden die hieronder zichtbaar zijn:",
	"un_ulist": "Toon",
	"un_ucopy": "Kopieer",
	"un_flt": "Optionele filter:&nbsp; URL moet het volgende bevatten",
	"un_fclr": "Reset filter",
	"un_derr": 'unpost-verwijderen mislukt:\n',
	"un_f5": 'Er is iets kapot, probeer te verversen of druk op F5',
	"un_uf5": "Sorry, maar u moet de pagina vernieuwen (bijvoorbeeld door op F5 of CTRL-R te drukken) voordat deze upload kan worden afgebroken.",
	"un_nou": '<b>Waarschuwing:</b> server te druk om onvoltooide uploads weer te geven; klik straks op de "refresh" link',
	"un_noc": '<b>Waarschuwing:</b> unpost van volledig geüploade bestanden is niet ingeschakeld/toegestaan in de serverconfiguratie',
	"un_max": "Toont de eerste 2000 bestanden (gebruik de filter)",
	"un_avail": "{0} recente uploads kunnen worden verwijderd<br />{1} onvoltooide kunnen worden afgebroken",
	"un_m2": "Gesorteerd op uploadtijd; meest recente eerst:",
	"un_no1": "sike! geen enkele upload is recent genoeg",
	"un_no2": "sike! geen uploads die aan dat filter voldoen zijn voldoende recent",
	"un_next": "Verwijder de volgende {0} bestanden",
	"un_abrt": "Afbreken",
	"un_del": "Verwijderen",
	"un_m3": "Je recente uploads laden...",
	"un_busy": "Verwijderen van {0} bestanden...",
	"un_clip": "{0} links gekopieerd naar klembord",

	"u_https1": "Je moet",
	"u_https2": "overschakelen naar https",
	"u_https3": "voor betere prestaties",
	"u_ancient": 'Je browser is indrukwekkend oud -- misschien moet je <a href="#" onclick="goto(\'bup\')">in plaats daarvan bup gebruiken</a>',
	"u_nowork": "Je moet firefox 53+ of chrome 57+ of iOS 11+ hebben",
	"tail_2old": "Je moet firefox 105+ of chrome 71+ of iOS 14.5+ hebben",
	"u_nodrop": 'Je browser is te oud voor uploaden via slepen en neerzetten',
	"u_notdir": "Dat is geen map!\n\nuw browser is te oud,\nprobeer in plaats daarvan sleep en neerzetten",
	"u_uri": "Om afbeeldingen te slepen vanuit andere browser tabblad,\nplaats deze dan op de grote uploadknop",
	"u_enpot": 'Overschakelen naar <a href="#">potato UI</a> (kan uploadsnelheid verbeteren)',
	"u_depot": 'Overschakelen naar <a href="#">fancy UI</a> (kan uploadsnelheid verminderen)',
	"u_gotpot": 'Overschakelen naar de potato UI voor verbeterde uploadsnelheid,\n\nVoel je vrij om het er niet mee eens te zijn en schakel terug!',
	"u_pott": "<p>Bestanden: &nbsp; <b>{0}</b> klaar, &nbsp; <b>{1}</b> mislukt, &nbsp; <b>{2}</b> bezig, &nbsp; <b>{3}</b> in de wachtrij</p>",
	"u_ever": "Dit is de basis uploader; up2k heeft minstens het volgende nodig<br>chrome 21 // firefox 13 // edge 12 // opera 12 // safari 5.1",
	"u_su2k": 'Dit is de basis uploader; <a href="#" id="u2yea">up2k</a> is beter',
	"u_uput": 'Optimaliseren voor snelheid (checksum overslaan)',
	"u_ewrite": 'Je hebt geen schrijftoegang tot deze map',
	"u_eread": 'Je hebt geen leestoegang tot deze map',
	"u_enoi": 'Zoeken naar bestanden is niet ingeschakeld in de serverconfiguratie',
	"u_enoow": "Overschrijven zal hier niet werken; je heb verwijder toestemming nodig",
	"u_badf": 'Deze {0} bestanden (van {1} totaal) zijn overgeslagen, mogelijk door bestandssysteemmachtigingen:\n\n',
	"u_blankf": 'Deze {0} bestanden (van {1} totaal) zijn leeg; alsnog uploaden?\n\n',
	"u_applef": 'Deze {0} bestanden (van {1} totaal) zijn waarschijnlijk ongewenst;\nKlik op <code>OK/Enter</code> om de volgende bestanden over te slaan,\Klik op <code>Annuleren/ESC</code> niet uit te sluiten en deze ook te uploaden:\n\n',
	"u_just1": '\nMisschien werkt het beter als je slechts één bestand selecteert',
	"u_ff_many": "Als je <b>Linux / MacOS / Android,</b> gebruikt dan <em>kan</em> deze hoeveelheid bestanden <a href=\"https://bugzilla.mozilla.org/show_bug.cgi?id=1790500\" target=\"_blank\">Firefox crashen!</a>\nals dat gebeurt, probeer het dan opnieuw (of gebruik Chrome).",
	"u_up_life": "Deze upload wordt verwijderd van de server\n{0} nadat het is voltooid",
	"u_asku": 'Upload deze {0} bestanden naar <code>{1}</code>',
	"u_unpt": "Je kunt deze upload ongedaan maken / verwijderen met de linkerbovenhoek 🧯",
	"u_bigtab": 'We staan op het punt om {0} bestanden te tonen\n\nDit kan uw browser laten crashen, weet je het zeker??',
	"u_scan": 'Bestanden scannen...',
	"u_dirstuck": 'Directory iterator liep vast bij het benaderen van het volgende {0} items; zal het volgende overslaan:',
	"u_etadone": 'Klaar ({0}, {1} bestanden)',
	"u_etaprep": '(klaarmaken om te uploaden)',
	"u_hashdone": 'hashing klaar',
	"u_hashing": 'Hash',
	"u_hs": 'Hallo zeggen...',
	"u_started": "De bestanden worden nu geüpload; zie [🚀]",
	"u_dupdefer": "Duplicaat; wordt verwerkt na alle andere bestanden",
	"u_actx": "klik op deze tekst om prestatieverlies</br>bij het overschakelen naar andere vensters/tabbladen te voorkomen",
	"u_fixed": "OK!&nbsp; Fixed it 👍",
	"u_cuerr": "Mislukt bij het uploaden van stuk {0} van {1};\nwaarschijnlijk ongevaarlijk, doorgaan\n\nbestand: {2}",
	"u_cuerr2": "Upload door server geweigerd (stuk {0} van {1});\nzal later opnieuw proberen\n\nbestand: {2}\n\nfout ",
	"u_ehstmp": "Zal opnieuw proberen; zie rechtsonder",
	"u_ehsfin": "Server heeft het verzoek om de upload te finaliseren afgewezen; opnieuw proberen...",
	"u_ehssrch": "Server heeft de zoekaanvraag afgewezen; opnieuw proberen...",
	"u_ehsinit": "Server heeft het verzoek om het uploaden te starten afgewezen; opnieuw proberen...",
	"u_eneths": "Netwerkfout tijdens het uitvoeren van de uploadhanddruk; opnieuw proberen...",
	"u_enethd": "Netwerkfout tijdens het testen van het bestaan van het doel; opnieuw proberen...",
	"u_cbusy": "Wachten tot de server ons weer vertrouwt na een netwerkstoring...",
	"u_ehsdf": "Server heeft geen schijfruimte meer!\n\nzal blijven proberen, voor het geval iemand genoeg ruimte vrijmaakt om door te gaan",
	"u_emtleak1": "Het lijkt erop dat uw webbrowser een geheugenlek heeft;\nprobeer",
	"u_emtleak2": ' <a href="{0}">over te schakel over naar https (aanbevolen)</a> of ',
	"u_emtleak3": ' ',
	"u_emtleakc": 'Probeer het volgende:\n<ul><li>druk op <code>F5</code> om de pagina te verversen</li><li>dan schakel de &nbsp;<code>mt</code>&nbsp; uit, deze knop staat in &nbsp;<code>⚙️ instellingen</code></li><li>en probeer de upload opnieuw</li></ul>Uploaden zal wat langzamer gaan, maar ja.\nSorry voor de problemen!\n\nPS: chrome v107 <a href="https://bugs.chromium.org/p/chromium/issues/detail?id=1354816" target="_blank">heeft een bugfix</a> voor dit',
	"u_emtleakf": '{robeer het volgende:\n<ul><li>druk op <code>F5</code> om de pagina te verversen</li><li>dan activeer <code>🥔</code> (aardappel) in de upload scherm<li>en probeer de upload opnieuw</li></ul>\nPS: firefox <a href="https://bugzilla.mozilla.org/show_bug.cgi?id=1790500" target="_blank">heeft mogelijk een fix</a> op een gegeven moment',
	"u_s404": "Niet gevonden op server",
	"u_expl": "Leg uit",
	"u_maxconn": "De meeste browsers beperken dit tot 6, maar firefox laat je dit verhogen met <code>network.http.max-persistent-connections-per-server</code> in <code>about:config</code>",
	"u_tu": '<p class="warn">WAARSCHUWING: turbo ingeschakeld, <span>&nbsp;webbrowser detecteert en hervat onvolledige uploads mogelijk niet; zie de tooltip van de turboknop</span></p>',
	"u_ts": '<p class="warn">WAARSCHUWING: turbo ingeschakeld, <span>&nbsp;zoekresultaten kunnen onjuist zijn; zie turbo-knop tooltip</span></p>',
	"u_turbo_c": "Turbo is uitgeschakeld in serverconfiguratie",
	"u_turbo_g": "Turbo uitgeschakeld, je geen recht om mappen in deze volume te tonen",
	"u_life_cfg": 'Automatisch verwijderen na <input id="lifem" p="60" /> minuten (of <input id="lifeh" p="3600" /> uur)',
	"u_life_est": 'Upload wordt verwijderd <span id="lifew" tt="local time">---</span>',
	"u_life_max": 'Deze map dwingt een\nmaximale levensduur van {0} af',
	"u_unp_ok": 'unpost is toegestaan voor {0}',
	"u_unp_ng": 'unpost zijn NIET toegestaan',
	"ue_ro": 'Je toegang tot deze map is alleen-lezen\n\n',
	"ue_nl": 'Je bent momenteel niet ingelogd',
	"ue_la": 'Je bent momenteel aangemeld als "{0}"',
	"ue_sr": 'U bevindt zich momenteel in de bestandszoekmodus\n\nschakel over naar uploadmodus door op het vergrootglas te klikken 🔎 (naast de grote ZOEK-knop), en probeer opnieuw te uploaden\n\nsorry',
	"ue_ta": 'Probeer opnieuw te uploaden, het zou nu moeten werken',
	"ue_ab": "Dit bestand wordt al geüpload naar een andere map en die upload moet worden voltooid voordat het bestand naar een andere map kan worden geüpload.\n\nU kunt de eerste upload afbreken en laten vergeten met de linkerbovenhoek 🧯",
	"ur_1uo": "OK: Bestand succesvol geüpload",
	"ur_auo": "OK: Alle {0} bestanden succesvol geüpload",
	"ur_1so": "OK: Bestand gevonden op server",
	"ur_aso": "OK: Alle {0} bestanden gevonden op server",
	"ur_1un": "Uploaden mislukt, sorry",
	"ur_aun": "Alle {0} uploads mislukt, sorry",
	"ur_1sn": "Bestand NIET gevonden op server",
	"ur_asn": "De {0} bestanden zijn NIET gevonden op de server",
	"ur_um": "Voltooid;\n{0} upload(s) OK,\n{1} upload(s) mislukt, sorry",
	"ur_sm": "Voltooid;\n{0} bestand(en) gevonden op de server,\n{1} bestand(en) NIET gevonden op de server",

	"lang_set": "Vernieuw de pagina om de wijziging door te voeren?",

	"splash": {
		"a1": "Update",
		"b1": "Hallo, hoe gaat het met jou? &nbsp; <small>(Je bent niet ingelogd)</small>",
		"c1": "Uitloggen",
		"d1": "Voorwaarde",
		"d2": "Toont de status van alle actieve threads",
		"e1": "Configuratie opnieuw laden.",
		"e2": "Leest configuratiebestanden opnieuw in$N(accounts, volumes, volumeschakelaars)$Nen brengt alle e2ds-volumes in kaart$N$Nopmerking: veranderingen in globale parameters$Nvereist een volledige herstart van de server",
		"f1": "Je kan het volgende lezen:",
		"g1": "Je kan naar het volgende uploaden:",
		"cc1": "Schakelaars en dergelijke:",
		"h1": "k304 uitschakelen",
		"i1": "k304 inschakelen",
		"j1": "k304 verbreekt de verbinding voor elke HTTP 304. Dit helpt tegen bepaalde proxy servers die kunnen vastlopen/plotseling stoppen met het laden van pagina's, maar het vermindert ook de prestaties aanzienlijk",
		"k1": "Instellingen resetten",
		"l1": "Inloggen:",
		"ls3": "inloggen", //m
		"lu4": "gebruikersnaam", //m
		"lp4": "wachtwoord", //m
		"lo3": "“{0}” overal afmelden", //m
		"lo2": "dit zal de sessie in alle browsers beëindigen", //m
		"m1": "Welkom terug,",
		"n1": "404: bestand bestaat niet &nbsp;┐( ´ -`)┌",
		"o1": 'of misschien heb je geen toegang? probeer een wachtwoord of <a href="' + SR + '/?h">ga naar startscherm</a>',
		"p1": "403: toegang geweigerd &nbsp;~┻━┻",
		"q1": 'Probeer een wachtwoord of <a href="' + SR + '/?h">ga naar startscherm</a>',
		"r1": "Ga naar startscherm",
		".s1": "Kaart",
		"t1": "Actie",
		"u2": "Tijd sinds iemand voor het laatst naar de server schreef$N( upload / naamswijziging / ... )$N$N17d = 17 dagen$N1h23 = 1 uur 23 minuten$N4m56 = 4 minuten 56 secondes",
		"v1": "Verbinden",
		"v2": "Gebruik deze server als een lokale harde schijf",
		"w1": "Overschakelen naar https",
		"x1": "Wachtwoord wijzigen",
		"y1": "Jou gedeelde items",
		"z1": "Ontgrendel gebied:",
		"ta1": "Je moet eerst een nieuw wachtwoord invoeren",
		"ta2": "Herhaal om nieuw wachtwoord te bevestigen:",
		"ta3": "Typefout gevonden; probeer het opnieuw",
		"aa1": "Inkomend:",
		"ab1": "Schakel nr. 304 uit",
		"ac1": "Schakel nr. 304 in",
		"ad1": "Nr. 304 stopt al het cachegebruik. Als k304 niet voldoende was, probeer dan deze. Vermenigvuldigt het dataverbruik.!",
		"ae1": "Uitgaand:",
		"af1": "Recent geüploade bestanden weergeven",
		"ag1": "Bekende IdP-gebruikers weergeven",
	}
};
