## text expansion

enable expansion of placeholder variables in `README.md` and prologue/epilogue files with `--exp` and customize the list of allowed placeholders to expand using `--exp-md` and `--exp-lg`

| explanation          | placeholder          |
| -------------------- | -------------------- |
| your ip address      | {{self.ip}}          |
| your user-agent      | {{self.ua}}          |
| your username        | {{self.uname}}       |
| the `Host` you see   | {{self.host}}        |
| server unix time     | {{srv.itime}}        |
| server datetime      | {{srv.htime}}        |
| server name          | {{cfg.name}}         |
| logout after         | {{cfg.logout}} hours |
| vol reindex interval | {{vf.scan}}          |
| thumbnail size       | {{vf.thsize}}        |
| your country         | {{hdr.cf_ipcountry}} |

placeholders starting with...
* `self.` are grabbed from copyparty's internal state; anything in `httpcli.py` is fair game
* `cfg.` are the global server settings
* `vf.` are the volflags of the current volume
* `hdr.` are grabbed from the client headers; any header is supported, just add it (in lowercase) to the allowlist
* `srv.` are processed inside the `_expand` function in httpcli

for example (bad example), `hdr_cf_ipcountry` maps to the header `CF-IPCountry` (which is generated by cloudflare before the request is passed on to your server / copyparty)
