/*
Copyright 2024 New Vector Ltd.
Copyright 2020 The Matrix.org Foundation C.I.C.

SPDX-License-Identifier: AGPL-3.0-only OR GPL-3.0-only OR LicenseRef-Element-Commercial
Please see LICENSE files in the repository root for full details.
*/

import type { DependencyInfo } from "./dep.js";
import type HakEnv from "./hakEnv.js";

export default async function check(hakEnv: HakEnv, moduleInfo: DependencyInfo): Promise<void> {
    await moduleInfo.scripts.check?.(hakEnv, moduleInfo);
}
