## Upgrading to v0.7.0 from previous versions

In essence, the `glance.yml` file has been moved from the root of the project to a `config/` directory and you now need to mount that directory to `/app/config` in the container.

### Before

Versions before v0.7.0 used a `docker-compose.yml` that looked like the following:

```yaml
services:
  glance:
    image: glanceapp/glance
    volumes:
      - ./glance.yml:/app/glance.yml
    ports:
      - 8080:8080
```

And expected you to have the following directory structure:

```plaintext
glance/
    docker-compose.yml
    glance.yml
```

### After

With the release of v0.7.0, the recommended `docker-compose.yml` looks like the following:

```yaml
services:
  glance:
    container_name: glance
    image: glanceapp/glance
    volumes:
      - ./config:/app/config
    ports:
      - 8080:8080
```

And expects you to have the following directory structure:

```plaintext
glance/
    docker-compose.yml
    config/
        glance.yml
```

## Why this change was necessary

1. Mounting a file rather than a directory is not common practice and leads to some issues, such as creating a directory if the file is not present, which has tripped up multiple people and caused unnecessary confusion
2. v0.7.0 added automatic reloads when the configuration file changes, which based on testing didn't work when mounting a single file
3. v0.7.0 added the ability to include config files, so you'd have to make this change anyways if you wanted to take advantage of that feature

Taking all of these into account, it felt like the right time to implement the change.
