/*
 * event.h
 * Header for the event module
 * Author: Michael Czigler
 * License: MIT
 */

#ifndef __KIRC_EVENT_H
#define __KIRC_EVENT_H

#include "kirc.h"
#include "helper.h"

enum event_type {
    EVENT_NONE = 0,
    EVENT_CTCP_ACTION,
    EVENT_CTCP_CLIENTINFO,
    EVENT_CTCP_DCC,
    EVENT_CTCP_PING,
    EVENT_CTCP_TIME,
    EVENT_CTCP_VERSION,
    EVENT_ERROR,
    EVENT_EXT_CAP,
    EVENT_EXT_AUTHENTICATE,
    EVENT_JOIN,
    EVENT_KICK,
    EVENT_MODE,
    EVENT_NICK,
    EVENT_NOTICE,
    EVENT_PART,
    EVENT_PING,
    EVENT_PRIVMSG,
    EVENT_QUIT,
    EVENT_TOPIC,
    EVENT_001_RPL_WELCOME,
    EVENT_002_RPL_YOURHOST,
    EVENT_003_RPL_CREATED,
    EVENT_004_RPL_MYINFO,
    EVENT_005_RPL_BOUNCE,
    EVENT_042_RPL_YOURID,
    EVENT_200_RPL_TRACELINK,
    EVENT_201_RPL_TRACECONNECTING,
    EVENT_202_RPL_TRACEHANDSHAKE,
    EVENT_203_RPL_TRACEUNKNOWN,
    EVENT_204_RPL_TRACEOPERATOR,
    EVENT_205_RPL_TRACEUSER,
    EVENT_206_RPL_TRACESERVER,
    EVENT_207_RPL_TRACESERVICE,
    EVENT_208_RPL_TRACENEWTYPE,
    EVENT_209_RPL_TRACECLASS,
    EVENT_211_RPL_STATSLINKINFO,
    EVENT_212_RPL_STATSCOMMANDS,
    EVENT_213_RPL_STATSCLINE,
    EVENT_215_RPL_STATSILINE,
    EVENT_216_RPL_STATSKLINE,
    EVENT_218_RPL_STATSYLINE,
    EVENT_219_RPL_ENDOFSTATS,
    EVENT_221_RPL_UMODEIS,
    EVENT_234_RPL_SERVLIST,
    EVENT_235_RPL_SERVLISTEND,
    EVENT_241_RPL_STATSLLINE,
    EVENT_242_RPL_STATSUPTIME,
    EVENT_243_RPL_STATSOLINE,
    EVENT_244_RPL_STATSHLINE,
    EVENT_245_RPL_STATSSLINE,
    EVENT_250_RPL_STATSCONN,
    EVENT_251_RPL_LUSERCLIENT,
    EVENT_252_RPL_LUSEROP,
    EVENT_253_RPL_LUSERUNKNOWN,
    EVENT_254_RPL_LUSERCHANNELS,
    EVENT_255_RPL_LUSERME,
    EVENT_256_RPL_ADMINME,
    EVENT_257_RPL_ADMINLOC1,
    EVENT_258_RPL_ADMINLOC2,
    EVENT_259_RPL_ADMINEMAIL,
    EVENT_261_RPL_TRACELOG,
    EVENT_263_RPL_TRYAGAIN,
    EVENT_265_RPL_LOCALUSERS,
    EVENT_266_RPL_GLOBALUSERS,
    EVENT_300_RPL_NONE,
    EVENT_301_RPL_AWAY,
    EVENT_302_RPL_USERHOST,
    EVENT_303_RPL_ISON,
    EVENT_305_RPL_UNAWAY,
    EVENT_306_RPL_NOWAWAY,
    EVENT_311_RPL_WHOISUSER,
    EVENT_312_RPL_WHOISSERVER,
    EVENT_313_RPL_WHOISOPERATOR,
    EVENT_314_RPL_WHOWASUSER,
    EVENT_315_RPL_ENDOFWHO,
    EVENT_317_RPL_WHOISIDLE,
    EVENT_318_RPL_ENDOFWHOIS,
    EVENT_319_RPL_WHOISCHANNELS,
    EVENT_322_RPL_LIST,
    EVENT_323_RPL_LISTEND,
    EVENT_324_RPL_CHANNELMODEIS,
    EVENT_328_RPL_CHANNEL_URL,
    EVENT_331_RPL_NOTOPIC,
    EVENT_332_RPL_TOPIC,
    EVENT_333_RPL_TOPICWHOTIME,
    EVENT_341_RPL_INVITING,
    EVENT_346_RPL_INVITELIST,
    EVENT_347_RPL_ENDOFINVITELIST,
    EVENT_348_RPL_EXCEPTLIST,
    EVENT_349_RPL_ENDOFEXCEPTLIST,
    EVENT_351_RPL_VERSION,
    EVENT_352_RPL_WHOREPLY,
    EVENT_353_RPL_NAMREPLY,
    EVENT_364_RPL_LINKS,
    EVENT_365_RPL_ENDOFLINKS,
    EVENT_366_RPL_ENDOFNAMES,
    EVENT_367_RPL_BANLIST,
    EVENT_368_RPL_ENDOFBANLIST,
    EVENT_369_RPL_ENDOFWHOWAS,
    EVENT_371_RPL_INFO,
    EVENT_372_RPL_MOTD,
    EVENT_374_RPL_ENDOFINFO,
    EVENT_375_RPL_MOTDSTART,
    EVENT_376_RPL_ENDOFMOTD,
    EVENT_381_RPL_YOUREOPER,
    EVENT_382_RPL_REHASHING,
    EVENT_383_RPL_YOURESERVICE,
    EVENT_391_RPL_TIME,
    EVENT_392_RPL_USERSSTART,
    EVENT_393_RPL_USERS,
    EVENT_394_RPL_ENDOFUSERS,
    EVENT_395_RPL_NOUSERS,
    EVENT_396_RPL_HOSTHIDDEN,
    EVENT_400_ERR_UNKNOWNERROR,
    EVENT_401_ERR_NOSUCHNICK,
    EVENT_402_ERR_NOSUCHSERVER,
    EVENT_403_ERR_NOSUCHCHANNEL,
    EVENT_404_ERR_CANNOTSENDTOCHAN,
    EVENT_405_ERR_TOOMANYCHANNELS,
    EVENT_406_ERR_WASNOSUCHNICK,
    EVENT_407_ERR_TOOMANYTARGETS,
    EVENT_408_ERR_NOSUCHSERVICE,
    EVENT_409_ERR_NOORIGIN,
    EVENT_411_ERR_NORECIPIENT,
    EVENT_412_ERR_NOTEXTTOSEND,
    EVENT_413_ERR_NOTOPLEVEL,
    EVENT_414_ERR_WILDTOPLEVEL,
    EVENT_415_ERR_BADMASK,
    EVENT_421_ERR_UNKNOWNCOMMAND,
    EVENT_422_ERR_NOMOTD,
    EVENT_423_ERR_NOADMININFO,
    EVENT_424_ERR_FILEERROR,
    EVENT_431_ERR_NONICKNAMEGIVEN,
    EVENT_432_ERR_ERRONEUSNICKNAME,
    EVENT_433_ERR_NICKNAMEINUSE,
    EVENT_436_ERR_NICKCOLLISION,
    EVENT_441_ERR_USERNOTINCHANNEL,
    EVENT_442_ERR_NOTONCHANNEL,
    EVENT_443_ERR_USERONCHANNEL,
    EVENT_444_ERR_NOLOGIN,
    EVENT_445_ERR_SUMMONDISABLED,
    EVENT_446_ERR_USERSDISABLED,
    EVENT_451_ERR_NOTREGISTERED,
    EVENT_461_ERR_NEEDMOREPARAMS,
    EVENT_462_ERR_ALREADYREGISTERED,
    EVENT_463_ERR_NOPERMFORHOST,
    EVENT_464_ERR_PASSWDMISMATCH,
    EVENT_465_ERR_YOUREBANNEDCREEP,
    EVENT_467_ERR_KEYSET,
    EVENT_470_ERR_LINKCHANNEL,
    EVENT_471_ERR_CHANNELISFULL,
    EVENT_472_ERR_UNKNOWNMODE,
    EVENT_473_ERR_INVITEONLYCHAN,
    EVENT_474_ERR_BANNEDFROMCHAN,
    EVENT_475_ERR_BADCHANNELKEY,
    EVENT_476_ERR_BADCHANMASK,
    EVENT_477_ERR_NEEDREGGEDNICK,
    EVENT_478_ERR_BANLISTFULL,
    EVENT_481_ERR_NOPRIVILEGES,
    EVENT_482_ERR_CHANOPRIVSNEEDED,
    EVENT_483_ERR_CANTKILLSERVER,
    EVENT_485_ERR_UNIQOPRIVSNEEDED,
    EVENT_491_ERR_NOOPERHOST,
    EVENT_501_ERR_UMODEUNKNOWNFLAG,
    EVENT_502_ERR_USERSDONTMATCH,
    EVENT_524_ERR_HELPNOTFOUND,
    EVENT_704_RPL_HELPSTART,
    EVENT_705_RPL_HELPTXT,
    EVENT_706_RPL_ENDOFHELP,
    EVENT_900_RPL_LOGGEDIN,
    EVENT_901_RPL_LOGGEDOUT,
    EVENT_902_ERR_NICKLOCKED,
    EVENT_903_RPL_SASLSUCCESS,
    EVENT_904_ERR_SASLFAIL,
    EVENT_905_ERR_SASLTOOLONG,
    EVENT_906_ERR_SASLABORTED,
    EVENT_907_ERR_SASLALREADY,
    EVENT_908_RPL_SASLMECHS
};

struct event_dispatch_table {
    const char *command;
    enum event_type type;
};

struct event {
    struct kirc_context *ctx;
    enum event_type type;
    char raw[MESSAGE_MAX_LEN];
    char channel[CHANNEL_MAX_LEN];
    char message[MESSAGE_MAX_LEN];
    char command[MESSAGE_MAX_LEN];
    char nickname[MESSAGE_MAX_LEN];
    char params[MESSAGE_MAX_LEN];
};

int event_init(struct event *event, struct kirc_context *ctx);
int event_parse(struct event *event, char *line);

#endif  // __KIRC_EVENT_H
