## Contributing Guidelines

#### **Did you find a bug?**

* Please open issues for bugs and security vulnerabilities.

* **Ensure the bug was not already reported** by searching on GitHub
  under issues.

* If you're unable to find an open issue addressing the problem, open
  a new one. Be sure to include a **title and clear description**, and
  as much relevant information as possible, for example a copy of the
  log-file (`~/.config/nchat/log.txt`).

#### **Did you write a patch that fixes a bug?**

* Ensure your patch follows the coding style of the project code. There
  is no formal style guide, but the style is similar to
  [Google's C++ Style](https://google.github.io/styleguide/cppguide.html).
  For code formatting, please use the script `./make.sh src` which
  automatically formats the code.

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution.
  Include the relevant issue number if applicable.

* One bug per pull request.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in an issue first and wait for feedback to ensure
  it fits the project scope, then start writing code.

* For the implementation refer to above section.

* One feature per pull request.

#### **Do you have questions about the source code?**

* Feel free to ask questions in the issues section.
