#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "vars.h"

int parse_input(char *str)
{
   char *k,hex[3],*k1;
   char tmp[4];
   int c,x;

   #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"Parsing input string: %s\n",str);
   #endif

    //Get url
    k=input_url;
    c=0;
    while(*str!=' ')
    {
     *k=*str;
     c++;
     if (*str==0 || c>ML_URL) return (-1);

     k++;
     str++;
    }
    *k++=0;
    str++;


    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"    url: %s\n",input_url);
    #endif

 
    //Get IP
    // Digit 1
    k=tmp;
    c=0;
    while(*str!='.')
    {
     if (*str==0 || c>2) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;
    c=atoi(tmp);
    if (c<0 || c>255) return (-1);
    input_ip[0]=c;

    //Get IP
    // Digit 2
    k=tmp;
    c=0;
    while(*str!='.')
    {
     if (*str==0 || c>2) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;
    c=atoi(tmp);
    if (c<0 || c>255) return (-1);
    input_ip[1]=c;

    //Get IP
    // Digit 3
    k=tmp;
    c=0;
    while(*str!='.')
    {
     if (*str==0 || c>2) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;
    c=atoi(tmp);
    if (c<0 || c>255) return (-1);
    input_ip[2]=c;

    //Get IP
    // Digit 4
    k=tmp;
    c=0;
    while(*str!='/')
    {
     if (*str==0 || c>2) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;
    c=atoi(tmp);
    if (c<0 || c>255) return (-1);
    input_ip[3]=c;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"     ip: %d.%d.%d.%d\n",(unsigned char)input_ip[0],(unsigned char)input_ip[1],(unsigned char)input_ip[2],(unsigned char)input_ip[3]);
    #endif

    //Get host
    k=input_host;
    c=0;
    while(*str!=' ')
    {
     if (*str==0 || c>ML_HOST) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"   host: %s\n",input_host);
    #endif

    //Get ident
    k=input_ident;
    c=0;
    while(*str!=' ')
    {
     *k=tolower((int)*str);
     c++;
     if (*str==0 || c>ML_IDENT) return (-1);

     k++;
     str++;
    }
    *k++=0;
    str++;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"  ident: %s\n",input_ident);
    #endif

   //Get unescaped ident
   k=input_ident_un;
   k1=input_ident;

   while (*k1)
   {
    *k=*k1;
     //unescape
      if (*k=='%')
      {
       // %% case
       if (*(k1+1)=='%') {k1+=2;k++;  continue;}

       //%XX
       if (*(k1+1) && *(k1+2))
         {
	  hex[0]=*(k1+1);
	  hex[1]=*(k1+2);
	  hex[2]=0;
	  if (1==sscanf(hex,"%x",&x))
	     {
	      *k=(char)(0x0ff & x);
	      k1+=2;
	     }
	 }
     }
    k++;
    k1++;
   }
    *k++=0;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr,"ident_u: %s\n",input_ident_un);
    #endif

    //Get method
    k=input_method;
    c=0;
    while(*str!=' ' && *str!=0 && *str!='\n' && *str!='\r')
    {
     if (*str==0 || c>ML_METHOD) return (-1);
     *k++=*str++;
     c++;
    }
    *k++=0;
    str++;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr," method: %s\n",input_method);
    #endif

    
    //Raw changes
    raw_change();

   //Get unescaped url
   k=input_url_un;
   k1=input_url;

   while (*k1)
   {
    *k=*k1;
     //unescape
      if (*k=='%')
      {
       // %% case
       if (*(k1+1)=='%') {k1+=2;k++;  continue;}

       //%XX
       if (*(k1+1) && *(k1+2))
         {
	  hex[0]=*(k1+1);
	  hex[1]=*(k1+2);
	  hex[2]=0;
	  if (1==sscanf(hex,"%x",&x))
	     {
	      *k=(char)(0x0ff & x);
	      k1+=2;
	     }
	 }
     }
    k++;
    k1++;
   }
    *k++=0;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr," url_un: %s\n",input_url_un);
    #endif

   #ifdef CASE_INDEPENDENT
   //Set case independent input url
    k=input_url_uc;
    k1=input_url_un;

    while (*k1)
    {
     *k=tolower((int)*k1);
      k++;
      k1++;
     }
    *k++=0;

    #ifdef DEBUG_PARSE_UNPUT
    fprintf(stderr," url_uc: %s\n",input_url_uc);
    #endif

   #endif


 return (0); // all OK
}
