import globals from "globals";
import js from "@eslint/js";
import stylistic from "@stylistic/eslint-plugin";

export default [
    js.configs.all,
    stylistic.configs["all-flat"],
    {ignores: ["interface/js/lib/"]},
    {
        languageOptions: {
            ecmaVersion: 2016,
            globals: {
                ...globals.browser,
                define: false,
            },
            parserOptions: {
                ecmaVersion: 2020,
            },
            sourceType: "script",
        },
        plugins: {
            "@stylistic": stylistic,
        },
        rules: {
            "@stylistic/array-bracket-newline": ["error", "consistent"],
            "@stylistic/array-element-newline": "off",
            "@stylistic/brace-style": ["error", "1tbs", {allowSingleLine: true}],
            "@stylistic/comma-dangle": ["error", "only-multiline"],
            "@stylistic/dot-location": ["error", "property"],
            "@stylistic/function-call-argument-newline": "off",
            "@stylistic/function-paren-newline": "off",
            "@stylistic/indent-binary-ops": "off",
            "@stylistic/max-len": ["error", {code: 128}],
            "@stylistic/max-statements-per-line": ["error", {max: 2}],
            "@stylistic/multiline-comment-style": "off",
            "@stylistic/multiline-ternary": ["error", "always-multiline"],
            "@stylistic/newline-per-chained-call": ["error", {ignoreChainWithDepth: 5}],
            "@stylistic/no-extra-parens": ["error", "functions"],
            "@stylistic/object-property-newline": ["error", {allowAllPropertiesOnSameLine: true}],
            "@stylistic/padded-blocks": ["error", "never"],
            "@stylistic/quote-props": ["error", "consistent-as-needed"],
            "@stylistic/quotes": ["error", "double", {avoidEscape: true}],
            "@stylistic/semi": ["error", "always"],
            "@stylistic/space-before-function-paren": ["error", {
                anonymous: "always",
                named: "never",
            }],

            "camelcase": "off",
            "capitalized-comments": "off",
            "curly": ["error", "multi-line"],
            "func-names": "off",
            "func-style": ["error", "declaration"],
            "id-length": ["error", {min: 1}],
            "line-comment-position": "off",
            "logical-assignment-operators": ["error", "never"],
            "max-lines": "off",
            "max-lines-per-function": "off",
            "max-params": ["warn", 6],
            "max-statements": ["warn", 55],
            "multiline-comment-style": "off",
            "no-continue": "off",
            "no-inline-comments": "off",
            "no-invalid-this": "off",
            "no-magic-numbers": "off",
            "no-negated-condition": "off",
            "no-plusplus": "off",
            "no-ternary": "off",
            "no-unused-vars": ["error", {caughtErrors: "none"}],
            "object-shorthand": "off",
            "one-var": ["error", {initialized: "never"}],
            "prefer-named-capture-group": "off",
            "prefer-object-has-own": "off",
            "prefer-spread": "off",
            "prefer-template": "off",
            "require-unicode-regexp": "off",
            "sort-keys": "off",
        },
    },
    {
        files: ["**/*.mjs"],
        languageOptions: {ecmaVersion: 2020, sourceType: "module"},
        rules: {
            "sort-keys": "error",
        },
    },
    {
        // Playwright E2E tests
        files: ["test/playwright/tests/*.mjs"],
        rules: {
            "no-await-in-loop": "off", // Playwright operations in loops are often sequential and not independent
            "no-empty-pattern": ["error", {allowObjectPatternsAsParameters: true}],
            "sort-keys": ["error", "asc", {minKeys: 4}]
        },
    },
];
