lazy_static::lazy_static! {
pub static ref T: std::collections::HashMap<&'static str, &'static str> =
    [
        ("Status", "État"),
        ("Your Desktop", "Votre bureau"),
        ("desk_tip", "Votre bureau est accessible via l’identifiant et le mot de passe ci-dessous."),
        ("Password", "Mot de passe"),
        ("Ready", "Prêt"),
        ("Established", "Établie"),
        ("connecting_status", "Connexion au réseau RustDesk…"),
        ("Enable service", "Activer le service"),
        ("Start service", "Démarrer le service"),
        ("Service is running", "Le service est en cours d’exécution"),
        ("Service is not running", "Le service est inactif"),
        ("not_ready_status", "Pas prêt ; veuillez vérifier la connexion"),
        ("Control Remote Desktop", "Contrôler un bureau à distance"),
        ("Transfer file", "Transférer des fichiers"),
        ("Connect", "Se connecter"),
        ("Recent sessions", "Sessions récentes"),
        ("Address book", "Carnet d’adresses"),
        ("Confirmation", "Confirmation"),
        ("TCP tunneling", "Tunnel TCP"),
        ("Remove", "Retirer"),
        ("Refresh random password", "Générer un nouveau mot de passe aléatoire"),
        ("Set your own password", "Définir votre propre mot de passe"),
        ("Enable keyboard/mouse", "Activer le contrôle clavier/souris"),
        ("Enable clipboard", "Activer la synchronisation du presse-papier"),
        ("Enable file transfer", "Activer le transfert de fichiers"),
        ("Enable TCP tunneling", "Activer le tunnel TCP"),
        ("IP Whitelisting", "Liste blanche d’adresses IP"),
        ("ID/Relay Server", "Serveur ID/relais"),
        ("Import server config", "Importer la configuration du serveur"),
        ("Export Server Config", "Exporter la configuration du serveur"),
        ("Import server configuration successfully", "Configuration du serveur importée avec succès"),
        ("Export server configuration successfully", "Configuration du serveur exportée avec succès"),
        ("Invalid server configuration", "Configuration du serveur non valide"),
        ("Clipboard is empty", "Le presse-papier est vide"),
        ("Stop service", "Arrêter le service"),
        ("Change ID", "Modifier l’ID"),
        ("Your new ID", "Votre nouvel ID"),
        ("length %min% to %max%", "longueur de %min% à %max%"),
        ("starts with a letter", "commence par une lettre"),
        ("allowed characters", "caractères autorisés"),
        ("id_change_tip", "Seuls les caractères a-z, A-Z, 0-9, - (trait d’union) et _ (tiret bas) sont autorisés. La première lettre doit être a-z ou A-Z. La longueur doit être comprise entre 6 et 16."),
        ("Website", "Site web"),
        ("About", "À propos"),
        ("Slogan_tip", "Fait avec cœur dans ce monde chaotique !"),
        ("Privacy Statement", "Déclaration de confidentialité"),
        ("Mute", "Muet"),
        ("Build Date", "Date de compilation"),
        ("Version", "Version"),
        ("Home", "Accueil"),
        ("Audio Input", "Entrée audio"),
        ("Enhancements", "Améliorations"),
        ("Hardware Codec", "Transcodage matériel"),
        ("Adaptive bitrate", "Débit adaptatif"),
        ("ID Server", "Serveur ID"),
        ("Relay Server", "Serveur relais"),
        ("API Server", "Serveur API"),
        ("invalid_http", "Doit commencer par http:// ou https://"),
        ("Invalid IP", "IP non valide"),
        ("Invalid format", "Format non valide"),
        ("server_not_support", "Non encore pris en charge par le serveur"),
        ("Not available", "Non disponible"),
        ("Too frequent", "Modifié trop fréquemment, veuillez réessayer plus tard"),
        ("Cancel", "Annuler"),
        ("Skip", "Ignorer"),
        ("Close", "Fermer"),
        ("Retry", "Réessayer"),
        ("OK", "Valider"),
        ("Password Required", "Mot de passe requis"),
        ("Please enter your password", "Veuillez saisir votre mot de passe"),
        ("Remember password", "Mémoriser le mot de passe"),
        ("Wrong Password", "Mauvais mot de passe"),
        ("Do you want to enter again?", "Voulez-vous ressaisir le mot de passe ?"),
        ("Connection Error", "Erreur de connexion"),
        ("Error", "Erreur"),
        ("Reset by the peer", "Terminée par l’appareil distant"),
        ("Connecting...", "Connexion…"),
        ("Connection in progress. Please wait.", "Connexion en cours ; veuillez patienter."),
        ("Please try 1 minute later", "Veuillez réessayer dans une minute"),
        ("Login Error", "Erreur de connexion"),
        ("Successful", "Succès"),
        ("Connected, waiting for image...", "Connecté ; en attente de l’image…"),
        ("Name", "Nom"),
        ("Type", "Type"),
        ("Modified", "Modifié le"),
        ("Size", "Taille"),
        ("Show Hidden Files", "Afficher les fichiers cachés"),
        ("Receive", "Recevoir"),
        ("Send", "Envoyer"),
        ("Refresh File", "Rafraîchir le contenu"),
        ("Local", "Local"),
        ("Remote", "Distant"),
        ("Remote Computer", "Appareil distant"),
        ("Local Computer", "Appareil local"),
        ("Confirm Delete", "Confirmer la suppression"),
        ("Delete", "Supprimer"),
        ("Properties", "Propriétés"),
        ("Multi Select", "Sélection multiple"),
        ("Select All", "Tout sélectionner"),
        ("Unselect All", "Tout déselectionner"),
        ("Empty Directory", "Répertoire vide"),
        ("Not an empty directory", "Répertoire non vide"),
        ("Are you sure you want to delete this file?", "Voulez-vous vraiment supprimer ce fichier ?"),
        ("Are you sure you want to delete this empty directory?", "Voulez-vous vraiment supprimer ce répertoire vide ?"),
        ("Are you sure you want to delete the file of this directory?", "Voulez-vous vraiment supprimer le fichier de ce répertoire ?"),
        ("Do this for all conflicts", "Appliquer à tous les conflits"),
        ("This is irreversible!", "Ceci est irréversible !"),
        ("Deleting", "Suppression"),
        ("files", "fichiers"),
        ("Waiting", "En attente"),
        ("Finished", "Terminé"),
        ("Speed", "Vitesse"),
        ("Custom Image Quality", "Qualité d’image personnalisée"),
        ("Privacy mode", "Mode de confidentialité"),
        ("Block user input", "Bloquer la saisie de l’utilisateur"),
        ("Unblock user input", "Débloquer la saisie de l’utilisateur"),
        ("Adjust Window", "Ajuster la fenêtre"),
        ("Original", "Ratio d'origine"),
        ("Shrink", "Rétrécir"),
        ("Stretch", "Étirer"),
        ("Scrollbar", "Barre de défilement"),
        ("ScrollAuto", "Défilement automatique"),
        ("Good image quality", "Bonne qualité d’image"),
        ("Balanced", "Équilibré"),
        ("Optimize reaction time", "Optimiser le temps de réaction"),
        ("Custom", "Personnalisé"),
        ("Show remote cursor", "Afficher le curseur distant"),
        ("Show quality monitor", "Afficher le moniteur de qualité"),
        ("Disable clipboard", "Désactiver le presse-papier"),
        ("Lock after session end", "Verrouiller l’appareil distant après la déconnexion"),
        ("Insert Ctrl + Alt + Del", "Envoyer Ctrl + Alt + Del"),
        ("Insert Lock", "Verrouiller l’appareil distant"),
        ("Refresh", "Rafraîchir l’écran"),
        ("ID does not exist", "L’ID n’existe pas"),
        ("Failed to connect to rendezvous server", "Échec de la connexion au serveur de rendez-vous"),
        ("Please try later", "Veuillez essayer plus tard"),
        ("Remote desktop is offline", "Le bureau distant est hors ligne"),
        ("Key mismatch", "Discordance des clés"),
        ("Timeout", "Connexion expirée"),
        ("Failed to connect to relay server", "Échec de la connexion au serveur relais"),
        ("Failed to connect via rendezvous server", "Échec de la connexion via le serveur de rendez-vous"),
        ("Failed to connect via relay server", "Échec de la connexion via le serveur relais"),
        ("Failed to make direct connection to remote desktop", "Échec de la connexion directe au bureau distant"),
        ("Set Password", "Définir le mot de passe"),
        ("OS Password", "Mot de passe du système d’exploitation"),
        ("install_tip", "RustDesk n’est pas installé, ce qui peut limiter son utilisation à cause de l’UAC. Cliquez ci-dessous pour l’installer."),
        ("Click to upgrade", "Mettre à niveau"),
        ("Configure", "Configurer"),
        ("config_acc", "L’autorisation « Accessibilité » est requise pour contrôler votre bureau à distance."),
        ("config_screen", "L’autorisation « Enregistrement d’écran » est requise pour accéder à votre bureau à distance."),
        ("Installing ...", "Installation…"),
        ("Install", "Installer"),
        ("Installation", "Installation"),
        ("Installation Path", "Chemin d’installation"),
        ("Create start menu shortcuts", "Créer des raccourcis dans le menu démarrer"),
        ("Create desktop icon", "Créer une icône sur le bureau"),
        ("agreement_tip", "En lançant l’installation, vous acceptez le contrat de licence."),
        ("Accept and Install", "Accepter et installer"),
        ("End-user license agreement", "Conditions générales d’utilisation"),
        ("Generating ...", "Génération…"),
        ("Your installation is lower version.", "La version installée est antérieure à la version en cours d’exécution."),
        ("not_close_tcp_tip", "Veuillez ne pas fermer cette fenêtre lors de l’utilisation du tunnel"),
        ("Listening ...", "En attente de connexion…"),
        ("Remote Host", "Hôte distant"),
        ("Remote Port", "Port distant"),
        ("Action", "Action"),
        ("Add", "Ajouter"),
        ("Local Port", "Port local"),
        ("Local Address", "Adresse locale"),
        ("Change Local Port", "Changer le port local"),
        ("setup_server_tip", "N’hésitez pas à mettre en place votre propre serveur afin d’améliorer la connexion"),
        ("Too short, at least 6 characters.", "Trop court, 6 caractères minimum."),
        ("The confirmation is not identical.", "Les deux entrées ne correspondent pas."),
        ("Permissions", "Autorisations"),
        ("Accept", "Accepter"),
        ("Dismiss", "Rejeter"),
        ("Disconnect", "Déconnecter"),
        ("Enable file copy and paste", "Activer le copier-coller de fichiers"),
        ("Connected", "Connecté"),
        ("Direct and encrypted connection", "Connexion directe chiffrée"),
        ("Relayed and encrypted connection", "Connexion via relais chiffrée"),
        ("Direct and unencrypted connection", "Connexion directe non chiffrée"),
        ("Relayed and unencrypted connection", "Connexion via relais non chiffrée"),
        ("Enter Remote ID", "Saisissez l’ID de l’appareil distant"),
        ("Enter your password", "Saisissez votre mot de passe"),
        ("Logging in...", "En cours de connexion…"),
        ("Enable RDP session sharing", "Activer le partage de session RDP"),
        ("Auto Login", "Connexion automatique (Requiert l’activation de l’option « Verrouiller l’appareil distant après la déconnexion »)"),
        ("Enable direct IP access", "Activer l’accès direct par adresse IP"),
        ("Rename", "Renommer"),
        ("Space", "Espace"),
        ("Create desktop shortcut", "Créer un raccourci sur le bureau"),
        ("Change Path", "Modifier le chemin"),
        ("Create Folder", "Créer un dossier"),
        ("Please enter the folder name", "Veuillez saisir le nom du dossier"),
        ("Fix it", "Réparer"),
        ("Warning", "Avertissement"),
        ("Login screen using Wayland is not supported", "L’écran de connexion n’est pas pris en charge sous Wayland"),
        ("Reboot required", "Redémarrage requis"),
        ("Unsupported display server", "Le serveur d’affichage n’est pas pris en charge"),
        ("x11 expected", "x11 attendu"),
        ("Port", "Port"),
        ("Settings", "Paramètres"),
        ("Username", " Nom d’utilisateur"),
        ("Invalid port", "Port non valide"),
        ("Closed manually by the peer", "Terminée manuellement par l’appareil distant"),
        ("Enable remote configuration modification", "Activer la modification de la configuration à distance"),
        ("Run without install", "Exécuter sans installer"),
        ("Connect via relay", "Connecter via relais"),
        ("Always connect via relay", "Forcer la connexion via relais"),
        ("whitelist_tip", "Seules les adresses IP incluses dans la liste blanche pourront accéder à mon appareil"),
        ("Login", "Connexion"),
        ("Verify", "Vérifier"),
        ("Remember me", "Se souvenir de moi"),
        ("Trust this device", "Faire confiance à cet appareil"),
        ("Verification code", "Code de vérification"),
        ("verification_tip", "Un code de vérification a été envoyé à l’adresse électronique enregistrée ; saisissez le code de vérification afin de poursuivre la connexion."),
        ("Logout", "Déconnexion"),
        ("Tags", "Étiquettes"),
        ("Search ID", "Rechercher un ID"),
        ("whitelist_sep", "Vous pouvez utiliser une virgule, un point-virgule, un espace ou une nouvelle ligne comme séparateur"),
        ("Add ID", "Ajouter un ID"),
        ("Add Tag", "Ajouter une étiquette"),
        ("Unselect all tags", "Désélectionner toutes les étiquettes"),
        ("Network error", "Erreur réseau"),
        ("Username missed", "Nom d’utilisateur manquant"),
        ("Password missed", "Mot de passe manquant"),
        ("Wrong credentials", "Identifiant ou mot de passe erroné"),
        ("The verification code is incorrect or has expired", "Le code de vérification est incorrect ou a expiré"),
        ("Edit Tag", "Modifier l’étiquette"),
        ("Forget Password", "Oublier le mot de passe"),
        ("Favorites", "Favoris"),
        ("Add to Favorites", "Ajouter aux favoris"),
        ("Remove from Favorites", "Retirer des favoris"),
        ("Empty", "Vide"),
        ("Invalid folder name", "Nom de dossier non valide"),
        ("Socks5 Proxy", "Socks5 Agents"),
        ("Socks5/Http(s) Proxy", "Proxy Socks5/Http(s)"),
        ("Discovered", "Découverts"),
        ("install_daemon_tip", "Le service système doit être installé avant de pouvoir activer l’exécution au démarrage du système."),
        ("Remote ID", "ID de l’appareil distant"),
        ("Paste", "Coller"),
        ("Paste here?", "Coller ici ?"),
        ("Are you sure to close the connection?", "Voulez-vous vraiment terminer la connexion ?"),
        ("Download new version", "Télécharger la nouvelle version"),
        ("Touch mode", "Mode tactile"),
        ("Mouse mode", "Mode souris"),
        ("One-Finger Tap", "Appui simple"),
        ("Left Mouse", "Clic gauche"),
        ("One-Long Tap", "Appui prolongé"),
        ("Two-Finger Tap", "Appui à deux doigts"),
        ("Right Mouse", "Clic droit"),
        ("One-Finger Move", "Mouvement à un doigt"),
        ("Double Tap & Move", "Mouvement après double appui"),
        ("Mouse Drag", "Glissement de la souris"),
        ("Three-Finger vertically", "Trois doigts verticalement"),
        ("Mouse Wheel", "Roulette de la souris"),
        ("Two-Finger Move", "Mouvement à deux doigts"),
        ("Canvas Move", "Déplacer la vue"),
        ("Pinch to Zoom", "Pincer pour zoomer"),
        ("Canvas Zoom", "Zoom sur la vue"),
        ("Reset canvas", "Réinitialiser la vue"),
        ("No permission of file transfer", "Absence de l’autorisation de transfert de fichiers"),
        ("Note", "Note"),
        ("Connection", "Connexion"),
        ("Share screen", "Partage d’écran"),
        ("Chat", "Discussion"),
        ("Total", "Total"),
        ("items", "éléments"),
        ("Selected", "Sélectionné(s)"),
        ("Screen Capture", "Capture de l’écran"),
        ("Input Control", "Contrôle de la saisie"),
        ("Audio Capture", "Capture de l’audio"),
        ("Do you accept?", "Acceptez-vous ?"),
        ("Open System Setting", "Ouvrir les paramètres système"),
        ("How to get Android input permission?", "Comment obtenir l’autorisation de contrôle de la saisie sur Android ?"),
        ("android_input_permission_tip1", "Pour qu’un appareil distant puisse contrôler votre appareil Android via la souris ou le toucher d’écran, vous devez autoriser RustDesk à utiliser le service « Accessibilité »."),
        ("android_input_permission_tip2", "Veuillez accéder à la page suivante des paramètres système, puis recherchez et accédez à la section [Services installés] ; activez ensuite le service [RustDesk Input]."),
        ("android_new_connection_tip", "Une nouvelle demande de contrôle a été reçue, elle souhaite contrôler votre appareil actuel."),
        ("android_service_will_start_tip", "L’activation de la capture de l’écran démarrera automatiquement le service, ce qui permettra aux appareils distants d’initier une connexion vers cet appareil."),
        ("android_stop_service_tip", "L’arrêt du service terminera automatiquement toutes les connexions établies."),
        ("android_version_audio_tip", "La version actuelle d’Android ne prend pas en charge la capture de l’audio, veuillez passer à Android 10 ou supérieur."),
        ("android_start_service_tip", "Appuyez sur [Démarrer le service] ou activez l’autorisation [Capture de l’écran] pour démarrer le service de partage d’écran."),
        ("android_permission_may_not_change_tip", "Les modifications des autorisations peuvent requérir une reconnexion avant d’être prises en compte par les connexions déjà établies."),
        ("Account", "Compte"),
        ("Overwrite", "Écraser"),
        ("This file exists, skip or overwrite this file?", "Ce fichier existe déjà, ignorer ou écraser ce fichier ?"),
        ("Quit", "Quitter"),
        ("Help", "Aide"),
        ("Failed", "Échec"),
        ("Succeeded", "Succès"),
        ("Someone turns on privacy mode, exit", "Quelqu’un active le mode de confidentialité, désactiver"),
        ("Unsupported", "Non pris en charge"),
        ("Peer denied", "Refusé par l’appareil distant"),
        ("Please install plugins", "Veuillez installer les plugins"),
        ("Peer exit", "Désactivé par l’appareil distant"),
        ("Failed to turn off", "Échec de la désactivation"),
        ("Turned off", "Désactivé"),
        ("Language", "Langue"),
        ("Keep RustDesk background service", "Garder le service RustDesk en arrière plan"),
        ("Ignore Battery Optimizations", "Ignorer les optimisations de la batterie"),
        ("android_open_battery_optimizations_tip", "Pour désactiver cette fonctionnalité, veuillez accéder à la page suivante des paramètres de l’application RustDesk, puis recherchez et accédez à la section [Batterie] ; décochez ensuite l’option [Sans restriction]."),
        ("Start on boot", "Lancer au démarrage"),
        ("Start the screen sharing service on boot, requires special permissions", "Lancer le service de partage d’écran au démarrage, nécessite des autorisations spéciales"),
        ("Connection not allowed", "Connexion non autorisée"),
        ("Legacy mode", "Mode hérité"),
        ("Map mode", "Mode correspondance"),
        ("Translate mode", "Mode traduction"),
        ("Use permanent password", "Utiliser un mot de passe permanent"),
        ("Use both passwords", "Utiliser les deux mots de passe"),
        ("Set permanent password", "Définir le mot de passe permanent"),
        ("Enable remote restart", "Activer le redémarrage à distance"),
        ("Restart remote device", "Redémarrer l’appareil distant"),
        ("Are you sure you want to restart", "Voulez-vous vraiment redémarrer l’appareil ?"),
        ("Restarting remote device", "Redémarrage de l’appareil distant"),
        ("remote_restarting_tip", "L'appareil distant redémarre ; veuillez fermer cette boîte de dialogue et vous reconnecter en utilisant le mot de passe permanent dans quelques instants"),
        ("Copied", "Copié"),
        ("Exit Fullscreen", "Quitter le mode plein écran"),
        ("Fullscreen", "Plein écran"),
        ("Mobile Actions", "Actions mobiles"),
        ("Select Monitor", "Sélection du moniteur"),
        ("Control Actions", "Actions de contrôle"),
        ("Display Settings", "Paramètres d’affichage"),
        ("Ratio", "Rapport"),
        ("Image Quality", "Qualité d’image"),
        ("Scroll Style", "Style de défilement"),
        ("Show Toolbar", "Afficher la barre d’outils"),
        ("Hide Toolbar", "Cacher la barre d’outils"),
        ("Direct Connection", "Connexion directe"),
        ("Relay Connection", "Connexion via relais"),
        ("Secure Connection", "Connexion sécurisée"),
        ("Insecure Connection", "Connexion non sécurisée"),
        ("Scale original", "Échelle 100 %"),
        ("Scale adaptive", "Mise à l’échelle auto"),
        ("General", "Général"),
        ("Security", "Sécurité"),
        ("Theme", "Thème"),
        ("Dark Theme", "Thème sombre"),
        ("Light Theme", "Thème clair"),
        ("Dark", "Sombre"),
        ("Light", "Clair"),
        ("Follow System", "Suivi système"),
        ("Enable hardware codec", "Activer le transcodage matériel"),
        ("Unlock Security Settings", "Déverrouiller les paramètres de sécurité"),
        ("Enable audio", "Activer l’audio"),
        ("Unlock Network Settings", "Déverrouiller les paramètres réseau"),
        ("Server", "Serveur"),
        ("Direct IP Access", "Accès direct par adresse IP"),
        ("Proxy", "Proxy"),
        ("Apply", "Appliquer"),
        ("Disconnect all devices?", "Déconnecter tous les appareils ?"),
        ("Clear", "Effacer"),
        ("Audio Input Device", "Périphérique source audio"),
        ("Use IP Whitelisting", "Utiliser une liste blanche d’adresses IP"),
        ("Network", "Réseau"),
        ("Pin Toolbar", "Épingler la barre d’outils"),
        ("Unpin Toolbar", "Détacher la barre d’outils"),
        ("Recording", "Enregistrement"),
        ("Directory", "Répertoire"),
        ("Automatically record incoming sessions", "Enregistrer automatiquement les sessions entrantes"),
        ("Automatically record outgoing sessions", "Enregistrer automatiquement les sessions sortantes"),
        ("Change", "Modifier"),
        ("Start session recording", "Commencer l’enregistrement"),
        ("Stop session recording", "Stopper l’enregistrement"),
        ("Enable recording session", "Activer l’enregistrement de session"),
        ("Enable LAN discovery", "Activer la découverte sur réseau local"),
        ("Deny LAN discovery", "Interdire la découverte sur réseau local"),
        ("Write a message", "Écrire un message"),
        ("Prompt", "Annonce"),
        ("Please wait for confirmation of UAC...", "Veuillez attendre la confirmation de l’UAC…"),
        ("elevated_foreground_window_tip", "La fenêtre active du bureau distant nécessite des privilèges plus élevés pour fonctionner, la souris et le clavier ne peuvent donc pas l’atteindre actuellement. Vous pouvez demander à l’utilisateur distant de réduire la fenêtre active ou de cliquer sur le bouton d’élévation dans la fenêtre de gestion de la connexion. Il est conseillé d’installer le logiciel sur l’appareil distant afin d’éviter ce problème."),
        ("Disconnected", "Déconnecté"),
        ("Other", "Divers"),
        ("Confirm before closing multiple tabs", "Confirmer avant de fermer plusieurs onglets"),
        ("Keyboard Settings", "Paramètres du clavier"),
        ("Full Access", "Accès total"),
        ("Screen Share", "Partage d’écran"),
        ("Wayland requires Ubuntu 21.04 or higher version.", "Wayland nécessite Ubuntu 21.04 ou une version ultérieure."),
        ("Wayland requires higher version of linux distro. Please try X11 desktop or change your OS.", "Wayland nécessite une version ultérieure de votre distribution Linux. Veuillez essayer le bureau X11 ou changer de système d’exploitation."),
        ("JumpLink", "Afficher"),
        ("Please Select the screen to be shared(Operate on the peer side).", "Veuillez sélectionner l’écran à partager (côté appareil distant)."),
        ("Show RustDesk", "Afficher RustDesk"),
        ("This PC", "Ce PC"),
        ("or", "ou"),
        ("Continue with", "Continuer avec"),
        ("Elevate", "Élever les privilèges"),
        ("Zoom cursor", "Augmenter la taille du curseur"),
        ("Accept sessions via password", "Accepter les sessions via mot de passe"),
        ("Accept sessions via click", "Accepter les sessions via clic de confirmation"),
        ("Accept sessions via both", "Accepter les sessions via mot de passe ou clic de confirmation"),
        ("Please wait for the remote side to accept your session request...", "Veuillez attendre que votre demande de session distante soit acceptée…"),
        ("One-time Password", "Mot de passe à usage unique"),
        ("Use one-time password", "Utiliser un mot de passe à usage unique"),
        ("One-time password length", "Longueur du mot de passe à usage unique"),
        ("Request access to your device", "Demande l’accès à votre appareil"),
        ("Hide connection management window", "Cacher la fenêtre de gestion de la connexion"),
        ("hide_cm_tip", "Requiert d’accepter les sessions via mot de passe avec un mot de passe permanent"),
        ("wayland_experiment_tip", "La prise en charge de Wayland est en phase expérimentale, veuillez utiliser X11 si vous avez besoin d’un accès non assisté."),
        ("Right click to select tabs", "Clic droit pour sélectionner les onglets"),
        ("Skipped", "Ignoré"),
        ("Add to address book", "Ajouter au carnet d’adresses"),
        ("Group", "Groupe"),
        ("Search", "Rechercher"),
        ("Closed manually by web console", "Terminée manuellement par la console web"),
        ("Local keyboard type", "Disposition du clavier local"),
        ("Select local keyboard type", "Sélectionner la disposition du clavier local"),
        ("software_render_tip", "Si vous utilisez une carte graphique Nvidia sous Linux et que la fenêtre distante se ferme immédiatement après la connexion, l’installation du pilote open-source Nouveau et l’utilisation du rendu du logiciel peuvent aider. Un redémarrage du logiciel est requis."),
        ("Always use software rendering", "Toujours utiliser le rendu logiciel"),
        ("config_input", "Vous devez accorder à RustDesk l’autorisation « Surveillance de l’entrée » pour contrôler le bureau distant avec le clavier."),
        ("config_microphone", "Vous devez accorder à RustDesk l’autorisation « Enregistrer l’audio » pour discuter à distance."),
        ("request_elevation_tip", "Vous pouvez également demander une élévation des privilèges si un utilisateur est présent côté distant."),
        ("Wait", "Attendre"),
        ("Elevation Error", "Erreur d’élévation des privilèges"),
        ("Ask the remote user for authentication", "Demander à l’utilisateur distant de s’authentifier"),
        ("Choose this if the remote account is administrator", "Sélectionnez cette option si le compte distant est administrateur"),
        ("Transmit the username and password of administrator", "Transmettre le nom d’utilisateur et le mot de passe d’un compte administrateur"),
        ("still_click_uac_tip", "L’utilisateur distant devra malgré tout confirmer l’UAC de l’instance RustDesk en cours d’éxécution."),
        ("Request Elevation", "Demander l’élévation des privilèges"),
        ("wait_accept_uac_tip", "Veuillez attendre l’acceptation de l’UAC par l’utilisateur distant."),
        ("Elevate successfully", "Élévation des privilèges réussie"),
        ("uppercase", "majuscule"),
        ("lowercase", "minuscule"),
        ("digit", "chiffre"),
        ("special character", "caractère spécial"),
        ("length>=8", "longueur ≥ 8"),
        ("Weak", "Faible"),
        ("Medium", "Moyen"),
        ("Strong", "Fort"),
        ("Switch Sides", "Inverser la prise de contrôle"),
        ("Please confirm if you want to share your desktop?", "Voulez-vous vraiment partager votre bureau ?"),
        ("Display", "Affichage"),
        ("Default View Style", "Style de vue par défaut"),
        ("Default Scroll Style", "Style de défilement par défaut"),
        ("Default Image Quality", "Qualité d’image par défaut"),
        ("Default Codec", "Codec par défaut"),
        ("Bitrate", "Débit"),
        ("FPS", "FPS"),
        ("Auto", "Auto"),
        ("Other Default Options", "Autres options par défaut"),
        ("Voice call", "Appel vocal"),
        ("Text chat", "Conversation textuelle"),
        ("Stop voice call", "Terminer l’appel vocal"),
        ("relay_hint_tip", "Il n’est pas toujours possible d’établir une connexion directe, mais une connexion via serveur relais est envisageable. En outre, si vous souhaitez utiliser un relais dès la première tentative, vous pouvez ajouter le suffixe « /r » à l’ID ou activer l’option « Forcer la connexion via relais » depuis la carte des sessions récentes, si elle s’y trouve."),
        ("Reconnect", "Se reconnecter"),
        ("Codec", "Codec"),
        ("Resolution", "Résolution"),
        ("No transfers in progress", "Aucun transfert en cours"),
        ("Set one-time password length", "Définir la longueur du mot de passe à usage unique"),
        ("RDP Settings", "Paramètres RDP"),
        ("Sort by", "Trier par"),
        ("New Connection", "Nouvelle connexion"),
        ("Restore", "Restaurer"),
        ("Minimize", "Minimiser"),
        ("Maximize", "Maximiser"),
        ("Your Device", "Votre appareil"),
        ("empty_recent_tip", "Oups, aucune session récente !\nIl est l’heure d’en organiser une nouvelle."),
        ("empty_favorite_tip", "Vous n’avez pas encore d’appareils distants favoris ?\nTrouvez quelqu’un avec qui vous connecter et ajoutez-le à vos favoris !"),
        ("empty_lan_tip", "Oh non, il semble que nous n’avons pas encore découvert d’appareils sur le réseau local."),
        ("empty_address_book_tip", "Mince, il n’y a actuellement aucun appareil distant répertorié dans votre carnet d’adresses."),
        ("Empty Username", "Nom d’utilisation non renseigné"),
        ("Empty Password", "Mot de passe non renseigné"),
        ("Me", "Moi"),
        ("identical_file_tip", "Ce fichier est identique à celui sur l’appareil distant."),
        ("show_monitors_tip", "Afficher les écrans dans la barre d’outils"),
        ("View Mode", "Mode vue"),
        ("login_linux_tip", "Vous devez vous connecter au compte Linux distant pour établir une session de bureau X"),
        ("verify_rustdesk_password_tip", "Vérifier le mot de passe RustDesk"),
        ("remember_account_tip", "Se souvenir de ce compte"),
        ("os_account_desk_tip", "Ce compte est utilisé pour se connecter au système d’exploitation distant et activer la session de bureau en mode sans affichage"),
        ("OS Account", "Compte du système d’exploitation"),
        ("another_user_login_title_tip", "Un autre utilisateur est déjà connecté"),
        ("another_user_login_text_tip", "Déconnecter"),
        ("xorg_not_found_title_tip", "Xorg introuvable"),
        ("xorg_not_found_text_tip", "Veuillez installer Xorg"),
        ("no_desktop_title_tip", "Aucun environnement de bureau n’est disponible"),
        ("no_desktop_text_tip", "Veuillez installer l’environnement de bureau GNOME"),
        ("No need to elevate", "Élever les privilèges n’est pas nécessaire"),
        ("System Sound", "Son système"),
        ("Default", "Défaut"),
        ("New RDP", "Nouvel RDP"),
        ("Fingerprint", "Empreinte numérique"),
        ("Copy Fingerprint", "Copier l’empreinte numérique"),
        ("no fingerprints", "Aucune empreinte numérique"),
        ("Select a peer", "Sélectionnez l’appareil distant"),
        ("Select peers", "Sélectionnez les appareils distants"),
        ("Plugins", "Plugins"),
        ("Uninstall", "Désinstaller"),
        ("Update", "Mettre à jour"),
        ("Enable", "Activer"),
        ("Disable", "Désactiver"),
        ("Options", "Options"),
        ("resolution_original_tip", "Résolution d’origine"),
        ("resolution_fit_local_tip", "Adapter à la résolution locale"),
        ("resolution_custom_tip", "Résolution personnalisée"),
        ("Collapse toolbar", "Réduire la barre d’outils"),
        ("Accept and Elevate", "Accepter et élever les privilèges"),
        ("accept_and_elevate_btn_tooltip", "Accepter la connexion et élever les privilèges UAC."),
        ("clipboard_wait_response_timeout_tip", "Expiration du délai d’attente du presse-papier."),
        ("Incoming connection", "Connexion entrante"),
        ("Outgoing connection", "Connexion sortante"),
        ("Exit", "Quitter"),
        ("Open", "Ouvrir"),
        ("logout_tip", "Voulez-vous vraiment vous déconnecter ?"),
        ("Service", "Service"),
        ("Start", "Démarrer"),
        ("Stop", "Arrêter"),
        ("exceed_max_devices", "Vous avez atteint le nombre maximal d’appareils gérés."),
        ("Sync with recent sessions", "Synchroniser avec les sessions récentes"),
        ("Sort tags", "Trier les étiquettes"),
        ("Open connection in new tab", "Ouvrir les connexions dans un nouvel onglet"),
        ("Move tab to new window", "Déplacer l’onglet vers une nouvelle fenêtre"),
        ("Can not be empty", "Ne peut pas être vide"),
        ("Already exists", "Existe déjà"),
        ("Change Password", "Modifier le mot de passe"),
        ("Refresh Password", "Actualiser le mot de passe"),
        ("ID", "ID"),
        ("Grid View", "Vue Grille"),
        ("List View", "Vue Liste"),
        ("Select", "Sélectionner"),
        ("Toggle Tags", "Basculer les étiquettes"),
        ("pull_ab_failed_tip", "Échec de l’actualisation du carnet d’adresses"),
        ("push_ab_failed_tip", "Échec de la synchronisation du carnet d’adresses avec le serveur"),
        ("synced_peer_readded_tip", "Les appareils qui étaient présents dans les sessions récentes seront synchronisés vers le carnet d’adresses."),
        ("Change Color", "Modifier la couleur"),
        ("Primary Color", "Couleur principale"),
        ("HSV Color", "Couleur TSV"),
        ("Installation Successful!", "Installation réussie !"),
        ("Installation failed!", "Échec de l’installation !"),
        ("Reverse mouse wheel", "Inverser le sens de la molette de la souris"),
        ("{} sessions", "{} sessions"),
        ("scam_title", "Vous êtes peut-être victime d’une ESCROQUERIE !"),
        ("scam_text1", "Si vous êtes au téléphone avec quelqu’un QUE VOUS NE CONNAISSEZ PAS et en qui VOUS N’AVEZ PAS CONFIANCE et qui vous a demandé d’utiliser RustDesk et de démarrer le service, ne le faites pas et raccrochez immédiatement."),
        ("scam_text2", "Il s’agit probablement d’un escroc qui tente de vous voler de l’argent ou d’autres informations personnelles."),
        ("Don't show again", "Ne plus afficher"),
        ("I Agree", "J’accepte"),
        ("Decline", "Refuser"),
        ("Timeout in minutes", "Délai d’expiration en minutes"),
        ("auto_disconnect_option_tip", "Terminer automatiquement les sessions entrantes en cas d’inactivité de l’utilisateur"),
        ("Connection failed due to inactivity", "Déconnecté automatiquement pour cause d’inactivité"),
        ("Check for software update on startup", "Vérifier la disponibilité des mises à jour au démarrage"),
        ("upgrade_rustdesk_server_pro_to_{}_tip", "Veuillez mettre à jour RustDesk Server Pro vers la version {} ou une version ultérieure !"),
        ("pull_group_failed_tip", "Échec de l’actualisation du groupe"),
        ("Filter by intersection", "Filtrer par intersection"),
        ("Remove wallpaper during incoming sessions", "Cacher le fond d’écran lors des sessions entrantes"),
        ("Test", "Test"),
        ("display_is_plugged_out_msg", "L’affichage est débranché, passez sur le premier affichage."),
        ("No displays", "Aucun affichage"),
        ("Open in new window", "Ouvrir dans une nouvelle fenêtre"),
        ("Show displays as individual windows", "Montrer les affichages sous forme de fenêtres individuelles"),
        ("Use all my displays for the remote session", "Utiliser tous mes affichages pour la session à distance"),
        ("selinux_tip", "SELinux est activé sur votre appareil, ce qui peut empêcher RustDesk de fonctionner correctement sur la machine contrôlée."),
        ("Change view", "Disposition"),
        ("Big tiles", "Grandes tuiles"),
        ("Small tiles", "Petites tuiles"),
        ("List", "Liste"),
        ("Virtual display", "Affichage virtuel"),
        ("Plug out all", "Tout débrancher"),
        ("True color (4:4:4)", "Couleur réelle (4:4:4)"),
        ("Enable blocking user input", "Activer le blocage des entrées de l’utilisateur"),
        ("id_input_tip", "Vous pouvez saisir un ID, une adresse IP ou un nom de domaine suivi d’un port (<domaine>:<port>).\nSi vous souhaitez accéder à un appareil sur un autre serveur, veuillez ajouter l’adresse du serveur (<id>@<adresse_serveur>?key=<valeur_clé>), par exemple :\n9123456234@192.168.16.1:21117?key=5Qbwsde3unUcJBtrx9ZkvUmwFNoExHzpryHuPUdqlWM=.\nSi vous souhaitez accéder à un appareil sur un serveur public, veuillez saisir « <id>@public » (la clé n’est pas nécessaire pour le serveur public).\n\nSi vous souhaitez forcer l’utilisation d’une connexion via relais dès la première tentative, ajoutez « /r » après l’ID, par exemple : « 9123456234/r »."),
        ("privacy_mode_impl_mag_tip", "Mode 1"),
        ("privacy_mode_impl_virtual_display_tip", "Mode 2"),
        ("Enter privacy mode", "Entrer en mode de confidentialité"),
        ("Exit privacy mode", "Quitter le mode de confidentialité"),
        ("idd_not_support_under_win10_2004_tip", "Le pilote d’affichage indirect n’est pas pris en charge. Windows 10 version 2004 ou ultérieure est requis."),
        ("input_source_1_tip", "Entrée source 1"),
        ("input_source_2_tip", "Entrée source 2"),
        ("Swap control-command key", "Intervertir la touche contrôle-commande"),
        ("swap-left-right-mouse", "Intervertir les boutons gauche et droit de la souris"),
        ("2FA code", "Code 2FA"),
        ("More", "Plus"),
        ("enable-2fa-title", "Activer l’authentification à deux facteurs"),
        ("enable-2fa-desc", "Veuillez maintenant configurer votre authentificateur. Vous pouvez utiliser une application d’authentification telle qu’Authy, Microsoft ou Google Authenticator sur votre téléphone ou votre ordinateur.\n\nScannez le code QR avec votre application puis saisissez le code affiché par votre application afin d’activer l’authentification à deux facteurs."),
        ("wrong-2fa-code", "Impossible de vérifier le code. Vérifiez l’exactitude du code saisi ainsi que des paramètres d’heure locale"),
        ("enter-2fa-title", "Authentification à deux facteurs"),
        ("Email verification code must be 6 characters.", "Le code de vérification de l’adresse électronique doit être composé de 6 caractères."),
        ("2FA code must be 6 digits.", "Le code 2FA doit être composé de 6 chiffres."),
        ("Multiple Windows sessions found", "Plusieurs sessions Windows ont été trouvées"),
        ("Please select the session you want to connect to", "Veuillez sélectionner la session à laquelle vous souhaitez vous connecter"),
        ("powered_by_me", "Utilise la technologie RustDesk"),
        ("outgoing_only_desk_tip", "Vous utilisez une version personnalisée.\nVous pouvez vous connecter à d’autres appareils, mais les autres appareils ne peuvent pas se connecter au vôtre."),
        ("preset_password_warning", "Cette version personnalisée est livrée avec un mot de passe prédéfini. Toute personne connaissant ce mot de passe pourrait prendre le contrôle total de votre appareil. Si vous ne vous y attendiez pas, désinstallez immédiatement le logiciel."),
        ("Security Alert", "Alerte de sécurité"),
        ("My address book", "Mon carnet d’adresses"),
        ("Personal", "Personnel"),
        ("Owner", "Propriétaire"),
        ("Set shared password", "Définir le mot de passe partagé"),
        ("Exist in", "Existe dans"),
        ("Read-only", "Lecture seule"),
        ("Read/Write", "Lecture/Écriture"),
        ("Full Control", "Contrôle complet"),
        ("share_warning_tip", "Les champs ci-dessus sont partagés et visibles par les autres."),
        ("Everyone", "Tout le monde"),
        ("ab_web_console_tip", "Plus sur la console web"),
        ("allow-only-conn-window-open-tip", "N’autoriser la connexion que si la fenêtre RustDesk est ouverte"),
        ("no_need_privacy_mode_no_physical_displays_tip", "Aucun affichage physique ; l’utilisation du mode de confidentialité n’est pas nécessaire."),
        ("Follow remote cursor", "Suivre le curseur distant"),
        ("Follow remote window focus", "Suivre la focalisation de fenêtre distante"),
        ("default_proxy_tip", "Le protocole et le port par défaut sont Socks5 et 1080"),
        ("no_audio_input_device_tip", "Aucun périphérique d’entrée audio trouvé."),
        ("Incoming", "Entrantes"),
        ("Outgoing", "Sortantes"),
        ("Clear Wayland screen selection", "Effacer la sélection d’écran Wayland"),
        ("clear_Wayland_screen_selection_tip", "Une fois la sélection d’écran effacée, vous pourrez resélectionner l’écran à partager."),
        ("confirm_clear_Wayland_screen_selection_tip", "Voulez-vous vraiment effacer la sélection d’écran Wayland ?"),
        ("android_new_voice_call_tip", "Une nouvelle demande d’appel vocal a été reçue. Si vous acceptez, l’audio passera sur la communication vocale."),
        ("texture_render_tip", "Utiliser le rendu de texture afin de lisser les images. Désactiver cette option permet de résoudre certains problèmes de rendu."),
        ("Use texture rendering", "Utiliser le rendu de texture"),
        ("Floating window", "Fenêtre flottante"),
        ("floating_window_tip", "Aide à maintenir le service en arrière-plan"),
        ("Keep screen on", "Maintenir l’écran allumé"),
        ("Never", "Jamais"),
        ("During controlled", "Lorsque l’appareil est contrôlé"),
        ("During service is on", "Lorsque le service est actif"),
        ("Capture screen using DirectX", "Utiliser DirectX pour capturer l’écran"),
        ("Back", "Retour"),
        ("Apps", "Applis"),
        ("Volume up", "Volume haut"),
        ("Volume down", "Volume bas"),
        ("Power", "Marche/Arrêt"),
        ("Telegram bot", "Bot Telegram"),
        ("enable-bot-tip", "Activer cette fonctionnalité vous permet de recevoir le code 2FA depuis votre bot. Peut également servir de notification de connexion."),
        ("enable-bot-desc", "1. Entamez une discussion avec @BotFather.\n2. Envoyez-lui la commande « newbot ». Vous recevrez un jeton suite à cette étape.\n3. Entamez une discussion avec votre bot nouvellement créé. Envoyez-lui un message commençant par une barre oblique (« / ») tel que « /hello » afin de l’activer.\n"),
        ("cancel-2fa-confirm-tip", "Voulez-vous vraiment désactiver l’authentication à deux facteurs ?"),
        ("cancel-bot-confirm-tip", "Voulez-vous vraiment désactiver le bot Telegram ?"),
        ("About RustDesk", "À propos de RustDesk"),
        ("Send clipboard keystrokes", "Taper le contenu du presse-papier"),
        ("network_error_tip", "Veuillez vérifier votre connexion réseau puis réessayer."),
        ("Unlock with PIN", "Déverrouiller par code PIN"),
        ("Requires at least {} characters", "Requiert un minimum de {} caractères"),
        ("Wrong PIN", "Code PIN erroné"),
        ("Set PIN", "Définir le code PIN"),
        ("Enable trusted devices", "Activer les appareils de confiance"),
        ("Manage trusted devices", "Gérer les appareils de confiance"),
        ("Platform", "Plateforme"),
        ("Days remaining", "Jours restants"),
        ("enable-trusted-devices-tip", "Ne pas demander de code 2FA sur les appareils de confiance"),
        ("Parent directory", "Répertoire parent"),
        ("Resume", "Reprendre"),
        ("Invalid file name", "Nom de fichier non valide"),
        ("one-way-file-transfer-tip", "Le transfert de fichiers à sens unique est activé côté appareil contrôlé."),
        ("Authentication Required", "Authentication requise"),
        ("Authenticate", "Authentifier"),
        ("web_id_input_tip", "Vous pouvez saisir un ID sur le même serveur ; le client web ne prend pas en charge l’accès par adresse IP.\nSi vous souhaitez accéder à un appareil sur un autre serveur, veuillez ajouter l’adresse du serveur (<id>@<adresse_serveur>?key=<valeur_clé>), par exemple :\n9123456234@192.168.16.1:21117?key=5Qbwsde3unUcJBtrx9ZkvUmwFNoExHzpryHuPUdqlWM=.\nSi vous souhaitez accéder à un appareil sur un serveur public, veuillez saisir « <id>@public » (la clé n’est pas nécessaire pour le serveur public)."),
        ("Download", "Télécharger"),
        ("Upload folder", "Téléverser le dossier"),
        ("Upload files", "Téléverser les fichiers"),
        ("Clipboard is synchronized", "Le presse-papier est synchronisé"),
        ("Update client clipboard", "Actualiser le presse-papier du client"),
        ("Untagged", "Sans étiquette"),
        ("new-version-of-{}-tip", "Une nouvelle version de {} est disponible"),
        ("Accessible devices", "Appareils accessibles"),
        ("upgrade_remote_rustdesk_client_to_{}_tip", "Veuillez mettre le client RustDesk distant à jour vers la version {} ou ultérieure !"),
        ("d3d_render_tip", "Sur certaines machines, l’écran du contrôle à distance peut rester noir lors de l’utilisation du rendu D3D."),
        ("Use D3D rendering", "Utiliser le rendu D3D"),
        ("Printer", "Imprimante"),
        ("printer-os-requirement-tip", "La fonction d’impression sortante nécessite Windows 10 ou une version ultérieure."),
        ("printer-requires-installed-{}-client-tip", "{} doit être installé sur cet appareil avant de pouvoir utiliser l’impression à distance."),
        ("printer-{}-not-installed-tip", "L’imprimante {} n’est pas installée."),
        ("printer-{}-ready-tip", "L’imprimante {} est installée et opérationnelle."),
        ("Install {} Printer", "Installer l’imprimante {}"),
        ("Outgoing Print Jobs", "Impressions sortantes"),
        ("Incoming Print Jobs", "Impressions entrantes"),
        ("Incoming Print Job", "Impression entrante"),
        ("use-the-default-printer-tip", "Utiliser l’imprimante par défaut"),
        ("use-the-selected-printer-tip", "Utiliser l’imprimante sélectionnée"),
        ("auto-print-tip", "Imprimer automatiquement en utilisant l’imprimante sélectionnée."),
        ("print-incoming-job-confirm-tip", "L’appareil distant vous a envoyé une impression ; voulez-vous l’exécuter de votre côté ?"),
        ("remote-printing-disallowed-tile-tip", "Impression à distance non autorisée"),
        ("remote-printing-disallowed-text-tip", "Les paramètres de l’appareil contrôlé n’autorisent pas l’impression à distance."),
        ("save-settings-tip", "Enregistrer les paramètres"),
        ("dont-show-again-tip", "Ne plus afficher"),
        ("Take screenshot", "Prendre une capture d’écran"),
        ("Taking screenshot", "Prise de capture d’écran"),
        ("screenshot-merged-screen-not-supported-tip", "Actuellement, la prise de capture d’écran ne prend pas en charge les affichages multiples. Veuillez réessayer après avoir sélectionné un seul affichage."),
        ("screenshot-action-tip", "Veuillez choisir l’action à effectuer avec la capture d’écran."),
        ("Save as", "Enregistrer sous"),
        ("Copy to clipboard", "Copier dans le presse-papier"),
        ("Enable remote printer", "Activer l’impression à distance"),
        ("Downloading {}", "Téléchargement de {}"),
        ("{} Update", "Mise à jour de {}"),
        ("{}-to-update-tip", "{} va maintenant quitter afin d’installer la nouvelle version."),
        ("download-new-version-failed-tip", "Le téléchargement a échoué. Vous pouvez réessayer, ou bien cliquer sur le bouton « Télécharger » pour vous rendre sur la page de publication afin de mettre à jour manuellement."),
        ("Auto update", "Installer les mises à jour automatiquement"),
        ("update-failed-check-msi-tip", "La vérification de la méthode d’installation a échoué. Veuillez cliquer sur le bouton « Télécharger » pour vous rendre sur la page de publication afin de mettre à jour manuellement."),
        ("websocket_tip", "Seules les connexions via relais sont prises en charge lors de l’utilisation de WebSocket."),
        ("Use WebSocket", "Utiliser WebSocket"),
        ("Trackpad speed", "Vitesse du pavé tactile"),
        ("Default trackpad speed", "Vitesse par défaut du pavé tactile"),
        ("Numeric one-time password", "Mot de passe à usage unique numérique"),
        ("Enable IPv6 P2P connection", "Activer la connexion P2P IPv6"),
        ("Enable UDP hole punching", "Activer le « hole punching » UDP"),
        ("View camera", "Afficher la caméra"),
        ("Enable camera", "Activer la caméra"),
        ("No cameras", "Aucune caméra"),
        ("view_camera_unsupported_tip", "L’appareil distant ne prend pas en charge l’affichage de la caméra."),
        ("Terminal", "Terminal"),
        ("Enable terminal", "Activer le terminal"),
        ("New tab", "Nouvel onglet"),
        ("Keep terminal sessions on disconnect", "Maintenir les sessions du terminal lors de la déconnexion"),
        ("Terminal (Run as administrator)", "Terminal (administrateur)"),
        ("terminal-admin-login-tip", "Veuillez saisir le nom d’utilisateur et le mot de passe de l’administrateur de l’appareil contrôlé."),
        ("Failed to get user token.", "Échec de l’obtention du jeton utilisateur."),
        ("Incorrect username or password.", "Nom d’utilisateur ou mot de passe incorrect."),
        ("The user is not an administrator.", "L’utilisateur n’est pas un administrateur."),
        ("Failed to check if the user is an administrator.", "Échec de la vérification du statut d’administrateur de l’utilisateur."),
        ("Supported only in the installed version.", "Uniquement pris en charge dans la version installée."),
        ("elevation_username_tip", "Saisissez un nom d’utilisateur ou un domaine\\utilisateur"),
        ("Preparing for installation ...", "Préparation de l’installation…"),
        ("Show my cursor", "Afficher mon curseur"),
    ].iter().cloned().collect();
}
