#!/usr/bin/python
""" surl setup.py """

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import surl.version as sv
from distutils.core import setup

if sys.version < '2.5':
    sys.exit('Sorry, you need python 2.5 or higher to install surl')

setup(  name = 'surl',
        version = sv.surl_version,
        description = "Make short URLs using various sites",
        long_description = """A URL shortening command line application that supports various sites. It supports stdin or filename input. It grabs the URLs, converts them, and returns the same text that was used in the input. It is known to work with a wealth of services, such as bit.ly, tinyurl.com and tr.im.
The currently supported sites are a.gd, bit.ly, burnurl.com, cli.gs, decenturl.com, digg.com, is.gd, kl.am, liip.to, metamark.net, sn.im, snipr.com, snipurl.com, snurl.com, tinyurl.com, tr.im, turl.ca, ur.ly, and zz.gd.""",
        license = 'GPL',
        author = 'Savvas Radevic',
        author_email = 'vicedar@gmail.com',
        url = 'http://launchpad.net/surl',
        packages = ['surl'],
        scripts = ['scripts/surl'],
        package_data = { 'surl': ['plugin.lst'] },
        data_files = [
            ('share/man/man1', ['docs/surl.1']),
        ],
)
