import os.path

# Surl directory: <surl dir>/plugin.lst
surl_dir = os.path.dirname(__file__)
# $HOME
user_home_dir = os.path.expanduser("~")
# ~/.surl/
user_surl_dir = os.path.join(user_home_dir, ".surl")

# plugin.lst (file that contains plugins path)
# File in surl: surl/plugin.lst

if os.path.exists(os.path.join(surl_dir, "plugin.lst")):
    surl_plugin_lst = os.path.join(surl_dir, "plugin.lst")
else:
    surl_plugin_lst = "plugin.lst"

# ~/.surl/plugins/
user_plugin_lst = os.path.join(user_surl_dir, "plugin.lst")

def get_real_path(path):
    # Expand path and "~"
    real_path = os.path.realpath(os.path.expanduser(path))
    return real_path
