""" surl.surlscript """

# Copyright (c) 2009-2010 Ahmed El-Mahdawy <aa.mahdawy.10@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys

#services.py
try:
    import services
except ImportError:
    import surl.services as services

def shorten(args, service, url):
    print services.supportedServices()[service].get(args, url)

def parseScript(args, path):
    """ Parse surlscript """
    try:
        f = open(path)
    except IOError:
        print "ERROR: Cannot read surlscript file %s" % path
        sys.exit(1)
    
    scr = {
        'service' : 'tinyurl.com',
        'url' : ''
    }
    linenum = 1
    
    for line in f.readlines():
        try:
            if line == "\n" or line.startswith("#"):
                continue
            if line.endswith("\n"):
                line = line[0:len(line) - 1]
            if line.startswith("setvar "):
                line = line.split(" ")
                scr[line[1]] = line[2]
            elif line.startswith("srv "):
                print "WARNING: Deprecated function srv at line " + str(linenum)
                scr['service'] = line.split(" ")[1]
            elif line.startswith("st "):
                print "WARNING: Deprecated function st at line " + str(linenum)
                scr['url'] = line.split(" ")[1]
            elif line == "exec" or line.startswith("exec "):
                shorten(args, scr['service'], scr['url'])
            elif line == "sht" or line.startswith("sht "):
                print "WARNING: Deprecated function sht at line " + str(linenum)
                shorten(args, scr['service'], scr['url'])
            elif line.startswith("printvar "):
                print scr[line.split(" ")[1]]
            elif line == "printinf" or line.startswith("printinf "):
                print "Long URL:", scr['url']
                print "Shortening Service:", scr['service']
            elif line == "clear" or line.startswith("clear "):
                line = line.split(" ")
                if line[1] == "*":
                    scr = {
                        'service' : 'tinyurl.com',
                        'url' : ''
                    }
                else:
                    scr[line[1]] = ''
            else:
                print "ERROR: " + path + " at line " + str(linenum) + ": Unknown function or missing argument: " + line
                sys.exit(1)
        except IndexError:
            print "ERROR: Missing argument at line " + str(linenum)
        except KeyError:
            print "ERROR: Invalid argument at line " + str(linenum)
        linenum = linenum + 1
    sys.exit()
        
