import { Scope } from '@sentry/core';
import { Dsn, Event, EventHint, Integration, IntegrationClass, Severity } from '@sentry/types';
import { ElectronClient as ElectronClientInterface, ElectronOptions } from './common';
/**
 * The Sentry Electron SDK Frontend.
 *
 * @see ElectronOptions for documentation on configuration options.
 */
export declare class ElectronClient implements ElectronClientInterface {
    /** Actual frontend implementation for the main or renderer process. */
    private readonly _inner;
    /**
     * Creates a new Electron SDK instance.
     *
     * This constructor automatically chooses the right implementation for the
     * process type (`browser` or `renderer`).
     *
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    captureMinidump(path: string, event: Event, scope: Scope): string | undefined;
    /**
     * @inheritDoc
     */
    captureException(exception: any, hint?: EventHint, scope?: Scope): string | undefined;
    /**
     * @inheritDoc
     */
    captureMessage(message: string, level?: Severity, hint?: EventHint, scope?: Scope): string | undefined;
    /**
     * @inheritDoc
     */
    captureEvent(event: Event, hint?: EventHint, scope?: Scope): string | undefined;
    /**
     * @inheritDoc
     */
    getDsn(): Dsn | undefined;
    /**
     * @inheritDoc
     */
    getOptions(): ElectronOptions;
    /**
     * @inheritDoc
     */
    close(timeout?: number): Promise<boolean>;
    /**
     * @inheritDoc
     */
    flush(timeout?: number): Promise<boolean>;
    /**
     * @inheritDoc
     */
    showReportDialog(options: any): void;
    /**
     * @inheritDoc
     */
    getIntegration<T extends Integration>(integration: IntegrationClass<T>): T | null;
    /**
     * @inheritDoc
     */
    setupIntegrations(): void;
}
/**
 * This either calls init on main with node interations or renderer
 * with browser integrations.
 *
 * @param options Options
 */
export declare function specificInit(options: ElectronOptions): void;
/** Convenience interface used to expose Integrations */
export interface Integrations {
    [key: string]: Integration;
}
/** Return all integrations depending if running in browser or renderer. */
export declare function getIntegrations(): {
    node: Integrations;
    electron: Integrations;
} | {
    browser: Integrations;
};
//# sourceMappingURL=dispatch.d.ts.map