/// <reference types="node" />
import { Stats } from 'fs';
/**
 * Asynchronously reads given files content.
 *
 * @param path A relative or absolute path to the file
 * @returns A Promise that resolves when the file has been read.
 */
export declare function readFileAsync(path: string, options?: {
    encoding?: string;
    flag?: string;
}): Promise<string | Buffer>;
/**
 * Recursively creates the given path.
 *
 * @param path A relative or absolute path to create.
 * @returns A Promise that resolves when the path has been created.
 */
export declare function mkdirp(path: string): Promise<void>;
/**
 * Synchronous version of {@link mkdirp}.
 *
 * @param path A relative or absolute path to create.
 */
export declare function mkdirpSync(path: string): void;
/**
 * Read stats async
 */
export declare function statAsync(path: string): Promise<Stats>;
/**
 * unlink async
 */
export declare function unlinkAsync(path: string): Promise<void>;
/**
 * readdir async
 */
export declare function readDirAsync(path: string): Promise<string[]>;
/**
 * rename async
 */
export declare function renameAsync(oldPath: string, newPath: string): Promise<void>;
//# sourceMappingURL=fs.d.ts.map