import { __assign, __awaiter, __generator, __read, __spreadArray } from "tslib";
export { Severity, Status, } from '@sentry/types';
export { addGlobalEventProcessor, addBreadcrumb, captureException, captureEvent, captureMessage, configureScope, getHubFromCarrier, getCurrentHub, Hub, Scope, setContext, setExtra, setExtras, setTag, setTags, setUser, withScope, } from '@sentry/core';
import { getCurrentHub, initAndBind } from '@sentry/core';
import { _callOnClient } from '@sentry/minimal';
import { defaultIntegrations } from '@sentry/node';
import { MainClient } from './client';
import { Electron, OnUncaughtException } from './integrations';
import { NetTransport } from './transports/net';
export { MainClient } from './client';
export { MainBackend } from './backend';
export { NetTransport } from './transports/net';
export { Integrations as NodeIntegrations } from '@sentry/node';
export var ElectronIntegrations = { Electron: Electron, OnUncaughtException: OnUncaughtException };
/**
 * Init call to node, if no transport is set, we use net of electron
 * @param options ElectronOptions
 */
export function init(options) {
    var electronIntegrations = defaultIntegrations.filter(function (integration) { return integration.name !== 'OnUncaughtException'; });
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = __spreadArray(__spreadArray([], __read(electronIntegrations)), [
            // eslint-disable-next-line @typescript-eslint/unbound-method
            new OnUncaughtException({ onFatalError: options.onFatalError }),
            new Electron(),
        ]);
    }
    initAndBind(MainClient, __assign({ transport: NetTransport }, options));
}
/**
 * This function does nothing, call it in the renderer
 */
export function showReportDialog() {
    // noop
}
/**
 * Uploads a native crash dump (Minidump) to Sentry.
 *
 * @param path The relative or absolute path to the minidump.
 * @param event Optional event payload to attach to the minidump.
 */
export function captureMinidump(path, event) {
    if (event === void 0) { event = {}; }
    _callOnClient('captureMinidump', path, event);
}
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
export function flush(timeout) {
    return __awaiter(this, void 0, void 0, function () {
        var client;
        return __generator(this, function (_a) {
            client = getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.flush(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
export function close(timeout) {
    return __awaiter(this, void 0, void 0, function () {
        var client;
        return __generator(this, function (_a) {
            client = getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.close(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
//# sourceMappingURL=index.js.map