Summary: Belgium electronic identity card PKCS#11 module and Firefox plugin
Name: eid-mw
Version: 5.1.26
Release: 0.%{revision}%{?dist}
License: LGPL
Group: Applications/Communications
URL: https://eid.belgium.be/

Source: eid-mw-%{version}-%{revision}.tar.gz
Source1: baselibs.conf
#BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: gtk3-devel
BuildRequires: desktop-file-utils
BuildRequires: p11-kit-devel
BuildRequires: pcsc-lite-devel
Requires(pre): /sbin/service
Requires: eid-mw-bin
Requires: eid-mw-libs
BuildRequires: gcc-c++
BuildRequires: libassuan-devel
BuildRequires: libgpg-error-devel
%if 0%{?suse_version}
Requires: pcsc-ccid
BuildRequires: libopenssl-devel
BuildRequires: libltdl7
BuildRequires: libtool
%else
Requires: ccid
BuildRequires: libtool-ltdl-devel
BuildRequires: openssl-devel
BuildRequires: openssl-perl
%endif
BuildRequires: libcurl-devel
BuildRequires: libproxy-devel
BuildRequires: libxml2-devel
BuildRequires: openssl
Conflicts: openct

%description
The eID Middleware provides the libraries, a PKCS#11 module and a Firefox
plugin to use Belgian eID (electronic identity) card in order to access
websites and/or sign documents.

%package devel
Summary: Belgium electronic identity card PKCS#11 module - development package
Requires: eid-mw

%description devel
The eID Middleware provides the libraries, a PKCS#11 module and a Firefox
plugin to use Belgian eID (electronic identity) card in order to access
websites and/or sign documents. This package contains the files needed
to develop against the eID Middleware.

%package bin
Summary: Belgium electronic identity card PKCS#11 module - helper binaries
Requires: eid-mw
%if 0%{?suse_version}
Requires: mozilla-nss-tools
%else
Requires: nss-tools
%endif

%description bin
The eID Middleware provides the libraries, a PKCS#11 module and a Firefox
plugin to use Belgian eID (electronic identity) card in order to access
websites and/or sign documents. This package contains a few helper
programs needed by the eID Middleware.

%package libs
Summary: Belgium electronic identity card PKCS#11 module - libraries
Conflicts: opensc < 0.26.0

%description libs
The eID Middleware provides the libraries, a PKCS#11 module and a Firefox
plugin to use Belgian eID (electronic identity) card in order to access
websites and/or sign documents. This package contains the actual libraries.

%package -n eid-viewer
Summary: Belgium electronic identity card viewer
Requires: eid-mw
%if 0%{?suse_version}
Requires: pcsc-ccid
%else
Requires: ccid
%endif
Requires: pcsc-lite
Conflicts: openct
Requires: pinentry-gui

%description -n eid-viewer
The eid-viewer application allows the user to read out any information from
a Belgian electronic identity card. Both identity information and information
about the stored cryptographic keys can be read in a user-friendly manner,
and can easily be printed out or stored for later reviewal.

The application verifies the signature of the identity information,
checks whether it was signed by a government-issued key, and optionally
checks the certificate against the government's Trust Service.

%prep
%setup -n eid-mw-%{version}-%{revision}

%build
%configure --enable-p11v220 --enable-webextension
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR="%{buildroot}"
mkdir -p %{buildroot}%{_libdir}/mozilla/
mv %{buildroot}/usr/lib/mozilla/pkcs11-modules %{buildroot}%{_libdir}/mozilla/ || true
mv %{buildroot}/usr/lib/mozilla/managed-storage %{buildroot}%{_libdir}/mozilla/ || true
rm -f %{buildroot}%{_datadir}/applications/eid-viewer.desktop
desktop-file-install --dir %{buildroot}%{_datadir}/applications --vendor fedict plugins_tools/eid-viewer/eid-viewer.desktop || true

%clean
%{__rm} -rf %{buildroot}

%post
/sbin/ldconfig

### Notify user if an action is required for the eID plugin to work.
if /usr/bin/pgrep 'chrome' &>/dev/null; then
    echo "INFO: You may have to restart Chrome for the Belgium eID add-on to work." >&2
fi
if /usr/bin/pgrep 'chromium' &>/dev/null; then
    echo "INFO: You may have to restart Chromium for the Belgium eID add-on to work." >&2
fi
if /usr/bin/pgrep 'firefox' &>/dev/null; then
    echo "INFO: You may have to restart Firefox for the Belgium eID add-on to work." >&2
fi

%postun
/sbin/ldconfig

### Make pcscd reread configuration and rescan USB bus.
if /sbin/service pcscd status &>/dev/null; then
    %{_sbindir}/pcscd -H &>/dev/null || :
fi

%files
%defattr(-, root, root, 0755)
### Include license files
%{_datadir}/mozilla/
%exclude %{_libdir}/*.la

%files libs
%defattr(-, root, root, 0755)
%{_libdir}/libbeidpkcs11.so.*
%{_libdir}/libeidviewer.so.*
%{_libdir}/pkcs11/
%{_datadir}/metainfo/
%exclude %{_datadir}/metainfo/*appdata.xml
%exclude %{_libdir}/libbeidpkcs11.so

%files bin
%defattr(-, root, root, 0755)
%{_bindir}/about-eid-mw
%{_bindir}/beid-update-nssdb
%{_sysconfdir}/xdg/autostart/beid-update-nssdb.desktop
%{_datadir}/locale/*/LC_MESSAGES/about-eid-mw.mo
%{_datadir}/p11-kit/
%{_libdir}/mozilla/

%files devel
%defattr(-, root, root, 0755)
%{_libdir}/libbeidpkcs11.a
%{_libdir}/libbeidpkcs11.so
%{_libdir}/libeidviewer.a
%{_libdir}/libeidviewer.so
%{_libdir}/pkgconfig/
%{_includedir}/beid/
%{_includedir}/eid-viewer/
%{_includedir}/eid-util/

%files -n eid-viewer
%defattr(-,root,root,0755)
%{_bindir}/eid-viewer
%{_datadir}/locale/*/LC_MESSAGES/eid-viewer.mo
%{_datadir}/applications/fedict-eid-viewer.desktop
%{_datadir}/eid-mw/
%{_datadir}/metainfo/
%exclude %{_datadir}/metainfo/*metainfo.xml
%{_datadir}/icons/hicolor/*/*/eid-viewer.png
%{_datadir}/glib-2.0/schemas/

%post -n eid-viewer
[ -x /usr/bin/glib-compile-schemas ] && /usr/bin/glib-compile-schemas /usr/share/glib-2.0/schemas

%changelog
* Fri May 20 2016 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.1.18-0.R
- Update to 4.1.18
- Update the XPI file so we have Firefox' new signature

* Wed May 18 2016 Wouter Verhelst <wouter.verhelst@fedict.be>
- Add libeidviewer stuff

* Thu Feb 18 2016 Wouter Verhelst <wouter.verhelst@fedict.be>
- Add p11-kit linkage

* Thu Aug 06 2015 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.1.5-0.R
- Update to 4.1.5
- Move eid-mw.spec to eid-mw.spec.in, and have it autogenerated by configure

* Fri Jul 17 2015 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.1.4-0.R
- Update to 4.1.4

* Thu Nov 27 2014 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.0.6-0.R
- Install about-eid-mw into the eid-mw-bin package

* Thu Aug 14 2014 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.0.6-0.R
- Split up somewhat further so that openSUSE-style multiarch works, too.

* Thu Jul 31 2014 Wouter Verhelst <wouter.verhelst@fedict.be> - 4.0.6-0.R
- Split package up into several subpackages so as to make multiarch work
  without much issues.

* Tue Oct 15 2013 Frank Marien <frank@apsu.be> - 4.0.6-0.R
- Upgrade to 4.0.6

* Thu May 3 2012 Frank Marien <frank@apsu.be> - 4.0.4-0.R
- Upgrade to 4.0.4

* Wed Mar 14 2012 Frank Marien <frank@apsu.be> - 4.0.2-0.R
- Upgrade to 4.0.2

* Fri Mar 18 2011 Frank Marien <frank@apsu.be> - 4.0.0-0.R
- Made Revision number variable to allow continuous builds.

* Thu Mar 17 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.6
- Split eid-mw and eid-viewer packages.

* Thu Feb 24 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.5
- Added post-install script and desktop file.

* Thu Feb 24 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.4
- Included pre-built JAR files.

* Wed Feb 23 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.3
- Added patched eid-applet core.

* Sun Feb 13 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.2
- Included eid-viewer build using maven.

* Mon Feb  7 2011 Dag Wieers <dag@wieers.com> - 4.0.0-0.1
- Initial package.

