/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.link.HyperLinkCondition;

public class HyperLinkContainsCondition
extends HyperLinkCondition {
    public static final String NAME = "hyper_link_contains";
    private final StringMatchingStrategy stringMatchingStrategy;

    public HyperLinkContainsCondition(String hyperlink, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics) {
        super(hyperlink, matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkLink(Hyperlink nodeLink) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(nodeLink), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_link");
        return this.createDescription(condition, this.containsDescription(), this.getHyperlink());
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String condition = TextUtils.getText("filter_link");
        return this.createRenderedIcons(condition, this.containsOperator(), this.getHyperlink(), fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

