package locales

var dict_ashkenazi = map[string]string{
	"Achrei Mot": "Achrei Mos",
	"Alot HaShachar": "Alos HaShachar",
	"Asara B'Tevet": "Asara B’Teves",
	"Avot": "Avos",
	"Baba Batra": "Baba Basra",
	"Bechorot": "Bechoros",
	"Bechukotai": "Bechukosai",
	"Beha'alotcha": "Beha’aloscha",
	"Bekhorot": "Bekhoros",
	"Berachot": "Berachos",
	"Berakhot": "Berakhos",
	"Bereshit": "Bereshis",
	"Birkat Hachamah": "Birkas Hachamah",
	"Chatzot HaLailah": "Chatzos HaLailah",
	"Chatzot hayom": "Chatzos",
	"Chukat": "Chukas",
	"Eduyot": "Eduyos",
	"Erev Shavuot": "Erev Shavuos",
	"Erev Sukkot": "Erev Sukkos",
	"Horayot": "Horayos",
	"Keritot": "Kerisos",
	"Ketubot": "Kesubos",
	"Ki Tavo": "Ki Savo",
	"Ki Teitzei": "Ki Seitzei",
	"Ki Tisa": "Ki Sisa",
	"Kriat Shema, sof zeman": "Krias Shema, sof zman",
	"Kriat Shema, sof zeman (MGA)": "Krias Shema, sof zman (MGA)",
	"Leil Selichot": "Leil Selichos",
	"Maasrot": "Maasros",
	"Makkot": "Makkos",
	"Matot": "Matos",
	"Menachot": "Menachos",
	"Middot": "Middos",
	"Midot": "Midos",
	"Mikvaot": "Mikvaos",
	"Oholot": "Oholos",
	"Parashat": "Parshas",
	"Purim Katan": "Purim Koton",
	"Shabbat": "Shabbos",
	"Shabbat Chazon": "Shabbos Chazon",
	"Shabbat HaChodesh": "Shabbos HaChodesh",
	"Shabbat HaGadol": "Shabbos HaGadol",
	"Shabbat Mevarchim Chodesh": "Shabbos Mevorchim Chodesh",
	"Shabbat Nachamu": "Shabbos Nachamu",
	"Shabbat Parah": "Shabbos Parah",
	"Shabbat Shekalim": "Shabbos Shekalim",
	"Shabbat Shirah": "Shabbos Shirah",
	"Shabbat Shuva": "Shabbos Shuvah",
	"Shabbat Zachor": "Shabbos Zachor",
	"Shavuot": "Shavuos",
	"Shavuot I": "Shavuos I",
	"Shavuot II": "Shavuos II",
	"Shemot": "Shemos",
	"Sheviit": "Sheviis",
	"Shevuot": "Shevuos",
	"Shmini Atzeret": "Shmini Atzeres",
	"Shushan Purim Katan": "Shushan Purim Koton",
	"Simchat Torah": "Simchas Torah",
	"Sukkot": "Sukkos",
	"Sukkot I": "Sukkos I",
	"Sukkot II": "Sukkos II",
	"Sukkot II (CH''M)": "Sukkos II (CH’’M)",
	"Sukkot III (CH''M)": "Sukkos III (CH’’M)",
	"Sukkot IV (CH''M)": "Sukkos IV (CH’’M)",
	"Sukkot V (CH''M)": "Sukkos V (CH’’M)",
	"Sukkot VI (CH''M)": "Sukkos VI (CH’’M)",
	"Sukkot VII (Hoshana Raba)": "Sukkos VII (Hoshana Raba)",
	"Ta'anit Bechorot": "Ta’anis Bechoros",
	"Ta'anit Esther": "Ta’anis Esther",
	"Taanit": "Taanis",
	"Tahorot": "Tahoros",
	"Tefilah, sof zeman": "Tefilah, sof zman",
	"Tefilah, sof zeman (MGA)": "Tefilah, sof zman (MGA)",
	"Terumot": "Terumos",
	"Tevet": "Teves",
	"Toldot": "Toldos",
	"Tzeit HaKochavim": "Tzeis HaKochavim",
	"Vaetchanan": "Vaeschanan",
	"Vezot Haberakhah": "Vezos Haberakhah",
	"Yevamot": "Yevamos",
	"Yitro": "Yisro",
}

func Lookup_ashkenazi(s string) (string, bool) {
	v, ok := dict_ashkenazi[s]
	if ok {
		return v, true
	}
	return s, false
}
