package locales

var dict_ashkenazi_standard = map[string]string{
	"Achrei Mot": "Achrei",
	"Adar": "Odor",
	"Adar I": "Odor Aleph",
	"Adar II": "Odor Beis",
	"Arachin": "Arochin",
	"Asara B'Tevet": "Asoro Beteyves",
	"Av": "Ov",
	"Avodah Zarah": "Avoydo Zoro",
	"Baba Batra": "Bovo Basro",
	"Baba Kamma": "Bovo Kamo",
	"Baba Metzia": "Bovo Metzio",
	"Balak": "Bolok",
	"Bamidbar": "Bamidbor",
	"Bechorot": "Bchoyros",
	"Bechukotai": "Bechukoysai",
	"Beha'alotcha": "Bahaaloscho",
	"Beitzah": "Beitzo",
	"Berachot": "Brochos",
	"Bereshit": "Breishis",
	"Bo": "Boy",
	"Candle lighting": "Hadlokas neyros",
	"Chagigah": "Chagigo",
	"Chanukah": "Chanukko",
	"Chanukah: 1 Candle": "Chanukko: 1 Candle",
	"Chanukah: 2 Candles": "Chanukko: 2 Candles",
	"Chanukah: 3 Candles": "Chanukko: 3 Candles",
	"Chanukah: 4 Candles": "Chanukko: 4 Candles",
	"Chanukah: 5 Candles": "Chanukko: 5 Candles",
	"Chanukah: 6 Candles": "Chanukko: 6 Candles",
	"Chanukah: 7 Candles": "Chanukko: 7 Candles",
	"Chanukah: 8 Candles": "Chanukko: 8 Candles",
	"Chanukah: 8th Day": "Chanukko: 8th Day",
	"Chayei Sara": "Chayei Soro",
	"Cheshvan": "Cheshvon",
	"Chukat": "Chukas",
	"Daf Yomi": "Daf Yoymi",
	"Days of the Omer": "Oymer",
	"Devarim": "Dvorim",
	"Erev Pesach": "Erev Peisach",
	"Erev Rosh Hashana": "Erev Rosh-Hashono",
	"Erev Shavuot": "Erev Shvuos",
	"Erev Simchat Torah": "Erev Simchas Toyro",
	"Erev Sukkot": "Erev Sukkos",
	"Erev Tish'a B'Av": "Erev Tisho Bov",
	"Eruvin": "Eiruvin",
	"Ha'azinu": "Haazinu",
	"Havdalah": "Havdolo",
	"Horayot": "Hoyroyos",
	"Iyyar": "Iyyor",
	"Kedoshim": "Kdoyshim",
	"Keritot": "Krisos",
	"Ketubot": "Ksubos",
	"Ki Tavo": "Ki-Sovo",
	"Ki Teitzei": "Ki-Seitzei",
	"Ki Tisa": "Ki-Siso",
	"Korach": "Koyrach",
	"Lag BaOmer": "Lag Boymer",
	"Lech-Lecha": "Lech-Lecho",
	"Leil Selichot": "Slichos",
	"Makkot": "Makkos",
	"Matot": "Matos",
	"Megillah": "Megillo",
	"Meilah": "Meilo",
	"Menachot": "Menochos",
	"Metzora": "Metzoyro",
	"Midot": "Midos",
	"Miketz": "Mikeitz",
	"Mishpatim": "Mishpotim",
	"Moed Katan": "Moyed Koton",
	"Nasso": "Nosso",
	"Nazir": "Nozir",
	"Nedarim": "Nedorim",
	"Niddah": "Niddo",
	"Nisan": "Nison",
	"Nitzavim": "Nitzovim",
	"Noach": "Noyach",
	"Parashat": "Parshas",
	"Pekudei": "Pkudey",
	"Pesach": "Peisach",
	"Pesach I": "Peisach I",
	"Pesach II": "Peisach II",
	"Pesach II (CH''M)": "Peisach II (CH''M)",
	"Pesach III (CH''M)": "Peisach III (CH''M)",
	"Pesach IV (CH''M)": "Peisach IV (CH''M)",
	"Pesach Sheni": "Peisach Sheini",
	"Pesach V (CH''M)": "Peisach V (CH''M)",
	"Pesach VI (CH''M)": "Peisach VI (CH''M)",
	"Pesach VII": "Peisach VII",
	"Pesach VIII": "Peisach VIII",
	"Pesachim": "Psochim",
	"Pinchas": "Pinchos",
	"Purim Katan": "Purim Koton",
	"Re'eh": "Reei",
	"Rosh Chodesh": "Rosh Choydesh",
	"Rosh Chodesh %s": "Rosh Choydesh %s",
	"Rosh Hashana": "Rosh Hashono",
	"Rosh Hashana I": "Rosh Hashono I",
	"Rosh Hashana II": "Rosh Hashono II",
	"Sh'lach": "Shlach",
	"Sh'vat": "Shvat",
	"Shabbat": "Shabbos",
	"Shabbat Chazon": "Shabbos Chazon",
	"Shabbat HaChodesh": "Shabbos HaChoydesh",
	"Shabbat HaGadol": "Shabbos HaGodol",
	"Shabbat Machar Chodesh": "Shabbos Mochor Choydesh",
	"Shabbat Nachamu": "Shabbos Nachamu",
	"Shabbat Parah": "Shabbos Poro",
	"Shabbat Rosh Chodesh": "Shabbos Rosh Choydesh",
	"Shabbat Shekalim": "Shabbos Shkolim",
	"Shabbat Shuva": "Shabbos Shuvo",
	"Shabbat Zachor": "Shabbos Zochor",
	"Shavuot": "Shvuos",
	"Shavuot I": "Shvuos I",
	"Shavuot II": "Shvuos II",
	"Shekalim": "Shkolim",
	"Shemot": "Shmoys",
	"Shevuot": "Shvuos",
	"Shmini Atzeret": "Shmini Atzeres",
	"Shushan Purim": "Shushon Purim",
	"Simchat Torah": "Simchas Toyro",
	"Sivan": "Sivon",
	"Sotah": "Soyto",
	"Sukkah": "Sukko",
	"Sukkot": "Sukkos",
	"Sukkot I": "Sukkos I",
	"Sukkot II": "Sukkos II",
	"Sukkot II (CH''M)": "Sukkos II (CH''M)",
	"Sukkot III (CH''M)": "Sukkos III (CH''M)",
	"Sukkot IV (CH''M)": "Sukkos IV (CH''M)",
	"Sukkot V (CH''M)": "Sukkos V (CH''M)",
	"Sukkot VI (CH''M)": "Sukkos VI (CH''M)",
	"Sukkot VII (Hoshana Raba)": "Sukkos VII (Hoyshano Rabo)",
	"Ta'anit Bechorot": "Taanis Bchoros",
	"Ta'anit Esther": "Taanis Ester",
	"Taanit": "Taanis",
	"Tamid": "Tomid",
	"Temurah": "Tmuro",
	"Terumah": "Trumo",
	"Tetzaveh": "Tetzave",
	"Tevet": "Teyves",
	"Tish'a B'Av": "Tisho B'ov",
	"Tish'a B'Av (observed)": "Tisho B'ov (observed)",
	"Toldot": "Toldos",
	"Tu B'Av": "Tu B'ov",
	"Tu B'Shvat": "Tu BiShvat",
	"Tzom Gedaliah": "Tzom Gdalyo",
	"Vaera": "Voeiro",
	"Vaetchanan": "Voeschanan",
	"Vayera": "Vayeiro",
	"Vayeshev": "Vayeishev",
	"Vayetzei": "Vayeitzei",
	"Vayikra": "Vayikro",
	"Vezot Haberakhah": "Zoys Habrocho",
	"Yevamot": "Yevomos",
	"Yitro": "Yisro",
	"Yom Kippur Katan": "Yom Kippur Koton",
	"Yom Yerushalayim": "Yom Yerusholayim",
	"Yoma": "Yumo",
	"Zevachim": "Zvochim",
}

func Lookup_ashkenazi_standard(s string) (string, bool) {
	v, ok := dict_ashkenazi_standard[s]
	if ok {
		return v, true
	}
	return s, false
}
