package locales

var dict_pl = map[string]string{
	"Achrei Mot": "Achare Mot",
	"Beha'alotcha": "Behaalotcha",
	"Bereshit": "Bereszit",
	"Beshalach": "Beszalach",
	"Candle lighting": "Zapalenie świec",
	"Chanukah": "Chanuka",
	"Chanukah: 1 Candle": "Chanuka: Pierwsza świeca",
	"Chanukah: 2 Candles": "Chanuka: Druga świeca",
	"Chanukah: 3 Candles": "Chanuka: Trzecia świeca",
	"Chanukah: 4 Candles": "Chanuka: Czwarta świeca",
	"Chanukah: 5 Candles": "Chanuka: Piąta świeca",
	"Chanukah: 6 Candles": "Chanuka: Szósta świeca",
	"Chanukah: 7 Candles": "Chanuka: Siódma świeca",
	"Chanukah: 8 Candles": "Chanuka: Ósma świeca",
	"Chanukah: 8th Day": "Chanuka: Dzień ósmy",
	"Chayei Sara": "Chaje Sara",
	"Days of the Omer": "Dni Omeru",
	"Devarim": "Dewarim",
	"Eikev": "Ekew",
	"Erev Pesach": "Erew Pesach",
	"Erev Purim": "Erew Purim",
	"Erev Rosh Hashana": "Erew Rosz Haszana",
	"Erev Shavuot": "Erew Szawuot",
	"Erev Simchat Torah": "Erew Simchat Tora",
	"Erev Sukkot": "Erew Sukkot",
	"Erev Yom Kippur": "Erew Jom Kippur",
	"Eruvin": "Eruwin",
	"Fast begins": "Czczo zaczyna",
	"Fast ends": "Czczo końce",
	"Ha'azinu": "Haazinu",
	"Havdalah": "Hawdala",
	"Kedoshim": "Kedoszim",
	"Ki Tavo": "Ki Tawo",
	"Ki Teitzei": "Ki Tece",
	"Kiddushin": "Kidduszin",
	"Lech-Lecha": "Lech Lecha",
	"Masei": "Mase",
	"Megillah": "Megilla",
	"Metzora": "Mecora",
	"Miketz": "Mikec",
	"Mishpatim": "Miszpatim",
	"Nasso": "Naso",
	"Nitzavim": "Nicawim",
	"Parashat": "Parsza",
	"Pekudei": "Pekude",
	"Re'eh": "Ree",
	"Rosh Chodesh": "Rosz Chodesz",
	"Rosh Chodesh %s": "Rosz Chodesz %s",
	"Rosh Hashana": "rosz Haszana",
	"Rosh Hashana I": "Rosz Haszana I",
	"Rosh Hashana II": "Rosz Haszana II",
	"Sh'lach": "Szelach",
	"Shabbat": "Szabbat",
	"Shabbat Chazon": "Szabbat Chazon",
	"Shabbat HaChodesh": "Szabbat HaChodesz",
	"Shabbat HaGadol": "Szabbat HaGadol",
	"Shabbat Machar Chodesh": "Szabbat Machar Chodesz",
	"Shabbat Nachamu": "Szabbat Nachamu",
	"Shabbat Parah": "Szabbat Parah",
	"Shabbat Rosh Chodesh": "Szabbat Rosz Chodesz",
	"Shabbat Shekalim": "Szabbat Szekalim",
	"Shabbat Shuva": "Szabbat Szuva",
	"Shabbat Zachor": "Szabbat Zachor",
	"Shavuot": "Szawuot",
	"Shavuot I": "Szawuot I",
	"Shavuot II": "Szawuot II",
	"Shekalim": "Szekalim",
	"Shemot": "Szemot",
	"Shevuot": "Szewuot",
	"Shmini": "Szemini",
	"Shmini Atzeret": "Szmini Aceret",
	"Shoftim": "Szoftim",
	"Shushan Purim": "Szuszan Purim",
	"Sukkot VII (Hoshana Raba)": "Sukkot VII (Hoszana Raba)",
	"Ta'anit Bechorot": "Post Bechorot",
	"Ta'anit Esther": "Post Esther",
	"Tazria": "Tazrija",
	"Terumah": "Teruma",
	"Tetzaveh": "Tecawe",
	"Tzav": "Caw",
	"Vaera": "Waera",
	"Vaetchanan": "Waetchanan",
	"Vayakhel": "Waejlech",
	"Vayechi": "Wajechi",
	"Vayeilech": "Waejlech",
	"Vayera": "Wajera",
	"Vayeshev": "Wajeszew",
	"Vayetzei": "Wajece",
	"Vayigash": "Wajigasz",
	"Vayikra": "Wajikra",
	"Vayishlach": "Waiszlach",
	"Vezot Haberakhah": "Wezor Habracha",
	"Yitro": "Jitro",
	"Yom HaAtzma'ut": "Jom HaAtzma'ut",
	"Yom HaShoah": "Jom HaShoah",
	"Yom HaZikaron": "Jom HaZikaron",
	"Yom Kippur": "Jom Kippur",
	"Yom Yerushalayim": "Jom Yerushalayim",
	"Yoma": "Joma",
	"day": "dzień",
	"min": "minut",
}

func Lookup_pl(s string) (string, bool) {
	v, ok := dict_pl[s]
	if ok {
		return v, true
	}
	return s, false
}
