package locales

var dict_pt = map[string]string{
	"Achrei Mot": "Acharei Mot",
	"Asara B'Tevet": "Asara b'Tevet",
	"Avodah Zarah": "Avodá Zará",
	"Baba Kamma": "Baba Kama",
	"Beha'alotcha": "Behaalotecha",
	"Beitzah": "Beitzá",
	"Berachot": "Brachot",
	"Candle lighting": "Acendimento das Velas",
	"Chagigah": "Chaguigá",
	"Chanukah": "Chanucá",
	"Chanukah: 1 Candle": "Chanucá: 1 vela",
	"Chanukah: 2 Candles": "Chanucá: 2 velas",
	"Chanukah: 3 Candles": "Chanucá: 3 velas",
	"Chanukah: 4 Candles": "Chanucá: 4 velas",
	"Chanukah: 5 Candles": "Chanucá: 5 velas",
	"Chanukah: 6 Candles": "Chanucá: 6 velas",
	"Chanukah: 7 Candles": "Chanucá: 7 velas",
	"Chanukah: 8 Candles": "Chanucá: 8 velas",
	"Chanukah: 8th Day": "Chanucá: 8º día",
	"Chullin": "Chulin",
	"Date out of range in input file. Skipping line %s": "Data fora do intervalo no arquivo de entrada. Pulando a linha %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Data fora do intervalo no arquivo yahrtzeit. Pulando linha %s",
	"Days of the Omer": "Os dias do Omer",
	"Erev Pesach": "Véspera de Pesach",
	"Erev Purim": "Véspera de Purim",
	"Erev Rosh Hashana": "Véspera de Rosh Hashana",
	"Erev Shavuot": "Véspera de Shavuot",
	"Erev Simchat Torah": "Véspera de Simchá Torá",
	"Erev Sukkot": "Véspera de Sukot",
	"Erev Tish'a B'Av": "Véspera de Tishá b'Av",
	"Erev Yom Kippur": "Véspera de Yom Kipur",
	"Error in input file.  Skipping line %s": "erro de leitura do arquivo de entrada. Ignorando linha %s",
	"Error in yahrtzeit file.  Skipping line %s": "Erro de leitura do arquivo yahrtzeit. Ignorando a linha %s",
	"Fast begins": "O jejum começa",
	"Fast ends": "O jejum termina",
	"Gitin": "Guitin",
	"Ha'azinu": "Haazinu",
	"Havdalah": "Havdalá",
	"Iyyar": "Iyar",
	"Kiddushin": "Kedushin",
	"Kinnim": "Kinim",
	"Lag BaOmer": "Lag baOmer",
	"Lech-Lecha": "Lech Lecha",
	"Makkot": "Makot",
	"Megillah": "Megilá",
	"Meilah": "Meilá",
	"Nasso": "Naso",
	"Niddah": "Nidá",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Mês não numérico no arquivo yahrtzeit. Pulando a linha %s",
	"Numeric hebrew month in input file.  Skipping line %s": "Mês numérico hebraico no arquivo de entrada. Ignorando a linha %s",
	"Parashat": "Parashá",
	"Pesach Chol ha-Moed Day 1": "Chol ha-Moed Pesach Dia 1",
	"Pesach Chol ha-Moed Day 2": "Chol ha-Moed Pesach Dia 2",
	"Pesach Chol ha-Moed Day 3": "Chol ha-Moed Pesach Dia 3",
	"Pesach Chol ha-Moed Day 4": "Chol ha-Moed Pesach Dia 4",
	"Pesach I (on Shabbat)": "Pesach I (no Shabat)",
	"Pesach II (CH''M)": "Pesach II (Chol haMoed)",
	"Pesach III (CH''M)": "Pesach III (Chol haMoed)",
	"Pesach IV (CH''M)": "Pesach IV (Chol haMoed)",
	"Pesach Shabbat Chol ha-Moed": "Shabat Chol ha-Moed Pesach",
	"Pesach V (CH''M)": "Pesach V (Chol haMoed)",
	"Pesach VI (CH''M)": "Pesach VI (Chol haMoed)",
	"Re'eh": "Ree",
	"Rosh Chodesh Iyyar": "Rosh Chodesh Iyar",
	"Rosh Chodesh Sh'vat": "Rosh Chodesh Shvat",
	"Rosh Hashana I": "Rosh haShaná I",
	"Rosh Hashana I (on Shabbat)": "Rosh haShaná I (no Shabat)",
	"Rosh Hashana II": "Rosh haShaná II",
	"Sanhedrin": "Sanedrin",
	"Sh'lach": "Shlach",
	"Sh'vat": "Shvat",
	"Shabbat": "Shabat",
	"Shabbat Chazon": "Shabat Chazon",
	"Shabbat HaChodesh": "Shabat haChodesh",
	"Shabbat HaGadol": "Shabat haGadol",
	"Shabbat Machar Chodesh": "Shabat Machar Chodesh",
	"Shabbat Nachamu": "Shabat Nachamu",
	"Shabbat Parah": "Shabat Pará",
	"Shabbat Rosh Chodesh": "Shabat Rosh Chodesh",
	"Shabbat Shekalim": "Shabat Shekalim",
	"Shabbat Shuva": "Shabat Shuva",
	"Shabbat Zachor": "Shabat Zachor",
	"Shabbat times for": "Horários de Shabat para",
	"Shavuot II (on Shabbat)": "Shavuot II (no Shabat)",
	"Shevuot": "Shavuot",
	"Simchat Torah": "Simchat Torá",
	"Sotah": "Sotá",
	"Sukkah": "Sucá",
	"Sukkot": "Sukot",
	"Sukkot Chol ha-Moed Day 1": "Chol ha-Moed Sukot Dia 1",
	"Sukkot Chol ha-Moed Day 2": "Chol ha-Moed Sukot Dia 2",
	"Sukkot Chol ha-Moed Day 3": "Chol ha-Moed Sukot Dia 3",
	"Sukkot Chol ha-Moed Day 4": "Chol ha-Moed Sukot Dia 4",
	"Sukkot Final Day (Hoshana Raba)": "Dia final de Sukot (Hoshana Raba)",
	"Sukkot I": "Sukot I",
	"Sukkot I (on Shabbat)": "Sukot I (no Shabat)",
	"Sukkot II": "Sukot II",
	"Sukkot II (CH''M)": "Sukot II (Chol haMoed)",
	"Sukkot III (CH''M)": "Sukot III (Chol haMoed)",
	"Sukkot IV (CH''M)": "Sukot IV (Chol haMoed)",
	"Sukkot Shabbat Chol ha-Moed": "Shabat Chol ha-Moed Sukot",
	"Sukkot V (CH''M)": "Sukot V (Chol haMoed)",
	"Sukkot VI (CH''M)": "Sukot VI (Chol haMoed)",
	"Sukkot VII (Hoshana Raba)": "Sukot VII (Hoshana Raba)",
	"Ta'anit Bechorot": "Taanit Bechorot",
	"Ta'anit Esther": "Taanit Ester",
	"Taanit": "Tanit",
	"Temurah": "Temurá",
	"Terumah": "Terumá",
	"Tetzaveh": "Tetzave",
	"This week's Torah portion is": "A porção da Torá desta semana é",
	"Tish'a B'Av": "Tishá b'Av",
	"Tish'a B'Av (observed)": "Tishá b'Av (observado)",
	"Tu B'Av": "Tu b'Av",
	"Tu B'Shvat": "Tu BiShvat",
	"Tzom Gedaliah": "Tzom Guedaliá",
	"Tzom Tammuz": "Tzom Tamuz",
	"Unable to allocate memory for holiday.": "Não é possível alocar memória para feriados",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Mês hebraico não reconhecido no arquivo de entrada. Pulando linha %s",
	"Vayakhel": "Vaiakel",
	"Vayeilech": "Vayelech",
	"Vayetzei": "Vayetze",
	"Vayishlach": "Vaishlach",
	"Vezot Haberakhah": "Vezot haBracha",
	"Yom HaAliyah": "Dia da Imigração",
	"Yom HaAtzma'ut": "Dia da Independência Sionista",
	"Yom HaShoah": "Dia da Lembrança do Holocausto",
	"Yom HaZikaron": "Dia da Memória dos Soldados Sionistas Caídos",
	"Yom Kippur": "Yom Kipur",
	"Yom Kippur (Mincha, Alternate)": "Yom Kippur (Minch, Alterno)",
	"Yom Kippur (Mincha, Traditional)": "Yom Kipur (Minch, Tradicional)",
	"Yom Kippur (on Shabbat)": "Yom Kipur (no Shabat)",
	"Yom Kippur Katan": "Yom Kipur Katan",
	"Yom Yerushalayim": "Dia da Reunificação Sionista de Jerusalém",
	"day": "dia",
	"day of the Omer": "Dia do Omer",
	"improper sedra year type calculated.": "tipo de ano de sedra impróprio calculado",
	"input file read error. Skipping line %s": "erro de leitura do arquivo de entrada. Ignorando linha %s",
	"occurs on": "ocorre na",
	"on": "é na",
	"yahrtzeit file read error. Skipping line %s": "Erro de leitura do arquivo yahrtzeit. Ignorando a linha %s",
}

func Lookup_pt(s string) (string, bool) {
	v, ok := dict_pt[s]
	if ok {
		return v, true
	}
	return s, false
}
