package locales

var dict_uk = map[string]string{
	"Achrei Mot": "Ахарей Мот",
	"Adar": "Адар",
	"Adar I": "Адар I",
	"Adar II": "Адар II",
	"Arachin": "Арахін",
	"Asara B'Tevet": "Піст 10го Тевета",
	"Av": "Ав",
	"Avodah Zarah": "Авода зара",
	"Baba Batra": "Баба Батра",
	"Baba Kamma": "Баба Кама",
	"Baba Metzia": "Баба Меціа",
	"Balak": "Балак",
	"Bamidbar": "Бамідбар",
	"Bechorot": "Бехорот",
	"Bechukotai": "Бехукотай",
	"Beha'alotcha": "Вегаалотха",
	"Behar": "Бе-ар",
	"Beitzah": "Яйце",
	"Berachot": "Благословення",
	"Bereshit": "Берешіт",
	"Beshalach": "Бешалах",
	"Bo": "Бо",
	"Candle lighting": "Засвічування свічок",
	"Chagigah": "Хагіга",
	"Chanukah": "Ханука",
	"Chanukah: 1 Candle": "Ханука: 1 Свічка",
	"Chanukah: 2 Candles": "Ханука: 2 Свічки",
	"Chanukah: 3 Candles": "Ханука: 3 Свічки",
	"Chanukah: 4 Candles": "Ханука: 4 Свічки",
	"Chanukah: 5 Candles": "Ханука: 5 Свічок",
	"Chanukah: 6 Candles": "Ханука: 6 Свічок",
	"Chanukah: 7 Candles": "Ханука: 7 Свічок",
	"Chanukah: 8 Candles": "Ханука: 8 Свічок",
	"Chanukah: 8th Day": "Ханука: 8-ий День",
	"Chayei Sara": "Хаей Сара",
	"Cheshvan": "Хешван",
	"Chukat": "Хукат",
	"Chullin": "Хулін",
	"Daf Yomi": "Сторінка Дня",
	"Days of the Omer": "Дні Омера",
	"Devarim": "Дварім",
	"Eikev": "Єйкев",
	"Elul": "Елул",
	"Emor": "Емор",
	"Erev Pesach": "Вечір Песаха",
	"Erev Purim": "Вечір Пурім",
	"Erev Rosh Hashana": "Вечір Рош-А-Шана",
	"Erev Shavuot": "Вечір Шавуота",
	"Erev Simchat Torah": "Вечір Сімхат Тора",
	"Erev Sukkot": "Вечір Суккота",
	"Erev Tish'a B'Av": "Вечір Дев'ятого Ава",
	"Erev Yom Kippur": "Вечір Дня Розкаяння",
	"Eruvin": "Эрувін",
	"Fast begins": "Піст розпочинається",
	"Fast ends": "Піст завершується",
	"Gitin": "Гітін",
	"Ha'azinu": "А-Азіну",
	"Havdalah": "Авдала",
	"Horayot": "Орайот",
	"Iyyar": "Іяр",
	"Kedoshim": "Кдошім",
	"Keritot": "Керітот",
	"Ketubot": "Ктубот",
	"Ki Tavo": "Кі Таво",
	"Ki Teitzei": "Кі Теце",
	"Ki Tisa": "Кі Тіса",
	"Kiddushin": "Кідушін",
	"Kinnim": "Кінім",
	"Kislev": "Кіслев",
	"Korach": "Корах",
	"Lag BaOmer": "Лаг Ба Омер",
	"Lech-Lecha": "Лех-Леха",
	"Leil Selichot": "Нічь сліхот",
	"Makkot": "Макот",
	"Masei": "Масей",
	"Matot": "Матот",
	"Megillah": "Сувій",
	"Meilah": "Меіла",
	"Menachot": "Менахот",
	"Metzora": "Мецора",
	"Midot": "Мідот",
	"Miketz": "Мікец",
	"Mishpatim": "Мішпатім",
	"Moed Katan": "Моед Катан",
	"Nasso": "Насо",
	"Nazir": "Назір",
	"Nedarim": "Недарім",
	"Niddah": "Ніда",
	"Nisan": "Нісан",
	"Nitzavim": "Ніцавім",
	"Noach": "Ноах",
	"Parashat": "Розділ",
	"Pekudei": "Пкудей",
	"Pesach": "Песах",
	"Pesach I": "Песах I",
	"Pesach II": "Песах II",
	"Pesach II (CH''M)": "Другий день Песах, Холь Амоєд",
	"Pesach III (CH''M)": "Третій день Песах, Холь Амоєд",
	"Pesach IV (CH''M)": "Четвертий день Песах, Холь Амоєд",
	"Pesach Sheni": "Вторий Песах",
	"Pesach V (CH''M)": "Пятый день Песах, Холь Амоєд",
	"Pesach VI (CH''M)": "Шостий день Песах, Холь Амоєд",
	"Pesach VII": "Сьомий день Песах",
	"Pesach VIII": "Восьмий день Песах",
	"Pesachim": "Песахім",
	"Pinchas": "Пінхас",
	"Purim": "Пурім",
	"Purim Katan": "Малий Пурім",
	"Re'eh": "Ре-ех",
	"Rosh Chodesh": "Новий Місяць",
	"Rosh Chodesh %s": "Новий Місяць %s",
	"Rosh Hashana": "Рош-А-Шана",
	"Rosh Hashana I": "Рош-А-Шана I",
	"Rosh Hashana II": "Рош-А-Шана II",
	"Sanhedrin": "Сангедрін",
	"Sh'lach": "Шлах",
	"Sh'vat": "Шват",
	"Shabbat": "Шаббат",
	"Shabbat Chazon": "Шаббат Хазон",
	"Shabbat HaChodesh": "Шаббат Місяця",
	"Shabbat HaGadol": "Великий Шаббат",
	"Shabbat Machar Chodesh": "Шаббат Перед Новим місяцем",
	"Shabbat Mevarchim Chodesh": "Шаббат мевархім Новим місяцем",
	"Shabbat Nachamu": "Шаббат Нахаму",
	"Shabbat Parah": "Шаббат Пара",
	"Shabbat Rosh Chodesh": "Шаббат Нового місяця",
	"Shabbat Shekalim": "Шаббат Шкалім",
	"Shabbat Shuva": "Шаббат Шува",
	"Shabbat Zachor": "Шаббат Захор",
	"Shavuot": "Шавуот",
	"Shavuot I": "Шавуот I",
	"Shavuot II": "Шавуот II",
	"Shekalim": "Шкалім",
	"Shemot": "Шмот",
	"Shevuot": "Швуот",
	"Shmini": "Шміні",
	"Shmini Atzeret": "Шміні Ацерет",
	"Shoftim": "Шофтім",
	"Shushan Purim": "Шушан Пурім",
	"Sigd": "Сігд",
	"Simchat Torah": "Сімхат Тора",
	"Sivan": "Сіван",
	"Sotah": "Сота",
	"Sukkah": "Сукка",
	"Sukkot": "Суккот",
	"Sukkot I": "Суккот I",
	"Sukkot II": "Суккот II",
	"Sukkot II (CH''M)": "Другий день Суккота (Холь Амоєд)",
	"Sukkot III (CH''M)": "Третій день Суккота (Холь Амоєд)",
	"Sukkot IV (CH''M)": "Четвертий день Суккота (Холь Амоєд)",
	"Sukkot V (CH''M)": "П'ятий день Суккота (Холь Амоєд)",
	"Sukkot VI (CH''M)": "Шостий день Суккота (Холь Амоєд)",
	"Sukkot VII (Hoshana Raba)": "Сьомий день Суккота (Ошана Раба)",
	"Ta'anit Bechorot": "Піст Первісток",
	"Ta'anit Esther": "Піст Естер",
	"Taanit": "Піст",
	"Tamid": "Тамід",
	"Tamuz": "Тамуз",
	"Tazria": "Тазріа",
	"Temurah": "Тмура",
	"Terumah": "Трума",
	"Tetzaveh": "Тецаве",
	"Tevet": "Тевет",
	"Tish'a B'Av": "Д'евяте Ава",
	"Tish'a B'Av (observed)": "Дев'яте Ава (святкується)",
	"Tishrei": "Тішрей",
	"Toldot": "Толдот",
	"Tu B'Av": "П'ятнадцате Ава",
	"Tu B'Shvat": "П'ятнадцате Швата",
	"Tu BiShvat": "П'ятнадцате Швата",
	"Tzav": "Цав",
	"Tzom Gedaliah": "Піст Гедальї",
	"Tzom Tammuz": "Піст Тамуза",
	"Vaera": "Ваєра",
	"Vaetchanan": "Ваетханан",
	"Vayakhel": "Ваякгель",
	"Vayechi": "Ваєхі",
	"Vayeilech": "Ваєлех",
	"Vayera": "Ваєра",
	"Vayeshev": "Ваєшев",
	"Vayetzei": "Ваєце",
	"Vayigash": "Ваїгаш",
	"Vayikra": "Ваїкра",
	"Vayishlach": "Ваїшлах",
	"Vezot Haberakhah": "Вєзот Габерахах",
	"Yevamot": "Євамот",
	"Yitro": "Їтро",
	"Yom HaAtzma'ut": "День Незалежності Ізраіля",
	"Yom HaShoah": "День Катастрофи",
	"Yom HaZikaron": "День Пам'яті",
	"Yom Kippur": "День Розкаяння",
	"Yom Kippur Katan": "День Розкаяння Катан",
	"Yom Yerushalayim": "День Єрусалима",
	"Yoma": "Йома",
	"Zevachim": "Євахім",
	"day": "день",
	"min": "мін.",
}

func Lookup_uk(s string) (string, bool) {
	v, ok := dict_uk[s]
	if ok {
		return v, true
	}
	return s, false
}
