// This file is part of Heimer.
// Copyright (C) 2020 Jussi Lind <jussi.lind@iki.fi>
//
// Heimer is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// Heimer is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Heimer. If not, see <http://www.gnu.org/licenses/>.

#ifndef SVG_EXPORT_DIALOG_HPP
#define SVG_EXPORT_DIALOG_HPP

#include <QDialog>

class ExportParams;
class QCheckBox;
class QDialogButtonBox;
class QLineEdit;
class QProgressBar;
class QPushButton;
class QSpinBox;

namespace Dialogs::Export {

class SvgExportDialog : public QDialog
{
    Q_OBJECT

public:
    //! Constructor.
    explicit SvgExportDialog(QWidget & parent);

    void setCurrentMindMapFileName(QString fileName);

    int exec() override;

public slots:

    void finishExport(bool success);

signals:

    void svgExportRequested(const ExportParams & exportParams);

private slots:

    void validate();

private:
    void initWidgets();

    QLineEdit * m_fileNameLineEdit = nullptr;

    QPushButton * m_fileNameButton = nullptr;

    QDialogButtonBox * m_buttonBox = nullptr;

    QProgressBar * m_progressBar = nullptr;

    QString m_fileNameWithExtension;
};

} // namespace Dialogs::Export

#endif // SVG_EXPORT_DIALOG_HPP
