/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.BitmapRec;
import com.pt.awt.font.CMap;
import com.pt.awt.font.CMapRec;
import com.pt.awt.font.CMapUTF16BE;
import com.pt.awt.font.CacheBitmap;
import com.pt.awt.font.CacheGlyph;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.GlyphRec;
import com.pt.awt.font.NFontManager;
import com.pt.awt.font.NFontSfnt;
import com.pt.awt.font.NFontSimple;
import com.pt.awt.font.SfntDirectory;
import com.pt.io.Rez;
import com.pt.lang.Mac;
import com.pt.lang.UnicodeBlock;
import com.pt.lang.UnicodeBlocks;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public class NFontTrueType
extends NFontSfnt
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    public static final String FORMAT = "TrueType";
    public static final String SUBFORMAT_BITMAP = "bitmap";
    public static final String SUBFORMAT_DFONT = "dfont";
    public static final String SUBFORMAT_TTC = "TTC";
    public static final int PID_UNICODE = 0;
    public static final int PID_MACINTOSH = 1;
    public static final int PID_MICROSOFT = 3;
    public static final int PID_CUSTOM = 4;
    private static final String[] MAP_MAC_STANDARD;
    private static final Encoding ENCODING_MAC_STANDARD;
    private static final int CKSUMADJ_OFFSET = 8;
    private static final int[] TAGS_KNOWN;
    private static final int[] TAGS_NO_GLYF;
    private static final UnicodeBlocks MAC_LATIN;
    private static final UnicodeBlocks[] BLOCKS_MAC_LATIN;
    private NFontTrueType[] urs_;
    private long[] ttfoffset_;
    NFontTrueType ur_;
    private String subformat_;
    private boolean fdfont_;
    private int maxGlyph_;
    private int glyphcnt_;
    private int indexToLocFormat_;
    private int[] loca_;
    private String[] names_;
    private CMapRec[] cmaps_;
    private UnicodeBlocks[] blocks_;
    private boolean[] subset_;
    CMap c2g_;
    private float FUnit_;
    private int macStyle_;
    private int rights_;
    private int hint_ = -1;
    private float ascent_;
    private float descent_;
    private float lineGap_;
    protected float[] widths_;
    private GlyphRec notdef_ = null;
    private int flags_;
    private int weight_;
    private int spacech_ = Integer.MIN_VALUE;
    private String name_;
    private String family_;
    private AffineTransform u_;
    private CacheGlyph gc_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontTrueType(URL uRL) throws FontFormatException, IOException {
        super(uRL);
    }

    public NFontTrueType(URL uRL, byte[] byArray) throws FontFormatException, IOException {
        super(uRL, byArray);
    }

    public NFontTrueType deriveFont(float f) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(f);
        nFontTrueType.u_ = new AffineTransform(this.m_);
        nFontTrueType.u_.scale(f, f);
        nFontTrueType.u_.concatenate(nFontTrueType.at_);
        return nFontTrueType;
    }

    public NFontTrueType deriveFont(AffineTransform affineTransform) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(affineTransform);
        nFontTrueType.u_ = new AffineTransform(this.m_);
        nFontTrueType.u_.concatenate(affineTransform);
        nFontTrueType.u_.scale(nFontTrueType.size_, nFontTrueType.size_);
        return nFontTrueType;
    }

    public NFontTrueType deriveFont(Encoding encoding, CMap cMap) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(encoding, cMap);
        CMap cMap2 = null;
        if (encoding == null) {
            cMap2 = this.getCMap(1, 0);
            if (cMap2 == null) {
                cMap2 = this.ur_.c2g_;
            }
        } else if (Encoding.UNICODE == encoding) {
            cMap2 = this.ur_.c2g_;
        } else if (Encoding.MAC_ROMAN == encoding) {
            cMap2 = this.getCMap(1, 0);
        } else if (Encoding.IDENTITY == encoding) {
            cMap2 = CMap.IDENTITY;
        } else if (Encoding.SYMBOL == encoding) {
            cMap2 = this.getCMap(3, 0);
        }
        if (cMap2 == null) {
            this.readPostTable();
            if (this.intrinsic_ != null) {
                cMap2 = encoding.mapTo(this.intrinsic_);
            } else if (this.ur_.c2g_ == null) {
                cMap2 = CMap.IDENTITY;
            } else {
                char[] cArray = CMap.createBlankPage();
                for (int i = 0; i < 256; ++i) {
                    String string = encoding.getName((char)i);
                    char c = Encoding.UNICODE.getChar(string);
                    cArray[i] = this.ur_.c2g_.toSelector(c);
                }
                cMap2 = new CMap(cArray);
            }
        }
        nFontTrueType.setCID(cMap2, nFontTrueType.touni_);
        return nFontTrueType;
    }

    public NFontTrueType deriveFont(CMap cMap, CMap cMap2) {
        NFontTrueType nFontTrueType = null;
        try {
            nFontTrueType = (NFontTrueType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nFontTrueType.setCID(cMap, cMap2);
        return nFontTrueType;
    }

    private void setCID(CMap cMap, CMap cMap2) {
        this.c2g_ = cMap != null ? cMap : this.ur_.c2g_;
        this.touni_ = cMap2 != null ? cMap2 : CMap.IDENTITY;
        this.spacech_ = Integer.MIN_VALUE;
    }

    public NFontTrueType deriveFont(boolean[] blArray) {
        NFontTrueType nFontTrueType = null;
        try {
            nFontTrueType = (NFontTrueType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nFontTrueType.subset_ = (boolean[])blArray.clone();
        return nFontTrueType;
    }

    float readFWord() {
        return (float)this.readInt16() * this.FUnit_;
    }

    float readUFWord() {
        return (float)this.readUint16() * this.FUnit_;
    }

    void parseFile() throws FontFormatException, IOException {
        this.subformat_ = "none";
        this.loca_ = null;
        boolean bl = this.fdfont_ = this.checkDfont();
        this.raoff_ = this.ra_.getFilePointer();
        this.subset_ = null;
        super.parseFile();
        if (!bl) {
            bl = this.checkTTC();
        }
        if (!bl) {
            this.ttfoffset_ = new long[]{0L};
        }
        this.urs_ = new NFontTrueType[this.ttfoffset_.length];
        this.urs_[0] = this.ur_ = this;
        this.raoff_ = this.ttfoffset_[0];
    }

    private boolean checkDfont() throws IOException {
        long l = this.ra_.getFilePointer();
        this.data_ = this.readRaw(l, 16);
        this.offset_ = 0;
        long l2 = this.readUint32();
        if (l2 != 256L) {
            this.ra_.seek(l);
            return false;
        }
        Rez rez = null;
        try {
            rez = new Rez(this.ra_, l);
        }
        catch (IOException iOException) {
            this.ra_.seek(l);
            return false;
        }
        long[] lArray = rez.getResources(Mac.intTag("sfnt"));
        int n = lArray.length / 2;
        if (n == 0) {
            return false;
        }
        this.ttfoffset_ = new long[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.ttfoffset_[n2] = lArray[n3];
            ++n2;
            n3 += 2;
        }
        this.subformat_ = SUBFORMAT_DFONT;
        this.ra_.seek(this.ttfoffset_[0]);
        return true;
    }

    private boolean checkTTC() throws IOException {
        if (TAG_TTCF != this.version_) {
            return false;
        }
        float f = this.readFixed();
        int n = (int)this.readUint32();
        this.data_ = this.readRaw(this.raoff_, 12 + n * 4);
        this.offset_ = 12;
        this.ttfoffset_ = new long[n];
        for (int i = 0; i < n; ++i) {
            this.ttfoffset_[i] = this.readUint32();
        }
        this.subformat_ = SUBFORMAT_TTC;
        return true;
    }

    void parse() throws FontFormatException, IOException {
        Encoding encoding;
        boolean bl;
        super.parse();
        this.readMaxpTable();
        this.readNameTable();
        boolean bl2 = bl = this.getTable(1751474532).length >= 54;
        if (bl) {
            this.readHeadTable();
            this.readMetricsTables();
        } else {
            this.widths_ = new float[0];
        }
        this.flags_ = this.computeFlags();
        this.readCMapTable();
        CMap cMap = CMap.IDENTITY;
        CMap cMap2 = this.getCMap(0, 4);
        if (cMap2 != null) {
            encoding = Encoding.UNICODE;
        } else {
            cMap2 = this.getCMap(3, 10);
            if (cMap2 != null) {
                encoding = Encoding.WIN_ANSI;
            } else {
                cMap2 = this.getCMap(3, 1);
                if (cMap2 != null) {
                    encoding = Encoding.WIN_ANSI;
                } else {
                    cMap2 = this.getCMap(0, 3);
                    if (cMap2 != null) {
                        encoding = Encoding.UNICODE;
                    } else {
                        cMap2 = this.getCMap(0, 1);
                        if (cMap2 != null) {
                            encoding = Encoding.UNICODE;
                        } else {
                            cMap2 = this.getCMap(0, 0);
                            if (cMap2 != null) {
                                encoding = Encoding.UNICODE;
                            } else {
                                cMap2 = this.getCMap(3, 0);
                                if (cMap2 != null) {
                                    encoding = Encoding.UNICODE;
                                    cMap = encoding.guessToUnicode();
                                    this.flags_ |= 4;
                                } else {
                                    cMap2 = this.getCMap(1, 0);
                                    if (cMap2 != null) {
                                        encoding = Encoding.MAC_ROMAN;
                                        cMap = encoding.guessToUnicode();
                                    } else {
                                        cMap2 = this.getCMap(-1, -1);
                                        if (cMap2 != null) {
                                            encoding = Encoding.IDENTITY;
                                        } else {
                                            cMap2 = CMap.IDENTITY;
                                            encoding = Encoding.IDENTITY;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.blocks_ = Encoding.UNICODE == encoding || Encoding.WIN_ANSI == encoding ? NFontManager.createMasks(cMap2) : (Encoding.MAC_ROMAN == encoding ? BLOCKS_MAC_LATIN : MASKS_NONE);
        this.setCID(cMap2, cMap);
        this.encoding_ = encoding;
        if (bl) {
            this.u_ = this.m_ = new AffineTransform((double)this.FUnit_, 0.0, 0.0, (double)(-this.FUnit_), 0.0, 0.0);
            this.gc_ = new CacheGlyph(this, this.m_);
        } else {
            this.subformat_ = SUBFORMAT_BITMAP;
            this.hint_ = 0;
            this.m_ = this.u_ = new AffineTransform();
        }
    }

    private int computeFlags() {
        float f;
        int n;
        int n2 = 0;
        float f2 = 0.0f;
        Object object = this.widths_;
        int n3 = ((float[])object).length;
        for (n = 0; n < n3; ++n) {
            f = object[n];
            if (f == 0.0f) continue;
            f2 = f;
            break;
        }
        object = this.widths_;
        n3 = ((float[])object).length;
        for (n = 0; n < n3; ++n) {
            f = object[n];
            if (f == 0.0f || !(Math.abs(f - f2) > 10.0f)) continue;
            f2 = 0.0f;
            break;
        }
        if (f2 > 0.0f) {
            n2 |= 1;
        }
        object = this.getName();
        String string = this.getFamily();
        n = 0;
        if (this.getTable(1330851634).length >= 56) {
            int n4 = this.readUint16();
            int n5 = this.readInt16();
            int n6 = this.readUint16();
            if (1 <= n6 && n6 <= 9) {
                n6 *= 100;
            }
            if (400 == n6 && object != null && ((String)object).indexOf(45) > 0) {
                n6 = NFontManager.guessWeight((String)object);
            }
            int n7 = this.readUint16();
            this.rights_ = this.readUint16();
            this.offset_ += 20;
            n = this.readInt16();
            int n8 = this.readUint8();
            int n9 = this.readUint8();
            int n10 = this.readUint8();
            int n11 = this.readUint8();
            int n12 = this.readUint8();
            int n13 = this.readUint8();
            int n14 = this.readUint8();
            int n15 = this.readUint8();
            int n16 = this.readUint8();
            int n17 = this.readUint8();
            this.offset_ += 16;
            this.offset_ += 4;
            int n18 = this.readUint16();
            int n19 = this.readUint16();
            this.offset_ += 2;
            this.weight_ = n6;
            if (0 < n && n < 16) {
                n <<= 8;
            }
            switch (n >> 8) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    n2 |= 2;
                    break;
                }
                case 9: {
                    n2 |= 0x10000002;
                    break;
                }
                case 10: {
                    n2 |= 0xA;
                    break;
                }
                case 12: {
                    n2 |= 4;
                }
            }
            if (n8 == 2 && n11 == 9) {
                n2 |= 1;
            }
            if (0 < n7 && n7 <= 4) {
                n2 |= 0x4000000;
            } else if (n7 >= 6) {
                n2 |= 0x8000000;
            }
            if ((n18 & 1) != 0) {
                n2 |= 0x40;
            }
            if (2 <= n8 && n8 <= 5 && 0 < n19 && n19 < 128) {
                n2 |= 0x20;
            }
        } else {
            int n20 = this.rights_ = this.names_ != null ? NFontManager.guessRights(this.names_[0] + " || " + this.names_[7] + " || " + this.names_[8] + " || " + this.names_[13]) : 4;
            if ((this.macStyle_ & 2) != 0) {
                n2 |= 0x40;
            }
            int n21 = this.weight_ = (this.macStyle_ & 1) != 0 ? 700 : 400;
        }
        if (n == 0) {
            int n22;
            if (400 <= this.weight_ && this.weight_ <= 500 && (400 > (n22 = NFontManager.guessWeight((String)object)) || n22 > 500)) {
                this.weight_ = n22;
            }
            n2 |= NFontManager.guessFlags((String)object, string);
        }
        n2 = NFontManager.fixFlags(n2, (String)object, string);
        return n2;
    }

    public String getName() {
        return this.name_;
    }

    public String getFamily() {
        return this.family_;
    }

    public String getDesigner() {
        return this.names_ != null ? this.names_[9] : null;
    }

    public String getCopyright() {
        return this.names_ != null ? this.names_[0] : null;
    }

    public String getName(int n) {
        return this.names_ != null && 0 <= n && n <= this.names_.length ? this.names_[n] : null;
    }

    public String getVersion() {
        return this.names_ != null && this.names_[5] != null ? this.names_[5] : super.getVersion();
    }

    public int getID() {
        return this.version_;
    }

    public int getRights() {
        return this.rights_;
    }

    public NFontTrueType getSubfont(int n) throws FontFormatException, IOException {
        if (n < 0 || n > this.getCount()) {
            return null;
        }
        if (this.urs_[n] != null) {
            return this.urs_[n];
        }
        NFontTrueType nFontTrueType = this.deriveFont(this.size_);
        nFontTrueType.setManager(null);
        nFontTrueType.ur_ = nFontTrueType;
        nFontTrueType.raoff_ = this.ttfoffset_[n];
        nFontTrueType.getRA();
        nFontTrueType.parse();
        if (this.fdfont_) {
            nFontTrueType.loca_ = null;
            nFontTrueType.intrinsic_ = null;
        }
        nFontTrueType.releaseRA();
        this.urs_[n] = nFontTrueType;
        return nFontTrueType;
    }

    public int getCount() {
        return this.urs_.length;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getSubformat() {
        return this.subformat_;
    }

    public int getFlags() {
        return this.flags_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public boolean isHinted() {
        if (this.hint_ == -1) {
            this.hint_ = 0;
            if (SUBFORMAT_BITMAP != this.getSubformat()) {
                int n = this.getMaxGlyphNum();
                for (int i = 1; i < n && this.hint_ != 1; ++i) {
                    this.getGlyphRec(i);
                }
                this.releaseRA();
            }
        }
        return this.hint_ == 1;
    }

    public int getNumGlyphs() {
        this.readLocaTable();
        return this.glyphcnt_;
    }

    public int getMaxGlyphNum() {
        return this.maxGlyph_;
    }

    public UnicodeBlocks[] getUnicode() {
        if (!$assertionsDisabled && this.blocks_ == null) {
            throw new AssertionError();
        }
        return this.blocks_;
    }

    public boolean canDisplayEchar(int n) {
        char c = this.c2g_.toSelector(n);
        return (c != '\u0000' || 0 == n) && this.canDisplayGID(c);
    }

    private boolean canDisplayGID(int n) {
        return n < this.getMaxGlyphNum();
    }

    public char getSpaceEchar() {
        if (this.spacech_ == Integer.MIN_VALUE) {
            char c;
            if (Encoding.SYMBOL == this.encoding_) {
                this.spacech_ = 65534;
            } else if (this.touni_ != null) {
                this.spacech_ = this.touni_.fromSelector(32);
            } else if (this.encoding_ != null && "space".equals(this.encoding_.getName(32)) && this.canDisplayEchar(32)) {
                this.spacech_ = 32;
            } else if (this.encoding_ != null && (c = this.encoding_.getChar("space")) != '\u0000' && this.canDisplayEchar(c)) {
                this.spacech_ = c;
            } else {
                char c2 = this.c2g_.toSelector(32);
                if (c2 != '\u0000' && this.canDisplayGID(c2)) {
                    boolean bl = this.ra_ == null;
                    int n = this.spacech_ = ((GeneralPath)this.getGlyphRec((int)c2).shape).getPathIterator(new AffineTransform()).isDone() ? 32 : 0;
                    if (bl) {
                        this.releaseRA();
                    }
                } else {
                    this.spacech_ = 65534;
                }
            }
        }
        return (char)this.spacech_;
    }

    private void readHeadTable() throws FontFormatException {
        float f = this.readFixed();
        if (!$assertionsDisabled && !((double)f < 2.0)) {
            throw new AssertionError(f);
        }
        int n = (int)this.readUint32();
        this.readUint32();
        long l = this.readUint32();
        if (!$assertionsDisabled && l != 1594834165L) {
            throw new AssertionError(l);
        }
        int n2 = this.readUint16();
        int n3 = this.readUint16();
        this.FUnit_ = 1.0f / (float)n3;
        long l2 = this.readDateTime();
        long l3 = this.readDateTime();
        float f2 = this.readInt16();
        float f3 = this.readInt16();
        float f4 = this.readInt16();
        float f5 = this.readInt16();
        this.bbox_ = new Rectangle2D.Double(f2, f3, f4, f5);
        this.macStyle_ = this.readUint16();
        int n4 = this.readUint16();
        int n5 = this.readInt16();
        this.indexToLocFormat_ = this.readInt16();
        if (this.indexToLocFormat_ != 0 && this.indexToLocFormat_ != 1) {
            throw new FontFormatException("'head': bad indexToLocFormat (" + this.indexToLocFormat_ + ")");
        }
    }

    private void readMaxpTable() {
        this.getTable(1835104368);
        if (!$assertionsDisabled && this.data_.length < 6) {
            throw new AssertionError();
        }
        float f = this.readFixed();
        if (!$assertionsDisabled && !((double)f < 2.0)) {
            throw new AssertionError(f);
        }
        this.maxGlyph_ = this.readUint16();
    }

    private void readLocaTable() {
        int n;
        int n2;
        if (this.loca_ != null) {
            return;
        }
        if (this != this.ur_) {
            this.ur_.readLocaTable();
            this.loca_ = this.ur_.loca_;
            this.glyphcnt_ = this.ur_.glyphcnt_;
            return;
        }
        this.getTable(1819239265);
        this.glyphcnt_ = 0;
        if (this.data_.length == 0) {
            this.loca_ = new int[0];
            return;
        }
        this.loca_ = new int[this.maxGlyph_ + 1];
        if (this.indexToLocFormat_ == 0) {
            n2 = this.maxGlyph_ + 1;
            for (n = 0; n < n2; ++n) {
                this.loca_[n] = this.readUint16() * 2;
            }
        } else {
            if (!$assertionsDisabled && this.indexToLocFormat_ != 1) {
                throw new AssertionError();
            }
            n2 = this.maxGlyph_ + 1;
            for (n = 0; n < n2; ++n) {
                this.loca_[n] = (int)this.readUint32();
            }
        }
        n2 = this.maxGlyph_;
        for (n = 0; n < n2; ++n) {
            if (!$assertionsDisabled && this.loca_[n] > this.loca_[n + 1]) {
                throw new AssertionError((Object)(this.loca_[n] + " > " + this.loca_[n + 1] + " @ " + n + " of " + this.maxGlyph_));
            }
            if (this.loca_[n] >= this.loca_[n + 1]) continue;
            ++this.glyphcnt_;
        }
    }

    private void readPostTable() {
        Encoding encoding;
        if (this.intrinsic_ != null) {
            return;
        }
        if (this != this.ur_) {
            this.ur_.readPostTable();
            this.intrinsic_ = this.ur_.intrinsic_;
            return;
        }
        if (this.getTable(1886352244).length < 10) {
            return;
        }
        float f = this.readFixed();
        float f2 = this.readFixed();
        float f3 = this.readFWord();
        float f4 = this.readFWord();
        int n = this.readUint16();
        this.offset_ += 18;
        if (f == 1.0f) {
            encoding = ENCODING_MAC_STANDARD;
        } else if (f == 2.0f) {
            int n2;
            int n3 = this.readUint16();
            int[] nArray = new int[n3];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.readUint16();
                int n5 = nArray[n2];
                if (n5 <= n4) continue;
                n4 = n5;
            }
            n2 = Math.max(0, n4 - 257);
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = this.readStringPascal();
            }
            String[] stringArray2 = new String[n3];
            for (int i = 0; i < n3; ++i) {
                int n6 = nArray[i];
                stringArray2[i] = n6 <= 257 ? MAP_MAC_STANDARD[n6] : stringArray[n6 - 258];
            }
            encoding = new Encoding("TrueType-2", stringArray2);
        } else if (f == 2.5f) {
            int n7 = this.readUint16();
            String[] stringArray = new String[n7];
            for (int i = 0; i < n7; ++i) {
                int n8 = this.readInt8();
                stringArray[i] = MAP_MAC_STANDARD[i + n8];
            }
            encoding = new Encoding("TrueType-2.5", stringArray);
        } else if (f == 3.0f) {
            encoding = null;
        } else {
            if (!$assertionsDisabled && f != 4.0f) {
                throw new AssertionError();
            }
            encoding = null;
        }
        this.intrinsic_ = encoding;
    }

    private void readNameTable() {
        int n = this.getTable(1851878757).length;
        if (n < 6) {
            this.name_ = "[no name]";
            this.family_ = "[no family]";
            return;
        }
        int n2 = this.readUint16();
        int n3 = this.readUint16();
        int n4 = this.readUint16();
        String[] stringArray = new String[20];
        int[] nArray = new int[stringArray.length];
        Arrays.fill(nArray, -1);
        int n5 = Math.min(n3, (n - 6) / 12);
        for (int i = 0; i < n5; ++i) {
            String string;
            boolean bl;
            int n6 = this.readUint16();
            int n7 = this.readUint16();
            int n8 = this.readUint16();
            int n9 = this.readUint16();
            int n10 = this.readUint16();
            int n11 = this.readUint16() + n4;
            if (n9 >= stringArray.length || n11 + n10 > n) continue;
            boolean bl2 = bl = 0 == n6 || 3 == n6;
            if (nArray[n9] != -1 && n8 != 0 && (0 != n6 || nArray[n9] == 0) || (string = (bl ? this.readString16(n11, n10) : this.readString(n11, n10)).trim()).length() <= 0) continue;
            stringArray[n9] = string;
            nArray[n9] = n6;
        }
        this.name_ = stringArray[6] != null ? stringArray[6] : (stringArray[4] != null ? stringArray[4] : "[no name]");
        this.family_ = stringArray[1] != null ? stringArray[1] : NFontManager.guessFamily(this.name_);
        this.names_ = stringArray;
    }

    private void readMetricsTables() {
        this.getTable(1751672161);
        if (!$assertionsDisabled && this.data_.length < 36) {
            throw new AssertionError();
        }
        float f = this.readFixed();
        this.ascent_ = this.readFWord();
        this.descent_ = this.readFWord();
        this.lineGap_ = this.readFWord();
        float f2 = this.readUFWord();
        float f3 = this.readFWord();
        float f4 = this.readFWord();
        float f5 = this.readFWord();
        int n = this.readInt16();
        int n2 = this.readInt16();
        float f6 = this.readFWord();
        this.readInt16();
        this.readInt16();
        this.readInt16();
        this.readInt16();
        int n3 = this.readInt16();
        int n4 = this.readUint16();
        this.getTable(1752003704);
        if (!$assertionsDisabled && this.data_.length < n4 * 2) {
            throw new AssertionError();
        }
        this.widths_ = new float[n4];
        for (int i = 0; i < n4; ++i) {
            this.widths_[i] = this.readUint16();
            this.readInt16();
        }
    }

    private void readCMapTable() {
        SfntDirectory sfntDirectory = this.getTableDirectory(1668112752);
        if (sfntDirectory == null) {
            this.cmaps_ = new CMapRec[0];
            return;
        }
        this.getTable(sfntDirectory, 0, 4);
        int n = this.readUint16();
        int n2 = this.readUint16();
        ArrayList<CMapRec> arrayList = new ArrayList<CMapRec>(10);
        this.getTable(sfntDirectory, 0, 4 + n2 * 8);
        this.offset_ = 4;
        if (n < 10 && this.data_.length >= 12) {
            for (int i = 0; i < n2; ++i) {
                int n3 = this.readUint16();
                int n4 = this.readUint16();
                int n5 = (int)this.readUint32();
                byte[] byArray = this.data_;
                int n6 = this.offset_;
                if (this.getTable(sfntDirectory, n5, 12).length >= 6) {
                    int n7;
                    int n8 = this.readUint16();
                    if (n8 <= 6) {
                        n7 = this.readUint16();
                    } else {
                        this.offset_ += 2;
                        n7 = (int)this.readUint32();
                    }
                    int n9 = n8 <= 6 ? this.readUint16() : (int)this.readUint32();
                    CMapRec cMapRec = new CMapRec(n3, n4, n9, -1, n8, n5, n7);
                    cMapRec.mappings_ = this.getCMap(cMapRec).census(0, 0x10FFFF);
                    arrayList.add(cMapRec);
                }
                this.data_ = byArray;
                this.offset_ = n6;
            }
        }
        this.cmaps_ = arrayList.toArray(new CMapRec[arrayList.size()]);
    }

    public CMapRec[] getCMapRecs() {
        return (CMapRec[])this.cmaps_.clone();
    }

    public CMap getCMap(int n, int n2) {
        return this.getCMap(n, n2, 0);
    }

    public CMap getCMap(int n, int n2, int n3) {
        if (this.cmaps_.length == 0) {
            return CMap.IDENTITY;
        }
        int n4 = -1;
        CMapRec cMapRec = null;
        CMapRec[] cMapRecArray = this.cmaps_;
        int n5 = cMapRecArray.length;
        for (int i = 0; i < n5; ++i) {
            CMapRec cMapRec2 = cMapRecArray[i];
            if (n != cMapRec2.getPID() && n != -1 || n2 != cMapRec2.getPSID() && n2 != -1 || n3 != cMapRec2.getLang() && n3 != -1 && n == 1 || cMapRec2.getMappings() <= n4) continue;
            cMapRec = cMapRec2;
            n4 = cMapRec2.getMappings();
        }
        return cMapRec != null ? this.getCMap(cMapRec) : null;
    }

    private CMap getCMap(CMapRec cMapRec) {
        char[][] cArrayArray;
        int n;
        int n2;
        SfntDirectory sfntDirectory = this.getTableDirectory(1668112752);
        this.getTable(sfntDirectory, cMapRec.getOffset(), sfntDirectory.length - cMapRec.getOffset());
        int n3 = this.readUint16();
        if (n3 <= 6) {
            n2 = this.readUint16();
            n = this.readUint16();
            cArrayArray = new char[256][];
        } else {
            this.offset_ -= 2;
            float f = this.readFixed();
            n2 = (int)this.readUint32();
            n = (int)this.readUint32();
            cArrayArray = new char[4352][];
        }
        if (n3 == 0) {
            char[] cArray = CMap.createBlankPage();
            int n4 = cArray.length;
            for (int i = 0; i < n4; ++i) {
                cArray[i] = (char)this.readUint8();
            }
            cArrayArray[0] = cArray;
        } else if (n3 == 2) {
            int n5;
            int[] nArray = new int[256];
            int n6 = 1;
            boolean[] blArray = new boolean[256];
            int n7 = nArray.length;
            for (int i = 0; i < n7; ++i) {
                nArray[i] = this.readUint16() / 8;
                int n8 = nArray[i];
                if (n8 <= 0 || blArray[n8]) continue;
                ++n6;
                blArray[n8] = true;
            }
            int[] nArray2 = new int[n6];
            int[] nArray3 = new int[n6];
            int[] nArray4 = new int[n6];
            int[] nArray5 = new int[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                nArray2[n5] = this.readUint16();
                nArray3[n5] = this.readUint16();
                nArray4[n5] = this.readInt16();
                nArray5[n5] = this.readUint16();
            }
            n5 = this.offset_;
            if (!$assertionsDisabled && n5 != 518 + 8 * n6) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 524 + nArray5[0] != n5) {
                throw new AssertionError();
            }
            cArrayArray[0] = CMap.createBlankPage();
            for (int i = 0; i < 256; ++i) {
                int n9;
                int n10 = nArray[i];
                if (!$assertionsDisabled && n10 != 0 && !blArray[n10]) {
                    throw new AssertionError((Object)(i + " => " + n10));
                }
                if (!$assertionsDisabled && n10 >= n6) {
                    throw new AssertionError(n10);
                }
                if (n10 == 0) {
                    if (!$assertionsDisabled && nArray4[0] != 0) {
                        throw new AssertionError();
                    }
                    this.offset_ = n5 + i * 2;
                    cArrayArray[0][i] = (char)this.readUint16();
                    continue;
                }
                this.offset_ = 518 + n10 * 8 - 2 + nArray5[n10];
                int n11 = n9 + nArray3[n10];
                for (n9 = nArray2[n10]; n9 < n11; ++n9) {
                    int n12 = this.readUint16();
                    if (n12 != 0) {
                        n12 = n12 + nArray4[n10] & 0xFFFF;
                    }
                    if (cArrayArray[i] == null) {
                        cArrayArray[i] = CMap.createBlankPage();
                    }
                    cArrayArray[i][n9] = (char)n12;
                }
            }
        } else if (n3 == 4) {
            int n13;
            int n14;
            int n15 = this.readUint16() / 2;
            this.offset_ += 6;
            int[] nArray = new int[n15];
            for (n14 = 0; n14 < n15; ++n14) {
                nArray[n14] = this.readUint16();
            }
            n14 = this.readUint16();
            int[] nArray6 = new int[n15];
            for (int i = 0; i < n15; ++i) {
                nArray6[i] = this.readUint16();
            }
            int[] nArray7 = new int[n15];
            for (n13 = 0; n13 < n15; ++n13) {
                nArray7[n13] = this.readInt16();
            }
            for (n13 = 0; n13 < n15; ++n13) {
                int n16;
                int n17 = this.readUint16();
                int n18 = n16 = nArray6[n13];
                int n19 = nArray[n13];
                int n20 = nArray7[n13];
                while (n16 <= n19) {
                    if (n16 != 65535) {
                        int n21;
                        int n22;
                        if (n17 == 0) {
                            n22 = n16 + n20 & 0xFFFF;
                        } else {
                            n21 = (n16 - n18) * 2 + this.offset_ - 2 + n17;
                            n22 = (this.data_[n21] & 0xFF) << 8 | this.data_[n21 + 1] & 0xFF;
                            if (n22 != 0) {
                                n22 -= nArray7[n13];
                            }
                        }
                        n21 = n16 >> 8;
                        if (cArrayArray[n21] == null) {
                            cArrayArray[n21] = CMap.createBlankPage();
                        }
                        cArrayArray[n21][n16 & 0xFF] = (char)n22;
                    }
                    ++n16;
                }
            }
        } else if (n3 == 6 || n3 == 10) {
            int n23;
            int n24 = n3 == 6 ? this.readUint16() : (int)this.readUint32();
            int n25 = n23 = n3 == 6 ? this.readUint16() : (int)this.readUint32();
            if (!$assertionsDisabled && n24 + n23 > 0x100000) {
                throw new AssertionError();
            }
            int n26 = n24;
            for (int i = 0; i < n23; ++i) {
                int n27 = this.readUint16();
                int n28 = n26 >> 8;
                if (cArrayArray[n28] == null) {
                    cArrayArray[n28] = CMap.createBlankPage();
                }
                cArrayArray[n28][n26 & 0xFF] = (char)n27;
                ++n26;
            }
        } else if (n3 == 8) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("format 8 " + this.getName()));
            }
        } else if (n3 == 12) {
            int n29 = (int)this.readUint32();
            for (int i = 0; i < n29; ++i) {
                int n30 = (int)this.readUint32();
                int n31 = (int)this.readUint32();
                int n32 = (int)this.readUint32();
                while (n30 <= n31) {
                    int n33 = n30 >> 8;
                    if (!$assertionsDisabled && n33 >= cArrayArray.length) {
                        throw new AssertionError((Object)(Integer.toHexString(n30) + " => " + n33));
                    }
                    if (cArrayArray[n33] == null) {
                        cArrayArray[n33] = CMap.createBlankPage();
                    }
                    cArrayArray[n33][n30 & 0xFF] = (char)n32;
                    ++n30;
                    ++n32;
                }
            }
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError(n3);
            }
            return CMap.IDENTITY;
        }
        int n34 = cMapRec.getPID();
        int n35 = cMapRec.getPSID();
        if (3 == n34 && n35 == 0 && Encoding.IDENTITY != this.encoding_ && Encoding.UNICODE != this.encoding_ && cArrayArray[240] != null && cArrayArray[0] == null) {
            cArrayArray[0] = cArrayArray[240];
            cArrayArray[240] = null;
        }
        return 0 == n34 && n35 >= 3 || 3 == n34 && n35 == 10 ? new CMapUTF16BE(cArrayArray) : new CMap(cArrayArray, null);
    }

    GlyphRec getGlyphRec(int n) {
        if (!this.canDisplayGID(n)) {
            if (this.notdef_ == null) {
                this.notdef_ = this.canDisplayGID(0) ? this.getGlyphRec(0) : GlyphRec.ZERO_CONTOUR;
            }
            return this.notdef_;
        }
        GlyphRec glyphRec = this.gc_.getGlyphRec(n);
        if (glyphRec == null) {
            glyphRec = this.buildChar(n);
            if (!$assertionsDisabled && glyphRec == null) {
                throw new AssertionError();
            }
            this.gc_.setGlyph(n, glyphRec);
        }
        return glyphRec;
    }

    private GlyphRec buildChar(int n) {
        GeneralPath generalPath;
        this.readLocaTable();
        if (n < 0 || n + 1 >= this.loca_.length) {
            return GlyphRec.ZERO_CONTOUR;
        }
        if (this.ra_ == null) {
            try {
                this.getRA();
            }
            catch (IOException iOException) {
                return GlyphRec.ZERO_CONTOUR;
            }
        }
        if (this.getTable(1735162214, this.loca_[n], this.loca_[n + 1] - this.loca_[n]).length < 10) {
            return GlyphRec.ZERO_CONTOUR;
        }
        int n2 = this.readInt16();
        float f = this.readFWord();
        float f2 = this.readFWord();
        float f3 = this.readFWord();
        float f4 = this.readFWord();
        if (n2 == 0) {
            generalPath = GlyphRec.PATH_ZERO_CONTOUR;
        } else if (n2 > 0) {
            Object[] objectArray = this.getPoints(n2);
            int[] nArray = (int[])objectArray[0];
            int[] nArray2 = (int[])objectArray[1];
            int[] nArray3 = (int[])objectArray[2];
            byte[] byArray = (byte[])objectArray[3];
            int n3 = (Integer)objectArray[4];
            generalPath = this.buildSimple(nArray, nArray2, nArray3, byArray, n3);
        } else {
            if (!$assertionsDisabled && n2 != -1) {
                throw new AssertionError(n2);
            }
            generalPath = this.buildComposite(n);
        }
        return new GlyphRec(generalPath, f, f2, f3, f4);
    }

    private Object[] getPoints(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[n];
        for (n5 = 0; n5 < n; ++n5) {
            nArray[n5] = this.readUint16();
        }
        n5 = this.readUint16();
        if (n5 > 1) {
            this.hint_ = 1;
        }
        this.offset_ += n5;
        int n6 = nArray[n - 1] + 1;
        int n7 = 0;
        byte[] byArray = new byte[n6 + 10];
        int n8 = 0;
        while (n8 < n6) {
            byte by;
            if (((by = (byArray[n8++] = this.data_[this.offset_++])) & 1) != 0) {
                ++n7;
            }
            if ((by & 8) == 0) continue;
            n4 = this.readUint8();
            n3 = n8 + n4;
            while (n8 < n3) {
                byArray[n8] = by;
                ++n8;
            }
            if ((by & 1) == 0) continue;
            n7 += n4;
        }
        n8 = 0;
        int[] nArray2 = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = byArray[n4];
            if ((n3 & 2) != 0) {
                n2 = this.readUint8();
                if ((n3 & 0x10) == 0) {
                    n2 = -n2;
                }
            } else {
                n2 = (n3 & 0x10) != 0 ? 0 : this.readInt16();
            }
            nArray2[n4] = n8 += n2;
        }
        int[] nArray3 = new int[n6];
        n3 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            int n9;
            byte by = byArray[n2];
            if ((by & 4) != 0) {
                n9 = this.readUint8();
                if ((by & 0x20) == 0) {
                    n9 = -n9;
                }
            } else {
                n9 = (by & 0x20) != 0 ? 0 : this.readInt16();
            }
            nArray3[n2] = n3 += n9;
        }
        return new Object[]{nArray2, nArray3, nArray, byArray, new Integer(n7)};
    }

    private GeneralPath buildSimple(int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray, int n) {
        GeneralPath generalPath = new GeneralPath(1, n * 2 + 5);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            float f;
            int n6;
            int n7;
            int n8;
            if (bl2) {
                bl2 = false;
                n8 = n4;
                ++n5;
                bl3 = true;
            } else if (bl3) {
                bl3 = false;
                bl = false;
                n4 = n3;
                n7 = nArray[n3];
                n6 = nArray2[n3];
                if ((byArray[n3] & 1) != 0) {
                    generalPath.moveTo(n7, n6);
                } else {
                    if (++n3 == n2) break;
                    float f2 = nArray[n3];
                    f = nArray2[n3];
                    if ((byArray[n3] & 1) == 0) {
                        generalPath.moveTo(((float)n7 + f2) / 2.0f, ((float)n6 + f) / 2.0f);
                    } else {
                        generalPath.moveTo(f2, f);
                    }
                }
                n8 = n3;
                if (n3 == nArray3[n5]) {
                    bl2 = true;
                } else {
                    ++n3;
                }
            } else {
                n8 = n3;
                if (n3 == nArray3[n5]) {
                    bl2 = true;
                } else {
                    ++n3;
                }
            }
            boolean bl4 = (byArray[n8] & 1) != 0;
            n7 = nArray[n8];
            n6 = nArray2[n8];
            if (bl4) {
                if (bl) {
                    generalPath.lineTo(n7, n6);
                } else {
                    bl = true;
                }
            } else {
                n8 = bl2 || n8 + 1 >= n2 ? n4 : n8 + 1;
                f = nArray[n8];
                float f3 = nArray2[n8];
                boolean bl5 = bl4 = (byArray[n8] & 1) != 0;
                if (!bl4) {
                    f = ((float)n7 + f) / 2.0f;
                    f3 = ((float)n6 + f3) / 2.0f;
                }
                generalPath.quadTo(n7, n6, f, f3);
                bl = false;
            }
            if (!bl3) continue;
            ++n3;
        }
        return generalPath;
    }

    private GeneralPath buildComposite(int n) {
        GeneralPath generalPath = new GeneralPath(1);
        int[] nArray = new int[100];
        int[][] nArrayArray = new int[100][];
        int[][] nArrayArray2 = new int[100][];
        SfntDirectory sfntDirectory = this.getTableDirectory(1735162214);
        int n2 = 0;
        while (this.offset_ + 4 <= this.data_.length) {
            float f;
            float f2;
            int n3 = this.readUint16();
            int n4 = this.readUint16();
            if (!$assertionsDisabled && !this.canDisplayGID(n4)) {
                throw new AssertionError(n4);
            }
            nArray[n2] = n4;
            if ((n3 & 2) != 0) {
                if ((n3 & 1) == 0) {
                    f2 = this.readInt8();
                    f = this.readInt8();
                } else {
                    f2 = this.readInt16();
                    f = this.readInt16();
                }
            } else {
                int n5;
                int n6;
                if ((n3 & 1) == 0) {
                    n6 = this.readUint8();
                    n5 = this.readUint8();
                } else {
                    n6 = this.readUint16();
                    n5 = this.readUint16();
                }
                f = 0.0f;
                f2 = 0.0f;
                byte[] byArray = this.data_;
                int n7 = this.offset_;
                this.getTable(sfntDirectory, this.loca_[n4], this.loca_[n4 + 1] - this.loca_[n4]);
                int n8 = this.readInt16();
                this.offset_ += 8;
                if (n8 < 0) {
                    n3 &= 0xFFFFFFDF;
                    break;
                }
                Object[] objectArray = this.getPoints(n8);
                nArrayArray[n2] = (int[])objectArray[0];
                nArrayArray2[n2] = (int[])objectArray[1];
                int n9 = nArrayArray[n2][n5];
                int n10 = nArrayArray2[n2][n5];
                int n11 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n12;
                    if (nArrayArray[i] == null) {
                        n12 = nArray[i];
                        this.getTable(sfntDirectory, this.loca_[n12], this.loca_[n12 + 1] - this.loca_[n12]);
                        n8 = this.readInt16();
                        this.offset_ += 8;
                        if (n8 < 0) {
                            n3 &= 0x20;
                            break;
                        }
                        objectArray = this.getPoints(n8);
                        nArrayArray[i] = (int[])objectArray[0];
                        nArrayArray2[i] = (int[])objectArray[1];
                    }
                    if (n6 < n11 + nArrayArray[i].length) {
                        n12 = nArrayArray[i][n6 - n11];
                        int n13 = nArrayArray2[i][n6 - n11];
                        f2 = n12 - n9;
                        f = n13 - n10;
                        break;
                    }
                    n11 += nArrayArray[i].length;
                }
                this.data_ = byArray;
                this.offset_ = n7;
            }
            float f3 = 1.0f;
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if ((n3 & 0x40) != 0) {
                f3 = this.readF2Dot14();
                f4 = this.readF2Dot14();
            } else if ((n3 & 8) != 0) {
                f3 = f4 = this.readF2Dot14();
            } else if ((n3 & 0x80) != 0) {
                f3 = this.readF2Dot14();
                f6 = this.readF2Dot14();
                f5 = this.readF2Dot14();
                f4 = this.readF2Dot14();
            }
            if ((n3 & 0x200) != 0) {
                if (n < this.widths_.length && n4 < this.widths_.length) {
                    this.widths_[n] = this.widths_[n4];
                } else if (!$assertionsDisabled && n4 < this.widths_.length) {
                    throw new AssertionError();
                }
            }
            byte[] byArray = this.data_;
            int n14 = this.offset_;
            if ((n3 & 0x800) != 0) {
                float f7 = Math.max(f3, f4);
                f2 *= f7;
                f *= f7;
            }
            AffineTransform affineTransform = new AffineTransform(f3, f6, f5, f4, f2, f);
            GeneralPath generalPath2 = (GeneralPath)this.getGlyphRec((int)n4).shape;
            generalPath.append(generalPath2.getPathIterator(affineTransform.isIdentity() ? null : affineTransform), false);
            this.data_ = byArray;
            this.offset_ = n14;
            if ((n3 & 0x20) == 0) break;
            ++n2;
        }
        return generalPath;
    }

    public Point2D echarAdvance(int n) {
        char c = this.c2g_.toSelector(n);
        double d = !this.canDisplayGID(c) ? 0.0 : (this.newwidths_ != null && this.firstch_ <= n && n <= this.lastch_ && this.newwidths_[n - this.firstch_] > 1 ? (double)this.newwidths_[n - this.firstch_] * 0.001 : (double)this.widths_[Math.min(c, this.widths_.length - 1)] * this.m_.getScaleX());
        return new Point2D.Double(d * (double)this.size_ * this.at_.getScaleX(), d * (double)this.size_ * this.at_.getShearY());
    }

    public Rectangle2D getEstringBounds(String string, int n, int n2) {
        Rectangle2D rectangle2D = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        double d = 0.0;
        int n3 = Math.min(n2, string.length());
        for (int i = Math.max(0, n); i < n3; ++i) {
            char c = string.charAt(i);
            char c2 = this.c2g_.toSelector(c);
            if (c2 == '\u0000' && c != '\u0000') continue;
            GlyphRec glyphRec = this.getGlyphRec(c2);
            rectangle2D.add(d + (double)glyphRec.xmin, -glyphRec.ymin);
            rectangle2D.add(d + (double)glyphRec.xmax, -glyphRec.ymax);
            d += this.newwidths_ != null && this.firstch_ <= c && c <= this.lastch_ && this.newwidths_[c - this.firstch_] > 1 ? (double)this.newwidths_[c - this.firstch_] * 0.001 : (double)this.widths_[Math.min(c2, this.widths_.length - 1)] * this.m_.getScaleX();
        }
        this.releaseRA();
        if (2 == this.at_.getType() || 0 == this.at_.getType()) {
            double d2 = this.at_.getScaleX() * (double)this.getSize();
            ((Rectangle2D)rectangle2D).setRect(((RectangularShape)rectangle2D).getX() * d2, ((RectangularShape)rectangle2D).getY() * d2, ((RectangularShape)rectangle2D).getWidth() * d2, ((RectangularShape)rectangle2D).getHeight() * d2);
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((RectangularShape)rectangle2D).getX(), (float)((RectangularShape)rectangle2D).getY());
            generalPath.lineTo((float)(((RectangularShape)rectangle2D).getX() + ((RectangularShape)rectangle2D).getWidth()), (float)(((RectangularShape)rectangle2D).getY() + ((RectangularShape)rectangle2D).getHeight()));
            generalPath.transform(AffineTransform.getScaleInstance(this.getSize(), this.getSize()));
            generalPath.transform(this.at_);
            rectangle2D = generalPath.getBounds2D();
        }
        return rectangle2D;
    }

    public float getAscent() {
        return this.ascent_ * this.getSize();
    }

    public float getDescent() {
        return this.descent_ * this.getSize();
    }

    public float getLeading() {
        return this.lineGap_ * this.getSize();
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        boolean bl;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (SUBFORMAT_BITMAP == this.getSubformat() || 3 == n) {
            return;
        }
        Color color2 = graphics2D.getColor();
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = null;
        CacheBitmap cacheBitmap = this.gc_.getCacheBitmap(this, this.at_, affineTransform, this.newwidths_, n, color2);
        boolean bl2 = bl = cacheBitmap != CacheBitmap.NONE;
        if (!bl) {
            graphics2D.translate(f, f2);
            graphics2D.transform(this.u_);
            if (1 == n || 2 == n || 5 == n || 6 == n) {
                basicStroke = (BasicStroke)graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke((float)((double)basicStroke.getLineWidth() / Math.sqrt(Math.abs(this.u_.getDeterminant()))), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
            }
        }
        double d = f;
        double d2 = 0.0;
        int n2 = Math.round(f2);
        String string2 = this.c2g_.toSelector(string);
        int n3 = string2.length();
        for (int i = 0; i < n3; ++i) {
            double d3;
            GlyphRec glyphRec;
            char c = string2.charAt(i);
            if ('\u0000' == c && this.newwidths_ != null && string.length() == string2.length() && '\u0000' == (c = this.ur_.c2g_.toSelector(string.charAt(i)))) {
                c = this.ur_.c2g_.toSelector(string.charAt(i) + 61440);
            }
            if ((glyphRec = this.getGlyphRec(c)) == this.notdef_) {
                c = '\u0000';
            }
            double d4 = this.widths_[Math.min(c, this.widths_.length - 1)];
            char c2 = string.charAt(i);
            int n4 = c2 - this.firstch_;
            double d5 = this.newwidths_ != null && Encoding.IDENTITY != this.getEncoding() && 0 <= n4 && n4 < this.newwidths_.length && this.newwidths_[n4] > 1 ? (double)this.newwidths_[n4] * 0.001 / this.m_.getScaleX() : 0.0;
            double d6 = d3 = d5 <= 1.0 || Math.abs(d4 - d5) <= 2.0 || this.pdfbad_[n4] ? 1.0 : d5 / d4;
            if (bl) {
                int n5 = (int)Math.round(d + d2);
                if ((d2 = (double)n5 - d) > 1.0) {
                    --n5;
                    d2 -= 1.0;
                } else if (d2 < -1.0) {
                    ++n5;
                    d2 += 1.0;
                }
                BitmapRec bitmapRec = cacheBitmap.getBitmap(c, glyphRec, d3);
                graphics2D.drawImage((Image)bitmapRec.img, n5 + bitmapRec.dx, n2 + bitmapRec.dy, null);
                d += (d5 != 0.0 ? d5 : d4) * this.u_.getScaleX();
                continue;
            }
            Shape shape = glyphRec.shape;
            if (d3 != 1.0) {
                graphics2D.scale(d3, 1.0);
            }
            if (0 == n || 2 == n || 4 == n || 6 == n) {
                graphics2D.fill(shape);
            }
            if (1 == n || 2 == n || 5 == n || 6 == n) {
                if (color == null || color.equals(color2)) {
                    graphics2D.draw(shape);
                } else {
                    graphics2D.setColor(color);
                    graphics2D.draw(shape);
                    graphics2D.setColor(color2);
                }
            }
            if (d3 != 1.0) {
                graphics2D.scale(1.0 / d3, 1.0);
            }
            graphics2D.translate(d5 != 0.0 ? d5 : d4, 0.0);
        }
        if (!bl) {
            graphics2D.setTransform(affineTransform);
        }
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        this.releaseRA();
    }

    public synchronized byte[] toByteArray() throws IOException {
        SfntDirectory sfntDirectory;
        int n;
        int n2;
        int n3;
        int n4;
        SfntDirectory sfntDirectory2 = this.getTableDirectory(1751474532);
        if (sfntDirectory2 != null) {
            sfntDirectory2.data = this.getTable(1751474532);
            Arrays.fill(sfntDirectory2.data, 8, 12, (byte)0);
        }
        SfntDirectory sfntDirectory3 = this.getTableDirectory(1819239265);
        SfntDirectory sfntDirectory4 = this.getTableDirectory(1735162214);
        this.readLocaTable();
        int n5 = Math.min(this.loca_.length - 1, this.subset_ != null ? this.subset_.length : Integer.MAX_VALUE);
        boolean bl = false;
        if (sfntDirectory3 != null && sfntDirectory4 != null) {
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                if (this.subset_ != null && !this.subset_[i]) continue;
                n4 = this.loca_[i + 1] - this.loca_[i];
                if ((n4 & 1) != 0) {
                    ++n4;
                }
                n6 += n4;
            }
            bl = n6 < 131072;
        }
        int[] nArray = this.loca_;
        if (this.subset_ != null && sfntDirectory3 != null && sfntDirectory4 != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            nArray = new int[n5 + 1];
            nArray[0] = 0;
            n3 = this.loca_[0];
            for (n4 = 0; n4 < n5; ++n4) {
                n2 = this.loca_[n4 + 1] - this.loca_[n4];
                if (n2 != 0) {
                    if (this.subset_[n4]) {
                        byteArrayOutputStream.write(this.getTable(sfntDirectory4, this.loca_[n4], n2));
                        if ((n2 & 1) != 0 && bl) {
                            byteArrayOutputStream.write(0);
                            --n3;
                        }
                    } else {
                        n3 -= n2;
                    }
                }
                nArray[n4 + 1] = this.loca_[n4 + 1] - n3;
            }
            sfntDirectory4.setData(byteArrayOutputStream.toByteArray());
        }
        if (sfntDirectory3 != null && sfntDirectory4 != null && sfntDirectory2 != null) {
            byte[] byArray = new byte[nArray.length * (bl ? 2 : 4)];
            n3 = nArray.length;
            n2 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                n = nArray[n4];
                if (bl) {
                    if (!$assertionsDisabled && (n & 1) != 0) {
                        throw new AssertionError();
                    }
                    n /= 2;
                } else {
                    byArray[n2++] = (byte)(n >> 24);
                    byArray[n2++] = (byte)(n >> 16);
                }
                byArray[n2++] = (byte)(n >> 8);
                byArray[n2++] = (byte)n;
            }
            sfntDirectory3.setData(byArray);
            sfntDirectory2.data[50] = 0;
            sfntDirectory2.data[51] = (byte)(!bl ? 1 : 0);
        }
        if ((sfntDirectory = this.getTableDirectory(1668112752)) != null && sfntDirectory.length >= 4) {
            int n7;
            this.getTable(1668112752);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(sfntDirectory.length);
            n3 = this.readUint16();
            n2 = this.readUint16();
            n = this.getOffset();
            this.getTable(1668112752, 0, 4 + n2 * 8);
            this.setOffset(n);
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            for (n7 = 0; n7 < n2; ++n7) {
                nArray2[n7] = this.readUint16();
                nArray3[n7] = this.readUint16();
                nArray4[n7] = (int)this.readUint32();
            }
            n7 = -1;
            int n8 = -1;
            int n9 = -1;
            byte[] byArray = null;
            for (int i = 0; i < n2; ++i) {
                int n10;
                int n11;
                int n12 = nArray2[i];
                int n13 = nArray3[i];
                int n14 = nArray4[i];
                this.getTable(sfntDirectory, n14, 12);
                int n15 = this.readUint16();
                if (n15 <= 6) {
                    n11 = this.readUint16();
                } else {
                    this.readUint16();
                    n11 = (int)this.readUint32();
                }
                int n16 = n15 <= 6 ? this.readUint16() : (int)this.readUint32();
                n = this.getOffset();
                byte[] byArray2 = this.getTable(sfntDirectory, n14, n11);
                this.setOffset(n);
                if (n12 == n7 && n13 == n8 && n16 == n9) {
                    n10 = Arrays.equals(byArray2, byArray) ? 1 : 0;
                    System.out.println((n10 != 0 ? "duplicate" : "conflicting") + " cmap subtables " + n12 + "/" + n13);
                    continue;
                }
                if (n15 == 12) {
                    n10 = (int)this.readUint32();
                    int n17 = 0;
                    int n18 = -1;
                    int n19 = -1;
                    int n20 = -1;
                    for (int j = 0; j < n10; ++j) {
                        int n21 = (int)this.readUint32();
                        int n22 = (int)this.readUint32();
                        int n23 = (int)this.readUint32();
                        if (n23 != 0) {
                            if (n23 == n20 && (n21 == n19 || n21 == n19 + 1)) {
                                n21 = n18;
                            } else {
                                ++n17;
                            }
                        }
                        n18 = n21;
                        n19 = n22;
                        n20 = n23;
                    }
                    System.out.println("CMap format 12, nGroups " + n10 + " => " + n17 + " (saved " + 12 * (n10 - n17) + ")");
                } else {
                    nArray4[i] = byteArrayOutputStream.size();
                }
                byteArrayOutputStream.write(byArray2);
                n7 = n12;
                n8 = n13;
                n9 = n16;
                byArray = byArray2;
            }
            byteArrayOutputStream.close();
        }
        byte[] byArray = super.toByteArray();
        if (TAG_TTCF == this.version_) {
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[0] = 0;
            byArray[1] = 1;
        }
        NFontTrueType nFontTrueType = null;
        try {
            nFontTrueType = new NFontTrueType(null, byArray);
        }
        catch (FontFormatException fontFormatException) {
            fontFormatException.printStackTrace();
        }
        if (sfntDirectory2 != null) {
            int n24 = -1313820742 - NFontTrueType.checksum(byArray);
            n = nFontTrueType.getTableDirectory((int)1751474532).offset;
            int n25 = 0;
            int n26 = 24;
            while (n25 < 4) {
                byArray[n + 8 + n25] = (byte)(n24 >> n26);
                ++n25;
                n26 -= 8;
            }
        }
        SfntDirectory[] sfntDirectoryArray = new SfntDirectory[]{sfntDirectory2, sfntDirectory4, sfntDirectory3, sfntDirectory};
        n = sfntDirectoryArray.length;
        for (int i = 0; i < n; ++i) {
            SfntDirectory sfntDirectory5 = sfntDirectoryArray[i];
            if (sfntDirectory5 == null) continue;
            sfntDirectory5.setData(null);
        }
        return byArray;
    }

    public /* synthetic */ NFontSimple deriveFont(Encoding encoding, CMap cMap) {
        return this.deriveFont(encoding, cMap);
    }

    public /* synthetic */ NFont deriveFont(AffineTransform affineTransform) {
        return this.deriveFont(affineTransform);
    }

    public /* synthetic */ NFont deriveFont(float f) {
        return this.deriveFont(f);
    }

    static {
        $assertionsDisabled = !NFontTrueType.class.desiredAssertionStatus();
        MAP_MAC_STANDARD = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
        ENCODING_MAC_STANDARD = new Encoding("TrueType-1", MAP_MAC_STANDARD);
        TAGS_KNOWN = new int[]{1819239265};
        TAGS_NO_GLYF = new int[]{1851878757, 1146308935};
        MAC_LATIN = UnicodeBlocks.getInstance(UnicodeBlock.getInstance(Character.UnicodeBlock.BASIC_LATIN)).or(UnicodeBlocks.getInstance(UnicodeBlock.getInstance(Character.UnicodeBlock.LATIN_1_SUPPLEMENT)));
        BLOCKS_MAC_LATIN = new UnicodeBlocks[]{MAC_LATIN, MAC_LATIN, MAC_LATIN};
    }
}

