/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FSFile;
import com.pt.io.FSFileMSSS;
import com.pt.io.FileSystem;
import com.pt.io.InputUni;
import com.pt.io.InputUniFile;
import com.pt.io.RandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import phelps.io.Files;
import phelps.io.InputStreamSlice;
import phelps.util.Arrayss;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemMSSS
extends FileSystem {
    private static final int[] HEADER_MAGIC;
    private static final int SECT_DIF = -4;
    private static final int SECT_FAT = -3;
    private static final int SECT_ENDOFCHAIN = -2;
    private static final int SECT_FREE = -1;
    private static final int STGTY_INVALID = 0;
    private static final int STGTY_STORAGE = 1;
    private static final int STGTY_STREAM = 2;
    private static final int STGTY_LOCKBYTES = 3;
    private static final int STGTY_PROPERTY = 4;
    private static final int STGTY_ROOT = 5;
    private RandomAccess ra_;
    private int byteOrder_;
    private int sectorSize_;
    private int sectorMiniSize_;
    private int sectorMini1_;
    private int sectorMiniCutoff_;
    private int[] fat_;
    private List<FSFileMSSS> dir_;
    private static final Comparator COMPARATOR_DIRECTORY;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$pt$io$FileSystemMSSS;

    public FileSystemMSSS(InputUni inputUni) throws IOException {
        super(inputUni.getURI());
        this.ra_ = inputUni.getRandomAccess();
        System.out.println(new StringBuffer().append("").append(inputUni.getURI()).append(", length = ").append(this.ra_.length()).append(" = 512 + ").append((this.ra_.length() - 512L) / 512L).append("*512").toString());
        this.init();
    }

    public static boolean identify(RandomAccess randomAccess) throws IOException {
        boolean bl = true;
        randomAccess.seek(0L);
        for (int n : HEADER_MAGIC) {
            if (n == randomAccess.read()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private char readChar() throws IOException {
        return (char)this.readShort();
    }

    private int readShort() throws IOException {
        return (this.ra_.read() | this.ra_.read() << 8) & 0xFFFF;
    }

    private int readLong() throws IOException {
        return this.ra_.read() | this.ra_.read() << 8 | this.ra_.read() << 16 | this.ra_.read() << 24;
    }

    private int[] collectChain(int n) {
        int[] nArray = new int[20];
        int n2 = 0;
        int n3 = n;
        while (n3 != -2) {
            if (n2 == nArray.length) {
                nArray = Arrayss.resize(nArray, nArray.length * 2);
            }
            nArray[n2++] = n3;
            n3 = this.fat_[n3];
        }
        return Arrayss.resize(nArray, n2);
    }

    private void seekSECT(int n) throws IOException {
        long l = 512L + ((long)n & 0xFFFFFFFFL) * (long)this.sectorSize_;
        System.out.println(new StringBuffer().append("seek #").append(n).append(" @ ").append(l).toString());
        this.ra_.seek(l);
    }

    private void init() throws IOException {
        int n;
        RandomAccess randomAccess = this.ra_;
        if (!FileSystemMSSS.identify(randomAccess)) {
            throw new IOException("not Microsoft Structured Storage format");
        }
        randomAccess.seek(0 + HEADER_MAGIC.length);
        randomAccess.skipBytes(16);
        int n2 = this.readShort();
        int n3 = this.readShort();
        this.byteOrder_ = this.readShort();
        this.sectorSize_ = 1 << this.readShort();
        this.sectorMiniSize_ = 1 << this.readShort();
        System.out.println(new StringBuffer().append("version = ").append(n3).append(".").append(n2).append(", bo=").append(Integer.toHexString(this.byteOrder_)).append(", sectors = ").append(this.sectorSize_).append(" / ").append(this.sectorMiniSize_).toString());
        this.readShort();
        this.readLong();
        this.readLong();
        int n4 = this.readLong();
        int n5 = this.readLong();
        this.readLong();
        this.sectorMiniCutoff_ = this.readLong();
        int n6 = this.readLong();
        int n7 = this.readLong();
        int n8 = this.readLong();
        int n9 = this.readLong();
        if (!$assertionsDisabled && randomAccess.getFilePointer() != 76L) {
            throw new AssertionError();
        }
        System.out.println(new StringBuffer().append("fatCnt = ").append(n4).append(" @ ").append(n5).append(", dif ").append(n8).append("..+").append(n9).append(", minicutoff = ").append(this.sectorMiniCutoff_).toString());
        int[] nArray = new int[n4];
        int n10 = Math.min(n4, 109);
        for (n = 0; n < n10; ++n) {
            nArray[n] = this.readLong();
        }
        if (n4 > 109 && !$assertionsDisabled) {
            throw new AssertionError((Object)"DIF not implemented");
        }
        this.fat_ = new int[n4 * this.sectorSize_ / 4];
        Arrays.fill(this.fat_, -2);
        n10 = 0;
        for (n = 0; n < n4; ++n) {
            System.out.print(new StringBuffer().append("SECT ").append(nArray[n]).append(":").toString());
            this.seekSECT(nArray[n]);
            int n11 = this.sectorSize_;
            for (int i = 0; i < n11; i += 4) {
                this.fat_[n10++] = this.readLong();
                int n12 = this.fat_[n10 - 1];
                System.out.print(new StringBuffer().append(" ").append(-4 == n12 ? "dif" : (-3 == n12 ? "fat" : (-2 == n12 ? "EOC" : (-1 == n12 ? "f" : Integer.toString(n12))))).toString());
            }
            System.out.println();
        }
        int[] nArray2 = this.collectChain(n5);
        ArrayList<FSFileMSSS> arrayList = new ArrayList<FSFileMSSS>(20);
        this.readDir("", 0, nArray2, new boolean[nArray2.length * 4], arrayList);
        FSFileMSSS fSFileMSSS = (FSFileMSSS)arrayList.remove(0);
        this.sectorMini1_ = fSFileMSSS.getSect1();
        Collections.sort(arrayList, COMPARATOR_DIRECTORY);
        this.dir_ = arrayList;
        System.out.println(arrayList);
    }

    private void readDir(String string, int n, int[] nArray, boolean[] blArray, List<FSFileMSSS> list) throws IOException {
        int n2;
        if (n == -1 || blArray[n]) {
            return;
        }
        blArray[n] = true;
        RandomAccess randomAccess = this.ra_;
        int n3 = n / 4;
        this.seekSECT(nArray[n3]);
        randomAccess.skipBytes((n - n3 * 4) * 128);
        StringBuffer stringBuffer = new StringBuffer(32);
        for (n2 = 0; n2 < 32; ++n2) {
            stringBuffer.append(this.readChar());
        }
        n2 = this.readShort();
        int n4 = randomAccess.read();
        int n5 = randomAccess.read();
        int n6 = this.readLong();
        int n7 = this.readLong();
        int n8 = this.readLong();
        randomAccess.skipBytes(16);
        int n9 = this.readLong();
        randomAccess.skipBytes(16);
        int n10 = this.readLong();
        int n11 = this.readLong();
        this.readShort();
        this.readShort();
        this.readDir(string, n6, nArray, blArray, list);
        if (0 != n4) {
            if (!$assertionsDisabled && n2 > 64) {
                throw new AssertionError(n2);
            }
            String string2 = stringBuffer.substring(0, n2 / 2 - 1);
            list.add(new FSFileMSSS(string2, n4, n10, n11, -1L));
            System.out.println(new StringBuffer().append(string2).append(", ").append(n4).append(", ").append(n6).append("..").append(n7).append("+").append(n8).append(" @ ").append(n10).append("..+").append(n11).toString());
            if (5 == n4) {
                this.readDir("/", n8, nArray, blArray, list);
            } else if (1 == n4) {
                this.readDir(new StringBuffer().append(string).append("/").append(string2).toString(), n8, nArray, blArray, list);
            }
        }
        this.readDir(string, n7, nArray, blArray, list);
    }

    @Override
    public Iterator iterator() throws IOException {
        return this.dir_.iterator();
    }

    public InputStream getInputStream(FSFile fSFile) throws IOException {
        InputStreamSlice inputStreamSlice;
        if (!(fSFile instanceof FSFileMSSS)) {
            throw new IOException("not a FSFileMSSS");
        }
        FSFileMSSS fSFileMSSS = (FSFileMSSS)fSFile;
        int n = fSFileMSSS.getType();
        if (2 == n) {
            int n2 = fSFileMSSS.getSect1();
            long l = fSFileMSSS.length();
            inputStreamSlice = l > (long)this.sectorMiniCutoff_ ? new InputStreamSlice(new InputStreamMSSS(n2), 0L, l) : new InputStreamSlice(new InputStreamMSSS(this.sectorMini1_), n2 * this.sectorMiniSize_, l);
        } else {
            inputStreamSlice = null;
        }
        return inputStreamSlice;
    }

    @Override
    public void close() throws IOException {
        if (this.ra_ != null) {
            this.ra_.close();
            this.ra_ = null;
        }
        super.close();
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        String string = "~/prj/Multivalent/related/WMvideo.doc";
        File file = Files.getFile(stringArray.length > 0 ? stringArray[0] : string);
        FileSystemMSSS fileSystemMSSS = new FileSystemMSSS(new InputUniFile(file));
        String string2 = "WordDocument";
        InputStream inputStream = fileSystemMSSS.getInputStream(fileSystemMSSS.getFile(string2));
        while ((n = inputStream.read()) != -1) {
            System.out.print((char)n);
        }
        System.out.println();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$com$pt$io$FileSystemMSSS == null ? (class$com$pt$io$FileSystemMSSS = FileSystemMSSS.class$("com.pt.io.FileSystemMSSS")) : class$com$pt$io$FileSystemMSSS).desiredAssertionStatus();
        HEADER_MAGIC = new int[]{208, 207, 17, 224, 161, 177, 26, 225};
        COMPARATOR_DIRECTORY = new Comparator<FSFileMSSS>(){

            @Override
            public int compare(FSFileMSSS fSFileMSSS, FSFileMSSS fSFileMSSS2) {
                return fSFileMSSS.getPath().compareTo(fSFileMSSS2.getPath());
            }

            @Override
            public boolean equals(Object object) {
                return this == object;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((FSFileMSSS)object, (FSFileMSSS)object2);
            }
        };
    }

    class InputStreamMSSS
    extends InputStream {
        private int sect_;
        private byte[] buf_;
        private int bufi_ = 0;
        private int limit_ = 0;
        private boolean eof_ = false;

        InputStreamMSSS(int n) {
            this.sect_ = n;
            this.buf_ = new byte[FileSystemMSSS.this.sectorSize_];
        }

        public int read() throws IOException {
            int n;
            if (this.bufi_ < this.limit_) {
                n = this.buf_[this.bufi_++] & 0xFF;
            } else if (this.eof_) {
                n = -1;
            } else {
                this.fill();
                n = this.read();
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bufi_ < this.limit_) {
                n2 = Math.min(n2, this.limit_ - this.bufi_);
                System.arraycopy(this.buf_, this.bufi_, byArray, n, n2);
                this.bufi_ += this.limit_;
            } else if (this.eof_) {
                n2 = -1;
            } else {
                this.fill();
                n2 = this.read(byArray, n, n2);
            }
            return n2;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = Math.min((long)(this.limit_ - this.bufi_), l);
            this.bufi_ = (int)((long)this.bufi_ + l2);
            while (l - l2 >= (long)FileSystemMSSS.this.sectorSize_ && -2 != this.sect_) {
                l2 += (long)FileSystemMSSS.this.sectorSize_;
                this.sect_ = FileSystemMSSS.this.fat_[this.sect_];
            }
            this.fill();
            int n = Math.min((int)(l2 - l), this.limit_);
            this.bufi_ = n;
            return l2 += (long)n;
        }

        private void fill() throws IOException {
            if (-2 != this.sect_) {
                FileSystemMSSS.this.seekSECT(this.sect_);
                FileSystemMSSS.this.ra_.readFully(this.buf_);
                this.bufi_ = 0;
                this.limit_ = FileSystemMSSS.this.sectorSize_;
                this.sect_ = FileSystemMSSS.this.fat_[this.sect_];
            } else {
                this.eof_ = true;
            }
        }
    }
}

