/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.OutputStreamTee;
import com.pt.io.OutputUniFile;
import com.pt.io.OutputUniOutputStream;
import com.pt.io.OutputUniRandomAccess;
import com.pt.io.OutputUniURI;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import phelps.io.OutputStreams;
import phelps.lang.Bytes;
import phelps.net.URIs;
import phelps.net.URLs;

public abstract class OutputUni {
    public static final OutputUni DEVNULL;
    private URI logical_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static OutputUni getInstance(Object object, URI uRI) {
        OutputUni outputUni;
        if (object instanceof URL) {
            try {
                object = URLs.toURI((URL)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (object == null) {
            outputUni = DEVNULL;
        } else if (object instanceof URI) {
            URI uRI2 = (URI)object;
            String string = uRI2.getScheme();
            outputUni = "memory".equals(string) ? new OutputUniRandomAccess(new RandomAccessByteArray(new byte[8192], "rw"), uRI) : ("file".equals(string) ? new OutputUniFile(new File(uRI2.getPath()), uRI) : new OutputUniURI((URI)object));
        } else if (object instanceof byte[]) {
            outputUni = new OutputUniRandomAccess(new RandomAccessByteArray((byte[])object, "rw"), uRI);
        } else if (object instanceof File) {
            outputUni = new OutputUniFile((File)object, uRI);
        } else if (object instanceof OutputStream) {
            outputUni = new OutputUniOutputStream((OutputStream)object, uRI);
        } else if (object instanceof RandomAccess) {
            outputUni = new OutputUniRandomAccess((RandomAccess)object, uRI);
        } else {
            outputUni = null;
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)(object + " of type " + object.getClass().getName() + " -- unsupported output class type"));
            }
        }
        OutputUni.getLogger().fine("output " + object + " => " + outputUni);
        return outputUni;
    }

    public static Logger getLogger() {
        return Logger.getLogger("com.pt.io.OutputUni");
    }

    public OutputUni(URI uRI) {
        this.logical_ = URIs.canonicalize(uRI);
    }

    public abstract Object getDestination();

    public URI getURI() {
        return this.logical_;
    }

    public OutputStreamTee getOutputStream(boolean bl) throws IOException {
        return new OutputStreamTee(this.getOutputStreamRaw(bl), bl ? this.length() : 0L);
    }

    public abstract OutputStream getOutputStreamRaw(boolean var1) throws IOException;

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream(false));
    }

    public abstract RandomAccess getRandomAccess() throws IOException;

    public abstract byte[] toByteArray() throws IOException;

    long length() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
    }

    static {
        $assertionsDisabled = !OutputUni.class.desiredAssertionStatus();
        DEVNULL = new OutputUni(URI.create("devnull:///")){

            public Object getDestination() {
                return null;
            }

            public OutputStream getOutputStreamRaw(boolean bl) {
                return OutputStreams.DEVNULL;
            }

            public RandomAccess getRandomAccess() {
                return RandomAccess.DEVNULL;
            }

            public byte[] toByteArray() {
                return Bytes.ARRAY0;
            }
        };
    }
}

