/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel.lens;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.std.lens.Lens;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ruler
extends Lens {
    static final int FIXEDHEIGHT = 40;
    int smalltick = 10;
    int bigtick = 100;
    public static final String ATTR_BIGTICK = "bigtick";
    public static final String ATTR_SMALLTICK = "smalltick";

    @Override
    public boolean paintAfter(Context context, Node node) {
        Rectangle rectangle = this.getContentBounds();
        int n = 5;
        int n2 = rectangle.x + n;
        int n3 = rectangle.y + n;
        int n4 = rectangle.width - n * 2;
        int n5 = rectangle.height - n * 2;
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.BLUE);
        if (rectangle.width > rectangle.height) {
            graphics2D.drawLine(n2, n3, n2 + n4, n3);
            int n6 = n2 + n4;
            for (int i = n2; i < n6; i += this.smalltick) {
                graphics2D.drawLine(i, n3, i, n3 + 5);
                if ((i - n2) % this.bigtick != 0) continue;
                graphics2D.drawLine(i, n3, i, n3 + 10);
            }
        } else {
            graphics2D.drawLine(n2, n3, n2, n3 + n5);
            int n7 = n3 + n5;
            for (int i = n3; i < n7; i += this.smalltick) {
                graphics2D.drawLine(n2, i, n2 + 5, i);
                if ((i - n3) % this.bigtick != 0) continue;
                graphics2D.drawLine(n2, i, n2 + 10, i);
            }
        }
        return super.paintAfter(context, node);
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("frameResized" == string && semanticEvent.getArg() == this.win_) {
            Rectangle rectangle = this.win_.bbox;
            if (rectangle.width >= rectangle.height) {
                rectangle.height = 40;
            } else {
                rectangle.width = 40;
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        map.put("height", Integer.toString(40));
        super.restore(eSISNode, map, layer);
        this.smalltick = Integers.parseInt(this.getAttr(ATTR_SMALLTICK), 10);
        this.bigtick = Integers.parseInt(this.getAttr(ATTR_BIGTICK), 100);
    }
}

