/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CLGeneral;
import multivalent.ContextListener;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.StyleSheet;
import multivalent.gui.VCheckbox;
import multivalent.gui.VFrame;
import multivalent.gui.VTextArea;
import multivalent.node.IParaBox;
import multivalent.node.IVBox;
import multivalent.node.LeafUnicode;
import phelps.awt.Colors;
import phelps.lang.Booleans;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Note
extends Behavior {
    public static final String MSG_SHOW = "showNote";
    public static final String MSG_DELETE = "deleteNote";
    public static final String MSG_SET_PINNED = "windowSetPinned";
    public static final String MSG_BACKGROUND = "editBackgroundColor";
    public static final String ATTR_CLOSED = "closed";
    public static final String ATTR_FLOATING = "floating";
    protected static Color deffg_ = Color.BLACK;
    protected static Color defbg_ = Color.YELLOW.brighter();
    protected static final Random random = new Random(System.currentTimeMillis());
    protected VFrame win_ = null;
    protected Document doc_ = null;
    protected boolean viz_ = true;

    public Node getContent() {
        return this.win_;
    }

    @Override
    public void buildBefore(Document document) {
        super.buildBefore(document);
        this.doc_.getLayers().buildBefore(this.doc_);
    }

    @Override
    public void buildAfter(Document document) {
        super.buildAfter(document);
        this.doc_.getLayers().buildAfter(this.doc_);
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Anno" == string) {
            if (!this.viz_) {
                INode iNode = (INode)semanticEvent.getOut();
                Browser browser = this.getBrowser();
                String string2 = this.win_.getTitle();
                if (string2 == null || string2.length() == 0) {
                    string2 = "(Note)";
                }
                this.createUI("button", string2, new SemanticEvent(browser, MSG_SHOW, null, this, null), iNode, "Note", false);
            }
        } else if ("createWidget/DOCPOPUP" == string && semanticEvent.getIn() == this.win_ && this.isEditable()) {
            Browser browser = this.getBrowser();
            INode iNode = (INode)semanticEvent.getOut();
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Pinned to Document", new SemanticEvent(browser, MSG_SET_PINNED, null, this, null), iNode, "EDIT", false);
            vCheckbox.setState(this.win_.isPinned());
            if (this.getAttr("uri") == null) {
                this.createUI("button", "Transparent", new SemanticEvent(browser, MSG_BACKGROUND, "transparent", this, null), iNode, "EDIT", false);
                StringTokenizer stringTokenizer = new StringTokenizer(this.getPreference("colors", "Yellow Orange Green Blue"));
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.createUI("button", string3, new SemanticEvent(browser, MSG_BACKGROUND, string3, this, null), iNode, "EDIT", false);
                }
            }
            this.createUI("button", "Delete Note", new SemanticEvent(browser, MSG_DELETE, null, this, null), iNode, "EDIT", false);
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if ("frameClosed" == string && this.win_ != null && object == this.win_) {
            this.viz_ = false;
        } else if (semanticEvent.getIn() == this) {
            if (MSG_DELETE == string) {
                this.destroy();
            } else if (MSG_SHOW == string) {
                boolean bl = Booleans.parseBoolean(semanticEvent.getArg(), !this.viz_);
                if (bl != this.viz_ && bl) {
                    Document document = this.getDocument();
                    document.appendChild(this.win_);
                    System.out.println(new StringBuffer().append("adding ").append(this.win_).append(" to ").append(document).toString());
                }
                this.viz_ = bl;
            } else if (MSG_SET_PINNED == string) {
                boolean bl = Booleans.parseBoolean(semanticEvent.getArg(), !this.win_.isPinned());
                this.win_.setPinned(bl);
                if (bl) {
                    this.removeAttr(ATTR_FLOATING);
                } else {
                    this.putAttr(ATTR_FLOATING, ATTR_FLOATING);
                }
            } else if (MSG_BACKGROUND == string) {
                Color color = null;
                String string2 = null;
                if (object != null) {
                    if (object instanceof Color) {
                        color = (Color)object;
                        string2 = Colors.getName(color);
                    } else if (object instanceof String) {
                        string2 = (String)object;
                        color = Colors.getColor(string2);
                    }
                }
                if (string2 != null) {
                    defbg_ = color;
                    this.putAttr("background", string2);
                    StyleSheet styleSheet = this.doc_.getStyleSheet();
                    CLGeneral cLGeneral = (CLGeneral)styleSheet.get("note");
                    cLGeneral.setBackground(color);
                    this.win_.repaint();
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void destroy() {
        this.win_.close();
        this.win_ = null;
        super.destroy();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        Object object;
        String string;
        super.restore(eSISNode, map, layer);
        Document document = this.getDocument();
        this.win_ = new VFrame("Note", null, document);
        this.win_.setPinned(this.getAttr(ATTR_FLOATING) == null);
        this.win_.setBounds(Integers.parseInt(this.getAttr("x"), 100), Integers.parseInt(this.getAttr("y"), 100), Integers.parseInt(this.getAttr("width"), 300), Integers.parseInt(this.getAttr("height"), 200));
        this.doc_ = new Document("Note", null, this.win_);
        String string2 = new StringBuffer().append("NOTE").append(String.valueOf(Math.abs(random.nextInt()))).toString();
        this.putAttr("name", string2);
        this.doc_.padding = INode.INSETS[3];
        this.doc_.setScrollbarShowPolicy((byte)0);
        Layer layer2 = this.doc_.getLayers();
        ESISNode eSISNode2 = null;
        if (eSISNode != null) {
            layer2.restoreChildren(eSISNode, layer2);
            eSISNode2 = layer2.getAux("content");
        }
        Browser browser = this.getBrowser();
        boolean bl = this.viz_ = !Booleans.parseBoolean(this.getAttr(ATTR_CLOSED), false);
        if (!this.viz_) {
            this.win_.remove();
        }
        if ((string = this.getAttr("uri")) != null) {
            this.doc_.editable = false;
            new LeafUnicode(new StringBuffer().append("Loading ").append(string).toString(), null, this.doc_);
            try {
                DocInfo docInfo = new DocInfo(document.getURI().resolve(string));
                docInfo.doc = this.doc_;
                browser.eventq("openDocument", docInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
        IVBox iVBox = new IVBox("body", null, null);
        VTextArea vTextArea = new VTextArea("ed", null, this.doc_, iVBox);
        vTextArea.setScrollbarShowPolicy((byte)1);
        vTextArea.editable = this.isEditable();
        vTextArea.setSizeChars(0, 0);
        if (eSISNode2 != null && eSISNode2.size() > 0 && ((String)eSISNode2.childAt(0)).trim().length() > 0) {
            this.win_.setIn(false);
            object = (String)eSISNode2.childAt(0);
            if (!((String)object).endsWith("\\n")) {
                object = new StringBuffer().append((String)object).append("\\n").toString();
            }
            int n = 0;
            int n2 = ((String)object).indexOf("\\n");
            while (n2 != -1) {
                IParaBox iParaBox = new IParaBox("line", null, null);
                int n3 = n;
                int n4 = ((String)object).indexOf(32, n);
                while (n4 < n2 && n4 != -1) {
                    if (n4 - n3 > 1) {
                        new LeafUnicode(((String)object).substring(n3, n4), null, iParaBox);
                    }
                    n3 = n4 + 1;
                    n4 = ((String)object).indexOf(32, n3);
                }
                if (n2 - n3 >= 1) {
                    new LeafUnicode(((String)object).substring(n3, n2), null, iParaBox);
                }
                if (iParaBox.size() > 0) {
                    iVBox.appendChild(iParaBox);
                }
                n = n2 + 2;
                n2 = ((String)object).indexOf("\\n", n);
            }
        } else {
            eSISNode2 = null;
        }
        if (iVBox.size() == 0) {
            object = new IParaBox("line", null, iVBox);
            new LeafUnicode("", null, (INode)object);
        }
        if (eSISNode2 == null) {
            if (this.win_.isPinned()) {
                this.win_.bbox.translate(document.getHsb().getValue(), document.getVsb().getValue());
            }
            object = iVBox.getFirstLeaf();
            browser.getCursorMark().move((Leaf)object, 0);
            browser.setCurNode((Node)object, 0);
            browser.setScope(this.doc_);
        }
        object = this.doc_.getStyleSheet();
        CLGeneral cLGeneral = new CLGeneral();
        cLGeneral.setForeground(Colors.getColor(this.getAttr("foreground"), deffg_));
        cLGeneral.setBackground(Colors.getColor(this.getAttr("background"), defbg_));
        ((StyleSheet)object).put("note", (ContextListener)cLGeneral);
        cLGeneral = new CLGeneral();
        cLGeneral.setPadding(5);
        ((StyleSheet)object).put("ed", (ContextListener)cLGeneral);
    }

    @Override
    public ESISNode save() {
        int n;
        String string;
        Object object;
        if (this.viz_) {
            this.removeAttr(ATTR_CLOSED);
        } else {
            this.putAttr(ATTR_CLOSED, "true");
        }
        Rectangle rectangle = this.win_.bbox;
        this.putAttr("x", String.valueOf(rectangle.x));
        this.putAttr("y", String.valueOf(rectangle.y));
        this.putAttr("width", String.valueOf(rectangle.width));
        this.putAttr("height", String.valueOf(rectangle.height));
        ESISNode eSISNode = super.save();
        if (this.getAttr("uri") == null) {
            object = new StringBuffer(2000);
            this.doc_.clipboardBeforeAfter((StringBuffer)object);
            string = ((StringBuffer)object).substring(0).trim();
            ((StringBuffer)object).setLength(0);
            n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    ((StringBuffer)object).append("\\n");
                    continue;
                }
                ((StringBuffer)object).append(c);
            }
            ESISNode eSISNode2 = new ESISNode("content");
            eSISNode.appendChild(eSISNode2);
            eSISNode2.appendChild(((StringBuffer)object).toString());
        }
        object = this.doc_.getLayers();
        string = this.getLayer().getName();
        n = ((Layer)object).size();
        for (int i = 0; i < n; ++i) {
            Layer layer = (Layer)((Layer)object).getBehavior(i);
            ESISNode eSISNode3 = null;
            if (string.equals(layer.getName())) {
                eSISNode3 = layer.save();
            }
            if (eSISNode3 == null) continue;
            eSISNode.appendChild(eSISNode3);
        }
        return eSISNode;
    }
}

