/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.awt.NFont;
import com.pt.awt.font.CMap;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.NFontSimple;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import multivalent.Context;
import multivalent.INode;
import multivalent.Node;
import multivalent.StyleSheet;
import multivalent.node.FixedIClip;
import multivalent.node.FixedLeafShape;
import multivalent.node.FixedLeafUnicode;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.GraphicsState;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;

public class NFontType3
extends NFontSimple
implements Cloneable {
    public static final String FORMAT = "Type3";
    private static final FixedLeafUnicode NOGLYPH;
    private static final Rectangle NO_CLIPPING;
    private static final Rectangle EMPTY_SHAPE;
    private static final AffineTransform MATRIX_DEFAULT;
    private Context cx_ = new Context();
    private PDF pdf_;
    private Dict charProcs_;
    private Dict localpage_ = null;
    private Dict page_;
    private AffineTransform glyph2user_ = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
    private Node[] cache_ = new Node[256];
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontType3(Dict dict, PDFReader pDFReader, PDF pDF) throws IOException {
        super(null);
        Object object;
        if (!($assertionsDisabled || dict != null && pDF != null)) {
            throw new AssertionError(dict);
        }
        this.pdf_ = pDF;
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("FontMatrix"));
        if (objectArray != null) {
            object = new double[6];
            PDF.getDoubles(objectArray, (double[])object, 6);
            this.m_ = new AffineTransform((double[])object);
        } else {
            this.m_ = MATRIX_DEFAULT;
        }
        object = COS.array2Rectangle((Object[])pDFReader.getObject(dict.get("FontBBox")), null);
        this.bbox_ = new Rectangle2D.Double(((Rectangle)object).getX(), ((Rectangle)object).getY(), ((Rectangle)object).getHeight(), ((Rectangle)object).getWidth());
        Dict dict2 = (Dict)pDFReader.getObject(dict.get("Resources"));
        if (dict2 != null) {
            this.localpage_ = new Dict(5);
            this.localpage_.put("Resources", dict2);
        }
        this.charProcs_ = (Dict)pDFReader.getObject(dict.get("CharProcs"));
        this.intrinsic_ = null;
        this.touni_ = CMap.IDENTITY;
        this.cx_.styleSheet = new StyleSheet();
    }

    public NFontType3 deriveFont(float f) {
        NFontType3 nFontType3 = null;
        try {
            nFontType3 = (NFontType3)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nFontType3.size_ = f;
        nFontType3.max_ = null;
        nFontType3.cache_ = new Node[256];
        nFontType3.setGlyph2User(this.at_);
        return nFontType3;
    }

    public NFontType3 deriveFont(Encoding encoding, CMap cMap) {
        return (NFontType3)super.deriveFont(encoding, cMap != null ? cMap : CMap.IDENTITY);
    }

    public NFontType3 deriveFont(AffineTransform affineTransform) {
        NFontType3 nFontType3 = (NFontType3)super.deriveFont(affineTransform);
        nFontType3.setGlyph2User(affineTransform);
        return nFontType3;
    }

    private void setGlyph2User(AffineTransform affineTransform) {
        float f = this.getSize();
        this.glyph2user_ = new AffineTransform(this.m_);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX() * (double)f, affineTransform.getShearY(), affineTransform.getShearX(), -affineTransform.getScaleY() * (double)f, 0.0, 0.0);
        this.glyph2user_.concatenate(affineTransform2);
    }

    public void setPage(Dict dict) {
        this.page_ = this.localpage_ != null ? this.localpage_ : dict;
    }

    private Node getGlyph(int n) {
        if (!($assertionsDisabled || this.firstch_ <= n && n <= this.lastch_)) {
            throw new AssertionError((Object)(this.firstch_ + " > " + n + " > " + this.lastch_));
        }
        Node node = this.cache_[n];
        if (node == null) {
            try {
                node = this.cache_[n] = this.createGlyph(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError(n);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createGlyph(int n) throws IOException {
        String string = this.encoding_.getName((char)n);
        Object object = this.charProcs_.get(string);
        PDFReader pDFReader = this.pdf_.getReader();
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(object, true);
        Rectangle rectangle = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        FixedIClip fixedIClip = new FixedIClip(string, null, null, rectangle, rectangle);
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.ctm = new AffineTransform(this.glyph2user_);
        try {
            this.pdf_.buildStream(this.page_, fixedIClip, graphicsState, inputStreamComposite, null);
        }
        catch (Exception exception) {
            new FixedLeafShape("bad_glyph " + n, null, fixedIClip, EMPTY_SHAPE, false, true);
        }
        finally {
            inputStreamComposite.close();
        }
        Node node = fixedIClip;
        if (fixedIClip.size() == 0) {
            return NOGLYPH;
        }
        if (node.isStruct() && node.size() == 1 && node.sizeSticky() == 0) {
            node = ((INode)node).removeChildAt(0);
        }
        Rectangle rectangle2 = node.bbox;
        if (!node.isValid()) {
            this.cx_.reset();
            node.formatNode(0, 0, this.cx_);
        }
        node.baseline = rectangle2.height;
        if (!$assertionsDisabled && !node.isValid()) {
            throw new AssertionError();
        }
        return node;
    }

    public String getName() {
        return "(Type 3)";
    }

    public String getFamily() {
        return "(Type 3)";
    }

    public String getFormat() {
        return FORMAT;
    }

    public int getNumGlyphs() {
        return this.charProcs_.size();
    }

    public boolean canDisplayEchar(int n) {
        return 65534 != n && this.charProcs_.get(this.encoding_.getName(n)) != null;
    }

    public char getSpaceEchar() {
        return '\ufffe';
    }

    public Point2D echarAdvance(int n) {
        double d;
        double d2 = d = n < this.firstch_ || n > this.lastch_ || !this.canDisplayEchar(n) ? 0.0 : (double)this.newwidths_[n - this.firstch_] * this.m_.getScaleX();
        if (d == 0.0 && this.canDisplayEchar(n)) {
            Node node = this.getGlyph(n);
            d = node.bbox.width;
        }
        return new Point2D.Double(d * (double)this.size_ * this.at_.getScaleX(), d * (double)this.size_ * this.at_.getShearY());
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        if (3 == n) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f, f2);
        this.cx_.g = graphics2D;
        double d = 0.0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (!this.canDisplayEchar(c)) continue;
            Node node = this.getGlyph(c);
            double d2 = node.bbox.y;
            graphics2D.translate(d, d2);
            node.paintNode(NO_CLIPPING, this.cx_);
            graphics2D.translate(-d, -d2);
            d += this.echarAdvance(c).getX();
        }
        graphics2D.setTransform(affineTransform);
    }

    public /* synthetic */ NFontSimple deriveFont(Encoding encoding, CMap cMap) {
        return this.deriveFont(encoding, cMap);
    }

    public /* synthetic */ NFont deriveFont(AffineTransform affineTransform) {
        return this.deriveFont(affineTransform);
    }

    public /* synthetic */ NFont deriveFont(float f) {
        return this.deriveFont(f);
    }

    static {
        $assertionsDisabled = !NFontType3.class.desiredAssertionStatus();
        NOGLYPH = new FixedLeafUnicode("", null, null);
        NOGLYPH.getIbbox().setBounds(0, 0, 0, 0);
        NOGLYPH.getBbox().setBounds(0, 0, 0, 0);
        NOGLYPH.setValid(true);
        NO_CLIPPING = new Rectangle(-10000, -10000, 10000, 10000);
        EMPTY_SHAPE = new Rectangle(0, 0, 0, 0);
        MATRIX_DEFAULT = new AffineTransform(0.001, 0.0, 0.0, 0.001, 0.0, 0.0);
    }
}

