/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.awt.NFont;
import com.pt.awt.font.CMap;
import com.pt.doc.PostScript;
import com.pt.io.InputUni;
import com.pt.io.OutputUni;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import multivalent.Meta;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.ColorSpaces;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encrypt;
import multivalent.std.adaptor.pdf.Fonts;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.Normalize;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import phelps.io.Files;
import phelps.io.InputStreams;
import phelps.lang.Bytes;
import phelps.lang.Integers;
import phelps.lang.Strings;
import phelps.net.URIs;
import phelps.util.Arrayss;
import phelps.util.Version;

public class PDFReader
extends COSSource {
    private static final boolean DEBUG = false;
    static final boolean DEBUG_DAMAGED = false;
    private static final char[] OBJECT_COMMENT;
    static final String SIGNATURE_ALT = "%!PS-Adobe-";
    private static final int INT_ACCUM_MAX = 0xCCCCCC3;
    private static final AffineTransform TRANSFORM_IDENTITY;
    private static final IRef IREF0;
    private static final Map<String, String> NAME_CANONICAL;
    static final List<String> PAGE_INHERITABLE;
    private static final char[] ESCAPE;
    private static final boolean[] WHITESPACE;
    private static final boolean[] WSDL;
    static final boolean[] OP;
    static final Map<String, String> INLINE_ABBREV;
    static final Map<String, String> INLINE_EXPAND;
    private static final String[] STREAM_CMDS;
    private Dict trailer_ = null;
    private long startxref_;
    private Dict Catalog_ = null;
    private Dict Info_ = null;
    private Encrypt encrypt_ = null;
    private Version version_;
    private int linid_ = -1;
    private int[] objOff_ = null;
    private short[] objGen_;
    private byte[] objType_;
    Object[] objCache_;
    private int[] pageObjNum_ = null;
    private boolean ffdf_ = false;
    private boolean fexact_ = false;
    private boolean fbulk_ = false;
    private Normalize norm_;
    private boolean fstruct_ = false;
    private RandomAccess ra_;
    private long ralen_;
    private URI uri_;
    private File fileb_ = null;
    private boolean modified_ = false;
    private boolean repaired_ = false;
    private Map<IRef, AffineTransform> imgctm_ = new HashMap<IRef, AffineTransform>(10);
    private Map<Object, SoftReference<ColorSpace>> cscache_ = new HashMap<Object, SoftReference<ColorSpace>>(10);
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFReader(File file) throws IOException, ParseException {
        this(InputUni.getInstance(file.getCanonicalFile(), null, null));
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
    }

    public PDFReader(InputUni inputUni) throws IOException, ParseException {
        if (!$assertionsDisabled && inputUni == null) {
            throw new AssertionError();
        }
        this.uri_ = inputUni.getURI();
        this.ra_ = inputUni.getRandomAccess();
        this.ralen_ = this.ra_.length();
        try {
            this.norm_ = new Normalize(this);
            this.readStructure();
        }
        catch (IOException iOException) {
            this.close();
        }
    }

    public PDFReader(Object[] objectArray, Dict dict) throws IOException {
        if (!($assertionsDisabled || objectArray != null && dict != null)) {
            throw new AssertionError();
        }
        this.uri_ = URI.create("data:///" + objectArray.length);
        this.ra_ = null;
        this.ralen_ = 0L;
        this.objCache_ = objectArray;
        this.trailer_ = dict;
        this.encrypt_ = new Encrypt((Dict)this.getObject(this.trailer_.get("Encrypt")), this);
        this.norm_ = null;
    }

    public void close() throws IOException {
        if (this.ra_ != null) {
            this.ra_.close();
            this.ra_ = null;
            if (this.fileb_ != null) {
                this.fileb_.delete();
            }
        }
    }

    public RandomAccess getRA() {
        return this.ra_;
    }

    public URI getURI() {
        return this.uri_;
    }

    public void setExact(boolean bl) {
        if (this.Catalog_ == null) {
            this.fexact_ = bl;
        }
    }

    public boolean isModified() {
        return this.modified_;
    }

    public boolean isRepaired() {
        return this.repaired_;
    }

    private void readStructure() throws IOException, ParseException {
        Encrypt encrypt;
        Object object;
        int n;
        int n2;
        this.Catalog_ = null;
        this.trailer_ = null;
        this.encrypt_ = null;
        this.reallocObj(1);
        RandomAccess randomAccess = this.getRA();
        int n3 = -1;
        String string = "%PDF-";
        int n4 = 1024;
        for (n2 = 0; n2 < n4; ++n2) {
            randomAccess.seek(n2);
            string = "%PDF-";
            n = 1;
            int n5 = string.length();
            for (int i = 0; i < n5; ++i) {
                int n6 = randomAccess.read();
                if (string.charAt(i) == n6) continue;
                if (i == 1 && n6 == 70) {
                    string = "%FDF-";
                    n4 = string.length();
                    this.ffdf_ = true;
                    continue;
                }
                if (i == 1 && n6 == 33 && randomAccess.read() == 80) {
                    string = SIGNATURE_ALT;
                    i = 2;
                    n5 = string.length();
                    continue;
                }
                n = 0;
                break;
            }
            if (n == 0) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            throw new ParseException("not a PDF: doesn't start with '%PDF-'", 0L);
        }
        if (n3 > 0) {
            randomAccess.slice(n3, randomAccess.length());
            this.ralen_ = randomAccess.length();
        }
        randomAccess.seek(string.length());
        if (SIGNATURE_ALT == string) {
            while (!Character.isWhitespace((char)randomAccess.read())) {
            }
            n4 = "PDF-".length();
            for (n2 = 0; n2 < n4; ++n2) {
                randomAccess.read();
            }
        }
        n2 = this.readInt(randomAccess);
        randomAccess.read();
        n4 = this.readInt(randomAccess);
        this.version_ = new Version(n2 + "." + n4);
        if (!$assertionsDisabled && n2 < 1) {
            throw new AssertionError(n2);
        }
        if ("%FDF-" == string) {
            block24: {
                this.reallocObj(100);
                n = 0;
                this.eatSpace(randomAccess);
                do {
                    long l = randomAccess.getFilePointer();
                    object = this.readObject();
                    if (object == null) break block24;
                    if ("trailer".equals(object)) {
                        this.trailer_ = (Dict)this.readObject();
                        break block24;
                    }
                    if (!$assertionsDisabled && !(object instanceof Number)) {
                        throw new AssertionError();
                    }
                    int n7 = ((Number)object).intValue();
                    if (n7 > n && (n = n7) >= this.getObjCnt()) {
                        this.reallocObj(this.getObjCnt() * 2);
                    }
                    object = this.readObject();
                    if (!$assertionsDisabled && ((Number)object).intValue() != 0) {
                        throw new AssertionError();
                    }
                    object = this.readObject();
                    if (!$assertionsDisabled && !"obj".equals(object)) {
                        throw new AssertionError();
                    }
                    object = this.readObject();
                    if (object == null) break block24;
                    this.objOff_[n7] = (int)l;
                    this.objGen_[n7] = 0;
                    this.objType_[n7] = 1;
                    if (COS.CLASS_DICTIONARY == object.getClass()) {
                        this.getStreamData(new IRef(n7, 0), true, false);
                    }
                    object = this.readObject();
                } while ($assertionsDisabled || "endobj".equals(object));
                throw new AssertionError(object);
            }
            this.reallocObj(n + 1);
        } else {
            block25: {
                randomAccess.seek(0L);
                this.eatSpace(randomAccess);
                Object object2 = this.readObject();
                Object object3 = this.readObject();
                Object object4 = this.readObject();
                object = this.readObject();
                this.linid_ = COS.CLASS_DICTIONARY == object.getClass() && ((Dict)object).get("Linearized") != null && COS.CLASS_INTEGER == object2.getClass() ? this.getObjInt(object2) : 0;
                try {
                    this.readXref();
                }
                catch (ParseException parseException) {
                    if (this.repair(parseException.getMessage())) break block25;
                    throw parseException;
                }
            }
            if (!$assertionsDisabled && this.trailer_ == null) {
                throw new AssertionError();
            }
            this.trailer_.put("Type", "XRef");
            this.normalizeObject(this.trailer_);
        }
        object = this.trailer_.get("Encrypt");
        List<IRef> list = this.connected(object);
        int n8 = list.size();
        for (int i = 0; i < n8; ++i) {
            IRef iRef = list.get(i);
            this.objCache_[iRef.id] = this.getObject(iRef);
        }
        Dict dict = (Dict)this.getObject(object);
        if (!$assertionsDisabled && dict != null && this.trailer_.get("ID") == null) {
            throw new AssertionError();
        }
        this.encrypt_ = encrypt = new Encrypt(dict, this);
        this.readStructure2();
    }

    private void readStructure2() throws IOException {
        if (this.fstruct_ || !this.isAuthorized()) {
            return;
        }
        this.fstruct_ = true;
        Dict dict = (Dict)this.trailer_.get("Compress");
        if (dict != null) {
            Object object;
            if (dict.get("Compact") != null) {
                this.rewriteCompact(dict);
            }
            if ((object = dict.get("Root")) != null) {
                this.trailer_.put("Root", object);
            }
            if (!$assertionsDisabled && this.Catalog_ != null) {
                throw new AssertionError(this.Catalog_);
            }
        }
        this.pageObjNum_ = null;
    }

    private void readXref() throws IOException, ParseException {
        int n;
        RandomAccess randomAccess = this.ra_;
        long l = this.ralen_;
        randomAccess.seek(l);
        boolean bl = false;
        for (n = "%%EOF".length(); n < 2048; ++n) {
            randomAccess.seek(l - (long)n);
            bl = true;
            int n2 = "%%EOF".length();
            for (int i = 0; i < n2; ++i) {
                if (randomAccess.read() == "%%EOF".charAt(i)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            randomAccess.seek(l - (long)n + 1L);
            break;
        }
        if (!bl) {
            throw new ParseException("can't find '%%EOF'", randomAccess.getFilePointer());
        }
        do {
            randomAccess.seek(randomAccess.getFilePointer() - 1L - 1L);
        } while ((n = randomAccess.read()) != 0 && WHITESPACE[n]);
        randomAccess.read();
        long l2 = 0L;
        long l3 = 1L;
        while (true) {
            randomAccess.seek(randomAccess.getFilePointer() - 1L - 1L);
            n = randomAccess.read();
            if (n < 48 || n > 57) break;
            l2 += (long)(n - 48) * l3;
            l3 *= 10L;
        }
        if (l2 <= 0L) {
            throw new ParseException("no 'startxref' value", randomAccess.getFilePointer());
        }
        if (l2 >= randomAccess.getFilePointer()) {
            throw new ParseException("'startxref' in trailer >= file length", l2);
        }
        this.startxref_ = l2;
        randomAccess.seek(l2);
        this.trailer_ = this.readXref(true);
    }

    public Dict readXref(boolean bl) throws IOException, ParseException {
        Dict dict;
        Object object;
        if (!($assertionsDisabled || this.objOff_ != null && this.ra_ != null)) {
            throw new AssertionError();
        }
        RandomAccess randomAccess = this.ra_;
        this.eatSpace(randomAccess);
        Object object2 = object = this.readObject();
        if (COS.CLASS_INTEGER == object2.getClass() && COS.CLASS_INTEGER == this.readObject().getClass() && "obj".equals(this.readObject()) && COS.CLASS_DICTIONARY == (object = this.readObject()).getClass() && "XRef".equals(((Dict)object).get("Type"))) {
            dict = (Dict)object;
            this.checkStream(randomAccess, dict);
            this.readXref15(dict);
            this.objCache_[this.getObjInt((Object)object2)] = COS.OBJECT_NULL;
        } else if ("xref".equals(object)) {
            dict = this.readXref10();
        } else {
            throw new ParseException("expected: 'xref' but saw '" + object + "'", randomAccess.getFilePointer());
        }
        if (bl && (object = dict.get("Prev")) != null) {
            long l = ((Number)object).longValue() & Long.MAX_VALUE;
            if (l < this.ralen_) {
                randomAccess.seek(l);
                this.readXref(bl);
            } else {
                throw new ParseException("bad Prev", l);
            }
        }
        this.objGen_[0] = -1;
        this.objType_[0] = 0;
        this.objCache_[0] = COS.OBJECT_DELETED;
        return dict;
    }

    private void readXref15(Dict dict) throws IOException {
        int n = this.getObjInt(dict.get("Size"));
        Object[] objectArray = (Object[])dict.get("Index");
        if (objectArray == null) {
            objectArray = new Object[]{Integers.ZERO, Integers.getInteger(n)};
        }
        Object[] objectArray2 = (Object[])dict.get("W");
        int n2 = this.getObjInt(objectArray2[0]);
        int n3 = this.getObjInt(objectArray2[1]);
        int n4 = this.getObjInt(objectArray2[2]);
        InputStreamComposite inputStreamComposite = this.getInputStream(dict);
        int n5 = objectArray.length;
        for (int i = 0; i < n5; i += 2) {
            int n6;
            int n7;
            int n8 = this.getObjInt(objectArray[i]);
            int n9 = n8 + (n7 = this.getObjInt(objectArray[i + 1]));
            if (n9 >= (n6 = this.getObjCnt())) {
                this.reallocObj(n9);
            }
            int[] nArray = this.objOff_;
            short[] sArray = this.objGen_;
            byte[] byArray = this.objType_;
            Object[] objectArray3 = this.objCache_;
            int n10 = n8 + n7;
            for (int j = n8; j < n10; ++j) {
                int n11;
                int n12 = n2 > 0 ? (int)((InputStream)inputStreamComposite).read() : 1;
                int n13 = 0;
                for (n11 = 0; n11 < n3; ++n11) {
                    n13 = n13 << 8 | ((InputStream)inputStreamComposite).read();
                }
                n11 = 0;
                for (int k = 0; k < n4; ++k) {
                    n11 = n11 << 8 | ((InputStream)inputStreamComposite).read();
                }
                if (n12 >= 2) {
                    n11 = 0;
                }
                if ((nArray[j] != 0 || sArray[j] != 0) && n11 <= (sArray[i] & 0xFFFF)) continue;
                nArray[j] = n13;
                sArray[j] = (short)n11;
                if (0 <= n12 && n12 <= 2) {
                    byArray[j] = n12;
                    objectArray3[j] = n12 == 0 ? COS.OBJECT_DELETED : null;
                    continue;
                }
                byArray[j] = 1;
                objectArray3[j] = COS.OBJECT_NULL;
            }
        }
        ((InputStream)inputStreamComposite).close();
    }

    private Dict readXref10() throws IOException, ParseException {
        int n;
        RandomAccess randomAccess = this.ra_;
        while ((n = randomAccess.read()) >= 48 && n <= 57) {
            randomAccess.seek(randomAccess.getFilePointer() - 1L);
            int n2 = this.readInt(randomAccess);
            int n3 = this.readInt(randomAccess);
            int n4 = this.getObjCnt();
            int n5 = n2 + n3;
            if (n5 >= n4) {
                this.reallocObj(n5);
            }
            int[] nArray = this.objOff_;
            short[] sArray = this.objGen_;
            byte[] byArray = this.objType_;
            Object[] objectArray = this.objCache_;
            long l = "%PDF-m.n\n".length();
            long l2 = this.ralen_ - (long)"1 0 obj\nendobj\nxref\ntrailer<<>>\nstartxref\n0\n%%EOF".length();
            int n6 = n2 + n3;
            for (int i = n2; i < n6; ++i) {
                n = randomAccess.read();
                long l3 = (long)(n - 48) * 1000000000L + (long)(randomAccess.read() - 48) * 100000000L + (long)(randomAccess.read() - 48) * 10000000L + (long)(randomAccess.read() - 48) * 1000000L + (long)(randomAccess.read() - 48) * 100000L + (long)(randomAccess.read() - 48) * 10000L + (long)(randomAccess.read() - 48) * 1000L + (long)(randomAccess.read() - 48) * 100L + (long)(randomAccess.read() - 48) * 10L + (long)(randomAccess.read() - 48);
                if (n < 48 || n > 57) {
                    this.repair("xref");
                    return this.trailer_;
                }
                randomAccess.read();
                int n7 = (randomAccess.read() - 48) * 10000 + (randomAccess.read() - 48) * 1000 + (randomAccess.read() - 48) * 100 + (randomAccess.read() - 48) * 10 + (randomAccess.read() - 48);
                randomAccess.read();
                boolean bl = randomAccess.read() != 102;
                randomAccess.read();
                n = randomAccess.read();
                if (48 <= n && n <= 57) {
                    randomAccess.seek(randomAccess.getFilePointer() - 1L);
                }
                if ((nArray[i] != 0 || sArray[i] != 0) && n7 <= (sArray[i] & 0xFFFF)) continue;
                nArray[i] = (int)l3;
                sArray[i] = (short)n7;
                if (bl && i > 0) {
                    byArray[i] = 1;
                    objectArray[i] = l <= l3 && l3 < l2 ? null : COS.OBJECT_NULL;
                    continue;
                }
                byArray[i] = 0;
                objectArray[i] = COS.OBJECT_DELETED;
            }
        }
        randomAccess.seek(randomAccess.getFilePointer() - 1L);
        this.eatSpace(randomAccess);
        long l = randomAccess.getFilePointer();
        if (!"trailer".equals(this.readObject())) {
            throw new ParseException("No trailer after xref table", randomAccess.getFilePointer());
        }
        Dict dict = (Dict)this.readObject();
        Object object = dict.get("XRefStm");
        if (object != null) {
            randomAccess.seek(((Number)object).longValue() & Long.MAX_VALUE);
            this.readXref(true);
        }
        return dict;
    }

    private void reallocObj(int n) {
        int n2 = Math.min(this.objOff_ != null ? this.getObjCnt() : 0, n);
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        this.objOff_ = Arrayss.resize(this.objOff_, n);
        this.objGen_ = Arrayss.resize(this.objGen_, n);
        this.objType_ = Arrayss.resize(this.objType_, n);
        this.objCache_ = Arrayss.resize(this.objCache_, n);
    }

    private void rewriteCompact(Dict dict) throws IOException {
        Object object;
        int n;
        Object object2;
        Object object3;
        long l = System.currentTimeMillis();
        long l2 = this.ralen_;
        IRef iRef = (IRef)dict.get("Compact");
        int n2 = dict.get("LengthO") != null ? this.getObjInt(dict.get("LengthO")) : Integer.MAX_VALUE;
        int n3 = this.getObjCnt();
        Dict dict2 = (Dict)this.getObject(iRef);
        int n4 = this.getObjInt(dict2.get("N"));
        boolean bl = n2 < 0x200000;
        PDFWriter pDFWriter = null;
        long[] lArray = null;
        if (!bl) {
            this.fileb_ = File.createTempFile("pdfb", ".pdf");
            pDFWriter = new PDFWriter(OutputUni.getInstance(this.fileb_, null));
            pDFWriter.setObjCnt(this.getObjCnt());
            object3 = this.getTrailer();
            object2 = pDFWriter.getTrailer();
            Object object4 = ((Dict)object3).get("Encrypt");
            if (object4 != null) {
                ((Dict)object2).put("Encrypt", object4);
            }
            List<IRef> list = this.connected(object4);
            int n5 = list.size();
            for (n = 0; n < n5; ++n) {
                object = list.get(n);
                pDFWriter.setObject(((IRef)object).id, this.getObject(object));
            }
            object4 = ((Dict)object3).get("ID");
            if (object4 != null) {
                ((Dict)object2).put("ID", object4);
            }
            pDFWriter.getVersion().setMin(this.getVersion());
            pDFWriter.setObjCnt(n3);
            lArray = new long[n3];
            pDFWriter.writeHeader();
        }
        object3 = this.getInputStream(iRef, false);
        object2 = new Deflater(1, false);
        this.fbulk_ = true;
        for (int i = 0; i < n4; ++i) {
            int n6;
            this.eatSpace((InputStreamComposite)object3);
            n = 0;
            while ((n6 = ((InputStreamComposite)object3).read()) >= 48 && n6 <= 57) {
                n = n * 10 + n6 - 48;
            }
            Object object5 = this.readObject((InputStreamComposite)object3);
            if (((InputStreamComposite)object3).peek() == 115) {
                ((InputStreamComposite)object3).read();
                object = (Dict)object5;
                int n7 = this.getObjInt(((Dict)object).get("Length"));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n7);
                boolean bl2 = ((Dict)object).get("Filter") == null && !"Type1U".equals(((Dict)object).get("Type")) && n7 > 256;
                OutputStream outputStream = bl2 ? new DeflaterOutputStream((OutputStream)byteArrayOutputStream, (Deflater)object2, 8192) : byteArrayOutputStream;
                InputStreams.copy((InputStream)object3, outputStream, false, n7);
                outputStream.close();
                ((Dict)object).put("DATA", byteArrayOutputStream.toByteArray());
                byteArrayOutputStream = null;
                ((Dict)object).remove("Length");
                if (bl2) {
                    ((Dict)object).put("Filter", "FlateDecode");
                    ((Deflater)object2).reset();
                }
            }
            object5 = this.thawCompact(object5);
            if (this.getObjOff(n) != 0L) continue;
            if (bl) {
                this.objCache_[n] = object5;
                continue;
            }
            lArray[n] = pDFWriter.writeObject(object5, n, 0);
        }
        ((Deflater)object2).end();
        ((InputStreamComposite)object3).close();
        this.fbulk_ = false;
        this.objCache_[iRef.id] = COS.OBJECT_NULL;
        if (bl) {
            long l3 = 0L;
        } else {
            for (n = 1; n < n3; ++n) {
                if (this.getObjOff(n) == 0L) continue;
                Object object6 = this.getObject(n);
                this.getStreamData(new IRef(n, this.getObjGen(n)), false, true);
                lArray[n] = pDFWriter.writeObject(object6, n, this.getObjGen(n));
            }
            Dict dict3 = new Dict(this.trailer_);
            pDFWriter.writeXref(dict3, n3, -1L, lArray, 0, n3);
            long l4 = pDFWriter.getOutputStream().getCount();
            pDFWriter.close();
            InputUni inputUni = InputUni.getInstance(this.fileb_, null, null);
            this.ra_ = inputUni.getRandomAccess();
            this.ralen_ = this.ra_.length();
            for (int i = 1; i < n3; ++i) {
                this.objOff_[i] = (int)lArray[i];
            }
            Arrays.fill(this.objType_, 1, n3, (byte)1);
            this.fileb_.deleteOnExit();
        }
        long l5 = System.currentTimeMillis() - l;
    }

    private Object thawCompact(Object object) throws IOException {
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return object;
        }
        Dict dict = (Dict)object;
        Object object2 = this.getObject(dict.get("Type"));
        Object object3 = this.getObject(dict.get("Subtype"));
        if ("Type1U".equals(object2)) {
            this.normalizeObject(object);
        }
        return object;
    }

    private boolean repair(String string) throws IOException {
        int n;
        if (this.isModified()) {
            return false;
        }
        this.modified_ = true;
        RandomAccess randomAccess = this.getRA();
        randomAccess.seek(0L);
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = 2000;
        this.reallocObj(n4);
        this.objOff_[0] = 0;
        this.objGen_[0] = -1;
        this.objCache_[0] = COS.OBJECT_DELETED;
        this.objType_[0] = 0;
        Arrays.fill(this.objOff_, 0);
        Arrays.fill(this.objGen_, (short)0);
        Arrays.fill(this.objType_, (byte)1);
        int n5 = -1;
        int n6 = -1;
        while ((n = randomAccess.read()) != -1) {
            long l;
            if (n != 13 && n != 10) continue;
            while ((n = randomAccess.read()) == 13 || n == 10) {
            }
            long l2 = randomAccess.getFilePointer() - 1L;
            if (n == 116) {
                Dict dict;
                Object object;
                if (randomAccess.read() != 114 || randomAccess.read() != 97 || randomAccess.read() != 105 || randomAccess.read() != 108 || randomAccess.read() != 101 || randomAccess.read() != 114) continue;
                this.eatSpace(randomAccess);
                Object object2 = this.readObject();
                if (COS.CLASS_DICTIONARY != object2.getClass() || (object = (dict = (Dict)object2).get("Size")) == null || COS.CLASS_INTEGER != object.getClass() || ((Number)object).intValue() <= n5) continue;
                this.startxref_ = -1L;
                n5 = this.getObjInt(object);
                this.trailer_ = dict;
                this.trailer_.remove("Prev");
                continue;
            }
            if (n < 48 || n > 57) continue;
            int n7 = n - 48;
            while ((n = randomAccess.read()) >= 48 && n <= 57) {
                n7 = n7 * 10 + n - 48;
            }
            if (n7 == 0 || !Character.isWhitespace((char)n)) continue;
            while (Character.isWhitespace((char)n)) {
                n = randomAccess.read();
            }
            if (n < 48 || n > 57) continue;
            long l3 = randomAccess.getFilePointer();
            int n8 = n - 48;
            while ((n = randomAccess.read()) >= 48 && n <= 57) {
                n8 = n8 * 10 + n - 48;
            }
            if (!Character.isWhitespace((char)n)) continue;
            while (Character.isWhitespace((char)n)) {
                n = randomAccess.read();
            }
            if (n != 111) {
                randomAccess.seek(l3);
                continue;
            }
            if (randomAccess.read() != 98 || randomAccess.read() != 106) continue;
            n = randomAccess.read();
            while (Character.isWhitespace((char)n)) {
                n = randomAccess.read();
            }
            int n9 = n;
            l3 = l = randomAccess.getFilePointer() - 1L;
            randomAccess.seek(l3);
            boolean bl = false;
            while ((n = randomAccess.read()) != -1) {
                if (n != 101 || randomAccess.read() != 110 || randomAccess.read() != 100 || randomAccess.read() != 111 || randomAccess.read() != 98 || randomAccess.read() != 106) continue;
                bl = true;
                l3 = randomAccess.getFilePointer();
                break;
            }
            if (bl && (n7 >= n4 || n8 >= this.getObjGen(n7))) {
                if (n7 >= n4) {
                    this.reallocObj(n4 *= 2);
                }
                this.objOff_[n7] = (int)l2;
                this.objGen_[n7] = (short)n8;
                this.objType_[n7] = 1;
                if (n7 >= n2) {
                    n2 = n7;
                }
                ++n3;
                if (n9 == 60) {
                    randomAccess.seek(l);
                    Object object = this.readObject();
                    Class<?> clazz = object.getClass();
                    if (COS.CLASS_DICTIONARY == clazz && "Catalog".equals(((Dict)object).get("Type"))) {
                        n6 = n7;
                    } else if (COS.CLASS_DICTIONARY == clazz && randomAccess.read() == 115 && randomAccess.read() == 116 && randomAccess.read() == 114 && randomAccess.read() == 101 && randomAccess.read() == 97 && randomAccess.read() == 109) {
                        Dict dict;
                        Object object3;
                        n = randomAccess.read();
                        long l4 = randomAccess.getFilePointer();
                        if (n == 13 && (n = randomAccess.read()) == 10) {
                            ++l4;
                        }
                        if ((object3 = (dict = (Dict)object).get("Length")) == null || dict.get("Filter") == null) {
                            int n10 = n;
                            while ((n = randomAccess.read()) != -1) {
                                if (n == 101 && randomAccess.read() == 110 && randomAccess.read() == 100 && randomAccess.read() == 115 && randomAccess.read() == 116 && randomAccess.read() == 114 && randomAccess.read() == 101 && randomAccess.read() == 97 && randomAccess.read() == 109) {
                                    long l5 = randomAccess.getFilePointer() - (long)"endstream".length() - (long)(n10 == 13 || n10 == 10 ? 1 : 0);
                                    Integer n11 = Integers.getInteger((int)(l5 - l4));
                                    if (!n11.equals(object3)) {
                                        dict.put("Length", n11);
                                        this.objCache_[n7] = dict;
                                        dict.put("DATA", new Long(l4));
                                    }
                                    if (l3 >= l5) break;
                                    l3 = l5;
                                    break;
                                }
                                n10 = n;
                            }
                        }
                    }
                }
            }
            randomAccess.seek(l3);
        }
        if (this.trailer_ == null && n6 >= 1) {
            this.trailer_ = new Dict(5);
            this.trailer_.put("Root", new IRef(n6, 0));
        }
        if (n3 == 0 || this.trailer_ == null) {
            return false;
        }
        n4 = n2 + 1;
        this.reallocObj(n4);
        if (!$assertionsDisabled && this.objOff_[0] != 0) {
            throw new AssertionError(this.objOff_[0]);
        }
        this.trailer_.put("Size", Integers.getInteger(n4));
        for (n = 0; n < n4; ++n) {
            if (this.objOff_[n] != 0 && this.objType_[n] != 0) continue;
            this.objCache_[n] = COS.OBJECT_NULL;
        }
        this.objOff_[0] = 0;
        this.objGen_[0] = -1;
        this.repaired_ = true;
        this.encrypt_ = new Encrypt((Dict)this.getObject(this.trailer_.get("Encrypt")), this);
        this.readStructure2();
        return true;
    }

    public Version getVersion() {
        return this.version_;
    }

    public int getLinearized() {
        return this.linid_;
    }

    public Dict getTrailer() {
        return this.trailer_;
    }

    public long getStartXRef() {
        return this.startxref_;
    }

    public Dict getCatalog() throws IOException {
        block7: {
            if (this.Catalog_ == null) {
                if (!this.isAuthorized()) {
                    throw new IOException("decrypt first!");
                }
                IRef iRef = (IRef)this.getTrailer().get("Root");
                Object object = this.getObject(iRef);
                if (object == null || COS.OBJECT_NULL == object) {
                    throw new IOException("No document catalog.");
                }
                try {
                    this.Catalog_ = (Dict)object;
                    if (!$assertionsDisabled && this.Catalog_ == null) {
                        throw new AssertionError();
                    }
                    if (!this.fexact_ && this.norm_ != null) {
                        this.norm_.normalizeDoc(this.Catalog_);
                    }
                    this.objCache_[iRef.id] = this.Catalog_;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!this.repair("getCatalog()")) break block7;
                    return this.getCatalog();
                }
            }
        }
        return this.Catalog_;
    }

    public Dict getInfo() throws IOException {
        if (this.Info_ == null) {
            Object object = this.getObject(this.getTrailer().get("Info"));
            Dict dict = this.Info_ = COS.OBJECT_NULL == object ? null : (Dict)object;
            if (this.Info_ != null) {
                String[] stringArray;
                String[] stringArray2 = stringArray = this.Info_.keySet().toArray(new String[0]);
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray2[i];
                    Object object2 = this.Info_.get(string);
                    if (COS.CLASS_STRING != object2.getClass() || ((StringBuffer)object2).length() != 0) continue;
                    this.Info_.remove(string);
                }
            }
        }
        return this.Info_;
    }

    public String getMetadata(Object object) throws IOException {
        Dict dict;
        IRef iRef;
        String string = "";
        if ((object = this.getObject(object)) != null && COS.CLASS_DICTIONARY == object.getClass() && (object = this.getObject(iRef = (IRef)(dict = (Dict)object).get("Metadata"))) != null && COS.CLASS_DICTIONARY == object.getClass()) {
            byte[] byArray = this.getStreamData(iRef, false, false);
            string = new String(byArray);
        }
        return string;
    }

    public Encrypt getEncrypt() {
        return this.encrypt_;
    }

    public boolean setPassword(String string) throws IOException {
        SecurityHandler securityHandler = this.getEncrypt().getSecurityHandler();
        boolean bl = securityHandler.isAuthorized();
        if (string != null) {
            boolean bl2 = bl = securityHandler.authOwner(string) || securityHandler.authUser(string);
            if (bl) {
                this.readStructure2();
            }
        }
        return securityHandler.isAuthorized();
    }

    public boolean isAuthorized() {
        Encrypt encrypt = this.getEncrypt();
        if (!$assertionsDisabled && encrypt == null) {
            throw new AssertionError();
        }
        return encrypt.getSecurityHandler().isAuthorized();
    }

    public int getPageCnt() throws IOException {
        if (this.pageObjNum_ != null) {
            return this.pageObjNum_.length;
        }
        Dict dict = this.getCatalog();
        IRef iRef = (IRef)dict.get("Pages");
        Object object = this.getObject(iRef);
        int n = 0;
        if (object != null && COS.CLASS_DICTIONARY == object.getClass()) {
            Dict dict2 = (Dict)object;
            dict2.remove("Parent");
            this.objCache_[iRef.id] = dict2;
            object = this.getObject(dict2.get("Count"));
            if (object instanceof Number) {
                n = this.getObjInt(object);
            }
        }
        this.pageObjNum_ = new int[n];
        Arrays.fill(this.pageObjNum_, -1);
        return n;
    }

    public IRef getPageRef(int n) throws IOException {
        int n2;
        int n3 = this.getPageCnt();
        if (!($assertionsDisabled || 1 <= n && n <= n3)) {
            throw new AssertionError((Object)(n + " > " + n3 + " (1-based)"));
        }
        if ((n2 = this.pageObjNum_[--n]) >= 0) {
            return new IRef(n2, this.getObjGen(n2));
        }
        IRef iRef = null;
        Dict dict = null;
        Object[] objectArray = new Object[]{(IRef)this.getCatalog().get("Pages")};
        Dict dict2 = null;
        int n4 = 0;
        int n5 = 0;
        while (n4 < objectArray.length) {
            String string;
            IRef iRef2 = (IRef)objectArray[n4];
            Object object = this.getObject(iRef2);
            if (COS.CLASS_DICTIONARY == object.getClass()) {
                dict2 = (Dict)object;
                string = (String)dict2.get("Type");
            } else {
                string = null;
            }
            if ("Pages".equals(string)) {
                int n6 = this.getObjInt(dict2.get("Count"));
                if (n >= n5 + n6) {
                    n5 += n6;
                    ++n4;
                    continue;
                }
                objectArray = (Object[])this.getObject(dict2.get("Kids"));
                if (objectArray.length < n6 || this.isModified()) {
                    n4 = 0;
                    continue;
                }
                if (!$assertionsDisabled && objectArray.length != n6) {
                    throw new AssertionError();
                }
                int n7 = objectArray.length;
                for (int i = 0; i < n7; ++i) {
                    IRef iRef3 = (IRef)objectArray[i];
                    object = this.getObject(iRef3);
                    while (COS.CLASS_DICTIONARY == object.getClass() && "Pages".equals(((Dict)object).get("Type"))) {
                        if ((object = ((Dict)object).get("Kids")) != null && COS.CLASS_ARRAY == object.getClass()) {
                            iRef3 = (IRef)((Object[])object)[0];
                            object = this.getObject(iRef3);
                            continue;
                        }
                        object = COS.OBJECT_NULL;
                        iRef3 = IREF0;
                    }
                    this.pageObjNum_[n5 + i] = iRef3.id;
                    objectArray[i] = iRef3;
                }
                iRef = (IRef)objectArray[n - n5];
                dict = (Dict)this.getObject(iRef);
                if (!($assertionsDisabled || iRef != null && iRef.id == this.pageObjNum_[n])) {
                    throw new AssertionError();
                }
                break;
            }
            if ("Page".equals(string)) {
                if (n5 == n) {
                    iRef = iRef2;
                    dict = dict2;
                    this.pageObjNum_[n] = iRef2.id;
                    break;
                }
                ++n5;
                ++n4;
                continue;
            }
            if (!$assertionsDisabled && string != null) {
                throw new AssertionError((Object)string);
            }
            if (COS.CLASS_DICTIONARY == object.getClass()) {
                if (dict2.get("Kids") != null) {
                    dict2.put("Type", "Pages");
                    continue;
                }
                dict2.put("Type", "Page");
                continue;
            }
            if (n5 == n) break;
            ++n4;
        }
        if (dict != null && "Pages".equals(dict.get("Type")) && !this.isModified()) {
            this.modified_ = true;
            Arrays.fill(this.pageObjNum_, -1);
            return this.getPageRef(n + 1);
        }
        return iRef;
    }

    public Dict getPage(int n) throws IOException {
        Object[] objectArray;
        Object object = this.getObject(this.getPageRef(n));
        if (object.getClass() != COS.CLASS_DICTIONARY) {
            return null;
        }
        Dict dict = (Dict)object;
        Object[] objectArray2 = new Object[PAGE_INHERITABLE.size()];
        int n2 = PAGE_INHERITABLE.size();
        block0: for (int i = 0; i < n2; ++i) {
            objectArray = PAGE_INHERITABLE.get(i);
            Dict dict2 = dict;
            while ((dict2 = (Dict)this.getObject(dict2.get("Parent"))) != null) {
                Object object2 = this.getObject(dict2.get((String)objectArray));
                if (object2 == null) continue;
                objectArray2[i] = object2;
                if (dict.get((String)objectArray) != null) continue block0;
                dict.put(objectArray, object2);
                continue block0;
            }
        }
        Object[] objectArray3 = (Object[])this.getObject(dict.get("MediaBox"));
        Object[] objectArray4 = (Object[])this.getObject(dict.get("CropBox"));
        if (objectArray4 == null) {
            objectArray4 = objectArray3;
        } else if (Arrays.equals(objectArray3, objectArray4) && (objectArray2[2] == null || Arrays.equals(objectArray4, (Object[])objectArray2[2]))) {
            dict.remove("CropBox");
        }
        objectArray = (Object[])this.getObject(dict.get("BleedBox"));
        if (Arrays.equals(objectArray4, objectArray)) {
            dict.remove("BleedBox");
        }
        if (Arrays.equals(objectArray4, objectArray = (Object[])this.getObject(dict.get("TrimBox")))) {
            dict.remove("TrimBox");
        }
        if (Arrays.equals(objectArray4, objectArray = (Object[])this.getObject(dict.get("ArtBox")))) {
            dict.remove("ArtBox");
        }
        if ((object = this.getObject(dict.get("Rotate"))) != null && this.getObjInt(object) == 0 && (objectArray2[3] == null || object.equals(objectArray2[3]))) {
            dict.remove("Rotate");
        }
        return dict;
    }

    public int getPageNum(Dict dict) throws IOException {
        if (!$assertionsDisabled && dict == null) {
            throw new AssertionError();
        }
        int n = 0;
        Dict dict2 = (Dict)this.getObject(dict.get("Parent"));
        if (dict2 != null) {
            Object[] objectArray = (Object[])this.getObject(dict2.get("Kids"));
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                Dict dict3 = (Dict)this.getObject(objectArray[i]);
                if (dict == dict3) {
                    n += this.getPageNum(dict2);
                    break;
                }
                if ("Page".equals(this.getObject(dict3.get("Type")))) {
                    ++n;
                    continue;
                }
                n += this.getObjInt(dict3.get("Count"));
            }
        } else {
            ++n;
        }
        return n;
    }

    public long getObjOff(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError((Object)(n + " not in [0.." + this.getObjCnt() + ">"));
        }
        return (long)this.objOff_[n] & Long.MAX_VALUE;
    }

    public int getObjGen(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError((Object)(n + " not in [0.." + this.getObjCnt() + ">"));
        }
        return this.objGen_[n] & 0xFFFF;
    }

    public byte getObjType(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError((Object)(n + " not in [0.." + this.getObjCnt() + ">"));
        }
        return this.objType_[n];
    }

    public int getObjCnt() {
        return this.objCache_.length;
    }

    public InputStreamComposite getInputStream(Object object, boolean bl) throws IOException {
        InputStreamComposite inputStreamComposite;
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        try {
            inputStreamComposite = new InputStreamComposite(object, bl, this);
        }
        catch (EOFException eOFException) {
            if (this.repair(eOFException.toString())) {
                inputStreamComposite = new InputStreamComposite(object, bl, this);
            }
            throw eOFException;
        }
        return inputStreamComposite;
    }

    public InputStreamComposite getInputStream(Object object) throws IOException {
        return this.getInputStream(object, false);
    }

    public byte[] getStreamData(Object object, boolean bl, boolean bl2) throws IOException {
        byte[] byArray;
        int n;
        Object object2 = this.getObject(object);
        if (object2 == null || object2.getClass() != COS.CLASS_DICTIONARY) {
            return null;
        }
        Dict dict = (Dict)object2;
        if ((object2 = dict.get("DATA")) == null) {
            return null;
        }
        String string = Images.getFilter(dict, this);
        Object object3 = this.getObject(dict.get("Filter"));
        boolean bl3 = object3 != null && (COS.CLASS_ARRAY == object3.getClass() || string == null);
        object3 = dict.get("Length");
        int n2 = n = object3 != null ? this.getObjInt(object3) : 0;
        if (COS.CLASS_DATA == object2.getClass()) {
            byArray = (byte[])object2;
            if (!bl && bl3) {
                byArray = InputStreams.toByteArray(this.getInputStream(object, false), byArray.length);
            }
        } else if (object2 instanceof File) {
            byArray = Files.toByteArray((File)object2);
        } else if (n <= 0) {
            byArray = Bytes.ARRAY0;
        } else if (bl) {
            if (!$assertionsDisabled && !(object2 instanceof Long)) {
                throw new AssertionError();
            }
            byArray = new byte[n];
            this.getRA().seek(((Number)object2).longValue());
            this.getRA().readFully(byArray);
        } else {
            byArray = InputStreams.toByteArray(this.getInputStream(object, false), 2 * n);
        }
        if (bl2) {
            dict.put("DATA", byArray);
            dict.remove("Length");
            if (!bl) {
                dict.remove("Filter");
                Object object4 = dict.remove("DecodeParms");
                if (string != null) {
                    dict.put("Filter", string);
                    if (object4 != null) {
                        if (COS.CLASS_ARRAY == object4.getClass()) {
                            object4 = ((Object[])object4)[((Object[])object4).length - 1];
                        }
                        if (object4 != COS.OBJECT_NULL) {
                            dict.put("DecodeParms", object4);
                        }
                    }
                }
            }
        }
        if (!$assertionsDisabled && byArray == null) {
            throw new AssertionError();
        }
        return byArray;
    }

    public void eatSpace(RandomAccess randomAccess) throws IOException {
        int n;
        while ((n = randomAccess.read()) != -1 && WHITESPACE[n]) {
        }
        if (n != -1) {
            randomAccess.seek(randomAccess.getFilePointer() - 1L);
        }
        if (n == 37) {
            this.readObject();
            this.eatSpace(randomAccess);
        }
    }

    public int readInt(RandomAccess randomAccess) throws IOException {
        int n;
        int n2 = 0;
        while ((n = randomAccess.read()) >= 48 && n <= 57) {
            n2 = n2 * 10 + (n - 48);
        }
        randomAccess.seek(randomAccess.getFilePointer() - 1L);
        this.eatSpace(randomAccess);
        return n2;
    }

    public static Double getReal(double d) {
        return PostScript.getReal(d);
    }

    static Double getReal(int n, int n2, int n3) {
        return PostScript.getReal(n, n2, n3);
    }

    public Object readObject() throws IOException {
        return this.readObject(this.ra_, -1, -1);
    }

    private Object readObject(RandomAccess randomAccess, int n, int n2) throws IOException {
        Object object;
        if (!$assertionsDisabled && randomAccess == null) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = null;
        int n3 = randomAccess.read();
        switch (n3) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n4 = 0;
                int n5 = 0;
                int n6 = -100;
                boolean bl = false;
                if (n3 == 43) {
                    bl = false;
                } else if (n3 == 45) {
                    bl = true;
                } else if (n3 == 46) {
                    n6 = 0;
                } else {
                    n4 = n3 - 48;
                }
                while ((n3 = randomAccess.read()) != -1) {
                    if (48 <= n3 && n3 <= 57) {
                        if (n4 >= 0xCCCCCC3) continue;
                        n4 = n4 * 10 + n3 - 48;
                        ++n6;
                        continue;
                    }
                    if (n3 == 46 && n6 < 0) {
                        n6 = 0;
                        n5 = n4;
                        n4 = 0;
                        continue;
                    }
                    if (n3 == 45) continue;
                    randomAccess.seek(randomAccess.getFilePointer() - 1L);
                    break;
                }
                if (bl) {
                    n5 = -n5;
                    n4 = -n4;
                    object = n6 < 0 ? (Number)Integers.getInteger(n4) : (Number)PDFReader.getReal(n5, n4, n6);
                    break;
                }
                if (n6 >= 0) {
                    object = PDFReader.getReal(n5, n4, n6);
                    break;
                }
                this.eatSpace(randomAccess);
                object = null;
                long l = randomAccess.getFilePointer();
                n3 = randomAccess.read();
                if (48 <= n3 && n3 <= 57) {
                    randomAccess.seek(l);
                    int n7 = this.readInt(randomAccess);
                    n3 = randomAccess.read();
                    if (n3 == 82) {
                        object = n4 != 0 ? new IRef(n4, n7) : COS.OBJECT_NULL;
                    }
                }
                if (object != null) break;
                randomAccess.seek(l);
                object = Integers.getInteger(n4);
                break;
            }
            case 40: {
                stringBuffer = new StringBuffer(20);
                int n8 = 1;
                while (n8 > 0 && (n3 = randomAccess.read()) != -1) {
                    if (n3 == 92) {
                        n3 = randomAccess.read();
                        if (n3 >= 48 && n3 <= 55) {
                            int n9 = n3 - 48;
                            n3 = randomAccess.read();
                            if (n3 >= 48 && n3 <= 55) {
                                n9 = n9 * 8 + (n3 - 48);
                                n3 = randomAccess.read();
                                if (n3 >= 48 && n3 <= 55) {
                                    n9 = n9 * 8 + (n3 - 48);
                                } else {
                                    randomAccess.seek(randomAccess.getFilePointer() - 1L);
                                }
                            } else {
                                randomAccess.seek(randomAccess.getFilePointer() - 1L);
                            }
                            stringBuffer.append((char)n9);
                            continue;
                        }
                        if (n3 == 10 || n3 == 13) {
                            if (n3 != 13 || (n3 = randomAccess.read()) == 10) continue;
                            randomAccess.seek(randomAccess.getFilePointer() - 1L);
                            continue;
                        }
                        stringBuffer.append(ESCAPE[n3]);
                        continue;
                    }
                    if (n3 == 10 || n3 == 13) {
                        stringBuffer.append('\n');
                        if (n3 != 13 || (n3 = randomAccess.read()) == 10 || n3 == -1) continue;
                        randomAccess.seek(randomAccess.getFilePointer() - 1L);
                        continue;
                    }
                    if (n3 == 40) {
                        ++n8;
                        stringBuffer.append('(');
                        continue;
                    }
                    if (n3 == 41) {
                        if (--n8 <= 0) continue;
                        stringBuffer.append(')');
                        continue;
                    }
                    stringBuffer.append((char)n3);
                }
                if (this.getEncrypt() != null && n > 0) {
                    this.getEncrypt().getStrF().reset(n, n2).decrypt(stringBuffer);
                }
                object = PDFReader.decodeUTF16(stringBuffer);
                break;
            }
            case 60: {
                n3 = randomAccess.read();
                if (n3 == 60) {
                    this.eatSpace(randomAccess);
                    Dict dict = new Dict(7);
                    while ((n3 = randomAccess.read()) != 62 && n3 != -1) {
                        randomAccess.seek(randomAccess.getFilePointer() - 1L);
                        Object object2 = this.readObject(randomAccess, n, n2);
                        Object object3 = this.readObject(randomAccess, n, n2);
                        if (object2.getClass() != COS.CLASS_NAME) continue;
                        if (object3 != COS.OBJECT_NULL) {
                            dict.put((String)object2, object3);
                            continue;
                        }
                        dict.remove(object2);
                    }
                    n3 = randomAccess.read();
                    if (n3 == -1) {
                        dict.clear();
                    } else if (!$assertionsDisabled && n3 != 62) {
                        throw new AssertionError(dict);
                    }
                    object = dict;
                    break;
                }
                randomAccess.seek(randomAccess.getFilePointer() - 1L);
                this.eatSpace(randomAccess);
                stringBuffer = new StringBuffer(50);
                while ((n3 = randomAccess.read()) != 62) {
                    int n10 = Integers.parseInt(n3);
                    if (n10 == -1) continue;
                    n10 <<= 4;
                    n3 = randomAccess.read();
                    if (n3 == -1 || n3 == 62) {
                        stringBuffer.append((char)n10);
                        break;
                    }
                    int n11 = Integers.parseInt(n3);
                    if (n11 != -1) {
                        stringBuffer.append((char)(n10 | n11));
                        continue;
                    }
                    stringBuffer.append((char)n10);
                }
                if (this.getEncrypt() != null && n > 0) {
                    this.getEncrypt().getStrF().reset(n, n2).decrypt(stringBuffer);
                }
                object = PDFReader.decodeUTF16(stringBuffer);
                break;
            }
            case 47: {
                String string;
                stringBuffer = new StringBuffer(40);
                while ((n3 = randomAccess.read()) != -1) {
                    if (n3 == 35) {
                        stringBuffer.append((char)Integers.parseHex(randomAccess.read(), randomAccess.read()));
                        continue;
                    }
                    if (!WSDL[n3]) {
                        stringBuffer.append((char)n3);
                        continue;
                    }
                    randomAccess.seek(randomAccess.getFilePointer() - 1L);
                    break;
                }
                if ((string = NAME_CANONICAL.get((String)(object = (Object)Strings.valueOf(stringBuffer)))) == null) break;
                object = string;
                break;
            }
            case 91: {
                this.eatSpace(randomAccess);
                ArrayList<Object> arrayList = new ArrayList<Object>(100);
                while ((n3 = randomAccess.read()) != -1 && n3 != 93) {
                    randomAccess.seek(randomAccess.getFilePointer() - 1L);
                    arrayList.add(this.readObject(randomAccess, n, n2));
                }
                object = arrayList.toArray();
                break;
            }
            case 37: {
                while ((n3 = randomAccess.read()) != -1 && n3 != 10 && n3 != 13) {
                }
                object = OBJECT_COMMENT;
                break;
            }
            case -1: 
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                object = null;
                break;
            }
            default: {
                stringBuffer = new StringBuffer(8);
                stringBuffer.append((char)n3);
                while ((n3 = randomAccess.read()) != -1 && !WSDL[n3]) {
                    stringBuffer.append((char)n3);
                }
                randomAccess.seek(randomAccess.getFilePointer() - 1L);
                object = stringBuffer.toString();
                if ("true".equals(object)) {
                    object = Boolean.TRUE;
                    break;
                }
                if ("false".equals(object)) {
                    object = Boolean.FALSE;
                    break;
                }
                if (!"null".equals(object)) break;
                object = COS.OBJECT_NULL;
            }
        }
        this.eatSpace(randomAccess);
        if ($assertionsDisabled || object == null) {
            // empty if block
        }
        return object;
    }

    private static StringBuffer decodeUTF16(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '\u00fe' && stringBuffer.charAt(1) == '\u00ff') {
            stringBuffer2 = new StringBuffer(stringBuffer.length() / 2);
            int n = 0;
            int n2 = stringBuffer.length();
            while (n + 1 < n2) {
                stringBuffer2.append((char)(stringBuffer.charAt(n) << 8 | stringBuffer.charAt(n + 1)));
                n += 2;
            }
        }
        return stringBuffer2;
    }

    public Object getObject(Object object) throws IOException {
        if (object != null && COS.CLASS_IREF == object.getClass()) {
            object = this.getObject(((IRef)object).id);
        }
        if (!$assertionsDisabled && object instanceof IRef) {
            throw new AssertionError(object);
        }
        return object;
    }

    public Object getObject(int n) throws IOException {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getEncrypt() != null && !this.isAuthorized()) {
            throw new AssertionError();
        }
        if (n <= 0 || n >= this.getObjCnt()) {
            return COS.OBJECT_NULL;
        }
        Object object = this.objCache_[n];
        if (object instanceof SoftReference) {
            object = ((SoftReference)object).get();
        }
        if (object != null) {
            return object;
        }
        byte by = this.getObjType(n);
        long l = this.getObjOff(n);
        if (1 == by) {
            if (!$assertionsDisabled && l < 9L) {
                throw new AssertionError();
            }
            RandomAccess randomAccess = this.getRA();
            randomAccess.seek(l);
            this.eatSpace(randomAccess);
            int n2 = this.readInt(randomAccess);
            if (!$assertionsDisabled && n2 != n) {
                throw new AssertionError((Object)("#" + n + " != " + n2 + " @ " + l));
            }
            int n3 = this.readInt(randomAccess);
            if (!$assertionsDisabled && n3 != this.objGen_[n]) {
                throw new AssertionError((Object)("#" + n + ": " + this.objGen_[n] + " != " + n3));
            }
            Object object2 = this.readObject();
            if (n2 == n && n3 == this.getObjGen(n) && "obj".equals(object2)) {
                object = this.readObject(randomAccess, n, n3);
            }
            if (object == null) {
                if (this.repair("getObject " + n + "/" + this.getObjGen(n) + " @ " + l + ", found " + n2 + "/" + n3 + " / " + object2)) {
                    return this.getObject(n);
                }
                object = COS.OBJECT_NULL;
            }
            this.checkStream(randomAccess, object);
            Class<?> clazz = object.getClass();
            if (!$assertionsDisabled && COS.CLASS_IREF == clazz) {
                throw new AssertionError(n);
            }
            this.normalizeObject(object);
            this.objCache_[n] = COS.CLASS_DICTIONARY == clazz || COS.CLASS_ARRAY == clazz || COS.CLASS_STRING == clazz ? new SoftReference<Object>(object) : object;
        } else if (2 == by) {
            int n4 = (int)l;
            Dict dict = (Dict)this.getObject(n4);
            if (!$assertionsDisabled && !"ObjStm".equals(dict.get("Type"))) {
                throw new AssertionError(dict);
            }
            int n5 = this.getObjInt(dict.get("N"));
            int n6 = this.getObjInt(dict.get("First"));
            RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(this.getInputStream(new IRef(n4, this.getObjGen(n4))), "r");
            int[] nArray = new int[n5 * 2];
            int n7 = nArray.length;
            for (int i = 0; i < n7; ++i) {
                nArray[i] = this.readInt(randomAccessByteArray);
            }
            int n8 = 0;
            for (n7 = 0; n7 < n5; ++n7) {
                int n9 = nArray[n7 * 2];
                Object object3 = this.objCache_[n9];
                if (object3 instanceof SoftReference && ((SoftReference)object3).get() == null) {
                    this.objCache_[n9] = null;
                    object3 = null;
                }
                if ((n8 < 1000 || n == n9) && object3 == null) {
                    randomAccessByteArray.seek(n6 + nArray[n7 * 2 + 1]);
                    object3 = this.readObject(randomAccessByteArray, -1, -1);
                    if (n == n9) {
                        object = object3;
                    } else {
                        ++n8;
                    }
                    Class<?> clazz = object3.getClass();
                    this.objCache_[n9] = COS.CLASS_DICTIONARY == clazz || COS.CLASS_ARRAY == clazz || COS.CLASS_STRING == clazz ? new SoftReference<Object>(object3) : object3;
                    continue;
                }
                nArray[n7 * 2] = 0;
            }
            for (n7 = 0; n7 < n5; ++n7) {
                n8 = nArray[n7 * 2];
                if (n8 == 0) continue;
                Object object4 = this.objCache_[n8];
                if (object4 instanceof SoftReference) {
                    object4 = ((SoftReference)object4).get();
                }
                if (object4 == null) continue;
                this.normalizeObject(object4);
            }
            randomAccessByteArray.close();
        } else {
            if (!$assertionsDisabled && 0 != by) {
                throw new AssertionError((Object)("#" + n + " = " + by + ", obj = " + this.objCache_[n]));
            }
            object = COS.OBJECT_NULL;
        }
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError(n);
        }
        return object;
    }

    void setObject(int n, Object object) {
        this.objCache_[n] = object;
    }

    private boolean checkStream(RandomAccess randomAccess, Object object) throws IOException {
        boolean bl = false;
        if (COS.CLASS_DICTIONARY == object.getClass() && ((Dict)object).get("Length") != null) {
            int n;
            bl = true;
            int n2 = "stream".length();
            for (n = 0; n < n2; ++n) {
                if ("stream".charAt(n) == randomAccess.read()) continue;
                bl = false;
                break;
            }
            if (bl) {
                n = randomAccess.read();
                long l = randomAccess.getFilePointer();
                if (n == 13 && (n = randomAccess.read()) == 10) {
                    ++l;
                }
                ((Dict)object).put("DATA", new Long(l));
            }
        }
        return bl;
    }

    private void normalizeObject(Object object) throws IOException {
        if (!this.fexact_ && this.norm_ != null) {
            this.norm_.normalizeObject(object);
        }
    }

    public void fault() throws IOException {
        this.connected(this.getTrailer());
        int n = this.getObjCnt();
        for (int i = 1; i < n; ++i) {
            if (this.objCache_[i] != null) continue;
            this.objCache_[i] = COS.OBJECT_NULL;
        }
    }

    public int countCached() {
        int n = 0;
        int n2 = this.getObjCnt();
        for (int i = 1; i < n2; ++i) {
            if (this.objCache_[i] == null) continue;
            ++n;
        }
        return n;
    }

    public void reset() {
        this.Catalog_ = null;
        this.Info_ = null;
        int n = this.getObjCnt();
        for (int i = 1; i < n; ++i) {
            Object object = this.objCache_[i];
            if (object != null && object instanceof SoftReference) {
                object = ((SoftReference)object).get();
            }
            if (object == null || COS.CLASS_DICTIONARY != object.getClass() && COS.CLASS_ARRAY != object.getClass()) continue;
            this.objCache_[i] = null;
        }
    }

    public Object readObject(InputStreamComposite inputStreamComposite) throws IOException {
        Object object;
        if (!$assertionsDisabled && inputStreamComposite == null) {
            throw new AssertionError();
        }
        int n = inputStreamComposite.read();
        switch (n) {
            case 47: {
                StringBuffer stringBuffer = new StringBuffer(30);
                while ((n = inputStreamComposite.read()) != -1) {
                    if (n == 35) {
                        stringBuffer.append((char)Integers.parseHex(inputStreamComposite.read(), inputStreamComposite.read()));
                        continue;
                    }
                    if (!WSDL[n]) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    inputStreamComposite.unread(n);
                    break;
                }
                object = stringBuffer.toString();
                break;
            }
            case 40: {
                StringBuffer stringBuffer = new StringBuffer(16);
                int n2 = 1;
                while (n2 > 0 && (n = inputStreamComposite.read()) != -1) {
                    if (n == 92) {
                        n = inputStreamComposite.read();
                        if (n >= 48 && n <= 55) {
                            int n3 = n - 48;
                            n = inputStreamComposite.read();
                            if (n >= 48 && n <= 55) {
                                n3 = n3 * 8 + (n - 48);
                                n = inputStreamComposite.read();
                                if (n >= 48 && n <= 55) {
                                    n3 = n3 * 8 + (n - 48);
                                } else {
                                    inputStreamComposite.unread(n);
                                }
                            } else {
                                inputStreamComposite.unread(n);
                            }
                            stringBuffer.append((char)n3);
                            continue;
                        }
                        if (n == 10 || n == 13) {
                            if (n != 13 || (n = inputStreamComposite.read()) == 10) continue;
                            inputStreamComposite.unread(n);
                            continue;
                        }
                        stringBuffer.append(ESCAPE[n]);
                        continue;
                    }
                    if (n == 10 || n == 13) {
                        stringBuffer.append('\n');
                        if (n != 13 || (n = inputStreamComposite.read()) == 10) continue;
                        inputStreamComposite.unread(n);
                        continue;
                    }
                    if (n == 40) {
                        ++n2;
                        stringBuffer.append('(');
                        continue;
                    }
                    if (n == 41) {
                        if (--n2 <= 0) continue;
                        stringBuffer.append(')');
                        continue;
                    }
                    stringBuffer.append((char)n);
                }
                object = stringBuffer;
                if (!this.fbulk_) break;
                object = PDFReader.decodeUTF16(stringBuffer);
                break;
            }
            case 91: {
                this.eatSpace(inputStreamComposite);
                ArrayList<Object> arrayList = new ArrayList<Object>(100);
                while ((n = inputStreamComposite.peek()) != 93 && n != -1) {
                    arrayList.add(this.readObject(inputStreamComposite));
                }
                if (inputStreamComposite.read() != 93) {
                    throw new IOException("array spit across streams");
                }
                object = arrayList.toArray();
                break;
            }
            case 60: {
                n = inputStreamComposite.read();
                if (n == 60) {
                    Dict dict = new Dict(5);
                    this.eatSpace(inputStreamComposite);
                    while ((n = inputStreamComposite.read()) != 62) {
                        if (n == -1) {
                            throw new IOException("dictionary spit across streams");
                        }
                        inputStreamComposite.unread(n);
                        Object object2 = this.readObject(inputStreamComposite);
                        if (inputStreamComposite.peek() == -1) {
                            throw new IOException("dictionary split across streams");
                        }
                        Object object3 = this.readObject(inputStreamComposite);
                        if (object3 != COS.OBJECT_NULL) {
                            dict.put((String)object2, object3);
                            continue;
                        }
                        dict.remove(object2);
                    }
                    n = inputStreamComposite.read();
                    if (!$assertionsDisabled && n != 62) {
                        throw new AssertionError();
                    }
                    object = dict;
                    break;
                }
                inputStreamComposite.unread(n);
                this.eatSpace(inputStreamComposite);
                StringBuffer stringBuffer = new StringBuffer(100);
                while ((n = inputStreamComposite.read()) != 62) {
                    int n4 = Integers.parseInt(n);
                    if (n4 == -1) continue;
                    n4 <<= 4;
                    n = inputStreamComposite.read();
                    if (n == -1 || n == 62) {
                        stringBuffer.append((char)n4);
                        break;
                    }
                    int n5 = Integers.parseInt(n);
                    if (n5 != -1) {
                        stringBuffer.append((char)(n4 | n5));
                        continue;
                    }
                    stringBuffer.append((char)n4);
                }
                object = stringBuffer;
                if (!this.fbulk_) break;
                object = PDFReader.decodeUTF16(stringBuffer);
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n6 = 0;
                int n7 = 0;
                int n8 = -100;
                boolean bl = false;
                if (n == 43) {
                    bl = false;
                } else if (n == 45) {
                    bl = true;
                } else if (n == 46) {
                    n8 = 0;
                } else {
                    n6 = n - 48;
                }
                while ((n = inputStreamComposite.read()) != -1) {
                    if (48 <= n && n <= 57) {
                        if (n6 >= 0xCCCCCC3) continue;
                        n6 = n6 * 10 + n - 48;
                        ++n8;
                        continue;
                    }
                    if (n == 46 && n8 < 0) {
                        n8 = 0;
                        n7 = n6;
                        n6 = 0;
                        continue;
                    }
                    if (n == 45) continue;
                    if (n != -1) break;
                    throw new IOException("number split across streams");
                }
                if (n == 82 && this.fbulk_) {
                    object = new IRef(n6, 0);
                    break;
                }
                inputStreamComposite.unread(n);
                if (bl) {
                    n6 = -n6;
                    n7 = -n7;
                }
                if (n8 < 0) {
                    object = Integers.getInteger(n6);
                    break;
                }
                object = PDFReader.getReal(n7, n6, n8);
                break;
            }
            case 37: {
                while ((n = inputStreamComposite.read()) != -1 && n != 10 && n != 13) {
                }
                object = OBJECT_COMMENT;
                break;
            }
            case -1: 
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(n);
                }
                object = null;
                break;
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer(20);
                stringBuffer.append((char)n);
                while ((n = inputStreamComposite.read()) != -1 && !WSDL[n]) {
                    stringBuffer.append((char)n);
                }
                inputStreamComposite.unread(n);
                object = stringBuffer.toString();
                if ("true".equals(object)) {
                    object = Boolean.TRUE;
                    break;
                }
                if ("false".equals(object)) {
                    object = Boolean.FALSE;
                    break;
                }
                if (!"null".equals(object)) break;
                object = COS.OBJECT_NULL;
            }
        }
        this.eatSpace(inputStreamComposite);
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        return object;
    }

    public void eatSpace(InputStreamComposite inputStreamComposite) throws IOException {
        int n;
        if (!$assertionsDisabled && inputStreamComposite == null) {
            throw new AssertionError();
        }
        while ((n = inputStreamComposite.read()) != -1 && WHITESPACE[n]) {
        }
        inputStreamComposite.unread(n);
        if (n == 37) {
            this.readObject(inputStreamComposite);
            this.eatSpace(inputStreamComposite);
        }
    }

    public Cmd[] readCommandArray(Object object) throws IOException {
        Cmd cmd;
        ArrayList<Cmd> arrayList = new ArrayList<Cmd>(1000);
        InputStreamComposite inputStreamComposite = this.getInputStream(object, true);
        while ((cmd = this.readCommand(inputStreamComposite)) != null) {
            arrayList.add(cmd);
        }
        inputStreamComposite.close();
        return arrayList.toArray(new Cmd[arrayList.size()]);
    }

    public Cmd readCommand(InputStreamComposite inputStreamComposite) throws IOException {
        int n;
        Object[] objectArray = new Object[6];
        int n2 = 0;
        String string = null;
        this.eatSpace(inputStreamComposite);
        while ((n = inputStreamComposite.peek()) != -1) {
            int n3;
            int n4;
            if (OP[n]) {
                if (n2 == 6) {
                    throw new IOException("array split across streams");
                }
                objectArray[n2++] = this.readObject(inputStreamComposite);
                continue;
            }
            char[] cArray = new char[3];
            int n5 = 4;
            for (int i = 0; i < n5; ++i) {
                n4 = inputStreamComposite.read();
                if (n4 == -1 || WSDL[n4]) {
                    if (i == 0) {
                        throw new IOException("null command");
                    }
                    string = new String(cArray, 0, i);
                    inputStreamComposite.unread(n4);
                    n3 = Arrays.binarySearch(STREAM_CMDS, string);
                    if (n3 < 0) break;
                    string = STREAM_CMDS[n3];
                    break;
                }
                cArray[i] = (char)n4;
            }
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            if ("%".equals(string)) {
                StringBuffer stringBuffer = new StringBuffer(80);
                while ((n = inputStreamComposite.read()) != -1 && n != 13 && n != 10) {
                    stringBuffer.append((char)n);
                }
                objectArray[0] = stringBuffer.substring(0);
                n2 = 1;
            } else if ("BI".equals(string)) {
                Object object;
                Object object2;
                this.eatSpace(inputStreamComposite);
                Dict dict = this.readInlineImage(inputStreamComposite);
                if (!$assertionsDisabled && dict.get("F") != null) {
                    throw new AssertionError(dict);
                }
                String string2 = Images.getFilter(dict, null);
                Object object3 = dict.get("Filter");
                Object object4 = object3 == null ? null : (COS.CLASS_ARRAY == object3.getClass() ? ((Object[])object3)[0] : (object2 = !object3.equals(string2) ? object3 : null));
                if ("LZW".equals(object2) || "LZWDecode".equals(object2)) {
                    dict.put("DATA", this.getStreamData(dict, false, false));
                    object = dict.remove("DecodeParms");
                    if (string2 != null) {
                        dict.put("Filter", string2);
                        if (object instanceof Object[]) {
                            Object[] objectArray2 = object;
                            dict.put("DecodeParms", objectArray2[objectArray2.length - 1]);
                        }
                    } else {
                        dict.remove("Filter");
                        dict.remove("DecodeParms");
                    }
                }
                object = (byte[])dict.remove("DATA");
                objectArray[0] = dict;
                objectArray[1] = object;
                n2 = 2;
            } else if ("TJ".equals(string) && n2 >= 1) {
                Object[] objectArray3 = (Object[])objectArray[0];
                n4 = 0;
                n3 = objectArray3.length;
                for (n5 = 0; n5 < n3; ++n5) {
                    Object object = objectArray3[n5];
                    Class<?> clazz = object.getClass();
                    if (COS.CLASS_STRING == clazz) {
                        objectArray3[n4++] = object;
                        continue;
                    }
                    if (COS.CLASS_INTEGER == clazz && ((Number)object).intValue() != 0) {
                        objectArray3[n4++] = object;
                        continue;
                    }
                    if (COS.CLASS_REAL != clazz || ((Number)object).doubleValue() == 0.0) continue;
                    objectArray3[n4++] = object;
                }
                if (n4 < n5) {
                    objectArray[0] = Arrayss.resize(objectArray3, n4);
                }
            }
            this.eatSpace(inputStreamComposite);
            break;
        }
        return string != null || n2 > 0 ? new Cmd(string, objectArray, n2) : null;
    }

    public Dict readInlineImage(InputStreamComposite inputStreamComposite) throws IOException {
        Object object;
        int n;
        Dict dict = new Dict(7);
        while ((n = inputStreamComposite.peek()) == 47) {
            object = this.readObject(inputStreamComposite);
            Object object2 = this.readObject(inputStreamComposite);
            String string = INLINE_EXPAND.get((String)object);
            if (string != null) {
                object = string;
            }
            if (object2 == COS.OBJECT_NULL) continue;
            dict.put(object, object2);
        }
        n = inputStreamComposite.read();
        if (!$assertionsDisabled && n != 73) {
            throw new AssertionError();
        }
        n = inputStreamComposite.read();
        if (!$assertionsDisabled && n != 68) {
            throw new AssertionError();
        }
        n = inputStreamComposite.read();
        if (!$assertionsDisabled && !Character.isWhitespace((char)n)) {
            throw new AssertionError();
        }
        if (n == 13 && inputStreamComposite.peek() == 10) {
            inputStreamComposite.read();
        }
        object = new ByteArrayOutputStream(4096);
        int n2 = -1;
        while (n != -1) {
            n = inputStreamComposite.read();
            if (n == 69 && inputStreamComposite.peek() == 73) {
                n = inputStreamComposite.read();
                if (n2 == 13 || n2 == 10 || inputStreamComposite.peek() == 32) break;
                ((ByteArrayOutputStream)object).write(69);
                ((ByteArrayOutputStream)object).write(73);
            } else {
                ((ByteArrayOutputStream)object).write(n);
            }
            n2 = n;
        }
        dict.put("DATA", ((ByteArrayOutputStream)object).toByteArray());
        this.eatSpace(inputStreamComposite);
        return dict;
    }

    public URI getFileSpecification(Object object) throws IOException {
        Serializable serializable;
        String string;
        if ((object = this.getObject(object)) == null || object == COS.OBJECT_NULL) {
            return null;
        }
        String string2 = null;
        if (COS.CLASS_STRING == object.getClass()) {
            string = object.toString();
        } else {
            if (!$assertionsDisabled && COS.CLASS_DICTIONARY != object.getClass()) {
                throw new AssertionError();
            }
            serializable = (Dict)object;
            String string3 = File.separatorChar == '/' ? "Unix" : (File.separatorChar == '\\' ? "DOS" : "Mac");
            Object object2 = ((Dict)serializable).get(string3);
            boolean bl = object2 != null || (object2 = ((Dict)serializable).get("F")) != null || (object2 = ((Dict)serializable).get("Unix")) != null || (object2 = ((Dict)serializable).get("Mac")) != null || (object2 = ((Dict)serializable).get("DOS")) != null;
            string = (String)this.getObject(object2);
            string2 = (String)this.getObject(((Dict)serializable).get("FS"));
        }
        if ("URL".equals(string2)) {
            try {
                serializable = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                serializable = null;
            }
        } else {
            serializable = this.getURI().resolve(string);
        }
        return serializable;
    }

    public InputStream getFileInputStream(Object object) throws IOException {
        InputStream inputStream;
        object = this.getObject(object);
        URI uRI = this.getFileSpecification(object);
        File file = new File(uRI.getPath());
        if (COS.CLASS_STRING == object.getClass() || "file".equals(uRI.getScheme()) && file.exists()) {
            inputStream = new FileInputStream(file);
        } else {
            if (!$assertionsDisabled && COS.CLASS_DICTIONARY != object.getClass()) {
                throw new AssertionError();
            }
            Dict dict = (Dict)object;
            String string = File.separatorChar == '/' ? "Unix" : (File.separatorChar == '\\' ? "DOS" : "Mac");
            Object[] objectArray = (Object[])this.getObject(dict.get("ID"));
            boolean bl = Boolean.TRUE == this.getObject(dict.get("V"));
            Dict dict2 = (Dict)this.getObject(dict.get("EF"));
            Dict dict3 = (Dict)this.getObject(dict.get("RF"));
            if (dict2 != null) {
                Meta.sampledata("embedded external");
                Dict dict4 = (Dict)this.getObject(this.getCatalog().get("Names"));
                Dict dict5 = (Dict)this.getObject(dict4.get("EmbeddedFiles"));
                Object object2 = dict2.get(string);
                boolean bl2 = object2 != null || (object2 = dict2.get("F")) != null || (object2 = dict2.get("Unix")) != null || (object2 = dict2.get("Mac")) != null || (object2 = dict2.get("DOS")) != null;
                StringBuffer stringBuffer = (StringBuffer)this.getObject(object2);
                Dict dict6 = (Dict)this.findNameTree(dict5, stringBuffer);
                String string2 = (String)this.getObject(dict6.get("Subtype"));
                Dict dict7 = (Dict)this.getObject(dict6.get("Params"));
                Dict dict8 = (Dict)(dict7 != null ? this.getObject(dict7.get("Mac")) : null);
                if (dict3 == null && dict8 == null) {
                    inputStream = this.getInputStream(dict6);
                } else {
                    int n = dict7 != null && (object2 = this.getObject(dict7.get("Size"))) instanceof Number ? ((Number)object2).intValue() : -1;
                    long l = -1L;
                    long l2 = -1L;
                    try {
                        if (dict7 != null && (object2 = this.getObject(dict7.get("CreationDate"))) instanceof StringBuffer) {
                            l = COS.parseDate((StringBuffer)object2);
                        }
                        if (dict7 != null && (object2 = this.getObject(dict7.get("ModDate"))) instanceof StringBuffer) {
                            l2 = COS.parseDate((StringBuffer)object2);
                        }
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                    InputStreamComposite inputStreamComposite = this.getInputStream(dict6);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ((OutputStream)fileOutputStream).close();
                    ((InputStream)inputStreamComposite).close();
                    inputStream = new FileInputStream(file);
                }
            } else if ("file".equals(uRI.getScheme())) {
                inputStream = new FileInputStream(file);
            } else {
                if (!bl) {
                    // empty if block
                }
                inputStream = URIs.toURL(uRI).openStream();
            }
        }
        return inputStream;
    }

    public ColorSpace getColorSpace(Object object, Dict dict, Dict dict2) throws IOException {
        ColorSpace colorSpace;
        if (dict != null && dict.get(object) != null) {
            object = dict.get(object);
        } else if (dict2 != null && dict2.get(object) != null) {
            object = dict2.get(object);
        }
        SoftReference<ColorSpace> softReference = this.cscache_.get(object);
        ColorSpace colorSpace2 = colorSpace = softReference != null ? softReference.get() : null;
        if (colorSpace == null) {
            colorSpace = ColorSpaces.createColorSpace(this.getObject(object), this);
            this.cscache_.put(object, new SoftReference<ColorSpace>(colorSpace));
        }
        return colorSpace;
    }

    public BufferedImage getImage(IRef iRef, AffineTransform affineTransform, Color color) throws IOException {
        if (!($assertionsDisabled || iRef != null && affineTransform != null)) {
            throw new AssertionError();
        }
        Dict dict = (Dict)this.getObject(iRef);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
        BufferedImage bufferedImage = (BufferedImage)dict.get("REALIZED");
        if (bufferedImage == null || !affineTransform2.equals(this.imgctm_.get(iRef))) {
            InputStreamComposite inputStreamComposite = this.getInputStream(iRef);
            bufferedImage = Images.createImage(dict, inputStreamComposite, affineTransform, color, this);
            ((InputStream)inputStreamComposite).close();
            dict.put("REALIZED", bufferedImage);
            this.imgctm_.put(iRef, affineTransform2);
        }
        return bufferedImage;
    }

    public NFont getFont(Dict dict, float f, AffineTransform affineTransform, PDF pDF) throws IOException {
        NFont nFont;
        NFont nFont2 = nFont = (NFont)dict.get("REALIZED");
        if (nFont == null) {
            nFont = Fonts.createFont(dict, this, pDF);
        }
        double d = affineTransform.getScaleX();
        double d2 = -affineTransform.getScaleY();
        if (f < 0.0f) {
            f = -f;
            d2 = -d2;
        }
        if (d == d2 && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
            float f2 = (float)((double)f * d);
            if (Math.abs(f2 - nFont.getSize()) > 1.0E-5f) {
                nFont = nFont.deriveFont(f2);
            }
            if (nFont.isTransformed()) {
                nFont = nFont.deriveFont(TRANSFORM_IDENTITY);
            }
        } else {
            if (Math.abs(f - nFont.getSize()) > 1.0E-5f) {
                nFont = nFont.deriveFont(f);
            }
            double d3 = affineTransform.getShearX();
            double d4 = -affineTransform.getShearY();
            AffineTransform affineTransform2 = nFont.getTransform();
            if (d != affineTransform2.getScaleX() || d2 != affineTransform2.getScaleY() || d3 != affineTransform2.getShearX() || d4 != affineTransform2.getShearY()) {
                AffineTransform affineTransform3 = new AffineTransform(d, d4, d3, d2, 0.0, 0.0);
                nFont = nFont.deriveFont(affineTransform3);
            }
        }
        if (nFont != nFont2) {
            dict.put("REALIZED", nFont);
        }
        return nFont;
    }

    public CMap getCMap(Object object) throws IOException {
        CMap cMap = null;
        Object object2 = this.getObject(object);
        if (object2 != null) {
            if (COS.CLASS_NAME == object.getClass()) {
                cMap = CMap.getInstance((String)object);
            } else {
                if (!$assertionsDisabled && COS.CLASS_DICTIONARY != object2.getClass()) {
                    throw new AssertionError((Object)(object2.getClass().getName() + " " + object));
                }
                Dict dict = (Dict)object2;
                if ((object2 = dict.get("REALIZED")) != null) {
                    cMap = (CMap)object2;
                } else {
                    CMap cMap2 = this.getCMap(dict.get("UseCMap"));
                    cMap = new CMap(cMap2, this.getInputStream(object, false));
                    dict.put("REALIZED", cMap);
                }
            }
        }
        return cMap;
    }

    public Object findNameTree(Dict dict, StringBuffer stringBuffer) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        if (dict == null || stringBuffer == null) {
            return null;
        }
        String string = stringBuffer.toString();
        Dict dict2 = dict;
        block0: while (dict2 != null && (objectArray = (Object[])this.getObject(dict2.get("Kids"))) != null) {
            dict2 = null;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Dict dict3;
                Object[] objectArray2;
                Object object = this.getObject(objectArray[n]);
                if (COS.OBJECT_NULL == object || (objectArray2 = (Object[])this.getObject((dict3 = (Dict)object).get("Limits")))[0].toString().compareTo(string) > 0 || string.compareTo(objectArray2[1].toString()) > 0) continue;
                dict2 = dict3;
                continue block0;
            }
        }
        if (dict2 != null) {
            objectArray = (Object[])this.getObject(dict2.get("Names"));
            n2 = objectArray.length;
            for (n = 0; n < n2; n += 2) {
                if (!string.equals(objectArray[n].toString())) continue;
                return objectArray[n + 1];
            }
        }
        return null;
    }

    public Object findNumberTree(Dict dict, int n) throws IOException {
        int n2;
        int n3;
        Object[] objectArray;
        if (dict == null) {
            return null;
        }
        Dict dict2 = dict;
        block0: while (dict2 != null && (objectArray = (Object[])this.getObject(dict2.get("Kids"))) != null) {
            dict2 = null;
            n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Dict dict3 = (Dict)this.getObject(objectArray[n2]);
                Object[] objectArray2 = (Object[])this.getObject(dict3.get("Limits"));
                if (this.getObjInt(objectArray2[0]) > n || n > this.getObjInt(objectArray2[1])) continue;
                dict2 = dict3;
                continue block0;
            }
        }
        if (dict2 != null) {
            objectArray = (Object[])this.getObject(dict2.get("Nums"));
            n3 = objectArray.length;
            for (n2 = 0; n2 < n3; n2 += 2) {
                if (n != this.getObjInt(objectArray[n2])) continue;
                return objectArray[n2 + 1];
            }
        }
        return null;
    }

    static {
        int n;
        Object object;
        $assertionsDisabled = !PDFReader.class.desiredAssertionStatus();
        OBJECT_COMMENT = new char[0];
        TRANSFORM_IDENTITY = new AffineTransform();
        IREF0 = new IRef(0, 0);
        NAME_CANONICAL = new HashMap<String, String>(101);
        Object object2 = new String[]{"Type", "Subtype", "Name", "XRef", "ObjStm", "First", "N", "Page", "Parent", "Contents", "Kids", "Count", "Rotate", "MediaBox", "CropBox", "BleedBox", "TrimBox", "ArtBox", "Length", "Filter", "FlateDecode", "DecodeParms", "LZWDecode", "DCTDecode", "JPXDecode", "CCITTFaxDecode", "PredictorDecode", "ASCII85Decode", "ASCIIHexDecode", "RunLengthDecode", "Resources", "XObject", "ExtGState", "Properties", "Group", "ProcSet", "Text", "ImageC", "PDF", "Im0", "Im1", "Fm0", "Fm1", "Font", "Type1", "Type1C", "TrueType", "CIDFontType0C", "XHeight", "StemH", "AveWidth", "MaxWidth", "Leading", "MissingWidth", "Form", "FormType", "Matrix", "BBox", "ColorSpace", "DeviceRGB", "DeviceCMYK", "Decode", "Width", "Height", "BitsPerComponent", "Columns", "Rows", "Metadata", "XML", "CryptFilter", "CF"};
        String[] stringArray = object2;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            object = stringArray[i];
            NAME_CANONICAL.put((String)object, (String)object);
        }
        PAGE_INHERITABLE = Collections.unmodifiableList(Arrays.asList("Resources", "MediaBox", "CropBox", "Rotate"));
        ESCAPE = PostScript.ESCAPE;
        WHITESPACE = PostScript.WHITESPACE;
        WSDL = PostScript.WSDL;
        OP = new boolean[256];
        object2 = "<[(/0123456789-+.";
        n2 = ((String)object2).length();
        for (n = 0; n < n2; ++n) {
            PDFReader.OP[((String)object2).charAt((int)n)] = true;
        }
        object2 = new String[]{"BitsPerComponent", "BPC", "ColorSpace", "CS", "Decode", "D", "DecodeParms", "DP", "Filter", "F", "Height", "H", "ImageMask", "IM", "Interpolate", "I", "Width", "W"};
        INLINE_ABBREV = new HashMap<String, String>(((Object)object2).length);
        INLINE_EXPAND = new HashMap<String, String>(((Object)object2).length);
        n2 = ((Object)object2).length;
        for (n = 0; n < n2; n += 2) {
            Object object3 = object2[n];
            object = object2[n + 1];
            INLINE_EXPAND.put((String)object, (String)object3);
            INLINE_ABBREV.put((String)object3, (String)object);
        }
        STREAM_CMDS = new String[]{"w", "J", "j", "M", "d", "ri", "i", "gs", "q", "Q", "cm", "m", "l", "c", "v", "y", "h", "re", "S", "s", "f", "F", "f*", "B", "B*", "b", "b*", "n", "W", "W*", "BT", "ET", "Tc", "Tw", "Tz", "TL", "Tf", "Tr", "Ts", "Td", "TD", "Tm", "T*", "Tj", "TJ", "'", "\"", "d0", "d1", "CS", "cs", "SC", "SCN", "sc", "scn", "G", "g", "RG", "rg", "K", "k", "sh", "BI", "ID", "EI", "Do", "MP", "DP", "BMC", "BDC", "EMC", "BX", "EX", "%"};
        Arrays.sort(STREAM_CMDS);
    }
}

