/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.awt.Graphics2D;
import java.util.Map;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.Span;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SidebarSpan
extends Span {
    Node observing = null;
    int x;
    int y1;
    int y2;

    @Override
    public boolean paintAfter(Context context, Node node) {
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(this.getLayer().getAnnoColor());
        graphics2D.drawLine(this.x, this.y1, this.x, this.y2);
        return false;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        return false;
    }

    void attach() {
        Node node;
        Leaf leaf = this.getStart().leaf;
        Leaf leaf2 = this.getEnd().leaf;
        this.observing = leaf.commonAncestor(leaf2);
        if (this.observing == leaf) {
            this.observing = this.observing.getParentNode();
        }
        this.observing.addObserver(this);
        this.x = this.observing.bbox.x - 10;
        this.y1 = 0;
        this.y2 = leaf2.bbox.height;
        for (node = leaf; node != this.observing; node = node.getParentNode()) {
            this.y1 += node.bbox.y;
        }
        for (node = leaf2; node != this.observing; node = node.getParentNode()) {
            this.y2 += node.bbox.y;
        }
    }

    @Override
    public void move(Leaf leaf, int n, Leaf leaf2, int n2) {
        if (this.observing != null) {
            this.observing.deleteObserver(this);
        }
        super.move(leaf, n, leaf2, n2);
        this.attach();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.attach();
    }

    @Override
    public void destroy() {
        if (this.observing != null) {
            this.observing.deleteObserver(this);
        }
        super.destroy();
    }
}

